/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.transform;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.transform.PremultiplyKt;
import com.github.ajalt.colormath.transform.TransformKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u001c\u0010\u0006\u001a\u00020\u00012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0019\u0010\u0007\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t*\u0002H\b\u00a2\u0006\u0002\u0010\n\u001a\u0019\u0010\u000b\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t*\u0002H\b\u00a2\u0006\u0002\u0010\n\u00a8\u0006\f"}, d2={"divideAlphaInPlace", "", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "components", "", "multiplyAlphaInPlace", "divideAlpha", "T", "Lcom/github/ajalt/colormath/Color;", "(Lcom/github/ajalt/colormath/Color;)Lcom/github/ajalt/colormath/Color;", "multiplyAlpha", "colormath"})
public final class PremultiplyKt {
    @NotNull
    public static final <T extends Color> T multiplyAlpha(@NotNull T $this$multiplyAlpha) {
        Intrinsics.checkNotNullParameter($this$multiplyAlpha, "<this>");
        return TransformKt.map($this$multiplyAlpha, multiplyAlpha.1.INSTANCE);
    }

    public static final void multiplyAlphaInPlace(@NotNull ColorSpace<?> space, @NotNull float[] components) {
        Intrinsics.checkNotNullParameter(space, "space");
        Intrinsics.checkNotNullParameter(components, "components");
        float a = ArraysKt.last(components);
        if (Float.isNaN(a) || a == 1.0f) {
            return;
        }
        int n = ArraysKt.getLastIndex(components);
        for (int i = 0; i < n; ++i) {
            if (space.getComponents().get(i).isPolar()) continue;
            components[i] = components[i] * a;
        }
    }

    @NotNull
    public static final <T extends Color> T divideAlpha(@NotNull T $this$divideAlpha) {
        Intrinsics.checkNotNullParameter($this$divideAlpha, "<this>");
        return TransformKt.map($this$divideAlpha, divideAlpha.1.INSTANCE);
    }

    public static final void divideAlphaInPlace(@NotNull ColorSpace<?> space, @NotNull float[] components) {
        Intrinsics.checkNotNullParameter(space, "space");
        Intrinsics.checkNotNullParameter(components, "components");
        float a = ArraysKt.last(components);
        if (Float.isNaN(a) || a == 0.0f || a == 1.0f) {
            return;
        }
        int n = ArraysKt.getLastIndex(components);
        for (int i = 0; i < n; ++i) {
            if (space.getComponents().get(i).isPolar()) continue;
            components[i] = components[i] / a;
        }
    }
}

