%%
%% This is file `tuzuk.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% tuzuk.dtx  (with options: `package')
%% 
%% This is a generated file.
%% 
%% Copyright (C) 2021-2024 by Özcan Oğuz
%% 
%% This file may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either
%% version 1.3c of this license or (at your option) any later
%% version.
%% 
\def\fileversion{v1.0.0}
\def\filedate{2024/03/13}
\NeedsTeXFormat{LaTeX2e}[2021/06/01]
\ProvidesClass{tuzuk}[\filedate\space\fileversion\space Turkish Bylaws and Regulations Document Class]
\LoadClass[12pt, onecolumn]{article}

\ProcessOptions\relax

\RequirePackage[a4paper,
                top=2.5cm,
                left=2.5cm,
                right= 2.5cm,
                bottom=2.5cm]{geometry}
\RequirePackage{mathptmx}
\RequirePackage{setspace}
\onehalfspacing

\RequirePackage{enumitem}
\RequirePackage[utf8]{inputenc}
\RequirePackage[turkish]{babel}
\RequirePackage[normalem]{ulem}
\RequirePackage{hyphenat}
\RequirePackage[T1]{fontenc}
\def\baskan#1{\def\@baskan{#1}}
\def\baskanyrd#1{\def\@baskanyrd{#1}}
\def\sekreter#1{\def\@sekreter{#1}}
\def\sayman#1{\def\@sayman{#1}}
\def\uye#1{\def\@uye{#1}}

\def\tuzukbasligi#1{
    \def\@tuzukbasligi{
            \textbf{%
                \MakeUppercase{#1}
            }
    }
}
\newcommand{\bolumadi}[1]{\vspace{8pt} \noindent\textbf{#1}\newline}
\newcommand{\madde}[2]{\noindent\textbf{Madde #1:} #2 \\}
\renewcommand{\maketitle}{
\thispagestyle{plain}
    \begin{center}
        \vspace{12pt}
        \@tuzukbasligi
    \end{center}
}
\newenvironment{fikra}
    {\begin{enumerate}[label=\alph*.]
    }
    {%
      \end{enumerate}
    }
\newcommand{\imzalar}{
    \renewcommand{\arraystretch}{1}
    \vspace{1.5cm} \noindent  \begin{tabular}{p{5cm}p{5cm}p{5cm}}
    \hrulefill & \hrulefill & \hrulefill \\
    \centering \@baskan & \centering \@baskanyrd & \centering \@sekreter \\
    \vspace{1cm} & \centering \\
    \hrulefill & \hrulefill \\
    \centering \@sayman & \centering \@uye \\
    \end{tabular}
}
\endinput
%%
%% End of file `tuzuk.cls'.
