#ifndef WRITEODFDRAW_H
#define WRITEODFDRAW_H
#include "writeodf.h"
namespace writeodf {
class draw_enhanced_geometry : public OdfWriter {
public:
    draw_enhanced_geometry(OdfWriter* x) :OdfWriter(x, "draw:enhanced-geometry", true) {
    }
    draw_enhanced_geometry(KoXmlWriter* x) :OdfWriter(x, "draw:enhanced-geometry", true) {
    }
    draw_equation add_draw_equation();
    draw_handle add_draw_handle(const QString& draw_handle_position);
    template<class T>
    void set_dr3d_projection(const T& value) {
        addAttribute("dr3d:projection", value);
    }
    template<class T>
    void set_dr3d_shade_mode(const T& value) {
        addAttribute("dr3d:shade-mode", value);
    }
    template<class T>
    void set_draw_concentric_gradient_fill_allowed(const T& value) {
        addAttribute("draw:concentric-gradient-fill-allowed", value);
    }
    void set_draw_enhanced_path(const QString& value) {
        addAttribute("draw:enhanced-path", value);
    }
    template<class T>
    void set_draw_extrusion(const T& value) {
        addAttribute("draw:extrusion", value);
    }
    template<class T>
    void set_draw_extrusion_allowed(const T& value) {
        addAttribute("draw:extrusion-allowed", value);
    }
    void set_draw_extrusion_brightness(const QString& value) {
        addAttribute("draw:extrusion-brightness", value);
    }
    template<class T>
    void set_draw_extrusion_color(const T& value) {
        addAttribute("draw:extrusion-color", value);
    }
    template<class T>
    void set_draw_extrusion_depth(const T& value) {
        addAttribute("draw:extrusion-depth", value);
    }
    void set_draw_extrusion_diffusion(const QString& value) {
        addAttribute("draw:extrusion-diffusion", value);
    }
    void set_draw_extrusion_first_light_direction(const QString& value) {
        addAttribute("draw:extrusion-first-light-direction", value);
    }
    template<class T>
    void set_draw_extrusion_first_light_harsh(const T& value) {
        addAttribute("draw:extrusion-first-light-harsh", value);
    }
    void set_draw_extrusion_first_light_level(const QString& value) {
        addAttribute("draw:extrusion-first-light-level", value);
    }
    template<class T>
    void set_draw_extrusion_light_face(const T& value) {
        addAttribute("draw:extrusion-light-face", value);
    }
    template<class T>
    void set_draw_extrusion_metal(const T& value) {
        addAttribute("draw:extrusion-metal", value);
    }
    void set_draw_extrusion_number_of_line_segments(qint64 value) {
        addAttribute("draw:extrusion-number-of-line-segments", value);
    }
    template<class T>
    void set_draw_extrusion_origin(const T& value) {
        addAttribute("draw:extrusion-origin", value);
    }
    template<class T>
    void set_draw_extrusion_rotation_angle(const T& value) {
        addAttribute("draw:extrusion-rotation-angle", value);
    }
    void set_draw_extrusion_rotation_center(const QString& value) {
        addAttribute("draw:extrusion-rotation-center", value);
    }
    void set_draw_extrusion_second_light_direction(const QString& value) {
        addAttribute("draw:extrusion-second-light-direction", value);
    }
    template<class T>
    void set_draw_extrusion_second_light_harsh(const T& value) {
        addAttribute("draw:extrusion-second-light-harsh", value);
    }
    void set_draw_extrusion_second_light_level(const QString& value) {
        addAttribute("draw:extrusion-second-light-level", value);
    }
    void set_draw_extrusion_shininess(const QString& value) {
        addAttribute("draw:extrusion-shininess", value);
    }
    template<class T>
    void set_draw_extrusion_skew(const T& value) {
        addAttribute("draw:extrusion-skew", value);
    }
    void set_draw_extrusion_specularity(const QString& value) {
        addAttribute("draw:extrusion-specularity", value);
    }
    void set_draw_extrusion_viewpoint(const QString& value) {
        addAttribute("draw:extrusion-viewpoint", value);
    }
    void set_draw_glue_point_leaving_directions(const QString& value) {
        addAttribute("draw:glue-point-leaving-directions", value);
    }
    template<class T>
    void set_draw_glue_point_type(const T& value) {
        addAttribute("draw:glue-point-type", value);
    }
    void set_draw_glue_points(const QString& value) {
        addAttribute("draw:glue-points", value);
    }
    template<class T>
    void set_draw_mirror_horizontal(const T& value) {
        addAttribute("draw:mirror-horizontal", value);
    }
    template<class T>
    void set_draw_mirror_vertical(const T& value) {
        addAttribute("draw:mirror-vertical", value);
    }
    void set_draw_modifiers(const QString& value) {
        addAttribute("draw:modifiers", value);
    }
    void set_draw_path_stretchpoint_x(double value) {
        addAttribute("draw:path-stretchpoint-x", value);
    }
    void set_draw_path_stretchpoint_y(double value) {
        addAttribute("draw:path-stretchpoint-y", value);
    }
    void set_draw_text_areas(const QString& value) {
        addAttribute("draw:text-areas", value);
    }
    template<class T>
    void set_draw_text_path(const T& value) {
        addAttribute("draw:text-path", value);
    }
    template<class T>
    void set_draw_text_path_allowed(const T& value) {
        addAttribute("draw:text-path-allowed", value);
    }
    template<class T>
    void set_draw_text_path_mode(const T& value) {
        addAttribute("draw:text-path-mode", value);
    }
    template<class T>
    void set_draw_text_path_same_letter_heights(const T& value) {
        addAttribute("draw:text-path-same-letter-heights", value);
    }
    template<class T>
    void set_draw_text_path_scale(const T& value) {
        addAttribute("draw:text-path-scale", value);
    }
    void set_draw_text_rotate_angle(const QString& value) {
        addAttribute("draw:text-rotate-angle", value);
    }
    template<class T>
    void set_draw_type(const T& value) {
        addAttribute("draw:type", value);
    }
    template<class T>
    void set_svg_viewBox(const T& value) {
        addAttribute("svg:viewBox", value);
    }
};
class draw_fill_image : public OdfWriter {
public:
    draw_fill_image(OdfWriter* x, const QString& draw_name, const QUrl& xlink_href) :OdfWriter(x, "draw:fill-image", false) {
        addAttribute("draw:name", draw_name);
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    draw_fill_image(KoXmlWriter* x, const QString& draw_name, const QUrl& xlink_href) :OdfWriter(x, "draw:fill-image", false) {
        addAttribute("draw:name", draw_name);
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    void set_draw_display_name(const QString& value) {
        addAttribute("draw:display-name", value);
    }
    void set_svg_height(const QString& value) {
        addAttribute("svg:height", value);
    }
    void set_svg_width(const QString& value) {
        addAttribute("svg:width", value);
    }
    template<class T>
    void set_xlink_actuate(const T& value) {
        addAttribute("xlink:actuate", value);
    }
    template<class T>
    void set_xlink_show(const T& value) {
        addAttribute("xlink:show", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_glue_point : public OdfWriter {
public:
    draw_glue_point(OdfWriter* x, const QString& draw_escape_direction, quint64 draw_id, const QString& svg_x, const QString& svg_y) :OdfWriter(x, "draw:glue-point", false) {
        addAttribute("draw:escape-direction", draw_escape_direction);
        addAttribute("draw:id", draw_id);
        addAttribute("svg:x", svg_x);
        addAttribute("svg:y", svg_y);
    }
    draw_glue_point(KoXmlWriter* x, const QString& draw_escape_direction, quint64 draw_id, const QString& svg_x, const QString& svg_y) :OdfWriter(x, "draw:glue-point", false) {
        addAttribute("draw:escape-direction", draw_escape_direction);
        addAttribute("draw:id", draw_id);
        addAttribute("svg:x", svg_x);
        addAttribute("svg:y", svg_y);
    }
    template<class T>
    void set_draw_align(const T& value) {
        addAttribute("draw:align", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_handle : public OdfWriter {
public:
    draw_handle(OdfWriter* x, const QString& draw_handle_position) :OdfWriter(x, "draw:handle", false) {
        addAttribute("draw:handle-position", draw_handle_position);
    }
    draw_handle(KoXmlWriter* x, const QString& draw_handle_position) :OdfWriter(x, "draw:handle", false) {
        addAttribute("draw:handle-position", draw_handle_position);
    }
    template<class T>
    void set_draw_handle_mirror_horizontal(const T& value) {
        addAttribute("draw:handle-mirror-horizontal", value);
    }
    template<class T>
    void set_draw_handle_mirror_vertical(const T& value) {
        addAttribute("draw:handle-mirror-vertical", value);
    }
    void set_draw_handle_polar(const QString& value) {
        addAttribute("draw:handle-polar", value);
    }
    void set_draw_handle_radius_range_maximum(const QString& value) {
        addAttribute("draw:handle-radius-range-maximum", value);
    }
    void set_draw_handle_radius_range_minimum(const QString& value) {
        addAttribute("draw:handle-radius-range-minimum", value);
    }
    void set_draw_handle_range_x_maximum(const QString& value) {
        addAttribute("draw:handle-range-x-maximum", value);
    }
    void set_draw_handle_range_x_minimum(const QString& value) {
        addAttribute("draw:handle-range-x-minimum", value);
    }
    void set_draw_handle_range_y_maximum(const QString& value) {
        addAttribute("draw:handle-range-y-maximum", value);
    }
    void set_draw_handle_range_y_minimum(const QString& value) {
        addAttribute("draw:handle-range-y-minimum", value);
    }
    template<class T>
    void set_draw_handle_switched(const T& value) {
        addAttribute("draw:handle-switched", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_param : public OdfWriter {
public:
    draw_param(OdfWriter* x) :OdfWriter(x, "draw:param", false) {
    }
    draw_param(KoXmlWriter* x) :OdfWriter(x, "draw:param", false) {
    }
    void set_draw_name(const QString& value) {
        addAttribute("draw:name", value);
    }
    void set_draw_value(const QString& value) {
        addAttribute("draw:value", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_equation : public OdfWriter {
public:
    draw_equation(OdfWriter* x) :OdfWriter(x, "draw:equation", false) {
    }
    draw_equation(KoXmlWriter* x) :OdfWriter(x, "draw:equation", false) {
    }
    void set_draw_formula(const QString& value) {
        addAttribute("draw:formula", value);
    }
    void set_draw_name(const QString& value) {
        addAttribute("draw:name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_gradient : public OdfWriter, public group_common_draw_gradient_attlist {
public:
    draw_gradient(OdfWriter* x, const QString& draw_style) :OdfWriter(x, "draw:gradient", false), group_common_draw_gradient_attlist(*static_cast<OdfWriter*>(this), draw_style) {
    }
    draw_gradient(KoXmlWriter* x, const QString& draw_style) :OdfWriter(x, "draw:gradient", false), group_common_draw_gradient_attlist(*static_cast<OdfWriter*>(this), draw_style) {
    }
    void set_draw_end_color(const QString& value) {
        addAttribute("draw:end-color", value);
    }
    void set_draw_end_intensity(const QString& value) {
        addAttribute("draw:end-intensity", value);
    }
    void set_draw_start_color(const QString& value) {
        addAttribute("draw:start-color", value);
    }
    void set_draw_start_intensity(const QString& value) {
        addAttribute("draw:start-intensity", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_stroke_dash : public OdfWriter {
public:
    draw_stroke_dash(OdfWriter* x, const QString& draw_name) :OdfWriter(x, "draw:stroke-dash", false) {
        addAttribute("draw:name", draw_name);
    }
    draw_stroke_dash(KoXmlWriter* x, const QString& draw_name) :OdfWriter(x, "draw:stroke-dash", false) {
        addAttribute("draw:name", draw_name);
    }
    void set_draw_display_name(const QString& value) {
        addAttribute("draw:display-name", value);
    }
    void set_draw_distance(const QString& value) {
        addAttribute("draw:distance", value);
    }
    void set_draw_dots1(qint64 value) {
        addAttribute("draw:dots1", value);
    }
    void set_draw_dots1_length(const QString& value) {
        addAttribute("draw:dots1-length", value);
    }
    void set_draw_dots2(qint64 value) {
        addAttribute("draw:dots2", value);
    }
    void set_draw_dots2_length(const QString& value) {
        addAttribute("draw:dots2-length", value);
    }
    template<class T>
    void set_draw_style(const T& value) {
        addAttribute("draw:style", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_area_polygon : public OdfWriter, public group_common_draw_area_attlist, public group_common_draw_points_attlist, public group_common_draw_viewbox_attlist, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_area_polygon(OdfWriter* x, const QString& draw_points, const QString& svg_height, const QString& svg_viewBox, const QString& svg_width, const QString& svg_x, const QString& svg_y) :OdfWriter(x, "draw:area-polygon", true), group_common_draw_area_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_points_attlist(*static_cast<OdfWriter*>(this), draw_points), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("svg:height", svg_height);
        addAttribute("svg:width", svg_width);
        addAttribute("svg:x", svg_x);
        addAttribute("svg:y", svg_y);
    }
    draw_area_polygon(KoXmlWriter* x, const QString& draw_points, const QString& svg_height, const QString& svg_viewBox, const QString& svg_width, const QString& svg_x, const QString& svg_y) :OdfWriter(x, "draw:area-polygon", true), group_common_draw_area_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_points_attlist(*static_cast<OdfWriter*>(this), draw_points), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("svg:height", svg_height);
        addAttribute("svg:width", svg_width);
        addAttribute("svg:x", svg_x);
        addAttribute("svg:y", svg_y);
    }
};
class draw_contour_polygon : public OdfWriter, public group_common_contour_attlist, public group_common_draw_points_attlist, public group_common_draw_size_attlist, public group_common_draw_viewbox_attlist {
public:
    draw_contour_polygon(OdfWriter* x, const QString& draw_points, const QString& draw_recreate_on_edit, const QString& svg_viewBox) :OdfWriter(x, "draw:contour-polygon", false), group_common_contour_attlist(*static_cast<OdfWriter*>(this), draw_recreate_on_edit), group_common_draw_points_attlist(*static_cast<OdfWriter*>(this), draw_points), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox) {
    }
    draw_contour_polygon(KoXmlWriter* x, const QString& draw_points, const QString& draw_recreate_on_edit, const QString& svg_viewBox) :OdfWriter(x, "draw:contour-polygon", false), group_common_contour_attlist(*static_cast<OdfWriter*>(this), draw_recreate_on_edit), group_common_draw_points_attlist(*static_cast<OdfWriter*>(this), draw_points), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_floating_frame : public OdfWriter, public group_common_draw_data_attlist, public group_xml_id {
public:
    draw_floating_frame(OdfWriter* x, const QUrl& xlink_href) :OdfWriter(x, "draw:floating-frame", false), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this), xlink_href), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    draw_floating_frame(KoXmlWriter* x, const QUrl& xlink_href) :OdfWriter(x, "draw:floating-frame", false), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this), xlink_href), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_frame_name(const QString& value) {
        addAttribute("draw:frame-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_layer : public OdfWriter, public group_svg_desc, public group_svg_title {
public:
    draw_layer(OdfWriter* x, const QString& draw_name) :OdfWriter(x, "draw:layer", true), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("draw:name", draw_name);
    }
    draw_layer(KoXmlWriter* x, const QString& draw_name) :OdfWriter(x, "draw:layer", true), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("draw:name", draw_name);
    }
    template<class T>
    void set_draw_display(const T& value) {
        addAttribute("draw:display", value);
    }
    template<class T>
    void set_draw_protected(const T& value) {
        addAttribute("draw:protected", value);
    }
};
class draw_object_ole : public OdfWriter, public group_common_draw_data_attlist, public group_office_binary_data, public group_xml_id {
public:
    draw_object_ole(OdfWriter* x) :OdfWriter(x, "draw:object-ole", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_office_binary_data(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    draw_object_ole(KoXmlWriter* x) :OdfWriter(x, "draw:object-ole", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_office_binary_data(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_class_id(const QString& value) {
        addAttribute("draw:class-id", value);
    }
};
class draw_area_rectangle : public OdfWriter, public group_common_draw_area_attlist, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_area_rectangle(OdfWriter* x, const QString& svg_height, const QString& svg_width, const QString& svg_x, const QString& svg_y) :OdfWriter(x, "draw:area-rectangle", true), group_common_draw_area_attlist(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("svg:height", svg_height);
        addAttribute("svg:width", svg_width);
        addAttribute("svg:x", svg_x);
        addAttribute("svg:y", svg_y);
    }
    draw_area_rectangle(KoXmlWriter* x, const QString& svg_height, const QString& svg_width, const QString& svg_x, const QString& svg_y) :OdfWriter(x, "draw:area-rectangle", true), group_common_draw_area_attlist(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("svg:height", svg_height);
        addAttribute("svg:width", svg_width);
        addAttribute("svg:x", svg_x);
        addAttribute("svg:y", svg_y);
    }
};
class draw_contour_path : public OdfWriter, public group_common_contour_attlist, public group_common_draw_path_data_attlist, public group_common_draw_size_attlist, public group_common_draw_viewbox_attlist {
public:
    draw_contour_path(OdfWriter* x, const QString& draw_recreate_on_edit, const QString& svg_d, const QString& svg_viewBox) :OdfWriter(x, "draw:contour-path", false), group_common_contour_attlist(*static_cast<OdfWriter*>(this), draw_recreate_on_edit), group_common_draw_path_data_attlist(*static_cast<OdfWriter*>(this), svg_d), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox) {
    }
    draw_contour_path(KoXmlWriter* x, const QString& draw_recreate_on_edit, const QString& svg_d, const QString& svg_viewBox) :OdfWriter(x, "draw:contour-path", false), group_common_contour_attlist(*static_cast<OdfWriter*>(this), draw_recreate_on_edit), group_common_draw_path_data_attlist(*static_cast<OdfWriter*>(this), svg_d), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox) {
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_hatch : public OdfWriter {
public:
    draw_hatch(OdfWriter* x, const QString& draw_name, const QString& draw_style) :OdfWriter(x, "draw:hatch", false) {
        addAttribute("draw:name", draw_name);
        addAttribute("draw:style", draw_style);
    }
    draw_hatch(KoXmlWriter* x, const QString& draw_name, const QString& draw_style) :OdfWriter(x, "draw:hatch", false) {
        addAttribute("draw:name", draw_name);
        addAttribute("draw:style", draw_style);
    }
    void set_draw_color(const QString& value) {
        addAttribute("draw:color", value);
    }
    void set_draw_display_name(const QString& value) {
        addAttribute("draw:display-name", value);
    }
    void set_draw_distance(const QString& value) {
        addAttribute("draw:distance", value);
    }
    void set_draw_rotation(const QString& value) {
        addAttribute("draw:rotation", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_image_map : public OdfWriter {
public:
    draw_image_map(OdfWriter* x) :OdfWriter(x, "draw:image-map", true) {
    }
    draw_image_map(KoXmlWriter* x) :OdfWriter(x, "draw:image-map", true) {
    }
    draw_area_circle add_draw_area_circle(const QString& svg_cx, const QString& svg_cy, const QString& svg_r);
    draw_area_polygon add_draw_area_polygon(const QString& draw_points, const QString& svg_height, const QString& svg_viewBox, const QString& svg_width, const QString& svg_x, const QString& svg_y);
    draw_area_rectangle add_draw_area_rectangle(const QString& svg_height, const QString& svg_width, const QString& svg_x, const QString& svg_y);
};
class draw_opacity : public OdfWriter, public group_common_draw_gradient_attlist {
public:
    draw_opacity(OdfWriter* x, const QString& draw_style) :OdfWriter(x, "draw:opacity", false), group_common_draw_gradient_attlist(*static_cast<OdfWriter*>(this), draw_style) {
    }
    draw_opacity(KoXmlWriter* x, const QString& draw_style) :OdfWriter(x, "draw:opacity", false), group_common_draw_gradient_attlist(*static_cast<OdfWriter*>(this), draw_style) {
    }
    void set_draw_end(const QString& value) {
        addAttribute("draw:end", value);
    }
    void set_draw_start(const QString& value) {
        addAttribute("draw:start", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_applet : public OdfWriter, public group_common_draw_data_attlist, public group_draw_param, public group_xml_id {
public:
    draw_applet(OdfWriter* x) :OdfWriter(x, "draw:applet", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_draw_param(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    draw_applet(KoXmlWriter* x) :OdfWriter(x, "draw:applet", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_draw_param(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_archive(const QString& value) {
        addAttribute("draw:archive", value);
    }
    void set_draw_code(const QString& value) {
        addAttribute("draw:code", value);
    }
    template<class T>
    void set_draw_may_script(const T& value) {
        addAttribute("draw:may-script", value);
    }
    void set_draw_object(const QString& value) {
        addAttribute("draw:object", value);
    }
};
class draw_a : public OdfWriter, public group_shape_instance, public group_xml_id {
public:
    draw_a(OdfWriter* x, const QUrl& xlink_href) :OdfWriter(x, "draw:a", true), group_shape_instance(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    draw_a(KoXmlWriter* x, const QUrl& xlink_href) :OdfWriter(x, "draw:a", true), group_shape_instance(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("xlink:href", xlink_href);
        addAttribute("xlink:type", "simple");
    }
    void set_office_name(const QString& value) {
        addAttribute("office:name", value);
    }
    template<class T>
    void set_office_server_map(const T& value) {
        addAttribute("office:server-map", value);
    }
    template<class T>
    void set_office_target_frame_name(const T& value) {
        addAttribute("office:target-frame-name", value);
    }
    void set_office_title(const QString& value) {
        addAttribute("office:title", value);
    }
    template<class T>
    void set_xlink_actuate(const T& value) {
        addAttribute("xlink:actuate", value);
    }
    template<class T>
    void set_xlink_show(const T& value) {
        addAttribute("xlink:show", value);
    }
};
class draw_page : public OdfWriter, public group_animation_element, public group_common_presentation_header_footer_attlist, public group_draw_layer_set, public group_office_forms, public group_presentation_notes, public group_shape, public group_svg_desc, public group_svg_title, public group_xml_id {
public:
    draw_page(OdfWriter* x, const QString& draw_master_page_name) :OdfWriter(x, "draw:page", true), group_animation_element(*static_cast<OdfWriter*>(this)), group_common_presentation_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_draw_layer_set(*static_cast<OdfWriter*>(this)), group_office_forms(*static_cast<OdfWriter*>(this)), group_presentation_notes(*static_cast<OdfWriter*>(this)), group_shape(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("draw:master-page-name", draw_master_page_name);
    }
    draw_page(KoXmlWriter* x, const QString& draw_master_page_name) :OdfWriter(x, "draw:page", true), group_animation_element(*static_cast<OdfWriter*>(this)), group_common_presentation_header_footer_attlist(*static_cast<OdfWriter*>(this)), group_draw_layer_set(*static_cast<OdfWriter*>(this)), group_office_forms(*static_cast<OdfWriter*>(this)), group_presentation_notes(*static_cast<OdfWriter*>(this)), group_shape(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
        addAttribute("draw:master-page-name", draw_master_page_name);
    }
    presentation_animations add_presentation_animations();
    void set_draw_id(const QString& value) {
        addAttribute("draw:id", value);
    }
    void set_draw_name(const QString& value) {
        addAttribute("draw:name", value);
    }
    void set_draw_nav_order(const QStringList& value) {
        addAttribute("draw:nav-order", value);
    }
    void set_draw_style_name(const QString& value) {
        addAttribute("draw:style-name", value);
    }
    void set_presentation_presentation_page_layout_name(const QString& value) {
        addAttribute("presentation:presentation-page-layout-name", value);
    }
};
class draw_plugin : public OdfWriter, public group_common_draw_data_attlist, public group_draw_param, public group_xml_id {
public:
    draw_plugin(OdfWriter* x, const QUrl& xlink_href) :OdfWriter(x, "draw:plugin", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this), xlink_href), group_draw_param(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    draw_plugin(KoXmlWriter* x, const QUrl& xlink_href) :OdfWriter(x, "draw:plugin", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this), xlink_href), group_draw_param(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_mime_type(const QString& value) {
        addAttribute("draw:mime-type", value);
    }
};
class draw_area_circle : public OdfWriter, public group_common_draw_area_attlist, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_area_circle(OdfWriter* x, const QString& svg_cx, const QString& svg_cy, const QString& svg_r) :OdfWriter(x, "draw:area-circle", true), group_common_draw_area_attlist(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("svg:cx", svg_cx);
        addAttribute("svg:cy", svg_cy);
        addAttribute("svg:r", svg_r);
    }
    draw_area_circle(KoXmlWriter* x, const QString& svg_cx, const QString& svg_cy, const QString& svg_r) :OdfWriter(x, "draw:area-circle", true), group_common_draw_area_attlist(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("svg:cx", svg_cx);
        addAttribute("svg:cy", svg_cy);
        addAttribute("svg:r", svg_r);
    }
};
class draw_g : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_id_attlist, public group_common_draw_name_attlist, public group_common_draw_style_name_attlist, public group_common_draw_z_index_attlist, public group_common_text_spreadsheet_shape_attlist, public group_draw_glue_point, public group_office_event_listeners, public group_shape, public group_svg_desc, public group_svg_title {
public:
    draw_g(OdfWriter* x) :OdfWriter(x, "draw:g", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_name_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_z_index_attlist(*static_cast<OdfWriter*>(this)), group_common_text_spreadsheet_shape_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_shape(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_g(KoXmlWriter* x) :OdfWriter(x, "draw:g", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_name_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_style_name_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_z_index_attlist(*static_cast<OdfWriter*>(this)), group_common_text_spreadsheet_shape_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_shape(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    void set_svg_y(const QString& value) {
        addAttribute("svg:y", value);
    }
};
class draw_layer_set : public OdfWriter {
public:
    draw_layer_set(OdfWriter* x) :OdfWriter(x, "draw:layer-set", true) {
    }
    draw_layer_set(KoXmlWriter* x) :OdfWriter(x, "draw:layer-set", true) {
    }
    draw_layer add_draw_layer(const QString& draw_name);
};
class draw_marker : public OdfWriter, public group_common_draw_path_data_attlist, public group_common_draw_viewbox_attlist {
public:
    draw_marker(OdfWriter* x, const QString& draw_name, const QString& svg_d, const QString& svg_viewBox) :OdfWriter(x, "draw:marker", false), group_common_draw_path_data_attlist(*static_cast<OdfWriter*>(this), svg_d), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox) {
        addAttribute("draw:name", draw_name);
    }
    draw_marker(KoXmlWriter* x, const QString& draw_name, const QString& svg_d, const QString& svg_viewBox) :OdfWriter(x, "draw:marker", false), group_common_draw_path_data_attlist(*static_cast<OdfWriter*>(this), svg_d), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox) {
        addAttribute("draw:name", draw_name);
    }
    void set_draw_display_name(const QString& value) {
        addAttribute("draw:display-name", value);
    }
    void addTextNode(const QString& data) {
        OdfWriter::addTextNode(data);
    }
};
class draw_object : public OdfWriter, public group_common_draw_data_attlist, public group_math_math, public group_office_document, public group_xml_id {
public:
    draw_object(OdfWriter* x) :OdfWriter(x, "draw:object", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_math_math(*static_cast<OdfWriter*>(this)), group_office_document(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    draw_object(KoXmlWriter* x) :OdfWriter(x, "draw:object", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_math_math(*static_cast<OdfWriter*>(this)), group_office_document(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_notify_on_update_of_ranges(const QString& value) {
        addAttribute("draw:notify-on-update-of-ranges", value);
    }
};
class draw_page_thumbnail : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_position_attlist, public group_common_draw_shape_with_styles_attlist, public group_common_draw_size_attlist, public group_presentation_shape_attlist, public group_svg_desc, public group_svg_title {
public:
    draw_page_thumbnail(OdfWriter* x) :OdfWriter(x, "draw:page-thumbnail", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_presentation_shape_attlist(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_page_thumbnail(KoXmlWriter* x) :OdfWriter(x, "draw:page-thumbnail", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_presentation_shape_attlist(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_page_number(quint64 value) {
        addAttribute("draw:page-number", value);
    }
};
class draw_text_box : public OdfWriter, public group_text_content, public group_xml_id {
public:
    draw_text_box(OdfWriter* x) :OdfWriter(x, "draw:text-box", true), group_text_content(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    draw_text_box(KoXmlWriter* x) :OdfWriter(x, "draw:text-box", true), group_text_content(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_chain_next_name(const QString& value) {
        addAttribute("draw:chain-next-name", value);
    }
    void set_draw_corner_radius(const QString& value) {
        addAttribute("draw:corner-radius", value);
    }
    void set_fo_max_height(const QString& value) {
        addAttribute("fo:max-height", value);
    }
    void set_fo_max_width(const QString& value) {
        addAttribute("fo:max-width", value);
    }
    void set_fo_min_height(const QString& value) {
        addAttribute("fo:min-height", value);
    }
    void set_fo_min_width(const QString& value) {
        addAttribute("fo:min-width", value);
    }
    void set_text_id(const QString& value) {
        addAttribute("text:id", value);
    }
};
class draw_frame : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_position_attlist, public group_common_draw_rel_size_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_draw_glue_point, public group_office_event_listeners, public group_presentation_shape_attlist, public group_svg_desc, public group_svg_title, public group_table_table {
public:
    draw_frame(OdfWriter* x) :OdfWriter(x, "draw:frame", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_rel_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_presentation_shape_attlist(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)), group_table_table(*static_cast<OdfWriter*>(this)) {
    }
    draw_frame(KoXmlWriter* x) :OdfWriter(x, "draw:frame", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_rel_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_presentation_shape_attlist(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)), group_table_table(*static_cast<OdfWriter*>(this)) {
    }
    draw_applet add_draw_applet();
    draw_contour_path add_draw_contour_path(const QString& draw_recreate_on_edit, const QString& svg_d, const QString& svg_viewBox);
    draw_contour_polygon add_draw_contour_polygon(const QString& draw_points, const QString& draw_recreate_on_edit, const QString& svg_viewBox);
    draw_floating_frame add_draw_floating_frame(const QUrl& xlink_href);
    draw_image add_draw_image();
    draw_image_map add_draw_image_map();
    draw_object add_draw_object();
    draw_object_ole add_draw_object_ole();
    draw_plugin add_draw_plugin(const QUrl& xlink_href);
    draw_text_box add_draw_text_box();
    void set_draw_copy_of(const QString& value) {
        addAttribute("draw:copy-of", value);
    }
};
class draw_circle : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_circle_ellipse_attlist, public group_common_draw_circle_ellipse_pos_attlist, public group_common_draw_position_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_size_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_circle(OdfWriter* x) :OdfWriter(x, "draw:circle", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_circle_ellipse_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_circle_ellipse_pos_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_circle(KoXmlWriter* x) :OdfWriter(x, "draw:circle", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_circle_ellipse_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_circle_ellipse_pos_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    void set_svg_r(const QString& value) {
        addAttribute("svg:r", value);
    }
};
class draw_control : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_position_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_size_attlist, public group_draw_glue_point, public group_svg_desc, public group_svg_title {
public:
    draw_control(OdfWriter* x, const QString& draw_control) :OdfWriter(x, "draw:control", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("draw:control", draw_control);
    }
    draw_control(KoXmlWriter* x, const QString& draw_control) :OdfWriter(x, "draw:control", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("draw:control", draw_control);
    }
};
class draw_ellipse : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_circle_ellipse_attlist, public group_common_draw_circle_ellipse_pos_attlist, public group_common_draw_position_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_size_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_ellipse(OdfWriter* x) :OdfWriter(x, "draw:ellipse", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_circle_ellipse_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_circle_ellipse_pos_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_ellipse(KoXmlWriter* x) :OdfWriter(x, "draw:ellipse", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_circle_ellipse_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_circle_ellipse_pos_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    void set_svg_rx(const QString& value) {
        addAttribute("svg:rx", value);
    }
    void set_svg_ry(const QString& value) {
        addAttribute("svg:ry", value);
    }
};
class draw_line : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_line(OdfWriter* x, const QString& svg_x1, const QString& svg_x2, const QString& svg_y1, const QString& svg_y2) :OdfWriter(x, "draw:line", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("svg:x1", svg_x1);
        addAttribute("svg:x2", svg_x2);
        addAttribute("svg:y1", svg_y1);
        addAttribute("svg:y2", svg_y2);
    }
    draw_line(KoXmlWriter* x, const QString& svg_x1, const QString& svg_x2, const QString& svg_y1, const QString& svg_y2) :OdfWriter(x, "draw:line", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("svg:x1", svg_x1);
        addAttribute("svg:x2", svg_x2);
        addAttribute("svg:y1", svg_y1);
        addAttribute("svg:y2", svg_y2);
    }
};
class draw_path : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_path_data_attlist, public group_common_draw_position_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_size_attlist, public group_common_draw_viewbox_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_path(OdfWriter* x, const QString& svg_d, const QString& svg_viewBox) :OdfWriter(x, "draw:path", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_path_data_attlist(*static_cast<OdfWriter*>(this), svg_d), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_path(KoXmlWriter* x, const QString& svg_d, const QString& svg_viewBox) :OdfWriter(x, "draw:path", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_path_data_attlist(*static_cast<OdfWriter*>(this), svg_d), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    void set_calligra_nodeTypes(const QString& value) {
        addAttribute("calligra:nodeTypes", value);
    }
};
class draw_polyline : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_points_attlist, public group_common_draw_position_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_size_attlist, public group_common_draw_viewbox_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_polyline(OdfWriter* x, const QString& draw_points, const QString& svg_viewBox) :OdfWriter(x, "draw:polyline", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_points_attlist(*static_cast<OdfWriter*>(this), draw_points), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_polyline(KoXmlWriter* x, const QString& draw_points, const QString& svg_viewBox) :OdfWriter(x, "draw:polyline", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_points_attlist(*static_cast<OdfWriter*>(this), draw_points), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
};
class draw_regular_polygon : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_position_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_size_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_regular_polygon(OdfWriter* x, quint64 draw_corners) :OdfWriter(x, "draw:regular-polygon", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("draw:corners", draw_corners);
    }
    draw_regular_polygon(KoXmlWriter* x, quint64 draw_corners) :OdfWriter(x, "draw:regular-polygon", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("draw:corners", draw_corners);
    }
    template<class T>
    void set_draw_concave(const T& value) {
        addAttribute("draw:concave", value);
    }
    void set_draw_sharpness(const QString& value) {
        addAttribute("draw:sharpness", value);
    }
};
class draw_caption : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_position_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_size_attlist, public group_draw_caption_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_caption(OdfWriter* x) :OdfWriter(x, "draw:caption", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_caption_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_caption(KoXmlWriter* x) :OdfWriter(x, "draw:caption", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_caption_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
};
class draw_custom_shape : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_position_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_size_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_custom_shape(OdfWriter* x) :OdfWriter(x, "draw:custom-shape", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_custom_shape(KoXmlWriter* x) :OdfWriter(x, "draw:custom-shape", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_enhanced_geometry add_draw_enhanced_geometry();
    void set_draw_data(const QString& value) {
        addAttribute("draw:data", value);
    }
    void set_draw_engine(const QString& value) {
        addAttribute("draw:engine", value);
    }
};
class draw_measure : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_measure(OdfWriter* x, const QString& svg_x1, const QString& svg_x2, const QString& svg_y1, const QString& svg_y2) :OdfWriter(x, "draw:measure", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("svg:x1", svg_x1);
        addAttribute("svg:x2", svg_x2);
        addAttribute("svg:y1", svg_y1);
        addAttribute("svg:y2", svg_y2);
    }
    draw_measure(KoXmlWriter* x, const QString& svg_x1, const QString& svg_x2, const QString& svg_y1, const QString& svg_y2) :OdfWriter(x, "draw:measure", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
        addAttribute("svg:x1", svg_x1);
        addAttribute("svg:x2", svg_x2);
        addAttribute("svg:y1", svg_y1);
        addAttribute("svg:y2", svg_y2);
    }
};
class draw_rect : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_position_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_size_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_rect(OdfWriter* x) :OdfWriter(x, "draw:rect", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_rect(KoXmlWriter* x) :OdfWriter(x, "draw:rect", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_corner_radius(const QString& value) {
        addAttribute("draw:corner-radius", value);
    }
    void set_svg_rx(const QString& value) {
        addAttribute("svg:rx", value);
    }
    void set_svg_ry(const QString& value) {
        addAttribute("svg:ry", value);
    }
};
class draw_image : public OdfWriter, public group_common_draw_data_attlist, public group_draw_text, public group_office_binary_data, public group_xml_id {
public:
    draw_image(OdfWriter* x) :OdfWriter(x, "draw:image", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_binary_data(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    draw_image(KoXmlWriter* x) :OdfWriter(x, "draw:image", true), group_common_draw_data_attlist(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_binary_data(*static_cast<OdfWriter*>(this)), group_xml_id(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_filter_name(const QString& value) {
        addAttribute("draw:filter-name", value);
    }
};
class draw_connector : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_viewbox_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_connector(OdfWriter* x, const QString& svg_viewBox) :OdfWriter(x, "draw:connector", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_connector(KoXmlWriter* x, const QString& svg_viewBox) :OdfWriter(x, "draw:connector", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    void set_draw_end_glue_point(quint64 value) {
        addAttribute("draw:end-glue-point", value);
    }
    void set_draw_end_shape(const QString& value) {
        addAttribute("draw:end-shape", value);
    }
    template<class T>
    void set_draw_line_skew(const T& value) {
        addAttribute("draw:line-skew", value);
    }
    void set_draw_start_glue_point(quint64 value) {
        addAttribute("draw:start-glue-point", value);
    }
    void set_draw_start_shape(const QString& value) {
        addAttribute("draw:start-shape", value);
    }
    template<class T>
    void set_draw_type(const T& value) {
        addAttribute("draw:type", value);
    }
    void set_svg_d(const QString& value) {
        addAttribute("svg:d", value);
    }
    void set_svg_x1(const QString& value) {
        addAttribute("svg:x1", value);
    }
    void set_svg_x2(const QString& value) {
        addAttribute("svg:x2", value);
    }
    void set_svg_y1(const QString& value) {
        addAttribute("svg:y1", value);
    }
    void set_svg_y2(const QString& value) {
        addAttribute("svg:y2", value);
    }
};
class draw_polygon : public OdfWriter, public group_common_draw_caption_id_attlist, public group_common_draw_points_attlist, public group_common_draw_position_attlist, public group_common_draw_shape_with_text_and_styles_attlist, public group_common_draw_size_attlist, public group_common_draw_viewbox_attlist, public group_draw_glue_point, public group_draw_text, public group_office_event_listeners, public group_svg_desc, public group_svg_title {
public:
    draw_polygon(OdfWriter* x, const QString& draw_points, const QString& svg_viewBox) :OdfWriter(x, "draw:polygon", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_points_attlist(*static_cast<OdfWriter*>(this), draw_points), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
    draw_polygon(KoXmlWriter* x, const QString& draw_points, const QString& svg_viewBox) :OdfWriter(x, "draw:polygon", true), group_common_draw_caption_id_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_points_attlist(*static_cast<OdfWriter*>(this), draw_points), group_common_draw_position_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_shape_with_text_and_styles_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_size_attlist(*static_cast<OdfWriter*>(this)), group_common_draw_viewbox_attlist(*static_cast<OdfWriter*>(this), svg_viewBox), group_draw_glue_point(*static_cast<OdfWriter*>(this)), group_draw_text(*static_cast<OdfWriter*>(this)), group_office_event_listeners(*static_cast<OdfWriter*>(this)), group_svg_desc(*static_cast<OdfWriter*>(this)), group_svg_title(*static_cast<OdfWriter*>(this)) {
    }
};
}
inline writeodf::draw_glue_point
writeodf::group_draw_glue_point::add_draw_glue_point(const QString& draw_escape_direction, quint64 draw_id, const QString& svg_x, const QString& svg_y) {
    return writeodf::draw_glue_point(&xml, draw_escape_direction, draw_id, svg_x, svg_y);
}
inline writeodf::draw_page
writeodf::group_draw_page::add_draw_page(const QString& draw_master_page_name) {
    return writeodf::draw_page(&xml, draw_master_page_name);
}
inline writeodf::draw_equation
writeodf::draw_enhanced_geometry::add_draw_equation() {
    return writeodf::draw_equation(this);
}
inline writeodf::draw_handle
writeodf::draw_enhanced_geometry::add_draw_handle(const QString& draw_handle_position) {
    return writeodf::draw_handle(this, draw_handle_position);
}
inline writeodf::draw_layer_set
writeodf::group_draw_layer_set::add_draw_layer_set() {
    return writeodf::draw_layer_set(&xml);
}
inline writeodf::draw_frame
writeodf::group_draw_frame::add_draw_frame() {
    return writeodf::draw_frame(&xml);
}
inline writeodf::draw_caption
writeodf::group_shape_instance::add_draw_caption() {
    return writeodf::draw_caption(&xml);
}
inline writeodf::draw_circle
writeodf::group_shape_instance::add_draw_circle() {
    return writeodf::draw_circle(&xml);
}
inline writeodf::draw_connector
writeodf::group_shape_instance::add_draw_connector(const QString& svg_viewBox) {
    return writeodf::draw_connector(&xml, svg_viewBox);
}
inline writeodf::draw_control
writeodf::group_shape_instance::add_draw_control(const QString& draw_control) {
    return writeodf::draw_control(&xml, draw_control);
}
inline writeodf::draw_custom_shape
writeodf::group_shape_instance::add_draw_custom_shape() {
    return writeodf::draw_custom_shape(&xml);
}
inline writeodf::draw_ellipse
writeodf::group_shape_instance::add_draw_ellipse() {
    return writeodf::draw_ellipse(&xml);
}
inline writeodf::draw_g
writeodf::group_shape_instance::add_draw_g() {
    return writeodf::draw_g(&xml);
}
inline writeodf::draw_line
writeodf::group_shape_instance::add_draw_line(const QString& svg_x1, const QString& svg_x2, const QString& svg_y1, const QString& svg_y2) {
    return writeodf::draw_line(&xml, svg_x1, svg_x2, svg_y1, svg_y2);
}
inline writeodf::draw_measure
writeodf::group_shape_instance::add_draw_measure(const QString& svg_x1, const QString& svg_x2, const QString& svg_y1, const QString& svg_y2) {
    return writeodf::draw_measure(&xml, svg_x1, svg_x2, svg_y1, svg_y2);
}
inline writeodf::draw_page_thumbnail
writeodf::group_shape_instance::add_draw_page_thumbnail() {
    return writeodf::draw_page_thumbnail(&xml);
}
inline writeodf::draw_path
writeodf::group_shape_instance::add_draw_path(const QString& svg_d, const QString& svg_viewBox) {
    return writeodf::draw_path(&xml, svg_d, svg_viewBox);
}
inline writeodf::draw_polygon
writeodf::group_shape_instance::add_draw_polygon(const QString& draw_points, const QString& svg_viewBox) {
    return writeodf::draw_polygon(&xml, draw_points, svg_viewBox);
}
inline writeodf::draw_polyline
writeodf::group_shape_instance::add_draw_polyline(const QString& draw_points, const QString& svg_viewBox) {
    return writeodf::draw_polyline(&xml, draw_points, svg_viewBox);
}
inline writeodf::draw_rect
writeodf::group_shape_instance::add_draw_rect() {
    return writeodf::draw_rect(&xml);
}
inline writeodf::draw_regular_polygon
writeodf::group_shape_instance::add_draw_regular_polygon(quint64 draw_corners) {
    return writeodf::draw_regular_polygon(&xml, draw_corners);
}
inline writeodf::draw_area_circle
writeodf::draw_image_map::add_draw_area_circle(const QString& svg_cx, const QString& svg_cy, const QString& svg_r) {
    return writeodf::draw_area_circle(this, svg_cx, svg_cy, svg_r);
}
inline writeodf::draw_area_polygon
writeodf::draw_image_map::add_draw_area_polygon(const QString& draw_points, const QString& svg_height, const QString& svg_viewBox, const QString& svg_width, const QString& svg_x, const QString& svg_y) {
    return writeodf::draw_area_polygon(this, draw_points, svg_height, svg_viewBox, svg_width, svg_x, svg_y);
}
inline writeodf::draw_area_rectangle
writeodf::draw_image_map::add_draw_area_rectangle(const QString& svg_height, const QString& svg_width, const QString& svg_x, const QString& svg_y) {
    return writeodf::draw_area_rectangle(this, svg_height, svg_width, svg_x, svg_y);
}
inline writeodf::draw_param
writeodf::group_draw_param::add_draw_param() {
    return writeodf::draw_param(&xml);
}
inline writeodf::draw_a
writeodf::group_shape::add_draw_a(const QUrl& xlink_href) {
    return writeodf::draw_a(&xml, xlink_href);
}
inline writeodf::draw_layer
writeodf::draw_layer_set::add_draw_layer(const QString& draw_name) {
    return writeodf::draw_layer(this, draw_name);
}
inline writeodf::draw_applet
writeodf::draw_frame::add_draw_applet() {
    return writeodf::draw_applet(this);
}
inline writeodf::draw_contour_path
writeodf::draw_frame::add_draw_contour_path(const QString& draw_recreate_on_edit, const QString& svg_d, const QString& svg_viewBox) {
    return writeodf::draw_contour_path(this, draw_recreate_on_edit, svg_d, svg_viewBox);
}
inline writeodf::draw_contour_polygon
writeodf::draw_frame::add_draw_contour_polygon(const QString& draw_points, const QString& draw_recreate_on_edit, const QString& svg_viewBox) {
    return writeodf::draw_contour_polygon(this, draw_points, draw_recreate_on_edit, svg_viewBox);
}
inline writeodf::draw_floating_frame
writeodf::draw_frame::add_draw_floating_frame(const QUrl& xlink_href) {
    return writeodf::draw_floating_frame(this, xlink_href);
}
inline writeodf::draw_image
writeodf::draw_frame::add_draw_image() {
    return writeodf::draw_image(this);
}
inline writeodf::draw_image_map
writeodf::draw_frame::add_draw_image_map() {
    return writeodf::draw_image_map(this);
}
inline writeodf::draw_object
writeodf::draw_frame::add_draw_object() {
    return writeodf::draw_object(this);
}
inline writeodf::draw_object_ole
writeodf::draw_frame::add_draw_object_ole() {
    return writeodf::draw_object_ole(this);
}
inline writeodf::draw_plugin
writeodf::draw_frame::add_draw_plugin(const QUrl& xlink_href) {
    return writeodf::draw_plugin(this, xlink_href);
}
inline writeodf::draw_text_box
writeodf::draw_frame::add_draw_text_box() {
    return writeodf::draw_text_box(this);
}
inline writeodf::draw_enhanced_geometry
writeodf::draw_custom_shape::add_draw_enhanced_geometry() {
    return writeodf::draw_enhanced_geometry(this);
}
#endif
