; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z10 | FileCheck %s
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z14 | FileCheck %s

;
; Test strict 32-bit square root.
;

declare half @llvm.experimental.constrained.sqrt.f16(half, metadata, metadata)
declare float @llvm.experimental.constrained.sqrt.f32(float, metadata, metadata)

; Check register square root.
define half @f0(half %val) #0 {
; CHECK-LABEL: f0:
; CHECK:       # %bb.0:
; CHECK:      brasl %r14, __extendhfsf2@PLT
; CHECK-NEXT: sqebr %f0, %f0
; CHECK-NEXT: brasl %r14, __truncsfhf2@PLT
; CHECK:      br %r14
  %res = call half @llvm.experimental.constrained.sqrt.f16(
                        half %val,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict") #0
  ret half %res
}

; Check register square root.
define float @f1(float %val) #0 {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sqebr %f0, %f0
; CHECK-NEXT:    br %r14
  %res = call float @llvm.experimental.constrained.sqrt.f32(
                        float %val,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict") #0
  ret float %res
}

; Check the low end of the SQEB range.
define float @f2(ptr %ptr) #0 {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sqeb %f0, 0(%r2)
; CHECK-NEXT:    br %r14
  %val = load float, ptr %ptr
  %res = call float @llvm.experimental.constrained.sqrt.f32(
                        float %val,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict") #0
  ret float %res
}

; Check the high end of the aligned SQEB range.
define float @f3(ptr %base) #0 {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sqeb %f0, 4092(%r2)
; CHECK-NEXT:    br %r14
  %ptr = getelementptr float, ptr %base, i64 1023
  %val = load float, ptr %ptr
  %res = call float @llvm.experimental.constrained.sqrt.f32(
                        float %val,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict") #0
  ret float %res
}

; Check the next word up, which needs separate address logic.
; Other sequences besides this one would be OK.
define float @f4(ptr %base) #0 {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    aghi %r2, 4096
; CHECK-NEXT:    sqeb %f0, 0(%r2)
; CHECK-NEXT:    br %r14
  %ptr = getelementptr float, ptr %base, i64 1024
  %val = load float, ptr %ptr
  %res = call float @llvm.experimental.constrained.sqrt.f32(
                        float %val,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict") #0
  ret float %res
}

; Check negative displacements, which also need separate address logic.
define float @f5(ptr %base) #0 {
; CHECK-LABEL: f5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    aghi %r2, -4
; CHECK-NEXT:    sqeb %f0, 0(%r2)
; CHECK-NEXT:    br %r14
  %ptr = getelementptr float, ptr %base, i64 -1
  %val = load float, ptr %ptr
  %res = call float @llvm.experimental.constrained.sqrt.f32(
                        float %val,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict") #0
  ret float %res
}

; Check that SQEB allows indices.
define float @f6(ptr %base, i64 %index) #0 {
; CHECK-LABEL: f6:
; CHECK:       # %bb.0:
; CHECK-NEXT:    sllg %r1, %r3, 2
; CHECK-NEXT:    sqeb %f0, 400(%r1,%r2)
; CHECK-NEXT:    br %r14
  %ptr1 = getelementptr float, ptr %base, i64 %index
  %ptr2 = getelementptr float, ptr %ptr1, i64 100
  %val = load float, ptr %ptr2
  %res = call float @llvm.experimental.constrained.sqrt.f32(
                        float %val,
                        metadata !"round.dynamic",
                        metadata !"fpexcept.strict") #0
  ret float %res
}

attributes #0 = { strictfp }
