; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test high-part vector multiply-and-add on z17
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z17 | FileCheck %s

; Test a v2i64 unsigned high-part multiply-and-add.
define <2 x i64> @f1(<2 x i64> %val1, <2 x i64> %val2, <2 x i64> %val3) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalhg %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %zext1 = zext <2 x i64> %val1 to <2 x i128>
  %zext2 = zext <2 x i64> %val2 to <2 x i128>
  %zext3 = zext <2 x i64> %val3 to <2 x i128>
  %mulx = mul <2 x i128> %zext1, %zext2
  %addx = add <2 x i128> %mulx, %zext3
  %highx = lshr <2 x i128> %addx, splat(i128 64)
  %high = trunc <2 x i128> %highx to <2 x i64>
  ret <2 x i64> %high
}

; Test a v2i64 signed high-part multiply-and-add.
define <2 x i64> @f2(<2 x i64> %val1, <2 x i64> %val2, <2 x i64> %val3) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmahg %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %sext1 = sext <2 x i64> %val1 to <2 x i128>
  %sext2 = sext <2 x i64> %val2 to <2 x i128>
  %sext3 = sext <2 x i64> %val3 to <2 x i128>
  %mulx = mul <2 x i128> %sext1, %sext2
  %addx = add <2 x i128> %mulx, %sext3
  %highx = lshr <2 x i128> %addx, splat(i128 64)
  %high = trunc <2 x i128> %highx to <2 x i64>
  ret <2 x i64> %high
}
