/* AvatarBannerWidget.c generated by valac 0.34.6, the Vala compiler
 * generated from AvatarBannerWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_AVATAR_BANNER_WIDGET (avatar_banner_widget_get_type ())
#define AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget))
#define AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))
#define IS_AVATAR_BANNER_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_BANNER_WIDGET))
#define IS_AVATAR_BANNER_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_BANNER_WIDGET))
#define AVATAR_BANNER_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetClass))

typedef struct _AvatarBannerWidget AvatarBannerWidget;
typedef struct _AvatarBannerWidgetClass AvatarBannerWidgetClass;
typedef struct _AvatarBannerWidgetPrivate AvatarBannerWidgetPrivate;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_PIXBUF_BUTTON (pixbuf_button_get_type ())
#define PIXBUF_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PIXBUF_BUTTON, PixbufButton))
#define PIXBUF_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PIXBUF_BUTTON, PixbufButtonClass))
#define IS_PIXBUF_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PIXBUF_BUTTON))
#define IS_PIXBUF_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PIXBUF_BUTTON))
#define PIXBUF_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PIXBUF_BUTTON, PixbufButtonClass))

typedef struct _PixbufButton PixbufButton;
typedef struct _PixbufButtonClass PixbufButtonClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AvatarBannerWidgetFetchBannerData AvatarBannerWidgetFetchBannerData;

struct _AvatarBannerWidget {
	GtkContainer parent_instance;
	AvatarBannerWidgetPrivate * priv;
};

struct _AvatarBannerWidgetClass {
	GtkContainerClass parent_class;
};

struct _AvatarBannerWidgetPrivate {
	gint _avatar_size;
	Account* account;
	PixbufButton* set_banner_button;
	PixbufButton* set_avatar_button;
};

struct _AvatarBannerWidgetFetchBannerData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	AvatarBannerWidget* self;
	Account* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	PixbufButton* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* pixbuf;
	Account* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	PixbufButton* _tmp12_;
	GdkPixbuf* _tmp13_;
};


static gpointer avatar_banner_widget_parent_class = NULL;
extern GdkPixbuf* twitter_no_banner;

GType avatar_banner_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType pixbuf_button_get_type (void) G_GNUC_CONST;
#define AVATAR_BANNER_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidgetPrivate))
enum  {
	AVATAR_BANNER_WIDGET_DUMMY_PROPERTY,
	AVATAR_BANNER_WIDGET_AVATAR_SIZE
};
#define AVATAR_BANNER_WIDGET_MIN_HEIGHT 150
#define AVATAR_BANNER_WIDGET_MAX_HEIGHT 250
#define AVATAR_BANNER_WIDGET_BANNER_RATIO 0.5
void avatar_banner_widget_set_account (AvatarBannerWidget* self, Account* account);
static void avatar_banner_widget_fetch_banner (AvatarBannerWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void avatar_banner_widget_fetch_banner_finish (AvatarBannerWidget* self, GAsyncResult* _res_);
void pixbuf_button_set_bg (PixbufButton* self, cairo_surface_t* bg);
cairo_surface_t* account_get_avatar (Account* self);
static gboolean avatar_banner_widget_real_draw (GtkWidget* base, cairo_t* ct);
static gint avatar_banner_widget_get_avatar_x (AvatarBannerWidget* self);
gint avatar_banner_widget_get_avatar_size (AvatarBannerWidget* self);
static gint avatar_banner_widget_get_avatar_y (AvatarBannerWidget* self);
static GtkSizeRequestMode avatar_banner_widget_real_get_request_mode (GtkWidget* base);
static void avatar_banner_widget_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat);
static void avatar_banner_widget_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* min, gint* nat);
static void avatar_banner_widget_fetch_banner_data_free (gpointer _data);
static gboolean avatar_banner_widget_fetch_banner_co (AvatarBannerWidgetFetchBannerData* _data_);
const gchar* account_get_banner_url (Account* self);
void pixbuf_button_set_pixbuf (PixbufButton* self, GdkPixbuf* pixbuf);
void utils_download_pixbuf (const gchar* url, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
GdkPixbuf* utils_download_pixbuf_finish (GAsyncResult* _res_);
static void avatar_banner_widget_fetch_banner_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void avatar_banner_widget_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static void avatar_banner_widget_real_add (GtkContainer* base, GtkWidget* w);
static void avatar_banner_widget_real_remove (GtkContainer* base, GtkWidget* w);
static void avatar_banner_widget_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback cb, void* cb_target);
static void avatar_banner_widget_banner_clicked_cb (AvatarBannerWidget* self);
static void avatar_banner_widget_avatar_clicked_cb (AvatarBannerWidget* self);
void avatar_banner_widget_set_avatar (AvatarBannerWidget* self, GdkPixbuf* avatar);
void avatar_banner_widget_set_banner (AvatarBannerWidget* self, GdkPixbuf* banner);
AvatarBannerWidget* avatar_banner_widget_new (void);
AvatarBannerWidget* avatar_banner_widget_construct (GType object_type);
void avatar_banner_widget_set_avatar_size (AvatarBannerWidget* self, gint value);
static GObject * avatar_banner_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
PixbufButton* pixbuf_button_new (gboolean show_menu, const gchar* menu_string);
PixbufButton* pixbuf_button_construct (GType object_type, gboolean show_menu, const gchar* menu_string);
static void _avatar_banner_widget_banner_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _avatar_banner_widget_avatar_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
GSettings* settings_get (void);
static void avatar_banner_widget_finalize (GObject* obj);
static void _vala_avatar_banner_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_avatar_banner_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void avatar_banner_widget_set_account (AvatarBannerWidget* self, Account* account) {
	Account* _tmp0_ = NULL;
	PixbufButton* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	cairo_surface_t* _tmp4_ = NULL;
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	g_return_if_fail (IS_ACCOUNT (account));
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	avatar_banner_widget_fetch_banner (self, NULL, NULL);
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->set_avatar_button;
	_tmp2_ = account;
	_tmp3_ = account_get_avatar (_tmp2_);
	_tmp4_ = _tmp3_;
	pixbuf_button_set_bg (_tmp1_, (cairo_surface_t*) _tmp4_);
}


static gboolean avatar_banner_widget_real_draw (GtkWidget* base, cairo_t* ct) {
	AvatarBannerWidget * self;
	gboolean result = FALSE;
	PixbufButton* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	PixbufButton* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = self->priv->set_banner_button;
	_tmp1_ = ct;
	gtk_container_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), _tmp1_);
	_tmp2_ = self->priv->set_avatar_button;
	_tmp3_ = ct;
	gtk_container_propagate_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), _tmp3_);
	result = TRUE;
	return result;
}


static gint avatar_banner_widget_get_avatar_x (AvatarBannerWidget* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (IS_AVATAR_BANNER_WIDGET (self), 0);
	_tmp0_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->_avatar_size;
	result = (_tmp0_ / 2) - (_tmp1_ / 2);
	return result;
}


static gint avatar_banner_widget_get_avatar_y (AvatarBannerWidget* self) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (IS_AVATAR_BANNER_WIDGET (self), 0);
	_tmp0_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->_avatar_size;
	result = _tmp0_ - _tmp1_;
	return result;
}


static GtkSizeRequestMode avatar_banner_widget_real_get_request_mode (GtkWidget* base) {
	AvatarBannerWidget * self;
	GtkSizeRequestMode result = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}


static void avatar_banner_widget_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat) {
	AvatarBannerWidget * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gint _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_tmp0_ = self->priv->_avatar_size;
	_vala_nat = _tmp0_ + 40;
	_vala_min = _vala_nat;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void avatar_banner_widget_real_get_preferred_height_for_width (GtkWidget* base, gint width, gint* min, gint* nat) {
	AvatarBannerWidget * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_tmp0_ = self->priv->_avatar_size;
	_vala_min = (_tmp0_ / 3) + AVATAR_BANNER_WIDGET_MIN_HEIGHT;
	_tmp1_ = width;
	_tmp2_ = self->priv->_avatar_size;
	_tmp3_ = MIN (AVATAR_BANNER_WIDGET_MAX_HEIGHT, ((gint) (_tmp1_ * AVATAR_BANNER_WIDGET_BANNER_RATIO)) + (_tmp2_ / 3));
	_tmp4_ = MAX (_vala_min, _tmp3_);
	_vala_nat = _tmp4_;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void avatar_banner_widget_fetch_banner_data_free (gpointer _data) {
	AvatarBannerWidgetFetchBannerData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (AvatarBannerWidgetFetchBannerData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void avatar_banner_widget_fetch_banner (AvatarBannerWidget* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	AvatarBannerWidgetFetchBannerData* _data_;
	AvatarBannerWidget* _tmp0_ = NULL;
	_data_ = g_slice_new0 (AvatarBannerWidgetFetchBannerData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, avatar_banner_widget_fetch_banner);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, avatar_banner_widget_fetch_banner_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	avatar_banner_widget_fetch_banner_co (_data_);
}


static void avatar_banner_widget_fetch_banner_finish (AvatarBannerWidget* self, GAsyncResult* _res_) {
	AvatarBannerWidgetFetchBannerData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void avatar_banner_widget_fetch_banner_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	AvatarBannerWidgetFetchBannerData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	avatar_banner_widget_fetch_banner_co (_data_);
}


static gboolean avatar_banner_widget_fetch_banner_co (AvatarBannerWidgetFetchBannerData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->account;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = account_get_banner_url (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->self->priv->set_banner_button;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = twitter_no_banner;
		pixbuf_button_set_pixbuf (_data_->_tmp3_, _data_->_tmp4_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->self->priv->account;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = account_get_banner_url (_data_->_tmp5_);
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = g_strconcat (_data_->_tmp7_, "/600x200", NULL);
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_state_ = 1;
	utils_download_pixbuf (_data_->_tmp9_, NULL, avatar_banner_widget_fetch_banner_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = utils_download_pixbuf_finish (_data_->_res_);
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = _data_->_tmp10_;
	_g_free0 (_data_->_tmp9_);
	_data_->pixbuf = _data_->_tmp11_;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->self->priv->set_banner_button;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = _data_->pixbuf;
	pixbuf_button_set_pixbuf (_data_->_tmp12_, _data_->_tmp13_);
	_g_object_unref0 (_data_->pixbuf);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void avatar_banner_widget_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	AvatarBannerWidget * self;
	GtkAllocation _tmp0_ = {0};
	GtkRequisition child_requisition = {0};
	GtkAllocation child_allocation = {0};
	PixbufButton* _tmp1_ = NULL;
	GtkRequisition _tmp2_ = {0};
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	GtkAllocation _tmp7_ = {0};
	gint _tmp8_ = 0;
	GtkRequisition _tmp9_ = {0};
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GtkAllocation _tmp12_ = {0};
	gint _tmp13_ = 0;
	GtkAllocation _tmp14_ = {0};
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GtkRequisition _tmp17_ = {0};
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	PixbufButton* _tmp20_ = NULL;
	GtkAllocation _tmp21_ = {0};
	PixbufButton* _tmp22_ = NULL;
	GtkRequisition _tmp23_ = {0};
	gint _tmp24_ = 0;
	GtkAllocation _tmp25_ = {0};
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	GtkAllocation _tmp28_ = {0};
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	PixbufButton* _tmp32_ = NULL;
	GtkAllocation _tmp33_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (avatar_banner_widget_parent_class)->size_allocate (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), gtk_widget_get_type (), GtkWidget), &_tmp0_);
	memset (&child_allocation, 0, sizeof (GtkAllocation));
	_tmp1_ = self->priv->set_banner_button;
	gtk_widget_get_preferred_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), &_tmp2_, NULL);
	child_requisition = _tmp2_;
	_tmp3_ = *allocation;
	_tmp4_ = _tmp3_.x;
	child_allocation.x = _tmp4_;
	_tmp5_ = *allocation;
	_tmp6_ = _tmp5_.y;
	child_allocation.y = _tmp6_;
	_tmp7_ = *allocation;
	_tmp8_ = _tmp7_.width;
	_tmp9_ = child_requisition;
	_tmp10_ = _tmp9_.width;
	_tmp11_ = MAX (_tmp8_, _tmp10_);
	child_allocation.width = _tmp11_;
	_tmp12_ = *allocation;
	_tmp13_ = _tmp12_.width;
	child_allocation.height = (gint) (_tmp13_ * AVATAR_BANNER_WIDGET_BANNER_RATIO);
	_tmp14_ = *allocation;
	_tmp15_ = _tmp14_.height;
	_tmp16_ = self->priv->_avatar_size;
	_tmp17_ = child_requisition;
	_tmp18_ = _tmp17_.height;
	_tmp19_ = MAX (_tmp15_ - (_tmp16_ / 2), _tmp18_);
	child_allocation.height = _tmp19_;
	_tmp20_ = self->priv->set_banner_button;
	_tmp21_ = child_allocation;
	gtk_widget_size_allocate (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), &_tmp21_);
	_tmp22_ = self->priv->set_avatar_button;
	gtk_widget_get_preferred_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), &_tmp23_, NULL);
	child_requisition = _tmp23_;
	_tmp24_ = avatar_banner_widget_get_avatar_x (self);
	_tmp25_ = *allocation;
	_tmp26_ = _tmp25_.x;
	child_allocation.x = _tmp24_ + _tmp26_;
	_tmp27_ = avatar_banner_widget_get_avatar_y (self);
	_tmp28_ = *allocation;
	_tmp29_ = _tmp28_.y;
	child_allocation.y = _tmp27_ + _tmp29_;
	_tmp30_ = self->priv->_avatar_size;
	child_allocation.width = _tmp30_;
	_tmp31_ = self->priv->_avatar_size;
	child_allocation.height = _tmp31_;
	_tmp32_ = self->priv->set_avatar_button;
	_tmp33_ = child_allocation;
	gtk_widget_size_allocate (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget), &_tmp33_);
}


static void avatar_banner_widget_real_add (GtkContainer* base, GtkWidget* w) {
	AvatarBannerWidget * self;
	GtkWidget* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_widget_set_parent (_tmp0_, (GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer));
}


static void avatar_banner_widget_real_remove (GtkContainer* base, GtkWidget* w) {
	AvatarBannerWidget * self;
	GtkWidget* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	gtk_widget_unparent (_tmp0_);
}


static void avatar_banner_widget_real_forall_internal (GtkContainer* base, gboolean include_internals, GtkCallback cb, void* cb_target) {
	AvatarBannerWidget * self;
	GtkCallback _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	PixbufButton* _tmp1_ = NULL;
	GtkCallback _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	PixbufButton* _tmp3_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	_tmp1_ = self->priv->set_banner_button;
	_tmp0_ (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), _tmp0__target);
	_tmp2_ = cb;
	_tmp2__target = cb_target;
	_tmp3_ = self->priv->set_avatar_button;
	_tmp2_ (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), _tmp2__target);
}


static void avatar_banner_widget_banner_clicked_cb (AvatarBannerWidget* self) {
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	g_signal_emit_by_name (self, "banner-clicked");
}


static void avatar_banner_widget_avatar_clicked_cb (AvatarBannerWidget* self) {
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	g_signal_emit_by_name (self, "avatar-clicked");
}


void avatar_banner_widget_set_avatar (AvatarBannerWidget* self, GdkPixbuf* avatar) {
	PixbufButton* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	g_return_if_fail (GDK_IS_PIXBUF (avatar));
	_tmp0_ = self->priv->set_avatar_button;
	_tmp1_ = avatar;
	pixbuf_button_set_pixbuf (_tmp0_, _tmp1_);
}


void avatar_banner_widget_set_banner (AvatarBannerWidget* self, GdkPixbuf* banner) {
	PixbufButton* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	g_return_if_fail (GDK_IS_PIXBUF (banner));
	_tmp0_ = self->priv->set_banner_button;
	_tmp1_ = banner;
	pixbuf_button_set_pixbuf (_tmp0_, _tmp1_);
}


AvatarBannerWidget* avatar_banner_widget_construct (GType object_type) {
	AvatarBannerWidget * self = NULL;
	self = (AvatarBannerWidget*) g_object_new (object_type, NULL);
	return self;
}


AvatarBannerWidget* avatar_banner_widget_new (void) {
	return avatar_banner_widget_construct (TYPE_AVATAR_BANNER_WIDGET);
}


gint avatar_banner_widget_get_avatar_size (AvatarBannerWidget* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (IS_AVATAR_BANNER_WIDGET (self), 0);
	_tmp0_ = self->priv->_avatar_size;
	result = _tmp0_;
	return result;
}


void avatar_banner_widget_set_avatar_size (AvatarBannerWidget* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (IS_AVATAR_BANNER_WIDGET (self));
	_tmp0_ = value;
	self->priv->_avatar_size = _tmp0_;
	g_object_notify ((GObject *) self, "avatar-size");
}


static void _avatar_banner_widget_banner_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	avatar_banner_widget_banner_clicked_cb ((AvatarBannerWidget*) self);
}


static void _avatar_banner_widget_avatar_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	avatar_banner_widget_avatar_clicked_cb ((AvatarBannerWidget*) self);
}


static GObject * avatar_banner_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AvatarBannerWidget * self;
	GtkStyleContext* _tmp0_ = NULL;
	PixbufButton* _tmp1_ = NULL;
	PixbufButton* _tmp2_ = NULL;
	PixbufButton* _tmp3_ = NULL;
	PixbufButton* _tmp4_ = NULL;
	PixbufButton* _tmp5_ = NULL;
	PixbufButton* _tmp6_ = NULL;
	PixbufButton* _tmp7_ = NULL;
	PixbufButton* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	GSettings* _tmp10_ = NULL;
	PixbufButton* _tmp11_ = NULL;
	parent_class = G_OBJECT_CLASS (avatar_banner_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp0_ = gtk_widget_get_style_context (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	gtk_style_context_add_class (_tmp0_, "avatar");
	_tmp1_ = pixbuf_button_new (FALSE, NULL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->set_banner_button);
	self->priv->set_banner_button = _tmp1_;
	_tmp2_ = self->priv->set_banner_button;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	_tmp3_ = self->priv->set_banner_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _avatar_banner_widget_banner_clicked_cb_gtk_button_clicked, self, 0);
	_tmp4_ = self->priv->set_banner_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = pixbuf_button_new (FALSE, NULL);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->set_avatar_button);
	self->priv->set_avatar_button = _tmp5_;
	_tmp6_ = self->priv->set_avatar_button;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	_tmp7_ = self->priv->set_avatar_button;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_button_get_type (), GtkButton), "clicked", (GCallback) _avatar_banner_widget_avatar_clicked_cb_gtk_button_clicked, self, 0);
	_tmp8_ = self->priv->set_avatar_button;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
	_tmp9_ = settings_get ();
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->set_avatar_button;
	g_settings_bind (_tmp10_, "round-avatars", G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, G_TYPE_OBJECT, GObject), "round", G_SETTINGS_BIND_DEFAULT);
	_g_object_unref0 (_tmp10_);
	return obj;
}


static void avatar_banner_widget_class_init (AvatarBannerWidgetClass * klass) {
	avatar_banner_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AvatarBannerWidgetPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*)(GtkWidget*, cairo_t*)) avatar_banner_widget_real_draw;
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*)(GtkWidget*)) avatar_banner_widget_real_get_request_mode;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*)(GtkWidget*, gint*, gint*)) avatar_banner_widget_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height_for_width = (void (*)(GtkWidget*, gint, gint*, gint*)) avatar_banner_widget_real_get_preferred_height_for_width;
	((GtkWidgetClass *) klass)->size_allocate = (void (*)(GtkWidget*, GtkAllocation*)) avatar_banner_widget_real_size_allocate;
	((GtkContainerClass *) klass)->add = (void (*)(GtkContainer*, GtkWidget*)) avatar_banner_widget_real_add;
	((GtkContainerClass *) klass)->remove = (void (*)(GtkContainer*, GtkWidget*)) avatar_banner_widget_real_remove;
	((GtkContainerClass *) klass)->forall = (void (*)(GtkContainer*, gboolean, GtkCallback, void*)) avatar_banner_widget_real_forall_internal;
	G_OBJECT_CLASS (klass)->get_property = _vala_avatar_banner_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_avatar_banner_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = avatar_banner_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = avatar_banner_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AVATAR_BANNER_WIDGET_AVATAR_SIZE, g_param_spec_int ("avatar-size", "avatar-size", "avatar-size", G_MININT, G_MAXINT, 48, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("avatar_changed", TYPE_AVATAR_BANNER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gdk_pixbuf_get_type ());
	g_signal_new ("banner_changed", TYPE_AVATAR_BANNER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, gdk_pixbuf_get_type ());
	g_signal_new ("avatar_clicked", TYPE_AVATAR_BANNER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("banner_clicked", TYPE_AVATAR_BANNER_WIDGET, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void avatar_banner_widget_instance_init (AvatarBannerWidget * self) {
	self->priv = AVATAR_BANNER_WIDGET_GET_PRIVATE (self);
	self->priv->_avatar_size = 48;
}


static void avatar_banner_widget_finalize (GObject* obj) {
	AvatarBannerWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	_g_object_unref0 (self->priv->set_banner_button);
	_g_object_unref0 (self->priv->set_avatar_button);
	G_OBJECT_CLASS (avatar_banner_widget_parent_class)->finalize (obj);
}


GType avatar_banner_widget_get_type (void) {
	static volatile gsize avatar_banner_widget_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_banner_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarBannerWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_banner_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarBannerWidget), 0, (GInstanceInitFunc) avatar_banner_widget_instance_init, NULL };
		GType avatar_banner_widget_type_id;
		avatar_banner_widget_type_id = g_type_register_static (gtk_container_get_type (), "AvatarBannerWidget", &g_define_type_info, 0);
		g_once_init_leave (&avatar_banner_widget_type_id__volatile, avatar_banner_widget_type_id);
	}
	return avatar_banner_widget_type_id__volatile;
}


static void _vala_avatar_banner_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AvatarBannerWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	switch (property_id) {
		case AVATAR_BANNER_WIDGET_AVATAR_SIZE:
		g_value_set_int (value, avatar_banner_widget_get_avatar_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_avatar_banner_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AvatarBannerWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_AVATAR_BANNER_WIDGET, AvatarBannerWidget);
	switch (property_id) {
		case AVATAR_BANNER_WIDGET_AVATAR_SIZE:
		avatar_banner_widget_set_avatar_size (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



