/***************************************************************************
 *                                  _   _ ____  _
 *  Project                     ___| | | |  _ \| |
 *                             / __| | | | |_) | |
 *                            | (__| |_| |  _ <| |___
 *                             \___|\___/|_| \_\_____|
 *
 * Copyright (C) Daniel Stenberg, <daniel@haxx.se>, et al.
 *
 * This software is licensed as described in the file COPYING, which
 * you should have received as part of this distribution. The terms
 * are also available at https://curl.se/docs/copyright.html.
 *
 * You may opt to use, copy, modify, merge, publish, distribute and/or sell
 * copies of the Software, and permit persons to whom the Software is
 * furnished to do so, under the terms of the COPYING file.
 *
 * This software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY
 * KIND, either express or implied.
 *
 * SPDX-License-Identifier: curl
 *
 ***************************************************************************/
#include "first.h"

#include "memdebug.h"

static const char *ldata_names[] = {
  "NONE",
  "SHARE",
  "COOKIE",
  "DNS",
  "SESSION",
  "CONNECT",
  "PSL",
  "HSTS",
  "NULL",
};

static void t1554_test_lock(CURL *handle, curl_lock_data data,
                            curl_lock_access laccess, void *useptr)
{
  (void)handle;
  (void)data;
  (void)laccess;
  (void)useptr;
  curl_mprintf("-> Mutex lock %s\n", ldata_names[data]);
}

static void t1554_test_unlock(CURL *handle, curl_lock_data data, void *useptr)
{
  (void)handle;
  (void)data;
  (void)useptr;
  curl_mprintf("<- Mutex unlock %s\n", ldata_names[data]);
}

/* test function */
static CURLcode test_lib1554(char *URL)
{
  CURLcode res = CURLE_OK;
  CURLSH *share = NULL;
  int i;

  global_init(CURL_GLOBAL_ALL);

  share = curl_share_init();
  if(!share) {
    curl_mfprintf(stderr, "curl_share_init() failed\n");
    goto test_cleanup;
  }

  curl_share_setopt(share, CURLSHOPT_SHARE, CURL_LOCK_DATA_CONNECT);
  curl_share_setopt(share, CURLSHOPT_LOCKFUNC, t1554_test_lock);
  curl_share_setopt(share, CURLSHOPT_UNLOCKFUNC, t1554_test_unlock);

  /* Loop the transfer and cleanup the handle properly every lap. This will
     still reuse connections since the pool is in the shared object! */

  for(i = 0; i < 3; i++) {
    CURL *curl = curl_easy_init();
    if(curl) {
      curl_easy_setopt(curl, CURLOPT_URL, URL);

      /* use the share object */
      curl_easy_setopt(curl, CURLOPT_SHARE, share);

      /* Perform the request, res will get the return code */
      res = curl_easy_perform(curl);

      /* always cleanup */
      curl_easy_cleanup(curl);

      /* Check for errors */
      if(res != CURLE_OK) {
        curl_mfprintf(stderr, "curl_easy_perform() failed: %s\n",
                      curl_easy_strerror(res));
        goto test_cleanup;
      }
    }
  }

test_cleanup:
  curl_share_cleanup(share);
  curl_global_cleanup();

  return res;
}
