-- SQL SQLITE
CREATE TABLE spatial_ref_sys(srid INTEGER PRIMARY KEY,auth_name,auth_srid,ref_sys_name,proj4text,srtext);
INSERT INTO spatial_ref_sys VALUES(26711,'epsg',26711,'','','PROJCS["",GEOGCS["",DATUM["North_American_Datum_1927",SPHEROID["Clarke 1866",6378206.4,294.9786982138982]],PRIMEM["Greenwich",0],UNIT["degree",0.0174532925199433]],PROJECTION["Transverse_Mercator"],PARAMETER["central_meridian",-117],PARAMETER["scale_factor",0.9996],PARAMETER["false_easting",500000],UNIT["meter",1],AUTHORITY["EPSG","26711"]]');
CREATE TABLE geometry_columns(f_table_name,f_geometry_column,geometry_type,coord_dimension,srid,spatial_index_enabled);
INSERT INTO geometry_columns VALUES('byte_sections','geometry',3,2,26711,1);
INSERT INTO geometry_columns VALUES('byte_tiles','geometry',3,2,26711,1);
CREATE TABLE raster_coverages(coverage_name PRIMARY KEY,title,abstract,sample_type,pixel_type,num_bands,compression,quality,tile_width,tile_height,horz_resolution,vert_resolution,srid,nodata_pixel,palette,statistics,geo_minx,geo_miny,geo_maxx,geo_maxy,extent_minx,extent_miny,extent_maxx,extent_maxy,strict_resolution,mixed_resolutions,section_paths,section_md5,section_summary,is_queryable,red_band_index,green_band_index,blue_band_index,nir_band_index,enable_auto_ndvi);
INSERT INTO raster_coverages VALUES('byte','','','UINT8','GRAYSCALE',1,'DEFLATE',100,512,512,60.0,60.0,26711,X'000301A513010006FF265CF5B8FE23',NULL,NULL,NULL,NULL,NULL,NULL,440720.0,3750120.0,441920.0,3751320.0,1,0,0,0,0,0,NULL,NULL,NULL,NULL,NULL);
CREATE TABLE raster_coverages_srid(coverage_name,srid,extent_minx,extent_miny,extent_maxx,extent_maxy);
CREATE TABLE byte_levels(pyramid_level INTEGER PRIMARY KEY,x_resolution_1_1,y_resolution_1_1,x_resolution_1_2,y_resolution_1_2,x_resolution_1_4,y_resolution_1_4,x_resolution_1_8,y_resolution_1_8);
INSERT INTO byte_levels VALUES(0,60.0,60.0,120.0,120.0,240.0,240.0,480.0,480.0);
-- CREATE TABLE byte_sections(section_id INTEGER PRIMARY KEY,section_name,width,height,file_path,md5_checksum,summary,statistics,geometry POLYGON);
-- INSERT INTO byte_sections VALUES(1,'byte',20,20,NULL,NULL,NULL,NULL,X'0001576800000000000040E61A4100000000749C4C410000000000F91A4100000000CC9E4C417C0300000001000000050000000000000040E61A4100000000749C4C410000000000F91A4100000000749C4C410000000000F91A4100000000CC9E4C410000000040E61A4100000000CC9E4C410000000040E61A4100000000749C4C41FE');
-- CREATE VIRTUAL TABLE idx_byte_sections_geometry USING rtree(pkid, xmin, xmax, ymin, ymax);
-- INSERT INTO idx_byte_sections_geometry SELECT section_id, ST_MinX(geometry), ST_MaxX(geometry), ST_MinY(geometry), ST_MaxY(geometry) FROM byte_sections;
CREATE TABLE byte_tiles(tile_id INTEGER PRIMARY KEY,pyramid_level,section_id,geometry POLYGON);
INSERT INTO byte_tiles VALUES(1,0,1,X'0001576800000000000040E61A4100000000CC624C410000000040C61C4100000000CC9E4C417C0300000001000000050000000000000040E61A4100000000CC624C410000000040C61C4100000000CC624C410000000040C61C4100000000CC9E4C410000000040E61A4100000000CC9E4C410000000040E61A4100000000CC624C41FE');
CREATE VIRTUAL TABLE idx_byte_tiles_geometry USING rtree(pkid, xmin, xmax, ymin, ymax);
INSERT INTO idx_byte_tiles_geometry SELECT tile_id, ST_MinX(geometry), ST_MaxX(geometry), ST_MinY(geometry), ST_MaxY(geometry) FROM byte_tiles;
CREATE TABLE byte_tile_data(tile_id INTEGER PRIMARY KEY,tile_data_odd,tile_data_even);
INSERT INTO byte_tile_data VALUES(1,X'00FA0122A51301000200020002000100000200720100000000000000000000C8789CEDD7A1B6D4301405D02B5397BA46560E9F8144F21BE01E0EE4C381E4339EC581C3CEB8672B33AE718DA47C00B615B3B7893D6BDD959B9C0F7958C7483DA2965AA2E67EE91F8347F134A6BEF5B2CC75DC5A89357AEA3FCE0EC5619EA7FB7EF9D78854EA9BD7A1469996AF6787E2307FEEB5475FE67D07F4D88FE172EDDFCF0EC5613EF7714DFFBE005B0C4B6ED3B0BF00F6FFE3788ED8EEF3D62EB79CC6F9DA724433FFC7F1526F53B47C4FEFDBEF14BD5F96B7CBA7B34371986FCB7CDD2BC03A4C7B054CB11781DBFCE5EC501CE6575BA25CC7D721D721529F9754C2FC1FC7CBBB74FB59E7B5B439D6DEB7965BD6FF0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000F89FBF6E9F6101C9B6B7A3BF366AF0',X'00DB0122A51301000200020001A3BF366A0000020075010000C8789CEDD7A19AD4301406D02B332E75131939168745227906DE6071EC232C6E70ACC4E2906071BBB2B232E31AD74ACA03605B31E7B844FDDF97E4DE9B87A1E532BD7929538E5B5D4E11D3DB8FC1BDB8F625D6219635ADA9A73AA6D286C7A343B19B5F3D5A4CB5F5320FE73FE7ED2ABC7FFE7A742876736D653BFD61EE6998B70A70BE7DF8919CFFFD788AF132E6D44BDB1A403A2D3D9F42FDBF1F9F237A9D638D36BCFBBDADD7BAAC5F8E0EC56EAE5BFFCFB7C8BD4E9756DBF60528EBA7A343B19BEF739A7A442A63EE91B621A055EFFF8E7C2B637D394D39BD5EFA79C8B7DA627C3E3A14BBF9196D4D11E5354F43FBB791BAF91F0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000080FFFA0B1A7B5C01C9BC493FB5D0');
CREATE VIRTUAL TABLE SpatialIndex USING VirtualSpatialIndex();
