/* $Id: d_mos4.model,v 26.92 2008/08/23 05:40:00 al Exp $ -*- C++ -*-
 * Copyright (C) 2001 Albert Davis
 * Author: Albert Davis <aldavis@gnu.org>
 *
 * This file is part of "Gnucap", the Gnu Circuit Analysis Package
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *------------------------------------------------------------------
 * MOS BSIM1 model.
 * derived from Spice3f4,Copyright 1990 Regents of the University of California
 * 1985 Hong J. Park, Thomas L. Quarles
 * Recoded for Gnucap model compiler, Al Davis, 2000
 */
/* This file is automatically generated. DO NOT EDIT */
#ifndef D_MOS4_H_INCLUDED
#define D_MOS4_H_INCLUDED

#include "d_mos_base.h"
#include "u_sdp.h"
#include "e_node.h"
#include "e_subckt.h"
#include "e_model.h"
/*--------------------------------------------------------------------------*/
class SDP_BUILT_IN_MOS4
  :public SDP_BUILT_IN_MOS_BASE{
public:
  explicit SDP_BUILT_IN_MOS4(const COMMON_COMPONENT* c) : SDP_BUILT_IN_MOS_BASE(c) {init(c);}
  void init(const COMMON_COMPONENT*);
public:
  double phi;	// Strong inversion surface potential
  double vfb;	// Flat band voltage
  double k1;	// Bulk effect coefficient 1
  double k2;	// Bulk effect coefficient 2
  double eta;	// VDS dependence of threshold voltage
  double etaB;	// VBS dependence of eta (x2e)
  double etaD;	// VDS dependence of eta (x3e)
  double mobZero;	// Zero field mobility at VDS=0 VGS=VTH (muz)
  double mobZeroB;	// VBS dependence of muz (x2mz)
  double mobVdd;	// Mobility @ VDS=VDD VGS=VTH, chan len modulation
  double mobVddB;	// VBS dependence of mus (x2ms)
  double mobVddD;	// VDS dependence of mus (x3ms)
  double ugs;	// VGS dependence of mobility (u0)
  double ugsB;	// VBS dependence of u0 (x2u0)
  double uds;	// VDS dependence of mobility, velocity saturation
  double udsB;	// VBS dependence of u1 (x2u1)
  double udsD;	// VDS dependence of u1 (x3u1)
  double n0;	// Subthreshold slope (n0)
  double nB;	// VBS dependence of subthreshold slope (nb)
  double nD;	// VDS dependence of subthreshold slope (nd)
  double betaZero;	// Beta at vds = 0 and vgs = Vth
  double betaZeroB;	// Vbs dependence of BetaZero
  double betaVdd;	// Beta at vds=Vdd and vgs=Vth
  double betaVddB;	// Vbs dependence of BVdd
  double betaVddD;	// Vds dependence of BVdd
  double vt0;	// 
};
/*--------------------------------------------------------------------------*/
class DEV_BUILT_IN_MOS;
class TDP_BUILT_IN_MOS4
  :public TDP_BUILT_IN_MOS_BASE{
public:
  explicit TDP_BUILT_IN_MOS4(const DEV_BUILT_IN_MOS*);
public:
};
/*--------------------------------------------------------------------------*/
class MODEL_BUILT_IN_MOS4
  :public MODEL_BUILT_IN_MOS_BASE{
protected:
  explicit MODEL_BUILT_IN_MOS4(const MODEL_BUILT_IN_MOS4& p);
public:
  explicit MODEL_BUILT_IN_MOS4(const BASE_SUBCKT*);
  ~MODEL_BUILT_IN_MOS4() {--_count;}
public: // override virtual
  std::string dev_type()const;
  void      set_dev_type(const std::string& nt);
  CARD*     clone()const {return new MODEL_BUILT_IN_MOS4(*this);}
  void      precalc_first();
  void      precalc_last();
  SDP_CARD* new_sdp(COMMON_COMPONENT* c)const;
  void      set_param_by_index(int, std::string&, int);
  bool      param_is_printable(int)const;
  std::string param_name(int)const;
  std::string param_name(int,int)const;
  std::string param_value(int)const;
  int param_count()const {return (95 + MODEL_BUILT_IN_MOS_BASE::param_count());}
  bool      is_valid(const COMPONENT*)const;
  void      tr_eval(COMPONENT*)const;
public: // not virtual
  static int count() {return _count;}
private: // strictly internal
  static int _count;
public: // input parameters
  SDP phi;	// Strong inversion surface potential
  SDP vfb;	// Flat band voltage
  SDP k1;	// Bulk effect coefficient 1
  SDP k2;	// Bulk effect coefficient 2
  SDP eta;	// VDS dependence of threshold voltage
  SDP etaB;	// VBS dependence of eta (x2e)
  SDP etaD;	// VDS dependence of eta (x3e)
  SDP mobZero;	// Zero field mobility at VDS=0 VGS=VTH (muz)
  SDP mobZeroB;	// VBS dependence of muz (x2mz)
  SDP mobVdd;	// Mobility @ VDS=VDD VGS=VTH, chan len modulation
  SDP mobVddB;	// VBS dependence of mus (x2ms)
  SDP mobVddD;	// VDS dependence of mus (x3ms)
  SDP ugs;	// VGS dependence of mobility (u0)
  SDP ugsB;	// VBS dependence of u0 (x2u0)
  SDP uds;	// VDS dependence of mobility, velocity saturation
  SDP udsB;	// VBS dependence of u1 (x2u1)
  SDP udsD;	// VDS dependence of u1 (x3u1)
  SDP n0;	// Subthreshold slope (n0)
  SDP nB;	// VBS dependence of subthreshold slope (nb)
  SDP nD;	// VDS dependence of subthreshold slope (nd)
  PARAMETER<double> dl_u;	// Channel length reduction
  PARAMETER<double> dw_u;	// Channel width reduction
  PARAMETER<double> tox_u;	// Gate oxide thickness
  PARAMETER<double> vdd;	// Supply voltage to specify mus
  PARAMETER<double> wdf;	// Default width of source drain diffusion (ignored)
  PARAMETER<double> dell;	// Length reduction of source drain diff (ignored)
  PARAMETER<double> temp;	// temperature (ignored)
  PARAMETER<double> xpart;	// Flag for channel charge partitioning
public: // calculated parameters
  double dl;	// 
  double dw;	// 
  double tox;	// 
  double cox;	// 
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
