
MACRO (GNC_CONFIGURE _INPUT _OUTPUT)
  FILE(READ ${_INPUT} FILE_CONTENTS_IN_IN)
  SET(FILE_CONTENTS_IN "${FILE_CONTENTS_IN_IN}")
  STRING(REGEX REPLACE "@-|-@" "@" _TMP2 "${FILE_CONTENTS_IN}")
  STRING(CONFIGURE "${_TMP2}" FILE_CONTENTS @ONLY)
  SET(_OUTPUT_FILE ${_OUTPUT})
  IF (NOT IS_ABSOLUTE ${_OUTPUT})
    SET(_OUTPUT_FILE ${CMAKE_CURRENT_BINARY_DIR}/${_OUTPUT})
  ENDIF()
  FILE(WRITE ${_OUTPUT_FILE} "${FILE_CONTENTS}")
ENDMACRO()


MACRO (GNC_CONFIGURE2 _TARGET _INPUT _OUTPUT)

  SET(_TMPDIR ${CMAKE_CURRENT_BINARY_DIR}${CMAKE_FILES_DIRECTORY})
  FILE(READ ${_INPUT} FILE_CONTENTS_IN_IN)
  SET(FILE_CONTENTS_IN "${FILE_CONTENTS_IN_IN}")
  STRING(REGEX REPLACE "@-|-@" "@" _TMP2 "${FILE_CONTENTS_IN}")
  FILE(WRITE ${_TMPDIR}/${_INPUT}.tmp "${_TMP2}")

  FILE(WRITE ${_TMPDIR}/${_INPUT}.cmake
    "SET(PERL ${PERL_EXECUTABLE})
     SET(VERSION ${VERSION})
     SET(GNC_HELPDIR \"${GNC_HELPDIR}\")
     SET(GETTEXT_PACKAGE ${GETTEXT_PACKAGE})
     CONFIGURE_FILE(\${SRC} \${DST} @ONLY)")

  SET(_OUTPUT_FILE ${_OUTPUT})
  IF (NOT IS_ABSOLUTE ${_OUTPUT})
    SET(_OUTPUT_FILE ${CMAKE_CURRENT_BINARY_DIR}/${_OUTPUT})
  ENDIF()

  ADD_CUSTOM_COMMAND(
    OUTPUT ${_OUTPUT_FILE}
    COMMAND ${CMAKE_COMMAND} -D SRC=${_TMPDIR}/${_INPUT}.tmp
                             -D DST=${_OUTPUT_FILE}
                             -P ${_TMPDIR}/${_INPUT}.cmake
    DEPENDS ${CMAKE_CURRENT_SOURCE_DIR}/${_INPUT}
    )

  ADD_CUSTOM_TARGET(${_TARGET} DEPENDS ${_OUTPUT_FILE})
ENDMACRO()
