/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This is GNU Go, a Go program. Contact gnugo@gnu.org, or see       *
 * http://www.gnu.org/software/gnugo/ for more information.          *
 *                                                                   *
 * Copyright 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,   *
 * 2008 and 2009 by the Free Software Foundation.                    *
 *                                                                   *
 * This program is free software; you can redistribute it and/or     *
 * modify it under the terms of the GNU General Public License as    *
 * published by the Free Software Foundation - version 3 or          *
 * (at your option) any later version.                               *
 *                                                                   *
 * This program is distributed in the hope that it will be useful,   *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *
 * GNU General Public License in file COPYING for more details.      *
 *                                                                   *
 * You should have received a copy of the GNU General Public         *
 * License along with this program; if not, write to the Free        *
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,       *
 * Boston, MA 02111, USA.                                            *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <stdio.h> /* for NULL */
#include "liberty.h"
#include "patterns.h"

static struct corner_pattern joseki[1623];

static int
autohelperjoseki264(int trans, int move, int color, int action)
{
  int A, B;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(647, trans, move);
  B = AFFINE_TRANSFORM(684, trans, move);

  return !play_attack_defend_n(OTHER_COLOR(color), 1, 1, A, B);
}

static int
autohelperjoseki282(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(649, trans, move);

  return (whose_moyo(OPPOSITE_INFLUENCE(color), A) == color);
}

static int
autohelperjoseki283(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(687, trans, move);

  return !dragon_weak(A) || (dragon[A].status == DEAD);
}

static int
autohelperjoseki350(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(721, trans, move);

  return  !(whose_territory(OPPOSITE_INFLUENCE(color), A) == color);
}

static int
autohelperjoseki672(int trans, int move, int color, int action)
{
  int A, B, C;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(758, trans, move);
  B = AFFINE_TRANSFORM(683, trans, move);
  C = AFFINE_TRANSFORM(722, trans, move);

  return !play_attack_defend_n(color, 1, 3, move, A, B, C);
}

static int
autohelperjoseki680(int trans, int move, int color, int action)
{
  int A, B, C;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(610, trans, move);
  B = AFFINE_TRANSFORM(609, trans, move);
  C = AFFINE_TRANSFORM(648, trans, move);

  return !play_attack_defend_n(color, 1, 3, A, move, B, C);
}

static int
autohelperjoseki1149(int trans, int move, int color, int action)
{
  int A, B, C, D, E, F, G, H, I, J, K, L, M;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(572, trans, move);
  B = AFFINE_TRANSFORM(536, trans, move);
  C = AFFINE_TRANSFORM(571, trans, move);
  D = AFFINE_TRANSFORM(537, trans, move);
  E = AFFINE_TRANSFORM(575, trans, move);
  F = AFFINE_TRANSFORM(538, trans, move);
  G = AFFINE_TRANSFORM(683, trans, move);
  H = AFFINE_TRANSFORM(648, trans, move);
  I = AFFINE_TRANSFORM(611, trans, move);
  J = AFFINE_TRANSFORM(576, trans, move);
  K = AFFINE_TRANSFORM(612, trans, move);
  L = AFFINE_TRANSFORM(649, trans, move);
  M = AFFINE_TRANSFORM(613, trans, move);

  return  play_attack_defend_n(OTHER_COLOR(color), 1, 13, A, B, C, D, E, F, G, H, I, J, K, L, M, M);
}

static int
autohelperjoseki1359(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(758, trans, move);

  return !(whose_area(OPPOSITE_INFLUENCE(color), A) == OTHER_COLOR(color));
}

static int
autohelperjoseki1618(int trans, int move, int color, int action)
{
  int A;
  UNUSED(color);
  UNUSED(action);

  A = AFFINE_TRANSFORM(430, trans, move);

  return !DEFEND_MACRO(A);
}

static int
autohelperjoseki1620(int trans, int move, int color, int action)
{
  UNUSED(trans);
  UNUSED(color);
  UNUSED(action);

  UNUSED(move);

  return safe_move(move, color);
}

static struct pattern_attribute attributes[] = {
#ifdef HAVE_TRANSPARENT_UNIONS
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=1.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {REVERSE_FOLLOWUP,{.value=10.000000}},
  {FOLLOWUP,{.value=15.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=0.015000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=-0.020000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=-0.020000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=6.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=6.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=6.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=6.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=8.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=8.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=6.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=6.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=6.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=8.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=6.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=8.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=3.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=8.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=5.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=5.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=8.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=8.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=5.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=5.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=5.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=8.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=10.000000}},
  {LAST_ATTRIBUTE,{.offset=0}},
  {SHAPE,{.value=5.000000}},
  {LAST_ATTRIBUTE,{.offset=0}}
#else
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,1.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {REVERSE_FOLLOWUP,10.000000,0},
  {FOLLOWUP,15.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,0.015000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,-0.020000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,-0.020000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,6.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,6.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,6.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,6.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,8.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,8.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,6.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,6.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,6.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,8.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,6.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,8.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,3.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,8.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,5.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,5.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,8.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,8.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,5.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,5.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,5.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,8.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,10.000000,0},
  {LAST_ATTRIBUTE,0.0,0},
  {SHAPE,5.000000,0},
  {LAST_ATTRIBUTE,0.0,0}
#endif
};

static struct corner_pattern joseki[] = {
  {986,0,0x820010,"JG1",attributes+0,0,NULL},
  {912,0,0x820010,"JG2",attributes+0,0,NULL},
  {988,0,0x820010,"JG3",attributes+0,0,NULL},
  {951,0,0x820010,"JG4",attributes+0,0,NULL},
  {914,0,0x820010,"JG5",attributes+0,0,NULL},
  {912,0,0x820010,"JG6",attributes+0,0,NULL},
  {875,0,0x900010,"JG7",attributes+0,0,NULL},
  {875,0,0x820010,"JG8",attributes+0,0,NULL},
  {875,0,0x900010,"JG9",attributes+0,0,NULL},
  {874,0,0x900010,"JG10",attributes+0,0,NULL},
  {874,0,0x900010,"JG11",attributes+0,0,NULL},
  {874,0,0x820010,"JG12",attributes+0,0,NULL},
  {875,0,0x820010,"JG13",attributes+0,0,NULL},
  {950,0,0x820010,"JG14",attributes+0,0,NULL},
  {911,0,0x820010,"JG15",attributes+0,0,NULL},
  {911,0,0x900010,"JG16",attributes+0,0,NULL},
  {911,0,0x900010,"JG17",attributes+0,0,NULL},
  {911,0,0x900010,"JG18",attributes+0,0,NULL},
  {874,0,0x900010,"JG19",attributes+0,0,NULL},
  {912,0,0x820010,"JG20",attributes+0,0,NULL},
  {874,0,0x900010,"JG21",attributes+0,0,NULL},
  {948,0,0x820010,"JG22",attributes+0,0,NULL},
  {876,0,0x820010,"JG23",attributes+0,0,NULL},
  {949,0,0x820010,"JG24",attributes+0,0,NULL},
  {912,0,0x820010,"JG25",attributes+0,0,NULL},
  {911,0,0x820010,"JG26",attributes+0,0,NULL},
  {985,0,0x820010,"JG27",attributes+0,0,NULL},
  {911,0,0x820010,"JG28",attributes+0,0,NULL},
  {985,0,0x820010,"JG29",attributes+0,0,NULL},
  {948,0,0x820010,"JG30",attributes+0,0,NULL},
  {948,0,0x820010,"JG31",attributes+0,0,NULL},
  {948,0,0x820010,"JG32",attributes+0,0,NULL},
  {948,0,0x820010,"JG33",attributes+0,0,NULL},
  {948,0,0x820010,"JG34",attributes+0,0,NULL},
  {948,0,0x820010,"JG35",attributes+0,0,NULL},
  {911,0,0x820010,"JG36",attributes+0,0,NULL},
  {948,0,0x820010,"JG37",attributes+0,0,NULL},
  {911,0,0x820010,"JG38",attributes+0,0,NULL},
  {948,0,0x820010,"JG39",attributes+0,0,NULL},
  {948,0,0x900010,"JG40",attributes+0,0,NULL},
  {948,0,0x820010,"JG41",attributes+0,0,NULL},
  {1022,0,0x820010,"JG42",attributes+0,0,NULL},
  {949,0,0x820010,"JG43",attributes+0,0,NULL},
  {985,0,0x820010,"JG44",attributes+0,0,NULL},
  {949,0,0x820010,"JG45",attributes+0,0,NULL},
  {910,0,0x820010,"JG46",attributes+0,0,NULL},
  {910,0,0x820010,"JG47",attributes+0,0,NULL},
  {910,0,0x820010,"JG48",attributes+0,0,NULL},
  {910,0,0x820010,"JG49",attributes+0,0,NULL},
  {910,0,0x820010,"JG50",attributes+0,0,NULL},
  {876,0,0x820010,"JG51",attributes+0,0,NULL},
  {875,0,0x820010,"JG52",attributes+0,0,NULL},
  {875,0,0x820010,"JG53",attributes+0,0,NULL},
  {876,0,0x820010,"JG54",attributes+0,0,NULL},
  {877,0,0x820010,"JG55",attributes+0,0,NULL},
  {877,0,0x820010,"JG56",attributes+0,0,NULL},
  {915,0,0x820010,"JG57",attributes+0,0,NULL},
  {913,0,0x840010,"JG58",attributes+0,0,NULL},
  {950,0,0x820010,"JG59",attributes+0,0,NULL},
  {910,0,0x820010,"JG60",attributes+0,0,NULL},
  {987,0,0x840010,"JG61",attributes+0,0,NULL},
  {985,0,0x820010,"JG62",attributes+0,0,NULL},
  {913,0,0x820010,"JG63",attributes+0,0,NULL},
  {985,0,0x820010,"JG64",attributes+0,0,NULL},
  {948,0,0x820010,"JG65",attributes+0,0,NULL},
  {1058,0,0x820010,"JG66",attributes+0,0,NULL},
  {913,0,0x820010,"JG67",attributes+0,0,NULL},
  {911,0,0x820010,"JG68",attributes+0,0,NULL},
  {874,0,0x900010,"JG69",attributes+0,0,NULL},
  {874,0,0x820010,"JG70",attributes+0,0,NULL},
  {911,0,0x820010,"JG71",attributes+0,0,NULL},
  {910,0,0x820010,"JG72",attributes+0,0,NULL},
  {910,0,0x820010,"JG73",attributes+0,0,NULL},
  {910,0,0x900010,"JG74",attributes+0,0,NULL},
  {948,0,0x820010,"JG75",attributes+0,0,NULL},
  {984,0,0x820010,"JG76",attributes+0,0,NULL},
  {986,0,0x820010,"JG77",attributes+0,0,NULL},
  {949,0,0x820010,"JG78",attributes+0,0,NULL},
  {912,0,0x820010,"JG79",attributes+0,0,NULL},
  {874,0,0x900010,"JG80",attributes+0,0,NULL},
  {875,0,0x900010,"JG81",attributes+0,0,NULL},
  {948,0,0x820010,"JG82",attributes+0,0,NULL},
  {874,0,0x820010,"JG83",attributes+0,0,NULL},
  {874,0,0x820010,"JG84",attributes+0,0,NULL},
  {839,0,0x1800010,"JG85",attributes+0,0,NULL},
  {839,0,0x820010,"JG86",attributes+0,0,NULL},
  {839,0,0x1800010,"JG87",attributes+0,0,NULL},
  {875,0,0x820010,"JG88",attributes+0,0,NULL},
  {948,0,0x820010,"JG89",attributes+0,0,NULL},
  {874,0,0x820010,"JG90",attributes+0,0,NULL},
  {912,0,0x820010,"JG91",attributes+0,0,NULL},
  {912,0,0x820010,"JG92",attributes+0,0,NULL},
  {875,0,0x900010,"JG93",attributes+0,0,NULL},
  {911,0,0x820010,"JG94",attributes+0,0,NULL},
  {911,0,0x900010,"JG95",attributes+0,0,NULL},
  {911,0,0x820010,"JG96",attributes+0,0,NULL},
  {911,0,0x820010,"JG97",attributes+0,0,NULL},
  {912,0,0x820010,"JG98",attributes+0,0,NULL},
  {911,0,0x820010,"JG99",attributes+1,0,NULL},
  {911,0,0x820010,"JG100",attributes+0,0,NULL},
  {874,0,0x820010,"JG101",attributes+0,0,NULL},
  {911,0,0x820010,"JG102",attributes+0,0,NULL},
  {912,0,0x820010,"JG103",attributes+0,0,NULL},
  {876,0,0x820010,"JG104",attributes+0,0,NULL},
  {949,0,0x820010,"JG105",attributes+0,0,NULL},
  {877,0,0x820010,"JG106",attributes+0,0,NULL},
  {1024,0,0x820010,"JG107",attributes+0,0,NULL},
  {915,0,0x840010,"JHK1",attributes+0,0,NULL},
  {915,0,0x820010,"JHK2",attributes+0,0,NULL},
  {876,0,0x820010,"JHK3",attributes+0,0,NULL},
  {876,0,0x900010,"JHK4",attributes+0,0,NULL},
  {915,0,0x820010,"JHK5",attributes+0,0,NULL},
  {915,0,0x820010,"JHK6",attributes+0,0,NULL},
  {915,0,0x820010,"JHK7",attributes+0,0,NULL},
  {915,0,0x820010,"JHK8",attributes+0,0,NULL},
  {915,0,0x1800010,"JHK9",attributes+0,0,NULL},
  {915,0,0x820010,"JHK10",attributes+0,0,NULL},
  {915,0,0x820010,"JHK11",attributes+0,0,NULL},
  {877,0,0x820010,"JHK12",attributes+0,0,NULL},
  {915,0,0x1800010,"JHK13",attributes+0,0,NULL},
  {877,0,0x820010,"JHK14",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK15",attributes+0,0,NULL},
  {915,0,0x820010,"JHK16",attributes+0,0,NULL},
  {914,0,0x820010,"JHK17",attributes+3,0,NULL},
  {914,0,0x820010,"JHK18",attributes+0,0,NULL},
  {914,0,0x820010,"JHK19",attributes+0,0,NULL},
  {914,0,0x820010,"JHK20",attributes+0,0,NULL},
  {914,0,0x820010,"JHK21",attributes+0,0,NULL},
  {914,0,0x820010,"JHK22",attributes+0,0,NULL},
  {915,0,0x820010,"JHK23",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK24",attributes+0,0,NULL},
  {914,0,0xa00010,"JHK25",attributes+0,0,NULL},
  {951,0,0x820010,"JHK26",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK27",attributes+0,0,NULL},
  {949,0,0x900010,"JHK28",attributes+0,0,NULL},
  {949,0,0x900010,"JHK29",attributes+0,0,NULL},
  {949,0,0x820010,"JHK30",attributes+0,0,NULL},
  {949,0,0x900010,"JHK31",attributes+0,0,NULL},
  {949,0,0x900010,"JHK32",attributes+0,0,NULL},
  {949,0,0x900010,"JHK33",attributes+0,0,NULL},
  {986,0,0x900010,"JHK34",attributes+0,0,NULL},
  {951,0,0x820010,"JHK35",attributes+0,0,NULL},
  {878,0,0x1800010,"JHK36",attributes+0,0,NULL},
  {915,0,0x820010,"JHK37",attributes+0,0,NULL},
  {916,0,0x820010,"JHK38",attributes+0,0,NULL},
  {917,0,0x1800010,"JHK39",attributes+0,0,NULL},
  {916,0,0x820010,"JHK40",attributes+0,0,NULL},
  {916,0,0x820010,"JHK41",attributes+0,0,NULL},
  {917,0,0x820010,"JHK42",attributes+0,0,NULL},
  {918,0,0x820010,"JHK43",attributes+0,0,NULL},
  {918,0,0x820010,"JHK44",attributes+0,0,NULL},
  {918,0,0x820010,"JHK45",attributes+0,0,NULL},
  {917,0,0x820010,"JHK46",attributes+0,0,NULL},
  {917,0,0x820010,"JHK47",attributes+0,0,NULL},
  {917,0,0x820010,"JHK48",attributes+0,0,NULL},
  {916,0,0x820010,"JHK49",attributes+0,0,NULL},
  {916,0,0x820010,"JHK50",attributes+0,0,NULL},
  {916,0,0x820010,"JHK51",attributes+0,0,NULL},
  {953,0,0x820010,"JHK52",attributes+0,0,NULL},
  {953,0,0x820010,"JHK53",attributes+0,0,NULL},
  {953,0,0x820010,"JHK54",attributes+0,0,NULL},
  {953,0,0x820010,"JHK55",attributes+0,0,NULL},
  {953,0,0x820010,"JHK56",attributes+0,0,NULL},
  {953,0,0x820010,"JHK57",attributes+0,0,NULL},
  {953,0,0x820010,"JHK58",attributes+0,0,NULL},
  {953,0,0x820010,"JHK59",attributes+0,0,NULL},
  {953,0,0x820010,"JHK60",attributes+0,0,NULL},
  {953,0,0x820010,"JHK61",attributes+0,0,NULL},
  {953,0,0x820010,"JHK62",attributes+0,0,NULL},
  {953,0,0x820010,"JHK63",attributes+0,0,NULL},
  {954,0,0x820010,"JHK64",attributes+0,0,NULL},
  {954,0,0x820010,"JHK65",attributes+0,0,NULL},
  {992,0,0x820010,"JHK66",attributes+0,0,NULL},
  {992,0,0x820010,"JHK67",attributes+0,0,NULL},
  {954,0,0x820010,"JHK68",attributes+0,0,NULL},
  {954,0,0x820010,"JHK69",attributes+0,0,NULL},
  {954,0,0x820010,"JHK70",attributes+0,0,NULL},
  {954,0,0x820010,"JHK71",attributes+0,0,NULL},
  {954,0,0x820010,"JHK72",attributes+0,0,NULL},
  {954,0,0x820010,"JHK73",attributes+0,0,NULL},
  {954,0,0x820010,"JHK74",attributes+0,0,NULL},
  {956,0,0x820010,"JHK75",attributes+0,0,NULL},
  {954,0,0x820010,"JHK76",attributes+0,0,NULL},
  {953,0,0x820010,"JHK77",attributes+0,0,NULL},
  {953,0,0x820010,"JHK78",attributes+0,0,NULL},
  {953,0,0x820010,"JHK79",attributes+0,0,NULL},
  {953,0,0x820010,"JHK80",attributes+0,0,NULL},
  {990,0,0x820010,"JHK81",attributes+0,0,NULL},
  {952,0,0x820010,"JHK82",attributes+0,0,NULL},
  {1027,0,0x820010,"JHK83",attributes+0,0,NULL},
  {1027,0,0x820010,"JHK84",attributes+0,0,NULL},
  {1027,0,0x820010,"JHK85",attributes+0,0,NULL},
  {1027,0,0x820010,"JHK86",attributes+0,0,NULL},
  {1028,0,0x820010,"JHK87",attributes+0,0,NULL},
  {954,0,0x820010,"JHK88",attributes+0,0,NULL},
  {954,0,0x820010,"JHK89",attributes+0,0,NULL},
  {954,0,0x820010,"JHK90",attributes+0,0,NULL},
  {953,0,0x820010,"JHK91",attributes+0,0,NULL},
  {954,0,0x820010,"JHK92",attributes+0,0,NULL},
  {953,0,0x820010,"JHK93",attributes+0,0,NULL},
  {953,0,0x820010,"JHK94",attributes+0,0,NULL},
  {953,0,0x820010,"JHK95",attributes+0,0,NULL},
  {953,0,0x820010,"JHK96",attributes+0,0,NULL},
  {914,0,0x820010,"JHK97",attributes+0,0,NULL},
  {914,0,0x820010,"JHK98",attributes+0,0,NULL},
  {914,0,0x820010,"JHK99",attributes+0,0,NULL},
  {988,0,0x880010,"JHK100",attributes+0,0,NULL},
  {989,0,0x820010,"JHK101",attributes+0,0,NULL},
  {989,0,0x820010,"JHK102",attributes+0,0,NULL},
  {989,0,0x820010,"JHK103",attributes+0,0,NULL},
  {989,0,0x820010,"JHK104",attributes+0,0,NULL},
  {988,0,0x820010,"JHK105",attributes+0,0,NULL},
  {915,0,0x1800010,"JHK106",attributes+0,0,NULL},
  {988,0,0x820010,"JHK107",attributes+0,0,NULL},
  {951,0,0x820010,"JHK108",attributes+0,0,NULL},
  {951,0,0x820010,"JHK109",attributes+0,0,NULL},
  {951,0,0x820010,"JHK110",attributes+0,0,NULL},
  {951,0,0x820010,"JHK111",attributes+0,0,NULL},
  {951,0,0x820010,"JHK112",attributes+0,0,NULL},
  {951,0,0x820010,"JHK113",attributes+0,0,NULL},
  {951,0,0x820010,"JHK114",attributes+0,0,NULL},
  {951,0,0x820010,"JHK115",attributes+0,0,NULL},
  {951,0,0x820010,"JHK116",attributes+0,0,NULL},
  {951,0,0x820010,"JHK117",attributes+0,0,NULL},
  {951,0,0x820010,"JHK118",attributes+0,0,NULL},
  {951,0,0x820010,"JHK119",attributes+0,0,NULL},
  {951,0,0x820010,"JHK120",attributes+0,0,NULL},
  {951,0,0x1800010,"JHK121",attributes+0,0,NULL},
  {951,0,0x1800010,"JHK122",attributes+0,0,NULL},
  {951,0,0x820010,"JHK123",attributes+0,0,NULL},
  {951,0,0x820010,"JHK124",attributes+0,0,NULL},
  {951,0,0x820010,"JHK125",attributes+0,0,NULL},
  {988,0,0x820010,"JHK126",attributes+0,0,NULL},
  {951,0,0x820010,"JHK127",attributes+0,0,NULL},
  {951,0,0x1800010,"JHK128",attributes+0,0,NULL},
  {951,0,0x1800010,"JHK129",attributes+0,0,NULL},
  {951,0,0x820010,"JHK130",attributes+0,0,NULL},
  {951,0,0x820010,"JHK131",attributes+0,0,NULL},
  {951,0,0x820010,"JHK132",attributes+0,0,NULL},
  {951,0,0x820010,"JHK133",attributes+0,0,NULL},
  {951,0,0x820010,"JHK134",attributes+0,0,NULL},
  {951,0,0x840010,"JHK135",attributes+0,0,NULL},
  {951,0,0x820010,"JHK136",attributes+0,0,NULL},
  {951,0,0x820010,"JHK137",attributes+0,0,NULL},
  {951,0,0x820010,"JHK138",attributes+0,0,NULL},
  {951,0,0x820010,"JHK139",attributes+0,0,NULL},
  {951,0,0x820010,"JHK140",attributes+0,0,NULL},
  {951,0,0x820010,"JHK141",attributes+0,0,NULL},
  {951,0,0x820010,"JHK142",attributes+0,0,NULL},
  {951,0,0x820010,"JHK143",attributes+0,0,NULL},
  {951,0,0x820010,"JHK144",attributes+0,0,NULL},
  {951,0,0x820010,"JHK145",attributes+0,0,NULL},
  {951,0,0x820010,"JHK146",attributes+0,0,NULL},
  {987,0,0x840010,"JHK147",attributes+0,0,NULL},
  {1061,0,0x880010,"JHK148",attributes+0,0,NULL},
  {1061,0,0x820010,"JHK149",attributes+0,0,NULL},
  {1061,0,0x820010,"JHK150",attributes+0,0,NULL},
  {915,0,0x840010,"JHK151",attributes+0,0,NULL},
  {914,0,0x840010,"JHK152",attributes+0,0,NULL},
  {915,0,0x820010,"JHK153",attributes+0,0,NULL},
  {915,0,0x820010,"JHK154",attributes+0,0,NULL},
  {915,0,0x820010,"JHK155",attributes+0,0,NULL},
  {915,0,0x820010,"JHK156",attributes+0,0,NULL},
  {952,0,0x820010,"JHK157",attributes+0,0,NULL},
  {915,0,0x820010,"JHK158",attributes+0,1,autohelperjoseki264},
  {915,0,0x820010,"JHK159",attributes+0,0,NULL},
  {915,0,0x820010,"JHK160",attributes+0,0,NULL},
  {915,0,0x820010,"JHK161",attributes+0,0,NULL},
  {915,0,0x820010,"JHK162",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK163",attributes+0,0,NULL},
  {952,0,0x820010,"JHK164",attributes+0,0,NULL},
  {952,0,0x820010,"JHK165",attributes+0,0,NULL},
  {952,0,0x820010,"JHK166",attributes+0,0,NULL},
  {952,0,0x840010,"JHK167",attributes+0,0,NULL},
  {952,0,0x820010,"JHK168",attributes+0,0,NULL},
  {952,0,0x820010,"JHK169",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK170",attributes+0,0,NULL},
  {915,0,0x820010,"JHK171",attributes+0,0,NULL},
  {913,0,0x820010,"JHK172",attributes+0,0,NULL},
  {878,0,0x820010,"JHK173",attributes+0,0,NULL},
  {878,0,0x880010,"JHK174",attributes+0,0,NULL},
  {1098,0,0x820010,"JHK175",attributes+0,0,NULL},
  {915,0,0x820010,"JHK176",attributes+0,1,autohelperjoseki282},
  {949,0,0x880010,"JHK177",attributes+0,1,autohelperjoseki283},
  {911,0,0x820010,"JHK178",attributes+0,0,NULL},
  {838,0,0x820010,"JHK179",attributes+0,0,NULL},
  {838,0,0x820010,"JHK180",attributes+0,0,NULL},
  {838,0,0x820010,"JHK181",attributes+0,0,NULL},
  {838,0,0x820010,"JHK182",attributes+0,0,NULL},
  {838,0,0x820010,"JHK183",attributes+0,0,NULL},
  {838,0,0x820010,"JHK184",attributes+0,0,NULL},
  {838,0,0x820010,"JHK185",attributes+0,0,NULL},
  {838,0,0x820010,"JHK186",attributes+0,0,NULL},
  {879,0,0x820010,"JHK187",attributes+0,0,NULL},
  {879,0,0x820010,"JHK188",attributes+0,0,NULL},
  {912,0,0x820010,"JHK189",attributes+0,0,NULL},
  {912,0,0x820010,"JHK190",attributes+0,0,NULL},
  {913,0,0x820010,"JHK191",attributes+0,0,NULL},
  {875,0,0x900010,"JHK192",attributes+0,0,NULL},
  {950,0,0x820010,"JHK193",attributes+0,0,NULL},
  {875,0,0x1800010,"JHK194",attributes+0,0,NULL},
  {875,0,0x820010,"JHK195",attributes+0,0,NULL},
  {875,0,0x820010,"JHK196",attributes+0,0,NULL},
  {875,0,0x820010,"JHK197",attributes+0,0,NULL},
  {875,0,0x820010,"JHK198",attributes+0,0,NULL},
  {876,0,0x820010,"JHK199",attributes+0,0,NULL},
  {875,0,0x820010,"JHK200",attributes+0,0,NULL},
  {913,0,0x820010,"JHK201",attributes+0,0,NULL},
  {876,0,0x820010,"JHK202",attributes+0,0,NULL},
  {913,0,0x820010,"JHK203",attributes+0,0,NULL},
  {913,0,0x820010,"JHK204",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK205",attributes+0,0,NULL},
  {913,0,0x820010,"JHK206",attributes+0,0,NULL},
  {914,0,0x820010,"JHK207",attributes+0,0,NULL},
  {913,0,0x820010,"JHK208",attributes+0,0,NULL},
  {914,0,0x820010,"JHK209",attributes+0,0,NULL},
  {914,0,0x820010,"JHK210",attributes+0,0,NULL},
  {914,0,0x820010,"JHK211",attributes+0,0,NULL},
  {911,0,0x820010,"JHK212",attributes+0,0,NULL},
  {911,0,0x820010,"JHK213",attributes+0,0,NULL},
  {911,0,0x820010,"JHK214",attributes+0,0,NULL},
  {913,0,0x1800010,"JHK215",attributes+0,0,NULL},
  {913,0,0x820010,"JHK216",attributes+0,0,NULL},
  {912,0,0x820010,"JHK217",attributes+0,0,NULL},
  {838,0,0x900010,"JHK218",attributes+0,0,NULL},
  {875,0,0x820010,"JHK219",attributes+0,0,NULL},
  {913,0,0x820010,"JHK220",attributes+0,0,NULL},
  {912,0,0x820010,"JHK221",attributes+0,0,NULL},
  {875,0,0x820010,"JHK222",attributes+0,0,NULL},
  {875,0,0x820010,"JHK223",attributes+0,0,NULL},
  {912,0,0x1800010,"JHK224",attributes+0,0,NULL},
  {913,0,0x820010,"JHK225",attributes+0,0,NULL},
  {912,0,0x1800010,"JHK226",attributes+0,0,NULL},
  {912,0,0x820010,"JHK227",attributes+0,0,NULL},
  {912,0,0x820010,"JHK228",attributes+0,0,NULL},
  {912,0,0x820010,"JHK229",attributes+0,0,NULL},
  {912,0,0x820010,"JHK230",attributes+0,0,NULL},
  {912,0,0x820010,"JHK231",attributes+0,0,NULL},
  {912,0,0x820010,"JHK232",attributes+0,0,NULL},
  {912,0,0x900010,"JHK233",attributes+0,0,NULL},
  {912,0,0x820010,"JHK234",attributes+0,0,NULL},
  {912,0,0x1800010,"JHK235",attributes+0,0,NULL},
  {917,0,0x820010,"JHK236",attributes+0,0,NULL},
  {917,0,0x900010,"JHK237",attributes+0,0,NULL},
  {915,0,0x840010,"JHK238",attributes+0,0,NULL},
  {914,0,0x900010,"JHK239",attributes+0,0,NULL},
  {913,0,0x900010,"JHK240",attributes+0,0,NULL},
  {914,0,0x900010,"JHK241",attributes+0,0,NULL},
  {913,0,0x900010,"JHK242",attributes+0,0,NULL},
  {879,0,0x900010,"JHK243",attributes+0,0,NULL},
  {916,0,0x900010,"JHK244",attributes+0,1,autohelperjoseki350},
  {879,0,0x820010,"JHK245",attributes+0,0,NULL},
  {913,0,0x900010,"JHK246",attributes+0,0,NULL},
  {913,0,0x820010,"JHK247",attributes+0,0,NULL},
  {950,0,0x820010,"JHK248",attributes+0,0,NULL},
  {1059,0,0x880010,"JHK249",attributes+0,0,NULL},
  {840,0,0x1800010,"JHK250",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK251",attributes+0,0,NULL},
  {914,0,0x900010,"JHK252",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK253",attributes+0,0,NULL},
  {914,0,0x900010,"JHK254",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK255",attributes+0,0,NULL},
  {914,0,0x900010,"JHK256",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK257",attributes+0,0,NULL},
  {914,0,0x900010,"JHK258",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK259",attributes+0,0,NULL},
  {914,0,0x900010,"JHK260",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK261",attributes+0,0,NULL},
  {914,0,0x900010,"JHK262",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK263",attributes+0,0,NULL},
  {914,0,0x900010,"JHK264",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK265",attributes+0,0,NULL},
  {914,0,0x900010,"JHK266",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK267",attributes+0,0,NULL},
  {914,0,0x900010,"JHK268",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK269",attributes+0,0,NULL},
  {951,0,0x900010,"JHK270",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK271",attributes+0,0,NULL},
  {914,0,0x900010,"JHK272",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK273",attributes+0,0,NULL},
  {914,0,0x900010,"JHK274",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK275",attributes+0,0,NULL},
  {914,0,0x900010,"JHK276",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK277",attributes+0,0,NULL},
  {914,0,0x900010,"JHK278",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK279",attributes+0,0,NULL},
  {914,0,0x900010,"JHK280",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK281",attributes+0,0,NULL},
  {914,0,0x900010,"JHK282",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK283",attributes+0,0,NULL},
  {914,0,0x900010,"JHK284",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK285",attributes+0,0,NULL},
  {914,0,0x900010,"JHK286",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK287",attributes+0,0,NULL},
  {914,0,0x900010,"JHK288",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK289",attributes+0,0,NULL},
  {914,0,0x900010,"JHK290",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK291",attributes+0,0,NULL},
  {914,0,0x900010,"JHK292",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK293",attributes+0,0,NULL},
  {914,0,0x900010,"JHK294",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK295",attributes+0,0,NULL},
  {914,0,0x900010,"JHK296",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK297",attributes+0,0,NULL},
  {914,0,0x900010,"JHK298",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK299",attributes+0,0,NULL},
  {914,0,0x900010,"JHK300",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK301",attributes+0,0,NULL},
  {914,0,0x900010,"JHK302",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK303",attributes+0,0,NULL},
  {951,0,0x900010,"JHK304",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK305",attributes+0,0,NULL},
  {914,0,0x900010,"JHK306",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK307",attributes+0,0,NULL},
  {914,0,0x900010,"JHK308",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK309",attributes+0,0,NULL},
  {951,0,0x900010,"JHK310",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK311",attributes+0,0,NULL},
  {914,0,0x900010,"JHK312",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK313",attributes+0,0,NULL},
  {914,0,0x900010,"JHK314",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK315",attributes+0,0,NULL},
  {914,0,0x820010,"JHK316",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK317",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK318",attributes+0,0,NULL},
  {981,0,0x1800010,"JHK319",attributes+0,0,NULL},
  {1018,0,0x900010,"JHK320",attributes+0,0,NULL},
  {1018,0,0x1800010,"JHK321",attributes+0,0,NULL},
  {1018,0,0x900010,"JHK322",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK323",attributes+0,0,NULL},
  {914,0,0x900010,"JHK324",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK325",attributes+0,0,NULL},
  {914,0,0x900010,"JHK326",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK327",attributes+0,0,NULL},
  {914,0,0x900010,"JHK328",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK329",attributes+0,0,NULL},
  {914,0,0x900010,"JHK330",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK331",attributes+0,0,NULL},
  {914,0,0x900010,"JHK332",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK333",attributes+0,0,NULL},
  {914,0,0x900010,"JHK334",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK335",attributes+0,0,NULL},
  {914,0,0x900010,"JHK336",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK337",attributes+0,0,NULL},
  {984,0,0x1800010,"JHK338",attributes+0,0,NULL},
  {984,0,0x900010,"JHK339",attributes+0,0,NULL},
  {1019,0,0x1800010,"JHK340",attributes+0,0,NULL},
  {1018,0,0x1800010,"JHK341",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK342",attributes+0,0,NULL},
  {914,0,0x900010,"JHK343",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK344",attributes+0,0,NULL},
  {914,0,0x900010,"JHK345",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK346",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK347",attributes+0,0,NULL},
  {914,0,0x900010,"JHK348",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK349",attributes+0,0,NULL},
  {914,0,0x900010,"JHK350",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK351",attributes+0,0,NULL},
  {914,0,0x900010,"JHK352",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK353",attributes+0,0,NULL},
  {914,0,0x900010,"JHK354",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK355",attributes+0,0,NULL},
  {914,0,0x900010,"JHK356",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK357",attributes+0,0,NULL},
  {914,0,0x900010,"JHK358",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK359",attributes+0,0,NULL},
  {914,0,0x900010,"JHK360",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK361",attributes+0,0,NULL},
  {914,0,0x900010,"JHK362",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK363",attributes+0,0,NULL},
  {914,0,0x900010,"JHK364",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK365",attributes+0,0,NULL},
  {914,0,0x900010,"JHK366",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK367",attributes+0,0,NULL},
  {914,0,0x900010,"JHK368",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK369",attributes+0,0,NULL},
  {914,0,0x900010,"JHK370",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK371",attributes+0,0,NULL},
  {951,0,0x900010,"JHK372",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK373",attributes+0,0,NULL},
  {914,0,0x900010,"JHK374",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK375",attributes+0,0,NULL},
  {951,0,0x900010,"JHK376",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK377",attributes+0,0,NULL},
  {914,0,0x900010,"JHK378",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK379",attributes+0,0,NULL},
  {914,0,0x900010,"JHK380",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK381",attributes+0,0,NULL},
  {914,0,0x900010,"JHK382",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK383",attributes+0,0,NULL},
  {914,0,0x900010,"JHK384",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK385",attributes+0,0,NULL},
  {914,0,0x900010,"JHK386",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK387",attributes+0,0,NULL},
  {914,0,0x900010,"JHK388",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK389",attributes+0,0,NULL},
  {914,0,0x900010,"JHK390",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK391",attributes+0,0,NULL},
  {914,0,0x900010,"JHK392",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK393",attributes+0,0,NULL},
  {914,0,0x900010,"JHK394",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK395",attributes+0,0,NULL},
  {914,0,0x900010,"JHK396",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK397",attributes+0,0,NULL},
  {914,0,0x900010,"JHK398",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK399",attributes+0,0,NULL},
  {914,0,0x900010,"JHK400",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK401",attributes+0,0,NULL},
  {914,0,0x900010,"JHK402",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK403",attributes+0,0,NULL},
  {914,0,0x900010,"JHK404",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK405",attributes+0,0,NULL},
  {914,0,0x900010,"JHK406",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK407",attributes+0,0,NULL},
  {914,0,0x900010,"JHK408",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK409",attributes+0,0,NULL},
  {914,0,0x900010,"JHK410",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK411",attributes+0,0,NULL},
  {914,0,0x900010,"JHK412",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK413",attributes+0,0,NULL},
  {914,0,0x900010,"JHK414",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK415",attributes+0,0,NULL},
  {914,0,0x900010,"JHK416",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK417",attributes+0,0,NULL},
  {914,0,0x900010,"JHK418",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK419",attributes+0,0,NULL},
  {914,0,0x900010,"JHK420",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK421",attributes+0,0,NULL},
  {914,0,0x900010,"JHK422",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK423",attributes+0,0,NULL},
  {914,0,0x900010,"JHK424",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK425",attributes+0,0,NULL},
  {951,0,0x900010,"JHK426",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK427",attributes+0,0,NULL},
  {914,0,0x900010,"JHK428",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK429",attributes+0,0,NULL},
  {951,0,0x900010,"JHK430",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK431",attributes+0,0,NULL},
  {914,0,0x900010,"JHK432",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK433",attributes+0,0,NULL},
  {914,0,0x900010,"JHK434",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK435",attributes+0,0,NULL},
  {914,0,0x900010,"JHK436",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK437",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK438",attributes+0,0,NULL},
  {914,0,0x900010,"JHK439",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK440",attributes+0,0,NULL},
  {914,0,0x900010,"JHK441",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK442",attributes+0,0,NULL},
  {914,0,0x900010,"JHK443",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK444",attributes+0,0,NULL},
  {914,0,0x900010,"JHK445",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK446",attributes+0,0,NULL},
  {914,0,0x900010,"JHK447",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK448",attributes+0,0,NULL},
  {914,0,0x900010,"JHK449",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK450",attributes+0,0,NULL},
  {914,0,0x900010,"JHK451",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK452",attributes+0,0,NULL},
  {914,0,0x900010,"JHK453",attributes+0,0,NULL},
  {875,0,0x1800010,"JHK454",attributes+0,0,NULL},
  {875,0,0x900010,"JHK455",attributes+0,0,NULL},
  {875,0,0x1800010,"JHK456",attributes+0,0,NULL},
  {875,0,0x900010,"JHK457",attributes+0,0,NULL},
  {912,0,0x1800010,"JHK458",attributes+0,0,NULL},
  {875,0,0x900010,"JHK459",attributes+0,0,NULL},
  {879,0,0x900010,"JHK460",attributes+0,0,NULL},
  {879,0,0x900010,"JHK461",attributes+0,0,NULL},
  {914,0,0x820010,"JHK462",attributes+0,0,NULL},
  {914,0,0x820010,"JHK463",attributes+0,0,NULL},
  {914,0,0x820010,"JHK464",attributes+0,0,NULL},
  {914,0,0x820010,"JHK465",attributes+0,0,NULL},
  {914,0,0x820010,"JHK466",attributes+0,0,NULL},
  {839,0,0x820010,"JHK467",attributes+0,0,NULL},
  {877,0,0x820010,"JHK468",attributes+0,0,NULL},
  {877,0,0x820010,"JHK469",attributes+0,0,NULL},
  {914,0,0x820010,"JHK470",attributes+0,0,NULL},
  {914,0,0x820010,"JHK471",attributes+0,0,NULL},
  {914,0,0x820010,"JHK472",attributes+0,0,NULL},
  {914,0,0x820010,"JHK473",attributes+0,0,NULL},
  {914,0,0x820010,"JHK474",attributes+0,0,NULL},
  {916,0,0x820010,"JHK475",attributes+0,0,NULL},
  {1100,0,0x820010,"JHK476",attributes+0,0,NULL},
  {914,0,0x820010,"JHK477",attributes+0,0,NULL},
  {914,0,0x820010,"JHK478",attributes+0,0,NULL},
  {914,0,0x820010,"JHK479",attributes+0,0,NULL},
  {914,0,0x820010,"JHK480",attributes+0,0,NULL},
  {917,0,0x820010,"JHK481",attributes+0,0,NULL},
  {991,0,0x820010,"JHK482",attributes+0,0,NULL},
  {914,0,0x900010,"JHK483",attributes+0,0,NULL},
  {914,0,0x820010,"JHK484",attributes+0,0,NULL},
  {914,0,0x820010,"JHK485",attributes+0,0,NULL},
  {914,0,0x820010,"JHK486",attributes+0,0,NULL},
  {914,0,0x820010,"JHK487",attributes+0,0,NULL},
  {914,0,0x820010,"JHK488",attributes+0,0,NULL},
  {914,0,0x820010,"JHK489",attributes+0,0,NULL},
  {951,0,0x820010,"JHK490",attributes+0,0,NULL},
  {914,0,0x820010,"JHK491",attributes+0,0,NULL},
  {988,0,0x820010,"JHK492",attributes+0,0,NULL},
  {988,0,0x820010,"JHK493",attributes+0,0,NULL},
  {988,0,0x820010,"JHK494",attributes+0,0,NULL},
  {914,0,0x820010,"JHK495",attributes+0,0,NULL},
  {914,0,0x820010,"JHK496",attributes+0,0,NULL},
  {914,0,0x820010,"JHK497",attributes+0,0,NULL},
  {914,0,0x820010,"JHK498",attributes+0,0,NULL},
  {914,0,0x820010,"JHK499",attributes+0,0,NULL},
  {914,0,0x820010,"JHK500",attributes+0,0,NULL},
  {913,0,0x820010,"JHK501",attributes+0,0,NULL},
  {913,0,0x820010,"JHK502",attributes+0,0,NULL},
  {913,0,0x820010,"JHK503",attributes+0,0,NULL},
  {913,0,0x820010,"JHK504",attributes+0,0,NULL},
  {913,0,0x820010,"JHK505",attributes+0,0,NULL},
  {913,0,0x820010,"JHK506",attributes+0,0,NULL},
  {913,0,0x820010,"JHK507",attributes+0,0,NULL},
  {913,0,0x820010,"JHK508",attributes+0,0,NULL},
  {913,0,0x820010,"JHK509",attributes+0,0,NULL},
  {913,0,0x820010,"JHK510",attributes+0,0,NULL},
  {913,0,0x820010,"JHK511",attributes+0,0,NULL},
  {1062,0,0x820010,"JHK512",attributes+0,0,NULL},
  {1062,0,0x820010,"JHK513",attributes+0,0,NULL},
  {1062,0,0x820010,"JHK514",attributes+0,0,NULL},
  {1062,0,0x820010,"JHK515",attributes+0,0,NULL},
  {913,0,0x820010,"JHK516",attributes+0,0,NULL},
  {876,0,0x900010,"JHK517",attributes+0,0,NULL},
  {876,0,0x820010,"JHK518",attributes+0,0,NULL},
  {914,0,0x820010,"JHK519",attributes+0,0,NULL},
  {913,0,0x820010,"JHK520",attributes+0,0,NULL},
  {877,0,0x820010,"JHK521",attributes+0,0,NULL},
  {878,0,0x820010,"JHK522",attributes+0,0,NULL},
  {877,0,0x820010,"JHK523",attributes+0,0,NULL},
  {878,0,0x820010,"JHK524",attributes+0,0,NULL},
  {914,0,0x820010,"JHK525",attributes+0,0,NULL},
  {915,0,0x820010,"JHK526",attributes+0,0,NULL},
  {913,0,0x820010,"JHK527",attributes+0,0,NULL},
  {874,0,0x1800010,"JHK528",attributes+0,0,NULL},
  {874,0,0x820010,"JHK529",attributes+0,0,NULL},
  {874,0,0x1800010,"JHK530",attributes+0,0,NULL},
  {874,0,0x820010,"JHK531",attributes+0,0,NULL},
  {874,0,0x1800010,"JHK532",attributes+0,0,NULL},
  {874,0,0x820010,"JHK533",attributes+0,0,NULL},
  {874,0,0x1800010,"JHK534",attributes+0,0,NULL},
  {874,0,0x820010,"JHK535",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK536",attributes+0,0,NULL},
  {952,0,0x820010,"JHK537",attributes+0,0,NULL},
  {915,0,0x820010,"JHK538",attributes+0,0,NULL},
  {915,0,0x820010,"JHK539",attributes+0,0,NULL},
  {952,0,0x820010,"JHK540",attributes+0,0,NULL},
  {951,0,0x820010,"JHK541",attributes+0,0,NULL},
  {914,0,0x820010,"JHK542",attributes+0,0,NULL},
  {876,0,0x820010,"JHK543",attributes+0,0,NULL},
  {876,0,0x820010,"JHK544",attributes+0,0,NULL},
  {913,0,0x820010,"JHK545",attributes+0,0,NULL},
  {914,0,0x820010,"JHK546",attributes+0,0,NULL},
  {914,0,0x820010,"JHK547",attributes+0,0,NULL},
  {914,0,0x820010,"JHK548",attributes+0,0,NULL},
  {914,0,0x820010,"JHK549",attributes+0,0,NULL},
  {914,0,0x820010,"JHK550",attributes+0,0,NULL},
  {914,0,0x820010,"JHK551",attributes+0,0,NULL},
  {914,0,0x820010,"JHK552",attributes+0,0,NULL},
  {914,0,0x820010,"JHK553",attributes+0,0,NULL},
  {914,0,0x820010,"JHK554",attributes+0,0,NULL},
  {914,0,0x820010,"JHK555",attributes+0,0,NULL},
  {914,0,0x820010,"JHK556",attributes+0,0,NULL},
  {914,0,0x820010,"JHK557",attributes+0,0,NULL},
  {914,0,0x820010,"JHK558",attributes+0,0,NULL},
  {914,0,0x820010,"JHK559",attributes+0,0,NULL},
  {914,0,0x820010,"JHK560",attributes+0,0,NULL},
  {875,0,0x820010,"JHK561",attributes+0,0,NULL},
  {876,0,0x820010,"JHK562",attributes+0,0,NULL},
  {876,0,0x820010,"JHK563",attributes+0,0,NULL},
  {876,0,0x820010,"JHK564",attributes+0,0,NULL},
  {876,0,0x820010,"JHK565",attributes+0,0,NULL},
  {914,0,0x820010,"JHK566",attributes+0,1,autohelperjoseki672},
  {914,0,0x820010,"JHK567",attributes+0,0,NULL},
  {914,0,0x820010,"JHK568",attributes+0,0,NULL},
  {951,0,0x820010,"JHK569",attributes+0,0,NULL},
  {951,0,0x820010,"JHK570",attributes+0,0,NULL},
  {951,0,0x820010,"JHK571",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK572",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK573",attributes+0,0,NULL},
  {914,0,0x820010,"JHK574",attributes+0,1,autohelperjoseki680},
  {914,0,0x820010,"JHK575",attributes+0,0,NULL},
  {914,0,0x820010,"JHK576",attributes+0,0,NULL},
  {914,0,0x820010,"JHK577",attributes+0,0,NULL},
  {914,0,0x820010,"JHK578",attributes+0,0,NULL},
  {914,0,0x820010,"JHK579",attributes+0,0,NULL},
  {914,0,0x820010,"JHK580",attributes+0,0,NULL},
  {914,0,0x820010,"JHK581",attributes+0,0,NULL},
  {914,0,0x820010,"JHK582",attributes+0,0,NULL},
  {915,0,0x820010,"JHK583",attributes+0,0,NULL},
  {915,0,0x820010,"JHK584",attributes+0,0,NULL},
  {989,0,0x820010,"JHK585",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK586",attributes+0,0,NULL},
  {914,0,0x820010,"JHK587",attributes+0,0,NULL},
  {914,0,0x820010,"JHK588",attributes+0,0,NULL},
  {914,0,0x820010,"JHK589",attributes+0,0,NULL},
  {914,0,0x820010,"JHK590",attributes+0,0,NULL},
  {914,0,0x820010,"JHK591",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK592",attributes+0,0,NULL},
  {950,0,0x840010,"JHK593",attributes+0,0,NULL},
  {913,0,0x820010,"JHK594",attributes+0,0,NULL},
  {875,0,0x820010,"JHK595",attributes+0,0,NULL},
  {916,0,0x820010,"JHK596",attributes+0,0,NULL},
  {1063,0,0x840010,"JHK597",attributes+0,0,NULL},
  {1026,0,0x840010,"JHK598",attributes+0,0,NULL},
  {986,0,0x820010,"JHK599",attributes+0,0,NULL},
  {986,0,0x820010,"JHK600",attributes+0,0,NULL},
  {916,0,0x820010,"JHK601",attributes+0,0,NULL},
  {917,0,0x820010,"JHK602",attributes+0,0,NULL},
  {1062,0,0x820010,"JHK603",attributes+0,0,NULL},
  {912,0,0x820010,"JHK604",attributes+0,0,NULL},
  {912,0,0x820010,"JHK605",attributes+0,0,NULL},
  {913,0,0x820010,"JHK606",attributes+0,0,NULL},
  {875,0,0x820010,"JHK607",attributes+0,0,NULL},
  {913,0,0x820010,"JHK608",attributes+0,0,NULL},
  {875,0,0x820010,"JHK609",attributes+0,0,NULL},
  {875,0,0x820010,"JHK610",attributes+0,0,NULL},
  {875,0,0x820010,"JHK611",attributes+0,0,NULL},
  {875,0,0x820010,"JHK612",attributes+0,0,NULL},
  {876,0,0x820010,"JHK613",attributes+0,0,NULL},
  {875,0,0x820010,"JHK614",attributes+0,0,NULL},
  {913,0,0x820010,"JHK615",attributes+0,0,NULL},
  {876,0,0x820010,"JHK616",attributes+0,0,NULL},
  {913,0,0x820010,"JHK617",attributes+0,0,NULL},
  {913,0,0x820010,"JHK618",attributes+0,0,NULL},
  {914,0,0x1800010,"JHK619",attributes+0,0,NULL},
  {913,0,0x820010,"JHK620",attributes+0,0,NULL},
  {914,0,0x820010,"JHK621",attributes+0,0,NULL},
  {913,0,0x820010,"JHK622",attributes+0,0,NULL},
  {914,0,0x820010,"JHK623",attributes+0,0,NULL},
  {914,0,0x820010,"JHK624",attributes+0,0,NULL},
  {914,0,0x820010,"JHK625",attributes+0,0,NULL},
  {911,0,0x820010,"JHK626",attributes+0,0,NULL},
  {911,0,0x820010,"JHK627",attributes+0,0,NULL},
  {911,0,0x820010,"JHK628",attributes+0,0,NULL},
  {913,0,0x1800010,"JHK629",attributes+0,0,NULL},
  {875,0,0x820010,"JHK630",attributes+0,0,NULL},
  {912,0,0x820010,"JHK631",attributes+0,0,NULL},
  {875,0,0x820010,"JHK632",attributes+0,0,NULL},
  {913,0,0x820010,"JHK633",attributes+0,0,NULL},
  {912,0,0x820010,"JHK634",attributes+0,0,NULL},
  {875,0,0x820010,"JHK635",attributes+0,0,NULL},
  {875,0,0x820010,"JHK636",attributes+0,0,NULL},
  {912,0,0x1800010,"JHK637",attributes+0,0,NULL},
  {913,0,0x820010,"JHK638",attributes+0,0,NULL},
  {912,0,0x820010,"JHK639",attributes+0,0,NULL},
  {912,0,0x820010,"JHK640",attributes+0,0,NULL},
  {912,0,0x820010,"JHK641",attributes+0,0,NULL},
  {912,0,0x820010,"JHK642",attributes+0,0,NULL},
  {912,0,0x820010,"JHK643",attributes+0,0,NULL},
  {912,0,0x820010,"JHK644",attributes+0,0,NULL},
  {912,0,0x820010,"JHK645",attributes+0,0,NULL},
  {912,0,0x820010,"JHK646",attributes+0,0,NULL},
  {912,0,0x820010,"JHK647",attributes+0,0,NULL},
  {912,0,0x820010,"JHK648",attributes+0,0,NULL},
  {912,0,0x820010,"JHK649",attributes+0,0,NULL},
  {912,0,0x820010,"JHK650",attributes+0,0,NULL},
  {878,0,0x820010,"JHK651",attributes+0,0,NULL},
  {986,0,0x880010,"JHK652",attributes+0,0,NULL},
  {912,1,0x820010,"JHK653",attributes+0,0,NULL},
  {912,1,0x820010,"JHK654",attributes+0,0,NULL},
  {912,0,0x820010,"JHK655",attributes+0,0,NULL},
  {912,0,0x820010,"JHK656",attributes+0,0,NULL},
  {949,0,0x820010,"JHK657",attributes+0,0,NULL},
  {912,0,0x820010,"JHK658",attributes+0,0,NULL},
  {912,0,0x820010,"JHK659",attributes+0,0,NULL},
  {912,0,0x820010,"JHK660",attributes+0,0,NULL},
  {912,0,0x820010,"JHK661",attributes+0,0,NULL},
  {912,0,0x820010,"JHK662",attributes+0,0,NULL},
  {912,0,0x820010,"JHK663",attributes+0,0,NULL},
  {986,0,0x820010,"JHK664",attributes+0,0,NULL},
  {986,0,0x820010,"JHK665",attributes+0,0,NULL},
  {986,0,0x820010,"JHK666",attributes+0,0,NULL},
  {986,0,0x820010,"JHK667",attributes+0,0,NULL},
  {986,0,0x820010,"JHK668",attributes+0,0,NULL},
  {986,0,0x820010,"JHK669",attributes+0,0,NULL},
  {986,0,0x820010,"JHK670",attributes+0,0,NULL},
  {986,0,0x820010,"JHK671",attributes+0,0,NULL},
  {952,0,0x820010,"JHK672",attributes+0,0,NULL},
  {986,0,0x880010,"JHK673",attributes+0,0,NULL},
  {912,0,0x820010,"JHK674",attributes+0,0,NULL},
  {912,0,0x820010,"JHK675",attributes+0,0,NULL},
  {912,0,0x820010,"JHK676",attributes+0,0,NULL},
  {912,0,0x820010,"JHK677",attributes+0,0,NULL},
  {912,0,0x820010,"JHK678",attributes+0,0,NULL},
  {912,0,0x820010,"JHK679",attributes+0,0,NULL},
  {912,0,0x820010,"JHK680",attributes+0,0,NULL},
  {912,0,0x820010,"JHK681",attributes+0,0,NULL},
  {912,0,0x820010,"JHK682",attributes+0,0,NULL},
  {913,0,0x820010,"JHK683",attributes+0,0,NULL},
  {1062,0,0x820010,"JHK684",attributes+0,0,NULL},
  {950,0,0x820010,"JHK685",attributes+0,0,NULL},
  {950,0,0x900010,"JHK686",attributes+0,0,NULL},
  {950,0,0x820010,"JHK687",attributes+0,0,NULL},
  {950,0,0x820010,"JHK688",attributes+0,0,NULL},
  {950,0,0x820010,"JHK689",attributes+0,0,NULL},
  {950,0,0x900010,"JHK690",attributes+0,0,NULL},
  {950,0,0x820010,"JHK691",attributes+0,0,NULL},
  {950,0,0x820010,"JHK692",attributes+0,0,NULL},
  {1063,0,0x840010,"JHK693",attributes+0,0,NULL},
  {1063,0,0x900010,"JHK694",attributes+0,0,NULL},
  {1063,0,0x900010,"JHK695",attributes+0,0,NULL},
  {1063,0,0x840010,"JHK696",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK697",attributes+0,0,NULL},
  {1100,0,0x820010,"JHK698",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK699",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK700",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK701",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK702",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK703",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK704",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK705",attributes+0,0,NULL},
  {1063,0,0x840010,"JHK706",attributes+0,0,NULL},
  {1063,0,0x840010,"JHK707",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK708",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK709",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK710",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK711",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK712",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK713",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK714",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK715",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK716",attributes+0,0,NULL},
  {1063,0,0x840010,"JHK717",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK718",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK719",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK720",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK721",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK722",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK723",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK724",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK725",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK726",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK727",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK728",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK729",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK730",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK731",attributes+0,0,NULL},
  {1063,0,0x820010,"JHK732",attributes+0,0,NULL},
  {1063,0,0x840010,"JHK733",attributes+0,0,NULL},
  {916,0,0x820010,"JHO1",attributes+0,0,NULL},
  {914,0,0x820010,"JHO2",attributes+0,0,NULL},
  {916,0,0x900010,"JHO3",attributes+0,0,NULL},
  {953,0,0x840010,"JHO4",attributes+0,0,NULL},
  {914,0,0x820010,"JHO5",attributes+0,0,NULL},
  {914,0,0x820010,"JHO6",attributes+0,0,NULL},
  {914,0,0x820010,"JHO7",attributes+0,0,NULL},
  {914,0,0x820010,"JHO8",attributes+0,0,NULL},
  {953,0,0x820010,"JHO9",attributes+0,0,NULL},
  {913,0,0x1800010,"JHO10",attributes+0,0,NULL},
  {880,0,0x840010,"JHO11",attributes+0,0,NULL},
  {988,0,0x820010,"JHO12",attributes+0,0,NULL},
  {917,0,0x840010,"JHO13",attributes+6,0,NULL},
  {954,0,0x840010,"JHO14",attributes+0,0,NULL},
  {991,0,0x840010,"JHO15",attributes+0,0,NULL},
  {916,0,0x840010,"JHO16",attributes+8,0,NULL},
  {1064,0,0x840010,"JHO17",attributes+10,0,NULL},
  {915,0,0x1800010,"JHO18",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO19",attributes+0,0,NULL},
  {842,0,0x820010,"JHO20",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO21",attributes+0,0,NULL},
  {842,0,0x820010,"JHO22",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO23",attributes+0,0,NULL},
  {842,0,0x900010,"JHO24",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO25",attributes+0,0,NULL},
  {842,0,0x900010,"JHO26",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO27",attributes+0,0,NULL},
  {842,0,0x900010,"JHO28",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO29",attributes+0,0,NULL},
  {842,0,0x900010,"JHO30",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO31",attributes+0,0,NULL},
  {842,0,0x900010,"JHO32",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO33",attributes+0,0,NULL},
  {842,0,0x900010,"JHO34",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO35",attributes+0,0,NULL},
  {842,0,0x900010,"JHO36",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO37",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO38",attributes+0,0,NULL},
  {842,0,0x900010,"JHO39",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO40",attributes+0,0,NULL},
  {842,0,0x900010,"JHO41",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO42",attributes+0,0,NULL},
  {842,0,0x900010,"JHO43",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO44",attributes+0,0,NULL},
  {842,0,0x900010,"JHO45",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO46",attributes+0,0,NULL},
  {842,0,0x900010,"JHO47",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO48",attributes+0,0,NULL},
  {842,0,0x900010,"JHO49",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO50",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO51",attributes+0,0,NULL},
  {842,0,0x900010,"JHO52",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO53",attributes+0,0,NULL},
  {842,0,0x900010,"JHO54",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO55",attributes+0,0,NULL},
  {842,0,0x900010,"JHO56",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO57",attributes+0,0,NULL},
  {842,0,0x900010,"JHO58",attributes+0,0,NULL},
  {842,0,0x1800010,"JHO59",attributes+0,0,NULL},
  {842,0,0x900010,"JHO60",attributes+0,0,NULL},
  {950,0,0x820010,"JHO61",attributes+0,0,NULL},
  {912,0,0x820010,"JHO62",attributes+0,0,NULL},
  {912,0,0x820010,"JHO63",attributes+0,0,NULL},
  {912,0,0x820010,"JHO64",attributes+0,0,NULL},
  {912,0,0x820010,"JHO65",attributes+0,0,NULL},
  {917,0,0x820010,"JHO66",attributes+0,0,NULL},
  {1060,0,0x820010,"JHO67",attributes+0,0,NULL},
  {912,0,0x820010,"JHO68",attributes+0,0,NULL},
  {880,0,0x840010,"JHO69",attributes+0,0,NULL},
  {950,0,0x880010,"JHO70",attributes+0,0,NULL},
  {953,0,0x820010,"JHO71",attributes+0,0,NULL},
  {950,0,0x820010,"JHO72",attributes+0,0,NULL},
  {953,0,0x820010,"JHO73",attributes+0,0,NULL},
  {1023,0,0x840010,"JHO74",attributes+0,0,NULL},
  {912,1,0x820010,"JHO75",attributes+0,0,NULL},
  {912,1,0x820010,"JHO76",attributes+0,0,NULL},
  {1023,0,0x820010,"JHO77",attributes+0,0,NULL},
  {1023,0,0x820010,"JHO78",attributes+0,0,NULL},
  {1024,0,0x820010,"JHO79",attributes+0,0,NULL},
  {1023,0,0x820010,"JHO80",attributes+0,0,NULL},
  {1025,0,0x820010,"JHO81",attributes+0,0,NULL},
  {912,0,0x840010,"JHO82",attributes+0,0,NULL},
  {950,0,0x820010,"JHO83",attributes+0,0,NULL},
  {950,0,0x820010,"JHO84",attributes+0,0,NULL},
  {912,1,0x840010,"JHO85",attributes+0,0,NULL},
  {950,1,0x820010,"JHO86",attributes+0,0,NULL},
  {950,0,0x1800010,"JHO87",attributes+0,0,NULL},
  {950,0,0x820010,"JHO88",attributes+0,0,NULL},
  {950,0,0x820010,"JHO89",attributes+0,0,NULL},
  {950,0,0x820010,"JHO90",attributes+0,0,NULL},
  {950,0,0x820010,"JHO91",attributes+0,0,NULL},
  {954,0,0x820010,"JHO92",attributes+0,0,NULL},
  {991,0,0x840010,"JHO93",attributes+0,0,NULL},
  {987,0,0x820010,"JHO94",attributes+0,0,NULL},
  {987,0,0x820010,"JHO95",attributes+0,0,NULL},
  {987,0,0x820010,"JHO96",attributes+0,0,NULL},
  {987,0,0x820010,"JHO97",attributes+0,0,NULL},
  {874,0,0x820010,"JHO98",attributes+0,0,NULL},
  {874,0,0x820010,"JHO99",attributes+0,0,NULL},
  {874,0,0x820010,"JHO100",attributes+0,0,NULL},
  {911,0,0x820010,"JHO101",attributes+0,0,NULL},
  {911,0,0x820010,"JHO102",attributes+0,0,NULL},
  {948,0,0x820010,"JHO103",attributes+0,0,NULL},
  {874,0,0x820010,"JHO104",attributes+0,0,NULL},
  {875,0,0x820010,"JHO105",attributes+0,0,NULL},
  {874,0,0x820010,"JHO106",attributes+0,0,NULL},
  {912,0,0x820010,"JHO107",attributes+0,0,NULL},
  {874,0,0x820010,"JHO108",attributes+0,0,NULL},
  {874,0,0x820010,"JHO109",attributes+0,0,NULL},
  {875,0,0x840010,"JHO110",attributes+0,0,NULL},
  {874,0,0x820010,"JHO111",attributes+0,0,NULL},
  {911,0,0x820010,"JHO112",attributes+0,0,NULL},
  {911,0,0x820010,"JHO113",attributes+0,0,NULL},
  {948,0,0x820010,"JHO114",attributes+0,0,NULL},
  {912,0,0x820010,"JHO115",attributes+0,0,NULL},
  {874,0,0x1800010,"JHO116",attributes+0,0,NULL},
  {912,0,0x820010,"JHO117",attributes+0,0,NULL},
  {913,0,0x820010,"JHO118",attributes+0,0,NULL},
  {950,0,0x820010,"JHO119",attributes+0,0,NULL},
  {913,0,0x820010,"JHO120",attributes+0,0,NULL},
  {950,0,0x820010,"JHO121",attributes+0,0,NULL},
  {913,0,0x820010,"JHO122",attributes+0,0,NULL},
  {875,0,0x820010,"JHO123",attributes+0,0,NULL},
  {876,0,0x820010,"JHO124",attributes+0,0,NULL},
  {914,0,0x820010,"JHO125",attributes+0,0,NULL},
  {911,0,0x820010,"JHO126",attributes+0,0,NULL},
  {911,0,0x820010,"JHO127",attributes+0,0,NULL},
  {911,0,0x820010,"JHO128",attributes+0,0,NULL},
  {911,0,0x820010,"JHO129",attributes+0,0,NULL},
  {911,0,0x820010,"JHO130",attributes+0,0,NULL},
  {911,0,0x820010,"JHO131",attributes+0,0,NULL},
  {912,0,0x820010,"JHO132",attributes+0,0,NULL},
  {911,0,0x820010,"JHO133",attributes+0,0,NULL},
  {874,0,0x820010,"JHO134",attributes+0,0,NULL},
  {874,0,0x820010,"JHO135",attributes+0,0,NULL},
  {875,0,0x820010,"JHO136",attributes+0,0,NULL},
  {875,0,0x820010,"JHO137",attributes+0,0,NULL},
  {913,0,0x820010,"JHO138",attributes+0,0,NULL},
  {949,0,0x820010,"JHO139",attributes+0,0,NULL},
  {911,0,0x820010,"JHO140",attributes+0,0,NULL},
  {911,0,0x820010,"JHO141",attributes+0,0,NULL},
  {911,0,0x820010,"JHO142",attributes+0,0,NULL},
  {911,0,0x820010,"JHO143",attributes+0,0,NULL},
  {911,0,0x820010,"JHO144",attributes+0,0,NULL},
  {911,0,0x820010,"JHO145",attributes+0,0,NULL},
  {911,0,0x820010,"JHO146",attributes+0,0,NULL},
  {911,0,0x820010,"JHO147",attributes+0,0,NULL},
  {911,0,0x820010,"JHO148",attributes+0,0,NULL},
  {911,0,0x820010,"JHO149",attributes+0,0,NULL},
  {912,0,0x820010,"JHO150",attributes+0,0,NULL},
  {911,0,0x820010,"JHO151",attributes+0,0,NULL},
  {911,0,0x820010,"JHO152",attributes+0,0,NULL},
  {911,0,0x820010,"JHO153",attributes+0,0,NULL},
  {911,0,0x820010,"JHO154",attributes+0,0,NULL},
  {950,0,0x820010,"JHO155",attributes+0,0,NULL},
  {913,0,0x820010,"JHO156",attributes+0,0,NULL},
  {951,0,0x840010,"JHO157",attributes+0,0,NULL},
  {951,0,0x820010,"JHO158",attributes+0,0,NULL},
  {951,0,0x820010,"JHO159",attributes+0,0,NULL},
  {951,0,0x820010,"JHO160",attributes+0,0,NULL},
  {951,0,0x820010,"JHO161",attributes+0,0,NULL},
  {951,0,0x820010,"JHO162",attributes+0,0,NULL},
  {951,0,0x820010,"JHO163",attributes+0,0,NULL},
  {951,0,0x820010,"JHO164",attributes+0,0,NULL},
  {954,0,0x820010,"JHO165",attributes+0,0,NULL},
  {1099,0,0x820010,"JHO166",attributes+0,0,NULL},
  {951,0,0x820010,"JHO167",attributes+0,0,NULL},
  {951,0,0x820010,"JHO168",attributes+0,0,NULL},
  {951,0,0x820010,"JHO169",attributes+0,0,NULL},
  {951,0,0x820010,"JHO170",attributes+0,0,NULL},
  {955,0,0x820010,"JHO171",attributes+0,0,NULL},
  {1099,0,0x820010,"JHO172",attributes+0,0,NULL},
  {951,0,0x820010,"JHO173",attributes+0,0,NULL},
  {951,0,0x820010,"JHO174",attributes+0,0,NULL},
  {951,0,0x820010,"JHO175",attributes+0,0,NULL},
  {951,0,0x820010,"JHO176",attributes+0,0,NULL},
  {955,0,0x820010,"JHO177",attributes+0,0,NULL},
  {1099,0,0x820010,"JHO178",attributes+0,0,NULL},
  {951,0,0x820010,"JHO179",attributes+0,0,NULL},
  {951,0,0x820010,"JHO180",attributes+0,0,NULL},
  {951,0,0x820010,"JHO181",attributes+0,0,NULL},
  {951,0,0x820010,"JHO182",attributes+0,0,NULL},
  {951,0,0x820010,"JHO183",attributes+0,0,NULL},
  {951,0,0x820010,"JHO184",attributes+0,0,NULL},
  {951,0,0x820010,"JHO185",attributes+0,0,NULL},
  {951,0,0x820010,"JHO186",attributes+0,0,NULL},
  {951,0,0x820010,"JHO187",attributes+0,0,NULL},
  {951,0,0x820010,"JHO188",attributes+0,0,NULL},
  {953,0,0x820010,"JHO189",attributes+0,0,NULL},
  {952,0,0x820010,"JHO190",attributes+0,0,NULL},
  {952,0,0x820010,"JHO191",attributes+0,0,NULL},
  {989,0,0x820010,"JHO192",attributes+0,0,NULL},
  {989,0,0x820010,"JHO193",attributes+0,0,NULL},
  {989,0,0x820010,"JHO194",attributes+0,0,NULL},
  {1026,0,0x820010,"JHO195",attributes+0,0,NULL},
  {1026,0,0x820010,"JHO196",attributes+0,0,NULL},
  {989,0,0x820010,"JHO197",attributes+0,0,NULL},
  {951,0,0x820010,"JHO198",attributes+0,0,NULL},
  {951,0,0x820010,"JHO199",attributes+0,0,NULL},
  {951,0,0x820010,"JHO200",attributes+0,0,NULL},
  {951,0,0x820010,"JHO201",attributes+0,0,NULL},
  {951,0,0x1800010,"JHO202",attributes+0,0,NULL},
  {951,0,0x820010,"JHO203",attributes+0,0,NULL},
  {951,0,0x820010,"JHO204",attributes+0,0,NULL},
  {951,0,0x820010,"JHO205",attributes+0,0,NULL},
  {951,0,0x820010,"JHO206",attributes+0,0,NULL},
  {951,0,0x820010,"JHO207",attributes+0,0,NULL},
  {951,0,0x820010,"JHO208",attributes+0,0,NULL},
  {951,0,0x820010,"JHO209",attributes+0,0,NULL},
  {951,0,0x820010,"JHO210",attributes+0,0,NULL},
  {951,0,0x820010,"JHO211",attributes+0,0,NULL},
  {951,0,0x820010,"JHO212",attributes+0,0,NULL},
  {951,0,0x820010,"JHO213",attributes+0,0,NULL},
  {951,0,0x820010,"JHO214",attributes+0,0,NULL},
  {951,0,0x820010,"JHO215",attributes+0,0,NULL},
  {951,0,0x820010,"JHO216",attributes+0,0,NULL},
  {951,0,0x820010,"JHO217",attributes+0,0,NULL},
  {951,0,0x820010,"JHO218",attributes+0,0,NULL},
  {951,0,0x820010,"JHO219",attributes+0,0,NULL},
  {951,0,0x820010,"JHO220",attributes+0,0,NULL},
  {951,0,0x820010,"JHO221",attributes+0,0,NULL},
  {951,0,0x820010,"JHO222",attributes+0,0,NULL},
  {955,0,0x820010,"JHO223",attributes+0,0,NULL},
  {951,0,0x820010,"JHO224",attributes+0,0,NULL},
  {951,0,0x820010,"JHO225",attributes+0,0,NULL},
  {953,0,0x820010,"JHO226",attributes+0,0,NULL},
  {953,0,0x820010,"JHO227",attributes+0,0,NULL},
  {953,0,0x820010,"JHO228",attributes+0,0,NULL},
  {953,0,0x820010,"JHO229",attributes+0,0,NULL},
  {951,0,0x1800010,"JHO230",attributes+0,0,NULL},
  {951,0,0x820010,"JHO231",attributes+0,0,NULL},
  {951,0,0x820010,"JHO232",attributes+0,0,NULL},
  {951,0,0x840010,"JHO233",attributes+0,0,NULL},
  {988,0,0x820010,"JHO234",attributes+0,0,NULL},
  {988,0,0x820010,"JHO235",attributes+0,0,NULL},
  {988,0,0x820010,"JHO236",attributes+0,0,NULL},
  {988,0,0x820010,"JHO237",attributes+0,0,NULL},
  {988,0,0x820010,"JHO238",attributes+0,0,NULL},
  {988,0,0x820010,"JHO239",attributes+0,0,NULL},
  {988,0,0x820010,"JHO240",attributes+0,0,NULL},
  {992,0,0x840010,"JHO241",attributes+0,0,NULL},
  {1102,0,0x840010,"JHO242",attributes+0,0,NULL},
  {912,0,0x820010,"JK1",attributes+0,0,NULL},
  {949,0,0x820010,"JK2",attributes+0,0,NULL},
  {911,0,0x900010,"JK3",attributes+0,0,NULL},
  {949,0,0x820010,"JK4",attributes+12,0,NULL},
  {913,0,0x900010,"JK5",attributes+0,0,NULL},
  {1059,0,0x900010,"JK6",attributes+0,0,NULL},
  {1134,0,0x880010,"JK7",attributes+0,0,NULL},
  {1134,0,0x820010,"JK8",attributes+0,0,NULL},
  {1097,0,0x820010,"JK9",attributes+0,0,NULL},
  {1134,0,0x820010,"JK10",attributes+0,0,NULL},
  {951,0,0x840010,"JK11",attributes+0,0,NULL},
  {951,0,0x820010,"JK12",attributes+0,0,NULL},
  {951,0,0x820010,"JK13",attributes+0,0,NULL},
  {951,0,0x820010,"JK14",attributes+0,0,NULL},
  {951,0,0x820010,"JK15",attributes+0,0,NULL},
  {951,0,0x820010,"JK16",attributes+0,0,NULL},
  {951,0,0x820010,"JK17",attributes+0,0,NULL},
  {1059,0,0x820010,"JK18",attributes+0,0,NULL},
  {1060,0,0x820010,"JK19",attributes+0,0,NULL},
  {1060,0,0x820010,"JK20",attributes+0,0,NULL},
  {1060,0,0x820010,"JK21",attributes+0,0,NULL},
  {1060,0,0x820010,"JK22",attributes+0,0,NULL},
  {1062,0,0x820010,"JK23",attributes+14,0,NULL},
  {1062,0,0x820010,"JK24",attributes+0,0,NULL},
  {1063,0,0x820010,"JK25",attributes+0,0,NULL},
  {1062,0,0x820010,"JK26",attributes+0,0,NULL},
  {949,0,0x820010,"JK27",attributes+0,0,NULL},
  {1059,0,0x820010,"JK28",attributes+0,0,NULL},
  {1064,0,0x820010,"JK29",attributes+0,0,NULL},
  {1064,0,0x880010,"JK30",attributes+0,0,NULL},
  {1023,0,0x820010,"JK31",attributes+16,0,NULL},
  {913,0,0x820010,"JK32",attributes+0,0,NULL},
  {1096,0,0x820010,"JK33",attributes+0,0,NULL},
  {949,0,0x820010,"JK34",attributes+0,0,NULL},
  {949,0,0x820010,"JK35",attributes+0,0,NULL},
  {949,0,0x820010,"JK36",attributes+0,0,NULL},
  {949,0,0x820010,"JK37",attributes+18,0,NULL},
  {949,0,0x820010,"JK38",attributes+0,0,NULL},
  {949,0,0x820010,"JK39",attributes+0,0,NULL},
  {949,0,0x820010,"JK40",attributes+0,0,NULL},
  {949,0,0x820010,"JK41",attributes+0,0,NULL},
  {949,0,0x1800010,"JK42",attributes+0,0,NULL},
  {949,0,0x820010,"JK43",attributes+0,0,NULL},
  {949,0,0x820010,"JK44",attributes+0,0,NULL},
  {949,0,0x820010,"JK45",attributes+0,0,NULL},
  {949,0,0x820010,"JK46",attributes+0,0,NULL},
  {949,0,0x820010,"JK47",attributes+0,0,NULL},
  {1097,0,0x820010,"JK48",attributes+0,0,NULL},
  {1101,0,0x880010,"JK49",attributes+20,0,NULL},
  {986,0,0x1800010,"JK50",attributes+0,0,NULL},
  {1097,0,0x820010,"JK51",attributes+0,0,NULL},
  {1097,0,0x820010,"JK52",attributes+0,0,NULL},
  {1097,0,0x820010,"JK53",attributes+22,0,NULL},
  {913,0,0x820010,"JK54",attributes+0,0,NULL},
  {874,0,0x900010,"JK55",attributes+0,0,NULL},
  {875,0,0x900010,"JK56",attributes+0,0,NULL},
  {875,0,0x820010,"JK57",attributes+0,0,NULL},
  {912,0,0x900010,"JK58",attributes+0,0,NULL},
  {949,0,0x820010,"JK59",attributes+0,0,NULL},
  {949,0,0x820010,"JK60",attributes+24,0,NULL},
  {950,0,0x820010,"JK61",attributes+0,0,NULL},
  {950,0,0x820010,"JK62",attributes+0,0,NULL},
  {950,0,0x820010,"JK63",attributes+0,0,NULL},
  {951,0,0x820010,"JK64",attributes+0,0,NULL},
  {988,0,0x820010,"JK65",attributes+0,0,NULL},
  {1025,0,0x900010,"JK66",attributes+0,0,NULL},
  {1025,0,0x900010,"JK67",attributes+0,0,NULL},
  {988,0,0x820010,"JK68",attributes+0,1,autohelperjoseki1149},
  {988,0,0x900010,"JK69",attributes+0,0,NULL},
  {988,0,0x820010,"JK70",attributes+0,0,NULL},
  {988,0,0x820010,"JK71",attributes+0,0,NULL},
  {988,0,0x820010,"JK72",attributes+0,0,NULL},
  {988,0,0x900010,"JK73",attributes+0,0,NULL},
  {988,0,0x900010,"JK74",attributes+0,0,NULL},
  {988,0,0x900010,"JK75",attributes+0,0,NULL},
  {988,0,0x820010,"JK76",attributes+0,0,NULL},
  {988,0,0x820010,"JK77",attributes+0,0,NULL},
  {988,0,0x820010,"JK78",attributes+0,0,NULL},
  {988,0,0x820010,"JK79",attributes+0,0,NULL},
  {988,0,0x820010,"JK80",attributes+0,0,NULL},
  {988,0,0x820010,"JK81",attributes+0,0,NULL},
  {912,0,0x1800010,"JK82",attributes+0,0,NULL},
  {986,0,0x1800010,"JK83",attributes+0,0,NULL},
  {986,0,0x820010,"JK84",attributes+0,0,NULL},
  {986,0,0x820010,"JK85",attributes+0,0,NULL},
  {986,0,0x820010,"JK86",attributes+0,0,NULL},
  {986,0,0x820010,"JK87",attributes+0,0,NULL},
  {986,0,0x820010,"JK88",attributes+0,0,NULL},
  {986,0,0x820010,"JK89",attributes+0,0,NULL},
  {1023,0,0x820010,"JK90",attributes+0,0,NULL},
  {1025,0,0x820010,"JK91",attributes+0,0,NULL},
  {1025,0,0x900010,"JK92",attributes+0,0,NULL},
  {1025,0,0x820010,"JK93",attributes+0,0,NULL},
  {1025,0,0x820010,"JK94",attributes+0,0,NULL},
  {1062,0,0x820010,"JK95",attributes+0,0,NULL},
  {1062,0,0x820010,"JK96",attributes+0,0,NULL},
  {1061,0,0x820010,"JK97",attributes+0,0,NULL},
  {1062,0,0x820010,"JK98",attributes+0,0,NULL},
  {1062,0,0x820010,"JK99",attributes+0,0,NULL},
  {1062,0,0x900010,"JK100",attributes+0,0,NULL},
  {1062,0,0x820010,"JK101",attributes+0,0,NULL},
  {1062,0,0x900010,"JK102",attributes+0,0,NULL},
  {1062,0,0x820010,"JK103",attributes+0,0,NULL},
  {1173,0,0x820010,"JK104",attributes+0,0,NULL},
  {1173,0,0x820010,"JK105",attributes+0,0,NULL},
  {1175,0,0x820010,"JK106",attributes+0,0,NULL},
  {1175,0,0x820010,"JK107",attributes+0,0,NULL},
  {986,0,0x1800010,"JK108",attributes+0,0,NULL},
  {912,0,0x820010,"JK109",attributes+0,0,NULL},
  {912,0,0x900010,"JK110",attributes+0,0,NULL},
  {912,0,0x900010,"JK111",attributes+0,0,NULL},
  {912,0,0x900010,"JK112",attributes+0,0,NULL},
  {949,0,0x820010,"JK113",attributes+26,0,NULL},
  {949,0,0x820010,"JK114",attributes+28,0,NULL},
  {950,0,0x880010,"JK115",attributes+0,0,NULL},
  {914,0,0x900010,"JK116",attributes+0,0,NULL},
  {914,0,0x1800010,"JK117",attributes+0,0,NULL},
  {914,0,0x820010,"JK118",attributes+30,0,NULL},
  {914,0,0x1800010,"JK119",attributes+0,0,NULL},
  {914,0,0x900010,"JK120",attributes+0,0,NULL},
  {952,0,0x820010,"JK121",attributes+0,0,NULL},
  {952,0,0x820010,"JK122",attributes+0,0,NULL},
  {952,0,0x820010,"JK123",attributes+0,0,NULL},
  {952,0,0x820010,"JK124",attributes+0,0,NULL},
  {913,0,0x1800010,"JK125",attributes+0,0,NULL},
  {949,0,0x880010,"JK126",attributes+32,0,NULL},
  {949,0,0x820010,"JK127",attributes+34,0,NULL},
  {950,0,0x820010,"JK128",attributes+0,0,NULL},
  {950,0,0x820010,"JK129",attributes+0,0,NULL},
  {950,0,0x820010,"JK130",attributes+0,0,NULL},
  {951,0,0x820010,"JK131",attributes+0,0,NULL},
  {951,0,0x820010,"JK132",attributes+0,0,NULL},
  {951,0,0x820010,"JK133",attributes+0,0,NULL},
  {988,0,0x820010,"JK134",attributes+0,0,NULL},
  {950,0,0x820010,"JK135",attributes+0,0,NULL},
  {950,0,0x1800010,"JK136",attributes+0,0,NULL},
  {912,0,0x1800010,"JK137",attributes+0,0,NULL},
  {949,0,0x820010,"JK138",attributes+0,0,NULL},
  {949,0,0x820010,"JK139",attributes+0,0,NULL},
  {986,0,0x820010,"JK140",attributes+0,0,NULL},
  {950,0,0x1800010,"JK141",attributes+0,0,NULL},
  {950,0,0x1800010,"JK142",attributes+0,0,NULL},
  {950,0,0x820010,"JK143",attributes+0,0,NULL},
  {950,0,0x820010,"JK144",attributes+36,0,NULL},
  {950,0,0x820010,"JK145",attributes+0,0,NULL},
  {950,0,0x900010,"JK146",attributes+0,0,NULL},
  {950,0,0x820010,"JK147",attributes+38,0,NULL},
  {1023,0,0x820010,"JK148",attributes+0,0,NULL},
  {986,0,0x820010,"JK149",attributes+0,0,NULL},
  {1023,0,0x820010,"JK150",attributes+0,0,NULL},
  {1027,0,0x820010,"JK151",attributes+0,0,NULL},
  {950,0,0x1800010,"JK152",attributes+0,0,NULL},
  {950,0,0x1800010,"JK153",attributes+0,0,NULL},
  {950,0,0x1800010,"JK154",attributes+0,0,NULL},
  {949,0,0x820010,"JK155",attributes+0,0,NULL},
  {949,0,0x820010,"JK156",attributes+0,0,NULL},
  {949,0,0x820010,"JK157",attributes+0,0,NULL},
  {986,0,0x900010,"JK158",attributes+0,0,NULL},
  {986,0,0x840010,"JK159",attributes+0,0,NULL},
  {986,0,0x820010,"JK160",attributes+0,0,NULL},
  {986,0,0x820010,"JK161",attributes+0,0,NULL},
  {949,0,0x820010,"JK162",attributes+0,0,NULL},
  {986,0,0x820010,"JK163",attributes+0,0,NULL},
  {912,0,0x900010,"JK164",attributes+0,0,NULL},
  {950,0,0x900010,"JK165",attributes+0,0,NULL},
  {987,0,0x900010,"JK166",attributes+0,0,NULL},
  {987,0,0x900010,"JK167",attributes+0,0,NULL},
  {951,0,0x820010,"JK168",attributes+0,0,NULL},
  {988,0,0x820010,"JK169",attributes+0,0,NULL},
  {988,0,0x900010,"JK170",attributes+0,0,NULL},
  {988,0,0x820010,"JK171",attributes+0,0,NULL},
  {988,0,0x820010,"JK172",attributes+0,0,NULL},
  {988,0,0x820010,"JK173",attributes+0,0,NULL},
  {1062,0,0x820010,"JK174",attributes+0,0,NULL},
  {988,0,0x820010,"JK175",attributes+0,0,NULL},
  {989,0,0x820010,"JK176",attributes+0,0,NULL},
  {990,0,0x820010,"JK177",attributes+0,0,NULL},
  {1138,0,0x820010,"JK178",attributes+0,0,NULL},
  {988,0,0x900010,"JK179",attributes+0,0,NULL},
  {988,0,0x900010,"JK180",attributes+0,0,NULL},
  {988,0,0x900010,"JK181",attributes+0,0,NULL},
  {988,0,0x900010,"JK182",attributes+0,0,NULL},
  {988,0,0x900010,"JK183",attributes+0,0,NULL},
  {988,0,0x900010,"JK184",attributes+0,0,NULL},
  {988,0,0x820010,"JK185",attributes+0,0,NULL},
  {988,0,0x820010,"JK186",attributes+0,0,NULL},
  {988,0,0x820010,"JK187",attributes+0,0,NULL},
  {988,0,0x820010,"JK188",attributes+0,0,NULL},
  {988,0,0x820010,"JK189",attributes+0,0,NULL},
  {988,0,0x900010,"JK190",attributes+0,0,NULL},
  {988,0,0x820010,"JK191",attributes+0,0,NULL},
  {988,0,0x820010,"JK192",attributes+0,0,NULL},
  {988,0,0x820010,"JK193",attributes+0,0,NULL},
  {988,0,0x820010,"JK194",attributes+0,0,NULL},
  {988,0,0x820010,"JK195",attributes+0,0,NULL},
  {990,0,0x820010,"JK196",attributes+0,0,NULL},
  {991,0,0x820010,"JK197",attributes+0,0,NULL},
  {992,0,0x820010,"JK198",attributes+0,0,NULL},
  {988,0,0x820010,"JK199",attributes+0,0,NULL},
  {988,0,0x900010,"JK200",attributes+0,0,NULL},
  {988,0,0x820010,"JK201",attributes+0,0,NULL},
  {988,0,0x900010,"JK202",attributes+0,0,NULL},
  {988,0,0x820010,"JK203",attributes+0,0,NULL},
  {992,0,0x820010,"JK204",attributes+0,0,NULL},
  {991,0,0x820010,"JK205",attributes+0,0,NULL},
  {988,0,0x1800010,"JK206",attributes+0,0,NULL},
  {989,0,0x820010,"JK207",attributes+0,0,NULL},
  {989,0,0x820010,"JK208",attributes+0,0,NULL},
  {988,0,0x1800010,"JK209",attributes+0,0,NULL},
  {988,0,0x820010,"JK210",attributes+0,0,NULL},
  {988,0,0x820010,"JK211",attributes+0,0,NULL},
  {988,0,0x820010,"JK212",attributes+0,0,NULL},
  {988,0,0x820010,"JK213",attributes+0,0,NULL},
  {988,0,0x820010,"JK214",attributes+0,0,NULL},
  {988,0,0x820010,"JK215",attributes+0,0,NULL},
  {988,0,0x820010,"JK216",attributes+0,0,NULL},
  {988,0,0x820010,"JK217",attributes+0,0,NULL},
  {988,0,0x820010,"JK218",attributes+0,0,NULL},
  {1062,0,0x820010,"JK219",attributes+0,0,NULL},
  {1062,0,0x820010,"JK220",attributes+0,0,NULL},
  {1062,0,0x820010,"JK221",attributes+0,0,NULL},
  {1062,0,0x820010,"JK222",attributes+0,0,NULL},
  {1062,0,0x820010,"JK223",attributes+0,0,NULL},
  {1061,0,0x1800010,"JK224",attributes+0,0,NULL},
  {1061,0,0x820010,"JK225",attributes+0,0,NULL},
  {1061,0,0x820010,"JK226",attributes+0,0,NULL},
  {1061,0,0x820010,"JK227",attributes+0,0,NULL},
  {1061,0,0x820010,"JK228",attributes+0,0,NULL},
  {1061,0,0x1800010,"JK229",attributes+0,0,NULL},
  {1061,0,0x820010,"JK230",attributes+0,0,NULL},
  {1061,0,0x820010,"JK231",attributes+0,0,NULL},
  {1061,0,0x820010,"JK232",attributes+0,0,NULL},
  {912,0,0x1800010,"JK233",attributes+0,0,NULL},
  {912,0,0x820010,"JK234",attributes+0,0,NULL},
  {1061,0,0x820010,"JK235",attributes+0,0,NULL},
  {1061,0,0x820010,"JK236",attributes+0,0,NULL},
  {1061,0,0x820010,"JK237",attributes+0,0,NULL},
  {1061,0,0x820010,"JK238",attributes+0,0,NULL},
  {1061,0,0x820010,"JK239",attributes+0,0,NULL},
  {914,0,0x820010,"JK240",attributes+0,0,NULL},
  {986,0,0x820010,"JK241",attributes+0,0,NULL},
  {1024,0,0x900010,"JK242",attributes+0,0,NULL},
  {987,0,0x820010,"JK243",attributes+40,0,NULL},
  {1022,0,0x820010,"JK244",attributes+0,0,NULL},
  {1059,0,0x820010,"JK245",attributes+0,0,NULL},
  {912,0,0x820010,"JK246",attributes+0,0,NULL},
  {987,0,0x900010,"JK247",attributes+0,0,NULL},
  {987,0,0x820010,"JK248",attributes+0,0,NULL},
  {954,0,0x820010,"JK249",attributes+0,0,NULL},
  {950,0,0x820010,"JK250",attributes+0,0,NULL},
  {987,0,0x820010,"JK251",attributes+0,0,NULL},
  {990,0,0x820010,"JK252",attributes+0,0,NULL},
  {1060,0,0x820010,"JK253",attributes+0,0,NULL},
  {988,0,0x820010,"JK254",attributes+42,0,NULL},
  {988,0,0x820010,"JK255",attributes+0,0,NULL},
  {1024,0,0x820010,"JK256",attributes+0,0,NULL},
  {988,0,0x900010,"JK257",attributes+0,0,NULL},
  {986,0,0x900010,"JK258",attributes+0,0,NULL},
  {987,0,0x900010,"JK259",attributes+0,0,NULL},
  {987,0,0x900010,"JK260",attributes+0,0,NULL},
  {988,0,0x900010,"JK261",attributes+0,0,NULL},
  {1025,0,0x900010,"JK262",attributes+0,0,NULL},
  {1025,0,0x900010,"JK263",attributes+0,0,NULL},
  {1025,0,0x820010,"JK264",attributes+44,0,NULL},
  {1025,0,0x900010,"JK265",attributes+0,0,NULL},
  {1099,0,0x820010,"JK266",attributes+46,0,NULL},
  {1062,0,0x900010,"JK267",attributes+0,0,NULL},
  {1025,0,0x900010,"JK268",attributes+0,0,NULL},
  {1062,0,0x900010,"JK269",attributes+0,0,NULL},
  {1062,0,0x900010,"JK270",attributes+0,0,NULL},
  {1063,0,0x900010,"JK271",attributes+0,0,NULL},
  {1064,0,0x900010,"JK272",attributes+0,0,NULL},
  {1023,0,0x820010,"JK273",attributes+48,0,NULL},
  {988,0,0x820010,"JK274",attributes+50,0,NULL},
  {988,0,0x900010,"JK275",attributes+0,0,NULL},
  {991,0,0x820010,"JK276",attributes+52,0,NULL},
  {1060,0,0x820010,"JK277",attributes+54,0,NULL},
  {985,0,0x820010,"JK278",attributes+0,1,autohelperjoseki1359},
  {949,0,0x820010,"JK279",attributes+0,0,NULL},
  {950,0,0x820010,"JK280",attributes+0,0,NULL},
  {987,0,0x820010,"JK281",attributes+0,0,NULL},
  {987,0,0x820010,"JK282",attributes+0,0,NULL},
  {986,0,0x820010,"JK283",attributes+0,0,NULL},
  {1061,0,0x820010,"JK284",attributes+0,0,NULL},
  {1061,0,0x820010,"JK285",attributes+0,0,NULL},
  {1061,0,0x820010,"JK286",attributes+0,0,NULL},
  {1098,0,0x820010,"JK287",attributes+0,0,NULL},
  {1098,0,0x820010,"JK288",attributes+0,0,NULL},
  {1098,0,0x820010,"JK289",attributes+0,0,NULL},
  {1098,0,0x820010,"JK290",attributes+0,0,NULL},
  {1098,0,0x820010,"JK291",attributes+0,0,NULL},
  {1135,0,0x820010,"JK292",attributes+0,0,NULL},
  {1135,0,0x820010,"JK293",attributes+0,0,NULL},
  {1098,0,0x820010,"JK294",attributes+0,0,NULL},
  {1136,0,0x820010,"JK295",attributes+0,0,NULL},
  {1136,0,0x820010,"JK296",attributes+0,0,NULL},
  {1136,0,0x820010,"JK297",attributes+0,0,NULL},
  {1136,0,0x820010,"JK298",attributes+0,0,NULL},
  {1062,0,0x820010,"JK299",attributes+0,0,NULL},
  {1063,0,0x820010,"JK300",attributes+0,0,NULL},
  {1063,0,0x820010,"JK301",attributes+0,0,NULL},
  {1063,0,0x820010,"JK302",attributes+0,0,NULL},
  {1063,0,0x820010,"JK303",attributes+0,0,NULL},
  {1063,0,0x820010,"JK304",attributes+0,0,NULL},
  {1063,0,0x820010,"JK305",attributes+0,0,NULL},
  {1063,0,0x820010,"JK306",attributes+0,0,NULL},
  {1061,0,0x820010,"JK307",attributes+0,0,NULL},
  {1061,0,0x820010,"JK308",attributes+0,0,NULL},
  {1061,0,0x820010,"JK309",attributes+0,0,NULL},
  {1061,0,0x820010,"JK310",attributes+0,0,NULL},
  {1061,0,0x820010,"JK311",attributes+0,0,NULL},
  {1063,0,0x820010,"JK312",attributes+0,0,NULL},
  {1063,0,0x820010,"JK313",attributes+0,0,NULL},
  {1063,0,0x820010,"JK314",attributes+0,0,NULL},
  {1063,0,0x820010,"JK315",attributes+0,0,NULL},
  {1063,0,0x820010,"JK316",attributes+0,0,NULL},
  {1063,0,0x820010,"JK317",attributes+0,0,NULL},
  {1063,0,0x820010,"JK318",attributes+0,0,NULL},
  {1065,0,0x820010,"JK319",attributes+0,0,NULL},
  {1065,0,0x820010,"JK320",attributes+0,0,NULL},
  {1065,0,0x820010,"JK321",attributes+0,0,NULL},
  {1101,0,0x820010,"JK322",attributes+0,0,NULL},
  {1137,0,0x820010,"JK323",attributes+0,0,NULL},
  {1064,0,0x820010,"JK324",attributes+0,0,NULL},
  {1064,0,0x820010,"JK325",attributes+0,0,NULL},
  {1064,0,0x820010,"JK326",attributes+0,0,NULL},
  {1064,0,0x820010,"JK327",attributes+0,0,NULL},
  {1064,0,0x820010,"JK328",attributes+0,0,NULL},
  {1064,0,0x820010,"JK329",attributes+0,0,NULL},
  {1064,0,0x820010,"JK330",attributes+0,0,NULL},
  {1064,0,0x820010,"JK331",attributes+0,0,NULL},
  {1064,0,0x820010,"JK332",attributes+0,0,NULL},
  {1064,0,0x820010,"JK333",attributes+0,0,NULL},
  {1064,0,0x820010,"JK334",attributes+0,0,NULL},
  {1064,0,0x820010,"JK335",attributes+0,0,NULL},
  {1064,0,0x820010,"JK336",attributes+0,0,NULL},
  {1064,0,0x820010,"JK337",attributes+0,0,NULL},
  {1064,0,0x820010,"JK338",attributes+0,0,NULL},
  {1064,0,0x820010,"JK339",attributes+0,0,NULL},
  {1137,0,0x820010,"JK340",attributes+0,0,NULL},
  {911,0,0x1800010,"JK341",attributes+0,0,NULL},
  {986,0,0x820010,"JK342",attributes+0,0,NULL},
  {986,0,0x820010,"JK343",attributes+0,0,NULL},
  {986,0,0x820010,"JK344",attributes+0,0,NULL},
  {986,0,0x820010,"JK345",attributes+0,0,NULL},
  {986,0,0x820010,"JK346",attributes+0,0,NULL},
  {989,0,0x820010,"JK347",attributes+0,0,NULL},
  {950,0,0x820010,"JK348",attributes+0,0,NULL},
  {950,0,0x820010,"JK349",attributes+0,0,NULL},
  {950,0,0x820010,"JK350",attributes+0,0,NULL},
  {950,0,0x820010,"JK351",attributes+0,0,NULL},
  {950,0,0x820010,"JK352",attributes+0,0,NULL},
  {954,0,0x820010,"JK353",attributes+0,0,NULL},
  {913,0,0x820010,"JK354",attributes+0,0,NULL},
  {913,0,0x820010,"JK355",attributes+0,0,NULL},
  {950,0,0x820010,"JK356",attributes+0,0,NULL},
  {950,0,0x820010,"JK357",attributes+0,0,NULL},
  {950,0,0x820010,"JK358",attributes+0,0,NULL},
  {950,0,0x820010,"JK359",attributes+0,0,NULL},
  {950,0,0x820010,"JK360",attributes+0,0,NULL},
  {950,0,0x820010,"JK361",attributes+0,0,NULL},
  {950,0,0x820010,"JK362",attributes+0,0,NULL},
  {950,0,0x820010,"JK363",attributes+0,0,NULL},
  {987,0,0x820010,"JK364",attributes+0,0,NULL},
  {987,0,0x820010,"JK365",attributes+0,0,NULL},
  {987,0,0x820010,"JK366",attributes+0,0,NULL},
  {987,0,0x820010,"JK367",attributes+0,0,NULL},
  {1025,0,0x820010,"JK368",attributes+0,0,NULL},
  {1025,0,0x820010,"JK369",attributes+0,0,NULL},
  {1025,0,0x820010,"JK370",attributes+0,0,NULL},
  {1027,0,0x820010,"JK371",attributes+0,0,NULL},
  {1027,0,0x820010,"JK372",attributes+0,0,NULL},
  {1028,0,0x1800010,"JK373",attributes+0,0,NULL},
  {1028,0,0x820010,"JK374",attributes+0,0,NULL},
  {1028,0,0x820010,"JK375",attributes+0,0,NULL},
  {1028,0,0x820010,"JK376",attributes+0,0,NULL},
  {1028,0,0x820010,"JK377",attributes+0,0,NULL},
  {1028,0,0x840010,"JK378",attributes+0,0,NULL},
  {1028,0,0x820010,"JK379",attributes+0,0,NULL},
  {1028,0,0x820010,"JK380",attributes+0,0,NULL},
  {1100,0,0x840010,"JK381",attributes+0,0,NULL},
  {1100,0,0x820010,"JK382",attributes+0,0,NULL},
  {1100,0,0x820010,"JK383",attributes+0,0,NULL},
  {1100,0,0x820010,"JK384",attributes+0,0,NULL},
  {1100,0,0x820010,"JK385",attributes+0,0,NULL},
  {1100,0,0x820010,"JK386",attributes+0,0,NULL},
  {1100,0,0x820010,"JK387",attributes+0,0,NULL},
  {1102,0,0x820010,"JK388",attributes+0,0,NULL},
  {1062,0,0x820010,"JK389",attributes+0,0,NULL},
  {1062,0,0x820010,"JK390",attributes+0,0,NULL},
  {1024,0,0x820010,"JK391",attributes+0,0,NULL},
  {1024,0,0x820010,"JK392",attributes+0,0,NULL},
  {1024,0,0x820010,"JK393",attributes+0,0,NULL},
  {1024,0,0x820010,"JK394",attributes+0,0,NULL},
  {1024,0,0x820010,"JK395",attributes+0,0,NULL},
  {1024,0,0x820010,"JK396",attributes+0,0,NULL},
  {1024,0,0x820010,"JK397",attributes+0,0,NULL},
  {1024,0,0x820010,"JK398",attributes+0,0,NULL},
  {1024,0,0x820010,"JK399",attributes+0,0,NULL},
  {1024,0,0x820010,"JK400",attributes+0,0,NULL},
  {1024,0,0x820010,"JK401",attributes+0,0,NULL},
  {1024,0,0x820010,"JK402",attributes+0,0,NULL},
  {1024,0,0x820010,"JK403",attributes+0,0,NULL},
  {1024,0,0x820010,"JK404",attributes+0,0,NULL},
  {1024,0,0x820010,"JK405",attributes+0,0,NULL},
  {1064,0,0x840010,"JK406",attributes+0,0,NULL},
  {1064,0,0x820010,"JK407",attributes+0,0,NULL},
  {1065,0,0x820010,"JK408",attributes+0,0,NULL},
  {1022,0,0x820010,"JK409",attributes+0,0,NULL},
  {1022,0,0x820010,"JK410",attributes+0,0,NULL},
  {1022,0,0x1800010,"JK411",attributes+0,0,NULL},
  {1022,0,0x820010,"JK412",attributes+0,0,NULL},
  {1022,0,0x820010,"JK413",attributes+0,0,NULL},
  {1022,0,0x820010,"JK414",attributes+0,0,NULL},
  {1022,0,0x820010,"JK415",attributes+0,0,NULL},
  {1022,0,0x820010,"JK416",attributes+0,0,NULL},
  {1022,0,0x820010,"JK417",attributes+0,0,NULL},
  {1022,0,0x820010,"JK418",attributes+0,0,NULL},
  {1022,0,0x820010,"JK419",attributes+0,0,NULL},
  {1022,0,0x820010,"JK420",attributes+0,0,NULL},
  {1022,0,0x820010,"JK421",attributes+0,0,NULL},
  {1022,0,0x820010,"JK422",attributes+0,0,NULL},
  {1024,0,0x820010,"JK423",attributes+0,0,NULL},
  {1024,0,0x820010,"JK424",attributes+0,0,NULL},
  {1024,0,0x820010,"JK425",attributes+0,0,NULL},
  {1024,0,0x820010,"JK426",attributes+0,0,NULL},
  {1024,0,0x820010,"JK427",attributes+0,0,NULL},
  {1022,0,0x1800010,"JK428",attributes+0,0,NULL},
  {1022,0,0x820010,"JK429",attributes+0,0,NULL},
  {1022,0,0x820010,"JK430",attributes+0,0,NULL},
  {1022,0,0x820010,"JK431",attributes+0,0,NULL},
  {1022,0,0x820010,"JK432",attributes+0,0,NULL},
  {1022,0,0x820010,"JK433",attributes+0,0,NULL},
  {1022,0,0x820010,"JK434",attributes+0,0,NULL},
  {1022,0,0x820010,"JK435",attributes+0,0,NULL},
  {1022,0,0x820010,"JK436",attributes+0,0,NULL},
  {1022,0,0x820010,"JK437",attributes+0,0,NULL},
  {1022,0,0x820010,"JK438",attributes+0,0,NULL},
  {1022,0,0x820010,"JK439",attributes+0,0,NULL},
  {1022,0,0x820010,"JK440",attributes+0,0,NULL},
  {1022,0,0x820010,"JK441",attributes+0,0,NULL},
  {1023,0,0x820010,"JK442",attributes+0,0,NULL},
  {1023,0,0x820010,"JK443",attributes+0,0,NULL},
  {1023,0,0x820010,"JK444",attributes+0,0,NULL},
  {1023,0,0x820010,"JK445",attributes+0,0,NULL},
  {1023,0,0x820010,"JK446",attributes+0,0,NULL},
  {1023,0,0x820010,"JK447",attributes+0,0,NULL},
  {1023,0,0x820010,"JK448",attributes+0,0,NULL},
  {1023,0,0x820010,"JK449",attributes+0,0,NULL},
  {988,1,0x840010,"JS1",attributes+0,0,NULL},
  {837,0,0x820010,"JS2",attributes+0,0,NULL},
  {912,0,0x820010,"JS3",attributes+0,0,NULL},
  {912,0,0x820010,"JS4",attributes+0,0,NULL},
  {949,0,0x820010,"JS5",attributes+56,0,NULL},
  {988,0,0x820010,"JS6",attributes+0,0,NULL},
  {948,0,0x820010,"JS7",attributes+0,0,NULL},
  {912,0,0x900010,"JS8",attributes+0,0,NULL},
  {912,0,0x900010,"JS9",attributes+0,0,NULL},
  {912,0,0x900010,"JS10",attributes+0,0,NULL},
  {912,1,0x900010,"JS11",attributes+0,0,NULL},
  {912,0,0x820010,"JM1",attributes+0,0,NULL},
  {912,0,0x820010,"JM2",attributes+0,0,NULL},
  {913,0,0x820010,"JM3",attributes+0,0,NULL},
  {913,0,0x820010,"JM4",attributes+0,0,NULL},
  {1061,0,0x900010,"JM5",attributes+0,0,NULL},
  {914,0,0x820010,"JM6",attributes+0,0,NULL},
  {1097,0,0x820010,"JM7",attributes+0,0,NULL},
  {1060,0,0x840010,"JM8",attributes+0,0,NULL},
  {912,0,0x820010,"JM9",attributes+0,0,NULL},
  {986,0,0x820010,"JM10",attributes+0,0,NULL},
  {987,0,0x820010,"JM11",attributes+0,0,NULL},
  {1097,0,0x820010,"JM12",attributes+0,0,NULL},
  {1060,0,0x840010,"JM13",attributes+0,0,NULL},
  {948,0,0x840010,"JT1",attributes+0,0,NULL},
  {948,0,0x820010,"JT2",attributes+0,0,NULL},
  {948,0,0x820010,"JT3",attributes+0,0,NULL},
  {948,0,0x900010,"JT4",attributes+0,0,NULL},
  {1021,0,0x820010,"JT5",attributes+0,0,NULL},
  {876,0,0x900010,"JT6",attributes+0,0,NULL},
  {949,0,0x840010,"JT7",attributes+0,0,NULL},
  {949,0,0x900010,"JT8",attributes+0,0,NULL},
  {949,0,0x820010,"JT9",attributes+0,0,NULL},
  {950,0,0x900010,"JT10",attributes+0,0,NULL},
  {950,0,0x900010,"JT11",attributes+0,0,NULL},
  {950,0,0x900010,"JT12",attributes+0,0,NULL},
  {950,0,0x900010,"JT13",attributes+0,0,NULL},
  {950,0,0x900010,"JT14",attributes+0,0,NULL},
  {948,0,0x900010,"JT15",attributes+0,0,NULL},
  {951,0,0x840010,"JT16",attributes+0,0,NULL},
  {951,0,0x900010,"JT17",attributes+0,0,NULL},
  {988,0,0x900010,"JT18",attributes+0,0,NULL},
  {951,0,0x900010,"JT19",attributes+0,0,NULL},
  {951,0,0x820010,"JT20",attributes+58,0,NULL},
  {951,0,0x820010,"JT21",attributes+0,0,NULL},
  {951,0,0x820010,"JT22",attributes+0,0,NULL},
  {988,0,0x900010,"JT23",attributes+0,0,NULL},
  {951,0,0x900010,"JT24",attributes+0,0,NULL},
  {951,0,0x900010,"JT25",attributes+0,0,NULL},
  {951,0,0x900010,"JT26",attributes+0,0,NULL},
  {951,0,0x900010,"JT27",attributes+0,0,NULL},
  {988,0,0x900010,"JT28",attributes+0,0,NULL},
  {988,0,0x900010,"JT29",attributes+0,0,NULL},
  {988,0,0x900010,"JT30",attributes+0,0,NULL},
  {988,0,0x900010,"JT31",attributes+0,0,NULL},
  {988,0,0x900010,"JT32",attributes+0,0,NULL},
  {988,0,0x900010,"JT33",attributes+0,0,NULL},
  {874,0,0x900010,"JT34",attributes+0,0,NULL},
  {912,0,0x820010,"JT35",attributes+0,0,NULL},
  {875,0,0x900010,"JT36",attributes+0,0,NULL},
  {912,0,0x820010,"JT37",attributes+0,0,NULL},
  {912,0,0x820010,"JT38",attributes+0,0,NULL},
  {912,0,0x820010,"JT39",attributes+0,0,NULL},
  {912,0,0x820010,"JT40",attributes+0,0,NULL},
  {912,0,0x820010,"JT41",attributes+0,0,NULL},
  {949,0,0x820010,"JT42",attributes+0,0,NULL},
  {986,0,0x820010,"JT43",attributes+0,0,NULL},
  {949,0,0x820010,"JT44",attributes+0,0,NULL},
  {949,0,0x820010,"JT45",attributes+0,0,NULL},
  {914,0,0x900010,"JT46",attributes+0,0,NULL},
  {988,0,0x820010,"JT47",attributes+0,0,NULL},
  {1025,0,0x820010,"JT48",attributes+0,0,NULL},
  {1025,0,0x820010,"JT49",attributes+0,0,NULL},
  {1025,0,0x820010,"JT50",attributes+0,0,NULL},
  {1025,0,0x820010,"JT51",attributes+0,0,NULL},
  {1025,0,0x900010,"JT52",attributes+0,0,NULL},
  {988,0,0x820010,"JT53",attributes+0,0,NULL},
  {988,0,0x820010,"JT54",attributes+0,0,NULL},
  {1099,0,0x820010,"JT55",attributes+0,0,NULL},
  {1099,0,0x820010,"JT56",attributes+0,0,NULL},
  {1100,0,0x820010,"JT57",attributes+0,0,NULL},
  {989,0,0x820010,"JT58",attributes+0,0,NULL},
  {989,0,0x820010,"JT59",attributes+0,0,NULL},
  {989,0,0x820010,"JT60",attributes+0,0,NULL},
  {989,0,0x820010,"JT61",attributes+0,0,NULL},
  {989,0,0x820010,"JT62",attributes+0,0,NULL},
  {989,0,0x820010,"JT63",attributes+0,0,NULL},
  {1137,0,0x820010,"JT64",attributes+0,1,autohelperjoseki1618},
  {1100,0,0x820010,"JT65",attributes+0,0,NULL},
  {989,0,0x820010,"JT66",attributes+0,1,autohelperjoseki1620},
  {951,0,0x880010,"JT67",attributes+0,0,NULL}
};


static struct corner_variation joseki_variations[] = {
  {760,0,1,15,&joseki_variations[7402],NULL},
  {759,0,1,7,&joseki_variations[6808],NULL},
  {722,0,1,9,&joseki_variations[5408],NULL},
  {798,0,1,11,&joseki_variations[4964],NULL},
  {761,0,1,15,&joseki_variations[4334],NULL},
  {834,0,1,4,&joseki_variations[3933],NULL},
  {796,0,1,5,&joseki_variations[3666],NULL},
  {723,0,1,5,&joseki_variations[2965],NULL},
  {724,0,1,7,&joseki_variations[2559],NULL},
  {763,0,1,5,&joseki_variations[2450],NULL},
  {762,0,1,1,&joseki_variations[2422],NULL},
  {721,0,1,6,&joseki_variations[803],NULL},
  {684,0,1,2,&joseki_variations[748],NULL},
  {758,0,1,2,&joseki_variations[685],NULL},
  {685,0,1,1,&joseki_variations[432],NULL},
  {797,0,1,6,&joseki_variations[16],NULL},
  {798,3,2,1,&joseki_variations[427],NULL},
  {724,0,1,1,&joseki_variations[382],NULL},
  {798,0,2,1,&joseki_variations[378],NULL},
  {761,0,1,10,&joseki_variations[73],NULL},
  {834,0,2,3,&joseki_variations[30],NULL},
  {834,3,2,1,&joseki_variations[22],NULL},
  {761,3,1,2,&joseki_variations[23],NULL},
  {800,0,3,1,&joseki_variations[28],NULL},
  {798,3,3,1,&joseki_variations[25],NULL},
  {800,0,4,1,&joseki_variations[26],NULL},
  {835,0,5,1,&joseki_variations[27],NULL},
  {760,0,1,0,NULL,&joseki[1589]},
  {835,0,4,1,&joseki_variations[29],NULL},
  {798,3,3,0,NULL,&joseki[1588]},
  {724,3,1,1,&joseki_variations[67],NULL},
  {761,0,1,2,&joseki_variations[48],NULL},
  {724,0,1,1,&joseki_variations[33],NULL},
  {761,0,2,1,&joseki_variations[34],NULL},
  {798,3,4,1,&joseki_variations[35],NULL},
  {835,3,6,3,&joseki_variations[36],NULL},
  {762,3,3,1,&joseki_variations[47],NULL},
  {872,3,7,1,&joseki_variations[44],NULL},
  {871,0,3,1,&joseki_variations[39],NULL},
  {872,3,8,1,&joseki_variations[40],NULL},
  {725,0,2,1,&joseki_variations[41],NULL},
  {762,3,4,1,&joseki_variations[42],NULL},
  {763,3,5,1,&joseki_variations[43],NULL},
  {909,3,9,0,NULL,&joseki[1221]},
  {725,0,2,1,&joseki_variations[45],NULL},
  {762,3,4,1,&joseki_variations[46],NULL},
  {763,3,5,0,NULL,&joseki[1220]},
  {872,3,7,0,NULL,&joseki[1219]},
  {798,3,3,1,&joseki_variations[55],NULL},
  {800,3,3,1,&joseki_variations[50],NULL},
  {835,3,4,1,&joseki_variations[51],NULL},
  {871,3,3,1,&joseki_variations[52],NULL},
  {872,3,6,2,&joseki_variations[53],&joseki[1574]},
  {726,0,1,0,NULL,&joseki[1575]},
  {725,3,1,0,NULL,&joseki[1576]},
  {835,3,5,3,&joseki_variations[56],NULL},
  {725,0,1,1,&joseki_variations[63],NULL},
  {762,3,2,2,&joseki_variations[60],NULL},
  {800,3,4,1,&joseki_variations[59],NULL},
  {760,3,1,0,NULL,&joseki[1579]},
  {724,0,1,0,NULL,&joseki[1218]},
  {799,0,5,1,&joseki_variations[62],&joseki[1222]},
  {763,3,3,0,NULL,&joseki[1223]},
  {762,3,3,1,&joseki_variations[64],NULL},
  {726,3,2,2,&joseki_variations[65],NULL},
  {724,0,1,0,NULL,&joseki[1216]},
  {799,0,6,0,NULL,&joseki[1217]},
  {761,0,2,1,&joseki_variations[68],NULL},
  {798,3,4,1,&joseki_variations[69],NULL},
  {835,3,6,1,&joseki_variations[70],NULL},
  {725,0,2,1,&joseki_variations[71],NULL},
  {762,3,4,1,&joseki_variations[72],NULL},
  {760,0,1,0,NULL,&joseki[1192]},
  {798,3,3,2,&joseki_variations[350],NULL},
  {834,0,2,1,&joseki_variations[261],NULL},
  {799,0,3,1,&joseki_variations[254],NULL},
  {800,0,3,3,&joseki_variations[171],NULL},
  {764,0,2,1,&joseki_variations[153],NULL},
  {799,3,3,1,&joseki_variations[134],NULL},
  {762,3,2,1,&joseki_variations[114],NULL},
  {833,3,1,1,&joseki_variations[93],NULL},
  {834,3,2,2,&joseki_variations[84],NULL},
  {871,3,2,1,&joseki_variations[83],NULL},
  {982,3,3,0,NULL,&joseki[1518]},
  {835,0,4,1,&joseki_variations[90],NULL},
  {798,0,3,1,&joseki_variations[86],NULL},
  {835,0,5,1,&joseki_variations[87],NULL},
  {836,3,6,1,&joseki_variations[88],NULL},
  {872,3,6,1,&joseki_variations[89],NULL},
  {871,3,3,0,NULL,&joseki[1427]},
  {872,3,5,1,&joseki_variations[91],NULL},
  {836,3,5,1,&joseki_variations[92],&joseki[1425]},
  {798,0,3,0,NULL,&joseki[1426]},
  {834,3,3,1,&joseki_variations[94],NULL},
  {908,0,4,1,&joseki_variations[95],NULL},
  {909,0,6,1,&joseki_variations[96],NULL},
  {945,0,5,1,&joseki_variations[97],NULL},
  {946,3,8,1,&joseki_variations[98],NULL},
  {982,0,6,1,&joseki_variations[99],NULL},
  {983,3,10,1,&joseki_variations[100],NULL},
  {1019,0,7,1,&joseki_variations[101],NULL},
  {1020,3,12,1,&joseki_variations[102],NULL},
  {1057,0,13,1,&joseki_variations[103],NULL},
  {725,0,1,1,&joseki_variations[104],NULL},
  {762,3,3,1,&joseki_variations[105],NULL},
  {799,3,5,1,&joseki_variations[106],NULL},
  {836,3,8,1,&joseki_variations[107],NULL},
  {910,3,11,1,&joseki_variations[108],NULL},
  {763,0,4,1,&joseki_variations[109],NULL},
  {800,0,7,1,&joseki_variations[110],NULL},
  {837,3,11,1,&joseki_variations[111],NULL},
  {764,0,5,1,&joseki_variations[112],NULL},
  {801,3,9,1,&joseki_variations[113],NULL},
  {765,3,6,0,NULL,&joseki[1387]},
  {799,3,4,1,&joseki_variations[115],NULL},
  {763,0,3,1,&joseki_variations[116],NULL},
  {800,0,6,1,&joseki_variations[117],NULL},
  {764,0,4,1,&joseki_variations[118],NULL},
  {801,3,8,1,&joseki_variations[119],NULL},
  {833,3,1,1,&joseki_variations[120],NULL},
  {834,3,3,1,&joseki_variations[121],NULL},
  {836,3,7,1,&joseki_variations[122],NULL},
  {837,3,10,1,&joseki_variations[123],NULL},
  {908,0,4,1,&joseki_variations[124],NULL},
  {909,0,6,1,&joseki_variations[125],NULL},
  {910,3,10,1,&joseki_variations[126],NULL},
  {945,0,5,1,&joseki_variations[127],NULL},
  {946,3,8,1,&joseki_variations[128],NULL},
  {982,0,6,1,&joseki_variations[129],NULL},
  {983,3,10,1,&joseki_variations[130],NULL},
  {1019,0,7,1,&joseki_variations[131],NULL},
  {1020,3,12,1,&joseki_variations[132],NULL},
  {1057,0,13,1,&joseki_variations[133],NULL},
  {725,0,1,0,NULL,&joseki[1386]},
  {763,0,2,1,&joseki_variations[135],NULL},
  {800,0,5,1,&joseki_variations[136],NULL},
  {764,0,3,1,&joseki_variations[137],NULL},
  {801,3,7,1,&joseki_variations[138],NULL},
  {833,3,1,1,&joseki_variations[139],NULL},
  {834,3,3,1,&joseki_variations[140],NULL},
  {836,3,6,1,&joseki_variations[141],NULL},
  {837,3,9,1,&joseki_variations[142],NULL},
  {908,0,4,1,&joseki_variations[143],NULL},
  {909,0,6,1,&joseki_variations[144],NULL},
  {910,3,9,1,&joseki_variations[145],NULL},
  {945,0,5,1,&joseki_variations[146],NULL},
  {946,3,8,1,&joseki_variations[147],NULL},
  {982,0,6,1,&joseki_variations[148],NULL},
  {983,3,10,1,&joseki_variations[149],NULL},
  {1019,0,7,1,&joseki_variations[150],NULL},
  {1020,3,12,1,&joseki_variations[151],NULL},
  {1057,0,13,1,&joseki_variations[152],NULL},
  {762,3,2,0,NULL,&joseki[1385]},
  {799,3,3,1,&joseki_variations[154],NULL},
  {800,0,4,1,&joseki_variations[155],NULL},
  {801,3,6,1,&joseki_variations[156],NULL},
  {833,3,1,1,&joseki_variations[157],NULL},
  {834,3,3,1,&joseki_variations[158],NULL},
  {836,3,6,1,&joseki_variations[159],NULL},
  {837,3,8,1,&joseki_variations[160],NULL},
  {908,0,4,1,&joseki_variations[161],NULL},
  {909,0,6,1,&joseki_variations[162],NULL},
  {910,3,9,1,&joseki_variations[163],NULL},
  {945,0,5,1,&joseki_variations[164],NULL},
  {946,3,8,1,&joseki_variations[165],NULL},
  {982,0,6,1,&joseki_variations[166],NULL},
  {983,3,10,1,&joseki_variations[167],NULL},
  {1019,0,7,1,&joseki_variations[168],NULL},
  {1020,3,12,1,&joseki_variations[169],NULL},
  {1057,0,13,1,&joseki_variations[170],NULL},
  {763,0,2,0,NULL,&joseki[1384]},
  {834,3,2,2,&joseki_variations[223],NULL},
  {833,3,1,1,&joseki_variations[190],NULL},
  {832,3,1,1,&joseki_variations[174],NULL},
  {833,3,2,1,&joseki_variations[175],NULL},
  {834,3,4,1,&joseki_variations[176],NULL},
  {835,0,6,1,&joseki_variations[177],NULL},
  {869,0,2,1,&joseki_variations[178],NULL},
  {870,0,4,1,&joseki_variations[179],NULL},
  {871,0,7,1,&joseki_variations[180],NULL},
  {872,3,10,1,&joseki_variations[181],NULL},
  {906,0,3,1,&joseki_variations[182],NULL},
  {908,0,9,1,&joseki_variations[183],NULL},
  {909,3,13,1,&joseki_variations[184],NULL},
  {944,0,6,1,&joseki_variations[185],NULL},
  {945,3,11,1,&joseki_variations[186],NULL},
  {981,3,7,1,&joseki_variations[187],NULL},
  {982,3,13,1,&joseki_variations[188],NULL},
  {836,3,7,1,&joseki_variations[189],&joseki[1485]},
  {798,0,3,0,NULL,&joseki[1486]},
  {834,3,3,1,&joseki_variations[191],NULL},
  {836,3,5,1,&joseki_variations[192],NULL},
  {908,0,4,2,&joseki_variations[193],NULL},
  {946,3,6,1,&joseki_variations[222],NULL},
  {945,0,5,2,&joseki_variations[195],NULL},
  {946,3,7,1,&joseki_variations[220],NULL},
  {909,0,6,1,&joseki_variations[197],NULL},
  {946,3,8,2,&joseki_variations[198],NULL},
  {983,3,9,1,&joseki_variations[218],NULL},
  {910,3,8,1,&joseki_variations[200],NULL},
  {982,0,6,1,&joseki_variations[201],NULL},
  {983,3,10,2,&joseki_variations[202],NULL},
  {1020,3,11,2,&joseki_variations[215],&joseki[1372]},
  {1019,0,7,1,&joseki_variations[204],NULL},
  {1020,3,12,1,&joseki_variations[205],NULL},
  {837,3,7,2,&joseki_variations[206],&joseki[1376]},
  {801,0,4,1,&joseki_variations[213],&joseki[1377]},
  {1057,0,13,2,&joseki_variations[208],&joseki[1380]},
  {801,3,4,1,&joseki_variations[212],&joseki[1381]},
  {764,0,2,1,&joseki_variations[210],NULL},
  {801,3,5,1,&joseki_variations[211],NULL},
  {799,3,3,0,NULL,&joseki[1383]},
  {764,0,2,0,NULL,&joseki[1382]},
  {1057,3,13,1,&joseki_variations[214],&joseki[1378]},
  {1093,0,8,0,NULL,&joseki[1379]},
  {1056,0,7,1,&joseki_variations[217],&joseki[1373]},
  {1019,0,7,0,NULL,&joseki[1375]},
  {872,3,5,0,NULL,&joseki[1374]},
  {910,3,8,1,&joseki_variations[219],&joseki[1370]},
  {982,0,6,0,NULL,&joseki[1371]},
  {983,3,8,1,&joseki_variations[221],&joseki[1368]},
  {909,0,6,0,NULL,&joseki[1369]},
  {945,0,5,0,NULL,&joseki[1367]},
  {836,3,4,2,&joseki_variations[228],NULL},
  {945,3,3,1,&joseki_variations[225],NULL},
  {835,3,4,2,&joseki_variations[226],&joseki[1451]},
  {802,0,4,0,NULL,&joseki[1452]},
  {766,0,2,0,NULL,&joseki[1453]},
  {908,0,3,2,&joseki_variations[241],NULL},
  {802,3,4,1,&joseki_variations[230],NULL},
  {804,3,5,1,&joseki_variations[231],NULL},
  {837,0,6,1,&joseki_variations[232],NULL},
  {839,0,8,1,&joseki_variations[233],NULL},
  {871,3,3,1,&joseki_variations[234],NULL},
  {874,3,8,1,&joseki_variations[235],NULL},
  {875,0,9,1,&joseki_variations[236],NULL},
  {908,0,4,1,&joseki_variations[237],NULL},
  {909,3,6,1,&joseki_variations[238],NULL},
  {911,3,11,1,&joseki_variations[239],NULL},
  {945,0,5,1,&joseki_variations[240],NULL},
  {1056,0,6,0,NULL,&joseki[1403]},
  {946,3,5,2,&joseki_variations[252],NULL},
  {802,3,4,1,&joseki_variations[243],NULL},
  {804,3,5,1,&joseki_variations[244],NULL},
  {837,0,6,1,&joseki_variations[245],NULL},
  {839,0,8,1,&joseki_variations[246],NULL},
  {874,3,7,1,&joseki_variations[247],NULL},
  {875,0,8,1,&joseki_variations[248],NULL},
  {909,3,5,1,&joseki_variations[249],NULL},
  {911,3,10,1,&joseki_variations[250],NULL},
  {945,0,4,1,&joseki_variations[251],NULL},
  {871,3,3,0,NULL,&joseki[1402]},
  {833,3,1,0,NULL,&joseki[1366]},
  {796,3,1,0,NULL,&joseki[1388]},
  {834,3,2,2,&joseki_variations[255],NULL},
  {909,3,4,1,&joseki_variations[260],NULL},
  {871,3,3,1,&joseki_variations[257],NULL},
  {872,0,5,1,&joseki_variations[258],NULL},
  {908,3,4,1,&joseki_variations[259],NULL},
  {767,0,2,0,NULL,&joseki[1330]},
  {835,3,4,0,NULL,&joseki[1324]},
  {835,3,4,4,&joseki_variations[262],NULL},
  {871,3,3,2,&joseki_variations[305],NULL},
  {836,3,5,1,&joseki_variations[283],NULL},
  {762,3,2,1,&joseki_variations[275],NULL},
  {870,0,1,1,&joseki_variations[266],NULL},
  {871,3,4,1,&joseki_variations[267],NULL},
  {907,0,2,1,&joseki_variations[268],NULL},
  {909,3,8,1,&joseki_variations[269],NULL},
  {725,0,1,1,&joseki_variations[270],NULL},
  {762,3,3,1,&joseki_variations[271],NULL},
  {836,3,7,1,&joseki_variations[272],NULL},
  {873,0,10,1,&joseki_variations[273],NULL},
  {874,3,11,1,&joseki_variations[274],NULL},
  {764,3,4,0,NULL,&joseki[1122]},
  {836,3,6,1,&joseki_variations[276],NULL},
  {870,0,1,1,&joseki_variations[277],NULL},
  {871,3,4,1,&joseki_variations[278],NULL},
  {873,0,9,1,&joseki_variations[279],NULL},
  {874,3,10,1,&joseki_variations[280],NULL},
  {907,0,2,1,&joseki_variations[281],NULL},
  {909,3,8,1,&joseki_variations[282],NULL},
  {725,0,1,0,NULL,&joseki[1121]},
  {870,0,1,1,&joseki_variations[284],NULL},
  {871,3,4,2,&joseki_variations[285],NULL},
  {873,0,8,3,&joseki_variations[294],NULL},
  {872,0,7,1,&joseki_variations[287],NULL},
  {873,0,9,1,&joseki_variations[288],NULL},
  {907,3,2,2,&joseki_variations[289],NULL},
  {909,3,9,1,&joseki_variations[293],NULL},
  {908,3,6,1,&joseki_variations[291],NULL},
  {909,3,10,1,&joseki_variations[292],NULL},
  {837,0,6,0,NULL,&joseki[1126]},
  {908,3,6,0,NULL,&joseki[1125]},
  {909,3,7,2,&joseki_variations[302],NULL},
  {874,3,9,1,&joseki_variations[299],NULL},
  {907,3,2,1,&joseki_variations[297],NULL},
  {909,3,8,1,&joseki_variations[298],NULL},
  {872,0,7,0,NULL,&joseki[1124]},
  {907,0,2,1,&joseki_variations[300],NULL},
  {909,3,8,1,&joseki_variations[301],NULL},
  {762,3,2,0,NULL,&joseki[1120]},
  {874,3,9,1,&joseki_variations[304],&joseki[1118]},
  {907,3,2,0,NULL,&joseki[1123]},
  {907,0,2,0,NULL,&joseki[1119]},
  {872,3,6,6,&joseki_variations[319],&joseki[1085]},
  {909,3,6,4,&joseki_variations[307],&joseki[1112]},
  {763,0,2,1,&joseki_variations[318],&joseki[1113]},
  {873,0,6,2,&joseki_variations[316],&joseki[1115]},
  {836,3,5,1,&joseki_variations[314],NULL},
  {799,0,3,1,&joseki_variations[311],&joseki[1131]},
  {1056,3,4,1,&joseki_variations[312],&joseki[1132]},
  {873,0,7,1,&joseki_variations[313],&joseki[1133]},
  {910,3,9,0,NULL,&joseki[1134]},
  {873,0,7,1,&joseki_variations[315],NULL},
  {870,0,1,0,NULL,&joseki[1117]},
  {836,3,5,0,NULL,&joseki[1116]},
  {872,3,6,0,NULL,&joseki[1127]},
  {1056,3,4,0,NULL,&joseki[1114]},
  {763,0,2,2,&joseki_variations[342],&joseki[1086]},
  {762,3,2,1,&joseki_variations[341],&joseki[1092]},
  {725,0,1,1,&joseki_variations[339],NULL},
  {983,0,7,2,&joseki_variations[334],&joseki[1099]},
  {799,0,3,2,&joseki_variations[327],&joseki[1108]},
  {873,0,7,1,&joseki_variations[325],NULL},
  {909,3,7,1,&joseki_variations[326],NULL},
  {799,0,3,0,NULL,&joseki[1128]},
  {1019,3,4,1,&joseki_variations[332],&joseki[1109]},
  {873,0,8,1,&joseki_variations[329],NULL},
  {909,3,7,1,&joseki_variations[330],NULL},
  {1056,3,4,1,&joseki_variations[331],&joseki[1129]},
  {767,0,2,0,NULL,&joseki[1130]},
  {767,0,2,1,&joseki_variations[333],&joseki[1110]},
  {874,0,8,0,NULL,&joseki[1111]},
  {762,3,2,1,&joseki_variations[338],&joseki[1100]},
  {725,0,1,1,&joseki_variations[336],NULL},
  {762,3,3,1,&joseki_variations[337],NULL},
  {798,3,3,0,NULL,&joseki[1102]},
  {725,0,1,0,NULL,&joseki[1101]},
  {762,3,3,1,&joseki_variations[340],NULL},
  {798,3,3,0,NULL,&joseki[1094]},
  {725,0,1,0,NULL,&joseki[1093]},
  {1019,3,4,1,&joseki_variations[347],&joseki[1087]},
  {945,0,4,1,&joseki_variations[344],NULL},
  {1019,3,5,1,&joseki_variations[345],NULL},
  {1093,0,6,1,&joseki_variations[346],NULL},
  {944,3,1,0,NULL,&joseki[1091]},
  {1093,0,5,2,&joseki_variations[348],&joseki[1088]},
  {1021,3,8,0,NULL,&joseki[1089]},
  {945,0,4,0,NULL,&joseki[1090]},
  {872,3,4,1,&joseki_variations[373],NULL},
  {834,0,2,1,&joseki_variations[352],NULL},
  {835,3,5,3,&joseki_variations[353],NULL},
  {871,3,3,1,&joseki_variations[367],NULL},
  {762,3,2,4,&joseki_variations[358],&joseki[1137]},
  {725,0,1,1,&joseki_variations[356],NULL},
  {762,3,3,1,&joseki_variations[357],NULL},
  {724,3,1,0,NULL,&joseki[1191]},
  {760,0,1,0,NULL,&joseki[1138]},
  {872,0,6,1,&joseki_variations[366],&joseki[1149]},
  {871,0,3,1,&joseki_variations[362],&joseki[1164]},
  {725,0,1,0,NULL,&joseki[1190]},
  {872,3,7,1,&joseki_variations[363],&joseki[1165]},
  {909,0,8,2,&joseki_variations[364],&joseki[1166]},
  {760,3,1,0,NULL,&joseki[1167]},
  {910,3,10,0,NULL,&joseki[1189]},
  {760,3,1,0,NULL,&joseki[1150]},
  {872,3,7,1,&joseki_variations[368],NULL},
  {725,0,1,1,&joseki_variations[369],NULL},
  {762,3,3,2,&joseki_variations[370],NULL},
  {723,0,1,0,NULL,&joseki[1095]},
  {983,0,8,1,&joseki_variations[372],NULL},
  {723,0,1,0,NULL,&joseki[1103]},
  {725,3,1,1,&joseki_variations[374],NULL},
  {762,3,3,1,&joseki_variations[375],NULL},
  {799,0,6,1,&joseki_variations[376],NULL},
  {801,0,7,1,&joseki_variations[377],NULL},
  {835,3,4,0,NULL,&joseki[1070]},
  {872,3,3,1,&joseki_variations[379],NULL},
  {800,3,3,1,&joseki_variations[380],NULL},
  {874,3,5,1,&joseki_variations[381],&joseki[922]},
  {870,0,1,0,NULL,&joseki[923]},
  {761,0,2,1,&joseki_variations[383],NULL},
  {798,3,4,4,&joseki_variations[384],NULL},
  {725,0,2,1,&joseki_variations[420],NULL},
  {872,3,5,1,&joseki_variations[414],NULL},
  {835,3,5,1,&joseki_variations[407],NULL},
  {833,0,1,1,&joseki_variations[388],NULL},
  {835,3,6,2,&joseki_variations[389],NULL},
  {872,3,7,1,&joseki_variations[401],NULL},
  {870,3,2,1,&joseki_variations[391],NULL},
  {872,3,8,1,&joseki_variations[392],NULL},
  {725,3,2,1,&joseki_variations[393],NULL},
  {762,3,4,1,&joseki_variations[394],NULL},
  {799,0,7,1,&joseki_variations[395],NULL},
  {727,3,3,2,&joseki_variations[396],NULL},
  {801,0,9,1,&joseki_variations[400],NULL},
  {800,0,8,1,&joseki_variations[398],NULL},
  {801,0,10,1,&joseki_variations[399],NULL},
  {760,3,1,0,NULL,&joseki[1056]},
  {722,0,1,0,NULL,&joseki[1054]},
  {725,3,2,1,&joseki_variations[402],NULL},
  {762,3,4,1,&joseki_variations[403],NULL},
  {799,0,7,1,&joseki_variations[404],NULL},
  {727,3,3,1,&joseki_variations[405],NULL},
  {801,0,9,1,&joseki_variations[406],NULL},
  {870,3,2,0,NULL,&joseki[1053]},
  {872,3,6,1,&joseki_variations[408],NULL},
  {725,3,2,1,&joseki_variations[409],NULL},
  {762,3,4,1,&joseki_variations[410],NULL},
  {799,0,7,1,&joseki_variations[411],NULL},
  {727,3,3,1,&joseki_variations[412],NULL},
  {801,0,9,1,&joseki_variations[413],NULL},
  {833,0,1,0,NULL,&joseki[1052]},
  {725,3,2,1,&joseki_variations[415],NULL},
  {762,3,4,1,&joseki_variations[416],NULL},
  {799,0,7,1,&joseki_variations[417],NULL},
  {727,3,3,1,&joseki_variations[418],NULL},
  {801,0,9,1,&joseki_variations[419],NULL},
  {835,3,5,0,NULL,&joseki[1051]},
  {762,3,4,1,&joseki_variations[421],NULL},
  {799,3,7,1,&joseki_variations[422],NULL},
  {726,3,3,1,&joseki_variations[423],NULL},
  {764,3,6,1,&joseki_variations[424],NULL},
  {804,3,10,1,&joseki_variations[425],NULL},
  {834,3,2,1,&joseki_variations[426],&joseki[873]},
  {796,0,1,0,NULL,&joseki[874]},
  {725,0,1,1,&joseki_variations[428],NULL},
  {762,3,2,1,&joseki_variations[429],NULL},
  {764,3,3,1,&joseki_variations[430],NULL},
  {804,3,6,1,&joseki_variations[431],NULL},
  {761,3,1,0,NULL,&joseki[861]},
  {722,3,2,3,&joseki_variations[433],NULL},
  {759,3,3,2,&joseki_variations[494],NULL},
  {759,0,3,1,&joseki_variations[465],NULL},
  {723,0,3,1,&joseki_variations[436],NULL},
  {760,3,4,1,&joseki_variations[437],NULL},
  {797,3,5,1,&joseki_variations[438],NULL},
  {724,0,4,1,&joseki_variations[439],NULL},
  {761,0,6,2,&joseki_variations[440],NULL},
  {798,3,8,1,&joseki_variations[451],NULL},
  {798,0,8,1,&joseki_variations[442],NULL},
  {800,3,9,1,&joseki_variations[443],NULL},
  {833,3,3,1,&joseki_variations[444],NULL},
  {834,0,7,1,&joseki_variations[445],NULL},
  {835,3,11,1,&joseki_variations[446],NULL},
  {836,3,12,1,&joseki_variations[447],NULL},
  {870,3,4,1,&joseki_variations[448],NULL},
  {871,0,9,1,&joseki_variations[449],NULL},
  {908,0,10,1,&joseki_variations[450],NULL},
  {759,3,3,0,NULL,&joseki[1599]},
  {872,3,9,2,&joseki_variations[452],NULL},
  {762,3,7,1,&joseki_variations[460],NULL},
  {725,3,5,1,&joseki_variations[454],NULL},
  {762,3,8,1,&joseki_variations[455],NULL},
  {799,0,11,1,&joseki_variations[456],NULL},
  {836,3,12,1,&joseki_variations[457],NULL},
  {800,0,12,1,&joseki_variations[458],NULL},
  {801,0,13,1,&joseki_variations[459],NULL},
  {759,0,3,0,NULL,&joseki[1043]},
  {799,0,10,1,&joseki_variations[461],NULL},
  {836,3,11,1,&joseki_variations[462],NULL},
  {800,0,11,1,&joseki_variations[463],NULL},
  {801,0,12,1,&joseki_variations[464],NULL},
  {725,3,5,0,NULL,&joseki[1042]},
  {723,0,3,1,&joseki_variations[466],NULL},
  {760,3,5,1,&joseki_variations[467],NULL},
  {797,3,6,2,&joseki_variations[468],NULL},
  {761,0,6,1,&joseki_variations[480],NULL},
  {724,0,4,1,&joseki_variations[470],NULL},
  {761,0,7,1,&joseki_variations[471],NULL},
  {798,3,9,1,&joseki_variations[472],NULL},
  {872,3,10,1,&joseki_variations[473],NULL},
  {725,3,5,1,&joseki_variations[474],NULL},
  {762,3,9,1,&joseki_variations[475],NULL},
  {799,0,12,1,&joseki_variations[476],NULL},
  {836,3,13,1,&joseki_variations[477],NULL},
  {800,0,13,1,&joseki_variations[478],NULL},
  {801,0,14,1,&joseki_variations[479],NULL},
  {721,3,1,0,NULL,&joseki[1044]},
  {798,3,8,1,&joseki_variations[481],NULL},
  {835,3,9,1,&joseki_variations[482],NULL},
  {762,0,7,1,&joseki_variations[483],NULL},
  {799,0,10,1,&joseki_variations[484],NULL},
  {836,3,12,1,&joseki_variations[485],NULL},
  {763,0,8,1,&joseki_variations[486],NULL},
  {800,3,12,1,&joseki_variations[487],NULL},
  {837,3,15,2,&joseki_variations[488],NULL},
  {801,0,13,1,&joseki_variations[493],NULL},
  {764,3,9,1,&joseki_variations[490],NULL},
  {801,0,14,1,&joseki_variations[491],NULL},
  {765,0,10,1,&joseki_variations[492],NULL},
  {727,3,4,0,NULL,&joseki[688]},
  {764,3,9,0,NULL,&joseki[687]},
  {796,0,4,1,&joseki_variations[645],NULL},
  {833,3,4,1,&joseki_variations[496],NULL},
  {870,3,5,1,&joseki_variations[497],NULL},
  {723,0,3,1,&joseki_variations[498],NULL},
  {760,3,5,1,&joseki_variations[499],NULL},
  {797,3,6,1,&joseki_variations[500],NULL},
  {834,0,8,1,&joseki_variations[501],NULL},
  {871,0,10,3,&joseki_variations[502],NULL},
  {908,0,11,1,&joseki_variations[635],NULL},
  {907,3,6,1,&joseki_variations[600],NULL},
  {724,0,4,1,&joseki_variations[505],NULL},
  {761,0,7,2,&joseki_variations[506],NULL},
  {764,0,8,1,&joseki_variations[587],NULL},
  {763,0,8,2,&joseki_variations[508],NULL},
  {764,0,9,1,&joseki_variations[534],NULL},
  {798,0,9,1,&joseki_variations[510],NULL},
  {800,3,11,1,&joseki_variations[511],NULL},
  {835,3,12,1,&joseki_variations[512],NULL},
  {836,3,13,1,&joseki_variations[513],NULL},
  {906,3,1,1,&joseki_variations[514],NULL},
  {907,3,7,1,&joseki_variations[515],NULL},
  {908,0,13,1,&joseki_variations[516],NULL},
  {944,0,8,1,&joseki_variations[517],NULL},
  {945,0,15,1,&joseki_variations[518],NULL},
  {946,3,20,1,&joseki_variations[519],NULL},
  {982,0,16,1,&joseki_variations[520],NULL},
  {690,0,2,1,&joseki_variations[521],NULL},
  {764,0,10,1,&joseki_variations[522],NULL},
  {801,0,14,1,&joseki_variations[523],NULL},
  {838,3,19,1,&joseki_variations[524],NULL},
  {875,3,22,1,&joseki_variations[525],NULL},
  {728,0,6,1,&joseki_variations[526],NULL},
  {765,3,12,1,&joseki_variations[527],NULL},
  {802,3,17,1,&joseki_variations[528],NULL},
  {839,0,23,1,&joseki_variations[529],NULL},
  {729,3,7,1,&joseki_variations[530],NULL},
  {840,3,25,2,&joseki_variations[531],&joseki[1617]},
  {1093,0,17,1,&joseki_variations[533],&joseki[1618]},
  {876,0,27,0,NULL,&joseki[1620]},
  {876,3,27,0,NULL,&joseki[1619]},
  {798,0,9,1,&joseki_variations[535],NULL},
  {800,3,11,3,&joseki_variations[536],NULL},
  {802,3,13,1,&joseki_variations[577],NULL},
  {765,3,10,1,&joseki_variations[566],NULL},
  {835,3,12,1,&joseki_variations[539],NULL},
  {836,3,13,1,&joseki_variations[540],NULL},
  {728,0,5,1,&joseki_variations[541],NULL},
  {765,3,11,2,&joseki_variations[542],NULL},
  {802,3,15,1,&joseki_variations[557],NULL},
  {801,0,13,1,&joseki_variations[544],NULL},
  {802,3,16,1,&joseki_variations[545],NULL},
  {729,3,6,1,&joseki_variations[546],NULL},
  {906,3,1,1,&joseki_variations[547],NULL},
  {907,3,7,1,&joseki_variations[548],NULL},
  {908,0,13,1,&joseki_variations[549],NULL},
  {944,0,8,1,&joseki_variations[550],NULL},
  {945,0,15,1,&joseki_variations[551],NULL},
  {946,3,20,1,&joseki_variations[552],NULL},
  {982,0,16,1,&joseki_variations[553],NULL},
  {838,3,18,1,&joseki_variations[554],&joseki[1613]},
  {839,0,22,1,&joseki_variations[555],&joseki[1614]},
  {875,3,21,1,&joseki_variations[556],&joseki[1615]},
  {690,0,2,0,NULL,&joseki[1616]},
  {906,3,1,1,&joseki_variations[558],NULL},
  {907,3,7,1,&joseki_variations[559],NULL},
  {908,0,13,1,&joseki_variations[560],NULL},
  {944,0,8,1,&joseki_variations[561],NULL},
  {945,0,15,1,&joseki_variations[562],NULL},
  {946,3,20,1,&joseki_variations[563],NULL},
  {982,0,16,1,&joseki_variations[564],NULL},
  {729,3,6,1,&joseki_variations[565],&joseki[1611]},
  {801,0,13,0,NULL,&joseki[1612]},
  {802,3,14,1,&joseki_variations[567],NULL},
  {835,3,12,1,&joseki_variations[568],NULL},
  {836,3,13,1,&joseki_variations[569],NULL},
  {906,3,1,1,&joseki_variations[570],NULL},
  {907,3,7,1,&joseki_variations[571],NULL},
  {908,0,13,1,&joseki_variations[572],NULL},
  {944,0,8,1,&joseki_variations[573],NULL},
  {945,0,15,1,&joseki_variations[574],NULL},
  {946,3,20,1,&joseki_variations[575],NULL},
  {982,0,16,1,&joseki_variations[576],NULL},
  {728,0,5,0,NULL,&joseki[1610]},
  {835,3,12,1,&joseki_variations[578],NULL},
  {836,3,13,1,&joseki_variations[579],NULL},
  {906,3,1,1,&joseki_variations[580],NULL},
  {907,3,7,1,&joseki_variations[581],NULL},
  {908,0,13,1,&joseki_variations[582],NULL},
  {944,0,8,1,&joseki_variations[583],NULL},
  {945,0,15,1,&joseki_variations[584],NULL},
  {946,3,20,1,&joseki_variations[585],NULL},
  {982,0,16,1,&joseki_variations[586],NULL},
  {765,3,10,0,NULL,&joseki[1609]},
  {798,0,9,1,&joseki_variations[588],NULL},
  {800,3,10,1,&joseki_variations[589],NULL},
  {802,3,12,1,&joseki_variations[590],NULL},
  {835,3,12,1,&joseki_variations[591],NULL},
  {836,3,13,1,&joseki_variations[592],NULL},
  {906,3,1,1,&joseki_variations[593],NULL},
  {907,3,7,1,&joseki_variations[594],NULL},
  {908,0,13,1,&joseki_variations[595],NULL},
  {944,0,8,1,&joseki_variations[596],NULL},
  {945,0,15,1,&joseki_variations[597],NULL},
  {946,3,20,1,&joseki_variations[598],NULL},
  {982,0,16,1,&joseki_variations[599],NULL},
  {763,0,8,0,NULL,&joseki[1608]},
  {908,0,12,2,&joseki_variations[601],NULL},
  {982,0,13,1,&joseki_variations[626],NULL},
  {944,0,7,2,&joseki_variations[603],NULL},
  {982,0,14,1,&joseki_variations[616],NULL},
  {945,0,14,1,&joseki_variations[605],NULL},
  {982,0,15,1,&joseki_variations[606],NULL},
  {724,0,4,1,&joseki_variations[607],NULL},
  {761,0,7,1,&joseki_variations[608],NULL},
  {764,0,8,1,&joseki_variations[609],NULL},
  {798,0,9,1,&joseki_variations[610],NULL},
  {800,3,10,1,&joseki_variations[611],NULL},
  {802,3,12,1,&joseki_variations[612],NULL},
  {835,3,12,1,&joseki_variations[613],NULL},
  {946,3,19,1,&joseki_variations[614],NULL},
  {836,3,13,1,&joseki_variations[615],NULL},
  {906,3,1,0,NULL,&joseki[1607]},
  {724,0,4,1,&joseki_variations[617],NULL},
  {761,0,7,1,&joseki_variations[618],NULL},
  {764,0,8,1,&joseki_variations[619],NULL},
  {798,0,9,1,&joseki_variations[620],NULL},
  {800,3,10,1,&joseki_variations[621],NULL},
  {802,3,12,1,&joseki_variations[622],NULL},
  {835,3,12,1,&joseki_variations[623],NULL},
  {836,3,13,1,&joseki_variations[624],NULL},
  {946,3,18,1,&joseki_variations[625],&joseki[1605]},
  {945,0,14,0,NULL,&joseki[1606]},
  {724,0,4,1,&joseki_variations[627],NULL},
  {761,0,7,1,&joseki_variations[628],NULL},
  {764,0,8,1,&joseki_variations[629],NULL},
  {798,0,9,1,&joseki_variations[630],NULL},
  {800,3,10,1,&joseki_variations[631],NULL},
  {802,3,12,1,&joseki_variations[632],NULL},
  {835,3,12,1,&joseki_variations[633],NULL},
  {836,3,13,1,&joseki_variations[634],NULL},
  {944,0,7,0,NULL,&joseki[1604]},
  {724,0,4,1,&joseki_variations[636],NULL},
  {761,0,7,1,&joseki_variations[637],NULL},
  {798,0,9,1,&joseki_variations[638],NULL},
  {800,3,10,1,&joseki_variations[639],NULL},
  {835,3,12,1,&joseki_variations[640],NULL},
  {836,3,13,1,&joseki_variations[641],NULL},
  {764,0,8,1,&joseki_variations[642],&joseki[1600]},
  {802,3,12,1,&joseki_variations[643],&joseki[1601]},
  {982,0,12,1,&joseki_variations[644],&joseki[1602]},
  {907,3,6,0,NULL,&joseki[1603]},
  {870,0,5,1,&joseki_variations[646],NULL},
  {907,3,6,1,&joseki_variations[647],NULL},
  {686,0,2,2,&joseki_variations[648],NULL},
  {797,0,6,1,&joseki_variations[668],NULL},
  {760,3,5,1,&joseki_variations[650],NULL},
  {797,0,7,1,&joseki_variations[651],NULL},
  {834,0,8,1,&joseki_variations[652],NULL},
  {871,3,10,1,&joseki_variations[653],NULL},
  {687,3,3,1,&joseki_variations[654],NULL},
  {724,3,5,1,&joseki_variations[655],NULL},
  {761,3,8,1,&joseki_variations[656],NULL},
  {798,3,11,1,&joseki_variations[657],NULL},
  {835,0,13,1,&joseki_variations[658],NULL},
  {872,3,16,1,&joseki_variations[659],NULL},
  {762,0,9,1,&joseki_variations[660],NULL},
  {799,0,13,1,&joseki_variations[661],NULL},
  {836,3,16,1,&joseki_variations[662],NULL},
  {763,0,10,1,&joseki_variations[663],NULL},
  {800,3,15,1,&joseki_variations[664],NULL},
  {837,3,19,1,&joseki_variations[665],NULL},
  {764,0,11,1,&joseki_variations[666],NULL},
  {801,0,17,1,&joseki_variations[667],NULL},
  {758,0,1,0,NULL,&joseki[463]},
  {834,0,7,1,&joseki_variations[669],NULL},
  {871,3,9,1,&joseki_variations[670],NULL},
  {687,3,3,1,&joseki_variations[671],NULL},
  {724,3,5,1,&joseki_variations[672],NULL},
  {761,3,7,1,&joseki_variations[673],NULL},
  {798,3,10,1,&joseki_variations[674],NULL},
  {835,0,12,1,&joseki_variations[675],NULL},
  {872,3,15,1,&joseki_variations[676],NULL},
  {762,0,8,1,&joseki_variations[677],NULL},
  {799,0,12,1,&joseki_variations[678],NULL},
  {836,3,15,1,&joseki_variations[679],NULL},
  {763,0,9,1,&joseki_variations[680],NULL},
  {800,3,14,1,&joseki_variations[681],NULL},
  {837,3,18,1,&joseki_variations[682],NULL},
  {764,0,10,1,&joseki_variations[683],NULL},
  {801,0,16,1,&joseki_variations[684],NULL},
  {760,3,5,0,NULL,&joseki[462]},
  {795,0,2,1,&joseki_variations[712],NULL},
  {685,0,1,1,&joseki_variations[687],NULL},
  {722,3,2,1,&joseki_variations[688],NULL},
  {759,3,4,1,&joseki_variations[689],NULL},
  {796,0,5,1,&joseki_variations[690],NULL},
  {870,0,6,1,&joseki_variations[691],NULL},
  {907,3,7,1,&joseki_variations[692],NULL},
  {686,0,2,1,&joseki_variations[693],NULL},
  {760,3,6,1,&joseki_variations[694],NULL},
  {797,0,8,1,&joseki_variations[695],NULL},
  {834,0,9,1,&joseki_variations[696],NULL},
  {871,3,11,1,&joseki_variations[697],NULL},
  {687,3,3,1,&joseki_variations[698],NULL},
  {724,3,5,1,&joseki_variations[699],NULL},
  {761,3,9,1,&joseki_variations[700],NULL},
  {798,3,12,1,&joseki_variations[701],NULL},
  {835,0,14,1,&joseki_variations[702],NULL},
  {872,3,17,1,&joseki_variations[703],NULL},
  {762,0,10,1,&joseki_variations[704],NULL},
  {799,0,14,1,&joseki_variations[705],NULL},
  {836,3,17,1,&joseki_variations[706],NULL},
  {763,0,11,1,&joseki_variations[707],NULL},
  {800,3,16,1,&joseki_variations[708],NULL},
  {837,3,20,1,&joseki_variations[709],NULL},
  {764,0,12,1,&joseki_variations[710],NULL},
  {801,0,18,1,&joseki_variations[711],NULL},
  {832,3,2,0,NULL,&joseki[464]},
  {685,3,1,1,&joseki_variations[713],NULL},
  {722,0,2,1,&joseki_variations[714],NULL},
  {759,3,4,1,&joseki_variations[715],NULL},
  {796,0,6,1,&joseki_variations[716],NULL},
  {833,0,7,1,&joseki_variations[717],NULL},
  {870,3,8,1,&joseki_variations[718],NULL},
  {723,3,3,1,&joseki_variations[719],NULL},
  {760,3,6,1,&joseki_variations[720],NULL},
  {797,3,9,1,&joseki_variations[721],NULL},
  {834,0,11,1,&joseki_variations[722],NULL},
  {871,3,13,1,&joseki_variations[723],NULL},
  {724,3,4,1,&joseki_variations[724],NULL},
  {761,3,8,1,&joseki_variations[725],NULL},
  {798,3,12,1,&joseki_variations[726],NULL},
  {835,0,15,1,&joseki_variations[727],NULL},
  {872,3,18,2,&joseki_variations[728],NULL},
  {762,0,9,1,&joseki_variations[739],NULL},
  {725,0,5,1,&joseki_variations[730],NULL},
  {762,0,10,1,&joseki_variations[731],NULL},
  {799,0,15,1,&joseki_variations[732],NULL},
  {836,3,19,1,&joseki_variations[733],NULL},
  {763,0,11,1,&joseki_variations[734],NULL},
  {800,3,17,1,&joseki_variations[735],NULL},
  {837,3,22,1,&joseki_variations[736],NULL},
  {764,0,12,1,&joseki_variations[737],NULL},
  {801,0,19,1,&joseki_variations[738],NULL},
  {869,3,3,0,NULL,&joseki[386]},
  {799,0,14,1,&joseki_variations[740],NULL},
  {836,3,18,1,&joseki_variations[741],NULL},
  {763,0,10,1,&joseki_variations[742],NULL},
  {800,3,16,1,&joseki_variations[743],NULL},
  {837,3,21,1,&joseki_variations[744],NULL},
  {764,0,11,1,&joseki_variations[745],NULL},
  {801,0,18,2,&joseki_variations[746],NULL},
  {721,0,1,0,NULL,&joseki[383]},
  {725,0,5,0,NULL,&joseki[385]},
  {722,0,2,1,&joseki_variations[779],NULL},
  {686,0,2,1,&joseki_variations[750],NULL},
  {688,0,3,1,&joseki_variations[751],NULL},
  {721,3,2,1,&joseki_variations[752],NULL},
  {722,0,3,1,&joseki_variations[753],NULL},
  {759,3,4,1,&joseki_variations[754],NULL},
  {723,0,5,1,&joseki_variations[755],NULL},
  {725,0,7,1,&joseki_variations[756],NULL},
  {726,3,8,1,&joseki_variations[757],NULL},
  {760,0,7,1,&joseki_variations[758],NULL},
  {761,0,8,1,&joseki_variations[759],NULL},
  {762,3,11,1,&joseki_variations[760],NULL},
  {763,3,13,1,&joseki_variations[761],NULL},
  {765,3,14,1,&joseki_variations[762],NULL},
  {795,3,3,1,&joseki_variations[763],NULL},
  {797,3,9,1,&joseki_variations[764],NULL},
  {798,0,11,1,&joseki_variations[765],NULL},
  {799,3,15,1,&joseki_variations[766],NULL},
  {800,0,18,1,&joseki_variations[767],NULL},
  {801,3,19,1,&joseki_variations[768],NULL},
  {832,3,4,1,&joseki_variations[769],NULL},
  {833,3,7,1,&joseki_variations[770],NULL},
  {834,3,12,1,&joseki_variations[771],NULL},
  {835,3,15,1,&joseki_variations[772],NULL},
  {836,0,20,1,&joseki_variations[773],NULL},
  {837,0,24,1,&joseki_variations[774],NULL},
  {869,0,5,1,&joseki_variations[775],NULL},
  {870,0,9,1,&joseki_variations[776],NULL},
  {871,0,15,1,&joseki_variations[777],NULL},
  {872,0,19,1,&joseki_variations[778],NULL},
  {685,3,2,0,NULL,&joseki[543]},
  {724,3,3,1,&joseki_variations[780],NULL},
  {758,0,2,1,&joseki_variations[781],NULL},
  {759,3,4,1,&joseki_variations[782],NULL},
  {760,3,5,1,&joseki_variations[783],NULL},
  {761,3,7,1,&joseki_variations[784],NULL},
  {762,0,8,1,&joseki_variations[785],NULL},
  {763,0,9,1,&joseki_variations[786],NULL},
  {764,0,10,1,&joseki_variations[787],NULL},
  {795,0,3,1,&joseki_variations[788],NULL},
  {796,0,6,1,&joseki_variations[789],NULL},
  {797,3,8,1,&joseki_variations[790],NULL},
  {798,3,11,1,&joseki_variations[791],NULL},
  {799,0,13,1,&joseki_variations[792],NULL},
  {800,3,15,1,&joseki_variations[793],NULL},
  {801,0,17,1,&joseki_variations[794],NULL},
  {833,0,7,1,&joseki_variations[795],NULL},
  {834,0,10,1,&joseki_variations[796],NULL},
  {835,0,14,1,&joseki_variations[797],NULL},
  {836,3,17,1,&joseki_variations[798],NULL},
  {837,3,20,1,&joseki_variations[799],NULL},
  {870,3,8,1,&joseki_variations[800],NULL},
  {871,3,12,1,&joseki_variations[801],NULL},
  {872,3,17,1,&joseki_variations[802],NULL},
  {869,3,4,0,NULL,&joseki[376]},
  {722,3,2,3,&joseki_variations[2001],NULL},
  {758,0,2,4,&joseki_variations[1488],NULL},
  {685,3,1,1,&joseki_variations[990],NULL},
  {795,0,2,2,&joseki_variations[848],NULL},
  {685,0,1,1,&joseki_variations[822],NULL},
  {722,0,2,1,&joseki_variations[809],NULL},
  {727,3,3,1,&joseki_variations[810],NULL},
  {759,3,3,1,&joseki_variations[811],NULL},
  {760,0,4,1,&joseki_variations[812],NULL},
  {761,0,5,1,&joseki_variations[813],NULL},
  {762,0,6,1,&joseki_variations[814],NULL},
  {763,0,7,1,&joseki_variations[815],NULL},
  {764,3,9,1,&joseki_variations[816],NULL},
  {796,3,4,1,&joseki_variations[817],NULL},
  {797,3,6,1,&joseki_variations[818],NULL},
  {798,3,8,1,&joseki_variations[819],NULL},
  {800,3,11,1,&joseki_variations[820],NULL},
  {804,3,14,1,&joseki_variations[821],NULL},
  {687,3,1,0,NULL,&joseki[897]},
  {759,0,3,1,&joseki_variations[823],NULL},
  {723,0,3,1,&joseki_variations[824],NULL},
  {727,3,4,1,&joseki_variations[825],NULL},
  {760,3,5,1,&joseki_variations[826],NULL},
  {797,3,6,1,&joseki_variations[827],NULL},
  {761,0,6,1,&joseki_variations[828],NULL},
  {798,3,8,1,&joseki_variations[829],NULL},
  {835,3,9,1,&joseki_variations[830],NULL},
  {762,0,7,1,&joseki_variations[831],NULL},
  {799,0,10,1,&joseki_variations[832],NULL},
  {836,3,12,1,&joseki_variations[833],NULL},
  {763,0,8,1,&joseki_variations[834],NULL},
  {800,3,12,1,&joseki_variations[835],NULL},
  {837,3,15,1,&joseki_variations[836],NULL},
  {764,3,10,1,&joseki_variations[837],NULL},
  {801,0,15,2,&joseki_variations[838],NULL},
  {765,0,11,1,&joseki_variations[845],NULL},
  {838,0,19,1,&joseki_variations[840],NULL},
  {875,0,20,1,&joseki_variations[841],NULL},
  {728,3,5,1,&joseki_variations[842],NULL},
  {765,0,12,1,&joseki_variations[843],NULL},
  {766,3,13,1,&joseki_variations[844],NULL},
  {946,3,10,0,NULL,&joseki[691]},
  {766,3,12,1,&joseki_variations[846],&joseki[689]},
  {838,0,19,1,&joseki_variations[847],NULL},
  {728,3,5,0,NULL,&joseki[690]},
  {832,0,3,1,&joseki_variations[896],NULL},
  {685,0,1,1,&joseki_variations[850],NULL},
  {722,3,3,1,&joseki_variations[851],NULL},
  {759,0,4,1,&joseki_variations[852],NULL},
  {833,0,6,2,&joseki_variations[853],NULL},
  {870,3,7,1,&joseki_variations[876],NULL},
  {723,3,4,1,&joseki_variations[855],NULL},
  {760,3,6,1,&joseki_variations[856],NULL},
  {797,0,8,1,&joseki_variations[857],NULL},
  {834,0,10,1,&joseki_variations[858],NULL},
  {869,3,3,1,&joseki_variations[859],NULL},
  {870,3,8,1,&joseki_variations[860],NULL},
  {871,3,13,1,&joseki_variations[861],NULL},
  {687,3,2,1,&joseki_variations[862],NULL},
  {761,3,8,1,&joseki_variations[863],NULL},
  {798,3,11,1,&joseki_variations[864],NULL},
  {835,0,14,1,&joseki_variations[865],NULL},
  {872,3,18,1,&joseki_variations[866],NULL},
  {725,3,6,1,&joseki_variations[867],NULL},
  {762,0,10,1,&joseki_variations[868],NULL},
  {799,0,14,1,&joseki_variations[869],NULL},
  {836,3,18,1,&joseki_variations[870],NULL},
  {726,0,7,1,&joseki_variations[871],NULL},
  {763,0,12,1,&joseki_variations[872],NULL},
  {800,3,17,1,&joseki_variations[873],NULL},
  {837,3,22,1,&joseki_variations[874],NULL},
  {801,0,18,1,&joseki_variations[875],NULL},
  {832,0,3,0,NULL,&joseki[558]},
  {723,3,4,1,&joseki_variations[877],NULL},
  {760,3,6,1,&joseki_variations[878],NULL},
  {797,0,8,1,&joseki_variations[879],NULL},
  {834,0,10,1,&joseki_variations[880],NULL},
  {871,3,12,1,&joseki_variations[881],NULL},
  {687,3,2,1,&joseki_variations[882],NULL},
  {761,3,8,1,&joseki_variations[883],NULL},
  {798,3,11,1,&joseki_variations[884],NULL},
  {835,0,14,1,&joseki_variations[885],NULL},
  {872,3,17,1,&joseki_variations[886],NULL},
  {725,3,6,1,&joseki_variations[887],NULL},
  {762,0,10,1,&joseki_variations[888],NULL},
  {799,0,14,1,&joseki_variations[889],NULL},
  {836,3,18,1,&joseki_variations[890],NULL},
  {726,0,7,1,&joseki_variations[891],NULL},
  {763,0,12,1,&joseki_variations[892],NULL},
  {800,3,17,1,&joseki_variations[893],NULL},
  {837,3,22,1,&joseki_variations[894],NULL},
  {801,0,18,1,&joseki_variations[895],NULL},
  {869,3,3,0,NULL,&joseki[557]},
  {685,0,1,2,&joseki_variations[897],NULL},
  {688,3,2,1,&joseki_variations[962],NULL},
  {869,3,4,1,&joseki_variations[899],NULL},
  {722,3,3,1,&joseki_variations[900],NULL},
  {759,0,4,1,&joseki_variations[901],NULL},
  {833,0,7,1,&joseki_variations[902],NULL},
  {870,3,9,2,&joseki_variations[903],NULL},
  {686,3,2,1,&joseki_variations[924],NULL},
  {723,3,4,1,&joseki_variations[905],NULL},
  {760,3,6,1,&joseki_variations[906],NULL},
  {797,0,8,1,&joseki_variations[907],NULL},
  {834,0,11,1,&joseki_variations[908],NULL},
  {871,3,14,1,&joseki_variations[909],NULL},
  {687,3,2,1,&joseki_variations[910],NULL},
  {761,3,8,1,&joseki_variations[911],NULL},
  {798,3,11,1,&joseki_variations[912],NULL},
  {835,0,15,1,&joseki_variations[913],NULL},
  {872,3,19,1,&joseki_variations[914],NULL},
  {725,3,6,1,&joseki_variations[915],NULL},
  {762,0,10,1,&joseki_variations[916],NULL},
  {799,0,14,1,&joseki_variations[917],NULL},
  {836,3,19,1,&joseki_variations[918],NULL},
  {726,0,7,1,&joseki_variations[919],NULL},
  {763,0,12,1,&joseki_variations[920],NULL},
  {800,3,17,1,&joseki_variations[921],NULL},
  {837,3,23,1,&joseki_variations[922],NULL},
  {801,0,18,1,&joseki_variations[923],NULL},
  {686,3,2,0,NULL,&joseki[559]},
  {723,3,5,1,&joseki_variations[925],NULL},
  {760,3,7,1,&joseki_variations[926],NULL},
  {797,0,9,1,&joseki_variations[927],NULL},
  {834,0,12,1,&joseki_variations[928],NULL},
  {871,3,15,2,&joseki_variations[929],NULL},
  {761,3,8,1,&joseki_variations[947],NULL},
  {724,0,6,1,&joseki_variations[931],NULL},
  {761,3,9,1,&joseki_variations[932],NULL},
  {798,3,12,1,&joseki_variations[933],NULL},
  {835,0,16,1,&joseki_variations[934],NULL},
  {872,3,20,1,&joseki_variations[935],NULL},
  {688,3,3,1,&joseki_variations[936],NULL},
  {725,3,8,1,&joseki_variations[937],NULL},
  {762,0,12,1,&joseki_variations[938],NULL},
  {799,0,16,1,&joseki_variations[939],NULL},
  {836,3,21,1,&joseki_variations[940],NULL},
  {726,0,9,1,&joseki_variations[941],NULL},
  {763,0,14,1,&joseki_variations[942],NULL},
  {800,3,19,1,&joseki_variations[943],NULL},
  {837,3,25,1,&joseki_variations[944],NULL},
  {801,0,20,1,&joseki_variations[945],NULL},
  {765,0,15,1,&joseki_variations[946],NULL},
  {687,3,3,0,NULL,&joseki[545]},
  {798,3,11,1,&joseki_variations[948],NULL},
  {835,0,15,1,&joseki_variations[949],NULL},
  {872,3,19,1,&joseki_variations[950],NULL},
  {688,3,3,1,&joseki_variations[951],NULL},
  {725,3,7,1,&joseki_variations[952],NULL},
  {762,0,11,1,&joseki_variations[953],NULL},
  {799,0,15,1,&joseki_variations[954],NULL},
  {836,3,20,1,&joseki_variations[955],NULL},
  {726,0,8,1,&joseki_variations[956],NULL},
  {763,0,13,1,&joseki_variations[957],NULL},
  {800,3,18,1,&joseki_variations[958],NULL},
  {837,3,24,1,&joseki_variations[959],NULL},
  {801,0,19,1,&joseki_variations[960],NULL},
  {765,0,14,1,&joseki_variations[961],NULL},
  {724,0,6,0,NULL,&joseki[544]},
  {722,3,3,1,&joseki_variations[963],NULL},
  {724,3,4,1,&joseki_variations[964],NULL},
  {725,0,6,1,&joseki_variations[965],NULL},
  {726,0,7,1,&joseki_variations[966],NULL},
  {727,0,8,1,&joseki_variations[967],NULL},
  {728,0,9,1,&joseki_variations[968],NULL},
  {759,0,4,1,&joseki_variations[969],NULL},
  {760,3,5,1,&joseki_variations[970],NULL},
  {761,3,7,1,&joseki_variations[971],NULL},
  {762,0,10,1,&joseki_variations[972],NULL},
  {763,0,12,1,&joseki_variations[973],NULL},
  {764,3,14,1,&joseki_variations[974],NULL},
  {765,3,16,1,&joseki_variations[975],NULL},
  {796,3,6,1,&joseki_variations[976],NULL},
  {797,3,8,1,&joseki_variations[977],NULL},
  {798,3,11,1,&joseki_variations[978],NULL},
  {799,0,15,1,&joseki_variations[979],NULL},
  {800,3,18,1,&joseki_variations[980],NULL},
  {801,0,21,1,&joseki_variations[981],NULL},
  {833,0,8,1,&joseki_variations[982],NULL},
  {834,0,11,1,&joseki_variations[983],NULL},
  {835,0,15,1,&joseki_variations[984],NULL},
  {836,3,20,1,&joseki_variations[985],NULL},
  {837,3,24,1,&joseki_variations[986],NULL},
  {870,3,9,1,&joseki_variations[987],NULL},
  {871,3,13,1,&joseki_variations[988],NULL},
  {872,3,18,1,&joseki_variations[989],NULL},
  {869,3,4,0,NULL,&joseki[504]},
  {722,3,3,2,&joseki_variations[991],NULL},
  {724,3,4,1,&joseki_variations[1454],NULL},
  {759,0,4,4,&joseki_variations[993],NULL},
  {833,0,5,4,&joseki_variations[1308],NULL},
  {760,0,5,2,&joseki_variations[1242],NULL},
  {796,0,5,1,&joseki_variations[1184],NULL},
  {795,3,2,3,&joseki_variations[997],NULL},
  {797,0,6,1,&joseki_variations[1149],NULL},
  {833,0,6,4,&joseki_variations[1050],NULL},
  {796,0,6,1,&joseki_variations[1000],NULL},
  {833,0,7,1,&joseki_variations[1001],NULL},
  {869,0,3,1,&joseki_variations[1002],NULL},
  {870,3,9,2,&joseki_variations[1003],NULL},
  {907,3,10,1,&joseki_variations[1028],NULL},
  {906,3,4,1,&joseki_variations[1005],NULL},
  {907,3,11,1,&joseki_variations[1006],NULL},
  {686,3,2,1,&joseki_variations[1007],NULL},
  {760,3,6,1,&joseki_variations[1008],NULL},
  {797,0,9,1,&joseki_variations[1009],NULL},
  {834,0,11,1,&joseki_variations[1010],NULL},
  {871,3,14,1,&joseki_variations[1011],NULL},
  {687,3,3,1,&joseki_variations[1012],NULL},
  {724,3,6,1,&joseki_variations[1013],NULL},
  {761,3,9,1,&joseki_variations[1014],NULL},
  {798,3,13,1,&joseki_variations[1015],NULL},
  {835,0,16,1,&joseki_variations[1016],NULL},
  {872,3,20,1,&joseki_variations[1017],NULL},
  {688,0,4,1,&joseki_variations[1018],NULL},
  {725,0,8,1,&joseki_variations[1019],NULL},
  {762,0,12,1,&joseki_variations[1020],NULL},
  {799,0,17,1,&joseki_variations[1021],NULL},
  {836,3,21,1,&joseki_variations[1022],NULL},
  {763,0,13,1,&joseki_variations[1023],NULL},
  {800,3,19,1,&joseki_variations[1024],NULL},
  {837,3,24,1,&joseki_variations[1025],NULL},
  {764,0,14,1,&joseki_variations[1026],NULL},
  {801,0,21,1,&joseki_variations[1027],NULL},
  {758,0,2,0,NULL,&joseki[435]},
  {686,3,2,1,&joseki_variations[1029],NULL},
  {760,3,6,1,&joseki_variations[1030],NULL},
  {797,0,9,1,&joseki_variations[1031],NULL},
  {834,0,11,1,&joseki_variations[1032],NULL},
  {871,3,14,1,&joseki_variations[1033],NULL},
  {687,3,3,1,&joseki_variations[1034],NULL},
  {724,3,6,1,&joseki_variations[1035],NULL},
  {761,3,9,1,&joseki_variations[1036],NULL},
  {798,3,13,1,&joseki_variations[1037],NULL},
  {835,0,16,1,&joseki_variations[1038],NULL},
  {872,3,20,1,&joseki_variations[1039],NULL},
  {688,0,4,1,&joseki_variations[1040],NULL},
  {725,0,8,1,&joseki_variations[1041],NULL},
  {762,0,12,1,&joseki_variations[1042],NULL},
  {799,0,17,1,&joseki_variations[1043],NULL},
  {836,3,21,1,&joseki_variations[1044],NULL},
  {763,0,13,1,&joseki_variations[1045],NULL},
  {800,3,19,1,&joseki_variations[1046],NULL},
  {837,3,24,1,&joseki_variations[1047],NULL},
  {764,0,14,1,&joseki_variations[1048],NULL},
  {801,0,21,1,&joseki_variations[1049],NULL},
  {906,3,4,0,NULL,&joseki[434]},
  {723,3,4,1,&joseki_variations[1126],NULL},
  {760,3,5,1,&joseki_variations[1103],NULL},
  {723,0,4,1,&joseki_variations[1079],NULL},
  {869,0,3,1,&joseki_variations[1054],NULL},
  {870,3,8,1,&joseki_variations[1055],NULL},
  {907,3,9,1,&joseki_variations[1056],NULL},
  {686,3,2,1,&joseki_variations[1057],NULL},
  {760,3,6,1,&joseki_variations[1058],NULL},
  {797,0,8,1,&joseki_variations[1059],NULL},
  {834,0,10,1,&joseki_variations[1060],NULL},
  {871,3,13,1,&joseki_variations[1061],NULL},
  {687,3,3,1,&joseki_variations[1062],NULL},
  {724,3,6,1,&joseki_variations[1063],NULL},
  {761,3,9,1,&joseki_variations[1064],NULL},
  {798,3,12,1,&joseki_variations[1065],NULL},
  {835,0,15,1,&joseki_variations[1066],NULL},
  {872,3,19,1,&joseki_variations[1067],NULL},
  {688,0,4,1,&joseki_variations[1068],NULL},
  {725,0,8,1,&joseki_variations[1069],NULL},
  {762,0,12,1,&joseki_variations[1070],NULL},
  {799,0,16,1,&joseki_variations[1071],NULL},
  {836,3,20,1,&joseki_variations[1072],NULL},
  {763,0,13,1,&joseki_variations[1073],NULL},
  {800,3,18,1,&joseki_variations[1074],NULL},
  {837,3,23,1,&joseki_variations[1075],NULL},
  {764,0,14,1,&joseki_variations[1076],NULL},
  {801,0,20,2,&joseki_variations[1077],NULL},
  {796,0,6,0,NULL,&joseki[433]},
  {758,0,2,0,NULL,&joseki[439]},
  {760,3,6,1,&joseki_variations[1080],NULL},
  {797,0,8,1,&joseki_variations[1081],NULL},
  {834,0,10,1,&joseki_variations[1082],NULL},
  {869,0,3,1,&joseki_variations[1083],NULL},
  {870,3,8,1,&joseki_variations[1084],NULL},
  {871,3,13,1,&joseki_variations[1085],NULL},
  {907,3,9,1,&joseki_variations[1086],NULL},
  {687,3,2,1,&joseki_variations[1087],NULL},
  {724,3,6,1,&joseki_variations[1088],NULL},
  {761,3,9,1,&joseki_variations[1089],NULL},
  {798,3,12,1,&joseki_variations[1090],NULL},
  {835,0,15,1,&joseki_variations[1091],NULL},
  {872,3,19,1,&joseki_variations[1092],NULL},
  {688,0,3,1,&joseki_variations[1093],NULL},
  {725,0,8,1,&joseki_variations[1094],NULL},
  {762,0,12,1,&joseki_variations[1095],NULL},
  {799,0,16,1,&joseki_variations[1096],NULL},
  {836,3,20,1,&joseki_variations[1097],NULL},
  {763,0,13,1,&joseki_variations[1098],NULL},
  {800,3,18,1,&joseki_variations[1099],NULL},
  {837,3,23,1,&joseki_variations[1100],NULL},
  {764,0,14,1,&joseki_variations[1101],NULL},
  {801,0,20,1,&joseki_variations[1102],NULL},
  {686,3,2,0,NULL,&joseki[432]},
  {797,0,7,1,&joseki_variations[1104],NULL},
  {834,0,9,1,&joseki_variations[1105],NULL},
  {869,0,3,1,&joseki_variations[1106],NULL},
  {870,3,8,1,&joseki_variations[1107],NULL},
  {871,3,12,1,&joseki_variations[1108],NULL},
  {907,3,9,1,&joseki_variations[1109],NULL},
  {687,3,2,1,&joseki_variations[1110],NULL},
  {724,3,5,1,&joseki_variations[1111],NULL},
  {761,3,8,1,&joseki_variations[1112],NULL},
  {798,3,11,1,&joseki_variations[1113],NULL},
  {835,0,14,1,&joseki_variations[1114],NULL},
  {872,3,18,1,&joseki_variations[1115],NULL},
  {688,0,3,1,&joseki_variations[1116],NULL},
  {725,0,7,1,&joseki_variations[1117],NULL},
  {762,0,11,1,&joseki_variations[1118],NULL},
  {799,0,15,1,&joseki_variations[1119],NULL},
  {836,3,19,1,&joseki_variations[1120],NULL},
  {763,0,12,1,&joseki_variations[1121],NULL},
  {800,3,17,1,&joseki_variations[1122],NULL},
  {837,3,22,1,&joseki_variations[1123],NULL},
  {764,0,13,1,&joseki_variations[1124],NULL},
  {801,0,19,1,&joseki_variations[1125],NULL},
  {723,0,4,0,NULL,&joseki[431]},
  {760,0,6,1,&joseki_variations[1127],NULL},
  {797,0,8,1,&joseki_variations[1128],NULL},
  {834,0,10,1,&joseki_variations[1129],NULL},
  {869,0,3,1,&joseki_variations[1130],NULL},
  {870,3,8,1,&joseki_variations[1131],NULL},
  {871,3,13,1,&joseki_variations[1132],NULL},
  {907,3,9,1,&joseki_variations[1133],NULL},
  {687,3,2,1,&joseki_variations[1134],NULL},
  {724,3,6,1,&joseki_variations[1135],NULL},
  {761,3,9,1,&joseki_variations[1136],NULL},
  {798,3,12,1,&joseki_variations[1137],NULL},
  {835,0,15,1,&joseki_variations[1138],NULL},
  {872,3,19,1,&joseki_variations[1139],NULL},
  {725,0,7,1,&joseki_variations[1140],NULL},
  {762,0,11,1,&joseki_variations[1141],NULL},
  {799,0,15,1,&joseki_variations[1142],NULL},
  {836,3,19,1,&joseki_variations[1143],NULL},
  {763,0,12,1,&joseki_variations[1144],NULL},
  {800,3,17,1,&joseki_variations[1145],NULL},
  {837,3,22,1,&joseki_variations[1146],NULL},
  {764,0,13,1,&joseki_variations[1147],NULL},
  {801,0,19,1,&joseki_variations[1148],NULL},
  {758,0,2,0,NULL,&joseki[419]},
  {833,0,6,1,&joseki_variations[1150],NULL},
  {834,0,8,1,&joseki_variations[1151],NULL},
  {869,0,3,1,&joseki_variations[1152],NULL},
  {870,3,8,1,&joseki_variations[1153],NULL},
  {871,3,11,1,&joseki_variations[1154],NULL},
  {907,3,9,1,&joseki_variations[1155],NULL},
  {687,3,2,1,&joseki_variations[1156],NULL},
  {724,3,5,1,&joseki_variations[1157],NULL},
  {761,3,7,1,&joseki_variations[1158],NULL},
  {798,3,10,1,&joseki_variations[1159],NULL},
  {835,0,13,1,&joseki_variations[1160],NULL},
  {872,3,17,2,&joseki_variations[1161],NULL},
  {725,0,6,1,&joseki_variations[1173],NULL},
  {688,0,3,1,&joseki_variations[1163],NULL},
  {725,0,7,1,&joseki_variations[1164],NULL},
  {762,0,10,1,&joseki_variations[1165],NULL},
  {799,0,14,1,&joseki_variations[1166],NULL},
  {836,3,18,1,&joseki_variations[1167],NULL},
  {763,0,11,1,&joseki_variations[1168],NULL},
  {800,3,16,1,&joseki_variations[1169],NULL},
  {837,3,21,1,&joseki_variations[1170],NULL},
  {764,0,12,1,&joseki_variations[1171],NULL},
  {801,0,18,1,&joseki_variations[1172],NULL},
  {760,3,5,0,NULL,&joseki[430]},
  {762,0,9,1,&joseki_variations[1174],NULL},
  {799,0,13,1,&joseki_variations[1175],NULL},
  {836,3,17,1,&joseki_variations[1176],NULL},
  {763,0,10,1,&joseki_variations[1177],NULL},
  {800,3,15,1,&joseki_variations[1178],NULL},
  {837,3,20,1,&joseki_variations[1179],NULL},
  {764,0,11,1,&joseki_variations[1180],NULL},
  {801,0,17,3,&joseki_variations[1181],NULL},
  {758,0,2,0,NULL,&joseki[411]},
  {760,0,5,0,NULL,&joseki[417]},
  {688,0,3,0,NULL,&joseki[429]},
  {833,0,6,2,&joseki_variations[1185],NULL},
  {870,3,7,1,&joseki_variations[1210],NULL},
  {723,3,4,1,&joseki_variations[1187],NULL},
  {760,0,6,1,&joseki_variations[1188],NULL},
  {797,3,8,1,&joseki_variations[1189],NULL},
  {834,0,10,1,&joseki_variations[1190],NULL},
  {869,0,2,1,&joseki_variations[1191],NULL},
  {870,3,8,1,&joseki_variations[1192],NULL},
  {871,3,13,1,&joseki_variations[1193],NULL},
  {907,3,9,1,&joseki_variations[1194],NULL},
  {687,3,2,1,&joseki_variations[1195],NULL},
  {724,3,6,1,&joseki_variations[1196],NULL},
  {761,3,9,1,&joseki_variations[1197],NULL},
  {798,3,12,1,&joseki_variations[1198],NULL},
  {835,0,15,1,&joseki_variations[1199],NULL},
  {872,3,19,1,&joseki_variations[1200],NULL},
  {725,0,7,1,&joseki_variations[1201],NULL},
  {762,0,11,1,&joseki_variations[1202],NULL},
  {799,0,15,1,&joseki_variations[1203],NULL},
  {836,3,19,1,&joseki_variations[1204],NULL},
  {763,0,12,1,&joseki_variations[1205],NULL},
  {800,3,17,1,&joseki_variations[1206],NULL},
  {837,3,22,1,&joseki_variations[1207],NULL},
  {764,0,13,1,&joseki_variations[1208],NULL},
  {801,0,19,1,&joseki_variations[1209],NULL},
  {758,0,2,0,NULL,&joseki[407]},
  {723,3,4,1,&joseki_variations[1211],NULL},
  {760,0,6,1,&joseki_variations[1212],NULL},
  {797,3,8,1,&joseki_variations[1213],NULL},
  {834,0,10,1,&joseki_variations[1214],NULL},
  {871,3,12,1,&joseki_variations[1215],NULL},
  {687,3,2,1,&joseki_variations[1216],NULL},
  {724,3,6,1,&joseki_variations[1217],NULL},
  {761,3,9,1,&joseki_variations[1218],NULL},
  {798,3,12,1,&joseki_variations[1219],NULL},
  {835,0,15,1,&joseki_variations[1220],NULL},
  {872,3,18,2,&joseki_variations[1221],NULL},
  {725,0,7,1,&joseki_variations[1233],NULL},
  {688,0,3,1,&joseki_variations[1223],NULL},
  {725,0,8,1,&joseki_variations[1224],NULL},
  {762,0,12,1,&joseki_variations[1225],NULL},
  {799,0,16,1,&joseki_variations[1226],NULL},
  {836,3,20,1,&joseki_variations[1227],NULL},
  {763,0,13,1,&joseki_variations[1228],NULL},
  {800,3,18,1,&joseki_variations[1229],NULL},
  {837,3,23,1,&joseki_variations[1230],NULL},
  {764,0,14,1,&joseki_variations[1231],NULL},
  {801,0,20,1,&joseki_variations[1232],NULL},
  {832,3,2,0,NULL,&joseki[400]},
  {762,0,11,1,&joseki_variations[1234],NULL},
  {799,0,15,1,&joseki_variations[1235],NULL},
  {836,3,19,1,&joseki_variations[1236],NULL},
  {763,0,12,1,&joseki_variations[1237],NULL},
  {800,3,17,1,&joseki_variations[1238],NULL},
  {837,3,22,1,&joseki_variations[1239],NULL},
  {764,0,13,1,&joseki_variations[1240],NULL},
  {801,0,19,1,&joseki_variations[1241],NULL},
  {688,0,3,0,NULL,&joseki[399]},
  {796,0,5,1,&joseki_variations[1267],NULL},
  {795,3,2,1,&joseki_variations[1244],NULL},
  {797,0,7,1,&joseki_variations[1245],NULL},
  {833,0,6,1,&joseki_variations[1246],NULL},
  {834,0,9,1,&joseki_variations[1247],NULL},
  {869,0,3,1,&joseki_variations[1248],NULL},
  {870,3,8,1,&joseki_variations[1249],NULL},
  {871,3,12,1,&joseki_variations[1250],NULL},
  {907,3,9,1,&joseki_variations[1251],NULL},
  {687,3,2,1,&joseki_variations[1252],NULL},
  {724,3,5,1,&joseki_variations[1253],NULL},
  {761,3,8,1,&joseki_variations[1254],NULL},
  {798,3,11,1,&joseki_variations[1255],NULL},
  {835,0,14,1,&joseki_variations[1256],NULL},
  {872,3,18,1,&joseki_variations[1257],NULL},
  {725,0,6,1,&joseki_variations[1258],NULL},
  {762,0,10,1,&joseki_variations[1259],NULL},
  {799,0,14,1,&joseki_variations[1260],NULL},
  {836,3,18,1,&joseki_variations[1261],NULL},
  {763,0,11,1,&joseki_variations[1262],NULL},
  {800,3,16,1,&joseki_variations[1263],NULL},
  {837,3,21,1,&joseki_variations[1264],NULL},
  {764,0,12,1,&joseki_variations[1265],NULL},
  {801,0,18,1,&joseki_variations[1266],NULL},
  {723,3,4,0,NULL,&joseki[418]},
  {797,3,7,1,&joseki_variations[1268],NULL},
  {833,0,6,1,&joseki_variations[1269],NULL},
  {834,0,9,2,&joseki_variations[1270],NULL},
  {870,3,7,1,&joseki_variations[1291],NULL},
  {869,0,2,1,&joseki_variations[1272],NULL},
  {870,3,8,1,&joseki_variations[1273],NULL},
  {871,3,12,1,&joseki_variations[1274],NULL},
  {907,3,9,1,&joseki_variations[1275],NULL},
  {687,3,2,1,&joseki_variations[1276],NULL},
  {724,3,5,1,&joseki_variations[1277],NULL},
  {761,3,8,1,&joseki_variations[1278],NULL},
  {798,3,11,1,&joseki_variations[1279],NULL},
  {835,0,14,1,&joseki_variations[1280],NULL},
  {872,3,18,1,&joseki_variations[1281],NULL},
  {725,0,6,1,&joseki_variations[1282],NULL},
  {762,0,10,1,&joseki_variations[1283],NULL},
  {799,0,14,1,&joseki_variations[1284],NULL},
  {836,3,18,1,&joseki_variations[1285],NULL},
  {763,0,11,1,&joseki_variations[1286],NULL},
  {800,3,16,1,&joseki_variations[1287],NULL},
  {837,3,21,1,&joseki_variations[1288],NULL},
  {764,0,12,1,&joseki_variations[1289],NULL},
  {801,0,18,1,&joseki_variations[1290],NULL},
  {723,3,4,0,NULL,&joseki[406]},
  {871,3,11,1,&joseki_variations[1292],NULL},
  {687,3,2,1,&joseki_variations[1293],NULL},
  {724,3,5,1,&joseki_variations[1294],NULL},
  {761,3,8,1,&joseki_variations[1295],NULL},
  {798,3,11,1,&joseki_variations[1296],NULL},
  {835,0,14,1,&joseki_variations[1297],NULL},
  {872,3,17,1,&joseki_variations[1298],NULL},
  {725,0,6,1,&joseki_variations[1299],NULL},
  {762,0,10,1,&joseki_variations[1300],NULL},
  {799,0,14,1,&joseki_variations[1301],NULL},
  {836,3,18,1,&joseki_variations[1302],NULL},
  {763,0,11,1,&joseki_variations[1303],NULL},
  {800,3,16,1,&joseki_variations[1304],NULL},
  {837,3,21,1,&joseki_variations[1305],NULL},
  {764,0,12,1,&joseki_variations[1306],NULL},
  {801,0,18,1,&joseki_variations[1307],NULL},
  {723,3,4,0,NULL,&joseki[398]},
  {834,0,6,2,&joseki_variations[1414],NULL},
  {870,3,6,1,&joseki_variations[1376],NULL},
  {760,0,5,2,&joseki_variations[1333],NULL},
  {797,0,5,1,&joseki_variations[1312],NULL},
  {834,0,7,1,&joseki_variations[1313],NULL},
  {869,0,2,1,&joseki_variations[1314],NULL},
  {870,3,7,1,&joseki_variations[1315],NULL},
  {871,3,10,1,&joseki_variations[1316],NULL},
  {907,3,8,1,&joseki_variations[1317],NULL},
  {687,3,2,1,&joseki_variations[1318],NULL},
  {724,3,5,1,&joseki_variations[1319],NULL},
  {761,3,7,1,&joseki_variations[1320],NULL},
  {798,3,9,1,&joseki_variations[1321],NULL},
  {835,0,12,1,&joseki_variations[1322],NULL},
  {872,3,16,1,&joseki_variations[1323],NULL},
  {725,0,6,1,&joseki_variations[1324],NULL},
  {762,0,9,1,&joseki_variations[1325],NULL},
  {799,0,12,1,&joseki_variations[1326],NULL},
  {836,3,16,1,&joseki_variations[1327],NULL},
  {763,0,10,1,&joseki_variations[1328],NULL},
  {800,3,14,1,&joseki_variations[1329],NULL},
  {837,3,19,1,&joseki_variations[1330],NULL},
  {764,0,11,1,&joseki_variations[1331],NULL},
  {801,0,16,1,&joseki_variations[1332],NULL},
  {795,3,2,0,NULL,&joseki[410]},
  {834,0,7,1,&joseki_variations[1356],NULL},
  {797,3,6,1,&joseki_variations[1335],NULL},
  {834,0,8,1,&joseki_variations[1336],NULL},
  {869,0,2,1,&joseki_variations[1337],NULL},
  {870,3,7,1,&joseki_variations[1338],NULL},
  {871,3,11,1,&joseki_variations[1339],NULL},
  {907,3,8,1,&joseki_variations[1340],NULL},
  {687,3,2,1,&joseki_variations[1341],NULL},
  {724,3,5,1,&joseki_variations[1342],NULL},
  {761,3,8,1,&joseki_variations[1343],NULL},
  {798,3,10,1,&joseki_variations[1344],NULL},
  {835,0,13,1,&joseki_variations[1345],NULL},
  {872,3,17,1,&joseki_variations[1346],NULL},
  {725,0,6,1,&joseki_variations[1347],NULL},
  {762,0,10,1,&joseki_variations[1348],NULL},
  {799,0,13,1,&joseki_variations[1349],NULL},
  {836,3,17,1,&joseki_variations[1350],NULL},
  {763,0,11,1,&joseki_variations[1351],NULL},
  {800,3,15,1,&joseki_variations[1352],NULL},
  {837,3,20,1,&joseki_variations[1353],NULL},
  {764,0,12,1,&joseki_variations[1354],NULL},
  {801,0,17,1,&joseki_variations[1355],NULL},
  {796,0,5,0,NULL,&joseki[405]},
  {869,0,2,1,&joseki_variations[1357],NULL},
  {870,3,7,1,&joseki_variations[1358],NULL},
  {871,3,10,1,&joseki_variations[1359],NULL},
  {907,3,8,1,&joseki_variations[1360],NULL},
  {687,3,2,1,&joseki_variations[1361],NULL},
  {724,3,5,1,&joseki_variations[1362],NULL},
  {761,3,8,1,&joseki_variations[1363],NULL},
  {798,3,9,1,&joseki_variations[1364],NULL},
  {835,0,12,1,&joseki_variations[1365],NULL},
  {872,3,16,1,&joseki_variations[1366],NULL},
  {725,0,6,1,&joseki_variations[1367],NULL},
  {762,0,10,1,&joseki_variations[1368],NULL},
  {799,0,12,1,&joseki_variations[1369],NULL},
  {836,3,16,1,&joseki_variations[1370],NULL},
  {763,0,11,1,&joseki_variations[1371],NULL},
  {800,3,14,1,&joseki_variations[1372],NULL},
  {837,3,19,1,&joseki_variations[1373],NULL},
  {764,0,12,1,&joseki_variations[1374],NULL},
  {801,0,16,1,&joseki_variations[1375],NULL},
  {797,3,6,0,NULL,&joseki[404]},
  {760,0,5,2,&joseki_variations[1377],NULL},
  {834,0,7,1,&joseki_variations[1397],NULL},
  {797,3,6,1,&joseki_variations[1379],NULL},
  {834,0,8,1,&joseki_variations[1380],NULL},
  {871,3,10,1,&joseki_variations[1381],NULL},
  {687,3,2,1,&joseki_variations[1382],NULL},
  {724,3,5,1,&joseki_variations[1383],NULL},
  {761,3,8,1,&joseki_variations[1384],NULL},
  {798,3,10,1,&joseki_variations[1385],NULL},
  {835,0,13,1,&joseki_variations[1386],NULL},
  {872,3,16,1,&joseki_variations[1387],NULL},
  {725,0,6,1,&joseki_variations[1388],NULL},
  {762,0,10,1,&joseki_variations[1389],NULL},
  {799,0,13,1,&joseki_variations[1390],NULL},
  {836,3,17,1,&joseki_variations[1391],NULL},
  {763,0,11,1,&joseki_variations[1392],NULL},
  {800,3,15,1,&joseki_variations[1393],NULL},
  {837,3,20,1,&joseki_variations[1394],NULL},
  {764,0,12,1,&joseki_variations[1395],NULL},
  {801,0,17,1,&joseki_variations[1396],NULL},
  {796,0,5,0,NULL,&joseki[397]},
  {871,3,9,1,&joseki_variations[1398],NULL},
  {687,3,2,1,&joseki_variations[1399],NULL},
  {724,3,5,1,&joseki_variations[1400],NULL},
  {761,3,8,1,&joseki_variations[1401],NULL},
  {798,3,9,1,&joseki_variations[1402],NULL},
  {835,0,12,1,&joseki_variations[1403],NULL},
  {872,3,15,1,&joseki_variations[1404],NULL},
  {725,0,6,1,&joseki_variations[1405],NULL},
  {762,0,10,1,&joseki_variations[1406],NULL},
  {799,0,12,1,&joseki_variations[1407],NULL},
  {836,3,16,1,&joseki_variations[1408],NULL},
  {763,0,11,1,&joseki_variations[1409],NULL},
  {800,3,14,1,&joseki_variations[1410],NULL},
  {837,3,19,1,&joseki_variations[1411],NULL},
  {764,0,12,1,&joseki_variations[1412],NULL},
  {801,0,16,1,&joseki_variations[1413],NULL},
  {797,3,6,0,NULL,&joseki[396]},
  {870,3,6,1,&joseki_variations[1436],NULL},
  {869,0,2,1,&joseki_variations[1416],NULL},
  {870,3,7,1,&joseki_variations[1417],NULL},
  {871,3,9,1,&joseki_variations[1418],NULL},
  {687,3,2,1,&joseki_variations[1419],NULL},
  {724,3,5,1,&joseki_variations[1420],NULL},
  {761,3,7,1,&joseki_variations[1421],NULL},
  {798,3,8,1,&joseki_variations[1422],NULL},
  {835,0,11,1,&joseki_variations[1423],NULL},
  {872,3,15,1,&joseki_variations[1424],NULL},
  {725,0,6,1,&joseki_variations[1425],NULL},
  {762,0,9,1,&joseki_variations[1426],NULL},
  {799,0,11,1,&joseki_variations[1427],NULL},
  {836,3,15,1,&joseki_variations[1428],NULL},
  {763,0,10,1,&joseki_variations[1429],NULL},
  {800,3,13,1,&joseki_variations[1430],NULL},
  {837,3,18,1,&joseki_variations[1431],NULL},
  {764,0,11,1,&joseki_variations[1432],NULL},
  {801,0,15,1,&joseki_variations[1433],NULL},
  {907,3,8,2,&joseki_variations[1434],&joseki[402]},
  {760,0,5,0,NULL,&joseki[403]},
  {797,0,5,0,NULL,&joseki[409]},
  {871,3,8,1,&joseki_variations[1437],NULL},
  {687,3,2,1,&joseki_variations[1438],NULL},
  {724,3,5,1,&joseki_variations[1439],NULL},
  {761,3,7,1,&joseki_variations[1440],NULL},
  {798,3,8,1,&joseki_variations[1441],NULL},
  {835,0,11,1,&joseki_variations[1442],NULL},
  {872,3,14,1,&joseki_variations[1443],NULL},
  {725,0,6,1,&joseki_variations[1444],NULL},
  {762,0,9,1,&joseki_variations[1445],NULL},
  {799,0,11,1,&joseki_variations[1446],NULL},
  {836,3,15,1,&joseki_variations[1447],NULL},
  {763,0,10,1,&joseki_variations[1448],NULL},
  {800,3,13,1,&joseki_variations[1449],NULL},
  {837,3,18,1,&joseki_variations[1450],NULL},
  {764,0,11,1,&joseki_variations[1451],NULL},
  {801,0,15,2,&joseki_variations[1452],NULL},
  {760,0,5,0,NULL,&joseki[395]},
  {869,0,2,0,NULL,&joseki[401]},
  {759,0,4,1,&joseki_variations[1455],NULL},
  {761,3,6,1,&joseki_variations[1456],NULL},
  {798,3,7,2,&joseki_variations[1457],NULL},
  {762,0,7,1,&joseki_variations[1474],NULL},
  {833,0,5,1,&joseki_variations[1459],NULL},
  {834,0,6,1,&joseki_variations[1460],NULL},
  {835,0,10,1,&joseki_variations[1461],NULL},
  {870,3,6,1,&joseki_variations[1462],NULL},
  {871,3,8,1,&joseki_variations[1463],NULL},
  {872,3,13,1,&joseki_variations[1464],NULL},
  {725,0,5,1,&joseki_variations[1465],NULL},
  {762,0,8,1,&joseki_variations[1466],NULL},
  {799,0,10,1,&joseki_variations[1467],NULL},
  {836,3,14,1,&joseki_variations[1468],NULL},
  {763,0,9,1,&joseki_variations[1469],NULL},
  {800,3,12,1,&joseki_variations[1470],NULL},
  {837,3,17,1,&joseki_variations[1471],NULL},
  {764,0,10,1,&joseki_variations[1472],NULL},
  {801,0,14,1,&joseki_variations[1473],NULL},
  {687,3,2,0,NULL,&joseki[394]},
  {799,0,9,1,&joseki_variations[1475],NULL},
  {763,0,8,1,&joseki_variations[1476],NULL},
  {800,3,11,1,&joseki_variations[1477],NULL},
  {764,0,9,1,&joseki_variations[1478],NULL},
  {801,0,13,1,&joseki_variations[1479],NULL},
  {833,0,5,1,&joseki_variations[1480],NULL},
  {834,0,6,1,&joseki_variations[1481],NULL},
  {835,0,10,1,&joseki_variations[1482],NULL},
  {836,3,13,1,&joseki_variations[1483],NULL},
  {837,3,16,1,&joseki_variations[1484],NULL},
  {870,3,6,1,&joseki_variations[1485],NULL},
  {871,3,8,1,&joseki_variations[1486],NULL},
  {872,3,13,1,&joseki_variations[1487],NULL},
  {725,0,5,0,NULL,&joseki[393]},
  {795,0,3,1,&joseki_variations[1899],NULL},
  {869,0,3,1,&joseki_variations[1785],NULL},
  {795,3,3,2,&joseki_variations[1543],NULL},
  {832,3,3,1,&joseki_variations[1492],NULL},
  {869,0,4,1,&joseki_variations[1493],NULL},
  {685,3,1,1,&joseki_variations[1494],NULL},
  {722,3,3,1,&joseki_variations[1495],NULL},
  {759,0,5,1,&joseki_variations[1496],NULL},
  {796,0,6,1,&joseki_variations[1497],NULL},
  {833,0,8,1,&joseki_variations[1498],NULL},
  {870,3,10,1,&joseki_variations[1499],NULL},
  {907,3,11,2,&joseki_variations[1500],NULL},
  {723,3,4,1,&joseki_variations[1523],NULL},
  {686,3,2,1,&joseki_variations[1502],NULL},
  {760,3,7,1,&joseki_variations[1503],NULL},
  {797,0,9,1,&joseki_variations[1504],NULL},
  {834,0,12,1,&joseki_variations[1505],NULL},
  {871,3,15,1,&joseki_variations[1506],NULL},
  {687,3,3,1,&joseki_variations[1507],NULL},
  {724,3,6,1,&joseki_variations[1508],NULL},
  {761,3,10,1,&joseki_variations[1509],NULL},
  {798,3,13,1,&joseki_variations[1510],NULL},
  {835,0,17,1,&joseki_variations[1511],NULL},
  {872,3,21,1,&joseki_variations[1512],NULL},
  {688,0,4,1,&joseki_variations[1513],NULL},
  {725,0,8,1,&joseki_variations[1514],NULL},
  {762,0,13,1,&joseki_variations[1515],NULL},
  {799,0,17,1,&joseki_variations[1516],NULL},
  {836,3,22,1,&joseki_variations[1517],NULL},
  {763,0,14,1,&joseki_variations[1518],NULL},
  {800,3,19,1,&joseki_variations[1519],NULL},
  {837,3,25,1,&joseki_variations[1520],NULL},
  {764,0,15,1,&joseki_variations[1521],NULL},
  {801,0,21,1,&joseki_variations[1522],NULL},
  {795,0,3,0,NULL,&joseki[443]},
  {760,0,7,1,&joseki_variations[1524],NULL},
  {797,0,9,1,&joseki_variations[1525],NULL},
  {834,0,12,1,&joseki_variations[1526],NULL},
  {871,3,15,1,&joseki_variations[1527],NULL},
  {687,3,2,1,&joseki_variations[1528],NULL},
  {724,3,6,1,&joseki_variations[1529],NULL},
  {761,3,10,1,&joseki_variations[1530],NULL},
  {798,3,13,1,&joseki_variations[1531],NULL},
  {835,0,17,1,&joseki_variations[1532],NULL},
  {872,3,21,1,&joseki_variations[1533],NULL},
  {725,0,7,1,&joseki_variations[1534],NULL},
  {762,0,12,1,&joseki_variations[1535],NULL},
  {799,0,16,1,&joseki_variations[1536],NULL},
  {836,3,21,1,&joseki_variations[1537],NULL},
  {763,0,13,1,&joseki_variations[1538],NULL},
  {800,3,18,1,&joseki_variations[1539],NULL},
  {837,3,24,1,&joseki_variations[1540],NULL},
  {764,0,14,1,&joseki_variations[1541],NULL},
  {801,0,20,1,&joseki_variations[1542],NULL},
  {795,0,3,0,NULL,&joseki[423]},
  {869,0,4,1,&joseki_variations[1646],NULL},
  {832,3,4,2,&joseki_variations[1545],NULL},
  {869,0,5,1,&joseki_variations[1576],NULL},
  {906,3,5,1,&joseki_variations[1547],NULL},
  {685,3,1,1,&joseki_variations[1548],NULL},
  {722,3,3,1,&joseki_variations[1549],NULL},
  {759,0,5,1,&joseki_variations[1550],NULL},
  {796,0,7,1,&joseki_variations[1551],NULL},
  {833,0,9,1,&joseki_variations[1552],NULL},
  {870,3,10,1,&joseki_variations[1553],NULL},
  {907,3,12,1,&joseki_variations[1554],NULL},
  {686,3,2,1,&joseki_variations[1555],NULL},
  {760,3,7,1,&joseki_variations[1556],NULL},
  {797,0,10,1,&joseki_variations[1557],NULL},
  {834,0,13,1,&joseki_variations[1558],NULL},
  {871,3,15,1,&joseki_variations[1559],NULL},
  {687,3,3,1,&joseki_variations[1560],NULL},
  {724,3,6,1,&joseki_variations[1561],NULL},
  {761,3,10,1,&joseki_variations[1562],NULL},
  {798,3,14,1,&joseki_variations[1563],NULL},
  {835,0,18,1,&joseki_variations[1564],NULL},
  {872,3,21,1,&joseki_variations[1565],NULL},
  {688,0,4,1,&joseki_variations[1566],NULL},
  {725,0,8,1,&joseki_variations[1567],NULL},
  {762,0,13,1,&joseki_variations[1568],NULL},
  {799,0,18,1,&joseki_variations[1569],NULL},
  {836,3,23,1,&joseki_variations[1570],NULL},
  {763,0,14,1,&joseki_variations[1571],NULL},
  {800,3,20,1,&joseki_variations[1572],NULL},
  {837,3,26,1,&joseki_variations[1573],NULL},
  {764,0,15,1,&joseki_variations[1574],NULL},
  {801,0,22,1,&joseki_variations[1575],NULL},
  {869,0,5,0,NULL,&joseki[437]},
  {685,3,1,1,&joseki_variations[1577],NULL},
  {722,3,3,1,&joseki_variations[1578],NULL},
  {759,0,5,1,&joseki_variations[1579],NULL},
  {833,0,8,1,&joseki_variations[1580],NULL},
  {870,3,10,1,&joseki_variations[1581],NULL},
  {907,3,11,3,&joseki_variations[1582],NULL},
  {723,0,4,1,&joseki_variations[1626],NULL},
  {723,3,4,1,&joseki_variations[1606],NULL},
  {686,3,2,1,&joseki_variations[1585],NULL},
  {760,3,7,1,&joseki_variations[1586],NULL},
  {797,0,9,1,&joseki_variations[1587],NULL},
  {834,0,12,1,&joseki_variations[1588],NULL},
  {871,3,15,1,&joseki_variations[1589],NULL},
  {687,3,3,1,&joseki_variations[1590],NULL},
  {724,3,6,1,&joseki_variations[1591],NULL},
  {761,3,10,1,&joseki_variations[1592],NULL},
  {798,3,13,1,&joseki_variations[1593],NULL},
  {835,0,17,1,&joseki_variations[1594],NULL},
  {872,3,21,1,&joseki_variations[1595],NULL},
  {688,0,4,1,&joseki_variations[1596],NULL},
  {725,0,8,1,&joseki_variations[1597],NULL},
  {762,0,13,1,&joseki_variations[1598],NULL},
  {799,0,17,1,&joseki_variations[1599],NULL},
  {836,3,22,1,&joseki_variations[1600],NULL},
  {763,0,14,1,&joseki_variations[1601],NULL},
  {800,3,19,1,&joseki_variations[1602],NULL},
  {837,3,25,1,&joseki_variations[1603],NULL},
  {764,0,15,1,&joseki_variations[1604],NULL},
  {801,0,21,1,&joseki_variations[1605],NULL},
  {796,0,7,0,NULL,&joseki[441]},
  {760,0,7,1,&joseki_variations[1607],NULL},
  {797,0,9,1,&joseki_variations[1608],NULL},
  {834,0,12,1,&joseki_variations[1609],NULL},
  {871,3,15,1,&joseki_variations[1610],NULL},
  {687,3,2,1,&joseki_variations[1611],NULL},
  {724,3,6,1,&joseki_variations[1612],NULL},
  {761,3,10,1,&joseki_variations[1613],NULL},
  {798,3,13,1,&joseki_variations[1614],NULL},
  {835,0,17,1,&joseki_variations[1615],NULL},
  {872,3,21,1,&joseki_variations[1616],NULL},
  {725,0,7,1,&joseki_variations[1617],NULL},
  {762,0,12,1,&joseki_variations[1618],NULL},
  {799,0,16,1,&joseki_variations[1619],NULL},
  {836,3,21,1,&joseki_variations[1620],NULL},
  {763,0,13,1,&joseki_variations[1621],NULL},
  {800,3,18,1,&joseki_variations[1622],NULL},
  {837,3,24,1,&joseki_variations[1623],NULL},
  {764,0,14,1,&joseki_variations[1624],NULL},
  {801,0,20,1,&joseki_variations[1625],NULL},
  {796,0,7,0,NULL,&joseki[421]},
  {760,3,7,1,&joseki_variations[1627],NULL},
  {797,0,9,1,&joseki_variations[1628],NULL},
  {834,0,12,1,&joseki_variations[1629],NULL},
  {871,3,15,1,&joseki_variations[1630],NULL},
  {687,3,2,1,&joseki_variations[1631],NULL},
  {724,3,6,1,&joseki_variations[1632],NULL},
  {761,3,10,1,&joseki_variations[1633],NULL},
  {798,3,13,1,&joseki_variations[1634],NULL},
  {835,0,17,1,&joseki_variations[1635],NULL},
  {872,3,21,1,&joseki_variations[1636],NULL},
  {725,0,7,1,&joseki_variations[1637],NULL},
  {762,0,12,1,&joseki_variations[1638],NULL},
  {799,0,16,1,&joseki_variations[1639],NULL},
  {836,3,21,1,&joseki_variations[1640],NULL},
  {763,0,13,1,&joseki_variations[1641],NULL},
  {800,3,18,1,&joseki_variations[1642],NULL},
  {837,3,24,1,&joseki_variations[1643],NULL},
  {764,0,14,1,&joseki_variations[1644],NULL},
  {801,0,20,1,&joseki_variations[1645],NULL},
  {796,0,7,0,NULL,&joseki[415]},
  {685,3,1,1,&joseki_variations[1647],NULL},
  {722,3,3,1,&joseki_variations[1648],NULL},
  {759,0,5,3,&joseki_variations[1649],NULL},
  {797,0,7,1,&joseki_variations[1764],NULL},
  {833,0,7,1,&joseki_variations[1678],NULL},
  {796,0,7,1,&joseki_variations[1652],NULL},
  {833,0,8,1,&joseki_variations[1653],NULL},
  {870,3,10,1,&joseki_variations[1654],NULL},
  {906,3,5,1,&joseki_variations[1655],NULL},
  {907,3,12,1,&joseki_variations[1656],NULL},
  {686,3,2,1,&joseki_variations[1657],NULL},
  {760,3,7,1,&joseki_variations[1658],NULL},
  {797,0,10,1,&joseki_variations[1659],NULL},
  {834,0,12,1,&joseki_variations[1660],NULL},
  {871,3,15,1,&joseki_variations[1661],NULL},
  {687,3,3,1,&joseki_variations[1662],NULL},
  {724,3,6,1,&joseki_variations[1663],NULL},
  {761,3,10,1,&joseki_variations[1664],NULL},
  {798,3,14,1,&joseki_variations[1665],NULL},
  {835,0,17,1,&joseki_variations[1666],NULL},
  {872,3,21,1,&joseki_variations[1667],NULL},
  {688,0,4,1,&joseki_variations[1668],NULL},
  {725,0,8,1,&joseki_variations[1669],NULL},
  {762,0,13,1,&joseki_variations[1670],NULL},
  {799,0,18,1,&joseki_variations[1671],NULL},
  {836,3,22,1,&joseki_variations[1672],NULL},
  {763,0,14,1,&joseki_variations[1673],NULL},
  {800,3,20,1,&joseki_variations[1674],NULL},
  {837,3,25,1,&joseki_variations[1675],NULL},
  {764,0,15,1,&joseki_variations[1676],NULL},
  {801,0,22,1,&joseki_variations[1677],NULL},
  {832,3,4,0,NULL,&joseki[436]},
  {870,3,9,1,&joseki_variations[1679],NULL},
  {907,3,10,4,&joseki_variations[1680],NULL},
  {760,3,6,1,&joseki_variations[1745],NULL},
  {723,0,4,1,&joseki_variations[1725],NULL},
  {723,3,4,1,&joseki_variations[1705],NULL},
  {686,3,2,1,&joseki_variations[1684],NULL},
  {760,3,7,1,&joseki_variations[1685],NULL},
  {797,0,9,1,&joseki_variations[1686],NULL},
  {834,0,11,1,&joseki_variations[1687],NULL},
  {871,3,14,1,&joseki_variations[1688],NULL},
  {687,3,3,1,&joseki_variations[1689],NULL},
  {724,3,6,1,&joseki_variations[1690],NULL},
  {761,3,10,1,&joseki_variations[1691],NULL},
  {798,3,13,1,&joseki_variations[1692],NULL},
  {835,0,16,1,&joseki_variations[1693],NULL},
  {872,3,20,1,&joseki_variations[1694],NULL},
  {688,0,4,1,&joseki_variations[1695],NULL},
  {725,0,8,1,&joseki_variations[1696],NULL},
  {762,0,13,1,&joseki_variations[1697],NULL},
  {799,0,17,1,&joseki_variations[1698],NULL},
  {836,3,21,1,&joseki_variations[1699],NULL},
  {763,0,14,1,&joseki_variations[1700],NULL},
  {800,3,19,1,&joseki_variations[1701],NULL},
  {837,3,24,1,&joseki_variations[1702],NULL},
  {764,0,15,1,&joseki_variations[1703],NULL},
  {801,0,21,1,&joseki_variations[1704],NULL},
  {832,3,4,0,NULL,&joseki[440]},
  {760,0,7,1,&joseki_variations[1706],NULL},
  {797,0,9,1,&joseki_variations[1707],NULL},
  {834,0,11,1,&joseki_variations[1708],NULL},
  {871,3,14,1,&joseki_variations[1709],NULL},
  {687,3,2,1,&joseki_variations[1710],NULL},
  {724,3,6,1,&joseki_variations[1711],NULL},
  {761,3,10,1,&joseki_variations[1712],NULL},
  {798,3,13,1,&joseki_variations[1713],NULL},
  {835,0,16,1,&joseki_variations[1714],NULL},
  {872,3,20,1,&joseki_variations[1715],NULL},
  {725,0,7,1,&joseki_variations[1716],NULL},
  {762,0,12,1,&joseki_variations[1717],NULL},
  {799,0,16,1,&joseki_variations[1718],NULL},
  {836,3,20,1,&joseki_variations[1719],NULL},
  {763,0,13,1,&joseki_variations[1720],NULL},
  {800,3,18,1,&joseki_variations[1721],NULL},
  {837,3,23,1,&joseki_variations[1722],NULL},
  {764,0,14,1,&joseki_variations[1723],NULL},
  {801,0,20,1,&joseki_variations[1724],NULL},
  {832,3,4,0,NULL,&joseki[420]},
  {760,3,7,1,&joseki_variations[1726],NULL},
  {797,0,9,1,&joseki_variations[1727],NULL},
  {834,0,11,1,&joseki_variations[1728],NULL},
  {871,3,14,1,&joseki_variations[1729],NULL},
  {687,3,2,1,&joseki_variations[1730],NULL},
  {724,3,6,1,&joseki_variations[1731],NULL},
  {761,3,10,1,&joseki_variations[1732],NULL},
  {798,3,13,1,&joseki_variations[1733],NULL},
  {835,0,16,1,&joseki_variations[1734],NULL},
  {872,3,20,1,&joseki_variations[1735],NULL},
  {725,0,7,1,&joseki_variations[1736],NULL},
  {762,0,12,1,&joseki_variations[1737],NULL},
  {799,0,16,1,&joseki_variations[1738],NULL},
  {836,3,20,1,&joseki_variations[1739],NULL},
  {763,0,13,1,&joseki_variations[1740],NULL},
  {800,3,18,1,&joseki_variations[1741],NULL},
  {837,3,23,1,&joseki_variations[1742],NULL},
  {764,0,14,1,&joseki_variations[1743],NULL},
  {801,0,20,1,&joseki_variations[1744],NULL},
  {832,3,4,0,NULL,&joseki[414]},
  {797,0,8,1,&joseki_variations[1746],NULL},
  {834,0,10,1,&joseki_variations[1747],NULL},
  {871,3,13,1,&joseki_variations[1748],NULL},
  {687,3,2,1,&joseki_variations[1749],NULL},
  {724,3,5,1,&joseki_variations[1750],NULL},
  {761,3,9,1,&joseki_variations[1751],NULL},
  {798,3,12,1,&joseki_variations[1752],NULL},
  {835,0,15,1,&joseki_variations[1753],NULL},
  {872,3,19,1,&joseki_variations[1754],NULL},
  {725,0,6,1,&joseki_variations[1755],NULL},
  {762,0,11,1,&joseki_variations[1756],NULL},
  {799,0,15,1,&joseki_variations[1757],NULL},
  {836,3,19,1,&joseki_variations[1758],NULL},
  {763,0,12,1,&joseki_variations[1759],NULL},
  {800,3,17,1,&joseki_variations[1760],NULL},
  {837,3,22,1,&joseki_variations[1761],NULL},
  {764,0,13,1,&joseki_variations[1762],NULL},
  {801,0,19,1,&joseki_variations[1763],NULL},
  {723,0,4,0,NULL,&joseki[413]},
  {833,0,7,1,&joseki_variations[1765],NULL},
  {834,0,9,1,&joseki_variations[1766],NULL},
  {870,3,9,1,&joseki_variations[1767],NULL},
  {871,3,12,1,&joseki_variations[1768],NULL},
  {907,3,10,1,&joseki_variations[1769],NULL},
  {687,3,2,1,&joseki_variations[1770],NULL},
  {724,3,5,1,&joseki_variations[1771],NULL},
  {761,3,8,1,&joseki_variations[1772],NULL},
  {798,3,11,1,&joseki_variations[1773],NULL},
  {835,0,14,1,&joseki_variations[1774],NULL},
  {872,3,18,1,&joseki_variations[1775],NULL},
  {725,0,6,1,&joseki_variations[1776],NULL},
  {762,0,10,1,&joseki_variations[1777],NULL},
  {799,0,14,1,&joseki_variations[1778],NULL},
  {836,3,18,1,&joseki_variations[1779],NULL},
  {763,0,11,1,&joseki_variations[1780],NULL},
  {800,3,16,1,&joseki_variations[1781],NULL},
  {837,3,21,1,&joseki_variations[1782],NULL},
  {764,0,12,1,&joseki_variations[1783],NULL},
  {801,0,18,1,&joseki_variations[1784],NULL},
  {760,3,6,0,NULL,&joseki[412]},
  {685,3,1,1,&joseki_variations[1786],NULL},
  {722,3,3,1,&joseki_variations[1787],NULL},
  {759,0,5,1,&joseki_variations[1788],NULL},
  {796,0,6,1,&joseki_variations[1789],NULL},
  {833,0,7,1,&joseki_variations[1790],NULL},
  {870,3,9,2,&joseki_variations[1791],NULL},
  {907,3,10,3,&joseki_variations[1816],NULL},
  {906,3,4,1,&joseki_variations[1793],NULL},
  {907,3,11,1,&joseki_variations[1794],NULL},
  {686,3,2,1,&joseki_variations[1795],NULL},
  {760,3,7,1,&joseki_variations[1796],NULL},
  {797,0,9,1,&joseki_variations[1797],NULL},
  {834,0,11,1,&joseki_variations[1798],NULL},
  {871,3,14,1,&joseki_variations[1799],NULL},
  {687,3,3,1,&joseki_variations[1800],NULL},
  {724,3,6,1,&joseki_variations[1801],NULL},
  {761,3,10,1,&joseki_variations[1802],NULL},
  {798,3,13,1,&joseki_variations[1803],NULL},
  {835,0,16,1,&joseki_variations[1804],NULL},
  {872,3,20,1,&joseki_variations[1805],NULL},
  {688,0,4,1,&joseki_variations[1806],NULL},
  {725,0,8,1,&joseki_variations[1807],NULL},
  {762,0,13,1,&joseki_variations[1808],NULL},
  {799,0,17,1,&joseki_variations[1809],NULL},
  {836,3,21,1,&joseki_variations[1810],NULL},
  {763,0,14,1,&joseki_variations[1811],NULL},
  {800,3,19,1,&joseki_variations[1812],NULL},
  {837,3,24,1,&joseki_variations[1813],NULL},
  {764,0,15,1,&joseki_variations[1814],NULL},
  {801,0,21,1,&joseki_variations[1815],NULL},
  {832,3,3,0,NULL,&joseki[438]},
  {723,3,4,1,&joseki_variations[1860],NULL},
  {723,0,4,1,&joseki_variations[1840],NULL},
  {686,3,2,1,&joseki_variations[1819],NULL},
  {760,3,7,1,&joseki_variations[1820],NULL},
  {797,0,9,1,&joseki_variations[1821],NULL},
  {834,0,11,1,&joseki_variations[1822],NULL},
  {871,3,14,1,&joseki_variations[1823],NULL},
  {687,3,3,1,&joseki_variations[1824],NULL},
  {724,3,6,1,&joseki_variations[1825],NULL},
  {761,3,10,1,&joseki_variations[1826],NULL},
  {798,3,13,1,&joseki_variations[1827],NULL},
  {835,0,16,1,&joseki_variations[1828],NULL},
  {872,3,20,1,&joseki_variations[1829],NULL},
  {688,0,4,1,&joseki_variations[1830],NULL},
  {725,0,8,1,&joseki_variations[1831],NULL},
  {762,0,13,1,&joseki_variations[1832],NULL},
  {799,0,17,1,&joseki_variations[1833],NULL},
  {836,3,21,1,&joseki_variations[1834],NULL},
  {763,0,14,1,&joseki_variations[1835],NULL},
  {800,3,19,1,&joseki_variations[1836],NULL},
  {837,3,24,1,&joseki_variations[1837],NULL},
  {764,0,15,1,&joseki_variations[1838],NULL},
  {801,0,21,1,&joseki_variations[1839],NULL},
  {832,3,3,0,NULL,&joseki[442]},
  {760,3,7,1,&joseki_variations[1841],NULL},
  {797,0,9,1,&joseki_variations[1842],NULL},
  {834,0,11,1,&joseki_variations[1843],NULL},
  {871,3,14,1,&joseki_variations[1844],NULL},
  {687,3,2,1,&joseki_variations[1845],NULL},
  {724,3,6,1,&joseki_variations[1846],NULL},
  {761,3,10,1,&joseki_variations[1847],NULL},
  {798,3,13,1,&joseki_variations[1848],NULL},
  {835,0,16,1,&joseki_variations[1849],NULL},
  {872,3,20,1,&joseki_variations[1850],NULL},
  {725,0,7,1,&joseki_variations[1851],NULL},
  {762,0,12,1,&joseki_variations[1852],NULL},
  {799,0,16,1,&joseki_variations[1853],NULL},
  {836,3,20,1,&joseki_variations[1854],NULL},
  {763,0,13,1,&joseki_variations[1855],NULL},
  {800,3,18,1,&joseki_variations[1856],NULL},
  {837,3,23,1,&joseki_variations[1857],NULL},
  {764,0,14,1,&joseki_variations[1858],NULL},
  {801,0,20,1,&joseki_variations[1859],NULL},
  {832,3,3,0,NULL,&joseki[416]},
  {760,0,7,2,&joseki_variations[1861],NULL},
  {797,3,9,1,&joseki_variations[1881],NULL},
  {797,0,9,1,&joseki_variations[1863],NULL},
  {834,0,11,1,&joseki_variations[1864],NULL},
  {871,3,14,1,&joseki_variations[1865],NULL},
  {687,3,2,1,&joseki_variations[1866],NULL},
  {724,3,6,1,&joseki_variations[1867],NULL},
  {761,3,10,1,&joseki_variations[1868],NULL},
  {798,3,13,1,&joseki_variations[1869],NULL},
  {835,0,16,1,&joseki_variations[1870],NULL},
  {872,3,20,1,&joseki_variations[1871],NULL},
  {725,0,7,1,&joseki_variations[1872],NULL},
  {762,0,12,1,&joseki_variations[1873],NULL},
  {799,0,16,1,&joseki_variations[1874],NULL},
  {836,3,20,1,&joseki_variations[1875],NULL},
  {763,0,13,1,&joseki_variations[1876],NULL},
  {800,3,18,1,&joseki_variations[1877],NULL},
  {837,3,23,1,&joseki_variations[1878],NULL},
  {764,0,14,1,&joseki_variations[1879],NULL},
  {801,0,20,1,&joseki_variations[1880],NULL},
  {832,3,3,0,NULL,&joseki[422]},
  {834,0,11,1,&joseki_variations[1882],NULL},
  {871,3,14,1,&joseki_variations[1883],NULL},
  {687,3,2,1,&joseki_variations[1884],NULL},
  {724,3,6,1,&joseki_variations[1885],NULL},
  {761,3,10,1,&joseki_variations[1886],NULL},
  {798,3,13,1,&joseki_variations[1887],NULL},
  {835,0,16,1,&joseki_variations[1888],NULL},
  {872,3,20,1,&joseki_variations[1889],NULL},
  {725,0,7,1,&joseki_variations[1890],NULL},
  {762,0,12,1,&joseki_variations[1891],NULL},
  {799,0,16,1,&joseki_variations[1892],NULL},
  {836,3,20,1,&joseki_variations[1893],NULL},
  {763,0,13,1,&joseki_variations[1894],NULL},
  {800,3,18,1,&joseki_variations[1895],NULL},
  {837,3,23,1,&joseki_variations[1896],NULL},
  {764,0,14,1,&joseki_variations[1897],NULL},
  {801,0,20,1,&joseki_variations[1898],NULL},
  {832,3,3,0,NULL,&joseki[408]},
  {685,3,1,2,&joseki_variations[1900],NULL},
  {722,0,3,1,&joseki_variations[1978],NULL},
  {869,0,4,1,&joseki_variations[1902],NULL},
  {722,3,3,1,&joseki_variations[1903],NULL},
  {759,0,5,1,&joseki_variations[1904],NULL},
  {796,0,7,1,&joseki_variations[1905],NULL},
  {833,0,8,1,&joseki_variations[1906],NULL},
  {870,3,10,2,&joseki_variations[1907],NULL},
  {907,3,11,3,&joseki_variations[1939],NULL},
  {906,0,5,1,&joseki_variations[1909],NULL},
  {907,3,12,3,&joseki_variations[1910],NULL},
  {944,3,13,2,&joseki_variations[1932],&joseki[426]},
  {943,0,6,1,&joseki_variations[1929],NULL},
  {686,3,2,1,&joseki_variations[1913],NULL},
  {760,3,7,1,&joseki_variations[1914],NULL},
  {797,0,10,1,&joseki_variations[1915],NULL},
  {834,0,12,1,&joseki_variations[1916],NULL},
  {871,3,15,1,&joseki_variations[1917],NULL},
  {687,3,3,1,&joseki_variations[1918],NULL},
  {724,3,6,1,&joseki_variations[1919],NULL},
  {761,3,10,1,&joseki_variations[1920],NULL},
  {798,3,14,1,&joseki_variations[1921],NULL},
  {835,0,17,1,&joseki_variations[1922],NULL},
  {872,3,21,1,&joseki_variations[1923],NULL},
  {688,0,4,1,&joseki_variations[1924],NULL},
  {725,0,8,1,&joseki_variations[1925],NULL},
  {762,0,13,1,&joseki_variations[1926],NULL},
  {799,0,18,1,&joseki_variations[1927],NULL},
  {836,3,22,1,&joseki_variations[1928],NULL},
  {944,3,13,0,NULL,&joseki[445]},
  {944,3,14,2,&joseki_variations[1930],NULL},
  {981,3,15,0,NULL,&joseki[428]},
  {980,3,7,0,NULL,&joseki[447]},
  {943,0,6,0,NULL,&joseki[427]},
  {686,3,2,1,&joseki_variations[1934],NULL},
  {760,3,7,1,&joseki_variations[1935],NULL},
  {797,0,10,1,&joseki_variations[1936],NULL},
  {834,0,12,1,&joseki_variations[1937],NULL},
  {871,3,15,1,&joseki_variations[1938],NULL},
  {943,0,6,0,NULL,&joseki[446]},
  {723,3,4,1,&joseki_variations[1958],NULL},
  {906,0,5,0,NULL,&joseki[425]},
  {686,3,2,1,&joseki_variations[1942],NULL},
  {760,3,7,1,&joseki_variations[1943],NULL},
  {797,0,10,1,&joseki_variations[1944],NULL},
  {834,0,12,1,&joseki_variations[1945],NULL},
  {871,3,15,1,&joseki_variations[1946],NULL},
  {687,3,3,1,&joseki_variations[1947],NULL},
  {724,3,6,1,&joseki_variations[1948],NULL},
  {761,3,10,1,&joseki_variations[1949],NULL},
  {798,3,14,1,&joseki_variations[1950],NULL},
  {835,0,17,1,&joseki_variations[1951],NULL},
  {872,3,21,1,&joseki_variations[1952],NULL},
  {688,0,4,1,&joseki_variations[1953],NULL},
  {725,0,8,1,&joseki_variations[1954],NULL},
  {762,0,13,1,&joseki_variations[1955],NULL},
  {799,0,18,1,&joseki_variations[1956],NULL},
  {836,3,22,1,&joseki_variations[1957],NULL},
  {906,0,5,0,NULL,&joseki[444]},
  {760,0,7,1,&joseki_variations[1959],NULL},
  {797,0,10,1,&joseki_variations[1960],NULL},
  {834,0,12,1,&joseki_variations[1961],NULL},
  {871,3,15,1,&joseki_variations[1962],NULL},
  {687,3,2,1,&joseki_variations[1963],NULL},
  {724,3,6,1,&joseki_variations[1964],NULL},
  {761,3,10,1,&joseki_variations[1965],NULL},
  {798,3,14,1,&joseki_variations[1966],NULL},
  {835,0,17,1,&joseki_variations[1967],NULL},
  {872,3,21,1,&joseki_variations[1968],NULL},
  {725,0,7,1,&joseki_variations[1969],NULL},
  {762,0,12,1,&joseki_variations[1970],NULL},
  {799,0,17,1,&joseki_variations[1971],NULL},
  {836,3,21,1,&joseki_variations[1972],NULL},
  {763,0,13,1,&joseki_variations[1973],NULL},
  {800,3,19,1,&joseki_variations[1974],NULL},
  {837,3,24,1,&joseki_variations[1975],NULL},
  {764,0,14,1,&joseki_variations[1976],NULL},
  {801,0,21,1,&joseki_variations[1977],NULL},
  {688,0,3,0,NULL,&joseki[424]},
  {759,3,5,1,&joseki_variations[1979],NULL},
  {796,0,7,1,&joseki_variations[1980],NULL},
  {833,0,8,1,&joseki_variations[1981],NULL},
  {870,3,9,1,&joseki_variations[1982],NULL},
  {723,3,4,1,&joseki_variations[1983],NULL},
  {760,3,7,1,&joseki_variations[1984],NULL},
  {797,3,10,1,&joseki_variations[1985],NULL},
  {834,0,12,1,&joseki_variations[1986],NULL},
  {871,3,14,1,&joseki_variations[1987],NULL},
  {724,3,5,1,&joseki_variations[1988],NULL},
  {761,3,9,1,&joseki_variations[1989],NULL},
  {798,3,13,1,&joseki_variations[1990],NULL},
  {835,0,16,1,&joseki_variations[1991],NULL},
  {872,3,19,1,&joseki_variations[1992],NULL},
  {762,0,10,1,&joseki_variations[1993],NULL},
  {799,0,15,1,&joseki_variations[1994],NULL},
  {836,3,19,1,&joseki_variations[1995],NULL},
  {763,0,11,1,&joseki_variations[1996],NULL},
  {800,3,17,1,&joseki_variations[1997],NULL},
  {837,3,22,1,&joseki_variations[1998],NULL},
  {764,0,12,1,&joseki_variations[1999],NULL},
  {801,0,19,1,&joseki_variations[2000],NULL},
  {869,3,4,0,NULL,&joseki[384]},
  {724,0,3,1,&joseki_variations[2399],NULL},
  {724,3,3,1,&joseki_variations[2247],NULL},
  {759,0,3,3,&joseki_variations[2004],NULL},
  {796,0,4,1,&joseki_variations[2222],NULL},
  {723,3,3,1,&joseki_variations[2114],NULL},
  {795,0,2,2,&joseki_variations[2007],NULL},
  {833,0,5,2,&joseki_variations[2052],NULL},
  {832,0,3,1,&joseki_variations[2009],NULL},
  {833,0,6,1,&joseki_variations[2010],NULL},
  {869,3,4,1,&joseki_variations[2011],NULL},
  {870,3,8,1,&joseki_variations[2012],NULL},
  {686,3,1,1,&joseki_variations[2013],NULL},
  {723,3,4,1,&joseki_variations[2014],NULL},
  {760,3,6,1,&joseki_variations[2015],NULL},
  {797,0,8,1,&joseki_variations[2016],NULL},
  {834,0,11,1,&joseki_variations[2017],NULL},
  {871,3,14,1,&joseki_variations[2018],NULL},
  {761,3,7,1,&joseki_variations[2019],NULL},
  {798,3,10,1,&joseki_variations[2020],NULL},
  {835,0,14,1,&joseki_variations[2021],NULL},
  {872,3,18,1,&joseki_variations[2022],NULL},
  {688,3,2,1,&joseki_variations[2023],NULL},
  {725,3,6,1,&joseki_variations[2024],NULL},
  {762,0,10,1,&joseki_variations[2025],NULL},
  {799,0,14,1,&joseki_variations[2026],NULL},
  {836,3,19,2,&joseki_variations[2027],NULL},
  {726,0,7,1,&joseki_variations[2046],NULL},
  {689,0,3,1,&joseki_variations[2029],NULL},
  {726,0,8,1,&joseki_variations[2030],NULL},
  {763,0,13,1,&joseki_variations[2031],NULL},
  {800,3,18,1,&joseki_variations[2032],NULL},
  {837,3,24,2,&joseki_variations[2033],NULL},
  {801,0,19,2,&joseki_variations[2040],NULL},
  {764,0,14,1,&joseki_variations[2035],NULL},
  {801,0,20,1,&joseki_variations[2036],NULL},
  {838,3,27,1,&joseki_variations[2037],NULL},
  {765,0,15,1,&joseki_variations[2038],NULL},
  {802,3,22,1,&joseki_variations[2039],NULL},
  {803,3,23,0,NULL,&joseki[553]},
  {802,3,20,1,&joseki_variations[2045],&joseki[549]},
  {765,0,14,1,&joseki_variations[2042],NULL},
  {802,3,21,1,&joseki_variations[2043],NULL},
  {838,3,26,1,&joseki_variations[2044],&joseki[551]},
  {764,0,14,0,NULL,&joseki[552]},
  {765,0,14,0,NULL,&joseki[550]},
  {763,0,12,1,&joseki_variations[2047],NULL},
  {800,3,17,1,&joseki_variations[2048],NULL},
  {837,3,23,1,&joseki_variations[2049],NULL},
  {801,0,18,1,&joseki_variations[2050],NULL},
  {765,0,13,1,&joseki_variations[2051],NULL},
  {684,3,1,0,NULL,&joseki[542]},
  {870,3,6,1,&joseki_variations[2084],NULL},
  {869,3,3,1,&joseki_variations[2054],NULL},
  {870,3,7,1,&joseki_variations[2055],NULL},
  {686,3,1,1,&joseki_variations[2056],NULL},
  {723,3,4,1,&joseki_variations[2057],NULL},
  {760,3,6,1,&joseki_variations[2058],NULL},
  {797,0,8,1,&joseki_variations[2059],NULL},
  {834,0,10,1,&joseki_variations[2060],NULL},
  {871,3,13,1,&joseki_variations[2061],NULL},
  {761,3,7,1,&joseki_variations[2062],NULL},
  {798,3,10,1,&joseki_variations[2063],NULL},
  {835,0,13,1,&joseki_variations[2064],NULL},
  {872,3,17,1,&joseki_variations[2065],NULL},
  {688,3,2,1,&joseki_variations[2066],NULL},
  {725,3,6,1,&joseki_variations[2067],NULL},
  {762,0,10,1,&joseki_variations[2068],NULL},
  {799,0,14,1,&joseki_variations[2069],NULL},
  {836,3,18,2,&joseki_variations[2070],NULL},
  {726,0,7,1,&joseki_variations[2078],NULL},
  {689,0,3,1,&joseki_variations[2072],NULL},
  {726,0,8,1,&joseki_variations[2073],NULL},
  {763,0,13,1,&joseki_variations[2074],NULL},
  {800,3,18,1,&joseki_variations[2075],NULL},
  {837,3,23,1,&joseki_variations[2076],NULL},
  {801,0,19,1,&joseki_variations[2077],NULL},
  {832,0,3,0,NULL,&joseki[548]},
  {763,0,12,1,&joseki_variations[2079],NULL},
  {800,3,17,1,&joseki_variations[2080],NULL},
  {837,3,22,1,&joseki_variations[2081],NULL},
  {801,0,18,1,&joseki_variations[2082],NULL},
  {765,0,13,1,&joseki_variations[2083],NULL},
  {832,0,3,0,NULL,&joseki[541]},
  {686,3,1,1,&joseki_variations[2085],NULL},
  {723,3,4,1,&joseki_variations[2086],NULL},
  {760,3,6,1,&joseki_variations[2087],NULL},
  {797,0,8,1,&joseki_variations[2088],NULL},
  {834,0,10,1,&joseki_variations[2089],NULL},
  {871,3,12,1,&joseki_variations[2090],NULL},
  {761,3,7,1,&joseki_variations[2091],NULL},
  {798,3,10,1,&joseki_variations[2092],NULL},
  {835,0,13,1,&joseki_variations[2093],NULL},
  {872,3,16,1,&joseki_variations[2094],NULL},
  {688,3,2,1,&joseki_variations[2095],NULL},
  {725,3,6,1,&joseki_variations[2096],NULL},
  {762,0,10,1,&joseki_variations[2097],NULL},
  {799,0,14,1,&joseki_variations[2098],NULL},
  {836,3,18,2,&joseki_variations[2099],NULL},
  {726,0,7,1,&joseki_variations[2107],NULL},
  {689,0,3,1,&joseki_variations[2101],NULL},
  {726,0,8,1,&joseki_variations[2102],NULL},
  {763,0,13,1,&joseki_variations[2103],NULL},
  {800,3,18,1,&joseki_variations[2104],NULL},
  {837,3,23,1,&joseki_variations[2105],NULL},
  {801,0,19,1,&joseki_variations[2106],NULL},
  {869,3,3,0,NULL,&joseki[547]},
  {763,0,12,1,&joseki_variations[2108],NULL},
  {800,3,17,1,&joseki_variations[2109],NULL},
  {837,3,22,1,&joseki_variations[2110],NULL},
  {801,0,18,2,&joseki_variations[2111],NULL},
  {765,0,13,1,&joseki_variations[2113],&joseki[539]},
  {689,0,3,0,NULL,&joseki[546]},
  {869,3,3,0,NULL,&joseki[540]},
  {760,3,5,2,&joseki_variations[2115],NULL},
  {724,0,4,1,&joseki_variations[2168],NULL},
  {795,0,2,1,&joseki_variations[2117],NULL},
  {797,0,7,1,&joseki_variations[2118],NULL},
  {833,0,5,1,&joseki_variations[2119],NULL},
  {834,0,9,1,&joseki_variations[2120],NULL},
  {870,3,6,1,&joseki_variations[2121],NULL},
  {871,3,11,2,&joseki_variations[2122],NULL},
  {687,0,1,1,&joseki_variations[2138],NULL},
  {687,3,1,1,&joseki_variations[2124],NULL},
  {761,3,7,1,&joseki_variations[2125],NULL},
  {798,3,10,1,&joseki_variations[2126],NULL},
  {835,0,13,1,&joseki_variations[2127],NULL},
  {872,3,16,1,&joseki_variations[2128],NULL},
  {725,3,5,1,&joseki_variations[2129],NULL},
  {762,0,9,1,&joseki_variations[2130],NULL},
  {799,0,13,1,&joseki_variations[2131],NULL},
  {836,3,17,1,&joseki_variations[2132],NULL},
  {726,0,6,1,&joseki_variations[2133],NULL},
  {763,0,11,1,&joseki_variations[2134],NULL},
  {800,3,16,1,&joseki_variations[2135],NULL},
  {837,3,21,1,&joseki_variations[2136],NULL},
  {801,0,17,1,&joseki_variations[2137],NULL},
  {685,0,1,0,NULL,&joseki[556]},
  {724,0,5,1,&joseki_variations[2139],NULL},
  {761,3,8,1,&joseki_variations[2140],NULL},
  {798,3,11,1,&joseki_variations[2141],NULL},
  {835,0,14,1,&joseki_variations[2142],NULL},
  {872,3,17,2,&joseki_variations[2143],NULL},
  {725,3,6,1,&joseki_variations[2160],NULL},
  {688,3,2,1,&joseki_variations[2145],NULL},
  {725,3,7,1,&joseki_variations[2146],NULL},
  {762,0,11,1,&joseki_variations[2147],NULL},
  {799,0,15,1,&joseki_variations[2148],NULL},
  {836,3,19,2,&joseki_variations[2149],NULL},
  {763,0,12,1,&joseki_variations[2156],NULL},
  {726,0,8,1,&joseki_variations[2151],NULL},
  {763,0,13,1,&joseki_variations[2152],NULL},
  {800,3,18,1,&joseki_variations[2153],NULL},
  {837,3,23,1,&joseki_variations[2154],NULL},
  {801,0,19,1,&joseki_variations[2155],NULL},
  {686,3,1,0,NULL,&joseki[538]},
  {800,3,17,1,&joseki_variations[2157],NULL},
  {837,3,22,1,&joseki_variations[2158],NULL},
  {801,0,18,1,&joseki_variations[2159],NULL},
  {726,0,8,0,NULL,&joseki[537]},
  {762,0,10,1,&joseki_variations[2161],NULL},
  {799,0,14,1,&joseki_variations[2162],NULL},
  {836,3,18,1,&joseki_variations[2163],NULL},
  {763,0,11,1,&joseki_variations[2164],NULL},
  {800,3,16,1,&joseki_variations[2165],NULL},
  {837,3,21,1,&joseki_variations[2166],NULL},
  {801,0,17,1,&joseki_variations[2167],NULL},
  {688,3,2,0,NULL,&joseki[536]},
  {761,3,7,2,&joseki_variations[2169],NULL},
  {762,0,8,1,&joseki_variations[2206],NULL},
  {725,3,5,1,&joseki_variations[2171],NULL},
  {762,0,9,2,&joseki_variations[2172],NULL},
  {763,0,10,1,&joseki_variations[2190],NULL},
  {726,0,6,1,&joseki_variations[2174],NULL},
  {763,0,11,1,&joseki_variations[2175],NULL},
  {795,0,2,1,&joseki_variations[2176],NULL},
  {797,0,7,1,&joseki_variations[2177],NULL},
  {798,3,10,1,&joseki_variations[2178],NULL},
  {799,0,13,1,&joseki_variations[2179],NULL},
  {800,3,16,1,&joseki_variations[2180],NULL},
  {801,0,17,1,&joseki_variations[2181],NULL},
  {833,0,5,1,&joseki_variations[2182],NULL},
  {834,0,9,1,&joseki_variations[2183],NULL},
  {835,0,13,1,&joseki_variations[2184],NULL},
  {836,3,17,1,&joseki_variations[2185],NULL},
  {837,3,21,1,&joseki_variations[2186],NULL},
  {870,3,6,1,&joseki_variations[2187],NULL},
  {871,3,11,1,&joseki_variations[2188],NULL},
  {872,3,16,1,&joseki_variations[2189],NULL},
  {687,3,1,0,NULL,&joseki[555]},
  {795,0,2,1,&joseki_variations[2191],NULL},
  {797,0,7,1,&joseki_variations[2192],NULL},
  {798,3,10,1,&joseki_variations[2193],NULL},
  {799,0,13,1,&joseki_variations[2194],NULL},
  {800,3,15,1,&joseki_variations[2195],NULL},
  {801,0,16,1,&joseki_variations[2196],NULL},
  {833,0,5,1,&joseki_variations[2197],NULL},
  {834,0,9,1,&joseki_variations[2198],NULL},
  {835,0,13,1,&joseki_variations[2199],NULL},
  {836,3,17,1,&joseki_variations[2200],NULL},
  {837,3,20,1,&joseki_variations[2201],NULL},
  {870,3,6,1,&joseki_variations[2202],NULL},
  {871,3,11,1,&joseki_variations[2203],NULL},
  {872,3,16,2,&joseki_variations[2204],NULL},
  {687,0,1,0,NULL,&joseki[535]},
  {726,0,6,0,NULL,&joseki[554]},
  {763,0,9,1,&joseki_variations[2207],NULL},
  {795,0,2,1,&joseki_variations[2208],NULL},
  {797,0,7,1,&joseki_variations[2209],NULL},
  {798,3,10,1,&joseki_variations[2210],NULL},
  {799,0,12,1,&joseki_variations[2211],NULL},
  {800,3,14,1,&joseki_variations[2212],NULL},
  {801,0,15,1,&joseki_variations[2213],NULL},
  {833,0,5,1,&joseki_variations[2214],NULL},
  {834,0,9,1,&joseki_variations[2215],NULL},
  {835,0,13,1,&joseki_variations[2216],NULL},
  {836,3,16,1,&joseki_variations[2217],NULL},
  {837,3,19,1,&joseki_variations[2218],NULL},
  {870,3,6,1,&joseki_variations[2219],NULL},
  {871,3,11,1,&joseki_variations[2220],NULL},
  {872,3,16,1,&joseki_variations[2221],NULL},
  {725,3,5,0,NULL,&joseki[534]},
  {870,3,5,1,&joseki_variations[2223],NULL},
  {723,0,3,1,&joseki_variations[2224],NULL},
  {760,3,5,1,&joseki_variations[2225],NULL},
  {834,0,7,1,&joseki_variations[2226],NULL},
  {871,3,9,1,&joseki_variations[2227],NULL},
  {724,3,4,1,&joseki_variations[2228],NULL},
  {761,3,7,1,&joseki_variations[2229],NULL},
  {798,3,9,1,&joseki_variations[2230],NULL},
  {835,0,11,1,&joseki_variations[2231],NULL},
  {872,3,14,1,&joseki_variations[2232],NULL},
  {688,3,1,1,&joseki_variations[2233],NULL},
  {725,0,6,1,&joseki_variations[2234],NULL},
  {762,0,10,1,&joseki_variations[2235],NULL},
  {799,0,13,1,&joseki_variations[2236],NULL},
  {836,3,16,1,&joseki_variations[2237],NULL},
  {726,0,7,1,&joseki_variations[2238],NULL},
  {763,0,12,1,&joseki_variations[2239],NULL},
  {800,3,16,1,&joseki_variations[2240],NULL},
  {837,3,20,1,&joseki_variations[2241],NULL},
  {727,0,8,1,&joseki_variations[2242],NULL},
  {764,3,14,1,&joseki_variations[2243],NULL},
  {801,0,19,1,&joseki_variations[2244],NULL},
  {728,0,9,1,&joseki_variations[2245],NULL},
  {765,3,16,1,&joseki_variations[2246],NULL},
  {685,3,1,0,NULL,&joseki[490]},
  {759,0,3,3,&joseki_variations[2248],NULL},
  {761,3,5,1,&joseki_variations[2362],NULL},
  {833,0,4,1,&joseki_variations[2339],NULL},
  {760,3,4,1,&joseki_variations[2251],NULL},
  {761,3,6,3,&joseki_variations[2252],NULL},
  {798,3,7,1,&joseki_variations[2317],NULL},
  {796,3,4,1,&joseki_variations[2294],NULL},
  {688,3,1,1,&joseki_variations[2255],NULL},
  {725,0,5,1,&joseki_variations[2256],NULL},
  {762,0,9,1,&joseki_variations[2257],NULL},
  {726,0,6,1,&joseki_variations[2258],NULL},
  {763,0,11,1,&joseki_variations[2259],NULL},
  {727,0,7,1,&joseki_variations[2260],NULL},
  {764,3,13,1,&joseki_variations[2261],NULL},
  {728,0,8,1,&joseki_variations[2262],NULL},
  {765,3,15,1,&joseki_variations[2263],NULL},
  {795,0,2,1,&joseki_variations[2264],NULL},
  {796,3,5,2,&joseki_variations[2265],NULL},
  {798,3,9,1,&joseki_variations[2281],NULL},
  {797,3,7,1,&joseki_variations[2267],NULL},
  {798,3,10,1,&joseki_variations[2268],NULL},
  {799,0,14,1,&joseki_variations[2269],NULL},
  {800,3,17,1,&joseki_variations[2270],NULL},
  {801,0,20,1,&joseki_variations[2271],NULL},
  {832,0,3,1,&joseki_variations[2272],NULL},
  {833,0,7,1,&joseki_variations[2273],NULL},
  {834,0,10,1,&joseki_variations[2274],NULL},
  {835,0,14,1,&joseki_variations[2275],NULL},
  {836,3,19,1,&joseki_variations[2276],NULL},
  {837,3,23,1,&joseki_variations[2277],NULL},
  {870,3,8,1,&joseki_variations[2278],NULL},
  {871,3,12,1,&joseki_variations[2279],NULL},
  {872,3,17,1,&joseki_variations[2280],NULL},
  {685,0,1,0,NULL,&joseki[503]},
  {799,0,13,1,&joseki_variations[2282],NULL},
  {800,3,16,1,&joseki_variations[2283],NULL},
  {801,0,19,1,&joseki_variations[2284],NULL},
  {832,0,3,1,&joseki_variations[2285],NULL},
  {833,0,7,1,&joseki_variations[2286],NULL},
  {834,0,9,1,&joseki_variations[2287],NULL},
  {835,0,13,1,&joseki_variations[2288],NULL},
  {836,3,18,1,&joseki_variations[2289],NULL},
  {837,3,22,1,&joseki_variations[2290],NULL},
  {870,3,8,1,&joseki_variations[2291],NULL},
  {871,3,11,1,&joseki_variations[2292],NULL},
  {872,3,16,1,&joseki_variations[2293],NULL},
  {797,3,7,0,NULL,&joseki[502]},
  {798,3,8,1,&joseki_variations[2295],NULL},
  {832,0,2,1,&joseki_variations[2296],NULL},
  {833,0,6,1,&joseki_variations[2297],NULL},
  {834,0,8,1,&joseki_variations[2298],NULL},
  {835,0,12,1,&joseki_variations[2299],NULL},
  {870,3,7,1,&joseki_variations[2300],NULL},
  {871,3,10,1,&joseki_variations[2301],NULL},
  {872,3,15,1,&joseki_variations[2302],NULL},
  {688,3,1,1,&joseki_variations[2303],NULL},
  {725,0,5,1,&joseki_variations[2304],NULL},
  {762,0,9,1,&joseki_variations[2305],NULL},
  {799,0,12,1,&joseki_variations[2306],NULL},
  {836,3,17,1,&joseki_variations[2307],NULL},
  {726,0,6,1,&joseki_variations[2308],NULL},
  {763,0,11,1,&joseki_variations[2309],NULL},
  {800,3,15,1,&joseki_variations[2310],NULL},
  {837,3,21,1,&joseki_variations[2311],NULL},
  {727,0,7,1,&joseki_variations[2312],NULL},
  {764,3,13,1,&joseki_variations[2313],NULL},
  {801,0,18,1,&joseki_variations[2314],NULL},
  {728,0,8,1,&joseki_variations[2315],NULL},
  {765,3,15,1,&joseki_variations[2316],NULL},
  {795,0,2,0,NULL,&joseki[501]},
  {832,0,2,1,&joseki_variations[2318],NULL},
  {833,0,5,1,&joseki_variations[2319],NULL},
  {834,0,7,1,&joseki_variations[2320],NULL},
  {835,0,11,1,&joseki_variations[2321],NULL},
  {870,3,6,1,&joseki_variations[2322],NULL},
  {871,3,9,1,&joseki_variations[2323],NULL},
  {872,3,14,1,&joseki_variations[2324],NULL},
  {688,3,1,1,&joseki_variations[2325],NULL},
  {725,0,5,1,&joseki_variations[2326],NULL},
  {762,0,9,1,&joseki_variations[2327],NULL},
  {799,0,11,1,&joseki_variations[2328],NULL},
  {836,3,16,1,&joseki_variations[2329],NULL},
  {726,0,6,1,&joseki_variations[2330],NULL},
  {763,0,11,1,&joseki_variations[2331],NULL},
  {800,3,14,1,&joseki_variations[2332],NULL},
  {837,3,20,1,&joseki_variations[2333],NULL},
  {727,0,7,1,&joseki_variations[2334],NULL},
  {764,3,13,1,&joseki_variations[2335],NULL},
  {801,0,17,1,&joseki_variations[2336],NULL},
  {728,0,8,1,&joseki_variations[2337],NULL},
  {765,3,15,1,&joseki_variations[2338],NULL},
  {796,3,4,0,NULL,&joseki[500]},
  {870,3,5,1,&joseki_variations[2340],NULL},
  {760,3,4,1,&joseki_variations[2341],NULL},
  {834,0,6,1,&joseki_variations[2342],NULL},
  {871,3,8,1,&joseki_variations[2343],NULL},
  {761,3,6,1,&joseki_variations[2344],NULL},
  {798,3,7,1,&joseki_variations[2345],NULL},
  {835,0,10,1,&joseki_variations[2346],NULL},
  {872,3,13,1,&joseki_variations[2347],NULL},
  {688,3,1,1,&joseki_variations[2348],NULL},
  {725,0,5,1,&joseki_variations[2349],NULL},
  {762,0,9,1,&joseki_variations[2350],NULL},
  {799,0,11,1,&joseki_variations[2351],NULL},
  {836,3,15,1,&joseki_variations[2352],NULL},
  {726,0,6,1,&joseki_variations[2353],NULL},
  {763,0,11,1,&joseki_variations[2354],NULL},
  {800,3,14,1,&joseki_variations[2355],NULL},
  {837,3,19,1,&joseki_variations[2356],NULL},
  {727,0,7,1,&joseki_variations[2357],NULL},
  {764,3,13,1,&joseki_variations[2358],NULL},
  {801,0,17,1,&joseki_variations[2359],NULL},
  {728,0,8,1,&joseki_variations[2360],NULL},
  {765,3,15,1,&joseki_variations[2361],NULL},
  {832,0,2,0,NULL,&joseki[499]},
  {798,3,6,2,&joseki_variations[2363],NULL},
  {762,0,6,1,&joseki_variations[2385],NULL},
  {833,0,4,1,&joseki_variations[2365],NULL},
  {834,0,5,1,&joseki_variations[2366],NULL},
  {835,0,9,1,&joseki_variations[2367],NULL},
  {870,3,5,1,&joseki_variations[2368],NULL},
  {871,3,7,1,&joseki_variations[2369],NULL},
  {872,3,12,1,&joseki_variations[2370],NULL},
  {688,3,1,1,&joseki_variations[2371],NULL},
  {725,0,5,1,&joseki_variations[2372],NULL},
  {762,0,8,1,&joseki_variations[2373],NULL},
  {799,0,10,1,&joseki_variations[2374],NULL},
  {836,3,14,1,&joseki_variations[2375],NULL},
  {726,0,6,1,&joseki_variations[2376],NULL},
  {763,0,10,1,&joseki_variations[2377],NULL},
  {800,3,13,1,&joseki_variations[2378],NULL},
  {837,3,18,1,&joseki_variations[2379],NULL},
  {727,0,7,1,&joseki_variations[2380],NULL},
  {764,3,12,1,&joseki_variations[2381],NULL},
  {801,0,16,1,&joseki_variations[2382],NULL},
  {728,0,8,1,&joseki_variations[2383],NULL},
  {765,3,14,1,&joseki_variations[2384],NULL},
  {760,3,4,0,NULL,&joseki[498]},
  {799,0,8,1,&joseki_variations[2386],NULL},
  {763,0,7,1,&joseki_variations[2387],NULL},
  {800,3,10,1,&joseki_variations[2388],NULL},
  {764,0,8,1,&joseki_variations[2389],NULL},
  {801,0,12,1,&joseki_variations[2390],NULL},
  {833,0,4,1,&joseki_variations[2391],NULL},
  {834,0,5,1,&joseki_variations[2392],NULL},
  {835,0,9,1,&joseki_variations[2393],NULL},
  {836,3,12,1,&joseki_variations[2394],NULL},
  {837,3,15,1,&joseki_variations[2395],NULL},
  {870,3,5,1,&joseki_variations[2396],NULL},
  {871,3,7,1,&joseki_variations[2397],NULL},
  {872,3,12,1,&joseki_variations[2398],NULL},
  {685,3,1,0,NULL,&joseki[392]},
  {758,3,2,1,&joseki_variations[2400],NULL},
  {759,0,4,1,&joseki_variations[2401],NULL},
  {760,0,5,1,&joseki_variations[2402],NULL},
  {761,0,7,1,&joseki_variations[2403],NULL},
  {762,3,8,1,&joseki_variations[2404],NULL},
  {763,3,9,1,&joseki_variations[2405],NULL},
  {764,3,10,1,&joseki_variations[2406],NULL},
  {795,3,3,1,&joseki_variations[2407],NULL},
  {796,3,6,1,&joseki_variations[2408],NULL},
  {797,0,8,1,&joseki_variations[2409],NULL},
  {798,0,11,1,&joseki_variations[2410],NULL},
  {799,3,13,1,&joseki_variations[2411],NULL},
  {800,0,15,1,&joseki_variations[2412],NULL},
  {801,3,17,1,&joseki_variations[2413],NULL},
  {833,3,7,1,&joseki_variations[2414],NULL},
  {834,3,10,1,&joseki_variations[2415],NULL},
  {835,3,14,1,&joseki_variations[2416],NULL},
  {836,0,17,1,&joseki_variations[2417],NULL},
  {837,0,20,1,&joseki_variations[2418],NULL},
  {870,0,8,1,&joseki_variations[2419],NULL},
  {871,0,12,1,&joseki_variations[2420],NULL},
  {872,0,17,1,&joseki_variations[2421],NULL},
  {684,3,1,0,NULL,&joseki[375]},
  {763,3,2,2,&joseki_variations[2423],NULL},
  {764,0,3,1,&joseki_variations[2443],NULL},
  {797,3,1,1,&joseki_variations[2425],NULL},
  {798,0,2,1,&joseki_variations[2426],NULL},
  {800,0,5,1,&joseki_variations[2427],NULL},
  {801,3,6,1,&joseki_variations[2428],NULL},
  {834,3,2,1,&joseki_variations[2429],NULL},
  {837,0,7,3,&joseki_variations[2430],NULL},
  {760,0,1,0,NULL,&joseki[616]},
  {1020,0,4,1,&joseki_variations[2442],NULL},
  {872,3,4,1,&joseki_variations[2433],NULL},
  {908,0,3,2,&joseki_variations[2434],NULL},
  {1020,0,6,1,&joseki_variations[2441],NULL},
  {873,3,6,1,&joseki_variations[2436],NULL},
  {909,0,6,1,&joseki_variations[2437],NULL},
  {1020,0,7,1,&joseki_variations[2438],NULL},
  {948,0,12,1,&joseki_variations[2439],&joseki[620]},
  {912,3,13,1,&joseki_variations[2440],NULL},
  {838,0,9,0,NULL,&joseki[621]},
  {909,0,6,0,NULL,&joseki[619]},
  {908,0,3,0,NULL,&joseki[618]},
  {765,0,4,1,&joseki_variations[2444],NULL},
  {797,3,1,1,&joseki_variations[2445],NULL},
  {871,3,2,1,&joseki_variations[2446],NULL},
  {798,0,2,1,&joseki_variations[2447],NULL},
  {800,0,5,1,&joseki_variations[2448],NULL},
  {801,3,7,1,&joseki_variations[2449],NULL},
  {760,3,1,0,NULL,&joseki[221]},
  {764,3,2,3,&joseki_variations[2533],NULL},
  {765,3,2,2,&joseki_variations[2526],NULL},
  {798,3,1,10,&joseki_variations[2467],NULL},
  {797,0,1,1,&joseki_variations[2462],NULL},
  {798,0,1,2,&joseki_variations[2455],NULL},
  {872,0,2,1,&joseki_variations[2459],NULL},
  {800,3,3,1,&joseki_variations[2457],NULL},
  {871,0,1,1,&joseki_variations[2458],NULL},
  {764,3,2,0,NULL,&joseki[934]},
  {800,3,3,1,&joseki_variations[2460],NULL},
  {804,3,4,1,&joseki_variations[2461],NULL},
  {764,3,2,0,NULL,&joseki[910]},
  {798,3,2,1,&joseki_variations[2463],NULL},
  {800,3,4,1,&joseki_variations[2464],NULL},
  {837,3,5,1,&joseki_variations[2465],NULL},
  {801,0,5,1,&joseki_variations[2466],NULL},
  {762,3,1,0,NULL,&joseki[615]},
  {872,3,2,3,&joseki_variations[2518],&joseki[253]},
  {804,3,3,3,&joseki_variations[2515],NULL},
  {800,3,3,1,&joseki_variations[2504],&joseki[344]},
  {799,0,2,1,&joseki_variations[2501],NULL},
  {871,3,1,1,&joseki_variations[2500],&joseki[699]},
  {837,3,3,1,&joseki_variations[2499],NULL},
  {871,0,1,3,&joseki_variations[2491],&joseki[758]},
  {872,0,2,2,&joseki_variations[2487],&joseki[779]},
  {1020,3,2,2,&joseki_variations[2481],NULL},
  {803,3,3,2,&joseki_variations[2477],&joseki[823]},
  {760,0,1,0,NULL,&joseki[824]},
  {837,0,3,1,&joseki_variations[2479],&joseki[833]},
  {872,3,2,1,&joseki_variations[2480],&joseki[834]},
  {724,0,1,0,NULL,&joseki[835]},
  {765,3,2,0,NULL,&joseki[803]},
  {803,3,3,1,&joseki_variations[2483],&joseki[806]},
  {837,0,3,2,&joseki_variations[2484],&joseki[807]},
  {872,3,2,0,NULL,&joseki[808]},
  {873,3,2,1,&joseki_variations[2486],NULL},
  {724,0,1,0,NULL,&joseki[820]},
  {836,3,2,1,&joseki_variations[2490],&joseki[780]},
  {800,3,3,1,&joseki_variations[2489],NULL},
  {801,0,4,0,NULL,&joseki[789]},
  {760,0,1,0,NULL,&joseki[781]},
  {836,3,2,1,&joseki_variations[2498],&joseki[759]},
  {872,3,3,1,&joseki_variations[2495],&joseki[770]},
  {767,3,2,1,&joseki_variations[2494],NULL},
  {872,3,3,0,NULL,&joseki[778]},
  {909,0,4,1,&joseki_variations[2496],&joseki[771]},
  {873,3,4,1,&joseki_variations[2497],&joseki[772]},
  {760,0,1,0,NULL,&joseki[773]},
  {760,0,1,0,NULL,&joseki[760]},
  {802,0,3,0,NULL,&joseki[757]},
  {724,0,1,0,NULL,&joseki[700]},
  {800,3,4,2,&joseki_variations[2502],NULL},
  {762,3,1,0,NULL,&joseki[672]},
  {836,3,3,0,NULL,&joseki[680]},
  {801,0,4,4,&joseki_variations[2505],&joseki[345]},
  {804,3,5,1,&joseki_variations[2514],NULL},
  {837,3,4,4,&joseki_variations[2509],&joseki[346]},
  {762,3,1,0,NULL,&joseki[622]},
  {764,3,2,0,NULL,&joseki[652]},
  {762,0,1,0,NULL,&joseki[347]},
  {761,0,1,0,NULL,&joseki[569]},
  {838,0,6,1,&joseki_variations[2513],NULL},
  {725,0,1,0,NULL,&joseki[607]},
  {762,3,1,0,NULL,&joseki[589]},
  {837,3,4,0,NULL,&joseki[343]},
  {800,3,3,0,NULL,&joseki[342]},
  {762,3,1,0,NULL,&joseki[840]},
  {765,3,2,0,NULL,&joseki[850]},
  {945,0,1,2,&joseki_variations[2524],&joseki[254]},
  {724,0,1,0,NULL,&joseki[257]},
  {1020,3,3,1,&joseki_variations[2521],NULL},
  {803,3,3,1,&joseki_variations[2522],NULL},
  {837,0,3,1,&joseki_variations[2523],NULL},
  {724,0,1,0,NULL,&joseki[809]},
  {874,3,4,0,NULL,&joseki[255]},
  {910,3,3,0,NULL,&joseki[256]},
  {871,0,1,1,&joseki_variations[2530],NULL},
  {798,3,1,1,&joseki_variations[2528],NULL},
  {1020,3,2,1,&joseki_variations[2529],NULL},
  {760,0,1,0,NULL,&joseki[804]},
  {798,3,1,1,&joseki_variations[2531],NULL},
  {800,3,3,1,&joseki_variations[2532],NULL},
  {760,0,1,0,NULL,&joseki[236]},
  {765,3,3,1,&joseki_variations[2552],NULL},
  {798,3,1,3,&joseki_variations[2542],NULL},
  {798,0,1,2,&joseki_variations[2536],NULL},
  {872,0,2,1,&joseki_variations[2540],NULL},
  {800,3,3,1,&joseki_variations[2538],NULL},
  {871,0,1,1,&joseki_variations[2539],NULL},
  {762,0,1,0,NULL,&joseki[935]},
  {800,3,3,1,&joseki_variations[2541],NULL},
  {762,0,1,0,NULL,&joseki[911]},
  {800,3,3,1,&joseki_variations[2550],NULL},
  {799,0,2,1,&joseki_variations[2546],NULL},
  {804,3,4,1,&joseki_variations[2545],NULL},
  {801,3,4,0,NULL,&joseki[863]},
  {800,3,4,1,&joseki_variations[2547],NULL},
  {801,0,6,1,&joseki_variations[2548],NULL},
  {837,3,5,1,&joseki_variations[2549],&joseki[654]},
  {762,0,1,0,NULL,&joseki[655]},
  {801,0,5,1,&joseki_variations[2551],NULL},
  {799,0,2,0,NULL,&joseki[653]},
  {797,0,1,1,&joseki_variations[2553],NULL},
  {871,0,2,1,&joseki_variations[2554],NULL},
  {798,3,2,1,&joseki_variations[2555],NULL},
  {800,3,4,1,&joseki_variations[2556],NULL},
  {801,0,6,2,&joseki_variations[2557],NULL},
  {762,3,1,0,NULL,&joseki[220]},
  {760,3,1,0,NULL,&joseki[228]},
  {761,3,2,2,&joseki_variations[2935],NULL},
  {763,0,2,1,&joseki_variations[2911],NULL},
  {761,0,2,4,&joseki_variations[2775],NULL},
  {759,3,1,2,&joseki_variations[2696],NULL},
  {759,0,1,4,&joseki_variations[2598],NULL},
  {798,0,2,1,&joseki_variations[2579],NULL},
  {798,3,2,2,&joseki_variations[2566],NULL},
  {725,0,2,1,&joseki_variations[2570],NULL},
  {871,3,1,2,&joseki_variations[2568],NULL},
  {762,3,2,0,NULL,&joseki[977]},
  {760,3,1,0,NULL,&joseki[978]},
  {762,3,3,2,&joseki_variations[2571],NULL},
  {763,0,4,1,&joseki_variations[2577],NULL},
  {726,0,3,1,&joseki_variations[2573],NULL},
  {763,0,5,1,&joseki_variations[2574],NULL},
  {800,3,7,1,&joseki_variations[2575],NULL},
  {764,3,6,1,&joseki_variations[2576],NULL},
  {801,3,9,0,NULL,&joseki[670]},
  {800,3,6,1,&joseki_variations[2578],NULL},
  {764,3,5,0,NULL,&joseki[669]},
  {725,3,2,2,&joseki_variations[2580],NULL},
  {763,3,3,1,&joseki_variations[2594],NULL},
  {762,0,3,1,&joseki_variations[2582],NULL},
  {799,0,5,1,&joseki_variations[2583],NULL},
  {726,3,3,1,&joseki_variations[2584],NULL},
  {763,3,5,1,&joseki_variations[2585],NULL},
  {800,0,8,1,&joseki_variations[2586],NULL},
  {837,3,9,1,&joseki_variations[2587],NULL},
  {874,0,10,1,&joseki_variations[2588],NULL},
  {801,3,9,1,&joseki_variations[2589],NULL},
  {838,0,11,1,&joseki_variations[2590],NULL},
  {875,0,13,1,&joseki_variations[2591],NULL},
  {802,3,10,1,&joseki_variations[2592],NULL},
  {839,3,13,1,&joseki_variations[2593],NULL},
  {760,3,1,0,NULL,&joseki[650]},
  {800,0,5,1,&joseki_variations[2595],NULL},
  {837,0,6,1,&joseki_variations[2596],NULL},
  {801,3,6,1,&joseki_variations[2597],NULL},
  {761,3,2,0,NULL,&joseki[613]},
  {760,3,2,1,&joseki_variations[2658],NULL},
  {797,3,2,1,&joseki_variations[2630],NULL},
  {761,0,3,1,&joseki_variations[2614],NULL},
  {725,3,2,1,&joseki_variations[2602],NULL},
  {760,0,2,1,&joseki_variations[2603],NULL},
  {762,3,5,1,&joseki_variations[2604],NULL},
  {763,0,6,1,&joseki_variations[2605],NULL},
  {796,3,2,1,&joseki_variations[2606],NULL},
  {797,0,4,1,&joseki_variations[2607],NULL},
  {798,3,6,1,&joseki_variations[2608],NULL},
  {799,3,9,1,&joseki_variations[2609],NULL},
  {800,3,11,1,&joseki_variations[2610],NULL},
  {834,3,5,1,&joseki_variations[2611],NULL},
  {837,0,13,1,&joseki_variations[2612],NULL},
  {872,3,8,1,&joseki_variations[2613],NULL},
  {833,3,3,0,NULL,&joseki[641]},
  {762,3,4,1,&joseki_variations[2615],NULL},
  {763,3,5,1,&joseki_variations[2616],NULL},
  {764,3,6,1,&joseki_variations[2617],NULL},
  {796,3,2,1,&joseki_variations[2618],NULL},
  {797,3,3,1,&joseki_variations[2619],NULL},
  {798,0,6,1,&joseki_variations[2620],NULL},
  {799,3,8,1,&joseki_variations[2621],NULL},
  {800,0,10,1,&joseki_variations[2622],NULL},
  {801,3,12,1,&joseki_variations[2623],NULL},
  {834,3,4,1,&joseki_variations[2624],NULL},
  {835,3,8,1,&joseki_variations[2625],NULL},
  {836,0,11,1,&joseki_variations[2626],NULL},
  {837,0,14,1,&joseki_variations[2627],NULL},
  {871,0,5,1,&joseki_variations[2628],NULL},
  {872,0,10,1,&joseki_variations[2629],NULL},
  {722,0,1,0,NULL,&joseki[456]},
  {834,3,3,1,&joseki_variations[2631],NULL},
  {871,0,4,1,&joseki_variations[2632],NULL},
  {761,0,3,1,&joseki_variations[2633],NULL},
  {798,0,5,1,&joseki_variations[2634],NULL},
  {835,3,7,1,&joseki_variations[2635],NULL},
  {872,0,9,2,&joseki_variations[2636],NULL},
  {762,3,4,1,&joseki_variations[2650],NULL},
  {725,3,2,1,&joseki_variations[2638],NULL},
  {762,3,5,1,&joseki_variations[2639],NULL},
  {799,3,8,1,&joseki_variations[2640],NULL},
  {836,0,11,1,&joseki_variations[2641],NULL},
  {763,3,6,1,&joseki_variations[2642],NULL},
  {800,0,10,1,&joseki_variations[2643],NULL},
  {837,0,14,1,&joseki_variations[2644],NULL},
  {727,3,3,1,&joseki_variations[2645],NULL},
  {764,0,8,1,&joseki_variations[2646],NULL},
  {801,3,13,1,&joseki_variations[2647],NULL},
  {728,3,4,1,&joseki_variations[2648],NULL},
  {765,0,10,1,&joseki_variations[2649],NULL},
  {760,3,2,0,NULL,&joseki[509]},
  {799,3,7,1,&joseki_variations[2651],NULL},
  {836,0,10,1,&joseki_variations[2652],NULL},
  {763,3,5,1,&joseki_variations[2653],NULL},
  {800,0,9,1,&joseki_variations[2654],NULL},
  {837,0,13,1,&joseki_variations[2655],NULL},
  {764,3,6,1,&joseki_variations[2656],NULL},
  {801,3,11,1,&joseki_variations[2657],NULL},
  {796,3,2,0,NULL,&joseki[455]},
  {761,0,4,2,&joseki_variations[2659],NULL},
  {762,3,5,1,&joseki_variations[2679],NULL},
  {797,3,3,1,&joseki_variations[2661],NULL},
  {798,0,6,1,&joseki_variations[2662],NULL},
  {834,3,4,1,&joseki_variations[2663],NULL},
  {835,3,8,1,&joseki_variations[2664],NULL},
  {871,0,5,1,&joseki_variations[2665],NULL},
  {872,0,10,1,&joseki_variations[2666],NULL},
  {725,3,2,1,&joseki_variations[2667],NULL},
  {762,3,6,1,&joseki_variations[2668],NULL},
  {799,3,9,1,&joseki_variations[2669],NULL},
  {836,0,12,1,&joseki_variations[2670],NULL},
  {763,3,7,1,&joseki_variations[2671],NULL},
  {800,0,11,1,&joseki_variations[2672],NULL},
  {837,0,15,1,&joseki_variations[2673],NULL},
  {727,3,3,1,&joseki_variations[2674],NULL},
  {764,0,9,1,&joseki_variations[2675],NULL},
  {801,3,14,1,&joseki_variations[2676],NULL},
  {728,3,4,1,&joseki_variations[2677],NULL},
  {765,0,11,1,&joseki_variations[2678],NULL},
  {723,0,1,0,NULL,&joseki[510]},
  {763,3,6,1,&joseki_variations[2680],NULL},
  {764,3,7,1,&joseki_variations[2681],NULL},
  {796,3,2,1,&joseki_variations[2682],NULL},
  {797,0,4,1,&joseki_variations[2683],NULL},
  {798,0,7,1,&joseki_variations[2684],NULL},
  {799,3,9,1,&joseki_variations[2685],NULL},
  {800,0,11,1,&joseki_variations[2686],NULL},
  {801,3,13,1,&joseki_variations[2687],NULL},
  {833,3,3,1,&joseki_variations[2688],NULL},
  {834,3,6,1,&joseki_variations[2689],NULL},
  {835,3,10,1,&joseki_variations[2690],NULL},
  {836,0,13,1,&joseki_variations[2691],NULL},
  {837,0,16,1,&joseki_variations[2692],NULL},
  {870,0,4,1,&joseki_variations[2693],NULL},
  {871,0,8,1,&joseki_variations[2694],NULL},
  {872,0,13,1,&joseki_variations[2695],NULL},
  {722,3,1,0,NULL,&joseki[452]},
  {761,0,3,1,&joseki_variations[2738],NULL},
  {760,3,2,1,&joseki_variations[2698],NULL},
  {797,0,3,1,&joseki_variations[2699],NULL},
  {834,0,4,1,&joseki_variations[2700],NULL},
  {761,0,4,1,&joseki_variations[2701],NULL},
  {798,3,6,1,&joseki_variations[2702],NULL},
  {835,3,8,3,&joseki_variations[2703],NULL},
  {872,0,9,2,&joseki_variations[2728],NULL},
  {871,3,5,1,&joseki_variations[2710],NULL},
  {871,0,5,1,&joseki_variations[2706],NULL},
  {872,3,10,1,&joseki_variations[2707],NULL},
  {909,0,11,1,&joseki_variations[2708],NULL},
  {762,3,5,1,&joseki_variations[2709],NULL},
  {723,0,1,0,NULL,&joseki[1170]},
  {872,0,10,1,&joseki_variations[2711],NULL},
  {725,0,2,2,&joseki_variations[2712],NULL},
  {762,3,6,1,&joseki_variations[2725],NULL},
  {799,0,8,1,&joseki_variations[2714],NULL},
  {763,0,6,2,&joseki_variations[2715],NULL},
  {800,3,10,1,&joseki_variations[2721],NULL},
  {801,0,10,1,&joseki_variations[2717],NULL},
  {836,3,11,1,&joseki_variations[2718],NULL},
  {873,3,14,1,&joseki_variations[2719],NULL},
  {837,0,13,1,&joseki_variations[2720],NULL},
  {909,3,11,0,NULL,&joseki[1162]},
  {836,3,11,1,&joseki_variations[2722],&joseki[1158]},
  {837,0,14,1,&joseki_variations[2723],&joseki[1159]},
  {873,3,14,1,&joseki_variations[2724],&joseki[1160]},
  {801,0,11,0,NULL,&joseki[1161]},
  {763,0,7,1,&joseki_variations[2726],NULL},
  {800,3,10,1,&joseki_variations[2727],NULL},
  {799,0,9,0,NULL,&joseki[1157]},
  {762,3,5,1,&joseki_variations[2737],NULL},
  {725,0,2,1,&joseki_variations[2730],NULL},
  {762,3,6,2,&joseki_variations[2731],NULL},
  {800,3,9,2,&joseki_variations[2735],&joseki[1154]},
  {763,0,7,1,&joseki_variations[2733],NULL},
  {800,3,10,1,&joseki_variations[2734],NULL},
  {871,3,5,0,NULL,&joseki[1156]},
  {763,0,7,0,NULL,&joseki[1155]},
  {796,0,2,0,NULL,&joseki[1163]},
  {725,0,2,0,NULL,&joseki[1153]},
  {798,0,4,2,&joseki_variations[2739],NULL},
  {762,3,4,1,&joseki_variations[2761],NULL},
  {833,3,2,1,&joseki_variations[2741],NULL},
  {834,3,3,1,&joseki_variations[2742],NULL},
  {835,3,7,1,&joseki_variations[2743],NULL},
  {870,0,3,1,&joseki_variations[2744],NULL},
  {871,0,5,1,&joseki_variations[2745],NULL},
  {872,0,10,1,&joseki_variations[2746],NULL},
  {688,0,1,1,&joseki_variations[2747],NULL},
  {725,3,3,1,&joseki_variations[2748],NULL},
  {762,3,6,1,&joseki_variations[2749],NULL},
  {799,3,8,1,&joseki_variations[2750],NULL},
  {836,0,12,1,&joseki_variations[2751],NULL},
  {726,3,4,1,&joseki_variations[2752],NULL},
  {763,3,8,1,&joseki_variations[2753],NULL},
  {800,0,11,1,&joseki_variations[2754],NULL},
  {837,0,16,1,&joseki_variations[2755],NULL},
  {727,3,5,1,&joseki_variations[2756],NULL},
  {764,0,10,1,&joseki_variations[2757],NULL},
  {801,3,14,1,&joseki_variations[2758],NULL},
  {728,3,6,1,&joseki_variations[2759],NULL},
  {765,0,12,1,&joseki_variations[2760],NULL},
  {722,0,1,0,NULL,&joseki[496]},
  {799,3,6,1,&joseki_variations[2762],NULL},
  {763,3,5,1,&joseki_variations[2763],NULL},
  {800,0,8,1,&joseki_variations[2764],NULL},
  {764,3,6,1,&joseki_variations[2765],NULL},
  {801,3,10,1,&joseki_variations[2766],NULL},
  {833,3,2,1,&joseki_variations[2767],NULL},
  {834,3,3,1,&joseki_variations[2768],NULL},
  {835,3,7,1,&joseki_variations[2769],NULL},
  {836,0,10,1,&joseki_variations[2770],NULL},
  {837,0,13,1,&joseki_variations[2771],NULL},
  {870,0,3,1,&joseki_variations[2772],NULL},
  {871,0,5,1,&joseki_variations[2773],NULL},
  {872,0,10,1,&joseki_variations[2774],NULL},
  {722,0,1,0,NULL,&joseki[390]},
  {798,0,3,2,&joseki_variations[2831],NULL},
  {762,3,3,1,&joseki_variations[2817],NULL},
  {797,3,1,1,&joseki_variations[2799],NULL},
  {798,3,3,2,&joseki_variations[2779],NULL},
  {725,0,2,1,&joseki_variations[2789],NULL},
  {872,3,4,1,&joseki_variations[2781],NULL},
  {725,3,2,1,&joseki_variations[2782],NULL},
  {762,3,4,1,&joseki_variations[2783],NULL},
  {799,0,6,2,&joseki_variations[2784],NULL},
  {801,0,7,1,&joseki_variations[2788],NULL},
  {727,3,3,1,&joseki_variations[2786],NULL},
  {801,0,8,1,&joseki_variations[2787],NULL},
  {797,0,1,0,NULL,&joseki[1050]},
  {727,3,3,0,NULL,&joseki[1049]},
  {762,3,4,2,&joseki_variations[2790],NULL},
  {764,3,5,1,&joseki_variations[2796],NULL},
  {799,3,6,1,&joseki_variations[2792],NULL},
  {726,3,3,1,&joseki_variations[2793],NULL},
  {764,3,6,1,&joseki_variations[2794],NULL},
  {804,3,9,1,&joseki_variations[2795],NULL},
  {797,0,1,0,NULL,&joseki[872]},
  {799,3,6,1,&joseki_variations[2797],NULL},
  {804,3,8,1,&joseki_variations[2798],NULL},
  {726,3,3,0,NULL,&joseki[871]},
  {798,0,4,1,&joseki_variations[2800],NULL},
  {834,3,2,1,&joseki_variations[2801],NULL},
  {835,3,6,1,&joseki_variations[2802],NULL},
  {871,0,3,1,&joseki_variations[2803],NULL},
  {872,0,8,1,&joseki_variations[2804],NULL},
  {725,3,2,1,&joseki_variations[2805],NULL},
  {762,3,4,1,&joseki_variations[2806],NULL},
  {799,3,7,1,&joseki_variations[2807],NULL},
  {836,0,10,1,&joseki_variations[2808],NULL},
  {763,3,5,1,&joseki_variations[2809],NULL},
  {800,0,9,1,&joseki_variations[2810],NULL},
  {837,0,13,1,&joseki_variations[2811],NULL},
  {727,3,3,1,&joseki_variations[2812],NULL},
  {764,0,7,1,&joseki_variations[2813],NULL},
  {801,3,12,1,&joseki_variations[2814],NULL},
  {728,3,4,1,&joseki_variations[2815],NULL},
  {765,0,9,1,&joseki_variations[2816],NULL},
  {759,0,1,0,NULL,&joseki[508]},
  {763,3,4,1,&joseki_variations[2818],NULL},
  {764,3,5,1,&joseki_variations[2819],NULL},
  {797,3,1,1,&joseki_variations[2820],NULL},
  {798,0,4,1,&joseki_variations[2821],NULL},
  {799,3,6,1,&joseki_variations[2822],NULL},
  {800,0,8,1,&joseki_variations[2823],NULL},
  {801,3,10,1,&joseki_variations[2824],NULL},
  {834,3,2,1,&joseki_variations[2825],NULL},
  {835,3,6,1,&joseki_variations[2826],NULL},
  {836,0,9,1,&joseki_variations[2827],NULL},
  {837,0,12,1,&joseki_variations[2828],NULL},
  {871,0,3,1,&joseki_variations[2829],NULL},
  {872,0,8,1,&joseki_variations[2830],NULL},
  {759,0,1,0,NULL,&joseki[454]},
  {762,3,3,1,&joseki_variations[2893],NULL},
  {833,3,1,1,&joseki_variations[2833],NULL},
  {834,3,2,1,&joseki_variations[2834],NULL},
  {835,3,6,2,&joseki_variations[2835],NULL},
  {871,0,3,1,&joseki_variations[2855],NULL},
  {870,0,2,1,&joseki_variations[2837],NULL},
  {871,0,4,1,&joseki_variations[2838],NULL},
  {872,0,9,1,&joseki_variations[2839],NULL},
  {688,0,1,1,&joseki_variations[2840],NULL},
  {725,3,3,1,&joseki_variations[2841],NULL},
  {762,3,5,1,&joseki_variations[2842],NULL},
  {799,3,7,1,&joseki_variations[2843],NULL},
  {836,0,11,1,&joseki_variations[2844],NULL},
  {726,3,4,1,&joseki_variations[2845],NULL},
  {763,3,7,1,&joseki_variations[2846],NULL},
  {800,0,10,1,&joseki_variations[2847],NULL},
  {837,0,15,1,&joseki_variations[2848],NULL},
  {727,3,5,1,&joseki_variations[2849],NULL},
  {764,0,9,1,&joseki_variations[2850],NULL},
  {801,3,13,1,&joseki_variations[2851],NULL},
  {728,3,6,1,&joseki_variations[2852],NULL},
  {765,0,11,2,&joseki_variations[2853],NULL},
  {759,3,1,0,NULL,&joseki[495]},
  {760,3,1,0,NULL,&joseki[505]},
  {872,0,8,2,&joseki_variations[2856],NULL},
  {725,3,2,1,&joseki_variations[2881],NULL},
  {688,0,1,1,&joseki_variations[2858],NULL},
  {725,3,3,1,&joseki_variations[2859],NULL},
  {762,3,5,1,&joseki_variations[2860],NULL},
  {799,3,7,1,&joseki_variations[2861],NULL},
  {836,0,11,2,&joseki_variations[2862],NULL},
  {763,3,6,1,&joseki_variations[2873],NULL},
  {726,3,4,1,&joseki_variations[2864],NULL},
  {763,3,7,1,&joseki_variations[2865],NULL},
  {800,0,10,1,&joseki_variations[2866],NULL},
  {837,0,15,1,&joseki_variations[2867],NULL},
  {727,3,5,1,&joseki_variations[2868],NULL},
  {764,0,9,1,&joseki_variations[2869],NULL},
  {801,3,13,1,&joseki_variations[2870],NULL},
  {728,3,6,1,&joseki_variations[2871],NULL},
  {765,0,11,1,&joseki_variations[2872],NULL},
  {870,0,2,0,NULL,&joseki[494]},
  {800,0,9,1,&joseki_variations[2874],NULL},
  {837,0,14,1,&joseki_variations[2875],NULL},
  {727,3,4,1,&joseki_variations[2876],NULL},
  {764,0,8,1,&joseki_variations[2877],NULL},
  {801,3,12,1,&joseki_variations[2878],NULL},
  {728,3,5,1,&joseki_variations[2879],NULL},
  {765,0,10,1,&joseki_variations[2880],NULL},
  {726,3,4,0,NULL,&joseki[493]},
  {762,3,4,1,&joseki_variations[2882],NULL},
  {799,3,6,1,&joseki_variations[2883],NULL},
  {836,0,10,1,&joseki_variations[2884],NULL},
  {763,3,5,1,&joseki_variations[2885],NULL},
  {800,0,8,1,&joseki_variations[2886],NULL},
  {837,0,13,1,&joseki_variations[2887],NULL},
  {727,3,3,1,&joseki_variations[2888],NULL},
  {764,0,7,1,&joseki_variations[2889],NULL},
  {801,3,11,1,&joseki_variations[2890],NULL},
  {728,3,4,1,&joseki_variations[2891],NULL},
  {765,0,9,1,&joseki_variations[2892],NULL},
  {688,0,1,0,NULL,&joseki[492]},
  {799,3,5,1,&joseki_variations[2894],NULL},
  {763,3,4,1,&joseki_variations[2895],NULL},
  {800,0,7,1,&joseki_variations[2896],NULL},
  {764,3,5,1,&joseki_variations[2897],NULL},
  {801,3,9,1,&joseki_variations[2898],NULL},
  {833,3,1,1,&joseki_variations[2899],NULL},
  {834,3,2,1,&joseki_variations[2900],NULL},
  {835,3,6,1,&joseki_variations[2901],NULL},
  {836,0,9,1,&joseki_variations[2902],NULL},
  {837,0,12,2,&joseki_variations[2903],NULL},
  {871,0,3,1,&joseki_variations[2909],NULL},
  {870,0,2,1,&joseki_variations[2905],NULL},
  {871,0,4,1,&joseki_variations[2906],NULL},
  {872,0,9,2,&joseki_variations[2907],NULL},
  {759,3,1,0,NULL,&joseki[389]},
  {760,3,1,0,NULL,&joseki[448]},
  {872,0,8,1,&joseki_variations[2910],NULL},
  {870,0,2,0,NULL,&joseki[388]},
  {798,3,2,4,&joseki_variations[2912],NULL},
  {872,3,3,5,&joseki_variations[2922],NULL},
  {800,3,4,1,&joseki_variations[2921],NULL},
  {871,3,1,1,&joseki_variations[2920],NULL},
  {1020,3,3,1,&joseki_variations[2916],NULL},
  {803,3,4,1,&joseki_variations[2917],NULL},
  {873,3,3,1,&joseki_variations[2918],NULL},
  {837,0,4,1,&joseki_variations[2919],NULL},
  {760,3,1,0,NULL,&joseki[821]},
  {760,3,1,0,NULL,&joseki[701]},
  {762,3,2,0,NULL,&joseki[668]},
  {760,0,1,0,NULL,&joseki[258]},
  {765,3,3,2,&joseki_variations[2932],&joseki[259]},
  {760,3,1,0,NULL,&joseki[278]},
  {1020,3,4,1,&joseki_variations[2929],NULL},
  {803,3,4,1,&joseki_variations[2927],NULL},
  {837,0,4,1,&joseki_variations[2928],NULL},
  {760,3,1,0,NULL,&joseki[836]},
  {803,3,4,1,&joseki_variations[2930],NULL},
  {837,0,4,1,&joseki_variations[2931],NULL},
  {760,3,1,0,NULL,&joseki[810]},
  {760,0,1,0,NULL,&joseki[260]},
  {837,0,4,1,&joseki_variations[2934],&joseki[276]},
  {760,3,1,0,NULL,&joseki[277]},
  {725,3,2,2,&joseki_variations[2946],NULL},
  {798,3,3,1,&joseki_variations[2937],NULL},
  {762,0,3,2,&joseki_variations[2938],NULL},
  {763,0,4,1,&joseki_variations[2942],NULL},
  {799,3,5,1,&joseki_variations[2940],&joseki[961]},
  {763,0,4,1,&joseki_variations[2941],NULL},
  {723,3,1,0,NULL,&joseki[962]},
  {800,3,6,1,&joseki_variations[2943],NULL},
  {837,3,7,1,&joseki_variations[2944],NULL},
  {801,0,7,1,&joseki_variations[2945],NULL},
  {723,3,1,0,NULL,&joseki[516]},
  {762,0,4,1,&joseki_variations[2953],NULL},
  {763,3,4,1,&joseki_variations[2948],NULL},
  {798,0,3,1,&joseki_variations[2949],NULL},
  {800,0,6,1,&joseki_variations[2950],NULL},
  {837,0,7,1,&joseki_variations[2951],NULL},
  {801,3,7,1,&joseki_variations[2952],NULL},
  {760,0,1,0,NULL,&joseki[614]},
  {799,0,5,2,&joseki_variations[2954],NULL},
  {836,0,6,1,&joseki_variations[2963],NULL},
  {835,0,3,2,&joseki_variations[2956],NULL},
  {726,0,3,1,&joseki_variations[2960],NULL},
  {689,3,1,1,&joseki_variations[2958],NULL},
  {763,3,6,1,&joseki_variations[2959],NULL},
  {760,0,1,0,NULL,&joseki[1569]},
  {763,3,6,1,&joseki_variations[2961],NULL},
  {727,3,4,1,&joseki_variations[2962],NULL},
  {689,3,1,0,NULL,&joseki[1568]},
  {763,3,5,1,&joseki_variations[2964],NULL},
  {723,3,1,0,NULL,&joseki[87]},
  {760,0,2,4,&joseki_variations[3446],NULL},
  {760,3,2,4,&joseki_variations[3070],NULL},
  {724,3,2,1,&joseki_variations[3042],NULL},
  {724,0,2,1,&joseki_variations[3032],NULL},
  {797,0,2,1,&joseki_variations[2970],NULL},
  {761,0,2,1,&joseki_variations[2971],NULL},
  {798,3,4,4,&joseki_variations[2972],NULL},
  {835,3,5,2,&joseki_variations[3015],NULL},
  {833,0,1,1,&joseki_variations[3005],NULL},
  {833,3,1,1,&joseki_variations[2993],NULL},
  {834,0,3,1,&joseki_variations[2976],NULL},
  {835,3,6,1,&joseki_variations[2977],NULL},
  {871,3,4,1,&joseki_variations[2978],NULL},
  {872,3,8,1,&joseki_variations[2979],NULL},
  {725,0,2,1,&joseki_variations[2980],NULL},
  {762,3,4,3,&joseki_variations[2981],NULL},
  {763,3,5,1,&joseki_variations[2992],&joseki[1096]},
  {726,0,3,1,&joseki_variations[2990],NULL},
  {983,0,9,2,&joseki_variations[2984],NULL},
  {763,3,5,1,&joseki_variations[2989],&joseki[1104]},
  {726,0,3,1,&joseki_variations[2986],NULL},
  {763,3,6,2,&joseki_variations[2987],NULL},
  {765,3,7,0,NULL,&joseki[1106]},
  {764,3,7,0,NULL,&joseki[1107]},
  {726,0,3,0,NULL,&joseki[1105]},
  {763,3,6,1,&joseki_variations[2991],NULL},
  {764,3,7,0,NULL,&joseki[1098]},
  {726,0,3,0,NULL,&joseki[1097]},
  {835,3,6,1,&joseki_variations[2994],NULL},
  {870,0,2,1,&joseki_variations[2995],NULL},
  {872,3,8,1,&joseki_variations[2996],NULL},
  {907,3,3,1,&joseki_variations[2997],NULL},
  {908,0,6,1,&joseki_variations[2998],NULL},
  {944,0,4,1,&joseki_variations[2999],NULL},
  {725,3,2,1,&joseki_variations[3000],NULL},
  {762,3,4,1,&joseki_variations[3001],NULL},
  {799,0,7,1,&joseki_variations[3002],NULL},
  {800,3,8,1,&joseki_variations[3003],NULL},
  {801,0,9,1,&joseki_variations[3004],NULL},
  {834,3,4,0,NULL,&joseki[1079]},
  {835,3,6,1,&joseki_variations[3006],NULL},
  {870,0,2,1,&joseki_variations[3007],NULL},
  {872,3,8,1,&joseki_variations[3008],NULL},
  {907,3,3,1,&joseki_variations[3009],NULL},
  {725,3,2,1,&joseki_variations[3010],NULL},
  {762,3,4,1,&joseki_variations[3011],NULL},
  {799,0,7,1,&joseki_variations[3012],NULL},
  {800,3,8,1,&joseki_variations[3013],NULL},
  {801,0,9,1,&joseki_variations[3014],NULL},
  {759,3,1,0,NULL,&joseki[1074]},
  {872,3,6,1,&joseki_variations[3027],NULL},
  {870,0,1,1,&joseki_variations[3017],NULL},
  {872,3,7,1,&joseki_variations[3018],NULL},
  {725,3,2,1,&joseki_variations[3019],NULL},
  {762,3,4,1,&joseki_variations[3020],NULL},
  {799,0,7,1,&joseki_variations[3021],NULL},
  {800,3,8,1,&joseki_variations[3022],NULL},
  {801,0,9,2,&joseki_variations[3023],NULL},
  {838,3,11,0,NULL,&joseki[1072]},
  {907,3,2,1,&joseki_variations[3025],&joseki[1073]},
  {908,0,5,1,&joseki_variations[3026],NULL},
  {833,3,1,0,NULL,&joseki[1078]},
  {725,3,2,1,&joseki_variations[3028],NULL},
  {762,3,4,1,&joseki_variations[3029],NULL},
  {799,0,7,1,&joseki_variations[3030],NULL},
  {801,0,8,1,&joseki_variations[3031],NULL},
  {800,3,8,0,NULL,&joseki[1071]},
  {761,3,3,1,&joseki_variations[3033],NULL},
  {798,3,4,2,&joseki_variations[3034],NULL},
  {762,0,4,1,&joseki_variations[3040],NULL},
  {725,0,3,1,&joseki_variations[3036],NULL},
  {762,0,5,1,&joseki_variations[3037],NULL},
  {799,3,7,1,&joseki_variations[3038],NULL},
  {763,3,6,1,&joseki_variations[3039],NULL},
  {800,3,9,0,NULL,&joseki[964]},
  {799,3,6,1,&joseki_variations[3041],NULL},
  {763,3,5,0,NULL,&joseki[963]},
  {761,0,3,1,&joseki_variations[3043],NULL},
  {798,0,4,1,&joseki_variations[3044],NULL},
  {762,3,4,1,&joseki_variations[3045],NULL},
  {763,3,5,2,&joseki_variations[3046],NULL},
  {800,0,7,1,&joseki_variations[3067],NULL},
  {799,3,6,1,&joseki_variations[3048],NULL},
  {800,0,8,2,&joseki_variations[3049],NULL},
  {837,0,9,1,&joseki_variations[3065],NULL},
  {801,3,9,3,&joseki_variations[3051],NULL},
  {836,0,7,1,&joseki_variations[3063],NULL},
  {835,3,5,1,&joseki_variations[3059],NULL},
  {834,3,2,1,&joseki_variations[3054],NULL},
  {835,3,6,1,&joseki_variations[3055],NULL},
  {836,0,9,1,&joseki_variations[3056],NULL},
  {837,0,12,1,&joseki_variations[3057],NULL},
  {872,0,7,1,&joseki_variations[3058],NULL},
  {796,0,1,0,NULL,&joseki[522]},
  {836,0,8,1,&joseki_variations[3060],NULL},
  {837,0,11,1,&joseki_variations[3061],NULL},
  {872,0,6,1,&joseki_variations[3062],&joseki[520]},
  {834,3,2,0,NULL,&joseki[521]},
  {837,0,10,1,&joseki_variations[3064],NULL},
  {835,3,5,0,NULL,&joseki[519]},
  {801,3,9,1,&joseki_variations[3066],NULL},
  {836,0,7,0,NULL,&joseki[518]},
  {837,0,8,1,&joseki_variations[3068],NULL},
  {801,3,8,1,&joseki_variations[3069],NULL},
  {799,3,6,0,NULL,&joseki[517]},
  {797,0,3,2,&joseki_variations[3382],NULL},
  {761,0,3,7,&joseki_variations[3245],NULL},
  {724,0,2,2,&joseki_variations[3090],NULL},
  {724,3,2,1,&joseki_variations[3074],NULL},
  {761,0,4,2,&joseki_variations[3075],NULL},
  {763,0,5,1,&joseki_variations[3085],NULL},
  {798,3,5,2,&joseki_variations[3077],NULL},
  {872,3,6,1,&joseki_variations[3082],NULL},
  {871,3,3,1,&joseki_variations[3079],NULL},
  {762,0,5,1,&joseki_variations[3080],NULL},
  {763,0,6,1,&joseki_variations[3081],NULL},
  {722,3,1,0,NULL,&joseki[747]},
  {762,0,5,1,&joseki_variations[3083],NULL},
  {763,0,6,1,&joseki_variations[3084],NULL},
  {722,3,1,0,NULL,&joseki[334]},
  {798,3,5,2,&joseki_variations[3086],NULL},
  {872,3,6,1,&joseki_variations[3089],NULL},
  {871,3,3,1,&joseki_variations[3088],NULL},
  {762,0,5,0,NULL,&joseki[746]},
  {762,0,5,0,NULL,&joseki[333]},
  {761,0,4,2,&joseki_variations[3119],NULL},
  {797,3,3,1,&joseki_variations[3092],NULL},
  {834,3,4,1,&joseki_variations[3093],NULL},
  {761,3,4,1,&joseki_variations[3094],NULL},
  {798,0,6,1,&joseki_variations[3095],NULL},
  {835,0,8,1,&joseki_variations[3096],NULL},
  {872,3,9,1,&joseki_variations[3097],NULL},
  {725,3,3,1,&joseki_variations[3098],NULL},
  {762,0,6,1,&joseki_variations[3099],NULL},
  {726,0,4,2,&joseki_variations[3100],NULL},
  {800,0,10,2,&joseki_variations[3109],NULL},
  {799,0,9,1,&joseki_variations[3102],NULL},
  {873,3,13,1,&joseki_variations[3103],NULL},
  {800,0,11,1,&joseki_variations[3104],NULL},
  {837,3,14,1,&joseki_variations[3105],NULL},
  {838,0,15,1,&joseki_variations[3106],NULL},
  {875,3,18,1,&joseki_variations[3107],NULL},
  {839,0,16,1,&joseki_variations[3108],NULL},
  {945,3,5,0,NULL,&joseki[1215]},
  {908,3,5,0,NULL,&joseki[1208]},
  {837,3,13,1,&joseki_variations[3111],&joseki[1209]},
  {838,0,14,2,&joseki_variations[3112],&joseki[1210]},
  {875,3,16,1,&joseki_variations[3117],&joseki[1211]},
  {839,0,15,1,&joseki_variations[3114],NULL},
  {873,3,12,1,&joseki_variations[3115],NULL},
  {875,3,17,1,&joseki_variations[3116],NULL},
  {799,0,9,0,NULL,&joseki[1214]},
  {839,0,15,1,&joseki_variations[3118],&joseki[1212]},
  {873,3,12,0,NULL,&joseki[1213]},
  {798,3,5,2,&joseki_variations[3191],NULL},
  {762,3,5,1,&joseki_variations[3121],NULL},
  {797,3,3,1,&joseki_variations[3122],NULL},
  {798,3,6,4,&joseki_variations[3123],NULL},
  {801,0,8,1,&joseki_variations[3189],NULL},
  {872,3,7,1,&joseki_variations[3162],NULL},
  {835,0,7,1,&joseki_variations[3151],NULL},
  {799,0,8,1,&joseki_variations[3127],NULL},
  {763,3,6,1,&joseki_variations[3128],NULL},
  {800,3,10,1,&joseki_variations[3129],NULL},
  {764,3,7,1,&joseki_variations[3130],NULL},
  {801,0,12,1,&joseki_variations[3131],NULL},
  {802,0,13,1,&joseki_variations[3132],NULL},
  {729,3,3,1,&joseki_variations[3133],NULL},
  {834,3,4,1,&joseki_variations[3134],NULL},
  {835,0,8,1,&joseki_variations[3135],NULL},
  {836,0,11,1,&joseki_variations[3136],NULL},
  {837,0,14,3,&joseki_variations[3137],NULL},
  {872,3,9,1,&joseki_variations[3150],NULL},
  {871,0,5,1,&joseki_variations[3148],NULL},
  {870,3,1,1,&joseki_variations[3140],NULL},
  {871,0,6,1,&joseki_variations[3141],NULL},
  {872,3,11,2,&joseki_variations[3142],NULL},
  {908,0,7,1,&joseki_variations[3147],&joseki[1033]},
  {907,3,2,1,&joseki_variations[3144],NULL},
  {908,0,8,1,&joseki_variations[3145],NULL},
  {945,0,9,1,&joseki_variations[3146],&joseki[1035]},
  {722,3,1,0,NULL,&joseki[1036]},
  {907,3,2,0,NULL,&joseki[1034]},
  {872,3,10,1,&joseki_variations[3149],NULL},
  {870,3,1,0,NULL,&joseki[1032]},
  {871,0,5,0,NULL,&joseki[1031]},
  {872,3,8,1,&joseki_variations[3152],NULL},
  {799,0,8,1,&joseki_variations[3153],NULL},
  {836,0,10,1,&joseki_variations[3154],NULL},
  {763,3,6,1,&joseki_variations[3155],NULL},
  {800,3,10,1,&joseki_variations[3156],NULL},
  {837,0,13,1,&joseki_variations[3157],NULL},
  {764,3,7,1,&joseki_variations[3158],NULL},
  {801,0,12,1,&joseki_variations[3159],NULL},
  {802,0,13,1,&joseki_variations[3160],NULL},
  {729,3,3,1,&joseki_variations[3161],NULL},
  {834,3,4,0,NULL,&joseki[1030]},
  {799,0,8,4,&joseki_variations[3163],NULL},
  {801,0,9,2,&joseki_variations[3186],NULL},
  {800,3,9,2,&joseki_variations[3178],NULL},
  {836,0,9,1,&joseki_variations[3170],NULL},
  {836,3,9,1,&joseki_variations[3167],NULL},
  {800,0,9,1,&joseki_variations[3168],NULL},
  {801,0,10,1,&joseki_variations[3169],NULL},
  {722,3,1,0,NULL,&joseki[1039]},
  {763,3,6,1,&joseki_variations[3171],NULL},
  {800,3,10,1,&joseki_variations[3172],NULL},
  {837,0,12,1,&joseki_variations[3173],NULL},
  {764,3,7,1,&joseki_variations[3174],NULL},
  {801,0,12,1,&joseki_variations[3175],NULL},
  {802,0,13,1,&joseki_variations[3176],&joseki[1027]},
  {729,3,3,1,&joseki_variations[3177],&joseki[1028]},
  {835,0,7,0,NULL,&joseki[1029]},
  {801,0,10,1,&joseki_variations[3184],NULL},
  {836,0,9,1,&joseki_variations[3180],NULL},
  {764,3,6,1,&joseki_variations[3181],NULL},
  {801,0,11,1,&joseki_variations[3182],NULL},
  {837,0,11,1,&joseki_variations[3183],&joseki[1025]},
  {763,3,6,0,NULL,&joseki[1026]},
  {836,0,9,1,&joseki_variations[3185],&joseki[1023]},
  {764,3,6,0,NULL,&joseki[1024]},
  {800,3,9,0,NULL,&joseki[1022]},
  {836,3,9,1,&joseki_variations[3188],&joseki[1037]},
  {800,0,9,0,NULL,&joseki[1038]},
  {872,3,7,1,&joseki_variations[3190],NULL},
  {799,0,8,0,NULL,&joseki[1021]},
  {872,3,6,3,&joseki_variations[3218],NULL},
  {871,3,3,3,&joseki_variations[3193],NULL},
  {762,3,5,1,&joseki_variations[3212],NULL},
  {725,0,3,1,&joseki_variations[3208],NULL},
  {725,3,3,1,&joseki_variations[3196],NULL},
  {762,3,6,2,&joseki_variations[3197],NULL},
  {763,0,7,1,&joseki_variations[3206],NULL},
  {799,0,8,1,&joseki_variations[3199],NULL},
  {726,3,4,1,&joseki_variations[3200],NULL},
  {763,0,8,1,&joseki_variations[3201],NULL},
  {800,0,11,2,&joseki_variations[3202],&joseki[728]},
  {764,3,9,1,&joseki_variations[3204],&joseki[729]},
  {797,0,3,0,NULL,&joseki[732]},
  {801,0,13,1,&joseki_variations[3205],&joseki[730]},
  {765,3,10,0,NULL,&joseki[731]},
  {799,0,8,1,&joseki_variations[3207],&joseki[726]},
  {726,3,4,0,NULL,&joseki[727]},
  {762,3,6,1,&joseki_variations[3209],NULL},
  {799,3,8,1,&joseki_variations[3210],NULL},
  {763,0,7,1,&joseki_variations[3211],NULL},
  {759,3,1,0,NULL,&joseki[723]},
  {763,0,6,3,&joseki_variations[3213],NULL},
  {799,3,7,1,&joseki_variations[3217],&joseki[721]},
  {725,3,3,0,NULL,&joseki[725]},
  {800,3,8,1,&joseki_variations[3216],&joseki[735]},
  {725,0,3,0,NULL,&joseki[736]},
  {725,0,3,0,NULL,&joseki[722]},
  {762,3,5,2,&joseki_variations[3237],NULL},
  {725,0,3,1,&joseki_variations[3233],NULL},
  {725,3,3,1,&joseki_variations[3221],NULL},
  {762,3,6,2,&joseki_variations[3222],NULL},
  {763,0,7,1,&joseki_variations[3231],NULL},
  {799,0,8,1,&joseki_variations[3224],NULL},
  {726,3,4,1,&joseki_variations[3225],NULL},
  {763,0,8,1,&joseki_variations[3226],NULL},
  {800,0,11,2,&joseki_variations[3227],&joseki[314]},
  {764,3,9,1,&joseki_variations[3229],&joseki[315]},
  {797,0,3,0,NULL,&joseki[318]},
  {801,0,13,1,&joseki_variations[3230],&joseki[316]},
  {765,3,10,0,NULL,&joseki[317]},
  {799,0,8,1,&joseki_variations[3232],&joseki[312]},
  {726,3,4,0,NULL,&joseki[313]},
  {762,3,6,1,&joseki_variations[3234],NULL},
  {799,3,8,1,&joseki_variations[3235],NULL},
  {763,0,7,1,&joseki_variations[3236],NULL},
  {759,3,1,0,NULL,&joseki[309]},
  {763,0,6,3,&joseki_variations[3240],NULL},
  {801,0,7,1,&joseki_variations[3239],NULL},
  {797,3,3,0,NULL,&joseki[1020]},
  {799,3,7,1,&joseki_variations[3244],&joseki[307]},
  {725,3,3,0,NULL,&joseki[311]},
  {800,3,8,1,&joseki_variations[3243],&joseki[321]},
  {725,0,3,0,NULL,&joseki[322]},
  {725,0,3,0,NULL,&joseki[308]},
  {763,0,4,3,&joseki_variations[3360],NULL},
  {798,3,4,5,&joseki_variations[3301],NULL},
  {763,3,4,1,&joseki_variations[3291],NULL},
  {797,3,3,5,&joseki_variations[3265],NULL},
  {800,0,4,2,&joseki_variations[3255],NULL},
  {871,3,3,1,&joseki_variations[3253],NULL},
  {835,3,4,1,&joseki_variations[3252],NULL},
  {797,3,3,0,NULL,&joseki[1557]},
  {945,0,4,1,&joseki_variations[3254],NULL},
  {797,3,3,0,NULL,&joseki[1493]},
  {835,3,4,1,&joseki_variations[3264],NULL},
  {834,3,3,3,&joseki_variations[3257],NULL},
  {798,3,4,0,NULL,&joseki[1431]},
  {767,0,4,1,&joseki_variations[3262],NULL},
  {982,3,4,1,&joseki_variations[3260],NULL},
  {1056,0,5,1,&joseki_variations[3261],NULL},
  {798,3,4,0,NULL,&joseki[1466]},
  {945,3,4,1,&joseki_variations[3263],NULL},
  {798,3,4,0,NULL,&joseki[1457]},
  {797,3,3,0,NULL,&joseki[1227]},
  {798,3,5,2,&joseki_variations[3284],NULL},
  {800,0,5,1,&joseki_variations[3281],NULL},
  {835,3,5,1,&joseki_variations[3277],NULL},
  {871,3,4,1,&joseki_variations[3274],NULL},
  {798,0,5,1,&joseki_variations[3270],NULL},
  {800,3,6,1,&joseki_variations[3271],NULL},
  {834,0,4,1,&joseki_variations[3272],NULL},
  {835,3,7,1,&joseki_variations[3273],NULL},
  {722,3,1,0,NULL,&joseki[1591]},
  {945,0,5,1,&joseki_variations[3275],NULL},
  {725,0,2,1,&joseki_variations[3276],&joseki[1494]},
  {873,3,7,0,NULL,&joseki[1495]},
  {725,0,2,2,&joseki_variations[3278],&joseki[1558]},
  {800,0,6,1,&joseki_variations[3280],&joseki[1560]},
  {982,3,4,0,NULL,&joseki[1559]},
  {982,3,4,0,NULL,&joseki[1229]},
  {835,3,5,2,&joseki_variations[3282],NULL},
  {725,0,2,0,NULL,&joseki[1228]},
  {722,0,1,0,NULL,&joseki[1230]},
  {801,0,6,1,&joseki_variations[3289],NULL},
  {872,3,6,1,&joseki_variations[3286],NULL},
  {762,0,4,1,&joseki_variations[3287],NULL},
  {801,0,7,1,&joseki_variations[3288],NULL},
  {722,3,1,0,NULL,&joseki[1015]},
  {872,3,6,1,&joseki_variations[3290],NULL},
  {762,0,4,0,NULL,&joseki[1014]},
  {797,3,3,1,&joseki_variations[3292],NULL},
  {798,0,5,2,&joseki_variations[3293],NULL},
  {836,0,6,1,&joseki_variations[3299],NULL},
  {835,3,6,1,&joseki_variations[3295],NULL},
  {836,0,7,1,&joseki_variations[3296],NULL},
  {872,3,7,1,&joseki_variations[3297],NULL},
  {800,0,7,1,&joseki_variations[3298],&joseki[786]},
  {722,3,1,0,NULL,&joseki[787]},
  {872,3,6,1,&joseki_variations[3300],NULL},
  {835,3,6,0,NULL,&joseki[785]},
  {872,3,5,2,&joseki_variations[3352],NULL},
  {835,3,5,1,&joseki_variations[3329],NULL},
  {871,3,3,1,&joseki_variations[3326],NULL},
  {800,0,5,1,&joseki_variations[3317],NULL},
  {834,3,3,1,&joseki_variations[3306],NULL},
  {762,0,4,1,&joseki_variations[3307],NULL},
  {800,0,6,4,&joseki_variations[3308],NULL},
  {759,3,1,0,NULL,&joseki[1433]},
  {759,0,1,0,NULL,&joseki[1435]},
  {767,0,5,1,&joseki_variations[3314],NULL},
  {982,3,4,1,&joseki_variations[3312],NULL},
  {1056,0,5,1,&joseki_variations[3313],NULL},
  {759,3,1,0,NULL,&joseki[1468]},
  {945,3,4,2,&joseki_variations[3315],NULL},
  {759,3,1,0,NULL,&joseki[1459]},
  {759,0,1,0,NULL,&joseki[1460]},
  {834,3,3,4,&joseki_variations[3318],NULL},
  {762,0,4,0,NULL,&joseki[1432]},
  {759,0,1,0,NULL,&joseki[1437]},
  {767,0,4,1,&joseki_variations[3324],NULL},
  {982,3,4,1,&joseki_variations[3322],NULL},
  {1056,0,5,1,&joseki_variations[3323],NULL},
  {762,0,4,0,NULL,&joseki[1467]},
  {945,3,4,1,&joseki_variations[3325],NULL},
  {762,0,4,0,NULL,&joseki[1458]},
  {762,3,4,1,&joseki_variations[3327],NULL},
  {763,0,5,1,&joseki_variations[3328],NULL},
  {724,0,2,0,NULL,&joseki[720]},
  {762,0,4,2,&joseki_variations[3330],NULL},
  {799,0,6,2,&joseki_variations[3339],NULL},
  {836,0,7,1,&joseki_variations[3332],NULL},
  {871,3,3,1,&joseki_variations[3333],NULL},
  {946,0,7,1,&joseki_variations[3334],NULL},
  {873,3,9,1,&joseki_variations[3335],NULL},
  {763,0,5,1,&joseki_variations[3336],NULL},
  {837,0,9,1,&joseki_variations[3337],NULL},
  {801,3,7,1,&joseki_variations[3338],NULL},
  {759,3,1,0,NULL,&joseki[1276]},
  {836,3,8,1,&joseki_variations[3347],NULL},
  {801,3,7,1,&joseki_variations[3341],NULL},
  {836,0,8,1,&joseki_variations[3342],NULL},
  {837,0,9,1,&joseki_variations[3343],NULL},
  {871,3,3,1,&joseki_variations[3344],NULL},
  {946,0,7,1,&joseki_variations[3345],NULL},
  {873,3,10,1,&joseki_variations[3346],NULL},
  {759,3,1,0,NULL,&joseki[1270]},
  {763,0,5,1,&joseki_variations[3348],NULL},
  {800,3,8,1,&joseki_variations[3349],NULL},
  {837,3,11,1,&joseki_variations[3350],NULL},
  {801,0,9,1,&joseki_variations[3351],NULL},
  {722,3,1,0,NULL,&joseki[684]},
  {762,3,4,2,&joseki_variations[3356],NULL},
  {801,0,5,2,&joseki_variations[3354],NULL},
  {797,3,3,0,NULL,&joseki[1013]},
  {762,3,4,0,NULL,&joseki[1018]},
  {763,0,5,1,&joseki_variations[3359],NULL},
  {801,0,6,1,&joseki_variations[3358],NULL},
  {724,0,2,0,NULL,&joseki[1019]},
  {724,0,2,0,NULL,&joseki[306]},
  {798,3,4,2,&joseki_variations[3371],NULL},
  {797,3,3,2,&joseki_variations[3364],NULL},
  {835,3,4,1,&joseki_variations[3363],NULL},
  {797,3,3,0,NULL,&joseki[1302]},
  {798,3,5,2,&joseki_variations[3367],NULL},
  {835,3,5,1,&joseki_variations[3366],NULL},
  {722,0,1,0,NULL,&joseki[1303]},
  {872,3,6,1,&joseki_variations[3370],NULL},
  {871,3,4,1,&joseki_variations[3369],NULL},
  {725,0,2,0,NULL,&joseki[713]},
  {725,0,2,0,NULL,&joseki[298]},
  {872,3,5,5,&joseki_variations[3377],NULL},
  {871,3,3,4,&joseki_variations[3373],NULL},
  {797,3,3,0,NULL,&joseki[712]},
  {762,3,4,0,NULL,&joseki[719]},
  {722,3,1,0,NULL,&joseki[737]},
  {724,3,2,0,NULL,&joseki[745]},
  {797,3,3,0,NULL,&joseki[297]},
  {759,3,1,0,NULL,&joseki[300]},
  {762,3,4,0,NULL,&joseki[305]},
  {722,3,1,0,NULL,&joseki[323]},
  {724,3,2,0,NULL,&joseki[332]},
  {724,0,2,2,&joseki_variations[3389],NULL},
  {834,0,4,1,&joseki_variations[3384],NULL},
  {761,0,3,1,&joseki_variations[3385],NULL},
  {798,3,5,1,&joseki_variations[3386],NULL},
  {800,3,6,1,&joseki_variations[3387],NULL},
  {835,3,7,1,&joseki_variations[3388],NULL},
  {759,3,1,0,NULL,&joseki[1581]},
  {761,3,4,1,&joseki_variations[3436],NULL},
  {761,0,4,1,&joseki_variations[3391],NULL},
  {798,3,6,4,&joseki_variations[3392],NULL},
  {872,3,7,1,&joseki_variations[3429],NULL},
  {835,3,7,2,&joseki_variations[3413],NULL},
  {871,3,4,1,&joseki_variations[3406],NULL},
  {833,0,1,1,&joseki_variations[3396],NULL},
  {835,3,8,1,&joseki_variations[3397],NULL},
  {870,3,2,1,&joseki_variations[3398],NULL},
  {872,3,10,1,&joseki_variations[3399],NULL},
  {725,3,3,1,&joseki_variations[3400],NULL},
  {762,3,6,1,&joseki_variations[3401],NULL},
  {799,0,9,1,&joseki_variations[3402],NULL},
  {800,0,10,1,&joseki_variations[3403],NULL},
  {727,3,4,1,&joseki_variations[3404],NULL},
  {801,0,12,1,&joseki_variations[3405],NULL},
  {759,3,1,0,NULL,&joseki[1057]},
  {725,3,3,1,&joseki_variations[3407],NULL},
  {762,3,6,1,&joseki_variations[3408],NULL},
  {799,0,9,1,&joseki_variations[3409],NULL},
  {726,3,4,1,&joseki_variations[3410],NULL},
  {763,0,8,1,&joseki_variations[3411],NULL},
  {800,0,12,1,&joseki_variations[3412],NULL},
  {835,3,7,0,NULL,&joseki[733]},
  {872,3,8,1,&joseki_variations[3422],NULL},
  {871,3,4,1,&joseki_variations[3415],NULL},
  {725,3,3,1,&joseki_variations[3416],NULL},
  {762,3,6,1,&joseki_variations[3417],NULL},
  {799,0,9,1,&joseki_variations[3418],NULL},
  {726,3,4,1,&joseki_variations[3419],NULL},
  {763,0,8,1,&joseki_variations[3420],NULL},
  {800,0,12,1,&joseki_variations[3421],NULL},
  {796,0,1,0,NULL,&joseki[734]},
  {725,3,3,1,&joseki_variations[3423],NULL},
  {762,3,6,1,&joseki_variations[3424],NULL},
  {799,0,9,1,&joseki_variations[3425],NULL},
  {726,3,4,1,&joseki_variations[3426],NULL},
  {763,0,8,1,&joseki_variations[3427],NULL},
  {800,0,12,1,&joseki_variations[3428],NULL},
  {796,0,1,0,NULL,&joseki[320]},
  {725,3,3,1,&joseki_variations[3430],NULL},
  {762,3,6,1,&joseki_variations[3431],NULL},
  {799,0,9,1,&joseki_variations[3432],NULL},
  {726,3,4,1,&joseki_variations[3433],NULL},
  {763,0,8,1,&joseki_variations[3434],NULL},
  {800,0,12,1,&joseki_variations[3435],NULL},
  {835,3,7,0,NULL,&joseki[319]},
  {798,0,6,1,&joseki_variations[3437],NULL},
  {725,3,3,2,&joseki_variations[3438],NULL},
  {762,0,6,1,&joseki_variations[3443],NULL},
  {799,3,8,1,&joseki_variations[3440],NULL},
  {763,3,6,1,&joseki_variations[3441],NULL},
  {800,3,10,1,&joseki_variations[3442],NULL},
  {759,0,1,0,NULL,&joseki[290]},
  {763,3,7,1,&joseki_variations[3444],NULL},
  {800,3,10,1,&joseki_variations[3445],NULL},
  {799,3,9,0,NULL,&joseki[289]},
  {834,0,3,1,&joseki_variations[3651],NULL},
  {797,0,3,5,&joseki_variations[3529],NULL},
  {724,0,2,1,&joseki_variations[3488],NULL},
  {761,3,3,1,&joseki_variations[3450],NULL},
  {798,0,4,3,&joseki_variations[3451],NULL},
  {872,0,5,1,&joseki_variations[3479],NULL},
  {871,0,3,1,&joseki_variations[3476],NULL},
  {835,0,5,2,&joseki_variations[3454],NULL},
  {872,0,6,2,&joseki_variations[3466],NULL},
  {946,3,6,1,&joseki_variations[3456],NULL},
  {762,3,4,1,&joseki_variations[3457],NULL},
  {836,3,7,1,&joseki_variations[3458],NULL},
  {873,0,8,1,&joseki_variations[3459],NULL},
  {763,3,5,1,&joseki_variations[3460],NULL},
  {837,3,9,1,&joseki_variations[3461],NULL},
  {874,0,11,1,&joseki_variations[3462],NULL},
  {801,0,7,1,&joseki_variations[3463],NULL},
  {838,3,11,1,&joseki_variations[3464],NULL},
  {803,3,8,1,&joseki_variations[3465],&joseki[1288]},
  {871,0,3,0,NULL,&joseki[1289]},
  {762,3,4,1,&joseki_variations[3472],NULL},
  {725,3,2,1,&joseki_variations[3468],NULL},
  {799,3,6,1,&joseki_variations[3469],NULL},
  {801,3,7,2,&joseki_variations[3470],NULL},
  {768,3,5,0,NULL,&joseki[1010]},
  {1019,0,3,0,NULL,&joseki[1011]},
  {799,3,6,1,&joseki_variations[3473],NULL},
  {801,3,7,2,&joseki_variations[3474],NULL},
  {768,3,5,0,NULL,&joseki[1004]},
  {1019,0,3,0,NULL,&joseki[1005]},
  {762,3,4,1,&joseki_variations[3477],NULL},
  {800,3,6,1,&joseki_variations[3478],NULL},
  {767,3,5,0,NULL,&joseki[931]},
  {762,3,4,3,&joseki_variations[3480],NULL},
  {800,3,6,2,&joseki_variations[3486],NULL},
  {801,3,6,1,&joseki_variations[3485],NULL},
  {799,3,6,1,&joseki_variations[3483],NULL},
  {801,3,7,1,&joseki_variations[3484],NULL},
  {835,0,5,0,NULL,&joseki[1003]},
  {799,3,6,0,NULL,&joseki[1002]},
  {767,3,5,0,NULL,&joseki[905]},
  {1019,0,3,0,NULL,&joseki[906]},
  {761,3,4,3,&joseki_variations[3489],NULL},
  {798,3,5,3,&joseki_variations[3511],NULL},
  {798,0,5,1,&joseki_variations[3503],NULL},
  {725,3,3,1,&joseki_variations[3492],NULL},
  {763,3,6,1,&joseki_variations[3493],NULL},
  {795,0,1,1,&joseki_variations[3494],NULL},
  {797,0,4,1,&joseki_variations[3495],NULL},
  {798,3,7,1,&joseki_variations[3496],NULL},
  {833,0,2,1,&joseki_variations[3497],NULL},
  {834,3,6,1,&joseki_variations[3498],NULL},
  {835,0,10,1,&joseki_variations[3499],NULL},
  {870,3,3,1,&joseki_variations[3500],NULL},
  {871,3,8,1,&joseki_variations[3501],NULL},
  {908,3,9,1,&joseki_variations[3502],NULL},
  {836,3,12,0,NULL,&joseki[991]},
  {725,3,3,1,&joseki_variations[3504],NULL},
  {762,3,6,1,&joseki_variations[3505],NULL},
  {763,3,7,1,&joseki_variations[3506],NULL},
  {800,0,9,1,&joseki_variations[3507],NULL},
  {837,0,10,1,&joseki_variations[3508],NULL},
  {801,3,10,1,&joseki_variations[3509],NULL},
  {767,3,8,1,&joseki_variations[3510],&joseki[587]},
  {872,0,6,0,NULL,&joseki[588]},
  {872,3,6,1,&joseki_variations[3524],NULL},
  {833,0,1,1,&joseki_variations[3517],NULL},
  {871,3,3,1,&joseki_variations[3514],NULL},
  {725,3,3,1,&joseki_variations[3515],NULL},
  {763,0,6,1,&joseki_variations[3516],NULL},
  {762,3,6,0,NULL,&joseki[753]},
  {872,3,7,1,&joseki_variations[3518],NULL},
  {725,3,3,1,&joseki_variations[3519],NULL},
  {762,3,6,1,&joseki_variations[3520],NULL},
  {763,0,7,1,&joseki_variations[3521],NULL},
  {837,0,10,1,&joseki_variations[3522],NULL},
  {765,3,8,1,&joseki_variations[3523],NULL},
  {911,3,12,0,NULL,&joseki[206]},
  {725,3,3,1,&joseki_variations[3525],NULL},
  {763,0,6,1,&joseki_variations[3526],NULL},
  {837,0,8,1,&joseki_variations[3527],NULL},
  {765,3,7,1,&joseki_variations[3528],NULL},
  {762,3,6,0,NULL,&joseki[205]},
  {834,0,4,1,&joseki_variations[3638],NULL},
  {724,0,2,1,&joseki_variations[3593],NULL},
  {834,3,4,2,&joseki_variations[3568],NULL},
  {833,3,1,1,&joseki_variations[3560],NULL},
  {871,0,4,2,&joseki_variations[3534],NULL},
  {761,3,3,1,&joseki_variations[3554],NULL},
  {724,0,2,1,&joseki_variations[3536],NULL},
  {761,3,4,1,&joseki_variations[3537],NULL},
  {798,3,6,2,&joseki_variations[3538],NULL},
  {835,0,7,1,&joseki_variations[3548],NULL},
  {835,3,7,1,&joseki_variations[3540],NULL},
  {725,3,3,1,&joseki_variations[3541],NULL},
  {762,3,6,1,&joseki_variations[3542],NULL},
  {763,0,7,2,&joseki_variations[3543],NULL},
  {800,3,10,0,NULL,&joseki[798]},
  {837,0,11,1,&joseki_variations[3545],&joseki[799]},
  {872,3,9,1,&joseki_variations[3546],&joseki[800]},
  {908,0,5,1,&joseki_variations[3547],&joseki[801]},
  {909,3,11,0,NULL,&joseki[802]},
  {725,3,3,1,&joseki_variations[3549],NULL},
  {799,3,8,1,&joseki_variations[3550],NULL},
  {836,3,10,1,&joseki_variations[3551],NULL},
  {910,3,12,1,&joseki_variations[3552],NULL},
  {763,0,6,1,&joseki_variations[3553],NULL},
  {762,3,6,0,NULL,&joseki[769]},
  {763,0,4,1,&joseki_variations[3555],NULL},
  {765,3,5,1,&joseki_variations[3556],NULL},
  {798,3,5,1,&joseki_variations[3557],NULL},
  {800,3,7,1,&joseki_variations[3558],NULL},
  {835,3,6,1,&joseki_variations[3559],NULL},
  {724,3,2,0,NULL,&joseki[241]},
  {834,3,5,1,&joseki_variations[3561],NULL},
  {724,3,2,1,&joseki_variations[3562],NULL},
  {761,3,4,1,&joseki_variations[3563],NULL},
  {763,0,5,1,&joseki_variations[3564],NULL},
  {765,3,6,1,&joseki_variations[3565],NULL},
  {798,3,6,1,&joseki_variations[3566],NULL},
  {835,0,9,1,&joseki_variations[3567],NULL},
  {799,0,7,0,NULL,&joseki[141]},
  {724,3,2,1,&joseki_variations[3578],NULL},
  {724,0,2,1,&joseki_variations[3570],NULL},
  {761,3,4,1,&joseki_variations[3571],NULL},
  {798,3,6,1,&joseki_variations[3572],NULL},
  {725,3,3,3,&joseki_variations[3573],NULL},
  {763,3,6,1,&joseki_variations[3577],&joseki[949]},
  {835,3,8,0,NULL,&joseki[954]},
  {871,3,5,1,&joseki_variations[3576],NULL},
  {763,3,6,0,NULL,&joseki[976]},
  {833,0,1,0,NULL,&joseki[950]},
  {761,3,4,1,&joseki_variations[3579],NULL},
  {763,0,5,1,&joseki_variations[3580],NULL},
  {798,3,6,1,&joseki_variations[3581],NULL},
  {835,0,8,2,&joseki_variations[3582],&joseki[135]},
  {871,3,5,1,&joseki_variations[3588],NULL},
  {836,3,9,2,&joseki_variations[3584],NULL},
  {872,0,9,0,NULL,&joseki[138]},
  {871,3,5,1,&joseki_variations[3586],NULL},
  {872,0,10,1,&joseki_variations[3587],NULL},
  {799,0,7,0,NULL,&joseki[139]},
  {799,0,7,1,&joseki_variations[3589],&joseki[136]},
  {836,3,10,1,&joseki_variations[3590],NULL},
  {872,0,10,1,&joseki_variations[3591],&joseki[137]},
  {837,3,12,1,&joseki_variations[3592],NULL},
  {909,0,11,0,NULL,&joseki[140]},
  {761,3,4,1,&joseki_variations[3594],NULL},
  {798,3,6,2,&joseki_variations[3595],NULL},
  {835,3,7,1,&joseki_variations[3617],NULL},
  {833,0,1,1,&joseki_variations[3597],NULL},
  {834,3,5,2,&joseki_variations[3598],NULL},
  {870,0,2,1,&joseki_variations[3610],NULL},
  {725,3,3,2,&joseki_variations[3600],NULL},
  {763,3,6,1,&joseki_variations[3608],NULL},
  {835,0,9,1,&joseki_variations[3602],NULL},
  {870,3,2,1,&joseki_variations[3603],NULL},
  {871,3,7,1,&joseki_variations[3604],NULL},
  {908,3,8,1,&joseki_variations[3605],NULL},
  {763,3,6,2,&joseki_variations[3606],&joseki[989]},
  {795,0,1,0,NULL,&joseki[990]},
  {796,0,1,0,NULL,&joseki[992]},
  {871,3,6,1,&joseki_variations[3609],&joseki[951]},
  {870,0,2,0,NULL,&joseki[952]},
  {871,3,7,2,&joseki_variations[3611],NULL},
  {908,3,8,1,&joseki_variations[3615],NULL},
  {725,3,3,1,&joseki_variations[3613],NULL},
  {763,3,6,1,&joseki_variations[3614],NULL},
  {908,3,8,0,NULL,&joseki[953]},
  {725,3,3,1,&joseki_variations[3616],NULL},
  {763,3,6,0,NULL,&joseki[946]},
  {725,3,3,3,&joseki_variations[3618],NULL},
  {763,0,6,3,&joseki_variations[3631],NULL},
  {762,3,6,1,&joseki_variations[3624],NULL},
  {726,3,4,1,&joseki_variations[3621],NULL},
  {763,0,7,1,&joseki_variations[3622],NULL},
  {765,3,8,1,&joseki_variations[3623],NULL},
  {871,0,4,0,NULL,&joseki[132]},
  {763,0,7,3,&joseki_variations[3625],NULL},
  {765,3,8,1,&joseki_variations[3629],NULL},
  {871,0,4,0,NULL,&joseki[797]},
  {803,3,10,1,&joseki_variations[3628],NULL},
  {871,0,4,0,NULL,&joseki[832]},
  {871,0,4,1,&joseki_variations[3630],&joseki[128]},
  {800,3,10,0,NULL,&joseki[129]},
  {765,3,7,3,&joseki_variations[3635],NULL},
  {762,3,6,0,NULL,&joseki[796]},
  {803,3,9,1,&joseki_variations[3634],NULL},
  {762,3,6,0,NULL,&joseki[831]},
  {762,3,6,0,NULL,&joseki[127]},
  {834,3,4,0,NULL,&joseki[130]},
  {726,3,4,0,NULL,&joseki[131]},
  {761,3,3,1,&joseki_variations[3639],NULL},
  {798,0,5,1,&joseki_variations[3640],NULL},
  {835,3,7,1,&joseki_variations[3641],NULL},
  {762,3,4,1,&joseki_variations[3642],NULL},
  {799,3,7,1,&joseki_variations[3643],NULL},
  {836,3,10,1,&joseki_variations[3644],NULL},
  {870,0,1,1,&joseki_variations[3645],NULL},
  {871,3,6,2,&joseki_variations[3646],NULL},
  {908,3,7,1,&joseki_variations[3650],&joseki[74]},
  {907,0,2,1,&joseki_variations[3648],NULL},
  {908,3,8,1,&joseki_variations[3649],NULL},
  {945,3,9,0,NULL,&joseki[76]},
  {907,0,2,0,NULL,&joseki[75]},
  {761,3,3,1,&joseki_variations[3652],NULL},
  {798,0,4,1,&joseki_variations[3653],NULL},
  {762,3,4,1,&joseki_variations[3654],NULL},
  {799,3,6,2,&joseki_variations[3655],NULL},
  {836,3,8,2,&joseki_variations[3661],NULL},
  {835,3,6,1,&joseki_variations[3657],NULL},
  {836,3,9,1,&joseki_variations[3658],NULL},
  {870,0,1,1,&joseki_variations[3659],NULL},
  {871,3,5,1,&joseki_variations[3660],NULL},
  {797,0,3,0,NULL,&joseki[73]},
  {871,3,4,1,&joseki_variations[3665],&joseki[70]},
  {870,0,1,1,&joseki_variations[3663],NULL},
  {871,3,5,1,&joseki_variations[3664],NULL},
  {835,3,6,0,NULL,&joseki[72]},
  {870,0,1,0,NULL,&joseki[71]},
  {834,3,2,1,&joseki_variations[3920],NULL},
  {834,0,2,2,&joseki_variations[3862],NULL},
  {870,3,2,1,&joseki_variations[3794],NULL},
  {723,0,1,4,&joseki_variations[3694],NULL},
  {797,0,2,2,&joseki_variations[3671],NULL},
  {834,3,3,1,&joseki_variations[3684],NULL},
  {833,3,2,1,&joseki_variations[3673],NULL},
  {834,3,4,1,&joseki_variations[3674],NULL},
  {724,0,1,1,&joseki_variations[3675],NULL},
  {761,0,2,1,&joseki_variations[3676],NULL},
  {798,3,5,1,&joseki_variations[3677],NULL},
  {725,0,2,1,&joseki_variations[3678],NULL},
  {762,3,4,1,&joseki_variations[3679],NULL},
  {799,3,8,1,&joseki_variations[3680],NULL},
  {726,3,3,1,&joseki_variations[3681],NULL},
  {764,3,6,1,&joseki_variations[3682],NULL},
  {804,3,11,1,&joseki_variations[3683],NULL},
  {722,0,1,0,NULL,&joseki[876]},
  {724,0,1,1,&joseki_variations[3685],NULL},
  {761,0,2,1,&joseki_variations[3686],NULL},
  {798,3,5,1,&joseki_variations[3687],NULL},
  {725,0,2,1,&joseki_variations[3688],NULL},
  {762,3,4,1,&joseki_variations[3689],NULL},
  {799,3,8,1,&joseki_variations[3690],NULL},
  {726,3,3,1,&joseki_variations[3691],NULL},
  {764,3,6,1,&joseki_variations[3692],NULL},
  {804,3,11,1,&joseki_variations[3693],NULL},
  {833,3,2,0,NULL,&joseki[875]},
  {834,3,3,1,&joseki_variations[3780],NULL},
  {833,3,2,2,&joseki_variations[3740],NULL},
  {797,3,3,1,&joseki_variations[3726],NULL},
  {760,0,2,2,&joseki_variations[3698],NULL},
  {797,3,4,1,&joseki_variations[3712],NULL},
  {797,0,4,1,&joseki_variations[3700],NULL},
  {833,0,2,1,&joseki_variations[3701],NULL},
  {834,3,6,1,&joseki_variations[3702],NULL},
  {870,3,3,1,&joseki_variations[3703],NULL},
  {871,3,8,1,&joseki_variations[3704],NULL},
  {908,3,9,1,&joseki_variations[3705],NULL},
  {724,0,2,1,&joseki_variations[3706],NULL},
  {761,3,4,1,&joseki_variations[3707],NULL},
  {798,3,7,1,&joseki_variations[3708],NULL},
  {835,0,10,1,&joseki_variations[3709],NULL},
  {725,3,3,1,&joseki_variations[3710],NULL},
  {763,3,6,1,&joseki_variations[3711],NULL},
  {836,3,12,0,NULL,&joseki[993]},
  {834,3,5,1,&joseki_variations[3713],NULL},
  {724,3,2,1,&joseki_variations[3714],NULL},
  {761,0,4,1,&joseki_variations[3715],NULL},
  {798,0,7,1,&joseki_variations[3716],NULL},
  {835,3,9,1,&joseki_variations[3717],NULL},
  {872,0,10,1,&joseki_variations[3718],NULL},
  {762,3,5,1,&joseki_variations[3719],NULL},
  {799,3,9,1,&joseki_variations[3720],NULL},
  {836,0,12,1,&joseki_variations[3721],NULL},
  {763,3,6,1,&joseki_variations[3722],NULL},
  {800,0,11,1,&joseki_variations[3723],NULL},
  {837,0,15,1,&joseki_variations[3724],NULL},
  {801,3,12,1,&joseki_variations[3725],NULL},
  {833,3,2,0,NULL,&joseki[527]},
  {834,3,4,1,&joseki_variations[3727],NULL},
  {724,3,2,1,&joseki_variations[3728],NULL},
  {761,0,3,1,&joseki_variations[3729],NULL},
  {798,0,6,1,&joseki_variations[3730],NULL},
  {835,3,8,1,&joseki_variations[3731],NULL},
  {872,0,9,1,&joseki_variations[3732],NULL},
  {762,3,4,1,&joseki_variations[3733],NULL},
  {799,3,8,1,&joseki_variations[3734],NULL},
  {836,0,11,1,&joseki_variations[3735],NULL},
  {763,3,5,1,&joseki_variations[3736],NULL},
  {800,0,10,1,&joseki_variations[3737],NULL},
  {837,0,14,1,&joseki_variations[3738],NULL},
  {801,3,11,1,&joseki_variations[3739],NULL},
  {760,0,2,0,NULL,&joseki[526]},
  {834,3,4,1,&joseki_variations[3767],NULL},
  {760,0,2,1,&joseki_variations[3742],NULL},
  {797,3,4,1,&joseki_variations[3743],NULL},
  {834,3,6,1,&joseki_variations[3744],NULL},
  {724,3,2,1,&joseki_variations[3745],NULL},
  {761,0,4,1,&joseki_variations[3746],NULL},
  {798,0,7,1,&joseki_variations[3747],NULL},
  {835,3,10,2,&joseki_variations[3748],NULL},
  {872,0,11,1,&joseki_variations[3759],NULL},
  {762,3,5,1,&joseki_variations[3750],NULL},
  {799,3,9,1,&joseki_variations[3751],NULL},
  {836,0,13,1,&joseki_variations[3752],NULL},
  {763,3,6,1,&joseki_variations[3753],NULL},
  {800,0,11,1,&joseki_variations[3754],NULL},
  {837,0,16,1,&joseki_variations[3755],NULL},
  {801,3,12,1,&joseki_variations[3756],NULL},
  {870,0,3,1,&joseki_variations[3757],NULL},
  {872,0,12,1,&joseki_variations[3758],NULL},
  {759,3,1,0,NULL,&joseki[529]},
  {762,3,5,1,&joseki_variations[3760],NULL},
  {799,3,9,1,&joseki_variations[3761],NULL},
  {836,0,13,1,&joseki_variations[3762],NULL},
  {763,3,6,1,&joseki_variations[3763],NULL},
  {800,0,11,1,&joseki_variations[3764],NULL},
  {837,0,16,1,&joseki_variations[3765],NULL},
  {801,3,12,1,&joseki_variations[3766],NULL},
  {870,0,3,0,NULL,&joseki[528]},
  {724,3,2,1,&joseki_variations[3768],NULL},
  {761,0,3,1,&joseki_variations[3769],NULL},
  {798,0,5,1,&joseki_variations[3770],NULL},
  {835,3,8,1,&joseki_variations[3771],NULL},
  {872,0,9,1,&joseki_variations[3772],NULL},
  {762,3,4,1,&joseki_variations[3773],NULL},
  {799,3,7,1,&joseki_variations[3774],NULL},
  {836,0,11,1,&joseki_variations[3775],NULL},
  {763,3,5,1,&joseki_variations[3776],NULL},
  {800,0,9,1,&joseki_variations[3777],NULL},
  {837,0,14,1,&joseki_variations[3778],NULL},
  {801,3,10,1,&joseki_variations[3779],NULL},
  {797,0,3,0,NULL,&joseki[524]},
  {724,3,2,1,&joseki_variations[3781],NULL},
  {761,0,3,1,&joseki_variations[3782],NULL},
  {798,0,5,1,&joseki_variations[3783],NULL},
  {835,3,7,1,&joseki_variations[3784],NULL},
  {872,0,8,1,&joseki_variations[3785],NULL},
  {762,3,4,1,&joseki_variations[3786],NULL},
  {799,3,7,1,&joseki_variations[3787],NULL},
  {836,0,10,1,&joseki_variations[3788],NULL},
  {763,3,5,1,&joseki_variations[3789],NULL},
  {800,0,9,1,&joseki_variations[3790],NULL},
  {837,0,13,1,&joseki_variations[3791],NULL},
  {801,3,10,2,&joseki_variations[3792],NULL},
  {833,3,2,0,NULL,&joseki[523]},
  {797,3,3,0,NULL,&joseki[525]},
  {723,0,1,2,&joseki_variations[3795],NULL},
  {834,0,3,1,&joseki_variations[3819],NULL},
  {760,3,2,1,&joseki_variations[3797],NULL},
  {834,0,4,1,&joseki_variations[3798],NULL},
  {871,3,6,1,&joseki_variations[3799],NULL},
  {724,3,2,1,&joseki_variations[3800],NULL},
  {761,3,4,1,&joseki_variations[3801],NULL},
  {798,3,6,1,&joseki_variations[3802],NULL},
  {835,0,8,1,&joseki_variations[3803],NULL},
  {872,3,11,1,&joseki_variations[3804],NULL},
  {688,3,1,1,&joseki_variations[3805],NULL},
  {725,0,4,1,&joseki_variations[3806],NULL},
  {762,0,7,1,&joseki_variations[3807],NULL},
  {799,0,10,1,&joseki_variations[3808],NULL},
  {836,3,13,1,&joseki_variations[3809],NULL},
  {726,0,5,1,&joseki_variations[3810],NULL},
  {763,0,9,1,&joseki_variations[3811],NULL},
  {800,3,13,1,&joseki_variations[3812],NULL},
  {837,3,17,1,&joseki_variations[3813],NULL},
  {727,0,6,1,&joseki_variations[3814],NULL},
  {764,3,11,1,&joseki_variations[3815],NULL},
  {801,0,16,1,&joseki_variations[3816],NULL},
  {728,0,7,1,&joseki_variations[3817],NULL},
  {765,3,13,1,&joseki_variations[3818],NULL},
  {759,0,1,0,NULL,&joseki[487]},
  {871,3,5,1,&joseki_variations[3820],NULL},
  {724,3,2,1,&joseki_variations[3821],NULL},
  {761,3,3,1,&joseki_variations[3822],NULL},
  {798,3,5,1,&joseki_variations[3823],NULL},
  {835,0,7,1,&joseki_variations[3824],NULL},
  {872,3,10,2,&joseki_variations[3825],NULL},
  {725,0,3,1,&joseki_variations[3850],NULL},
  {688,3,1,1,&joseki_variations[3827],NULL},
  {725,0,4,1,&joseki_variations[3828],NULL},
  {762,0,6,1,&joseki_variations[3829],NULL},
  {799,0,9,1,&joseki_variations[3830],NULL},
  {836,3,12,2,&joseki_variations[3831],NULL},
  {763,0,7,1,&joseki_variations[3842],NULL},
  {726,0,5,1,&joseki_variations[3833],NULL},
  {763,0,8,1,&joseki_variations[3834],NULL},
  {800,3,12,1,&joseki_variations[3835],NULL},
  {837,3,16,1,&joseki_variations[3836],NULL},
  {727,0,6,1,&joseki_variations[3837],NULL},
  {764,3,10,1,&joseki_variations[3838],NULL},
  {801,0,15,1,&joseki_variations[3839],NULL},
  {728,0,7,1,&joseki_variations[3840],NULL},
  {765,3,12,1,&joseki_variations[3841],NULL},
  {760,3,2,0,NULL,&joseki[486]},
  {800,3,11,1,&joseki_variations[3843],NULL},
  {837,3,15,1,&joseki_variations[3844],NULL},
  {727,0,5,1,&joseki_variations[3845],NULL},
  {764,3,9,1,&joseki_variations[3846],NULL},
  {801,0,14,1,&joseki_variations[3847],NULL},
  {728,0,6,1,&joseki_variations[3848],NULL},
  {765,3,11,1,&joseki_variations[3849],NULL},
  {726,0,5,0,NULL,&joseki[485]},
  {762,0,5,1,&joseki_variations[3851],NULL},
  {799,0,8,1,&joseki_variations[3852],NULL},
  {836,3,11,1,&joseki_variations[3853],NULL},
  {763,0,6,1,&joseki_variations[3854],NULL},
  {800,3,10,1,&joseki_variations[3855],NULL},
  {837,3,14,1,&joseki_variations[3856],NULL},
  {727,0,4,1,&joseki_variations[3857],NULL},
  {764,3,8,1,&joseki_variations[3858],NULL},
  {801,0,13,1,&joseki_variations[3859],NULL},
  {728,0,5,1,&joseki_variations[3860],NULL},
  {765,3,10,1,&joseki_variations[3861],NULL},
  {688,3,1,0,NULL,&joseki[484]},
  {871,3,3,1,&joseki_variations[3893],NULL},
  {870,3,2,1,&joseki_variations[3864],NULL},
  {871,3,4,1,&joseki_variations[3865],NULL},
  {724,3,1,1,&joseki_variations[3866],NULL},
  {761,3,2,1,&joseki_variations[3867],NULL},
  {798,3,4,1,&joseki_variations[3868],NULL},
  {835,0,6,1,&joseki_variations[3869],NULL},
  {872,3,9,2,&joseki_variations[3870],NULL},
  {762,0,3,1,&joseki_variations[3885],NULL},
  {725,0,2,1,&joseki_variations[3872],NULL},
  {762,0,4,1,&joseki_variations[3873],NULL},
  {799,0,7,1,&joseki_variations[3874],NULL},
  {836,3,10,1,&joseki_variations[3875],NULL},
  {763,0,5,1,&joseki_variations[3876],NULL},
  {800,3,9,1,&joseki_variations[3877],NULL},
  {837,3,13,1,&joseki_variations[3878],NULL},
  {727,0,3,1,&joseki_variations[3879],NULL},
  {764,3,7,1,&joseki_variations[3880],NULL},
  {801,0,12,1,&joseki_variations[3881],NULL},
  {728,0,4,1,&joseki_variations[3882],NULL},
  {765,3,9,2,&joseki_variations[3883],NULL},
  {722,0,1,0,NULL,&joseki[473]},
  {723,0,1,0,NULL,&joseki[483]},
  {799,0,6,1,&joseki_variations[3886],NULL},
  {836,3,9,1,&joseki_variations[3887],NULL},
  {763,0,4,1,&joseki_variations[3888],NULL},
  {800,3,8,1,&joseki_variations[3889],NULL},
  {837,3,12,1,&joseki_variations[3890],NULL},
  {764,0,5,1,&joseki_variations[3891],NULL},
  {801,0,10,1,&joseki_variations[3892],NULL},
  {722,0,1,0,NULL,&joseki[367]},
  {724,3,1,1,&joseki_variations[3894],NULL},
  {761,3,2,1,&joseki_variations[3895],NULL},
  {798,3,4,1,&joseki_variations[3896],NULL},
  {835,0,6,1,&joseki_variations[3897],NULL},
  {872,3,8,2,&joseki_variations[3898],NULL},
  {762,0,3,1,&joseki_variations[3912],NULL},
  {725,0,2,1,&joseki_variations[3900],NULL},
  {762,0,4,1,&joseki_variations[3901],NULL},
  {799,0,7,1,&joseki_variations[3902],NULL},
  {836,3,10,1,&joseki_variations[3903],NULL},
  {763,0,5,1,&joseki_variations[3904],NULL},
  {800,3,9,1,&joseki_variations[3905],NULL},
  {837,3,13,1,&joseki_variations[3906],NULL},
  {727,0,3,1,&joseki_variations[3907],NULL},
  {764,3,7,1,&joseki_variations[3908],NULL},
  {801,0,12,1,&joseki_variations[3909],NULL},
  {728,0,4,1,&joseki_variations[3910],NULL},
  {765,3,9,1,&joseki_variations[3911],NULL},
  {870,3,2,0,NULL,&joseki[472]},
  {799,0,6,1,&joseki_variations[3913],NULL},
  {836,3,9,1,&joseki_variations[3914],NULL},
  {763,0,4,1,&joseki_variations[3915],NULL},
  {800,3,8,1,&joseki_variations[3916],NULL},
  {837,3,12,1,&joseki_variations[3917],NULL},
  {764,0,5,1,&joseki_variations[3918],NULL},
  {801,0,10,1,&joseki_variations[3919],NULL},
  {870,3,2,0,NULL,&joseki[366]},
  {871,0,3,1,&joseki_variations[3921],NULL},
  {908,0,4,1,&joseki_variations[3922],NULL},
  {724,3,1,1,&joseki_variations[3923],NULL},
  {761,0,2,1,&joseki_variations[3924],NULL},
  {798,0,4,1,&joseki_variations[3925],NULL},
  {835,0,6,1,&joseki_variations[3926],NULL},
  {872,3,8,1,&joseki_variations[3927],NULL},
  {909,0,10,1,&joseki_variations[3928],NULL},
  {762,3,3,1,&joseki_variations[3929],NULL},
  {799,3,6,1,&joseki_variations[3930],NULL},
  {836,3,9,1,&joseki_variations[3931],NULL},
  {873,3,12,1,&joseki_variations[3932],NULL},
  {759,3,1,0,NULL,&joseki[46]},
  {871,3,2,4,&joseki_variations[4253],NULL},
  {761,3,1,12,&joseki_variations[4002],NULL},
  {724,3,1,1,&joseki_variations[3966],NULL},
  {761,0,1,3,&joseki_variations[3937],NULL},
  {798,0,2,1,&joseki_variations[3954],NULL},
  {835,3,3,4,&joseki_variations[3944],NULL},
  {798,3,2,1,&joseki_variations[3940],NULL},
  {835,3,4,2,&joseki_variations[3941],NULL},
  {797,0,1,0,NULL,&joseki[1136]},
  {800,3,3,1,&joseki_variations[3943],NULL},
  {797,0,1,0,NULL,&joseki[1578]},
  {871,3,2,0,NULL,&joseki[1083]},
  {798,3,2,0,NULL,&joseki[1135]},
  {909,3,4,1,&joseki_variations[3950],NULL},
  {800,3,2,2,&joseki_variations[3948],NULL},
  {871,3,2,0,NULL,&joseki[1572]},
  {798,3,2,0,NULL,&joseki[1577]},
  {799,0,2,1,&joseki_variations[3951],NULL},
  {836,0,5,1,&joseki_variations[3952],NULL},
  {873,3,6,1,&joseki_variations[3953],NULL},
  {871,3,2,0,NULL,&joseki[1241]},
  {835,3,4,1,&joseki_variations[3955],NULL},
  {872,0,5,1,&joseki_variations[3956],NULL},
  {762,0,2,1,&joseki_variations[3957],NULL},
  {799,3,4,1,&joseki_variations[3958],NULL},
  {836,3,7,1,&joseki_variations[3959],NULL},
  {873,3,9,1,&joseki_variations[3960],NULL},
  {910,0,10,1,&joseki_variations[3961],NULL},
  {763,3,3,1,&joseki_variations[3962],NULL},
  {800,0,6,1,&joseki_variations[3963],NULL},
  {764,3,4,1,&joseki_variations[3964],NULL},
  {838,3,11,1,&joseki_variations[3965],NULL},
  {909,0,6,0,NULL,&joseki[677]},
  {761,3,2,1,&joseki_variations[3967],NULL},
  {798,3,3,1,&joseki_variations[3968],NULL},
  {835,0,5,1,&joseki_variations[3969],NULL},
  {872,3,6,2,&joseki_variations[3970],NULL},
  {762,0,3,1,&joseki_variations[3991],NULL},
  {725,0,2,1,&joseki_variations[3972],NULL},
  {762,0,4,1,&joseki_variations[3973],NULL},
  {799,0,6,1,&joseki_variations[3974],NULL},
  {836,3,9,1,&joseki_variations[3975],NULL},
  {763,0,5,1,&joseki_variations[3976],NULL},
  {800,3,8,1,&joseki_variations[3977],NULL},
  {837,3,12,3,&joseki_variations[3978],NULL},
  {801,0,9,1,&joseki_variations[3990],NULL},
  {764,3,6,1,&joseki_variations[3988],NULL},
  {727,0,3,1,&joseki_variations[3981],NULL},
  {764,3,7,1,&joseki_variations[3982],NULL},
  {801,0,11,2,&joseki_variations[3983],NULL},
  {765,3,8,1,&joseki_variations[3987],&joseki[468]},
  {728,0,4,1,&joseki_variations[3985],NULL},
  {765,3,9,1,&joseki_variations[3986],NULL},
  {871,3,2,0,NULL,&joseki[470]},
  {728,0,4,0,NULL,&joseki[469]},
  {801,0,10,1,&joseki_variations[3989],NULL},
  {727,0,3,0,NULL,&joseki[467]},
  {764,3,6,0,NULL,&joseki[466]},
  {799,0,5,1,&joseki_variations[3992],NULL},
  {836,3,8,1,&joseki_variations[3993],NULL},
  {763,0,4,1,&joseki_variations[3994],NULL},
  {800,3,7,1,&joseki_variations[3995],NULL},
  {837,3,11,2,&joseki_variations[3996],NULL},
  {801,0,8,2,&joseki_variations[4000],NULL},
  {764,0,5,1,&joseki_variations[3998],NULL},
  {801,0,9,1,&joseki_variations[3999],NULL},
  {871,3,2,0,NULL,&joseki[364]},
  {764,0,5,0,NULL,&joseki[363]},
  {725,0,2,0,NULL,&joseki[465]},
  {798,0,2,1,&joseki_variations[4250],NULL},
  {725,3,1,1,&joseki_variations[4245],NULL},
  {798,3,2,1,&joseki_variations[4235],NULL},
  {799,3,2,5,&joseki_variations[4181],&joseki[1321]},
  {946,3,3,4,&joseki_variations[4168],&joseki[1334]},
  {872,0,3,1,&joseki_variations[4165],NULL},
  {982,3,2,0,NULL,&joseki[1358]},
  {908,3,2,2,&joseki_variations[4079],&joseki[1359]},
  {835,3,3,1,&joseki_variations[4077],&joseki[1422]},
  {800,3,2,7,&joseki_variations[4024],&joseki[1428]},
  {799,0,2,1,&joseki_variations[4023],&joseki[1542]},
  {762,3,2,1,&joseki_variations[4014],NULL},
  {799,0,3,2,&joseki_variations[4015],NULL},
  {800,0,4,1,&joseki_variations[4021],&joseki[1544]},
  {763,3,3,1,&joseki_variations[4017],NULL},
  {800,0,5,1,&joseki_variations[4018],NULL},
  {801,0,6,1,&joseki_variations[4019],&joseki[1547]},
  {1019,0,2,1,&joseki_variations[4020],&joseki[1548]},
  {1021,0,6,0,NULL,&joseki[1549]},
  {764,3,3,1,&joseki_variations[4022],&joseki[1545]},
  {1019,0,2,0,NULL,&joseki[1546]},
  {762,3,2,0,NULL,&joseki[1543]},
  {760,0,1,0,NULL,&joseki[1429]},
  {945,0,2,2,&joseki_variations[4074],&joseki[1449]},
  {982,0,2,2,&joseki_variations[4071],&joseki[1462]},
  {908,3,2,1,&joseki_variations[4069],NULL},
  {907,0,1,1,&joseki_variations[4060],NULL},
  {870,3,1,1,&joseki_variations[4033],NULL},
  {765,0,2,2,&joseki_variations[4031],&joseki[1487]},
  {982,3,2,0,NULL,&joseki[1488]},
  {805,3,4,0,NULL,&joseki[1489]},
  {907,0,2,2,&joseki_variations[4034],NULL},
  {908,3,4,1,&joseki_variations[4055],NULL},
  {871,3,3,1,&joseki_variations[4036],NULL},
  {908,3,5,3,&joseki_variations[4037],NULL},
  {909,0,7,1,&joseki_variations[4051],NULL},
  {872,0,5,1,&joseki_variations[4046],NULL},
  {835,3,3,1,&joseki_variations[4040],NULL},
  {872,0,6,1,&joseki_variations[4041],NULL},
  {909,0,9,1,&joseki_variations[4042],NULL},
  {944,3,3,1,&joseki_variations[4043],NULL},
  {945,0,7,1,&joseki_variations[4044],NULL},
  {982,0,8,1,&joseki_variations[4045],NULL},
  {833,0,1,0,NULL,&joseki[1479]},
  {909,0,8,1,&joseki_variations[4047],NULL},
  {944,3,3,1,&joseki_variations[4048],NULL},
  {945,0,7,1,&joseki_variations[4049],NULL},
  {982,0,8,1,&joseki_variations[4050],NULL},
  {835,3,3,0,NULL,&joseki[1478]},
  {944,3,3,1,&joseki_variations[4052],NULL},
  {945,0,7,1,&joseki_variations[4053],NULL},
  {982,0,8,1,&joseki_variations[4054],NULL},
  {872,0,5,0,NULL,&joseki[1477]},
  {944,3,3,1,&joseki_variations[4056],NULL},
  {945,0,6,1,&joseki_variations[4057],NULL},
  {982,0,7,1,&joseki_variations[4058],NULL},
  {909,0,6,1,&joseki_variations[4059],&joseki[1475]},
  {871,3,3,0,NULL,&joseki[1476]},
  {908,3,3,2,&joseki_variations[4061],NULL},
  {982,0,4,1,&joseki_variations[4068],NULL},
  {944,3,2,2,&joseki_variations[4063],NULL},
  {982,0,5,1,&joseki_variations[4067],NULL},
  {945,0,5,1,&joseki_variations[4065],NULL},
  {982,0,6,1,&joseki_variations[4066],NULL},
  {870,3,1,0,NULL,&joseki[1474]},
  {945,0,5,0,NULL,&joseki[1473]},
  {944,3,2,0,NULL,&joseki[1472]},
  {982,0,3,1,&joseki_variations[4070],NULL},
  {907,0,1,0,NULL,&joseki[1471]},
  {1056,3,3,1,&joseki_variations[4073],&joseki[1463]},
  {908,3,2,0,NULL,&joseki[1470]},
  {760,0,1,0,NULL,&joseki[1464]},
  {797,3,1,0,NULL,&joseki[1450]},
  {767,3,2,1,&joseki_variations[4076],&joseki[1454]},
  {760,0,1,0,NULL,&joseki[1455]},
  {872,0,4,1,&joseki_variations[4078],&joseki[1423]},
  {797,3,1,0,NULL,&joseki[1424]},
  {836,0,3,1,&joseki_variations[4141],&joseki[1360]},
  {909,0,4,1,&joseki_variations[4081],NULL},
  {945,3,3,2,&joseki_variations[4082],NULL},
  {799,0,2,1,&joseki_variations[4134],NULL},
  {762,3,2,1,&joseki_variations[4084],NULL},
  {799,0,3,1,&joseki_variations[4085],NULL},
  {836,0,5,2,&joseki_variations[4086],NULL},
  {800,3,4,2,&joseki_variations[4116],NULL},
  {763,3,3,1,&joseki_variations[4088],NULL},
  {800,3,5,1,&joseki_variations[4089],NULL},
  {837,3,8,1,&joseki_variations[4090],NULL},
  {874,0,9,1,&joseki_variations[4091],NULL},
  {801,0,6,1,&joseki_variations[4092],NULL},
  {838,0,10,2,&joseki_variations[4093],NULL},
  {875,3,12,1,&joseki_variations[4109],NULL},
  {911,0,12,1,&joseki_variations[4095],NULL},
  {912,0,15,2,&joseki_variations[4096],NULL},
  {802,0,7,1,&joseki_variations[4104],NULL},
  {765,3,4,1,&joseki_variations[4098],NULL},
  {802,0,8,1,&joseki_variations[4099],NULL},
  {839,3,13,1,&joseki_variations[4100],NULL},
  {876,0,15,1,&joseki_variations[4101],NULL},
  {803,3,9,1,&joseki_variations[4102],NULL},
  {840,3,15,1,&joseki_variations[4103],NULL},
  {1056,0,4,0,NULL,&joseki[1421]},
  {839,3,12,1,&joseki_variations[4105],NULL},
  {876,0,14,1,&joseki_variations[4106],NULL},
  {803,3,8,1,&joseki_variations[4107],NULL},
  {840,3,14,1,&joseki_variations[4108],NULL},
  {765,3,4,0,NULL,&joseki[1420]},
  {802,0,7,1,&joseki_variations[4110],NULL},
  {839,3,12,1,&joseki_variations[4111],NULL},
  {911,0,12,1,&joseki_variations[4112],&joseki[1415]},
  {803,3,8,1,&joseki_variations[4113],&joseki[1416]},
  {876,0,15,1,&joseki_variations[4114],&joseki[1417]},
  {840,3,14,1,&joseki_variations[4115],&joseki[1418]},
  {912,0,16,0,NULL,&joseki[1419]},
  {802,0,5,1,&joseki_variations[4125],NULL},
  {837,3,7,1,&joseki_variations[4118],NULL},
  {874,0,8,1,&joseki_variations[4119],NULL},
  {801,0,5,1,&joseki_variations[4120],NULL},
  {838,0,9,1,&joseki_variations[4121],NULL},
  {875,3,11,1,&joseki_variations[4122],NULL},
  {802,0,6,1,&joseki_variations[4123],NULL},
  {839,3,11,1,&joseki_variations[4124],NULL},
  {763,3,3,0,NULL,&joseki[1414]},
  {837,3,7,2,&joseki_variations[4126],NULL},
  {839,3,9,1,&joseki_variations[4132],NULL},
  {874,0,8,1,&joseki_variations[4128],NULL},
  {838,0,8,1,&joseki_variations[4129],NULL},
  {839,3,10,1,&joseki_variations[4130],NULL},
  {875,3,10,1,&joseki_variations[4131],&joseki[1412]},
  {801,0,5,0,NULL,&joseki[1413]},
  {874,0,8,1,&joseki_variations[4133],NULL},
  {838,0,8,0,NULL,&joseki[1411]},
  {836,0,4,1,&joseki_variations[4135],NULL},
  {800,3,3,1,&joseki_variations[4136],NULL},
  {802,0,4,1,&joseki_variations[4137],NULL},
  {837,3,6,1,&joseki_variations[4138],NULL},
  {839,3,8,1,&joseki_variations[4139],NULL},
  {874,0,7,1,&joseki_variations[4140],NULL},
  {762,3,2,0,NULL,&joseki[1410]},
  {800,3,2,3,&joseki_variations[4142],&joseki[1361]},
  {909,0,4,1,&joseki_variations[4163],&joseki[1362]},
  {946,0,4,1,&joseki_variations[4162],NULL},
  {802,0,3,1,&joseki_variations[4145],NULL},
  {837,3,5,1,&joseki_variations[4146],&joseki[1393]},
  {909,0,4,1,&joseki_variations[4147],&joseki[1394]},
  {945,3,3,1,&joseki_variations[4148],&joseki[1395]},
  {874,0,6,2,&joseki_variations[4149],&joseki[1396]},
  {875,3,7,2,&joseki_variations[4154],&joseki[1397]},
  {839,3,7,2,&joseki_variations[4151],&joseki[1405]},
  {804,0,4,1,&joseki_variations[4153],&joseki[1406]},
  {799,0,2,0,NULL,&joseki[1409]},
  {875,3,7,0,NULL,&joseki[1407]},
  {911,0,9,1,&joseki_variations[4158],&joseki[1398]},
  {839,3,7,1,&joseki_variations[4156],NULL},
  {804,0,4,1,&joseki_variations[4157],NULL},
  {911,0,9,0,NULL,&joseki[1408]},
  {839,3,7,2,&joseki_variations[4159],&joseki[1399]},
  {804,0,4,1,&joseki_variations[4161],&joseki[1400]},
  {1056,0,4,0,NULL,&joseki[1404]},
  {797,3,1,0,NULL,&joseki[1401]},
  {797,3,1,0,NULL,&joseki[1365]},
  {946,3,5,1,&joseki_variations[4164],NULL},
  {910,0,6,0,NULL,&joseki[1363]},
  {946,3,4,1,&joseki_variations[4166],NULL},
  {800,3,2,1,&joseki_variations[4167],&joseki[1355]},
  {759,0,1,0,NULL,&joseki[1356]},
  {837,0,3,2,&joseki_variations[4179],&joseki[1335]},
  {836,3,3,1,&joseki_variations[4176],NULL},
  {799,3,2,1,&joseki_variations[4172],NULL},
  {872,0,3,0,NULL,&joseki[1354]},
  {836,3,4,1,&joseki_variations[4173],NULL},
  {873,0,5,1,&joseki_variations[4174],NULL},
  {837,0,5,1,&joseki_variations[4175],NULL},
  {872,0,3,0,NULL,&joseki[1340]},
  {837,0,4,1,&joseki_variations[4177],NULL},
  {873,0,4,1,&joseki_variations[4178],&joseki[1338]},
  {799,3,2,0,NULL,&joseki[1339]},
  {764,3,2,0,NULL,&joseki[1336]},
  {836,3,3,0,NULL,&joseki[1337]},
  {909,0,3,1,&joseki_variations[4234],&joseki[1322]},
  {945,0,2,1,&joseki_variations[4232],&joseki[1325]},
  {872,3,3,1,&joseki_variations[4230],&joseki[1327]},
  {871,0,2,1,&joseki_variations[4226],NULL},
  {836,3,4,2,&joseki_variations[4186],NULL},
  {837,0,5,1,&joseki_variations[4212],NULL},
  {872,0,3,1,&joseki_variations[4188],NULL},
  {946,3,4,1,&joseki_variations[4189],NULL},
  {1020,3,5,1,&joseki_variations[4190],NULL},
  {873,0,6,1,&joseki_variations[4191],NULL},
  {947,0,8,1,&joseki_variations[4192],NULL},
  {763,0,2,2,&joseki_variations[4193],NULL},
  {837,0,6,1,&joseki_variations[4208],NULL},
  {800,3,4,1,&joseki_variations[4195],NULL},
  {837,0,7,1,&joseki_variations[4196],NULL},
  {874,3,10,1,&joseki_variations[4197],NULL},
  {911,0,11,3,&joseki_variations[4198],NULL},
  {875,3,11,1,&joseki_variations[4207],NULL},
  {838,0,8,1,&joseki_variations[4205],NULL},
  {801,3,5,1,&joseki_variations[4201],NULL},
  {838,0,9,1,&joseki_variations[4202],NULL},
  {875,3,13,1,&joseki_variations[4203],NULL},
  {839,0,10,1,&joseki_variations[4204],&joseki[1352]},
  {766,3,3,0,NULL,&joseki[1353]},
  {875,3,12,1,&joseki_variations[4206],NULL},
  {801,3,5,0,NULL,&joseki[1351]},
  {838,0,8,0,NULL,&joseki[1350]},
  {874,3,9,1,&joseki_variations[4209],NULL},
  {911,0,10,1,&joseki_variations[4210],NULL},
  {875,3,10,1,&joseki_variations[4211],NULL},
  {800,3,4,0,NULL,&joseki[1349]},
  {872,0,3,1,&joseki_variations[4213],NULL},
  {946,3,4,1,&joseki_variations[4214],NULL},
  {873,0,6,1,&joseki_variations[4215],NULL},
  {874,3,8,1,&joseki_variations[4216],&joseki[1341]},
  {911,0,9,2,&joseki_variations[4217],&joseki[1342]},
  {875,3,9,1,&joseki_variations[4222],&joseki[1343]},
  {947,0,8,1,&joseki_variations[4219],NULL},
  {838,3,6,1,&joseki_variations[4220],NULL},
  {875,3,10,1,&joseki_variations[4221],NULL},
  {983,0,5,0,NULL,&joseki[1346]},
  {947,0,8,2,&joseki_variations[4223],&joseki[1344]},
  {838,3,6,0,NULL,&joseki[1345]},
  {1020,3,5,1,&joseki_variations[4225],&joseki[1347]},
  {763,0,2,0,NULL,&joseki[1348]},
  {872,3,4,1,&joseki_variations[4227],NULL},
  {909,3,5,1,&joseki_variations[4228],&joseki[1331]},
  {945,0,3,1,&joseki_variations[4229],&joseki[1332]},
  {767,3,2,0,NULL,&joseki[1333]},
  {908,0,2,1,&joseki_variations[4231],&joseki[1328]},
  {797,3,1,0,NULL,&joseki[1329]},
  {1019,3,3,1,&joseki_variations[4233],NULL},
  {759,0,1,0,NULL,&joseki[1326]},
  {797,3,1,0,NULL,&joseki[1323]},
  {835,0,4,1,&joseki_variations[4236],NULL},
  {872,3,5,1,&joseki_variations[4237],NULL},
  {762,0,2,1,&joseki_variations[4238],NULL},
  {799,0,4,1,&joseki_variations[4239],NULL},
  {836,3,7,1,&joseki_variations[4240],NULL},
  {763,0,3,1,&joseki_variations[4241],NULL},
  {800,3,6,1,&joseki_variations[4242],NULL},
  {837,3,10,1,&joseki_variations[4243],NULL},
  {801,0,7,1,&joseki_variations[4244],NULL},
  {724,3,1,0,NULL,&joseki[362]},
  {762,0,3,1,&joseki_variations[4246],NULL},
  {799,0,4,1,&joseki_variations[4247],NULL},
  {836,0,6,1,&joseki_variations[4248],NULL},
  {726,3,2,1,&joseki_variations[4249],NULL},
  {797,3,1,0,NULL,&joseki[82]},
  {799,3,3,1,&joseki_variations[4251],NULL},
  {836,3,5,1,&joseki_variations[4252],NULL},
  {760,0,1,0,NULL,&joseki[67]},
  {908,3,3,2,&joseki_variations[4316],NULL},
  {724,3,1,1,&joseki_variations[4286],NULL},
  {761,0,1,3,&joseki_variations[4266],NULL},
  {761,3,1,1,&joseki_variations[4257],NULL},
  {798,3,2,1,&joseki_variations[4258],NULL},
  {835,0,4,1,&joseki_variations[4259],NULL},
  {872,3,6,1,&joseki_variations[4260],NULL},
  {762,0,2,1,&joseki_variations[4261],NULL},
  {799,0,4,1,&joseki_variations[4262],NULL},
  {836,3,7,1,&joseki_variations[4263],NULL},
  {763,0,3,1,&joseki_variations[4264],NULL},
  {800,3,6,1,&joseki_variations[4265],NULL},
  {796,0,1,0,NULL,&joseki[695]},
  {798,0,2,1,&joseki_variations[4277],NULL},
  {835,3,3,2,&joseki_variations[4274],NULL},
  {835,0,3,1,&joseki_variations[4269],NULL},
  {872,3,5,2,&joseki_variations[4270],NULL},
  {873,3,6,0,NULL,&joseki[1522]},
  {873,0,6,1,&joseki_variations[4272],NULL},
  {910,3,7,1,&joseki_variations[4273],NULL},
  {833,3,1,0,NULL,&joseki[1526]},
  {797,0,1,0,NULL,&joseki[1084]},
  {800,3,2,1,&joseki_variations[4276],NULL},
  {797,0,1,0,NULL,&joseki[1573]},
  {762,3,2,1,&joseki_variations[4278],NULL},
  {763,3,3,1,&joseki_variations[4279],NULL},
  {800,0,5,1,&joseki_variations[4280],NULL},
  {837,0,7,1,&joseki_variations[4281],NULL},
  {801,3,6,3,&joseki_variations[4282],NULL},
  {872,3,5,1,&joseki_variations[4285],&joseki[562]},
  {909,3,5,0,NULL,&joseki[564]},
  {872,0,5,0,NULL,&joseki[565]},
  {799,0,4,0,NULL,&joseki[563]},
  {761,3,2,1,&joseki_variations[4287],NULL},
  {798,3,3,1,&joseki_variations[4288],NULL},
  {835,0,5,1,&joseki_variations[4289],NULL},
  {872,3,7,2,&joseki_variations[4290],NULL},
  {762,0,3,1,&joseki_variations[4306],NULL},
  {725,0,2,1,&joseki_variations[4292],NULL},
  {762,0,4,1,&joseki_variations[4293],NULL},
  {799,0,6,1,&joseki_variations[4294],NULL},
  {836,3,9,1,&joseki_variations[4295],NULL},
  {763,0,5,1,&joseki_variations[4296],NULL},
  {800,3,8,1,&joseki_variations[4297],NULL},
  {837,3,12,1,&joseki_variations[4298],NULL},
  {727,0,3,1,&joseki_variations[4299],NULL},
  {764,3,7,1,&joseki_variations[4300],NULL},
  {801,0,11,1,&joseki_variations[4301],NULL},
  {728,0,4,1,&joseki_variations[4302],NULL},
  {765,3,9,3,&joseki_variations[4303],NULL},
  {796,0,1,0,NULL,&joseki[471]},
  {833,0,1,0,NULL,&joseki[491]},
  {797,0,1,0,NULL,&joseki[507]},
  {799,0,5,1,&joseki_variations[4307],NULL},
  {836,3,8,1,&joseki_variations[4308],NULL},
  {763,0,4,1,&joseki_variations[4309],NULL},
  {800,3,7,1,&joseki_variations[4310],NULL},
  {837,3,11,1,&joseki_variations[4311],NULL},
  {764,0,5,1,&joseki_variations[4312],NULL},
  {801,0,9,3,&joseki_variations[4313],NULL},
  {796,0,1,0,NULL,&joseki[365]},
  {833,0,1,0,NULL,&joseki[387]},
  {797,0,1,0,NULL,&joseki[453]},
  {724,0,1,1,&joseki_variations[4324],NULL},
  {761,3,1,1,&joseki_variations[4318],NULL},
  {909,0,5,1,&joseki_variations[4319],NULL},
  {946,3,6,1,&joseki_variations[4320],NULL},
  {836,0,3,1,&joseki_variations[4321],NULL},
  {910,0,7,1,&joseki_variations[4322],NULL},
  {800,3,2,1,&joseki_variations[4323],NULL},
  {835,0,3,0,NULL,&joseki[1364]},
  {761,3,2,1,&joseki_variations[4325],NULL},
  {798,3,3,1,&joseki_variations[4326],NULL},
  {835,3,5,1,&joseki_variations[4327],NULL},
  {872,0,7,1,&joseki_variations[4328],NULL},
  {909,3,9,1,&joseki_variations[4329],NULL},
  {762,0,3,1,&joseki_variations[4330],NULL},
  {799,0,5,1,&joseki_variations[4331],NULL},
  {836,0,8,1,&joseki_variations[4332],NULL},
  {873,0,11,1,&joseki_variations[4333],NULL},
  {796,3,1,0,NULL,&joseki[45]},
  {798,0,2,5,&joseki_variations[4750],NULL},
  {762,3,2,5,&joseki_variations[4715],NULL},
  {762,0,2,2,&joseki_variations[4693],NULL},
  {836,3,2,2,&joseki_variations[4691],NULL},
  {725,0,1,1,&joseki_variations[4654],NULL},
  {797,3,1,1,&joseki_variations[4652],NULL},
  {763,0,2,1,&joseki_variations[4617],NULL},
  {764,3,2,1,&joseki_variations[4614],NULL},
  {798,3,2,3,&joseki_variations[4499],NULL},
  {835,3,2,11,&joseki_variations[4438],NULL},
  {796,3,1,1,&joseki_variations[4431],NULL},
  {800,0,2,2,&joseki_variations[4383],NULL},
  {871,3,1,3,&joseki_variations[4374],NULL},
  {833,3,1,1,&joseki_variations[4367],NULL},
  {796,0,1,1,&joseki_variations[4349],NULL},
  {833,3,2,1,&joseki_variations[4350],NULL},
  {834,0,3,1,&joseki_variations[4351],NULL},
  {835,0,5,2,&joseki_variations[4352],NULL},
  {871,3,4,1,&joseki_variations[4363],NULL},
  {870,3,3,1,&joseki_variations[4354],NULL},
  {871,3,5,1,&joseki_variations[4355],NULL},
  {872,3,8,2,&joseki_variations[4356],NULL},
  {873,0,9,1,&joseki_variations[4361],NULL},
  {836,0,6,1,&joseki_variations[4358],NULL},
  {873,0,10,1,&joseki_variations[4359],NULL},
  {910,3,11,1,&joseki_variations[4360],NULL},
  {911,3,12,0,NULL,&joseki[1530]},
  {910,3,10,1,&joseki_variations[4362],NULL},
  {836,0,6,0,NULL,&joseki[1529]},
  {872,3,7,1,&joseki_variations[4364],NULL},
  {873,0,8,1,&joseki_variations[4365],NULL},
  {910,3,9,1,&joseki_variations[4366],NULL},
  {870,3,3,0,NULL,&joseki[1528]},
  {834,0,2,1,&joseki_variations[4368],NULL},
  {835,0,4,1,&joseki_variations[4369],NULL},
  {871,3,3,1,&joseki_variations[4370],NULL},
  {872,3,6,1,&joseki_variations[4371],NULL},
  {873,0,7,1,&joseki_variations[4372],NULL},
  {910,3,8,1,&joseki_variations[4373],NULL},
  {796,0,1,0,NULL,&joseki[1527]},
  {945,0,2,1,&joseki_variations[4382],&joseki[1490]},
  {797,0,1,0,NULL,&joseki[1517]},
  {835,0,2,1,&joseki_variations[4377],&joseki[1519]},
  {872,3,4,2,&joseki_variations[4378],&joseki[1520]},
  {834,0,1,0,NULL,&joseki[1521]},
  {873,0,5,1,&joseki_variations[4380],&joseki[1523]},
  {910,3,6,1,&joseki_variations[4381],&joseki[1524]},
  {834,0,1,0,NULL,&joseki[1525]},
  {760,3,1,0,NULL,&joseki[1491]},
  {833,3,1,1,&joseki_variations[4412],NULL},
  {832,3,1,1,&joseki_variations[4385],NULL},
  {833,3,2,1,&joseki_variations[4386],NULL},
  {834,3,3,1,&joseki_variations[4387],NULL},
  {835,0,5,2,&joseki_variations[4388],NULL},
  {870,0,3,1,&joseki_variations[4403],NULL},
  {869,0,2,1,&joseki_variations[4390],NULL},
  {870,0,4,1,&joseki_variations[4391],NULL},
  {871,0,6,1,&joseki_variations[4392],NULL},
  {872,3,9,1,&joseki_variations[4393],NULL},
  {906,0,3,1,&joseki_variations[4394],NULL},
  {908,0,8,1,&joseki_variations[4395],NULL},
  {909,3,12,1,&joseki_variations[4396],NULL},
  {944,0,6,1,&joseki_variations[4397],NULL},
  {945,3,10,2,&joseki_variations[4398],NULL},
  {982,3,11,1,&joseki_variations[4402],NULL},
  {981,3,7,1,&joseki_variations[4400],NULL},
  {982,3,12,1,&joseki_variations[4401],NULL},
  {797,0,1,0,NULL,&joseki[1484]},
  {981,3,7,0,NULL,&joseki[1483]},
  {871,0,5,1,&joseki_variations[4404],NULL},
  {872,3,8,1,&joseki_variations[4405],NULL},
  {906,0,2,1,&joseki_variations[4406],NULL},
  {908,0,7,1,&joseki_variations[4407],NULL},
  {909,3,11,1,&joseki_variations[4408],NULL},
  {944,0,5,1,&joseki_variations[4409],NULL},
  {945,3,9,1,&joseki_variations[4410],NULL},
  {982,3,10,1,&joseki_variations[4411],NULL},
  {869,0,2,0,NULL,&joseki[1482]},
  {834,3,2,1,&joseki_variations[4413],NULL},
  {835,0,4,1,&joseki_variations[4414],NULL},
  {870,0,2,1,&joseki_variations[4415],NULL},
  {871,0,4,1,&joseki_variations[4416],NULL},
  {872,3,7,2,&joseki_variations[4417],NULL},
  {907,3,3,1,&joseki_variations[4425],NULL},
  {906,0,1,1,&joseki_variations[4419],NULL},
  {908,0,6,1,&joseki_variations[4420],NULL},
  {909,3,10,1,&joseki_variations[4421],NULL},
  {944,0,4,1,&joseki_variations[4422],NULL},
  {945,3,8,1,&joseki_variations[4423],NULL},
  {982,3,9,1,&joseki_variations[4424],NULL},
  {832,3,1,0,NULL,&joseki[1481]},
  {908,0,6,1,&joseki_variations[4426],NULL},
  {909,3,10,1,&joseki_variations[4427],NULL},
  {944,0,4,1,&joseki_variations[4428],NULL},
  {945,3,8,1,&joseki_variations[4429],NULL},
  {982,3,9,1,&joseki_variations[4430],NULL},
  {906,0,1,0,NULL,&joseki[1480]},
  {797,0,2,1,&joseki_variations[4432],NULL},
  {800,0,4,1,&joseki_variations[4433],NULL},
  {834,3,3,1,&joseki_variations[4434],NULL},
  {836,3,5,1,&joseki_variations[4435],NULL},
  {908,0,4,1,&joseki_variations[4436],NULL},
  {946,3,6,1,&joseki_variations[4437],NULL},
  {759,0,1,0,NULL,&joseki[1389]},
  {834,0,1,0,NULL,&joseki[1082]},
  {800,0,2,3,&joseki_variations[4496],&joseki[1224]},
  {836,0,3,2,&joseki_variations[4488],&joseki[1236]},
  {799,0,2,1,&joseki_variations[4484],NULL},
  {872,0,3,1,&joseki_variations[4479],NULL},
  {946,0,3,3,&joseki_variations[4461],&joseki[1250]},
  {763,0,2,1,&joseki_variations[4460],&joseki[1300]},
  {760,3,1,0,NULL,&joseki[1555]},
  {762,3,2,1,&joseki_variations[4459],&joseki[1561]},
  {725,0,1,1,&joseki_variations[4451],NULL},
  {800,3,2,2,&joseki_variations[4449],&joseki[1570]},
  {834,0,1,0,NULL,&joseki[1571]},
  {760,3,1,0,NULL,&joseki[1621]},
  {762,3,3,1,&joseki_variations[4452],NULL},
  {799,3,4,2,&joseki_variations[4453],&joseki[1563]},
  {763,0,4,1,&joseki_variations[4458],&joseki[1564]},
  {726,3,2,1,&joseki_variations[4455],NULL},
  {763,0,5,1,&joseki_variations[4456],NULL},
  {727,0,3,1,&joseki_variations[4457],&joseki[1566]},
  {724,3,1,0,NULL,&joseki[1567]},
  {726,3,2,0,NULL,&joseki[1565]},
  {725,0,1,0,NULL,&joseki[1562]},
  {760,3,1,0,NULL,&joseki[1301]},
  {837,3,3,2,&joseki_variations[4474],&joseki[1251]},
  {763,0,2,1,&joseki_variations[4468],NULL},
  {801,3,2,1,&joseki_variations[4464],&joseki[1260]},
  {836,0,3,1,&joseki_variations[4465],&joseki[1261]},
  {873,3,4,1,&joseki_variations[4466],&joseki[1262]},
  {837,0,4,1,&joseki_variations[4467],&joseki[1263]},
  {798,3,2,0,NULL,&joseki[1264]},
  {837,3,4,2,&joseki_variations[4469],NULL},
  {839,3,5,1,&joseki_variations[4473],&joseki[1253]},
  {765,0,3,1,&joseki_variations[4471],NULL},
  {839,3,6,1,&joseki_variations[4472],NULL},
  {1057,3,4,0,NULL,&joseki[1255]},
  {765,0,3,0,NULL,&joseki[1254]},
  {763,0,2,0,NULL,&joseki[1252]},
  {764,0,2,1,&joseki_variations[4476],&joseki[1256]},
  {839,3,5,1,&joseki_variations[4477],&joseki[1257]},
  {803,0,3,1,&joseki_variations[4478],&joseki[1258]},
  {1057,3,4,0,NULL,&joseki[1259]},
  {799,3,2,1,&joseki_variations[4480],NULL},
  {836,0,4,1,&joseki_variations[4481],NULL},
  {873,3,6,1,&joseki_variations[4482],NULL},
  {837,0,5,1,&joseki_variations[4483],NULL},
  {798,3,2,0,NULL,&joseki[1246]},
  {836,0,4,1,&joseki_variations[4485],NULL},
  {873,3,5,1,&joseki_variations[4486],NULL},
  {909,3,3,1,&joseki_variations[4487],&joseki[1239]},
  {834,0,1,0,NULL,&joseki[1240]},
  {873,3,4,2,&joseki_variations[4492],&joseki[1237]},
  {872,0,3,1,&joseki_variations[4490],NULL},
  {873,3,5,1,&joseki_variations[4491],NULL},
  {799,3,2,0,NULL,&joseki[1245]},
  {799,0,2,0,NULL,&joseki[1238]},
  {837,0,4,1,&joseki_variations[4494],NULL},
  {909,3,3,1,&joseki_variations[4495],&joseki[1242]},
  {798,0,2,0,NULL,&joseki[1243]},
  {760,3,1,0,NULL,&joseki[1225]},
  {945,3,1,0,NULL,&joseki[1234]},
  {874,3,4,0,NULL,&joseki[1235]},
  {872,3,3,4,&joseki_variations[4597],NULL},
  {800,0,3,1,&joseki_variations[4595],NULL},
  {835,3,3,5,&joseki_variations[4502],NULL},
  {799,0,3,1,&joseki_variations[4594],NULL},
  {872,0,4,2,&joseki_variations[4554],NULL},
  {799,3,3,1,&joseki_variations[4543],NULL},
  {946,0,4,3,&joseki_variations[4522],NULL},
  {871,3,1,1,&joseki_variations[4507],NULL},
  {872,0,5,1,&joseki_variations[4508],NULL},
  {946,0,6,1,&joseki_variations[4509],NULL},
  {725,3,1,1,&joseki_variations[4510],NULL},
  {762,3,3,1,&joseki_variations[4511],NULL},
  {799,3,5,1,&joseki_variations[4512],NULL},
  {836,0,7,1,&joseki_variations[4513],NULL},
  {873,3,10,1,&joseki_variations[4514],NULL},
  {726,3,2,1,&joseki_variations[4515],NULL},
  {763,0,5,1,&joseki_variations[4516],NULL},
  {800,0,8,1,&joseki_variations[4517],NULL},
  {837,0,11,1,&joseki_variations[4518],NULL},
  {727,0,3,1,&joseki_variations[4519],NULL},
  {764,0,7,1,&joseki_variations[4520],NULL},
  {801,3,11,1,&joseki_variations[4521],NULL},
  {909,0,6,0,NULL,&joseki[1299]},
  {801,3,3,1,&joseki_variations[4538],NULL},
  {799,0,3,1,&joseki_variations[4533],NULL},
  {762,3,2,1,&joseki_variations[4525],NULL},
  {799,3,4,1,&joseki_variations[4526],NULL},
  {836,0,6,1,&joseki_variations[4527],NULL},
  {873,3,7,1,&joseki_variations[4528],NULL},
  {763,0,3,1,&joseki_variations[4529],NULL},
  {800,0,6,1,&joseki_variations[4530],NULL},
  {837,0,9,1,&joseki_variations[4531],NULL},
  {801,3,7,1,&joseki_variations[4532],NULL},
  {872,0,4,0,NULL,&joseki[1293]},
  {801,3,4,1,&joseki_variations[4534],NULL},
  {836,0,5,1,&joseki_variations[4535],NULL},
  {873,3,6,1,&joseki_variations[4536],NULL},
  {837,0,6,1,&joseki_variations[4537],NULL},
  {760,3,1,0,NULL,&joseki[1266]},
  {836,0,4,1,&joseki_variations[4539],NULL},
  {873,3,5,1,&joseki_variations[4540],NULL},
  {837,0,5,2,&joseki_variations[4541],NULL},
  {799,0,3,0,NULL,&joseki[1265]},
  {763,0,2,0,NULL,&joseki[1271]},
  {836,0,5,1,&joseki_variations[4544],NULL},
  {837,0,6,1,&joseki_variations[4545],NULL},
  {871,3,1,1,&joseki_variations[4546],NULL},
  {872,0,5,2,&joseki_variations[4547],NULL},
  {874,0,9,1,&joseki_variations[4552],NULL},
  {873,3,8,1,&joseki_variations[4549],NULL},
  {909,0,6,1,&joseki_variations[4550],NULL},
  {910,0,10,1,&joseki_variations[4551],NULL},
  {800,3,4,0,NULL,&joseki[1249]},
  {910,0,8,1,&joseki_variations[4553],NULL},
  {908,3,2,0,NULL,&joseki[1248]},
  {799,3,3,1,&joseki_variations[4589],NULL},
  {946,0,5,2,&joseki_variations[4556],NULL},
  {762,3,2,1,&joseki_variations[4572],NULL},
  {725,3,1,1,&joseki_variations[4558],NULL},
  {762,3,3,1,&joseki_variations[4559],NULL},
  {799,3,5,1,&joseki_variations[4560],NULL},
  {836,0,7,1,&joseki_variations[4561],NULL},
  {873,3,9,1,&joseki_variations[4562],NULL},
  {726,3,2,1,&joseki_variations[4563],NULL},
  {763,0,5,1,&joseki_variations[4564],NULL},
  {800,0,8,1,&joseki_variations[4565],NULL},
  {837,0,11,1,&joseki_variations[4566],NULL},
  {727,0,3,2,&joseki_variations[4567],NULL},
  {801,3,10,1,&joseki_variations[4571],NULL},
  {764,0,7,1,&joseki_variations[4569],NULL},
  {801,3,11,1,&joseki_variations[4570],NULL},
  {871,3,1,0,NULL,&joseki[1298]},
  {764,0,7,0,NULL,&joseki[1297]},
  {799,3,4,1,&joseki_variations[4573],NULL},
  {836,0,6,1,&joseki_variations[4574],NULL},
  {873,3,8,2,&joseki_variations[4575],NULL},
  {763,0,3,1,&joseki_variations[4585],NULL},
  {726,3,1,1,&joseki_variations[4577],NULL},
  {763,0,4,1,&joseki_variations[4578],NULL},
  {800,0,7,1,&joseki_variations[4579],NULL},
  {837,0,10,2,&joseki_variations[4580],NULL},
  {801,3,8,1,&joseki_variations[4584],NULL},
  {727,0,2,1,&joseki_variations[4582],NULL},
  {801,3,9,1,&joseki_variations[4583],NULL},
  {725,3,1,0,NULL,&joseki[1296]},
  {727,0,2,0,NULL,&joseki[1295]},
  {800,0,6,1,&joseki_variations[4586],NULL},
  {837,0,9,1,&joseki_variations[4587],NULL},
  {801,3,7,1,&joseki_variations[4588],NULL},
  {726,3,1,0,NULL,&joseki[1294]},
  {836,0,5,1,&joseki_variations[4590],NULL},
  {873,3,7,1,&joseki_variations[4591],NULL},
  {910,0,8,1,&joseki_variations[4592],NULL},
  {837,0,6,1,&joseki_variations[4593],NULL},
  {871,3,1,0,NULL,&joseki[1247]},
  {760,3,1,0,NULL,&joseki[995]},
  {871,3,1,1,&joseki_variations[4596],NULL},
  {760,3,1,0,NULL,&joseki[928]},
  {800,0,3,1,&joseki_variations[4613],NULL},
  {801,0,3,2,&joseki_variations[4611],NULL},
  {762,3,2,2,&joseki_variations[4606],NULL},
  {725,3,1,1,&joseki_variations[4601],NULL},
  {762,3,3,1,&joseki_variations[4602],NULL},
  {799,0,5,1,&joseki_variations[4603],NULL},
  {801,0,6,2,&joseki_variations[4604],NULL},
  {724,0,1,0,NULL,&joseki[1048]},
  {797,0,1,0,NULL,&joseki[1069]},
  {801,0,4,1,&joseki_variations[4610],NULL},
  {799,0,4,1,&joseki_variations[4608],NULL},
  {801,0,5,1,&joseki_variations[4609],NULL},
  {725,3,1,0,NULL,&joseki[1047]},
  {799,0,4,0,NULL,&joseki[1046]},
  {760,3,1,0,NULL,&joseki[999]},
  {762,3,2,0,NULL,&joseki[1045]},
  {760,3,1,0,NULL,&joseki[902]},
  {798,3,2,1,&joseki_variations[4615],NULL},
  {804,3,4,1,&joseki_variations[4616],NULL},
  {762,3,2,0,NULL,&joseki[867]},
  {798,3,2,5,&joseki_variations[4618],NULL},
  {872,3,3,1,&joseki_variations[4651],NULL},
  {800,3,4,1,&joseki_variations[4647],NULL},
  {871,3,1,1,&joseki_variations[4646],NULL},
  {801,3,4,1,&joseki_variations[4636],NULL},
  {835,3,3,1,&joseki_variations[4623],NULL},
  {946,0,4,1,&joseki_variations[4624],NULL},
  {799,3,3,2,&joseki_variations[4625],NULL},
  {801,3,5,1,&joseki_variations[4632],NULL},
  {836,0,5,1,&joseki_variations[4627],NULL},
  {873,3,6,1,&joseki_variations[4628],NULL},
  {800,0,5,1,&joseki_variations[4629],NULL},
  {837,0,8,1,&joseki_variations[4630],NULL},
  {801,3,6,1,&joseki_variations[4631],NULL},
  {762,3,2,0,NULL,&joseki[1292]},
  {836,0,5,1,&joseki_variations[4633],NULL},
  {873,3,6,1,&joseki_variations[4634],NULL},
  {837,0,7,1,&joseki_variations[4635],NULL},
  {800,0,5,0,NULL,&joseki[1291]},
  {835,3,3,1,&joseki_variations[4637],NULL},
  {946,0,4,1,&joseki_variations[4638],NULL},
  {836,0,4,1,&joseki_variations[4639],NULL},
  {873,3,5,1,&joseki_variations[4640],NULL},
  {837,0,6,3,&joseki_variations[4641],NULL},
  {760,3,1,0,NULL,&joseki[1272]},
  {874,3,8,1,&joseki_variations[4644],&joseki[1280]},
  {799,3,3,0,NULL,&joseki[1290]},
  {838,0,8,1,&joseki_variations[4645],&joseki[1281]},
  {760,3,1,0,NULL,&joseki[1282]},
  {760,3,1,0,NULL,&joseki[710]},
  {837,3,5,1,&joseki_variations[4648],NULL},
  {801,0,5,2,&joseki_variations[4649],NULL},
  {762,3,2,0,NULL,&joseki[570]},
  {760,3,1,0,NULL,&joseki[578]},
  {760,3,1,0,NULL,&joseki[295]},
  {836,3,3,1,&joseki_variations[4653],NULL},
  {760,0,1,0,NULL,&joseki[89]},
  {762,3,3,5,&joseki_variations[4655],NULL},
  {836,3,4,1,&joseki_variations[4690],NULL},
  {799,3,4,1,&joseki_variations[4684],NULL},
  {797,0,1,1,&joseki_variations[4679],NULL},
  {763,0,4,1,&joseki_variations[4666],NULL},
  {764,3,4,1,&joseki_variations[4660],NULL},
  {798,3,2,2,&joseki_variations[4661],NULL},
  {804,3,6,1,&joseki_variations[4665],NULL},
  {799,3,5,1,&joseki_variations[4663],NULL},
  {804,3,7,1,&joseki_variations[4664],NULL},
  {724,0,1,0,NULL,&joseki[870]},
  {799,3,5,0,NULL,&joseki[869]},
  {798,3,2,2,&joseki_variations[4667],NULL},
  {800,3,6,1,&joseki_variations[4676],NULL},
  {799,3,5,1,&joseki_variations[4669],NULL},
  {800,3,7,1,&joseki_variations[4670],NULL},
  {837,3,8,2,&joseki_variations[4671],NULL},
  {801,0,8,1,&joseki_variations[4675],NULL},
  {727,0,2,1,&joseki_variations[4673],NULL},
  {801,0,9,1,&joseki_variations[4674],NULL},
  {760,3,1,0,NULL,&joseki[574]},
  {727,0,2,0,NULL,&joseki[573]},
  {837,3,7,1,&joseki_variations[4677],NULL},
  {801,0,7,1,&joseki_variations[4678],NULL},
  {799,3,5,0,NULL,&joseki[572]},
  {799,3,5,1,&joseki_variations[4680],NULL},
  {834,3,2,1,&joseki_variations[4681],NULL},
  {836,3,7,1,&joseki_variations[4682],NULL},
  {726,0,2,1,&joseki_variations[4683],NULL},
  {833,3,1,0,NULL,&joseki[83]},
  {836,3,5,2,&joseki_variations[4685],NULL},
  {726,0,2,1,&joseki_variations[4689],&joseki[80]},
  {763,0,4,2,&joseki_variations[4687],&joseki[84]},
  {726,3,2,0,NULL,&joseki[85]},
  {724,3,1,0,NULL,&joseki[86]},
  {834,3,1,0,NULL,&joseki[81]},
  {799,3,4,0,NULL,&joseki[79]},
  {762,3,2,0,NULL,&joseki[77]},
  {797,3,1,0,NULL,&joseki[88]},
  {726,0,1,1,&joseki_variations[4703],NULL},
  {763,0,3,1,&joseki_variations[4695],NULL},
  {798,3,2,1,&joseki_variations[4696],NULL},
  {835,3,3,1,&joseki_variations[4697],NULL},
  {799,0,4,1,&joseki_variations[4698],NULL},
  {836,3,6,1,&joseki_variations[4699],NULL},
  {800,3,6,1,&joseki_variations[4700],NULL},
  {837,3,9,1,&joseki_variations[4701],NULL},
  {801,0,7,1,&joseki_variations[4702],NULL},
  {760,3,1,0,NULL,&joseki[683]},
  {763,3,4,1,&joseki_variations[4704],NULL},
  {727,0,2,1,&joseki_variations[4705],NULL},
  {764,3,6,1,&joseki_variations[4706],NULL},
  {765,3,7,1,&joseki_variations[4707],NULL},
  {796,0,1,1,&joseki_variations[4708],NULL},
  {798,0,3,1,&joseki_variations[4709],NULL},
  {799,3,5,1,&joseki_variations[4710],NULL},
  {833,0,2,1,&joseki_variations[4711],NULL},
  {834,3,3,1,&joseki_variations[4712],NULL},
  {835,3,6,1,&joseki_variations[4713],NULL},
  {836,3,9,1,&joseki_variations[4714],NULL},
  {908,3,4,0,NULL,&joseki[60]},
  {796,0,1,1,&joseki_variations[4740],NULL},
  {836,3,3,1,&joseki_variations[4739],NULL},
  {763,0,3,1,&joseki_variations[4734],NULL},
  {763,3,3,1,&joseki_variations[4723],NULL},
  {764,3,3,1,&joseki_variations[4720],NULL},
  {798,3,2,1,&joseki_variations[4721],NULL},
  {804,3,5,1,&joseki_variations[4722],NULL},
  {725,0,1,0,NULL,&joseki[868]},
  {796,3,1,1,&joseki_variations[4724],NULL},
  {798,0,3,1,&joseki_variations[4725],NULL},
  {799,3,5,1,&joseki_variations[4726],NULL},
  {800,0,7,1,&joseki_variations[4727],NULL},
  {834,3,2,1,&joseki_variations[4728],NULL},
  {835,3,5,1,&joseki_variations[4729],NULL},
  {836,0,8,1,&joseki_variations[4730],NULL},
  {870,0,2,1,&joseki_variations[4731],NULL},
  {871,0,4,1,&joseki_variations[4732],NULL},
  {872,0,8,1,&joseki_variations[4733],NULL},
  {760,3,1,0,NULL,&joseki[696]},
  {798,3,2,1,&joseki_variations[4735],NULL},
  {800,3,5,1,&joseki_variations[4736],NULL},
  {837,3,6,1,&joseki_variations[4737],NULL},
  {801,0,6,1,&joseki_variations[4738],NULL},
  {725,0,1,0,NULL,&joseki[571]},
  {725,0,1,0,NULL,&joseki[78]},
  {798,0,3,1,&joseki_variations[4741],NULL},
  {835,0,4,1,&joseki_variations[4742],NULL},
  {799,3,5,1,&joseki_variations[4743],NULL},
  {836,3,7,1,&joseki_variations[4744],NULL},
  {870,0,2,1,&joseki_variations[4745],NULL},
  {871,0,3,1,&joseki_variations[4746],NULL},
  {872,3,7,1,&joseki_variations[4747],NULL},
  {907,3,3,1,&joseki_variations[4748],NULL},
  {908,3,5,1,&joseki_variations[4749],NULL},
  {909,3,10,0,NULL,&joseki[32]},
  {799,3,3,1,&joseki_variations[4962],NULL},
  {762,3,2,2,&joseki_variations[4827],NULL},
  {762,0,2,1,&joseki_variations[4786],NULL},
  {725,0,1,1,&joseki_variations[4760],NULL},
  {835,3,3,1,&joseki_variations[4755],NULL},
  {909,3,4,1,&joseki_variations[4756],NULL},
  {836,0,4,1,&joseki_variations[4757],NULL},
  {873,3,5,1,&joseki_variations[4758],NULL},
  {837,0,5,1,&joseki_variations[4759],NULL},
  {834,3,1,0,NULL,&joseki[1244]},
  {762,3,3,1,&joseki_variations[4761],NULL},
  {799,3,5,2,&joseki_variations[4762],NULL},
  {836,0,6,1,&joseki_variations[4767],NULL},
  {835,3,3,1,&joseki_variations[4764],NULL},
  {836,0,7,1,&joseki_variations[4765],NULL},
  {726,3,2,1,&joseki_variations[4766],NULL},
  {724,0,1,0,NULL,&joseki[959]},
  {726,3,2,1,&joseki_variations[4768],NULL},
  {763,3,5,1,&joseki_variations[4769],NULL},
  {800,0,8,1,&joseki_variations[4770],NULL},
  {837,0,10,2,&joseki_variations[4771],NULL},
  {727,0,3,1,&joseki_variations[4779],NULL},
  {690,3,1,1,&joseki_variations[4773],NULL},
  {801,3,10,1,&joseki_variations[4774],NULL},
  {838,0,13,1,&joseki_variations[4775],NULL},
  {728,3,4,1,&joseki_variations[4776],NULL},
  {765,3,8,1,&joseki_variations[4777],NULL},
  {802,3,13,1,&joseki_variations[4778],NULL},
  {871,0,1,0,NULL,&joseki[666]},
  {764,0,7,1,&joseki_variations[4780],NULL},
  {801,3,11,1,&joseki_variations[4781],NULL},
  {838,0,14,1,&joseki_variations[4782],NULL},
  {728,3,4,1,&joseki_variations[4783],NULL},
  {765,3,9,1,&joseki_variations[4784],NULL},
  {802,3,14,1,&joseki_variations[4785],NULL},
  {690,3,1,0,NULL,&joseki[665]},
  {799,3,4,4,&joseki_variations[4787],NULL},
  {836,3,5,1,&joseki_variations[4820],NULL},
  {835,3,3,1,&joseki_variations[4803],NULL},
  {726,0,1,1,&joseki_variations[4795],NULL},
  {833,0,1,1,&joseki_variations[4791],NULL},
  {834,3,2,1,&joseki_variations[4792],NULL},
  {835,3,5,1,&joseki_variations[4793],NULL},
  {836,3,8,1,&joseki_variations[4794],NULL},
  {796,0,1,0,NULL,&joseki[59]},
  {763,3,4,1,&joseki_variations[4796],NULL},
  {727,0,2,1,&joseki_variations[4797],NULL},
  {764,3,6,1,&joseki_variations[4798],NULL},
  {765,3,7,1,&joseki_variations[4799],NULL},
  {833,0,1,1,&joseki_variations[4800],NULL},
  {835,3,4,1,&joseki_variations[4801],NULL},
  {836,3,7,1,&joseki_variations[4802],NULL},
  {834,3,2,0,NULL,&joseki[58]},
  {836,3,6,2,&joseki_variations[4804],NULL},
  {763,3,3,2,&joseki_variations[4813],NULL},
  {726,0,1,1,&joseki_variations[4806],NULL},
  {763,3,4,2,&joseki_variations[4807],NULL},
  {764,3,5,1,&joseki_variations[4812],&joseki[54]},
  {727,0,2,1,&joseki_variations[4809],NULL},
  {764,3,6,1,&joseki_variations[4810],NULL},
  {765,3,7,1,&joseki_variations[4811],&joseki[56]},
  {833,0,1,0,NULL,&joseki[57]},
  {727,0,2,0,NULL,&joseki[55]},
  {726,0,1,0,NULL,&joseki[53]},
  {872,0,4,1,&joseki_variations[4815],NULL},
  {873,3,8,1,&joseki_variations[4816],NULL},
  {910,0,9,1,&joseki_variations[4817],NULL},
  {800,0,6,1,&joseki_variations[4818],NULL},
  {764,3,4,1,&joseki_variations[4819],NULL},
  {834,0,1,0,NULL,&joseki[676]},
  {763,3,3,2,&joseki_variations[4821],NULL},
  {835,3,3,0,NULL,&joseki[52]},
  {800,0,6,1,&joseki_variations[4823],NULL},
  {764,3,4,1,&joseki_variations[4824],NULL},
  {872,0,3,1,&joseki_variations[4825],&joseki[674]},
  {873,3,7,1,&joseki_variations[4826],NULL},
  {910,0,8,0,NULL,&joseki[675]},
  {799,3,4,8,&joseki_variations[4850],NULL},
  {763,3,3,1,&joseki_variations[4829],NULL},
  {800,0,5,1,&joseki_variations[4830],NULL},
  {837,0,6,2,&joseki_variations[4831],NULL},
  {801,3,6,8,&joseki_variations[4835],NULL},
  {872,0,3,1,&joseki_variations[4833],NULL},
  {1020,0,4,1,&joseki_variations[4834],NULL},
  {1019,0,1,0,NULL,&joseki[355]},
  {767,3,4,1,&joseki_variations[4849],&joseki[349]},
  {765,3,4,2,&joseki_variations[4847],&joseki[351]},
  {799,3,4,0,NULL,&joseki[357]},
  {724,3,1,0,NULL,&joseki[515]},
  {871,3,1,1,&joseki_variations[4846],&joseki[560]},
  {767,0,4,1,&joseki_variations[4845],NULL},
  {804,0,7,1,&joseki_variations[4844],NULL},
  {838,3,8,1,&joseki_variations[4843],NULL},
  {872,0,3,0,NULL,&joseki[568]},
  {765,3,4,0,NULL,&joseki[567]},
  {765,3,4,0,NULL,&joseki[566]},
  {834,0,1,0,NULL,&joseki[561]},
  {872,0,3,0,NULL,&joseki[352]},
  {727,0,1,0,NULL,&joseki[356]},
  {872,0,3,0,NULL,&joseki[350]},
  {836,3,5,3,&joseki_variations[4952],NULL},
  {835,0,3,1,&joseki_variations[4937],NULL},
  {834,3,1,2,&joseki_variations[4922],NULL},
  {833,0,1,1,&joseki_variations[4910],NULL},
  {872,0,3,1,&joseki_variations[4904],NULL},
  {763,3,3,1,&joseki_variations[4877],NULL},
  {836,0,5,3,&joseki_variations[4860],&joseki[957]},
  {835,3,3,1,&joseki_variations[4858],NULL},
  {836,0,6,1,&joseki_variations[4859],NULL},
  {725,0,1,0,NULL,&joseki[958]},
  {726,3,1,1,&joseki_variations[4866],NULL},
  {763,3,3,1,&joseki_variations[4864],NULL},
  {837,3,6,1,&joseki_variations[4863],NULL},
  {873,0,6,0,NULL,&joseki[960]},
  {800,0,6,1,&joseki_variations[4865],NULL},
  {835,3,3,0,NULL,&joseki[693]},
  {763,3,4,1,&joseki_variations[4867],NULL},
  {800,0,7,1,&joseki_variations[4868],NULL},
  {837,0,9,1,&joseki_variations[4869],NULL},
  {727,0,2,1,&joseki_variations[4870],NULL},
  {764,0,6,1,&joseki_variations[4871],NULL},
  {801,3,10,1,&joseki_variations[4872],NULL},
  {838,0,13,1,&joseki_variations[4873],NULL},
  {728,3,3,1,&joseki_variations[4874],NULL},
  {765,3,8,1,&joseki_variations[4875],NULL},
  {802,3,13,1,&joseki_variations[4876],NULL},
  {725,0,1,0,NULL,&joseki[664]},
  {800,0,6,4,&joseki_variations[4878],NULL},
  {837,0,7,1,&joseki_variations[4902],NULL},
  {801,3,7,2,&joseki_variations[4894],NULL},
  {836,0,5,1,&joseki_variations[4885],NULL},
  {835,3,3,1,&joseki_variations[4882],NULL},
  {836,0,6,1,&joseki_variations[4883],NULL},
  {872,0,4,1,&joseki_variations[4884],NULL},
  {834,3,1,0,NULL,&joseki[694]},
  {837,0,8,1,&joseki_variations[4886],NULL},
  {727,0,1,1,&joseki_variations[4887],NULL},
  {764,0,5,1,&joseki_variations[4888],NULL},
  {801,3,9,1,&joseki_variations[4889],NULL},
  {838,0,12,1,&joseki_variations[4890],NULL},
  {728,3,2,1,&joseki_variations[4891],NULL},
  {765,3,7,1,&joseki_variations[4892],NULL},
  {802,3,12,1,&joseki_variations[4893],NULL},
  {726,3,1,0,NULL,&joseki[663]},
  {836,0,5,1,&joseki_variations[4900],NULL},
  {835,3,3,1,&joseki_variations[4896],NULL},
  {836,0,6,1,&joseki_variations[4897],NULL},
  {837,0,9,1,&joseki_variations[4898],NULL},
  {872,0,4,1,&joseki_variations[4899],&joseki[360]},
  {834,3,1,0,NULL,&joseki[361]},
  {837,0,8,1,&joseki_variations[4901],NULL},
  {835,3,3,0,NULL,&joseki[359]},
  {801,3,7,1,&joseki_variations[4903],NULL},
  {836,0,5,0,NULL,&joseki[358]},
  {763,3,3,1,&joseki_variations[4905],NULL},
  {800,0,6,1,&joseki_variations[4906],NULL},
  {837,0,7,1,&joseki_variations[4907],NULL},
  {801,3,7,1,&joseki_variations[4908],NULL},
  {765,3,4,1,&joseki_variations[4909],NULL},
  {836,0,5,0,NULL,&joseki[353]},
  {834,3,2,1,&joseki_variations[4911],NULL},
  {835,0,5,1,&joseki_variations[4912],NULL},
  {836,3,8,2,&joseki_variations[4913],NULL},
  {871,0,3,1,&joseki_variations[4919],NULL},
  {870,0,2,1,&joseki_variations[4915],NULL},
  {871,0,4,1,&joseki_variations[4916],NULL},
  {872,3,8,1,&joseki_variations[4917],NULL},
  {908,3,5,1,&joseki_variations[4918],NULL},
  {909,3,10,0,NULL,&joseki[40]},
  {872,3,7,1,&joseki_variations[4920],NULL},
  {908,3,4,1,&joseki_variations[4921],&joseki[38]},
  {870,0,2,0,NULL,&joseki[39]},
  {836,3,6,1,&joseki_variations[4935],NULL},
  {835,0,4,1,&joseki_variations[4924],NULL},
  {836,3,7,1,&joseki_variations[4925],NULL},
  {871,0,2,1,&joseki_variations[4926],NULL},
  {872,3,6,3,&joseki_variations[4927],&joseki[36]},
  {833,0,1,0,NULL,&joseki[37]},
  {909,0,7,1,&joseki_variations[4933],&joseki[41]},
  {873,3,10,1,&joseki_variations[4930],NULL},
  {908,0,3,1,&joseki_variations[4931],NULL},
  {909,0,8,1,&joseki_variations[4932],NULL},
  {724,3,1,0,NULL,&joseki[44]},
  {873,3,10,1,&joseki_variations[4934],&joseki[42]},
  {908,0,3,0,NULL,&joseki[43]},
  {871,0,2,1,&joseki_variations[4936],NULL},
  {835,0,4,0,NULL,&joseki[35]},
  {836,3,6,3,&joseki_variations[4938],NULL},
  {872,3,4,1,&joseki_variations[4951],&joseki[26]},
  {871,0,1,1,&joseki_variations[4948],NULL},
  {870,0,1,1,&joseki_variations[4941],NULL},
  {871,0,2,1,&joseki_variations[4942],NULL},
  {872,3,6,2,&joseki_variations[4943],NULL},
  {908,3,3,1,&joseki_variations[4947],NULL},
  {907,3,2,1,&joseki_variations[4945],NULL},
  {908,3,4,1,&joseki_variations[4946],NULL},
  {796,0,1,0,NULL,&joseki[31]},
  {907,3,2,0,NULL,&joseki[30]},
  {872,3,5,1,&joseki_variations[4949],NULL},
  {908,3,2,1,&joseki_variations[4950],&joseki[28]},
  {870,0,1,0,NULL,&joseki[29]},
  {871,0,1,0,NULL,&joseki[27]},
  {835,0,3,0,NULL,&joseki[25]},
  {871,0,1,1,&joseki_variations[4961],&joseki[33]},
  {872,0,3,1,&joseki_variations[4955],NULL},
  {763,3,3,1,&joseki_variations[4956],NULL},
  {800,0,6,1,&joseki_variations[4957],NULL},
  {837,0,8,1,&joseki_variations[4958],NULL},
  {801,3,7,1,&joseki_variations[4959],NULL},
  {765,3,4,1,&joseki_variations[4960],NULL},
  {835,0,3,0,NULL,&joseki[354]},
  {834,3,1,0,NULL,&joseki[34]},
  {836,3,4,1,&joseki_variations[4963],NULL},
  {762,3,2,0,NULL,&joseki[24]},
  {836,3,2,2,&joseki_variations[5402],NULL},
  {799,3,2,3,&joseki_variations[5394],NULL},
  {762,0,1,5,&joseki_variations[5208],NULL},
  {834,0,1,2,&joseki_variations[5196],NULL},
  {763,3,1,3,&joseki_variations[5085],NULL},
  {762,3,1,2,&joseki_variations[5045],NULL},
  {725,3,1,3,&joseki_variations[5010],NULL},
  {764,3,1,1,&joseki_variations[5001],NULL},
  {764,0,1,2,&joseki_variations[4992],NULL},
  {800,3,2,3,&joseki_variations[4979],NULL},
  {801,3,2,1,&joseki_variations[4975],&joseki[996]},
  {872,0,2,2,&joseki_variations[4976],&joseki[997]},
  {761,3,1,0,NULL,&joseki[998]},
  {768,3,1,1,&joseki_variations[4978],&joseki[1080]},
  {1019,0,1,0,NULL,&joseki[1081]},
  {872,0,2,3,&joseki_variations[4989],&joseki[900]},
  {872,3,2,3,&joseki_variations[4985],&joseki[913]},
  {871,0,1,3,&joseki_variations[4982],&joseki[926]},
  {761,3,1,0,NULL,&joseki[927]},
  {804,3,3,0,NULL,&joseki[932]},
  {763,0,1,0,NULL,&joseki[933]},
  {836,0,2,1,&joseki_variations[4988],&joseki[914]},
  {797,0,1,0,NULL,&joseki[921]},
  {760,0,1,0,NULL,&joseki[924]},
  {760,3,1,0,NULL,&joseki[915]},
  {761,3,1,0,NULL,&joseki[901]},
  {804,3,3,0,NULL,&joseki[908]},
  {763,0,1,0,NULL,&joseki[909]},
  {804,0,3,5,&joseki_variations[4996],NULL},
  {799,3,2,1,&joseki_variations[4994],NULL},
  {804,0,4,1,&joseki_variations[4995],NULL},
  {761,0,1,0,NULL,&joseki[865]},
  {725,3,1,0,NULL,&joseki[858]},
  {763,3,1,0,NULL,&joseki[862]},
  {799,3,2,0,NULL,&joseki[864]},
  {761,3,1,0,NULL,&joseki[866]},
  {760,3,1,0,NULL,&joseki[877]},
  {804,0,3,6,&joseki_variations[5002],NULL},
  {762,0,1,0,NULL,&joseki[852]},
  {871,0,1,0,NULL,&joseki[853]},
  {908,0,1,0,NULL,&joseki[854]},
  {872,0,2,0,NULL,&joseki[855]},
  {1020,0,2,1,&joseki_variations[5008],NULL},
  {909,0,2,0,NULL,&joseki[857]},
  {1026,0,5,1,&joseki_variations[5009],NULL},
  {838,0,3,0,NULL,&joseki[856]},
  {763,3,2,1,&joseki_variations[5040],NULL},
  {762,0,2,3,&joseki_variations[5015],NULL},
  {764,0,2,1,&joseki_variations[5013],NULL},
  {804,0,4,1,&joseki_variations[5014],NULL},
  {762,0,2,0,NULL,&joseki[859]},
  {763,3,3,1,&joseki_variations[5035],NULL},
  {726,3,2,1,&joseki_variations[5020],NULL},
  {764,0,3,1,&joseki_variations[5018],NULL},
  {804,0,5,1,&joseki_variations[5019],NULL},
  {797,3,1,0,NULL,&joseki[860]},
  {763,3,4,2,&joseki_variations[5021],NULL},
  {800,0,6,1,&joseki_variations[5032],NULL},
  {799,0,4,1,&joseki_variations[5023],NULL},
  {800,0,7,1,&joseki_variations[5024],NULL},
  {837,3,8,1,&joseki_variations[5025],NULL},
  {874,0,9,1,&joseki_variations[5026],NULL},
  {801,3,8,1,&joseki_variations[5027],NULL},
  {838,0,10,1,&joseki_variations[5028],NULL},
  {875,0,12,1,&joseki_variations[5029],NULL},
  {802,3,9,1,&joseki_variations[5030],NULL},
  {839,3,12,1,&joseki_variations[5031],NULL},
  {760,0,1,0,NULL,&joseki[649]},
  {837,0,7,1,&joseki_variations[5033],NULL},
  {801,3,7,1,&joseki_variations[5034],NULL},
  {760,0,1,0,NULL,&joseki[611]},
  {800,0,5,1,&joseki_variations[5036],NULL},
  {837,0,6,1,&joseki_variations[5037],NULL},
  {801,3,6,2,&joseki_variations[5038],NULL},
  {761,3,1,0,NULL,&joseki[609]},
  {726,3,2,0,NULL,&joseki[610]},
  {800,0,4,1,&joseki_variations[5041],NULL},
  {837,0,5,1,&joseki_variations[5042],NULL},
  {801,3,5,2,&joseki_variations[5043],NULL},
  {762,0,2,0,NULL,&joseki[608]},
  {724,0,1,0,NULL,&joseki[612]},
  {763,3,2,3,&joseki_variations[5047],NULL},
  {761,0,1,0,NULL,&joseki[956]},
  {800,0,4,2,&joseki_variations[5081],NULL},
  {764,0,3,1,&joseki_variations[5071],NULL},
  {799,3,3,2,&joseki_variations[5050],NULL},
  {836,0,4,1,&joseki_variations[5056],NULL},
  {800,0,5,1,&joseki_variations[5052],NULL},
  {801,3,6,1,&joseki_variations[5053],NULL},
  {835,0,2,1,&joseki_variations[5054],NULL},
  {836,0,5,1,&joseki_variations[5055],NULL},
  {837,0,8,0,NULL,&joseki[682]},
  {800,0,5,4,&joseki_variations[5057],NULL},
  {837,0,7,1,&joseki_variations[5061],NULL},
  {835,0,2,0,NULL,&joseki[681]},
  {761,0,1,0,NULL,&joseki[692]},
  {797,0,1,0,NULL,&joseki[698]},
  {727,0,1,1,&joseki_variations[5062],NULL},
  {764,0,4,1,&joseki_variations[5063],NULL},
  {801,3,8,2,&joseki_variations[5064],NULL},
  {765,3,5,1,&joseki_variations[5070],NULL},
  {728,3,2,1,&joseki_variations[5066],NULL},
  {765,3,6,1,&joseki_variations[5067],NULL},
  {838,0,11,1,&joseki_variations[5068],&joseki[660]},
  {802,3,11,1,&joseki_variations[5069],&joseki[661]},
  {761,0,1,0,NULL,&joseki[662]},
  {728,3,2,0,NULL,&joseki[659]},
  {799,3,3,1,&joseki_variations[5072],NULL},
  {800,0,5,2,&joseki_variations[5073],NULL},
  {837,0,6,1,&joseki_variations[5079],NULL},
  {801,3,7,1,&joseki_variations[5075],NULL},
  {836,0,4,1,&joseki_variations[5076],NULL},
  {837,0,7,1,&joseki_variations[5077],NULL},
  {765,3,4,1,&joseki_variations[5078],&joseki[657]},
  {727,0,1,0,NULL,&joseki[658]},
  {801,3,7,1,&joseki_variations[5080],NULL},
  {836,0,4,0,NULL,&joseki[656]},
  {837,0,5,1,&joseki_variations[5083],NULL},
  {799,0,3,0,NULL,&joseki[667]},
  {801,3,5,1,&joseki_variations[5084],NULL},
  {761,0,1,0,NULL,&joseki[348]},
  {765,0,2,4,&joseki_variations[5114],&joseki[107]},
  {872,0,2,2,&joseki_variations[5093],NULL},
  {800,0,3,1,&joseki_variations[5088],NULL},
  {764,0,2,1,&joseki_variations[5089],NULL},
  {801,3,5,1,&joseki_variations[5090],NULL},
  {765,0,3,1,&joseki_variations[5091],NULL},
  {871,3,1,1,&joseki_variations[5092],NULL},
  {797,3,1,0,NULL,&joseki[219]},
  {800,0,3,1,&joseki_variations[5101],NULL},
  {837,3,3,1,&joseki_variations[5095],NULL},
  {765,0,2,3,&joseki_variations[5096],NULL},
  {839,3,5,1,&joseki_variations[5100],NULL},
  {911,3,5,1,&joseki_variations[5099],NULL},
  {724,3,1,0,NULL,&joseki[212]},
  {946,0,3,0,NULL,&joseki[211]},
  {762,0,1,0,NULL,&joseki[207]},
  {837,3,4,1,&joseki_variations[5102],NULL},
  {801,0,4,1,&joseki_variations[5103],NULL},
  {838,0,6,1,&joseki_variations[5104],NULL},
  {875,3,8,1,&joseki_variations[5105],NULL},
  {728,3,1,1,&joseki_variations[5106],NULL},
  {765,0,3,1,&joseki_variations[5107],NULL},
  {802,0,7,1,&joseki_variations[5108],NULL},
  {839,3,10,1,&joseki_variations[5109],NULL},
  {876,3,13,1,&joseki_variations[5110],NULL},
  {766,3,4,1,&joseki_variations[5111],NULL},
  {803,3,9,1,&joseki_variations[5112],NULL},
  {840,0,13,1,&joseki_variations[5113],NULL},
  {874,0,6,0,NULL,&joseki[165]},
  {760,3,1,0,NULL,&joseki[108]},
  {837,3,3,1,&joseki_variations[5133],NULL},
  {766,3,3,1,&joseki_variations[5121],NULL},
  {871,3,1,1,&joseki_variations[5118],&joseki[213]},
  {800,0,3,1,&joseki_variations[5119],&joseki[214]},
  {801,3,4,1,&joseki_variations[5120],&joseki[215]},
  {764,0,2,0,NULL,&joseki[216]},
  {872,0,2,1,&joseki_variations[5122],NULL},
  {800,0,3,1,&joseki_variations[5123],NULL},
  {837,3,4,1,&joseki_variations[5124],NULL},
  {801,0,4,1,&joseki_variations[5125],NULL},
  {838,0,6,1,&joseki_variations[5126],NULL},
  {875,3,8,1,&joseki_variations[5127],NULL},
  {802,0,6,1,&joseki_variations[5128],NULL},
  {839,3,9,1,&joseki_variations[5129],NULL},
  {876,3,12,1,&joseki_variations[5130],NULL},
  {803,3,8,1,&joseki_variations[5131],NULL},
  {840,0,12,1,&joseki_variations[5132],NULL},
  {728,3,1,0,NULL,&joseki[164]},
  {872,0,2,4,&joseki_variations[5134],&joseki[143]},
  {803,3,4,1,&joseki_variations[5195],NULL},
  {766,0,3,2,&joseki_variations[5173],NULL},
  {802,0,4,3,&joseki_variations[5152],NULL},
  {801,0,3,1,&joseki_variations[5138],NULL},
  {838,0,5,1,&joseki_variations[5139],NULL},
  {802,0,5,1,&joseki_variations[5140],NULL},
  {839,3,8,2,&joseki_variations[5141],NULL},
  {876,3,10,1,&joseki_variations[5148],NULL},
  {875,3,7,1,&joseki_variations[5143],NULL},
  {876,3,11,1,&joseki_variations[5144],NULL},
  {766,3,3,1,&joseki_variations[5145],NULL},
  {803,3,7,1,&joseki_variations[5146],NULL},
  {840,0,11,1,&joseki_variations[5147],NULL},
  {800,0,3,0,NULL,&joseki[163]},
  {766,3,3,1,&joseki_variations[5149],NULL},
  {803,3,7,1,&joseki_variations[5150],NULL},
  {840,0,11,1,&joseki_variations[5151],NULL},
  {875,3,7,0,NULL,&joseki[162]},
  {803,3,5,1,&joseki_variations[5171],NULL},
  {839,3,6,3,&joseki_variations[5161],NULL},
  {838,0,4,1,&joseki_variations[5155],NULL},
  {839,3,7,1,&joseki_variations[5156],NULL},
  {766,3,3,1,&joseki_variations[5157],NULL},
  {803,3,6,1,&joseki_variations[5158],NULL},
  {840,0,10,1,&joseki_variations[5159],NULL},
  {876,3,9,1,&joseki_variations[5160],&joseki[160]},
  {801,0,3,0,NULL,&joseki[161]},
  {766,0,3,1,&joseki_variations[5169],NULL},
  {803,3,5,1,&joseki_variations[5167],NULL},
  {766,3,3,1,&joseki_variations[5164],NULL},
  {803,3,6,1,&joseki_variations[5165],NULL},
  {840,0,9,1,&joseki_variations[5166],NULL},
  {838,0,4,0,NULL,&joseki[159]},
  {840,0,8,1,&joseki_variations[5168],NULL},
  {766,3,3,0,NULL,&joseki[158]},
  {803,3,6,1,&joseki_variations[5170],NULL},
  {804,3,7,0,NULL,&joseki[157]},
  {839,3,6,1,&joseki_variations[5172],&joseki[155]},
  {766,0,3,0,NULL,&joseki[156]},
  {803,3,5,2,&joseki_variations[5189],NULL},
  {802,0,4,1,&joseki_variations[5175],NULL},
  {803,3,6,3,&joseki_variations[5176],NULL},
  {804,3,7,1,&joseki_variations[5187],NULL},
  {839,3,6,1,&joseki_variations[5182],NULL},
  {767,0,4,1,&joseki_variations[5179],NULL},
  {804,3,8,1,&joseki_variations[5180],NULL},
  {805,3,9,1,&joseki_variations[5181],NULL},
  {839,3,6,0,NULL,&joseki[154]},
  {767,0,4,1,&joseki_variations[5183],NULL},
  {804,3,8,1,&joseki_variations[5184],NULL},
  {805,3,9,1,&joseki_variations[5185],&joseki[149]},
  {769,0,5,1,&joseki_variations[5186],&joseki[150]},
  {801,3,3,0,NULL,&joseki[151]},
  {839,3,6,1,&joseki_variations[5188],&joseki[147]},
  {767,0,4,0,NULL,&joseki[148]},
  {804,3,6,1,&joseki_variations[5194],&joseki[145]},
  {767,0,4,1,&joseki_variations[5191],NULL},
  {804,3,7,1,&joseki_variations[5192],NULL},
  {805,3,8,1,&joseki_variations[5193],&joseki[152]},
  {802,0,4,0,NULL,&joseki[153]},
  {802,0,4,0,NULL,&joseki[146]},
  {766,0,3,0,NULL,&joseki[144]},
  {762,3,1,1,&joseki_variations[5204],NULL},
  {835,3,3,1,&joseki_variations[5198],NULL},
  {871,0,2,1,&joseki_variations[5199],NULL},
  {872,3,5,1,&joseki_variations[5200],NULL},
  {762,0,1,1,&joseki_variations[5201],NULL},
  {763,3,2,1,&joseki_variations[5202],NULL},
  {800,3,4,1,&joseki_variations[5203],NULL},
  {797,3,1,0,NULL,&joseki[845]},
  {799,3,3,1,&joseki_variations[5205],NULL},
  {836,3,5,1,&joseki_variations[5206],NULL},
  {908,0,2,1,&joseki_variations[5207],&joseki[63]},
  {760,3,1,0,NULL,&joseki[64]},
  {799,3,3,1,&joseki_variations[5387],NULL},
  {872,0,2,4,&joseki_variations[5276],NULL},
  {763,3,2,5,&joseki_variations[5251],NULL},
  {799,0,3,3,&joseki_variations[5217],NULL},
  {871,0,1,1,&joseki_variations[5213],NULL},
  {763,0,2,1,&joseki_variations[5214],NULL},
  {800,3,4,1,&joseki_variations[5215],NULL},
  {764,3,3,1,&joseki_variations[5216],NULL},
  {801,3,6,0,NULL,&joseki[936]},
  {726,0,1,1,&joseki_variations[5238],NULL},
  {763,3,2,1,&joseki_variations[5230],NULL},
  {726,3,1,1,&joseki_variations[5220],NULL},
  {763,3,3,1,&joseki_variations[5221],NULL},
  {800,0,6,1,&joseki_variations[5222],NULL},
  {837,3,7,1,&joseki_variations[5223],NULL},
  {801,3,7,1,&joseki_variations[5224],NULL},
  {838,0,9,1,&joseki_variations[5225],&joseki[643]},
  {802,3,8,1,&joseki_variations[5226],&joseki[644]},
  {874,0,8,1,&joseki_variations[5227],&joseki[645]},
  {839,3,11,1,&joseki_variations[5228],&joseki[646]},
  {875,0,11,1,&joseki_variations[5229],&joseki[647]},
  {725,3,1,0,NULL,&joseki[648]},
  {800,0,5,1,&joseki_variations[5231],NULL},
  {837,3,6,2,&joseki_variations[5232],NULL},
  {801,3,6,2,&joseki_variations[5236],NULL},
  {764,3,3,1,&joseki_variations[5234],NULL},
  {801,3,7,1,&joseki_variations[5235],NULL},
  {872,0,2,0,NULL,&joseki[633]},
  {764,3,3,0,NULL,&joseki[632]},
  {726,3,1,0,NULL,&joseki[642]},
  {800,0,5,1,&joseki_variations[5239],NULL},
  {837,3,6,2,&joseki_variations[5240],NULL},
  {764,0,3,1,&joseki_variations[5247],NULL},
  {727,3,2,1,&joseki_variations[5242],NULL},
  {764,0,4,1,&joseki_variations[5243],NULL},
  {801,3,8,1,&joseki_variations[5244],NULL},
  {838,3,10,1,&joseki_variations[5245],NULL},
  {765,3,5,1,&joseki_variations[5246],NULL},
  {872,0,2,0,NULL,&joseki[631]},
  {801,3,7,1,&joseki_variations[5248],NULL},
  {838,3,9,1,&joseki_variations[5249],NULL},
  {765,3,4,1,&joseki_variations[5250],NULL},
  {727,3,2,0,NULL,&joseki[630]},
  {800,0,4,1,&joseki_variations[5273],NULL},
  {799,0,3,1,&joseki_variations[5262],NULL},
  {800,3,4,2,&joseki_variations[5259],&joseki[841]},
  {804,0,4,1,&joseki_variations[5257],NULL},
  {836,3,3,1,&joseki_variations[5256],NULL},
  {800,0,4,0,NULL,&joseki[849]},
  {836,3,3,1,&joseki_variations[5258],NULL},
  {835,0,2,0,NULL,&joseki[848]},
  {804,0,5,1,&joseki_variations[5261],NULL},
  {835,3,2,0,NULL,&joseki[844]},
  {872,0,2,0,NULL,&joseki[842]},
  {800,0,5,1,&joseki_variations[5263],NULL},
  {837,3,6,2,&joseki_variations[5264],NULL},
  {801,3,6,1,&joseki_variations[5270],NULL},
  {764,0,3,1,&joseki_variations[5266],NULL},
  {801,3,7,1,&joseki_variations[5267],NULL},
  {838,3,9,1,&joseki_variations[5268],NULL},
  {765,3,4,1,&joseki_variations[5269],&joseki[628]},
  {726,0,1,0,NULL,&joseki[629]},
  {838,3,8,2,&joseki_variations[5271],&joseki[625]},
  {872,0,2,0,NULL,&joseki[626]},
  {764,0,3,0,NULL,&joseki[627]},
  {801,3,5,1,&joseki_variations[5274],NULL},
  {837,3,5,1,&joseki_variations[5275],&joseki[623]},
  {799,0,3,0,NULL,&joseki[624]},
  {726,3,1,1,&joseki_variations[5310],NULL},
  {763,3,2,3,&joseki_variations[5290],NULL},
  {726,0,1,1,&joseki_variations[5284],NULL},
  {763,0,2,1,&joseki_variations[5280],NULL},
  {800,3,4,1,&joseki_variations[5281],NULL},
  {764,3,3,1,&joseki_variations[5282],NULL},
  {804,3,6,1,&joseki_variations[5283],NULL},
  {801,3,6,0,NULL,&joseki[912]},
  {763,3,3,1,&joseki_variations[5285],NULL},
  {837,3,5,1,&joseki_variations[5286],NULL},
  {765,0,4,1,&joseki_variations[5287],NULL},
  {766,3,5,1,&joseki_variations[5288],NULL},
  {803,3,7,1,&joseki_variations[5289],NULL},
  {764,3,4,0,NULL,&joseki[202]},
  {837,3,4,1,&joseki_variations[5302],NULL},
  {800,3,4,4,&joseki_variations[5296],NULL},
  {799,0,3,1,&joseki_variations[5293],NULL},
  {800,0,5,1,&joseki_variations[5294],NULL},
  {837,3,6,1,&joseki_variations[5295],NULL},
  {760,3,1,0,NULL,&joseki[634]},
  {760,3,1,0,NULL,&joseki[283]},
  {804,3,5,0,NULL,&joseki[293]},
  {767,3,3,0,NULL,&joseki[294]},
  {802,3,5,1,&joseki_variations[5300],NULL},
  {804,0,6,1,&joseki_variations[5301],NULL},
  {725,0,1,0,NULL,&joseki[843]},
  {765,0,3,3,&joseki_variations[5303],NULL},
  {803,3,5,1,&joseki_variations[5309],NULL},
  {766,3,4,1,&joseki_variations[5307],NULL},
  {839,3,6,1,&joseki_variations[5306],NULL},
  {726,3,1,0,NULL,&joseki[208]},
  {803,3,6,1,&joseki_variations[5308],NULL},
  {726,0,1,0,NULL,&joseki[201]},
  {766,3,4,0,NULL,&joseki[200]},
  {763,3,3,2,&joseki_variations[5311],NULL},
  {837,3,5,1,&joseki_variations[5342],NULL},
  {800,3,5,1,&joseki_variations[5313],NULL},
  {837,3,6,1,&joseki_variations[5314],NULL},
  {801,0,6,1,&joseki_variations[5315],NULL},
  {765,0,4,1,&joseki_variations[5316],NULL},
  {802,0,8,2,&joseki_variations[5317],NULL},
  {839,3,10,1,&joseki_variations[5336],NULL},
  {838,0,8,1,&joseki_variations[5319],NULL},
  {839,3,11,1,&joseki_variations[5320],NULL},
  {766,0,5,1,&joseki_variations[5321],NULL},
  {803,3,10,1,&joseki_variations[5322],NULL},
  {767,0,6,1,&joseki_variations[5323],NULL},
  {804,3,12,1,&joseki_variations[5324],NULL},
  {805,3,13,2,&joseki_variations[5325],NULL},
  {875,3,10,1,&joseki_variations[5333],&joseki[176]},
  {840,3,14,1,&joseki_variations[5327],NULL},
  {874,0,8,1,&joseki_variations[5328],NULL},
  {875,3,11,1,&joseki_variations[5329],NULL},
  {876,0,15,1,&joseki_variations[5330],NULL},
  {912,3,12,1,&joseki_variations[5331],&joseki[180]},
  {769,0,7,1,&joseki_variations[5332],&joseki[181]},
  {760,3,1,0,NULL,&joseki[182]},
  {876,0,14,1,&joseki_variations[5334],&joseki[177]},
  {840,3,14,1,&joseki_variations[5335],&joseki[178]},
  {874,0,8,0,NULL,&joseki[179]},
  {766,0,5,1,&joseki_variations[5337],NULL},
  {803,3,10,1,&joseki_variations[5338],NULL},
  {767,0,6,1,&joseki_variations[5339],NULL},
  {804,3,12,1,&joseki_variations[5340],NULL},
  {805,3,13,1,&joseki_variations[5341],NULL},
  {838,0,8,0,NULL,&joseki[175]},
  {765,0,4,4,&joseki_variations[5343],NULL},
  {803,3,6,1,&joseki_variations[5386],NULL},
  {766,0,5,3,&joseki_variations[5356],NULL},
  {802,0,6,2,&joseki_variations[5349],NULL},
  {839,3,7,1,&joseki_variations[5347],NULL},
  {767,0,5,1,&joseki_variations[5348],&joseki[209]},
  {911,3,7,0,NULL,&joseki[210]},
  {803,3,7,1,&joseki_variations[5354],NULL},
  {839,3,8,1,&joseki_variations[5351],NULL},
  {766,0,5,1,&joseki_variations[5352],NULL},
  {803,3,8,1,&joseki_variations[5353],NULL},
  {804,3,9,0,NULL,&joseki[199]},
  {839,3,8,1,&joseki_variations[5355],&joseki[197]},
  {766,0,5,0,NULL,&joseki[198]},
  {803,3,7,2,&joseki_variations[5380],NULL},
  {802,0,6,1,&joseki_variations[5366],NULL},
  {767,0,6,1,&joseki_variations[5359],NULL},
  {801,0,5,1,&joseki_variations[5360],NULL},
  {802,0,7,1,&joseki_variations[5361],NULL},
  {839,3,9,1,&joseki_variations[5362],NULL},
  {803,3,9,1,&joseki_variations[5363],NULL},
  {804,3,11,1,&joseki_variations[5364],NULL},
  {805,3,12,1,&joseki_variations[5365],NULL},
  {800,3,5,0,NULL,&joseki[174]},
  {803,3,8,3,&joseki_variations[5367],NULL},
  {804,3,9,1,&joseki_variations[5378],NULL},
  {839,3,8,1,&joseki_variations[5373],NULL},
  {767,0,6,1,&joseki_variations[5370],NULL},
  {804,3,10,1,&joseki_variations[5371],NULL},
  {805,3,11,1,&joseki_variations[5372],NULL},
  {839,3,8,0,NULL,&joseki[196]},
  {767,0,6,1,&joseki_variations[5374],NULL},
  {804,3,10,1,&joseki_variations[5375],NULL},
  {805,3,11,1,&joseki_variations[5376],&joseki[171]},
  {769,0,7,1,&joseki_variations[5377],&joseki[172]},
  {801,3,5,0,NULL,&joseki[173]},
  {839,3,8,1,&joseki_variations[5379],&joseki[169]},
  {767,0,6,0,NULL,&joseki[170]},
  {804,3,8,1,&joseki_variations[5385],&joseki[167]},
  {767,0,6,1,&joseki_variations[5382],NULL},
  {804,3,9,1,&joseki_variations[5383],NULL},
  {805,3,10,1,&joseki_variations[5384],&joseki[194]},
  {802,0,6,0,NULL,&joseki[195]},
  {802,0,6,0,NULL,&joseki[168]},
  {766,0,5,0,NULL,&joseki[166]},
  {836,3,4,1,&joseki_variations[5388],NULL},
  {763,3,2,2,&joseki_variations[5389],&joseki[50]},
  {761,0,1,0,NULL,&joseki[51]},
  {800,0,5,3,&joseki_variations[5391],NULL},
  {761,0,1,0,NULL,&joseki[673]},
  {725,0,1,0,NULL,&joseki[678]},
  {801,0,6,0,NULL,&joseki[679]},
  {836,3,3,2,&joseki_variations[5400],NULL},
  {834,0,1,1,&joseki_variations[5397],NULL},
  {835,0,2,0,NULL,&joseki[994]},
  {836,3,4,2,&joseki_variations[5398],NULL},
  {762,3,1,0,NULL,&joseki[62]},
  {761,3,1,0,NULL,&joseki[66]},
  {761,0,1,0,NULL,&joseki[23]},
  {834,0,1,0,NULL,&joseki[61]},
  {799,3,2,0,NULL,&joseki[22]},
  {801,3,2,1,&joseki_variations[5404],NULL},
  {872,0,2,1,&joseki_variations[5405],NULL},
  {874,0,4,1,&joseki_variations[5406],NULL},
  {946,3,3,1,&joseki_variations[5407],NULL},
  {835,0,2,0,NULL,&joseki[851]},
  {759,3,2,6,&joseki_variations[6408],NULL},
  {760,0,2,2,&joseki_variations[6394],NULL},
  {796,0,2,3,&joseki_variations[6320],NULL},
  {759,0,2,4,&joseki_variations[6089],NULL},
  {723,3,2,3,&joseki_variations[5874],NULL},
  {686,0,1,2,&joseki_variations[5816],NULL},
  {724,3,2,2,&joseki_variations[5657],NULL},
  {723,0,2,5,&joseki_variations[5430],NULL},
  {797,0,2,1,&joseki_variations[5417],NULL},
  {833,0,2,1,&joseki_variations[5418],NULL},
  {870,3,3,1,&joseki_variations[5419],NULL},
  {724,0,2,1,&joseki_variations[5420],NULL},
  {761,0,3,1,&joseki_variations[5421],NULL},
  {798,3,5,1,&joseki_variations[5422],NULL},
  {835,3,7,1,&joseki_variations[5423],NULL},
  {872,3,9,1,&joseki_variations[5424],NULL},
  {725,3,3,1,&joseki_variations[5425],NULL},
  {762,3,5,1,&joseki_variations[5426],NULL},
  {799,0,8,1,&joseki_variations[5427],NULL},
  {727,3,4,1,&joseki_variations[5428],NULL},
  {801,0,10,1,&joseki_variations[5429],NULL},
  {800,3,9,0,NULL,&joseki[1055]},
  {760,0,3,1,&joseki_variations[5649],NULL},
  {724,0,3,2,&joseki_variations[5527],NULL},
  {687,0,1,1,&joseki_variations[5455],NULL},
  {760,3,3,1,&joseki_variations[5446],NULL},
  {724,3,3,1,&joseki_variations[5435],NULL},
  {758,0,1,1,&joseki_variations[5436],NULL},
  {760,0,4,1,&joseki_variations[5437],NULL},
  {761,3,6,1,&joseki_variations[5438],NULL},
  {763,3,7,1,&joseki_variations[5439],NULL},
  {796,0,3,1,&joseki_variations[5440],NULL},
  {797,3,6,1,&joseki_variations[5441],NULL},
  {798,0,9,1,&joseki_variations[5442],NULL},
  {833,3,4,1,&joseki_variations[5443],NULL},
  {834,3,8,1,&joseki_variations[5444],NULL},
  {835,0,12,1,&joseki_variations[5445],NULL},
  {908,3,9,0,NULL,&joseki[1313]},
  {797,3,4,1,&joseki_variations[5447],NULL},
  {761,0,4,2,&joseki_variations[5448],NULL},
  {800,0,6,1,&joseki_variations[5452],NULL},
  {835,3,6,1,&joseki_variations[5450],NULL},
  {763,0,5,1,&joseki_variations[5451],NULL},
  {982,3,5,0,NULL,&joseki[1304]},
  {835,3,6,1,&joseki_variations[5453],NULL},
  {982,3,5,1,&joseki_variations[5454],&joseki[1231]},
  {767,0,5,0,NULL,&joseki[1232]},
  {724,0,4,2,&joseki_variations[5456],NULL},
  {725,3,5,1,&joseki_variations[5505],NULL},
  {688,3,2,1,&joseki_variations[5458],NULL},
  {725,3,6,1,&joseki_variations[5459],NULL},
  {689,3,3,1,&joseki_variations[5460],NULL},
  {727,3,8,2,&joseki_variations[5461],NULL},
  {728,0,9,1,&joseki_variations[5485],NULL},
  {691,3,4,1,&joseki_variations[5463],NULL},
  {728,0,10,1,&joseki_variations[5464],NULL},
  {729,3,11,1,&joseki_variations[5465],NULL},
  {758,0,1,1,&joseki_variations[5466],NULL},
  {759,3,3,1,&joseki_variations[5467],NULL},
  {760,3,5,1,&joseki_variations[5468],NULL},
  {761,0,8,1,&joseki_variations[5469],NULL},
  {762,3,11,1,&joseki_variations[5470],NULL},
  {763,3,13,1,&joseki_variations[5471],NULL},
  {764,0,15,1,&joseki_variations[5472],NULL},
  {765,0,18,1,&joseki_variations[5473],NULL},
  {767,0,20,1,&joseki_variations[5474],NULL},
  {796,3,4,1,&joseki_variations[5475],NULL},
  {798,3,10,1,&joseki_variations[5476],NULL},
  {799,0,14,1,&joseki_variations[5477],NULL},
  {800,0,17,1,&joseki_variations[5478],NULL},
  {801,0,20,1,&joseki_variations[5479],NULL},
  {833,0,5,1,&joseki_variations[5480],NULL},
  {834,3,8,1,&joseki_variations[5481],NULL},
  {835,3,13,1,&joseki_variations[5482],NULL},
  {870,3,6,1,&joseki_variations[5483],NULL},
  {872,3,15,1,&joseki_variations[5484],NULL},
  {685,3,1,0,NULL,&joseki[1068]},
  {729,3,10,1,&joseki_variations[5486],NULL},
  {758,0,1,1,&joseki_variations[5487],NULL},
  {759,3,3,1,&joseki_variations[5488],NULL},
  {760,3,5,1,&joseki_variations[5489],NULL},
  {761,0,8,1,&joseki_variations[5490],NULL},
  {762,3,11,1,&joseki_variations[5491],NULL},
  {763,3,13,1,&joseki_variations[5492],NULL},
  {764,0,15,1,&joseki_variations[5493],NULL},
  {765,0,17,1,&joseki_variations[5494],NULL},
  {796,3,4,1,&joseki_variations[5495],NULL},
  {798,3,10,1,&joseki_variations[5496],NULL},
  {799,0,14,1,&joseki_variations[5497],NULL},
  {800,0,17,1,&joseki_variations[5498],NULL},
  {801,0,20,1,&joseki_variations[5499],NULL},
  {833,0,5,1,&joseki_variations[5500],NULL},
  {834,3,8,1,&joseki_variations[5501],NULL},
  {835,3,13,1,&joseki_variations[5502],NULL},
  {870,3,6,1,&joseki_variations[5503],NULL},
  {872,3,15,1,&joseki_variations[5504],NULL},
  {691,3,4,0,NULL,&joseki[1067]},
  {689,3,2,1,&joseki_variations[5506],NULL},
  {727,3,7,1,&joseki_variations[5507],NULL},
  {728,0,8,1,&joseki_variations[5508],NULL},
  {729,3,9,1,&joseki_variations[5509],NULL},
  {758,0,1,1,&joseki_variations[5510],NULL},
  {759,3,3,1,&joseki_variations[5511],NULL},
  {760,3,5,1,&joseki_variations[5512],NULL},
  {761,0,8,1,&joseki_variations[5513],NULL},
  {762,3,10,1,&joseki_variations[5514],NULL},
  {763,3,12,1,&joseki_variations[5515],NULL},
  {764,0,14,1,&joseki_variations[5516],NULL},
  {796,3,4,1,&joseki_variations[5517],NULL},
  {798,3,10,1,&joseki_variations[5518],NULL},
  {799,0,13,1,&joseki_variations[5519],NULL},
  {800,0,16,1,&joseki_variations[5520],NULL},
  {801,0,19,1,&joseki_variations[5521],NULL},
  {833,0,5,1,&joseki_variations[5522],NULL},
  {834,3,8,1,&joseki_variations[5523],NULL},
  {835,3,13,1,&joseki_variations[5524],NULL},
  {870,3,6,1,&joseki_variations[5525],NULL},
  {872,3,15,1,&joseki_variations[5526],NULL},
  {688,3,2,0,NULL,&joseki[1066]},
  {725,3,4,3,&joseki_variations[5540],NULL},
  {758,0,1,1,&joseki_variations[5529],NULL},
  {761,0,5,1,&joseki_variations[5530],NULL},
  {762,3,6,1,&joseki_variations[5531],NULL},
  {796,0,3,1,&joseki_variations[5532],NULL},
  {797,0,5,1,&joseki_variations[5533],NULL},
  {798,3,8,1,&joseki_variations[5534],NULL},
  {800,3,10,1,&joseki_variations[5535],NULL},
  {833,3,4,1,&joseki_variations[5536],NULL},
  {834,0,7,1,&joseki_variations[5537],NULL},
  {835,3,11,1,&joseki_variations[5538],NULL},
  {871,3,8,1,&joseki_variations[5539],NULL},
  {909,3,13,0,NULL,&joseki[1587]},
  {727,3,5,1,&joseki_variations[5622],NULL},
  {726,0,5,1,&joseki_variations[5563],NULL},
  {689,3,1,1,&joseki_variations[5543],NULL},
  {727,3,6,1,&joseki_variations[5544],NULL},
  {728,0,7,1,&joseki_variations[5545],NULL},
  {758,0,1,1,&joseki_variations[5546],NULL},
  {759,3,3,1,&joseki_variations[5547],NULL},
  {760,3,5,1,&joseki_variations[5548],NULL},
  {761,0,7,1,&joseki_variations[5549],NULL},
  {762,3,9,1,&joseki_variations[5550],NULL},
  {763,3,11,1,&joseki_variations[5551],NULL},
  {764,0,13,1,&joseki_variations[5552],NULL},
  {796,3,4,1,&joseki_variations[5553],NULL},
  {798,3,9,1,&joseki_variations[5554],NULL},
  {799,0,12,1,&joseki_variations[5555],NULL},
  {800,0,15,1,&joseki_variations[5556],NULL},
  {801,0,18,1,&joseki_variations[5557],NULL},
  {833,0,5,1,&joseki_variations[5558],NULL},
  {834,3,8,1,&joseki_variations[5559],NULL},
  {835,3,12,1,&joseki_variations[5560],NULL},
  {870,3,6,1,&joseki_variations[5561],NULL},
  {872,3,14,1,&joseki_variations[5562],NULL},
  {729,3,8,0,NULL,&joseki[1065]},
  {727,3,6,2,&joseki_variations[5564],NULL},
  {728,0,7,1,&joseki_variations[5591],NULL},
  {758,0,1,1,&joseki_variations[5566],NULL},
  {759,3,3,1,&joseki_variations[5567],NULL},
  {760,3,5,1,&joseki_variations[5568],NULL},
  {761,0,7,1,&joseki_variations[5569],NULL},
  {762,3,9,1,&joseki_variations[5570],NULL},
  {796,3,4,1,&joseki_variations[5571],NULL},
  {798,3,9,1,&joseki_variations[5572],NULL},
  {799,0,12,2,&joseki_variations[5573],NULL},
  {800,0,14,1,&joseki_variations[5584],NULL},
  {763,3,11,1,&joseki_variations[5575],NULL},
  {800,0,15,1,&joseki_variations[5576],NULL},
  {764,0,13,1,&joseki_variations[5577],NULL},
  {801,0,18,1,&joseki_variations[5578],NULL},
  {833,0,5,1,&joseki_variations[5579],NULL},
  {834,3,8,1,&joseki_variations[5580],NULL},
  {835,3,12,1,&joseki_variations[5581],NULL},
  {870,3,6,1,&joseki_variations[5582],NULL},
  {872,3,14,1,&joseki_variations[5583],NULL},
  {689,3,1,0,NULL,&joseki[1064]},
  {801,0,16,1,&joseki_variations[5585],NULL},
  {833,0,5,1,&joseki_variations[5586],NULL},
  {834,3,8,1,&joseki_variations[5587],NULL},
  {835,3,12,1,&joseki_variations[5588],NULL},
  {870,3,6,1,&joseki_variations[5589],NULL},
  {872,3,14,1,&joseki_variations[5590],NULL},
  {763,3,11,0,NULL,&joseki[1063]},
  {758,0,1,1,&joseki_variations[5592],NULL},
  {759,3,3,1,&joseki_variations[5593],NULL},
  {760,3,5,1,&joseki_variations[5594],NULL},
  {761,0,7,1,&joseki_variations[5595],NULL},
  {762,3,9,2,&joseki_variations[5596],NULL},
  {765,3,13,1,&joseki_variations[5611],NULL},
  {763,0,11,1,&joseki_variations[5598],NULL},
  {765,3,14,1,&joseki_variations[5599],NULL},
  {729,3,8,1,&joseki_variations[5600],NULL},
  {796,3,4,1,&joseki_variations[5601],NULL},
  {798,3,9,1,&joseki_variations[5602],NULL},
  {799,0,12,1,&joseki_variations[5603],NULL},
  {800,0,15,1,&joseki_variations[5604],NULL},
  {801,0,17,1,&joseki_variations[5605],NULL},
  {833,0,5,1,&joseki_variations[5606],NULL},
  {834,3,8,1,&joseki_variations[5607],NULL},
  {835,3,12,1,&joseki_variations[5608],NULL},
  {870,3,6,1,&joseki_variations[5609],NULL},
  {872,3,14,1,&joseki_variations[5610],NULL},
  {805,3,21,0,NULL,&joseki[1062]},
  {796,3,4,1,&joseki_variations[5612],NULL},
  {798,3,9,1,&joseki_variations[5613],NULL},
  {799,0,12,1,&joseki_variations[5614],NULL},
  {800,0,14,1,&joseki_variations[5615],NULL},
  {801,0,16,1,&joseki_variations[5616],NULL},
  {833,0,5,1,&joseki_variations[5617],NULL},
  {834,3,8,1,&joseki_variations[5618],NULL},
  {835,3,12,1,&joseki_variations[5619],NULL},
  {870,3,6,1,&joseki_variations[5620],NULL},
  {872,3,14,1,&joseki_variations[5621],NULL},
  {729,3,8,0,NULL,&joseki[1061]},
  {758,0,1,1,&joseki_variations[5623],NULL},
  {759,3,3,1,&joseki_variations[5624],NULL},
  {760,3,5,1,&joseki_variations[5625],NULL},
  {761,0,7,1,&joseki_variations[5626],NULL},
  {762,3,9,1,&joseki_variations[5627],NULL},
  {796,3,4,2,&joseki_variations[5628],NULL},
  {797,0,7,1,&joseki_variations[5640],NULL},
  {798,3,9,1,&joseki_variations[5630],NULL},
  {799,0,12,1,&joseki_variations[5631],NULL},
  {800,0,13,1,&joseki_variations[5632],NULL},
  {801,0,15,1,&joseki_variations[5633],NULL},
  {728,0,6,1,&joseki_variations[5634],NULL},
  {833,0,5,1,&joseki_variations[5635],NULL},
  {834,3,8,1,&joseki_variations[5636],NULL},
  {835,3,12,1,&joseki_variations[5637],NULL},
  {870,3,6,1,&joseki_variations[5638],NULL},
  {872,3,14,1,&joseki_variations[5639],NULL},
  {765,3,12,0,NULL,&joseki[1060]},
  {798,3,10,1,&joseki_variations[5641],NULL},
  {799,0,13,1,&joseki_variations[5642],NULL},
  {800,0,14,1,&joseki_variations[5643],NULL},
  {801,0,16,1,&joseki_variations[5644],NULL},
  {833,0,5,1,&joseki_variations[5645],NULL},
  {835,3,12,1,&joseki_variations[5646],NULL},
  {870,3,6,1,&joseki_variations[5647],NULL},
  {872,3,14,1,&joseki_variations[5648],NULL},
  {834,3,9,0,NULL,&joseki[1059]},
  {871,3,4,1,&joseki_variations[5650],NULL},
  {687,3,1,1,&joseki_variations[5651],NULL},
  {724,0,4,1,&joseki_variations[5652],NULL},
  {761,3,6,1,&joseki_variations[5653],NULL},
  {798,3,7,1,&joseki_variations[5654],NULL},
  {725,3,5,1,&joseki_variations[5655],NULL},
  {763,0,8,1,&joseki_variations[5656],NULL},
  {762,3,8,0,NULL,&joseki[756]},
  {758,0,1,1,&joseki_variations[5760],NULL},
  {759,3,2,2,&joseki_variations[5659],NULL},
  {761,3,4,2,&joseki_variations[5722],NULL},
  {760,0,3,1,&joseki_variations[5661],NULL},
  {761,3,5,2,&joseki_variations[5662],NULL},
  {762,0,6,1,&joseki_variations[5705],NULL},
  {725,0,3,1,&joseki_variations[5664],NULL},
  {762,0,7,1,&joseki_variations[5665],NULL},
  {763,0,8,1,&joseki_variations[5666],NULL},
  {727,0,4,1,&joseki_variations[5667],NULL},
  {764,3,10,1,&joseki_variations[5668],NULL},
  {728,0,5,1,&joseki_variations[5669],NULL},
  {765,3,12,1,&joseki_variations[5670],NULL},
  {796,0,3,2,&joseki_variations[5671],NULL},
  {798,3,7,1,&joseki_variations[5694],NULL},
  {797,3,5,1,&joseki_variations[5673],NULL},
  {798,3,8,1,&joseki_variations[5674],NULL},
  {799,0,11,1,&joseki_variations[5675],NULL},
  {800,3,13,1,&joseki_variations[5676],NULL},
  {801,0,16,2,&joseki_variations[5677],NULL},
  {834,0,6,1,&joseki_variations[5687],NULL},
  {833,0,4,1,&joseki_variations[5679],NULL},
  {834,0,7,1,&joseki_variations[5680],NULL},
  {835,0,11,1,&joseki_variations[5681],NULL},
  {836,3,15,1,&joseki_variations[5682],NULL},
  {837,3,18,1,&joseki_variations[5683],NULL},
  {870,3,5,1,&joseki_variations[5684],NULL},
  {871,3,9,1,&joseki_variations[5685],NULL},
  {872,3,14,1,&joseki_variations[5686],NULL},
  {723,3,2,0,NULL,&joseki[478]},
  {835,0,10,1,&joseki_variations[5688],NULL},
  {836,3,14,1,&joseki_variations[5689],NULL},
  {837,3,17,1,&joseki_variations[5690],NULL},
  {870,3,4,1,&joseki_variations[5691],NULL},
  {871,3,8,1,&joseki_variations[5692],NULL},
  {872,3,13,1,&joseki_variations[5693],NULL},
  {833,0,4,0,NULL,&joseki[477]},
  {799,0,10,1,&joseki_variations[5695],NULL},
  {800,3,12,1,&joseki_variations[5696],NULL},
  {801,0,15,1,&joseki_variations[5697],NULL},
  {834,0,5,1,&joseki_variations[5698],NULL},
  {835,0,9,1,&joseki_variations[5699],NULL},
  {836,3,13,1,&joseki_variations[5700],NULL},
  {837,3,16,1,&joseki_variations[5701],NULL},
  {870,3,4,1,&joseki_variations[5702],NULL},
  {871,3,7,1,&joseki_variations[5703],NULL},
  {872,3,12,1,&joseki_variations[5704],NULL},
  {797,3,5,0,NULL,&joseki[476]},
  {763,0,7,1,&joseki_variations[5706],NULL},
  {764,0,8,1,&joseki_variations[5707],NULL},
  {796,0,3,1,&joseki_variations[5708],NULL},
  {797,3,5,1,&joseki_variations[5709],NULL},
  {798,3,8,1,&joseki_variations[5710],NULL},
  {799,0,10,1,&joseki_variations[5711],NULL},
  {800,3,12,1,&joseki_variations[5712],NULL},
  {801,0,14,1,&joseki_variations[5713],NULL},
  {833,0,4,1,&joseki_variations[5714],NULL},
  {834,0,7,1,&joseki_variations[5715],NULL},
  {835,0,11,1,&joseki_variations[5716],NULL},
  {836,3,14,1,&joseki_variations[5717],NULL},
  {837,3,17,1,&joseki_variations[5718],NULL},
  {870,3,5,1,&joseki_variations[5719],NULL},
  {871,3,9,1,&joseki_variations[5720],NULL},
  {872,3,14,1,&joseki_variations[5721],NULL},
  {723,3,2,0,NULL,&joseki[378]},
  {762,0,5,1,&joseki_variations[5743],NULL},
  {725,0,3,1,&joseki_variations[5724],NULL},
  {762,0,6,1,&joseki_variations[5725],NULL},
  {763,0,7,1,&joseki_variations[5726],NULL},
  {727,0,4,1,&joseki_variations[5727],NULL},
  {764,3,9,1,&joseki_variations[5728],NULL},
  {728,0,5,1,&joseki_variations[5729],NULL},
  {765,3,11,1,&joseki_variations[5730],NULL},
  {796,0,3,1,&joseki_variations[5731],NULL},
  {798,3,6,1,&joseki_variations[5732],NULL},
  {799,0,9,1,&joseki_variations[5733],NULL},
  {800,3,11,1,&joseki_variations[5734],NULL},
  {801,0,14,1,&joseki_variations[5735],NULL},
  {834,0,4,1,&joseki_variations[5736],NULL},
  {835,0,8,1,&joseki_variations[5737],NULL},
  {836,3,12,1,&joseki_variations[5738],NULL},
  {837,3,15,1,&joseki_variations[5739],NULL},
  {870,3,4,1,&joseki_variations[5740],NULL},
  {871,3,6,1,&joseki_variations[5741],NULL},
  {872,3,11,1,&joseki_variations[5742],NULL},
  {760,0,3,0,NULL,&joseki[475]},
  {763,0,6,1,&joseki_variations[5744],NULL},
  {764,0,7,1,&joseki_variations[5745],NULL},
  {796,0,3,1,&joseki_variations[5746],NULL},
  {797,3,4,1,&joseki_variations[5747],NULL},
  {798,3,7,1,&joseki_variations[5748],NULL},
  {799,0,9,1,&joseki_variations[5749],NULL},
  {800,3,11,1,&joseki_variations[5750],NULL},
  {801,0,13,1,&joseki_variations[5751],NULL},
  {833,0,4,1,&joseki_variations[5752],NULL},
  {834,0,6,1,&joseki_variations[5753],NULL},
  {835,0,10,1,&joseki_variations[5754],NULL},
  {836,3,13,1,&joseki_variations[5755],NULL},
  {837,3,16,1,&joseki_variations[5756],NULL},
  {870,3,5,1,&joseki_variations[5757],NULL},
  {871,3,8,1,&joseki_variations[5758],NULL},
  {872,3,13,1,&joseki_variations[5759],NULL},
  {760,0,3,0,NULL,&joseki[377]},
  {759,3,3,2,&joseki_variations[5761],NULL},
  {761,3,5,1,&joseki_variations[5798],NULL},
  {760,3,4,1,&joseki_variations[5763],NULL},
  {761,3,6,1,&joseki_variations[5764],NULL},
  {762,0,7,1,&joseki_variations[5765],NULL},
  {763,0,8,1,&joseki_variations[5766],NULL},
  {764,0,9,2,&joseki_variations[5767],NULL},
  {796,0,4,1,&joseki_variations[5784],NULL},
  {795,0,2,1,&joseki_variations[5769],NULL},
  {796,0,5,1,&joseki_variations[5770],NULL},
  {797,3,7,1,&joseki_variations[5771],NULL},
  {798,3,10,1,&joseki_variations[5772],NULL},
  {799,0,12,1,&joseki_variations[5773],NULL},
  {800,3,14,1,&joseki_variations[5774],NULL},
  {801,0,16,1,&joseki_variations[5775],NULL},
  {833,0,6,1,&joseki_variations[5776],NULL},
  {834,0,9,1,&joseki_variations[5777],NULL},
  {835,0,13,1,&joseki_variations[5778],NULL},
  {836,3,16,1,&joseki_variations[5779],NULL},
  {837,3,19,1,&joseki_variations[5780],NULL},
  {870,3,7,1,&joseki_variations[5781],NULL},
  {871,3,11,1,&joseki_variations[5782],NULL},
  {872,3,16,1,&joseki_variations[5783],NULL},
  {721,3,1,0,NULL,&joseki[374]},
  {797,3,6,1,&joseki_variations[5785],NULL},
  {798,3,9,1,&joseki_variations[5786],NULL},
  {799,0,11,1,&joseki_variations[5787],NULL},
  {800,3,13,1,&joseki_variations[5788],NULL},
  {801,0,15,1,&joseki_variations[5789],NULL},
  {833,0,5,1,&joseki_variations[5790],NULL},
  {834,0,8,1,&joseki_variations[5791],NULL},
  {835,0,12,1,&joseki_variations[5792],NULL},
  {836,3,15,1,&joseki_variations[5793],NULL},
  {837,3,18,1,&joseki_variations[5794],NULL},
  {870,3,6,1,&joseki_variations[5795],NULL},
  {871,3,10,1,&joseki_variations[5796],NULL},
  {872,3,15,1,&joseki_variations[5797],NULL},
  {795,0,2,0,NULL,&joseki[373]},
  {762,0,6,1,&joseki_variations[5799],NULL},
  {763,0,7,1,&joseki_variations[5800],NULL},
  {764,0,8,1,&joseki_variations[5801],NULL},
  {796,0,4,1,&joseki_variations[5802],NULL},
  {797,3,5,1,&joseki_variations[5803],NULL},
  {798,3,8,1,&joseki_variations[5804],NULL},
  {799,0,10,1,&joseki_variations[5805],NULL},
  {800,3,12,1,&joseki_variations[5806],NULL},
  {801,0,14,1,&joseki_variations[5807],NULL},
  {833,0,5,1,&joseki_variations[5808],NULL},
  {834,0,7,1,&joseki_variations[5809],NULL},
  {835,0,11,1,&joseki_variations[5810],NULL},
  {836,3,14,1,&joseki_variations[5811],NULL},
  {837,3,17,1,&joseki_variations[5812],NULL},
  {870,3,6,1,&joseki_variations[5813],NULL},
  {871,3,9,1,&joseki_variations[5814],NULL},
  {872,3,14,1,&joseki_variations[5815],NULL},
  {760,3,4,0,NULL,&joseki[372]},
  {723,3,3,2,&joseki_variations[5839],NULL},
  {760,0,3,2,&joseki_variations[5818],NULL},
  {724,0,3,1,&joseki_variations[5827],NULL},
  {871,3,4,1,&joseki_variations[5820],NULL},
  {687,3,2,1,&joseki_variations[5821],NULL},
  {724,0,4,1,&joseki_variations[5822],NULL},
  {761,3,6,1,&joseki_variations[5823],NULL},
  {798,3,7,1,&joseki_variations[5824],NULL},
  {725,3,5,1,&joseki_variations[5825],NULL},
  {763,0,8,1,&joseki_variations[5826],NULL},
  {723,3,3,0,NULL,&joseki[755]},
  {761,3,5,1,&joseki_variations[5828],NULL},
  {798,0,6,2,&joseki_variations[5829],NULL},
  {872,0,7,1,&joseki_variations[5835],NULL},
  {871,0,4,1,&joseki_variations[5831],NULL},
  {725,3,4,1,&joseki_variations[5832],NULL},
  {799,3,8,1,&joseki_variations[5833],NULL},
  {763,3,7,1,&joseki_variations[5834],NULL},
  {835,3,7,0,NULL,&joseki[744]},
  {725,3,4,1,&joseki_variations[5836],NULL},
  {799,3,8,1,&joseki_variations[5837],NULL},
  {763,3,7,1,&joseki_variations[5838],NULL},
  {835,3,7,0,NULL,&joseki[331]},
  {725,3,4,1,&joseki_variations[5855],NULL},
  {760,0,4,1,&joseki_variations[5841],NULL},
  {724,3,4,1,&joseki_variations[5842],NULL},
  {761,3,6,1,&joseki_variations[5843],NULL},
  {798,0,7,1,&joseki_variations[5844],NULL},
  {835,0,8,2,&joseki_variations[5845],NULL},
  {872,0,9,1,&joseki_variations[5851],NULL},
  {871,0,5,1,&joseki_variations[5847],NULL},
  {725,3,5,1,&joseki_variations[5848],NULL},
  {799,3,9,1,&joseki_variations[5849],NULL},
  {763,3,8,1,&joseki_variations[5850],NULL},
  {796,0,2,0,NULL,&joseki[742]},
  {725,3,5,1,&joseki_variations[5852],NULL},
  {799,3,9,1,&joseki_variations[5853],NULL},
  {763,3,8,1,&joseki_variations[5854],NULL},
  {796,0,2,0,NULL,&joseki[329]},
  {760,0,4,1,&joseki_variations[5856],NULL},
  {761,3,5,1,&joseki_variations[5857],NULL},
  {763,3,7,1,&joseki_variations[5858],NULL},
  {798,0,6,3,&joseki_variations[5859],NULL},
  {872,0,7,1,&joseki_variations[5871],NULL},
  {835,0,7,2,&joseki_variations[5865],NULL},
  {871,0,5,1,&joseki_variations[5862],NULL},
  {799,3,8,2,&joseki_variations[5863],&joseki[739]},
  {835,0,7,0,NULL,&joseki[740]},
  {724,0,4,0,NULL,&joseki[743]},
  {872,0,8,1,&joseki_variations[5869],NULL},
  {799,3,8,1,&joseki_variations[5867],NULL},
  {871,0,5,1,&joseki_variations[5868],NULL},
  {724,3,4,0,NULL,&joseki[741]},
  {799,3,8,1,&joseki_variations[5870],NULL},
  {724,3,4,0,NULL,&joseki[328]},
  {799,3,8,2,&joseki_variations[5872],&joseki[326]},
  {835,0,7,0,NULL,&joseki[327]},
  {724,0,4,0,NULL,&joseki[330]},
  {725,3,3,1,&joseki_variations[6073],NULL},
  {760,0,3,4,&joseki_variations[5991],NULL},
  {724,3,3,1,&joseki_variations[5877],NULL},
  {758,0,1,2,&joseki_variations[5878],NULL},
  {759,3,3,2,&joseki_variations[5904],NULL},
  {725,0,4,1,&joseki_variations[5880],NULL},
  {727,0,5,1,&joseki_variations[5881],NULL},
  {728,0,6,1,&joseki_variations[5882],NULL},
  {760,0,4,1,&joseki_variations[5883],NULL},
  {761,3,6,1,&joseki_variations[5884],NULL},
  {762,0,8,1,&joseki_variations[5885],NULL},
  {763,0,9,1,&joseki_variations[5886],NULL},
  {764,3,11,1,&joseki_variations[5887],NULL},
  {765,3,13,1,&joseki_variations[5888],NULL},
  {796,0,3,1,&joseki_variations[5889],NULL},
  {797,3,6,1,&joseki_variations[5890],NULL},
  {798,3,9,1,&joseki_variations[5891],NULL},
  {799,0,12,1,&joseki_variations[5892],NULL},
  {800,3,14,1,&joseki_variations[5893],NULL},
  {801,0,17,1,&joseki_variations[5894],NULL},
  {832,3,2,1,&joseki_variations[5895],NULL},
  {833,0,5,1,&joseki_variations[5896],NULL},
  {834,0,9,1,&joseki_variations[5897],NULL},
  {835,0,13,1,&joseki_variations[5898],NULL},
  {836,3,17,1,&joseki_variations[5899],NULL},
  {837,3,20,1,&joseki_variations[5900],NULL},
  {870,3,6,1,&joseki_variations[5901],NULL},
  {871,3,11,1,&joseki_variations[5902],NULL},
  {872,3,16,1,&joseki_variations[5903],NULL},
  {688,3,1,0,NULL,&joseki[482]},
  {761,3,6,2,&joseki_variations[5941],NULL},
  {760,3,5,1,&joseki_variations[5906],NULL},
  {761,3,7,1,&joseki_variations[5907],NULL},
  {762,0,8,1,&joseki_variations[5908],NULL},
  {763,0,9,1,&joseki_variations[5909],NULL},
  {764,0,10,2,&joseki_variations[5910],NULL},
  {796,0,4,1,&joseki_variations[5927],NULL},
  {795,0,2,1,&joseki_variations[5912],NULL},
  {796,0,5,1,&joseki_variations[5913],NULL},
  {797,3,8,1,&joseki_variations[5914],NULL},
  {798,3,11,1,&joseki_variations[5915],NULL},
  {799,0,13,1,&joseki_variations[5916],NULL},
  {800,3,15,1,&joseki_variations[5917],NULL},
  {801,0,17,1,&joseki_variations[5918],NULL},
  {833,0,6,1,&joseki_variations[5919],NULL},
  {834,0,10,1,&joseki_variations[5920],NULL},
  {835,0,14,1,&joseki_variations[5921],NULL},
  {836,3,17,1,&joseki_variations[5922],NULL},
  {837,3,20,1,&joseki_variations[5923],NULL},
  {870,3,7,1,&joseki_variations[5924],NULL},
  {871,3,12,1,&joseki_variations[5925],NULL},
  {872,3,17,1,&joseki_variations[5926],NULL},
  {685,3,1,0,NULL,&joseki[382]},
  {797,3,7,1,&joseki_variations[5928],NULL},
  {798,3,10,1,&joseki_variations[5929],NULL},
  {799,0,12,1,&joseki_variations[5930],NULL},
  {800,3,14,1,&joseki_variations[5931],NULL},
  {801,0,16,1,&joseki_variations[5932],NULL},
  {833,0,5,1,&joseki_variations[5933],NULL},
  {834,0,9,1,&joseki_variations[5934],NULL},
  {835,0,13,1,&joseki_variations[5935],NULL},
  {836,3,16,1,&joseki_variations[5936],NULL},
  {837,3,19,1,&joseki_variations[5937],NULL},
  {870,3,6,1,&joseki_variations[5938],NULL},
  {871,3,11,1,&joseki_variations[5939],NULL},
  {872,3,16,1,&joseki_variations[5940],NULL},
  {795,0,2,0,NULL,&joseki[381]},
  {762,0,7,1,&joseki_variations[5974],NULL},
  {725,0,4,1,&joseki_variations[5943],NULL},
  {762,0,8,1,&joseki_variations[5944],NULL},
  {763,0,9,1,&joseki_variations[5945],NULL},
  {727,0,5,1,&joseki_variations[5946],NULL},
  {764,3,11,1,&joseki_variations[5947],NULL},
  {728,0,6,1,&joseki_variations[5948],NULL},
  {765,3,13,1,&joseki_variations[5949],NULL},
  {796,0,4,1,&joseki_variations[5950],NULL},
  {797,3,6,1,&joseki_variations[5951],NULL},
  {798,3,9,1,&joseki_variations[5952],NULL},
  {799,0,12,1,&joseki_variations[5953],NULL},
  {800,3,14,1,&joseki_variations[5954],NULL},
  {801,0,17,2,&joseki_variations[5955],NULL},
  {833,0,5,1,&joseki_variations[5966],NULL},
  {832,3,2,1,&joseki_variations[5957],NULL},
  {833,0,6,1,&joseki_variations[5958],NULL},
  {834,0,9,1,&joseki_variations[5959],NULL},
  {835,0,13,1,&joseki_variations[5960],NULL},
  {836,3,17,1,&joseki_variations[5961],NULL},
  {837,3,20,1,&joseki_variations[5962],NULL},
  {870,3,7,1,&joseki_variations[5963],NULL},
  {871,3,11,1,&joseki_variations[5964],NULL},
  {872,3,16,1,&joseki_variations[5965],NULL},
  {760,0,5,0,NULL,&joseki[481]},
  {834,0,8,1,&joseki_variations[5967],NULL},
  {835,0,12,1,&joseki_variations[5968],NULL},
  {836,3,16,1,&joseki_variations[5969],NULL},
  {837,3,19,1,&joseki_variations[5970],NULL},
  {870,3,6,1,&joseki_variations[5971],NULL},
  {871,3,10,1,&joseki_variations[5972],NULL},
  {872,3,15,1,&joseki_variations[5973],NULL},
  {832,3,2,0,NULL,&joseki[480]},
  {763,0,8,1,&joseki_variations[5975],NULL},
  {764,0,9,1,&joseki_variations[5976],NULL},
  {796,0,4,1,&joseki_variations[5977],NULL},
  {797,3,6,1,&joseki_variations[5978],NULL},
  {798,3,9,1,&joseki_variations[5979],NULL},
  {799,0,11,1,&joseki_variations[5980],NULL},
  {800,3,13,1,&joseki_variations[5981],NULL},
  {801,0,15,1,&joseki_variations[5982],NULL},
  {833,0,5,1,&joseki_variations[5983],NULL},
  {834,0,8,1,&joseki_variations[5984],NULL},
  {835,0,12,1,&joseki_variations[5985],NULL},
  {836,3,15,1,&joseki_variations[5986],NULL},
  {837,3,18,1,&joseki_variations[5987],NULL},
  {870,3,6,1,&joseki_variations[5988],NULL},
  {871,3,10,1,&joseki_variations[5989],NULL},
  {872,3,15,1,&joseki_variations[5990],NULL},
  {760,3,5,0,NULL,&joseki[380]},
  {761,3,4,3,&joseki_variations[6055],NULL},
  {724,0,3,1,&joseki_variations[6041],NULL},
  {871,0,4,2,&joseki_variations[6030],NULL},
  {797,0,4,2,&joseki_variations[5995],NULL},
  {724,3,3,1,&joseki_variations[6008],NULL},
  {834,3,5,2,&joseki_variations[5997],NULL},
  {761,3,4,1,&joseki_variations[6004],NULL},
  {724,3,3,1,&joseki_variations[5999],NULL},
  {761,3,5,1,&joseki_variations[6000],NULL},
  {798,3,7,1,&joseki_variations[6001],NULL},
  {800,0,8,1,&joseki_variations[6002],NULL},
  {835,0,9,1,&joseki_variations[6003],NULL},
  {833,0,2,0,NULL,&joseki[1593]},
  {798,3,6,1,&joseki_variations[6005],NULL},
  {800,0,7,1,&joseki_variations[6006],NULL},
  {835,0,8,1,&joseki_variations[6007],NULL},
  {724,3,3,0,NULL,&joseki[1592]},
  {761,3,5,2,&joseki_variations[6009],NULL},
  {798,0,7,1,&joseki_variations[6022],NULL},
  {798,3,7,1,&joseki_variations[6011],NULL},
  {800,0,8,1,&joseki_variations[6012],NULL},
  {833,0,2,1,&joseki_variations[6013],NULL},
  {834,3,6,1,&joseki_variations[6014],NULL},
  {835,0,10,2,&joseki_variations[6015],NULL},
  {871,3,7,1,&joseki_variations[6021],&joseki[1594]},
  {870,0,3,1,&joseki_variations[6017],NULL},
  {871,3,8,1,&joseki_variations[6018],NULL},
  {908,3,9,1,&joseki_variations[6019],&joseki[1596]},
  {836,0,11,1,&joseki_variations[6020],&joseki[1597]},
  {685,3,1,0,NULL,&joseki[1598]},
  {870,0,3,0,NULL,&joseki[1595]},
  {872,0,8,1,&joseki_variations[6023],NULL},
  {762,0,6,1,&joseki_variations[6024],NULL},
  {799,3,9,1,&joseki_variations[6025],NULL},
  {836,0,10,1,&joseki_variations[6026],NULL},
  {800,3,10,1,&joseki_variations[6027],NULL},
  {801,3,11,2,&joseki_variations[6028],NULL},
  {725,3,4,0,NULL,&joseki[1040]},
  {685,3,1,0,NULL,&joseki[1041]},
  {945,3,5,1,&joseki_variations[6037],NULL},
  {724,0,3,1,&joseki_variations[6032],NULL},
  {761,3,5,1,&joseki_variations[6033],NULL},
  {798,0,6,1,&joseki_variations[6034],NULL},
  {762,3,6,1,&joseki_variations[6035],NULL},
  {763,3,7,1,&joseki_variations[6036],NULL},
  {797,3,4,0,NULL,&joseki[748]},
  {724,3,3,1,&joseki_variations[6038],NULL},
  {763,3,5,1,&joseki_variations[6039],NULL},
  {798,0,5,1,&joseki_variations[6040],NULL},
  {796,3,2,0,NULL,&joseki[705]},
  {761,3,5,2,&joseki_variations[6042],NULL},
  {798,0,6,1,&joseki_variations[6051],NULL},
  {762,3,6,1,&joseki_variations[6044],NULL},
  {763,3,7,1,&joseki_variations[6045],NULL},
  {797,3,4,1,&joseki_variations[6046],NULL},
  {798,0,7,2,&joseki_variations[6047],NULL},
  {872,0,8,1,&joseki_variations[6050],NULL},
  {871,0,5,1,&joseki_variations[6049],NULL},
  {759,0,2,0,NULL,&joseki[749]},
  {759,0,2,0,NULL,&joseki[336]},
  {872,0,7,1,&joseki_variations[6052],NULL},
  {762,3,6,1,&joseki_variations[6053],NULL},
  {763,3,7,1,&joseki_variations[6054],NULL},
  {797,3,4,0,NULL,&joseki[335]},
  {763,3,5,1,&joseki_variations[6071],NULL},
  {763,0,5,1,&joseki_variations[6064],NULL},
  {762,3,5,1,&joseki_variations[6058],NULL},
  {797,0,4,1,&joseki_variations[6059],NULL},
  {798,0,6,1,&joseki_variations[6060],NULL},
  {801,3,8,1,&joseki_variations[6061],NULL},
  {872,0,7,2,&joseki_variations[6062],NULL},
  {768,3,6,0,NULL,&joseki[1016]},
  {1019,0,5,0,NULL,&joseki[1017]},
  {797,0,4,1,&joseki_variations[6065],NULL},
  {798,3,6,1,&joseki_variations[6066],NULL},
  {800,3,8,1,&joseki_variations[6067],NULL},
  {835,0,7,1,&joseki_variations[6068],NULL},
  {836,3,8,1,&joseki_variations[6069],NULL},
  {872,0,8,1,&joseki_variations[6070],NULL},
  {724,3,3,0,NULL,&joseki[788]},
  {798,0,5,1,&joseki_variations[6072],NULL},
  {725,3,3,0,NULL,&joseki[324]},
  {760,0,3,2,&joseki_variations[6074],NULL},
  {797,0,4,1,&joseki_variations[6082],NULL},
  {761,3,4,1,&joseki_variations[6076],NULL},
  {763,3,6,1,&joseki_variations[6077],NULL},
  {798,0,5,2,&joseki_variations[6078],NULL},
  {872,0,6,1,&joseki_variations[6081],NULL},
  {871,0,4,1,&joseki_variations[6080],NULL},
  {686,0,1,0,NULL,&joseki[738]},
  {686,0,1,0,NULL,&joseki[325]},
  {761,3,4,1,&joseki_variations[6083],NULL},
  {763,3,6,1,&joseki_variations[6084],NULL},
  {798,0,6,2,&joseki_variations[6085],NULL},
  {872,0,7,1,&joseki_variations[6088],NULL},
  {871,0,5,1,&joseki_variations[6087],NULL},
  {685,3,1,0,NULL,&joseki[714]},
  {685,3,1,0,NULL,&joseki[299]},
  {796,0,3,1,&joseki_variations[6302],NULL},
  {723,3,2,2,&joseki_variations[6210],NULL},
  {686,0,1,1,&joseki_variations[6198],NULL},
  {796,3,3,3,&joseki_variations[6093],NULL},
  {797,3,4,1,&joseki_variations[6165],NULL},
  {870,3,4,1,&joseki_variations[6103],NULL},
  {723,3,2,1,&joseki_variations[6096],NULL},
  {760,0,4,1,&joseki_variations[6097],NULL},
  {871,0,6,1,&joseki_variations[6098],NULL},
  {945,3,7,1,&joseki_variations[6099],NULL},
  {724,3,3,1,&joseki_variations[6100],NULL},
  {763,3,6,1,&joseki_variations[6101],NULL},
  {798,0,7,1,&joseki_variations[6102],NULL},
  {834,3,6,0,NULL,&joseki[706]},
  {907,0,5,2,&joseki_variations[6104],NULL},
  {686,3,1,1,&joseki_variations[6133],NULL},
  {944,0,6,1,&joseki_variations[6106],NULL},
  {723,3,2,1,&joseki_variations[6107],NULL},
  {760,0,4,1,&joseki_variations[6108],NULL},
  {797,3,6,1,&joseki_variations[6109],NULL},
  {834,3,7,1,&joseki_variations[6110],NULL},
  {871,3,9,1,&joseki_variations[6111],NULL},
  {908,0,11,1,&joseki_variations[6112],NULL},
  {945,3,13,1,&joseki_variations[6113],NULL},
  {724,3,3,1,&joseki_variations[6114],NULL},
  {761,3,6,1,&joseki_variations[6115],NULL},
  {798,0,9,1,&joseki_variations[6116],NULL},
  {835,0,11,1,&joseki_variations[6117],NULL},
  {872,0,14,1,&joseki_variations[6118],NULL},
  {909,3,17,1,&joseki_variations[6119],NULL},
  {725,3,4,1,&joseki_variations[6120],NULL},
  {762,0,8,1,&joseki_variations[6121],NULL},
  {982,0,14,1,&joseki_variations[6122],&joseki[1179]},
  {910,3,20,2,&joseki_variations[6123],&joseki[1180]},
  {837,0,14,1,&joseki_variations[6132],&joseki[1181]},
  {763,3,9,1,&joseki_variations[6125],NULL},
  {837,0,15,1,&joseki_variations[6126],NULL},
  {874,0,19,1,&joseki_variations[6127],&joseki[1183]},
  {984,3,24,1,&joseki_variations[6128],&joseki[1184]},
  {1093,0,15,1,&joseki_variations[6129],&joseki[1185]},
  {949,3,26,1,&joseki_variations[6130],&joseki[1186]},
  {840,0,16,1,&joseki_variations[6131],&joseki[1187]},
  {766,3,10,0,NULL,&joseki[1188]},
  {763,3,9,0,NULL,&joseki[1182]},
  {797,3,5,1,&joseki_variations[6134],NULL},
  {834,3,6,1,&joseki_variations[6135],NULL},
  {871,0,8,2,&joseki_variations[6136],NULL},
  {724,0,3,1,&joseki_variations[6152],NULL},
  {687,0,2,1,&joseki_variations[6138],NULL},
  {724,0,4,1,&joseki_variations[6139],NULL},
  {761,0,6,1,&joseki_variations[6140],NULL},
  {798,0,9,1,&joseki_variations[6141],NULL},
  {835,3,11,1,&joseki_variations[6142],NULL},
  {872,0,14,1,&joseki_variations[6143],NULL},
  {762,3,7,1,&joseki_variations[6144],NULL},
  {799,3,11,1,&joseki_variations[6145],NULL},
  {836,0,14,1,&joseki_variations[6146],NULL},
  {763,3,8,1,&joseki_variations[6147],NULL},
  {800,0,13,1,&joseki_variations[6148],NULL},
  {837,0,17,1,&joseki_variations[6149],NULL},
  {764,3,9,1,&joseki_variations[6150],NULL},
  {801,3,15,1,&joseki_variations[6151],NULL},
  {685,3,1,0,NULL,&joseki[461]},
  {761,0,5,1,&joseki_variations[6153],NULL},
  {798,0,8,1,&joseki_variations[6154],NULL},
  {835,3,10,1,&joseki_variations[6155],NULL},
  {872,0,13,1,&joseki_variations[6156],NULL},
  {762,3,6,1,&joseki_variations[6157],NULL},
  {799,3,10,1,&joseki_variations[6158],NULL},
  {836,0,13,1,&joseki_variations[6159],NULL},
  {763,3,7,1,&joseki_variations[6160],NULL},
  {800,0,12,1,&joseki_variations[6161],NULL},
  {837,0,16,1,&joseki_variations[6162],NULL},
  {764,3,8,1,&joseki_variations[6163],NULL},
  {801,3,14,1,&joseki_variations[6164],NULL},
  {687,0,2,0,NULL,&joseki[460]},
  {834,3,5,2,&joseki_variations[6166],NULL},
  {871,0,6,1,&joseki_variations[6184],NULL},
  {870,3,4,1,&joseki_variations[6168],NULL},
  {871,0,7,1,&joseki_variations[6169],NULL},
  {724,0,2,1,&joseki_variations[6170],NULL},
  {761,0,4,1,&joseki_variations[6171],NULL},
  {798,0,7,1,&joseki_variations[6172],NULL},
  {835,3,9,1,&joseki_variations[6173],NULL},
  {872,0,12,1,&joseki_variations[6174],NULL},
  {762,3,5,1,&joseki_variations[6175],NULL},
  {799,3,9,1,&joseki_variations[6176],NULL},
  {836,0,12,1,&joseki_variations[6177],NULL},
  {763,3,6,1,&joseki_variations[6178],NULL},
  {800,0,11,1,&joseki_variations[6179],NULL},
  {837,0,15,1,&joseki_variations[6180],NULL},
  {764,3,7,1,&joseki_variations[6181],NULL},
  {801,3,13,1,&joseki_variations[6182],NULL},
  {907,0,5,1,&joseki_variations[6183],&joseki[458]},
  {686,3,1,0,NULL,&joseki[459]},
  {724,0,2,1,&joseki_variations[6185],NULL},
  {761,0,4,1,&joseki_variations[6186],NULL},
  {798,0,7,1,&joseki_variations[6187],NULL},
  {835,3,9,1,&joseki_variations[6188],NULL},
  {872,0,11,1,&joseki_variations[6189],NULL},
  {762,3,5,1,&joseki_variations[6190],NULL},
  {799,3,9,1,&joseki_variations[6191],NULL},
  {836,0,12,1,&joseki_variations[6192],NULL},
  {763,3,6,1,&joseki_variations[6193],NULL},
  {800,0,11,1,&joseki_variations[6194],NULL},
  {837,0,15,1,&joseki_variations[6195],NULL},
  {764,3,7,1,&joseki_variations[6196],NULL},
  {801,3,13,1,&joseki_variations[6197],NULL},
  {870,3,4,0,NULL,&joseki[457]},
  {723,3,3,1,&joseki_variations[6199],NULL},
  {725,3,4,1,&joseki_variations[6200],NULL},
  {760,0,5,1,&joseki_variations[6201],NULL},
  {761,3,6,1,&joseki_variations[6202],NULL},
  {763,3,8,1,&joseki_variations[6203],NULL},
  {798,0,7,2,&joseki_variations[6204],NULL},
  {872,0,8,1,&joseki_variations[6208],NULL},
  {799,3,9,1,&joseki_variations[6206],NULL},
  {871,0,6,1,&joseki_variations[6207],NULL},
  {835,3,8,0,NULL,&joseki[718]},
  {799,3,9,1,&joseki_variations[6209],NULL},
  {835,3,8,0,NULL,&joseki[304]},
  {725,3,3,1,&joseki_variations[6287],NULL},
  {760,0,4,1,&joseki_variations[6212],NULL},
  {797,3,5,2,&joseki_variations[6213],NULL},
  {724,0,3,1,&joseki_variations[6266],NULL},
  {834,3,6,2,&joseki_variations[6215],NULL},
  {871,3,7,2,&joseki_variations[6241],NULL},
  {870,3,3,1,&joseki_variations[6217],NULL},
  {871,3,8,1,&joseki_variations[6218],NULL},
  {907,0,4,1,&joseki_variations[6219],NULL},
  {908,0,10,2,&joseki_variations[6220],NULL},
  {945,3,11,1,&joseki_variations[6232],NULL},
  {944,0,5,1,&joseki_variations[6222],NULL},
  {945,3,12,1,&joseki_variations[6223],NULL},
  {724,3,3,1,&joseki_variations[6224],NULL},
  {761,3,6,1,&joseki_variations[6225],NULL},
  {798,0,8,1,&joseki_variations[6226],NULL},
  {835,0,10,1,&joseki_variations[6227],NULL},
  {872,0,13,1,&joseki_variations[6228],NULL},
  {909,3,16,1,&joseki_variations[6229],NULL},
  {725,3,4,1,&joseki_variations[6230],NULL},
  {762,0,8,1,&joseki_variations[6231],NULL},
  {796,3,3,0,NULL,&joseki[1178]},
  {724,3,3,1,&joseki_variations[6233],NULL},
  {761,3,6,1,&joseki_variations[6234],NULL},
  {798,0,8,1,&joseki_variations[6235],NULL},
  {835,0,10,1,&joseki_variations[6236],NULL},
  {872,0,13,1,&joseki_variations[6237],NULL},
  {909,3,16,1,&joseki_variations[6238],NULL},
  {725,3,4,1,&joseki_variations[6239],NULL},
  {762,0,8,1,&joseki_variations[6240],NULL},
  {944,0,5,0,NULL,&joseki[1177]},
  {908,0,8,1,&joseki_variations[6254],NULL},
  {907,0,3,1,&joseki_variations[6243],NULL},
  {908,0,9,1,&joseki_variations[6244],NULL},
  {945,3,10,1,&joseki_variations[6245],NULL},
  {724,3,3,1,&joseki_variations[6246],NULL},
  {761,3,6,1,&joseki_variations[6247],NULL},
  {798,0,8,1,&joseki_variations[6248],NULL},
  {835,0,10,1,&joseki_variations[6249],NULL},
  {872,0,12,1,&joseki_variations[6250],NULL},
  {909,3,15,1,&joseki_variations[6251],NULL},
  {725,3,4,1,&joseki_variations[6252],NULL},
  {762,0,8,1,&joseki_variations[6253],NULL},
  {870,3,3,0,NULL,&joseki[1176]},
  {945,3,9,1,&joseki_variations[6255],NULL},
  {724,3,3,1,&joseki_variations[6256],NULL},
  {761,3,6,1,&joseki_variations[6257],NULL},
  {798,0,8,1,&joseki_variations[6258],NULL},
  {835,0,10,1,&joseki_variations[6259],NULL},
  {872,0,12,1,&joseki_variations[6260],NULL},
  {909,3,14,2,&joseki_variations[6261],NULL},
  {762,0,7,1,&joseki_variations[6265],NULL},
  {725,3,4,1,&joseki_variations[6263],NULL},
  {762,0,8,1,&joseki_variations[6264],NULL},
  {907,0,3,0,NULL,&joseki[1175]},
  {725,3,4,0,NULL,&joseki[1174]},
  {761,3,6,1,&joseki_variations[6267],NULL},
  {798,0,8,4,&joseki_variations[6268],NULL},
  {872,0,9,1,&joseki_variations[6284],NULL},
  {835,3,9,1,&joseki_variations[6280],NULL},
  {834,0,6,1,&joseki_variations[6275],NULL},
  {871,0,6,1,&joseki_variations[6272],NULL},
  {762,3,7,1,&joseki_variations[6273],NULL},
  {763,3,8,1,&joseki_variations[6274],NULL},
  {835,3,9,0,NULL,&joseki[750]},
  {835,3,10,1,&joseki_variations[6276],NULL},
  {872,0,11,1,&joseki_variations[6277],NULL},
  {762,3,7,1,&joseki_variations[6278],NULL},
  {763,3,8,1,&joseki_variations[6279],NULL},
  {799,3,10,0,NULL,&joseki[339]},
  {872,0,10,1,&joseki_variations[6281],NULL},
  {762,3,7,1,&joseki_variations[6282],NULL},
  {763,3,8,1,&joseki_variations[6283],NULL},
  {834,0,6,0,NULL,&joseki[338]},
  {762,3,7,1,&joseki_variations[6285],NULL},
  {763,3,8,1,&joseki_variations[6286],NULL},
  {835,3,9,0,NULL,&joseki[337]},
  {760,0,4,1,&joseki_variations[6288],NULL},
  {761,3,5,1,&joseki_variations[6289],NULL},
  {763,3,7,1,&joseki_variations[6290],NULL},
  {798,0,6,3,&joseki_variations[6291],NULL},
  {872,0,7,1,&joseki_variations[6301],NULL},
  {835,0,7,2,&joseki_variations[6295],NULL},
  {871,0,5,1,&joseki_variations[6294],NULL},
  {799,3,8,0,NULL,&joseki[716]},
  {872,0,8,1,&joseki_variations[6299],NULL},
  {799,3,8,1,&joseki_variations[6297],NULL},
  {871,0,5,1,&joseki_variations[6298],NULL},
  {685,3,1,0,NULL,&joseki[717]},
  {799,3,8,1,&joseki_variations[6300],NULL},
  {685,3,1,0,NULL,&joseki[303]},
  {799,3,8,0,NULL,&joseki[302]},
  {723,3,2,2,&joseki_variations[6303],NULL},
  {760,0,4,1,&joseki_variations[6314],NULL},
  {833,3,4,1,&joseki_variations[6305],NULL},
  {760,3,4,1,&joseki_variations[6306],NULL},
  {797,0,6,1,&joseki_variations[6307],NULL},
  {834,3,8,1,&joseki_variations[6308],NULL},
  {724,0,3,1,&joseki_variations[6309],NULL},
  {761,0,6,1,&joseki_variations[6310],NULL},
  {763,0,7,1,&joseki_variations[6311],NULL},
  {798,3,9,1,&joseki_variations[6312],NULL},
  {835,3,12,1,&joseki_variations[6313],NULL},
  {982,3,9,0,NULL,&joseki[1320]},
  {797,3,6,1,&joseki_variations[6315],NULL},
  {834,0,7,1,&joseki_variations[6316],NULL},
  {761,3,5,1,&joseki_variations[6317],NULL},
  {798,3,8,1,&joseki_variations[6318],NULL},
  {836,3,10,1,&joseki_variations[6319],NULL},
  {871,3,8,0,NULL,&joseki[21]},
  {723,3,2,1,&joseki_variations[6387],NULL},
  {834,0,3,1,&joseki_variations[6358],NULL},
  {797,3,3,2,&joseki_variations[6323],NULL},
  {834,0,4,1,&joseki_variations[6342],NULL},
  {833,0,3,1,&joseki_variations[6325],NULL},
  {834,0,5,1,&joseki_variations[6326],NULL},
  {870,3,4,1,&joseki_variations[6327],NULL},
  {871,3,7,1,&joseki_variations[6328],NULL},
  {724,3,2,1,&joseki_variations[6329],NULL},
  {761,3,3,1,&joseki_variations[6330],NULL},
  {798,3,6,1,&joseki_variations[6331],NULL},
  {835,0,9,1,&joseki_variations[6332],NULL},
  {872,3,12,1,&joseki_variations[6333],NULL},
  {762,0,4,1,&joseki_variations[6334],NULL},
  {799,0,8,1,&joseki_variations[6335],NULL},
  {836,3,12,1,&joseki_variations[6336],NULL},
  {763,0,5,1,&joseki_variations[6337],NULL},
  {800,3,10,1,&joseki_variations[6338],NULL},
  {837,3,15,1,&joseki_variations[6339],NULL},
  {764,0,6,1,&joseki_variations[6340],NULL},
  {801,0,12,1,&joseki_variations[6341],NULL},
  {759,3,2,0,NULL,&joseki[370]},
  {870,3,3,1,&joseki_variations[6343],NULL},
  {871,3,6,1,&joseki_variations[6344],NULL},
  {724,3,2,1,&joseki_variations[6345],NULL},
  {761,3,3,1,&joseki_variations[6346],NULL},
  {798,3,6,1,&joseki_variations[6347],NULL},
  {835,0,8,1,&joseki_variations[6348],NULL},
  {872,3,11,1,&joseki_variations[6349],NULL},
  {762,0,4,1,&joseki_variations[6350],NULL},
  {799,0,8,1,&joseki_variations[6351],NULL},
  {836,3,11,1,&joseki_variations[6352],NULL},
  {763,0,5,1,&joseki_variations[6353],NULL},
  {800,3,10,1,&joseki_variations[6354],NULL},
  {837,3,14,1,&joseki_variations[6355],NULL},
  {764,0,6,1,&joseki_variations[6356],NULL},
  {801,0,12,1,&joseki_variations[6357],NULL},
  {833,0,3,0,NULL,&joseki[369]},
  {870,3,3,1,&joseki_variations[6359],NULL},
  {871,3,5,1,&joseki_variations[6360],NULL},
  {724,3,2,1,&joseki_variations[6361],NULL},
  {761,3,3,1,&joseki_variations[6362],NULL},
  {798,3,5,1,&joseki_variations[6363],NULL},
  {835,0,7,1,&joseki_variations[6364],NULL},
  {872,3,10,2,&joseki_variations[6365],NULL},
  {762,0,4,1,&joseki_variations[6379],NULL},
  {725,0,3,1,&joseki_variations[6367],NULL},
  {762,0,5,1,&joseki_variations[6368],NULL},
  {799,0,8,1,&joseki_variations[6369],NULL},
  {836,3,11,1,&joseki_variations[6370],NULL},
  {763,0,6,1,&joseki_variations[6371],NULL},
  {800,3,10,1,&joseki_variations[6372],NULL},
  {837,3,14,1,&joseki_variations[6373],NULL},
  {727,0,4,1,&joseki_variations[6374],NULL},
  {764,3,8,1,&joseki_variations[6375],NULL},
  {801,0,13,1,&joseki_variations[6376],NULL},
  {728,0,5,1,&joseki_variations[6377],NULL},
  {765,3,10,1,&joseki_variations[6378],NULL},
  {759,3,2,0,NULL,&joseki[474]},
  {799,0,7,1,&joseki_variations[6380],NULL},
  {836,3,10,1,&joseki_variations[6381],NULL},
  {763,0,5,1,&joseki_variations[6382],NULL},
  {800,3,9,1,&joseki_variations[6383],NULL},
  {837,3,13,1,&joseki_variations[6384],NULL},
  {764,0,6,1,&joseki_variations[6385],NULL},
  {801,0,11,1,&joseki_variations[6386],NULL},
  {797,3,3,0,NULL,&joseki[368]},
  {760,0,3,1,&joseki_variations[6388],NULL},
  {797,3,5,1,&joseki_variations[6389],NULL},
  {834,0,6,1,&joseki_variations[6390],NULL},
  {761,3,4,1,&joseki_variations[6391],NULL},
  {798,3,7,1,&joseki_variations[6392],NULL},
  {836,3,9,1,&joseki_variations[6393],NULL},
  {759,0,2,0,NULL,&joseki[20]},
  {761,3,3,1,&joseki_variations[6402],NULL},
  {871,3,3,1,&joseki_variations[6396],NULL},
  {724,0,2,1,&joseki_variations[6397],NULL},
  {761,3,4,1,&joseki_variations[6398],NULL},
  {798,3,5,1,&joseki_variations[6399],NULL},
  {725,3,3,1,&joseki_variations[6400],NULL},
  {763,0,6,1,&joseki_variations[6401],NULL},
  {687,3,1,0,NULL,&joseki[754]},
  {796,0,2,1,&joseki_variations[6403],NULL},
  {797,3,4,1,&joseki_variations[6404],NULL},
  {798,3,6,1,&joseki_variations[6405],NULL},
  {834,0,5,1,&joseki_variations[6406],NULL},
  {836,3,8,1,&joseki_variations[6407],NULL},
  {723,3,2,0,NULL,&joseki[19]},
  {760,0,3,5,&joseki_variations[6688],NULL},
  {796,3,3,2,&joseki_variations[6653],NULL},
  {796,0,3,3,&joseki_variations[6580],NULL},
  {833,3,3,1,&joseki_variations[6548],NULL},
  {723,0,2,3,&joseki_variations[6439],NULL},
  {723,3,2,1,&joseki_variations[6414],NULL},
  {760,0,4,2,&joseki_variations[6415],NULL},
  {761,3,5,1,&joseki_variations[6429],NULL},
  {797,0,5,1,&joseki_variations[6417],NULL},
  {724,3,3,1,&joseki_variations[6418],NULL},
  {761,3,6,1,&joseki_variations[6419],NULL},
  {798,0,8,1,&joseki_variations[6420],NULL},
  {835,0,9,1,&joseki_variations[6421],NULL},
  {762,3,7,1,&joseki_variations[6422],NULL},
  {799,3,10,1,&joseki_variations[6423],NULL},
  {836,0,12,1,&joseki_variations[6424],NULL},
  {763,3,8,1,&joseki_variations[6425],NULL},
  {800,0,12,1,&joseki_variations[6426],NULL},
  {837,0,15,1,&joseki_variations[6427],NULL},
  {801,3,13,1,&joseki_variations[6428],NULL},
  {796,0,3,0,NULL,&joseki[686]},
  {798,0,6,1,&joseki_variations[6430],NULL},
  {835,0,7,1,&joseki_variations[6431],NULL},
  {762,3,6,1,&joseki_variations[6432],NULL},
  {799,3,8,1,&joseki_variations[6433],NULL},
  {836,0,10,1,&joseki_variations[6434],NULL},
  {763,3,7,1,&joseki_variations[6435],NULL},
  {800,0,10,1,&joseki_variations[6436],NULL},
  {837,0,13,1,&joseki_variations[6437],NULL},
  {801,3,11,1,&joseki_variations[6438],NULL},
  {797,0,5,0,NULL,&joseki[685]},
  {760,0,4,2,&joseki_variations[6503],NULL},
  {833,0,3,3,&joseki_variations[6460],NULL},
  {760,3,4,1,&joseki_variations[6442],NULL},
  {797,0,5,1,&joseki_variations[6443],NULL},
  {834,0,6,2,&joseki_variations[6444],NULL},
  {761,0,5,1,&joseki_variations[6452],NULL},
  {724,0,3,1,&joseki_variations[6446],NULL},
  {761,0,6,1,&joseki_variations[6447],NULL},
  {798,3,8,1,&joseki_variations[6448],NULL},
  {835,3,10,1,&joseki_variations[6449],NULL},
  {762,3,7,1,&joseki_variations[6450],NULL},
  {800,3,10,1,&joseki_variations[6451],NULL},
  {871,3,7,0,NULL,&joseki[1585]},
  {798,3,7,2,&joseki_variations[6453],NULL},
  {800,3,8,1,&joseki_variations[6458],NULL},
  {835,3,9,1,&joseki_variations[6455],NULL},
  {762,3,6,1,&joseki_variations[6456],NULL},
  {800,3,9,1,&joseki_variations[6457],NULL},
  {724,0,3,0,NULL,&joseki[1584]},
  {835,3,9,1,&joseki_variations[6459],NULL},
  {762,3,6,0,NULL,&joseki[1583]},
  {870,3,4,1,&joseki_variations[6489],NULL},
  {797,0,4,1,&joseki_variations[6477],NULL},
  {870,0,4,1,&joseki_variations[6463],NULL},
  {907,3,5,1,&joseki_variations[6464],NULL},
  {725,3,3,1,&joseki_variations[6465],NULL},
  {760,0,4,1,&joseki_variations[6466],NULL},
  {797,0,5,1,&joseki_variations[6467],NULL},
  {871,3,8,1,&joseki_variations[6468],NULL},
  {761,0,5,1,&joseki_variations[6469],NULL},
  {798,3,7,1,&joseki_variations[6470],NULL},
  {835,3,9,1,&joseki_variations[6471],NULL},
  {872,3,12,1,&joseki_variations[6472],NULL},
  {762,3,7,1,&joseki_variations[6473],NULL},
  {799,0,10,1,&joseki_variations[6474],NULL},
  {800,3,11,1,&joseki_variations[6475],NULL},
  {801,0,12,1,&joseki_variations[6476],NULL},
  {945,3,10,0,NULL,&joseki[1076]},
  {761,0,4,1,&joseki_variations[6478],NULL},
  {798,3,6,1,&joseki_variations[6479],NULL},
  {835,3,8,1,&joseki_variations[6480],NULL},
  {870,0,4,1,&joseki_variations[6481],NULL},
  {872,3,10,1,&joseki_variations[6482],NULL},
  {907,3,5,1,&joseki_variations[6483],NULL},
  {725,3,3,1,&joseki_variations[6484],NULL},
  {762,3,6,1,&joseki_variations[6485],NULL},
  {799,0,9,1,&joseki_variations[6486],NULL},
  {800,3,10,1,&joseki_variations[6487],NULL},
  {801,0,11,1,&joseki_variations[6488],NULL},
  {871,3,7,0,NULL,&joseki[1075]},
  {760,3,4,1,&joseki_variations[6490],NULL},
  {797,0,5,1,&joseki_variations[6491],NULL},
  {724,0,3,1,&joseki_variations[6492],NULL},
  {761,0,6,1,&joseki_variations[6493],NULL},
  {798,3,8,1,&joseki_variations[6494],NULL},
  {835,3,10,1,&joseki_variations[6495],NULL},
  {872,3,12,1,&joseki_variations[6496],NULL},
  {725,3,4,1,&joseki_variations[6497],NULL},
  {762,3,8,1,&joseki_variations[6498],NULL},
  {799,0,11,1,&joseki_variations[6499],NULL},
  {800,0,12,1,&joseki_variations[6500],NULL},
  {727,3,5,1,&joseki_variations[6501],NULL},
  {801,0,14,1,&joseki_variations[6502],NULL},
  {796,3,3,0,NULL,&joseki[1058]},
  {724,3,3,2,&joseki_variations[6524],NULL},
  {797,3,5,1,&joseki_variations[6505],NULL},
  {834,3,6,1,&joseki_variations[6506],NULL},
  {871,0,7,1,&joseki_variations[6507],NULL},
  {945,3,8,1,&joseki_variations[6508],NULL},
  {761,3,5,1,&joseki_variations[6509],NULL},
  {798,0,7,1,&joseki_variations[6510],NULL},
  {835,3,9,2,&joseki_variations[6511],NULL},
  {799,0,8,2,&joseki_variations[6518],NULL},
  {762,0,6,1,&joseki_variations[6513],NULL},
  {799,0,9,1,&joseki_variations[6514],NULL},
  {836,0,12,1,&joseki_variations[6515],NULL},
  {873,3,14,1,&joseki_variations[6516],NULL},
  {837,3,13,1,&joseki_variations[6517],NULL},
  {874,3,16,0,NULL,&joseki[1508]},
  {837,3,11,1,&joseki_variations[6523],&joseki[1504]},
  {836,0,11,1,&joseki_variations[6520],NULL},
  {837,3,12,1,&joseki_variations[6521],NULL},
  {873,3,13,1,&joseki_variations[6522],&joseki[1506]},
  {762,0,6,0,NULL,&joseki[1507]},
  {836,0,11,0,NULL,&joseki[1505]},
  {761,0,6,1,&joseki_variations[6531],NULL},
  {797,3,5,1,&joseki_variations[6526],NULL},
  {761,3,6,1,&joseki_variations[6527],NULL},
  {763,3,7,1,&joseki_variations[6528],NULL},
  {798,0,8,1,&joseki_variations[6529],NULL},
  {835,0,9,1,&joseki_variations[6530],NULL},
  {796,3,3,0,NULL,&joseki[1315]},
  {762,3,7,1,&joseki_variations[6532],NULL},
  {763,3,8,1,&joseki_variations[6533],NULL},
  {795,3,1,1,&joseki_variations[6534],NULL},
  {797,3,6,1,&joseki_variations[6535],NULL},
  {798,0,9,1,&joseki_variations[6536],NULL},
  {799,3,11,1,&joseki_variations[6537],NULL},
  {800,0,13,1,&joseki_variations[6538],NULL},
  {801,3,14,1,&joseki_variations[6539],NULL},
  {833,3,4,1,&joseki_variations[6540],NULL},
  {834,3,8,1,&joseki_variations[6541],NULL},
  {835,3,12,1,&joseki_variations[6542],NULL},
  {836,0,15,1,&joseki_variations[6543],NULL},
  {837,0,18,1,&joseki_variations[6544],NULL},
  {870,0,5,1,&joseki_variations[6545],NULL},
  {871,0,10,1,&joseki_variations[6546],NULL},
  {872,0,15,1,&joseki_variations[6547],NULL},
  {721,3,1,0,NULL,&joseki[533]},
  {834,3,4,1,&joseki_variations[6549],NULL},
  {870,0,4,1,&joseki_variations[6550],NULL},
  {871,0,6,1,&joseki_variations[6551],NULL},
  {724,0,2,1,&joseki_variations[6552],NULL},
  {761,0,4,1,&joseki_variations[6553],NULL},
  {798,0,5,1,&joseki_variations[6554],NULL},
  {835,3,8,1,&joseki_variations[6555],NULL},
  {872,0,11,2,&joseki_variations[6556],NULL},
  {762,3,5,1,&joseki_variations[6572],NULL},
  {688,0,1,1,&joseki_variations[6558],NULL},
  {725,3,4,1,&joseki_variations[6559],NULL},
  {762,3,7,1,&joseki_variations[6560],NULL},
  {799,3,9,1,&joseki_variations[6561],NULL},
  {836,0,13,1,&joseki_variations[6562],NULL},
  {726,3,5,1,&joseki_variations[6563],NULL},
  {763,3,9,1,&joseki_variations[6564],NULL},
  {800,0,12,1,&joseki_variations[6565],NULL},
  {837,0,17,1,&joseki_variations[6566],NULL},
  {727,3,6,1,&joseki_variations[6567],NULL},
  {764,0,11,1,&joseki_variations[6568],NULL},
  {801,3,15,1,&joseki_variations[6569],NULL},
  {728,3,7,1,&joseki_variations[6570],NULL},
  {765,0,13,1,&joseki_variations[6571],NULL},
  {721,3,1,0,NULL,&joseki[497]},
  {799,3,7,1,&joseki_variations[6573],NULL},
  {836,0,11,1,&joseki_variations[6574],NULL},
  {763,3,6,1,&joseki_variations[6575],NULL},
  {800,0,9,1,&joseki_variations[6576],NULL},
  {837,0,14,1,&joseki_variations[6577],NULL},
  {764,3,7,1,&joseki_variations[6578],NULL},
  {801,3,11,1,&joseki_variations[6579],NULL},
  {721,3,1,0,NULL,&joseki[391]},
  {797,3,4,1,&joseki_variations[6635],NULL},
  {833,0,4,1,&joseki_variations[6603],NULL},
  {723,0,2,2,&joseki_variations[6583],NULL},
  {760,0,4,1,&joseki_variations[6595],NULL},
  {760,3,4,1,&joseki_variations[6585],NULL},
  {797,0,6,1,&joseki_variations[6586],NULL},
  {834,0,7,1,&joseki_variations[6587],NULL},
  {871,3,8,1,&joseki_variations[6588],NULL},
  {724,0,3,1,&joseki_variations[6589],NULL},
  {761,0,6,1,&joseki_variations[6590],NULL},
  {798,3,9,1,&joseki_variations[6591],NULL},
  {835,3,11,1,&joseki_variations[6592],NULL},
  {762,3,7,1,&joseki_variations[6593],NULL},
  {800,3,11,1,&joseki_variations[6594],NULL},
  {833,3,4,0,NULL,&joseki[1586]},
  {797,3,6,1,&joseki_variations[6596],NULL},
  {834,3,7,1,&joseki_variations[6597],NULL},
  {724,3,3,1,&joseki_variations[6598],NULL},
  {761,3,6,1,&joseki_variations[6599],NULL},
  {763,3,7,1,&joseki_variations[6600],NULL},
  {798,0,9,1,&joseki_variations[6601],NULL},
  {835,0,11,1,&joseki_variations[6602],NULL},
  {833,3,4,0,NULL,&joseki[1312]},
  {870,3,5,1,&joseki_variations[6604],NULL},
  {723,3,2,1,&joseki_variations[6605],NULL},
  {797,3,5,1,&joseki_variations[6606],NULL},
  {834,0,7,1,&joseki_variations[6607],NULL},
  {871,3,9,1,&joseki_variations[6608],NULL},
  {724,3,3,1,&joseki_variations[6609],NULL},
  {761,3,5,1,&joseki_variations[6610],NULL},
  {798,3,8,1,&joseki_variations[6611],NULL},
  {835,0,11,1,&joseki_variations[6612],NULL},
  {872,3,14,2,&joseki_variations[6613],NULL},
  {762,0,6,1,&joseki_variations[6627],NULL},
  {725,0,4,1,&joseki_variations[6615],NULL},
  {762,0,7,1,&joseki_variations[6616],NULL},
  {799,0,11,1,&joseki_variations[6617],NULL},
  {836,3,15,1,&joseki_variations[6618],NULL},
  {763,0,8,1,&joseki_variations[6619],NULL},
  {800,3,13,1,&joseki_variations[6620],NULL},
  {837,3,18,1,&joseki_variations[6621],NULL},
  {727,0,5,1,&joseki_variations[6622],NULL},
  {764,3,10,1,&joseki_variations[6623],NULL},
  {801,0,16,1,&joseki_variations[6624],NULL},
  {728,0,6,1,&joseki_variations[6625],NULL},
  {765,3,12,1,&joseki_variations[6626],NULL},
  {758,0,1,0,NULL,&joseki[479]},
  {799,0,10,1,&joseki_variations[6628],NULL},
  {836,3,14,1,&joseki_variations[6629],NULL},
  {763,0,7,1,&joseki_variations[6630],NULL},
  {800,3,12,1,&joseki_variations[6631],NULL},
  {837,3,17,1,&joseki_variations[6632],NULL},
  {764,0,8,1,&joseki_variations[6633],NULL},
  {801,0,14,1,&joseki_variations[6634],NULL},
  {758,0,1,0,NULL,&joseki[379]},
  {833,0,4,1,&joseki_variations[6636],NULL},
  {834,0,6,1,&joseki_variations[6637],NULL},
  {870,3,5,1,&joseki_variations[6638],NULL},
  {871,3,8,1,&joseki_variations[6639],NULL},
  {724,3,2,1,&joseki_variations[6640],NULL},
  {761,3,4,1,&joseki_variations[6641],NULL},
  {798,3,7,1,&joseki_variations[6642],NULL},
  {835,0,10,1,&joseki_variations[6643],NULL},
  {872,3,13,1,&joseki_variations[6644],NULL},
  {762,0,5,1,&joseki_variations[6645],NULL},
  {799,0,9,1,&joseki_variations[6646],NULL},
  {836,3,13,1,&joseki_variations[6647],NULL},
  {763,0,6,1,&joseki_variations[6648],NULL},
  {800,3,11,1,&joseki_variations[6649],NULL},
  {837,3,16,1,&joseki_variations[6650],NULL},
  {764,0,7,1,&joseki_variations[6651],NULL},
  {801,0,13,1,&joseki_variations[6652],NULL},
  {758,0,1,0,NULL,&joseki[371]},
  {723,0,2,1,&joseki_variations[6679],NULL},
  {870,0,4,1,&joseki_variations[6655],NULL},
  {723,3,2,1,&joseki_variations[6656],NULL},
  {760,0,4,1,&joseki_variations[6657],NULL},
  {834,3,6,1,&joseki_variations[6658],NULL},
  {871,0,8,1,&joseki_variations[6659],NULL},
  {724,0,3,1,&joseki_variations[6660],NULL},
  {761,0,6,1,&joseki_variations[6661],NULL},
  {798,0,8,1,&joseki_variations[6662],NULL},
  {835,3,10,1,&joseki_variations[6663],NULL},
  {872,0,13,1,&joseki_variations[6664],NULL},
  {688,0,1,1,&joseki_variations[6665],NULL},
  {725,3,5,1,&joseki_variations[6666],NULL},
  {762,3,9,1,&joseki_variations[6667],NULL},
  {799,3,12,1,&joseki_variations[6668],NULL},
  {836,0,15,1,&joseki_variations[6669],NULL},
  {726,3,6,1,&joseki_variations[6670],NULL},
  {763,3,11,1,&joseki_variations[6671],NULL},
  {800,0,15,1,&joseki_variations[6672],NULL},
  {837,0,19,1,&joseki_variations[6673],NULL},
  {727,3,7,1,&joseki_variations[6674],NULL},
  {764,0,13,1,&joseki_variations[6675],NULL},
  {801,3,18,1,&joseki_variations[6676],NULL},
  {728,3,8,1,&joseki_variations[6677],NULL},
  {765,0,15,1,&joseki_variations[6678],NULL},
  {721,3,1,0,NULL,&joseki[489]},
  {760,0,4,1,&joseki_variations[6680],NULL},
  {797,0,6,1,&joseki_variations[6681],NULL},
  {834,3,7,1,&joseki_variations[6682],NULL},
  {724,0,3,1,&joseki_variations[6683],NULL},
  {761,3,6,1,&joseki_variations[6684],NULL},
  {763,0,7,1,&joseki_variations[6685],NULL},
  {798,3,9,1,&joseki_variations[6686],NULL},
  {836,3,11,1,&joseki_variations[6687],NULL},
  {801,3,11,0,NULL,&joseki[13]},
  {763,0,4,1,&joseki_variations[6805],NULL},
  {834,3,4,1,&joseki_variations[6801],NULL},
  {797,0,4,1,&joseki_variations[6786],NULL},
  {796,3,3,2,&joseki_variations[6736],NULL},
  {797,3,4,1,&joseki_variations[6693],NULL},
  {761,0,4,1,&joseki_variations[6694],NULL},
  {798,3,6,3,&joseki_variations[6695],NULL},
  {872,3,7,1,&joseki_variations[6706],NULL},
  {762,0,5,1,&joseki_variations[6700],NULL},
  {764,3,5,1,&joseki_variations[6698],NULL},
  {804,3,8,1,&joseki_variations[6699],NULL},
  {796,3,3,0,NULL,&joseki[891]},
  {763,0,6,1,&joseki_variations[6701],NULL},
  {800,3,9,1,&joseki_variations[6702],NULL},
  {764,3,7,1,&joseki_variations[6703],NULL},
  {801,3,11,1,&joseki_variations[6704],NULL},
  {804,3,12,1,&joseki_variations[6705],NULL},
  {796,3,3,0,NULL,&joseki[886]},
  {762,3,5,1,&joseki_variations[6707],NULL},
  {799,0,8,1,&joseki_variations[6708],NULL},
  {726,0,2,1,&joseki_variations[6709],NULL},
  {763,0,7,1,&joseki_variations[6710],NULL},
  {800,0,11,1,&joseki_variations[6711],NULL},
  {837,0,12,1,&joseki_variations[6712],NULL},
  {874,3,14,1,&joseki_variations[6713],NULL},
  {911,3,15,1,&joseki_variations[6714],NULL},
  {801,3,12,1,&joseki_variations[6715],NULL},
  {838,3,14,1,&joseki_variations[6716],NULL},
  {875,0,17,1,&joseki_variations[6717],NULL},
  {912,0,19,1,&joseki_variations[6718],NULL},
  {765,3,8,1,&joseki_variations[6719],NULL},
  {802,3,14,1,&joseki_variations[6720],NULL},
  {839,0,17,1,&joseki_variations[6721],NULL},
  {876,3,21,1,&joseki_variations[6722],NULL},
  {766,3,9,1,&joseki_variations[6723],NULL},
  {803,0,16,1,&joseki_variations[6724],NULL},
  {840,0,20,1,&joseki_variations[6725],NULL},
  {767,3,10,1,&joseki_variations[6726],NULL},
  {804,0,18,1,&joseki_variations[6727],NULL},
  {805,0,19,1,&joseki_variations[6728],NULL},
  {949,3,20,1,&joseki_variations[6729],&joseki[189]},
  {913,0,24,2,&joseki_variations[6730],&joseki[190]},
  {951,3,29,1,&joseki_variations[6735],&joseki[191]},
  {914,0,28,1,&joseki_variations[6732],NULL},
  {951,3,30,1,&joseki_variations[6733],NULL},
  {769,3,11,1,&joseki_variations[6734],NULL},
  {915,3,31,0,NULL,&joseki[193]},
  {914,0,28,0,NULL,&joseki[192]},
  {797,0,5,1,&joseki_variations[6779],NULL},
  {797,3,5,1,&joseki_variations[6738],NULL},
  {761,0,4,1,&joseki_variations[6739],NULL},
  {798,3,7,3,&joseki_variations[6740],NULL},
  {762,0,5,2,&joseki_variations[6751],NULL},
  {764,3,5,1,&joseki_variations[6749],NULL},
  {763,0,5,1,&joseki_variations[6743],NULL},
  {764,3,6,2,&joseki_variations[6744],NULL},
  {804,3,10,1,&joseki_variations[6748],NULL},
  {800,3,9,1,&joseki_variations[6746],NULL},
  {804,3,11,1,&joseki_variations[6747],NULL},
  {762,0,5,0,NULL,&joseki[894]},
  {800,3,9,0,NULL,&joseki[893]},
  {804,3,9,1,&joseki_variations[6750],NULL},
  {763,0,5,0,NULL,&joseki[892]},
  {763,0,6,1,&joseki_variations[6759],NULL},
  {726,0,2,1,&joseki_variations[6753],NULL},
  {763,0,7,1,&joseki_variations[6754],NULL},
  {800,3,11,1,&joseki_variations[6755],NULL},
  {727,3,3,1,&joseki_variations[6756],NULL},
  {764,3,9,1,&joseki_variations[6757],NULL},
  {804,3,14,1,&joseki_variations[6758],NULL},
  {721,3,1,0,NULL,&joseki[899]},
  {800,3,10,3,&joseki_variations[6760],NULL},
  {764,3,7,2,&joseki_variations[6774],NULL},
  {727,0,2,1,&joseki_variations[6767],NULL},
  {727,3,2,1,&joseki_variations[6763],NULL},
  {764,3,8,1,&joseki_variations[6764],NULL},
  {804,3,13,2,&joseki_variations[6765],NULL},
  {721,0,1,0,NULL,&joseki[896]},
  {726,0,2,0,NULL,&joseki[898]},
  {764,3,8,1,&joseki_variations[6768],NULL},
  {801,3,13,2,&joseki_variations[6769],NULL},
  {804,3,14,1,&joseki_variations[6773],NULL},
  {728,3,3,1,&joseki_variations[6771],NULL},
  {804,3,15,1,&joseki_variations[6772],NULL},
  {690,0,1,0,NULL,&joseki[889]},
  {728,3,3,0,NULL,&joseki[888]},
  {801,3,12,1,&joseki_variations[6777],NULL},
  {804,3,12,1,&joseki_variations[6776],NULL},
  {727,3,2,0,NULL,&joseki[895]},
  {804,3,13,1,&joseki_variations[6778],NULL},
  {727,0,2,0,NULL,&joseki[887]},
  {834,3,6,1,&joseki_variations[6780],NULL},
  {724,0,2,1,&joseki_variations[6781],NULL},
  {761,3,5,1,&joseki_variations[6782],NULL},
  {763,0,6,1,&joseki_variations[6783],NULL},
  {798,3,8,1,&joseki_variations[6784],NULL},
  {836,3,10,1,&joseki_variations[6785],NULL},
  {723,0,2,0,NULL,&joseki[12]},
  {834,3,5,2,&joseki_variations[6787],NULL},
  {761,3,4,2,&joseki_variations[6794],NULL},
  {724,0,2,1,&joseki_variations[6789],NULL},
  {761,3,5,1,&joseki_variations[6790],NULL},
  {763,0,6,1,&joseki_variations[6791],NULL},
  {798,3,7,1,&joseki_variations[6792],NULL},
  {836,3,9,1,&joseki_variations[6793],NULL},
  {796,3,3,0,NULL,&joseki[11]},
  {836,3,7,1,&joseki_variations[6799],NULL},
  {763,0,5,1,&joseki_variations[6796],NULL},
  {798,3,6,1,&joseki_variations[6797],NULL},
  {836,3,8,1,&joseki_variations[6798],NULL},
  {724,0,2,0,NULL,&joseki[10]},
  {763,0,5,1,&joseki_variations[6800],NULL},
  {798,3,6,0,NULL,&joseki[9]},
  {761,3,4,1,&joseki_variations[6802],NULL},
  {836,3,6,1,&joseki_variations[6803],NULL},
  {763,0,5,1,&joseki_variations[6804],NULL},
  {797,0,4,0,NULL,&joseki[8]},
  {834,3,4,1,&joseki_variations[6806],NULL},
  {836,3,5,1,&joseki_variations[6807],NULL},
  {761,3,4,0,NULL,&joseki[7]},
  {760,3,2,2,&joseki_variations[7298],NULL},
  {796,3,2,7,&joseki_variations[7139],NULL},
  {760,0,2,3,&joseki_variations[7086],NULL},
  {723,3,1,2,&joseki_variations[6959],NULL},
  {796,0,2,2,&joseki_variations[6916],NULL},
  {723,0,1,3,&joseki_variations[6820],NULL},
  {834,0,2,1,&joseki_variations[6815],NULL},
  {761,3,2,1,&joseki_variations[6816],NULL},
  {872,0,4,1,&joseki_variations[6817],NULL},
  {946,3,5,1,&joseki_variations[6818],NULL},
  {800,3,3,1,&joseki_variations[6819],NULL},
  {767,3,3,0,NULL,&joseki[1357]},
  {760,3,3,3,&joseki_variations[6857],NULL},
  {797,0,3,1,&joseki_variations[6840],NULL},
  {760,0,3,1,&joseki_variations[6823],NULL},
  {797,0,4,1,&joseki_variations[6824],NULL},
  {834,3,5,1,&joseki_variations[6825],NULL},
  {724,3,2,1,&joseki_variations[6826],NULL},
  {761,0,5,1,&joseki_variations[6827],NULL},
  {798,3,7,1,&joseki_variations[6828],NULL},
  {762,3,6,2,&joseki_variations[6829],NULL},
  {800,0,9,1,&joseki_variations[6839],NULL},
  {799,3,9,1,&joseki_variations[6831],NULL},
  {800,0,10,1,&joseki_variations[6832],NULL},
  {835,0,9,1,&joseki_variations[6833],&joseki[1443]},
  {836,3,12,1,&joseki_variations[6834],&joseki[1444]},
  {872,0,10,1,&joseki_variations[6835],&joseki[1445]},
  {945,3,6,1,&joseki_variations[6836],NULL},
  {873,0,14,1,&joseki_variations[6837],&joseki[1446]},
  {837,3,14,1,&joseki_variations[6838],&joseki[1447]},
  {871,0,6,0,NULL,&joseki[1448]},
  {799,3,9,0,NULL,&joseki[1442]},
  {834,3,4,2,&joseki_variations[6841],NULL},
  {761,0,3,1,&joseki_variations[6848],NULL},
  {724,3,2,1,&joseki_variations[6843],NULL},
  {761,0,4,1,&joseki_variations[6844],NULL},
  {798,3,6,1,&joseki_variations[6845],NULL},
  {762,3,5,1,&joseki_variations[6846],NULL},
  {800,0,8,1,&joseki_variations[6847],NULL},
  {760,0,3,0,NULL,&joseki[1441]},
  {798,3,5,2,&joseki_variations[6849],NULL},
  {762,3,4,1,&joseki_variations[6855],NULL},
  {835,0,7,1,&joseki_variations[6851],NULL},
  {799,3,6,1,&joseki_variations[6852],NULL},
  {871,3,5,1,&joseki_variations[6853],NULL},
  {945,0,6,1,&joseki_variations[6854],NULL},
  {796,3,2,0,NULL,&joseki[1514]},
  {800,0,7,1,&joseki_variations[6856],NULL},
  {724,3,2,0,NULL,&joseki[1440]},
  {797,3,4,1,&joseki_variations[6896],NULL},
  {724,0,2,1,&joseki_variations[6873],NULL},
  {834,3,4,1,&joseki_variations[6860],NULL},
  {761,0,4,1,&joseki_variations[6861],NULL},
  {798,3,5,3,&joseki_variations[6862],NULL},
  {762,0,5,1,&joseki_variations[6868],NULL},
  {800,0,6,1,&joseki_variations[6867],NULL},
  {762,3,5,1,&joseki_variations[6865],NULL},
  {800,0,7,1,&joseki_variations[6866],NULL},
  {797,0,4,0,NULL,&joseki[1439]},
  {762,3,5,0,NULL,&joseki[1438]},
  {800,0,7,2,&joseki_variations[6869],NULL},
  {796,3,2,0,NULL,&joseki[1436]},
  {767,0,6,1,&joseki_variations[6871],NULL},
  {945,3,5,1,&joseki_variations[6872],NULL},
  {796,3,2,0,NULL,&joseki[1461]},
  {761,0,5,1,&joseki_variations[6874],NULL},
  {725,3,3,1,&joseki_variations[6875],NULL},
  {762,3,7,1,&joseki_variations[6876],NULL},
  {763,3,8,1,&joseki_variations[6877],NULL},
  {727,3,4,1,&joseki_variations[6878],NULL},
  {764,0,10,1,&joseki_variations[6879],NULL},
  {728,3,5,1,&joseki_variations[6880],NULL},
  {765,0,12,1,&joseki_variations[6881],NULL},
  {795,3,1,1,&joseki_variations[6882],NULL},
  {796,3,3,1,&joseki_variations[6883],NULL},
  {797,3,6,1,&joseki_variations[6884],NULL},
  {798,0,9,1,&joseki_variations[6885],NULL},
  {799,3,12,1,&joseki_variations[6886],NULL},
  {800,0,14,1,&joseki_variations[6887],NULL},
  {801,3,17,1,&joseki_variations[6888],NULL},
  {833,0,4,1,&joseki_variations[6889],NULL},
  {834,3,8,1,&joseki_variations[6890],NULL},
  {835,3,12,1,&joseki_variations[6891],NULL},
  {836,0,16,1,&joseki_variations[6892],NULL},
  {837,0,19,1,&joseki_variations[6893],NULL},
  {871,0,9,1,&joseki_variations[6894],NULL},
  {872,0,14,1,&joseki_variations[6895],NULL},
  {832,0,2,0,NULL,&joseki[514]},
  {834,3,5,1,&joseki_variations[6897],NULL},
  {871,0,6,1,&joseki_variations[6898],NULL},
  {724,0,2,1,&joseki_variations[6899],NULL},
  {761,0,5,1,&joseki_variations[6900],NULL},
  {798,0,7,1,&joseki_variations[6901],NULL},
  {835,3,9,1,&joseki_variations[6902],NULL},
  {872,0,11,1,&joseki_variations[6903],NULL},
  {725,3,3,1,&joseki_variations[6904],NULL},
  {762,3,7,1,&joseki_variations[6905],NULL},
  {799,3,10,1,&joseki_variations[6906],NULL},
  {836,0,13,1,&joseki_variations[6907],NULL},
  {763,3,8,1,&joseki_variations[6908],NULL},
  {800,0,12,1,&joseki_variations[6909],NULL},
  {837,0,16,1,&joseki_variations[6910],NULL},
  {727,3,4,1,&joseki_variations[6911],NULL},
  {764,0,10,1,&joseki_variations[6912],NULL},
  {801,3,15,1,&joseki_variations[6913],NULL},
  {728,3,5,1,&joseki_variations[6914],NULL},
  {765,0,12,1,&joseki_variations[6915],NULL},
  {796,3,2,0,NULL,&joseki[511]},
  {870,3,3,1,&joseki_variations[6935],NULL},
  {723,3,1,1,&joseki_variations[6918],NULL},
  {760,3,3,1,&joseki_variations[6919],NULL},
  {797,0,5,2,&joseki_variations[6920],NULL},
  {834,3,6,1,&joseki_variations[6929],NULL},
  {833,3,3,1,&joseki_variations[6922],NULL},
  {834,3,7,1,&joseki_variations[6923],NULL},
  {724,0,2,1,&joseki_variations[6924],NULL},
  {761,0,5,1,&joseki_variations[6925],NULL},
  {763,0,6,1,&joseki_variations[6926],NULL},
  {798,3,8,1,&joseki_variations[6927],NULL},
  {835,3,11,1,&joseki_variations[6928],NULL},
  {722,0,1,0,NULL,&joseki[1319]},
  {724,0,2,1,&joseki_variations[6930],NULL},
  {761,0,5,1,&joseki_variations[6931],NULL},
  {763,0,6,1,&joseki_variations[6932],NULL},
  {798,3,8,1,&joseki_variations[6933],NULL},
  {835,3,10,1,&joseki_variations[6934],NULL},
  {833,3,3,0,NULL,&joseki[1318]},
  {723,0,1,1,&joseki_variations[6936],NULL},
  {760,3,3,1,&joseki_variations[6937],NULL},
  {834,0,5,1,&joseki_variations[6938],NULL},
  {871,3,7,1,&joseki_variations[6939],NULL},
  {724,3,2,1,&joseki_variations[6940],NULL},
  {761,3,5,1,&joseki_variations[6941],NULL},
  {798,3,7,1,&joseki_variations[6942],NULL},
  {835,0,9,1,&joseki_variations[6943],NULL},
  {872,3,12,1,&joseki_variations[6944],NULL},
  {688,3,1,1,&joseki_variations[6945],NULL},
  {725,0,4,1,&joseki_variations[6946],NULL},
  {762,0,8,1,&joseki_variations[6947],NULL},
  {799,0,11,1,&joseki_variations[6948],NULL},
  {836,3,14,1,&joseki_variations[6949],NULL},
  {726,0,5,1,&joseki_variations[6950],NULL},
  {763,0,10,1,&joseki_variations[6951],NULL},
  {800,3,14,1,&joseki_variations[6952],NULL},
  {837,3,18,1,&joseki_variations[6953],NULL},
  {727,0,6,1,&joseki_variations[6954],NULL},
  {764,3,12,1,&joseki_variations[6955],NULL},
  {801,0,17,1,&joseki_variations[6956],NULL},
  {728,0,7,1,&joseki_variations[6957],NULL},
  {765,3,14,1,&joseki_variations[6958],NULL},
  {722,3,1,0,NULL,&joseki[488]},
  {760,0,3,2,&joseki_variations[7024],NULL},
  {760,3,3,3,&joseki_variations[6961],NULL},
  {724,0,2,1,&joseki_variations[7006],NULL},
  {797,3,4,1,&joseki_variations[6993],NULL},
  {797,0,4,2,&joseki_variations[6964],NULL},
  {761,0,4,3,&joseki_variations[6976],NULL},
  {724,0,2,1,&joseki_variations[6966],NULL},
  {761,0,5,1,&joseki_variations[6967],NULL},
  {763,0,6,1,&joseki_variations[6968],NULL},
  {798,3,7,2,&joseki_variations[6969],NULL},
  {835,3,8,3,&joseki_variations[6973],NULL},
  {834,3,5,1,&joseki_variations[6971],NULL},
  {835,3,9,1,&joseki_variations[6972],NULL},
  {796,0,2,0,NULL,&joseki[1317]},
  {796,3,2,0,NULL,&joseki[1310]},
  {722,3,1,0,NULL,&joseki[1314]},
  {834,3,5,0,NULL,&joseki[1316]},
  {763,0,5,1,&joseki_variations[6990],NULL},
  {871,3,5,1,&joseki_variations[6985],NULL},
  {798,3,6,1,&joseki_variations[6979],NULL},
  {799,3,7,1,&joseki_variations[6980],NULL},
  {834,0,5,1,&joseki_variations[6981],NULL},
  {835,0,8,1,&joseki_variations[6982],NULL},
  {871,3,6,1,&joseki_variations[6983],NULL},
  {945,0,7,1,&joseki_variations[6984],NULL},
  {722,3,1,0,NULL,&joseki[1503]},
  {945,0,6,1,&joseki_variations[6986],NULL},
  {798,3,6,1,&joseki_variations[6987],NULL},
  {835,0,7,1,&joseki_variations[6988],&joseki[1500]},
  {799,3,7,1,&joseki_variations[6989],&joseki[1501]},
  {834,0,5,0,NULL,&joseki[1502]},
  {798,3,6,1,&joseki_variations[6991],NULL},
  {835,3,7,1,&joseki_variations[6992],NULL},
  {724,0,2,0,NULL,&joseki[1309]},
  {761,3,4,1,&joseki_variations[6994],NULL},
  {798,0,6,1,&joseki_variations[6995],NULL},
  {833,3,2,1,&joseki_variations[6996],NULL},
  {835,0,8,1,&joseki_variations[6997],NULL},
  {870,3,3,1,&joseki_variations[6998],NULL},
  {872,0,10,1,&joseki_variations[6999],NULL},
  {907,0,4,1,&joseki_variations[7000],NULL},
  {725,0,2,1,&joseki_variations[7001],NULL},
  {762,0,6,1,&joseki_variations[7002],NULL},
  {799,3,9,1,&joseki_variations[7003],NULL},
  {800,0,10,1,&joseki_variations[7004],NULL},
  {801,3,11,1,&joseki_variations[7005],NULL},
  {908,0,8,0,NULL,&joseki[1077]},
  {761,3,5,1,&joseki_variations[7007],NULL},
  {762,0,6,1,&joseki_variations[7008],NULL},
  {763,0,7,1,&joseki_variations[7009],NULL},
  {795,0,1,1,&joseki_variations[7010],NULL},
  {797,0,5,1,&joseki_variations[7011],NULL},
  {798,3,8,1,&joseki_variations[7012],NULL},
  {799,0,10,1,&joseki_variations[7013],NULL},
  {800,3,12,1,&joseki_variations[7014],NULL},
  {801,0,13,1,&joseki_variations[7015],NULL},
  {833,0,3,1,&joseki_variations[7016],NULL},
  {834,0,7,1,&joseki_variations[7017],NULL},
  {835,0,11,1,&joseki_variations[7018],NULL},
  {836,3,14,1,&joseki_variations[7019],NULL},
  {837,3,17,1,&joseki_variations[7020],NULL},
  {870,3,4,1,&joseki_variations[7021],NULL},
  {871,3,9,1,&joseki_variations[7022],NULL},
  {872,3,14,1,&joseki_variations[7023],NULL},
  {722,3,1,0,NULL,&joseki[532]},
  {761,3,4,4,&joseki_variations[7053],NULL},
  {724,3,2,1,&joseki_variations[7026],NULL},
  {761,3,5,2,&joseki_variations[7027],NULL},
  {798,0,6,2,&joseki_variations[7041],NULL},
  {762,0,6,1,&joseki_variations[7029],NULL},
  {797,3,4,1,&joseki_variations[7030],NULL},
  {798,0,7,1,&joseki_variations[7031],NULL},
  {834,3,5,1,&joseki_variations[7032],NULL},
  {835,0,9,1,&joseki_variations[7033],NULL},
  {871,3,6,1,&joseki_variations[7034],NULL},
  {872,0,11,2,&joseki_variations[7035],NULL},
  {909,3,12,1,&joseki_variations[7040],NULL},
  {908,0,7,1,&joseki_variations[7037],NULL},
  {909,3,13,1,&joseki_variations[7038],NULL},
  {945,3,8,1,&joseki_variations[7039],&joseki[1172]},
  {722,0,1,0,NULL,&joseki[1173]},
  {908,0,7,0,NULL,&joseki[1171]},
  {872,0,7,1,&joseki_variations[7048],NULL},
  {871,0,4,1,&joseki_variations[7043],NULL},
  {725,3,3,1,&joseki_variations[7044],NULL},
  {762,0,7,1,&joseki_variations[7045],NULL},
  {799,0,9,1,&joseki_variations[7046],NULL},
  {763,3,8,1,&joseki_variations[7047],NULL},
  {800,3,11,0,NULL,&joseki[724]},
  {725,3,3,1,&joseki_variations[7049],NULL},
  {762,0,7,1,&joseki_variations[7050],NULL},
  {799,0,9,1,&joseki_variations[7051],NULL},
  {763,3,8,1,&joseki_variations[7052],NULL},
  {800,3,11,0,NULL,&joseki[310]},
  {763,3,5,1,&joseki_variations[7081],NULL},
  {871,0,4,1,&joseki_variations[7069],NULL},
  {798,0,5,1,&joseki_variations[7062],NULL},
  {797,3,4,1,&joseki_variations[7057],NULL},
  {798,0,6,1,&joseki_variations[7058],NULL},
  {800,0,7,1,&joseki_variations[7059],NULL},
  {834,3,5,1,&joseki_variations[7060],NULL},
  {835,0,8,1,&joseki_variations[7061],NULL},
  {722,3,1,0,NULL,&joseki[1582]},
  {834,0,4,1,&joseki_variations[7063],NULL},
  {762,3,5,1,&joseki_variations[7064],NULL},
  {800,3,7,2,&joseki_variations[7065],NULL},
  {767,3,6,0,NULL,&joseki[1434]},
  {982,0,5,1,&joseki_variations[7067],NULL},
  {1056,3,6,1,&joseki_variations[7068],NULL},
  {767,3,6,0,NULL,&joseki[1469]},
  {798,0,5,1,&joseki_variations[7070],NULL},
  {835,0,6,1,&joseki_variations[7071],NULL},
  {946,3,8,1,&joseki_variations[7072],NULL},
  {762,3,5,1,&joseki_variations[7073],NULL},
  {836,3,8,1,&joseki_variations[7074],NULL},
  {873,0,10,1,&joseki_variations[7075],NULL},
  {763,3,6,1,&joseki_variations[7076],NULL},
  {837,3,10,1,&joseki_variations[7077],NULL},
  {801,0,8,3,&joseki_variations[7078],NULL},
  {767,3,7,0,NULL,&joseki[1277]},
  {768,3,7,0,NULL,&joseki[1278]},
  {769,3,7,0,NULL,&joseki[1279]},
  {798,0,5,2,&joseki_variations[7082],NULL},
  {872,0,6,1,&joseki_variations[7085],NULL},
  {871,0,4,1,&joseki_variations[7084],NULL},
  {725,3,2,0,NULL,&joseki[715]},
  {725,3,2,0,NULL,&joseki[301]},
  {797,3,3,1,&joseki_variations[7118],NULL},
  {761,0,3,2,&joseki_variations[7099],NULL},
  {762,0,3,1,&joseki_variations[7089],NULL},
  {763,3,4,1,&joseki_variations[7090],NULL},
  {796,3,2,1,&joseki_variations[7091],NULL},
  {797,3,4,1,&joseki_variations[7092],NULL},
  {798,0,5,1,&joseki_variations[7093],NULL},
  {800,3,8,1,&joseki_variations[7094],NULL},
  {834,0,5,1,&joseki_variations[7095],NULL},
  {835,3,7,1,&joseki_variations[7096],NULL},
  {871,0,6,1,&joseki_variations[7097],NULL},
  {872,3,9,1,&joseki_variations[7098],NULL},
  {799,3,7,0,NULL,&joseki[847]},
  {726,0,1,1,&joseki_variations[7109],NULL},
  {796,3,2,1,&joseki_variations[7101],NULL},
  {797,0,4,1,&joseki_variations[7102],NULL},
  {798,3,6,1,&joseki_variations[7103],NULL},
  {800,0,7,1,&joseki_variations[7104],NULL},
  {834,3,5,1,&joseki_variations[7105],NULL},
  {836,3,8,1,&joseki_variations[7106],NULL},
  {908,0,6,1,&joseki_variations[7107],NULL},
  {946,3,9,1,&joseki_variations[7108],NULL},
  {909,3,9,0,NULL,&joseki[1392]},
  {763,0,5,1,&joseki_variations[7110],NULL},
  {765,3,6,1,&joseki_variations[7111],NULL},
  {796,3,2,1,&joseki_variations[7112],NULL},
  {797,3,4,1,&joseki_variations[7113],NULL},
  {871,0,5,1,&joseki_variations[7114],NULL},
  {798,3,6,1,&joseki_variations[7115],NULL},
  {799,3,7,1,&joseki_variations[7116],NULL},
  {800,3,10,1,&joseki_variations[7117],NULL},
  {909,3,8,0,NULL,&joseki[250]},
  {761,0,3,2,&joseki_variations[7119],NULL},
  {763,0,4,2,&joseki_variations[7127],NULL},
  {798,3,5,1,&joseki_variations[7121],NULL},
  {799,3,6,1,&joseki_variations[7122],NULL},
  {726,0,1,1,&joseki_variations[7123],NULL},
  {763,0,5,1,&joseki_variations[7124],NULL},
  {800,3,9,1,&joseki_variations[7125],NULL},
  {765,3,6,1,&joseki_variations[7126],NULL},
  {839,3,11,0,NULL,&joseki[114]},
  {765,3,5,1,&joseki_variations[7134],NULL},
  {764,0,5,1,&joseki_variations[7129],NULL},
  {765,3,6,1,&joseki_variations[7130],NULL},
  {798,3,5,1,&joseki_variations[7131],NULL},
  {799,3,6,1,&joseki_variations[7132],NULL},
  {800,3,8,1,&joseki_variations[7133],NULL},
  {801,3,10,0,NULL,&joseki[116]},
  {798,3,5,1,&joseki_variations[7135],NULL},
  {799,3,6,1,&joseki_variations[7136],NULL},
  {800,3,8,2,&joseki_variations[7137],&joseki[112]},
  {726,0,1,0,NULL,&joseki[113]},
  {764,0,5,0,NULL,&joseki[115]},
  {834,0,3,1,&joseki_variations[7285],NULL},
  {797,3,3,1,&joseki_variations[7271],NULL},
  {760,0,2,1,&joseki_variations[7256],NULL},
  {723,0,1,3,&joseki_variations[7194],NULL},
  {833,0,3,1,&joseki_variations[7166],NULL},
  {723,3,1,1,&joseki_variations[7158],NULL},
  {797,0,3,1,&joseki_variations[7146],NULL},
  {834,3,4,1,&joseki_variations[7147],NULL},
  {908,0,5,1,&joseki_variations[7148],NULL},
  {761,0,2,2,&joseki_variations[7149],NULL},
  {946,3,7,1,&joseki_variations[7155],NULL},
  {798,3,5,1,&joseki_variations[7151],NULL},
  {946,3,8,1,&joseki_variations[7152],NULL},
  {836,3,7,1,&joseki_variations[7153],NULL},
  {800,0,6,1,&joseki_variations[7154],NULL},
  {760,0,2,0,NULL,&joseki[1391]},
  {836,3,6,1,&joseki_variations[7156],NULL},
  {800,0,5,1,&joseki_variations[7157],NULL},
  {798,3,5,0,NULL,&joseki[1390]},
  {760,3,3,1,&joseki_variations[7159],NULL},
  {797,0,5,1,&joseki_variations[7160],NULL},
  {724,0,2,1,&joseki_variations[7161],NULL},
  {761,0,5,1,&joseki_variations[7162],NULL},
  {763,0,6,1,&joseki_variations[7163],NULL},
  {798,3,8,1,&joseki_variations[7164],NULL},
  {835,3,9,1,&joseki_variations[7165],NULL},
  {834,0,6,0,NULL,&joseki[1311]},
  {870,3,4,1,&joseki_variations[7167],NULL},
  {723,3,1,1,&joseki_variations[7168],NULL},
  {760,3,3,1,&joseki_variations[7169],NULL},
  {797,0,5,1,&joseki_variations[7170],NULL},
  {834,0,7,1,&joseki_variations[7171],NULL},
  {724,0,2,1,&joseki_variations[7172],NULL},
  {761,3,5,1,&joseki_variations[7173],NULL},
  {798,3,8,1,&joseki_variations[7174],NULL},
  {835,0,11,2,&joseki_variations[7175],NULL},
  {872,3,13,1,&joseki_variations[7186],NULL},
  {871,3,9,1,&joseki_variations[7177],NULL},
  {872,3,14,1,&joseki_variations[7178],NULL},
  {762,0,6,1,&joseki_variations[7179],NULL},
  {799,0,10,1,&joseki_variations[7180],NULL},
  {836,3,14,1,&joseki_variations[7181],NULL},
  {763,0,7,1,&joseki_variations[7182],NULL},
  {800,3,12,1,&joseki_variations[7183],NULL},
  {837,3,17,1,&joseki_variations[7184],NULL},
  {801,0,13,1,&joseki_variations[7185],NULL},
  {795,0,1,0,NULL,&joseki[531]},
  {762,0,6,1,&joseki_variations[7187],NULL},
  {799,0,10,1,&joseki_variations[7188],NULL},
  {836,3,14,1,&joseki_variations[7189],NULL},
  {763,0,7,1,&joseki_variations[7190],NULL},
  {800,3,12,1,&joseki_variations[7191],NULL},
  {837,3,17,1,&joseki_variations[7192],NULL},
  {801,0,13,1,&joseki_variations[7193],NULL},
  {871,3,9,0,NULL,&joseki[530]},
  {760,3,3,1,&joseki_variations[7214],NULL},
  {797,0,4,1,&joseki_variations[7206],NULL},
  {760,0,3,1,&joseki_variations[7197],NULL},
  {797,0,5,1,&joseki_variations[7198],NULL},
  {834,3,6,1,&joseki_variations[7199],NULL},
  {871,3,7,1,&joseki_variations[7200],NULL},
  {945,0,8,1,&joseki_variations[7201],NULL},
  {761,0,4,1,&joseki_variations[7202],NULL},
  {798,3,7,1,&joseki_variations[7203],NULL},
  {835,0,9,1,&joseki_variations[7204],NULL},
  {799,3,8,1,&joseki_variations[7205],NULL},
  {873,3,12,0,NULL,&joseki[1516]},
  {834,3,5,1,&joseki_variations[7207],NULL},
  {871,3,6,1,&joseki_variations[7208],NULL},
  {945,0,7,1,&joseki_variations[7209],NULL},
  {761,0,3,1,&joseki_variations[7210],NULL},
  {798,3,6,1,&joseki_variations[7211],NULL},
  {835,0,8,1,&joseki_variations[7212],NULL},
  {799,3,7,1,&joseki_variations[7213],NULL},
  {760,0,3,0,NULL,&joseki[1515]},
  {797,3,5,2,&joseki_variations[7215],NULL},
  {834,3,6,1,&joseki_variations[7237],NULL},
  {833,0,3,1,&joseki_variations[7217],NULL},
  {834,3,7,1,&joseki_variations[7218],NULL},
  {871,0,8,1,&joseki_variations[7219],NULL},
  {724,0,2,1,&joseki_variations[7220],NULL},
  {761,0,5,1,&joseki_variations[7221],NULL},
  {798,0,8,1,&joseki_variations[7222],NULL},
  {835,3,11,1,&joseki_variations[7223],NULL},
  {872,0,13,1,&joseki_variations[7224],NULL},
  {725,3,3,1,&joseki_variations[7225],NULL},
  {762,3,7,1,&joseki_variations[7226],NULL},
  {799,3,11,1,&joseki_variations[7227],NULL},
  {836,0,15,1,&joseki_variations[7228],NULL},
  {763,3,8,1,&joseki_variations[7229],NULL},
  {800,0,13,1,&joseki_variations[7230],NULL},
  {837,0,18,1,&joseki_variations[7231],NULL},
  {727,3,4,1,&joseki_variations[7232],NULL},
  {764,0,10,1,&joseki_variations[7233],NULL},
  {801,3,16,1,&joseki_variations[7234],NULL},
  {728,3,5,1,&joseki_variations[7235],NULL},
  {765,0,12,1,&joseki_variations[7236],NULL},
  {795,3,1,0,NULL,&joseki[513]},
  {871,0,7,1,&joseki_variations[7238],NULL},
  {724,0,2,1,&joseki_variations[7239],NULL},
  {761,0,5,1,&joseki_variations[7240],NULL},
  {798,0,8,1,&joseki_variations[7241],NULL},
  {835,3,10,1,&joseki_variations[7242],NULL},
  {872,0,12,1,&joseki_variations[7243],NULL},
  {725,3,3,1,&joseki_variations[7244],NULL},
  {762,3,7,1,&joseki_variations[7245],NULL},
  {799,3,11,1,&joseki_variations[7246],NULL},
  {836,0,14,1,&joseki_variations[7247],NULL},
  {763,3,8,1,&joseki_variations[7248],NULL},
  {800,0,13,1,&joseki_variations[7249],NULL},
  {837,0,17,1,&joseki_variations[7250],NULL},
  {727,3,4,1,&joseki_variations[7251],NULL},
  {764,0,10,1,&joseki_variations[7252],NULL},
  {801,3,16,1,&joseki_variations[7253],NULL},
  {728,3,5,1,&joseki_variations[7254],NULL},
  {765,0,12,1,&joseki_variations[7255],NULL},
  {833,0,3,0,NULL,&joseki[512]},
  {797,3,4,1,&joseki_variations[7257],NULL},
  {834,0,5,1,&joseki_variations[7258],NULL},
  {871,3,6,1,&joseki_variations[7259],NULL},
  {908,3,7,1,&joseki_variations[7260],NULL},
  {724,0,1,1,&joseki_variations[7261],NULL},
  {761,3,4,1,&joseki_variations[7262],NULL},
  {798,3,7,1,&joseki_variations[7263],NULL},
  {835,3,9,1,&joseki_variations[7264],NULL},
  {872,0,11,1,&joseki_variations[7265],NULL},
  {909,3,13,1,&joseki_variations[7266],NULL},
  {762,0,5,1,&joseki_variations[7267],NULL},
  {799,0,9,1,&joseki_variations[7268],NULL},
  {836,0,12,1,&joseki_variations[7269],NULL},
  {873,0,15,1,&joseki_variations[7270],NULL},
  {833,3,3,0,NULL,&joseki[49]},
  {834,0,4,1,&joseki_variations[7272],NULL},
  {871,3,5,1,&joseki_variations[7273],NULL},
  {908,3,6,1,&joseki_variations[7274],NULL},
  {724,0,1,1,&joseki_variations[7275],NULL},
  {761,3,3,1,&joseki_variations[7276],NULL},
  {798,3,6,1,&joseki_variations[7277],NULL},
  {835,3,8,1,&joseki_variations[7278],NULL},
  {872,0,10,1,&joseki_variations[7279],NULL},
  {909,3,12,1,&joseki_variations[7280],NULL},
  {762,0,4,1,&joseki_variations[7281],NULL},
  {799,0,8,1,&joseki_variations[7282],NULL},
  {836,0,11,1,&joseki_variations[7283],NULL},
  {873,0,14,1,&joseki_variations[7284],NULL},
  {760,0,2,0,NULL,&joseki[48]},
  {871,3,4,1,&joseki_variations[7286],NULL},
  {908,3,5,1,&joseki_variations[7287],NULL},
  {724,0,1,1,&joseki_variations[7288],NULL},
  {761,3,3,1,&joseki_variations[7289],NULL},
  {798,3,5,1,&joseki_variations[7290],NULL},
  {835,3,7,1,&joseki_variations[7291],NULL},
  {872,0,9,1,&joseki_variations[7292],NULL},
  {909,3,11,1,&joseki_variations[7293],NULL},
  {762,0,4,1,&joseki_variations[7294],NULL},
  {799,0,7,1,&joseki_variations[7295],NULL},
  {836,0,10,1,&joseki_variations[7296],NULL},
  {873,0,13,1,&joseki_variations[7297],NULL},
  {797,3,3,0,NULL,&joseki[47]},
  {763,3,3,1,&joseki_variations[7399],NULL},
  {797,0,3,3,&joseki_variations[7300],NULL},
  {761,3,3,1,&joseki_variations[7328],NULL},
  {798,3,4,1,&joseki_variations[7321],NULL},
  {761,0,3,3,&joseki_variations[7303],NULL},
  {763,0,4,1,&joseki_variations[7318],NULL},
  {871,3,4,1,&joseki_variations[7312],NULL},
  {798,3,5,1,&joseki_variations[7306],NULL},
  {799,3,6,1,&joseki_variations[7307],NULL},
  {834,3,4,1,&joseki_variations[7308],NULL},
  {835,0,7,1,&joseki_variations[7309],NULL},
  {871,3,5,1,&joseki_variations[7310],NULL},
  {945,0,6,1,&joseki_variations[7311],NULL},
  {723,0,1,0,NULL,&joseki[1513]},
  {945,0,5,1,&joseki_variations[7313],NULL},
  {798,3,5,2,&joseki_variations[7314],NULL},
  {723,3,1,0,NULL,&joseki[1499]},
  {835,0,6,1,&joseki_variations[7316],NULL},
  {799,3,6,1,&joseki_variations[7317],NULL},
  {834,3,4,0,NULL,&joseki[1512]},
  {798,3,5,1,&joseki_variations[7319],NULL},
  {835,3,6,1,&joseki_variations[7320],NULL},
  {723,3,1,0,NULL,&joseki[1308]},
  {834,0,4,1,&joseki_variations[7322],NULL},
  {762,3,3,1,&joseki_variations[7323],NULL},
  {763,0,4,1,&joseki_variations[7324],NULL},
  {800,3,7,1,&joseki_variations[7325],NULL},
  {837,3,9,1,&joseki_variations[7326],NULL},
  {801,0,8,1,&joseki_variations[7327],NULL},
  {723,3,1,0,NULL,&joseki[617]},
  {798,0,5,4,&joseki_variations[7329],NULL},
  {872,0,6,1,&joseki_variations[7350],NULL},
  {764,0,4,1,&joseki_variations[7347],NULL},
  {763,3,4,1,&joseki_variations[7341],NULL},
  {762,3,4,1,&joseki_variations[7333],NULL},
  {763,3,5,1,&joseki_variations[7334],NULL},
  {800,0,8,1,&joseki_variations[7335],NULL},
  {764,0,6,2,&joseki_variations[7336],NULL},
  {804,0,10,1,&joseki_variations[7340],NULL},
  {801,0,10,1,&joseki_variations[7338],NULL},
  {804,0,11,1,&joseki_variations[7339],NULL},
  {722,3,1,0,NULL,&joseki[885]},
  {801,0,10,0,NULL,&joseki[884]},
  {764,0,5,2,&joseki_variations[7342],NULL},
  {804,0,8,1,&joseki_variations[7346],NULL},
  {800,0,7,1,&joseki_variations[7344],NULL},
  {804,0,9,1,&joseki_variations[7345],NULL},
  {762,3,4,0,NULL,&joseki[883]},
  {800,0,7,0,NULL,&joseki[882]},
  {804,0,7,2,&joseki_variations[7348],NULL},
  {763,3,4,0,NULL,&joseki[881]},
  {722,3,1,0,NULL,&joseki[890]},
  {762,0,4,1,&joseki_variations[7351],NULL},
  {726,3,1,1,&joseki_variations[7352],NULL},
  {763,3,6,2,&joseki_variations[7353],NULL},
  {800,3,9,1,&joseki_variations[7382],NULL},
  {765,0,7,1,&joseki_variations[7355],NULL},
  {766,0,8,1,&joseki_variations[7356],NULL},
  {767,0,9,1,&joseki_variations[7357],NULL},
  {799,3,7,1,&joseki_variations[7358],NULL},
  {800,3,10,1,&joseki_variations[7359],NULL},
  {837,3,11,1,&joseki_variations[7360],NULL},
  {874,0,13,1,&joseki_variations[7361],NULL},
  {801,0,11,1,&joseki_variations[7362],NULL},
  {838,0,13,1,&joseki_variations[7363],NULL},
  {875,3,16,2,&joseki_variations[7364],NULL},
  {912,3,17,1,&joseki_variations[7374],NULL},
  {911,0,14,1,&joseki_variations[7366],NULL},
  {912,3,18,1,&joseki_variations[7367],NULL},
  {802,0,13,1,&joseki_variations[7368],NULL},
  {839,3,16,1,&joseki_variations[7369],NULL},
  {876,0,20,1,&joseki_variations[7370],NULL},
  {803,3,15,1,&joseki_variations[7371],NULL},
  {840,3,19,1,&joseki_variations[7372],NULL},
  {804,3,17,1,&joseki_variations[7373],NULL},
  {722,3,1,0,NULL,&joseki[188]},
  {802,0,13,1,&joseki_variations[7375],NULL},
  {839,3,16,1,&joseki_variations[7376],NULL},
  {876,0,20,1,&joseki_variations[7377],NULL},
  {803,3,15,1,&joseki_variations[7378],NULL},
  {840,3,19,1,&joseki_variations[7379],NULL},
  {804,3,17,1,&joseki_variations[7380],NULL},
  {805,3,18,1,&joseki_variations[7381],NULL},
  {911,0,14,0,NULL,&joseki[187]},
  {837,3,10,1,&joseki_variations[7383],NULL},
  {874,0,12,1,&joseki_variations[7384],NULL},
  {801,0,10,1,&joseki_variations[7385],NULL},
  {838,0,12,1,&joseki_variations[7386],NULL},
  {875,3,15,1,&joseki_variations[7387],NULL},
  {912,3,16,1,&joseki_variations[7388],NULL},
  {765,0,7,1,&joseki_variations[7389],NULL},
  {802,0,12,1,&joseki_variations[7390],NULL},
  {839,3,15,1,&joseki_variations[7391],NULL},
  {876,0,19,1,&joseki_variations[7392],NULL},
  {766,0,8,1,&joseki_variations[7393],NULL},
  {803,3,14,1,&joseki_variations[7394],NULL},
  {840,3,18,1,&joseki_variations[7395],NULL},
  {767,0,9,1,&joseki_variations[7396],NULL},
  {804,3,16,1,&joseki_variations[7397],NULL},
  {805,3,17,1,&joseki_variations[7398],NULL},
  {799,3,7,0,NULL,&joseki[186]},
  {834,0,3,1,&joseki_variations[7400],NULL},
  {836,0,4,1,&joseki_variations[7401],NULL},
  {722,3,1,0,NULL,&joseki[6]},
  {836,3,2,1,&joseki_variations[8672],NULL},
  {834,3,2,4,&joseki_variations[8641],NULL},
  {797,3,2,9,&joseki_variations[8342],NULL},
  {796,0,1,3,&joseki_variations[8273],NULL},
  {834,0,2,1,&joseki_variations[8256],NULL},
  {761,0,2,2,&joseki_variations[8236],NULL},
  {763,0,2,4,&joseki_variations[8174],NULL},
  {761,3,2,8,&joseki_variations[8001],NULL},
  {797,0,2,5,&joseki_variations[7746],NULL},
  {798,3,2,9,&joseki_variations[7673],&joseki[1531]},
  {724,0,1,5,&joseki_variations[7558],NULL},
  {724,3,1,2,&joseki_variations[7429],NULL},
  {762,3,2,1,&joseki_variations[7421],NULL},
  {798,0,2,1,&joseki_variations[7418],NULL},
  {800,3,2,1,&joseki_variations[7417],NULL},
  {871,0,2,0,NULL,&joseki[1537]},
  {872,3,3,1,&joseki_variations[7419],NULL},
  {800,3,3,1,&joseki_variations[7420],NULL},
  {874,3,5,0,NULL,&joseki[925]},
  {763,0,3,1,&joseki_variations[7422],NULL},
  {796,3,1,1,&joseki_variations[7423],NULL},
  {798,3,3,1,&joseki_variations[7424],NULL},
  {872,3,4,1,&joseki_variations[7425],NULL},
  {799,3,5,1,&joseki_variations[7426],NULL},
  {800,3,7,1,&joseki_variations[7427],NULL},
  {837,0,8,1,&joseki_variations[7428],NULL},
  {724,0,1,0,NULL,&joseki[636]},
  {763,3,3,1,&joseki_variations[7499],NULL},
  {761,3,3,3,&joseki_variations[7431],NULL},
  {798,3,4,3,&joseki_variations[7449],NULL},
  {798,0,4,1,&joseki_variations[7439],NULL},
  {762,0,4,1,&joseki_variations[7434],NULL},
  {796,3,1,1,&joseki_variations[7435],NULL},
  {797,3,3,1,&joseki_variations[7436],NULL},
  {798,0,6,1,&joseki_variations[7437],NULL},
  {834,0,4,1,&joseki_variations[7438],NULL},
  {836,0,9,0,NULL,&joseki[1541]},
  {725,3,2,1,&joseki_variations[7440],NULL},
  {762,0,5,1,&joseki_variations[7441],NULL},
  {799,0,7,1,&joseki_variations[7442],NULL},
  {763,3,6,1,&joseki_variations[7443],NULL},
  {800,0,9,1,&joseki_variations[7444],NULL},
  {837,0,10,1,&joseki_variations[7445],NULL},
  {727,3,3,1,&joseki_variations[7446],NULL},
  {801,3,11,1,&joseki_variations[7447],NULL},
  {838,0,13,1,&joseki_variations[7448],&joseki[576]},
  {802,3,12,0,NULL,&joseki[577]},
  {762,0,4,1,&joseki_variations[7485],NULL},
  {833,0,1,1,&joseki_variations[7465],NULL},
  {725,0,2,1,&joseki_variations[7452],NULL},
  {762,3,5,1,&joseki_variations[7453],NULL},
  {799,3,7,1,&joseki_variations[7454],NULL},
  {726,0,3,1,&joseki_variations[7455],NULL},
  {763,0,7,1,&joseki_variations[7456],NULL},
  {800,3,10,1,&joseki_variations[7457],NULL},
  {837,0,11,1,&joseki_variations[7458],NULL},
  {874,3,12,1,&joseki_variations[7459],NULL},
  {801,0,11,1,&joseki_variations[7460],NULL},
  {838,3,13,1,&joseki_variations[7461],NULL},
  {875,3,15,1,&joseki_variations[7462],NULL},
  {802,0,12,1,&joseki_variations[7463],NULL},
  {839,0,15,1,&joseki_variations[7464],NULL},
  {797,0,2,0,NULL,&joseki[651]},
  {834,0,3,1,&joseki_variations[7466],NULL},
  {835,0,7,1,&joseki_variations[7467],NULL},
  {870,3,2,1,&joseki_variations[7468],NULL},
  {871,3,5,1,&joseki_variations[7469],NULL},
  {872,3,10,1,&joseki_variations[7470],NULL},
  {688,3,1,1,&joseki_variations[7471],NULL},
  {725,0,3,1,&joseki_variations[7472],NULL},
  {762,0,6,1,&joseki_variations[7473],NULL},
  {799,0,8,1,&joseki_variations[7474],NULL},
  {836,3,12,1,&joseki_variations[7475],NULL},
  {726,0,4,1,&joseki_variations[7476],NULL},
  {763,0,8,1,&joseki_variations[7477],NULL},
  {800,3,11,1,&joseki_variations[7478],NULL},
  {837,3,16,1,&joseki_variations[7479],NULL},
  {727,0,5,1,&joseki_variations[7480],NULL},
  {764,3,10,1,&joseki_variations[7481],NULL},
  {801,0,14,1,&joseki_variations[7482],NULL},
  {728,0,6,1,&joseki_variations[7483],NULL},
  {765,3,12,1,&joseki_variations[7484],NULL},
  {723,3,1,0,NULL,&joseki[506]},
  {799,0,6,1,&joseki_variations[7486],NULL},
  {763,0,5,1,&joseki_variations[7487],NULL},
  {800,3,8,1,&joseki_variations[7488],NULL},
  {764,0,6,1,&joseki_variations[7489],NULL},
  {801,0,10,1,&joseki_variations[7490],NULL},
  {833,0,1,1,&joseki_variations[7491],NULL},
  {834,0,3,1,&joseki_variations[7492],NULL},
  {835,0,7,1,&joseki_variations[7493],NULL},
  {836,3,10,1,&joseki_variations[7494],NULL},
  {837,3,13,1,&joseki_variations[7495],NULL},
  {870,3,2,1,&joseki_variations[7496],NULL},
  {871,3,5,1,&joseki_variations[7497],NULL},
  {872,3,10,1,&joseki_variations[7498],NULL},
  {797,3,2,0,NULL,&joseki[449]},
  {798,0,3,3,&joseki_variations[7500],NULL},
  {872,0,4,6,&joseki_variations[7516],NULL},
  {871,0,2,4,&joseki_variations[7507],NULL},
  {1020,0,4,1,&joseki_variations[7503],NULL},
  {803,0,5,1,&joseki_variations[7504],NULL},
  {873,0,4,1,&joseki_variations[7505],NULL},
  {837,3,5,1,&joseki_variations[7506],NULL},
  {729,3,2,0,NULL,&joseki[822]},
  {766,3,4,1,&joseki_variations[7514],&joseki[702]},
  {804,0,5,1,&joseki_variations[7513],NULL},
  {768,3,4,1,&joseki_variations[7512],NULL},
  {802,3,5,1,&joseki_variations[7511],NULL},
  {945,3,3,0,NULL,&joseki[709]},
  {802,3,5,0,NULL,&joseki[708]},
  {802,3,5,0,NULL,&joseki[707]},
  {945,3,3,1,&joseki_variations[7515],&joseki[703]},
  {723,3,1,0,NULL,&joseki[704]},
  {766,3,4,1,&joseki_variations[7557],&joseki[279]},
  {1019,0,2,0,NULL,&joseki[281]},
  {802,3,5,0,NULL,&joseki[282]},
  {1020,0,5,3,&joseki_variations[7528],NULL},
  {803,0,5,1,&joseki_variations[7526],NULL},
  {837,3,5,1,&joseki_variations[7522],NULL},
  {729,3,2,1,&joseki_variations[7523],NULL},
  {803,0,6,1,&joseki_variations[7524],NULL},
  {1019,0,2,1,&joseki_variations[7525],&joseki[838]},
  {766,3,5,0,NULL,&joseki[839]},
  {837,3,5,1,&joseki_variations[7527],NULL},
  {729,3,2,0,NULL,&joseki[837]},
  {803,0,5,1,&joseki_variations[7554],NULL},
  {837,3,5,2,&joseki_variations[7547],NULL},
  {800,3,5,1,&joseki_variations[7531],NULL},
  {837,3,6,3,&joseki_variations[7532],NULL},
  {801,0,6,1,&joseki_variations[7545],NULL},
  {764,0,4,1,&joseki_variations[7542],NULL},
  {727,3,2,1,&joseki_variations[7535],NULL},
  {764,0,5,1,&joseki_variations[7536],NULL},
  {801,0,8,2,&joseki_variations[7537],NULL},
  {803,0,9,1,&joseki_variations[7541],NULL},
  {728,0,3,1,&joseki_variations[7539],NULL},
  {803,0,10,1,&joseki_variations[7540],NULL},
  {726,3,2,0,NULL,&joseki[819]},
  {728,0,3,0,NULL,&joseki[818]},
  {801,0,7,1,&joseki_variations[7543],NULL},
  {803,0,8,1,&joseki_variations[7544],NULL},
  {727,3,2,0,NULL,&joseki[817]},
  {803,0,7,1,&joseki_variations[7546],NULL},
  {764,0,4,0,NULL,&joseki[816]},
  {729,3,2,1,&joseki_variations[7551],NULL},
  {801,0,5,1,&joseki_variations[7549],NULL},
  {803,0,6,1,&joseki_variations[7550],NULL},
  {800,3,5,0,NULL,&joseki[815]},
  {803,0,6,2,&joseki_variations[7552],NULL},
  {911,0,7,0,NULL,&joseki[812]},
  {911,3,7,0,NULL,&joseki[813]},
  {837,3,5,2,&joseki_variations[7555],NULL},
  {729,3,2,0,NULL,&joseki[811]},
  {801,0,5,0,NULL,&joseki[814]},
  {838,0,5,0,NULL,&joseki[280]},
  {761,3,3,2,&joseki_variations[7651],NULL},
  {763,0,3,1,&joseki_variations[7647],NULL},
  {798,3,3,3,&joseki_variations[7593],NULL},
  {762,3,3,1,&joseki_variations[7585],NULL},
  {725,3,2,1,&joseki_variations[7563],NULL},
  {762,3,4,1,&joseki_variations[7564],NULL},
  {763,0,5,1,&joseki_variations[7565],NULL},
  {796,3,1,2,&joseki_variations[7566],NULL},
  {798,3,4,1,&joseki_variations[7580],NULL},
  {797,0,3,1,&joseki_variations[7568],NULL},
  {798,3,5,2,&joseki_variations[7569],NULL},
  {872,3,6,1,&joseki_variations[7576],NULL},
  {799,3,8,1,&joseki_variations[7571],NULL},
  {800,3,10,1,&joseki_variations[7572],NULL},
  {834,3,4,1,&joseki_variations[7573],NULL},
  {837,0,12,1,&joseki_variations[7574],NULL},
  {872,3,7,1,&joseki_variations[7575],NULL},
  {759,0,1,0,NULL,&joseki[640]},
  {799,3,8,1,&joseki_variations[7577],NULL},
  {800,3,10,1,&joseki_variations[7578],NULL},
  {837,0,11,1,&joseki_variations[7579],NULL},
  {834,3,4,0,NULL,&joseki[639]},
  {872,3,5,1,&joseki_variations[7581],NULL},
  {799,3,7,1,&joseki_variations[7582],NULL},
  {800,3,9,1,&joseki_variations[7583],NULL},
  {837,0,10,1,&joseki_variations[7584],NULL},
  {797,0,3,0,NULL,&joseki[638]},
  {763,0,4,1,&joseki_variations[7586],NULL},
  {796,3,1,1,&joseki_variations[7587],NULL},
  {798,3,4,1,&joseki_variations[7588],NULL},
  {872,3,5,1,&joseki_variations[7589],NULL},
  {799,3,6,1,&joseki_variations[7590],NULL},
  {800,3,8,1,&joseki_variations[7591],NULL},
  {837,0,9,1,&joseki_variations[7592],NULL},
  {725,3,2,0,NULL,&joseki[637]},
  {872,3,4,2,&joseki_variations[7615],NULL},
  {870,0,1,1,&joseki_variations[7603],NULL},
  {833,0,1,1,&joseki_variations[7596],NULL},
  {872,3,5,1,&joseki_variations[7597],NULL},
  {725,0,2,1,&joseki_variations[7598],NULL},
  {762,3,4,1,&joseki_variations[7599],NULL},
  {763,0,5,1,&joseki_variations[7600],NULL},
  {800,3,7,1,&joseki_variations[7601],NULL},
  {765,3,6,1,&joseki_variations[7602],NULL},
  {726,3,3,0,NULL,&joseki[274]},
  {872,3,5,1,&joseki_variations[7604],NULL},
  {725,0,2,1,&joseki_variations[7605],NULL},
  {762,3,4,2,&joseki_variations[7606],NULL},
  {763,0,5,1,&joseki_variations[7612],NULL},
  {726,3,3,1,&joseki_variations[7608],NULL},
  {763,0,6,1,&joseki_variations[7609],NULL},
  {800,3,8,1,&joseki_variations[7610],NULL},
  {765,3,7,1,&joseki_variations[7611],NULL},
  {834,0,2,0,NULL,&joseki[272]},
  {800,3,7,1,&joseki_variations[7613],NULL},
  {765,3,6,1,&joseki_variations[7614],NULL},
  {726,3,3,0,NULL,&joseki[271]},
  {762,3,3,1,&joseki_variations[7644],NULL},
  {725,0,2,1,&joseki_variations[7617],NULL},
  {762,3,4,2,&joseki_variations[7618],NULL},
  {763,0,5,2,&joseki_variations[7629],NULL},
  {726,0,3,1,&joseki_variations[7620],NULL},
  {763,0,6,1,&joseki_variations[7621],NULL},
  {800,3,8,2,&joseki_variations[7622],NULL},
  {764,3,7,1,&joseki_variations[7625],NULL},
  {765,3,7,1,&joseki_variations[7624],NULL},
  {801,3,9,0,NULL,&joseki[275]},
  {801,0,10,1,&joseki_variations[7626],NULL},
  {765,3,8,1,&joseki_variations[7627],NULL},
  {838,3,11,1,&joseki_variations[7628],&joseki[267]},
  {802,3,12,0,NULL,&joseki[268]},
  {765,3,6,1,&joseki_variations[7641],NULL},
  {800,3,7,3,&joseki_variations[7631],NULL},
  {764,3,6,1,&joseki_variations[7638],NULL},
  {801,0,8,1,&joseki_variations[7636],NULL},
  {765,3,6,2,&joseki_variations[7634],NULL},
  {870,0,1,0,NULL,&joseki[270]},
  {833,0,1,0,NULL,&joseki[273]},
  {765,3,6,1,&joseki_variations[7637],NULL},
  {837,3,8,0,NULL,&joseki[269]},
  {801,0,9,1,&joseki_variations[7639],NULL},
  {765,3,7,1,&joseki_variations[7640],NULL},
  {726,0,3,0,NULL,&joseki[266]},
  {800,3,7,1,&joseki_variations[7642],&joseki[263]},
  {801,0,8,1,&joseki_variations[7643],&joseki[264]},
  {764,3,6,0,NULL,&joseki[265]},
  {763,0,4,1,&joseki_variations[7645],NULL},
  {765,3,5,1,&joseki_variations[7646],NULL},
  {725,0,2,0,NULL,&joseki[262]},
  {765,3,4,1,&joseki_variations[7648],NULL},
  {798,3,3,1,&joseki_variations[7649],NULL},
  {872,3,4,1,&joseki_variations[7650],NULL},
  {762,3,3,0,NULL,&joseki[261]},
  {763,0,4,2,&joseki_variations[7665],NULL},
  {798,0,4,1,&joseki_variations[7653],NULL},
  {725,3,2,2,&joseki_variations[7654],NULL},
  {763,3,5,1,&joseki_variations[7661],NULL},
  {762,3,5,1,&joseki_variations[7656],NULL},
  {763,3,6,1,&joseki_variations[7657],NULL},
  {800,0,8,1,&joseki_variations[7658],NULL},
  {837,0,9,1,&joseki_variations[7659],NULL},
  {801,3,9,1,&joseki_variations[7660],NULL},
  {723,0,1,0,NULL,&joseki[586]},
  {800,0,7,1,&joseki_variations[7662],NULL},
  {837,0,8,1,&joseki_variations[7663],NULL},
  {801,3,8,1,&joseki_variations[7664],NULL},
  {762,3,5,0,NULL,&joseki[585]},
  {765,3,5,1,&joseki_variations[7669],NULL},
  {871,3,2,1,&joseki_variations[7667],NULL},
  {798,3,4,1,&joseki_variations[7668],NULL},
  {725,3,2,0,NULL,&joseki[752]},
  {798,3,4,1,&joseki_variations[7670],NULL},
  {837,0,6,1,&joseki_variations[7671],NULL},
  {872,3,5,1,&joseki_variations[7672],NULL},
  {725,3,2,0,NULL,&joseki[204]},
  {872,3,3,2,&joseki_variations[7716],NULL},
  {871,0,2,1,&joseki_variations[7707],NULL},
  {762,3,2,1,&joseki_variations[7690],NULL},
  {764,3,2,1,&joseki_variations[7688],NULL},
  {836,3,3,1,&joseki_variations[7685],NULL},
  {909,3,3,1,&joseki_variations[7684],NULL},
  {871,3,2,1,&joseki_variations[7683],NULL},
  {908,3,2,1,&joseki_variations[7682],NULL},
  {761,0,2,0,NULL,&joseki[1532]},
  {761,3,2,0,NULL,&joseki[979]},
  {761,3,2,0,NULL,&joseki[973]},
  {761,3,2,0,NULL,&joseki[965]},
  {872,0,3,1,&joseki_variations[7686],NULL},
  {800,0,3,1,&joseki_variations[7687],NULL},
  {761,3,2,0,NULL,&joseki[916]},
  {804,3,4,1,&joseki_variations[7689],NULL},
  {797,3,2,0,NULL,&joseki[878]},
  {763,0,3,1,&joseki_variations[7691],NULL},
  {800,3,5,3,&joseki_variations[7692],NULL},
  {837,3,6,2,&joseki_variations[7702],NULL},
  {801,0,6,1,&joseki_variations[7699],NULL},
  {764,3,4,1,&joseki_variations[7695],NULL},
  {801,0,7,1,&joseki_variations[7696],NULL},
  {833,0,1,1,&joseki_variations[7697],NULL},
  {837,3,7,1,&joseki_variations[7698],NULL},
  {908,0,3,0,NULL,&joseki[600]},
  {833,0,1,1,&joseki_variations[7700],NULL},
  {837,3,7,1,&joseki_variations[7701],NULL},
  {764,3,4,0,NULL,&joseki[599]},
  {801,0,6,1,&joseki_variations[7706],NULL},
  {764,0,4,1,&joseki_variations[7704],NULL},
  {801,0,7,1,&joseki_variations[7705],NULL},
  {797,3,2,0,NULL,&joseki[601]},
  {833,0,1,0,NULL,&joseki[598]},
  {762,3,2,1,&joseki_variations[7708],NULL},
  {763,0,3,1,&joseki_variations[7709],NULL},
  {800,3,5,2,&joseki_variations[7710],NULL},
  {764,3,4,1,&joseki_variations[7713],NULL},
  {765,3,4,1,&joseki_variations[7712],NULL},
  {797,0,2,0,NULL,&joseki[252]},
  {801,0,7,1,&joseki_variations[7714],NULL},
  {765,3,5,1,&joseki_variations[7715],NULL},
  {797,0,2,0,NULL,&joseki[218]},
  {762,3,2,2,&joseki_variations[7719],NULL},
  {800,0,3,1,&joseki_variations[7718],NULL},
  {761,3,2,0,NULL,&joseki[907]},
  {726,0,1,1,&joseki_variations[7727],NULL},
  {763,0,3,2,&joseki_variations[7721],NULL},
  {800,0,5,1,&joseki_variations[7726],NULL},
  {799,3,4,1,&joseki_variations[7723],NULL},
  {800,3,6,1,&joseki_variations[7724],NULL},
  {837,0,7,1,&joseki_variations[7725],NULL},
  {796,3,1,0,NULL,&joseki[635]},
  {797,3,2,0,NULL,&joseki[284]},
  {763,0,4,1,&joseki_variations[7728],NULL},
  {800,0,6,1,&joseki_variations[7729],NULL},
  {837,0,7,1,&joseki_variations[7730],NULL},
  {874,3,9,1,&joseki_variations[7731],NULL},
  {801,3,7,1,&joseki_variations[7732],NULL},
  {838,3,9,1,&joseki_variations[7733],NULL},
  {875,0,12,1,&joseki_variations[7734],NULL},
  {912,0,13,1,&joseki_variations[7735],NULL},
  {765,3,5,1,&joseki_variations[7736],NULL},
  {802,3,9,1,&joseki_variations[7737],NULL},
  {839,0,12,1,&joseki_variations[7738],NULL},
  {876,3,16,1,&joseki_variations[7739],NULL},
  {766,3,6,1,&joseki_variations[7740],NULL},
  {803,0,11,1,&joseki_variations[7741],NULL},
  {840,0,15,1,&joseki_variations[7742],NULL},
  {767,3,7,1,&joseki_variations[7743],NULL},
  {804,0,13,1,&joseki_variations[7744],NULL},
  {805,0,14,1,&joseki_variations[7745],NULL},
  {797,3,2,0,NULL,&joseki[183]},
  {724,0,1,1,&joseki_variations[7959],NULL},
  {761,3,2,3,&joseki_variations[7887],NULL},
  {871,0,3,3,&joseki_variations[7815],NULL},
  {798,3,3,1,&joseki_variations[7799],NULL},
  {834,0,3,2,&joseki_variations[7751],NULL},
  {761,0,2,1,&joseki_variations[7781],NULL},
  {724,3,1,1,&joseki_variations[7753],NULL},
  {761,0,3,1,&joseki_variations[7754],NULL},
  {798,3,5,1,&joseki_variations[7755],NULL},
  {835,3,7,1,&joseki_variations[7756],NULL},
  {725,0,2,1,&joseki_variations[7757],NULL},
  {762,3,5,1,&joseki_variations[7758],NULL},
  {726,3,3,1,&joseki_variations[7759],&joseki[1193]},
  {872,0,8,2,&joseki_variations[7760],&joseki[1194]},
  {800,3,9,2,&joseki_variations[7768],&joseki[1195]},
  {799,0,8,1,&joseki_variations[7762],NULL},
  {873,0,12,1,&joseki_variations[7763],NULL},
  {800,3,10,1,&joseki_variations[7764],NULL},
  {837,0,13,1,&joseki_variations[7765],NULL},
  {838,3,14,1,&joseki_variations[7766],NULL},
  {875,3,17,1,&joseki_variations[7767],NULL},
  {763,3,7,0,NULL,&joseki[1201]},
  {837,0,12,2,&joseki_variations[7770],&joseki[1196]},
  {723,3,1,0,NULL,&joseki[1207]},
  {838,3,13,2,&joseki_variations[7772],&joseki[1197]},
  {801,3,10,0,NULL,&joseki[1206]},
  {873,0,11,2,&joseki_variations[7776],&joseki[1198]},
  {875,0,15,1,&joseki_variations[7774],&joseki[1202]},
  {839,3,14,1,&joseki_variations[7775],&joseki[1203]},
  {873,0,11,0,NULL,&joseki[1204]},
  {875,3,16,1,&joseki_variations[7780],&joseki[1199]},
  {875,0,16,1,&joseki_variations[7778],NULL},
  {839,3,14,1,&joseki_variations[7779],NULL},
  {876,3,18,0,NULL,&joseki[1205]},
  {799,0,8,0,NULL,&joseki[1200]},
  {798,3,4,1,&joseki_variations[7782],NULL},
  {835,3,6,2,&joseki_variations[7783],NULL},
  {762,3,3,1,&joseki_variations[7795],NULL},
  {872,3,7,1,&joseki_variations[7785],NULL},
  {725,0,1,1,&joseki_variations[7786],NULL},
  {762,3,4,2,&joseki_variations[7787],NULL},
  {763,3,5,1,&joseki_variations[7794],&joseki[1143]},
  {726,0,2,1,&joseki_variations[7789],NULL},
  {763,3,6,1,&joseki_variations[7790],NULL},
  {764,3,7,1,&joseki_variations[7791],&joseki[1145]},
  {908,0,4,1,&joseki_variations[7792],&joseki[1146]},
  {947,3,11,1,&joseki_variations[7793],&joseki[1147]},
  {945,0,5,0,NULL,&joseki[1148]},
  {726,0,2,0,NULL,&joseki[1144]},
  {872,3,7,2,&joseki_variations[7796],&joseki[1139]},
  {908,0,4,1,&joseki_variations[7798],&joseki[1140]},
  {725,0,1,0,NULL,&joseki[1142]},
  {800,3,6,0,NULL,&joseki[1141]},
  {762,3,2,1,&joseki_variations[7800],NULL},
  {763,0,3,1,&joseki_variations[7801],NULL},
  {800,3,6,2,&joseki_variations[7802],NULL},
  {837,3,7,1,&joseki_variations[7810],NULL},
  {801,0,7,1,&joseki_variations[7804],NULL},
  {833,0,1,1,&joseki_variations[7805],NULL},
  {837,3,8,1,&joseki_variations[7806],NULL},
  {870,0,2,1,&joseki_variations[7807],NULL},
  {871,3,5,1,&joseki_variations[7808],NULL},
  {907,3,3,1,&joseki_variations[7809],NULL},
  {908,3,7,0,NULL,&joseki[606]},
  {801,0,7,2,&joseki_variations[7811],NULL},
  {871,3,3,0,NULL,&joseki[604]},
  {870,0,1,1,&joseki_variations[7813],NULL},
  {871,3,4,1,&joseki_variations[7814],NULL},
  {907,3,2,0,NULL,&joseki[605]},
  {798,3,3,2,&joseki_variations[7855],NULL},
  {761,3,2,1,&joseki_variations[7834],NULL},
  {724,0,1,1,&joseki_variations[7818],NULL},
  {761,3,3,2,&joseki_variations[7819],NULL},
  {763,0,4,1,&joseki_variations[7828],NULL},
  {798,3,5,1,&joseki_variations[7821],NULL},
  {835,0,6,1,&joseki_variations[7822],NULL},
  {725,3,2,1,&joseki_variations[7823],NULL},
  {799,3,7,1,&joseki_variations[7824],NULL},
  {836,3,9,1,&joseki_variations[7825],NULL},
  {910,3,11,1,&joseki_variations[7826],NULL},
  {763,0,5,1,&joseki_variations[7827],NULL},
  {723,0,1,0,NULL,&joseki[768]},
  {798,3,5,1,&joseki_variations[7829],NULL},
  {835,0,6,1,&joseki_variations[7830],NULL},
  {799,3,6,1,&joseki_variations[7831],NULL},
  {836,3,8,1,&joseki_variations[7832],NULL},
  {910,3,10,1,&joseki_variations[7833],NULL},
  {725,3,2,0,NULL,&joseki[767]},
  {763,0,3,2,&joseki_variations[7835],NULL},
  {765,3,4,1,&joseki_variations[7848],NULL},
  {798,3,4,2,&joseki_variations[7837],NULL},
  {836,3,5,1,&joseki_variations[7846],NULL},
  {835,0,5,2,&joseki_variations[7839],NULL},
  {836,3,6,1,&joseki_variations[7844],NULL},
  {799,3,5,1,&joseki_variations[7841],NULL},
  {836,3,7,1,&joseki_variations[7842],NULL},
  {910,3,9,1,&joseki_variations[7843],NULL},
  {724,0,1,0,NULL,&joseki[766]},
  {910,3,8,1,&joseki_variations[7845],NULL},
  {799,3,5,0,NULL,&joseki[765]},
  {910,3,7,1,&joseki_variations[7847],&joseki[763]},
  {835,0,5,0,NULL,&joseki[764]},
  {798,3,4,1,&joseki_variations[7849],NULL},
  {800,3,6,2,&joseki_variations[7850],NULL},
  {835,3,5,1,&joseki_variations[7854],&joseki[239]},
  {835,0,5,1,&joseki_variations[7852],&joseki[242]},
  {836,3,6,1,&joseki_variations[7853],NULL},
  {873,0,8,0,NULL,&joseki[243]},
  {723,0,1,0,NULL,&joseki[240]},
  {762,3,2,2,&joseki_variations[7873],NULL},
  {725,3,1,1,&joseki_variations[7857],NULL},
  {762,3,3,1,&joseki_variations[7858],NULL},
  {726,0,2,1,&joseki_variations[7859],NULL},
  {763,0,5,2,&joseki_variations[7860],NULL},
  {800,3,8,1,&joseki_variations[7868],NULL},
  {764,3,6,1,&joseki_variations[7862],NULL},
  {765,3,7,1,&joseki_variations[7863],NULL},
  {799,3,6,1,&joseki_variations[7864],NULL},
  {800,3,9,1,&joseki_variations[7865],NULL},
  {837,0,10,1,&joseki_variations[7866],NULL},
  {801,0,11,1,&joseki_variations[7867],NULL},
  {873,0,8,0,NULL,&joseki[226]},
  {764,3,6,1,&joseki_variations[7869],NULL},
  {801,0,10,1,&joseki_variations[7870],NULL},
  {765,3,7,1,&joseki_variations[7871],NULL},
  {837,0,9,1,&joseki_variations[7872],&joseki[224]},
  {799,3,6,0,NULL,&joseki[225]},
  {763,0,3,1,&joseki_variations[7881],NULL},
  {726,0,1,1,&joseki_variations[7875],NULL},
  {763,0,4,1,&joseki_variations[7876],NULL},
  {800,3,7,1,&joseki_variations[7877],NULL},
  {764,3,5,1,&joseki_variations[7878],NULL},
  {801,0,9,1,&joseki_variations[7879],NULL},
  {765,3,6,1,&joseki_variations[7880],NULL},
  {725,3,1,0,NULL,&joseki[223]},
  {800,3,6,1,&joseki_variations[7882],NULL},
  {764,3,4,1,&joseki_variations[7883],NULL},
  {801,0,8,1,&joseki_variations[7884],NULL},
  {765,3,5,2,&joseki_variations[7885],NULL},
  {726,0,1,0,NULL,&joseki[222]},
  {838,3,9,0,NULL,&joseki[227]},
  {763,0,3,2,&joseki_variations[7945],NULL},
  {798,0,4,1,&joseki_variations[7938],NULL},
  {798,3,4,7,&joseki_variations[7890],NULL},
  {836,3,5,1,&joseki_variations[7934],NULL},
  {800,0,5,2,&joseki_variations[7926],NULL},
  {834,3,3,3,&joseki_variations[7921],&joseki[938]},
  {833,0,1,1,&joseki_variations[7900],NULL},
  {909,3,5,1,&joseki_variations[7899],NULL},
  {871,3,3,1,&joseki_variations[7898],NULL},
  {908,3,3,1,&joseki_variations[7897],NULL},
  {834,3,3,0,NULL,&joseki[981]},
  {834,3,3,0,NULL,&joseki[974]},
  {834,3,3,0,NULL,&joseki[967]},
  {834,3,4,5,&joseki_variations[7901],NULL},
  {871,3,5,2,&joseki_variations[7918],&joseki[940]},
  {870,0,2,1,&joseki_variations[7915],NULL},
  {909,3,7,1,&joseki_variations[7914],NULL},
  {908,3,5,1,&joseki_variations[7913],NULL},
  {870,3,2,2,&joseki_variations[7906],NULL},
  {908,3,6,1,&joseki_variations[7911],NULL},
  {835,0,7,1,&joseki_variations[7908],NULL},
  {871,3,6,1,&joseki_variations[7909],NULL},
  {908,3,7,1,&joseki_variations[7910],NULL},
  {724,0,1,0,NULL,&joseki[986]},
  {835,0,7,1,&joseki_variations[7912],&joseki[984]},
  {871,3,6,0,NULL,&joseki[985]},
  {870,3,2,0,NULL,&joseki[983]},
  {871,3,5,0,NULL,&joseki[969]},
  {871,3,6,2,&joseki_variations[7916],NULL},
  {908,3,7,0,NULL,&joseki[942]},
  {724,0,1,0,NULL,&joseki[943]},
  {870,0,2,0,NULL,&joseki[941]},
  {909,3,8,1,&joseki_variations[7920],NULL},
  {724,0,1,0,NULL,&joseki[970]},
  {833,0,1,0,NULL,&joseki[939]},
  {909,3,6,1,&joseki_variations[7925],NULL},
  {908,3,4,1,&joseki_variations[7924],NULL},
  {833,0,1,0,NULL,&joseki[982]},
  {833,0,1,0,NULL,&joseki[968]},
  {835,0,5,1,&joseki_variations[7930],NULL},
  {834,3,3,1,&joseki_variations[7928],NULL},
  {835,0,6,1,&joseki_variations[7929],NULL},
  {723,3,1,0,NULL,&joseki[1590]},
  {836,3,6,1,&joseki_variations[7931],NULL},
  {837,3,8,1,&joseki_variations[7932],NULL},
  {872,0,6,1,&joseki_variations[7933],NULL},
  {801,3,6,0,NULL,&joseki[920]},
  {872,0,5,1,&joseki_variations[7935],NULL},
  {800,0,5,1,&joseki_variations[7936],NULL},
  {837,3,7,1,&joseki_variations[7937],&joseki[918]},
  {835,0,5,0,NULL,&joseki[919]},
  {762,3,3,1,&joseki_variations[7939],NULL},
  {763,3,4,1,&joseki_variations[7940],NULL},
  {800,0,7,1,&joseki_variations[7941],NULL},
  {837,0,8,1,&joseki_variations[7942],NULL},
  {801,3,8,1,&joseki_variations[7943],NULL},
  {766,3,5,1,&joseki_variations[7944],&joseki[581]},
  {1019,0,3,0,NULL,&joseki[582]},
  {765,3,4,1,&joseki_variations[7957],NULL},
  {798,3,4,4,&joseki_variations[7947],NULL},
  {834,3,3,1,&joseki_variations[7956],NULL},
  {836,3,5,1,&joseki_variations[7954],NULL},
  {835,3,5,1,&joseki_variations[7953],&joseki[792]},
  {803,3,6,1,&joseki_variations[7951],NULL},
  {835,3,5,1,&joseki_variations[7952],&joseki[827]},
  {724,0,1,0,NULL,&joseki[828]},
  {724,0,1,0,NULL,&joseki[793]},
  {872,0,5,1,&joseki_variations[7955],NULL},
  {723,3,1,0,NULL,&joseki[784]},
  {723,0,1,0,NULL,&joseki[134]},
  {798,3,4,1,&joseki_variations[7958],NULL},
  {834,3,3,0,NULL,&joseki[133]},
  {761,3,3,2,&joseki_variations[7960],NULL},
  {763,0,4,2,&joseki_variations[7992],NULL},
  {798,3,5,3,&joseki_variations[7962],NULL},
  {835,3,6,1,&joseki_variations[7985],NULL},
  {833,0,1,1,&joseki_variations[7970],NULL},
  {834,3,3,3,&joseki_variations[7965],NULL},
  {725,3,2,1,&joseki_variations[7969],&joseki[947]},
  {835,3,7,0,NULL,&joseki[955]},
  {871,3,4,1,&joseki_variations[7968],NULL},
  {725,3,2,0,NULL,&joseki[975]},
  {723,0,1,0,NULL,&joseki[948]},
  {834,3,4,3,&joseki_variations[7971],NULL},
  {870,0,2,1,&joseki_variations[7982],NULL},
  {871,3,5,1,&joseki_variations[7979],NULL},
  {835,0,8,1,&joseki_variations[7974],NULL},
  {870,3,2,1,&joseki_variations[7975],NULL},
  {871,3,6,1,&joseki_variations[7976],NULL},
  {908,3,7,1,&joseki_variations[7977],NULL},
  {725,3,2,1,&joseki_variations[7978],&joseki[987]},
  {723,0,1,0,NULL,&joseki[988]},
  {909,3,9,1,&joseki_variations[7980],NULL},
  {725,3,2,1,&joseki_variations[7981],&joseki[971]},
  {723,0,1,0,NULL,&joseki[972]},
  {871,3,6,1,&joseki_variations[7983],NULL},
  {725,3,2,1,&joseki_variations[7984],&joseki[944]},
  {723,0,1,0,NULL,&joseki[945]},
  {725,3,2,1,&joseki_variations[7986],NULL},
  {763,0,5,3,&joseki_variations[7987],NULL},
  {765,3,6,1,&joseki_variations[7991],NULL},
  {723,0,1,0,NULL,&joseki[795]},
  {803,3,8,1,&joseki_variations[7990],NULL},
  {723,0,1,0,NULL,&joseki[830]},
  {723,0,1,0,NULL,&joseki[126]},
  {765,3,5,1,&joseki_variations[7998],NULL},
  {798,3,5,1,&joseki_variations[7994],NULL},
  {835,3,6,2,&joseki_variations[7995],NULL},
  {725,3,2,0,NULL,&joseki[794]},
  {803,3,7,1,&joseki_variations[7997],NULL},
  {725,3,2,0,NULL,&joseki[829]},
  {798,3,5,1,&joseki_variations[7999],NULL},
  {835,3,6,1,&joseki_variations[8000],NULL},
  {725,3,2,0,NULL,&joseki[125]},
  {763,0,3,3,&joseki_variations[8149],NULL},
  {763,3,3,2,&joseki_variations[8127],NULL},
  {798,0,3,5,&joseki_variations[8038],NULL},
  {798,3,3,4,&joseki_variations[8029],NULL},
  {800,3,3,1,&joseki_variations[8026],NULL},
  {762,3,3,1,&joseki_variations[8013],NULL},
  {871,0,2,1,&joseki_variations[8010],NULL},
  {835,0,3,1,&joseki_variations[8009],NULL},
  {723,3,1,0,NULL,&joseki[1556]},
  {945,3,3,2,&joseki_variations[8011],NULL},
  {723,3,1,0,NULL,&joseki[1492]},
  {797,3,2,0,NULL,&joseki[1496]},
  {763,3,4,1,&joseki_variations[8014],NULL},
  {796,0,1,1,&joseki_variations[8015],NULL},
  {798,0,4,1,&joseki_variations[8016],NULL},
  {801,0,7,1,&joseki_variations[8017],NULL},
  {835,0,5,1,&joseki_variations[8018],NULL},
  {946,3,6,1,&joseki_variations[8019],NULL},
  {836,3,7,1,&joseki_variations[8020],NULL},
  {873,0,8,1,&joseki_variations[8021],NULL},
  {837,3,9,1,&joseki_variations[8022],NULL},
  {874,0,11,1,&joseki_variations[8023],NULL},
  {838,3,11,2,&joseki_variations[8024],NULL},
  {769,3,5,0,NULL,&joseki[1285]},
  {768,3,5,0,NULL,&joseki[1286]},
  {835,0,3,2,&joseki_variations[8027],NULL},
  {723,3,1,0,NULL,&joseki[1226]},
  {797,3,2,0,NULL,&joseki[1233]},
  {836,3,4,1,&joseki_variations[8035],NULL},
  {797,0,2,0,NULL,&joseki[937]},
  {909,3,4,1,&joseki_variations[8034],NULL},
  {908,3,2,1,&joseki_variations[8033],NULL},
  {797,0,2,0,NULL,&joseki[980]},
  {797,0,2,0,NULL,&joseki[966]},
  {872,0,4,1,&joseki_variations[8036],NULL},
  {800,0,4,1,&joseki_variations[8037],NULL},
  {797,0,2,0,NULL,&joseki[917]},
  {725,3,1,2,&joseki_variations[8114],NULL},
  {762,3,3,2,&joseki_variations[8106],NULL},
  {872,0,4,4,&joseki_variations[8092],NULL},
  {800,3,4,1,&joseki_variations[8090],NULL},
  {835,0,4,3,&joseki_variations[8043],NULL},
  {872,0,5,2,&joseki_variations[8083],NULL},
  {946,3,5,2,&joseki_variations[8060],NULL},
  {871,0,2,1,&joseki_variations[8046],NULL},
  {946,3,6,1,&joseki_variations[8047],NULL},
  {762,3,3,2,&joseki_variations[8048],NULL},
  {799,3,5,1,&joseki_variations[8055],NULL},
  {836,3,6,1,&joseki_variations[8050],NULL},
  {873,0,8,1,&joseki_variations[8051],NULL},
  {763,3,4,1,&joseki_variations[8052],NULL},
  {837,3,8,1,&joseki_variations[8053],NULL},
  {801,0,6,1,&joseki_variations[8054],NULL},
  {723,3,1,0,NULL,&joseki[1275]},
  {801,0,6,1,&joseki_variations[8056],NULL},
  {836,3,7,1,&joseki_variations[8057],NULL},
  {873,0,9,1,&joseki_variations[8058],NULL},
  {837,3,8,1,&joseki_variations[8059],NULL},
  {723,3,1,0,NULL,&joseki[1269]},
  {799,3,4,1,&joseki_variations[8078],NULL},
  {762,3,3,2,&joseki_variations[8062],NULL},
  {799,3,5,1,&joseki_variations[8073],NULL},
  {836,3,6,1,&joseki_variations[8064],NULL},
  {873,0,7,1,&joseki_variations[8065],NULL},
  {763,3,4,1,&joseki_variations[8066],NULL},
  {837,3,8,1,&joseki_variations[8067],NULL},
  {801,0,6,2,&joseki_variations[8068],NULL},
  {871,0,2,0,NULL,&joseki[1274]},
  {874,0,10,1,&joseki_variations[8070],NULL},
  {838,3,10,2,&joseki_variations[8071],NULL},
  {796,0,1,0,NULL,&joseki[1284]},
  {723,0,1,0,NULL,&joseki[1287]},
  {801,0,6,1,&joseki_variations[8074],NULL},
  {836,3,7,1,&joseki_variations[8075],NULL},
  {873,0,8,1,&joseki_variations[8076],NULL},
  {837,3,8,1,&joseki_variations[8077],NULL},
  {871,0,2,0,NULL,&joseki[1268]},
  {801,0,5,1,&joseki_variations[8079],NULL},
  {836,3,6,1,&joseki_variations[8080],NULL},
  {873,0,7,1,&joseki_variations[8081],NULL},
  {837,3,7,1,&joseki_variations[8082],NULL},
  {762,3,3,0,NULL,&joseki[1267]},
  {799,3,4,1,&joseki_variations[8088],NULL},
  {725,3,1,1,&joseki_variations[8085],NULL},
  {799,3,5,1,&joseki_variations[8086],NULL},
  {801,3,6,1,&joseki_variations[8087],NULL},
  {723,0,1,0,NULL,&joseki[1009]},
  {801,3,5,1,&joseki_variations[8089],NULL},
  {725,3,1,0,NULL,&joseki[1008]},
  {871,0,2,1,&joseki_variations[8091],NULL},
  {762,3,3,0,NULL,&joseki[929]},
  {800,3,4,1,&joseki_variations[8105],NULL},
  {762,3,3,2,&joseki_variations[8101],NULL},
  {801,3,4,3,&joseki_variations[8098],NULL},
  {799,3,4,1,&joseki_variations[8096],NULL},
  {801,3,5,1,&joseki_variations[8097],NULL},
  {835,0,4,0,NULL,&joseki[1007]},
  {762,3,3,0,NULL,&joseki[1000]},
  {799,3,4,0,NULL,&joseki[1006]},
  {723,3,1,0,NULL,&joseki[1012]},
  {800,3,5,1,&joseki_variations[8104],NULL},
  {801,3,5,1,&joseki_variations[8103],NULL},
  {723,0,1,0,NULL,&joseki[1001]},
  {723,0,1,0,NULL,&joseki[904]},
  {762,3,3,0,NULL,&joseki[903]},
  {763,3,4,1,&joseki_variations[8110],NULL},
  {800,3,5,1,&joseki_variations[8108],NULL},
  {871,0,2,1,&joseki_variations[8109],NULL},
  {723,0,1,0,NULL,&joseki[930]},
  {800,0,6,1,&joseki_variations[8111],NULL},
  {837,0,7,1,&joseki_variations[8112],NULL},
  {801,3,7,1,&joseki_variations[8113],NULL},
  {797,0,2,0,NULL,&joseki[580]},
  {762,0,4,1,&joseki_variations[8120],NULL},
  {763,3,4,1,&joseki_variations[8116],NULL},
  {800,0,6,1,&joseki_variations[8117],NULL},
  {837,0,7,1,&joseki_variations[8118],NULL},
  {801,3,7,1,&joseki_variations[8119],NULL},
  {724,0,1,0,NULL,&joseki[584]},
  {799,0,6,1,&joseki_variations[8121],NULL},
  {763,3,5,1,&joseki_variations[8122],NULL},
  {800,0,8,1,&joseki_variations[8123],NULL},
  {837,0,9,1,&joseki_variations[8124],NULL},
  {727,3,2,1,&joseki_variations[8125],NULL},
  {801,3,10,1,&joseki_variations[8126],NULL},
  {724,3,1,0,NULL,&joseki[575]},
  {798,0,3,4,&joseki_variations[8130],NULL},
  {835,0,3,1,&joseki_variations[8129],NULL},
  {797,3,2,0,NULL,&joseki[1305]},
  {872,0,4,1,&joseki_variations[8148],NULL},
  {800,0,5,1,&joseki_variations[8144],NULL},
  {871,0,2,1,&joseki_variations[8143],NULL},
  {801,0,5,1,&joseki_variations[8134],NULL},
  {835,0,4,1,&joseki_variations[8135],NULL},
  {946,3,5,1,&joseki_variations[8136],NULL},
  {836,3,5,1,&joseki_variations[8137],NULL},
  {873,0,6,1,&joseki_variations[8138],NULL},
  {837,3,7,2,&joseki_variations[8139],NULL},
  {762,3,3,0,NULL,&joseki[1273]},
  {874,0,9,1,&joseki_variations[8141],NULL},
  {838,3,9,1,&joseki_variations[8142],NULL},
  {762,3,3,0,NULL,&joseki[1283]},
  {723,3,1,0,NULL,&joseki[711]},
  {837,0,6,1,&joseki_variations[8145],NULL},
  {801,3,6,2,&joseki_variations[8146],NULL},
  {762,3,3,0,NULL,&joseki[579]},
  {725,3,1,0,NULL,&joseki[583]},
  {723,3,1,0,NULL,&joseki[296]},
  {765,3,4,2,&joseki_variations[8165],NULL},
  {871,0,2,1,&joseki_variations[8158],NULL},
  {798,3,3,3,&joseki_variations[8152],NULL},
  {836,3,4,1,&joseki_variations[8156],NULL},
  {797,0,2,0,NULL,&joseki[791]},
  {803,3,5,1,&joseki_variations[8155],NULL},
  {797,0,2,0,NULL,&joseki[826]},
  {872,0,4,1,&joseki_variations[8157],NULL},
  {797,0,2,0,NULL,&joseki[783]},
  {798,3,3,2,&joseki_variations[8159],NULL},
  {836,3,4,1,&joseki_variations[8164],NULL},
  {872,3,5,1,&joseki_variations[8161],NULL},
  {873,3,6,1,&joseki_variations[8162],NULL},
  {909,0,6,1,&joseki_variations[8163],NULL},
  {797,0,2,0,NULL,&joseki[777]},
  {797,0,2,0,NULL,&joseki[762]},
  {798,3,3,2,&joseki_variations[8170],NULL},
  {797,0,2,1,&joseki_variations[8167],NULL},
  {798,3,4,1,&joseki_variations[8168],NULL},
  {835,3,5,1,&joseki_variations[8169],&joseki[123]},
  {724,0,1,0,NULL,&joseki[124]},
  {797,0,2,0,NULL,&joseki[122]},
  {800,3,5,1,&joseki_variations[8172],NULL},
  {871,0,2,1,&joseki_variations[8173],NULL},
  {797,0,2,0,NULL,&joseki[238]},
  {765,3,3,2,&joseki_variations[8219],NULL},
  {764,3,3,1,&joseki_variations[8213],NULL},
  {798,3,2,8,&joseki_variations[8183],NULL},
  {797,3,2,1,&joseki_variations[8178],NULL},
  {798,3,3,1,&joseki_variations[8179],NULL},
  {800,3,5,1,&joseki_variations[8180],NULL},
  {837,3,6,1,&joseki_variations[8181],NULL},
  {801,0,6,1,&joseki_variations[8182],NULL},
  {761,0,2,0,NULL,&joseki[591]},
  {872,3,3,2,&joseki_variations[8211],NULL},
  {800,3,4,2,&joseki_variations[8206],NULL},
  {871,3,2,1,&joseki_variations[8205],NULL},
  {836,3,3,2,&joseki_variations[8201],NULL},
  {871,0,2,1,&joseki_variations[8197],NULL},
  {834,3,2,1,&joseki_variations[8192],NULL},
  {761,3,2,0,NULL,&joseki[790]},
  {803,3,4,1,&joseki_variations[8191],NULL},
  {761,3,2,0,NULL,&joseki[825]},
  {871,0,3,1,&joseki_variations[8193],NULL},
  {872,3,5,1,&joseki_variations[8194],NULL},
  {873,3,6,1,&joseki_variations[8195],NULL},
  {909,0,6,1,&joseki_variations[8196],NULL},
  {761,0,2,0,NULL,&joseki[775]},
  {872,3,4,1,&joseki_variations[8198],NULL},
  {873,3,5,1,&joseki_variations[8199],NULL},
  {909,0,5,1,&joseki_variations[8200],NULL},
  {834,3,2,0,NULL,&joseki[774]},
  {871,0,2,1,&joseki_variations[8204],NULL},
  {872,0,3,1,&joseki_variations[8203],NULL},
  {761,3,2,0,NULL,&joseki[782]},
  {761,3,2,0,NULL,&joseki[761]},
  {761,3,2,0,NULL,&joseki[751]},
  {837,3,5,1,&joseki_variations[8208],NULL},
  {762,3,2,0,NULL,&joseki[671]},
  {801,0,5,2,&joseki_variations[8209],NULL},
  {797,3,2,0,NULL,&joseki[590]},
  {762,3,2,0,NULL,&joseki[597]},
  {761,3,2,0,NULL,&joseki[340]},
  {797,3,2,0,NULL,&joseki[341]},
  {765,3,4,1,&joseki_variations[8214],NULL},
  {871,0,2,1,&joseki_variations[8215],NULL},
  {798,3,2,1,&joseki_variations[8216],NULL},
  {800,3,4,1,&joseki_variations[8217],NULL},
  {801,0,6,1,&joseki_variations[8218],NULL},
  {762,3,2,0,NULL,&joseki[217]},
  {798,3,2,4,&joseki_variations[8225],NULL},
  {797,3,2,1,&joseki_variations[8221],NULL},
  {871,0,3,1,&joseki_variations[8222],NULL},
  {798,3,3,1,&joseki_variations[8223],NULL},
  {800,3,5,1,&joseki_variations[8224],NULL},
  {761,0,2,0,NULL,&joseki[245]},
  {761,3,2,0,NULL,&joseki[121]},
  {800,3,4,1,&joseki_variations[8232],&joseki[142]},
  {837,0,4,1,&joseki_variations[8230],NULL},
  {1020,3,3,1,&joseki_variations[8229],NULL},
  {797,3,2,0,NULL,&joseki[805]},
  {872,3,3,1,&joseki_variations[8231],NULL},
  {761,3,2,0,NULL,&joseki[203]},
  {871,0,2,3,&joseki_variations[8233],NULL},
  {761,3,2,0,NULL,&joseki[237]},
  {797,3,2,0,NULL,&joseki[244]},
  {762,3,2,0,NULL,&joseki[251]},
  {726,0,1,1,&joseki_variations[8243],NULL},
  {798,3,3,1,&joseki_variations[8238],NULL},
  {799,3,4,1,&joseki_variations[8239],&joseki[1533]},
  {833,0,1,1,&joseki_variations[8240],&joseki[1534]},
  {909,3,5,1,&joseki_variations[8241],&joseki[1535]},
  {726,0,1,1,&joseki_variations[8242],NULL},
  {801,3,6,0,NULL,&joseki[1536]},
  {796,3,1,1,&joseki_variations[8244],NULL},
  {797,3,3,2,&joseki_variations[8245],NULL},
  {836,3,5,1,&joseki_variations[8253],NULL},
  {871,0,4,1,&joseki_variations[8247],NULL},
  {763,0,4,1,&joseki_variations[8248],NULL},
  {765,3,5,1,&joseki_variations[8249],NULL},
  {798,3,5,1,&joseki_variations[8250],NULL},
  {799,3,6,1,&joseki_variations[8251],NULL},
  {800,3,9,1,&joseki_variations[8252],NULL},
  {759,0,1,0,NULL,&joseki[249]},
  {800,3,6,1,&joseki_variations[8254],NULL},
  {764,0,4,1,&joseki_variations[8255],&joseki[105]},
  {982,3,4,0,NULL,&joseki[106]},
  {761,3,2,2,&joseki_variations[8257],NULL},
  {798,0,3,2,&joseki_variations[8266],NULL},
  {800,3,3,3,&joseki_variations[8259],NULL},
  {723,3,1,0,NULL,&joseki[1430]},
  {767,3,3,1,&joseki_variations[8264],NULL},
  {982,0,3,1,&joseki_variations[8262],NULL},
  {1056,3,4,1,&joseki_variations[8263],NULL},
  {723,3,1,0,NULL,&joseki[1465]},
  {945,0,3,1,&joseki_variations[8265],NULL},
  {723,3,1,0,NULL,&joseki[1456]},
  {799,3,4,1,&joseki_variations[8271],NULL},
  {762,3,3,1,&joseki_variations[8268],NULL},
  {799,3,5,1,&joseki_variations[8269],NULL},
  {836,3,7,1,&joseki_variations[8270],NULL},
  {723,0,1,0,NULL,&joseki[69]},
  {836,3,6,1,&joseki_variations[8272],NULL},
  {762,3,3,0,NULL,&joseki[68]},
  {797,3,3,4,&joseki_variations[8304],NULL},
  {834,0,3,2,&joseki_variations[8284],NULL},
  {761,0,2,1,&joseki_variations[8276],NULL},
  {798,0,4,1,&joseki_variations[8277],NULL},
  {800,3,5,1,&joseki_variations[8278],NULL},
  {833,3,2,1,&joseki_variations[8279],NULL},
  {834,0,4,1,&joseki_variations[8280],NULL},
  {835,3,7,1,&joseki_variations[8281],NULL},
  {836,3,8,1,&joseki_variations[8282],NULL},
  {871,3,5,1,&joseki_variations[8283],NULL},
  {726,0,1,0,NULL,&joseki[97]},
  {871,3,4,1,&joseki_variations[8298],NULL},
  {870,3,2,1,&joseki_variations[8286],NULL},
  {871,3,5,1,&joseki_variations[8287],NULL},
  {724,3,1,1,&joseki_variations[8288],NULL},
  {761,3,3,1,&joseki_variations[8289],NULL},
  {798,3,5,1,&joseki_variations[8290],NULL},
  {835,0,7,1,&joseki_variations[8291],NULL},
  {872,3,10,1,&joseki_variations[8292],NULL},
  {762,0,4,1,&joseki_variations[8293],NULL},
  {799,0,7,1,&joseki_variations[8294],NULL},
  {836,3,10,1,&joseki_variations[8295],NULL},
  {763,0,5,1,&joseki_variations[8296],NULL},
  {800,3,9,1,&joseki_variations[8297],NULL},
  {723,0,1,0,NULL,&joseki[697]},
  {761,0,2,1,&joseki_variations[8299],NULL},
  {798,0,4,1,&joseki_variations[8300],NULL},
  {800,3,5,1,&joseki_variations[8301],NULL},
  {835,3,6,1,&joseki_variations[8302],NULL},
  {836,3,7,1,&joseki_variations[8303],NULL},
  {833,3,2,0,NULL,&joseki[96]},
  {836,3,4,1,&joseki_variations[8341],NULL},
  {761,3,2,2,&joseki_variations[8333],NULL},
  {761,0,2,1,&joseki_variations[8325],NULL},
  {833,0,2,1,&joseki_variations[8308],NULL},
  {834,0,5,1,&joseki_variations[8309],NULL},
  {870,3,3,1,&joseki_variations[8310],NULL},
  {871,3,7,1,&joseki_variations[8311],NULL},
  {724,3,1,1,&joseki_variations[8312],NULL},
  {761,3,3,1,&joseki_variations[8313],NULL},
  {798,3,6,1,&joseki_variations[8314],NULL},
  {835,0,9,1,&joseki_variations[8315],NULL},
  {872,3,12,1,&joseki_variations[8316],NULL},
  {762,0,4,1,&joseki_variations[8317],NULL},
  {799,0,8,1,&joseki_variations[8318],NULL},
  {836,3,12,1,&joseki_variations[8319],NULL},
  {763,0,5,1,&joseki_variations[8320],NULL},
  {800,3,10,1,&joseki_variations[8321],NULL},
  {837,3,15,1,&joseki_variations[8322],NULL},
  {764,0,6,1,&joseki_variations[8323],NULL},
  {801,0,12,1,&joseki_variations[8324],NULL},
  {759,3,1,0,NULL,&joseki[451]},
  {798,0,5,1,&joseki_variations[8326],NULL},
  {800,3,6,1,&joseki_variations[8327],NULL},
  {833,0,2,1,&joseki_variations[8328],NULL},
  {834,3,5,1,&joseki_variations[8329],NULL},
  {835,3,8,1,&joseki_variations[8330],NULL},
  {836,3,9,1,&joseki_variations[8331],NULL},
  {870,3,3,1,&joseki_variations[8332],&joseki[101]},
  {726,0,1,0,NULL,&joseki[102]},
  {836,3,5,1,&joseki_variations[8340],NULL},
  {834,0,4,2,&joseki_variations[8335],NULL},
  {836,3,6,1,&joseki_variations[8339],NULL},
  {798,3,5,1,&joseki_variations[8337],NULL},
  {836,3,7,1,&joseki_variations[8338],NULL},
  {722,0,1,0,NULL,&joseki[18]},
  {798,3,5,0,NULL,&joseki[17]},
  {834,0,4,0,NULL,&joseki[16]},
  {761,3,2,0,NULL,&joseki[15]},
  {836,3,3,1,&joseki_variations[8640],NULL},
  {761,0,2,4,&joseki_variations[8533],NULL},
  {763,0,2,1,&joseki_variations[8530],NULL},
  {798,3,3,4,&joseki_variations[8491],NULL},
  {871,3,3,2,&joseki_variations[8447],NULL},
  {724,3,1,3,&joseki_variations[8404],NULL},
  {761,3,2,4,&joseki_variations[8371],NULL},
  {724,0,1,1,&joseki_variations[8359],NULL},
  {798,0,3,1,&joseki_variations[8351],&joseki[1538]},
  {834,0,3,1,&joseki_variations[8352],NULL},
  {835,3,5,1,&joseki_variations[8353],NULL},
  {871,0,4,1,&joseki_variations[8354],NULL},
  {872,3,7,1,&joseki_variations[8355],NULL},
  {762,0,2,1,&joseki_variations[8356],NULL},
  {763,3,3,1,&joseki_variations[8357],NULL},
  {800,3,6,1,&joseki_variations[8358],NULL},
  {796,3,1,0,NULL,&joseki[846]},
  {761,3,3,1,&joseki_variations[8360],NULL},
  {798,3,5,1,&joseki_variations[8361],NULL},
  {725,0,2,1,&joseki_variations[8362],NULL},
  {762,3,5,1,&joseki_variations[8363],NULL},
  {763,0,6,2,&joseki_variations[8364],NULL},
  {800,0,9,1,&joseki_variations[8370],NULL},
  {800,3,9,1,&joseki_variations[8366],NULL},
  {837,3,10,1,&joseki_variations[8367],NULL},
  {764,0,7,1,&joseki_variations[8368],NULL},
  {801,0,11,1,&joseki_variations[8369],NULL},
  {723,3,1,0,NULL,&joseki[603]},
  {723,3,1,0,NULL,&joseki[292]},
  {798,3,4,1,&joseki_variations[8399],NULL},
  {798,0,4,3,&joseki_variations[8383],NULL},
  {835,0,4,1,&joseki_variations[8381],NULL},
  {871,0,3,1,&joseki_variations[8375],NULL},
  {945,3,4,1,&joseki_variations[8376],NULL},
  {798,0,4,2,&joseki_variations[8377],&joseki[1497]},
  {759,3,1,0,NULL,&joseki[1498]},
  {835,3,5,1,&joseki_variations[8379],&joseki[1509]},
  {799,0,5,1,&joseki_variations[8380],&joseki[1510]},
  {759,3,1,0,NULL,&joseki[1511]},
  {763,3,3,1,&joseki_variations[8382],NULL},
  {798,0,4,0,NULL,&joseki[1306]},
  {834,3,3,1,&joseki_variations[8388],NULL},
  {835,0,5,1,&joseki_variations[8386],NULL},
  {762,0,3,0,NULL,&joseki[1539]},
  {763,3,3,1,&joseki_variations[8387],NULL},
  {759,3,1,0,NULL,&joseki[1307]},
  {835,0,6,3,&joseki_variations[8389],NULL},
  {872,3,7,1,&joseki_variations[8397],NULL},
  {871,3,4,1,&joseki_variations[8393],NULL},
  {800,0,5,1,&joseki_variations[8392],NULL},
  {723,3,1,0,NULL,&joseki[1580]},
  {872,0,8,1,&joseki_variations[8394],NULL},
  {909,3,9,1,&joseki_variations[8395],NULL},
  {762,0,3,1,&joseki_variations[8396],NULL},
  {724,3,1,0,NULL,&joseki[1168]},
  {762,0,3,1,&joseki_variations[8398],NULL},
  {724,3,1,0,NULL,&joseki[1151]},
  {725,0,1,1,&joseki_variations[8400],NULL},
  {762,3,4,1,&joseki_variations[8401],NULL},
  {763,0,5,1,&joseki_variations[8402],NULL},
  {800,0,8,1,&joseki_variations[8403],NULL},
  {724,0,1,0,NULL,&joseki[291]},
  {798,3,4,1,&joseki_variations[8442],NULL},
  {761,0,3,1,&joseki_variations[8436],NULL},
  {761,3,3,2,&joseki_variations[8407],NULL},
  {798,3,5,1,&joseki_variations[8421],NULL},
  {798,0,5,2,&joseki_variations[8409],NULL},
  {834,3,3,1,&joseki_variations[8412],NULL},
  {762,0,4,1,&joseki_variations[8411],NULL},
  {834,0,3,0,NULL,&joseki[1540]},
  {835,0,7,2,&joseki_variations[8413],NULL},
  {872,3,8,1,&joseki_variations[8419],NULL},
  {871,3,4,1,&joseki_variations[8415],NULL},
  {872,0,9,1,&joseki_variations[8416],NULL},
  {909,3,10,1,&joseki_variations[8417],NULL},
  {762,0,4,1,&joseki_variations[8418],NULL},
  {759,0,1,0,NULL,&joseki[1169]},
  {762,0,4,1,&joseki_variations[8420],NULL},
  {759,0,1,0,NULL,&joseki[1152]},
  {762,0,4,1,&joseki_variations[8422],NULL},
  {799,0,7,1,&joseki_variations[8423],NULL},
  {763,0,5,1,&joseki_variations[8424],NULL},
  {800,3,9,1,&joseki_variations[8425],NULL},
  {764,0,6,1,&joseki_variations[8426],NULL},
  {801,0,11,1,&joseki_variations[8427],NULL},
  {833,0,1,1,&joseki_variations[8428],NULL},
  {834,0,4,1,&joseki_variations[8429],NULL},
  {835,0,8,1,&joseki_variations[8430],NULL},
  {836,3,11,1,&joseki_variations[8431],NULL},
  {837,3,14,1,&joseki_variations[8432],NULL},
  {870,3,2,1,&joseki_variations[8433],NULL},
  {871,3,6,1,&joseki_variations[8434],NULL},
  {872,3,11,1,&joseki_variations[8435],NULL},
  {796,0,1,0,NULL,&joseki[450]},
  {798,3,5,1,&joseki_variations[8437],NULL},
  {725,0,2,1,&joseki_variations[8438],NULL},
  {762,3,5,1,&joseki_variations[8439],NULL},
  {763,0,6,1,&joseki_variations[8440],NULL},
  {800,0,9,1,&joseki_variations[8441],NULL},
  {723,3,1,0,NULL,&joseki[288]},
  {725,0,2,1,&joseki_variations[8443],NULL},
  {762,3,4,1,&joseki_variations[8444],NULL},
  {763,0,5,1,&joseki_variations[8445],NULL},
  {800,0,8,1,&joseki_variations[8446],NULL},
  {761,0,3,0,NULL,&joseki[287]},
  {763,3,2,1,&joseki_variations[8480],NULL},
  {761,3,2,2,&joseki_variations[8449],NULL},
  {763,3,3,1,&joseki_variations[8465],NULL},
  {798,0,4,1,&joseki_variations[8451],NULL},
  {835,0,5,1,&joseki_variations[8452],NULL},
  {872,0,7,1,&joseki_variations[8453],NULL},
  {762,3,3,1,&joseki_variations[8454],NULL},
  {799,3,6,1,&joseki_variations[8455],NULL},
  {836,3,8,1,&joseki_variations[8456],NULL},
  {873,0,11,1,&joseki_variations[8457],NULL},
  {763,3,4,1,&joseki_variations[8458],NULL},
  {800,0,8,1,&joseki_variations[8459],NULL},
  {837,0,11,1,&joseki_variations[8460],NULL},
  {764,0,5,1,&joseki_variations[8461],NULL},
  {801,3,10,1,&joseki_variations[8462],NULL},
  {765,0,6,2,&joseki_variations[8463],NULL},
  {874,3,15,0,NULL,&joseki[233]},
  {802,3,12,0,NULL,&joseki[234]},
  {764,0,4,1,&joseki_variations[8466],NULL},
  {765,0,5,1,&joseki_variations[8467],NULL},
  {798,0,4,1,&joseki_variations[8468],NULL},
  {835,0,5,1,&joseki_variations[8469],NULL},
  {799,3,5,1,&joseki_variations[8470],NULL},
  {800,0,7,2,&joseki_variations[8471],NULL},
  {837,0,9,1,&joseki_variations[8477],NULL},
  {801,3,9,1,&joseki_variations[8473],NULL},
  {836,3,7,1,&joseki_variations[8474],NULL},
  {873,0,9,1,&joseki_variations[8475],NULL},
  {837,0,10,1,&joseki_variations[8476],NULL},
  {762,3,3,0,NULL,&joseki[232]},
  {801,3,9,2,&joseki_variations[8478],NULL},
  {836,3,7,0,NULL,&joseki[231]},
  {802,3,11,0,NULL,&joseki[235]},
  {764,0,3,1,&joseki_variations[8481],NULL},
  {765,0,4,1,&joseki_variations[8482],NULL},
  {798,0,3,2,&joseki_variations[8483],NULL},
  {800,0,5,1,&joseki_variations[8489],NULL},
  {799,3,4,1,&joseki_variations[8485],NULL},
  {800,0,6,1,&joseki_variations[8486],NULL},
  {837,0,7,1,&joseki_variations[8487],NULL},
  {801,3,8,1,&joseki_variations[8488],NULL},
  {761,3,2,0,NULL,&joseki[230]},
  {801,3,7,1,&joseki_variations[8490],NULL},
  {799,3,4,0,NULL,&joseki[229]},
  {872,3,4,1,&joseki_variations[8509],NULL},
  {762,3,2,1,&joseki_variations[8506],NULL},
  {725,0,1,1,&joseki_variations[8497],NULL},
  {764,3,2,1,&joseki_variations[8495],NULL},
  {804,3,5,1,&joseki_variations[8496],NULL},
  {761,0,2,0,NULL,&joseki[879]},
  {762,3,3,1,&joseki_variations[8498],NULL},
  {763,0,4,2,&joseki_variations[8499],NULL},
  {800,0,7,1,&joseki_variations[8505],NULL},
  {800,3,7,1,&joseki_variations[8501],NULL},
  {837,3,8,1,&joseki_variations[8502],NULL},
  {764,0,5,1,&joseki_variations[8503],NULL},
  {801,0,9,1,&joseki_variations[8504],NULL},
  {761,3,2,0,NULL,&joseki[602]},
  {724,3,1,0,NULL,&joseki[286]},
  {763,0,3,1,&joseki_variations[8507],NULL},
  {800,0,6,1,&joseki_variations[8508],NULL},
  {725,0,1,0,NULL,&joseki[285]},
  {762,3,2,1,&joseki_variations[8510],NULL},
  {726,0,1,1,&joseki_variations[8511],NULL},
  {763,0,4,1,&joseki_variations[8512],NULL},
  {800,0,7,1,&joseki_variations[8513],NULL},
  {837,0,8,1,&joseki_variations[8514],NULL},
  {874,3,10,1,&joseki_variations[8515],NULL},
  {801,3,8,1,&joseki_variations[8516],NULL},
  {838,3,10,1,&joseki_variations[8517],NULL},
  {875,0,13,1,&joseki_variations[8518],NULL},
  {912,0,14,1,&joseki_variations[8519],NULL},
  {765,3,5,1,&joseki_variations[8520],NULL},
  {802,3,10,1,&joseki_variations[8521],NULL},
  {839,0,13,1,&joseki_variations[8522],NULL},
  {876,3,17,1,&joseki_variations[8523],NULL},
  {766,3,6,1,&joseki_variations[8524],NULL},
  {803,0,12,1,&joseki_variations[8525],NULL},
  {840,0,16,1,&joseki_variations[8526],NULL},
  {767,3,7,1,&joseki_variations[8527],NULL},
  {804,0,14,1,&joseki_variations[8528],NULL},
  {805,0,15,1,&joseki_variations[8529],NULL},
  {761,0,2,0,NULL,&joseki[184]},
  {765,3,3,1,&joseki_variations[8531],NULL},
  {798,3,3,1,&joseki_variations[8532],NULL},
  {761,0,2,0,NULL,&joseki[109]},
  {836,3,4,2,&joseki_variations[8634],NULL},
  {798,0,4,2,&joseki_variations[8613],NULL},
  {763,0,3,2,&joseki_variations[8596],NULL},
  {798,3,4,6,&joseki_variations[8537],NULL},
  {799,3,5,1,&joseki_variations[8589],NULL},
  {762,0,3,1,&joseki_variations[8585],NULL},
  {872,3,5,1,&joseki_variations[8564],NULL},
  {762,3,3,1,&joseki_variations[8559],NULL},
  {725,0,1,1,&joseki_variations[8545],NULL},
  {764,3,3,1,&joseki_variations[8543],NULL},
  {804,3,6,1,&joseki_variations[8544],NULL},
  {759,3,1,0,NULL,&joseki[880]},
  {762,3,4,1,&joseki_variations[8546],NULL},
  {763,0,5,2,&joseki_variations[8547],NULL},
  {800,3,8,1,&joseki_variations[8556],NULL},
  {799,3,7,1,&joseki_variations[8549],NULL},
  {800,3,9,1,&joseki_variations[8550],NULL},
  {837,3,10,2,&joseki_variations[8551],NULL},
  {801,0,10,1,&joseki_variations[8555],NULL},
  {727,0,2,1,&joseki_variations[8553],NULL},
  {801,0,11,1,&joseki_variations[8554],NULL},
  {838,3,13,0,NULL,&joseki[596]},
  {727,0,2,0,NULL,&joseki[595]},
  {837,3,9,1,&joseki_variations[8557],NULL},
  {801,0,9,1,&joseki_variations[8558],NULL},
  {799,3,7,0,NULL,&joseki[594]},
  {763,0,4,1,&joseki_variations[8560],NULL},
  {800,3,7,1,&joseki_variations[8561],NULL},
  {837,3,8,1,&joseki_variations[8562],NULL},
  {801,0,8,1,&joseki_variations[8563],NULL},
  {725,0,1,0,NULL,&joseki[593]},
  {762,3,3,1,&joseki_variations[8565],NULL},
  {726,0,1,1,&joseki_variations[8566],NULL},
  {763,0,5,1,&joseki_variations[8567],NULL},
  {800,0,8,1,&joseki_variations[8568],NULL},
  {837,0,9,1,&joseki_variations[8569],NULL},
  {874,3,11,1,&joseki_variations[8570],NULL},
  {801,3,9,1,&joseki_variations[8571],NULL},
  {838,3,11,1,&joseki_variations[8572],NULL},
  {875,0,14,1,&joseki_variations[8573],NULL},
  {912,0,15,1,&joseki_variations[8574],NULL},
  {765,3,6,1,&joseki_variations[8575],NULL},
  {802,3,11,1,&joseki_variations[8576],NULL},
  {839,0,14,1,&joseki_variations[8577],NULL},
  {876,3,18,1,&joseki_variations[8578],NULL},
  {766,3,7,1,&joseki_variations[8579],NULL},
  {803,0,13,1,&joseki_variations[8580],NULL},
  {840,0,17,1,&joseki_variations[8581],NULL},
  {767,3,8,1,&joseki_variations[8582],NULL},
  {804,0,15,1,&joseki_variations[8583],NULL},
  {805,0,16,1,&joseki_variations[8584],NULL},
  {759,3,1,0,NULL,&joseki[185]},
  {799,3,6,1,&joseki_variations[8586],NULL},
  {763,0,4,1,&joseki_variations[8587],NULL},
  {765,3,5,1,&joseki_variations[8588],NULL},
  {838,3,8,0,NULL,&joseki[120]},
  {726,0,1,1,&joseki_variations[8590],NULL},
  {763,0,4,1,&joseki_variations[8591],NULL},
  {765,3,5,2,&joseki_variations[8592],NULL},
  {838,3,8,0,NULL,&joseki[118]},
  {800,3,8,1,&joseki_variations[8594],NULL},
  {871,0,3,1,&joseki_variations[8595],NULL},
  {796,3,1,0,NULL,&joseki[248]},
  {765,3,4,1,&joseki_variations[8602],NULL},
  {798,3,4,1,&joseki_variations[8598],NULL},
  {800,3,6,1,&joseki_variations[8599],NULL},
  {837,3,7,1,&joseki_variations[8600],NULL},
  {801,0,7,1,&joseki_variations[8601],NULL},
  {762,3,3,0,NULL,&joseki[592]},
  {798,3,4,2,&joseki_variations[8603],NULL},
  {799,3,5,4,&joseki_variations[8607],&joseki[110]},
  {800,3,6,1,&joseki_variations[8605],NULL},
  {871,0,3,1,&joseki_variations[8606],NULL},
  {799,3,5,0,NULL,&joseki[246]},
  {759,0,1,0,NULL,&joseki[111]},
  {726,0,1,0,NULL,&joseki[117]},
  {762,0,3,0,NULL,&joseki[119]},
  {800,3,7,1,&joseki_variations[8611],NULL},
  {871,0,3,1,&joseki_variations[8612],NULL},
  {726,0,1,0,NULL,&joseki[247]},
  {836,3,5,1,&joseki_variations[8632],NULL},
  {800,3,5,3,&joseki_variations[8615],NULL},
  {835,3,5,1,&joseki_variations[8629],NULL},
  {834,0,3,1,&joseki_variations[8625],NULL},
  {833,0,1,2,&joseki_variations[8618],NULL},
  {835,3,6,1,&joseki_variations[8623],NULL},
  {834,3,4,1,&joseki_variations[8620],NULL},
  {835,3,7,1,&joseki_variations[8621],NULL},
  {836,3,8,1,&joseki_variations[8622],NULL},
  {796,0,1,0,NULL,&joseki[100]},
  {836,3,7,1,&joseki_variations[8624],NULL},
  {834,3,4,0,NULL,&joseki[99]},
  {835,3,6,1,&joseki_variations[8626],NULL},
  {836,3,7,1,&joseki_variations[8627],NULL},
  {871,3,4,1,&joseki_variations[8628],&joseki[94]},
  {796,0,1,0,NULL,&joseki[95]},
  {836,3,6,2,&joseki_variations[8630],NULL},
  {834,0,3,0,NULL,&joseki[93]},
  {833,0,1,0,NULL,&joseki[98]},
  {800,3,5,1,&joseki_variations[8633],NULL},
  {835,3,5,0,NULL,&joseki[92]},
  {800,3,4,2,&joseki_variations[8638],&joseki[90]},
  {726,0,1,1,&joseki_variations[8636],NULL},
  {800,3,5,1,&joseki_variations[8637],NULL},
  {796,3,1,0,NULL,&joseki[104]},
  {798,0,4,0,NULL,&joseki[91]},
  {726,0,1,0,NULL,&joseki[103]},
  {796,0,1,0,NULL,&joseki[14]},
  {836,3,3,2,&joseki_variations[8669],NULL},
  {762,0,2,3,&joseki_variations[8652],NULL},
  {871,0,3,1,&joseki_variations[8645],NULL},
  {799,3,2,0,NULL,&joseki[1550]},
  {761,0,2,1,&joseki_variations[8646],NULL},
  {763,0,3,1,&joseki_variations[8647],NULL},
  {798,3,3,1,&joseki_variations[8648],NULL},
  {872,3,6,1,&joseki_variations[8649],NULL},
  {873,3,7,1,&joseki_variations[8650],NULL},
  {909,0,7,1,&joseki_variations[8651],NULL},
  {908,3,4,0,NULL,&joseki[776]},
  {836,3,4,2,&joseki_variations[8665],NULL},
  {908,3,3,1,&joseki_variations[8661],NULL},
  {799,3,3,2,&joseki_variations[8655],NULL},
  {800,3,4,0,NULL,&joseki[1551]},
  {763,0,3,1,&joseki_variations[8657],NULL},
  {800,3,5,1,&joseki_variations[8658],NULL},
  {801,3,6,1,&joseki_variations[8659],&joseki[1552]},
  {1019,3,3,1,&joseki_variations[8660],&joseki[1553]},
  {1021,3,6,0,NULL,&joseki[1554]},
  {798,3,2,1,&joseki_variations[8662],NULL},
  {799,0,4,1,&joseki_variations[8663],NULL},
  {836,0,6,1,&joseki_variations[8664],NULL},
  {1019,3,4,0,NULL,&joseki[65]},
  {801,3,3,0,NULL,&joseki[2]},
  {764,0,3,1,&joseki_variations[8667],NULL},
  {801,3,4,1,&joseki_variations[8668],NULL},
  {802,3,5,0,NULL,&joseki[3]},
  {762,0,2,0,NULL,&joseki[1]},
  {763,0,2,1,&joseki_variations[8671],&joseki[4]},
  {759,3,1,0,NULL,&joseki[5]},
  {834,3,2,0,NULL,&joseki[0]}
};


struct corner_db joseki_db = {
  14,
  14,
  16,
  joseki_variations
};
