/* switcher.c generated by valac 0.15.1, the Vala compiler
 * generated from switcher.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus-xkb - IBus XKB
 *
 * Copyright(c) 2012 Takao Fujiwara <takao.fujiwara1@gmail.com>
 * Copyright(c) 2011 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ibus.h>
#include <gdk/gdk.h>
#include <atk/atk.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SWITCHER (switcher_get_type ())
#define SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SWITCHER, Switcher))
#define SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SWITCHER, SwitcherClass))
#define IS_SWITCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SWITCHER))
#define IS_SWITCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SWITCHER))
#define SWITCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SWITCHER, SwitcherClass))

typedef struct _Switcher Switcher;
typedef struct _SwitcherClass SwitcherClass;
typedef struct _SwitcherPrivate SwitcherPrivate;

#define SWITCHER_TYPE_KEYBINDING (switcher_keybinding_get_type ())
#define SWITCHER_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWITCHER_TYPE_KEYBINDING, SwitcherKeybinding))
#define SWITCHER_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWITCHER_TYPE_KEYBINDING, SwitcherKeybindingClass))
#define SWITCHER_IS_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWITCHER_TYPE_KEYBINDING))
#define SWITCHER_IS_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWITCHER_TYPE_KEYBINDING))
#define SWITCHER_KEYBINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWITCHER_TYPE_KEYBINDING, SwitcherKeybindingClass))

typedef struct _SwitcherKeybinding SwitcherKeybinding;
typedef struct _SwitcherKeybindingClass SwitcherKeybindingClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;
#define _switcher_keybinding_unref0(var) ((var == NULL) ? NULL : (var = (switcher_keybinding_unref (var), NULL)))
typedef struct _SwitcherKeybindingPrivate SwitcherKeybindingPrivate;
typedef struct _SwitcherParamSpecKeybinding SwitcherParamSpecKeybinding;

struct _Switcher {
	GtkWindow parent_instance;
	SwitcherPrivate * priv;
};

struct _SwitcherClass {
	GtkWindowClass parent_class;
};

struct _SwitcherPrivate {
	GtkBox* m_box;
	GtkLabel* m_label;
	GtkButton** m_buttons;
	gint m_buttons_length1;
	gint _m_buttons_size_;
	IBusEngineDesc** m_engines;
	gint m_engines_length1;
	gint _m_engines_size_;
	guint m_selected_engine;
	guint m_primary_modifier;
	GMainLoop* m_loop;
	GList* m_keybindings;
	gint m_result;
	gint m_default_font_size;
};

struct _Block5Data {
	int _ref_count_;
	Switcher * self;
	gint index;
	GtkButton* button;
};

struct _SwitcherKeybinding {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SwitcherKeybindingPrivate * priv;
};

struct _SwitcherKeybindingClass {
	GTypeClass parent_class;
	void (*finalize) (SwitcherKeybinding *self);
};

struct _SwitcherKeybindingPrivate {
	gchar* _accelerator;
	guint _keysym;
	GdkModifierType _modifiers;
};

struct _SwitcherParamSpecKeybinding {
	GParamSpec parent_instance;
};


static gpointer switcher_parent_class = NULL;
static gpointer switcher_keybinding_parent_class = NULL;

GType switcher_get_type (void) G_GNUC_CONST;
static gpointer switcher_keybinding_ref (gpointer instance);
static void switcher_keybinding_unref (gpointer instance);
static GParamSpec* switcher_param_spec_keybinding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) G_GNUC_UNUSED;
static void switcher_value_set_keybinding (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static void switcher_value_take_keybinding (GValue* value, gpointer v_object) G_GNUC_UNUSED;
static gpointer switcher_value_get_keybinding (const GValue* value) G_GNUC_UNUSED;
static GType switcher_keybinding_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define SWITCHER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SWITCHER, SwitcherPrivate))
enum  {
	SWITCHER_DUMMY_PROPERTY
};
#define SWITCHER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~((((((((GDK_MOD2_MASK | GDK_LOCK_MASK) | GDK_MOD4_MASK) | GDK_MOD5_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK))))
#define SWITCHER_m_desc_label_max_len 20
Switcher* switcher_new (void);
Switcher* switcher_construct (GType object_type);
gint switcher_run (Switcher* self, GdkEvent* event, IBusEngineDesc** engines, int engines_length1, gint index, GList* keybindings);
guint keybinding_manager_get_primary_modifier (guint binding_mask);
#define KEYBINDING_MANAGER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~((((((((GDK_MOD2_MASK | GDK_LOCK_MASK) | GDK_MOD4_MASK) | GDK_MOD5_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK))))
static void switcher_update_engines (Switcher* self, IBusEngineDesc** engines, int engines_length1);
static gboolean ___lambda15_ (Switcher* self);
static gboolean ____lambda15__gsource_func (gpointer self);
static GtkButton* switcher_ime_button_new (Switcher* self, IBusEngineDesc* engine);
static IBusEngineDesc** _vala_array_dup7 (IBusEngineDesc** self, int length);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static gboolean _____lambda13_ (Block5Data* _data5_, GdkEventCrossing* e);
static gboolean ______lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean _____lambda14_ (Block5Data* _data5_, GdkEventButton* e);
static gboolean ______lambda14__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _vala_array_add24 (GtkButton*** array, int* length, int* size, GtkButton* value);
static void switcher_next_engine (Switcher* self);
static void switcher_previous_engine (Switcher* self);
static void switcher_real_show (GtkWidget* base);
static gboolean switcher_real_key_press_event (GtkWidget* base, GdkEventKey* e);
static guint switcher_keybinding_get_keysym (SwitcherKeybinding* self);
static GdkModifierType switcher_keybinding_get_modifiers (SwitcherKeybinding* self);
static gboolean switcher_real_key_release_event (GtkWidget* base, GdkEventKey* e);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event, guint primary_modifier);
#define SWITCHER_KEYBINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SWITCHER_TYPE_KEYBINDING, SwitcherKeybindingPrivate))
enum  {
	SWITCHER_KEYBINDING_DUMMY_PROPERTY
};
static SwitcherKeybinding* switcher_keybinding_new (const gchar* accelerator, guint keysym, GdkModifierType modifiers);
static SwitcherKeybinding* switcher_keybinding_construct (GType object_type, const gchar* accelerator, guint keysym, GdkModifierType modifiers);
static void switcher_keybinding_set_accelerator (SwitcherKeybinding* self, const gchar* value);
static void switcher_keybinding_set_keysym (SwitcherKeybinding* self, guint value);
static void switcher_keybinding_set_modifiers (SwitcherKeybinding* self, GdkModifierType value);
static const gchar* switcher_keybinding_get_accelerator (SwitcherKeybinding* self);
static void switcher_keybinding_finalize (SwitcherKeybinding* obj);
static void switcher_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Switcher* switcher_construct (GType object_type) {
	Switcher * self = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* vbox;
	GtkAlignment* _tmp2_;
	GtkAlignment* _tmp3_;
	GtkAlignment* align;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	AtkObject* _tmp10_ = NULL;
	AtkObject* _tmp11_;
	AtkObject* obj;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	self = (Switcher*) g_object_new (object_type, "type", GTK_WINDOW_POPUP, "events", GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK, "window-position", GTK_WIN_POS_CENTER, "accept-focus", TRUE, "decorated", FALSE, "modal", TRUE, "focus-visible", TRUE, NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	_tmp1_ = g_object_ref_sink (_tmp0_);
	vbox = _tmp1_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) vbox);
	_tmp2_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	align = _tmp3_;
	gtk_box_pack_start (vbox, (GtkWidget*) align, TRUE, TRUE, (guint) 0);
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	_tmp5_ = g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->m_box);
	self->priv->m_box = _tmp5_;
	_tmp6_ = self->priv->m_box;
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkLabel*) gtk_label_new ("");
	_tmp8_ = g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->m_label);
	self->priv->m_label = _tmp8_;
	_tmp9_ = self->priv->m_label;
	_tmp10_ = gtk_widget_get_accessible ((GtkWidget*) _tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	obj = _tmp11_;
	atk_object_set_role (obj, ATK_ROLE_STATUSBAR);
	_tmp12_ = self->priv->m_label;
	gtk_misc_set_padding ((GtkMisc*) _tmp12_, 3, 3);
	_tmp13_ = self->priv->m_label;
	gtk_box_pack_end (vbox, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (obj);
	_g_object_unref0 (align);
	_g_object_unref0 (vbox);
	return self;
}


Switcher* switcher_new (void) {
	return switcher_construct (TYPE_SWITCHER);
}


static gboolean ___lambda15_ (Switcher* self) {
	gboolean result = FALSE;
	GdkWindow* _tmp0_ = NULL;
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_set_opacity (_tmp0_, 1.0);
	result = FALSE;
	return result;
}


static gboolean ____lambda15__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda15_ (self);
	return result;
}


gint switcher_run (Switcher* self, GdkEvent* event, IBusEngineDesc** engines, int engines_length1, gint index, GList* keybindings) {
	gint result = 0;
	GMainLoop* _tmp0_;
	gint _tmp1_;
	IBusEngineDesc** _tmp2_;
	gint _tmp2__length1;
	GdkEvent* _tmp3_;
	GdkEventKey _tmp4_;
	GdkModifierType _tmp5_;
	guint _tmp6_ = 0U;
	IBusEngineDesc** _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_;
	GtkLabel* _tmp9_;
	GtkButton** _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_;
	GtkButton* _tmp12_;
	gconstpointer _tmp13_ = NULL;
	GtkButton** _tmp14_;
	gint _tmp14__length1;
	gint _tmp15_;
	GtkButton* _tmp16_;
	GList* _tmp17_;
	GdkEvent* _tmp18_;
	GdkDevice* _tmp19_ = NULL;
	GdkDevice* _tmp20_;
	GdkDevice* device;
	GdkDevice* _tmp21_;
	GdkDevice* keyboard = NULL;
	GdkDevice* pointer = NULL;
	GdkDevice* _tmp32_;
	GdkInputSource _tmp33_ = 0;
	gboolean _tmp44_ = FALSE;
	GdkGrabStatus status = 0;
	GdkDevice* _tmp46_;
	GdkWindow* _tmp47_ = NULL;
	GdkGrabStatus _tmp48_ = 0;
	GdkGrabStatus _tmp49_;
	GdkDevice* _tmp51_;
	GdkWindow* _tmp52_ = NULL;
	GdkGrabStatus _tmp53_ = 0;
	GdkGrabStatus _tmp54_;
	GMainLoop* _tmp56_;
	GMainLoop* _tmp57_;
	GdkDevice* _tmp58_;
	GdkDevice* _tmp59_;
	gint _tmp61_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (event != NULL, 0);
	_tmp0_ = self->priv->m_loop;
	g_assert (_tmp0_ == NULL);
	_tmp1_ = index;
	_tmp2_ = engines;
	_tmp2__length1 = engines_length1;
	g_assert (_tmp1_ < _tmp2__length1);
	_tmp3_ = event;
	_tmp4_ = _tmp3_->key;
	_tmp5_ = _tmp4_.state;
	_tmp6_ = keybinding_manager_get_primary_modifier ((guint) (_tmp5_ & KEYBINDING_MANAGER_MODIFIER_FILTER));
	self->priv->m_primary_modifier = _tmp6_;
	_tmp7_ = engines;
	_tmp7__length1 = engines_length1;
	switcher_update_engines (self, _tmp7_, _tmp7__length1);
	self->priv->m_result = 0;
	_tmp8_ = index;
	self->priv->m_selected_engine = (guint) _tmp8_;
	_tmp9_ = self->priv->m_label;
	_tmp10_ = self->priv->m_buttons;
	_tmp10__length1 = self->priv->m_buttons_length1;
	_tmp11_ = index;
	_tmp12_ = _tmp10_[_tmp11_];
	_tmp13_ = g_object_get_data ((GObject*) _tmp12_, "longname");
	gtk_label_set_text (_tmp9_, (const gchar*) _tmp13_);
	_tmp14_ = self->priv->m_buttons;
	_tmp14__length1 = self->priv->m_buttons_length1;
	_tmp15_ = index;
	_tmp16_ = _tmp14_[_tmp15_];
	gtk_widget_grab_focus ((GtkWidget*) _tmp16_);
	_tmp17_ = keybindings;
	self->priv->m_keybindings = (GList*) _tmp17_;
	_tmp18_ = event;
	_tmp19_ = gdk_event_get_device (_tmp18_);
	_tmp20_ = _g_object_ref0 (_tmp19_);
	device = _tmp20_;
	_tmp21_ = device;
	if (_tmp21_ == NULL) {
		GdkDisplay* _tmp22_ = NULL;
		GdkDisplay* _tmp23_;
		GdkDisplay* display;
		GdkDisplay* _tmp24_;
		GdkDeviceManager* _tmp25_ = NULL;
		GdkDeviceManager* _tmp26_;
		GdkDeviceManager* device_manager;
		GdkDeviceManager* _tmp27_;
		GList* _tmp28_ = NULL;
		GList* _tmp29_;
		gconstpointer _tmp30_;
		GdkDevice* _tmp31_;
		_tmp22_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp23_ = _g_object_ref0 (_tmp22_);
		display = _tmp23_;
		_tmp24_ = display;
		_tmp25_ = gdk_display_get_device_manager (_tmp24_);
		_tmp26_ = _g_object_ref0 (_tmp25_);
		device_manager = _tmp26_;
		_tmp27_ = device_manager;
		_tmp28_ = gdk_device_manager_list_devices (_tmp27_, GDK_DEVICE_TYPE_MASTER);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_->data;
		_tmp31_ = _g_object_ref0 ((GdkDevice*) _tmp30_);
		_g_object_unref0 (device);
		device = _tmp31_;
		_g_list_free0 (_tmp29_);
		_g_object_unref0 (device_manager);
		_g_object_unref0 (display);
	}
	_tmp32_ = device;
	_tmp33_ = gdk_device_get_source (_tmp32_);
	if (_tmp33_ == GDK_SOURCE_KEYBOARD) {
		GdkDevice* _tmp34_;
		GdkDevice* _tmp35_;
		GdkDevice* _tmp36_;
		GdkDevice* _tmp37_ = NULL;
		GdkDevice* _tmp38_;
		_tmp34_ = device;
		_tmp35_ = _g_object_ref0 (_tmp34_);
		_g_object_unref0 (keyboard);
		keyboard = _tmp35_;
		_tmp36_ = device;
		_tmp37_ = gdk_device_get_associated_device (_tmp36_);
		_tmp38_ = _g_object_ref0 (_tmp37_);
		_g_object_unref0 (pointer);
		pointer = _tmp38_;
	} else {
		GdkDevice* _tmp39_;
		GdkDevice* _tmp40_;
		GdkDevice* _tmp41_;
		GdkDevice* _tmp42_ = NULL;
		GdkDevice* _tmp43_;
		_tmp39_ = device;
		_tmp40_ = _g_object_ref0 (_tmp39_);
		_g_object_unref0 (pointer);
		pointer = _tmp40_;
		_tmp41_ = device;
		_tmp42_ = gdk_device_get_associated_device (_tmp41_);
		_tmp43_ = _g_object_ref0 (_tmp42_);
		_g_object_unref0 (keyboard);
		keyboard = _tmp43_;
	}
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp44_ = gtk_widget_is_composited ((GtkWidget*) self);
	if (_tmp44_) {
		GdkWindow* _tmp45_ = NULL;
		_tmp45_ = gtk_widget_get_window ((GtkWidget*) self);
		gdk_window_set_opacity (_tmp45_, 0.0);
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda15__gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp46_ = keyboard;
	_tmp47_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp48_ = gdk_device_grab (_tmp46_, _tmp47_, GDK_OWNERSHIP_NONE, TRUE, GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK, NULL, (guint32) GDK_CURRENT_TIME);
	status = _tmp48_;
	_tmp49_ = status;
	if (_tmp49_ != GDK_GRAB_SUCCESS) {
		GdkGrabStatus _tmp50_;
		_tmp50_ = status;
		g_warning ("switcher.vala:165: Grab keyboard failed! status = %d", (gint) _tmp50_);
	}
	_tmp51_ = pointer;
	_tmp52_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp53_ = gdk_device_grab (_tmp51_, _tmp52_, GDK_OWNERSHIP_NONE, TRUE, GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK, NULL, (guint32) GDK_CURRENT_TIME);
	status = _tmp53_;
	_tmp54_ = status;
	if (_tmp54_ != GDK_GRAB_SUCCESS) {
		GdkGrabStatus _tmp55_;
		_tmp55_ = status;
		g_warning ("switcher.vala:175: Grab pointer failed! status = %d", (gint) _tmp55_);
	}
	_tmp56_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->m_loop);
	self->priv->m_loop = _tmp56_;
	_tmp57_ = self->priv->m_loop;
	g_main_loop_run (_tmp57_);
	_g_main_loop_unref0 (self->priv->m_loop);
	self->priv->m_loop = NULL;
	_tmp58_ = keyboard;
	gdk_device_ungrab (_tmp58_, (guint32) GDK_CURRENT_TIME);
	_tmp59_ = pointer;
	gdk_device_ungrab (_tmp59_, (guint32) GDK_CURRENT_TIME);
	gtk_widget_hide ((GtkWidget*) self);
	while (TRUE) {
		gboolean _tmp60_ = FALSE;
		_tmp60_ = gtk_events_pending ();
		if (!_tmp60_) {
			break;
		}
		gtk_main_iteration ();
	}
	_tmp61_ = self->priv->m_result;
	result = _tmp61_;
	_g_object_unref0 (pointer);
	_g_object_unref0 (keyboard);
	_g_object_unref0 (device);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static GtkButton* switcher_ime_button_new (Switcher* self, IBusEngineDesc* engine) {
	GtkButton* result = NULL;
	IBusEngineDesc* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* language;
	IBusEngineDesc* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* symbol;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* id;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	GtkButton* _tmp18_;
	GtkButton* _tmp19_;
	GtkButton* button;
	GtkAlignment* _tmp20_;
	GtkAlignment* _tmp21_;
	GtkAlignment* align;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkBox* box;
	const gchar* _tmp24_;
	GtkLabel* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* label;
	gint _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* id_font;
	const gchar* _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* markup;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (engine != NULL, NULL);
	_tmp0_ = engine;
	_tmp1_ = ibus_engine_desc_get_language (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	language = _tmp2_;
	_tmp3_ = engine;
	_tmp4_ = ibus_engine_desc_get_symbol (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	symbol = _tmp5_;
	_tmp6_ = language;
	_tmp7_ = g_strdup (_tmp6_);
	id = _tmp7_;
	_tmp8_ = id;
	_tmp9_ = strlen (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 2) {
		const gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		_tmp11_ = id;
		_tmp12_ = string_slice (_tmp11_, (glong) 0, (glong) 2);
		_g_free0 (id);
		id = _tmp12_;
	}
	_tmp13_ = symbol;
	_tmp14_ = strlen (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != 0) {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = symbol;
		_tmp17_ = g_strdup (_tmp16_);
		_g_free0 (id);
		id = _tmp17_;
	}
	_tmp18_ = (GtkButton*) gtk_button_new ();
	_tmp19_ = g_object_ref_sink (_tmp18_);
	button = _tmp19_;
	_tmp20_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 0.0f, 0.0f);
	_tmp21_ = g_object_ref_sink (_tmp20_);
	align = _tmp21_;
	gtk_container_add ((GtkContainer*) button, (GtkWidget*) align);
	_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	_tmp23_ = g_object_ref_sink (_tmp22_);
	box = _tmp23_;
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) box);
	_tmp24_ = id;
	_tmp25_ = (GtkLabel*) gtk_label_new (_tmp24_);
	_tmp26_ = g_object_ref_sink (_tmp25_);
	label = _tmp26_;
	_tmp27_ = self->priv->m_default_font_size;
	_tmp28_ = g_strdup_printf ("%d", _tmp27_);
	id_font = _tmp28_;
	_tmp29_ = id;
	_tmp30_ = g_strdup_printf ("<span font=\"%s\">%s</span>", id_font, _tmp29_);
	markup = _tmp30_;
	gtk_label_set_markup (label, markup);
	gtk_box_pack_start (box, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	result = button;
	_g_free0 (markup);
	_g_free0 (id_font);
	_g_object_unref0 (label);
	_g_object_unref0 (box);
	_g_object_unref0 (align);
	_g_free0 (id);
	_g_free0 (symbol);
	_g_free0 (language);
	return result;
}


static IBusEngineDesc** _vala_array_dup7 (IBusEngineDesc** self, int length) {
	IBusEngineDesc** result;
	int i;
	result = g_new0 (IBusEngineDesc*, length + 1);
	for (i = 0; i < length; i++) {
		IBusEngineDesc* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		Switcher * self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->button);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean _____lambda13_ (Block5Data* _data5_, GdkEventCrossing* e) {
	Switcher * self;
	gboolean result = FALSE;
	GtkButton* _tmp0_;
	gint _tmp1_;
	self = _data5_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data5_->button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	_tmp1_ = _data5_->index;
	self->priv->m_selected_engine = (guint) _tmp1_;
	result = TRUE;
	return result;
}


static gboolean ______lambda13__gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = _____lambda13_ (self, event);
	return result;
}


static gboolean _____lambda14_ (Block5Data* _data5_, GdkEventButton* e) {
	Switcher * self;
	gboolean result = FALSE;
	gint _tmp0_;
	guint _tmp1_;
	GMainLoop* _tmp2_;
	self = _data5_->self;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data5_->index;
	self->priv->m_selected_engine = (guint) _tmp0_;
	_tmp1_ = self->priv->m_selected_engine;
	self->priv->m_result = (gint) _tmp1_;
	_tmp2_ = self->priv->m_loop;
	g_main_loop_quit (_tmp2_);
	result = TRUE;
	return result;
}


static gboolean ______lambda14__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _____lambda14_ (self, event);
	return result;
}


static void _vala_array_add24 (GtkButton*** array, int* length, int* size, GtkButton* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void switcher_update_engines (Switcher* self, IBusEngineDesc** engines, int engines_length1) {
	GtkButton** _tmp0_;
	gint _tmp0__length1;
	GtkButton** _tmp3_ = NULL;
	IBusEngineDesc** _tmp4_;
	gint _tmp4__length1;
	IBusEngineDesc** _tmp6_;
	gint _tmp6__length1;
	IBusEngineDesc** _tmp7_;
	gint _tmp7__length1;
	gint max_label_width;
	GtkLabel* _tmp47_;
	GtkButton** _tmp48_;
	gint _tmp48__length1;
	GtkButton* _tmp49_;
	gconstpointer _tmp50_ = NULL;
	GtkLabel* _tmp51_;
	GdkDisplay* _tmp52_ = NULL;
	GdkDisplay* _tmp53_;
	GdkDisplay* display;
	GdkScreen* _tmp54_ = NULL;
	GdkDisplay* _tmp55_;
	GdkScreen* _tmp58_;
	GdkScreen* _tmp59_;
	GdkScreen* screen;
	gint screen_width;
	GdkScreen* _tmp60_;
	gboolean _tmp63_ = FALSE;
	gint _tmp64_;
	gboolean _tmp67_;
	gint _tmp69_;
	gint _tmp70_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_buttons;
	_tmp0__length1 = self->priv->m_buttons_length1;
	{
		GtkButton** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp0_;
		button_collection_length1 = _tmp0__length1;
		for (button_it = 0; button_it < _tmp0__length1; button_it = button_it + 1) {
			GtkButton* _tmp1_;
			GtkButton* button = NULL;
			_tmp1_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp1_;
			{
				GtkButton* _tmp2_;
				_tmp2_ = button;
				gtk_widget_destroy ((GtkWidget*) _tmp2_);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp3_ = g_new0 (GtkButton*, 0 + 1);
	self->priv->m_buttons = (_vala_array_free (self->priv->m_buttons, self->priv->m_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_buttons = _tmp3_;
	self->priv->m_buttons_length1 = 0;
	self->priv->_m_buttons_size_ = self->priv->m_buttons_length1;
	_tmp4_ = engines;
	_tmp4__length1 = engines_length1;
	if (_tmp4_ == NULL) {
		IBusEngineDesc** _tmp5_ = NULL;
		_tmp5_ = g_new0 (IBusEngineDesc*, 0 + 1);
		self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_engines = _tmp5_;
		self->priv->m_engines_length1 = 0;
		self->priv->_m_engines_size_ = self->priv->m_engines_length1;
		return;
	}
	_tmp6_ = engines;
	_tmp6__length1 = engines_length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup7 (_tmp6_, _tmp6__length1) : ((gpointer) _tmp6_);
	_tmp7__length1 = _tmp6__length1;
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_engines = _tmp7_;
	self->priv->m_engines_length1 = _tmp7__length1;
	self->priv->_m_engines_size_ = self->priv->m_engines_length1;
	max_label_width = 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				Block5Data* _data5_;
				gboolean _tmp9_;
				gint _tmp11_;
				IBusEngineDesc** _tmp12_;
				gint _tmp12__length1;
				gint _tmp13_;
				IBusEngineDesc** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				IBusEngineDesc* _tmp16_;
				IBusEngineDesc* _tmp17_;
				IBusEngineDesc* engine;
				IBusEngineDesc* _tmp18_;
				GtkButton* _tmp19_ = NULL;
				IBusEngineDesc* _tmp20_;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				gchar* longname;
				GtkButton* _tmp23_;
				GtkButton* _tmp24_;
				GtkButton* _tmp25_;
				GtkButton* _tmp26_;
				const gchar* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				GtkButton* _tmp32_;
				const gchar* _tmp33_;
				gchar* _tmp34_;
				GtkLabel* _tmp35_;
				const gchar* _tmp36_;
				gint width = 0;
				GtkLabel* _tmp37_;
				gint _tmp38_ = 0;
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_ = 0;
				GtkBox* _tmp42_;
				GtkButton* _tmp43_;
				GtkButton** _tmp44_;
				gint _tmp44__length1;
				GtkButton* _tmp45_;
				GtkButton* _tmp46_;
				_data5_ = g_slice_new0 (Block5Data);
				_data5_->_ref_count_ = 1;
				_data5_->self = g_object_ref (self);
				_tmp9_ = _tmp8_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp11_ = i;
				_tmp12_ = self->priv->m_engines;
				_tmp12__length1 = self->priv->m_engines_length1;
				if (!(_tmp11_ < _tmp12__length1)) {
					block5_data_unref (_data5_);
					_data5_ = NULL;
					break;
				}
				_tmp13_ = i;
				_data5_->index = _tmp13_;
				_tmp14_ = self->priv->m_engines;
				_tmp14__length1 = self->priv->m_engines_length1;
				_tmp15_ = i;
				_tmp16_ = _tmp14_[_tmp15_];
				_tmp17_ = _g_object_ref0 (_tmp16_);
				engine = _tmp17_;
				_tmp18_ = engine;
				_tmp19_ = switcher_ime_button_new (self, _tmp18_);
				_data5_->button = _tmp19_;
				_tmp20_ = engine;
				_tmp21_ = ibus_engine_desc_get_longname (_tmp20_);
				_tmp22_ = g_strdup (_tmp21_);
				longname = _tmp22_;
				_tmp23_ = _data5_->button;
				gtk_button_set_relief (_tmp23_, GTK_RELIEF_NONE);
				_tmp24_ = _data5_->button;
				gtk_widget_show ((GtkWidget*) _tmp24_);
				_tmp25_ = _data5_->button;
				g_signal_connect_data ((GtkWidget*) _tmp25_, "enter-notify-event", (GCallback) ______lambda13__gtk_widget_enter_notify_event, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
				_tmp26_ = _data5_->button;
				g_signal_connect_data ((GtkWidget*) _tmp26_, "button-press-event", (GCallback) ______lambda14__gtk_widget_button_press_event, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
				_tmp27_ = longname;
				_tmp28_ = strlen (_tmp27_);
				_tmp29_ = _tmp28_;
				if (_tmp29_ > SWITCHER_m_desc_label_max_len) {
					const gchar* _tmp30_;
					gchar* _tmp31_ = NULL;
					_tmp30_ = longname;
					_tmp31_ = string_slice (_tmp30_, (glong) 0, (glong) SWITCHER_m_desc_label_max_len);
					_g_free0 (longname);
					longname = _tmp31_;
				}
				_tmp32_ = _data5_->button;
				_tmp33_ = longname;
				_tmp34_ = g_strdup (_tmp33_);
				g_object_set_data_full ((GObject*) _tmp32_, "longname", _tmp34_, g_free);
				_tmp35_ = self->priv->m_label;
				_tmp36_ = longname;
				gtk_label_set_label (_tmp35_, _tmp36_);
				_tmp37_ = self->priv->m_label;
				gtk_widget_get_preferred_width ((GtkWidget*) _tmp37_, NULL, &_tmp38_);
				width = _tmp38_;
				_tmp39_ = max_label_width;
				_tmp40_ = width;
				_tmp41_ = MAX (_tmp39_, _tmp40_);
				max_label_width = _tmp41_;
				_tmp42_ = self->priv->m_box;
				_tmp43_ = _data5_->button;
				gtk_box_pack_start (_tmp42_, (GtkWidget*) _tmp43_, TRUE, TRUE, (guint) 0);
				_tmp44_ = self->priv->m_buttons;
				_tmp44__length1 = self->priv->m_buttons_length1;
				_tmp45_ = _data5_->button;
				_tmp46_ = _g_object_ref0 (_tmp45_);
				_vala_array_add24 (&self->priv->m_buttons, &self->priv->m_buttons_length1, &self->priv->_m_buttons_size_, _tmp46_);
				_g_free0 (longname);
				_g_object_unref0 (engine);
				block5_data_unref (_data5_);
				_data5_ = NULL;
			}
		}
	}
	_tmp47_ = self->priv->m_label;
	_tmp48_ = self->priv->m_buttons;
	_tmp48__length1 = self->priv->m_buttons_length1;
	_tmp49_ = _tmp48_[0];
	_tmp50_ = g_object_get_data ((GObject*) _tmp49_, "longname");
	gtk_label_set_text (_tmp47_, (const gchar*) _tmp50_);
	_tmp51_ = self->priv->m_label;
	gtk_label_set_ellipsize (_tmp51_, PANGO_ELLIPSIZE_END);
	_tmp52_ = gdk_display_get_default ();
	_tmp53_ = _g_object_ref0 (_tmp52_);
	display = _tmp53_;
	_tmp55_ = display;
	if (_tmp55_ != NULL) {
		GdkDisplay* _tmp56_;
		GdkScreen* _tmp57_ = NULL;
		_tmp56_ = display;
		_tmp57_ = gdk_display_get_default_screen (_tmp56_);
		_tmp54_ = _tmp57_;
	} else {
		_tmp54_ = NULL;
	}
	_tmp58_ = _tmp54_;
	_tmp59_ = _g_object_ref0 (_tmp58_);
	screen = _tmp59_;
	screen_width = 0;
	_tmp60_ = screen;
	if (_tmp60_ != NULL) {
		GdkScreen* _tmp61_;
		gint _tmp62_ = 0;
		_tmp61_ = screen;
		_tmp62_ = gdk_screen_get_width (_tmp61_);
		screen_width = _tmp62_;
	}
	_tmp64_ = screen_width;
	if (_tmp64_ > 0) {
		gint _tmp65_;
		gint _tmp66_;
		_tmp65_ = max_label_width;
		_tmp66_ = screen_width;
		_tmp63_ = _tmp65_ > (_tmp66_ / 4);
	} else {
		_tmp63_ = FALSE;
	}
	_tmp67_ = _tmp63_;
	if (_tmp67_) {
		gint _tmp68_;
		_tmp68_ = screen_width;
		max_label_width = _tmp68_ / 4;
	}
	_tmp69_ = max_label_width;
	max_label_width = _tmp69_ + 20;
	_tmp70_ = max_label_width;
	gtk_window_set_default_size ((GtkWindow*) self, _tmp70_, -1);
	_g_object_unref0 (screen);
	_g_object_unref0 (display);
}


static void switcher_next_engine (Switcher* self) {
	guint _tmp0_;
	IBusEngineDesc** _tmp1_;
	gint _tmp1__length1;
	GtkLabel* _tmp3_;
	GtkButton** _tmp4_;
	gint _tmp4__length1;
	guint _tmp5_;
	GtkButton* _tmp6_;
	gconstpointer _tmp7_ = NULL;
	GtkButton** _tmp8_;
	gint _tmp8__length1;
	guint _tmp9_;
	GtkButton* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_selected_engine;
	_tmp1_ = self->priv->m_engines;
	_tmp1__length1 = self->priv->m_engines_length1;
	if (_tmp0_ == ((guint) (_tmp1__length1 - 1))) {
		self->priv->m_selected_engine = (guint) 0;
	} else {
		guint _tmp2_;
		_tmp2_ = self->priv->m_selected_engine;
		self->priv->m_selected_engine = _tmp2_ + 1;
	}
	_tmp3_ = self->priv->m_label;
	_tmp4_ = self->priv->m_buttons;
	_tmp4__length1 = self->priv->m_buttons_length1;
	_tmp5_ = self->priv->m_selected_engine;
	_tmp6_ = _tmp4_[_tmp5_];
	_tmp7_ = g_object_get_data ((GObject*) _tmp6_, "longname");
	gtk_label_set_text (_tmp3_, (const gchar*) _tmp7_);
	_tmp8_ = self->priv->m_buttons;
	_tmp8__length1 = self->priv->m_buttons_length1;
	_tmp9_ = self->priv->m_selected_engine;
	_tmp10_ = _tmp8_[_tmp9_];
	gtk_window_set_focus ((GtkWindow*) self, (GtkWidget*) _tmp10_);
}


static void switcher_previous_engine (Switcher* self) {
	guint _tmp0_;
	GtkLabel* _tmp3_;
	GtkButton** _tmp4_;
	gint _tmp4__length1;
	guint _tmp5_;
	GtkButton* _tmp6_;
	gconstpointer _tmp7_ = NULL;
	GtkButton** _tmp8_;
	gint _tmp8__length1;
	guint _tmp9_;
	GtkButton* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_selected_engine;
	if (_tmp0_ == ((guint) 0)) {
		IBusEngineDesc** _tmp1_;
		gint _tmp1__length1;
		_tmp1_ = self->priv->m_engines;
		_tmp1__length1 = self->priv->m_engines_length1;
		self->priv->m_selected_engine = (guint) (_tmp1__length1 - 1);
	} else {
		guint _tmp2_;
		_tmp2_ = self->priv->m_selected_engine;
		self->priv->m_selected_engine = _tmp2_ - 1;
	}
	_tmp3_ = self->priv->m_label;
	_tmp4_ = self->priv->m_buttons;
	_tmp4__length1 = self->priv->m_buttons_length1;
	_tmp5_ = self->priv->m_selected_engine;
	_tmp6_ = _tmp4_[_tmp5_];
	_tmp7_ = g_object_get_data ((GObject*) _tmp6_, "longname");
	gtk_label_set_text (_tmp3_, (const gchar*) _tmp7_);
	_tmp8_ = self->priv->m_buttons;
	_tmp8__length1 = self->priv->m_buttons_length1;
	_tmp9_ = self->priv->m_selected_engine;
	_tmp10_ = _tmp8_[_tmp9_];
	gtk_window_set_focus ((GtkWindow*) self, (GtkWidget*) _tmp10_);
}


static void switcher_real_show (GtkWidget* base) {
	Switcher * self;
	self = (Switcher*) base;
	GTK_WIDGET_CLASS (switcher_parent_class)->show ((GtkWidget*) GTK_WINDOW (self));
	gtk_window_set_focus_visible ((GtkWindow*) self, TRUE);
}


static gpointer _switcher_keybinding_ref0 (gpointer self) {
	return self ? switcher_keybinding_ref (self) : NULL;
}


static gboolean switcher_real_key_press_event (GtkWidget* base, GdkEventKey* e) {
	Switcher * self;
	gboolean result = FALSE;
	GdkEventKey* pe;
	GdkEventKey* _tmp0_;
	GdkModifierType _tmp1_;
	GdkModifierType state;
	GdkEventKey* _tmp23_;
	guint _tmp24_;
	self = (Switcher*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	pe = e;
	_tmp0_ = pe;
	_tmp1_ = (*_tmp0_).state;
	state = _tmp1_ & SWITCHER_MODIFIER_FILTER;
	{
		GList* _tmp2_;
		GList* keybindings;
		_tmp2_ = self->priv->m_keybindings;
		keybindings = _tmp2_;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				GList* _tmp7_;
				GList* _tmp8_;
				gconstpointer _tmp9_;
				SwitcherKeybinding* _tmp10_;
				SwitcherKeybinding* keybinding;
				gboolean _tmp11_ = FALSE;
				GdkEventKey* _tmp12_;
				guint _tmp13_;
				SwitcherKeybinding* _tmp14_;
				guint _tmp15_;
				guint _tmp16_;
				gboolean _tmp21_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					GList* _tmp5_;
					GList* _tmp6_;
					_tmp5_ = keybindings;
					_tmp6_ = _tmp5_->next;
					keybindings = _tmp6_;
				}
				_tmp3_ = FALSE;
				_tmp7_ = keybindings;
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = keybindings;
				_tmp9_ = _tmp8_->data;
				_tmp10_ = _switcher_keybinding_ref0 ((SwitcherKeybinding*) _tmp9_);
				keybinding = _tmp10_;
				_tmp12_ = pe;
				_tmp13_ = (*_tmp12_).keyval;
				_tmp14_ = keybinding;
				_tmp15_ = switcher_keybinding_get_keysym (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp13_ == _tmp16_) {
					GdkModifierType _tmp17_;
					SwitcherKeybinding* _tmp18_;
					GdkModifierType _tmp19_;
					GdkModifierType _tmp20_;
					_tmp17_ = state;
					_tmp18_ = keybinding;
					_tmp19_ = switcher_keybinding_get_modifiers (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp11_ = _tmp17_ == _tmp20_;
				} else {
					_tmp11_ = FALSE;
				}
				_tmp21_ = _tmp11_;
				if (_tmp21_) {
					GdkModifierType _tmp22_;
					_tmp22_ = state;
					if ((_tmp22_ & GDK_SHIFT_MASK) == 0) {
						switcher_next_engine (self);
					} else {
						switcher_previous_engine (self);
					}
					result = TRUE;
					_switcher_keybinding_unref0 (keybinding);
					return result;
				}
				_switcher_keybinding_unref0 (keybinding);
			}
		}
	}
	_tmp23_ = pe;
	_tmp24_ = (*_tmp23_).keyval;
	switch (_tmp24_) {
		case 0x08fb:
		case 0xff51:
		{
			switcher_previous_engine (self);
			break;
		}
		case 0x08fc:
		case 0xff52:
		{
			break;
		}
		case 0x08fd:
		case 0xff53:
		{
			switcher_next_engine (self);
			break;
		}
		case 0x08fe:
		case 0xff54:
		{
			break;
		}
		default:
		{
			GdkEventKey* _tmp25_;
			guint _tmp26_;
			GMainLoop* _tmp27_;
			_tmp25_ = pe;
			_tmp26_ = (*_tmp25_).keyval;
			g_debug ("switcher.vala:352: 0x%04x", _tmp26_);
			_tmp27_ = self->priv->m_loop;
			if (_tmp27_ != NULL) {
				GMainLoop* _tmp28_;
				_tmp28_ = self->priv->m_loop;
				g_main_loop_quit (_tmp28_);
				_g_main_loop_unref0 (self->priv->m_loop);
				self->priv->m_loop = NULL;
			}
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static gboolean switcher_real_key_release_event (GtkWidget* base, GdkEventKey* e) {
	Switcher * self;
	gboolean result = FALSE;
	GdkEventKey* pe;
	GdkEventKey* _tmp0_;
	guint _tmp1_;
	gboolean _tmp2_ = FALSE;
	GMainLoop* _tmp3_;
	GMainLoop* _tmp4_;
	guint _tmp5_;
	self = (Switcher*) base;
	g_return_val_if_fail (e != NULL, FALSE);
	pe = e;
	_tmp0_ = pe;
	_tmp1_ = self->priv->m_primary_modifier;
	_tmp2_ = keybinding_manager_primary_modifier_still_pressed ((GdkEvent*) _tmp0_, _tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = self->priv->m_loop;
	if (_tmp3_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->m_loop;
	g_main_loop_quit (_tmp4_);
	_tmp5_ = self->priv->m_selected_engine;
	self->priv->m_result = (gint) _tmp5_;
	result = TRUE;
	return result;
}


static SwitcherKeybinding* switcher_keybinding_construct (GType object_type, const gchar* accelerator, guint keysym, GdkModifierType modifiers) {
	SwitcherKeybinding* self = NULL;
	const gchar* _tmp0_;
	guint _tmp1_;
	GdkModifierType _tmp2_;
	g_return_val_if_fail (accelerator != NULL, NULL);
	self = (SwitcherKeybinding*) g_type_create_instance (object_type);
	_tmp0_ = accelerator;
	switcher_keybinding_set_accelerator (self, _tmp0_);
	_tmp1_ = keysym;
	switcher_keybinding_set_keysym (self, _tmp1_);
	_tmp2_ = modifiers;
	switcher_keybinding_set_modifiers (self, _tmp2_);
	return self;
}


static SwitcherKeybinding* switcher_keybinding_new (const gchar* accelerator, guint keysym, GdkModifierType modifiers) {
	return switcher_keybinding_construct (SWITCHER_TYPE_KEYBINDING, accelerator, keysym, modifiers);
}


static const gchar* switcher_keybinding_get_accelerator (SwitcherKeybinding* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_accelerator;
	result = _tmp0_;
	return result;
}


static void switcher_keybinding_set_accelerator (SwitcherKeybinding* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_accelerator);
	self->priv->_accelerator = _tmp1_;
}


static guint switcher_keybinding_get_keysym (SwitcherKeybinding* self) {
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_keysym;
	result = _tmp0_;
	return result;
}


static void switcher_keybinding_set_keysym (SwitcherKeybinding* self, guint value) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_keysym = _tmp0_;
}


static GdkModifierType switcher_keybinding_get_modifiers (SwitcherKeybinding* self) {
	GdkModifierType result;
	GdkModifierType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


static void switcher_keybinding_set_modifiers (SwitcherKeybinding* self, GdkModifierType value) {
	GdkModifierType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_modifiers = _tmp0_;
}


static void switcher_value_keybinding_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void switcher_value_keybinding_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		switcher_keybinding_unref (value->data[0].v_pointer);
	}
}


static void switcher_value_keybinding_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = switcher_keybinding_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer switcher_value_keybinding_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* switcher_value_keybinding_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		SwitcherKeybinding* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = switcher_keybinding_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* switcher_value_keybinding_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	SwitcherKeybinding** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = switcher_keybinding_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec* switcher_param_spec_keybinding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	SwitcherParamSpecKeybinding* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SWITCHER_TYPE_KEYBINDING), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer switcher_value_get_keybinding (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SWITCHER_TYPE_KEYBINDING), NULL);
	return value->data[0].v_pointer;
}


static void switcher_value_set_keybinding (GValue* value, gpointer v_object) {
	SwitcherKeybinding* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SWITCHER_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SWITCHER_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		switcher_keybinding_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		switcher_keybinding_unref (old);
	}
}


static void switcher_value_take_keybinding (GValue* value, gpointer v_object) {
	SwitcherKeybinding* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SWITCHER_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SWITCHER_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		switcher_keybinding_unref (old);
	}
}


static void switcher_keybinding_class_init (SwitcherKeybindingClass * klass) {
	switcher_keybinding_parent_class = g_type_class_peek_parent (klass);
	SWITCHER_KEYBINDING_CLASS (klass)->finalize = switcher_keybinding_finalize;
	g_type_class_add_private (klass, sizeof (SwitcherKeybindingPrivate));
}


static void switcher_keybinding_instance_init (SwitcherKeybinding * self) {
	self->priv = SWITCHER_KEYBINDING_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void switcher_keybinding_finalize (SwitcherKeybinding* obj) {
	SwitcherKeybinding * self;
	self = SWITCHER_KEYBINDING (obj);
	_g_free0 (self->priv->_accelerator);
}


static GType switcher_keybinding_get_type (void) {
	static volatile gsize switcher_keybinding_type_id__volatile = 0;
	if (g_once_init_enter (&switcher_keybinding_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { switcher_value_keybinding_init, switcher_value_keybinding_free_value, switcher_value_keybinding_copy_value, switcher_value_keybinding_peek_pointer, "p", switcher_value_keybinding_collect_value, "p", switcher_value_keybinding_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (SwitcherKeybindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switcher_keybinding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitcherKeybinding), 0, (GInstanceInitFunc) switcher_keybinding_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType switcher_keybinding_type_id;
		switcher_keybinding_type_id = g_type_register_fundamental (g_type_fundamental_next (), "SwitcherKeybinding", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&switcher_keybinding_type_id__volatile, switcher_keybinding_type_id);
	}
	return switcher_keybinding_type_id__volatile;
}


static gpointer switcher_keybinding_ref (gpointer instance) {
	SwitcherKeybinding* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void switcher_keybinding_unref (gpointer instance) {
	SwitcherKeybinding* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SWITCHER_KEYBINDING_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void switcher_class_init (SwitcherClass * klass) {
	switcher_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SwitcherPrivate));
	GTK_WIDGET_CLASS (klass)->show = switcher_real_show;
	GTK_WIDGET_CLASS (klass)->key_press_event = switcher_real_key_press_event;
	GTK_WIDGET_CLASS (klass)->key_release_event = switcher_real_key_release_event;
	G_OBJECT_CLASS (klass)->finalize = switcher_finalize;
}


static void switcher_instance_init (Switcher * self) {
	GtkButton** _tmp0_ = NULL;
	self->priv = SWITCHER_GET_PRIVATE (self);
	_tmp0_ = g_new0 (GtkButton*, 0 + 1);
	self->priv->m_buttons = _tmp0_;
	self->priv->m_buttons_length1 = 0;
	self->priv->_m_buttons_size_ = self->priv->m_buttons_length1;
	self->priv->m_default_font_size = 16;
}


static void switcher_finalize (GObject* obj) {
	Switcher * self;
	self = SWITCHER (obj);
	_g_object_unref0 (self->priv->m_box);
	_g_object_unref0 (self->priv->m_label);
	self->priv->m_buttons = (_vala_array_free (self->priv->m_buttons, self->priv->m_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_engines = (_vala_array_free (self->priv->m_engines, self->priv->m_engines_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_main_loop_unref0 (self->priv->m_loop);
	G_OBJECT_CLASS (switcher_parent_class)->finalize (obj);
}


GType switcher_get_type (void) {
	static volatile gsize switcher_type_id__volatile = 0;
	if (g_once_init_enter (&switcher_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwitcherClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switcher_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Switcher), 0, (GInstanceInitFunc) switcher_instance_init, NULL };
		GType switcher_type_id;
		switcher_type_id = g_type_register_static (GTK_TYPE_WINDOW, "Switcher", &g_define_type_info, 0);
		g_once_init_leave (&switcher_type_id__volatile, switcher_type_id);
	}
	return switcher_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



