/*
 * Copyright (C) Jacek Konieczy <jajcus@zeus.polsl.gliwice.pl>
 *     extra HTTP configuration
 *
 */

#ifndef __KHTTPOPTDLG_H
#define __KHTTPOPTDLG_H

#include <QLabel>
#include <QLineEdit>
#include <QCheckBox>

#include <kcmodule.h>
#include <kconfig.h>
#include <ksharedconfig.h>

class KAboutData;

/**
*  Dialog for configuring HTTP Options like charset and language negotiation
*  and assuming that file got from HTTP is HTML if no Content-Type is given
*/
class KHTTPOptions : public KCModule
{
    Q_OBJECT
public:
    KHTTPOptions(KSharedConfig::Ptr config, const QString &group, const KAboutData *aboutData, QWidget *parent);

    void load() Q_DECL_OVERRIDE;
    void save() Q_DECL_OVERRIDE;
    void defaults() Q_DECL_OVERRIDE;

private:

    KSharedConfig::Ptr m_pConfig;
    QString m_groupname;

    // Acceptable languages "LANG" - locale selected languages
    QLabel *lb_languages;
    QLineEdit *le_languages;

    // Acceptable charsets "CHARSET" - locale selected charset
    QLabel *lb_charsets;
    QLineEdit *le_charsets;

    QString defaultCharsets;

private Q_SLOTS:
    void slotChanged();

};

#endif // __KHTTPOPTDLG_H
