/* document.c generated by valac 0.35.2.3-28fcae, the Vala compiler
 * generated from document.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <latexila.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>


#define TYPE_SELECTION_TYPE (selection_type_get_type ())

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block15Data Block15Data;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_TAB_INFO_BAR (tab_info_bar_get_type ())
#define TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAB_INFO_BAR, TabInfoBar))
#define TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAB_INFO_BAR, TabInfoBarClass))
#define IS_TAB_INFO_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAB_INFO_BAR))
#define IS_TAB_INFO_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAB_INFO_BAR))
#define TAB_INFO_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAB_INFO_BAR, TabInfoBarClass))

typedef struct _TabInfoBar TabInfoBar;
typedef struct _TabInfoBarClass TabInfoBarClass;
typedef struct _Block16Data Block16Data;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define TYPE_LATEXILA_APP (latexila_app_get_type ())
#define LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA_APP, LatexilaApp))
#define LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA_APP, LatexilaAppClass))
#define IS_LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA_APP))
#define IS_LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA_APP))
#define LATEXILA_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA_APP, LatexilaAppClass))

typedef struct _LatexilaApp LatexilaApp;
typedef struct _LatexilaAppClass LatexilaAppClass;
typedef struct _Block17Data Block17Data;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	DOCUMENT_CURSOR_MOVED_SIGNAL,
	DOCUMENT_LAST_SIGNAL
};
static guint document_signals[DOCUMENT_LAST_SIGNAL] = {0};

typedef enum  {
	SELECTION_TYPE_NO_SELECTION,
	SELECTION_TYPE_ONE_LINE,
	SELECTION_TYPE_MULTIPLE_LINES
} SelectionType;

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};

struct _DocumentPrivate {
	GFile* _location;
	gboolean _readonly;
	gint _project_id;
	gboolean backup_made;
	gchar* _etag;
	gchar* encoding;
	gboolean new_file;
	DocumentStructure* _structure;
	GFileInfo* _metadata_info;
};

struct _Block15Data {
	int _ref_count_;
	Document* self;
	GtkSourceCompletion* completion;
};

struct _Block16Data {
	int _ref_count_;
	Document* self;
	TabInfoBar* infobar;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block17Data {
	int _ref_count_;
	Document* self;
	TabInfoBar* infobar;
};


static gpointer document_parent_class = NULL;

GType selection_type_get_type (void) G_GNUC_CONST;
GType document_get_type (void) G_GNUC_CONST;
GType document_tab_get_type (void) G_GNUC_CONST;
GType document_structure_get_type (void) G_GNUC_CONST;
#define DOCUMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT, DocumentPrivate))
enum  {
	DOCUMENT_DUMMY_PROPERTY,
	DOCUMENT_LOCATION,
	DOCUMENT_READONLY,
	DOCUMENT_PROJECT_ID
};
Document* document_new (void);
Document* document_construct (GType object_type);
static void __lambda50_ (Document* self);
static void document_update_syntax_highlighting (Document* self);
static void document_update_project_id (Document* self);
static void ___lambda50__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda51_ (Document* self, GtkTextIter* location, GtkTextMark* mark);
static void ___lambda51__gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self);
static void __lambda52_ (Document* self);
static void ___lambda52__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
gboolean document_get_modified (Document* self);
void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_view (DocumentTab* self);
static gboolean __lambda20_ (Block15Data* _data15_);
static gboolean ___lambda20__gsource_func (gpointer self);
void document_load (Document* self, GFile* location);
void document_set_location (Document* self, GFile* value);
void document_set_contents (Document* self, const gchar* contents);
static gchar* document_to_utf8 (Document* self, const gchar* text, GError** error);
GType tab_info_bar_get_type (void) G_GNUC_CONST;
TabInfoBar* document_tab_add_message (DocumentTab* self, const gchar* primary_msg, const gchar* secondary_msg, GtkMessageType msg_type);
void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force);
GFile* document_get_location (Document* self);
static void document_save_metadata (Document* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void ____lambda17_ (Block16Data* _data16_, gint response_id);
static void _____lambda17__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
void tab_info_bar_add_ok_button (TabInfoBar* self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self, Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_projects (GValue* value, gpointer v_object);
void value_take_projects (GValue* value, gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
GeeIterator* projects_iterator (Projects* self);
void document_set_project_id (Document* self, gint value);
gchar* document_get_uri_for_display (Document* self);
static gchar* document_get_unsaved_document_name (Document* self);
gchar* document_get_short_name_for_display (Document* self);
static guint document_get_unsaved_document_num (Document* self);
GType latexila_app_get_type (void) G_GNUC_CONST;
LatexilaApp* latexila_app_get_instance (void);
GeeList* latexila_app_get_documents (LatexilaApp* self);
static void _vala_array_add4 (guint* * array, int* length, int* size, guint value);
static gboolean _vala_uint_array_contains (guint * stack, int stack_length, guint needle);
gboolean document_is_local (Document* self);
gboolean document_is_externally_modified (Document* self);
void document_set_style_scheme_from_string (Document* self, const gchar* scheme_id);
void document_comment_selected_lines (Document* self);
void document_comment_between (Document* self, GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean end_iter_set);
void document_uncomment_selected_lines (Document* self);
void document_select_lines (Document* self, gint start, gint end);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
SelectionType document_get_selection_type (Document* self);
gboolean document_goto_line (Document* self, gint line);
Project* document_get_project (Document* self);
gint document_get_project_id (Document* self);
Project* projects_get (Projects* self, gint id);
GFile* document_get_main_file (Document* self);
gboolean document_is_main_file_a_tex_file (Document* self);
gchar* document_get_current_indentation (Document* self, GtkTextIter* iter);
DocumentStructure* document_get_structure (Document* self);
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type, Document* doc);
void document_structure_parse (DocumentStructure* self);
gboolean document_set_tmp_location (Document* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda26_ (Block17Data* _data17_, gint response_id);
GType main_window_get_type (void) G_GNUC_CONST;
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
gboolean main_window_save_document (MainWindow* self, Document* doc, gboolean force_save_as);
static void ___lambda26__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self);
void document_set_metadata (Document* self, const gchar* key, const gchar* val);
gchar* document_get_metadata (Document* self, const gchar* key);
gboolean document_get_readonly (Document* self);
void document_set_readonly (Document* self, gboolean value);
static void document_finalize (GObject * obj);
static void _vala_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

extern const gchar* ENCODINGS_CHARSETS[60];

GType selection_type_get_type (void) {
	static volatile gsize selection_type_type_id__volatile = 0;
	if (g_once_init_enter (&selection_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SELECTION_TYPE_NO_SELECTION, "SELECTION_TYPE_NO_SELECTION", "no-selection"}, {SELECTION_TYPE_ONE_LINE, "SELECTION_TYPE_ONE_LINE", "one-line"}, {SELECTION_TYPE_MULTIPLE_LINES, "SELECTION_TYPE_MULTIPLE_LINES", "multiple-lines"}, {0, NULL, NULL}};
		GType selection_type_type_id;
		selection_type_type_id = g_enum_register_static ("SelectionType", values);
		g_once_init_leave (&selection_type_type_id__volatile, selection_type_type_id);
	}
	return selection_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda50_ (Document* self) {
	document_update_syntax_highlighting (self);
	document_update_project_id (self);
}


static void ___lambda50__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda50_ ((Document*) self);
}


static void __lambda51_ (Document* self, GtkTextIter* location, GtkTextMark* mark) {
	GtkTextMark* _tmp0_;
	GtkTextMark* _tmp1_;
	g_return_if_fail (location != NULL);
	g_return_if_fail (mark != NULL);
	_tmp0_ = mark;
	_tmp1_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) self);
	if (_tmp0_ == _tmp1_) {
		g_signal_emit (self, document_signals[DOCUMENT_CURSOR_MOVED_SIGNAL], 0);
	}
}


static void ___lambda51__gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self) {
	__lambda51_ ((Document*) self, location, mark);
}


static void __lambda52_ (Document* self) {
	self->priv->new_file = FALSE;
	g_signal_emit (self, document_signals[DOCUMENT_CURSOR_MOVED_SIGNAL], 0);
}


static void ___lambda52__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	__lambda52_ ((Document*) self);
}


Document* document_construct (GType object_type) {
	Document * self = NULL;
	GtkSourceLanguageManager* lm;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	GtkSourceLanguage* _tmp2_;
	self = (Document*) g_object_new (object_type, NULL);
	_tmp0_ = gtk_source_language_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	lm = _tmp1_;
	_tmp2_ = gtk_source_language_manager_get_language (lm, "latex");
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, _tmp2_);
	g_signal_connect_object ((GObject*) self, "notify::location", (GCallback) ___lambda50__g_object_notify, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self, "mark-set", (GCallback) ___lambda51__gtk_text_buffer_mark_set, self, 0);
	g_signal_connect_object ((GtkTextBuffer*) self, "changed", (GCallback) ___lambda52__gtk_text_buffer_changed, self, 0);
	_g_object_unref0 (lm);
	return self;
}


Document* document_new (void) {
	return document_construct (TYPE_DOCUMENT);
}


gboolean document_get_modified (Document* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->new_file;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer));
	result = _tmp1_;
	return result;
}


static Block15Data* block15_data_ref (Block15Data* _data15_) {
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}


static void block15_data_unref (void * _userdata_) {
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		Document* self;
		self = _data15_->self;
		_g_object_unref0 (_data15_->completion);
		_g_object_unref0 (self);
		g_slice_free (Block15Data, _data15_);
	}
}


static gboolean __lambda20_ (Block15Data* _data15_) {
	Document* self;
	gboolean result = FALSE;
	self = _data15_->self;
	gtk_source_completion_unblock_interactive (_data15_->completion);
	result = FALSE;
	return result;
}


static gboolean ___lambda20__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda20_ (self);
	return result;
}


void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len) {
	Block15Data* _data15_;
	DocumentTab* _tmp0_;
	DocumentView* _tmp1_;
	DocumentView* _tmp2_;
	GtkSourceCompletion* _tmp3_;
	GtkSourceCompletion* _tmp4_;
	GtkSourceCompletion* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (text != NULL);
	_data15_ = g_slice_new0 (Block15Data);
	_data15_->_ref_count_ = 1;
	_data15_->self = g_object_ref (self);
	_tmp0_ = self->tab;
	_tmp1_ = document_tab_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_data15_->completion = _tmp5_;
	gtk_source_completion_block_interactive (_data15_->completion);
	_tmp6_ = text;
	_tmp7_ = len;
	gtk_text_buffer_insert ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_buffer_get_type (), GtkSourceBuffer), iter, _tmp6_, _tmp7_);
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda20__gsource_func, block15_data_ref (_data15_), block15_data_unref);
	block15_data_unref (_data15_);
	_data15_ = NULL;
}


void document_load (Document* self, GFile* location) {
	GFile* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	{
		GFileInfo* _tmp0_;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		_tmp1_ = location;
		_tmp2_ = g_file_query_info (_tmp1_, "metadata::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->_metadata_info);
		self->priv->_metadata_info = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GFileInfo* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("document.vala:104: Get document metadata failed: %s", _tmp5_);
		_tmp6_ = g_file_info_new ();
		_g_object_unref0 (self->priv->_metadata_info);
		self->priv->_metadata_info = _tmp6_;
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp7_ = location;
	document_set_location (self, _tmp7_);
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		GFile* _tmp8_;
		guint8* _tmp9_ = NULL;
		gsize _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* text;
		guint8* _tmp12_;
		gint _tmp12__length1;
		const gchar* _tmp13_;
		gboolean _tmp14_;
		GtkRecentManager* _tmp19_;
		GFile* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp8_ = location;
		g_file_load_contents (_tmp8_, NULL, &_tmp9_, &_tmp10_, &_tmp11_, &_inner_error_);
		chars = (g_free (chars), NULL);
		chars = _tmp9_;
		chars_length1 = _tmp10_;
		_chars_size_ = chars_length1;
		g_free (self->priv->_etag);
		self->priv->_etag = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			chars = (g_free (chars), NULL);
			goto __catch9_g_error;
		}
		_tmp12_ = chars;
		_tmp12__length1 = chars_length1;
		chars = NULL;
		chars_length1 = 0;
		text = (gchar*) _tmp12_;
		_tmp13_ = text;
		_tmp14_ = g_utf8_validate (_tmp13_, (gssize) -1, NULL);
		if (_tmp14_) {
			const gchar* _tmp15_;
			_tmp15_ = text;
			document_set_contents (self, _tmp15_);
		} else {
			gchar* utf8_text;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			_tmp16_ = text;
			_tmp17_ = document_to_utf8 (self, _tmp16_, &_inner_error_);
			utf8_text = _tmp17_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_free (text);
				chars = (g_free (chars), NULL);
				goto __catch9_g_error;
			}
			_tmp18_ = utf8_text;
			document_set_contents (self, _tmp18_);
			g_free (utf8_text);
		}
		document_update_syntax_highlighting (self);
		_tmp19_ = gtk_recent_manager_get_default ();
		_tmp20_ = location;
		_tmp21_ = g_file_get_uri (_tmp20_);
		_tmp22_ = _tmp21_;
		gtk_recent_manager_add_item (_tmp19_, _tmp22_);
		g_free (_tmp22_);
		g_free (text);
		chars = (g_free (chars), NULL);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
		gchar* primary_msg;
		GFile* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		DocumentTab* _tmp30_;
		const gchar* _tmp31_;
		GError* _tmp32_;
		const gchar* _tmp33_;
		TabInfoBar* _tmp34_;
		TabInfoBar* _tmp35_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		g_warning ("document.vala:132: %s", _tmp24_);
		_tmp25_ = location;
		_tmp26_ = g_file_get_parse_name (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strdup_printf (_ ("Impossible to load the file '%s'."), _tmp27_);
		_tmp29_ = _tmp28_;
		g_free (_tmp27_);
		primary_msg = _tmp29_;
		_tmp30_ = self->tab;
		_tmp31_ = primary_msg;
		_tmp32_ = e;
		_tmp33_ = _tmp32_->message;
		_tmp34_ = document_tab_add_message (_tmp30_, _tmp31_, _tmp33_, GTK_MESSAGE_ERROR);
		_tmp35_ = _tmp34_;
		_g_object_unref0 (_tmp35_);
		g_free (primary_msg);
		_g_error_free0 (e);
	}
	__finally9:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_;
	glong _tmp16_;
	glong _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_;
		glong _tmp15_;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


void document_set_contents (Document* self, const gchar* contents) {
	gchar* contents2;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar _tmp4_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GtkTextIter iter = {0};
	GtkTextIter _tmp10_ = {0};
	GtkTextIter _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contents != NULL);
	contents2 = NULL;
	_tmp0_ = contents;
	_tmp1_ = contents;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_get (_tmp0_, (glong) (_tmp3_ - 1));
	if (_tmp4_ == '\n') {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = contents;
		_tmp6_ = string_slice (_tmp5_, (glong) 0, (glong) -1);
		g_free (contents2);
		contents2 = _tmp6_;
	}
	gtk_source_buffer_begin_not_undoable_action ((GtkSourceBuffer*) self);
	_tmp8_ = contents2;
	_tmp7_ = _tmp8_;
	if (_tmp7_ == NULL) {
		const gchar* _tmp9_;
		_tmp9_ = contents;
		_tmp7_ = _tmp9_;
	}
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp7_, -1);
	self->priv->new_file = TRUE;
	gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
	gtk_source_buffer_end_not_undoable_action ((GtkSourceBuffer*) self);
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp10_);
	iter = _tmp10_;
	_tmp11_ = iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp11_);
	g_free (contents2);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static Block16Data* block16_data_ref (Block16Data* _data16_) {
	g_atomic_int_inc (&_data16_->_ref_count_);
	return _data16_;
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
		Document* self;
		self = _data16_->self;
		_g_object_unref0 (_data16_->infobar);
		_g_object_unref0 (self);
		g_slice_free (Block16Data, _data16_);
	}
}


static void ____lambda17_ (Block16Data* _data16_, gint response_id) {
	Document* self;
	gint _tmp0_;
	TabInfoBar* _tmp1_;
	self = _data16_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_YES)) {
		document_save (self, FALSE, FALSE);
	}
	_tmp1_ = _data16_->infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp1_);
}


static void _____lambda17__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	____lambda17_ (self, response_id);
}


void document_save (Document* self, gboolean check_file_changed_on_disk, gboolean force) {
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp6_ = {0};
	GtkTextIter _tmp7_ = {0};
	gchar* text;
	GtkTextIter _tmp8_;
	GtkTextIter _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_location;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp3_ = force;
	if (!_tmp3_) {
		gboolean _tmp4_;
		_tmp4_ = self->priv->new_file;
		_tmp2_ = !_tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_;
		_tmp5_ = document_get_modified (self);
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		return;
	}
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp6_, &_tmp7_);
	start = _tmp6_;
	end = _tmp7_;
	_tmp8_ = start;
	_tmp9_ = end;
	_tmp10_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp8_, &_tmp9_, FALSE);
	text = _tmp10_;
	_tmp11_ = text;
	_tmp12_ = text;
	_tmp13_ = strlen (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = string_get (_tmp11_, (glong) (_tmp14_ - 1));
	if (_tmp15_ != '\n') {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		_tmp16_ = text;
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = g_strconcat (_tmp17_, "\n", NULL);
		g_free (text);
		text = _tmp18_;
	}
	{
		GSettings* settings;
		GSettings* _tmp19_;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_;
		gboolean make_backup;
		const gchar* _tmp24_ = NULL;
		gboolean _tmp25_;
		gchar* etag;
		gchar* _tmp27_;
		const gchar* _tmp28_;
		GFile* parent;
		GFile* _tmp44_;
		GFile* _tmp45_;
		gboolean _tmp46_ = FALSE;
		GFile* _tmp47_;
		GFile* _tmp51_;
		const gchar* _tmp52_;
		guint8* _tmp53_;
		gint _tmp53__length1;
		guint8* _tmp54_;
		gint _tmp54__length1;
		const gchar* _tmp55_;
		gboolean _tmp56_;
		gchar* _tmp57_ = NULL;
		GtkRecentManager* _tmp58_;
		GFile* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		_tmp19_ = g_settings_new ("org.gnome.latexila.preferences.editor");
		settings = _tmp19_;
		_tmp21_ = self->priv->backup_made;
		if (!_tmp21_) {
			GSettings* _tmp22_;
			gboolean _tmp23_;
			_tmp22_ = settings;
			_tmp23_ = g_settings_get_boolean (_tmp22_, "create-backup-copy");
			_tmp20_ = _tmp23_;
		} else {
			_tmp20_ = FALSE;
		}
		make_backup = _tmp20_;
		_tmp25_ = check_file_changed_on_disk;
		if (_tmp25_) {
			const gchar* _tmp26_;
			_tmp26_ = self->priv->_etag;
			_tmp24_ = _tmp26_;
		} else {
			_tmp24_ = NULL;
		}
		_tmp27_ = g_strdup (_tmp24_);
		etag = _tmp27_;
		_tmp28_ = self->priv->encoding;
		if (_tmp28_ != NULL) {
			gchar* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			_tmp30_ = text;
			_tmp31_ = text;
			_tmp32_ = strlen (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp34_ = self->priv->encoding;
			_tmp35_ = g_convert (_tmp30_, (gssize) _tmp33_, _tmp34_, "UTF-8", NULL, NULL, &_inner_error_);
			_tmp29_ = _tmp35_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_free (etag);
				_g_object_unref0 (settings);
				goto __catch10_g_error;
			}
			_tmp36_ = _tmp29_;
			_tmp29_ = NULL;
			g_free (text);
			text = _tmp36_;
			g_free (_tmp29_);
		} else {
			gchar* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			_tmp38_ = text;
			_tmp39_ = text;
			_tmp40_ = strlen (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_filename_from_utf8 (_tmp38_, (gssize) _tmp41_, NULL, NULL, &_inner_error_);
			_tmp37_ = _tmp42_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_free (etag);
				_g_object_unref0 (settings);
				goto __catch10_g_error;
			}
			_tmp43_ = _tmp37_;
			_tmp37_ = NULL;
			g_free (text);
			text = _tmp43_;
			g_free (_tmp37_);
		}
		_tmp44_ = self->priv->_location;
		_tmp45_ = g_file_get_parent (_tmp44_);
		parent = _tmp45_;
		_tmp47_ = parent;
		if (_tmp47_ != NULL) {
			GFile* _tmp48_;
			gboolean _tmp49_;
			_tmp48_ = parent;
			_tmp49_ = g_file_query_exists (_tmp48_, NULL);
			_tmp46_ = !_tmp49_;
		} else {
			_tmp46_ = FALSE;
		}
		if (_tmp46_) {
			GFile* _tmp50_;
			_tmp50_ = parent;
			g_file_make_directory_with_parents (_tmp50_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (parent);
				g_free (etag);
				_g_object_unref0 (settings);
				goto __catch10_g_error;
			}
		}
		_tmp51_ = self->priv->_location;
		_tmp52_ = text;
		_tmp53_ = string_get_data (_tmp52_, &_tmp53__length1);
		_tmp54_ = _tmp53_;
		_tmp54__length1 = _tmp53__length1;
		_tmp55_ = etag;
		_tmp56_ = make_backup;
		g_file_replace_contents (_tmp51_, _tmp54_, (gsize) _tmp54__length1, _tmp55_, _tmp56_, G_FILE_CREATE_NONE, &_tmp57_, NULL, &_inner_error_);
		g_free (self->priv->_etag);
		self->priv->_etag = _tmp57_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (parent);
			g_free (etag);
			_g_object_unref0 (settings);
			goto __catch10_g_error;
		}
		gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
		_tmp58_ = gtk_recent_manager_get_default ();
		_tmp59_ = self->priv->_location;
		_tmp60_ = g_file_get_uri (_tmp59_);
		_tmp61_ = _tmp60_;
		gtk_recent_manager_add_item (_tmp58_, _tmp61_);
		g_free (_tmp61_);
		self->priv->backup_made = TRUE;
		document_save_metadata (self);
		_g_object_unref0 (parent);
		g_free (etag);
		_g_object_unref0 (settings);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp62_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp62_ = e;
		if (g_error_matches (_tmp62_, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
			Block16Data* _data16_;
			gchar* primary_msg;
			GFile* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* secondary_msg;
			gchar* _tmp68_;
			DocumentTab* _tmp69_;
			const gchar* _tmp70_;
			const gchar* _tmp71_;
			TabInfoBar* _tmp72_;
			TabInfoBar* _tmp73_;
			TabInfoBar* _tmp74_;
			TabInfoBar* _tmp75_;
			_data16_ = g_slice_new0 (Block16Data);
			_data16_->_ref_count_ = 1;
			_data16_->self = g_object_ref (self);
			_tmp63_ = self->priv->_location;
			_tmp64_ = g_file_get_parse_name (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strdup_printf (_ ("The file %s has been modified since reading it."), _tmp65_);
			_tmp67_ = _tmp66_;
			g_free (_tmp65_);
			primary_msg = _tmp67_;
			_tmp68_ = g_strdup (_ ("If you save it, all the external changes could be lost. Save it anyway" \
"?"));
			secondary_msg = _tmp68_;
			_tmp69_ = self->tab;
			_tmp70_ = primary_msg;
			_tmp71_ = secondary_msg;
			_tmp72_ = document_tab_add_message (_tmp69_, _tmp70_, _tmp71_, GTK_MESSAGE_WARNING);
			_data16_->infobar = _tmp72_;
			_tmp73_ = _data16_->infobar;
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp73_, _ ("_Save Anyway"), (gint) GTK_RESPONSE_YES);
			_tmp74_ = _data16_->infobar;
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp74_, _ ("_Don't Save"), (gint) GTK_RESPONSE_CANCEL);
			_tmp75_ = _data16_->infobar;
			g_signal_connect_data ((GtkInfoBar*) _tmp75_, "response", (GCallback) _____lambda17__gtk_info_bar_response, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
			g_free (secondary_msg);
			g_free (primary_msg);
			block16_data_unref (_data16_);
			_data16_ = NULL;
		} else {
			GError* _tmp76_;
			const gchar* _tmp77_;
			gchar* primary_msg;
			gchar* _tmp78_;
			TabInfoBar* infobar;
			DocumentTab* _tmp79_;
			const gchar* _tmp80_;
			GError* _tmp81_;
			const gchar* _tmp82_;
			TabInfoBar* _tmp83_;
			TabInfoBar* _tmp84_;
			_tmp76_ = e;
			_tmp77_ = _tmp76_->message;
			g_warning ("document.vala:229: %s", _tmp77_);
			_tmp78_ = g_strdup (_ ("Impossible to save the file."));
			primary_msg = _tmp78_;
			_tmp79_ = self->tab;
			_tmp80_ = primary_msg;
			_tmp81_ = e;
			_tmp82_ = _tmp81_->message;
			_tmp83_ = document_tab_add_message (_tmp79_, _tmp80_, _tmp82_, GTK_MESSAGE_ERROR);
			infobar = _tmp83_;
			_tmp84_ = infobar;
			tab_info_bar_add_ok_button (_tmp84_);
			_g_object_unref0 (infobar);
			g_free (primary_msg);
		}
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_free (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_free (text);
}


static gchar* document_to_utf8 (Document* self, const gchar* text, GError** error) {
	gchar* result = NULL;
	GError* _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	{
		const gchar** charset_collection = NULL;
		gint charset_collection_length1 = 0;
		gint _charset_collection_size_ = 0;
		gint charset_it = 0;
		charset_collection = ENCODINGS_CHARSETS;
		charset_collection_length1 = G_N_ELEMENTS (ENCODINGS_CHARSETS);
		for (charset_it = 0; charset_it < G_N_ELEMENTS (ENCODINGS_CHARSETS); charset_it = charset_it + 1) {
			gchar* _tmp0_;
			gchar* charset = NULL;
			_tmp0_ = g_strdup (charset_collection[charset_it]);
			charset = _tmp0_;
			{
				{
					gchar* utf8_text;
					const gchar* _tmp1_;
					const gchar* _tmp2_;
					gint _tmp3_;
					gint _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp1_ = text;
					_tmp2_ = text;
					_tmp3_ = strlen (_tmp2_);
					_tmp4_ = _tmp3_;
					_tmp5_ = charset;
					_tmp6_ = g_convert (_tmp1_, (gssize) _tmp4_, "UTF-8", _tmp5_, NULL, NULL, &_inner_error_);
					utf8_text = _tmp6_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == G_CONVERT_ERROR) {
							goto __catch11_g_convert_error;
						}
						g_free (charset);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
					_tmp7_ = charset;
					_tmp8_ = g_strdup (_tmp7_);
					g_free (self->priv->encoding);
					self->priv->encoding = _tmp8_;
					result = utf8_text;
					g_free (charset);
					return result;
				}
				goto __finally11;
				__catch11_g_convert_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
					g_free (charset);
					continue;
				}
				__finally11:
				if (_inner_error_->domain == G_CONVERT_ERROR) {
					g_propagate_error (error, _inner_error_);
					g_free (charset);
					return NULL;
				} else {
					g_free (charset);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				g_free (charset);
			}
		}
	}
	_tmp9_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _ ("Error trying to convert the document to UTF-8"));
	_inner_error_ = _tmp9_;
	if (_inner_error_->domain == G_CONVERT_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void document_update_syntax_highlighting (Document* self) {
	GtkSourceLanguageManager* lm;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	gchar* content_type;
	GtkSourceLanguage* lang;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GtkSourceLanguage* _tmp10_;
	GtkSourceLanguage* _tmp11_;
	GtkSourceLanguage* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_source_language_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	lm = _tmp1_;
	content_type = NULL;
	{
		GFileInfo* info;
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->priv->_location;
		_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		info = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch12_g_error;
		}
		_tmp4_ = g_file_info_get_content_type (info);
		_tmp5_ = g_strdup (_tmp4_);
		g_free (content_type);
		content_type = _tmp5_;
		_g_object_unref0 (info);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_free (content_type);
		_g_object_unref0 (lm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = self->priv->_location;
	_tmp7_ = g_file_get_parse_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = content_type;
	_tmp10_ = gtk_source_language_manager_guess_language (lm, _tmp8_, _tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_tmp12_ = _tmp11_;
	g_free (_tmp8_);
	lang = _tmp12_;
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, lang);
	_g_object_unref0 (lang);
	g_free (content_type);
	_g_object_unref0 (lm);
}


static void document_update_project_id (Document* self) {
	gint i;
	g_return_if_fail (self != NULL);
	i = 0;
	{
		GeeIterator* _project_it;
		Projects* _tmp0_;
		Projects* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = projects_get_default ();
		_tmp1_ = _tmp0_;
		_tmp2_ = projects_iterator (_tmp1_);
		_tmp3_ = _tmp2_;
		_projects_unref0 (_tmp1_);
		_project_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			gboolean _tmp5_;
			Project project;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Project* _tmp8_;
			Project _tmp9_ = {0};
			Project _tmp10_;
			GFile* _tmp11_;
			Project _tmp12_;
			GFile* _tmp13_;
			gboolean _tmp14_;
			gint _tmp16_;
			_tmp4_ = _project_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _project_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			_tmp8_ = (Project*) _tmp7_;
			project_copy (_tmp8_, &_tmp9_);
			_tmp10_ = _tmp9_;
			_project_free0 (_tmp8_);
			project = _tmp10_;
			_tmp11_ = self->priv->_location;
			_tmp12_ = project;
			_tmp13_ = _tmp12_.directory;
			_tmp14_ = g_file_has_prefix (_tmp11_, _tmp13_);
			if (_tmp14_) {
				gint _tmp15_;
				_tmp15_ = i;
				document_set_project_id (self, _tmp15_);
				project_destroy (&project);
				_g_object_unref0 (_project_it);
				return;
			}
			_tmp16_ = i;
			i = _tmp16_ + 1;
			project_destroy (&project);
		}
		_g_object_unref0 (_project_it);
	}
	document_set_project_id (self, -1);
}


gchar* document_get_uri_for_display (Document* self) {
	gchar* result = NULL;
	GFile* _tmp0_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = document_get_unsaved_document_name (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_location;
	_tmp3_ = g_file_get_parse_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = latexila_utils_replace_home_dir_with_tilde (_tmp4_);
	_tmp6_ = _tmp5_;
	g_free (_tmp4_);
	result = _tmp6_;
	return result;
}


gchar* document_get_short_name_for_display (Document* self) {
	gchar* result = NULL;
	GFile* _tmp0_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = document_get_unsaved_document_name (self);
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->priv->_location;
	_tmp3_ = g_file_get_basename (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* document_get_unsaved_document_name (Document* self) {
	gchar* result = NULL;
	guint num;
	guint _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = document_get_unsaved_document_num (self);
	num = _tmp0_;
	_tmp1_ = g_strdup_printf ("%u", num);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (" ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_ ("Untitled Document"), _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	g_free (_tmp4_);
	g_free (_tmp2_);
	result = _tmp6_;
	return result;
}


static void _vala_array_add4 (guint* * array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static gboolean _vala_uint_array_contains (guint * stack, int stack_length, guint needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (needle == stack[i]) {
			return TRUE;
		}
	}
	return FALSE;
}


static guint document_get_unsaved_document_num (Document* self) {
	guint result = 0U;
	GFile* _tmp0_;
	guint _tmp1_;
	guint* all_nums;
	guint* _tmp3_;
	gint all_nums_length1;
	gint _all_nums_size_;
	guint num = 0U;
	guint _tmp27_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_location;
	g_return_val_if_fail (_tmp0_ == NULL, 0);
	_tmp1_ = self->_unsaved_doc_num;
	if (_tmp1_ > ((guint) 0)) {
		guint _tmp2_;
		_tmp2_ = self->_unsaved_doc_num;
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_new0 (guint, 0);
	all_nums = _tmp3_;
	all_nums_length1 = 0;
	_all_nums_size_ = all_nums_length1;
	{
		GeeList* _doc_list;
		LatexilaApp* _tmp4_;
		LatexilaApp* _tmp5_;
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		gint _doc_size;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _doc_index;
		_tmp4_ = latexila_app_get_instance ();
		_tmp5_ = _tmp4_;
		_tmp6_ = latexila_app_get_documents (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_doc_list = _tmp7_;
		_tmp8_ = _doc_list;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_doc_size = _tmp10_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			Document* doc;
			GeeList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			Document* _tmp17_;
			Document* _tmp18_;
			GFile* _tmp19_;
			_tmp11_ = _doc_index;
			_doc_index = _tmp11_ + 1;
			_tmp12_ = _doc_index;
			_tmp13_ = _doc_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _doc_list;
			_tmp15_ = _doc_index;
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
			doc = (Document*) _tmp16_;
			_tmp17_ = doc;
			if (_tmp17_ == self) {
				_g_object_unref0 (doc);
				continue;
			}
			_tmp18_ = doc;
			_tmp19_ = _tmp18_->priv->_location;
			if (_tmp19_ == NULL) {
				guint* _tmp20_;
				gint _tmp20__length1;
				Document* _tmp21_;
				guint _tmp22_;
				_tmp20_ = all_nums;
				_tmp20__length1 = all_nums_length1;
				_tmp21_ = doc;
				_tmp22_ = document_get_unsaved_document_num (_tmp21_);
				_vala_array_add4 (&all_nums, &all_nums_length1, &_all_nums_size_, _tmp22_);
			}
			_g_object_unref0 (doc);
		}
		_g_object_unref0 (_doc_list);
	}
	{
		gboolean _tmp23_;
		num = (guint) 1;
		_tmp23_ = TRUE;
		while (TRUE) {
			guint _tmp25_;
			guint* _tmp26_;
			gint _tmp26__length1;
			if (!_tmp23_) {
				guint _tmp24_;
				_tmp24_ = num;
				num = _tmp24_ + 1;
			}
			_tmp23_ = FALSE;
			_tmp25_ = num;
			_tmp26_ = all_nums;
			_tmp26__length1 = all_nums_length1;
			if (!_vala_uint_array_contains (_tmp26_, _tmp26__length1, _tmp25_)) {
				break;
			}
		}
	}
	_tmp27_ = num;
	self->_unsaved_doc_num = _tmp27_;
	result = num;
	all_nums = (g_free (all_nums), NULL);
	return result;
}


gboolean document_is_local (Document* self) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_location;
	_tmp2_ = g_file_has_uri_scheme (_tmp1_, "file");
	result = _tmp2_;
	return result;
}


gboolean document_is_externally_modified (Document* self) {
	gboolean result = FALSE;
	GFile* _tmp0_;
	gchar* current_etag;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	current_etag = NULL;
	{
		GFileInfo* file_info;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = self->priv->_location;
		_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_ETAG_VALUE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		file_info = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch13_g_error;
		}
		_tmp3_ = file_info;
		_tmp4_ = g_file_info_get_etag (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		g_free (current_etag);
		current_etag = _tmp5_;
		_g_object_unref0 (file_info);
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (e);
		g_free (current_etag);
		return result;
	}
	__finally13:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_free (current_etag);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = current_etag;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp8_ = current_etag;
		_tmp9_ = self->priv->_etag;
		_tmp6_ = g_strcmp0 (_tmp8_, _tmp9_) != 0;
	} else {
		_tmp6_ = FALSE;
	}
	result = _tmp6_;
	g_free (current_etag);
	return result;
}


void document_set_style_scheme_from_string (Document* self, const gchar* scheme_id) {
	GtkSourceStyleSchemeManager* manager;
	GtkSourceStyleSchemeManager* _tmp0_;
	GtkSourceStyleSchemeManager* _tmp1_;
	const gchar* _tmp2_;
	GtkSourceStyleScheme* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scheme_id != NULL);
	_tmp0_ = gtk_source_style_scheme_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	manager = _tmp1_;
	_tmp2_ = scheme_id;
	_tmp3_ = gtk_source_style_scheme_manager_get_scheme (manager, _tmp2_);
	gtk_source_buffer_set_style_scheme ((GtkSourceBuffer*) self, _tmp3_);
	_g_object_unref0 (manager);
}


void document_comment_selected_lines (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_;
	GtkTextIter _tmp3_;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = start;
	_tmp3_ = end;
	document_comment_between (self, &_tmp2_, &_tmp3_, TRUE);
}


void document_comment_between (Document* self, GtkTextIter* start_iter, GtkTextIter* end_iter, gboolean end_iter_set) {
	gint start_line;
	gint _tmp0_;
	gint end_line;
	gint _tmp1_;
	gboolean _tmp2_;
	GtkTextIter cur_iter = {0};
	gint _tmp4_;
	GtkTextIter _tmp5_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (start_iter != NULL);
	g_return_if_fail (end_iter != NULL);
	_tmp0_ = gtk_text_iter_get_line (start_iter);
	start_line = _tmp0_;
	_tmp1_ = start_line;
	end_line = _tmp1_;
	_tmp2_ = end_iter_set;
	if (_tmp2_) {
		gint _tmp3_;
		_tmp3_ = gtk_text_iter_get_line (end_iter);
		end_line = _tmp3_;
	}
	_tmp4_ = start_line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
	cur_iter = _tmp5_;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint line_num;
		gint _tmp6_;
		_tmp6_ = start_line;
		line_num = _tmp6_;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				gint _tmp10_;
				gboolean _tmp11_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = line_num;
					line_num = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = line_num;
				_tmp10_ = end_line;
				if (!(_tmp9_ <= _tmp10_)) {
					break;
				}
				_tmp11_ = gtk_text_iter_ends_line (&cur_iter);
				if (_tmp11_) {
					document_insert (self, &cur_iter, "%", -1);
				} else {
					document_insert (self, &cur_iter, "% ", -1);
				}
				gtk_text_iter_forward_line (&cur_iter);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}


void document_uncomment_selected_lines (Document* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gint start_line;
	gint _tmp2_;
	gint end_line;
	gint _tmp3_;
	gint line_count;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
	start = _tmp0_;
	end = _tmp1_;
	_tmp2_ = gtk_text_iter_get_line (&start);
	start_line = _tmp2_;
	_tmp3_ = gtk_text_iter_get_line (&end);
	end_line = _tmp3_;
	_tmp4_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
	line_count = _tmp4_;
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
	{
		gint i;
		gint _tmp5_;
		_tmp5_ = start_line;
		i = _tmp5_;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				GtkTextIter _tmp11_ = {0};
				gint _tmp12_;
				gint _tmp13_;
				gchar* line;
				GtkTextIter _tmp17_;
				GtkTextIter _tmp18_;
				gchar* _tmp19_;
				gint j;
				gint start_delete;
				gint stop_delete;
				gint _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				GtkTextIter _tmp43_ = {0};
				gint _tmp44_;
				gint _tmp45_;
				GtkTextIter _tmp46_ = {0};
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = i;
				_tmp9_ = end_line;
				if (!(_tmp8_ <= _tmp9_)) {
					break;
				}
				_tmp10_ = i;
				gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp11_, _tmp10_);
				start = _tmp11_;
				_tmp12_ = i;
				_tmp13_ = line_count;
				if (_tmp12_ == (_tmp13_ - 1)) {
					GtkTextIter _tmp14_ = {0};
					gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp14_);
					end = _tmp14_;
				} else {
					gint _tmp15_;
					GtkTextIter _tmp16_ = {0};
					_tmp15_ = i;
					gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp16_, _tmp15_ + 1);
					end = _tmp16_;
				}
				_tmp17_ = start;
				_tmp18_ = end;
				_tmp19_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp17_, &_tmp18_, FALSE);
				line = _tmp19_;
				j = 0;
				start_delete = -1;
				stop_delete = -1;
				while (TRUE) {
					const gchar* _tmp20_;
					gint _tmp21_;
					gchar _tmp22_;
					const gchar* _tmp23_;
					gint _tmp24_;
					gchar _tmp25_;
					gint _tmp39_;
					_tmp20_ = line;
					_tmp21_ = j;
					_tmp22_ = string_get (_tmp20_, (glong) _tmp21_);
					if (!(_tmp22_ != '\0')) {
						break;
					}
					_tmp23_ = line;
					_tmp24_ = j;
					_tmp25_ = string_get (_tmp23_, (glong) _tmp24_);
					if (_tmp25_ == '%') {
						gint _tmp26_;
						gint _tmp27_;
						const gchar* _tmp28_;
						gint _tmp29_;
						gchar _tmp30_;
						_tmp26_ = j;
						start_delete = _tmp26_;
						_tmp27_ = j;
						stop_delete = _tmp27_ + 1;
						_tmp28_ = line;
						_tmp29_ = j;
						_tmp30_ = string_get (_tmp28_, (glong) (_tmp29_ + 1));
						if (_tmp30_ == ' ') {
							gint _tmp31_;
							_tmp31_ = stop_delete;
							stop_delete = _tmp31_ + 1;
						}
						break;
					} else {
						gboolean _tmp32_ = FALSE;
						const gchar* _tmp33_;
						gint _tmp34_;
						gchar _tmp35_;
						_tmp33_ = line;
						_tmp34_ = j;
						_tmp35_ = string_get (_tmp33_, (glong) _tmp34_);
						if (_tmp35_ != ' ') {
							const gchar* _tmp36_;
							gint _tmp37_;
							gchar _tmp38_;
							_tmp36_ = line;
							_tmp37_ = j;
							_tmp38_ = string_get (_tmp36_, (glong) _tmp37_);
							_tmp32_ = _tmp38_ != '\t';
						} else {
							_tmp32_ = FALSE;
						}
						if (_tmp32_) {
							break;
						}
					}
					_tmp39_ = j;
					j = _tmp39_ + 1;
				}
				_tmp40_ = start_delete;
				if (_tmp40_ == -1) {
					g_free (line);
					continue;
				}
				_tmp41_ = i;
				_tmp42_ = start_delete;
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp43_, _tmp41_, _tmp42_);
				start = _tmp43_;
				_tmp44_ = i;
				_tmp45_ = stop_delete;
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp46_, _tmp44_, _tmp45_);
				end = _tmp46_;
				gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
				g_free (line);
			}
		}
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
}


void document_select_lines (Document* self, gint start, gint end) {
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	gint _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gint _tmp2_;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	DocumentTab* _tmp6_;
	DocumentView* _tmp7_;
	DocumentView* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = start;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp1_, _tmp0_);
	start_iter = _tmp1_;
	_tmp2_ = end;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp3_, _tmp2_);
	end_iter = _tmp3_;
	_tmp4_ = start_iter;
	_tmp5_ = end_iter;
	gtk_text_buffer_select_range ((GtkTextBuffer*) self, &_tmp4_, &_tmp5_);
	_tmp6_ = self->tab;
	_tmp7_ = document_tab_get_view (_tmp6_);
	_tmp8_ = _tmp7_;
	document_view_scroll_to_cursor (_tmp8_, 0.25);
}


SelectionType document_get_selection_type (Document* self) {
	SelectionType result = 0;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_ = {0};
	gint _tmp4_;
	gint _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = gtk_text_buffer_get_has_selection ((GtkTextBuffer*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = SELECTION_TYPE_NO_SELECTION;
		return result;
	}
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp2_, &_tmp3_);
	start = _tmp2_;
	end = _tmp3_;
	_tmp4_ = gtk_text_iter_get_line (&start);
	_tmp5_ = gtk_text_iter_get_line (&end);
	if (_tmp4_ == _tmp5_) {
		result = SELECTION_TYPE_ONE_LINE;
		return result;
	}
	result = SELECTION_TYPE_MULTIPLE_LINES;
	return result;
}


gboolean document_goto_line (Document* self, gint line) {
	gboolean result = FALSE;
	gint _tmp0_;
	gboolean ret;
	GtkTextIter iter = {0};
	gint _tmp1_;
	gint _tmp2_;
	GtkTextIter _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = line;
	g_return_val_if_fail (_tmp0_ >= -1, FALSE);
	ret = TRUE;
	_tmp1_ = line;
	_tmp2_ = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
	if (_tmp1_ >= _tmp2_) {
		GtkTextIter _tmp3_ = {0};
		ret = FALSE;
		gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp3_);
		iter = _tmp3_;
	} else {
		gint _tmp4_;
		GtkTextIter _tmp5_ = {0};
		_tmp4_ = line;
		gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp5_, _tmp4_);
		iter = _tmp5_;
	}
	_tmp6_ = iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp6_);
	result = ret;
	return result;
}


Project* document_get_project (Document* self) {
	Project* result = NULL;
	gint _tmp0_;
	Projects* _tmp1_;
	Projects* _tmp2_;
	gint _tmp3_;
	Project* _tmp4_;
	Project* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_project_id;
	if (_tmp0_ == -1) {
		result = NULL;
		return result;
	}
	_tmp1_ = projects_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_project_id;
	_tmp4_ = projects_get (_tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	_projects_unref0 (_tmp2_);
	result = _tmp5_;
	return result;
}


GFile* document_get_main_file (Document* self) {
	GFile* result = NULL;
	GFile* _tmp0_;
	Project* project;
	Project* _tmp1_;
	Project* _tmp2_;
	Project* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = document_get_project (self);
	project = _tmp1_;
	_tmp2_ = project;
	if (_tmp2_ == NULL) {
		GFile* _tmp3_;
		GFile* _tmp4_;
		_tmp3_ = self->priv->_location;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		result = _tmp4_;
		_project_free0 (project);
		return result;
	}
	_tmp5_ = project;
	_tmp6_ = (*_tmp5_).main_file;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	_project_free0 (project);
	return result;
}


gboolean document_is_main_file_a_tex_file (Document* self) {
	gboolean result = FALSE;
	GFile* main_file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* path;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = document_get_main_file (self);
	main_file = _tmp0_;
	_tmp1_ = main_file;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (main_file);
		return result;
	}
	_tmp2_ = main_file;
	_tmp3_ = g_file_get_parse_name (_tmp2_);
	path = _tmp3_;
	_tmp4_ = path;
	_tmp5_ = g_str_has_suffix (_tmp4_, ".tex");
	result = _tmp5_;
	g_free (path);
	_g_object_unref0 (main_file);
	return result;
}


static gboolean string_get_next_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_;
	gunichar _tmp1_;
	gunichar _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	_vala_c = _tmp1_;
	_tmp2_ = _vala_c;
	if (_tmp2_ != ((gunichar) 0)) {
		gint _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = *index;
		_tmp4_ = g_utf8_next_char (((gchar*) self) + _tmp3_);
		*index = (gint) (_tmp4_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gchar* g_unichar_to_string (gunichar self) {
	gchar* result = NULL;
	gchar* str;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	_tmp0_ = g_new0 (gchar, 7);
	str = (gchar*) _tmp0_;
	_tmp1_ = str;
	g_unichar_to_utf8 (self, _tmp1_);
	result = str;
	return result;
}


gchar* document_get_current_indentation (Document* self, GtkTextIter* iter) {
	gchar* result = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	gint line;
	gint _tmp0_;
	gint _tmp1_;
	GtkTextIter _tmp2_ = {0};
	gint _tmp3_;
	GtkTextIter _tmp4_ = {0};
	gchar* text;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_;
	gchar* current_indent;
	gchar* _tmp8_;
	gint index;
	gunichar cur_char = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_line (iter);
	line = _tmp0_;
	_tmp1_ = line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp2_, _tmp1_);
	start_iter = _tmp2_;
	_tmp3_ = line;
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp4_, _tmp3_ + 1);
	end_iter = _tmp4_;
	_tmp5_ = start_iter;
	_tmp6_ = end_iter;
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
	text = _tmp7_;
	_tmp8_ = g_strdup ("");
	current_indent = _tmp8_;
	index = 0;
	while (TRUE) {
		const gchar* _tmp9_;
		gunichar _tmp10_ = 0U;
		gboolean _tmp11_;
		gboolean _tmp12_ = FALSE;
		gunichar _tmp13_;
		_tmp9_ = text;
		_tmp11_ = string_get_next_char (_tmp9_, &index, &_tmp10_);
		cur_char = _tmp10_;
		if (!_tmp11_) {
			break;
		}
		_tmp13_ = cur_char;
		if (_tmp13_ == ((gunichar) ' ')) {
			_tmp12_ = TRUE;
		} else {
			gunichar _tmp14_;
			_tmp14_ = cur_char;
			_tmp12_ = _tmp14_ == ((gunichar) '\t');
		}
		if (_tmp12_) {
			const gchar* _tmp15_;
			gunichar _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp15_ = current_indent;
			_tmp16_ = cur_char;
			_tmp17_ = g_unichar_to_string (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
			g_free (current_indent);
			current_indent = _tmp19_;
			g_free (_tmp18_);
		} else {
			break;
		}
	}
	result = current_indent;
	g_free (text);
	return result;
}


DocumentStructure* document_get_structure (Document* self) {
	DocumentStructure* result = NULL;
	DocumentStructure* _tmp0_;
	DocumentStructure* _tmp3_;
	DocumentStructure* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_structure;
	if (_tmp0_ == NULL) {
		DocumentStructure* _tmp1_;
		DocumentStructure* _tmp2_;
		_tmp1_ = document_structure_new (self);
		_g_object_unref0 (self->priv->_structure);
		self->priv->_structure = _tmp1_;
		_tmp2_ = self->priv->_structure;
		document_structure_parse (_tmp2_);
	}
	_tmp3_ = self->priv->_structure;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	return result;
}


static Block17Data* block17_data_ref (Block17Data* _data17_) {
	g_atomic_int_inc (&_data17_->_ref_count_);
	return _data17_;
}


static void block17_data_unref (void * _userdata_) {
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
		Document* self;
		self = _data17_->self;
		_g_object_unref0 (_data17_->infobar);
		_g_object_unref0 (self);
		g_slice_free (Block17Data, _data17_);
	}
}


static void __lambda26_ (Block17Data* _data17_, gint response_id) {
	Document* self;
	gint _tmp0_;
	TabInfoBar* _tmp5_;
	self = _data17_->self;
	_tmp0_ = response_id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_YES)) {
		MainWindow* main_window;
		DocumentTab* _tmp1_;
		GtkWindow* _tmp2_;
		MainWindow* _tmp3_;
		_tmp1_ = self->tab;
		_tmp2_ = utils_get_toplevel_window ((GtkWidget*) _tmp1_);
		main_window = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp2_) : NULL;
		_tmp3_ = main_window;
		if (_tmp3_ != NULL) {
			MainWindow* _tmp4_;
			_tmp4_ = main_window;
			main_window_save_document (_tmp4_, self, TRUE);
		}
	}
	_tmp5_ = _data17_->infobar;
	gtk_widget_destroy ((GtkWidget*) _tmp5_);
}


static void ___lambda26__gtk_info_bar_response (GtkInfoBar* _sender, gint response_id, gpointer self) {
	__lambda26_ (self, response_id);
}


gboolean document_set_tmp_location (Document* self) {
	gboolean result = FALSE;
	Block17Data* _data17_;
	gchar* template;
	gchar* _tmp0_;
	gchar* tmp_dir = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	DocumentTab* _tmp12_;
	TabInfoBar* _tmp13_;
	TabInfoBar* _tmp14_;
	TabInfoBar* _tmp15_;
	TabInfoBar* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_data17_ = g_slice_new0 (Block17Data);
	_data17_->_ref_count_ = 1;
	_data17_->self = g_object_ref (self);
	_tmp0_ = g_strdup ("latexila-XXXXXX");
	template = _tmp0_;
	{
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = template;
		_tmp3_ = g_dir_make_tmp (_tmp2_, &_inner_error_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch14_g_file_error;
			}
			g_free (tmp_dir);
			g_free (template);
			block17_data_unref (_data17_);
			_data17_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		g_free (tmp_dir);
		tmp_dir = _tmp4_;
		g_free (_tmp1_);
	}
	goto __finally14;
	__catch14_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("document.vala:584: Impossible to create temporary directory: %s", _tmp6_);
		result = FALSE;
		_g_error_free0 (e);
		g_free (tmp_dir);
		g_free (template);
		block17_data_unref (_data17_);
		_data17_ = NULL;
		return result;
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_free (tmp_dir);
		g_free (template);
		block17_data_unref (_data17_);
		_data17_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp7_ = tmp_dir;
	_tmp8_ = g_build_filename (_tmp7_, "tmp.tex", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_new_for_path (_tmp9_);
	_tmp11_ = _tmp10_;
	document_set_location (self, _tmp11_);
	_g_object_unref0 (_tmp11_);
	g_free (_tmp9_);
	_tmp12_ = self->tab;
	_tmp13_ = document_tab_add_message (_tmp12_, _ ("The file has a temporary location. The data can be lost after rebootin" \
"g your computer."), _ ("Do you want to save the file in a safer place?"), GTK_MESSAGE_WARNING);
	_data17_->infobar = _tmp13_;
	_tmp14_ = _data17_->infobar;
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp14_, _ ("Save _As"), (gint) GTK_RESPONSE_YES);
	_tmp15_ = _data17_->infobar;
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp15_, _ ("Cancel"), (gint) GTK_RESPONSE_NO);
	_tmp16_ = _data17_->infobar;
	g_signal_connect_data ((GtkInfoBar*) _tmp16_, "response", (GCallback) ___lambda26__gtk_info_bar_response, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
	result = TRUE;
	g_free (tmp_dir);
	g_free (template);
	block17_data_unref (_data17_);
	_data17_ = NULL;
	return result;
}


static void document_save_metadata (Document* self) {
	GFileInfo* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_metadata_info;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_location;
	if (_tmp1_ == NULL) {
		return;
	}
	{
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
		_tmp2_ = self->priv->_location;
		_tmp3_ = self->priv->_metadata_info;
		g_file_set_attributes_from_info (_tmp2_, _tmp3_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_warning ("document.vala:632: Set document metadata failed: %s", _tmp5_);
		_g_error_free0 (_error_);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void document_set_metadata (Document* self, const gchar* key, const gchar* val) {
	GFileInfo* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = self->priv->_metadata_info;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = val;
	if (_tmp1_ != NULL) {
		GFileInfo* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->_metadata_info;
		_tmp3_ = key;
		_tmp4_ = val;
		g_file_info_set_attribute_string (_tmp2_, _tmp3_, _tmp4_);
	} else {
		GFileInfo* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = self->priv->_metadata_info;
		_tmp6_ = key;
		g_file_info_set_attribute (_tmp5_, _tmp6_, G_FILE_ATTRIBUTE_TYPE_INVALID, NULL);
	}
	document_save_metadata (self);
}


gchar* document_get_metadata (Document* self, const gchar* key) {
	gchar* result = NULL;
	GFileInfo* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GFileInfo* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->_metadata_info;
	g_return_val_if_fail (_tmp0_ != NULL, NULL);
	_tmp2_ = self->priv->_metadata_info;
	_tmp3_ = key;
	_tmp4_ = g_file_info_has_attribute (_tmp2_, _tmp3_);
	if (_tmp4_) {
		GFileInfo* _tmp5_;
		const gchar* _tmp6_;
		GFileAttributeType _tmp7_;
		_tmp5_ = self->priv->_metadata_info;
		_tmp6_ = key;
		_tmp7_ = g_file_info_get_attribute_type (_tmp5_, _tmp6_);
		_tmp1_ = _tmp7_ == G_FILE_ATTRIBUTE_TYPE_STRING;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GFileInfo* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = self->priv->_metadata_info;
		_tmp9_ = key;
		_tmp10_ = g_file_info_get_attribute_string (_tmp8_, _tmp9_);
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
	result = NULL;
	return result;
}


GFile* document_get_location (Document* self) {
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_location;
	result = _tmp0_;
	return result;
}


void document_set_location (Document* self, GFile* value) {
	g_return_if_fail (self != NULL);
	if (document_get_location (self) != value) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = value;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (self->priv->_location);
		self->priv->_location = _tmp1_;
		g_object_notify ((GObject *) self, "location");
	}
}


gboolean document_get_readonly (Document* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_readonly;
	result = _tmp0_;
	return result;
}


void document_set_readonly (Document* self, gboolean value) {
	g_return_if_fail (self != NULL);
	if (document_get_readonly (self) != value) {
		gboolean _tmp0_;
		_tmp0_ = value;
		self->priv->_readonly = _tmp0_;
		g_object_notify ((GObject *) self, "readonly");
	}
}


gint document_get_project_id (Document* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_project_id;
	result = _tmp0_;
	return result;
}


void document_set_project_id (Document* self, gint value) {
	g_return_if_fail (self != NULL);
	if (document_get_project_id (self) != value) {
		gint _tmp0_;
		_tmp0_ = value;
		self->priv->_project_id = _tmp0_;
		g_object_notify ((GObject *) self, "project-id");
	}
}


static void document_class_init (DocumentClass * klass) {
	document_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_document_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_document_set_property;
	G_OBJECT_CLASS (klass)->finalize = document_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_LOCATION, g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_READONLY, g_param_spec_boolean ("readonly", "readonly", "readonly", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_PROJECT_ID, g_param_spec_int ("project-id", "project-id", "project-id", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	document_signals[DOCUMENT_CURSOR_MOVED_SIGNAL] = g_signal_new ("cursor_moved", TYPE_DOCUMENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void document_instance_init (Document * self) {
	GFileInfo* _tmp0_;
	self->priv = DOCUMENT_GET_PRIVATE (self);
	self->priv->_readonly = FALSE;
	self->_unsaved_doc_num = (guint) 0;
	self->priv->_project_id = -1;
	self->priv->backup_made = FALSE;
	self->priv->encoding = NULL;
	self->priv->new_file = TRUE;
	self->priv->_structure = NULL;
	_tmp0_ = g_file_info_new ();
	self->priv->_metadata_info = _tmp0_;
}


static void document_finalize (GObject * obj) {
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT, Document);
	_g_object_unref0 (self->priv->_location);
	_g_object_unref0 (self->tab);
	g_free (self->priv->_etag);
	g_free (self->priv->encoding);
	_g_object_unref0 (self->priv->_structure);
	_g_object_unref0 (self->priv->_metadata_info);
	G_OBJECT_CLASS (document_parent_class)->finalize (obj);
}


GType document_get_type (void) {
	static volatile gsize document_type_id__volatile = 0;
	if (g_once_init_enter (&document_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Document), 0, (GInstanceInitFunc) document_instance_init, NULL };
		GType document_type_id;
		document_type_id = g_type_register_static (gtk_source_buffer_get_type (), "Document", &g_define_type_info, 0);
		g_once_init_leave (&document_type_id__volatile, document_type_id);
	}
	return document_type_id__volatile;
}


static void _vala_document_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
	switch (property_id) {
		case DOCUMENT_LOCATION:
		g_value_set_object (value, document_get_location (self));
		break;
		case DOCUMENT_READONLY:
		g_value_set_boolean (value, document_get_readonly (self));
		break;
		case DOCUMENT_PROJECT_ID:
		g_value_set_int (value, document_get_project_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_document_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
	switch (property_id) {
		case DOCUMENT_LOCATION:
		document_set_location (self, g_value_get_object (value));
		break;
		case DOCUMENT_READONLY:
		document_set_readonly (self, g_value_get_boolean (value));
		break;
		case DOCUMENT_PROJECT_ID:
		document_set_project_id (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



