/* search.c generated by valac 0.36.5, the Vala compiler
 * generated from search.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <tepl/tepl.h>
#include <gtksourceview/gtksource.h>


#define TYPE_GOTO_LINE (goto_line_get_type ())
#define GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GOTO_LINE, GotoLine))
#define GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GOTO_LINE, GotoLineClass))
#define IS_GOTO_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GOTO_LINE))
#define IS_GOTO_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GOTO_LINE))
#define GOTO_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GOTO_LINE, GotoLineClass))

typedef struct _GotoLine GotoLine;
typedef struct _GotoLineClass GotoLineClass;
typedef struct _GotoLinePrivate GotoLinePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;
typedef struct _SearchAndReplacePrivate SearchAndReplacePrivate;

#define SEARCH_AND_REPLACE_TYPE_MODE (search_and_replace_mode_get_type ())
typedef struct _Block30Data Block30Data;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block31Data Block31Data;

struct _GotoLine {
	GtkGrid parent_instance;
	GotoLinePrivate * priv;
};

struct _GotoLineClass {
	GtkGridClass parent_class;
};

struct _GotoLinePrivate {
	MainWindow* main_window;
	GtkEntry* entry;
};

struct _SearchAndReplace {
	GObject parent_instance;
	SearchAndReplacePrivate * priv;
};

struct _SearchAndReplaceClass {
	GObjectClass parent_class;
};

struct _SearchAndReplacePrivate {
	MainWindow* _main_window;
	GtkGrid* _main_grid;
	GtkGrid* _replace_grid;
	GtkArrow* _arrow;
	GtkSearchEntry* _entry_find;
	GtkSearchEntry* _entry_replace;
	GtkLabel* _info_label;
	GtkSourceSearchSettings* _search_settings;
	GtkSourceSearchContext* _search_context;
};

typedef enum  {
	SEARCH_AND_REPLACE_MODE_SEARCH,
	SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE
} SearchAndReplaceMode;

struct _Block30Data {
	int _ref_count_;
	SearchAndReplace* self;
	GtkButton* button_previous;
	GtkButton* button_next;
	GtkButton* button_replace;
	GtkButton* button_replace_all;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _Block31Data {
	int _ref_count_;
	SearchAndReplace* self;
	GtkMenu* menu;
};


static gpointer goto_line_parent_class = NULL;
static gpointer search_and_replace_parent_class = NULL;

GType goto_line_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define GOTO_LINE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GOTO_LINE, GotoLinePrivate))
enum  {
	GOTO_LINE_DUMMY_PROPERTY
};
GotoLine* goto_line_new (MainWindow* main_window);
GotoLine* goto_line_construct (GType object_type, MainWindow* main_window);
static void __lambda54_ (GotoLine* self);
static void ___lambda54__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda55_ (GotoLine* self);
static void ___lambda55__gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda56_ (GotoLine* self);
static void ___lambda56__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void goto_line_on_changed (GotoLine* self);
static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
void goto_line_show (GotoLine* self);
void error_entry_remove_error (GtkWidget* widget);
void error_entry_add_error (GtkWidget* widget);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
static void goto_line_finalize (GObject * obj);
GType search_and_replace_get_type (void) G_GNUC_CONST;
#define SEARCH_AND_REPLACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SEARCH_AND_REPLACE, SearchAndReplacePrivate))
enum  {
	SEARCH_AND_REPLACE_DUMMY_PROPERTY
};
static GType search_and_replace_mode_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static SearchAndReplaceMode search_and_replace_get_mode (SearchAndReplace* self);
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static void search_and_replace_init_find_entry (SearchAndReplace* self);
static GtkButton* search_and_replace_get_button (SearchAndReplace* self, const gchar* icon_name);
static void __lambda58_ (SearchAndReplace* self);
static void ___lambda58__gtk_button_clicked (GtkButton* _sender, gpointer self);
void search_and_replace_hide (SearchAndReplace* self);
static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda60_ (SearchAndReplace* self);
GType document_get_type (void) G_GNUC_CONST;
GType document_tab_get_type (void) G_GNUC_CONST;
TeplView* tepl_tab_get_view (TeplTab* self);
static void ___lambda60__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void search_and_replace_search_forward (SearchAndReplace* self);
static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda61_ (Block30Data* _data30_);
static void ___lambda61__gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void search_and_replace_replace (SearchAndReplace* self);
static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void __lambda62_ (SearchAndReplace* self);
static void ___lambda62__gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean __lambda63_ (SearchAndReplace* self, GdkEventKey* event);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
static gboolean ___lambda63__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void __lambda57_ (Block31Data* _data31_, GtkEntryIconPosition icon_pos, GdkEvent* event);
static void ___lambda57__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
void search_and_replace_show_search (SearchAndReplace* self);
static void search_and_replace_show (SearchAndReplace* self);
DocumentTab* main_window_get_active_tab (MainWindow* self);
Document* main_window_get_active_document (MainWindow* self);
static void search_and_replace_connect_active_document (SearchAndReplace* self);
static void _search_and_replace_connect_active_document_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void search_and_replace_destroy_search_context (SearchAndReplace* self);
static void search_and_replace_mark_set_cb (SearchAndReplace* self, GtkTextBuffer* buffer, GtkTextIter* location, GtkTextMark* mark);
static void _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self);
static void __lambda59_ (SearchAndReplace* self);
static void search_and_replace_update_info_label (SearchAndReplace* self);
static void ___lambda59__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean document_get_readonly (Document* self);
static void search_and_replace_finalize (GObject * obj);


static void __lambda54_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda54__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda54_ ((GotoLine*) self);
}


static void __lambda55_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda55__gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	__lambda55_ ((GotoLine*) self);
}


static void __lambda56_ (GotoLine* self) {
	gtk_widget_hide ((GtkWidget*) self);
}


static void ___lambda56__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	__lambda56_ ((GotoLine*) self);
}


static void _goto_line_on_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	goto_line_on_changed ((GotoLine*) self);
}


GotoLine* goto_line_construct (GType object_type, MainWindow* main_window) {
	GotoLine * self = NULL;
	MainWindow* _tmp0_;
	GtkButton* close_button = NULL;
	GtkButton* _tmp1_;
	GtkImage* img = NULL;
	GtkImage* _tmp2_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp3_;
	GtkEntry* _tmp4_;
	GtkEntry* _tmp5_;
	GIcon* icon = NULL;
	GThemedIcon* _tmp6_;
	GtkEntry* _tmp7_;
	GtkEntry* _tmp8_;
	GtkEntry* _tmp9_;
	GtkEntry* _tmp10_;
	GtkEntry* _tmp11_;
	GtkEntry* _tmp12_;
	GtkEntry* _tmp13_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (GotoLine*) g_object_new (object_type, NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing ((GtkGrid*) self, (guint) 3);
	_tmp0_ = main_window;
	self->priv->main_window = _tmp0_;
	_tmp1_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp1_);
	close_button = _tmp1_;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) close_button);
	gtk_button_set_relief (close_button, GTK_RELIEF_NONE);
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name ("window-close", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp2_);
	img = _tmp2_;
	gtk_container_add ((GtkContainer*) close_button, (GtkWidget*) img);
	g_signal_connect_object (close_button, "clicked", (GCallback) ___lambda54__gtk_button_clicked, self, 0);
	_tmp3_ = (GtkLabel*) gtk_label_new (_ ("Go to Line:"));
	g_object_ref_sink (_tmp3_);
	label = _tmp3_;
	gtk_widget_set_margin_start ((GtkWidget*) label, 2);
	gtk_widget_set_margin_end ((GtkWidget*) label, 2);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) label);
	_tmp4_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->entry);
	self->priv->entry = _tmp4_;
	_tmp5_ = self->priv->entry;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp5_);
	_tmp6_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("go-jump-symbolic");
	icon = (GIcon*) _tmp6_;
	_tmp7_ = self->priv->entry;
	gtk_entry_set_icon_from_gicon (_tmp7_, GTK_ENTRY_ICON_SECONDARY, icon);
	_tmp8_ = self->priv->entry;
	gtk_entry_set_icon_activatable (_tmp8_, GTK_ENTRY_ICON_SECONDARY, TRUE);
	_tmp9_ = self->priv->entry;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp9_, _ ("Line you want to move the cursor to"));
	_tmp10_ = self->priv->entry;
	gtk_widget_set_size_request ((GtkWidget*) _tmp10_, 100, -1);
	_tmp11_ = self->priv->entry;
	g_signal_connect_object (_tmp11_, "activate", (GCallback) ___lambda55__gtk_entry_activate, self, 0);
	_tmp12_ = self->priv->entry;
	g_signal_connect_object (_tmp12_, "icon-press", (GCallback) ___lambda56__gtk_entry_icon_press, self, 0);
	_tmp13_ = self->priv->entry;
	g_signal_connect_object ((GtkEditable*) _tmp13_, "changed", (GCallback) _goto_line_on_changed_gtk_editable_changed, self, 0);
	_g_object_unref0 (icon);
	_g_object_unref0 (label);
	_g_object_unref0 (img);
	_g_object_unref0 (close_button);
	return self;
}


GotoLine* goto_line_new (MainWindow* main_window) {
	return goto_line_construct (TYPE_GOTO_LINE, main_window);
}


void goto_line_show (GotoLine* self) {
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	gtk_entry_set_text (_tmp0_, "");
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp1_ = self->priv->entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp1_);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static void goto_line_on_changed (GotoLine* self) {
	GtkEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gchar* text = NULL;
	GtkEntry* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gint line = 0;
	const gchar* _tmp19_;
	gint _tmp20_;
	MainWindow* _tmp21_;
	DocumentView* _tmp22_;
	DocumentView* _tmp23_;
	gint _tmp24_;
	gboolean _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->entry;
	_tmp1_ = gtk_entry_get_text_length (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == ((guint) 0)) {
		GtkEntry* _tmp3_;
		_tmp3_ = self->priv->entry;
		error_entry_remove_error ((GtkWidget*) _tmp3_);
		return;
	}
	_tmp4_ = self->priv->entry;
	_tmp5_ = gtk_entry_get_text (_tmp4_);
	_tmp6_ = g_strdup (_tmp5_);
	text = _tmp6_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gint _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gunichar c = 0U;
				const gchar* _tmp13_;
				gint _tmp14_;
				gchar _tmp15_;
				gunichar _tmp16_;
				gboolean _tmp17_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp9_ = i;
				_tmp10_ = text;
				_tmp11_ = strlen (_tmp10_);
				_tmp12_ = _tmp11_;
				if (!(_tmp9_ < _tmp12_)) {
					break;
				}
				_tmp13_ = text;
				_tmp14_ = i;
				_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
				c = (gunichar) _tmp15_;
				_tmp16_ = c;
				_tmp17_ = g_unichar_isdigit (_tmp16_);
				if (!_tmp17_) {
					GtkEntry* _tmp18_;
					_tmp18_ = self->priv->entry;
					error_entry_add_error ((GtkWidget*) _tmp18_);
					_g_free0 (text);
					return;
				}
			}
		}
	}
	_tmp19_ = text;
	_tmp20_ = atoi (_tmp19_);
	line = _tmp20_ - 1;
	_tmp21_ = self->priv->main_window;
	_tmp22_ = main_window_get_active_view (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = line;
	_tmp25_ = tepl_view_goto_line ((TeplView*) _tmp23_, _tmp24_);
	if (_tmp25_) {
		GtkEntry* _tmp26_;
		_tmp26_ = self->priv->entry;
		error_entry_remove_error ((GtkWidget*) _tmp26_);
	} else {
		GtkEntry* _tmp27_;
		_tmp27_ = self->priv->entry;
		error_entry_add_error ((GtkWidget*) _tmp27_);
	}
	_g_free0 (text);
}


static void goto_line_class_init (GotoLineClass * klass) {
	goto_line_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GotoLinePrivate));
	G_OBJECT_CLASS (klass)->finalize = goto_line_finalize;
}


static void goto_line_instance_init (GotoLine * self) {
	self->priv = GOTO_LINE_GET_PRIVATE (self);
}


static void goto_line_finalize (GObject * obj) {
	GotoLine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GOTO_LINE, GotoLine);
	_g_object_unref0 (self->priv->entry);
	G_OBJECT_CLASS (goto_line_parent_class)->finalize (obj);
}


GType goto_line_get_type (void) {
	static volatile gsize goto_line_type_id__volatile = 0;
	if (g_once_init_enter (&goto_line_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GotoLineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) goto_line_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GotoLine), 0, (GInstanceInitFunc) goto_line_instance_init, NULL };
		GType goto_line_type_id;
		goto_line_type_id = g_type_register_static (gtk_grid_get_type (), "GotoLine", &g_define_type_info, 0);
		g_once_init_leave (&goto_line_type_id__volatile, goto_line_type_id);
	}
	return goto_line_type_id__volatile;
}


static GType search_and_replace_mode_get_type (void) {
	static volatile gsize search_and_replace_mode_type_id__volatile = 0;
	if (g_once_init_enter (&search_and_replace_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{SEARCH_AND_REPLACE_MODE_SEARCH, "SEARCH_AND_REPLACE_MODE_SEARCH", "search"}, {SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE, "SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE", "search-and-replace"}, {0, NULL, NULL}};
		GType search_and_replace_mode_type_id;
		search_and_replace_mode_type_id = g_enum_register_static ("SearchAndReplaceMode", values);
		g_once_init_leave (&search_and_replace_mode_type_id__volatile, search_and_replace_mode_type_id);
	}
	return search_and_replace_mode_type_id__volatile;
}


static SearchAndReplaceMode search_and_replace_get_mode (SearchAndReplace* self) {
	SearchAndReplaceMode result = 0;
	SearchAndReplaceMode _tmp0_ = 0;
	GtkArrow* _tmp1_;
	GtkArrowType _tmp2_;
	GtkArrowType _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->_arrow;
	g_object_get (_tmp1_, "arrow-type", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GTK_ARROW_UP) {
		_tmp0_ = SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE;
	} else {
		_tmp0_ = SEARCH_AND_REPLACE_MODE_SEARCH;
	}
	result = _tmp0_;
	return result;
}


static Block30Data* block30_data_ref (Block30Data* _data30_) {
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}


static void block30_data_unref (void * _userdata_) {
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		SearchAndReplace* self;
		self = _data30_->self;
		_g_object_unref0 (_data30_->button_replace_all);
		_g_object_unref0 (_data30_->button_replace);
		_g_object_unref0 (_data30_->button_next);
		_g_object_unref0 (_data30_->button_previous);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}


static void __lambda58_ (SearchAndReplace* self) {
	SearchAndReplaceMode _tmp0_;
	_tmp0_ = search_and_replace_get_mode (self);
	if (_tmp0_ == SEARCH_AND_REPLACE_MODE_SEARCH_AND_REPLACE) {
		GtkArrow* _tmp1_;
		GtkGrid* _tmp2_;
		_tmp1_ = self->priv->_arrow;
		g_object_set (_tmp1_, "arrow-type", GTK_ARROW_DOWN, NULL);
		_tmp2_ = self->priv->_replace_grid;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
	} else {
		GtkArrow* _tmp3_;
		GtkGrid* _tmp4_;
		_tmp3_ = self->priv->_arrow;
		g_object_set (_tmp3_, "arrow-type", GTK_ARROW_UP, NULL);
		_tmp4_ = self->priv->_replace_grid;
		gtk_widget_show ((GtkWidget*) _tmp4_);
	}
}


static void ___lambda58__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda58_ ((SearchAndReplace*) self);
}


static void _search_and_replace_hide_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_hide ((SearchAndReplace*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda60_ (SearchAndReplace* self) {
	GtkSourceSearchContext* _tmp0_;
	GtkTextIter iter = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	Document* doc = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkSourceSearchContext* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gboolean _tmp10_;
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_DOCUMENT) ? ((Document*) _tmp2_) : NULL);
	doc = _tmp3_;
	_tmp4_ = doc;
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, &_tmp5_, NULL);
	iter = _tmp5_;
	_tmp6_ = self->priv->_search_context;
	_tmp7_ = iter;
	_tmp10_ = gtk_source_search_context_backward2 (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, NULL);
	match_start = _tmp8_;
	match_end = _tmp9_;
	if (_tmp10_) {
		Document* _tmp11_;
		GtkTextIter _tmp12_;
		GtkTextIter _tmp13_;
		Document* _tmp14_;
		DocumentTab* _tmp15_;
		TeplView* _tmp16_;
		TeplView* _tmp17_;
		_tmp11_ = doc;
		_tmp12_ = match_start;
		_tmp13_ = match_end;
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
		_tmp14_ = doc;
		_tmp15_ = _tmp14_->tab;
		_tmp16_ = tepl_tab_get_view ((TeplTab*) _tmp15_);
		_tmp17_ = _tmp16_;
		tepl_view_scroll_to_cursor (_tmp17_);
	}
	_g_object_unref0 (doc);
}


static void ___lambda60__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda60_ ((SearchAndReplace*) self);
}


static void _search_and_replace_search_forward_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_search_forward ((SearchAndReplace*) self);
}


static void _search_and_replace_search_forward_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_search_forward ((SearchAndReplace*) self);
}


static void __lambda61_ (Block30Data* _data30_) {
	SearchAndReplace* self;
	gboolean sensitive = FALSE;
	GtkSearchEntry* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	self = _data30_->self;
	_tmp0_ = self->priv->_entry_find;
	_tmp1_ = gtk_entry_get_text_length ((GtkEntry*) _tmp0_);
	_tmp2_ = _tmp1_;
	sensitive = _tmp2_ > ((guint) 0);
	gtk_widget_set_sensitive ((GtkWidget*) _data30_->button_previous, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data30_->button_next, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data30_->button_replace, sensitive);
	gtk_widget_set_sensitive ((GtkWidget*) _data30_->button_replace_all, sensitive);
}


static void ___lambda61__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	__lambda61_ (self);
}


static void _search_and_replace_replace_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	search_and_replace_replace ((SearchAndReplace*) self);
}


static void _search_and_replace_replace_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	search_and_replace_replace ((SearchAndReplace*) self);
}


static void __lambda62_ (SearchAndReplace* self) {
	GtkSourceSearchContext* _tmp0_;
	GError * _inner_error_ = NULL;
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ != NULL) {
		MainWindow* _tmp1_;
		DocumentView* _tmp2_;
		DocumentView* _tmp3_;
		GtkSourceCompletion* _tmp4_;
		GtkSourceCompletion* _tmp5_;
		MainWindow* _tmp10_;
		DocumentView* _tmp11_;
		DocumentView* _tmp12_;
		GtkSourceCompletion* _tmp13_;
		GtkSourceCompletion* _tmp14_;
		_tmp1_ = self->priv->_main_window;
		_tmp2_ = main_window_get_active_view (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp3_);
		_tmp5_ = _tmp4_;
		gtk_source_completion_block_interactive (_tmp5_);
		{
			GtkSourceSearchContext* _tmp6_;
			GtkSearchEntry* _tmp7_;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp6_ = self->priv->_search_context;
			_tmp7_ = self->priv->_entry_replace;
			_tmp8_ = gtk_entry_get_text ((GtkEntry*) _tmp7_);
			_tmp9_ = _tmp8_;
			gtk_source_search_context_replace_all (_tmp6_, _tmp9_, -1, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch43_g_error;
			}
		}
		goto __finally43;
		__catch43_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally43:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp10_ = self->priv->_main_window;
		_tmp11_ = main_window_get_active_view (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp12_);
		_tmp14_ = _tmp13_;
		gtk_source_completion_unblock_interactive (_tmp14_);
	}
}


static void ___lambda62__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda62_ ((SearchAndReplace*) self);
}


static gboolean __lambda63_ (SearchAndReplace* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey* _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	switch (_tmp1_) {
		case GDK_KEY_Tab:
		{
			GtkSearchEntry* _tmp2_;
			search_and_replace_show_search_and_replace (self);
			_tmp2_ = self->priv->_entry_replace;
			gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Escape:
		{
			search_and_replace_hide (self);
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}


static gboolean ___lambda63__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = __lambda63_ ((SearchAndReplace*) self, event);
	return result;
}


SearchAndReplace* search_and_replace_construct (GType object_type, MainWindow* main_window) {
	SearchAndReplace * self = NULL;
	Block30Data* _data30_;
	MainWindow* _tmp0_;
	GtkSourceSearchSettings* _tmp1_;
	GtkSourceSearchSettings* _tmp2_;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkButton* button_arrow = NULL;
	GtkButton* _tmp6_;
	GtkArrow* _tmp7_;
	GtkArrow* _tmp8_;
	GtkGrid* _tmp9_;
	GtkGrid* find_grid = NULL;
	GtkGrid* _tmp10_;
	GtkGrid* _tmp11_;
	GtkSearchEntry* _tmp12_;
	GtkButton* _tmp13_;
	GtkButton* _tmp14_;
	GtkButton* button_close = NULL;
	GtkButton* _tmp15_;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkGrid* _tmp19_;
	GtkGrid* _tmp20_;
	GtkGrid* _tmp21_;
	GtkGrid* _tmp22_;
	GtkGrid* _tmp23_;
	GtkSearchEntry* _tmp24_;
	GtkSearchEntry* _tmp25_;
	GtkSearchEntry* _tmp26_;
	GtkSearchEntry* _tmp27_;
	GtkSearchEntry* _tmp28_;
	GtkGrid* _tmp29_;
	GtkSearchEntry* _tmp30_;
	GtkButton* _tmp31_;
	GtkButton* _tmp32_;
	GtkGrid* replace_all_grid = NULL;
	GtkGrid* _tmp33_;
	GtkImage* image = NULL;
	GtkImage* _tmp34_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp35_;
	GtkGrid* _tmp36_;
	GtkGrid* _tmp37_;
	GtkSearchEntry* _tmp38_;
	GtkSearchEntry* _tmp39_;
	GtkSearchEntry* _tmp40_;
	GtkSearchEntry* _tmp41_;
	GtkGrid* _tmp42_;
	g_return_val_if_fail (main_window != NULL, NULL);
	_data30_ = g_slice_new0 (Block30Data);
	_data30_->_ref_count_ = 1;
	self = (SearchAndReplace*) g_object_new (object_type, NULL);
	_data30_->self = g_object_ref (self);
	_tmp0_ = main_window;
	self->priv->_main_window = _tmp0_;
	_tmp1_ = gtk_source_search_settings_new ();
	_g_object_unref0 (self->priv->_search_settings);
	self->priv->_search_settings = _tmp1_;
	_tmp2_ = self->priv->_search_settings;
	gtk_source_search_settings_set_wrap_around (_tmp2_, TRUE);
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->_main_grid);
	self->priv->_main_grid = _tmp3_;
	_tmp4_ = self->priv->_main_grid;
	gtk_grid_set_column_spacing (_tmp4_, (guint) 3);
	_tmp5_ = self->priv->_main_grid;
	gtk_grid_set_row_spacing (_tmp5_, (guint) 3);
	_tmp6_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp6_);
	button_arrow = _tmp6_;
	_tmp7_ = (GtkArrow*) gtk_arrow_new (GTK_ARROW_DOWN, GTK_SHADOW_OUT);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->_arrow);
	self->priv->_arrow = _tmp7_;
	_tmp8_ = self->priv->_arrow;
	gtk_container_add ((GtkContainer*) button_arrow, (GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->_main_grid;
	gtk_grid_attach (_tmp9_, (GtkWidget*) button_arrow, 0, 0, 1, 1);
	_tmp10_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp10_);
	find_grid = _tmp10_;
	gtk_orientable_set_orientation ((GtkOrientable*) find_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (find_grid, (guint) 2);
	_tmp11_ = self->priv->_main_grid;
	gtk_grid_attach (_tmp11_, (GtkWidget*) find_grid, 1, 0, 1, 1);
	search_and_replace_init_find_entry (self);
	_tmp12_ = self->priv->_entry_find;
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _tmp12_);
	_tmp13_ = search_and_replace_get_button (self, "go-up");
	_data30_->button_previous = _tmp13_;
	_tmp14_ = search_and_replace_get_button (self, "go-down");
	_data30_->button_next = _tmp14_;
	_tmp15_ = search_and_replace_get_button (self, "window-close");
	button_close = _tmp15_;
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _data30_->button_previous);
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _data30_->button_next);
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) button_close);
	gtk_widget_set_sensitive ((GtkWidget*) _data30_->button_previous, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) _data30_->button_next, FALSE);
	_tmp16_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->priv->_info_label);
	self->priv->_info_label = _tmp16_;
	_tmp17_ = self->priv->_info_label;
	gtk_widget_set_margin_start ((GtkWidget*) _tmp17_, 12);
	_tmp18_ = self->priv->_info_label;
	gtk_container_add ((GtkContainer*) find_grid, (GtkWidget*) _tmp18_);
	_tmp19_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->_replace_grid);
	self->priv->_replace_grid = _tmp19_;
	_tmp20_ = self->priv->_replace_grid;
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp20_, GTK_ORIENTATION_HORIZONTAL);
	_tmp21_ = self->priv->_replace_grid;
	gtk_grid_set_column_spacing (_tmp21_, (guint) 2);
	_tmp22_ = self->priv->_main_grid;
	_tmp23_ = self->priv->_replace_grid;
	gtk_grid_attach (_tmp22_, (GtkWidget*) _tmp23_, 1, 1, 1, 1);
	_tmp24_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->priv->_entry_replace);
	self->priv->_entry_replace = _tmp24_;
	_tmp25_ = self->priv->_entry_replace;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp25_, _ ("Replace with"));
	_tmp26_ = self->priv->_entry_replace;
	g_object_set ((GtkWidget*) _tmp26_, "can-focus", TRUE, NULL);
	_tmp27_ = self->priv->_entry_replace;
	gtk_entry_set_width_chars ((GtkEntry*) _tmp27_, 25);
	_tmp28_ = self->priv->_entry_replace;
	g_object_set ((GtkEntry*) _tmp28_, "primary-icon-gicon", NULL, NULL);
	_tmp29_ = self->priv->_replace_grid;
	_tmp30_ = self->priv->_entry_replace;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = search_and_replace_get_button (self, "edit-find-replace");
	_data30_->button_replace = _tmp31_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _data30_->button_replace, _ ("Replace"));
	_tmp32_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp32_);
	_data30_->button_replace_all = _tmp32_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _data30_->button_replace_all, _ ("Replace All"));
	gtk_button_set_relief (_data30_->button_replace_all, GTK_RELIEF_NONE);
	_tmp33_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp33_);
	replace_all_grid = _tmp33_;
	gtk_orientable_set_orientation ((GtkOrientable*) replace_all_grid, GTK_ORIENTATION_HORIZONTAL);
	gtk_grid_set_column_spacing (replace_all_grid, (guint) 8);
	gtk_widget_set_valign ((GtkWidget*) replace_all_grid, GTK_ALIGN_CENTER);
	_tmp34_ = (GtkImage*) gtk_image_new_from_icon_name ("edit-find-replace", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp34_);
	image = _tmp34_;
	gtk_container_add ((GtkContainer*) replace_all_grid, (GtkWidget*) image);
	_tmp35_ = (GtkLabel*) gtk_label_new (_ ("All"));
	g_object_ref_sink (_tmp35_);
	label = _tmp35_;
	gtk_container_add ((GtkContainer*) replace_all_grid, (GtkWidget*) label);
	gtk_container_add ((GtkContainer*) _data30_->button_replace_all, (GtkWidget*) replace_all_grid);
	_tmp36_ = self->priv->_replace_grid;
	gtk_container_add ((GtkContainer*) _tmp36_, (GtkWidget*) _data30_->button_replace);
	_tmp37_ = self->priv->_replace_grid;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _data30_->button_replace_all);
	gtk_widget_set_sensitive ((GtkWidget*) _data30_->button_replace, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) _data30_->button_replace_all, FALSE);
	g_signal_connect_object (button_arrow, "clicked", (GCallback) ___lambda58__gtk_button_clicked, self, 0);
	g_signal_connect_object (button_close, "clicked", (GCallback) _search_and_replace_hide_gtk_button_clicked, self, 0);
	g_signal_connect_object (_data30_->button_previous, "clicked", (GCallback) ___lambda60__gtk_button_clicked, self, 0);
	g_signal_connect_object (_data30_->button_next, "clicked", (GCallback) _search_and_replace_search_forward_gtk_button_clicked, self, 0);
	_tmp38_ = self->priv->_entry_find;
	g_signal_connect_object ((GtkEntry*) _tmp38_, "activate", (GCallback) _search_and_replace_search_forward_gtk_entry_activate, self, 0);
	_tmp39_ = self->priv->_entry_find;
	g_signal_connect_data ((GtkEditable*) _tmp39_, "changed", (GCallback) ___lambda61__gtk_editable_changed, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
	g_signal_connect_object (_data30_->button_replace, "clicked", (GCallback) _search_and_replace_replace_gtk_button_clicked, self, 0);
	_tmp40_ = self->priv->_entry_replace;
	g_signal_connect_object ((GtkEntry*) _tmp40_, "activate", (GCallback) _search_and_replace_replace_gtk_entry_activate, self, 0);
	g_signal_connect_object (_data30_->button_replace_all, "clicked", (GCallback) ___lambda62__gtk_button_clicked, self, 0);
	_tmp41_ = self->priv->_entry_find;
	g_signal_connect_object ((GtkWidget*) _tmp41_, "key-press-event", (GCallback) ___lambda63__gtk_widget_key_press_event, self, 0);
	_tmp42_ = self->priv->_main_grid;
	gtk_widget_hide ((GtkWidget*) _tmp42_);
	_g_object_unref0 (label);
	_g_object_unref0 (image);
	_g_object_unref0 (replace_all_grid);
	_g_object_unref0 (button_close);
	_g_object_unref0 (find_grid);
	_g_object_unref0 (button_arrow);
	block30_data_unref (_data30_);
	_data30_ = NULL;
	return self;
}


SearchAndReplace* search_and_replace_new (MainWindow* main_window) {
	return search_and_replace_construct (TYPE_SEARCH_AND_REPLACE, main_window);
}


static Block31Data* block31_data_ref (Block31Data* _data31_) {
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}


static void block31_data_unref (void * _userdata_) {
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		SearchAndReplace* self;
		self = _data31_->self;
		_g_object_unref0 (_data31_->menu);
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}


static void __lambda57_ (Block31Data* _data31_, GtkEntryIconPosition icon_pos, GdkEvent* event) {
	SearchAndReplace* self;
	GtkEntryIconPosition _tmp0_;
	self = _data31_->self;
	g_return_if_fail (event != NULL);
	_tmp0_ = icon_pos;
	if (_tmp0_ == GTK_ENTRY_ICON_PRIMARY) {
		GdkEvent* _tmp1_;
		GdkEventButton* _tmp2_;
		GdkEventButton* _tmp3_;
		guint _tmp4_;
		GdkEvent* _tmp5_;
		GdkEventButton* _tmp6_;
		GdkEventButton* _tmp7_;
		guint32 _tmp8_;
		_tmp1_ = event;
		_tmp2_ = (GdkEventButton *) (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_->button;
		_tmp5_ = event;
		_tmp6_ = (GdkEventButton *) (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_->time;
		gtk_menu_popup (_data31_->menu, NULL, NULL, NULL, NULL, _tmp4_, _tmp8_);
	}
}


static void ___lambda57__gtk_entry_icon_press (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	__lambda57_ (self, p0, p1);
}


static void search_and_replace_init_find_entry (SearchAndReplace* self) {
	Block31Data* _data31_;
	GtkSearchEntry* _tmp0_;
	GtkSearchEntry* _tmp1_;
	GThemedIcon* _tmp2_;
	GThemedIcon* _tmp3_;
	GtkSearchEntry* _tmp4_;
	GtkSearchEntry* _tmp5_;
	GtkSearchEntry* _tmp6_;
	GtkSearchEntry* _tmp7_;
	GtkSearchEntry* _tmp8_;
	GtkSearchEntry* _tmp9_;
	GtkSourceSearchSettings* _tmp10_;
	GtkMenu* _tmp11_;
	GtkCheckMenuItem* check_case_sensitive = NULL;
	GtkCheckMenuItem* _tmp12_;
	GtkCheckMenuItem* check_entire_word = NULL;
	GtkCheckMenuItem* _tmp13_;
	GtkSourceSearchSettings* _tmp14_;
	GtkSourceSearchSettings* _tmp15_;
	GtkSearchEntry* _tmp16_;
	g_return_if_fail (self != NULL);
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp0_ = (GtkSearchEntry*) gtk_search_entry_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_entry_find);
	self->priv->_entry_find = _tmp0_;
	_tmp1_ = self->priv->_entry_find;
	_tmp2_ = (GThemedIcon*) g_themed_icon_new_with_default_fallbacks ("document-properties-symbolic");
	_tmp3_ = _tmp2_;
	g_object_set ((GtkEntry*) _tmp1_, "primary-icon-gicon", (GIcon*) _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->_entry_find;
	g_object_set ((GtkEntry*) _tmp4_, "primary-icon-activatable", TRUE, NULL);
	_tmp5_ = self->priv->_entry_find;
	g_object_set ((GtkEntry*) _tmp5_, "primary-icon-sensitive", TRUE, NULL);
	_tmp6_ = self->priv->_entry_find;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp6_, _ ("Search for"));
	_tmp7_ = self->priv->_entry_find;
	g_object_set ((GtkWidget*) _tmp7_, "can-focus", TRUE, NULL);
	_tmp8_ = self->priv->_entry_find;
	gtk_entry_set_width_chars ((GtkEntry*) _tmp8_, 25);
	_tmp9_ = self->priv->_entry_find;
	_tmp10_ = self->priv->_search_settings;
	g_object_bind_property_with_closures ((GObject*) _tmp9_, "text", (GObject*) _tmp10_, "search-text", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp11_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp11_);
	_data31_->menu = _tmp11_;
	_tmp12_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Case sensitive"));
	g_object_ref_sink (_tmp12_);
	check_case_sensitive = _tmp12_;
	_tmp13_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Entire words only"));
	g_object_ref_sink (_tmp13_);
	check_entire_word = _tmp13_;
	gtk_menu_shell_append ((GtkMenuShell*) _data31_->menu, (GtkWidget*) ((GtkMenuItem*) check_case_sensitive));
	gtk_menu_shell_append ((GtkMenuShell*) _data31_->menu, (GtkWidget*) ((GtkMenuItem*) check_entire_word));
	gtk_widget_show_all ((GtkWidget*) _data31_->menu);
	_tmp14_ = self->priv->_search_settings;
	g_object_bind_property_with_closures ((GObject*) check_case_sensitive, "active", (GObject*) _tmp14_, "case-sensitive", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp15_ = self->priv->_search_settings;
	g_object_bind_property_with_closures ((GObject*) check_entire_word, "active", (GObject*) _tmp15_, "at-word-boundaries", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp16_ = self->priv->_entry_find;
	g_signal_connect_data ((GtkEntry*) _tmp16_, "icon-press", (GCallback) ___lambda57__gtk_entry_icon_press, block31_data_ref (_data31_), (GClosureNotify) block31_data_unref, 0);
	_g_object_unref0 (check_entire_word);
	_g_object_unref0 (check_case_sensitive);
	block31_data_unref (_data31_);
	_data31_ = NULL;
}


static GtkButton* search_and_replace_get_button (SearchAndReplace* self, const gchar* icon_name) {
	GtkButton* result = NULL;
	GtkButton* button = NULL;
	GtkButton* _tmp0_;
	GtkImage* image = NULL;
	const gchar* _tmp1_;
	GtkImage* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (icon_name != NULL, NULL);
	_tmp0_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp0_);
	button = _tmp0_;
	_tmp1_ = icon_name;
	_tmp2_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp1_, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp2_);
	image = _tmp2_;
	gtk_container_add ((GtkContainer*) button, (GtkWidget*) image);
	gtk_button_set_relief (button, GTK_RELIEF_NONE);
	result = button;
	_g_object_unref0 (image);
	return result;
}


GtkWidget* search_and_replace_get_widget (SearchAndReplace* self) {
	GtkWidget* result = NULL;
	GtkGrid* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_grid;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}


void search_and_replace_show_search (SearchAndReplace* self) {
	GtkArrow* _tmp0_;
	GtkGrid* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_arrow;
	g_object_set (_tmp0_, "arrow-type", GTK_ARROW_DOWN, NULL);
	search_and_replace_show (self);
	_tmp1_ = self->priv->_replace_grid;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}


void search_and_replace_show_search_and_replace (SearchAndReplace* self) {
	GtkArrow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_arrow;
	g_object_set (_tmp0_, "arrow-type", GTK_ARROW_UP, NULL);
	search_and_replace_show (self);
}


static void _search_and_replace_connect_active_document_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	search_and_replace_connect_active_document ((SearchAndReplace*) self);
}


static void search_and_replace_show (SearchAndReplace* self) {
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	GtkGrid* _tmp3_;
	GtkSearchEntry* _tmp4_;
	Document* doc = NULL;
	MainWindow* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	TeplSelectionType _tmp10_;
	MainWindow* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_main_grid;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->_entry_find;
	gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
	_tmp5_ = self->priv->_main_window;
	_tmp6_ = main_window_get_active_document (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	doc = _tmp8_;
	_tmp9_ = doc;
	_tmp10_ = tepl_buffer_get_selection_type ((TeplBuffer*) _tmp9_);
	if (_tmp10_ == TEPL_SELECTION_TYPE_ON_SAME_LINE) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		Document* _tmp11_;
		GtkTextIter _tmp12_ = {0};
		GtkTextIter _tmp13_ = {0};
		GtkSearchEntry* _tmp14_;
		Document* _tmp15_;
		GtkTextIter _tmp16_;
		GtkTextIter _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp11_ = doc;
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
		start = _tmp12_;
		end = _tmp13_;
		_tmp14_ = self->priv->_entry_find;
		_tmp15_ = doc;
		_tmp16_ = start;
		_tmp17_ = end;
		_tmp18_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp15_, &_tmp16_, &_tmp17_, FALSE);
		_tmp19_ = _tmp18_;
		gtk_entry_set_text ((GtkEntry*) _tmp14_, _tmp19_);
		_g_free0 (_tmp19_);
	}
	_tmp20_ = self->priv->_main_window;
	g_signal_connect_object ((GObject*) _tmp20_, "notify::active-document", (GCallback) _search_and_replace_connect_active_document_g_object_notify, self, 0);
	search_and_replace_connect_active_document (self);
	_g_object_unref0 (doc);
}


void search_and_replace_hide (SearchAndReplace* self) {
	MainWindow* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	GtkGrid* _tmp3_;
	MainWindow* _tmp4_;
	DocumentView* _tmp5_;
	DocumentView* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _search_and_replace_connect_active_document_g_object_notify, self);
	search_and_replace_destroy_search_context (self);
	_tmp3_ = self->priv->_main_grid;
	gtk_widget_hide ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->_main_window;
	_tmp5_ = main_window_get_active_view (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ != NULL) {
		MainWindow* _tmp7_;
		DocumentView* _tmp8_;
		DocumentView* _tmp9_;
		_tmp7_ = self->priv->_main_window;
		_tmp8_ = main_window_get_active_view (_tmp7_);
		_tmp9_ = _tmp8_;
		gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
	}
}


static void _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set (GtkTextBuffer* _sender, GtkTextIter* location, GtkTextMark* mark, gpointer self) {
	search_and_replace_mark_set_cb ((SearchAndReplace*) self, _sender, location, mark);
}


static void search_and_replace_destroy_search_context (SearchAndReplace* self) {
	GtkSourceSearchContext* _tmp0_;
	GtkSourceBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	GtkSourceBuffer* _tmp3_;
	GtkSourceBuffer* _tmp4_;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = buffer;
	g_signal_parse_name ("mark-set", gtk_text_buffer_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkTextBuffer*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set, self);
	_g_object_unref0 (self->priv->_search_context);
	self->priv->_search_context = NULL;
	_g_object_unref0 (buffer);
}


static void __lambda59_ (SearchAndReplace* self) {
	gboolean _tmp0_ = FALSE;
	GtkSourceSearchContext* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_occurrences_count (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		GtkSourceSearchSettings* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = self->priv->_search_settings;
		_tmp5_ = gtk_source_search_settings_get_search_text (_tmp4_);
		_tmp0_ = _tmp5_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkSearchEntry* _tmp6_;
		_tmp6_ = self->priv->_entry_find;
		error_entry_add_error ((GtkWidget*) _tmp6_);
	} else {
		GtkSourceSearchContext* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp7_ = self->priv->_search_context;
		_tmp8_ = gtk_source_search_context_get_occurrences_count (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_ >= 0) {
			GtkSearchEntry* _tmp10_;
			_tmp10_ = self->priv->_entry_find;
			error_entry_remove_error ((GtkWidget*) _tmp10_);
		}
	}
	search_and_replace_update_info_label (self);
}


static void ___lambda59__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda59_ ((SearchAndReplace*) self);
}


static void search_and_replace_connect_active_document (SearchAndReplace* self) {
	Document* doc = NULL;
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	GtkSourceSearchSettings* _tmp6_;
	GtkSourceSearchContext* _tmp7_;
	GtkSourceSearchContext* _tmp8_;
	gboolean readonly = FALSE;
	MainWindow* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GtkGrid* _tmp14_;
	gboolean _tmp15_;
	Document* _tmp16_;
	g_return_if_fail (self != NULL);
	search_and_replace_destroy_search_context (self);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	doc = _tmp3_;
	_tmp4_ = doc;
	if (_tmp4_ == NULL) {
		_g_object_unref0 (doc);
		return;
	}
	_tmp5_ = doc;
	_tmp6_ = self->priv->_search_settings;
	_tmp7_ = gtk_source_search_context_new ((GtkSourceBuffer*) _tmp5_, _tmp6_);
	_g_object_unref0 (self->priv->_search_context);
	self->priv->_search_context = _tmp7_;
	_tmp8_ = self->priv->_search_context;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::occurrences-count", (GCallback) ___lambda59__g_object_notify, self, 0);
	_tmp9_ = self->priv->_main_window;
	_tmp10_ = main_window_get_active_document (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = document_get_readonly (_tmp11_);
	_tmp13_ = _tmp12_;
	readonly = _tmp13_;
	_tmp14_ = self->priv->_replace_grid;
	_tmp15_ = readonly;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, !_tmp15_);
	_tmp16_ = doc;
	g_signal_connect_object ((GtkTextBuffer*) _tmp16_, "mark-set", (GCallback) _search_and_replace_mark_set_cb_gtk_text_buffer_mark_set, self, 0);
	_g_object_unref0 (doc);
}


static void search_and_replace_mark_set_cb (SearchAndReplace* self, GtkTextBuffer* buffer, GtkTextIter* location, GtkTextMark* mark) {
	gboolean _tmp0_ = FALSE;
	GtkTextMark* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextMark* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (location != NULL);
	g_return_if_fail (mark != NULL);
	_tmp1_ = mark;
	_tmp2_ = buffer;
	_tmp3_ = gtk_text_buffer_get_insert (_tmp2_);
	if (_tmp1_ == _tmp3_) {
		_tmp0_ = TRUE;
	} else {
		GtkTextMark* _tmp4_;
		GtkTextBuffer* _tmp5_;
		GtkTextMark* _tmp6_;
		_tmp4_ = mark;
		_tmp5_ = buffer;
		_tmp6_ = gtk_text_buffer_get_selection_bound (_tmp5_);
		_tmp0_ = _tmp4_ == _tmp6_;
	}
	if (_tmp0_) {
		search_and_replace_update_info_label (self);
	}
}


static void search_and_replace_update_info_label (SearchAndReplace* self) {
	gboolean _tmp0_ = FALSE;
	GtkSourceSearchContext* _tmp1_;
	gint count = 0;
	GtkSourceSearchContext* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	GtkTextBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp11_;
	GtkSourceBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp14_;
	GtkTextIter _tmp15_ = {0};
	GtkTextIter _tmp16_ = {0};
	gint pos = 0;
	GtkSourceSearchContext* _tmp17_;
	GtkTextIter _tmp18_;
	GtkTextIter _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_search_context;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GtkSourceSearchSettings* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->_search_settings;
		_tmp3_ = gtk_source_search_settings_get_search_text (_tmp2_);
		_tmp0_ = _tmp3_ == NULL;
	}
	if (_tmp0_) {
		GtkLabel* _tmp4_;
		_tmp4_ = self->priv->_info_label;
		gtk_label_set_text (_tmp4_, "");
		return;
	}
	_tmp5_ = self->priv->_search_context;
	_tmp6_ = gtk_source_search_context_get_occurrences_count (_tmp5_);
	_tmp7_ = _tmp6_;
	count = _tmp7_;
	_tmp8_ = count;
	if (_tmp8_ == -1) {
		return;
	}
	_tmp9_ = count;
	if (_tmp9_ == 0) {
		GtkLabel* _tmp10_;
		_tmp10_ = self->priv->_info_label;
		gtk_label_set_text (_tmp10_, _ ("Not found"));
		return;
	}
	_tmp11_ = self->priv->_search_context;
	_tmp12_ = gtk_source_search_context_get_buffer (_tmp11_);
	_tmp13_ = _g_object_ref0 ((GtkTextBuffer*) _tmp12_);
	buffer = _tmp13_;
	_tmp14_ = buffer;
	gtk_text_buffer_get_selection_bounds (_tmp14_, &_tmp15_, &_tmp16_);
	start = _tmp15_;
	end = _tmp16_;
	_tmp17_ = self->priv->_search_context;
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = gtk_source_search_context_get_occurrence_position (_tmp17_, &_tmp18_, &_tmp19_);
	pos = _tmp20_;
	_tmp21_ = pos;
	if (_tmp21_ > 0) {
		GtkLabel* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp22_ = self->priv->_info_label;
		_tmp23_ = pos;
		_tmp24_ = count;
		_tmp25_ = g_strdup_printf (_ ("Match %d of %d"), _tmp23_, _tmp24_);
		_tmp26_ = _tmp25_;
		gtk_label_set_text (_tmp22_, _tmp26_);
		_g_free0 (_tmp26_);
	} else {
		gchar* text = NULL;
		gint _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_;
		GtkLabel* _tmp30_;
		const gchar* _tmp31_;
		_tmp27_ = count;
		_tmp28_ = count;
		_tmp29_ = g_strdup_printf (ngettext ("%d match", "%d matches", (gulong) _tmp27_), _tmp28_);
		text = _tmp29_;
		_tmp30_ = self->priv->_info_label;
		_tmp31_ = text;
		gtk_label_set_text (_tmp30_, _tmp31_);
		_g_free0 (text);
	}
	_g_object_unref0 (buffer);
}


static void search_and_replace_search_forward (SearchAndReplace* self) {
	GtkSourceSearchContext* _tmp0_;
	GtkTextIter iter = {0};
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	Document* doc = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkSourceSearchContext* _tmp6_;
	GtkTextIter _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_DOCUMENT) ? ((Document*) _tmp2_) : NULL);
	doc = _tmp3_;
	_tmp4_ = doc;
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, NULL, &_tmp5_);
	iter = _tmp5_;
	_tmp6_ = self->priv->_search_context;
	_tmp7_ = iter;
	_tmp10_ = gtk_source_search_context_forward2 (_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_, NULL);
	match_start = _tmp8_;
	match_end = _tmp9_;
	if (_tmp10_) {
		Document* _tmp11_;
		GtkTextIter _tmp12_;
		GtkTextIter _tmp13_;
		Document* _tmp14_;
		DocumentTab* _tmp15_;
		TeplView* _tmp16_;
		TeplView* _tmp17_;
		_tmp11_ = doc;
		_tmp12_ = match_start;
		_tmp13_ = match_end;
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp11_, &_tmp12_, &_tmp13_);
		_tmp14_ = doc;
		_tmp15_ = _tmp14_->tab;
		_tmp16_ = tepl_tab_get_view ((TeplTab*) _tmp15_);
		_tmp17_ = _tmp16_;
		tepl_view_scroll_to_cursor (_tmp17_);
	}
	_g_object_unref0 (doc);
}


static void search_and_replace_replace (SearchAndReplace* self) {
	GtkSourceSearchContext* _tmp0_;
	GtkTextIter match_start = {0};
	GtkTextIter match_end = {0};
	GtkSourceBuffer* buffer = NULL;
	GtkSourceSearchContext* _tmp1_;
	GtkSourceBuffer* _tmp2_;
	GtkSourceBuffer* _tmp3_;
	GtkSourceBuffer* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_ = {0};
	MainWindow* _tmp7_;
	DocumentView* _tmp8_;
	DocumentView* _tmp9_;
	GtkSourceCompletion* _tmp10_;
	GtkSourceCompletion* _tmp11_;
	MainWindow* _tmp20_;
	DocumentView* _tmp21_;
	DocumentView* _tmp22_;
	GtkSourceCompletion* _tmp23_;
	GtkSourceCompletion* _tmp24_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_search_context;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = self->priv->_search_context;
	_tmp2_ = gtk_source_search_context_get_buffer (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	buffer = _tmp3_;
	_tmp4_ = buffer;
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) _tmp4_, &_tmp5_, &_tmp6_);
	match_start = _tmp5_;
	match_end = _tmp6_;
	_tmp7_ = self->priv->_main_window;
	_tmp8_ = main_window_get_active_view (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp9_);
	_tmp11_ = _tmp10_;
	gtk_source_completion_block_interactive (_tmp11_);
	{
		gboolean _tmp12_ = FALSE;
		GtkSourceSearchContext* _tmp13_;
		GtkTextIter _tmp14_;
		GtkTextIter _tmp15_;
		GtkSearchEntry* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gboolean _tmp19_;
		_tmp13_ = self->priv->_search_context;
		_tmp14_ = match_start;
		_tmp15_ = match_end;
		_tmp16_ = self->priv->_entry_replace;
		_tmp17_ = gtk_entry_get_text ((GtkEntry*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gtk_source_search_context_replace2 (_tmp13_, &_tmp14_, &_tmp15_, _tmp18_, -1, &_inner_error_);
		_tmp12_ = _tmp19_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch44_g_error;
		}
		if (!_tmp12_) {
			search_and_replace_search_forward (self);
		}
	}
	goto __finally44;
	__catch44_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally44:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (buffer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp20_ = self->priv->_main_window;
	_tmp21_ = main_window_get_active_view (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp22_);
	_tmp24_ = _tmp23_;
	gtk_source_completion_unblock_interactive (_tmp24_);
	_g_object_unref0 (buffer);
}


static void search_and_replace_class_init (SearchAndReplaceClass * klass) {
	search_and_replace_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SearchAndReplacePrivate));
	G_OBJECT_CLASS (klass)->finalize = search_and_replace_finalize;
}


static void search_and_replace_instance_init (SearchAndReplace * self) {
	self->priv = SEARCH_AND_REPLACE_GET_PRIVATE (self);
	self->priv->_search_context = NULL;
}


static void search_and_replace_finalize (GObject * obj) {
	SearchAndReplace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SEARCH_AND_REPLACE, SearchAndReplace);
	_g_object_unref0 (self->priv->_main_grid);
	_g_object_unref0 (self->priv->_replace_grid);
	_g_object_unref0 (self->priv->_arrow);
	_g_object_unref0 (self->priv->_entry_find);
	_g_object_unref0 (self->priv->_entry_replace);
	_g_object_unref0 (self->priv->_info_label);
	_g_object_unref0 (self->priv->_search_settings);
	_g_object_unref0 (self->priv->_search_context);
	G_OBJECT_CLASS (search_and_replace_parent_class)->finalize (obj);
}


GType search_and_replace_get_type (void) {
	static volatile gsize search_and_replace_type_id__volatile = 0;
	if (g_once_init_enter (&search_and_replace_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SearchAndReplaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) search_and_replace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SearchAndReplace), 0, (GInstanceInitFunc) search_and_replace_instance_init, NULL };
		GType search_and_replace_type_id;
		search_and_replace_type_id = g_type_register_static (G_TYPE_OBJECT, "SearchAndReplace", &g_define_type_info, 0);
		g_once_init_leave (&search_and_replace_type_id__volatile, search_and_replace_type_id);
	}
	return search_and_replace_type_id__volatile;
}



