/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* librvngabw
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2002-2004 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2004-2006 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://librvngabw.sourceforge.net
 */

#ifndef ABW_STRING_DOCUMENT_HANDLER_H
#define ABW_STRING_DOCUMENT_HANDLER_H

#include <librvngabw/librvngabw.hxx>

namespace librvngabw
{
class StringDocumentHandlerPrivate;

/** a document handler which stores element in a RVNGString (which can be stored as a AbiWord file)
 */
class StringDocumentHandler : public ABWDocumentHandler
{
public:
	//! constructor
	StringDocumentHandler();
	//! destructor
	virtual ~StringDocumentHandler();

	//! returns the final string
	librevenge::RVNGString const &getData() const;

	//! start document
	virtual void startDocument();
	//! end document
	virtual void endDocument();
	//! add a start's element
	virtual void startElement(const char *psName, const librevenge::RVNGPropertyList &xPropList);
	//! add a end's element
	virtual void endElement(const char *psName);
	//! add a list of character
	virtual void characters(const librevenge::RVNGString &sCharacters);
private:
	//! the class data
	StringDocumentHandlerPrivate *m_data;

	StringDocumentHandler(StringDocumentHandler const &);
	StringDocumentHandler operator=(StringDocumentHandler const &);
};
}
#endif

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
