/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* librvngabw
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2006 Ariya Hidayat (ariya@kde.org)
 * Copyright (C) 2005 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 */

#ifndef ABW_SVG_DRAWING_GENERATOR_HXX
#define ABW_SVG_DRAWING_GENERATOR_HXX

#include <librevenge/librevenge.h>

#include "FilterInternal.hxx"

namespace librvngabw
{
class ABWSVGDrawingGeneratorInternal;
/** class used to create a basic SVG drawing */
class ABWSVGDrawingGenerator
{
public:
	//! constructor
	ABWSVGDrawingGenerator();
	//! destructor
	~ABWSVGDrawingGenerator();

	//! returns the picture content (and the position )
	bool getPicture(librevenge::RVNGString &pict, double &minx, double &miny, double &maxx, double &maxy);
	//! store the graphic style
	void setStyle(const librevenge::RVNGPropertyList &propList);
	//! draw a rectangle
	void drawRectangle(const librevenge::RVNGPropertyList &propList);
	//! draw an ellipse
	void drawEllipse(const librevenge::RVNGPropertyList &propList);
	//! draw a polyline
	void drawPolyline(const librevenge::RVNGPropertyList &propList);
	//! draw a polygon
	void drawPolygon(const librevenge::RVNGPropertyList &propList);
	//! draw a patch
	void drawPath(const librevenge::RVNGPropertyList &propList);

protected:
	/** the data */
	std::shared_ptr<ABWSVGDrawingGeneratorInternal> m_data;
private:
	ABWSVGDrawingGenerator(const ABWSVGDrawingGenerator &);
	ABWSVGDrawingGenerator &operator=(const ABWSVGDrawingGenerator &);
};

}

#endif // ABW_SVG_DRAWING_GENERATOR_HXX

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
