/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/* librvngabw
 * Version: MPL 2.0 / LGPLv2.1+
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * Major Contributor(s):
 * Copyright (C) 2002-2004 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2004 Fridrich Strba (fridrich.strba@bluewin.ch)
 *
 * For minor contributions see the git repository.
 *
 * Alternatively, the contents of this file may be used under the terms
 * of the GNU Lesser General Public License Version 2.1 or later
 * (LGPLv2.1+), in which case the provisions of the LGPLv2.1+ are
 * applicable instead of those above.
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef _ABW_TEXT_GENERATOR_HXX_
#define _ABW_TEXT_GENERATOR_HXX_

#include <librevenge/librevenge.h>

#include "librvngabw-api.hxx"
#include "ABWDocumentHandler.hxx"

namespace librvngabw
{
class ABWTextGeneratorPrivate;

/** A generator for text documents.
  *
  * See @c librevenge library for documentation of the ::librevenge::RVNGTextInterface
  * interface.
  */
class RVNGABWAPI ABWTextGenerator final : public librevenge::RVNGTextInterface
{
public:
	ABWTextGenerator(ABWDocumentHandler *pHandler);
	~ABWTextGenerator() final;

	void setDocumentMetaData(const librevenge::RVNGPropertyList &propList) final;
	void startDocument(const librevenge::RVNGPropertyList &) final;
	void endDocument() final;

	void defineEmbeddedFont(const librevenge::RVNGPropertyList &propList) final;

	void definePageStyle(const librevenge::RVNGPropertyList &) final;
	void openPageSpan(const librevenge::RVNGPropertyList &propList) final;
	void closePageSpan() final;

	void defineSectionStyle(const librevenge::RVNGPropertyList &) final;
	void openSection(const librevenge::RVNGPropertyList &propList) final;
	void closeSection() final;

	void openHeader(const librevenge::RVNGPropertyList &propList) final;
	void closeHeader() final;
	void openFooter(const librevenge::RVNGPropertyList &propList) final;
	void closeFooter() final;

	void defineParagraphStyle(const librevenge::RVNGPropertyList &propList) final;
	void openParagraph(const librevenge::RVNGPropertyList &propList) final;
	void closeParagraph() final;

	void defineCharacterStyle(const librevenge::RVNGPropertyList &propList) final;
	void openSpan(const librevenge::RVNGPropertyList &propList) final;
	void closeSpan() final;

	void openLink(const librevenge::RVNGPropertyList &propList) final;
	void closeLink() final;

	void insertTab() final;
	void insertSpace() final;
	void insertText(const librevenge::RVNGString &text) final;
	void insertLineBreak() final;
	void insertField(const librevenge::RVNGPropertyList &propList) final;

	void openOrderedListLevel(const librevenge::RVNGPropertyList &propList) final;
	void openUnorderedListLevel(const librevenge::RVNGPropertyList &propList) final;
	void closeOrderedListLevel() final;
	void closeUnorderedListLevel() final;
	void openListElement(const librevenge::RVNGPropertyList &propList) final;
	void closeListElement() final;

	void openFootnote(const librevenge::RVNGPropertyList &propList) final;
	void closeFootnote() final;
	void openEndnote(const librevenge::RVNGPropertyList &propList) final;
	void closeEndnote() final;
	void openComment(const librevenge::RVNGPropertyList &propList) final;
	void closeComment() final;
	void openTextBox(const librevenge::RVNGPropertyList &propList) final;
	void closeTextBox() final;

	void openTable(const librevenge::RVNGPropertyList &propList) final;
	void openTableRow(const librevenge::RVNGPropertyList &propList) final;
	void closeTableRow() final;
	void openTableCell(const librevenge::RVNGPropertyList &propList) final;
	void closeTableCell() final;
	void insertCoveredTableCell(const librevenge::RVNGPropertyList &propList) final;
	void closeTable() final;

	//
	// simple Graphic
	//

	void openGroup(const librevenge::RVNGPropertyList &propList) final;
	void closeGroup() final;

	void defineGraphicStyle(const librevenge::RVNGPropertyList &propList) final;
	void drawRectangle(const librevenge::RVNGPropertyList &propList) final;
	void drawEllipse(const librevenge::RVNGPropertyList &propList) final;
	void drawPolygon(const librevenge::RVNGPropertyList &propList) final;
	void drawPolyline(const librevenge::RVNGPropertyList &propList) final;
	void drawPath(const librevenge::RVNGPropertyList &propList) final;
	void drawConnector(const librevenge::RVNGPropertyList &propList) final;

	void openFrame(const librevenge::RVNGPropertyList &propList) final;
	void closeFrame() final;

	void insertBinaryObject(const librevenge::RVNGPropertyList &propList) final;
	void insertEquation(const librevenge::RVNGPropertyList &propList) final;

	/** Registers a handler to check acceptable mimeType
	  * @param[in] checkHandler a function that check is a mime type must be allowed
	  * @param[in] useAlsoDefaultType a flag to know if we need to use or not the default value
	  *
	  * \note by default, the list of allowed image is: bmp,gif,jpeg,png, svg,tiff,wnf and wpg
	*/
	void registerCheckImageHandler(ABWCheckImage checkHandler, bool useAlsoDefaultType);
	/** Registers a handler for embedded images.
	  *
	  * The handler converts the image to a format suitable for the used
	  * ABWDocumentHandler.
	  *
	  * @param[in] mimeType MIME type of the image
	  * @param[in] imageHandler a function that handles processing of
	  *		the images's data and generating output
	  */
	void registerEmbeddedImageHandler(const librevenge::RVNGString &mimeType, ABWEmbeddedImage imageHandler);
	/** Registers a handler for embedded objects.
	  *
	  * @param[in] mimeType MIME type of the object
	  * @param[in] objectHandler a function that handles processing of
	  *		the object's data and generating output
	  */
	void registerEmbeddedObjectHandler(const librevenge::RVNGString &mimeType, ABWEmbeddedObject objectHandler);


private:
	ABWTextGenerator(ABWTextGenerator const &);
	ABWTextGenerator &operator=(ABWTextGenerator const &);

	ABWTextGeneratorPrivate *m_data;
};
}
#endif

/* vim:set shiftwidth=4 softtabstop=4 noexpandtab: */
