; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc < %s -mtriple aarch64 -verify-machineinstrs | FileCheck %s

define i64 @Str64Ldr64(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov x0, x1
; CHECK-NEXT:    str x1, [x8, #8]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i64, ptr %P, i64 1
  %0 = load i64, ptr %arrayidx1
  ret i64 %0
}

define i32 @Str64Ldr32_0(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    str x1, [x8, #8]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i32, ptr %P, i64 2
  %0 = load i32, ptr %arrayidx1
  ret i32 %0
}

define i32 @Str64Ldr32_1(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr32_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x1, [x0, #8]
; CHECK-NEXT:    lsr x0, x1, #32
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i32, ptr %P, i64 3
  %0 = load i32, ptr %arrayidx1
  ret i32 %0
}

define i16 @Str64Ldr16_0(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    str x1, [x8, #8]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 4
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i16 @Str64Ldr16_1(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr16_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x1, [x0, #8]
; CHECK-NEXT:    lsr w0, w1, #16
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 5
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i16 @Str64Ldr16_2(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x1, [x0, #8]
; CHECK-NEXT:    ubfx x0, x1, #32, #16
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 6
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i16 @Str64Ldr16_3(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr16_3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x1, [x0, #8]
; CHECK-NEXT:    lsr x0, x1, #48
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 7
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i8 @Str64Ldr8_0(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    str x1, [x8, #8]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 8
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Str64Ldr8_1(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr8_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x1, [x0, #8]
; CHECK-NEXT:    ubfx x0, x1, #8, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 9
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Str64Ldr8_2(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr8_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x1, [x0, #8]
; CHECK-NEXT:    ubfx x0, x1, #16, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 10
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Str64Ldr8_3(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr8_3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x1, [x0, #8]
; CHECK-NEXT:    lsr w0, w1, #24
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 11
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Str64Ldr8_4(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr8_4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x1, [x0, #8]
; CHECK-NEXT:    ubfx x0, x1, #32, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 12
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Str64Ldr8_5(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr8_5:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x1, [x0, #8]
; CHECK-NEXT:    ubfx x0, x1, #40, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 13
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Str64Ldr8_6(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr8_6:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x1, [x0, #8]
; CHECK-NEXT:    ubfx x0, x1, #48, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 14
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Str64Ldr8_7(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Str64Ldr8_7:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x1, [x0, #8]
; CHECK-NEXT:    lsr x0, x1, #56
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 15
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i32 @Str32Ldr32(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Str32Ldr32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    str w1, [x8, #4]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i32, ptr %P, i64 1
  %0 = load i32, ptr %arrayidx1
  ret i32 %0
}

define i16 @Str32Ldr16_0(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Str32Ldr16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    str w1, [x8, #4]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 2
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i16 @Str32Ldr16_1(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Str32Ldr16_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str w1, [x0, #4]
; CHECK-NEXT:    lsr w0, w1, #16
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 3
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i8 @Str32Ldr8_0(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Str32Ldr8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    str w1, [x8, #4]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 4
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Str32Ldr8_1(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Str32Ldr8_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str w1, [x0, #4]
; CHECK-NEXT:    ubfx w0, w1, #8, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 5
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Str32Ldr8_2(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Str32Ldr8_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str w1, [x0, #4]
; CHECK-NEXT:    ubfx w0, w1, #16, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 6
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Str32Ldr8_3(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Str32Ldr8_3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str w1, [x0, #4]
; CHECK-NEXT:    lsr w0, w1, #24
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 7
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i16 @Str16Ldr16(ptr nocapture %P, i16 %v, i64 %n) {
; CHECK-LABEL: Str16Ldr16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    strh w1, [x8, #2]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i16, ptr %P, i64 1
  store i16 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 1
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i8 @Str16Ldr8_0(ptr nocapture %P, i16 %v, i64 %n) {
; CHECK-LABEL: Str16Ldr8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    strh w1, [x8, #2]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i16, ptr %P, i64 1
  store i16 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 2
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Str16Ldr8_1(ptr nocapture %P, i16 %v, i64 %n) {
; CHECK-LABEL: Str16Ldr8_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    strh w1, [x0, #2]
; CHECK-NEXT:    ubfx w0, w1, #8, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i16, ptr %P, i64 1
  store i16 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 3
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}


define i64 @Unscaled_Str64Ldr64(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov x0, x1
; CHECK-NEXT:    stur x1, [x8, #-8]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i64, ptr %P, i64 -1
  %0 = load i64, ptr %arrayidx1
  ret i64 %0
}

define i32 @Unscaled_Str64Ldr32_0(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr32_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    stur x1, [x8, #-8]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i32, ptr %P, i64 -2
  %0 = load i32, ptr %arrayidx1
  ret i32 %0
}

define i32 @Unscaled_Str64Ldr32_1(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr32_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur x1, [x0, #-8]
; CHECK-NEXT:    lsr x0, x1, #32
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i32, ptr %P, i64 -1
  %0 = load i32, ptr %arrayidx1
  ret i32 %0
}

define i16 @Unscaled_Str64Ldr16_0(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    stur x1, [x8, #-8]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 -4
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i16 @Unscaled_Str64Ldr16_1(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr16_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur x1, [x0, #-8]
; CHECK-NEXT:    lsr w0, w1, #16
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 -3
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i16 @Unscaled_Str64Ldr16_2(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr16_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur x1, [x0, #-8]
; CHECK-NEXT:    ubfx x0, x1, #32, #16
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 -2
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i16 @Unscaled_Str64Ldr16_3(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr16_3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur x1, [x0, #-8]
; CHECK-NEXT:    lsr x0, x1, #48
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 -1
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i8 @Unscaled_Str64Ldr8_0(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    stur x1, [x8, #-8]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -8
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Unscaled_Str64Ldr8_1(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr8_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur x1, [x0, #-8]
; CHECK-NEXT:    ubfx x0, x1, #8, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -7
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Unscaled_Str64Ldr8_2(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr8_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur x1, [x0, #-8]
; CHECK-NEXT:    ubfx x0, x1, #16, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -6
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Unscaled_Str64Ldr8_3(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr8_3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur x1, [x0, #-8]
; CHECK-NEXT:    lsr w0, w1, #24
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -5
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Unscaled_Str64Ldr8_4(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr8_4:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur x1, [x0, #-8]
; CHECK-NEXT:    ubfx x0, x1, #32, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -4
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Unscaled_Str64Ldr8_5(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr8_5:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur x1, [x0, #-8]
; CHECK-NEXT:    ubfx x0, x1, #40, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -3
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Unscaled_Str64Ldr8_6(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr8_6:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur x1, [x0, #-8]
; CHECK-NEXT:    ubfx x0, x1, #48, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -2
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Unscaled_Str64Ldr8_7(ptr nocapture %P, i64 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str64Ldr8_7:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur x1, [x0, #-8]
; CHECK-NEXT:    lsr x0, x1, #56
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i64, ptr %P, i64 -1
  store i64 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -1
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i32 @Unscaled_Str32Ldr32(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str32Ldr32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    stur w1, [x8, #-4]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 -1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i32, ptr %P, i64 -1
  %0 = load i32, ptr %arrayidx1
  ret i32 %0
}

define i16 @Unscaled_Str32Ldr16_0(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str32Ldr16_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    stur w1, [x8, #-4]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 -1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 -2
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i16 @Unscaled_Str32Ldr16_1(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str32Ldr16_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur w1, [x0, #-4]
; CHECK-NEXT:    lsr w0, w1, #16
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 -1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 -1
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i8 @Unscaled_Str32Ldr8_0(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str32Ldr8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    stur w1, [x8, #-4]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 -1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -4
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Unscaled_Str32Ldr8_1(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str32Ldr8_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur w1, [x0, #-4]
; CHECK-NEXT:    ubfx w0, w1, #8, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 -1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -3
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Unscaled_Str32Ldr8_2(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str32Ldr8_2:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur w1, [x0, #-4]
; CHECK-NEXT:    ubfx w0, w1, #16, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 -1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -2
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Unscaled_Str32Ldr8_3(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str32Ldr8_3:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stur w1, [x0, #-4]
; CHECK-NEXT:    lsr w0, w1, #24
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 -1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -1
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i16 @Unscaled_Str16Ldr16(ptr nocapture %P, i16 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str16Ldr16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    sturh w1, [x8, #-2]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i16, ptr %P, i64 -1
  store i16 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 -1
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i8 @Unscaled_Str16Ldr8_0(ptr nocapture %P, i16 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str16Ldr8_0:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    mov w0, w1
; CHECK-NEXT:    sturh w1, [x8, #-2]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i16, ptr %P, i64 -1
  store i16 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -2
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i8 @Unscaled_Str16Ldr8_1(ptr nocapture %P, i16 %v, i64 %n) {
; CHECK-LABEL: Unscaled_Str16Ldr8_1:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    sturh w1, [x0, #-2]
; CHECK-NEXT:    ubfx w0, w1, #8, #8
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i16, ptr %P, i64 -1
  store i16 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i8, ptr %P, i64 -1
  %0 = load i8, ptr %arrayidx1
  ret i8 %0
}

define i16 @StrVolatileLdr(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: StrVolatileLdr:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str w1, [x0, #4]
; CHECK-NEXT:    ldrh w0, [x0, #4]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 2
  %0 = load volatile i16, ptr %arrayidx1
  ret i16 %0
}

define i16 @StrNotInRangeLdr(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: StrNotInRangeLdr:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    ldrh w0, [x0, #2]
; CHECK-NEXT:    str w1, [x8, #4]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 1
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i16 @Unscaled_StrNotInRangeLdr(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: Unscaled_StrNotInRangeLdr:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    mov x8, x0
; CHECK-NEXT:    ldurh w0, [x0, #-6]
; CHECK-NEXT:    stur w1, [x8, #-4]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 -1
  store i32 %v, ptr %arrayidx0
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 -3
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

define i16 @StrCallLdr(ptr nocapture %P, i32 %v, i64 %n) {
; CHECK-LABEL: StrCallLdr:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    stp x30, x19, [sp, #-16]! // 16-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w19, -8
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    mov x19, x0
; CHECK-NEXT:    str w1, [x0, #4]
; CHECK-NEXT:    bl test_dummy
; CHECK-NEXT:    ldrh w0, [x19, #2]
; CHECK-NEXT:    ldp x30, x19, [sp], #16 // 16-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 %v, ptr %arrayidx0
  %c = call i1 @test_dummy()
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 1
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}

declare i1 @test_dummy()

define i16 @StrStrLdr(i32 %v, ptr %P, ptr %P2, i32 %n) {
; CHECK-LABEL: StrStrLdr:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str w0, [x1, #4]
; CHECK-NEXT:    str w3, [x2]
; CHECK-NEXT:    ldrh w0, [x1, #4]
; CHECK-NEXT:    ret
entry:
  %arrayidx0 = getelementptr inbounds i32, ptr %P, i64 1
  store i32 %v, ptr %arrayidx0
  store i32 %n, ptr %P2
  %arrayidx1 = getelementptr inbounds i16, ptr %P, i64 2
  %0 = load i16, ptr %arrayidx1
  ret i16 %0
}
