; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=aarch64-none-eabi -o - %s | FileCheck %s

define <2 x i64> @v2i64_02(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: v2i64_02:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    zip1 v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ret
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <2 x i32> <i32 0, i32 2>
  %d = zext <2 x i32> %c to <2 x i64>
  ret <2 x i64> %d
}

define <2 x i64> @v2i64_13(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: v2i64_13:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ext v1.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    zip2 v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ret
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <2 x i32> <i32 1, i32 3>
  %d = zext <2 x i32> %c to <2 x i64>
  ret <2 x i64> %d
}

define <2 x i64> @v2i64_04812(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: v2i64_04812:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip1 v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ret
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <2 x i32> <i32 0, i32 4>
  %d = zext <2 x i32> %c to <2 x i64>
  ret <2 x i64> %d
}

define <2 x i64> @v2i64_15913(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: v2i64_15913:
; CHECK:       // %bb.0:
; CHECK-NEXT:    zip2 v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ret
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <2 x i32> <i32 1, i32 5>
  %d = zext <2 x i32> %c to <2 x i64>
  ret <2 x i64> %d
}

define <2 x i64> @v2i64_261014(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: v2i64_261014:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ext v1.16b, v1.16b, v1.16b, #8
; CHECK-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    zip1 v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ret
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <2 x i32> <i32 2, i32 6>
  %d = zext <2 x i32> %c to <2 x i64>
  ret <2 x i64> %d
}

define <2 x i64> @v2i64_37(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: v2i64_37:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ext v1.16b, v1.16b, v1.16b, #8
; CHECK-NEXT:    ext v0.16b, v0.16b, v0.16b, #8
; CHECK-NEXT:    zip2 v0.2s, v0.2s, v1.2s
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ret
  %c = shufflevector <4 x i32> %a, <4 x i32> %b, <2 x i32> <i32 3, i32 7>
  %d = zext <2 x i32> %c to <2 x i64>
  ret <2 x i64> %d
}

define <4 x i64> @v2i64_i16_04812(<16 x i16> %a) {
; CHECK-LABEL: v2i64_i16_04812:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v2.2d, #0x00ffff0000ffff
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ushll2 v1.2d, v0.4s, #0
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ret
  %s1 = shufflevector <16 x i16> %a, <16 x i16> undef, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %z1 = zext <4 x i16> %s1 to <4 x i64>
  ret <4 x i64> %z1
}

define <4 x i64> @v2i64_i16_15913(<16 x i16> %a) {
; CHECK-LABEL: v2i64_i16_15913:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v2.2d, #0x0000000000ffff
; CHECK-NEXT:    ushr v0.2d, v0.2d, #16
; CHECK-NEXT:    ushr v1.2d, v1.2d, #16
; CHECK-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    and v1.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %s1 = shufflevector <16 x i16> %a, <16 x i16> undef, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %z1 = zext <4 x i16> %s1 to <4 x i64>
  ret <4 x i64> %z1
}

define <4 x i64> @v2i64_i16_261014(<16 x i16> %a) {
; CHECK-LABEL: v2i64_i16_261014:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v2.2d, #0x00ffff0000ffff
; CHECK-NEXT:    uzp2 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ushll2 v1.2d, v0.4s, #0
; CHECK-NEXT:    ushll v0.2d, v0.2s, #0
; CHECK-NEXT:    ret
  %s1 = shufflevector <16 x i16> %a, <16 x i16> undef, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %z1 = zext <4 x i16> %s1 to <4 x i64>
  ret <4 x i64> %z1
}

define <4 x i64> @v2i64_i16_371115(<16 x i16> %a) {
; CHECK-LABEL: v2i64_i16_371115:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.2d, v0.2d, #48
; CHECK-NEXT:    ushr v1.2d, v1.2d, #48
; CHECK-NEXT:    ret
  %s1 = shufflevector <16 x i16> %a, <16 x i16> undef, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %z1 = zext <4 x i16> %s1 to <4 x i64>
  ret <4 x i64> %z1
}


define <4 x i32> @v4i32_0246(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: v4i32_0246:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0x00ffff0000ffff
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %c = shufflevector <8 x i16> %a, <8 x i16> %b, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %d = zext <4 x i16> %c to <4 x i32>
  ret <4 x i32> %d
}

define <4 x i32> @v4i32_1357(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: v4i32_1357:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.4s, v0.4s, #16
; CHECK-NEXT:    ret
  %c = shufflevector <8 x i16> %a, <8 x i16> %b, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %d = zext <4 x i16> %c to <4 x i32>
  ret <4 x i32> %d
}

define <4 x i32> @v4i32_04812(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: v4i32_04812:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v2.2d, #0x00ffff0000ffff
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ret
  %c = shufflevector <8 x i16> %a, <8 x i16> %b, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %d = zext <4 x i16> %c to <4 x i32>
  ret <4 x i32> %d
}

define <4 x i32> @v4i32_15913(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: v4i32_15913:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ushr v0.4s, v0.4s, #16
; CHECK-NEXT:    ret
  %c = shufflevector <8 x i16> %a, <8 x i16> %b, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %d = zext <4 x i16> %c to <4 x i32>
  ret <4 x i32> %d
}

define <4 x i32> @v4i32_261014(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: v4i32_261014:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v2.2d, #0x00ffff0000ffff
; CHECK-NEXT:    uzp2 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    ret
  %c = shufflevector <8 x i16> %a, <8 x i16> %b, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %d = zext <4 x i16> %c to <4 x i32>
  ret <4 x i32> %d
}

define <4 x i32> @v4i32_371115(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: v4i32_371115:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp2 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    ushr v0.4s, v0.4s, #16
; CHECK-NEXT:    ret
  %c = shufflevector <8 x i16> %a, <8 x i16> %b, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %d = zext <4 x i16> %c to <4 x i32>
  ret <4 x i32> %d
}


define <8 x i16> @v8i16_0246(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i16_0246:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.8h, #255, lsl #8
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %d = zext <8 x i8> %c to <8 x i16>
  ret <8 x i16> %d
}

define <8 x i16> @v8i16_1357(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i16_1357:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.8h, v0.8h, #8
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %d = zext <8 x i8> %c to <8 x i16>
  ret <8 x i16> %d
}

define <8 x i16> @v8i16_04812(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i16_04812:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    bic v0.8h, #255, lsl #8
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
  %d = zext <8 x i8> %c to <8 x i16>
  ret <8 x i16> %d
}

define <8 x i16> @v8i16_15913(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i16_15913:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ushr v0.8h, v0.8h, #8
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
  %d = zext <8 x i8> %c to <8 x i16>
  ret <8 x i16> %d
}

define <8 x i16> @v8i16_261014(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i16_261014:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp2 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    bic v0.8h, #255, lsl #8
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
  %d = zext <8 x i8> %c to <8 x i16>
  ret <8 x i16> %d
}

define <8 x i16> @v8i16_371115(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i16_371115:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp2 v0.8h, v0.8h, v1.8h
; CHECK-NEXT:    ushr v0.8h, v0.8h, #8
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
  %d = zext <8 x i8> %c to <8 x i16>
  ret <8 x i16> %d
}


define <8 x i32> @v8i32_0246(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i32_0246:
; CHECK:       // %bb.0:
; CHECK-NEXT:    bic v0.8h, #255, lsl #8
; CHECK-NEXT:    ushll2 v1.4s, v0.8h, #0
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %d = zext <8 x i8> %c to <8 x i32>
  ret <8 x i32> %d
}

define <8 x i32> @v8i32_1357(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i32_1357:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.8h, v0.8h, #8
; CHECK-NEXT:    ushll2 v1.4s, v0.8h, #0
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %d = zext <8 x i8> %c to <8 x i32>
  ret <8 x i32> %d
}

define <8 x i32> @v8i32_04812(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i32_04812:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v2.2d, #0x0000ff000000ff
; CHECK-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    and v1.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
  %d = zext <8 x i8> %c to <8 x i32>
  ret <8 x i32> %d
}

define <8 x i32> @v8i32_15913(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i32_15913:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v2.2d, #0x0000ff000000ff
; CHECK-NEXT:    ushr v0.4s, v0.4s, #8
; CHECK-NEXT:    ushr v1.4s, v1.4s, #8
; CHECK-NEXT:    and v0.16b, v0.16b, v2.16b
; CHECK-NEXT:    and v1.16b, v1.16b, v2.16b
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
  %d = zext <8 x i8> %c to <8 x i32>
  ret <8 x i32> %d
}

define <8 x i32> @v8i32_261014(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i32_261014:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.4s, v0.4s, #16
; CHECK-NEXT:    ushr v1.4s, v1.4s, #16
; CHECK-NEXT:    bic v0.4s, #255, lsl #8
; CHECK-NEXT:    bic v1.4s, #255, lsl #8
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
  %d = zext <8 x i8> %c to <8 x i32>
  ret <8 x i32> %d
}

define <8 x i32> @v8i32_371115(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: v8i32_371115:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ushr v0.4s, v0.4s, #24
; CHECK-NEXT:    ushr v1.4s, v1.4s, #24
; CHECK-NEXT:    ret
  %c = shufflevector <16 x i8> %a, <16 x i8> %b, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
  %d = zext <8 x i8> %c to <8 x i32>
  ret <8 x i32> %d
}


define <8 x i64> @zext_add(<32 x i16> %l) {
; CHECK-LABEL: zext_add:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v4.2d, #0x00ffff0000ffff
; CHECK-NEXT:    uzp1 v5.4s, v0.4s, v1.4s
; CHECK-NEXT:    uzp2 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-NEXT:    uzp2 v2.4s, v2.4s, v3.4s
; CHECK-NEXT:    and v3.16b, v5.16b, v4.16b
; CHECK-NEXT:    and v6.16b, v0.16b, v4.16b
; CHECK-NEXT:    and v7.16b, v1.16b, v4.16b
; CHECK-NEXT:    and v4.16b, v2.16b, v4.16b
; CHECK-NEXT:    usra v3.4s, v5.4s, #16
; CHECK-NEXT:    usra v6.4s, v0.4s, #16
; CHECK-NEXT:    usra v7.4s, v1.4s, #16
; CHECK-NEXT:    usra v4.4s, v2.4s, #16
; CHECK-NEXT:    uaddl v0.2d, v3.2s, v6.2s
; CHECK-NEXT:    uaddl2 v1.2d, v3.4s, v6.4s
; CHECK-NEXT:    uaddl2 v3.2d, v7.4s, v4.4s
; CHECK-NEXT:    uaddl v2.2d, v7.2s, v4.2s
; CHECK-NEXT:    ret
    %s1 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
    %z1 = zext <8 x i16> %s1 to <8 x i64>
    %s2 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
    %z2 = zext <8 x i16> %s2 to <8 x i64>
    %s3 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
    %z3 = zext <8 x i16> %s3 to <8 x i64>
    %s4 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
    %z4 = zext <8 x i16> %s4 to <8 x i64>
    %a = add <8 x i64> %z1, %z2
    %b = add <8 x i64> %z3, %z4
    %c = add <8 x i64> %a, %b
    ret <8 x i64> %c
}

define <8 x i64> @zext_load_add(ptr %p) {
; CHECK-LABEL: zext_load_add:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ld4 { v0.8h, v1.8h, v2.8h, v3.8h }, [x0]
; CHECK-NEXT:    uaddl v4.4s, v0.4h, v1.4h
; CHECK-NEXT:    uaddl v5.4s, v2.4h, v3.4h
; CHECK-NEXT:    uaddl2 v6.4s, v0.8h, v1.8h
; CHECK-NEXT:    uaddl2 v2.4s, v2.8h, v3.8h
; CHECK-NEXT:    uaddl v0.2d, v4.2s, v5.2s
; CHECK-NEXT:    uaddl2 v1.2d, v4.4s, v5.4s
; CHECK-NEXT:    uaddl2 v3.2d, v6.4s, v2.4s
; CHECK-NEXT:    uaddl v2.2d, v6.2s, v2.2s
; CHECK-NEXT:    ret
    %l = load <32 x i16>, ptr %p
    %s1 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
    %z1 = zext <8 x i16> %s1 to <8 x i64>
    %s2 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
    %z2 = zext <8 x i16> %s2 to <8 x i64>
    %s3 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
    %z3 = zext <8 x i16> %s3 to <8 x i64>
    %s4 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
    %z4 = zext <8 x i16> %s4 to <8 x i64>
    %a = add <8 x i64> %z1, %z2
    %b = add <8 x i64> %z3, %z4
    %c = add <8 x i64> %a, %b
    ret <8 x i64> %c
}

define <8 x double> @uitofp_fadd(<32 x i16> %l) {
; CHECK-LABEL: uitofp_fadd:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v4.2d, #0x0000000000ffff
; CHECK-NEXT:    ushr v5.2d, v0.2d, #16
; CHECK-NEXT:    ushr v6.2d, v1.2d, #16
; CHECK-NEXT:    ushr v7.2d, v2.2d, #16
; CHECK-NEXT:    ushr v17.2d, v3.2d, #16
; CHECK-NEXT:    ushr v20.2d, v0.2d, #32
; CHECK-NEXT:    ushr v22.2d, v1.2d, #32
; CHECK-NEXT:    ushr v23.2d, v2.2d, #32
; CHECK-NEXT:    ushr v24.2d, v3.2d, #32
; CHECK-NEXT:    and v16.16b, v0.16b, v4.16b
; CHECK-NEXT:    and v18.16b, v1.16b, v4.16b
; CHECK-NEXT:    and v19.16b, v2.16b, v4.16b
; CHECK-NEXT:    and v21.16b, v3.16b, v4.16b
; CHECK-NEXT:    and v5.16b, v5.16b, v4.16b
; CHECK-NEXT:    and v6.16b, v6.16b, v4.16b
; CHECK-NEXT:    and v7.16b, v7.16b, v4.16b
; CHECK-NEXT:    and v17.16b, v17.16b, v4.16b
; CHECK-NEXT:    and v20.16b, v20.16b, v4.16b
; CHECK-NEXT:    and v22.16b, v22.16b, v4.16b
; CHECK-NEXT:    and v23.16b, v23.16b, v4.16b
; CHECK-NEXT:    and v4.16b, v24.16b, v4.16b
; CHECK-NEXT:    ushr v0.2d, v0.2d, #48
; CHECK-NEXT:    ushr v1.2d, v1.2d, #48
; CHECK-NEXT:    ushr v2.2d, v2.2d, #48
; CHECK-NEXT:    ushr v3.2d, v3.2d, #48
; CHECK-NEXT:    ucvtf v16.2d, v16.2d
; CHECK-NEXT:    ucvtf v18.2d, v18.2d
; CHECK-NEXT:    ucvtf v19.2d, v19.2d
; CHECK-NEXT:    ucvtf v21.2d, v21.2d
; CHECK-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-NEXT:    ucvtf v17.2d, v17.2d
; CHECK-NEXT:    ucvtf v20.2d, v20.2d
; CHECK-NEXT:    ucvtf v22.2d, v22.2d
; CHECK-NEXT:    ucvtf v23.2d, v23.2d
; CHECK-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-NEXT:    fadd v5.2d, v16.2d, v5.2d
; CHECK-NEXT:    fadd v17.2d, v21.2d, v17.2d
; CHECK-NEXT:    fadd v7.2d, v19.2d, v7.2d
; CHECK-NEXT:    fadd v6.2d, v18.2d, v6.2d
; CHECK-NEXT:    fadd v0.2d, v20.2d, v0.2d
; CHECK-NEXT:    fadd v1.2d, v22.2d, v1.2d
; CHECK-NEXT:    fadd v3.2d, v4.2d, v3.2d
; CHECK-NEXT:    fadd v2.2d, v23.2d, v2.2d
; CHECK-NEXT:    fadd v0.2d, v5.2d, v0.2d
; CHECK-NEXT:    fadd v1.2d, v6.2d, v1.2d
; CHECK-NEXT:    fadd v2.2d, v7.2d, v2.2d
; CHECK-NEXT:    fadd v3.2d, v17.2d, v3.2d
; CHECK-NEXT:    ret
    %s1 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
    %z1 = uitofp <8 x i16> %s1 to <8 x double>
    %s2 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
    %z2 = uitofp <8 x i16> %s2 to <8 x double>
    %s3 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
    %z3 = uitofp <8 x i16> %s3 to <8 x double>
    %s4 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
    %z4 = uitofp <8 x i16> %s4 to <8 x double>
    %a = fadd <8 x double> %z1, %z2
    %b = fadd <8 x double> %z3, %z4
    %c = fadd <8 x double> %a, %b
    ret <8 x double> %c
}

define <8 x double> @uitofp_load_fadd(ptr %p) {
; CHECK-LABEL: uitofp_load_fadd:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    movi v0.2d, #0x0000000000ffff
; CHECK-NEXT:    ldp q3, q4, [x0, #32]
; CHECK-NEXT:    ushr v5.2d, v1.2d, #16
; CHECK-NEXT:    ushr v6.2d, v2.2d, #16
; CHECK-NEXT:    ushr v20.2d, v1.2d, #32
; CHECK-NEXT:    ushr v7.2d, v3.2d, #16
; CHECK-NEXT:    ushr v17.2d, v4.2d, #16
; CHECK-NEXT:    ushr v22.2d, v2.2d, #32
; CHECK-NEXT:    ushr v23.2d, v3.2d, #32
; CHECK-NEXT:    ushr v24.2d, v4.2d, #32
; CHECK-NEXT:    and v16.16b, v1.16b, v0.16b
; CHECK-NEXT:    and v18.16b, v2.16b, v0.16b
; CHECK-NEXT:    and v19.16b, v3.16b, v0.16b
; CHECK-NEXT:    and v21.16b, v4.16b, v0.16b
; CHECK-NEXT:    and v5.16b, v5.16b, v0.16b
; CHECK-NEXT:    and v6.16b, v6.16b, v0.16b
; CHECK-NEXT:    and v7.16b, v7.16b, v0.16b
; CHECK-NEXT:    and v17.16b, v17.16b, v0.16b
; CHECK-NEXT:    and v20.16b, v20.16b, v0.16b
; CHECK-NEXT:    and v22.16b, v22.16b, v0.16b
; CHECK-NEXT:    and v23.16b, v23.16b, v0.16b
; CHECK-NEXT:    and v0.16b, v24.16b, v0.16b
; CHECK-NEXT:    ushr v1.2d, v1.2d, #48
; CHECK-NEXT:    ushr v2.2d, v2.2d, #48
; CHECK-NEXT:    ushr v3.2d, v3.2d, #48
; CHECK-NEXT:    ushr v4.2d, v4.2d, #48
; CHECK-NEXT:    ucvtf v16.2d, v16.2d
; CHECK-NEXT:    ucvtf v18.2d, v18.2d
; CHECK-NEXT:    ucvtf v19.2d, v19.2d
; CHECK-NEXT:    ucvtf v21.2d, v21.2d
; CHECK-NEXT:    ucvtf v5.2d, v5.2d
; CHECK-NEXT:    ucvtf v6.2d, v6.2d
; CHECK-NEXT:    ucvtf v7.2d, v7.2d
; CHECK-NEXT:    ucvtf v17.2d, v17.2d
; CHECK-NEXT:    ucvtf v20.2d, v20.2d
; CHECK-NEXT:    ucvtf v22.2d, v22.2d
; CHECK-NEXT:    ucvtf v23.2d, v23.2d
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-NEXT:    ucvtf v2.2d, v2.2d
; CHECK-NEXT:    ucvtf v3.2d, v3.2d
; CHECK-NEXT:    ucvtf v4.2d, v4.2d
; CHECK-NEXT:    fadd v6.2d, v18.2d, v6.2d
; CHECK-NEXT:    fadd v5.2d, v16.2d, v5.2d
; CHECK-NEXT:    fadd v17.2d, v21.2d, v17.2d
; CHECK-NEXT:    fadd v7.2d, v19.2d, v7.2d
; CHECK-NEXT:    fadd v1.2d, v20.2d, v1.2d
; CHECK-NEXT:    fadd v3.2d, v23.2d, v3.2d
; CHECK-NEXT:    fadd v2.2d, v22.2d, v2.2d
; CHECK-NEXT:    fadd v4.2d, v0.2d, v4.2d
; CHECK-NEXT:    fadd v0.2d, v5.2d, v1.2d
; CHECK-NEXT:    fadd v1.2d, v6.2d, v2.2d
; CHECK-NEXT:    fadd v2.2d, v7.2d, v3.2d
; CHECK-NEXT:    fadd v3.2d, v17.2d, v4.2d
; CHECK-NEXT:    ret
    %l = load <32 x i16>, ptr %p
    %s1 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
    %z1 = uitofp <8 x i16> %s1 to <8 x double>
    %s2 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
    %z2 = uitofp <8 x i16> %s2 to <8 x double>
    %s3 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
    %z3 = uitofp <8 x i16> %s3 to <8 x double>
    %s4 = shufflevector <32 x i16> %l, <32 x i16> undef, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
    %z4 = uitofp <8 x i16> %s4 to <8 x double>
    %a = fadd <8 x double> %z1, %z2
    %b = fadd <8 x double> %z3, %z4
    %c = fadd <8 x double> %a, %b
    ret <8 x double> %c
}

define <4 x i32> @isUndefDeInterleave_b0(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: isUndefDeInterleave_b0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0x00ffff0000ffff
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %2 = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 poison, i32 poison, i32 0, i32 4, i32 poison, i32 poison, i32 poison, i32 poison>
  %s2 = shufflevector <8 x i16> %2, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = zext <4 x i16> %s2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @isUndefDeInterleave_b1(<8 x i16> %a) {
; CHECK-LABEL: isUndefDeInterleave_b1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    ushr v0.4s, v0.4s, #16
; CHECK-NEXT:    ret
  %2 = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 poison, i32 poison, i32 1, i32 5, i32 poison, i32 poison, i32 poison, i32 poison>
  %s2 = shufflevector <8 x i16> %2, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = zext <4 x i16> %s2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @isUndefDeInterleave_b2(<8 x i16> %a) {
; CHECK-LABEL: isUndefDeInterleave_b2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0x00ffff0000ffff
; CHECK-NEXT:    uzp2 v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %2 = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 poison, i32 poison, i32 2, i32 6, i32 poison, i32 poison, i32 poison, i32 poison>
  %s2 = shufflevector <8 x i16> %2, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = zext <4 x i16> %s2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @isUndefDeInterleave_b3(<8 x i16> %a) {
; CHECK-LABEL: isUndefDeInterleave_b3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp2 v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    ushr v0.4s, v0.4s, #16
; CHECK-NEXT:    ret
  %2 = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 poison, i32 poison, i32 3, i32 7, i32 poison, i32 poison, i32 poison, i32 poison>
  %s2 = shufflevector <8 x i16> %2, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = zext <4 x i16> %s2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @isUndefDeInterleave_t0(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: isUndefDeInterleave_t0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0x00ffff0000ffff
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %2 = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 0, i32 4>
  %s2 = shufflevector <8 x i16> %2, <8 x i16> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %3 = zext <4 x i16> %s2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @isUndefDeInterleave_t1(<8 x i16> %a) {
; CHECK-LABEL: isUndefDeInterleave_t1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    ushr v0.4s, v0.4s, #16
; CHECK-NEXT:    ret
  %2 = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 1, i32 5>
  %s2 = shufflevector <8 x i16> %2, <8 x i16> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %3 = zext <4 x i16> %s2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @isUndefDeInterleave_t2(<8 x i16> %a) {
; CHECK-LABEL: isUndefDeInterleave_t2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movi v1.2d, #0x00ffff0000ffff
; CHECK-NEXT:    uzp2 v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    and v0.16b, v0.16b, v1.16b
; CHECK-NEXT:    ret
  %2 = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 2, i32 6>
  %s2 = shufflevector <8 x i16> %2, <8 x i16> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %3 = zext <4 x i16> %s2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @isUndefDeInterleave_t3(<8 x i16> %a) {
; CHECK-LABEL: isUndefDeInterleave_t3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uzp2 v0.4s, v0.4s, v0.4s
; CHECK-NEXT:    ushr v0.4s, v0.4s, #16
; CHECK-NEXT:    ret
  %2 = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 poison, i32 3, i32 7>
  %s2 = shufflevector <8 x i16> %2, <8 x i16> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %3 = zext <4 x i16> %s2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @isUndefDeInterleave_b0_bad(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: isUndefDeInterleave_b0_bad:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI40_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI40_0]
; CHECK-NEXT:    tbl v0.16b, { v0.16b }, v1.16b
; CHECK-NEXT:    ushll v0.4s, v0.4h, #0
; CHECK-NEXT:    ret
  %2 = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 4, i32 4, i32 0, i32 4, i32 poison, i32 poison, i32 poison, i32 poison>
  %s2 = shufflevector <8 x i16> %2, <8 x i16> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  %3 = zext <4 x i16> %s2 to <4 x i32>
  ret <4 x i32> %3
}

define <4 x i32> @isUndefDeInterleave_t1_bad(<8 x i16> %a) {
; CHECK-LABEL: isUndefDeInterleave_t1_bad:
; CHECK:       // %bb.0:
; CHECK-NEXT:    adrp x8, .LCPI41_0
; CHECK-NEXT:    ldr q1, [x8, :lo12:.LCPI41_0]
; CHECK-NEXT:    tbl v0.16b, { v0.16b }, v1.16b
; CHECK-NEXT:    ushll2 v0.4s, v0.8h, #0
; CHECK-NEXT:    ret
  %2 = shufflevector <8 x i16> %a, <8 x i16> poison, <8 x i32> <i32 poison, i32 poison, i32 poison, i32 poison, i32 4, i32 4, i32 1, i32 5>
  %s2 = shufflevector <8 x i16> %2, <8 x i16> poison, <4 x i32> <i32 4, i32 5, i32 6, i32 7>
  %3 = zext <4 x i16> %s2 to <4 x i32>
  ret <4 x i32> %3
}

define i16 @undeftop(<8 x i16> %0) {
; CHECK-LABEL: undeftop:
; CHECK:       // %bb.0:
; CHECK-NEXT:    dup v0.8h, v0.h[4]
; CHECK-NEXT:    uaddl v0.4s, v0.4h, v0.4h
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    umov w0, v0.h[0]
; CHECK-NEXT:    ret
  %2 = shufflevector <8 x i16> %0, <8 x i16> zeroinitializer, <8 x i32> <i32 4, i32 5, i32 6, i32 7, i32 9, i32 7, i32 5, i32 3>
  %3 = zext <8 x i16> %2 to <8 x i64>
  %new0 = add <8 x i64> %3, %3
  %last = trunc <8 x i64> %new0 to <8 x i16>
  %4 = extractelement <8 x i16> %last, i32 0
  ret i16 %4
}
