; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=nsan -nsan-shadow-type-mapping=dqq -S %s | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"

; Tests for invoke instructions that require special handling of the phis.

declare float @may_throw()

declare void @personalityFn()

define float @invoke1() sanitize_numerical_stability personality void ()* @personalityFn {
; CHECK-LABEL: @invoke1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C:%.*]] = invoke float @may_throw()
; CHECK-NEXT:            to label [[TMP0:%.*]] unwind label [[LAND:%.*]]
; CHECK:       0:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__nsan_shadow_ret_tag, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], ptrtoint (ptr @may_throw to i64)
; CHECK-NEXT:    [[TMP3:%.*]] = load double, ptr @__nsan_shadow_ret_ptr, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = fpext float [[C]] to double
; CHECK-NEXT:    [[TMP5:%.*]] = select i1 [[TMP2]], double [[TMP3]], double [[TMP4]]
; CHECK-NEXT:    br label [[CONTINUE:%.*]]
; CHECK:       continue:
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       land:
; CHECK-NEXT:    [[RES:%.*]] = landingpad { ptr, i32 }
; CHECK-NEXT:            cleanup
; CHECK-NEXT:    [[LV:%.*]] = uitofp i32 1 to float
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[R:%.*]] = phi float [ [[LV]], [[LAND]] ], [ [[C]], [[CONTINUE]] ]
; CHECK-NEXT:    [[TMP6:%.*]] = phi double [ 1.000000e+00, [[LAND]] ], [ [[TMP5]], [[CONTINUE]] ]
; CHECK-NEXT:    [[TMP7:%.*]] = call i32 @__nsan_internal_check_float_d(float [[R]], double [[TMP6]], i32 1, i64 0)
; CHECK-NEXT:    [[TMP8:%.*]] = icmp eq i32 [[TMP7]], 1
; CHECK-NEXT:    [[TMP9:%.*]] = fpext float [[R]] to double
; CHECK-NEXT:    [[TMP10:%.*]] = select i1 [[TMP8]], double [[TMP9]], double [[TMP6]]
; CHECK-NEXT:    store i64 ptrtoint (ptr @invoke1 to i64), ptr @__nsan_shadow_ret_tag, align 8
; CHECK-NEXT:    store double [[TMP10]], ptr @__nsan_shadow_ret_ptr, align 8
; CHECK-NEXT:    ret float [[R]]
;

entry:
  %c = invoke float @may_throw() to label %continue unwind label %land

continue:
  br label %exit

land:
  %res = landingpad { ptr, i32 } cleanup
  %lv = uitofp i32 1 to float
  br label %exit

exit:
  %r = phi float [ %lv, %land], [ %c, %continue ]
  ret float %r
}

define float @invoke2() sanitize_numerical_stability personality void ()* @personalityFn {
; CHECK-LABEL: @invoke2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C:%.*]] = invoke float @may_throw()
; CHECK-NEXT:            to label [[TMP0:%.*]] unwind label [[LAND:%.*]]
; CHECK:       0:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__nsan_shadow_ret_tag, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], ptrtoint (ptr @may_throw to i64)
; CHECK-NEXT:    [[TMP3:%.*]] = load double, ptr @__nsan_shadow_ret_ptr, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = fpext float [[C]] to double
; CHECK-NEXT:    [[TMP5:%.*]] = select i1 [[TMP2]], double [[TMP3]], double [[TMP4]]
; CHECK-NEXT:    br label [[CONTINUE:%.*]]
; CHECK:       continue:
; CHECK-NEXT:    [[CV:%.*]] = fadd float [[C]], 2.000000e+00
; CHECK-NEXT:    [[TMP6:%.*]] = fadd double [[TMP5]], 2.000000e+00
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       land:
; CHECK-NEXT:    [[RES:%.*]] = landingpad { ptr, i32 }
; CHECK-NEXT:            cleanup
; CHECK-NEXT:    [[LV:%.*]] = uitofp i32 1 to float
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[R:%.*]] = phi float [ [[LV]], [[LAND]] ], [ [[CV]], [[CONTINUE]] ]
; CHECK-NEXT:    [[TMP7:%.*]] = phi double [ 1.000000e+00, [[LAND]] ], [ [[TMP6]], [[CONTINUE]] ]
; CHECK-NEXT:    [[TMP8:%.*]] = call i32 @__nsan_internal_check_float_d(float [[R]], double [[TMP7]], i32 1, i64 0)
; CHECK-NEXT:    [[TMP9:%.*]] = icmp eq i32 [[TMP8]], 1
; CHECK-NEXT:    [[TMP10:%.*]] = fpext float [[R]] to double
; CHECK-NEXT:    [[TMP11:%.*]] = select i1 [[TMP9]], double [[TMP10]], double [[TMP7]]
; CHECK-NEXT:    store i64 ptrtoint (ptr @invoke2 to i64), ptr @__nsan_shadow_ret_tag, align 8
; CHECK-NEXT:    store double [[TMP11]], ptr @__nsan_shadow_ret_ptr, align 8
; CHECK-NEXT:    ret float [[R]]
;

entry:
  %c = invoke float @may_throw() to label %continue unwind label %land

continue:
  %cv = fadd float %c, 2.0
  br label %exit

land:
  %res = landingpad { ptr, i32 } cleanup
  %lv = uitofp i32 1 to float
  br label %exit

exit:
  %r = phi float [ %lv, %land], [ %cv, %continue ]
  ret float %r
}

define float @invoke3() sanitize_numerical_stability personality void ()* @personalityFn {
; CHECK-LABEL: @invoke3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[C:%.*]] = invoke float @may_throw()
; CHECK-NEXT:            to label [[TMP0:%.*]] unwind label [[LAND:%.*]]
; CHECK:       land:
; CHECK-NEXT:    [[RES:%.*]] = landingpad { ptr, i32 }
; CHECK-NEXT:            cleanup
; CHECK-NEXT:    [[LV:%.*]] = uitofp i32 1 to float
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       0:
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__nsan_shadow_ret_tag, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], ptrtoint (ptr @may_throw to i64)
; CHECK-NEXT:    [[TMP3:%.*]] = load double, ptr @__nsan_shadow_ret_ptr, align 8
; CHECK-NEXT:    [[TMP4:%.*]] = fpext float [[C]] to double
; CHECK-NEXT:    [[TMP5:%.*]] = select i1 [[TMP2]], double [[TMP3]], double [[TMP4]]
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[R:%.*]] = phi float [ [[LV]], [[LAND]] ], [ [[C]], [[TMP0]] ]
; CHECK-NEXT:    [[TMP6:%.*]] = phi double [ 1.000000e+00, [[LAND]] ], [ [[TMP5]], [[TMP0]] ]
; CHECK-NEXT:    [[TMP7:%.*]] = call i32 @__nsan_internal_check_float_d(float [[R]], double [[TMP6]], i32 1, i64 0)
; CHECK-NEXT:    [[TMP8:%.*]] = icmp eq i32 [[TMP7]], 1
; CHECK-NEXT:    [[TMP9:%.*]] = fpext float [[R]] to double
; CHECK-NEXT:    [[TMP10:%.*]] = select i1 [[TMP8]], double [[TMP9]], double [[TMP6]]
; CHECK-NEXT:    store i64 ptrtoint (ptr @invoke3 to i64), ptr @__nsan_shadow_ret_tag, align 8
; CHECK-NEXT:    store double [[TMP10]], ptr @__nsan_shadow_ret_ptr, align 8
; CHECK-NEXT:    ret float [[R]]
;

entry:
  %c = invoke float @may_throw() to label %exit unwind label %land

land:
  %res = landingpad { ptr, i32 } cleanup
  %lv = uitofp i32 1 to float
  br label %exit

exit:
  %r = phi float [ %lv, %land], [ %c, %entry ]
  ret float %r
}
