; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes='lower-matrix-intrinsics' -S < %s | FileCheck %s

define void @strided_store_3x2(<6 x i32> %in, ptr %out) {
; CHECK-LABEL: @strided_store_3x2(
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <6 x i32> [[IN:%.*]], <6 x i32> poison, <3 x i32> <i32 0, i32 1, i32 2>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <6 x i32> [[IN]], <6 x i32> poison, <3 x i32> <i32 3, i32 4, i32 5>
; CHECK-NEXT:    store <3 x i32> [[SPLIT]], ptr [[OUT:%.*]], align 4
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr i32, ptr [[OUT]], i64 5
; CHECK-NEXT:    store <3 x i32> [[SPLIT1]], ptr [[VEC_GEP]], align 4
; CHECK-NEXT:    ret void
;
  call void @llvm.matrix.column.major.store(<6 x i32> %in, ptr %out, i64 5, i1 false, i32 3, i32 2)
  ret void
}

define void @strided_store_3x2_nonconst_stride(<6 x i32> %in, i64 %stride, ptr %out) {
; CHECK-LABEL: @strided_store_3x2_nonconst_stride(
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <6 x i32> [[IN:%.*]], <6 x i32> poison, <3 x i32> <i32 0, i32 1, i32 2>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <6 x i32> [[IN]], <6 x i32> poison, <3 x i32> <i32 3, i32 4, i32 5>
; CHECK-NEXT:    [[VEC_START:%.*]] = mul i64 0, [[STRIDE:%.*]]
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr i32, ptr [[OUT:%.*]], i64 [[VEC_START]]
; CHECK-NEXT:    store <3 x i32> [[SPLIT]], ptr [[VEC_GEP]], align 4
; CHECK-NEXT:    [[VEC_START2:%.*]] = mul i64 1, [[STRIDE]]
; CHECK-NEXT:    [[VEC_GEP3:%.*]] = getelementptr i32, ptr [[OUT]], i64 [[VEC_START2]]
; CHECK-NEXT:    store <3 x i32> [[SPLIT1]], ptr [[VEC_GEP3]], align 4
; CHECK-NEXT:    ret void
;
  call void @llvm.matrix.column.major.store(<6 x i32> %in, ptr %out, i64 %stride, i1 false, i32 3, i32 2)
  ret void
}


declare void @llvm.matrix.column.major.store(<6 x i32>, ptr, i64, i1, i32, i32)

define void @strided_store_2x3(<10 x i32> %in, ptr %out) {
; CHECK-LABEL: @strided_store_2x3(
; CHECK-NEXT:    [[SPLIT:%.*]] = shufflevector <10 x i32> [[IN:%.*]], <10 x i32> poison, <2 x i32> <i32 0, i32 1>
; CHECK-NEXT:    [[SPLIT1:%.*]] = shufflevector <10 x i32> [[IN]], <10 x i32> poison, <2 x i32> <i32 2, i32 3>
; CHECK-NEXT:    [[SPLIT2:%.*]] = shufflevector <10 x i32> [[IN]], <10 x i32> poison, <2 x i32> <i32 4, i32 5>
; CHECK-NEXT:    [[SPLIT3:%.*]] = shufflevector <10 x i32> [[IN]], <10 x i32> poison, <2 x i32> <i32 6, i32 7>
; CHECK-NEXT:    [[SPLIT4:%.*]] = shufflevector <10 x i32> [[IN]], <10 x i32> poison, <2 x i32> <i32 8, i32 9>
; CHECK-NEXT:    store <2 x i32> [[SPLIT]], ptr [[OUT:%.*]], align 4
; CHECK-NEXT:    [[VEC_GEP:%.*]] = getelementptr i32, ptr [[OUT]], i64 4
; CHECK-NEXT:    store <2 x i32> [[SPLIT1]], ptr [[VEC_GEP]], align 4
; CHECK-NEXT:    [[VEC_GEP6:%.*]] = getelementptr i32, ptr [[OUT]], i64 8
; CHECK-NEXT:    store <2 x i32> [[SPLIT2]], ptr [[VEC_GEP6]], align 4
; CHECK-NEXT:    [[VEC_GEP8:%.*]] = getelementptr i32, ptr [[OUT]], i64 12
; CHECK-NEXT:    store <2 x i32> [[SPLIT3]], ptr [[VEC_GEP8]], align 4
; CHECK-NEXT:    [[VEC_GEP10:%.*]] = getelementptr i32, ptr [[OUT]], i64 16
; CHECK-NEXT:    store <2 x i32> [[SPLIT4]], ptr [[VEC_GEP10]], align 4
; CHECK-NEXT:    ret void
;
  call void @llvm.matrix.column.major.store.v10i32(<10 x i32> %in, ptr %out, i64 4, i1 false, i32 2, i32 5)
  ret void
}

declare void @llvm.matrix.column.major.store.v10i32(<10 x i32>, ptr, i64, i1, i32, i32)
