; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

target datalayout = "n8:16:32:64"

declare void @use(i8)
declare void @use_vec(<2 x i8>)

define i32 @select_icmp_eq_and_1_0_or_2(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_or_2(
; CHECK-NEXT:    [[AND:%.*]] = shl i32 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %or = or i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define i32 @select_icmp_eq_and_1_0_or_2_disjoint(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_or_2_disjoint(
; CHECK-NEXT:    [[AND:%.*]] = shl i32 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = or disjoint i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %or = or disjoint i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define i32 @select_icmp_eq_and_1_0_add_2_nsw_nuw(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_add_2_nsw_nuw(
; CHECK-NEXT:    [[AND:%.*]] = shl i32 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = add nuw nsw i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %or = add nsw nuw i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define <2 x i32> @select_icmp_eq_and_1_0_or_2_vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_or_2_vec(
; CHECK-NEXT:    [[AND:%.*]] = shl <2 x i32> [[X:%.*]], splat (i32 1)
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[AND]], splat (i32 2)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i32> [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and <2 x i32> %x, <i32 1, i32 1>
  %cmp = icmp eq <2 x i32> %and, zeroinitializer
  %or = or <2 x i32> %y, <i32 2, i32 2>
  %select = select <2 x i1> %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define <2 x i32> @select_icmp_eq_and_1_0_or_2_vec_poison1(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_or_2_vec_poison1(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i32> [[X:%.*]], <i32 1, i32 poison>
; CHECK-NEXT:    [[TMP1:%.*]] = shl nuw nsw <2 x i32> [[AND]], splat (i32 1)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i32> [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and <2 x i32> %x, <i32 1, i32 poison>
  %cmp = icmp eq <2 x i32> %and, zeroinitializer
  %or = or <2 x i32> %y, <i32 2, i32 2>
  %select = select <2 x i1> %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define <2 x i32> @select_icmp_eq_and_1_0_or_2_vec_poison2(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_or_2_vec_poison2(
; CHECK-NEXT:    [[AND:%.*]] = shl <2 x i32> [[X:%.*]], splat (i32 1)
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[AND]], splat (i32 2)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i32> [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and <2 x i32> %x, <i32 1, i32 1>
  %cmp = icmp eq <2 x i32> %and, <i32 0, i32 poison>
  %or = or <2 x i32> %y, <i32 2, i32 2>
  %select = select <2 x i1> %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define <2 x i32> @select_icmp_eq_and_1_0_or_2_vec_poison3(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_or_2_vec_poison3(
; CHECK-NEXT:    [[AND:%.*]] = shl <2 x i32> [[X:%.*]], splat (i32 1)
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[AND]], splat (i32 2)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i32> [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and <2 x i32> %x, <i32 1, i32 1>
  %cmp = icmp eq <2 x i32> %and, zeroinitializer
  %or = or <2 x i32> %y, <i32 2, i32 poison>
  %select = select <2 x i1> %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define i32 @select_icmp_eq_and_1_0_xor_2(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_xor_2(
; CHECK-NEXT:    [[AND:%.*]] = shl i32 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}

define i32 @select_icmp_eq_and_1_0_and_not_2(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_and_not_2(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -3
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[AND2]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %and2 = and i32 %y, -3
  %select = select i1 %cmp, i32 %y, i32 %and2
  ret i32 %select
}

define i32 @select_icmp_eq_and_32_0_or_8(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_32_0_or_8(
; CHECK-NEXT:    [[AND:%.*]] = lshr i32 [[X:%.*]], 2
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 8
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 32
  %cmp = icmp eq i32 %and, 0
  %or = or i32 %y, 8
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define <2 x i32> @select_icmp_eq_and_32_0_or_8_vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @select_icmp_eq_and_32_0_or_8_vec(
; CHECK-NEXT:    [[AND:%.*]] = lshr <2 x i32> [[X:%.*]], splat (i32 2)
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[AND]], splat (i32 8)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i32> [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and <2 x i32> %x, <i32 32, i32 32>
  %cmp = icmp eq <2 x i32> %and, zeroinitializer
  %or = or <2 x i32> %y, <i32 8, i32 8>
  %select = select <2 x i1> %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define i32 @select_icmp_eq_and_32_0_xor_8(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_32_0_xor_8(
; CHECK-NEXT:    [[AND:%.*]] = lshr i32 [[X:%.*]], 2
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 8
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 32
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %y, 8
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}

define i32 @select_icmp_eq_and_32_0_and_not_8(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_32_0_and_not_8(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 32
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -9
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[AND2]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 32
  %cmp = icmp eq i32 %and, 0
  %and2 = and i32 %y, -9
  %select = select i1 %cmp, i32 %y, i32 %and2
  ret i32 %select
}

define i32 @select_icmp_ne_0_and_4096_or_4096(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_4096_or_4096(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[AND]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %or = or i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define <2 x i32> @select_icmp_ne_0_and_4096_or_4096_vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_4096_or_4096_vec(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i32> [[X:%.*]], splat (i32 4096)
; CHECK-NEXT:    [[TMP1:%.*]] = xor <2 x i32> [[AND]], splat (i32 4096)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i32> [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and <2 x i32> %x, <i32 4096, i32 4096>
  %cmp = icmp ne <2 x i32> zeroinitializer, %and
  %or = or <2 x i32> %y, <i32 4096, i32 4096>
  %select = select <2 x i1> %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define i32 @select_icmp_ne_0_and_4096_xor_4096(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_4096_xor_4096(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[AND]], [[Y:%.*]]
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[TMP1]], 4096
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %xor = xor i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}

define i32 @select_icmp_ne_0_and_4096_and_not_4096(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_4096_and_not_4096(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -4097
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[AND2]], i32 [[Y]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %and2 = and i32 %y, -4097
  %select = select i1 %cmp, i32 %y, i32 %and2
  ret i32 %select
}

define i32 @select_icmp_eq_and_4096_0_or_4096(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_4096_0_or_4096(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[AND]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %or = or i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define <2 x i32> @select_icmp_eq_and_4096_0_or_4096_vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @select_icmp_eq_and_4096_0_or_4096_vec(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i32> [[X:%.*]], splat (i32 4096)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i32> [[Y:%.*]], [[AND]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and <2 x i32> %x, <i32 4096, i32 4096>
  %cmp = icmp eq <2 x i32> %and, zeroinitializer
  %or = or <2 x i32> %y, <i32 4096, i32 4096>
  %select = select <2 x i1> %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define i32 @select_icmp_eq_and_4096_0_xor_4096(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_4096_0_xor_4096(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[Y:%.*]], [[AND]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}

define i32 @select_icmp_eq_and_4096_0_and_not_4096(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_4096_0_and_not_4096(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -4097
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[AND2]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %and2 = and i32 %y, -4097
  %select = select i1 %cmp, i32 %y, i32 %and2
  ret i32 %select
}

define i32 @select_icmp_eq_0_and_1_or_1(i64 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_0_and_1_or_1(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[X:%.*]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 1
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i64 %x, 1
  %cmp = icmp eq i64 %and, 0
  %or = or i32 %y, 1
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define <2 x i32> @select_icmp_eq_0_and_1_or_1_vec(<2 x i64> %x, <2 x i32> %y) {
; CHECK-LABEL: @select_icmp_eq_0_and_1_or_1_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc <2 x i64> [[X:%.*]] to <2 x i32>
; CHECK-NEXT:    [[TMP2:%.*]] = and <2 x i32> [[TMP1]], splat (i32 1)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i32> [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and <2 x i64> %x, <i64 1, i64 1>
  %cmp = icmp eq <2 x i64> %and, zeroinitializer
  %or = or <2 x i32> %y, <i32 1, i32 1>
  %select = select <2 x i1> %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define i32 @select_icmp_eq_0_and_1_xor_1(i64 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_0_and_1_xor_1(
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[X:%.*]] to i32
; CHECK-NEXT:    [[TMP2:%.*]] = and i32 [[TMP1]], 1
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i64 %x, 1
  %cmp = icmp eq i64 %and, 0
  %xor = xor i32 %y, 1
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}

define i32 @select_icmp_eq_0_and_1_and_not_1(i64 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_0_and_1_and_not_1(
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i64 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -2
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[AND2]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i64 %x, 1
  %cmp = icmp eq i64 %and, 0
  %and2 = and i32 %y, -2
  %select = select i1 %cmp, i32 %y, i32 %and2
  ret i32 %select
}

define i32 @select_icmp_ne_0_and_4096_or_32(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_4096_or_32(
; CHECK-NEXT:    [[AND:%.*]] = lshr i32 [[X:%.*]], 7
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 32
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], 32
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %or = or i32 %y, 32
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define i32 @select_icmp_ne_0_and_4096_xor_32(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_4096_xor_32(
; CHECK-NEXT:    [[AND:%.*]] = lshr i32 [[X:%.*]], 7
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 32
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], [[Y:%.*]]
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[TMP2]], 32
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %xor = xor i32 %y, 32
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}

define i32 @select_icmp_ne_0_and_4096_and_not_32(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_4096_and_not_32(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -33
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[AND2]], i32 [[Y]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %and2 = and i32 %y, -33
  %select = select i1 %cmp, i32 %y, i32 %and2
  ret i32 %select
}

define i32 @select_icmp_ne_0_and_32_or_4096(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_32_or_4096(
; CHECK-NEXT:    [[AND:%.*]] = shl i32 [[X:%.*]], 7
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 4096
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 32
  %cmp = icmp ne i32 0, %and
  %or = or i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define <2 x i32> @select_icmp_ne_0_and_32_or_4096_vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_32_or_4096_vec(
; CHECK-NEXT:    [[AND:%.*]] = shl <2 x i32> [[X:%.*]], splat (i32 7)
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[AND]], splat (i32 4096)
; CHECK-NEXT:    [[TMP2:%.*]] = xor <2 x i32> [[TMP1]], splat (i32 4096)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i32> [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and <2 x i32> %x, <i32 32, i32 32>
  %cmp = icmp ne <2 x i32> zeroinitializer, %and
  %or = or <2 x i32> %y, <i32 4096, i32 4096>
  %select = select <2 x i1> %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define i32 @select_icmp_ne_0_and_32_xor_4096(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_32_xor_4096(
; CHECK-NEXT:    [[AND:%.*]] = shl i32 [[X:%.*]], 7
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 4096
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], [[Y:%.*]]
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[TMP2]], 4096
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 32
  %cmp = icmp ne i32 0, %and
  %xor = xor i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}

define i32 @select_icmp_ne_0_and_32_and_not_4096(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_32_and_not_4096(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 32
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -4097
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[AND2]], i32 [[Y]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 32
  %cmp = icmp ne i32 0, %and
  %and2 = and i32 %y, -4097
  %select = select i1 %cmp, i32 %y, i32 %and2
  ret i32 %select
}

define i8 @select_icmp_ne_0_and_1073741824_or_8(i32 %x, i8 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_1073741824_or_8(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1073741824
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[Y:%.*]], 8
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i8 [[OR]], i8 [[Y]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %and = and i32 %x, 1073741824
  %cmp = icmp ne i32 0, %and
  %or = or i8 %y, 8
  %select = select i1 %cmp, i8 %y, i8 %or
  ret i8 %select
}

define i8 @select_icmp_ne_0_and_1073741824_xor_8(i32 %x, i8 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_1073741824_xor_8(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1073741824
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i8 [[Y:%.*]], 8
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i8 [[XOR]], i8 [[Y]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %and = and i32 %x, 1073741824
  %cmp = icmp ne i32 0, %and
  %xor = xor i8 %y, 8
  %select = select i1 %cmp, i8 %y, i8 %xor
  ret i8 %select
}

define i8 @select_icmp_ne_0_and_1073741824_and_not_8(i32 %x, i8 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_1073741824_and_not_8(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1073741824
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i8 [[Y:%.*]], -9
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i8 [[AND2]], i8 [[Y]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %and = and i32 %x, 1073741824
  %cmp = icmp ne i32 0, %and
  %and2 = and i8 %y, -9
  %select = select i1 %cmp, i8 %y, i8 %and2
  ret i8 %select
}

define i32 @select_icmp_ne_0_and_8_or_1073741824(i8 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_8_or_1073741824(
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], 8
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[Y:%.*]], 1073741824
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[OR]], i32 [[Y]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i8 %x, 8
  %cmp = icmp ne i8 0, %and
  %or = or i32 %y, 1073741824
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define i32 @select_icmp_ne_0_and_8_xor_1073741824(i8 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_8_xor_1073741824(
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], 8
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[Y:%.*]], 1073741824
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[XOR]], i32 [[Y]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i8 %x, 8
  %cmp = icmp ne i8 0, %and
  %xor = xor i32 %y, 1073741824
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}

define i32 @select_icmp_ne_0_and_8_and_not_1073741824(i8 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_ne_0_and_8_and_not_1073741824(
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], 8
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -1073741825
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[AND2]], i32 [[Y]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i8 %x, 8
  %cmp = icmp ne i8 0, %and
  %and2 = and i32 %y, -1073741825
  %select = select i1 %cmp, i32 %y, i32 %and2
  ret i32 %select
}

; We can't combine here, because the cmp is scalar and the or vector.
; Just make sure we don't assert.
define <2 x i32> @select_icmp_eq_and_1_0_or_vector_of_2s(i32 %x, <2 x i32> %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_or_vector_of_2s(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i32> [[Y:%.*]], splat (i32 2)
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], <2 x i32> [[Y]], <2 x i32> [[OR]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %or = or <2 x i32> %y, <i32 2, i32 2>
  %select = select i1 %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define i32 @select_icmp_and_8_ne_0_xor_8(i32 %x) {
; CHECK-LABEL: @select_icmp_and_8_ne_0_xor_8(
; CHECK-NEXT:    [[X_XOR:%.*]] = and i32 [[X:%.*]], -9
; CHECK-NEXT:    ret i32 [[X_XOR]]
;
  %and = and i32 %x, 8
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %x, 8
  %x.xor = select i1 %cmp, i32 %x, i32 %xor
  ret i32 %x.xor
}

define i32 @select_icmp_and_8_eq_0_xor_8(i32 %x) {
; CHECK-LABEL: @select_icmp_and_8_eq_0_xor_8(
; CHECK-NEXT:    [[XOR_X:%.*]] = or i32 [[X:%.*]], 8
; CHECK-NEXT:    ret i32 [[XOR_X]]
;
  %and = and i32 %x, 8
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %x, 8
  %xor.x = select i1 %cmp, i32 %xor, i32 %x
  ret i32 %xor.x
}

define i64 @select_icmp_x_and_8_eq_0_y_xor_8(i32 %x, i64 %y) {
; CHECK-LABEL: @select_icmp_x_and_8_eq_0_y_xor_8(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP1:%.*]] = zext nneg i32 [[AND]] to i64
; CHECK-NEXT:    [[Y_XOR:%.*]] = xor i64 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i64 [[Y_XOR]]
;
  %and = and i32 %x, 8
  %cmp = icmp eq i32 %and, 0
  %xor = xor i64 %y, 8
  %y.xor = select i1 %cmp, i64 %y, i64 %xor
  ret i64 %y.xor
}

define i64 @select_icmp_x_and_8_ne_0_y_xor_8(i32 %x, i64 %y) {
; CHECK-LABEL: @select_icmp_x_and_8_ne_0_y_xor_8(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[AND]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = zext nneg i32 [[TMP1]] to i64
; CHECK-NEXT:    [[XOR_Y:%.*]] = xor i64 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i64 [[XOR_Y]]
;
  %and = and i32 %x, 8
  %cmp = icmp eq i32 %and, 0
  %xor = xor i64 %y, 8
  %xor.y = select i1 %cmp, i64 %xor, i64 %y
  ret i64 %xor.y
}

define i64 @select_icmp_x_and_8_ne_0_y_or_8(i32 %x, i64 %y) {
; CHECK-LABEL: @select_icmp_x_and_8_ne_0_y_or_8(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 8
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[AND]], 8
; CHECK-NEXT:    [[TMP2:%.*]] = zext nneg i32 [[TMP1]] to i64
; CHECK-NEXT:    [[OR_Y:%.*]] = or i64 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i64 [[OR_Y]]
;
  %and = and i32 %x, 8
  %cmp = icmp eq i32 %and, 0
  %or = or i64 %y, 8
  %or.y = select i1 %cmp, i64 %or, i64 %y
  ret i64 %or.y
}

define <2 x i64> @select_icmp_x_and_8_ne_0_y_or_8_vec(<2 x i32> %x, <2 x i64> %y) {
; CHECK-LABEL: @select_icmp_x_and_8_ne_0_y_or_8_vec(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i32> [[X:%.*]], splat (i32 8)
; CHECK-NEXT:    [[TMP1:%.*]] = xor <2 x i32> [[AND]], splat (i32 8)
; CHECK-NEXT:    [[TMP2:%.*]] = zext nneg <2 x i32> [[TMP1]] to <2 x i64>
; CHECK-NEXT:    [[OR_Y:%.*]] = or <2 x i64> [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret <2 x i64> [[OR_Y]]
;
  %and = and <2 x i32> %x, <i32 8, i32 8>
  %cmp = icmp eq <2 x i32> %and, zeroinitializer
  %or = or <2 x i64> %y, <i64 8, i64 8>
  %or.y = select <2 x i1> %cmp, <2 x i64> %or, <2 x i64> %y
  ret <2 x i64> %or.y
}

define i64 @select_icmp_x_and_8_ne_0_y_and_not_8(i32 %x, i64 %y) {
; CHECK-LABEL: @select_icmp_x_and_8_ne_0_y_and_not_8(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 8
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i64 [[Y:%.*]], -9
; CHECK-NEXT:    [[AND_Y:%.*]] = select i1 [[CMP]], i64 [[AND2]], i64 [[Y]]
; CHECK-NEXT:    ret i64 [[AND_Y]]
;
  %and = and i32 %x, 8
  %cmp = icmp eq i32 %and, 0
  %and2 = and i64 %y, -9
  %and.y = select i1 %cmp, i64 %and2, i64 %y
  ret i64 %and.y
}

define i32 @select_icmp_and_2147483648_ne_0_xor_2147483648(i32 %x) {
; CHECK-LABEL: @select_icmp_and_2147483648_ne_0_xor_2147483648(
; CHECK-NEXT:    [[X_XOR:%.*]] = and i32 [[X:%.*]], 2147483647
; CHECK-NEXT:    ret i32 [[X_XOR]]
;
  %and = and i32 %x, 2147483648
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %x, 2147483648
  %x.xor = select i1 %cmp, i32 %x, i32 %xor
  ret i32 %x.xor
}

define i32 @select_icmp_and_2147483648_eq_0_xor_2147483648(i32 %x) {
; CHECK-LABEL: @select_icmp_and_2147483648_eq_0_xor_2147483648(
; CHECK-NEXT:    [[XOR_X:%.*]] = or i32 [[X:%.*]], -2147483648
; CHECK-NEXT:    ret i32 [[XOR_X]]
;
  %and = and i32 %x, 2147483648
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %x, 2147483648
  %xor.x = select i1 %cmp, i32 %xor, i32 %x
  ret i32 %xor.x
}

define i32 @select_icmp_x_and_2147483648_ne_0_or_2147483648(i32 %x) {
; CHECK-LABEL: @select_icmp_x_and_2147483648_ne_0_or_2147483648(
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[X:%.*]], -2147483648
; CHECK-NEXT:    ret i32 [[OR]]
;
  %and = and i32 %x, 2147483648
  %cmp = icmp eq i32 %and, 0
  %or = or i32 %x, 2147483648
  %or.x = select i1 %cmp, i32 %or, i32 %x
  ret i32 %or.x
}

define i32 @test68(i32 %x, i32 %y) {
; CHECK-LABEL: @test68(
; CHECK-NEXT:    [[AND:%.*]] = lshr i32 [[X:%.*]], 6
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 128
  %cmp = icmp eq i32 %and, 0
  %or = or i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define <2 x i32> @test68vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @test68vec(
; CHECK-NEXT:    [[AND:%.*]] = lshr <2 x i32> [[X:%.*]], splat (i32 6)
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[AND]], splat (i32 2)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i32> [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and <2 x i32> %x, <i32 128, i32 128>
  %cmp = icmp eq <2 x i32> %and, zeroinitializer
  %or = or <2 x i32> %y, <i32 2, i32 2>
  %select = select <2 x i1> %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define i32 @test68_xor(i32 %x, i32 %y) {
; CHECK-LABEL: @test68_xor(
; CHECK-NEXT:    [[AND:%.*]] = lshr i32 [[X:%.*]], 6
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 128
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}

define i32 @test68_and(i32 %x, i32 %y) {
; CHECK-LABEL: @test68_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 128
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -3
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[AND2]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 128
  %cmp = icmp eq i32 %and, 0
  %and2 = and i32 %y, -3
  %select = select i1 %cmp, i32 %y, i32 %and2
  ret i32 %select
}

define i32 @test69(i32 %x, i32 %y) {
; CHECK-LABEL: @test69(
; CHECK-NEXT:    [[AND:%.*]] = lshr i32 [[X:%.*]], 6
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 2
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 128
  %cmp = icmp ne i32 %and, 0
  %or = or i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %or
  ret i32 %select
}

define <2 x i32> @test69vec(<2 x i32> %x, <2 x i32> %y) {
; CHECK-LABEL: @test69vec(
; CHECK-NEXT:    [[AND:%.*]] = lshr <2 x i32> [[X:%.*]], splat (i32 6)
; CHECK-NEXT:    [[TMP1:%.*]] = and <2 x i32> [[AND]], splat (i32 2)
; CHECK-NEXT:    [[TMP2:%.*]] = xor <2 x i32> [[TMP1]], splat (i32 2)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i32> [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret <2 x i32> [[SELECT]]
;
  %and = and <2 x i32> %x, <i32 128, i32 128>
  %cmp = icmp ne <2 x i32> %and, zeroinitializer
  %or = or <2 x i32> %y, <i32 2, i32 2>
  %select = select <2 x i1> %cmp, <2 x i32> %y, <2 x i32> %or
  ret <2 x i32> %select
}

define i32 @test69_xor(i32 %x, i32 %y) {
; CHECK-LABEL: @test69_xor(
; CHECK-NEXT:    [[AND:%.*]] = lshr i32 [[X:%.*]], 6
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 2
; CHECK-NEXT:    [[TMP2:%.*]] = xor i32 [[TMP1]], [[Y:%.*]]
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[TMP2]], 2
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 128
  %cmp = icmp ne i32 %and, 0
  %xor = xor i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}

define i32 @test69_and(i32 %x, i32 %y) {
; CHECK-LABEL: @test69_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 128
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[AND2]], i32 [[Y]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 128
  %cmp = icmp ne i32 %and, 0
  %and2 = and i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %and2
  ret i32 %select
}

define i8 @test70(i8 %x, i8 %y) {
; CHECK-LABEL: @test70(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i8 [[X:%.*]], 6
; CHECK-NEXT:    [[TMP2:%.*]] = and i8 [[TMP1]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = or i8 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %cmp = icmp slt i8 %x, 0
  %or = or i8 %y, 2
  %select = select i1 %cmp, i8 %or, i8 %y
  ret i8 %select
}

define i8 @test70_multiuse(i8 %x, i8 %y) {
; CHECK-LABEL: @test70_multiuse(
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[X:%.*]], 0
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[Y:%.*]], 2
; CHECK-NEXT:    call void @use(i8 [[OR]])
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i8 [[OR]], i8 [[Y]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %cmp = icmp slt i8 %x, 0
  %or = or i8 %y, 2
  call void @use(i8 %or)
  %select = select i1 %cmp, i8 %or, i8 %y
  ret i8 %select
}

define i32 @shift_no_xor_multiuse_or(i32 %x, i32 %y) {
; CHECK-LABEL: @shift_no_xor_multiuse_or(
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[Y:%.*]], 2
; CHECK-NEXT:    [[AND:%.*]] = shl i32 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y]], [[TMP1]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[OR]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %or = or i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %or
  %res = mul i32 %select, %or ; to bump up use count of the Or
  ret i32 %res
}

define i32 @shift_no_xor_multiuse_xor(i32 %x, i32 %y) {
; CHECK-LABEL: @shift_no_xor_multiuse_xor(
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[Y:%.*]], 2
; CHECK-NEXT:    [[AND:%.*]] = shl i32 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[AND]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[Y]], [[TMP1]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[XOR]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %xor
  %res = mul i32 %select, %xor ; to bump up use count of the Xor
  ret i32 %res
}

define i32 @shift_no_xor_multiuse_and(i32 %x, i32 %y) {
; CHECK-LABEL: @shift_no_xor_multiuse_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -3
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[AND2]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[AND2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %and2 = and i32 %y, -3
  %select = select i1 %cmp, i32 %y, i32 %and2
  %res = mul i32 %select, %and2 ; to bump up use count of the And
  ret i32 %res
}

define i32 @no_shift_no_xor_multiuse_or(i32 %x, i32 %y) {
; CHECK-LABEL: @no_shift_no_xor_multiuse_or(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[Y:%.*]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y]], [[AND]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[OR]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %or = or i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %or
  %res = mul i32 %select, %or ; to bump up use count of the Or
  ret i32 %res
}

define i32 @no_shift_no_xor_multiuse_xor(i32 %x, i32 %y) {
; CHECK-LABEL: @no_shift_no_xor_multiuse_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[Y:%.*]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[Y]], [[AND]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[XOR]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %xor
  %res = mul i32 %select, %xor ; to bump up use count of the Xor
  ret i32 %res
}

define i32 @no_shift_no_xor_multiuse_and(i32 %x, i32 %y) {
; CHECK-LABEL: @no_shift_no_xor_multiuse_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = add i32 [[Y:%.*]], -4097
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[AND2]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[AND2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %and2 = add i32 %y, -4097
  %select = select i1 %cmp, i32 %y, i32 %and2
  %res = mul i32 %select, %and2 ; to bump up use count of the And
  ret i32 %res
}

define i32 @no_shift_xor_multiuse_or(i32 %x, i32 %y) {
; CHECK-LABEL: @no_shift_xor_multiuse_or(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[Y:%.*]], 4096
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[AND]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y]], [[TMP1]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[OR]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %or = or i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %or
  %res = mul i32 %select, %or ; to bump up use count of the Or
  ret i32 %res
}

define i32 @no_shift_xor_multiuse_xor(i32 %x, i32 %y) {
; CHECK-LABEL: @no_shift_xor_multiuse_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[Y:%.*]], 4096
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[AND]], [[Y]]
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[TMP1]], 4096
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[XOR]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %xor = xor i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %xor
  %res = mul i32 %select, %xor ; to bump up use count of the Xor
  ret i32 %res
}

define i32 @no_shift_xor_multiuse_and(i32 %x, i32 %y) {
; CHECK-LABEL: @no_shift_xor_multiuse_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -4097
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[AND2]], i32 [[Y]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[AND2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %and2 = and i32 %y, -4097
  %select = select i1 %cmp, i32 %y, i32 %and2
  %res = mul i32 %select, %and2 ; to bump up use count of the And
  ret i32 %res
}

define i32 @shift_xor_multiuse_or(i32 %x, i32 %y) {
; CHECK-LABEL: @shift_xor_multiuse_or(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[Y:%.*]], 2048
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[OR]], i32 [[Y]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[OR]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %or = or i32 %y, 2048
  %select = select i1 %cmp, i32 %y, i32 %or
  %res = mul i32 %select, %or ; to bump up use count of the Or
  ret i32 %res
}

define i32 @shift_xor_multiuse_xor(i32 %x, i32 %y) {
; CHECK-LABEL: @shift_xor_multiuse_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[Y:%.*]], 2048
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[XOR]], i32 [[Y]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[XOR]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %xor = xor i32 %y, 2048
  %select = select i1 %cmp, i32 %y, i32 %xor
  %res = mul i32 %select, %xor ; to bump up use count of the Xor
  ret i32 %res
}

define i32 @shift_xor_multiuse_and(i32 %x, i32 %y) {
; CHECK-LABEL: @shift_xor_multiuse_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -2049
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[AND2]], i32 [[Y]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[AND2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %and2 = and i32 %y, -2049
  %select = select i1 %cmp, i32 %y, i32 %and2
  %res = mul i32 %select, %and2 ; to bump up use count of the and
  ret i32 %res
}

define i32 @shift_no_xor_multiuse_cmp(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_no_xor_multiuse_cmp(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = shl nuw nsw i32 [[AND]], 1
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %or = or i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %or
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @shift_no_xor_multiuse_cmp_with_xor(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_no_xor_multiuse_cmp_with_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = shl nuw nsw i32 [[AND]], 1
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %xor
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @shift_no_xor_multiuse_cmp_with_and(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_no_xor_multiuse_cmp_with_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -3
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[AND2]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %and2 = and i32 %y, -3
  %select = select i1 %cmp, i32 %y, i32 %and2
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @no_shift_no_xor_multiuse_cmp(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_no_xor_multiuse_cmp(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[AND]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %or = or i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %or
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @no_shift_no_xor_multiuse_cmp_with_xor(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_no_xor_multiuse_cmp_with_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[Y:%.*]], [[AND]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %xor
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @no_shift_no_xor_multiuse_cmp_with_and(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_no_xor_multiuse_cmp_with_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -4097
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[AND2]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %and2 = and i32 %y, -4097
  %select = select i1 %cmp, i32 %y, i32 %and2
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @no_shift_xor_multiuse_cmp(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_xor_multiuse_cmp(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[AND]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %or = or i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %or
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @no_shift_xor_multiuse_cmp_with_xor(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_xor_multiuse_cmp_with_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = xor i32 [[AND]], [[Y:%.*]]
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[TMP1]], 4096
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %xor = xor i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %xor
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @no_shift_xor_multiuse_cmp_with_and(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_xor_multiuse_cmp_with_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -4097
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[AND2]], i32 [[Y]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %and2 = and i32 %y, -4097
  %select = select i1 %cmp, i32 %y, i32 %and2
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @shift_xor_multiuse_cmp(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_xor_multiuse_cmp(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[Y:%.*]], 2048
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[OR]], i32 [[Y]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %or = or i32 %y, 2048
  %select = select i1 %cmp, i32 %y, i32 %or
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @shift_xor_multiuse_cmp_with_xor(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_xor_multiuse_cmp_with_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[Y:%.*]], 2048
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[XOR]], i32 [[Y]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %xor = xor i32 %y, 2048
  %select = select i1 %cmp, i32 %y, i32 %xor
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @shift_xor_multiuse_cmp_with_and(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_xor_multiuse_cmp_with_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -2049
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[AND2]], i32 [[Y]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    ret i32 [[RES]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %and2 = and i32 %y, -2049
  %select = select i1 %cmp, i32 %y, i32 %and2
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  ret i32 %res
}

define i32 @shift_no_xor_multiuse_cmp_or(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_no_xor_multiuse_cmp_or(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[Y:%.*]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[OR]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[OR]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %or = or i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %or
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %or ; to bump up the use count of the or
  ret i32 %res2
}

define i32 @shift_no_xor_multiuse_cmp_xor(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_no_xor_multiuse_cmp_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[Y:%.*]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[XOR]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[XOR]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %xor
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %xor ; to bump up the use count of the xor
  ret i32 %res2
}

define i32 @shift_no_xor_multiuse_cmp_and(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_no_xor_multiuse_cmp_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -3
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[AND2]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[AND2]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %and2 = and i32 %y, -3
  %select = select i1 %cmp, i32 %y, i32 %and2
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %and2 ; to bump up the use count of the and
  ret i32 %res2
}

define i32 @no_shift_no_xor_multiuse_cmp_or(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_no_xor_multiuse_cmp_or(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[Y:%.*]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = or i32 [[Y]], [[AND]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[OR]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %or = or i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %or
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %or ; to bump up the use count of the or
  ret i32 %res2
}

define i32 @no_shift_no_xor_multiuse_cmp_xor(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_no_xor_multiuse_cmp_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[Y:%.*]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = xor i32 [[Y]], [[AND]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[XOR]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %xor = xor i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %xor
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %xor ; to bump up the use count of the xor
  ret i32 %res2
}

define i32 @no_shift_no_xor_multiuse_cmp_and(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_no_xor_multiuse_cmp_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -4097
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[AND2]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP]], i32 [[Z:%.*]], i32 [[W:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[AND2]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 4096
  %cmp = icmp eq i32 %and, 0
  %and2 = and i32 %y, -4097
  %select = select i1 %cmp, i32 %y, i32 %and2
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %and2 ; to bump up the use count of the and
  ret i32 %res2
}

define i32 @no_shift_xor_multiuse_cmp_or(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_xor_multiuse_cmp_or(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[Y:%.*]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[OR]], i32 [[Y]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[OR]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %or = or i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %or
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %or ; to bump up the use count of the or
  ret i32 %res2
}

define i32 @no_shift_xor_multiuse_cmp_xor(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_xor_multiuse_cmp_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[Y:%.*]], 4096
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[XOR]], i32 [[Y]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[XOR]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %xor = xor i32 %y, 4096
  %select = select i1 %cmp, i32 %y, i32 %xor
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %xor ; to bump up the use count of the xor
  ret i32 %res2
}

define i32 @no_shift_xor_multiuse_cmp_and(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @no_shift_xor_multiuse_cmp_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], -4097
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[AND2]], i32 [[Y]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[AND2]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %and2 = and i32 %y, -4097
  %select = select i1 %cmp, i32 %y, i32 %and2
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %and2 ; to bump up the use count of the and
  ret i32 %res2
}

define i32 @shift_xor_multiuse_cmp_or(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_xor_multiuse_cmp_or(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[OR:%.*]] = or i32 [[Y:%.*]], 2048
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[OR]], i32 [[Y]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[OR]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %or = or i32 %y, 2048
  %select = select i1 %cmp, i32 %y, i32 %or
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %or ; to bump up the use count of the or
  ret i32 %res2
}

define i32 @shift_xor_multiuse_cmp_xor(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_xor_multiuse_cmp_xor(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i32 [[Y:%.*]], 2048
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[XOR]], i32 [[Y]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[XOR]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %xor = xor i32 %y, 2048
  %select = select i1 %cmp, i32 %y, i32 %xor
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %xor ; to bump up the use count of the xor
  ret i32 %res2
}

define i32 @shift_xor_multiuse_cmp_and(i32 %x, i32 %y, i32 %z, i32 %w) {
; CHECK-LABEL: @shift_xor_multiuse_cmp_and(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 4096
; CHECK-NEXT:    [[CMP_NOT:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[AND2:%.*]] = and i32 [[Y:%.*]], 2048
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP_NOT]], i32 [[AND2]], i32 [[Y]]
; CHECK-NEXT:    [[SELECT2:%.*]] = select i1 [[CMP_NOT]], i32 [[W:%.*]], i32 [[Z:%.*]]
; CHECK-NEXT:    [[RES:%.*]] = mul i32 [[SELECT]], [[SELECT2]]
; CHECK-NEXT:    [[RES2:%.*]] = mul i32 [[RES]], [[AND2]]
; CHECK-NEXT:    ret i32 [[RES2]]
;
  %and = and i32 %x, 4096
  %cmp = icmp ne i32 0, %and
  %and2 = and i32 %y, 2048
  %select = select i1 %cmp, i32 %y, i32 %and2
  %select2 = select i1 %cmp, i32 %z, i32 %w ; to bump up use count of the cmp
  %res = mul i32 %select, %select2
  %res2 = mul i32 %res, %and2 ; to bump up the use count of the and
  ret i32 %res2
}

define i8 @set_bits(i8 %x, i1 %b)  {
; CHECK-LABEL: @set_bits(
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], -6
; CHECK-NEXT:    [[MASKSEL:%.*]] = select i1 [[B:%.*]], i8 5, i8 0
; CHECK-NEXT:    [[COND:%.*]] = or disjoint i8 [[AND]], [[MASKSEL]]
; CHECK-NEXT:    ret i8 [[COND]]
;
  %and = and i8 %x, 250
  %or = or i8 %x, 5
  %cond = select i1 %b, i8 %or, i8 %and
  ret i8 %cond
}

; Negative test

define i8 @set_bits_not_inverse_constant(i8 %x, i1 %b)  {
; CHECK-LABEL: @set_bits_not_inverse_constant(
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], -6
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[X]], 7
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[B:%.*]], i8 [[OR]], i8 [[AND]]
; CHECK-NEXT:    ret i8 [[COND]]
;
  %and = and i8 %x, 250
  %or = or i8 %x, 7
  %cond = select i1 %b, i8 %or, i8 %and
  ret i8 %cond
}

define i8 @set_bits_extra_use1(i8 %x, i1 %b)  {
; CHECK-LABEL: @set_bits_extra_use1(
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], -6
; CHECK-NEXT:    call void @use(i8 [[AND]])
; CHECK-NEXT:    [[MASKSEL:%.*]] = select i1 [[B:%.*]], i8 5, i8 0
; CHECK-NEXT:    [[COND:%.*]] = or disjoint i8 [[AND]], [[MASKSEL]]
; CHECK-NEXT:    ret i8 [[COND]]
;
  %and = and i8 %x, 250
  call void @use(i8 %and)
  %or = or i8 %x, 5
  %cond = select i1 %b, i8 %or, i8 %and
  ret i8 %cond
}

; Negative test

define i8 @set_bits_extra_use2(i8 %x, i1 %b)  {
; CHECK-LABEL: @set_bits_extra_use2(
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], -6
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[X]], 5
; CHECK-NEXT:    call void @use(i8 [[OR]])
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[B:%.*]], i8 [[OR]], i8 [[AND]]
; CHECK-NEXT:    ret i8 [[COND]]
;
  %and = and i8 %x, 250
  %or = or i8 %x, 5
  call void @use(i8 %or)
  %cond = select i1 %b, i8 %or, i8 %and
  ret i8 %cond
}

define <2 x i8> @clear_bits(<2 x i8> %x, <2 x i1> %b)  {
; CHECK-LABEL: @clear_bits(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i8> [[X:%.*]], splat (i8 37)
; CHECK-NEXT:    [[MASKSEL:%.*]] = select <2 x i1> [[B:%.*]], <2 x i8> zeroinitializer, <2 x i8> splat (i8 -38)
; CHECK-NEXT:    [[COND:%.*]] = or disjoint <2 x i8> [[AND]], [[MASKSEL]]
; CHECK-NEXT:    ret <2 x i8> [[COND]]
;
  %and = and <2 x i8> %x, <i8 37, i8 37>
  %or = or <2 x i8> %x, <i8 218, i8 218>
  %cond = select <2 x i1> %b, <2 x i8> %and, <2 x i8> %or
  ret <2 x i8> %cond
}

; Negative test

define <2 x i8> @clear_bits_not_inverse_constant(<2 x i8> %x, <2 x i1> %b)  {
; CHECK-LABEL: @clear_bits_not_inverse_constant(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i8> [[X:%.*]], <i8 undef, i8 37>
; CHECK-NEXT:    [[OR:%.*]] = or <2 x i8> [[X]], splat (i8 -38)
; CHECK-NEXT:    [[COND:%.*]] = select <2 x i1> [[B:%.*]], <2 x i8> [[AND]], <2 x i8> [[OR]]
; CHECK-NEXT:    ret <2 x i8> [[COND]]
;
  %and = and <2 x i8> %x, <i8 undef, i8 37>
  %or = or <2 x i8> %x, <i8 218, i8 218>
  %cond = select <2 x i1> %b, <2 x i8> %and, <2 x i8> %or
  ret <2 x i8> %cond
}

define <2 x i8> @clear_bits_extra_use1(<2 x i8> %x, i1 %b)  {
; CHECK-LABEL: @clear_bits_extra_use1(
; CHECK-NEXT:    [[AND:%.*]] = and <2 x i8> [[X:%.*]], splat (i8 37)
; CHECK-NEXT:    call void @use_vec(<2 x i8> [[AND]])
; CHECK-NEXT:    [[MASKSEL:%.*]] = select i1 [[B:%.*]], <2 x i8> zeroinitializer, <2 x i8> splat (i8 -38)
; CHECK-NEXT:    [[COND:%.*]] = or disjoint <2 x i8> [[AND]], [[MASKSEL]]
; CHECK-NEXT:    ret <2 x i8> [[COND]]
;
  %and = and <2 x i8> %x, <i8 37, i8 37>
  call void @use_vec(<2 x i8> %and)
  %or = or <2 x i8> %x, <i8 218, i8 218>
  %cond = select i1 %b, <2 x i8> %and, <2 x i8> %or
  ret <2 x i8> %cond
}

; Negative test

define i8 @clear_bits_extra_use2(i8 %x, i1 %b)  {
; CHECK-LABEL: @clear_bits_extra_use2(
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X:%.*]], -6
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[X]], 5
; CHECK-NEXT:    call void @use(i8 [[OR]])
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[B:%.*]], i8 [[AND]], i8 [[OR]]
; CHECK-NEXT:    ret i8 [[COND]]
;
  %and = and i8 %x, 250
  %or = or i8 %x, 5
  call void @use(i8 %or)
  %cond = select i1 %b, i8 %and, i8 %or
  ret i8 %cond
}

; Tests factoring in cost of saving the `and`
define i64 @xor_i8_to_i64_shl_save_and_eq(i8 %x, i64 %y) {
; CHECK-LABEL: @xor_i8_to_i64_shl_save_and_eq(
; CHECK-NEXT:    [[XX:%.*]] = and i8 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[XX]], 0
; CHECK-NEXT:    [[Z:%.*]] = xor i64 [[Y:%.*]], -9223372036854775808
; CHECK-NEXT:    [[R:%.*]] = select i1 [[CMP]], i64 [[Z]], i64 [[Y]]
; CHECK-NEXT:    ret i64 [[R]]
;
  %xx = and i8 %x, 1
  %cmp = icmp eq i8 %xx, 0
  %z = xor i64 %y, -9223372036854775808
  %r = select i1 %cmp, i64 %z, i64 %y
  ret i64 %r
}

define i64 @xor_i8_to_i64_shl_save_and_ne(i8 %x, i64 %y) {
; CHECK-LABEL: @xor_i8_to_i64_shl_save_and_ne(
; CHECK-NEXT:    [[TMP1:%.*]] = zext i8 [[X:%.*]] to i64
; CHECK-NEXT:    [[TMP2:%.*]] = shl i64 [[TMP1]], 63
; CHECK-NEXT:    [[R:%.*]] = xor i64 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i64 [[R]]
;
  %xx = and i8 %x, 1
  %cmp = icmp ne i8 %xx, 0
  %z = xor i64 %y, -9223372036854775808
  %r = select i1 %cmp, i64 %z, i64 %y
  ret i64 %r
}

define i32 @select_icmp_eq_and_1_0_srem_2_fail_null_identity(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_srem_2_fail_null_identity(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = srem i32 [[Y:%.*]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[XOR]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %xor = srem i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}


define i32 @select_icmp_eq_and_1_0_sdiv_2_fail_null_1_identity(i32 %x, i32 %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_sdiv_2_fail_null_1_identity(
; CHECK-NEXT:    [[AND:%.*]] = and i32 [[X:%.*]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = sdiv i32 [[Y:%.*]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], i32 [[Y]], i32 [[XOR]]
; CHECK-NEXT:    ret i32 [[SELECT]]
;
  %and = and i32 %x, 1
  %cmp = icmp eq i32 %and, 0
  %xor = sdiv i32 %y, 2
  %select = select i1 %cmp, i32 %y, i32 %xor
  ret i32 %select
}

define i8 @select_icmp_eq_and_1_0_lshr_fv(i8 %x, i8 %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_lshr_fv(
; CHECK-NEXT:    [[AND:%.*]] = shl i8 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[AND]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = lshr i8 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %and = and i8 %x, 1
  %cmp = icmp eq i8 %and, 0
  %blshr = lshr i8 %y, 2
  %select = select i1 %cmp, i8 %y, i8 %blshr
  ret i8 %select
}

define i8 @select_icmp_eq_and_1_0_lshr_exact_fv(i8 %x, i8 %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_lshr_exact_fv(
; CHECK-NEXT:    [[AND:%.*]] = shl i8 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[AND]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = lshr exact i8 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %and = and i8 %x, 1
  %cmp = icmp eq i8 %and, 0
  %blshr = lshr exact i8 %y, 2
  %select = select i1 %cmp, i8 %y, i8 %blshr
  ret i8 %select
}

define i8 @select_icmp_eq_and_1_0_lshr_tv(i8 %x, i8 %y) {
; CHECK-LABEL: @select_icmp_eq_and_1_0_lshr_tv(
; CHECK-NEXT:    [[AND:%.*]] = shl i8 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP1:%.*]] = and i8 [[AND]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = lshr i8 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %and = and i8 %x, 1
  %cmp = icmp ne i8 %and, 0
  %blshr = lshr i8 %y, 2
  %select = select i1 %cmp, i8 %blshr, i8 %y
  ret i8 %select
}

define i8 @select_trunc_or_2(i8 %x, i8 %y) {
; CHECK-LABEL: @select_trunc_or_2(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i8 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = and i8 [[TMP1]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = or i8 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %trunc = trunc i8 %x to i1
  %or = or i8 %y, 2
  %select = select i1 %trunc, i8 %or, i8 %y
  ret i8 %select
}

define i8 @select_not_trunc_or_2(i8 %x, i8 %y) {
; CHECK-LABEL: @select_not_trunc_or_2(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i8 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = and i8 [[TMP1]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = or i8 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %trunc = trunc i8 %x to i1
  %not = xor i1 %trunc, true
  %or = or i8 %y, 2
  %select = select i1 %not, i8 %y, i8 %or
  ret i8 %select
}

define i8 @select_trunc_nuw_or_2(i8 %x, i8 %y) {
; CHECK-LABEL: @select_trunc_nuw_or_2(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i8 [[X:%.*]], 1
; CHECK-NEXT:    [[SELECT:%.*]] = or i8 [[Y:%.*]], [[TMP1]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %trunc = trunc nuw i8 %x to i1
  %or = or i8 %y, 2
  %select = select i1 %trunc, i8 %or, i8 %y
  ret i8 %select
}

define i8 @select_trunc_nsw_or_2(i8 %x, i8 %y) {
; CHECK-LABEL: @select_trunc_nsw_or_2(
; CHECK-NEXT:    [[TMP1:%.*]] = shl i8 [[X:%.*]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = and i8 [[TMP1]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = or i8 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %trunc = trunc nsw i8 %x to i1
  %or = or i8 %y, 2
  %select = select i1 %trunc, i8 %or, i8 %y
  ret i8 %select
}

define <2 x i8> @select_trunc_or_2_vec(<2 x i8> %x, <2 x i8> %y) {
; CHECK-LABEL: @select_trunc_or_2_vec(
; CHECK-NEXT:    [[TMP1:%.*]] = shl <2 x i8> [[X:%.*]], splat (i8 1)
; CHECK-NEXT:    [[TMP2:%.*]] = and <2 x i8> [[TMP1]], splat (i8 2)
; CHECK-NEXT:    [[SELECT:%.*]] = or <2 x i8> [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret <2 x i8> [[SELECT]]
;
  %trunc = trunc <2 x i8> %x to <2 x i1>
  %or = or <2 x i8> %y, <i8 2, i8 2>
  %select = select <2 x i1> %trunc, <2 x i8> %or, <2 x i8> %y
  ret <2 x i8> %select
}

define i8 @neg_select_trunc_or_2(i8 %x, i8 %y) {
; CHECK-LABEL: @neg_select_trunc_or_2(
; CHECK-NEXT:    [[TRUNC:%.*]] = trunc i8 [[X:%.*]] to i1
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[Y:%.*]], 2
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[TRUNC]], i8 [[Y]], i8 [[OR]]
; CHECK-NEXT:    ret i8 [[SELECT]]
;
  %trunc = trunc i8 %x to i1
  %or = or i8 %y, 2
  %select = select i1 %trunc, i8 %y, i8 %or
  ret i8 %select
}

define i8 @select_icmp_bittest_range(i8 range(i8 0, 64) %a, i8 %y) {
; CHECK-LABEL: @select_icmp_bittest_range(
; CHECK-NEXT:    [[TMP1:%.*]] = lshr i8 [[A:%.*]], 4
; CHECK-NEXT:    [[TMP2:%.*]] = and i8 [[TMP1]], 2
; CHECK-NEXT:    [[RES:%.*]] = or i8 [[Y:%.*]], [[TMP2]]
; CHECK-NEXT:    ret i8 [[RES]]
;
  %cmp = icmp ult i8 %a, 32
  %or = or i8 %y, 2
  %res = select i1 %cmp, i8 %y, i8 %or
  ret i8 %res
}

define i8 @neg_select_icmp_bittest_range(i8 range(i8 0, 65) %a, i8 %y) {
; CHECK-LABEL: @neg_select_icmp_bittest_range(
; CHECK-NEXT:    [[CMP:%.*]] = icmp samesign ult i8 [[A:%.*]], 32
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[Y:%.*]], 2
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP]], i8 [[Y]], i8 [[OR]]
; CHECK-NEXT:    ret i8 [[RES]]
;
  %cmp = icmp ult i8 %a, 32
  %or = or i8 %y, 2
  %res = select i1 %cmp, i8 %y, i8 %or
  ret i8 %res
}

define i8 @neg_select_icmp_bittest_range_2(i8 range(i8 0, 64) %a, i8 %y) {
; CHECK-LABEL: @neg_select_icmp_bittest_range_2(
; CHECK-NEXT:    [[CMP:%.*]] = icmp samesign ult i8 [[A:%.*]], 16
; CHECK-NEXT:    [[OR:%.*]] = or i8 [[Y:%.*]], 2
; CHECK-NEXT:    [[RES:%.*]] = select i1 [[CMP]], i8 [[Y]], i8 [[OR]]
; CHECK-NEXT:    ret i8 [[RES]]
;
  %cmp = icmp ult i8 %a, 16
  %or = or i8 %y, 2
  %res = select i1 %cmp, i8 %y, i8 %or
  ret i8 %res
}
