; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu -mattr=+sve2p1,+bf16 < %s | FileCheck %s

;
; ST1Q: vector base +  unscaled offset
;   e.g. st1q { z0.q }, p0, [z1.d, x0]
;

define void @sst1_scatter_u64base_offset_i8(<vscale x 16 x i8> %data, <vscale x 1 x i1> %pg, <vscale x 2 x i64> %b, i64 %offset) {
; CHECK-LABEL: sst1_scatter_u64base_offset_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1q { z0.q }, p0, [z1.d, x0]
; CHECK-NEXT:    ret
  call void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv16i8.nxv2i64(<vscale x 16 x i8> %data,
                                                           <vscale x 1 x i1> %pg,
                                                           <vscale x 2 x i64> %b,
                                                           i64 %offset)
  ret void
}

define void @sst1_scatter_u64base_offset_i16(<vscale x 8 x i16> %data, <vscale x 1 x i1> %pg, <vscale x 2 x i64> %b, i64 %offset) {
; CHECK-LABEL: sst1_scatter_u64base_offset_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1q { z0.q }, p0, [z1.d, x0]
; CHECK-NEXT:    ret
  call void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv8i16.nxv2i64(<vscale x 8 x i16> %data,
                                                           <vscale x 1 x i1> %pg,
                                                           <vscale x 2 x i64> %b,
                                                           i64 %offset)
  ret void
}

define void @sst1_scatter_u64base_offset_i32(<vscale x 4 x i32> %data, <vscale x 1 x i1> %pg, <vscale x 2 x i64> %b, i64 %offset) {
; CHECK-LABEL: sst1_scatter_u64base_offset_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1q { z0.q }, p0, [z1.d, x0]
; CHECK-NEXT:    ret
  call void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv4i32.nxv2i64(<vscale x 4 x i32> %data,
                                                           <vscale x 1 x i1> %pg,
                                                           <vscale x 2 x i64> %b,
                                                           i64 %offset)
  ret void
}

define void @sst1_scatter_u64base_offset_i64(<vscale x 2 x i64> %data, <vscale x 1 x i1> %pg, <vscale x 2 x i64> %b, i64 %offset) {
; CHECK-LABEL: sst1_scatter_u64base_offset_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1q { z0.q }, p0, [z1.d, x0]
; CHECK-NEXT:    ret
  call void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv2i64.nxv2i64(<vscale x 2 x i64> %data,
                                                           <vscale x 1 x i1> %pg,
                                                           <vscale x 2 x i64> %b,
                                                           i64 %offset)
  ret void
}

define void @sst1_scatter_u64base_offset_f16(<vscale x 8 x half> %data, <vscale x 1 x i1> %pg, <vscale x 2 x i64> %base, i64 %offset) {
; CHECK-LABEL: sst1_scatter_u64base_offset_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1q { z0.q }, p0, [z1.d, x0]
; CHECK-NEXT:    ret
   call void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv8f16.nxv2i64(<vscale x 8 x half> %data,
                                                            <vscale x 1 x i1> %pg,
                                                            <vscale x 2 x i64> %base,
                                                            i64 %offset)
  ret void
}

define void @sst1_scatter_u64base_offset_f32(<vscale x 4 x float> %data, <vscale x 1 x i1> %pg, <vscale x 2 x i64> %b, i64 %offset) {
; CHECK-LABEL: sst1_scatter_u64base_offset_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1q { z0.q }, p0, [z1.d, x0]
; CHECK-NEXT:    ret
  call void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv4f32.nxv2i64(<vscale x 4 x float> %data,
                                                           <vscale x 1 x i1> %pg,
                                                           <vscale x 2 x i64> %b,
                                                           i64 %offset)
  ret void
}

define void @sst1_scatter_u64base_offset_f64(<vscale x 2 x double> %data, <vscale x 1 x i1> %pg, <vscale x 2 x i64> %b, i64 %offset) {
; CHECK-LABEL: sst1_scatter_u64base_offset_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1q { z0.q }, p0, [z1.d, x0]
; CHECK-NEXT:    ret
  call void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv2f64.nxv2i64(<vscale x 2 x double> %data,
                                                           <vscale x 1 x i1> %pg,
                                                           <vscale x 2 x i64> %b,
                                                           i64 %offset)
  ret void
}

define void @sst1_scatter_u64base_offset_bf16(<vscale x 8 x bfloat> %data, <vscale x 1 x i1> %pg, <vscale x 2 x i64> %b, i64 %offset) {
; CHECK-LABEL: sst1_scatter_u64base_offset_bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    st1q { z0.q }, p0, [z1.d, x0]
; CHECK-NEXT:    ret
  call void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv8bf16.nxv2i64(<vscale x 8 x bfloat> %data,
                                                            <vscale x 1 x i1> %pg,
                                                            <vscale x 2 x i64> %b,
                                                             i64 %offset)
  ret void
}

define void @test_svst1q_scatter_u64offset_s8(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 16 x i8> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_s8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv16i8(<vscale x 16 x i8> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

define void @test_svst1q_scatter_u64offset_u8(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 16 x i8> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_u8:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv16i8(<vscale x 16 x i8> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

define void @test_svst1q_scatter_u64offset_s16(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 8 x i16> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_s16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv8i16(<vscale x 8 x i16> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

define void @test_svst1q_scatter_u64offset_u16(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 8 x i16> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_u16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv8i16(<vscale x 8 x i16> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

define void @test_svst1q_scatter_u64offset_s32(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 4 x i32> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_s32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv4i32(<vscale x 4 x i32> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

define void @test_svst1q_scatter_u64offset_u32(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 4 x i32> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_u32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv4i32(<vscale x 4 x i32> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

define void @test_svst1q_scatter_u64offset_s64(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 2 x i64> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_s64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv2i64(<vscale x 2 x i64> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

define void @test_svst1q_scatter_u64offset_u64(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 2 x i64> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_u64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv2i64(<vscale x 2 x i64> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

define void @test_svst1q_scatter_u64offset_bf16(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 8 x bfloat> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_bf16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv8bf16(<vscale x 8 x bfloat> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

define void @test_svst1q_scatter_u64offset_f16(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 8 x half> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_f16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv8f16(<vscale x 8 x half> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

define void @test_svst1q_scatter_u64offset_f32(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 4 x float> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_f32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv4f32(<vscale x 4 x float> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

define void @test_svst1q_scatter_u64offset_f64(<vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off, <vscale x 2 x double> %data) {
; CHECK-LABEL: test_svst1q_scatter_u64offset_f64:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    st1q { z1.q }, p0, [z0.d, x0]
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv2f64(<vscale x 2 x double> %data, <vscale x 1 x i1> %pg, ptr %base, <vscale x 2 x i64> %off)
  ret void
}

declare void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv16i8.nxv2i64(<vscale x 16 x i8>, <vscale x 1 x i1>, <vscale x 2 x i64>, i64)
declare void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv8i16.nxv2i64(<vscale x 8 x i16>, <vscale x 1 x i1>, <vscale x 2 x i64>, i64)
declare void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv4i32.nxv2i64(<vscale x 4 x i32>, <vscale x 1 x i1>, <vscale x 2 x i64>, i64)
declare void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv2i64.nxv2i64(<vscale x 2 x i64>, <vscale x 1 x i1>, <vscale x 2 x i64>, i64)
declare void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv8f16.nxv2i64(<vscale x 8 x half>, <vscale x 1 x i1>, <vscale x 2 x i64>, i64)
declare void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv4f32.nxv2i64(<vscale x 4 x float>, <vscale x 1 x i1>, <vscale x 2 x i64>, i64)
declare void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv2f64.nxv2i64(<vscale x 2 x double>, <vscale x 1 x i1>, <vscale x 2 x i64>, i64)
declare void @llvm.aarch64.sve.st1q.scatter.scalar.offset.nxv8bf16.nxv2i64(<vscale x 8 x bfloat>, <vscale x 1 x i1>, <vscale x 2 x i64>, i64)
declare void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv16i8(<vscale x 16 x i8>, <vscale x 1 x i1>, ptr, <vscale x 2 x i64>)
declare void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv8i16(<vscale x 8 x i16>, <vscale x 1 x i1>, ptr, <vscale x 2 x i64>)
declare void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv4i32(<vscale x 4 x i32>, <vscale x 1 x i1>, ptr, <vscale x 2 x i64>)
declare void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv2i64(<vscale x 2 x i64>, <vscale x 1 x i1>, ptr, <vscale x 2 x i64>)
declare void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv8bf16(<vscale x 8 x bfloat>, <vscale x 1 x i1>, ptr, <vscale x 2 x i64>)
declare void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv8f16(<vscale x 8 x half>, <vscale x 1 x i1>, ptr, <vscale x 2 x i64>)
declare void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv4f32(<vscale x 4 x float>, <vscale x 1 x i1>, ptr, <vscale x 2 x i64>)
declare void @llvm.aarch64.sve.st1q.scatter.vector.offset.nxv2f64(<vscale x 2 x double>, <vscale x 1 x i1>, ptr, <vscale x 2 x i64>)
