; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr="+wavefrontsize64" -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX11,SDAG-GFX11 %s
; RUN: llc -mtriple=amdgcn -mcpu=fiji -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,VI,SDAG-VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s | FileCheck -check-prefixes=GCN,GFX9,SDAG-GFX9 %s

; RUN: llc -global-isel -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx1100 -mattr="+wavefrontsize64" -verify-machineinstrs < %s 2>%t | FileCheck -check-prefixes=GCN,GFX11,GISEL-GFX11 %s
; RUN: FileCheck --check-prefix=ERR %s < %t
; RUN: llc -global-isel -global-isel-abort=2 -mtriple=amdgcn -mcpu=fiji -verify-machineinstrs < %s 2>%t | FileCheck -check-prefixes=GCN,VI,GISEL-VI %s
; RUN: FileCheck --check-prefix=ERR %s < %t
; RUN: llc -global-isel -global-isel-abort=2 -mtriple=amdgcn -mcpu=gfx900 -verify-machineinstrs < %s 2>%t | FileCheck -check-prefixes=GCN,GFX9,GISEL-GFX9 %s
; RUN: FileCheck --check-prefix=ERR %s < %t

; Note: GlobalISel abort is disabled so we don't crash on i1 inputs.
;  They are allowed in DAGISel but we (intentionally) don't support them
;  in GlobalISel.

; ERR: warning: Instruction selection used fallback path for v_icmp_i1_ne0

declare i64 @llvm.amdgcn.icmp.i32(i32, i32, i32) #0
declare i64 @llvm.amdgcn.icmp.i64(i64, i64, i32) #0
declare i64 @llvm.amdgcn.icmp.i16(i16, i16, i32) #0
declare i64 @llvm.amdgcn.icmp.i1(i1, i1, i32) #0

define amdgpu_kernel void @v_icmp_i32_eq(ptr addrspace(1) %out, i32 %src) {
; GFX11-LABEL: v_icmp_i32_eq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u32_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i32_eq:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_eq_u32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i32_eq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u32_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i32_eq:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_eq_u32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 32)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i32(ptr addrspace(1) %out, i32 %src) {
; SDAG-GFX11-LABEL: v_icmp_i32:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i32:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_endpgm
;
; SDAG-GFX9-LABEL: v_icmp_i32:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_icmp_i32:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i32:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s1
; GISEL-VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_icmp_i32:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 30)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i32_ne(ptr addrspace(1) %out, i32 %src) {
; GFX11-LABEL: v_icmp_i32_ne:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i32_ne:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ne_u32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i32_ne:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i32_ne:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ne_u32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 33)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i32_ugt(ptr addrspace(1) %out, i32 %src) {
; GFX11-LABEL: v_icmp_i32_ugt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_u32_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i32_ugt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_gt_u32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i32_ugt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_u32_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i32_ugt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_gt_u32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 34)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i32_uge(ptr addrspace(1) %out, i32 %src) {
; GFX11-LABEL: v_icmp_i32_uge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_u32_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i32_uge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ge_u32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i32_uge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ge_u32_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i32_uge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ge_u32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 35)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i32_ult(ptr addrspace(1) %out, i32 %src) {
; GFX11-LABEL: v_icmp_i32_ult:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_u32_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i32_ult:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_lt_u32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i32_ult:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_u32_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i32_ult:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_lt_u32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 36)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i32_ule(ptr addrspace(1) %out, i32 %src) {
; GFX11-LABEL: v_icmp_i32_ule:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_u32_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i32_ule:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_le_u32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i32_ule:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_le_u32_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i32_ule:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_le_u32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 37)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i32_sgt(ptr addrspace(1) %out, i32 %src) #1 {
; GFX11-LABEL: v_icmp_i32_sgt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_i32_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i32_sgt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_gt_i32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i32_sgt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_i32_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i32_sgt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_gt_i32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 38)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i32_sge(ptr addrspace(1) %out, i32 %src) {
; GFX11-LABEL: v_icmp_i32_sge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_i32_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i32_sge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ge_i32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i32_sge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ge_i32_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i32_sge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ge_i32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 39)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i32_slt(ptr addrspace(1) %out, i32 %src) {
; GFX11-LABEL: v_icmp_i32_slt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_i32_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i32_slt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_lt_i32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i32_slt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_i32_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i32_slt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_lt_i32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 40)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i32_sle(ptr addrspace(1) %out, i32 %src) {
; GFX11-LABEL: v_icmp_i32_sle:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_i32_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i32_sle:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_le_i32_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i32_sle:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_le_i32_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i32_sle:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_le_i32_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 41)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i64_eq(ptr addrspace(1) %out, i64 %src) {
; GFX11-LABEL: v_icmp_i64_eq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u64_e64 s[2:3], 0x64, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i64_eq:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_eq_u64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i64_eq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u64_e64 s[2:3], s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i64_eq:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_eq_u64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i64(i64 %src, i64 100, i32 32)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i64_ne(ptr addrspace(1) %out, i64 %src) {
; GFX11-LABEL: v_icmp_i64_ne:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u64_e64 s[2:3], 0x64, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i64_ne:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i64_ne:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i64_ne:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ne_u64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i64(i64 %src, i64 100, i32 33)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_u64_ugt(ptr addrspace(1) %out, i64 %src) {
; GFX11-LABEL: v_icmp_u64_ugt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_u64_e64 s[2:3], 0x64, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_u64_ugt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_gt_u64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_u64_ugt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_u64_e64 s[2:3], s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_u64_ugt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_gt_u64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i64(i64 %src, i64 100, i32 34)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_u64_uge(ptr addrspace(1) %out, i64 %src) {
; GFX11-LABEL: v_icmp_u64_uge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_u64_e64 s[2:3], 0x64, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_u64_uge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ge_u64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_u64_uge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ge_u64_e64 s[2:3], s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_u64_uge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ge_u64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i64(i64 %src, i64 100, i32 35)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_u64_ult(ptr addrspace(1) %out, i64 %src) {
; GFX11-LABEL: v_icmp_u64_ult:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_u64_e64 s[2:3], 0x64, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_u64_ult:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_lt_u64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_u64_ult:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_u64_e64 s[2:3], s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_u64_ult:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_lt_u64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i64(i64 %src, i64 100, i32 36)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_u64_ule(ptr addrspace(1) %out, i64 %src) {
; GFX11-LABEL: v_icmp_u64_ule:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_u64_e64 s[2:3], 0x64, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_u64_ule:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_le_u64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_u64_ule:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_le_u64_e64 s[2:3], s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_u64_ule:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_le_u64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i64(i64 %src, i64 100, i32 37)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i64_sgt(ptr addrspace(1) %out, i64 %src) {
; GFX11-LABEL: v_icmp_i64_sgt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_i64_e64 s[2:3], 0x64, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i64_sgt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_gt_i64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i64_sgt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_i64_e64 s[2:3], s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i64_sgt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_gt_i64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i64(i64 %src, i64 100, i32 38)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i64_sge(ptr addrspace(1) %out, i64 %src) {
; GFX11-LABEL: v_icmp_i64_sge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_i64_e64 s[2:3], 0x64, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i64_sge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ge_i64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i64_sge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ge_i64_e64 s[2:3], s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i64_sge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ge_i64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i64(i64 %src, i64 100, i32 39)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i64_slt(ptr addrspace(1) %out, i64 %src) {
; GFX11-LABEL: v_icmp_i64_slt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_i64_e64 s[2:3], 0x64, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i64_slt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_lt_i64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i64_slt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_i64_e64 s[2:3], s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i64_slt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_lt_i64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i64(i64 %src, i64 100, i32 40)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i64_sle(ptr addrspace(1) %out, i64 %src) {
; GFX11-LABEL: v_icmp_i64_sle:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_i64_e64 s[2:3], 0x64, s[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i64_sle:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, 0
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_le_i64_e64 s[2:3], s[2:3], v[0:1]
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i64_sle:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v1, 0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_le_i64_e64 s[2:3], s[2:3], v[0:1]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i64_sle:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, 0
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_le_i64_e64 s[2:3], s[2:3], v[0:1]
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i64(i64 %src, i64 100, i32 41)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i16_eq(ptr addrspace(1) %out, i16 %src) {
; GFX11-LABEL: v_icmp_i16_eq:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_eq_u16_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i16_eq:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_eq_u16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i16_eq:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_eq_u16_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i16_eq:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_eq_u16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i16(i16 %src, i16 100, i32 32)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i16(ptr addrspace(1) %out, i16 %src) {
; SDAG-GFX11-LABEL: v_icmp_i16:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i16:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_endpgm
;
; SDAG-GFX9-LABEL: v_icmp_i16:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: v_icmp_i16:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GISEL-GFX11-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX11-NEXT:    global_store_b64 v0, v[0:1], s[0:1]
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i16:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s0
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s1
; GISEL-VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: v_icmp_i16:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GISEL-GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-GFX9-NEXT:    global_store_dwordx2 v0, v[0:1], s[0:1]
; GISEL-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i16(i16 %src, i16 100, i32 30)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i16_ne(ptr addrspace(1) %out, i16 %src) {
; GFX11-LABEL: v_icmp_i16_ne:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u16_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i16_ne:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ne_u16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i16_ne:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u16_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i16_ne:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ne_u16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i16(i16 %src, i16 100, i32 33)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i16_ugt(ptr addrspace(1) %out, i16 %src) {
; GFX11-LABEL: v_icmp_i16_ugt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_u16_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i16_ugt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_gt_u16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i16_ugt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_u16_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i16_ugt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_gt_u16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i16(i16 %src, i16 100, i32 34)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i16_uge(ptr addrspace(1) %out, i16 %src) {
; GFX11-LABEL: v_icmp_i16_uge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_u16_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i16_uge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ge_u16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i16_uge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ge_u16_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i16_uge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ge_u16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i16(i16 %src, i16 100, i32 35)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i16_ult(ptr addrspace(1) %out, i16 %src) {
; GFX11-LABEL: v_icmp_i16_ult:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_u16_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i16_ult:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_lt_u16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i16_ult:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_u16_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i16_ult:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_lt_u16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i16(i16 %src, i16 100, i32 36)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i16_ule(ptr addrspace(1) %out, i16 %src) {
; GFX11-LABEL: v_icmp_i16_ule:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_u16_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i16_ule:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_le_u16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i16_ule:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_le_u16_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i16_ule:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_le_u16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i16(i16 %src, i16 100, i32 37)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i16_sgt(ptr addrspace(1) %out, i16 %src) #1 {
; GFX11-LABEL: v_icmp_i16_sgt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_lt_i16_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i16_sgt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_gt_i16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i16_sgt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_gt_i16_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i16_sgt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_gt_i16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i16(i16 %src, i16 100, i32 38)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i16_sge(ptr addrspace(1) %out, i16 %src) {
; GFX11-LABEL: v_icmp_i16_sge:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_le_i16_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i16_sge:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_ge_i16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i16_sge:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ge_i16_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i16_sge:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_ge_i16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i16(i16 %src, i16 100, i32 39)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i16_slt(ptr addrspace(1) %out, i16 %src) {
; GFX11-LABEL: v_icmp_i16_slt:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_i16_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i16_slt:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_lt_i16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i16_slt:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_lt_i16_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i16_slt:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_lt_i16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i16(i16 %src, i16 100, i32 40)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i16_sle(ptr addrspace(1) %out, i16 %src) {
; GFX11-LABEL: v_icmp_i16_sle:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b32 s2, s[4:5], 0x2c
; GFX11-NEXT:    s_load_b64 s[0:1], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ge_i16_e64 s[2:3], 0x64, s2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: v_icmp_i16_sle:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; SDAG-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; SDAG-VI-NEXT:    s_waitcnt lgkmcnt(0)
; SDAG-VI-NEXT:    v_cmp_le_i16_e64 s[2:3], s2, v0
; SDAG-VI-NEXT:    v_mov_b32_e32 v0, s0
; SDAG-VI-NEXT:    v_mov_b32_e32 v2, s2
; SDAG-VI-NEXT:    v_mov_b32_e32 v1, s1
; SDAG-VI-NEXT:    v_mov_b32_e32 v3, s3
; SDAG-VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; SDAG-VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i16_sle:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GFX9-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v0, 0x64
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_cmp_le_i16_e64 s[2:3], s2, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: v_icmp_i16_sle:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GISEL-VI-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, 0x64
; GISEL-VI-NEXT:    s_waitcnt lgkmcnt(0)
; GISEL-VI-NEXT:    v_cmp_le_i16_e64 s[2:3], s2, v0
; GISEL-VI-NEXT:    v_mov_b32_e32 v0, s2
; GISEL-VI-NEXT:    v_mov_b32_e32 v3, s1
; GISEL-VI-NEXT:    v_mov_b32_e32 v1, s3
; GISEL-VI-NEXT:    v_mov_b32_e32 v2, s0
; GISEL-VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i16(i16 %src, i16 100, i32 41)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_icmp_i1_ne0(ptr addrspace(1) %out, i32 %a, i32 %b) {
; GFX11-LABEL: v_icmp_i1_ne0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[4:5], 0x24
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_cmp_gt_u32 s2, 1
; GFX11-NEXT:    s_cselect_b64 s[4:5], -1, 0
; GFX11-NEXT:    s_cmp_gt_u32 s3, 2
; GFX11-NEXT:    s_cselect_b64 s[2:3], -1, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_b64 s[2:3], s[4:5], s[2:3]
; GFX11-NEXT:    v_mov_b32_e32 v0, s2
; GFX11-NEXT:    v_mov_b32_e32 v1, s3
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[0:1]
; GFX11-NEXT:    s_endpgm
;
; VI-LABEL: v_icmp_i1_ne0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_cmp_gt_u32 s2, 1
; VI-NEXT:    s_cselect_b64 s[4:5], -1, 0
; VI-NEXT:    s_cmp_gt_u32 s3, 2
; VI-NEXT:    s_cselect_b64 s[2:3], -1, 0
; VI-NEXT:    s_and_b64 s[2:3], s[4:5], s[2:3]
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v2, s2
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; VI-NEXT:    s_endpgm
;
; GFX9-LABEL: v_icmp_i1_ne0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_cmp_gt_u32 s2, 1
; GFX9-NEXT:    s_cselect_b64 s[4:5], -1, 0
; GFX9-NEXT:    s_cmp_gt_u32 s3, 2
; GFX9-NEXT:    s_cselect_b64 s[2:3], -1, 0
; GFX9-NEXT:    s_and_b64 s[2:3], s[4:5], s[2:3]
; GFX9-NEXT:    v_mov_b32_e32 v0, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
  %c0 = icmp ugt i32 %a, 1
  %c1 = icmp ugt i32 %b, 2
  %src = and i1 %c0, %c1
  %result = call i64 @llvm.amdgcn.icmp.i1(i1 %src, i1 false, i32 33)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

define amdgpu_ps void @test_intr_icmp_i32_invalid_cc(ptr addrspace(1) %out, i32 %src) {
; SDAG-GFX11-LABEL: test_intr_icmp_i32_invalid_cc:
; SDAG-GFX11:       ; %bb.0:
; SDAG-GFX11-NEXT:    s_endpgm
;
; SDAG-VI-LABEL: test_intr_icmp_i32_invalid_cc:
; SDAG-VI:       ; %bb.0:
; SDAG-VI-NEXT:    s_endpgm
;
; SDAG-GFX9-LABEL: test_intr_icmp_i32_invalid_cc:
; SDAG-GFX9:       ; %bb.0:
; SDAG-GFX9-NEXT:    s_endpgm
;
; GISEL-GFX11-LABEL: test_intr_icmp_i32_invalid_cc:
; GISEL-GFX11:       ; %bb.0:
; GISEL-GFX11-NEXT:    global_store_b64 v[0:1], v[0:1], off
; GISEL-GFX11-NEXT:    s_endpgm
;
; GISEL-VI-LABEL: test_intr_icmp_i32_invalid_cc:
; GISEL-VI:       ; %bb.0:
; GISEL-VI-NEXT:    flat_store_dwordx2 v[0:1], v[0:1]
; GISEL-VI-NEXT:    s_endpgm
;
; GISEL-GFX9-LABEL: test_intr_icmp_i32_invalid_cc:
; GISEL-GFX9:       ; %bb.0:
; GISEL-GFX9-NEXT:    global_store_dwordx2 v[0:1], v[0:1], off
; GISEL-GFX9-NEXT:    s_endpgm
  %result = call i64 @llvm.amdgcn.icmp.i32(i32 %src, i32 100, i32 9999)
  store i64 %result, ptr addrspace(1) %out
  ret void
}

attributes #0 = { nounwind readnone convergent }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GCN: {{.*}}
