; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV64I
; RUN: llc -mtriple=riscv64 -mattr=+zbb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV64ZBB-ZBKB
; RUN: llc -mtriple=riscv64 -mattr=+zbkb -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefixes=CHECK,RV64ZBB-ZBKB

define signext i32 @andn_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: andn_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: andn_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    andn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %neg = xor i32 %b, -1
  %and = and i32 %neg, %a
  ret i32 %and
}

define i64 @andn_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: andn_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: andn_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    andn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %neg = xor i64 %b, -1
  %and = and i64 %neg, %a
  ret i64 %and
}

define signext i32 @orn_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: orn_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: orn_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    orn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %neg = xor i32 %b, -1
  %or = or i32 %neg, %a
  ret i32 %or
}

define i64 @orn_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: orn_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: orn_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    orn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %neg = xor i64 %b, -1
  %or = or i64 %neg, %a
  ret i64 %or
}

define signext i32 @xnor_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: xnor_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: xnor_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    xnor a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %neg = xor i32 %a, -1
  %xor = xor i32 %neg, %b
  ret i32 %xor
}

define i64 @xnor_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: xnor_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: xnor_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    xnor a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %neg = xor i64 %a, -1
  %xor = xor i64 %neg, %b
  ret i64 %xor
}

define signext i32 @disjoint_or_xnor_i32(i32 signext %a, i32 signext %b) nounwind {
; CHECK-LABEL: disjoint_or_xnor_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    or a0, a0, a1
; CHECK-NEXT:    not a0, a0
; CHECK-NEXT:    ret
  %or = or disjoint i32 %a, %b
  %not = xor i32 %or, -1
  ret i32 %not
}

define i64 @disjoint_or_xnor_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: disjoint_or_xnor_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: disjoint_or_xnor_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    xnor a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %or = or disjoint i64 %a, %b
  %not = xor i64 %or, -1
  ret i64 %not
}

define signext i32 @disjoint_or_xnor_knownbits_i32(i32 signext %x, i32 signext %y, i32 signext %z) nounwind {
; RV64I-LABEL: disjoint_or_xnor_knownbits_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a0, a0, 126
; RV64I-NEXT:    andi a1, a1, -127
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: disjoint_or_xnor_knownbits_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    andi a0, a0, 126
; RV64ZBB-ZBKB-NEXT:    andi a1, a1, -127
; RV64ZBB-ZBKB-NEXT:    xnor a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %a = and i32 %x, 126
  %b = and i32 %y, -127
  %or = or i32 %a, %b
  %not = xor i32 %or, -1
  ret i32 %not
}

define i64 @disjoint_or_xnor_knownbits_i64(i64 %x, i64 %y, i64 %z) nounwind {
; RV64I-LABEL: disjoint_or_xnor_knownbits_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a0, a0, 126
; RV64I-NEXT:    andi a1, a1, -127
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: disjoint_or_xnor_knownbits_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    andi a0, a0, 126
; RV64ZBB-ZBKB-NEXT:    andi a1, a1, -127
; RV64ZBB-ZBKB-NEXT:    xnor a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %a = and i64 %x, 126
  %b = and i64 %y, -127
  %or = or i64 %a, %b
  %not = xor i64 %or, -1
  ret i64 %not
}

define signext i32 @inverted_masked_merge_i32(i32 signext %x, i32 signext %y, i32 signext %z) nounwind {
; RV64I-LABEL: inverted_masked_merge_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xor a1, a1, a2
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    xor a0, a0, a2
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: inverted_masked_merge_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    and a1, a0, a1
; RV64ZBB-ZBKB-NEXT:    andn a0, a2, a0
; RV64ZBB-ZBKB-NEXT:    xnor a0, a1, a0
; RV64ZBB-ZBKB-NEXT:    ret
  %a = and i32 %x, %y
  %notx = xor i32 %x, -1
  %b = and i32 %notx, %z
  %or = or i32 %a, %b
  %not = xor i32 %or, -1
  ret i32 %not
}

define i64 @inverted_masked_merge_i64(i64 %x, i64 %y, i64 %z) nounwind {
; RV64I-LABEL: inverted_masked_merge_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    xor a1, a1, a2
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:    xor a0, a0, a2
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: inverted_masked_merge_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    and a1, a0, a1
; RV64ZBB-ZBKB-NEXT:    andn a0, a2, a0
; RV64ZBB-ZBKB-NEXT:    xnor a0, a1, a0
; RV64ZBB-ZBKB-NEXT:    ret
  %a = and i64 %x, %y
  %notx = xor i64 %x, -1
  %b = and i64 %notx, %z
  %or = or i64 %a, %b
  %not = xor i64 %or, -1
  ret i64 %not
}

declare i32 @llvm.fshl.i32(i32, i32, i32)

define signext i32 @rol_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: rol_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a2, a0, a1
; RV64I-NEXT:    negw a1, a1
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    or a0, a2, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: rol_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    rolw a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 %b)
  ret i32 %1
}

; Similar to rol_i32, but doesn't sign extend the result.
define void @rol_i32_nosext(i32 signext %a, i32 signext %b, ptr %x) nounwind {
; RV64I-LABEL: rol_i32_nosext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sllw a3, a0, a1
; RV64I-NEXT:    negw a1, a1
; RV64I-NEXT:    srlw a0, a0, a1
; RV64I-NEXT:    or a0, a3, a0
; RV64I-NEXT:    sw a0, 0(a2)
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: rol_i32_nosext:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    rolw a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    sw a0, 0(a2)
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 %b)
  store i32 %1, ptr %x
  ret void
}

define signext i32 @rol_i32_neg_constant_rhs(i32 signext %a) nounwind {
; RV64I-LABEL: rol_i32_neg_constant_rhs:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, -2
; RV64I-NEXT:    negw a2, a0
; RV64I-NEXT:    sllw a0, a1, a0
; RV64I-NEXT:    srlw a1, a1, a2
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: rol_i32_neg_constant_rhs:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    li a1, -2
; RV64ZBB-ZBKB-NEXT:    rolw a0, a1, a0
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshl.i32(i32 -2, i32 -2, i32 %a)
  ret i32 %1
}

declare i64 @llvm.fshl.i64(i64, i64, i64)

define i64 @rol_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: rol_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sll a2, a0, a1
; RV64I-NEXT:    negw a1, a1
; RV64I-NEXT:    srl a0, a0, a1
; RV64I-NEXT:    or a0, a2, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: rol_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    rol a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %or = tail call i64 @llvm.fshl.i64(i64 %a, i64 %a, i64 %b)
  ret i64 %or
}

declare i32 @llvm.fshr.i32(i32, i32, i32)

define signext i32 @ror_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: ror_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a2, a0, a1
; RV64I-NEXT:    negw a1, a1
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    or a0, a2, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: ror_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    rorw a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 %b)
  ret i32 %1
}

; Similar to ror_i32, but doesn't sign extend the result.
define void @ror_i32_nosext(i32 signext %a, i32 signext %b, ptr %x) nounwind {
; RV64I-LABEL: ror_i32_nosext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srlw a3, a0, a1
; RV64I-NEXT:    negw a1, a1
; RV64I-NEXT:    sllw a0, a0, a1
; RV64I-NEXT:    or a0, a3, a0
; RV64I-NEXT:    sw a0, 0(a2)
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: ror_i32_nosext:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    rorw a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    sw a0, 0(a2)
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 %b)
  store i32 %1, ptr %x
  ret void
}

define signext i32 @ror_i32_neg_constant_rhs(i32 signext %a) nounwind {
; RV64I-LABEL: ror_i32_neg_constant_rhs:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, -2
; RV64I-NEXT:    negw a2, a0
; RV64I-NEXT:    srlw a0, a1, a0
; RV64I-NEXT:    sllw a1, a1, a2
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: ror_i32_neg_constant_rhs:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    li a1, -2
; RV64ZBB-ZBKB-NEXT:    rorw a0, a1, a0
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshr.i32(i32 -2, i32 -2, i32 %a)
  ret i32 %1
}

declare i64 @llvm.fshr.i64(i64, i64, i64)

define i64 @ror_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: ror_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srl a2, a0, a1
; RV64I-NEXT:    negw a1, a1
; RV64I-NEXT:    sll a0, a0, a1
; RV64I-NEXT:    or a0, a2, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: ror_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    ror a0, a0, a1
; RV64ZBB-ZBKB-NEXT:    ret
  %or = tail call i64 @llvm.fshr.i64(i64 %a, i64 %a, i64 %b)
  ret i64 %or
}

define signext i32 @rori_i32_fshl(i32 signext %a) nounwind {
; RV64I-LABEL: rori_i32_fshl:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srliw a1, a0, 1
; RV64I-NEXT:    slliw a0, a0, 31
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: rori_i32_fshl:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    roriw a0, a0, 1
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 31)
  ret i32 %1
}

; Similar to rori_i32_fshl, but doesn't sign extend the result.
define void @rori_i32_fshl_nosext(i32 signext %a, ptr %x) nounwind {
; RV64I-LABEL: rori_i32_fshl_nosext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srliw a2, a0, 1
; RV64I-NEXT:    slli a0, a0, 31
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    sw a0, 0(a1)
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: rori_i32_fshl_nosext:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    roriw a0, a0, 1
; RV64ZBB-ZBKB-NEXT:    sw a0, 0(a1)
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshl.i32(i32 %a, i32 %a, i32 31)
  store i32 %1, ptr %x
  ret void
}

define signext i32 @rori_i32_fshr(i32 signext %a) nounwind {
; RV64I-LABEL: rori_i32_fshr:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slliw a1, a0, 1
; RV64I-NEXT:    srliw a0, a0, 31
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: rori_i32_fshr:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    roriw a0, a0, 31
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 31)
  ret i32 %1
}

; Similar to rori_i32_fshr, but doesn't sign extend the result.
define void @rori_i32_fshr_nosext(i32 signext %a, ptr %x) nounwind {
; RV64I-LABEL: rori_i32_fshr_nosext:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a2, a0, 1
; RV64I-NEXT:    srliw a0, a0, 31
; RV64I-NEXT:    or a0, a0, a2
; RV64I-NEXT:    sw a0, 0(a1)
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: rori_i32_fshr_nosext:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    roriw a0, a0, 31
; RV64ZBB-ZBKB-NEXT:    sw a0, 0(a1)
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i32 @llvm.fshr.i32(i32 %a, i32 %a, i32 31)
  store i32 %1, ptr %x
  ret void
}

; This test is similar to the type legalized version of the fshl/fshr tests, but
; instead of having the same input to both shifts it has different inputs. Make
; sure we don't match it as a roriw.
define signext i32 @not_rori_i32(i32 signext %x, i32 signext %y) nounwind {
; CHECK-LABEL: not_rori_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slliw a0, a0, 31
; CHECK-NEXT:    srliw a1, a1, 1
; CHECK-NEXT:    or a0, a0, a1
; CHECK-NEXT:    ret
  %a = shl i32 %x, 31
  %b = lshr i32 %y, 1
  %c = or i32 %a, %b
  ret i32 %c
}

; This is similar to the type legalized roriw pattern, but the and mask is more
; than 32 bits so the lshr doesn't shift zeroes into the lower 32 bits. Make
; sure we don't match it to roriw.
define i64 @roriw_bug(i64 %x) nounwind {
; CHECK-LABEL: roriw_bug:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a1, a0, 31
; CHECK-NEXT:    andi a2, a0, -2
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    or a0, a1, a0
; CHECK-NEXT:    sext.w a0, a0
; CHECK-NEXT:    xor a0, a2, a0
; CHECK-NEXT:    ret
  %a = shl i64 %x, 31
  %b = and i64 %x, 18446744073709551614
  %c = lshr i64 %b, 1
  %d = or i64 %a, %c
  %e = shl i64 %d, 32
  %f = ashr i64 %e, 32
  %g = xor i64 %b, %f ; to increase the use count on %b to disable SimplifyDemandedBits.
  ret i64 %g
}

define i64 @rori_i64_fshl(i64 %a) nounwind {
; RV64I-LABEL: rori_i64_fshl:
; RV64I:       # %bb.0:
; RV64I-NEXT:    srli a1, a0, 1
; RV64I-NEXT:    slli a0, a0, 63
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: rori_i64_fshl:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    rori a0, a0, 1
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i64 @llvm.fshl.i64(i64 %a, i64 %a, i64 63)
  ret i64 %1
}

define i64 @rori_i64_fshr(i64 %a) nounwind {
; RV64I-LABEL: rori_i64_fshr:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a1, a0, 1
; RV64I-NEXT:    srli a0, a0, 63
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: rori_i64_fshr:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    rori a0, a0, 63
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = tail call i64 @llvm.fshr.i64(i64 %a, i64 %a, i64 63)
  ret i64 %1
}

define signext i32 @not_shl_one_i32(i32 signext %x) {
; RV64I-LABEL: not_shl_one_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 1
; RV64I-NEXT:    sllw a0, a1, a0
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: not_shl_one_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    li a1, -2
; RV64ZBB-ZBKB-NEXT:    rolw a0, a1, a0
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = shl i32 1, %x
  %2 = xor i32 %1, -1
  ret i32 %2
}

define i64 @not_shl_one_i64(i64 %x) {
; RV64I-LABEL: not_shl_one_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    li a1, 1
; RV64I-NEXT:    sll a0, a1, a0
; RV64I-NEXT:    not a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: not_shl_one_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    li a1, -2
; RV64ZBB-ZBKB-NEXT:    rol a0, a1, a0
; RV64ZBB-ZBKB-NEXT:    ret
  %1 = shl i64 1, %x
  %2 = xor i64 %1, -1
  ret i64 %2
}

define i8 @srli_i8(i8 %a) nounwind {
; CHECK-LABEL: srli_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 56
; CHECK-NEXT:    srli a0, a0, 62
; CHECK-NEXT:    ret
  %1 = lshr i8 %a, 6
  ret i8 %1
}

; We could use sext.b+srai, but slli+srai offers more opportunities for
; comppressed instructions.
define i8 @srai_i8(i8 %a) nounwind {
; CHECK-LABEL: srai_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 56
; CHECK-NEXT:    srai a0, a0, 61
; CHECK-NEXT:    ret
  %1 = ashr i8 %a, 5
  ret i8 %1
}

; We could use zext.h+srli, but slli+srli offers more opportunities for
; comppressed instructions.
define i16 @srli_i16(i16 %a) nounwind {
; CHECK-LABEL: srli_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 48
; CHECK-NEXT:    srli a0, a0, 54
; CHECK-NEXT:    ret
  %1 = lshr i16 %a, 6
  ret i16 %1
}

; We could use sext.h+srai, but slli+srai offers more opportunities for
; comppressed instructions.
define i16 @srai_i16(i16 %a) nounwind {
; CHECK-LABEL: srai_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    slli a0, a0, 48
; CHECK-NEXT:    srai a0, a0, 57
; CHECK-NEXT:    ret
  %1 = ashr i16 %a, 9
  ret i16 %1
}

define i1 @andn_seqz_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: andn_seqz_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: andn_seqz_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    andn a0, a1, a0
; RV64ZBB-ZBKB-NEXT:    seqz a0, a0
; RV64ZBB-ZBKB-NEXT:    ret
  %and = and i32 %a, %b
  %cmpeq = icmp eq i32 %and, %b
  ret i1 %cmpeq
}

define i1 @andn_seqz_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: andn_seqz_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    seqz a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: andn_seqz_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    andn a0, a1, a0
; RV64ZBB-ZBKB-NEXT:    seqz a0, a0
; RV64ZBB-ZBKB-NEXT:    ret
  %and = and i64 %a, %b
  %cmpeq = icmp eq i64 %and, %b
  ret i1 %cmpeq
}

define i1 @andn_snez_i32(i32 signext %a, i32 signext %b) nounwind {
; RV64I-LABEL: andn_snez_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: andn_snez_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    andn a0, a1, a0
; RV64ZBB-ZBKB-NEXT:    snez a0, a0
; RV64ZBB-ZBKB-NEXT:    ret
  %and = and i32 %a, %b
  %cmpeq = icmp ne i32 %and, %b
  ret i1 %cmpeq
}

define i1 @andn_snez_i64(i64 %a, i64 %b) nounwind {
; RV64I-LABEL: andn_snez_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: andn_snez_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    andn a0, a1, a0
; RV64ZBB-ZBKB-NEXT:    snez a0, a0
; RV64ZBB-ZBKB-NEXT:    ret
  %and = and i64 %a, %b
  %cmpeq = icmp ne i64 %and, %b
  ret i1 %cmpeq
}

define i32 @and_hoisted_not_i32(i32 %x, i32 %m, i1 zeroext %cond) {
; RV64I-LABEL: and_hoisted_not_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB38_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:  .LBB38_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: and_hoisted_not_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB38_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    andn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:  .LBB38_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i32 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = and i32 %a, %x
  ret i32 %masked

identity:
  ret i32 %x
}

define i32 @and_hoisted_not_i32_swapped(i32 %x, i32 %m, i1 zeroext %cond) {
; RV64I-LABEL: and_hoisted_not_i32_swapped:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB39_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:  .LBB39_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: and_hoisted_not_i32_swapped:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB39_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    andn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:  .LBB39_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i32 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = and i32 %x, %a
  ret i32 %masked

identity:
  ret i32 %x
}

define i64 @and_hoisted_not_i64(i64 %x, i64 %m, i1 zeroext %cond) {
; RV64I-LABEL: and_hoisted_not_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB40_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a1, a0
; RV64I-NEXT:  .LBB40_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: and_hoisted_not_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB40_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    andn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:  .LBB40_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i64 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = and i64 %a, %x
  ret i64 %masked

identity:
  ret i64 %x
}

define i64 @and_hoisted_not_i64_swapped(i64 %x, i64 %m, i1 zeroext %cond) {
; RV64I-LABEL: and_hoisted_not_i64_swapped:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB41_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:  .LBB41_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: and_hoisted_not_i64_swapped:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB41_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    andn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:  .LBB41_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i64 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = and i64 %x, %a
  ret i64 %masked

identity:
  ret i64 %x
}

define i32 @or_hoisted_not_i32(i32 %x, i32 %m, i1 zeroext %cond) {
; RV64I-LABEL: or_hoisted_not_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB42_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:  .LBB42_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: or_hoisted_not_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB42_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    orn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:  .LBB42_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i32 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = or i32 %a, %x
  ret i32 %masked

identity:
  ret i32 %x
}

define i32 @or_hoisted_not_i32_swapped(i32 %x, i32 %m, i1 zeroext %cond) {
; RV64I-LABEL: or_hoisted_not_i32_swapped:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB43_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:  .LBB43_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: or_hoisted_not_i32_swapped:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB43_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    orn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:  .LBB43_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i32 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = or i32 %x, %a
  ret i32 %masked

identity:
  ret i32 %x
}

define i64 @or_hoisted_not_i64(i64 %x, i64 %m, i1 zeroext %cond) {
; RV64I-LABEL: or_hoisted_not_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB44_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    or a0, a1, a0
; RV64I-NEXT:  .LBB44_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: or_hoisted_not_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB44_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    orn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:  .LBB44_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i64 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = or i64 %a, %x
  ret i64 %masked

identity:
  ret i64 %x
}

define i64 @or_hoisted_not_i64_swapped(i64 %x, i64 %m, i1 zeroext %cond) {
; RV64I-LABEL: or_hoisted_not_i64_swapped:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB45_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    or a0, a0, a1
; RV64I-NEXT:  .LBB45_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: or_hoisted_not_i64_swapped:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB45_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    orn a0, a0, a1
; RV64ZBB-ZBKB-NEXT:  .LBB45_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i64 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = or i64 %x, %a
  ret i64 %masked

identity:
  ret i64 %x
}

define i32 @xor_hoisted_not_i32(i32 %x, i32 %m, i1 zeroext %cond) {
; RV64I-LABEL: xor_hoisted_not_i32:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB46_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    xor a0, a1, a0
; RV64I-NEXT:  .LBB46_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: xor_hoisted_not_i32:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB46_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    xnor a0, a1, a0
; RV64ZBB-ZBKB-NEXT:  .LBB46_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i32 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = xor i32 %a, %x
  ret i32 %masked

identity:
  ret i32 %x
}

define i32 @xor_hoisted_not_i32_swapped(i32 %x, i32 %m, i1 zeroext %cond) {
; RV64I-LABEL: xor_hoisted_not_i32_swapped:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB47_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:  .LBB47_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: xor_hoisted_not_i32_swapped:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB47_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    xnor a0, a1, a0
; RV64ZBB-ZBKB-NEXT:  .LBB47_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i32 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = xor i32 %x, %a
  ret i32 %masked

identity:
  ret i32 %x
}

define i64 @xor_hoisted_not_i64(i64 %x, i64 %m, i1 zeroext %cond) {
; RV64I-LABEL: xor_hoisted_not_i64:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB48_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    xor a0, a1, a0
; RV64I-NEXT:  .LBB48_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: xor_hoisted_not_i64:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB48_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    xnor a0, a1, a0
; RV64ZBB-ZBKB-NEXT:  .LBB48_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i64 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = xor i64 %a, %x
  ret i64 %masked

identity:
  ret i64 %x
}

define i64 @xor_hoisted_not_i64_swapped(i64 %x, i64 %m, i1 zeroext %cond) {
; RV64I-LABEL: xor_hoisted_not_i64_swapped:
; RV64I:       # %bb.0:
; RV64I-NEXT:    beqz a2, .LBB49_2
; RV64I-NEXT:  # %bb.1: # %mask
; RV64I-NEXT:    not a1, a1
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:  .LBB49_2: # %identity
; RV64I-NEXT:    ret
;
; RV64ZBB-ZBKB-LABEL: xor_hoisted_not_i64_swapped:
; RV64ZBB-ZBKB:       # %bb.0:
; RV64ZBB-ZBKB-NEXT:    beqz a2, .LBB49_2
; RV64ZBB-ZBKB-NEXT:  # %bb.1: # %mask
; RV64ZBB-ZBKB-NEXT:    xnor a0, a1, a0
; RV64ZBB-ZBKB-NEXT:  .LBB49_2: # %identity
; RV64ZBB-ZBKB-NEXT:    ret
  %a = xor i64 %m, -1
  br i1 %cond, label %mask, label %identity

mask:
  %masked = xor i64 %x, %a
  ret i64 %masked

identity:
  ret i64 %x
}
