; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test widening vector multiplication on z17.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z17 | FileCheck %s

; Test a v2i64 (even) -> i128 unsigned widening multiplication.
define i128 @f1(<2 x i64> %val1, <2 x i64> %val2) {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmleg %v0, %v24, %v26
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %elt1 = extractelement <2 x i64> %val1, i32 0
  %zext1 = zext i64 %elt1 to i128
  %elt2 = extractelement <2 x i64> %val2, i32 0
  %zext2 = zext i64 %elt2 to i128
  %ret = mul i128 %zext1, %zext2
  ret i128 %ret
}

; Test a v2i64 (odd) -> i128 unsigned widening multiplication.
define i128 @f2(<2 x i64> %val1, <2 x i64> %val2) {
; CHECK-LABEL: f2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlog %v0, %v24, %v26
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %elt1 = extractelement <2 x i64> %val1, i32 1
  %zext1 = zext i64 %elt1 to i128
  %elt2 = extractelement <2 x i64> %val2, i32 1
  %zext2 = zext i64 %elt2 to i128
  %ret = mul i128 %zext1, %zext2
  ret i128 %ret
}

; Test a v2i64 (even) -> i128 signed widening multiplication.
define i128 @f3(<2 x i64> %val1, <2 x i64> %val2) {
; CHECK-LABEL: f3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmeg %v0, %v24, %v26
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %elt1 = extractelement <2 x i64> %val1, i32 0
  %sext1 = sext i64 %elt1 to i128
  %elt2 = extractelement <2 x i64> %val2, i32 0
  %sext2 = sext i64 %elt2 to i128
  %ret = mul i128 %sext1, %sext2
  ret i128 %ret
}

; Test a v2i64 (odd) -> i128 signed widening multiplication.
define i128 @f4(<2 x i64> %val1, <2 x i64> %val2) {
; CHECK-LABEL: f4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmog %v0, %v24, %v26
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %elt1 = extractelement <2 x i64> %val1, i32 1
  %sext1 = sext i64 %elt1 to i128
  %elt2 = extractelement <2 x i64> %val2, i32 1
  %sext2 = sext i64 %elt2 to i128
  %ret = mul i128 %sext1, %sext2
  ret i128 %ret
}
