; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+ndd -verify-machineinstrs | FileCheck %s

define i16 @shrd16rrcl(i16 noundef %a, i16 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd16rrcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb $15, %dl, %cl
; CHECK-NEXT:    shrdw %cl, %di, %si, %ax
; CHECK-NEXT:    retq
entry:
    %clin = sext i8 %cl to i16
    %shrd = call i16 @llvm.fshr.i16(i16 %a, i16 %b, i16 %clin)
    ret i16 %shrd
}

define i16 @shrd16rrcl_mask(i16 noundef %a, i16 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd16rrcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb $15, %dl, %cl
; CHECK-NEXT:    shrdw %cl, %di, %si, %ax
; CHECK-NEXT:    retq
entry:
    %clin = sext i8 %cl to i16
    %shamt = and i16 %clin, 31
    %shrd = call i16 @llvm.fshr.i16(i16 %a, i16 %b, i16 %shamt)
    ret i16 %shrd
}

define i32 @shrd32rrcl(i32 noundef %a, i32 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd32rrcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrdl %cl, %edi, %esi, %eax
; CHECK-NEXT:    retq
entry:
    %clin = sext i8 %cl to i32
    %shrd = call i32 @llvm.fshr.i32(i32 %a, i32 %b, i32 %clin)
    ret i32 %shrd
}

define i32 @shrd32rrcl_mask(i32 noundef %a, i32 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd32rrcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrdl %cl, %edi, %esi, %eax
; CHECK-NEXT:    retq
entry:
    %clin = sext i8 %cl to i32
    %shamt = and i32 %clin, 31
    %shrd = call i32 @llvm.fshr.i32(i32 %a, i32 %b, i32 %shamt)
    ret i32 %shrd
}

define i64 @shrd64rrcl(i64 noundef %a, i64 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd64rrcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrdq %cl, %rdi, %rsi, %rax
; CHECK-NEXT:    retq
entry:
    %clin = sext i8 %cl to i64
    %shrd = call i64 @llvm.fshr.i64(i64 %a, i64 %b, i64 %clin)
    ret i64 %shrd
}

define i64 @shrd64rrcl_mask(i64 noundef %a, i64 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd64rrcl_mask:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrdq %cl, %rdi, %rsi, %rax
; CHECK-NEXT:    retq
entry:
    %clin = sext i8 %cl to i64
    %shamt = and i64 %clin, 63
    %shrd = call i64 @llvm.fshr.i64(i64 %a, i64 %b, i64 %shamt)
    ret i64 %shrd
}

define i16 @shrd16rri8(i16 noundef %a, i16 noundef %b) {
; CHECK-LABEL: shrd16rri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrdw $12, %di, %si, %ax
; CHECK-NEXT:    retq
entry:
    %shrd = call i16 @llvm.fshr.i16(i16 %a, i16 %b, i16 12)
    ret i16 %shrd
}

define i32 @shrd32rri8(i32 noundef %a, i32 noundef %b) {
; CHECK-LABEL: shrd32rri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrdl $12, %edi, %esi, %eax
; CHECK-NEXT:    retq
entry:
    %shrd = call i32 @llvm.fshr.i32(i32 %a, i32 %b, i32 12)
    ret i32 %shrd
}

define i64 @shrd64rri8(i64 noundef %a, i64 noundef %b) {
; CHECK-LABEL: shrd64rri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrdq $12, %rdi, %rsi, %rax
; CHECK-NEXT:    retq
entry:
    %shrd = call i64 @llvm.fshr.i64(i64 %a, i64 %b, i64 12)
    ret i64 %shrd
}

define i16 @shrd16mrcl(ptr %ptr, i16 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd16mrcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movzwl (%rdi), %eax
; CHECK-NEXT:    andb $15, %dl, %cl
; CHECK-NEXT:    shrdw %cl, %ax, %si, %ax
; CHECK-NEXT:    retq
entry:
    %a = load i16, ptr %ptr
    %clin = sext i8 %cl to i16
    %shrd = call i16 @llvm.fshr.i16(i16 %a, i16 %b, i16 %clin)
    ret i16 %shrd
}

define i32 @shrd32mrcl(ptr %ptr, i32 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd32mrcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    movl (%rdi), %eax
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrdl %cl, %eax, %esi, %eax
; CHECK-NEXT:    retq
entry:
    %a = load i32, ptr %ptr
    %clin = sext i8 %cl to i32
    %shrd = call i32 @llvm.fshr.i32(i32 %a, i32 %b, i32 %clin)
    ret i32 %shrd
}

define i64 @shrd64mrcl(ptr %ptr, i64 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd64mrcl:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    movq (%rdi), %rax
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrdq %cl, %rax, %rsi, %rax
; CHECK-NEXT:    retq
entry:
    %a = load i64, ptr %ptr
    %clin = sext i8 %cl to i64
    %shrd = call i64 @llvm.fshr.i64(i64 %a, i64 %b, i64 %clin)
    ret i64 %shrd
}

define i16 @shrd16mri8(ptr %ptr, i16 noundef %b) {
; CHECK-LABEL: shrd16mri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shldw $4, %si, (%rdi), %ax
; CHECK-NEXT:    retq
entry:
    %a = load i16, ptr %ptr
    %shrd = call i16 @llvm.fshr.i16(i16 %a, i16 %b, i16 12)
    ret i16 %shrd
}

define i32 @shrd32mri8(ptr %ptr, i32 noundef %b) {
; CHECK-LABEL: shrd32mri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shldl $20, %esi, (%rdi), %eax
; CHECK-NEXT:    retq
entry:
    %a = load i32, ptr %ptr
    %shrd = call i32 @llvm.fshr.i32(i32 %a, i32 %b, i32 12)
    ret i32 %shrd
}

define i64 @shrd64mri8(ptr %ptr, i64 noundef %b) {
; CHECK-LABEL: shrd64mri8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shldq $52, %rsi, (%rdi), %rax
; CHECK-NEXT:    retq
entry:
    %a = load i64, ptr %ptr
    %shrd = call i64 @llvm.fshr.i64(i64 %a, i64 %b, i64 12)
    ret i64 %shrd
}

define void @shrd16mrcl_legacy(ptr %ptr, i16 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd16mrcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    andb $15, %dl, %cl
; CHECK-NEXT:    shrdw %cl, %si, (%rdi)
; CHECK-NEXT:    retq
entry:
    %a = load i16, ptr %ptr
    %clin = sext i8 %cl to i16
    %shrd = call i16 @llvm.fshr.i16(i16 %b, i16 %a, i16 %clin)
    store i16 %shrd, ptr %ptr
    ret void
}

define void @shrd32mrcl_legacy(ptr %ptr, i32 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd32mrcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrdl %cl, %esi, (%rdi)
; CHECK-NEXT:    retq
entry:
    %a = load i32, ptr %ptr
    %clin = sext i8 %cl to i32
    %shrd = call i32 @llvm.fshr.i32(i32 %b, i32 %a, i32 %clin)
    store i32 %shrd, ptr %ptr
    ret void
}

define void @shrd64mrcl_legacy(ptr %ptr, i64 noundef %b, i8 %cl) {
; CHECK-LABEL: shrd64mrcl_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    movl %edx, %ecx
; CHECK-NEXT:    # kill: def $cl killed $cl killed $ecx
; CHECK-NEXT:    shrdq %cl, %rsi, (%rdi)
; CHECK-NEXT:    retq
entry:
    %a = load i64, ptr %ptr
    %clin = sext i8 %cl to i64
    %shrd = call i64 @llvm.fshr.i64(i64 %b, i64 %a, i64 %clin)
    store i64 %shrd, ptr %ptr
    ret void
}

define void @shrd16mri8_legacy(ptr %ptr, i16 noundef %b) {
; CHECK-LABEL: shrd16mri8_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrdw $12, %si, (%rdi)
; CHECK-NEXT:    retq
entry:
    %a = load i16, ptr %ptr
    %shrd = call i16 @llvm.fshr.i16(i16 %b, i16 %a, i16 12)
    store i16 %shrd, ptr %ptr
    ret void
}

define void @shrd32mri8_legacy(ptr %ptr, i32 noundef %b) {
; CHECK-LABEL: shrd32mri8_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrdl $12, %esi, (%rdi)
; CHECK-NEXT:    retq
entry:
    %a = load i32, ptr %ptr
    %shrd = call i32 @llvm.fshr.i32(i32 %b, i32 %a, i32 12)
    store i32 %shrd, ptr %ptr
    ret void
}

define void @shrd64mri8_legacy(ptr %ptr, i64 noundef %b) {
; CHECK-LABEL: shrd64mri8_legacy:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    shrdq $12, %rsi, (%rdi)
; CHECK-NEXT:    retq
entry:
    %a = load i64, ptr %ptr
    %shrd = call i64 @llvm.fshr.i64(i64 %b, i64 %a, i64 12)
    store i64 %shrd, ptr %ptr
    ret void
}
