;; Check that we can read the old STACK_ID summary format that encoded the id as
;; a VBR8 instead of as a pair of 32-bit fixed-width values.
;;
;; The old bitcode was generated by the older compiler from `opt -thinlto-bc`
;; on the following LLVM assembly:
;;
;; target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
;; target triple = "x86_64-unknown-linux-gnu"
;;
;; define void @bar() {
;;   call void @foo(), !callsite !0
;;   ret void
;; }
;;
;; declare void @foo()
;;
;; !0 = !{i64 9086428284934609951}

; RUN: llvm-dis %S/Inputs/memprof-old-stackid-summary.bc -o - | FileCheck %s
; CHECK: stackIds: (9086428284934609951)
