; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

declare void @sink(i32)

define internal void @test(ptr %X) !dbg !2 {
; CHECK-LABEL: define {{[^@]+}}@test
; CHECK-SAME: (ptr nofree noundef nonnull readonly align 8 captures(none) dereferenceable(8) [[X:%.*]]) !dbg [[DBG3:![0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[X]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr [[TMP1]], align 8
; CHECK-NEXT:    call void @sink(i32 [[TMP2]])
; CHECK-NEXT:    ret void
;
  %1 = load ptr, ptr %X, align 8
  %2 = load i32, ptr %1, align 8
  call void @sink(i32 %2)
  ret void
}

%struct.pair = type { i32, i32 }

define internal void @test_byval(ptr byval(%struct.pair) %P) {
; CHECK: Function Attrs: memory(readwrite, argmem: none)
; CHECK-LABEL: define {{[^@]+}}@test_byval
; CHECK-SAME: () #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    call void @sink(i32 noundef 0)
; CHECK-NEXT:    ret void
;
  call void @sink(i32 0)
  ret void
}

define void @caller(ptr %Y, ptr %P) {
; TUNIT-LABEL: define {{[^@]+}}@caller
; TUNIT-SAME: (ptr nofree readonly captures(none) [[Y:%.*]], ptr nofree readnone captures(none) [[P:%.*]]) {
; TUNIT-NEXT:    call void @test(ptr nofree noundef readonly align 8 captures(none) [[Y]]), !dbg [[DBG4:![0-9]+]]
; TUNIT-NEXT:    call void @test_byval(), !dbg [[DBG5:![0-9]+]]
; TUNIT-NEXT:    ret void
;
; CGSCC-LABEL: define {{[^@]+}}@caller
; CGSCC-SAME: (ptr nofree noundef nonnull readonly align 8 captures(none) dereferenceable(8) [[Y:%.*]], ptr nofree readnone captures(none) [[P:%.*]]) {
; CGSCC-NEXT:    call void @test(ptr nofree noundef nonnull readonly align 8 captures(none) dereferenceable(8) [[Y]]), !dbg [[DBG4:![0-9]+]]
; CGSCC-NEXT:    call void @test_byval(), !dbg [[DBG5:![0-9]+]]
; CGSCC-NEXT:    ret void
;
  call void @test(ptr %Y), !dbg !1

  call void @test_byval(ptr byval(%struct.pair) %P), !dbg !6
  ret void
}


!llvm.module.flags = !{!0}
!llvm.dbg.cu = !{!3}

!0 = !{i32 2, !"Debug Info Version", i32 3}
!1 = !DILocation(line: 8, scope: !2)
!2 = distinct !DISubprogram(name: "test", file: !5, line: 3, isLocal: true, isDefinition: true, virtualIndex: 6, flags: DIFlagPrototyped, isOptimized: false, unit: !3, scopeLine: 3, scope: null)
!3 = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, producer: "clang version 3.5.0 ", isOptimized: false, emissionKind: LineTablesOnly, file: !5)
!5 = !DIFile(filename: "test.c", directory: "")
!6 = !DILocation(line: 9, scope: !2)
;.
; TUNIT: attributes #[[ATTR0]] = { memory(readwrite, argmem: none) }
;.
; CGSCC: attributes #[[ATTR0]] = { memory(readwrite, argmem: none) }
;.
; TUNIT: [[META0:![0-9]+]] = !{i32 2, !"Debug Info Version", i32 3}
; TUNIT: [[META1:![0-9]+]] = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: [[META2:![0-9]+]], producer: "{{.*}}clang version {{.*}} ", isOptimized: false, runtimeVersion: 0, emissionKind: LineTablesOnly)
; TUNIT: [[META2]] = !DIFile(filename: "test.c", directory: "")
; TUNIT: [[DBG3]] = distinct !DISubprogram(name: "test", scope: null, file: [[META2]], line: 3, scopeLine: 3, virtualIndex: 6, flags: DIFlagPrototyped, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition, unit: [[META1]])
; TUNIT: [[DBG4]] = !DILocation(line: 8, scope: [[DBG3]])
; TUNIT: [[DBG5]] = !DILocation(line: 9, scope: [[DBG3]])
;.
; CGSCC: [[META0:![0-9]+]] = !{i32 2, !"Debug Info Version", i32 3}
; CGSCC: [[META1:![0-9]+]] = distinct !DICompileUnit(language: DW_LANG_C_plus_plus, file: [[META2:![0-9]+]], producer: "{{.*}}clang version {{.*}} ", isOptimized: false, runtimeVersion: 0, emissionKind: LineTablesOnly)
; CGSCC: [[META2]] = !DIFile(filename: "test.c", directory: "")
; CGSCC: [[DBG3]] = distinct !DISubprogram(name: "test", scope: null, file: [[META2]], line: 3, scopeLine: 3, virtualIndex: 6, flags: DIFlagPrototyped, spFlags: DISPFlagLocalToUnit | DISPFlagDefinition, unit: [[META1]])
; CGSCC: [[DBG4]] = !DILocation(line: 8, scope: [[DBG3]])
; CGSCC: [[DBG5]] = !DILocation(line: 9, scope: [[DBG3]])
;.
