; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown             | FileCheck %s --check-prefixes=X86,X86-NOSSE
; RUN: llc < %s -mtriple=i686-unknown -mattr=sse2 | FileCheck %s --check-prefixes=X86,X86-SSE2
; RUN: llc < %s -mtriple=i686-unknown -mattr=avx | FileCheck %s --check-prefixes=X86,X86-AVX
; RUN: llc < %s -mtriple=i686-unknown -mattr=avx512f | FileCheck %s --check-prefixes=X86,X86-AVX
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefixes=X64,X64-SSE
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=avx | FileCheck %s --check-prefixes=X64,X64-AVX
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=avx512f | FileCheck %s --check-prefixes=X64,X64-AVX

define i32 @testmsws(float %x) {
; X86-NOSSE-LABEL: testmsws:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    pushl %eax
; X86-NOSSE-NEXT:    .cfi_def_cfa_offset 8
; X86-NOSSE-NEXT:    flds {{[0-9]+}}(%esp)
; X86-NOSSE-NEXT:    fistpl (%esp)
; X86-NOSSE-NEXT:    movl (%esp), %eax
; X86-NOSSE-NEXT:    popl %ecx
; X86-NOSSE-NEXT:    .cfi_def_cfa_offset 4
; X86-NOSSE-NEXT:    retl
;
; X86-SSE2-LABEL: testmsws:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    cvtss2si {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    retl
;
; X86-AVX-LABEL: testmsws:
; X86-AVX:       # %bb.0: # %entry
; X86-AVX-NEXT:    vcvtss2si {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: testmsws:
; X64-SSE:       # %bb.0: # %entry
; X64-SSE-NEXT:    cvtss2si %xmm0, %eax
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: testmsws:
; X64-AVX:       # %bb.0: # %entry
; X64-AVX-NEXT:    vcvtss2si %xmm0, %eax
; X64-AVX-NEXT:    retq
entry:
  %0 = tail call i32 @llvm.lrint.i32.f32(float %x)
  ret i32 %0
}

define i32 @testmswd(double %x) {
; X86-NOSSE-LABEL: testmswd:
; X86-NOSSE:       # %bb.0: # %entry
; X86-NOSSE-NEXT:    pushl %eax
; X86-NOSSE-NEXT:    .cfi_def_cfa_offset 8
; X86-NOSSE-NEXT:    fldl {{[0-9]+}}(%esp)
; X86-NOSSE-NEXT:    fistpl (%esp)
; X86-NOSSE-NEXT:    movl (%esp), %eax
; X86-NOSSE-NEXT:    popl %ecx
; X86-NOSSE-NEXT:    .cfi_def_cfa_offset 4
; X86-NOSSE-NEXT:    retl
;
; X86-SSE2-LABEL: testmswd:
; X86-SSE2:       # %bb.0: # %entry
; X86-SSE2-NEXT:    cvtsd2si {{[0-9]+}}(%esp), %eax
; X86-SSE2-NEXT:    retl
;
; X86-AVX-LABEL: testmswd:
; X86-AVX:       # %bb.0: # %entry
; X86-AVX-NEXT:    vcvtsd2si {{[0-9]+}}(%esp), %eax
; X86-AVX-NEXT:    retl
;
; X64-SSE-LABEL: testmswd:
; X64-SSE:       # %bb.0: # %entry
; X64-SSE-NEXT:    cvtsd2si %xmm0, %eax
; X64-SSE-NEXT:    retq
;
; X64-AVX-LABEL: testmswd:
; X64-AVX:       # %bb.0: # %entry
; X64-AVX-NEXT:    vcvtsd2si %xmm0, %eax
; X64-AVX-NEXT:    retq
entry:
  %0 = tail call i32 @llvm.lrint.i32.f64(double %x)
  ret i32 %0
}

define i32 @testmsll(x86_fp80 %x) {
; X86-LABEL: testmsll:
; X86:       # %bb.0: # %entry
; X86-NEXT:    pushl %eax
; X86-NEXT:    .cfi_def_cfa_offset 8
; X86-NEXT:    fldt {{[0-9]+}}(%esp)
; X86-NEXT:    fistpl (%esp)
; X86-NEXT:    movl (%esp), %eax
; X86-NEXT:    popl %ecx
; X86-NEXT:    .cfi_def_cfa_offset 4
; X86-NEXT:    retl
;
; X64-LABEL: testmsll:
; X64:       # %bb.0: # %entry
; X64-NEXT:    fldt {{[0-9]+}}(%rsp)
; X64-NEXT:    fistpl -{{[0-9]+}}(%rsp)
; X64-NEXT:    movl -{{[0-9]+}}(%rsp), %eax
; X64-NEXT:    retq
entry:
  %0 = tail call i32 @llvm.lrint.i32.f80(x86_fp80 %x)
  ret i32 %0
}

declare i32 @llvm.lrint.i32.f32(float) nounwind readnone
declare i32 @llvm.lrint.i32.f64(double) nounwind readnone
declare i32 @llvm.lrint.i32.f80(x86_fp80) nounwind readnone
