/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLKeygenElement.h"

#include "ExceptionCode.h"
#include "HTMLFormElement.h"
#include "HTMLKeygenElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLKeygenElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLKeygenElementTableValues[13] =
{
    { "autofocus", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementAutofocus), (intptr_t)setJSHTMLKeygenElementAutofocus THUNK_GENERATOR(0) },
    { "challenge", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementChallenge), (intptr_t)setJSHTMLKeygenElementChallenge THUNK_GENERATOR(0) },
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementDisabled), (intptr_t)setJSHTMLKeygenElementDisabled THUNK_GENERATOR(0) },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementForm), (intptr_t)0 THUNK_GENERATOR(0) },
    { "keytype", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementKeytype), (intptr_t)setJSHTMLKeygenElementKeytype THUNK_GENERATOR(0) },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementName), (intptr_t)setJSHTMLKeygenElementName THUNK_GENERATOR(0) },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementType), (intptr_t)0 THUNK_GENERATOR(0) },
    { "willValidate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementWillValidate), (intptr_t)0 THUNK_GENERATOR(0) },
    { "validity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementValidity), (intptr_t)0 THUNK_GENERATOR(0) },
    { "validationMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementValidationMessage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "labels", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementLabels), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLKeygenElementTable = { 34, 31, JSHTMLKeygenElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLKeygenElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLKeygenElementConstructorTable = { 1, 0, JSHTMLKeygenElementConstructorTableValues, 0 };
class JSHTMLKeygenElementConstructor : public DOMConstructorObject {
public:
    JSHTMLKeygenElementConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLKeygenElementConstructor::s_info = { "HTMLKeygenElementConstructor", &DOMConstructorObject::s_info, &JSHTMLKeygenElementConstructorTable, 0 };

JSHTMLKeygenElementConstructor::JSHTMLKeygenElementConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLKeygenElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLKeygenElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLKeygenElementConstructor, JSDOMWrapper>(exec, &JSHTMLKeygenElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLKeygenElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLKeygenElementConstructor, JSDOMWrapper>(exec, &JSHTMLKeygenElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLKeygenElementPrototypeTableValues[3] =
{
    { "checkValidity", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLKeygenElementPrototypeFunctionCheckValidity), (intptr_t)0 THUNK_GENERATOR(0) },
    { "setCustomValidity", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLKeygenElementPrototypeFunctionSetCustomValidity), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLKeygenElementPrototypeTable = { 4, 3, JSHTMLKeygenElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLKeygenElementPrototype::s_info = { "HTMLKeygenElementPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSHTMLKeygenElementPrototypeTable, 0 };

JSObject* JSHTMLKeygenElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLKeygenElement>(exec, globalObject);
}

bool JSHTMLKeygenElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLKeygenElementPrototypeTable, this, propertyName, slot);
}

bool JSHTMLKeygenElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLKeygenElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHTMLKeygenElement::s_info = { "HTMLKeygenElement", &JSHTMLElement::s_info, &JSHTMLKeygenElementTable, 0 };

JSHTMLKeygenElement::JSHTMLKeygenElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLKeygenElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLKeygenElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLKeygenElementPrototype(exec->globalData(), globalObject, JSHTMLKeygenElementPrototype::createStructure(exec->globalData(), JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLKeygenElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLKeygenElement, Base>(exec, &JSHTMLKeygenElementTable, this, propertyName, slot);
}

bool JSHTMLKeygenElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLKeygenElement, Base>(exec, &JSHTMLKeygenElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLKeygenElementAutofocus(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::autofocusAttr));
    return result;
}


JSValue jsHTMLKeygenElementChallenge(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::challengeAttr));
    return result;
}


JSValue jsHTMLKeygenElementDisabled(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::disabledAttr));
    return result;
}


JSValue jsHTMLKeygenElementForm(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->form()));
    return result;
}


JSValue jsHTMLKeygenElementKeytype(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::HTMLNames::keytypeAttr));
    return result;
}


JSValue jsHTMLKeygenElementName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->name());
    return result;
}


JSValue jsHTMLKeygenElementType(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->type());
    return result;
}


JSValue jsHTMLKeygenElementWillValidate(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->willValidate());
    return result;
}


JSValue jsHTMLKeygenElementValidity(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->validity()));
    return result;
}


JSValue jsHTMLKeygenElementValidationMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->validationMessage());
    return result;
}


JSValue jsHTMLKeygenElementLabels(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->labels()));
    return result;
}


JSValue jsHTMLKeygenElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLKeygenElement* domObject = static_cast<JSHTMLKeygenElement*>(asObject(slotBase));
    return JSHTMLKeygenElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLKeygenElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSHTMLKeygenElement, Base>(exec, propertyName, value, &JSHTMLKeygenElementTable, this, slot);
}

void setJSHTMLKeygenElementAutofocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(thisObject);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value.toBoolean(exec));
}


void setJSHTMLKeygenElementChallenge(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(thisObject);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::challengeAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLKeygenElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(thisObject);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value.toBoolean(exec));
}


void setJSHTMLKeygenElementKeytype(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(thisObject);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::keytypeAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLKeygenElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(thisObject);
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    imp->setName(ustringToString(value.toString(exec)));
}


JSValue JSHTMLKeygenElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLKeygenElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLKeygenElementPrototypeFunctionCheckValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLKeygenElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(thisValue));
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());


    JSC::JSValue result = jsBoolean(imp->checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLKeygenElementPrototypeFunctionSetCustomValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLKeygenElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLKeygenElement* castedThis = static_cast<JSHTMLKeygenElement*>(asObject(thisValue));
    HTMLKeygenElement* imp = static_cast<HTMLKeygenElement*>(castedThis->impl());
    const String& error(valueToStringWithUndefinedOrNullCheck(exec, exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}


}
