/**
 * @file
 * Text parsing functions
 *
 * @authors
 * Copyright (C) 2023 Richard Russon <rich@flatcap.org>
 *
 * @copyright
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * @page lib_parse Text parsing functions
 *
 * | File                | Description                |
 * | :------------------ | :------------------------- |
 * | parse/extract.c     | @subpage parse_extract     |
 * | parse/rc.c          | @subpage parse_rc          |
 * | parse/set.c         | @subpage parse_set         |
 */

#ifndef MUTT_PARSE_LIB_H
#define MUTT_PARSE_LIB_H

// IWYU pragma: begin_exports
#include "extract.h"
#include "rc.h"
#include "set.h"
// IWYU pragma: end_exports

#endif /* MUTT_PARSE_LIB_H */
