/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.40 from the
 * contents of TrapReceiver.xs. Do not edit this file, edit TrapReceiver.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "TrapReceiver.xs"
/* -*- c -*- */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "ppport.h"

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#include "perl_snmptrapd.h"

#include "const-c.inc"

typedef struct trapd_cb_data_s {
   SV *perl_cb;
} trapd_cb_data;

typedef struct netsnmp_oid_s {
    oid                 *name;
    size_t               len;
    oid                  namebuf[ MAX_OID_LEN ];
} netsnmp_oid;

static SV* newSVoid(oid* sname, size_t slen)
{
    /*assert(slen < MAX_OID_LEN);*/
    netsnmp_oid *o = malloc(sizeof(netsnmp_oid));
    o->name = o->namebuf;
    o->len = slen;
    memcpy(o->name, sname, slen * sizeof(oid));

#undef CALL_EXTERNAL_OID_NEW

#ifdef CALL_EXTERNAL_OID_NEW
    {
      SV *arg;
      SV *rarg;

      PUSHMARK(sp);

      rarg = sv_2mortal(newSViv((IV) 0));
      arg = sv_2mortal(newSVrv(rarg, "netsnmp_oidPtr"));
      sv_setiv(arg, (IV) o);
      XPUSHs(rarg);

      PUTBACK;
      i = perl_call_pv("NetSNMP::OID::newwithptr", G_SCALAR);
      SPAGAIN;

      if (i != 1) {
	snmp_log(LOG_ERR, "unhandled OID error.\n");
	/* ack XXX */
      }
      /* get the value */
      {
	  SV *rv = POPs;
	  SvREFCNT_inc(rv);
	  PUTBACK;
	  return rv;
      }
    }
#else /* build it and bless ourselves */
    {
      HV *hv = newHV();
      SV *rv = newRV_noinc((SV *) hv);
      SV *rvsub = newRV_noinc((SV *) newSViv((UV) o));
      rvsub = sv_bless(rvsub, gv_stashpv("netsnmp_oidPtr", 1));
      (void)hv_store(hv, "oidptr", 6,  rvsub, 0);
      return sv_bless(rv, gv_stashpv("NetSNMP::OID", 1));
    }
#endif /* build oid ourselves */
}

int   perl_trapd_handler( netsnmp_pdu           *pdu,
                          netsnmp_transport     *transport,
                          netsnmp_trapd_handler *handler)
{
    trapd_cb_data *cb_data;
    SV *pcallback;
    netsnmp_variable_list *vb;
    SV **tmparray;
    int i, c = 0;
    u_char *outbuf;
    size_t ob_len = 0, oo_len = 0;
    AV *varbinds;
    HV *pduinfo;
    int noValuesReturned;
    int callingCFfailed = 0;
    int result = NETSNMPTRAPD_HANDLER_OK;
    netsnmp_pdu * v2pdu = NULL;

    dSP;
    ENTER;
    SAVETMPS;

    if (!pdu || !handler)
        return 0;

    /* nuke v1 PDUs */
    if (pdu->command == SNMP_MSG_TRAP) {
        v2pdu = convert_v1pdu_to_v2(pdu);
        pdu = v2pdu;
    }

    cb_data = handler->handler_data;
    if (!cb_data || !cb_data->perl_cb)
        return 0;

    pcallback = cb_data->perl_cb;

    /* get PDU related info */
    pduinfo = newHV();
#define STOREPDU(n, v) (void)hv_store(pduinfo, n, strlen(n), v, 0)
#define STOREPDUi(n, v) STOREPDU(n, newSViv(v))
#define STOREPDUs(n, v) STOREPDU(n, newSVpv(v, 0))
    STOREPDUi("version", pdu->version);
    STOREPDUs("notificationtype", ((pdu->command == SNMP_MSG_INFORM) ? "INFORM":"TRAP"));
    STOREPDUi("requestid", pdu->reqid);
    STOREPDUi("messageid", pdu->msgid);
    STOREPDUi("transactionid", pdu->transid);
    STOREPDUi("errorstatus", pdu->errstat);
    STOREPDUi("errorindex", pdu->errindex);
    if (pdu->version == 3) {
        STOREPDUi("securitymodel", pdu->securityModel);
        STOREPDUi("securitylevel", pdu->securityLevel);
        STOREPDU("contextName",
                 newSVpv(pdu->contextName ? pdu->contextName : "", pdu->contextNameLen));
        STOREPDU("contextEngineID",
                 newSVpv(pdu->contextEngineID ? (char *) pdu->contextEngineID : "",
                                    pdu->contextEngineIDLen));
        STOREPDU("securityEngineID",
                 newSVpv(pdu->securityEngineID ? (char *) pdu->securityEngineID : "",
                                    pdu->securityEngineIDLen));
        STOREPDU("securityName",
                 newSVpv(pdu->securityName ? (char *) pdu->securityName : "", pdu->securityNameLen));
    } else {
        STOREPDU("community",
                 newSVpv(pdu->community ? (char *) pdu->community : "", pdu->community_len));
    }

    if (transport && transport->f_fmtaddr) {
        char *tstr = transport->f_fmtaddr(transport, pdu->transport_data,
                                          pdu->transport_data_length);
        STOREPDUs("receivedfrom", tstr);
        netsnmp_free(tstr);
    }


    /*
     * collect OID objects in a temp array first
     */
    /* get VARBIND related info */
    i = count_varbinds(pdu->variables);
    tmparray = malloc(sizeof(*tmparray) * i);

    for(vb = pdu->variables; vb; vb = vb->next_variable) {

        /* get the oid */
	tmparray[c++] = newSVoid(vb->name, vb->name_length);
    }

    /*
     * build the varbind lists
     */
    varbinds = newAV();
    for(vb = pdu->variables, i = 0; vb; vb = vb->next_variable, i++) {
        /* push the oid */
        AV *vba;
        vba = newAV();


        /* get the value */
        outbuf = NULL;
        ob_len = 0;
        oo_len = 0;
	sprint_realloc_by_type(&outbuf, &ob_len, &oo_len, 1,
                               vb, 0, 0, 0);

        av_push(vba,tmparray[i]);
        av_push(vba,newSVpvn((char *) outbuf, oo_len));
        netsnmp_free(outbuf);
        av_push(vba,newSViv(vb->type));
	switch (vb->type) {
	case ASN_INTEGER:
		av_push(vba,newSViv((int32_t)*vb->val.integer));
		break;
	case ASN_COUNTER:
	case ASN_GAUGE:
	case ASN_TIMETICKS:
	case ASN_UINTEGER: /* from rfc1442 */
		av_push(vba,newSVuv((uint32_t)*vb->val.integer));
		break;
	case ASN_IPADDRESS:
	case ASN_OCTET_STR:
	case ASN_OPAQUE:
	case ASN_NSAP:
		av_push(vba,newSVpvn((char*)vb->val.string,vb->val_len));
		break;
	case ASN_BIT_STR:
		av_push(vba,newSVpvn((char*)vb->val.bitstring,vb->val_len));
		break;
	case ASN_OBJECT_ID:
		av_push(vba,newSVoid(vb->val.objid,vb->val_len / sizeof(oid)));
		break;
#ifdef NETSNMP_WITH_OPAQUE_SPECIAL_TYPES
	case ASN_OPAQUE_FLOAT:
		av_push(vba,newSVnv(*vb->val.floatVal));
		break;
	case ASN_OPAQUE_DOUBLE:
		av_push(vba,newSVnv(*vb->val.doubleVal));
		break;
	case ASN_OPAQUE_I64:
		{
			char buf[I64CHARSZ + 1];
			printI64(buf, vb->val.counter64);
			av_push(vba,newSVpv(buf,0));
		}
		break;
	case ASN_OPAQUE_COUNTER64:
	case ASN_OPAQUE_U64:
#endif
	case ASN_COUNTER64:
		{
			char buf[I64CHARSZ + 1];
			printU64(buf, vb->val.counter64);
			av_push(vba,newSVpv(buf,0));
		}
		break;
	case ASN_NULL:
	default:
		av_push(vba,newSV(0));
		break;
	}
        av_push(varbinds, (SV *) newRV_noinc((SV *) vba));
    }

    PUSHMARK(sp);

    /* store the collected information on the stack */
    XPUSHs(sv_2mortal(newRV_noinc((SV*) pduinfo)));
    XPUSHs(sv_2mortal(newRV_noinc((SV*) varbinds)));

    /* put the stack back in order */
    PUTBACK;

    /* actually call the callback function */
    if (SvTYPE(pcallback) == SVt_PVCV) {
        noValuesReturned = perl_call_sv(pcallback, G_SCALAR);
        /* XXX: it discards the results, which isn't right */
    } else if (SvROK(pcallback) && SvTYPE(SvRV(pcallback)) == SVt_PVCV) {
        /* reference to code */
        noValuesReturned = perl_call_sv(SvRV(pcallback), G_SCALAR);
    } else {
        snmp_log(LOG_ERR, " tried to call a perl function but failed to understand its type: (ref = %p, svrok: %lu, SVTYPE: %lu)\n", pcallback, (unsigned long)SvROK(pcallback), (unsigned long)SvTYPE(pcallback));
	callingCFfailed = 1;
    }

    if (!callingCFfailed) {
      SPAGAIN;

      if ( noValuesReturned == 0 ) {
        snmp_log(LOG_WARNING, " perl callback function %p did not return a scalar, assuming %d (NETSNMPTRAPD_HANDLER_OK)\n", pcallback, NETSNMPTRAPD_HANDLER_OK);
      }
      else {
	SV *rv = POPs;

	if (SvTYPE(rv) != SVt_IV) {
	  snmp_log(LOG_WARNING, " perl callback function %p returned a scalar of type %lu instead of an integer, assuming %d (NETSNMPTRAPD_HANDLER_OK)\n", pcallback, (unsigned long)SvTYPE(rv), NETSNMPTRAPD_HANDLER_OK);
	}
	else {
	  int rvi = (IV)SvIVx(rv);

	  if ((NETSNMPTRAPD_HANDLER_OK <= rvi) && (rvi <= NETSNMPTRAPD_HANDLER_FINISH)) {
	    snmp_log(LOG_DEBUG, " perl callback function %p returns %d\n", pcallback, rvi);
	    result = rvi;
	  }
	  else {
	    snmp_log(LOG_WARNING, " perl callback function %p returned an invalid scalar integer value (%d), assuming %d (NETSNMPTRAPD_HANDLER_OK)\n", pcallback, rvi, NETSNMPTRAPD_HANDLER_OK);
	  }
	}
      }

      PUTBACK;
    }

#ifdef DUMPIT
    fprintf(stderr, "DUMPDUMPDUMPDUMPDUMPDUMP\n");
    sv_dump(pduinfo);
    fprintf(stderr, "--------------------\n");
    sv_dump(varbinds);
#endif
    
    /* svREFCNT_dec((SV *) pduinfo); */
#ifdef NOT_THIS
    {
        SV *vba;
        while(vba = av_pop(varbinds)) {
            av_undef((AV *) vba);
        }
    }
    av_undef(varbinds);
#endif    
    free(tmparray);

      if (v2pdu) {
              snmp_free_pdu(v2pdu);
      }

    FREETMPS;
    LEAVE;
    return result;
}

#line 327 "TrapReceiver.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 471 "TrapReceiver.c"

/* INCLUDE:  Including 'const-xs.inc' from 'TrapReceiver.xs' */


XS_EUPXS(XS_NetSNMP__TrapReceiver_constant); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__TrapReceiver_constant)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 4 "./const-xs.inc"
#ifdef dXSTARG
	dXSTARG; /* Faster if we have it.  */
#else
	dTARGET;
#endif
	STRLEN		len;
        int		type;
	IV		iv = 0; /* avoid uninit var warning */
	/* NV		nv;	Uncomment this if you need to return NVs */
	/* const char	*pv;	Uncomment this if you need to return PVs */
#line 496 "TrapReceiver.c"
	SV *	sv = ST(0)
;
	const char *	s = SvPV(sv, len);
#line 18 "./const-xs.inc"
        /* Change this to constant(aTHX_ s, len, &iv, &nv);
           if you need to return both NVs and IVs */
	type = constant(aTHX_ s, len, &iv);
      /* Return 1 or 2 items. First is error message, or undef if no error.
           Second, if present, is found value */
        switch (type) {
        case PERL_constant_NOTFOUND:
          sv =
	    sv_2mortal(newSVpvf("%s is not a valid NetSNMP::TrapReceiver macro", s));
          PUSHs(sv);
          break;
        case PERL_constant_NOTDEF:
          sv = sv_2mortal(newSVpvf(
	    "Your vendor has not defined NetSNMP::TrapReceiver macro %s, used",
				   s));
          PUSHs(sv);
          break;
        case PERL_constant_ISIV:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHi(iv);
          break;
	/* Uncomment this if you need to return NOs
        case PERL_constant_ISNO:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_no);
          break; */
	/* Uncomment this if you need to return NVs
        case PERL_constant_ISNV:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHn(nv);
          break; */
	/* Uncomment this if you need to return PVs
        case PERL_constant_ISPV:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, strlen(pv));
          break; */
	/* Uncomment this if you need to return PVNs
        case PERL_constant_ISPVN:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, iv);
          break; */
	/* Uncomment this if you need to return SVs
        case PERL_constant_ISSV:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHs(sv);
          break; */
	/* Uncomment this if you need to return UNDEFs
        case PERL_constant_ISUNDEF:
          break; */
	/* Uncomment this if you need to return UVs
        case PERL_constant_ISUV:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHu((UV)iv);
          break; */
	/* Uncomment this if you need to return YESs
        case PERL_constant_ISYES:
          EXTEND(SP, 2);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_yes);
          break; */
        default:
          sv = sv_2mortal(newSVpvf(
	    "Unexpected return type %d while processing NetSNMP::TrapReceiver macro %s, used",
               type, s));
          PUSHs(sv);
        }
#line 574 "TrapReceiver.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'TrapReceiver.xs' from 'const-xs.inc' */


XS_EUPXS(XS_NetSNMP__TrapReceiver_register); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_NetSNMP__TrapReceiver_register)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "regoid, perlcallback");
    {
	char *	regoid = (char *)SvPV_nolen(ST(0))
;
	SV *	perlcallback = ST(1)
;
#line 327 "TrapReceiver.xs"
	oid myoid[MAX_OID_LEN];
	size_t myoid_len = MAX_OID_LEN;
        trapd_cb_data *cb_data;
        netsnmp_trapd_handler *handler = NULL;
#line 600 "TrapReceiver.c"
	int	RETVAL;
	dXSTARG;
#line 332 "TrapReceiver.xs"
        {
            if (!regoid || !perlcallback) {
                RETVAL = 0;
                return;
            }
            if (strcmp(regoid,"all") == 0) {
                handler = 
                    netsnmp_add_global_traphandler(NETSNMPTRAPD_POST_HANDLER,
                                                   perl_trapd_handler);
            } else if (strcmp(regoid,"default") == 0) {
                handler = 
                    netsnmp_add_default_traphandler(perl_trapd_handler);
            } else if (!snmp_parse_oid(regoid, myoid, &myoid_len)) {
                snmp_log(LOG_ERR,
                         "Failed to parse oid for perl registration: %s\n",
                         regoid);
                RETVAL = 0;
                return;
            } else {
                handler = 
                    netsnmp_add_traphandler(perl_trapd_handler,
                                            myoid, myoid_len);
            }

            if (handler) {
                cb_data = malloc(sizeof(trapd_cb_data));
                cb_data->perl_cb = newSVsv(perlcallback);
                handler->handler_data = cb_data;
                handler->authtypes = (1 << VACM_VIEW_EXECUTE);
                RETVAL = 1;
            } else {
                RETVAL = 0;
            }
        }
#line 638 "TrapReceiver.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_NetSNMP__TrapReceiver); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_NetSNMP__TrapReceiver)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        (void)newXSproto_portable("NetSNMP::TrapReceiver::constant", XS_NetSNMP__TrapReceiver_constant, file, "$");
        (void)newXSproto_portable("NetSNMP::TrapReceiver::register", XS_NetSNMP__TrapReceiver_register, file, "$$");
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

