function [h,g,a,info] = wfilt_coif(K)
%-*- texinfo -*-
%@deftypefn {Function} wfilt_coif
%@verbatim
%WFILT_COIF Coiflets
%
%   Usage: [h,g,a] = wfilt_coif(K);
%
%   [h,g,a]=WFILT_COIF(K) with K in {1,2,3,4,5} returns a Coiflet
%   filters of order 2K the number of vanishing moments of both the
%   scaling and the wavelet functions.
%
%   Values are taken from table 8.1 from the reference. REMARK: There is 
%   a typo in 2nd element for K==1.
%
%   Examples:
%   ---------
%   :
%     wfiltinfo('coif2');
%
%   :
%     wfiltinfo('coif5');
% 
%   References:
%     I. Daubechies. Ten Lectures on Wavelets. Society for Industrial and
%     Applied Mathematics, Philadelphia, PA, USA, 1992.
%     
%@end verbatim
%@strong{Url}: @url{http://ltfat.github.io/doc/wavelets/wfilt_coif.html}
%@end deftypefn

% Copyright (C) 2005-2018 Peter L. Soendergaard <peter@sonderport.dk> and others.
% This file is part of LTFAT version 2.4.0
%
% This program is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with this program.  If not, see <http://www.gnu.org/licenses/>.

% AUTHOR: Zdenek Prusa

info.istight = 1;
a = [2;2];

switch(K)
    case 1
       hlp = [
             -5.142972847076845595317549230122688830344559947132656813651045e-02
              2.389297284707684559531754923012268883034455994713265681365104e-01
              6.028594569415369119063509846024537766068911989426531362730209e-01
              2.721405430584630880936490153975462233931088010573468637269790e-01
             -5.142972847076845595317549230122688830344559947132656813651045e-02
             -1.107027152923154404682450769877311169655440052867343186348954e-02
             ];
    case 2
       hlp = [
              1.158759673871686817889714882853120395708315073355502818875931e-02
             -2.932013798346856448679594524397843054053420947418409889774786e-02
             -4.763959031100813225872995081511549408622753909592460525840745e-02
              2.730210465347666137982239328923516270034828327990699588033501e-01
              5.746823938568638472459483149751499367740786490481481391460366e-01
              2.948671936956191896750637208703777973914107635455611537640778e-01
             -5.408560709171142997443672832006888537570221990444706777525838e-02
             -4.202648046077160694657530752545884878978719268926222513485613e-02
              1.674441016327950635146257083249391698866289538037299820224006e-02
              3.967883612962012109043447090269950094081810916481648252817197e-03
             -1.289203356140659543141355500990678257894936161704492503370186e-03
             -5.095053991076441489598480835620951586540050976664367876412655e-04
             ];
    case 3
       hlp = [
             -2.682418670922068664584689955153722375535836177157637134187840e-03
              5.503126707831385107969640263617469178794666057252906037981936e-03
              1.658356047917034608134280439996549525220639437145367606178002e-02
             -4.650776447872697640390293095170192691113917841041002855534619e-02
             -4.322076356021191118175840907244577856782537221435748296465882e-02
              2.865033352736474630249006862976158896891076238443844211133873e-01
              5.612852568703300445990941995240077241406247774064453800050914e-01
              3.029835717728241602862575774374668529867757043461413348549577e-01
             -5.077014075488886159516471867138370972545857441670871832472707e-02
             -5.819625076158553022607041679522801089624825903982541419721721e-02
              2.443409432116695639462954438418928805487699080947974989338820e-02
              1.122924096203786563399489540091488781245346096838814728167341e-02
             -6.369601011048822977293753932627342482077585617391852852955559e-03
             -1.820458915566242322836631665832145136570132777862391313328351e-03
              7.902051009575939937150950543290226440287715441826917281929124e-04
              3.296651737931830308416338897758022998655744276957481989605186e-04
             -5.019277455327664998007173088097694083956570594580641192332170e-05
             -2.446573425530813115445387662881902303945941576472342106918209e-05
             ];
    case 4
       hlp = [
              6.309612114309468490753696608619526520153127603444406835368201e-04
             -1.152225143769973488683007937016166047881572156705066038094891e-03
             -5.194525163470323267558201363327294331811309729430512113592118e-03
              1.136246148326482276463392678363118465908960082105224676102131e-02
              1.886723856956305960822813160712701905823879297781452350370094e-02
             -5.746424190192718517290527411385172124443396690932404284859269e-02
             -3.965265296244913762718094206756579981738035770770645437919302e-02
              2.936674050161006858761278962798582650835466243678172528509866e-01
              5.531264550395492870333469741987846570947502710783248169642137e-01
              3.071573096678856987248881030393884808414165269795297009902001e-01
             -4.711273752389572084912399351781012121935994396763702238263689e-02
             -6.803811467802056988332974920928626798429778679560269769187728e-02
              2.781363695846951303169163645831936314699164412528991864702607e-02
              1.773583142270308388403079552822372238681544967313003044695583e-02
             -1.075631615508724933047071603601897536695959225169888787867102e-02
             -4.001010844950535391911552472397083276670126595827549403173754e-03
              2.652664913530499860820143301690017184933302935238430721089152e-03
              8.955939276952843603555618778866181384528643960440369133096025e-04
             -4.165001950941708741516836418852536615951250588002878691463468e-04
             -1.838296167136253805617482342622910940008368723403836355183423e-04
              4.408022661597206973006038672236031501663774161685451815597956e-05
              2.208284691230832960893331999804142845136324572860276715790883e-05
             -2.304919162676504406778986897925054839632903355820414483306851e-06
             -1.262179179994622253884862172782890488140153502131112374520603e-06
             ];
    case 5
       hlp = [
             -1.499645228345950331670593167919531667975440598691604525531231e-04
              2.535527523580334712936363872191554706055603482812691726895588e-04
              1.540286725995222360335148244676269541414659303531250711822333e-03
             -2.941078164035693185044038586065593320891475311414770624555173e-03
             -7.164112349410053294382279572472252500899544810929605832362178e-03
              1.655218330649288840540841623080651353621667424921282557975513e-02
              1.991901719798432056056857854066125809443504706772520641876273e-02
             -6.499837825472324963374262221660858232544804226063450042795603e-02
             -3.680255347446873527191823500872992242220223547780834450868002e-02
              2.980959014587191795511466861338063554509597132272839414668911e-01
              5.475082713540367154128337935687830970431964302909253422329131e-01
              3.097002590784203529311533316221254677074498876376965941549923e-01
             -4.386731482823615640442730013366750193381707273908757638050452e-02
             -7.464442013283971243472663968192859562973186442054433655531762e-02
              2.919469277528073666095772398605275751022315529465178441510318e-02
              2.310457227706684192610065243663928370022983285246219996141160e-02
             -1.397129268638200558584119246355879336305763752871371182932059e-02
             -6.476749751505861835547590642967453082384538848552165075614441e-03
              4.781116799130657606400088024549264921093190305150784065791191e-03
              1.719383484385504023022397097446276782318002683055773803854075e-03
             -1.174947934413537690027670037110105795928147523549002426409332e-03
             -4.508222400696236312231932151038336110220594834213702970043431e-04
              2.134457975086291667348984871136041914777578046177470626552867e-04
              9.924691139873533169989496559631669037970741600337089424730635e-05
             -2.914684388622130824599478843558087403539428940986384077972155e-05
             -1.504031798197685905639227292876711236513927746903476131955063e-05
              2.616809660013118152124234488302931243021794024318439103773996e-06
              1.457502921355163070577152619048168436286350537937563166257584e-06
             -1.148199649902979726237655584441763456854312591680755421569962e-07
             -6.791060677322355511541065559242475254516249773485524025251102e-08
             ];
    case 6
       hlp = [
              3.590369176713147297619137585162985487882983106558813483919654e-05
             -5.739587600308579302553116112640931312834124316491419262693257e-05
             -4.416681189774217015420887950711066328841194295133755225305844e-04
              7.718952365964601416123598337617069164684563206275891099236221e-04
              2.502464949920583984721024494943552146200854870661622211002418e-03
             -4.970540926794084916072709193212250530229884674851059194676904e-03
             -8.649031599946572670088689962363342931064457587276457635862837e-03
              2.096272704497140779792663941456374769474253019820508756967019e-02
              2.035485665853858604541136567848434116598037957308057353920592e-02
             -7.047945564795552885905434147081164203757922879137146339823510e-02
             -3.448140611368923447131875491841937617457159299006945091335206e-02
              3.010998878403483951866118786441379902683440623823004392113350e-01
              5.433431541205752976643226361323847389491208513427704619816300e-01
              3.114106686884303879320332890564758567306967030720816157048784e-01
             -4.108920994584877203854246950993119698209208008049962179892675e-02
             -7.938037857340304740867638342147592451705918503253249849143539e-02
              2.959417996664270964779250587338231669479158250990737014414477e-02
              2.749324945396978289421721884832761949259069726774638450310483e-02
             -1.622820901345195945858655272139343256940218447777075044002063e-02
             -8.944948800734973559175903045029991278019908264185511730556261e-03
              6.781924902353432370456282863377674743820538634665380239602198e-03
              2.727776322637165251200756406544564359327985321401403409245472e-03
             -2.173603470504406274543289770274934991733554729244606459300157e-03
             -8.184301467772110627838702680469158860544118224504527036324346e-04
              5.443695006423825218320707989235387077885356717678678221237514e-04
              2.299669354496271337796680394777537358902688275513954507765924e-04
             -1.093025858275705388257100771765109469841731265349469854748449e-04
             -5.323102894235956524250869703703947941287269765076967124254140e-05
              1.749138884456354646795465632327170008020712055425505484223307e-05
              9.291277996211799255766657547295162218792966588358292566578482e-06
             -2.067852860108562040355056354764683583070734740977224663511355e-06
             -1.173528057754959701015486666538811237336231287996985858558749e-06
              1.595231380068613024221709499993144713297922814623646799204434e-07
              9.548236102970597211555688470325396069418862428946106509526618e-08
             -6.001316648399794543233636397364817876191104394511939069108879e-09
             -3.754092421718877429714314525761519021787631896344301745834088e-09
             ];
    case 7
       hlp = [
             -8.642436297638419945610948131417508321449359042880382837616795e-06
              1.323092600668737320653618189565188176193563004626002735569108e-05
              1.238159302411191700694316904823586790698547751438666389964909e-04
             -2.030827471878621660379666662315021490193874834607822591973651e-04
             -8.268301617880235510290843066205662542616488856061409195612586e-04
              1.489005690114437686460337716452079526238674405271430102926760e-03
              3.414934412450460679215304700817226231104673750197184931650456e-03
             -7.027860242269773782347401141338545341343547479199220829531083e-03
             -9.759879698174635975799287457121964575077621800626382384905922e-03
              2.468545489421116360102434627504896094772630565645374342185378e-02
              2.046157861402903980087467083352777920759194756736646791948754e-02
             -7.463948234553393791576174267216063661913646014250615692345955e-02
             -3.255052720695225444262327386510843067531614239181091226317606e-02
              3.032701839810768064176188260727440638632962820833222425246103e-01
              5.400990244606528900971955967395441757408783874674606654776292e-01
              3.126383971738483006163784309975347847899010543829381537178238e-01
             -3.871497424779051301839419764560067767205245057921330411662831e-02
             -8.293907947422769053048964127950429060647696494556080282464817e-02
              2.949014117259198370970425259971349135137714379653805589390139e-02
              3.110778126696628039496809790347026077516532785378620954115443e-02
             -1.778674610242698080195492177636195380628008680534327644027865e-02
             -1.127612352465961805417517163375322309389029593356595515710364e-02
              8.522290099960163136478259451975210336102817817562221392657719e-03
              3.840520687530513060929693850444023135936063807811968697808645e-03
             -3.265307484878191553686608663193259573061021023330761877609170e-03
             -1.273879229605184944648413513123685328329522201334094650099164e-03
              1.014515696091098223010746848382433126910091720031207326903328e-03
              4.097679895401914370060120309164154094898913488243766819496226e-04
             -2.609696573094586622328219462237882874111293043254082981395787e-04
             -1.186646887145157446962850804940522053646675640116219334763007e-04
              5.636383526557468584243108976415315613118268111676116113791335e-05
              2.858866828380331402146557751682881290895951013741692838961144e-05
             -1.006611544197303027244467426357681984010120261232862556289963e-05
             -5.495099010556417822017774697665452170235386110376505191968507e-06
              1.415682965517504934011008339473818198664994789606034408294717e-06
              8.188133233610314217903522752009348948778608588070621911086501e-07
             -1.463230575247395655425908281663831406004216665367756779712751e-07
             -8.874835827294529368648499409085591173735229589713890206258021e-08
              9.853606453775557692052504971290731996468795418172901924493247e-09
              6.220130833773100584817683046405291459615130548784852993590582e-09
             -3.237371065873786031415974713833345092654235228652968924822315e-10
             -2.114649662048637955296836248309680136665362492693075345297952e-10
             ];
    case 8
       hlp = [
              2.089031388199542217649735304633077946477575993553137874997499e-06
             -3.088829676466960594403785936495123295795735325141186563064826e-06
             -3.415065199420814308581377665735877442810613593316182887801764e-05
              5.336794978475752885866749586223668039582360880077534324830961e-05
              2.625452092146307108027768728326461036005400582791844219135485e-04
             -4.409238208772274245312366838988697089610792049225817119782188e-04
             -1.260955244697859087126122671343741939804055800993471565939717e-03
              2.334035748516809401796699851512493931521487402803856088184519e-03
              4.238998515964122916906367014472885263525332429616686168386780e-03
             -9.010216682788485374574179959374952745626145790175446525921665e-03
             -1.059137210972160452062877264732854070957273640727973500291258e-02
              2.784023497265315551670806338623371354680279388669611745037381e-02
              2.038491393825460625255433218588522954822776999829791972608492e-02
             -7.790193780817760648856650048481215968473342802126754335290911e-02
             -3.091398960464199635355286295557605183007519885588326376800431e-02
              3.049113846932028296232414935045248095543039057351616871735909e-01
              5.374812703269839615372906413514102630694929400948606989937313e-01
              3.135612340595966380418077448086007870950549040456326333016594e-01
             -3.667108316665038246204915903550010028035229188747930760164446e-02
             -8.570923901203457457230067054960180625904745972345544735005669e-02
              2.912276318941918093502808667205448538832711003842651923199100e-02
              3.411957880301561499047582538207723820508873324357307771206279e-02
             -1.884914078883376071043287013172570992844993887415459298291641e-02
             -1.342459526650064517082192966318056581890805569912583356614454e-02
              9.982558825082415904373108133470460186315362848702191453854950e-03
              4.996294194193990739772329108378853011245087219628720892888460e-03
             -4.353415716030435524873558659254500246467092155734985247834619e-03
             -1.798882274878169625580021134613003566863070625422298385086326e-03
              1.580842866685999532270584538283553531040029730619088591607990e-03
              6.341164354094166487421798386547881496331208497274921165613427e-04
             -4.859037288504776883185923185674204816335250660367189593401172e-04
             -2.105615022500261821665621601578029342187313061309595147668812e-04
              1.284762650553455535249206074613997094898698286922036784576671e-04
              6.190332439714985153834932259246488292329875513962818749340013e-05
             -2.932710247776567240870160300128192249260665410455632214571613e-05
             -1.541634258578732960762233596163970199686495285352470015267722e-05
              5.679130231196248852811714735791066544261806333156564637706958e-06
              3.179814253819903951090335509892218398493686680727385157906016e-06
             -9.018823843695175549580166675906964282301328192772638509290562e-07
             -5.313922705051620291263120753790527283196870682052587236468039e-07
              1.123841380424949688574412705744289982140965409566073018148117e-07
              6.910143395859795983361485345968765950977315740669289349714194e-08
             -1.028133863272738862101812736488937814136249072478179304322756e-08
             -6.555732343557023119114074649273108865362704549509543350446188e-09
              6.130612315575721972473587395696526436552798806104270539014282e-10
              4.033910072490666571003953018881489938766267669840899254802129e-10
             -1.785744077894230068079099924407862882873224386100989050429950e-11
             -1.207731024612356156550871498168833597517735826635815624658975e-11
             ];
    case 9
       hlp = [
             -5.066363823597422392806056574334164019913184490360944548316318e-07
              7.278391993125473027029583168671424388748658656372670262448419e-07
              9.304737272738569335426840667700605845237073216830127313873309e-06
             -1.399166643491873035927397151326087921115765448962913723958371e-05
             -8.091702401289310224621206748421921014290936300934460833068239e-05
              1.288948603756442891955388200793566964011433484841725529675464e-04
              4.429833292564910878782752821721584532350914860569614883397891e-04
             -7.604638375385009047720991576053046852032649468701121074994496e-04
             -1.712076406330546261864476465012314688415071394908910205115863e-03
              3.250609771558499559986242897495101339387218580957593472948506e-03
              4.965544559205420047336110923957506351279457718709199656899118e-03
             -1.087293322510375296786682178855708097994536728252120886318829e-02
             -1.121487186714498120022344911296954171366809171629939577546416e-02
              3.053409241514424830665032185876170313664500941851818086027391e-02
              2.020392698610770380447570514810463753302939216061746963067828e-02
             -8.052780090649459945830240285306098489931000767407230573519424e-02
             -2.950481547909572113527928936790826747949471856175409844500779e-02
              3.061961521402196297060170641420108731472017553153312985302650e-01
              5.353120232520133713115706737209774227378476257207779817606799e-01
              3.142791902169524902984239510600746503211251765067043225338625e-01
             -3.489491800009343033063601189229669581774254383120018514658627e-02
             -8.792560957387142697108395104950963599558244039650648988222216e-02
              2.861927542811334614253853950282153483993260752259557922334958e-02
              3.665967931975593019562623910949450882200844831012366323592970e-02
             -1.955945002554213167931774103463762372167104971118382178710488e-02
             -1.538279230927754406350075858557526842247910581873511998413085e-02
              1.118552122310349928798438523781104471338643824158961043502858e-02
              6.153778805250375760539535917130018322120240439861388830004320e-03
             -5.383941047406102653501165062580070636876629329655105558566173e-03
             -2.374234426766700376811893833905319565227030464607844605997432e-03
              2.201384480544939153490212385667343932208692420769790727070706e-03
              8.978070631742198872611262172632408686645841161925814232909679e-04
             -7.748091639808001244045755147010278445955718484470643940080615e-04
             -3.271988742130504187500457463514277973862371006416232573352337e-04
              2.382340816470993068532708118584131071285832153866665367058914e-04
              1.098939547757907591024137319089517624469653929668339354098746e-04
             -6.459841534412000641464605011582059745094736001136249665670393e-05
             -3.262384353548798509572707535297893969508001470867657290979350e-05
              1.539823757133791368834354345267796411124232848770592546980638e-05
              8.354049038925734685227308673812966075026848925201707946720101e-06
             -3.173574058801678589943416130953277710277471261605337088707621e-06
             -1.818949869332426905097083388417804018910760658657704860329107e-06
              5.517186750972799125927280958782447793255276643806997727626076e-07
              3.308966123618421063439933908570170555222439095610467058151640e-07
             -7.846530733490392810972396794430929632826504340137889923489193e-08
             -4.890737315241025544677728915264690823141541323355311455146920e-08
              8.750627874791451325430828577550291173132606932489491650978024e-09
              5.638473635810843029376963642806188780738425364694324846641801e-09
             -7.167429275081674956250392820907257304489315331347262926580420e-10
             -4.754207280832321963819557935464843642627576884386666887645887e-10
              3.830468826216721628160165172614737318957786647293037946018968e-11
              2.606522688312826422093936510197703125780060151935658173250167e-11
             -1.001456631869681899515352955030379117902110811720682559024841e-12
             -6.970967839322873084383232882845795920838117679540306239345441e-13
             ];
    case 10
       hlp = [
              1.232039860648044172279299405224082875252688628145893763395790e-07
             -1.727295600804314762711191670132331791341141012661151334481794e-07
             -2.511081517709769407961552319066117068245327429766666733928049e-06
              3.658544046042552874351627900962366978528997860123373895778793e-06
              2.436668276348995654567141715803151760606013118025710110377401e-05
             -3.722543982033220274394394471108112000512191070987312940916252e-05
             -1.497469279949762172542844959871018020917187701428092381975699e-04
              2.428593780445920993243261353647084659003272232610773863151794e-04
              6.540313182060373357098490399551418144208877502266803289923939e-04
             -1.146063191568871560182378726825944083414392177714466101235875e-03
             -2.159498802066973425125604747126061872540389369353813104148470e-03
              4.198356898750693446005403941056755251392636143022056890090725e-03
              5.598275450294209413911534747591226887261098750954757306041384e-03
             -1.260095805571421166223679712763560488266840720081803933722030e-02
             -1.168247265355164122837179014169010489974316491167398434017964e-02
              3.285412351493396730558710291243592888780292689130164184828513e-02
              1.996368405025267515773975348713442321055648689376329104127913e-02
             -8.268628841732119164746367518414478774806468603519900610269584e-02
             -2.827515877359611439071634624194631537427006948348240041241060e-02
              3.072295399526691328155262418641709088201200529352508961256835e-01
              5.334767884906935739862412544069281108017755758434730066259645e-01
              3.148528691610333337017175073118974445216093370484743945217914e-01
             -3.333673484145423901496513466029874130150784824285513273324710e-02
             -8.973828824876461620729131462736908322846203417126514244115363e-02
              2.804975877403786393498709022507676088711706121355859697479949e-02
              3.882650078944377967276663169043218713908993336081868910959595e-02
             -2.001823819093022389853947550669865247947997489243455484715571e-02
             -1.715959267288721579873571730849821259719260958329570391883719e-02
              1.216641740406415476398704875951061876471553491032831272757748e-02
              7.287002668222967317616933795891484580054714258414483676611073e-03
             -6.330873585683910945116572500327893678512281593087324528956428e-03
             -2.982656931766638403179439090660944850553111019029093184942893e-03
              2.842726797184870190904247769487845255184476983143715832751782e-03
              1.194989100375986838359310533134452087293580850721847113981799e-03
             -1.113592929026716220582486976294877082540073971334172516478939e-03
             -4.665959023435428623124863826904417915798780109069842899171733e-04
              3.854915448171689185378413676726041277985033697385268395398737e-04
              1.722736489049248280735630694200218710841097211364504157426810e-04
             -1.192039440276314665828270011182318354192262701354872993867613e-04
             -5.799804551608036312810594836126727444524814767625101691871260e-05
              3.303955116680311017462087431863046046226866796792060186027460e-05
              1.735375106985050789058251093166552848987592399630060085283037e-05
             -8.153689583347474492592925111165323709051679031024702923650800e-06
             -4.549758014112714450559595397423919633198378184124113284457878e-06
              1.765789027517910443710091424096930382691903616281733579514694e-06
              1.034104799224371158938634470768393243015388383126290286799001e-06
             -3.293437798170512614804826256037338836342628817269828495710584e-07
             -2.008825017273243555706624872035287742407494975566457013532182e-07
              5.172869892752758054467150354777867503503057315845912340980461e-08
              3.267471887025676044777185234904542674259187212800749921513620e-08
             -6.644210603985367626472026676249006537350458801953377329083388e-09
             -4.326722848192605397244652678298064482622875881609332553562911e-09
              6.694767246505386091091135023442214060965867621406459703646360e-10
              4.478193476940001390457010880530025539995676698350272513506529e-10
             -4.958883523601264332798684165341380344606385498242825617652400e-11
             -3.396977896617646756144544675014526730130390520604930211664642e-11
              2.399541927897950965447863495074910322552410081226759270966602e-12
              1.679108441896732974456456195021048198285552771033686283521003e-12
             -5.688326582012783070559328035350356616163807538811872116072541e-14
             -4.057351322008929507004790032757210978914475486123608161502457e-14
             ];
    case 11
       hlp = [
             -3.002841270578181341151286551992204393218350582050331595402947e-08
              4.122272295217427667266356780879156258114498741519631516920331e-08
              6.724990810124306151562398023851821394904913501570357570065506e-07
             -9.541360761072246280269422180608056185383175100955611359233360e-07
             -7.202532561401011173077639437360684947826378373817567768549254e-06
              1.063453162485789261522879856606560854907350313528134680849924e-05
              4.909272375475312318494348591512780526373439988508822238418822e-05
             -7.613184050961339338779773068101736230733664198546980476770618e-05
             -2.390784892821873979161511417107775995428809136314600188678204e-04
              3.943679383279311167583246559267867071442290440944189999981643e-04
              8.853493370435959653823385085809947651235906281219659248568656e-04
             -1.581686514051756535736270395427784669332587895176156014356356e-03
             -2.590742746810224935563114329456904019725483278674143464295211e-03
              5.149870818465970012295826228755714553228583889769273657074563e-03
              6.145845672897527026066671647152239861924038000733917998375367e-03
             -1.419393259281191647250120633508339618223543447429480888885451e-02
             -1.203207413449444640173778009728050814154121296076212013667261e-02
              3.486923068039100484429764121043168480751638068774959794674373e-02
              1.969083876878412756398286849757105734674338626918970666727437e-02
             -8.449176235282616008524865397153001199569198030863676330987291e-02
             -2.718999570426944985720147291173682797300682913513030026037261e-02
              3.080790765578655262603080397883700945436205022547475195838858e-01
              5.318981263183423043747894675482113686160804211740980090048888e-01
              3.153211471627422880186647707469009438784368258990685746892257e-01
             -3.195766007061928848761664009258043321006644364041143491101353e-02
             -9.124769812610534134560255473252823728312230005712995741316249e-02
              2.745384767698916118757918507086581985709771313695467894960792e-02
              4.069416828919323054368101934164054080633716017333800953161065e-02
             -2.029580028320762422710091483209306643651315777764043153811346e-02
             -1.877019961372162622019431440913198179510661354819964912645659e-02
              1.296101510005597271938818874849814161448679262503765364267420e-02
              8.380611488139723458203988762791929393262625838897962724368728e-03
             -7.184830591966413369120495146871921423473823635538498945128881e-03
             -3.609859908793898337842135309705990038242466823111355909651691e-03
              3.480855644490575075872348257576088455972056599653664736521251e-03
              1.519587122349825377958385405834371021723021014013798688930949e-03
             -1.487476950041717485556524898256248562236771186568035610613046e-03
             -6.266221323526552965740711288191177473318091288369663188353385e-04
              5.669194750141824007727306877180277155664136228075876060283768e-04
              2.483548169561553353815465009266736653140504966736322870003302e-04
             -1.947562130464613262021359493483333444690328898219310892360572e-04
             -9.182970970440133704016563635061723131880458403925476794220964e-05
              6.068684153958316426511545635539425250648039719186543457181453e-05
              3.088900022390199858477343797815906237906306891829977141838519e-05
             -1.713715146668224571508596341585374794778243270230714316209873e-05
             -9.308177549019247529116617185853630140339620355105237169582950e-06
              4.350944607244218897315593155029012286145084684860699651446177e-06
              2.489826198091695152209251895295085602387717821947484457226637e-06
             -9.810226131982706356161587985205307909654994261025367440308819e-07
             -5.860477917929613862778466907321520994203794368308376828863000e-07
              1.935841542281693216091905456706113598339749921662496254592563e-07
              1.199713894157469549665332933845486904444785619477457333399722e-07
             -3.286315290852867745345772422742964814900623793534583508718160e-08
             -2.102733655956564692974301994118024161699559390143901211493212e-08
              4.697313377266824850774441291113868308618121213665395500265262e-09
              3.091127346541495169376181275469205804231142302008934448079057e-09
             -5.492931291038498819123339772152269159856609319161416280911575e-10
             -3.705832674015332129353734352375876066802108394411578196121359e-10
              5.043003455436262175385618694799102815016439527671656113021805e-11
              3.478819684783597645372027295624442362976569795450758846730982e-11
             -3.407139658961008818238265022607619145960800136177153397899540e-12
             -2.397817050423233350570935216927526718398777501751418933159848e-12
              1.505627237721835119751916336971964703936303188134672123458877e-13
              1.078921592982513510792367677790040203074764526102391850430293e-13
             -3.263876236830110071269528317803593334490309684938793753165837e-15
             -2.377548488823423543125139291778920077224497814021891145988281e-15
             ];
    case 12
       hlp = [
              7.332768095940030936479170284005726526900547838823690875511772e-09
             -9.882788960094173321966534093367099204293628590516819427395258e-09
             -1.789770690933674811780047200109598433010386971973430500672055e-07
              2.482235718295242398333562594286195512316082783324858732252918e-07
              2.096862898770904613564680054212556937787154121601629543533841e-06
             -3.008997523302885197296541933722942006923516241629763269568385e-06
             -1.569727511606401439531655092040058072751445499110659438977086e-05
              2.347282446659006948884988502182500910534796840878776320306027e-05
              8.432620671960839513456175441990492843161437159914478159180496e-05
             -1.326465700910231806666155456982630828426491024439193157580022e-04
             -3.461069031961523260598540665989975463806418435597964924450827e-04
              5.801724592109383434087721189210231779950668973412340708531782e-04
              1.128329952931538448642997807830809340563912699376148776100497e-03
             -2.052978207989856468257756671236218003175082899217794093393105e-03
             -2.998854718805581165102352821152213608341151163107294684246684e-03
              6.087234661002692098937246236052456417362244403536977448648695e-03
              6.618258248500649305698119745808151708404790949797235636697129e-03
             -1.565844764466259880161945578291943699894979290174981301878469e-02
             -1.229143532595011743051583354556862863433008454113067034110364e-02
              3.663359030520896940491446552702346213307676159344592871561174e-02
              1.940158311172772932244832520273815443263367988550797208188773e-02
             -8.602421369693663560157681223178103065887873009243441444273671e-02
             -2.622309610147498279896640360042796723325043337619084753451538e-02
              3.087901191936800440665016928578559620370136549385877375418705e-01
              5.305215546028922252760737677862501004955798466743925981589890e-01
              3.157101125097144187884255713018906584467729236429617965600542e-01
             -3.072728270411850832025519617026920233823691270616686168610683e-02
             -9.252355517407954901591096183036942267909813631619741203079509e-02
              2.685426980489526041311526911968158600872135457665305597171601e-02
              4.231906584194910461336004572125137067789978502941750699346161e-02
             -2.044171277278771763990740324636394218858904394719947562326197e-02
             -2.023145788215137568397333973747514178822985181848891022548418e-02
              1.360136074289957261858358098198061002684141161420690992513613e-02
              9.426267566785124441978318969535742805562416304113067761168412e-03
             -7.945708281838580982329878679291156067815423974682242221896984e-03
             -4.244616137562462768873148640133872748101997290450405726506771e-03
              4.099701294107222470709340142349077619300436310693220618061200e-03
              1.865723923369076273507077887878603520484228647302554964863350e-03
             -1.883095146836284131126558963690882906898471660722337699052360e-03
             -8.050306441934266570411103136671969129999167330943811990532568e-04
              7.774244768363498320173652454360791629397769478205798411568457e-04
              3.372847962851042846971724663631080138529114657505401824166820e-04
             -2.913208318185371820345028586920081498099751816901944041981459e-04
             -1.340525559954698716569234001877227886256687091468901002407760e-04
              9.982127673611594435680485331533411291981760920599082733502195e-05
              4.937348728732130704294498684307923950522584256106944886949448e-05
             -3.135036716312241024722693180559594774556478340860978546951440e-05
             -1.658147773498940772484726369548058692747045913396859511266770e-05
              8.993369381780249884815177697768622600696214964193331328463550e-06
              5.029634518357754652723486937747064581822127275361432214835696e-06
             -2.337864167664466494570925080931611944904459384149351585277512e-06
             -1.368676631106717262348517888568825801321041470548296848624890e-06
              5.450688318062644286926839313049161286349015828217309026636711e-07
              3.316523922200394953147539061914190708715734274178414348860243e-07
             -1.126508114108817402586366374763002332801656314726353024056859e-07
             -7.087035083421007145362900821929976013240319835720189106840565e-08
              2.036136552214949970328712725606531020556011014972233106738542e-08
              1.319046726965912968164902682289037946241823978447803297147618e-08
             -3.166087228464481990319888550523695148079523238750557992010525e-09
             -2.104991149449598511738256933418413456831105806964526595267674e-09
              4.146945431639040971236501326093312709747378328969720686955287e-10
              2.821776098897944456514363403112985675647966425504805181915693e-10
             -4.446983453406239471384232757602885317329111550023751533862821e-11
             -3.089624808780293616300620576734718588630028421505260673719541e-11
              3.747462360879854551489729939613548244791307999347455031364712e-12
              2.653081274384644726529610503659130177381947905208003616541403e-12
             -2.326413554174593468421370682954805683688973923244290583476656e-13
             -1.675405289088832668656302656638525011959950143853262083260676e-13
              9.457233677790636292829124094363707169383163229929980763002159e-15
              6.917698090475727804437168736067302147625040054118083556555473e-15
             -1.888230812078774308964339134901795324778762733781901178118498e-16
             -1.401017335540698807093219863467094751924636611380629198255055e-16
             ];
    case 13
       hlp = [
             -1.793548393002850396214718676857202286659666424187461477734916e-09
              2.378211185014311786110879108757436954350720046766491611553072e-09
              4.738378239463632066007380653022285879027956504083662158044852e-08
             -6.443042549205366017018471056937057609502890297774359019447097e-08
             -6.027665210865901726655682284996751140817763415224888556619716e-07
              8.442063562432018658923481573987170154629168292318465207460091e-07
              4.916019713173742217516567081751095460187255617230097133575212e-06
             -7.131597545851986841244858233956149652674565400158665885083228e-06
             -2.887621717983862897214028125602451735414281976333647039362767e-05
              4.370659106170444884665034460659021177081728764017693131624860e-05
              1.301010589502334343162340998315752253281092458614582842230339e-04
             -2.074517436437432445981843921824038136707694799228389255014386e-04
             -4.675659350970496983228743630930465551287595323790670572391233e-04
              7.958726623965077575159821003474228536032266651825968350366428e-04
              1.376238684291389421260151294679793034786767219476646917508650e-03
             -2.547925839943045924066603828685111513038130582703762656864035e-03
             -3.380448382429659921946074764411430359936216225160144993981999e-03
              6.999176747558747594441502446219623982632259493449887383625331e-03
              7.025277873701559172377638256697086265819697238858476588169332e-03
             -1.700403721911182477272019360628329604078467241211115244215388e-02
             -1.248110041093927898560561468789729670710805348798639274049645e-02
              3.818992191138900815386778979798299217649095657811074673392633e-02
              1.910593122449920408487253901211150453954067290839567103918095e-02
             -8.734123305433746527793626123316474698117075663794485992246041e-02
             -2.535440772516182914289995632242460491764482405133781896194027e-02
              3.093942491825020619708297996329932122162946840728332042771585e-01
              5.293074910143676049377270336094486347453907972435992671221709e-01
              3.160379244009616024122892848920228469630372079810266391126280e-01
             -2.962163220306191371882270857478632946112548274231313092509283e-02
             -9.361576444399936039733984609999327008143196158286264947803189e-02
              2.626405247194866459650693584890446232517026215635389354877327e-02
              4.374461075475828517065334688194008307695911637366798984389094e-02
             -2.049134157245617651216272008653608168147661681048849172375451e-02
             -2.155975349513035485872319905355436164781967949252709342828195e-02
              1.411469715539851095863611028564527062867149436850684547048665e-02
              1.042015012705080744964255765999888273943255976544095301354753e-02
             -8.618241965220092705853657584595597150491673418403411002408392e-03
             -4.878411229018901327291501121500987653856731550945133361152065e-03
              4.689231319014487945639277139124902021493524893685817080310457e-03
              2.228006944652422042461995816835639158465376266146249271470082e-03
             -2.289300216009735975701956488620738834491684014507704186201093e-03
             -9.995141996257751415873914459680403989351818715310372734784204e-04
              1.011237075436018016549433779140494575127827962961245293854167e-03
              4.381342083712223181655422780539654899256457840343499415845070e-04
             -4.077800844935014982451276827385817092870017635124843071185474e-04
             -1.844040745436007917646038575655224990196066190810660605304526e-04
              1.512620828188999164176721097533404532449113024454664717717400e-04
              7.298889914269074881614764112188558106800789316340412477261329e-05
             -5.182922229726125421401881179344203187294861819954288822285889e-05
             -2.672839739746518397507211250706440905085295052637683361350922e-05
              1.639620996879063097510387977200493175731056979428359020893174e-05
              8.963666558523048764112718546851367368030517279319460108445549e-06
             -4.766464838000155192746436553819324857933144402808057358218020e-06
             -2.735466156072759824467664346873929524570661158335396527180534e-06
              1.263996241706422344627321843525682342021921638088785036829943e-06
              7.554924136965026151745000640360811330632516737592082697244460e-07
             -3.031372027194064857797292192738025195545051465615020648049694e-07
             -1.876153353569459383609680347900216851365226014600160596860682e-07
              6.512178154867684103162618794588474859582328666119453018835115e-08
              4.155335593309412282776259416691605536103007067016402041304343e-08
             -1.239596814755558143100692869308986827004606690663547726503092e-08
             -8.126161332398177051328184604237057975154642800593274318357692e-09
              2.063790114950702612059895249532033343340137201326403800942906e-09
              1.385901944573589656765876273409079665095347609123824623959651e-09
             -2.957224178853409095488876110988057035662351440629962056952036e-10
             -2.029311934113340193298299122766339237347606272015477168851847e-10
              3.571772829282367453820656456837216050596922160503361259637188e-11
              2.499410377682389724091314347623318996671569127462013112818877e-11
             -3.534890218851825710748828088218388133415831376956616696797412e-12
             -2.517884527624136958659745558559312992706644927689162729125510e-12
              2.751761925220381284379520354168022844435052022760463778480642e-13
              1.992032170370043447922955009924406643179442598661368210363579e-13
             -1.579660989452381199649841550208895174521301273998672860864606e-14
             -1.160591617584672995112625842000957667465588057411636690187883e-14
              5.944365969270122882900608066221185975352672745351687370149379e-16
              4.427175531427877551269875594300908130209116956704562714053338e-16
             -1.099853008896742180355036418837212161914020836623592509294684e-17
             -8.294635939298345162821665414627459859677158780165562383375210e-18
             ];
    case 14
       hlp = [
              4.393123283287643046743977676392679809833123671791969857529554e-10
             -5.740995333980705032482946798804467194492616738218164095035288e-10
             -1.248927009234748737577807595315202881486499763243765085950971e-08
              1.668938708534669081372944925855130859570883667030296283192275e-08
              1.714224718466457012729254240886670886351889068326223437908249e-07
             -2.350888489707823711598280869672645467891128086655653747378426e-07
             -1.512829449512444398231569819651340325454203862764615475827846e-06
              2.138843028494803759906484297432258680083063727505990520765838e-06
              9.645189410175859129875925155219070194081512175741287765540858e-06
             -1.413900766434184664705667161036292966126778120705989526301092e-05
             -4.732386374886606069931596084808261069441902397080602834581236e-05
              7.246665915416318653041426061722482786676878913517175624718883e-05
              1.858717516638060924675018895058421783537325657288962327083514e-04
             -3.002639346667087045056450058456524356780635529605230858304448e-04
             -6.001981648119978322839905692747076742955350870879313864711891e-04
              1.036704424281183769332139455241059670502046121189437350622494e-03
              1.624019729102622430009407806264396637075700567293622239292888e-03
             -3.056866654227471285910973139305702040302592610826831936007958e-03
             -3.734374338375411359548223317593068662165508326760318658468879e-03
              7.878974156362307531137246310651783340668870035859860685992973e-03
              7.375794892775370758210034597418329565084392014608514718594919e-03
             -1.824112316356241062692741179162085194558935295694349102012547e-02
             -1.261644961352131486551701382111180567640901225706461078977920e-02
              3.957213740580164637883912093052435411100033612855489943952285e-02
              1.881013375897047936537530404984248905528105177371268733601760e-02
             -8.848531745012440411869086432922856738256941097681738588710806e-02
             -2.456831883802970358635588048610460583666496666472048714250036e-02
              3.099141258514769597675719014297798938256245460277150903434604e-01
              5.282263993480420420172683726700426615634588134049161997619639e-01
              3.163176118910136471847844244749096048202155473691440639981631e-01
             -2.862162705070505721847062425772578719710517153178747344517326e-02
             -9.456098562568806415195259578154116428430268415200065101526812e-02
              2.569051606124748855707310139514692975138855764331441058027644e-02
              4.500466183802795354926526381495033532360504829689303112753676e-02
             -2.047021532120584933449635791950977974026461349249053431599797e-02
             -2.277014831481950414178652294664971699995306130850012029895679e-02
              1.452361964346076643465698934593935628651549016326324569145137e-02
              1.136128541937039082819287050631790459539185066230834792169280e-02
             -9.209420947381265408066732190659507079985769827890316211408732e-03
             -5.504969422021670816364481890406139436891358063842746391250159e-03
              5.243747074749862954985821475569406094355637198674133818712452e-03
              2.601674598427237622587421382305601947017094209097298433834035e-03
             -2.697275841549192002303803931030430917736443859609363181433549e-03
             -1.207776471356184889908600913725134183482141825908028112001291e-03
              1.262622737054852256202461193382270265994430106051249583099008e-03
              5.499311966045329956589364039445100979613421696316486920186038e-04
             -5.422272627380624698839955658312215512244309349484916450185708e-04
             -2.425184361340171436100075350681685661504913784969748899389596e-04
              2.152149496400025476355694208172147853936641059086477755698365e-04
              1.017555903218396117566574602158457196612571864784370737617320e-04
             -7.935125388684553688655161870002244461407761128159434896618062e-05
             -3.998277597219932662226493843559158394980004861650575475073792e-05
              2.721796546580936689236981518793293817082739932936290854597108e-05
              1.455457611510765292828084081835640403374221862390765492386559e-05
             -8.665251169633984802148726995857663363842070697439942022312573e-06
             -4.876002876304524386897822246961544519628259634511055566637692e-06
              2.547630497377554690874245620888763103208548188356120375663417e-06
              1.496291521165122830795751824395745883743697658779928306182602e-06
             -6.871963182955767930114979093149987762546939511820085867823395e-07
             -4.186054213338905216716743937485713975287167010801084873077525e-07
              1.688323085510447043387946782295494719025294305992339556134599e-07
              1.061608664532340347260400721455574451686604605297267706650340e-07
             -3.748126052504886126462262044258726754387739289902914735975186e-08
             -2.423790421295234792457591882318039900764790491363232906013318e-08
              7.451944128021296384873848910815562162615603046168848323657834e-09
              4.940829113027976152032509192714512864500880531926251999539656e-09
             -1.313004290651891746787587770064129324937346786322188934177725e-09
             -8.903006190166202390134120838864396696475015840820998020804486e-10
              2.024339408983577773846670331538285833569817328592031229378977e-10
              1.400716332649913272902011493738096845560270049348128272163217e-10
             -2.687843639588594104182180535839092397502172743578767496300069e-11
             -1.894326416951989057103502558801200560928286148276804817046860e-11
              3.010449065125004813763195657162392547592377042598795440577733e-12
              2.157549110009031291962129877779262524544188824969196959112637e-12
             -2.765131213310687469788780767616475716770096486689988092675382e-13
             -2.012365100006663638325338350119352463903184738855668161185981e-13
              1.999559651890099694974046277400337493312467655228527142562129e-14
              1.475855904098499257323658940826580143845487753742438097885182e-14
             -1.067284385873308952698526062594338734883390319779112369515680e-15
             -7.980454732861187078908378609623987154745352892645906516335706e-16
              3.737960558513592434172838302437103561627990707012528832920768e-17
              2.828736827706445597408742152789813333751511825684331285246309e-17
             -6.443221017103948534696419228196665121335677484790396728190832e-19
             -4.930480277882556230626331748820167974609092329853622801401922e-19
             ];
    case 15
       hlp = [
             -1.077388305690034925568519317607342584913833777614742512289616e-10
              1.389587596342677833974329883522061230029685955993897881938371e-10
              3.279393998194510988634872448273529681786105568152537128188232e-09
             -4.314917428064750425742001408005222171763816486950620059656063e-09
             -4.830480955281757774084367520164529040833872636548135345926328e-08
              6.503442589750190197880818956936279316947206899423481669747179e-08
              4.586202226530976939526210331832939590139698224375343383858299e-07
             -6.341483528169214053400193756836695190022413814118163945498651e-07
             -3.153995479916402549978249764513192992770609509053150015780527e-06
              4.499804120432346419024095680248633407936442025574963153980269e-06
              1.673949137596284707730217911852880032270066826000466620282769e-05
             -2.478673953689472562808496884430051456931244781632393118270780e-05
             -7.133403721727709318079068467834164023289442323885459167236538e-05
              1.104625554161070296128803495762953054143520115043831806016786e-04
              2.507269022498110858235302333943956572610456366436693548255909e-04
             -4.101297424840067893342949874400724512592760895309517943587399e-04
             -7.410047143677847135223722282750946641042780322618912256742384e-04
              1.298007949810447142342589176001928848518589813981439840532480e-03
              1.868002036616641522111287518387513439361411763383193116215989e-03
             -3.572228252449254403963990114096416980805538949675814075573840e-03
             -4.060845546989816000749383711188465103702344678606463573419343e-03
              8.722973601634679156834244798678586473379340842447624760010613e-03
              7.677632624610885216379589736677645849428563543670856456892832e-03
             -1.937998629272623327245351651340032378963145895629830248355253e-02
             -1.270912987080621205738379925710726654478701862241529402092432e-02
              4.080738066060462170763876758586958836909785300855426384151542e-02
              1.851809057592325149969383820293931082576986760496903450942510e-02
             -8.948849897626424781521688387105939501138967888885573845565360e-02
             -2.385247670399674430387895964623311594722573671400958395974253e-02
              3.103664257008206645231191613171869470278587854279025003466673e-01
              5.272557364814477983716848071901714167787737772153872785679251e-01
              3.165587650075045121866443592930838541058283366878004666876859e-01
             -2.771191753156204367193336798361266628380497625857187392479985e-02
             -9.538675074777090841664081647061476726485316724852952970342536e-02
              2.513756235583785139515577768765056710377747798734684870047976e-02
              4.612595054152007266785799039333521785448817048938105661049367e-02
             -2.039697130032260717744814776948275153234836586193746022325595e-02
             -2.387610261602642412532087773123245712932154519493636933580111e-02
              1.484665336652742504720315601481410278546028124094856659564326e-02
              1.225045078722903548958708772567092776061773279630721958212731e-02
             -9.727026988684677132100204448228164919286050721340500899358847e-03
             -6.119790408666201569472108881793143052368912545364690258267249e-03
              5.760546284765569349029577236247005441326471924211526110831333e-03
              2.982639689783411796793051935450475228274526754982054792962250e-03
             -3.100326747810698908670357861857946527442099277807566353764288e-03
             -1.427598950056448560388339550760364489836477975524209634886824e-03
              1.526288902864820487351136408213978592286541943096968601069530e-03
              6.716807141163574375155812673929624759515069203426478824767004e-04
             -6.923091961922026215168169239588952998971619503794813547976866e-04
             -3.079753690537485675760336348529151045406687032785607559287851e-04
              2.913765589242728312575501892839254155123375897451413662654452e-04
              1.355892883935182989877008830272296210763299728475431240359051e-04
             -1.144136457600174453829439526659056859019745676077854858593439e-04
             -5.647366526527395256230283878165734782055526539079541637152500e-05
              4.202814469137045804231920127700407277374824908280103138814183e-05
              2.200691925199183606470694553320593703444346894670462898724267e-05
             -1.443487126829503983751150823245149445739823542713233210642676e-05
             -7.967044068720793687142187645523516573594381036006224439668751e-06
              4.620529572512414091638085200280358471196525782083614164517925e-06
              2.667271171141226202145908685103109359180536100787642097511661e-06
             -1.371646007677255108283723404199936479217347063529498435611186e-06
             -8.226257775777933787075210506019317042435483731184419620540542e-07
              3.754707488446600189267042303254271529522879725934705336303128e-07
              2.327460534735607792375886758810039203536663498026314128685740e-07
             -9.419176207630012538547307468277369699399418776908683708933552e-08
             -6.010901363192621272223652431192551853015388169886067903126279e-08
              2.151040529867103646106333296464104096442766675831068812680466e-08
              1.408663721444152455727196509866657267275259238167897249854527e-08
             -4.438471764420978016551707826632529934591397495469950610230150e-09
             -2.974872318653716789002892729632634360902192191395110942422961e-09
              8.203736354629479986724051586473684219941281670765722417668819e-10
              5.614906982011763291961026759329761169245818883997411717426871e-10
             -1.344369082215606926514414754427875310059984578418456061162278e-10
             -9.377858898150921640144384471918102613403240839501295781875527e-11
              1.928845257086926701816336874687366534718638777936590534635229e-11
              1.369011182657074022662376575505428888871791726174235399548870e-11
             -2.384934840461770473688929159579828219691317417791483110727798e-12
             -1.719778967631011393923929779685944798509748321140853638527672e-12
              2.489379237039083598560573205355055108535626207998662168681925e-13
              1.821429711569697474507499816102915339752696477298299745504329e-13
             -2.132622020734041001406592439010728287329439597809749096351270e-14
             -1.581480392919139876757416822279485491215786823105416373080481e-14
              1.439584163156225165032712921349710482363055530913169445190637e-15
              1.080870877608085873106724565550332487149959687560803170944524e-15
             -7.178988398852581130761463819471838970960348029733518906208378e-17
             -5.452456075593213060858973182314766684639894698667113525487884e-17
              2.351146114661327422889598894161189162646924206890382575430334e-18
              1.804873032260938513483901979969512893697634895683128101624000e-18
             -3.793093840880643734719632714511071568608235299231836638122279e-20
             -2.940897685979289093951754752537580047693528343881245635936847e-20
             ];
    case 16
       hlp = [
              2.645128227931334401194749017856094903839224759604187535975348e-11
             -3.371203198492327805593180795398582247961552853458158404332701e-11
             -8.582602955015851169989985547605915833769704579350018283905453e-10
              1.113682743874024896922872631560006089322116513037553196433140e-09
              1.350357555669007302187662129540475982947984508250679168402207e-08
             -1.788542662216945768696335511240007863403120034978963421466759e-08
             -1.372399767643349435868829666738563944471884881660198607643932e-07
              1.861142798232072777457875152815716474831537306031011659394987e-07
              1.012632916853084889127303847166996705778109099232881893357767e-06
             -1.411391218929900871875409836854758822959995175269209988265964e-06
             -5.780354906513060544090253238716694637224354416047278875195167e-06
              8.319552925349192408642980463945086193729912325909182155797371e-06
              2.656172937335282438452193694808438866757101525885555802877363e-05
             -3.971488503705784806195172735954055483778562353132473949420383e-05
             -1.009502477694915360037551527344779468467449497309371492607906e-04
              1.580205984850860534574382720595384850826996029171338643269624e-04
              3.235585956460851636390368611428001979093146497993005344305241e-04
             -5.356766020478135601304959841352994036589791570941083598445719e-04
             -8.873556546319179065472262621811119401586608437112185894641021e-04
              1.575478281351532632439717118803866388929199851338529206979138e-03
              2.105606651204431619054524746734864557623457229083947484722320e-03
             -4.088191894353650561276869582147927639352373035186017974748492e-03
             -4.360872292782198728376270454745337063294048791901294558973734e-03
              9.529568586822569351636224042126142702339784399550130407812201e-03
              7.937554616751835390855349461479084645184690272876975812761538e-03
             -2.043028062273575036423529610008583445387419918322244014076844e-02
             -1.276805798943377800134681508900535312774995954006995157514628e-02
              4.191756976239118832120686348770409281363202997039966458608067e-02
              1.823220381522837114361006424809362329414770645451392462449888e-02
             -9.037537219708957768297195651417043288020180323453952191219619e-02
             -2.319696593669936172505243393626168348704758643822052626742965e-02
              3.107636928082792940641010571409269845541349652957861643505019e-01
              5.263779607858160898968654079428530858936436413545697317378081e-01
              3.167685981610576430160454114053628826549777499820093838585069e-01
             -2.688002764399130975457186260346246083982252335484396969696049e-02
             -9.611413622779535731607299381683923415585409438866982806312433e-02
              2.460702264184366170433044783596672126378075093050623290409127e-02
              4.712982774514209557951414612253477983062538454664569371378627e-02
             -2.028535796367687397692592233666898932654122251735124185611584e-02
             -2.488947090480479804467455088466028171550905433401327138474797e-02
              1.509891466100476055081827485608676509355525843509560496666700e-02
              1.308946215944044192535019406077351673456069366724670016932535e-02
             -1.017883680802027111277390598900318783317279547588070199634251e-02
             -6.719748071003458935775571012030544444136724430402220957162335e-03
              6.238935489467385921022852560870393671940489207452244538094472e-03
              3.367468902298941859370206452925695206983662336670801038560071e-03
             -3.493551700182803646132263836442232208288107750606295145197587e-03
             -1.656892742742846792662641923332649254682158396970453428791079e-03
              1.797580707568879158693851162651173871535491718081800368907782e-03
              8.023813584888036977682855962559617079147220211451113235479547e-04
             -8.554898439358329127957776138969823280630767426284649193621767e-04
             -3.803250541195305567062453832052319106641157897723285573667716e-04
              3.790575215750319491406179627066855114144121793545714885424013e-04
              1.743405946247572050905785206176608832450147638063148826743472e-04
             -1.572439781316405883265776380849622489840291930399907686729106e-04
             -7.624948592584476281257978178990423864516589094309239278548039e-05
              6.128060596774506984228013865022369414316454857306786928520834e-05
              3.146741963266068084535293135528229727240575644439933447074425e-05
             -2.245327295507508821937104934719536410602401822650676684612963e-05
             -1.216243182507186686293172059854826389902098520645342122978134e-05
              7.720917364617828003652627867578175616946793895014715674935806e-06
              4.381753178661449645296516382515863584261691809111376008934184e-06
             -2.482767124382555232483399147672417058164552715497813674691440e-06
             -1.466343698163771614780524818641106403735083198445173705132776e-06
              7.432014174835368770981871416234950435655553162638884480980583e-07
              4.542989331759269644535718413196051785388101460827659003970839e-07
             -2.060699879933986058206760300398806699720723820737944360367781e-07
             -1.298170865048347187816076578378402307087125075336611133383038e-07
              5.264581641375993977610164728920521257086259803613235153366270e-08
              3.406393391619068289195417747073909213446800676676765817676367e-08
             -1.232185691522856953729451450757280208371851915642712294292861e-08
             -8.166093443152050070015881861916421702970930717440939870025784e-09
              2.625409011502555900921203294713520941212542142978903897341494e-09
              1.777971486566651937150629742259638331676290922471013840418127e-09
             -5.055670327267217324394512474432436609546961385665820073629149e-10
             -3.491603047784209234885018449563067499142505674739795662842523e-10
              8.724442027269310202793317644100398216549268990858642429012803e-11
              6.134056646089015827615754897419277972739575045939973674430929e-11
             -1.335550933533140093069772884082926341856038121300357216420744e-11
             -9.545001301055681232254913151946668780573427381542116387716243e-12
              1.791132091052570705585609717173338686203233385162086497884597e-12
              1.299479612944140546458425080979636378248568664374156541007765e-12
             -2.071542478174027600308270770710599707024301130761618879837078e-13
             -1.523876419589572596433135600175398293765409391592690642809664e-13
              2.024011564013098795384504309899456379953546444981404140928647e-14
              1.508090533430543564179721448102668377867975040540446828012097e-14
             -1.624316869855319846554453444493486257563508484962017834581348e-15
             -1.224719779181149805165600696876308523367619824015832031858679e-15
              1.027939569018525333323110570745538777072560620646729968488678e-16
              7.836461641294003176782800892601140107677607857155479918585838e-17
             -4.809623970748619654544928861639842603928203458148585584400867e-18
             -3.704428468500691125388142845245956973807333959654959653370468e-18
              1.479077310414365270465857340835402997778146774718460154867300e-19
              1.150168591577669048697174066699145993471476194503387272230234e-19
             -2.242407694525583556140058750006128491924916204038852290292985e-21
             -1.759447752651847364048938898264828071373418617420955762135442e-21
             ];
    case 17
       hlp = [
             -6.500464389707599365209386548586351053892021378458138653304423e-12
              8.195092532207287031929315133511822259455558174314608981943899e-12
              2.239711179183031212893330219097909418305437894719629936823048e-10
             -2.869947756536888954496920486027606890198732779175975385193469e-10
             -3.748652869247186892176371615982066497362408141014325378716294e-09
              4.892949218890121214706505923918329440794016605904313473814529e-09
              4.060535996907768482760233032378242455655290824022613838518523e-08
             -5.412800273268200651966255945372126329232373624996043338727765e-08
             -3.199646878369895994575449942065193991181771279589753273012370e-07
              4.369727725871308893880916467851990680716049438182815833632030e-07
              1.954675426993304663744299195821942913722501797065421760283585e-06
             -2.745513146733188764932399232387671708256227137296795085887882e-06
             -9.634412972188383779747780077033215938910939748761965263335434e-06
              1.398510128440620079969365258470536422184684456048432702271769e-05
              3.936982972446342694180294131275967364969863087882012583523302e-05
             -5.942171285371293607280496067664382735077180061970981330506268e-05
             -1.360187671549120330733322490500505609713066081377747046659631e-04
              2.151477677680517385918241110555023784071910115637214853600854e-04
              4.031846985142799308758422861627631567915210555326501592195629e-04
             -6.753056524717059857256997400254135291064617085196739372670596e-04
             -1.037019038482154436516186769361377053347840390147975287354903e-03
              1.865278399043969526599364729851177613810456808562792176901007e-03
              2.335092479166843852619505691860960037151295448017402395490464e-03
             -4.600362410545124310128593731153519957157915045164845600048444e-03
             -4.635901516367530468266774633995064938864595165304482662269926e-03
              1.029849878093488912016135237127927932437021681117450333050470e-02
              8.161354844742695166287867590528306934013230497272094086439853e-03
             -2.140083454707180990471957764441619892415141666259178396074188e-02
             -1.280013066407215003063560801494039614508212222821778081264683e-02
              4.292055861596262214973257156936151304056714777314126061614130e-02
              1.795390690266262592020002418739607395852481356276768335967618e-02
             -9.116513012907441746922273129338011409075492893988681588200024e-02
             -2.259372514218996220695158554614204610976204851195489170219594e-02
              3.111155431954246180810318298644662465180042749292370227009409e-01
              5.255791920096491971882691260862499824764740619924123678110320e-01
              3.169526419329032746356987532605638232939637480462148442295005e-01
             -2.611571666365402171510563042119336240297149649416458785911946e-02
             -9.675954853667507935197631998670465823029201914294383672129969e-02
              2.409947009460623399471523812196780471148876929014194101062573e-02
              4.803353218498044015416060073004473385881416575908077296603559e-02
             -2.014561229992014297122142514992242081365435497050595479226927e-02
             -2.582061660161950684110954569039206647948969052599286532681994e-02
              1.529272640253308240084109219531756056459883643674183337274434e-02
              1.388071397467832912373059115868453151221079623138136285750566e-02
             -1.057221105345110246802817506341466648095287774314054180322389e-02
             -7.302762653438232901227689142950547329538140829539078289487808e-03
              6.679525479155670944534388145244600799904556867195771509687913e-03
              3.753327910175261617061638983698597354605196849112621375976962e-03
             -3.873502044238494209221075063035775273773018743760471430473527e-03
             -1.893732606269440797293869629956889668362203362383552157238979e-03
              2.072543024867895178559272835210161485056077281253166510139696e-03
              9.410418747008923962829724903349867736584130840706583199324136e-04
             -1.029236208596613388068225340603899734435060101885503041426292e-03
             -4.591014336769466560134513688989777037625141817691452272446129e-04
              4.773008760819621131157362935521176506345390013016953367673484e-04
              2.178204082961996755621953357319268908714183698410765755733914e-04
             -2.078309675413889310430737904787028903664009273165646558840663e-04
             -9.929997042562200063281249722482587882228792457135570086630464e-05
              8.530214005775875557344845401830936434184861259249422544962929e-05
              4.303127018338600126871147843984523103940762542407178890295340e-05
             -3.305701987257830145946843240723975476098534205446659095902282e-05
             -1.758829650866963971776918784161632040379719078606077372721020e-05
              1.208769577843697327040603409274814451217826643812352568992268e-05
              6.746467675120962867147670937319739759733836479700116679771234e-06
             -4.160355187316342019270990597595419877216228873682832991804769e-06
             -2.420254904648915254014955740890841226083885744291947005091657e-06
              1.342994249603250343064678689811024077753583828488987218045940e-06
              8.097294554089061667504430331210249043842934823174097650144144e-07
             -4.049444940788524829884048775715404594466969342774847971126013e-07
             -2.518965167469206882003809454171378587968607051431751373150446e-07
              1.135553617795151208855033374367694728763504841965654332076720e-07
              7.261651917558697862566637161896385928154192436065001744633099e-08
             -2.947980283978599533805321526934370923141985995773718687989809e-08
             -1.932361910368835906234029388933678481624943182582035193495632e-08
              7.050321193690929766855893625237523724477327743751448148520006e-09
              4.725540898626838453733797773219853119997567959454100093653807e-09
             -1.544890271654104814899353348226128082357337920194464818206503e-09
             -1.056616142600432792887732860128652200494175165768667682069691e-09
              3.082594659999300699574359679210901640096775130739951087627160e-10
              2.147504833829198392113195006888709994262573995228896673552773e-10
             -5.561286894620042086964943668161558452409502342704415471486767e-11
             -3.940143496183440249847057247704879900653366187527397859030185e-11
              8.995643580413385770110048797179920790859544777777746910312038e-12
              6.472787221353141291937900214024339897450801045313739690950453e-12
             -1.291529680835762905157565016413333440330657604408304192114484e-12
             -9.426669651972276882689445158605509492502686267040217113580068e-13
              1.625527264466347733962941488626801955710436180523082414371005e-13
              1.202192377372031845627082725619201334357843245869818759928528e-13
             -1.765518459644471564018808330096255160185888800253188548281582e-14
             -1.321779015475951542862804164493083633990380882447565336832597e-14
              1.621075287427611093636143991429535087675201571842337901672180e-15
              1.227498087932053340876125326218310922521150243946862677354389e-15
             -1.223432402366205698930334886661193082730379267225732134795174e-16
             -9.362464931639200345906241184043712676525956780242932081695469e-17
              7.286307451400376946525901096753718888478670661483802452725131e-18
              5.631244920089436674573794405513798919334447045845529038034991e-18
             -3.210669220728058803342344742726907080377349121830123276313938e-19
             -2.504389307995414770751414118526232971373346964470499339128194e-19
              9.305380936099856808127703965979897197171695480831630403884988e-21
              7.321457794081650002123376485818067154029026613875178979778160e-21
             -1.330546671429478643380151195298922795778536160301584472334406e-22
             -1.055408614665356789775787814731337905514088897800715301399902e-22
             ];
  otherwise
        error('%s: No such COIFLET filters.',upper(mfilename)); 

end
d = [-4*K+1, -2*K-1];

hlp = hlp*sqrt(2);

harr = [flipud(hlp),(-1).^(0:size(hlp, 1)-1).'.*hlp];

h=mat2cell(harr,size(harr,1),ones(1,size(harr,2)));
h=cellfun(@(hEl,dEl) struct('h',hEl(:),'offset',dEl),h,num2cell(d),...
          'UniformOutput',0);

g = h;




