/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFEComponentTransferElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEComponentTransferElement.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFEComponentTransferElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEComponentTransferElementIn1), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEComponentTransferElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEComponentTransferElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEComponentTransferElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEComponentTransferElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEComponentTransferElementResult), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEComponentTransferElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEComponentTransferElementStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEComponentTransferElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEComponentTransferElementTable = { 34, 31, JSSVGFEComponentTransferElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFEComponentTransferElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEComponentTransferElementConstructorTable = { 1, 0, JSSVGFEComponentTransferElementConstructorTableValues, 0 };
const ClassInfo JSSVGFEComponentTransferElementConstructor::s_info = { "SVGFEComponentTransferElementConstructor", &Base::s_info, &JSSVGFEComponentTransferElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFEComponentTransferElementConstructor) };

JSSVGFEComponentTransferElementConstructor::JSSVGFEComponentTransferElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEComponentTransferElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFEComponentTransferElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFEComponentTransferElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEComponentTransferElementConstructor, JSDOMWrapper>(exec, &JSSVGFEComponentTransferElementConstructorTable, jsCast<JSSVGFEComponentTransferElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFEComponentTransferElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEComponentTransferElementConstructor, JSDOMWrapper>(exec, &JSSVGFEComponentTransferElementConstructorTable, jsCast<JSSVGFEComponentTransferElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEComponentTransferElementPrototypeTableValues[] =
{
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGFEComponentTransferElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEComponentTransferElementPrototypeTable = { 2, 1, JSSVGFEComponentTransferElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEComponentTransferElementPrototype::s_info = { "SVGFEComponentTransferElementPrototype", &Base::s_info, &JSSVGFEComponentTransferElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFEComponentTransferElementPrototype) };

JSObject* JSSVGFEComponentTransferElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEComponentTransferElement>(exec, globalObject);
}

bool JSSVGFEComponentTransferElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEComponentTransferElementPrototype* thisObject = jsCast<JSSVGFEComponentTransferElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFEComponentTransferElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGFEComponentTransferElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEComponentTransferElementPrototype* thisObject = jsCast<JSSVGFEComponentTransferElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGFEComponentTransferElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGFEComponentTransferElement::s_info = { "SVGFEComponentTransferElement", &Base::s_info, &JSSVGFEComponentTransferElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFEComponentTransferElement) };

JSSVGFEComponentTransferElement::JSSVGFEComponentTransferElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEComponentTransferElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGFEComponentTransferElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEComponentTransferElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEComponentTransferElementPrototype::create(exec->globalData(), globalObject, JSSVGFEComponentTransferElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEComponentTransferElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEComponentTransferElement* thisObject = jsCast<JSSVGFEComponentTransferElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFEComponentTransferElement, Base>(exec, &JSSVGFEComponentTransferElementTable, thisObject, propertyName, slot);
}

bool JSSVGFEComponentTransferElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEComponentTransferElement* thisObject = jsCast<JSSVGFEComponentTransferElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFEComponentTransferElement, Base>(exec, &JSSVGFEComponentTransferElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFEComponentTransferElementIn1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEComponentTransferElement* castedThis = jsCast<JSSVGFEComponentTransferElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEComponentTransferElement* impl = static_cast<SVGFEComponentTransferElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEComponentTransferElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEComponentTransferElement* castedThis = jsCast<JSSVGFEComponentTransferElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEComponentTransferElement* impl = static_cast<SVGFEComponentTransferElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEComponentTransferElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEComponentTransferElement* castedThis = jsCast<JSSVGFEComponentTransferElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEComponentTransferElement* impl = static_cast<SVGFEComponentTransferElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEComponentTransferElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEComponentTransferElement* castedThis = jsCast<JSSVGFEComponentTransferElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEComponentTransferElement* impl = static_cast<SVGFEComponentTransferElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEComponentTransferElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEComponentTransferElement* castedThis = jsCast<JSSVGFEComponentTransferElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEComponentTransferElement* impl = static_cast<SVGFEComponentTransferElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEComponentTransferElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEComponentTransferElement* castedThis = jsCast<JSSVGFEComponentTransferElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEComponentTransferElement* impl = static_cast<SVGFEComponentTransferElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEComponentTransferElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEComponentTransferElement* castedThis = jsCast<JSSVGFEComponentTransferElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEComponentTransferElement* impl = static_cast<SVGFEComponentTransferElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEComponentTransferElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEComponentTransferElement* castedThis = jsCast<JSSVGFEComponentTransferElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEComponentTransferElement* impl = static_cast<SVGFEComponentTransferElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGFEComponentTransferElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEComponentTransferElement* domObject = jsCast<JSSVGFEComponentTransferElement*>(asObject(slotBase));
    return JSSVGFEComponentTransferElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEComponentTransferElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEComponentTransferElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGFEComponentTransferElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGFEComponentTransferElement::s_info))
        return throwVMTypeError(exec);
    JSSVGFEComponentTransferElement* castedThis = jsCast<JSSVGFEComponentTransferElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGFEComponentTransferElement::s_info);
    SVGFEComponentTransferElement* impl = static_cast<SVGFEComponentTransferElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
