/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLDocument.h"

#include "Element.h"
#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "HTMLDocument.h"
#include "JSDOMBinding.h"
#include "JSElement.h"
#include "JSHTMLCollection.h"
#include "KURL.h"
#include "wtf/text/AtomicString.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLDocumentTableValues[] =
{
    { "embeds", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentEmbeds), (intptr_t)0, NoIntrinsic },
    { "plugins", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentPlugins), (intptr_t)0, NoIntrinsic },
    { "scripts", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentScripts), (intptr_t)0, NoIntrinsic },
    { "all", 0, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentAll), (intptr_t)setJSHTMLDocumentAll, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentHeight), (intptr_t)0, NoIntrinsic },
    { "dir", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentDir), (intptr_t)setJSHTMLDocumentDir, NoIntrinsic },
    { "designMode", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentDesignMode), (intptr_t)setJSHTMLDocumentDesignMode, NoIntrinsic },
    { "compatMode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentCompatMode), (intptr_t)0, NoIntrinsic },
    { "activeElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentActiveElement), (intptr_t)0, NoIntrinsic },
    { "bgColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentBgColor), (intptr_t)setJSHTMLDocumentBgColor, NoIntrinsic },
    { "fgColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentFgColor), (intptr_t)setJSHTMLDocumentFgColor, NoIntrinsic },
    { "alinkColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentAlinkColor), (intptr_t)setJSHTMLDocumentAlinkColor, NoIntrinsic },
    { "linkColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentLinkColor), (intptr_t)setJSHTMLDocumentLinkColor, NoIntrinsic },
    { "vlinkColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentVlinkColor), (intptr_t)setJSHTMLDocumentVlinkColor, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLDocumentConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDocumentTable = { 36, 31, JSHTMLDocumentTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLDocumentConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDocumentConstructorTable = { 1, 0, JSHTMLDocumentConstructorTableValues, 0 };
const ClassInfo JSHTMLDocumentConstructor::s_info = { "HTMLDocumentConstructor", &Base::s_info, &JSHTMLDocumentConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLDocumentConstructor) };

JSHTMLDocumentConstructor::JSHTMLDocumentConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLDocumentConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLDocumentPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLDocumentConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLDocumentConstructor, JSDOMWrapper>(exec, &JSHTMLDocumentConstructorTable, jsCast<JSHTMLDocumentConstructor*>(cell), propertyName, slot);
}

bool JSHTMLDocumentConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLDocumentConstructor, JSDOMWrapper>(exec, &JSHTMLDocumentConstructorTable, jsCast<JSHTMLDocumentConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLDocumentPrototypeTableValues[] =
{
    { "open", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionOpen), (intptr_t)0, NoIntrinsic },
    { "close", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionClose), (intptr_t)0, NoIntrinsic },
    { "write", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionWrite), (intptr_t)1, NoIntrinsic },
    { "writeln", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionWriteln), (intptr_t)1, NoIntrinsic },
    { "clear", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionClear), (intptr_t)0, NoIntrinsic },
    { "captureEvents", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionCaptureEvents), (intptr_t)0, NoIntrinsic },
    { "releaseEvents", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionReleaseEvents), (intptr_t)0, NoIntrinsic },
    { "hasFocus", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLDocumentPrototypeFunctionHasFocus), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLDocumentPrototypeTable = { 17, 15, JSHTMLDocumentPrototypeTableValues, 0 };
const ClassInfo JSHTMLDocumentPrototype::s_info = { "HTMLDocumentPrototype", &Base::s_info, &JSHTMLDocumentPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLDocumentPrototype) };

JSObject* JSHTMLDocumentPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLDocument>(exec, globalObject);
}

bool JSHTMLDocumentPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLDocumentPrototype* thisObject = jsCast<JSHTMLDocumentPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLDocumentPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLDocumentPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLDocumentPrototype* thisObject = jsCast<JSHTMLDocumentPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLDocumentPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLDocument::s_info = { "HTMLDocument", &Base::s_info, &JSHTMLDocumentTable, 0 , CREATE_METHOD_TABLE(JSHTMLDocument) };

JSHTMLDocument::JSHTMLDocument(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLDocument> impl)
    : JSDocument(structure, globalObject, impl)
{
}

void JSHTMLDocument::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLDocument::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLDocumentPrototype::create(exec->globalData(), globalObject, JSHTMLDocumentPrototype::createStructure(exec->globalData(), globalObject, JSDocumentPrototype::self(exec, globalObject)));
}

bool JSHTMLDocument::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLDocument* thisObject = jsCast<JSHTMLDocument*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (canGetItemsForName(exec, static_cast<HTMLDocument*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLDocument, Base>(exec, &JSHTMLDocumentTable, thisObject, propertyName, slot);
}

bool JSHTMLDocument::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLDocument* thisObject = jsCast<JSHTMLDocument*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (canGetItemsForName(exec, static_cast<HTMLDocument*>(thisObject->impl()), propertyName)) {
        PropertySlot slot;
        slot.setCustom(thisObject, nameGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), ReadOnly | DontDelete | DontEnum);
        return true;
    }
    return getStaticValueDescriptor<JSHTMLDocument, Base>(exec, &JSHTMLDocumentTable, thisObject, propertyName, descriptor);
}

bool JSHTMLDocument::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSHTMLDocument* thisObject = jsCast<JSHTMLDocument*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    PropertyName propertyName = Identifier::from(exec, index);
    if (canGetItemsForName(exec, static_cast<HTMLDocument*>(thisObject->impl()), propertyName)) {
        slot.setCustom(thisObject, thisObject->nameGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsHTMLDocumentEmbeds(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->embeds()));
    return result;
}


JSValue jsHTMLDocumentPlugins(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->plugins()));
    return result;
}


JSValue jsHTMLDocumentScripts(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->scripts()));
    return result;
}


JSValue jsHTMLDocumentAll(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    return castedThis->all(exec);
}


JSValue jsHTMLDocumentWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = jsNumber(impl->width());
    return result;
}


JSValue jsHTMLDocumentHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = jsNumber(impl->height());
    return result;
}


JSValue jsHTMLDocumentDir(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->dir());
    return result;
}


JSValue jsHTMLDocumentDesignMode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->designMode());
    return result;
}


JSValue jsHTMLDocumentCompatMode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->compatMode());
    return result;
}


JSValue jsHTMLDocumentActiveElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->activeElement()));
    return result;
}


JSValue jsHTMLDocumentBgColor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->bgColor());
    return result;
}


JSValue jsHTMLDocumentFgColor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fgColor());
    return result;
}


JSValue jsHTMLDocumentAlinkColor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->alinkColor());
    return result;
}


JSValue jsHTMLDocumentLinkColor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->linkColor());
    return result;
}


JSValue jsHTMLDocumentVlinkColor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->vlinkColor());
    return result;
}


JSValue jsHTMLDocumentConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLDocument* domObject = jsCast<JSHTMLDocument*>(asObject(slotBase));
    return JSHTMLDocument::getConstructor(exec, domObject->globalObject());
}

void JSHTMLDocument::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLDocument* thisObject = jsCast<JSHTMLDocument*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLDocument, Base>(exec, propertyName, value, &JSHTMLDocumentTable, thisObject, slot);
}

void setJSHTMLDocumentAll(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSHTMLDocument*>(thisObject)->setAll(exec, value);
}


void setJSHTMLDocumentDir(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(thisObject);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    impl->setDir(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLDocumentDesignMode(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(thisObject);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    impl->setDesignMode(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLDocumentBgColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(thisObject);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    impl->setBgColor(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLDocumentFgColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(thisObject);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    impl->setFgColor(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLDocumentAlinkColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(thisObject);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    impl->setAlinkColor(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLDocumentLinkColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(thisObject);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    impl->setLinkColor(valueToStringWithNullCheck(exec, value));
}


void setJSHTMLDocumentVlinkColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(thisObject);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    impl->setVlinkColor(valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLDocument::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLDocumentConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionOpen(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLDocument::s_info))
        return throwVMTypeError(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLDocument::s_info);
    return JSValue::encode(castedThis->open(exec));
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionClose(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLDocument::s_info))
        return throwVMTypeError(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLDocument::s_info);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    impl->close();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionWrite(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLDocument::s_info))
        return throwVMTypeError(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLDocument::s_info);
    return JSValue::encode(castedThis->write(exec));
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionWriteln(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLDocument::s_info))
        return throwVMTypeError(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLDocument::s_info);
    return JSValue::encode(castedThis->writeln(exec));
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionClear(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLDocument::s_info))
        return throwVMTypeError(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLDocument::s_info);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    impl->clear();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionCaptureEvents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLDocument::s_info))
        return throwVMTypeError(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLDocument::s_info);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    impl->captureEvents();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionReleaseEvents(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLDocument::s_info))
        return throwVMTypeError(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLDocument::s_info);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());
    impl->releaseEvents();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLDocumentPrototypeFunctionHasFocus(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLDocument::s_info))
        return throwVMTypeError(exec);
    JSHTMLDocument* castedThis = jsCast<JSHTMLDocument*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLDocument::s_info);
    HTMLDocument* impl = static_cast<HTMLDocument*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->hasFocus());
    return JSValue::encode(result);
}


}
