/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLKeygenElement.h"

#include "ExceptionCode.h"
#include "HTMLFormElement.h"
#include "HTMLKeygenElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "NodeList.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLKeygenElementTableValues[] =
{
    { "autofocus", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementAutofocus), (intptr_t)setJSHTMLKeygenElementAutofocus, NoIntrinsic },
    { "challenge", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementChallenge), (intptr_t)setJSHTMLKeygenElementChallenge, NoIntrinsic },
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementDisabled), (intptr_t)setJSHTMLKeygenElementDisabled, NoIntrinsic },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementForm), (intptr_t)0, NoIntrinsic },
    { "keytype", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementKeytype), (intptr_t)setJSHTMLKeygenElementKeytype, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementName), (intptr_t)setJSHTMLKeygenElementName, NoIntrinsic },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementType), (intptr_t)0, NoIntrinsic },
    { "willValidate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementWillValidate), (intptr_t)0, NoIntrinsic },
    { "validity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementValidity), (intptr_t)0, NoIntrinsic },
    { "validationMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementValidationMessage), (intptr_t)0, NoIntrinsic },
    { "labels", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementLabels), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLKeygenElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLKeygenElementTable = { 34, 31, JSHTMLKeygenElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLKeygenElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLKeygenElementConstructorTable = { 1, 0, JSHTMLKeygenElementConstructorTableValues, 0 };
const ClassInfo JSHTMLKeygenElementConstructor::s_info = { "HTMLKeygenElementConstructor", &Base::s_info, &JSHTMLKeygenElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLKeygenElementConstructor) };

JSHTMLKeygenElementConstructor::JSHTMLKeygenElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLKeygenElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLKeygenElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLKeygenElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLKeygenElementConstructor, JSDOMWrapper>(exec, &JSHTMLKeygenElementConstructorTable, jsCast<JSHTMLKeygenElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLKeygenElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLKeygenElementConstructor, JSDOMWrapper>(exec, &JSHTMLKeygenElementConstructorTable, jsCast<JSHTMLKeygenElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLKeygenElementPrototypeTableValues[] =
{
    { "checkValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLKeygenElementPrototypeFunctionCheckValidity), (intptr_t)0, NoIntrinsic },
    { "setCustomValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLKeygenElementPrototypeFunctionSetCustomValidity), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLKeygenElementPrototypeTable = { 4, 3, JSHTMLKeygenElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLKeygenElementPrototype::s_info = { "HTMLKeygenElementPrototype", &Base::s_info, &JSHTMLKeygenElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLKeygenElementPrototype) };

JSObject* JSHTMLKeygenElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLKeygenElement>(exec, globalObject);
}

bool JSHTMLKeygenElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLKeygenElementPrototype* thisObject = jsCast<JSHTMLKeygenElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLKeygenElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLKeygenElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLKeygenElementPrototype* thisObject = jsCast<JSHTMLKeygenElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLKeygenElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLKeygenElement::s_info = { "HTMLKeygenElement", &Base::s_info, &JSHTMLKeygenElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLKeygenElement) };

JSHTMLKeygenElement::JSHTMLKeygenElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLKeygenElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLKeygenElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLKeygenElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLKeygenElementPrototype::create(exec->globalData(), globalObject, JSHTMLKeygenElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLKeygenElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLKeygenElement* thisObject = jsCast<JSHTMLKeygenElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLKeygenElement, Base>(exec, &JSHTMLKeygenElementTable, thisObject, propertyName, slot);
}

bool JSHTMLKeygenElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLKeygenElement* thisObject = jsCast<JSHTMLKeygenElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLKeygenElement, Base>(exec, &JSHTMLKeygenElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLKeygenElementAutofocus(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::autofocusAttr));
    return result;
}


JSValue jsHTMLKeygenElementChallenge(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::challengeAttr));
    return result;
}


JSValue jsHTMLKeygenElementDisabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::disabledAttr));
    return result;
}


JSValue jsHTMLKeygenElementForm(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->form()));
    return result;
}


JSValue jsHTMLKeygenElementKeytype(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::keytypeAttr));
    return result;
}


JSValue jsHTMLKeygenElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::nameAttr));
    return result;
}


JSValue jsHTMLKeygenElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsHTMLKeygenElementWillValidate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->willValidate());
    return result;
}


JSValue jsHTMLKeygenElementValidity(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->validity()));
    return result;
}


JSValue jsHTMLKeygenElementValidationMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->validationMessage());
    return result;
}


JSValue jsHTMLKeygenElementLabels(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->labels()));
    return result;
}


JSValue jsHTMLKeygenElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLKeygenElement* domObject = jsCast<JSHTMLKeygenElement*>(asObject(slotBase));
    return JSHTMLKeygenElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLKeygenElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLKeygenElement* thisObject = jsCast<JSHTMLKeygenElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLKeygenElement, Base>(exec, propertyName, value, &JSHTMLKeygenElementTable, thisObject, slot);
}

void setJSHTMLKeygenElementAutofocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(thisObject);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value.toBoolean(exec));
}


void setJSHTMLKeygenElementChallenge(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(thisObject);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::challengeAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLKeygenElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(thisObject);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value.toBoolean(exec));
}


void setJSHTMLKeygenElementKeytype(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(thisObject);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::keytypeAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLKeygenElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(thisObject);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLKeygenElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLKeygenElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLKeygenElementPrototypeFunctionCheckValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLKeygenElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLKeygenElement::s_info);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLKeygenElementPrototypeFunctionSetCustomValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLKeygenElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLKeygenElement* castedThis = jsCast<JSHTMLKeygenElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLKeygenElement::s_info);
    HTMLKeygenElement* impl = static_cast<HTMLKeygenElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& error(valueToStringWithUndefinedOrNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}


}
