/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFEOffsetElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedNumber.h"
#include "JSSVGAnimatedString.h"
#include "SVGFEOffsetElement.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFEOffsetElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementIn1), (intptr_t)0, NoIntrinsic },
    { "dx", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementDx), (intptr_t)0, NoIntrinsic },
    { "dy", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementDy), (intptr_t)0, NoIntrinsic },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementHeight), (intptr_t)0, NoIntrinsic },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementResult), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEOffsetElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEOffsetElementTable = { 35, 31, JSSVGFEOffsetElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFEOffsetElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEOffsetElementConstructorTable = { 1, 0, JSSVGFEOffsetElementConstructorTableValues, 0 };
const ClassInfo JSSVGFEOffsetElementConstructor::s_info = { "SVGFEOffsetElementConstructor", &Base::s_info, &JSSVGFEOffsetElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFEOffsetElementConstructor) };

JSSVGFEOffsetElementConstructor::JSSVGFEOffsetElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEOffsetElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFEOffsetElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFEOffsetElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEOffsetElementConstructor, JSDOMWrapper>(exec, &JSSVGFEOffsetElementConstructorTable, jsCast<JSSVGFEOffsetElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFEOffsetElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEOffsetElementConstructor, JSDOMWrapper>(exec, &JSSVGFEOffsetElementConstructorTable, jsCast<JSSVGFEOffsetElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEOffsetElementPrototypeTableValues[] =
{
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGFEOffsetElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEOffsetElementPrototypeTable = { 2, 1, JSSVGFEOffsetElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEOffsetElementPrototype::s_info = { "SVGFEOffsetElementPrototype", &Base::s_info, &JSSVGFEOffsetElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFEOffsetElementPrototype) };

JSObject* JSSVGFEOffsetElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEOffsetElement>(exec, globalObject);
}

bool JSSVGFEOffsetElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEOffsetElementPrototype* thisObject = jsCast<JSSVGFEOffsetElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFEOffsetElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGFEOffsetElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEOffsetElementPrototype* thisObject = jsCast<JSSVGFEOffsetElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGFEOffsetElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGFEOffsetElement::s_info = { "SVGFEOffsetElement", &Base::s_info, &JSSVGFEOffsetElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFEOffsetElement) };

JSSVGFEOffsetElement::JSSVGFEOffsetElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEOffsetElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGFEOffsetElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEOffsetElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEOffsetElementPrototype::create(exec->globalData(), globalObject, JSSVGFEOffsetElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEOffsetElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEOffsetElement* thisObject = jsCast<JSSVGFEOffsetElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFEOffsetElement, Base>(exec, &JSSVGFEOffsetElementTable, thisObject, propertyName, slot);
}

bool JSSVGFEOffsetElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEOffsetElement* thisObject = jsCast<JSSVGFEOffsetElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFEOffsetElement, Base>(exec, &JSSVGFEOffsetElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFEOffsetElementIn1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEOffsetElement* castedThis = jsCast<JSSVGFEOffsetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEOffsetElement* impl = static_cast<SVGFEOffsetElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEOffsetElementDx(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEOffsetElement* castedThis = jsCast<JSSVGFEOffsetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEOffsetElement* impl = static_cast<SVGFEOffsetElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->dxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEOffsetElementDy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEOffsetElement* castedThis = jsCast<JSSVGFEOffsetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEOffsetElement* impl = static_cast<SVGFEOffsetElement*>(castedThis->impl());
    RefPtr<SVGAnimatedNumber> obj = impl->dyAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEOffsetElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEOffsetElement* castedThis = jsCast<JSSVGFEOffsetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEOffsetElement* impl = static_cast<SVGFEOffsetElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEOffsetElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEOffsetElement* castedThis = jsCast<JSSVGFEOffsetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEOffsetElement* impl = static_cast<SVGFEOffsetElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEOffsetElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEOffsetElement* castedThis = jsCast<JSSVGFEOffsetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEOffsetElement* impl = static_cast<SVGFEOffsetElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEOffsetElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEOffsetElement* castedThis = jsCast<JSSVGFEOffsetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEOffsetElement* impl = static_cast<SVGFEOffsetElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEOffsetElementResult(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEOffsetElement* castedThis = jsCast<JSSVGFEOffsetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEOffsetElement* impl = static_cast<SVGFEOffsetElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEOffsetElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEOffsetElement* castedThis = jsCast<JSSVGFEOffsetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEOffsetElement* impl = static_cast<SVGFEOffsetElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEOffsetElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEOffsetElement* castedThis = jsCast<JSSVGFEOffsetElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEOffsetElement* impl = static_cast<SVGFEOffsetElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGFEOffsetElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEOffsetElement* domObject = jsCast<JSSVGFEOffsetElement*>(asObject(slotBase));
    return JSSVGFEOffsetElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEOffsetElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEOffsetElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGFEOffsetElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGFEOffsetElement::s_info))
        return throwVMTypeError(exec);
    JSSVGFEOffsetElement* castedThis = jsCast<JSSVGFEOffsetElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGFEOffsetElement::s_info);
    SVGFEOffsetElement* impl = static_cast<SVGFEOffsetElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
