/* valagidlparser.c generated by valac, the Vala compiler
 * generated from valagidlparser.vala, do not modify */

/* valagidlparser.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <gidlmodule.h>
#include <gidlparser.h>
#include <gidlnode.h>
#include <float.h>
#include <math.h>
#include <gmetadata.h>
#include <stdio.h>


#define VALA_TYPE_GIDL_PARSER (vala_gidl_parser_get_type ())
#define VALA_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParser))
#define VALA_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))
#define VALA_IS_GIDL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GIDL_PARSER))
#define VALA_IS_GIDL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GIDL_PARSER))
#define VALA_GIDL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GIDL_PARSER, ValaGIdlParserClass))

typedef struct _ValaGIdlParser ValaGIdlParser;
typedef struct _ValaGIdlParserClass ValaGIdlParserClass;
typedef struct _ValaGIdlParserPrivate ValaGIdlParserPrivate;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_idl_module_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_idl_module_free0_ (var), NULL)))
#define __g_list_free__vala_code_node_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__vala_code_node_unref0_ (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define __g_slist_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_free0_ (var), NULL)))

struct _ValaGIdlParser {
	ValaCodeVisitor parent_instance;
	ValaGIdlParserPrivate * priv;
};

struct _ValaGIdlParserClass {
	ValaCodeVisitorClass parent_class;
};

struct _ValaGIdlParserPrivate {
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaSourceReference* current_source_reference;
	ValaNamespace* current_namespace;
	ValaTypeSymbol* current_data_type;
	ValaMap* codenode_attributes_map;
	ValaMap* codenode_attributes_patterns;
	ValaSet* current_type_symbol_set;
	ValaMap* cname_type_map;
};


static gpointer vala_gidl_parser_parent_class = NULL;
static GRegex* vala_gidl_parser_type_from_string_regex;
static GRegex* vala_gidl_parser_type_from_string_regex = NULL;

GType vala_gidl_parser_get_type (void) G_GNUC_CONST;
#define VALA_GIDL_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIDL_PARSER, ValaGIdlParserPrivate))
enum  {
	VALA_GIDL_PARSER_DUMMY_PROPERTY
};
void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context);
static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns);
static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl);
static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t);
static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st);
static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface);
static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en);
static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed);
static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d);
static gchar* vala_gidl_parser_get_cname (ValaGIdlParser* self, ValaSymbol* sym, ValaSymbol* container);
static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file);
static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file);
static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module);
static void _g_idl_module_free0_ (gpointer var);
static void _g_list_free__g_idl_module_free0_ (GList* self);
static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const gchar* type_name, ValaSymbol* container);
static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const gchar* codenode, int* result_length1);
static gchar* vala_gidl_parser_eval (ValaGIdlParser* self, const gchar* s);
gchar* vala_gidl_parser_get_cprefix (ValaGIdlParser* self, ValaSymbol* sym);
static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const gchar* const_name, ValaSymbol* container);
static gchar* vala_gidl_parser_get_lower_case_cprefix (ValaGIdlParser* self, ValaSymbol* sym);
static gchar* vala_gidl_parser_get_cheader_filename (ValaGIdlParser* self, ValaSymbol* sym);
static gchar* vala_gidl_parser_get_finish_cname (ValaGIdlParser* self, ValaMethod* m);
static gchar* vala_gidl_parser_get_lower_case_cname (ValaGIdlParser* self, ValaSymbol* sym);
static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self, GIdlNode* node, int* result_length1);
static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self, ValaSymbol* container, ValaSymbol* sym);
static void vala_gidl_parser_parse_node (ValaGIdlParser* self, GIdlNode* node, GIdlModule* module, ValaSymbol* container);
static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node);
static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaSymbol* container, GIdlModule* module, gboolean is_flags);
static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module);
static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module);
static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node);
static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface);
static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self, const gchar* name);
static void _vala_code_node_unref0_ (gpointer var);
static void _g_list_free__vala_code_node_unref0_ (GList* self);
static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction);
static ValaDataType* vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self, const gchar* type_string, gboolean owned_by_default, ValaSourceReference* source_reference);
static gboolean vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self, ValaDataType* parent_type, const gchar* type_arguments, ValaSourceReference* source_reference);
static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param);
static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction);
static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const gchar* cname);
static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const gchar* n);
static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node);
static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface);
static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node);
static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node);
static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol);
static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const gchar* type_name);
static ValaUnresolvedSymbol* vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self, const gchar* symbol_string, ValaSourceReference* source_reference);
static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const gchar* name, const gchar* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface);
static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const gchar* name);
static void _g_free0_ (gpointer var);
static void _g_slist_free__g_free0_ (GSList* self);
ValaGIdlParser* vala_gidl_parser_new (void);
ValaGIdlParser* vala_gidl_parser_construct (GType object_type);
static void vala_gidl_parser_finalize (ValaCodeVisitor* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Parse all source files in the specified code context and build a
 * code tree.
 *
 * @param context a code context
 */
static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


void vala_gidl_parser_parse (ValaGIdlParser* self, ValaCodeContext* context) {
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GEqualFunc _tmp2_ = NULL;
	ValaHashMap* _tmp3_ = NULL;
	ValaCodeContext* _tmp4_ = NULL;
	ValaCodeContext* _tmp5_ = NULL;
	ValaCodeContext* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = (ValaMap*) _tmp3_;
	_tmp4_ = context;
	_tmp5_ = _vala_code_context_ref0 (_tmp4_);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp5_;
	_tmp6_ = context;
	vala_code_context_accept (_tmp6_, (ValaCodeVisitor*) self);
	_vala_map_unref0 (self->priv->cname_type_map);
	self->priv->cname_type_map = NULL;
}


static void vala_gidl_parser_real_visit_namespace (ValaCodeVisitor* base, ValaNamespace* ns) {
	ValaGIdlParser * self;
	ValaNamespace* _tmp0_ = NULL;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ns != NULL);
	_tmp0_ = ns;
	vala_code_node_accept_children ((ValaCodeNode*) _tmp0_, (ValaCodeVisitor*) self);
}


static void vala_gidl_parser_real_visit_class (ValaCodeVisitor* base, ValaClass* cl) {
	ValaGIdlParser * self;
	ValaClass* _tmp0_ = NULL;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = cl;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_real_visit_struct (ValaCodeVisitor* base, ValaStruct* st) {
	ValaGIdlParser * self;
	ValaStruct* _tmp0_ = NULL;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = st;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_real_visit_interface (ValaCodeVisitor* base, ValaInterface* iface) {
	ValaGIdlParser * self;
	ValaInterface* _tmp0_ = NULL;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (iface != NULL);
	_tmp0_ = iface;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_real_visit_enum (ValaCodeVisitor* base, ValaEnum* en) {
	ValaGIdlParser * self;
	ValaEnum* _tmp0_ = NULL;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = en;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_real_visit_error_domain (ValaCodeVisitor* base, ValaErrorDomain* ed) {
	ValaGIdlParser * self;
	ValaErrorDomain* _tmp0_ = NULL;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (ed != NULL);
	_tmp0_ = ed;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_real_visit_delegate (ValaCodeVisitor* base, ValaDelegate* d) {
	ValaGIdlParser * self;
	ValaDelegate* _tmp0_ = NULL;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = d;
	vala_gidl_parser_visit_type (self, (ValaTypeSymbol*) _tmp0_);
}


static void vala_gidl_parser_visit_type (ValaGIdlParser* self, ValaTypeSymbol* t) {
	ValaMap* _tmp0_ = NULL;
	ValaTypeSymbol* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (t != NULL);
	_tmp0_ = self->priv->cname_type_map;
	_tmp1_ = t;
	_tmp2_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_map_contains (_tmp0_, _tmp3_);
	_tmp5_ = !_tmp4_;
	_g_free0 (_tmp3_);
	if (_tmp5_) {
		ValaMap* _tmp6_ = NULL;
		ValaTypeSymbol* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		ValaTypeSymbol* _tmp10_ = NULL;
		_tmp6_ = self->priv->cname_type_map;
		_tmp7_ = t;
		_tmp8_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = t;
		vala_map_set (_tmp6_, _tmp9_, _tmp10_);
		_g_free0 (_tmp9_);
	}
}


static void vala_gidl_parser_real_visit_source_file (ValaCodeVisitor* base, ValaSourceFile* source_file) {
	ValaGIdlParser * self;
	ValaSourceFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	self = (ValaGIdlParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = source_file;
	_tmp1_ = vala_source_file_get_filename (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_str_has_suffix (_tmp2_, ".gi");
	if (_tmp3_) {
		ValaSourceFile* _tmp4_ = NULL;
		_tmp4_ = source_file;
		vala_gidl_parser_parse_file (self, _tmp4_);
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		_tmp3_ = offset;
		_tmp4_ = len;
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
		string_length = _tmp5_;
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		_tmp6_ = strlen (self);
		_tmp7_ = _tmp6_;
		string_length = (glong) _tmp7_;
	}
	_tmp8_ = offset;
	if (_tmp8_ < ((glong) 0)) {
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp9_ = string_length;
		_tmp10_ = offset;
		offset = _tmp9_ + _tmp10_;
		_tmp11_ = offset;
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
		_tmp12_ = offset;
		_tmp13_ = string_length;
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
	}
	_tmp14_ = len;
	if (_tmp14_ < ((glong) 0)) {
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
		_tmp15_ = string_length;
		_tmp16_ = offset;
		len = _tmp15_ - _tmp16_;
	}
	_tmp17_ = offset;
	_tmp18_ = len;
	_tmp19_ = string_length;
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
	_tmp20_ = offset;
	_tmp21_ = len;
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
	result = _tmp22_;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gint string_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strchr (((gchar*) self) + _tmp0_, (gssize) -1, _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void _g_idl_module_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_idl_module_free (var), NULL));
}


static void _g_list_free__g_idl_module_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_idl_module_free0_, NULL);
	g_list_free (self);
}


static void vala_gidl_parser_parse_file (ValaGIdlParser* self, ValaSourceFile* source_file) {
	gchar* metadata_filename = NULL;
	ValaSourceFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	ValaSourceFile* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	ValaSourceFile* _tmp14_ = NULL;
	ValaSourceFile* _tmp15_ = NULL;
	GHashFunc _tmp16_ = NULL;
	GEqualFunc _tmp17_ = NULL;
	GEqualFunc _tmp18_ = NULL;
	ValaHashMap* _tmp19_ = NULL;
	GHashFunc _tmp20_ = NULL;
	GEqualFunc _tmp21_ = NULL;
	ValaHashMap* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = source_file;
	_tmp1_ = vala_source_file_get_filename (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = source_file;
	_tmp4_ = vala_source_file_get_filename (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = strlen (".gi");
	_tmp9_ = _tmp8_;
	_tmp10_ = string_substring (_tmp2_, (glong) 0, (glong) (_tmp7_ - _tmp9_));
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("%s.metadata", _tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	metadata_filename = _tmp13_;
	_tmp14_ = source_file;
	_tmp15_ = _vala_source_file_ref0 (_tmp14_);
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp15_;
	_tmp16_ = g_str_hash;
	_tmp17_ = g_str_equal;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp16_, _tmp17_, _tmp18_);
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	self->priv->codenode_attributes_map = (ValaMap*) _tmp19_;
	_tmp20_ = g_direct_hash;
	_tmp21_ = g_direct_equal;
	_tmp22_ = vala_hash_map_new (G_TYPE_POINTER, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp20_, (GEqualFunc) g_pattern_spec_equal, _tmp21_);
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	self->priv->codenode_attributes_patterns = (ValaMap*) _tmp22_;
	_tmp23_ = metadata_filename;
	_tmp24_ = g_file_test (_tmp23_, G_FILE_TEST_EXISTS);
	if (_tmp24_) {
		{
			gchar* metadata = NULL;
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
			gchar** _tmp28_ = NULL;
			gchar** _tmp29_ = NULL;
			_tmp25_ = metadata_filename;
			g_file_get_contents (_tmp25_, &_tmp26_, NULL, &_inner_error_);
			_g_free0 (metadata);
			metadata = _tmp26_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_free0 (metadata);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch0_g_file_error;
				}
				_g_free0 (metadata);
				_g_free0 (metadata_filename);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp27_ = metadata;
			_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, "\n", 0);
			{
				gchar** line_collection = NULL;
				gint line_collection_length1 = 0;
				gint _line_collection_size_ = 0;
				gint line_it = 0;
				line_collection = _tmp29_;
				line_collection_length1 = _vala_array_length (_tmp28_);
				for (line_it = 0; line_it < _vala_array_length (_tmp28_); line_it = line_it + 1) {
					gchar* _tmp30_ = NULL;
					gchar* line = NULL;
					_tmp30_ = g_strdup (line_collection[line_it]);
					line = _tmp30_;
					{
						const gchar* _tmp31_ = NULL;
						gboolean _tmp32_ = FALSE;
						gchar** tokens = NULL;
						const gchar* _tmp33_ = NULL;
						gchar** _tmp34_ = NULL;
						gchar** _tmp35_ = NULL;
						gint tokens_length1 = 0;
						gint _tokens_size_ = 0;
						gchar** _tmp36_ = NULL;
						gint _tmp36__length1 = 0;
						const gchar* _tmp37_ = NULL;
						gchar** _tmp38_ = NULL;
						gint _tmp38__length1 = 0;
						const gchar* _tmp39_ = NULL;
						gint _tmp40_ = 0;
						ValaMap* _tmp48_ = NULL;
						gchar** _tmp49_ = NULL;
						gint _tmp49__length1 = 0;
						const gchar* _tmp50_ = NULL;
						gchar** _tmp51_ = NULL;
						gint _tmp51__length1 = 0;
						const gchar* _tmp52_ = NULL;
						_tmp31_ = line;
						_tmp32_ = g_str_has_prefix (_tmp31_, "#");
						if (_tmp32_) {
							_g_free0 (line);
							continue;
						}
						_tmp33_ = line;
						_tmp35_ = _tmp34_ = g_strsplit (_tmp33_, " ", 2);
						tokens = _tmp35_;
						tokens_length1 = _vala_array_length (_tmp34_);
						_tokens_size_ = tokens_length1;
						_tmp36_ = tokens;
						_tmp36__length1 = tokens_length1;
						_tmp37_ = _tmp36_[0];
						if (NULL == _tmp37_) {
							tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (line);
							continue;
						}
						_tmp38_ = tokens;
						_tmp38__length1 = tokens_length1;
						_tmp39_ = _tmp38_[0];
						_tmp40_ = string_index_of_char (_tmp39_, (gunichar) '*', 0);
						if (-1 != _tmp40_) {
							GPatternSpec* pattern = NULL;
							gchar** _tmp41_ = NULL;
							gint _tmp41__length1 = 0;
							const gchar* _tmp42_ = NULL;
							GPatternSpec* _tmp43_ = NULL;
							ValaMap* _tmp44_ = NULL;
							GPatternSpec* _tmp45_ = NULL;
							gchar** _tmp46_ = NULL;
							gint _tmp46__length1 = 0;
							const gchar* _tmp47_ = NULL;
							_tmp41_ = tokens;
							_tmp41__length1 = tokens_length1;
							_tmp42_ = _tmp41_[0];
							_tmp43_ = g_pattern_spec_new (_tmp42_);
							pattern = _tmp43_;
							_tmp44_ = self->priv->codenode_attributes_patterns;
							_tmp45_ = pattern;
							_tmp46_ = tokens;
							_tmp46__length1 = tokens_length1;
							_tmp47_ = _tmp46_[0];
							vala_map_set (_tmp44_, _tmp45_, _tmp47_);
						}
						_tmp48_ = self->priv->codenode_attributes_map;
						_tmp49_ = tokens;
						_tmp49__length1 = tokens_length1;
						_tmp50_ = _tmp49_[0];
						_tmp51_ = tokens;
						_tmp51__length1 = tokens_length1;
						_tmp52_ = _tmp51_[1];
						vala_map_set (_tmp48_, _tmp50_, _tmp52_);
						tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (line);
					}
				}
				line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
			}
			_g_free0 (metadata);
		}
		goto __finally0;
		__catch0_g_file_error:
		{
			GError* e = NULL;
			GError* _tmp53_ = NULL;
			const gchar* _tmp54_ = NULL;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp53_ = e;
			_tmp54_ = _tmp53_->message;
			_tmp55_ = g_strdup_printf ("Unable to read metadata file: %s", _tmp54_);
			_tmp56_ = _tmp55_;
			vala_report_error (NULL, _tmp56_);
			_g_free0 (_tmp56_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		GList* modules = NULL;
		ValaSourceFile* _tmp57_ = NULL;
		const gchar* _tmp58_ = NULL;
		const gchar* _tmp59_ = NULL;
		GList* _tmp60_ = NULL;
		ValaSourceFile* _tmp61_ = NULL;
		ValaSourceLocation _tmp62_ = {0};
		ValaSourceLocation _tmp63_ = {0};
		ValaSourceReference* _tmp64_ = NULL;
		_tmp57_ = source_file;
		_tmp58_ = vala_source_file_get_filename (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = g_idl_parse_file (_tmp59_, &_inner_error_);
		modules = _tmp60_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_MARKUP_ERROR) {
				goto __catch1_g_markup_error;
			}
			_g_free0 (metadata_filename);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp61_ = source_file;
		vala_source_location_init (&_tmp62_, NULL, 0, 0);
		vala_source_location_init (&_tmp63_, NULL, 0, 0);
		_tmp64_ = vala_source_reference_new (_tmp61_, &_tmp62_, &_tmp63_);
		_vala_source_reference_unref0 (self->priv->current_source_reference);
		self->priv->current_source_reference = _tmp64_;
		{
			GList* module_collection = NULL;
			GList* module_it = NULL;
			module_collection = modules;
			for (module_it = module_collection; module_it != NULL; module_it = module_it->next) {
				GIdlModule* module = NULL;
				module = (GIdlModule*) module_it->data;
				{
					ValaNamespace* ns = NULL;
					GIdlModule* _tmp65_ = NULL;
					ValaNamespace* _tmp66_ = NULL;
					ValaNamespace* _tmp67_ = NULL;
					_tmp65_ = module;
					_tmp66_ = vala_gidl_parser_parse_module (self, _tmp65_);
					ns = _tmp66_;
					_tmp67_ = ns;
					if (_tmp67_ != NULL) {
						ValaCodeContext* _tmp68_ = NULL;
						ValaNamespace* _tmp69_ = NULL;
						ValaNamespace* _tmp70_ = NULL;
						ValaNamespace* _tmp71_ = NULL;
						_tmp68_ = self->priv->context;
						_tmp69_ = vala_code_context_get_root (_tmp68_);
						_tmp70_ = _tmp69_;
						_tmp71_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp70_, _tmp71_);
					}
					_vala_code_node_unref0 (ns);
				}
			}
		}
		__g_list_free__g_idl_module_free0_0 (modules);
	}
	goto __finally1;
	__catch1_g_markup_error:
	{
		GError* e = NULL;
		GError* _tmp72_ = NULL;
		const gchar* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp72_ = e;
		_tmp73_ = _tmp72_->message;
		_tmp74_ = g_strdup_printf ("Unable to parse GIDL file: %s", _tmp73_);
		_tmp75_ = _tmp74_;
		vala_report_error (NULL, _tmp75_);
		_g_free0 (_tmp75_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (metadata_filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (metadata_filename);
}


static gchar* vala_gidl_parser_fix_type_name (ValaGIdlParser* self, const gchar* type_name, ValaSymbol* container) {
	gchar* result = NULL;
	gchar** attributes = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gint attributes_length1 = 0;
	gint _attributes_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp14_ = NULL;
	ValaSymbol* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp0_ = type_name;
	_tmp2_ = vala_gidl_parser_get_attributes (self, _tmp0_, &_tmp1_);
	attributes = _tmp2_;
	attributes_length1 = _tmp1_;
	_attributes_size_ = attributes_length1;
	_tmp3_ = attributes;
	_tmp3__length1 = attributes_length1;
	if (_tmp3_ != NULL) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = attributes;
		_tmp4__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp4_;
			attr_collection_length1 = _tmp4__length1;
			for (attr_it = 0; attr_it < _tmp4__length1; attr_it = attr_it + 1) {
				gchar* _tmp5_ = NULL;
				gchar* attr = NULL;
				_tmp5_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp5_;
				{
					gchar** nv = NULL;
					const gchar* _tmp6_ = NULL;
					gchar** _tmp7_ = NULL;
					gchar** _tmp8_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gchar** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					const gchar* _tmp10_ = NULL;
					_tmp6_ = attr;
					_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "=", 2);
					nv = _tmp8_;
					nv_length1 = _vala_array_length (_tmp7_);
					_nv_size_ = nv_length1;
					_tmp9_ = nv;
					_tmp9__length1 = nv_length1;
					_tmp10_ = _tmp9_[0];
					if (g_strcmp0 (_tmp10_, "name") == 0) {
						gchar** _tmp11_ = NULL;
						gint _tmp11__length1 = 0;
						const gchar* _tmp12_ = NULL;
						gchar* _tmp13_ = NULL;
						_tmp11_ = nv;
						_tmp11__length1 = nv_length1;
						_tmp12_ = _tmp11_[1];
						_tmp13_ = vala_gidl_parser_eval (self, _tmp12_);
						result = _tmp13_;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp14_ = type_name;
	_tmp15_ = container;
	_tmp16_ = vala_symbol_get_name (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_str_has_prefix (_tmp14_, _tmp17_);
	if (_tmp18_) {
		const gchar* _tmp19_ = NULL;
		ValaSymbol* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		gchar* _tmp25_ = NULL;
		_tmp19_ = type_name;
		_tmp20_ = container;
		_tmp21_ = vala_symbol_get_name (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = strlen (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = string_substring (_tmp19_, (glong) _tmp24_, (glong) -1);
		result = _tmp25_;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		return result;
	} else {
		gchar* cprefix = NULL;
		ValaSymbol* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		gboolean _tmp30_ = FALSE;
		_tmp26_ = container;
		_tmp27_ = vala_gidl_parser_get_cprefix (self, _tmp26_);
		cprefix = _tmp27_;
		_tmp28_ = type_name;
		_tmp29_ = cprefix;
		_tmp30_ = g_str_has_prefix (_tmp28_, _tmp29_);
		if (_tmp30_) {
			const gchar* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			gchar* _tmp35_ = NULL;
			_tmp31_ = type_name;
			_tmp32_ = cprefix;
			_tmp33_ = strlen (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = string_substring (_tmp31_, (glong) _tmp34_, (glong) -1);
			result = _tmp35_;
			_g_free0 (cprefix);
			attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		_g_free0 (cprefix);
	}
	_tmp36_ = type_name;
	_tmp37_ = g_strdup (_tmp36_);
	result = _tmp37_;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static gchar* vala_gidl_parser_fix_const_name (ValaGIdlParser* self, const gchar* const_name, ValaSymbol* container) {
	gchar* result = NULL;
	gchar* pref = NULL;
	ValaSymbol* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_name != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_tmp0_ = container;
	_tmp1_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_ascii_strup (_tmp2_, (gssize) -1);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	pref = _tmp4_;
	_tmp5_ = const_name;
	_tmp6_ = pref;
	_tmp7_ = g_str_has_prefix (_tmp5_, _tmp6_);
	if (_tmp7_) {
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gchar* _tmp12_ = NULL;
		_tmp8_ = const_name;
		_tmp9_ = pref;
		_tmp10_ = strlen (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = string_substring (_tmp8_, (glong) _tmp11_, (glong) -1);
		result = _tmp12_;
		_g_free0 (pref);
		return result;
	}
	_tmp13_ = const_name;
	_tmp14_ = g_strdup (_tmp13_);
	result = _tmp14_;
	_g_free0 (pref);
	return result;
}


static gchar* vala_gidl_parser_get_cheader_filename (ValaGIdlParser* self, ValaSymbol* sym) {
	gchar* result = NULL;
	gchar* cheader_filename = NULL;
	ValaSymbol* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	ValaSymbol* _tmp3_ = NULL;
	ValaSymbol* _tmp4_ = NULL;
	ValaSymbol* _tmp5_ = NULL;
	gchar* _tmp19_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "cheader_filename", NULL);
	cheader_filename = _tmp1_;
	_tmp2_ = cheader_filename;
	if (_tmp2_ != NULL) {
		result = cheader_filename;
		return result;
	}
	_tmp3_ = sym;
	_tmp4_ = vala_symbol_get_parent_symbol (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaSymbol* _tmp6_ = NULL;
		ValaSymbol* _tmp7_ = NULL;
		ValaSymbol* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp6_ = sym;
		_tmp7_ = vala_symbol_get_parent_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_gidl_parser_get_cheader_filename (self, _tmp8_);
		result = _tmp9_;
		_g_free0 (cheader_filename);
		return result;
	} else {
		ValaSymbol* _tmp10_ = NULL;
		ValaSourceReference* _tmp11_ = NULL;
		ValaSourceReference* _tmp12_ = NULL;
		_tmp10_ = sym;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaSymbol* _tmp13_ = NULL;
			ValaSourceReference* _tmp14_ = NULL;
			ValaSourceReference* _tmp15_ = NULL;
			ValaSourceFile* _tmp16_ = NULL;
			ValaSourceFile* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			_tmp13_ = sym;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_source_reference_get_file (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_source_file_get_cinclude_filename (_tmp17_);
			result = _tmp18_;
			_g_free0 (cheader_filename);
			return result;
		}
	}
	_tmp19_ = g_strdup ("");
	result = _tmp19_;
	_g_free0 (cheader_filename);
	return result;
}


static gchar* vala_gidl_parser_get_cname (ValaGIdlParser* self, ValaSymbol* sym, ValaSymbol* container) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_ = NULL;
	gchar* cname = NULL;
	ValaSymbol* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ValaSymbol* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = container;
	if (_tmp0_ == NULL) {
		ValaSymbol* _tmp1_ = NULL;
		ValaSymbol* _tmp2_ = NULL;
		ValaSymbol* _tmp3_ = NULL;
		_tmp1_ = sym;
		_tmp2_ = vala_symbol_get_parent_symbol (_tmp1_);
		_tmp3_ = _tmp2_;
		container = _tmp3_;
	}
	_tmp4_ = sym;
	_tmp5_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp4_, "CCode", "cname", NULL);
	cname = _tmp5_;
	_tmp6_ = cname;
	if (_tmp6_ != NULL) {
		result = cname;
		return result;
	}
	_tmp7_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_METHOD)) {
		gchar* name = NULL;
		ValaSymbol* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		ValaSymbol* _tmp12_ = NULL;
		ValaSymbol* _tmp19_ = NULL;
		_tmp8_ = sym;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		name = _tmp11_;
		_tmp12_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_CREATION_METHOD)) {
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_ = NULL;
			_tmp14_ = name;
			if (_tmp14_ == NULL) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_ = NULL;
				_tmp15_ = name;
				_tmp13_ = g_strcmp0 (_tmp15_, ".new") == 0;
			}
			if (_tmp13_) {
				gchar* _tmp16_ = NULL;
				_tmp16_ = g_strdup ("new");
				_g_free0 (name);
				name = _tmp16_;
			} else {
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				_tmp17_ = name;
				_tmp18_ = g_strconcat ("new_", _tmp17_, NULL);
				_g_free0 (name);
				name = _tmp18_;
			}
		}
		_tmp19_ = container;
		if (_tmp19_ != NULL) {
			ValaSymbol* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			_tmp20_ = container;
			_tmp21_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = name;
			_tmp24_ = g_strdup_printf ("%s%s", _tmp22_, _tmp23_);
			_tmp25_ = _tmp24_;
			_g_free0 (_tmp22_);
			result = _tmp25_;
			_g_free0 (name);
			_g_free0 (cname);
			return result;
		} else {
			result = name;
			_g_free0 (cname);
			return result;
		}
		_g_free0 (name);
	} else {
		ValaSymbol* _tmp26_ = NULL;
		_tmp26_ = container;
		if (_tmp26_ != NULL) {
			ValaSymbol* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			ValaSymbol* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			_tmp27_ = container;
			_tmp28_ = vala_gidl_parser_get_cprefix (self, _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = sym;
			_tmp31_ = vala_symbol_get_name (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strdup_printf ("%s%s", _tmp29_, _tmp32_);
			_tmp34_ = _tmp33_;
			_g_free0 (_tmp29_);
			result = _tmp34_;
			_g_free0 (cname);
			return result;
		} else {
			ValaSymbol* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			_tmp35_ = sym;
			_tmp36_ = vala_symbol_get_name (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strdup (_tmp37_);
			result = _tmp38_;
			_g_free0 (cname);
			return result;
		}
	}
	_g_free0 (cname);
}


static gchar* vala_gidl_parser_get_finish_cname (ValaGIdlParser* self, ValaMethod* m) {
	gchar* result = NULL;
	gchar* finish_cname = NULL;
	ValaMethod* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _result_ = NULL;
	ValaMethod* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (m != NULL, NULL);
	_tmp0_ = m;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "finish_name", NULL);
	finish_cname = _tmp1_;
	_tmp2_ = finish_cname;
	if (_tmp2_ != NULL) {
		result = finish_cname;
		return result;
	}
	_tmp3_ = m;
	_tmp4_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp3_, NULL);
	_result_ = _tmp4_;
	_tmp5_ = _result_;
	_tmp6_ = g_str_has_suffix (_tmp5_, "_async");
	if (_tmp6_) {
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gchar* _tmp13_ = NULL;
		_tmp7_ = _result_;
		_tmp8_ = _result_;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = strlen ("_async");
		_tmp12_ = _tmp11_;
		_tmp13_ = string_substring (_tmp7_, (glong) 0, (glong) (_tmp10_ - _tmp12_));
		_g_free0 (_result_);
		_result_ = _tmp13_;
	}
	_tmp14_ = _result_;
	_tmp15_ = g_strconcat (_tmp14_, "_finish", NULL);
	result = _tmp15_;
	_g_free0 (_result_);
	_g_free0 (finish_cname);
	return result;
}


static gchar* vala_gidl_parser_get_lower_case_cname (ValaGIdlParser* self, ValaSymbol* sym) {
	gchar* result = NULL;
	gchar* lower_case_csuffix = NULL;
	ValaSymbol* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	ValaSymbol* _tmp4_ = NULL;
	ValaSymbol* _tmp32_ = NULL;
	ValaSymbol* _tmp33_ = NULL;
	ValaSymbol* _tmp34_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_symbol_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_camel_case_to_lower_case (_tmp2_);
	lower_case_csuffix = _tmp3_;
	_tmp4_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		const gchar* _tmp5_ = NULL;
		gboolean _tmp6_ = FALSE;
		const gchar* _tmp21_ = NULL;
		gboolean _tmp22_ = FALSE;
		_tmp5_ = lower_case_csuffix;
		_tmp6_ = g_str_has_prefix (_tmp5_, "type_");
		if (_tmp6_) {
			const gchar* _tmp7_ = NULL;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			_tmp7_ = lower_case_csuffix;
			_tmp8_ = strlen ("type_");
			_tmp9_ = _tmp8_;
			_tmp10_ = string_substring (_tmp7_, (glong) _tmp9_, (glong) -1);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_strconcat ("type", _tmp11_, NULL);
			_g_free0 (lower_case_csuffix);
			lower_case_csuffix = _tmp12_;
			_g_free0 (_tmp11_);
		} else {
			const gchar* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			_tmp13_ = lower_case_csuffix;
			_tmp14_ = g_str_has_prefix (_tmp13_, "is_");
			if (_tmp14_) {
				const gchar* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				_tmp15_ = lower_case_csuffix;
				_tmp16_ = strlen ("is_");
				_tmp17_ = _tmp16_;
				_tmp18_ = string_substring (_tmp15_, (glong) _tmp17_, (glong) -1);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat ("is", _tmp19_, NULL);
				_g_free0 (lower_case_csuffix);
				lower_case_csuffix = _tmp20_;
				_g_free0 (_tmp19_);
			}
		}
		_tmp21_ = lower_case_csuffix;
		_tmp22_ = g_str_has_suffix (_tmp21_, "_class");
		if (_tmp22_) {
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			_tmp23_ = lower_case_csuffix;
			_tmp24_ = lower_case_csuffix;
			_tmp25_ = strlen (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = strlen ("_class");
			_tmp28_ = _tmp27_;
			_tmp29_ = string_substring (_tmp23_, (glong) 0, (glong) (_tmp26_ - _tmp28_));
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strconcat (_tmp30_, "class", NULL);
			_g_free0 (lower_case_csuffix);
			lower_case_csuffix = _tmp31_;
			_g_free0 (_tmp30_);
		}
	}
	_tmp32_ = sym;
	_tmp33_ = vala_symbol_get_parent_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	if (_tmp34_ != NULL) {
		ValaSymbol* _tmp35_ = NULL;
		ValaSymbol* _tmp36_ = NULL;
		ValaSymbol* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		_tmp35_ = sym;
		_tmp36_ = vala_symbol_get_parent_symbol (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = lower_case_csuffix;
		_tmp41_ = g_strdup_printf ("%s%s", _tmp39_, _tmp40_);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp39_);
		result = _tmp42_;
		_g_free0 (lower_case_csuffix);
		return result;
	} else {
		result = lower_case_csuffix;
		return result;
	}
	_g_free0 (lower_case_csuffix);
}


static gchar* vala_gidl_parser_get_lower_case_cprefix (ValaGIdlParser* self, ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* cprefix = NULL;
	ValaSymbol* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp13_ = NULL;
	ValaSymbol* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	_tmp1_ = vala_symbol_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = g_strdup ("");
		result = _tmp3_;
		return result;
	}
	_tmp4_ = sym;
	_tmp5_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp4_, "CCode", "lower_case_cprefix", NULL);
	_g_free0 (cprefix);
	cprefix = _tmp5_;
	_tmp7_ = cprefix;
	if (_tmp7_ == NULL) {
		gboolean _tmp8_ = FALSE;
		ValaSymbol* _tmp9_ = NULL;
		_tmp9_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
			_tmp8_ = TRUE;
		} else {
			ValaSymbol* _tmp10_ = NULL;
			_tmp10_ = sym;
			_tmp8_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_STRUCT);
		}
		_tmp6_ = _tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaSymbol* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		_tmp11_ = sym;
		_tmp12_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp11_, "CCode", "cprefix", NULL);
		_g_free0 (cprefix);
		cprefix = _tmp12_;
	}
	_tmp13_ = cprefix;
	if (_tmp13_ != NULL) {
		result = cprefix;
		return result;
	}
	_tmp14_ = sym;
	_tmp15_ = vala_gidl_parser_get_lower_case_cname (self, _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strconcat (_tmp16_, "_", NULL);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	result = _tmp18_;
	_g_free0 (cprefix);
	return result;
}


gchar* vala_gidl_parser_get_cprefix (ValaGIdlParser* self, ValaSymbol* sym) {
	gchar* result = NULL;
	ValaSymbol* _tmp0_ = NULL;
	gchar* _tmp45_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sym != NULL, NULL);
	_tmp0_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		ValaSymbol* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		_tmp1_ = sym;
		_tmp2_ = vala_gidl_parser_get_cname (self, _tmp1_, NULL);
		result = _tmp2_;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		ValaSymbol* _tmp4_ = NULL;
		_tmp4_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_ENUM)) {
			_tmp3_ = TRUE;
		} else {
			ValaSymbol* _tmp5_ = NULL;
			_tmp5_ = sym;
			_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_ERROR_DOMAIN);
		}
		if (_tmp3_) {
			ValaSymbol* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			_tmp6_ = sym;
			_tmp7_ = vala_gidl_parser_get_lower_case_cname (self, _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = g_ascii_strup (_tmp8_, (gssize) -1);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup_printf ("%s_", _tmp10_);
			_tmp12_ = _tmp11_;
			_g_free0 (_tmp10_);
			_g_free0 (_tmp8_);
			result = _tmp12_;
			return result;
		} else {
			ValaSymbol* _tmp13_ = NULL;
			_tmp13_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_NAMESPACE)) {
				ValaSymbol* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				_tmp14_ = sym;
				_tmp15_ = vala_symbol_get_name (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ != NULL) {
					gchar* cprefix = NULL;
					ValaSymbol* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					ValaSymbol* _tmp20_ = NULL;
					ValaSymbol* _tmp21_ = NULL;
					ValaSymbol* _tmp22_ = NULL;
					_tmp17_ = sym;
					_tmp18_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp17_, "CCode", "cprefix", NULL);
					cprefix = _tmp18_;
					_tmp19_ = cprefix;
					if (_tmp19_ != NULL) {
						result = cprefix;
						return result;
					}
					_tmp20_ = sym;
					_tmp21_ = vala_symbol_get_parent_symbol (_tmp20_);
					_tmp22_ = _tmp21_;
					if (_tmp22_ != NULL) {
						ValaSymbol* _tmp23_ = NULL;
						ValaSymbol* _tmp24_ = NULL;
						ValaSymbol* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						ValaSymbol* _tmp28_ = NULL;
						const gchar* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
						gchar* _tmp31_ = NULL;
						gchar* _tmp32_ = NULL;
						_tmp23_ = sym;
						_tmp24_ = vala_symbol_get_parent_symbol (_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp26_ = vala_gidl_parser_get_cprefix (self, _tmp25_);
						_tmp27_ = _tmp26_;
						_tmp28_ = sym;
						_tmp29_ = vala_symbol_get_name (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = g_strdup_printf ("%s%s", _tmp27_, _tmp30_);
						_tmp32_ = _tmp31_;
						_g_free0 (_tmp27_);
						result = _tmp32_;
						_g_free0 (cprefix);
						return result;
					} else {
						ValaSymbol* _tmp33_ = NULL;
						const gchar* _tmp34_ = NULL;
						const gchar* _tmp35_ = NULL;
						gchar* _tmp36_ = NULL;
						_tmp33_ = sym;
						_tmp34_ = vala_symbol_get_name (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = g_strdup (_tmp35_);
						result = _tmp36_;
						_g_free0 (cprefix);
						return result;
					}
					_g_free0 (cprefix);
				} else {
					gchar* _tmp37_ = NULL;
					_tmp37_ = g_strdup ("");
					result = _tmp37_;
					return result;
				}
			} else {
				ValaSymbol* _tmp38_ = NULL;
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				_tmp38_ = sym;
				_tmp39_ = vala_symbol_get_name (_tmp38_);
				_tmp40_ = _tmp39_;
				if (_tmp40_ != NULL) {
					ValaSymbol* _tmp41_ = NULL;
					const gchar* _tmp42_ = NULL;
					const gchar* _tmp43_ = NULL;
					gchar* _tmp44_ = NULL;
					_tmp41_ = sym;
					_tmp42_ = vala_symbol_get_name (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = g_strdup (_tmp43_);
					result = _tmp44_;
					return result;
				}
			}
		}
	}
	_tmp45_ = g_strdup ("");
	result = _tmp45_;
	return result;
}


static gchar** vala_gidl_parser_get_attributes_for_node (ValaGIdlParser* self, GIdlNode* node, int* result_length1) {
	gchar** result = NULL;
	gchar* name = NULL;
	GIdlNode* _tmp0_ = NULL;
	GIdlNodeTypeId _tmp1_ = 0;
	const gchar* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gchar** _tmp34_ = NULL;
	gchar** _tmp35_ = NULL;
	gint _tmp35__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == G_IDL_NODE_FUNCTION) {
		GIdlNode* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		_tmp2_ = node;
		_tmp3_ = ((GIdlNodeFunction*) _tmp2_)->symbol;
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (name);
		name = _tmp4_;
	} else {
		GIdlNode* _tmp5_ = NULL;
		GIdlNodeTypeId _tmp6_ = 0;
		_tmp5_ = node;
		_tmp6_ = _tmp5_->type;
		if (_tmp6_ == G_IDL_NODE_SIGNAL) {
			ValaTypeSymbol* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			GIdlNode* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			_tmp7_ = self->priv->current_data_type;
			_tmp8_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp7_, NULL);
			_tmp9_ = _tmp8_;
			_tmp10_ = node;
			_tmp11_ = _tmp10_->name;
			_tmp12_ = g_strdup_printf ("%s::%s", _tmp9_, _tmp11_);
			_g_free0 (name);
			name = _tmp12_;
			_g_free0 (_tmp9_);
		} else {
			GIdlNode* _tmp13_ = NULL;
			GIdlNodeTypeId _tmp14_ = 0;
			_tmp13_ = node;
			_tmp14_ = _tmp13_->type;
			if (_tmp14_ == G_IDL_NODE_PROPERTY) {
				ValaTypeSymbol* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				GIdlNode* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				gchar* _tmp20_ = NULL;
				_tmp15_ = self->priv->current_data_type;
				_tmp16_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp15_, NULL);
				_tmp17_ = _tmp16_;
				_tmp18_ = node;
				_tmp19_ = _tmp18_->name;
				_tmp20_ = g_strdup_printf ("%s:%s", _tmp17_, _tmp19_);
				_g_free0 (name);
				name = _tmp20_;
				_g_free0 (_tmp17_);
			} else {
				GIdlNode* _tmp21_ = NULL;
				GIdlNodeTypeId _tmp22_ = 0;
				_tmp21_ = node;
				_tmp22_ = _tmp21_->type;
				if (_tmp22_ == G_IDL_NODE_FIELD) {
					ValaTypeSymbol* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					GIdlNode* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					_tmp23_ = self->priv->current_data_type;
					_tmp24_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp23_, NULL);
					_tmp25_ = _tmp24_;
					_tmp26_ = node;
					_tmp27_ = _tmp26_->name;
					_tmp28_ = g_strdup_printf ("%s.%s", _tmp25_, _tmp27_);
					_g_free0 (name);
					name = _tmp28_;
					_g_free0 (_tmp25_);
				} else {
					GIdlNode* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					_tmp29_ = node;
					_tmp30_ = _tmp29_->name;
					_tmp31_ = g_strdup (_tmp30_);
					_g_free0 (name);
					name = _tmp31_;
				}
			}
		}
	}
	_tmp32_ = name;
	_tmp34_ = vala_gidl_parser_get_attributes (self, _tmp32_, &_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp35__length1 = _tmp33_;
	if (result_length1) {
		*result_length1 = _tmp35__length1;
	}
	result = _tmp35_;
	_g_free0 (name);
	return result;
}


static void vala_gidl_parser_add_symbol_to_container (ValaGIdlParser* self, ValaSymbol* container, ValaSymbol* sym) {
	ValaSymbol* _tmp0_ = NULL;
	gboolean _tmp112_ = FALSE;
	ValaSymbol* _tmp113_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = container;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp1_ = NULL;
		ValaSymbol* _tmp2_ = NULL;
		_tmp1_ = container;
		cl = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_CLASS, ValaClass);
		_tmp2_ = sym;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CLASS)) {
			ValaClass* _tmp3_ = NULL;
			ValaSymbol* _tmp4_ = NULL;
			_tmp3_ = cl;
			_tmp4_ = sym;
			vala_symbol_add_class ((ValaSymbol*) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_CLASS, ValaClass));
		} else {
			ValaSymbol* _tmp5_ = NULL;
			_tmp5_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_CONSTANT)) {
				ValaClass* _tmp6_ = NULL;
				ValaSymbol* _tmp7_ = NULL;
				_tmp6_ = cl;
				_tmp7_ = sym;
				vala_symbol_add_constant ((ValaSymbol*) _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, VALA_TYPE_CONSTANT, ValaConstant));
			} else {
				ValaSymbol* _tmp8_ = NULL;
				_tmp8_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_ENUM)) {
					ValaClass* _tmp9_ = NULL;
					ValaSymbol* _tmp10_ = NULL;
					_tmp9_ = cl;
					_tmp10_ = sym;
					vala_symbol_add_enum ((ValaSymbol*) _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_ENUM, ValaEnum));
				} else {
					ValaSymbol* _tmp11_ = NULL;
					_tmp11_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_FIELD)) {
						ValaClass* _tmp12_ = NULL;
						ValaSymbol* _tmp13_ = NULL;
						_tmp12_ = cl;
						_tmp13_ = sym;
						vala_symbol_add_field ((ValaSymbol*) _tmp12_, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_FIELD, ValaField));
					} else {
						ValaSymbol* _tmp14_ = NULL;
						_tmp14_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_METHOD)) {
							ValaClass* _tmp15_ = NULL;
							ValaSymbol* _tmp16_ = NULL;
							_tmp15_ = cl;
							_tmp16_ = sym;
							vala_symbol_add_method ((ValaSymbol*) _tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_METHOD, ValaMethod));
						} else {
							ValaSymbol* _tmp17_ = NULL;
							_tmp17_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALA_TYPE_PROPERTY)) {
								ValaClass* _tmp18_ = NULL;
								ValaSymbol* _tmp19_ = NULL;
								_tmp18_ = cl;
								_tmp19_ = sym;
								vala_symbol_add_property ((ValaSymbol*) _tmp18_, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_PROPERTY, ValaProperty));
							} else {
								ValaSymbol* _tmp20_ = NULL;
								_tmp20_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_SIGNAL)) {
									ValaClass* _tmp21_ = NULL;
									ValaSymbol* _tmp22_ = NULL;
									_tmp21_ = cl;
									_tmp22_ = sym;
									vala_symbol_add_signal ((ValaSymbol*) _tmp21_, G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_SIGNAL, ValaSignal));
								} else {
									ValaSymbol* _tmp23_ = NULL;
									_tmp23_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, VALA_TYPE_STRUCT)) {
										ValaClass* _tmp24_ = NULL;
										ValaSymbol* _tmp25_ = NULL;
										_tmp24_ = cl;
										_tmp25_ = sym;
										vala_symbol_add_struct ((ValaSymbol*) _tmp24_, G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_STRUCT, ValaStruct));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		ValaSymbol* _tmp26_ = NULL;
		_tmp26_ = container;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, VALA_TYPE_ENUM)) {
			ValaEnum* en = NULL;
			ValaSymbol* _tmp27_ = NULL;
			ValaSymbol* _tmp28_ = NULL;
			_tmp27_ = container;
			en = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_ENUM, ValaEnum);
			_tmp28_ = sym;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALA_TYPE_ENUM_VALUE)) {
				ValaEnum* _tmp29_ = NULL;
				ValaSymbol* _tmp30_ = NULL;
				_tmp29_ = en;
				_tmp30_ = sym;
				vala_enum_add_value (_tmp29_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_ENUM_VALUE, ValaEnumValue));
			} else {
				ValaSymbol* _tmp31_ = NULL;
				_tmp31_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_CONSTANT)) {
					ValaEnum* _tmp32_ = NULL;
					ValaSymbol* _tmp33_ = NULL;
					_tmp32_ = en;
					_tmp33_ = sym;
					vala_symbol_add_constant ((ValaSymbol*) _tmp32_, G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_CONSTANT, ValaConstant));
				} else {
					ValaSymbol* _tmp34_ = NULL;
					_tmp34_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALA_TYPE_METHOD)) {
						ValaEnum* _tmp35_ = NULL;
						ValaSymbol* _tmp36_ = NULL;
						_tmp35_ = en;
						_tmp36_ = sym;
						vala_symbol_add_method ((ValaSymbol*) _tmp35_, G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_METHOD, ValaMethod));
					}
				}
			}
		} else {
			ValaSymbol* _tmp37_ = NULL;
			_tmp37_ = container;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp37_, VALA_TYPE_INTERFACE)) {
				ValaInterface* iface = NULL;
				ValaSymbol* _tmp38_ = NULL;
				ValaSymbol* _tmp39_ = NULL;
				_tmp38_ = container;
				iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_INTERFACE, ValaInterface);
				_tmp39_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_CLASS)) {
					ValaInterface* _tmp40_ = NULL;
					ValaSymbol* _tmp41_ = NULL;
					_tmp40_ = iface;
					_tmp41_ = sym;
					vala_symbol_add_class ((ValaSymbol*) _tmp40_, G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, VALA_TYPE_CLASS, ValaClass));
				} else {
					ValaSymbol* _tmp42_ = NULL;
					_tmp42_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, VALA_TYPE_CONSTANT)) {
						ValaInterface* _tmp43_ = NULL;
						ValaSymbol* _tmp44_ = NULL;
						_tmp43_ = iface;
						_tmp44_ = sym;
						vala_symbol_add_constant ((ValaSymbol*) _tmp43_, G_TYPE_CHECK_INSTANCE_CAST (_tmp44_, VALA_TYPE_CONSTANT, ValaConstant));
					} else {
						ValaSymbol* _tmp45_ = NULL;
						_tmp45_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, VALA_TYPE_ENUM)) {
							ValaInterface* _tmp46_ = NULL;
							ValaSymbol* _tmp47_ = NULL;
							_tmp46_ = iface;
							_tmp47_ = sym;
							vala_symbol_add_enum ((ValaSymbol*) _tmp46_, G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_ENUM, ValaEnum));
						} else {
							ValaSymbol* _tmp48_ = NULL;
							_tmp48_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_FIELD)) {
								ValaInterface* _tmp49_ = NULL;
								ValaSymbol* _tmp50_ = NULL;
								_tmp49_ = iface;
								_tmp50_ = sym;
								vala_symbol_add_field ((ValaSymbol*) _tmp49_, G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_FIELD, ValaField));
							} else {
								ValaSymbol* _tmp51_ = NULL;
								_tmp51_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_METHOD)) {
									ValaInterface* _tmp52_ = NULL;
									ValaSymbol* _tmp53_ = NULL;
									_tmp52_ = iface;
									_tmp53_ = sym;
									vala_symbol_add_method ((ValaSymbol*) _tmp52_, G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_METHOD, ValaMethod));
								} else {
									ValaSymbol* _tmp54_ = NULL;
									_tmp54_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp54_, VALA_TYPE_PROPERTY)) {
										ValaInterface* _tmp55_ = NULL;
										ValaSymbol* _tmp56_ = NULL;
										_tmp55_ = iface;
										_tmp56_ = sym;
										vala_symbol_add_property ((ValaSymbol*) _tmp55_, G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										ValaSymbol* _tmp57_ = NULL;
										_tmp57_ = sym;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp57_, VALA_TYPE_SIGNAL)) {
											ValaInterface* _tmp58_ = NULL;
											ValaSymbol* _tmp59_ = NULL;
											_tmp58_ = iface;
											_tmp59_ = sym;
											vala_symbol_add_signal ((ValaSymbol*) _tmp58_, G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_SIGNAL, ValaSignal));
										} else {
											ValaSymbol* _tmp60_ = NULL;
											_tmp60_ = sym;
											if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp60_, VALA_TYPE_STRUCT)) {
												ValaInterface* _tmp61_ = NULL;
												ValaSymbol* _tmp62_ = NULL;
												_tmp61_ = iface;
												_tmp62_ = sym;
												vala_symbol_add_struct ((ValaSymbol*) _tmp61_, G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_STRUCT, ValaStruct));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				ValaSymbol* _tmp63_ = NULL;
				_tmp63_ = container;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp63_, VALA_TYPE_NAMESPACE)) {
					ValaNamespace* ns = NULL;
					ValaSymbol* _tmp64_ = NULL;
					ValaSymbol* _tmp65_ = NULL;
					_tmp64_ = container;
					ns = G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_NAMESPACE, ValaNamespace);
					_tmp65_ = sym;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, VALA_TYPE_NAMESPACE)) {
						ValaNamespace* _tmp66_ = NULL;
						ValaSymbol* _tmp67_ = NULL;
						_tmp66_ = ns;
						_tmp67_ = sym;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp66_, G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, VALA_TYPE_NAMESPACE, ValaNamespace));
					} else {
						ValaSymbol* _tmp68_ = NULL;
						_tmp68_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp68_, VALA_TYPE_CLASS)) {
							ValaNamespace* _tmp69_ = NULL;
							ValaSymbol* _tmp70_ = NULL;
							_tmp69_ = ns;
							_tmp70_ = sym;
							vala_symbol_add_class ((ValaSymbol*) _tmp69_, G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, VALA_TYPE_CLASS, ValaClass));
						} else {
							ValaSymbol* _tmp71_ = NULL;
							_tmp71_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp71_, VALA_TYPE_CONSTANT)) {
								ValaNamespace* _tmp72_ = NULL;
								ValaSymbol* _tmp73_ = NULL;
								_tmp72_ = ns;
								_tmp73_ = sym;
								vala_symbol_add_constant ((ValaSymbol*) _tmp72_, G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_CONSTANT, ValaConstant));
							} else {
								ValaSymbol* _tmp74_ = NULL;
								_tmp74_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp74_, VALA_TYPE_DELEGATE)) {
									ValaNamespace* _tmp75_ = NULL;
									ValaSymbol* _tmp76_ = NULL;
									_tmp75_ = ns;
									_tmp76_ = sym;
									vala_symbol_add_delegate ((ValaSymbol*) _tmp75_, G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_DELEGATE, ValaDelegate));
								} else {
									ValaSymbol* _tmp77_ = NULL;
									_tmp77_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp77_, VALA_TYPE_ENUM)) {
										ValaNamespace* _tmp78_ = NULL;
										ValaSymbol* _tmp79_ = NULL;
										_tmp78_ = ns;
										_tmp79_ = sym;
										vala_symbol_add_enum ((ValaSymbol*) _tmp78_, G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_ENUM, ValaEnum));
									} else {
										ValaSymbol* _tmp80_ = NULL;
										_tmp80_ = sym;
										if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, VALA_TYPE_ERROR_DOMAIN)) {
											ValaNamespace* _tmp81_ = NULL;
											ValaSymbol* _tmp82_ = NULL;
											_tmp81_ = ns;
											_tmp82_ = sym;
											vala_symbol_add_error_domain ((ValaSymbol*) _tmp81_, G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
										} else {
											ValaSymbol* _tmp83_ = NULL;
											_tmp83_ = sym;
											if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp83_, VALA_TYPE_FIELD)) {
												ValaNamespace* _tmp84_ = NULL;
												ValaSymbol* _tmp85_ = NULL;
												_tmp84_ = ns;
												_tmp85_ = sym;
												vala_symbol_add_field ((ValaSymbol*) _tmp84_, G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_FIELD, ValaField));
											} else {
												ValaSymbol* _tmp86_ = NULL;
												_tmp86_ = sym;
												if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp86_, VALA_TYPE_INTERFACE)) {
													ValaNamespace* _tmp87_ = NULL;
													ValaSymbol* _tmp88_ = NULL;
													_tmp87_ = ns;
													_tmp88_ = sym;
													vala_symbol_add_interface ((ValaSymbol*) _tmp87_, G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_INTERFACE, ValaInterface));
												} else {
													ValaSymbol* _tmp89_ = NULL;
													_tmp89_ = sym;
													if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp89_, VALA_TYPE_METHOD)) {
														ValaNamespace* _tmp90_ = NULL;
														ValaSymbol* _tmp91_ = NULL;
														_tmp90_ = ns;
														_tmp91_ = sym;
														vala_symbol_add_method ((ValaSymbol*) _tmp90_, G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, VALA_TYPE_METHOD, ValaMethod));
													} else {
														ValaSymbol* _tmp92_ = NULL;
														_tmp92_ = sym;
														if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, VALA_TYPE_NAMESPACE)) {
															ValaNamespace* _tmp93_ = NULL;
															ValaSymbol* _tmp94_ = NULL;
															_tmp93_ = ns;
															_tmp94_ = sym;
															vala_symbol_add_namespace ((ValaSymbol*) _tmp93_, G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_NAMESPACE, ValaNamespace));
														} else {
															ValaSymbol* _tmp95_ = NULL;
															_tmp95_ = sym;
															if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, VALA_TYPE_STRUCT)) {
																ValaNamespace* _tmp96_ = NULL;
																ValaSymbol* _tmp97_ = NULL;
																_tmp96_ = ns;
																_tmp97_ = sym;
																vala_symbol_add_struct ((ValaSymbol*) _tmp96_, G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, VALA_TYPE_STRUCT, ValaStruct));
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					ValaSymbol* _tmp98_ = NULL;
					_tmp98_ = container;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_STRUCT)) {
						ValaStruct* st = NULL;
						ValaSymbol* _tmp99_ = NULL;
						ValaSymbol* _tmp100_ = NULL;
						_tmp99_ = container;
						st = G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_STRUCT, ValaStruct);
						_tmp100_ = sym;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp100_, VALA_TYPE_CONSTANT)) {
							ValaStruct* _tmp101_ = NULL;
							ValaSymbol* _tmp102_ = NULL;
							_tmp101_ = st;
							_tmp102_ = sym;
							vala_symbol_add_constant ((ValaSymbol*) _tmp101_, G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CONSTANT, ValaConstant));
						} else {
							ValaSymbol* _tmp103_ = NULL;
							_tmp103_ = sym;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp103_, VALA_TYPE_FIELD)) {
								ValaStruct* _tmp104_ = NULL;
								ValaSymbol* _tmp105_ = NULL;
								_tmp104_ = st;
								_tmp105_ = sym;
								vala_symbol_add_field ((ValaSymbol*) _tmp104_, G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, VALA_TYPE_FIELD, ValaField));
							} else {
								ValaSymbol* _tmp106_ = NULL;
								_tmp106_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_METHOD)) {
									ValaStruct* _tmp107_ = NULL;
									ValaSymbol* _tmp108_ = NULL;
									_tmp107_ = st;
									_tmp108_ = sym;
									vala_symbol_add_method ((ValaSymbol*) _tmp107_, G_TYPE_CHECK_INSTANCE_CAST (_tmp108_, VALA_TYPE_METHOD, ValaMethod));
								} else {
									ValaSymbol* _tmp109_ = NULL;
									_tmp109_ = sym;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp109_, VALA_TYPE_PROPERTY)) {
										ValaStruct* _tmp110_ = NULL;
										ValaSymbol* _tmp111_ = NULL;
										_tmp110_ = st;
										_tmp111_ = sym;
										vala_symbol_add_property ((ValaSymbol*) _tmp110_, G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_PROPERTY, ValaProperty));
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp113_ = sym;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp113_, VALA_TYPE_NAMESPACE)) {
		ValaSymbol* _tmp114_ = NULL;
		_tmp114_ = container;
		_tmp112_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp114_, VALA_TYPE_NAMESPACE);
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		ValaSymbol* _tmp115_ = NULL;
		ValaSymbol* _tmp116_ = NULL;
		gchar* _tmp117_ = NULL;
		gchar* _tmp118_ = NULL;
		_tmp115_ = sym;
		_tmp116_ = sym;
		_tmp117_ = vala_gidl_parser_get_cheader_filename (self, _tmp116_);
		_tmp118_ = _tmp117_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp115_, "CCode", "cheader_filename", _tmp118_, NULL);
		_g_free0 (_tmp118_);
	}
}


static void vala_gidl_parser_parse_node (ValaGIdlParser* self, GIdlNode* node, GIdlModule* module, ValaSymbol* container) {
	GIdlNode* _tmp0_ = NULL;
	GIdlNodeTypeId _tmp1_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (module != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == G_IDL_NODE_CALLBACK) {
		ValaDelegate* cb = NULL;
		GIdlNode* _tmp2_ = NULL;
		ValaDelegate* _tmp3_ = NULL;
		ValaDelegate* _tmp4_ = NULL;
		ValaDelegate* _tmp5_ = NULL;
		ValaDelegate* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		ValaSymbol* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		ValaSymbol* _tmp12_ = NULL;
		ValaDelegate* _tmp13_ = NULL;
		ValaSourceFile* _tmp14_ = NULL;
		ValaDelegate* _tmp15_ = NULL;
		_tmp2_ = node;
		_tmp3_ = vala_gidl_parser_parse_delegate (self, (GIdlNodeFunction*) _tmp2_);
		cb = _tmp3_;
		_tmp4_ = cb;
		if (_tmp4_ == NULL) {
			_vala_code_node_unref0 (cb);
			return;
		}
		_tmp5_ = cb;
		_tmp6_ = cb;
		_tmp7_ = vala_symbol_get_name ((ValaSymbol*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = container;
		_tmp10_ = vala_gidl_parser_fix_type_name (self, _tmp8_, _tmp9_);
		_tmp11_ = _tmp10_;
		vala_symbol_set_name ((ValaSymbol*) _tmp5_, _tmp11_);
		_g_free0 (_tmp11_);
		_tmp12_ = container;
		_tmp13_ = cb;
		vala_gidl_parser_add_symbol_to_container (self, _tmp12_, (ValaSymbol*) _tmp13_);
		_tmp14_ = self->priv->current_source_file;
		_tmp15_ = cb;
		vala_source_file_add_node (_tmp14_, (ValaCodeNode*) _tmp15_);
		_vala_code_node_unref0 (cb);
	} else {
		GIdlNode* _tmp16_ = NULL;
		GIdlNodeTypeId _tmp17_ = 0;
		_tmp16_ = node;
		_tmp17_ = _tmp16_->type;
		if (_tmp17_ == G_IDL_NODE_STRUCT) {
			GIdlNode* _tmp18_ = NULL;
			ValaSymbol* _tmp19_ = NULL;
			GIdlModule* _tmp20_ = NULL;
			_tmp18_ = node;
			_tmp19_ = container;
			_tmp20_ = module;
			vala_gidl_parser_parse_struct (self, (GIdlNodeStruct*) _tmp18_, _tmp19_, _tmp20_);
		} else {
			GIdlNode* _tmp21_ = NULL;
			GIdlNodeTypeId _tmp22_ = 0;
			_tmp21_ = node;
			_tmp22_ = _tmp21_->type;
			if (_tmp22_ == G_IDL_NODE_UNION) {
				GIdlNode* _tmp23_ = NULL;
				ValaSymbol* _tmp24_ = NULL;
				GIdlModule* _tmp25_ = NULL;
				_tmp23_ = node;
				_tmp24_ = container;
				_tmp25_ = module;
				vala_gidl_parser_parse_union (self, (GIdlNodeUnion*) _tmp23_, _tmp24_, _tmp25_);
			} else {
				GIdlNode* _tmp26_ = NULL;
				GIdlNodeTypeId _tmp27_ = 0;
				_tmp26_ = node;
				_tmp27_ = _tmp26_->type;
				if (_tmp27_ == G_IDL_NODE_BOXED) {
					GIdlNode* _tmp28_ = NULL;
					ValaSymbol* _tmp29_ = NULL;
					GIdlModule* _tmp30_ = NULL;
					_tmp28_ = node;
					_tmp29_ = container;
					_tmp30_ = module;
					vala_gidl_parser_parse_boxed (self, (GIdlNodeBoxed*) _tmp28_, _tmp29_, _tmp30_);
				} else {
					GIdlNode* _tmp31_ = NULL;
					GIdlNodeTypeId _tmp32_ = 0;
					_tmp31_ = node;
					_tmp32_ = _tmp31_->type;
					if (_tmp32_ == G_IDL_NODE_ENUM) {
						GIdlNode* _tmp33_ = NULL;
						ValaSymbol* _tmp34_ = NULL;
						GIdlModule* _tmp35_ = NULL;
						_tmp33_ = node;
						_tmp34_ = container;
						_tmp35_ = module;
						vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) _tmp33_, _tmp34_, _tmp35_, FALSE);
					} else {
						GIdlNode* _tmp36_ = NULL;
						GIdlNodeTypeId _tmp37_ = 0;
						_tmp36_ = node;
						_tmp37_ = _tmp36_->type;
						if (_tmp37_ == G_IDL_NODE_FLAGS) {
							GIdlNode* _tmp38_ = NULL;
							ValaSymbol* _tmp39_ = NULL;
							GIdlModule* _tmp40_ = NULL;
							_tmp38_ = node;
							_tmp39_ = container;
							_tmp40_ = module;
							vala_gidl_parser_parse_enum (self, (GIdlNodeEnum*) _tmp38_, _tmp39_, _tmp40_, TRUE);
						} else {
							GIdlNode* _tmp41_ = NULL;
							GIdlNodeTypeId _tmp42_ = 0;
							_tmp41_ = node;
							_tmp42_ = _tmp41_->type;
							if (_tmp42_ == G_IDL_NODE_OBJECT) {
								GIdlNode* _tmp43_ = NULL;
								ValaSymbol* _tmp44_ = NULL;
								GIdlModule* _tmp45_ = NULL;
								_tmp43_ = node;
								_tmp44_ = container;
								_tmp45_ = module;
								vala_gidl_parser_parse_object (self, (GIdlNodeInterface*) _tmp43_, _tmp44_, _tmp45_);
							} else {
								GIdlNode* _tmp46_ = NULL;
								GIdlNodeTypeId _tmp47_ = 0;
								_tmp46_ = node;
								_tmp47_ = _tmp46_->type;
								if (_tmp47_ == G_IDL_NODE_INTERFACE) {
									GIdlNode* _tmp48_ = NULL;
									ValaSymbol* _tmp49_ = NULL;
									GIdlModule* _tmp50_ = NULL;
									_tmp48_ = node;
									_tmp49_ = container;
									_tmp50_ = module;
									vala_gidl_parser_parse_interface (self, (GIdlNodeInterface*) _tmp48_, _tmp49_, _tmp50_);
								} else {
									GIdlNode* _tmp51_ = NULL;
									GIdlNodeTypeId _tmp52_ = 0;
									_tmp51_ = node;
									_tmp52_ = _tmp51_->type;
									if (_tmp52_ == G_IDL_NODE_CONSTANT) {
										ValaConstant* c = NULL;
										GIdlNode* _tmp53_ = NULL;
										ValaConstant* _tmp54_ = NULL;
										ValaConstant* _tmp55_ = NULL;
										_tmp53_ = node;
										_tmp54_ = vala_gidl_parser_parse_constant (self, (GIdlNodeConstant*) _tmp53_);
										c = _tmp54_;
										_tmp55_ = c;
										if (_tmp55_ != NULL) {
											ValaConstant* _tmp56_ = NULL;
											ValaConstant* _tmp57_ = NULL;
											const gchar* _tmp58_ = NULL;
											const gchar* _tmp59_ = NULL;
											ValaSymbol* _tmp60_ = NULL;
											gchar* _tmp61_ = NULL;
											gchar* _tmp62_ = NULL;
											ValaSymbol* _tmp63_ = NULL;
											ValaConstant* _tmp64_ = NULL;
											ValaSourceFile* _tmp65_ = NULL;
											ValaConstant* _tmp66_ = NULL;
											_tmp56_ = c;
											_tmp57_ = c;
											_tmp58_ = vala_symbol_get_name ((ValaSymbol*) _tmp57_);
											_tmp59_ = _tmp58_;
											_tmp60_ = container;
											_tmp61_ = vala_gidl_parser_fix_const_name (self, _tmp59_, _tmp60_);
											_tmp62_ = _tmp61_;
											vala_symbol_set_name ((ValaSymbol*) _tmp56_, _tmp62_);
											_g_free0 (_tmp62_);
											_tmp63_ = container;
											_tmp64_ = c;
											vala_gidl_parser_add_symbol_to_container (self, _tmp63_, (ValaSymbol*) _tmp64_);
											_tmp65_ = self->priv->current_source_file;
											_tmp66_ = c;
											vala_source_file_add_node (_tmp65_, (ValaCodeNode*) _tmp66_);
										}
										_vala_code_node_unref0 (c);
									} else {
										GIdlNode* _tmp67_ = NULL;
										GIdlNodeTypeId _tmp68_ = 0;
										_tmp67_ = node;
										_tmp68_ = _tmp67_->type;
										if (_tmp68_ == G_IDL_NODE_FUNCTION) {
											ValaMethod* m = NULL;
											GIdlNode* _tmp69_ = NULL;
											ValaMethod* _tmp70_ = NULL;
											ValaMethod* _tmp71_ = NULL;
											_tmp69_ = node;
											_tmp70_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp69_, FALSE);
											m = _tmp70_;
											_tmp71_ = m;
											if (_tmp71_ != NULL) {
												ValaMethod* _tmp72_ = NULL;
												ValaSymbol* _tmp73_ = NULL;
												ValaMethod* _tmp74_ = NULL;
												ValaSourceFile* _tmp75_ = NULL;
												ValaMethod* _tmp76_ = NULL;
												_tmp72_ = m;
												vala_method_set_binding (_tmp72_, VALA_MEMBER_BINDING_STATIC);
												_tmp73_ = container;
												_tmp74_ = m;
												vala_gidl_parser_add_symbol_to_container (self, _tmp73_, (ValaSymbol*) _tmp74_);
												_tmp75_ = self->priv->current_source_file;
												_tmp76_ = m;
												vala_source_file_add_node (_tmp75_, (ValaCodeNode*) _tmp76_);
											}
											_vala_code_node_unref0 (m);
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static ValaSymbol* vala_gidl_parser_get_container_from_name (ValaGIdlParser* self, const gchar* name) {
	ValaSymbol* result = NULL;
	gchar** path = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint path_length1 = 0;
	gint _path_size_ = 0;
	ValaSymbol* cp = NULL;
	ValaNamespace* _tmp3_ = NULL;
	ValaSymbol* _tmp4_ = NULL;
	ValaSymbol* _tmp5_ = NULL;
	ValaSymbol* _tmp6_ = NULL;
	ValaSymbol* _tmp7_ = NULL;
	ValaCodeContext* _tmp8_ = NULL;
	ValaNamespace* _tmp9_ = NULL;
	ValaNamespace* _tmp10_ = NULL;
	ValaSymbol* cc = NULL;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ".", 0);
	path = _tmp2_;
	path_length1 = _vala_array_length (_tmp1_);
	_path_size_ = path_length1;
	_tmp3_ = self->priv->current_namespace;
	_tmp4_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp3_);
	cp = _tmp4_;
	_tmp5_ = cp;
	_tmp6_ = vala_symbol_get_parent_symbol (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->context;
	_tmp9_ = vala_code_context_get_root (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp7_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_SYMBOL, ValaSymbol)) {
		ValaSymbol* _tmp11_ = NULL;
		ValaSymbol* _tmp12_ = NULL;
		ValaSymbol* _tmp13_ = NULL;
		ValaSymbol* _tmp14_ = NULL;
		_tmp11_ = cp;
		_tmp12_ = vala_symbol_get_parent_symbol (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (cp);
		cp = _tmp14_;
	}
	cc = NULL;
	_tmp15_ = path;
	_tmp15__length1 = path_length1;
	{
		gchar** tok_collection = NULL;
		gint tok_collection_length1 = 0;
		gint _tok_collection_size_ = 0;
		gint tok_it = 0;
		tok_collection = _tmp15_;
		tok_collection_length1 = _tmp15__length1;
		for (tok_it = 0; tok_it < _tmp15__length1; tok_it = tok_it + 1) {
			const gchar* tok = NULL;
			tok = tok_collection[tok_it];
			{
				ValaSymbol* _tmp16_ = NULL;
				ValaScope* _tmp17_ = NULL;
				ValaScope* _tmp18_ = NULL;
				const gchar* _tmp19_ = NULL;
				ValaSymbol* _tmp20_ = NULL;
				ValaSymbol* _tmp21_ = NULL;
				ValaSymbol* _tmp22_ = NULL;
				ValaSymbol* _tmp28_ = NULL;
				ValaSymbol* _tmp29_ = NULL;
				_tmp16_ = cp;
				_tmp17_ = vala_symbol_get_scope (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = tok;
				_tmp20_ = vala_scope_lookup (_tmp18_, _tmp19_);
				_tmp21_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_SYMBOL) ? ((ValaSymbol*) _tmp20_) : NULL;
				if (_tmp21_ == NULL) {
					_vala_code_node_unref0 (_tmp20_);
				}
				_vala_code_node_unref0 (cc);
				cc = _tmp21_;
				_tmp22_ = cc;
				if (_tmp22_ == NULL) {
					const gchar* _tmp23_ = NULL;
					ValaSourceReference* _tmp24_ = NULL;
					ValaNamespace* _tmp25_ = NULL;
					ValaSymbol* _tmp26_ = NULL;
					ValaSymbol* _tmp27_ = NULL;
					_tmp23_ = tok;
					_tmp24_ = self->priv->current_source_reference;
					_tmp25_ = vala_namespace_new (_tmp23_, _tmp24_);
					_vala_code_node_unref0 (cc);
					cc = (ValaSymbol*) _tmp25_;
					_tmp26_ = cp;
					_tmp27_ = cc;
					vala_gidl_parser_add_symbol_to_container (self, _tmp26_, _tmp27_);
				}
				_tmp28_ = cc;
				_tmp29_ = _vala_code_node_ref0 (_tmp28_);
				_vala_code_node_unref0 (cp);
				cp = _tmp29_;
			}
		}
	}
	result = cc;
	_vala_code_node_unref0 (cp);
	path = (_vala_array_free (path, path_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void _vala_code_node_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static void _g_list_free__vala_code_node_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _vala_code_node_unref0_, NULL);
	g_list_free (self);
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaNamespace* vala_gidl_parser_parse_module (ValaGIdlParser* self, GIdlModule* module) {
	ValaNamespace* result = NULL;
	ValaSymbol* sym = NULL;
	ValaCodeContext* _tmp0_ = NULL;
	ValaNamespace* _tmp1_ = NULL;
	ValaNamespace* _tmp2_ = NULL;
	ValaScope* _tmp3_ = NULL;
	ValaScope* _tmp4_ = NULL;
	GIdlModule* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ValaSymbol* _tmp7_ = NULL;
	ValaNamespace* ns = NULL;
	ValaSymbol* _tmp8_ = NULL;
	ValaNamespace* _tmp21_ = NULL;
	ValaNamespace* _tmp22_ = NULL;
	gchar** attributes = NULL;
	ValaNamespace* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gchar** _tmp27_ = NULL;
	gint attributes_length1 = 0;
	gint _attributes_size_ = 0;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	ValaArrayList* deferred = NULL;
	GEqualFunc _tmp109_ = NULL;
	ValaArrayList* _tmp110_ = NULL;
	GIdlModule* _tmp111_ = NULL;
	GList* _tmp112_ = NULL;
	ValaSymbol* _tmp167_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (module != NULL, NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = vala_code_context_get_root (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = module;
	_tmp6_ = _tmp5_->name;
	_tmp7_ = vala_scope_lookup (_tmp4_, _tmp6_);
	sym = _tmp7_;
	_tmp8_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_NAMESPACE)) {
		ValaSymbol* _tmp9_ = NULL;
		ValaNamespace* _tmp10_ = NULL;
		ValaNamespace* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp9_ = sym;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_vala_code_node_unref0 (ns);
		ns = _tmp10_;
		_tmp11_ = ns;
		_tmp12_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			ValaNamespace* _tmp14_ = NULL;
			ValaNamespace* _tmp15_ = NULL;
			ValaSourceReference* _tmp16_ = NULL;
			_tmp14_ = ns;
			__g_list_free__vala_code_node_unref0_0 (((ValaCodeNode*) _tmp14_)->attributes);
			((ValaCodeNode*) _tmp14_)->attributes = NULL;
			_tmp15_ = ns;
			_tmp16_ = self->priv->current_source_reference;
			vala_code_node_set_source_reference ((ValaCodeNode*) _tmp15_, _tmp16_);
		}
	} else {
		GIdlModule* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		ValaSourceReference* _tmp19_ = NULL;
		ValaNamespace* _tmp20_ = NULL;
		_tmp17_ = module;
		_tmp18_ = _tmp17_->name;
		_tmp19_ = self->priv->current_source_reference;
		_tmp20_ = vala_namespace_new (_tmp18_, _tmp19_);
		_vala_code_node_unref0 (ns);
		ns = _tmp20_;
	}
	_tmp21_ = ns;
	_tmp22_ = _vala_code_node_ref0 (_tmp21_);
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = _tmp22_;
	_tmp23_ = ns;
	_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp27_ = vala_gidl_parser_get_attributes (self, _tmp25_, &_tmp26_);
	attributes = _tmp27_;
	attributes_length1 = _tmp26_;
	_attributes_size_ = attributes_length1;
	_tmp28_ = attributes;
	_tmp28__length1 = attributes_length1;
	if (_tmp28_ != NULL) {
		gchar** _tmp29_ = NULL;
		gint _tmp29__length1 = 0;
		_tmp29_ = attributes;
		_tmp29__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp29_;
			attr_collection_length1 = _tmp29__length1;
			for (attr_it = 0; attr_it < _tmp29__length1; attr_it = attr_it + 1) {
				gchar* _tmp30_ = NULL;
				gchar* attr = NULL;
				_tmp30_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp30_;
				{
					gchar** nv = NULL;
					const gchar* _tmp31_ = NULL;
					gchar** _tmp32_ = NULL;
					gchar** _tmp33_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gchar** _tmp34_ = NULL;
					gint _tmp34__length1 = 0;
					const gchar* _tmp35_ = NULL;
					_tmp31_ = attr;
					_tmp33_ = _tmp32_ = g_strsplit (_tmp31_, "=", 2);
					nv = _tmp33_;
					nv_length1 = _vala_array_length (_tmp32_);
					_nv_size_ = nv_length1;
					_tmp34_ = nv;
					_tmp34__length1 = nv_length1;
					_tmp35_ = _tmp34_[0];
					if (g_strcmp0 (_tmp35_, "cheader_filename") == 0) {
						ValaNamespace* _tmp36_ = NULL;
						gchar** _tmp37_ = NULL;
						gint _tmp37__length1 = 0;
						const gchar* _tmp38_ = NULL;
						gchar* _tmp39_ = NULL;
						gchar* _tmp40_ = NULL;
						_tmp36_ = ns;
						_tmp37_ = nv;
						_tmp37__length1 = nv_length1;
						_tmp38_ = _tmp37_[1];
						_tmp39_ = vala_gidl_parser_eval (self, _tmp38_);
						_tmp40_ = _tmp39_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp36_, "CCode", "cheader_filename", _tmp40_, NULL);
						_g_free0 (_tmp40_);
					} else {
						gchar** _tmp41_ = NULL;
						gint _tmp41__length1 = 0;
						const gchar* _tmp42_ = NULL;
						_tmp41_ = nv;
						_tmp41__length1 = nv_length1;
						_tmp42_ = _tmp41_[0];
						if (g_strcmp0 (_tmp42_, "cprefix") == 0) {
							ValaNamespace* _tmp43_ = NULL;
							gchar** _tmp44_ = NULL;
							gint _tmp44__length1 = 0;
							const gchar* _tmp45_ = NULL;
							gchar* _tmp46_ = NULL;
							gchar* _tmp47_ = NULL;
							_tmp43_ = ns;
							_tmp44_ = nv;
							_tmp44__length1 = nv_length1;
							_tmp45_ = _tmp44_[1];
							_tmp46_ = vala_gidl_parser_eval (self, _tmp45_);
							_tmp47_ = _tmp46_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp43_, "CCode", "cprefix", _tmp47_, NULL);
							_g_free0 (_tmp47_);
						} else {
							gchar** _tmp48_ = NULL;
							gint _tmp48__length1 = 0;
							const gchar* _tmp49_ = NULL;
							_tmp48_ = nv;
							_tmp48__length1 = nv_length1;
							_tmp49_ = _tmp48_[0];
							if (g_strcmp0 (_tmp49_, "lower_case_cprefix") == 0) {
								ValaNamespace* _tmp50_ = NULL;
								gchar** _tmp51_ = NULL;
								gint _tmp51__length1 = 0;
								const gchar* _tmp52_ = NULL;
								gchar* _tmp53_ = NULL;
								gchar* _tmp54_ = NULL;
								_tmp50_ = ns;
								_tmp51_ = nv;
								_tmp51__length1 = nv_length1;
								_tmp52_ = _tmp51_[1];
								_tmp53_ = vala_gidl_parser_eval (self, _tmp52_);
								_tmp54_ = _tmp53_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp50_, "CCode", "lower_case_cprefix", _tmp54_, NULL);
								_g_free0 (_tmp54_);
							} else {
								gchar** _tmp55_ = NULL;
								gint _tmp55__length1 = 0;
								const gchar* _tmp56_ = NULL;
								_tmp55_ = nv;
								_tmp55__length1 = nv_length1;
								_tmp56_ = _tmp55_[0];
								if (g_strcmp0 (_tmp56_, "gir_namespace") == 0) {
									ValaNamespace* _tmp57_ = NULL;
									ValaSourceReference* _tmp58_ = NULL;
									ValaSourceReference* _tmp59_ = NULL;
									ValaSourceFile* _tmp60_ = NULL;
									ValaSourceFile* _tmp61_ = NULL;
									gchar** _tmp62_ = NULL;
									gint _tmp62__length1 = 0;
									const gchar* _tmp63_ = NULL;
									gchar* _tmp64_ = NULL;
									gchar* _tmp65_ = NULL;
									ValaNamespace* _tmp66_ = NULL;
									gchar** _tmp67_ = NULL;
									gint _tmp67__length1 = 0;
									const gchar* _tmp68_ = NULL;
									gchar* _tmp69_ = NULL;
									gchar* _tmp70_ = NULL;
									_tmp57_ = ns;
									_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
									_tmp59_ = _tmp58_;
									_tmp60_ = vala_source_reference_get_file (_tmp59_);
									_tmp61_ = _tmp60_;
									_tmp62_ = nv;
									_tmp62__length1 = nv_length1;
									_tmp63_ = _tmp62_[1];
									_tmp64_ = vala_gidl_parser_eval (self, _tmp63_);
									_tmp65_ = _tmp64_;
									vala_source_file_set_gir_namespace (_tmp61_, _tmp65_);
									_g_free0 (_tmp65_);
									_tmp66_ = ns;
									_tmp67_ = nv;
									_tmp67__length1 = nv_length1;
									_tmp68_ = _tmp67_[1];
									_tmp69_ = vala_gidl_parser_eval (self, _tmp68_);
									_tmp70_ = _tmp69_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp66_, "CCode", "gir_namespace", _tmp70_, NULL);
									_g_free0 (_tmp70_);
								} else {
									gchar** _tmp71_ = NULL;
									gint _tmp71__length1 = 0;
									const gchar* _tmp72_ = NULL;
									_tmp71_ = nv;
									_tmp71__length1 = nv_length1;
									_tmp72_ = _tmp71_[0];
									if (g_strcmp0 (_tmp72_, "gir_version") == 0) {
										ValaNamespace* _tmp73_ = NULL;
										ValaSourceReference* _tmp74_ = NULL;
										ValaSourceReference* _tmp75_ = NULL;
										ValaSourceFile* _tmp76_ = NULL;
										ValaSourceFile* _tmp77_ = NULL;
										gchar** _tmp78_ = NULL;
										gint _tmp78__length1 = 0;
										const gchar* _tmp79_ = NULL;
										gchar* _tmp80_ = NULL;
										gchar* _tmp81_ = NULL;
										ValaNamespace* _tmp82_ = NULL;
										gchar** _tmp83_ = NULL;
										gint _tmp83__length1 = 0;
										const gchar* _tmp84_ = NULL;
										gchar* _tmp85_ = NULL;
										gchar* _tmp86_ = NULL;
										_tmp73_ = ns;
										_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
										_tmp75_ = _tmp74_;
										_tmp76_ = vala_source_reference_get_file (_tmp75_);
										_tmp77_ = _tmp76_;
										_tmp78_ = nv;
										_tmp78__length1 = nv_length1;
										_tmp79_ = _tmp78_[1];
										_tmp80_ = vala_gidl_parser_eval (self, _tmp79_);
										_tmp81_ = _tmp80_;
										vala_source_file_set_gir_version (_tmp77_, _tmp81_);
										_g_free0 (_tmp81_);
										_tmp82_ = ns;
										_tmp83_ = nv;
										_tmp83__length1 = nv_length1;
										_tmp84_ = _tmp83_[1];
										_tmp85_ = vala_gidl_parser_eval (self, _tmp84_);
										_tmp86_ = _tmp85_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp82_, "CCode", "gir_version", _tmp86_, NULL);
										_g_free0 (_tmp86_);
									} else {
										gchar** _tmp87_ = NULL;
										gint _tmp87__length1 = 0;
										const gchar* _tmp88_ = NULL;
										_tmp87_ = nv;
										_tmp87__length1 = nv_length1;
										_tmp88_ = _tmp87_[0];
										if (g_strcmp0 (_tmp88_, "deprecated") == 0) {
											gchar** _tmp89_ = NULL;
											gint _tmp89__length1 = 0;
											const gchar* _tmp90_ = NULL;
											gchar* _tmp91_ = NULL;
											gchar* _tmp92_ = NULL;
											gboolean _tmp93_ = FALSE;
											_tmp89_ = nv;
											_tmp89__length1 = nv_length1;
											_tmp90_ = _tmp89_[1];
											_tmp91_ = vala_gidl_parser_eval (self, _tmp90_);
											_tmp92_ = _tmp91_;
											_tmp93_ = g_strcmp0 (_tmp92_, "1") == 0;
											_g_free0 (_tmp92_);
											if (_tmp93_) {
												ValaNamespace* _tmp94_ = NULL;
												_tmp94_ = ns;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp94_, "Version", "deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp95_ = NULL;
											gint _tmp95__length1 = 0;
											const gchar* _tmp96_ = NULL;
											_tmp95_ = nv;
											_tmp95__length1 = nv_length1;
											_tmp96_ = _tmp95_[0];
											if (g_strcmp0 (_tmp96_, "replacement") == 0) {
												ValaNamespace* _tmp97_ = NULL;
												gchar** _tmp98_ = NULL;
												gint _tmp98__length1 = 0;
												const gchar* _tmp99_ = NULL;
												gchar* _tmp100_ = NULL;
												gchar* _tmp101_ = NULL;
												_tmp97_ = ns;
												_tmp98_ = nv;
												_tmp98__length1 = nv_length1;
												_tmp99_ = _tmp98_[1];
												_tmp100_ = vala_gidl_parser_eval (self, _tmp99_);
												_tmp101_ = _tmp100_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp97_, "Version", "replacement", _tmp101_, NULL);
												_g_free0 (_tmp101_);
											} else {
												gchar** _tmp102_ = NULL;
												gint _tmp102__length1 = 0;
												const gchar* _tmp103_ = NULL;
												_tmp102_ = nv;
												_tmp102__length1 = nv_length1;
												_tmp103_ = _tmp102_[0];
												if (g_strcmp0 (_tmp103_, "deprecated_since") == 0) {
													ValaNamespace* _tmp104_ = NULL;
													gchar** _tmp105_ = NULL;
													gint _tmp105__length1 = 0;
													const gchar* _tmp106_ = NULL;
													gchar* _tmp107_ = NULL;
													gchar* _tmp108_ = NULL;
													_tmp104_ = ns;
													_tmp105_ = nv;
													_tmp105__length1 = nv_length1;
													_tmp106_ = _tmp105_[1];
													_tmp107_ = vala_gidl_parser_eval (self, _tmp106_);
													_tmp108_ = _tmp107_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp104_, "Version", "deprecated_since", _tmp108_, NULL);
													_g_free0 (_tmp108_);
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp109_ = g_direct_equal;
	_tmp110_ = vala_array_list_new (G_TYPE_POINTER, NULL, NULL, _tmp109_);
	deferred = _tmp110_;
	_tmp111_ = module;
	_tmp112_ = _tmp111_->entries;
	{
		GList* node_collection = NULL;
		GList* node_it = NULL;
		node_collection = _tmp112_;
		for (node_it = node_collection; node_it != NULL; node_it = node_it->next) {
			GIdlNode* node = NULL;
			node = (GIdlNode*) node_it->data;
			{
				gboolean is_deferred = FALSE;
				gchar** child_attributes = NULL;
				GIdlNode* _tmp113_ = NULL;
				gint _tmp114_ = 0;
				gchar** _tmp115_ = NULL;
				gint child_attributes_length1 = 0;
				gint _child_attributes_size_ = 0;
				gchar** _tmp116_ = NULL;
				gint _tmp116__length1 = 0;
				gboolean _tmp125_ = FALSE;
				is_deferred = FALSE;
				_tmp113_ = node;
				_tmp115_ = vala_gidl_parser_get_attributes_for_node (self, _tmp113_, &_tmp114_);
				child_attributes = _tmp115_;
				child_attributes_length1 = _tmp114_;
				_child_attributes_size_ = child_attributes_length1;
				_tmp116_ = child_attributes;
				_tmp116__length1 = child_attributes_length1;
				if (_tmp116_ != NULL) {
					gchar** _tmp117_ = NULL;
					gint _tmp117__length1 = 0;
					_tmp117_ = child_attributes;
					_tmp117__length1 = child_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp117_;
						attr_collection_length1 = _tmp117__length1;
						for (attr_it = 0; attr_it < _tmp117__length1; attr_it = attr_it + 1) {
							const gchar* attr = NULL;
							attr = attr_collection[attr_it];
							{
								gchar** nv = NULL;
								const gchar* _tmp118_ = NULL;
								gchar** _tmp119_ = NULL;
								gchar** _tmp120_ = NULL;
								gint nv_length1 = 0;
								gint _nv_size_ = 0;
								gchar** _tmp121_ = NULL;
								gint _tmp121__length1 = 0;
								const gchar* _tmp122_ = NULL;
								_tmp118_ = attr;
								_tmp120_ = _tmp119_ = g_strsplit (_tmp118_, "=", 2);
								nv = _tmp120_;
								nv_length1 = _vala_array_length (_tmp119_);
								_nv_size_ = nv_length1;
								_tmp121_ = nv;
								_tmp121__length1 = nv_length1;
								_tmp122_ = _tmp121_[0];
								if (g_strcmp0 (_tmp122_, "parent") == 0) {
									ValaArrayList* _tmp123_ = NULL;
									GIdlNode* _tmp124_ = NULL;
									_tmp123_ = deferred;
									_tmp124_ = node;
									vala_collection_add ((ValaCollection*) _tmp123_, _tmp124_);
									is_deferred = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							}
						}
					}
				}
				_tmp125_ = is_deferred;
				if (!_tmp125_) {
					GIdlNode* _tmp126_ = NULL;
					GIdlModule* _tmp127_ = NULL;
					ValaNamespace* _tmp128_ = NULL;
					_tmp126_ = node;
					_tmp127_ = module;
					_tmp128_ = ns;
					vala_gidl_parser_parse_node (self, _tmp126_, _tmp127_, (ValaSymbol*) _tmp128_);
				}
				child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp129_ = NULL;
		ValaArrayList* _tmp130_ = NULL;
		gint _node_size = 0;
		ValaArrayList* _tmp131_ = NULL;
		gint _tmp132_ = 0;
		gint _tmp133_ = 0;
		gint _node_index = 0;
		_tmp129_ = deferred;
		_tmp130_ = _vala_iterable_ref0 (_tmp129_);
		_node_list = _tmp130_;
		_tmp131_ = _node_list;
		_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
		_tmp133_ = _tmp132_;
		_node_size = _tmp133_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp134_ = 0;
			gint _tmp135_ = 0;
			gint _tmp136_ = 0;
			GIdlNode* node = NULL;
			ValaArrayList* _tmp137_ = NULL;
			gint _tmp138_ = 0;
			gpointer _tmp139_ = NULL;
			ValaSymbol* container = NULL;
			ValaNamespace* _tmp140_ = NULL;
			ValaSymbol* _tmp141_ = NULL;
			gchar** child_attributes = NULL;
			GIdlNode* _tmp142_ = NULL;
			gint _tmp143_ = 0;
			gchar** _tmp144_ = NULL;
			gint child_attributes_length1 = 0;
			gint _child_attributes_size_ = 0;
			gchar** _tmp145_ = NULL;
			gint _tmp145__length1 = 0;
			ValaSymbol* _tmp157_ = NULL;
			GIdlNode* _tmp162_ = NULL;
			GIdlModule* _tmp163_ = NULL;
			ValaSymbol* _tmp164_ = NULL;
			ValaNamespace* _tmp165_ = NULL;
			ValaNamespace* _tmp166_ = NULL;
			_tmp134_ = _node_index;
			_node_index = _tmp134_ + 1;
			_tmp135_ = _node_index;
			_tmp136_ = _node_size;
			if (!(_tmp135_ < _tmp136_)) {
				break;
			}
			_tmp137_ = _node_list;
			_tmp138_ = _node_index;
			_tmp139_ = vala_list_get ((ValaList*) _tmp137_, _tmp138_);
			node = (GIdlNode*) _tmp139_;
			_tmp140_ = ns;
			_tmp141_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp140_);
			container = _tmp141_;
			_tmp142_ = node;
			_tmp144_ = vala_gidl_parser_get_attributes_for_node (self, _tmp142_, &_tmp143_);
			child_attributes = _tmp144_;
			child_attributes_length1 = _tmp143_;
			_child_attributes_size_ = child_attributes_length1;
			_tmp145_ = child_attributes;
			_tmp145__length1 = child_attributes_length1;
			if (_tmp145_ != NULL) {
				gchar** _tmp146_ = NULL;
				gint _tmp146__length1 = 0;
				_tmp146_ = child_attributes;
				_tmp146__length1 = child_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp146_;
					attr_collection_length1 = _tmp146__length1;
					for (attr_it = 0; attr_it < _tmp146__length1; attr_it = attr_it + 1) {
						const gchar* attr = NULL;
						attr = attr_collection[attr_it];
						{
							gchar** nv = NULL;
							const gchar* _tmp147_ = NULL;
							gchar** _tmp148_ = NULL;
							gchar** _tmp149_ = NULL;
							gint nv_length1 = 0;
							gint _nv_size_ = 0;
							gchar** _tmp150_ = NULL;
							gint _tmp150__length1 = 0;
							const gchar* _tmp151_ = NULL;
							_tmp147_ = attr;
							_tmp149_ = _tmp148_ = g_strsplit (_tmp147_, "=", 2);
							nv = _tmp149_;
							nv_length1 = _vala_array_length (_tmp148_);
							_nv_size_ = nv_length1;
							_tmp150_ = nv;
							_tmp150__length1 = nv_length1;
							_tmp151_ = _tmp150_[0];
							if (g_strcmp0 (_tmp151_, "parent") == 0) {
								gchar** _tmp152_ = NULL;
								gint _tmp152__length1 = 0;
								const gchar* _tmp153_ = NULL;
								gchar* _tmp154_ = NULL;
								gchar* _tmp155_ = NULL;
								ValaSymbol* _tmp156_ = NULL;
								_tmp152_ = nv;
								_tmp152__length1 = nv_length1;
								_tmp153_ = _tmp152_[1];
								_tmp154_ = vala_gidl_parser_eval (self, _tmp153_);
								_tmp155_ = _tmp154_;
								_tmp156_ = vala_gidl_parser_get_container_from_name (self, _tmp155_);
								_vala_code_node_unref0 (container);
								container = _tmp156_;
								_g_free0 (_tmp155_);
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						}
					}
				}
			}
			_tmp157_ = container;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp157_, VALA_TYPE_NAMESPACE)) {
				ValaSymbol* _tmp158_ = NULL;
				ValaNamespace* _tmp159_ = NULL;
				_tmp158_ = container;
				_tmp159_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, VALA_TYPE_NAMESPACE, ValaNamespace));
				_vala_code_node_unref0 (self->priv->current_namespace);
				self->priv->current_namespace = _tmp159_;
			} else {
				ValaSymbol* _tmp160_ = NULL;
				ValaTypeSymbol* _tmp161_ = NULL;
				_tmp160_ = container;
				_tmp161_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (self->priv->current_data_type);
				self->priv->current_data_type = _tmp161_;
			}
			_tmp162_ = node;
			_tmp163_ = module;
			_tmp164_ = container;
			vala_gidl_parser_parse_node (self, _tmp162_, _tmp163_, _tmp164_);
			_tmp165_ = ns;
			_tmp166_ = _vala_code_node_ref0 (_tmp165_);
			_vala_code_node_unref0 (self->priv->current_namespace);
			self->priv->current_namespace = _tmp166_;
			_vala_code_node_unref0 (self->priv->current_data_type);
			self->priv->current_data_type = NULL;
			child_attributes = (_vala_array_free (child_attributes, child_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (container);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_vala_code_node_unref0 (self->priv->current_namespace);
	self->priv->current_namespace = NULL;
	_tmp167_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp167_, VALA_TYPE_NAMESPACE)) {
		result = NULL;
		_vala_iterable_unref0 (deferred);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (ns);
		_vala_code_node_unref0 (sym);
		return result;
	}
	result = ns;
	_vala_iterable_unref0 (deferred);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (sym);
	return result;
}


static gdouble double_parse (const gchar* str) {
	gdouble result = 0.0;
	const gchar* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	g_return_val_if_fail (str != NULL, 0.0);
	_tmp0_ = str;
	_tmp1_ = g_ascii_strtod (_tmp0_, NULL);
	result = _tmp1_;
	return result;
}


static ValaDelegate* vala_gidl_parser_parse_delegate (ValaGIdlParser* self, GIdlNodeFunction* f_node) {
	ValaDelegate* result = NULL;
	GIdlNode* node = NULL;
	GIdlNodeFunction* _tmp0_ = NULL;
	ValaDataType* return_type = NULL;
	GIdlNodeFunction* _tmp1_ = NULL;
	GIdlNodeParam* _tmp2_ = NULL;
	ValaDataType* _tmp3_ = NULL;
	ValaDelegate* cb = NULL;
	GIdlNode* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ValaDataType* _tmp6_ = NULL;
	ValaSourceReference* _tmp7_ = NULL;
	ValaDelegate* _tmp8_ = NULL;
	ValaDelegate* _tmp9_ = NULL;
	ValaDelegate* _tmp10_ = NULL;
	gboolean check_has_target = FALSE;
	gboolean suppress_throws = FALSE;
	gchar* error_types = NULL;
	gchar** attributes = NULL;
	GIdlNode* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar** _tmp14_ = NULL;
	gint attributes_length1 = 0;
	gint _attributes_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	guint remaining_params = 0U;
	GIdlNodeFunction* _tmp162_ = NULL;
	GList* _tmp163_ = NULL;
	guint _tmp164_ = 0U;
	GIdlNodeFunction* _tmp165_ = NULL;
	GList* _tmp166_ = NULL;
	gboolean _tmp347_ = FALSE;
	gboolean _tmp348_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f_node != NULL, NULL);
	_tmp0_ = f_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = f_node;
	_tmp2_ = _tmp1_->result;
	_tmp3_ = vala_gidl_parser_parse_param (self, _tmp2_, NULL);
	return_type = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = _tmp4_->name;
	_tmp6_ = return_type;
	_tmp7_ = self->priv->current_source_reference;
	_tmp8_ = vala_delegate_new (_tmp5_, _tmp6_, _tmp7_, NULL);
	cb = _tmp8_;
	_tmp9_ = cb;
	vala_symbol_set_access ((ValaSymbol*) _tmp9_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp10_ = cb;
	vala_delegate_set_has_target (_tmp10_, FALSE);
	check_has_target = TRUE;
	suppress_throws = FALSE;
	error_types = NULL;
	_tmp11_ = node;
	_tmp12_ = _tmp11_->name;
	_tmp14_ = vala_gidl_parser_get_attributes (self, _tmp12_, &_tmp13_);
	attributes = _tmp14_;
	attributes_length1 = _tmp13_;
	_attributes_size_ = attributes_length1;
	_tmp15_ = attributes;
	_tmp15__length1 = attributes_length1;
	if (_tmp15_ != NULL) {
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		_tmp16_ = attributes;
		_tmp16__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp16_;
			attr_collection_length1 = _tmp16__length1;
			for (attr_it = 0; attr_it < _tmp16__length1; attr_it = attr_it + 1) {
				gchar* _tmp17_ = NULL;
				gchar* attr = NULL;
				_tmp17_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp17_;
				{
					gchar** nv = NULL;
					const gchar* _tmp18_ = NULL;
					gchar** _tmp19_ = NULL;
					gchar** _tmp20_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					_tmp18_ = attr;
					_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "=", 2);
					nv = _tmp20_;
					nv_length1 = _vala_array_length (_tmp19_);
					_nv_size_ = nv_length1;
					_tmp21_ = nv;
					_tmp21__length1 = nv_length1;
					_tmp22_ = _tmp21_[0];
					if (g_strcmp0 (_tmp22_, "hidden") == 0) {
						gchar** _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						const gchar* _tmp24_ = NULL;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gboolean _tmp27_ = FALSE;
						_tmp23_ = nv;
						_tmp23__length1 = nv_length1;
						_tmp24_ = _tmp23_[1];
						_tmp25_ = vala_gidl_parser_eval (self, _tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = g_strcmp0 (_tmp26_, "1") == 0;
						_g_free0 (_tmp26_);
						if (_tmp27_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (error_types);
							_vala_code_node_unref0 (cb);
							_vala_code_node_unref0 (return_type);
							return result;
						}
					} else {
						gchar** _tmp28_ = NULL;
						gint _tmp28__length1 = 0;
						const gchar* _tmp29_ = NULL;
						_tmp28_ = nv;
						_tmp28__length1 = nv_length1;
						_tmp29_ = _tmp28_[0];
						if (g_strcmp0 (_tmp29_, "cheader_filename") == 0) {
							ValaDelegate* _tmp30_ = NULL;
							gchar** _tmp31_ = NULL;
							gint _tmp31__length1 = 0;
							const gchar* _tmp32_ = NULL;
							gchar* _tmp33_ = NULL;
							gchar* _tmp34_ = NULL;
							_tmp30_ = cb;
							_tmp31_ = nv;
							_tmp31__length1 = nv_length1;
							_tmp32_ = _tmp31_[1];
							_tmp33_ = vala_gidl_parser_eval (self, _tmp32_);
							_tmp34_ = _tmp33_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp30_, "CCode", "cheader_filename", _tmp34_, NULL);
							_g_free0 (_tmp34_);
						} else {
							gchar** _tmp35_ = NULL;
							gint _tmp35__length1 = 0;
							const gchar* _tmp36_ = NULL;
							_tmp35_ = nv;
							_tmp35__length1 = nv_length1;
							_tmp36_ = _tmp35_[0];
							if (g_strcmp0 (_tmp36_, "has_target") == 0) {
								gchar** _tmp37_ = NULL;
								gint _tmp37__length1 = 0;
								const gchar* _tmp38_ = NULL;
								gchar* _tmp39_ = NULL;
								gchar* _tmp40_ = NULL;
								gboolean _tmp41_ = FALSE;
								_tmp37_ = nv;
								_tmp37__length1 = nv_length1;
								_tmp38_ = _tmp37_[1];
								_tmp39_ = vala_gidl_parser_eval (self, _tmp38_);
								_tmp40_ = _tmp39_;
								_tmp41_ = g_strcmp0 (_tmp40_, "0") == 0;
								_g_free0 (_tmp40_);
								if (_tmp41_) {
									check_has_target = FALSE;
								} else {
									gchar** _tmp42_ = NULL;
									gint _tmp42__length1 = 0;
									const gchar* _tmp43_ = NULL;
									gchar* _tmp44_ = NULL;
									gchar* _tmp45_ = NULL;
									gboolean _tmp46_ = FALSE;
									_tmp42_ = nv;
									_tmp42__length1 = nv_length1;
									_tmp43_ = _tmp42_[1];
									_tmp44_ = vala_gidl_parser_eval (self, _tmp43_);
									_tmp45_ = _tmp44_;
									_tmp46_ = g_strcmp0 (_tmp45_, "1") == 0;
									_g_free0 (_tmp45_);
									if (_tmp46_) {
										ValaDelegate* _tmp47_ = NULL;
										_tmp47_ = cb;
										vala_delegate_set_has_target (_tmp47_, TRUE);
									}
								}
							} else {
								gchar** _tmp48_ = NULL;
								gint _tmp48__length1 = 0;
								const gchar* _tmp49_ = NULL;
								_tmp48_ = nv;
								_tmp48__length1 = nv_length1;
								_tmp49_ = _tmp48_[0];
								if (g_strcmp0 (_tmp49_, "transfer_ownership") == 0) {
									gchar** _tmp50_ = NULL;
									gint _tmp50__length1 = 0;
									const gchar* _tmp51_ = NULL;
									gchar* _tmp52_ = NULL;
									gchar* _tmp53_ = NULL;
									gboolean _tmp54_ = FALSE;
									_tmp50_ = nv;
									_tmp50__length1 = nv_length1;
									_tmp51_ = _tmp50_[1];
									_tmp52_ = vala_gidl_parser_eval (self, _tmp51_);
									_tmp53_ = _tmp52_;
									_tmp54_ = g_strcmp0 (_tmp53_, "1") == 0;
									_g_free0 (_tmp53_);
									if (_tmp54_) {
										ValaDataType* _tmp55_ = NULL;
										_tmp55_ = return_type;
										vala_data_type_set_value_owned (_tmp55_, TRUE);
									}
								} else {
									gchar** _tmp56_ = NULL;
									gint _tmp56__length1 = 0;
									const gchar* _tmp57_ = NULL;
									_tmp56_ = nv;
									_tmp56__length1 = nv_length1;
									_tmp57_ = _tmp56_[0];
									if (g_strcmp0 (_tmp57_, "is_array") == 0) {
										gchar** _tmp58_ = NULL;
										gint _tmp58__length1 = 0;
										const gchar* _tmp59_ = NULL;
										gchar* _tmp60_ = NULL;
										gchar* _tmp61_ = NULL;
										gboolean _tmp62_ = FALSE;
										_tmp58_ = nv;
										_tmp58__length1 = nv_length1;
										_tmp59_ = _tmp58_[1];
										_tmp60_ = vala_gidl_parser_eval (self, _tmp59_);
										_tmp61_ = _tmp60_;
										_tmp62_ = g_strcmp0 (_tmp61_, "1") == 0;
										_g_free0 (_tmp61_);
										if (_tmp62_) {
											ValaDataType* _tmp63_ = NULL;
											ValaDataType* _tmp64_ = NULL;
											ValaDataType* _tmp65_ = NULL;
											ValaSourceReference* _tmp66_ = NULL;
											ValaSourceReference* _tmp67_ = NULL;
											ValaArrayType* _tmp68_ = NULL;
											ValaDelegate* _tmp69_ = NULL;
											ValaDataType* _tmp70_ = NULL;
											_tmp63_ = return_type;
											vala_data_type_set_value_owned (_tmp63_, TRUE);
											_tmp64_ = return_type;
											_tmp65_ = return_type;
											_tmp66_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp65_);
											_tmp67_ = _tmp66_;
											_tmp68_ = vala_array_type_new (_tmp64_, 1, _tmp67_);
											_vala_code_node_unref0 (return_type);
											return_type = (ValaDataType*) _tmp68_;
											_tmp69_ = cb;
											_tmp70_ = return_type;
											vala_delegate_set_return_type (_tmp69_, _tmp70_);
										}
									} else {
										gchar** _tmp71_ = NULL;
										gint _tmp71__length1 = 0;
										const gchar* _tmp72_ = NULL;
										_tmp71_ = nv;
										_tmp71__length1 = nv_length1;
										_tmp72_ = _tmp71_[0];
										if (g_strcmp0 (_tmp72_, "throws") == 0) {
											gchar** _tmp73_ = NULL;
											gint _tmp73__length1 = 0;
											const gchar* _tmp74_ = NULL;
											gchar* _tmp75_ = NULL;
											gchar* _tmp76_ = NULL;
											gboolean _tmp77_ = FALSE;
											_tmp73_ = nv;
											_tmp73__length1 = nv_length1;
											_tmp74_ = _tmp73_[1];
											_tmp75_ = vala_gidl_parser_eval (self, _tmp74_);
											_tmp76_ = _tmp75_;
											_tmp77_ = g_strcmp0 (_tmp76_, "0") == 0;
											_g_free0 (_tmp76_);
											if (_tmp77_) {
												suppress_throws = TRUE;
											}
										} else {
											gchar** _tmp78_ = NULL;
											gint _tmp78__length1 = 0;
											const gchar* _tmp79_ = NULL;
											_tmp78_ = nv;
											_tmp78__length1 = nv_length1;
											_tmp79_ = _tmp78_[0];
											if (g_strcmp0 (_tmp79_, "error_types") == 0) {
												gchar** _tmp80_ = NULL;
												gint _tmp80__length1 = 0;
												const gchar* _tmp81_ = NULL;
												gchar* _tmp82_ = NULL;
												_tmp80_ = nv;
												_tmp80__length1 = nv_length1;
												_tmp81_ = _tmp80_[1];
												_tmp82_ = vala_gidl_parser_eval (self, _tmp81_);
												_g_free0 (error_types);
												error_types = _tmp82_;
											} else {
												gchar** _tmp83_ = NULL;
												gint _tmp83__length1 = 0;
												const gchar* _tmp84_ = NULL;
												_tmp83_ = nv;
												_tmp83__length1 = nv_length1;
												_tmp84_ = _tmp83_[0];
												if (g_strcmp0 (_tmp84_, "array_length_type") == 0) {
													ValaDelegate* _tmp85_ = NULL;
													gchar** _tmp86_ = NULL;
													gint _tmp86__length1 = 0;
													const gchar* _tmp87_ = NULL;
													gchar* _tmp88_ = NULL;
													gchar* _tmp89_ = NULL;
													_tmp85_ = cb;
													_tmp86_ = nv;
													_tmp86__length1 = nv_length1;
													_tmp87_ = _tmp86_[1];
													_tmp88_ = vala_gidl_parser_eval (self, _tmp87_);
													_tmp89_ = _tmp88_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp85_, "CCode", "array_length_type", _tmp89_, NULL);
													_g_free0 (_tmp89_);
												} else {
													gchar** _tmp90_ = NULL;
													gint _tmp90__length1 = 0;
													const gchar* _tmp91_ = NULL;
													_tmp90_ = nv;
													_tmp90__length1 = nv_length1;
													_tmp91_ = _tmp90_[0];
													if (g_strcmp0 (_tmp91_, "type_name") == 0) {
														ValaDelegate* _tmp92_ = NULL;
														gchar** _tmp93_ = NULL;
														gint _tmp93__length1 = 0;
														const gchar* _tmp94_ = NULL;
														gchar* _tmp95_ = NULL;
														gchar* _tmp96_ = NULL;
														ValaDataType* _tmp97_ = NULL;
														gboolean _tmp98_ = FALSE;
														gboolean _tmp99_ = FALSE;
														ValaDataType* _tmp100_ = NULL;
														ValaDataType* _tmp101_ = NULL;
														_tmp92_ = cb;
														_tmp93_ = nv;
														_tmp93__length1 = nv_length1;
														_tmp94_ = _tmp93_[1];
														_tmp95_ = vala_gidl_parser_eval (self, _tmp94_);
														_tmp96_ = _tmp95_;
														_tmp97_ = return_type;
														_tmp98_ = vala_data_type_get_value_owned (_tmp97_);
														_tmp99_ = _tmp98_;
														_tmp100_ = vala_gidl_parser_parse_type_from_string (self, _tmp96_, _tmp99_, NULL);
														_vala_code_node_unref0 (return_type);
														return_type = _tmp100_;
														_tmp101_ = return_type;
														vala_delegate_set_return_type (_tmp92_, _tmp101_);
														_g_free0 (_tmp96_);
													} else {
														gchar** _tmp102_ = NULL;
														gint _tmp102__length1 = 0;
														const gchar* _tmp103_ = NULL;
														_tmp102_ = nv;
														_tmp102__length1 = nv_length1;
														_tmp103_ = _tmp102_[0];
														if (g_strcmp0 (_tmp103_, "deprecated") == 0) {
															gchar** _tmp104_ = NULL;
															gint _tmp104__length1 = 0;
															const gchar* _tmp105_ = NULL;
															gchar* _tmp106_ = NULL;
															gchar* _tmp107_ = NULL;
															gboolean _tmp108_ = FALSE;
															_tmp104_ = nv;
															_tmp104__length1 = nv_length1;
															_tmp105_ = _tmp104_[1];
															_tmp106_ = vala_gidl_parser_eval (self, _tmp105_);
															_tmp107_ = _tmp106_;
															_tmp108_ = g_strcmp0 (_tmp107_, "1") == 0;
															_g_free0 (_tmp107_);
															if (_tmp108_) {
																ValaDelegate* _tmp109_ = NULL;
																_tmp109_ = cb;
																vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp109_, "Version", "deprecated", TRUE, NULL);
															}
														} else {
															gchar** _tmp110_ = NULL;
															gint _tmp110__length1 = 0;
															const gchar* _tmp111_ = NULL;
															_tmp110_ = nv;
															_tmp110__length1 = nv_length1;
															_tmp111_ = _tmp110_[0];
															if (g_strcmp0 (_tmp111_, "replacement") == 0) {
																ValaDelegate* _tmp112_ = NULL;
																gchar** _tmp113_ = NULL;
																gint _tmp113__length1 = 0;
																const gchar* _tmp114_ = NULL;
																gchar* _tmp115_ = NULL;
																gchar* _tmp116_ = NULL;
																_tmp112_ = cb;
																_tmp113_ = nv;
																_tmp113__length1 = nv_length1;
																_tmp114_ = _tmp113_[1];
																_tmp115_ = vala_gidl_parser_eval (self, _tmp114_);
																_tmp116_ = _tmp115_;
																vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp112_, "Version", "replacement", _tmp116_, NULL);
																_g_free0 (_tmp116_);
															} else {
																gchar** _tmp117_ = NULL;
																gint _tmp117__length1 = 0;
																const gchar* _tmp118_ = NULL;
																_tmp117_ = nv;
																_tmp117__length1 = nv_length1;
																_tmp118_ = _tmp117_[0];
																if (g_strcmp0 (_tmp118_, "deprecated_since") == 0) {
																	ValaDelegate* _tmp119_ = NULL;
																	gchar** _tmp120_ = NULL;
																	gint _tmp120__length1 = 0;
																	const gchar* _tmp121_ = NULL;
																	gchar* _tmp122_ = NULL;
																	gchar* _tmp123_ = NULL;
																	_tmp119_ = cb;
																	_tmp120_ = nv;
																	_tmp120__length1 = nv_length1;
																	_tmp121_ = _tmp120_[1];
																	_tmp122_ = vala_gidl_parser_eval (self, _tmp121_);
																	_tmp123_ = _tmp122_;
																	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp119_, "Version", "deprecated_since", _tmp123_, NULL);
																	_g_free0 (_tmp123_);
																} else {
																	gchar** _tmp124_ = NULL;
																	gint _tmp124__length1 = 0;
																	const gchar* _tmp125_ = NULL;
																	_tmp124_ = nv;
																	_tmp124__length1 = nv_length1;
																	_tmp125_ = _tmp124_[0];
																	if (g_strcmp0 (_tmp125_, "type_arguments") == 0) {
																		ValaDataType* _tmp126_ = NULL;
																		gchar** _tmp127_ = NULL;
																		gint _tmp127__length1 = 0;
																		const gchar* _tmp128_ = NULL;
																		gchar* _tmp129_ = NULL;
																		gchar* _tmp130_ = NULL;
																		_tmp126_ = return_type;
																		_tmp127_ = nv;
																		_tmp127__length1 = nv_length1;
																		_tmp128_ = _tmp127_[1];
																		_tmp129_ = vala_gidl_parser_eval (self, _tmp128_);
																		_tmp130_ = _tmp129_;
																		vala_gidl_parser_parse_type_arguments_from_string (self, _tmp126_, _tmp130_, NULL);
																		_g_free0 (_tmp130_);
																	} else {
																		gchar** _tmp131_ = NULL;
																		gint _tmp131__length1 = 0;
																		const gchar* _tmp132_ = NULL;
																		_tmp131_ = nv;
																		_tmp131__length1 = nv_length1;
																		_tmp132_ = _tmp131_[0];
																		if (g_strcmp0 (_tmp132_, "instance_pos") == 0) {
																			ValaDelegate* _tmp133_ = NULL;
																			gchar** _tmp134_ = NULL;
																			gint _tmp134__length1 = 0;
																			const gchar* _tmp135_ = NULL;
																			gchar* _tmp136_ = NULL;
																			gchar* _tmp137_ = NULL;
																			gdouble _tmp138_ = 0.0;
																			_tmp133_ = cb;
																			_tmp134_ = nv;
																			_tmp134__length1 = nv_length1;
																			_tmp135_ = _tmp134_[1];
																			_tmp136_ = vala_gidl_parser_eval (self, _tmp135_);
																			_tmp137_ = _tmp136_;
																			_tmp138_ = double_parse (_tmp137_);
																			vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp133_, "CCode", "instance_pos", _tmp138_, NULL);
																			_g_free0 (_tmp137_);
																		} else {
																			gchar** _tmp139_ = NULL;
																			gint _tmp139__length1 = 0;
																			const gchar* _tmp140_ = NULL;
																			_tmp139_ = nv;
																			_tmp139__length1 = nv_length1;
																			_tmp140_ = _tmp139_[0];
																			if (g_strcmp0 (_tmp140_, "type_parameters") == 0) {
																				gchar** _tmp141_ = NULL;
																				gint _tmp141__length1 = 0;
																				const gchar* _tmp142_ = NULL;
																				gchar* _tmp143_ = NULL;
																				gchar* _tmp144_ = NULL;
																				gchar** _tmp145_ = NULL;
																				gchar** _tmp146_ = NULL;
																				gchar** _tmp147_ = NULL;
																				gint _tmp147__length1 = 0;
																				_tmp141_ = nv;
																				_tmp141__length1 = nv_length1;
																				_tmp142_ = _tmp141_[1];
																				_tmp143_ = vala_gidl_parser_eval (self, _tmp142_);
																				_tmp144_ = _tmp143_;
																				_tmp146_ = _tmp145_ = g_strsplit (_tmp144_, ",", 0);
																				_tmp147_ = _tmp146_;
																				_tmp147__length1 = _vala_array_length (_tmp145_);
																				_g_free0 (_tmp144_);
																				{
																					gchar** type_param_name_collection = NULL;
																					gint type_param_name_collection_length1 = 0;
																					gint _type_param_name_collection_size_ = 0;
																					gint type_param_name_it = 0;
																					type_param_name_collection = _tmp147_;
																					type_param_name_collection_length1 = _tmp147__length1;
																					for (type_param_name_it = 0; type_param_name_it < _tmp147__length1; type_param_name_it = type_param_name_it + 1) {
																						gchar* _tmp148_ = NULL;
																						gchar* type_param_name = NULL;
																						_tmp148_ = g_strdup (type_param_name_collection[type_param_name_it]);
																						type_param_name = _tmp148_;
																						{
																							ValaDelegate* _tmp149_ = NULL;
																							const gchar* _tmp150_ = NULL;
																							ValaSourceReference* _tmp151_ = NULL;
																							ValaTypeParameter* _tmp152_ = NULL;
																							ValaTypeParameter* _tmp153_ = NULL;
																							_tmp149_ = cb;
																							_tmp150_ = type_param_name;
																							_tmp151_ = self->priv->current_source_reference;
																							_tmp152_ = vala_typeparameter_new (_tmp150_, _tmp151_);
																							_tmp153_ = _tmp152_;
																							vala_delegate_add_type_parameter (_tmp149_, _tmp153_);
																							_vala_code_node_unref0 (_tmp153_);
																							_g_free0 (type_param_name);
																						}
																					}
																					type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																				}
																			} else {
																				gchar** _tmp154_ = NULL;
																				gint _tmp154__length1 = 0;
																				const gchar* _tmp155_ = NULL;
																				_tmp154_ = nv;
																				_tmp154__length1 = nv_length1;
																				_tmp155_ = _tmp154_[0];
																				if (g_strcmp0 (_tmp155_, "experimental") == 0) {
																					gchar** _tmp156_ = NULL;
																					gint _tmp156__length1 = 0;
																					const gchar* _tmp157_ = NULL;
																					gchar* _tmp158_ = NULL;
																					gchar* _tmp159_ = NULL;
																					gboolean _tmp160_ = FALSE;
																					_tmp156_ = nv;
																					_tmp156__length1 = nv_length1;
																					_tmp157_ = _tmp156_[1];
																					_tmp158_ = vala_gidl_parser_eval (self, _tmp157_);
																					_tmp159_ = _tmp158_;
																					_tmp160_ = g_strcmp0 (_tmp159_, "1") == 0;
																					_g_free0 (_tmp159_);
																					if (_tmp160_) {
																						ValaDelegate* _tmp161_ = NULL;
																						_tmp161_ = cb;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp161_, "Version", "experimental", TRUE, NULL);
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp162_ = f_node;
	_tmp163_ = _tmp162_->parameters;
	_tmp164_ = g_list_length (_tmp163_);
	remaining_params = _tmp164_;
	_tmp165_ = f_node;
	_tmp166_ = _tmp165_->parameters;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp166_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node = NULL;
				GIdlNodeParam* _tmp167_ = NULL;
				gboolean _tmp168_ = FALSE;
				gboolean _tmp169_ = FALSE;
				gboolean _tmp170_ = FALSE;
				guint _tmp346_ = 0U;
				_tmp167_ = param;
				param_node = (GIdlNode*) _tmp167_;
				_tmp170_ = check_has_target;
				if (_tmp170_) {
					guint _tmp171_ = 0U;
					_tmp171_ = remaining_params;
					_tmp169_ = _tmp171_ == ((guint) 1);
				} else {
					_tmp169_ = FALSE;
				}
				if (_tmp169_) {
					gboolean _tmp172_ = FALSE;
					GIdlNode* _tmp173_ = NULL;
					const gchar* _tmp174_ = NULL;
					_tmp173_ = param_node;
					_tmp174_ = _tmp173_->name;
					if (g_strcmp0 (_tmp174_, "user_data") == 0) {
						_tmp172_ = TRUE;
					} else {
						GIdlNode* _tmp175_ = NULL;
						const gchar* _tmp176_ = NULL;
						_tmp175_ = param_node;
						_tmp176_ = _tmp175_->name;
						_tmp172_ = g_strcmp0 (_tmp176_, "data") == 0;
					}
					_tmp168_ = _tmp172_;
				} else {
					_tmp168_ = FALSE;
				}
				if (_tmp168_) {
					ValaDelegate* _tmp177_ = NULL;
					_tmp177_ = cb;
					vala_delegate_set_has_target (_tmp177_, TRUE);
				} else {
					gboolean _tmp178_ = FALSE;
					gboolean _tmp179_ = FALSE;
					gchar* param_name = NULL;
					GIdlNode* _tmp189_ = NULL;
					const gchar* _tmp190_ = NULL;
					gchar* _tmp191_ = NULL;
					const gchar* _tmp192_ = NULL;
					ValaParameterDirection direction = 0;
					ValaDataType* param_type = NULL;
					GIdlNodeParam* _tmp196_ = NULL;
					ValaParameterDirection _tmp197_ = 0;
					ValaDataType* _tmp198_ = NULL;
					ValaParameter* p = NULL;
					const gchar* _tmp199_ = NULL;
					ValaDataType* _tmp200_ = NULL;
					ValaParameter* _tmp201_ = NULL;
					ValaParameter* _tmp202_ = NULL;
					ValaParameterDirection _tmp203_ = 0;
					gboolean hide_param = FALSE;
					gboolean show_param = FALSE;
					gboolean array_requested = FALSE;
					gboolean out_requested = FALSE;
					GIdlNode* _tmp204_ = NULL;
					const gchar* _tmp205_ = NULL;
					GIdlNode* _tmp206_ = NULL;
					const gchar* _tmp207_ = NULL;
					gchar* _tmp208_ = NULL;
					gchar* _tmp209_ = NULL;
					gint _tmp210_ = 0;
					gchar** _tmp211_ = NULL;
					gchar** _tmp212_ = NULL;
					gint _tmp212__length1 = 0;
					gboolean _tmp341_ = FALSE;
					gboolean _tmp342_ = FALSE;
					_tmp179_ = suppress_throws;
					if (_tmp179_ == FALSE) {
						GIdlNodeParam* _tmp180_ = NULL;
						gboolean _tmp181_ = FALSE;
						_tmp180_ = param;
						_tmp181_ = vala_gidl_parser_param_is_exception (self, _tmp180_);
						_tmp178_ = _tmp181_;
					} else {
						_tmp178_ = FALSE;
					}
					if (_tmp178_) {
						const gchar* _tmp182_ = NULL;
						guint _tmp188_ = 0U;
						_tmp182_ = error_types;
						if (_tmp182_ == NULL) {
							ValaDelegate* _tmp183_ = NULL;
							GIdlNodeParam* _tmp184_ = NULL;
							GIdlNodeType* _tmp185_ = NULL;
							ValaDataType* _tmp186_ = NULL;
							ValaDataType* _tmp187_ = NULL;
							_tmp183_ = cb;
							_tmp184_ = param;
							_tmp185_ = _tmp184_->type;
							_tmp186_ = vala_gidl_parser_parse_type (self, _tmp185_, NULL);
							_tmp187_ = _tmp186_;
							vala_code_node_add_error_type ((ValaCodeNode*) _tmp183_, _tmp187_);
							_vala_code_node_unref0 (_tmp187_);
						}
						_tmp188_ = remaining_params;
						remaining_params = _tmp188_ - 1;
						continue;
					}
					_tmp189_ = param_node;
					_tmp190_ = _tmp189_->name;
					_tmp191_ = g_strdup (_tmp190_);
					param_name = _tmp191_;
					_tmp192_ = param_name;
					if (g_strcmp0 (_tmp192_, "string") == 0) {
						gchar* _tmp193_ = NULL;
						_tmp193_ = g_strdup ("str");
						_g_free0 (param_name);
						param_name = _tmp193_;
					} else {
						const gchar* _tmp194_ = NULL;
						_tmp194_ = param_name;
						if (g_strcmp0 (_tmp194_, "self") == 0) {
							gchar* _tmp195_ = NULL;
							_tmp195_ = g_strdup ("_self");
							_g_free0 (param_name);
							param_name = _tmp195_;
						}
					}
					_tmp196_ = param;
					_tmp198_ = vala_gidl_parser_parse_param (self, _tmp196_, &_tmp197_);
					direction = _tmp197_;
					param_type = _tmp198_;
					_tmp199_ = param_name;
					_tmp200_ = param_type;
					_tmp201_ = vala_parameter_new (_tmp199_, _tmp200_, NULL);
					p = _tmp201_;
					_tmp202_ = p;
					_tmp203_ = direction;
					vala_parameter_set_direction (_tmp202_, _tmp203_);
					hide_param = FALSE;
					show_param = FALSE;
					array_requested = FALSE;
					out_requested = FALSE;
					_tmp204_ = node;
					_tmp205_ = _tmp204_->name;
					_tmp206_ = param_node;
					_tmp207_ = _tmp206_->name;
					_tmp208_ = g_strdup_printf ("%s.%s", _tmp205_, _tmp207_);
					_tmp209_ = _tmp208_;
					_tmp211_ = vala_gidl_parser_get_attributes (self, _tmp209_, &_tmp210_);
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					attributes = _tmp211_;
					attributes_length1 = _tmp210_;
					_attributes_size_ = attributes_length1;
					_g_free0 (_tmp209_);
					_tmp212_ = attributes;
					_tmp212__length1 = attributes_length1;
					if (_tmp212_ != NULL) {
						gchar** _tmp213_ = NULL;
						gint _tmp213__length1 = 0;
						_tmp213_ = attributes;
						_tmp213__length1 = attributes_length1;
						{
							gchar** attr_collection = NULL;
							gint attr_collection_length1 = 0;
							gint _attr_collection_size_ = 0;
							gint attr_it = 0;
							attr_collection = _tmp213_;
							attr_collection_length1 = _tmp213__length1;
							for (attr_it = 0; attr_it < _tmp213__length1; attr_it = attr_it + 1) {
								gchar* _tmp214_ = NULL;
								gchar* attr = NULL;
								_tmp214_ = g_strdup (attr_collection[attr_it]);
								attr = _tmp214_;
								{
									gchar** nv = NULL;
									const gchar* _tmp215_ = NULL;
									gchar** _tmp216_ = NULL;
									gchar** _tmp217_ = NULL;
									gint nv_length1 = 0;
									gint _nv_size_ = 0;
									gchar** _tmp218_ = NULL;
									gint _tmp218__length1 = 0;
									const gchar* _tmp219_ = NULL;
									_tmp215_ = attr;
									_tmp217_ = _tmp216_ = g_strsplit (_tmp215_, "=", 2);
									nv = _tmp217_;
									nv_length1 = _vala_array_length (_tmp216_);
									_nv_size_ = nv_length1;
									_tmp218_ = nv;
									_tmp218__length1 = nv_length1;
									_tmp219_ = _tmp218_[0];
									if (g_strcmp0 (_tmp219_, "hidden") == 0) {
										gchar** _tmp220_ = NULL;
										gint _tmp220__length1 = 0;
										const gchar* _tmp221_ = NULL;
										gchar* _tmp222_ = NULL;
										gchar* _tmp223_ = NULL;
										gboolean _tmp224_ = FALSE;
										_tmp220_ = nv;
										_tmp220__length1 = nv_length1;
										_tmp221_ = _tmp220_[1];
										_tmp222_ = vala_gidl_parser_eval (self, _tmp221_);
										_tmp223_ = _tmp222_;
										_tmp224_ = g_strcmp0 (_tmp223_, "1") == 0;
										_g_free0 (_tmp223_);
										if (_tmp224_) {
											hide_param = TRUE;
										} else {
											gchar** _tmp225_ = NULL;
											gint _tmp225__length1 = 0;
											const gchar* _tmp226_ = NULL;
											gchar* _tmp227_ = NULL;
											gchar* _tmp228_ = NULL;
											gboolean _tmp229_ = FALSE;
											_tmp225_ = nv;
											_tmp225__length1 = nv_length1;
											_tmp226_ = _tmp225_[1];
											_tmp227_ = vala_gidl_parser_eval (self, _tmp226_);
											_tmp228_ = _tmp227_;
											_tmp229_ = g_strcmp0 (_tmp228_, "0") == 0;
											_g_free0 (_tmp228_);
											if (_tmp229_) {
												show_param = TRUE;
											}
										}
									} else {
										gchar** _tmp230_ = NULL;
										gint _tmp230__length1 = 0;
										const gchar* _tmp231_ = NULL;
										_tmp230_ = nv;
										_tmp230__length1 = nv_length1;
										_tmp231_ = _tmp230_[0];
										if (g_strcmp0 (_tmp231_, "is_array") == 0) {
											gchar** _tmp232_ = NULL;
											gint _tmp232__length1 = 0;
											const gchar* _tmp233_ = NULL;
											gchar* _tmp234_ = NULL;
											gchar* _tmp235_ = NULL;
											gboolean _tmp236_ = FALSE;
											_tmp232_ = nv;
											_tmp232__length1 = nv_length1;
											_tmp233_ = _tmp232_[1];
											_tmp234_ = vala_gidl_parser_eval (self, _tmp233_);
											_tmp235_ = _tmp234_;
											_tmp236_ = g_strcmp0 (_tmp235_, "1") == 0;
											_g_free0 (_tmp235_);
											if (_tmp236_) {
												ValaDataType* _tmp237_ = NULL;
												ValaDataType* _tmp238_ = NULL;
												ValaDataType* _tmp239_ = NULL;
												ValaSourceReference* _tmp240_ = NULL;
												ValaSourceReference* _tmp241_ = NULL;
												ValaArrayType* _tmp242_ = NULL;
												ValaParameter* _tmp243_ = NULL;
												ValaDataType* _tmp244_ = NULL;
												gboolean _tmp245_ = FALSE;
												_tmp237_ = param_type;
												vala_data_type_set_value_owned (_tmp237_, TRUE);
												_tmp238_ = param_type;
												_tmp239_ = param_type;
												_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp239_);
												_tmp241_ = _tmp240_;
												_tmp242_ = vala_array_type_new (_tmp238_, 1, _tmp241_);
												_vala_code_node_unref0 (param_type);
												param_type = (ValaDataType*) _tmp242_;
												_tmp243_ = p;
												_tmp244_ = param_type;
												vala_variable_set_variable_type ((ValaVariable*) _tmp243_, _tmp244_);
												_tmp245_ = out_requested;
												if (!_tmp245_) {
													ValaParameter* _tmp246_ = NULL;
													_tmp246_ = p;
													vala_parameter_set_direction (_tmp246_, VALA_PARAMETER_DIRECTION_IN);
												}
												array_requested = TRUE;
											}
										} else {
											gchar** _tmp247_ = NULL;
											gint _tmp247__length1 = 0;
											const gchar* _tmp248_ = NULL;
											_tmp247_ = nv;
											_tmp247__length1 = nv_length1;
											_tmp248_ = _tmp247_[0];
											if (g_strcmp0 (_tmp248_, "is_out") == 0) {
												gchar** _tmp249_ = NULL;
												gint _tmp249__length1 = 0;
												const gchar* _tmp250_ = NULL;
												gchar* _tmp251_ = NULL;
												gchar* _tmp252_ = NULL;
												gboolean _tmp253_ = FALSE;
												_tmp249_ = nv;
												_tmp249__length1 = nv_length1;
												_tmp250_ = _tmp249_[1];
												_tmp251_ = vala_gidl_parser_eval (self, _tmp250_);
												_tmp252_ = _tmp251_;
												_tmp253_ = g_strcmp0 (_tmp252_, "1") == 0;
												_g_free0 (_tmp252_);
												if (_tmp253_) {
													ValaParameter* _tmp254_ = NULL;
													gboolean _tmp255_ = FALSE;
													gboolean _tmp256_ = FALSE;
													_tmp254_ = p;
													vala_parameter_set_direction (_tmp254_, VALA_PARAMETER_DIRECTION_OUT);
													out_requested = TRUE;
													_tmp256_ = array_requested;
													if (!_tmp256_) {
														ValaDataType* _tmp257_ = NULL;
														_tmp257_ = param_type;
														_tmp255_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp257_, VALA_TYPE_ARRAY_TYPE);
													} else {
														_tmp255_ = FALSE;
													}
													if (_tmp255_) {
														ValaArrayType* array_type = NULL;
														ValaDataType* _tmp258_ = NULL;
														ValaArrayType* _tmp259_ = NULL;
														ValaArrayType* _tmp260_ = NULL;
														ValaDataType* _tmp261_ = NULL;
														ValaDataType* _tmp262_ = NULL;
														ValaDataType* _tmp263_ = NULL;
														ValaParameter* _tmp264_ = NULL;
														ValaDataType* _tmp265_ = NULL;
														_tmp258_ = param_type;
														_tmp259_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp258_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
														array_type = _tmp259_;
														_tmp260_ = array_type;
														_tmp261_ = vala_array_type_get_element_type (_tmp260_);
														_tmp262_ = _tmp261_;
														_tmp263_ = _vala_code_node_ref0 (_tmp262_);
														_vala_code_node_unref0 (param_type);
														param_type = _tmp263_;
														_tmp264_ = p;
														_tmp265_ = param_type;
														vala_variable_set_variable_type ((ValaVariable*) _tmp264_, _tmp265_);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												gchar** _tmp266_ = NULL;
												gint _tmp266__length1 = 0;
												const gchar* _tmp267_ = NULL;
												_tmp266_ = nv;
												_tmp266__length1 = nv_length1;
												_tmp267_ = _tmp266_[0];
												if (g_strcmp0 (_tmp267_, "is_ref") == 0) {
													gchar** _tmp268_ = NULL;
													gint _tmp268__length1 = 0;
													const gchar* _tmp269_ = NULL;
													gchar* _tmp270_ = NULL;
													gchar* _tmp271_ = NULL;
													gboolean _tmp272_ = FALSE;
													_tmp268_ = nv;
													_tmp268__length1 = nv_length1;
													_tmp269_ = _tmp268_[1];
													_tmp270_ = vala_gidl_parser_eval (self, _tmp269_);
													_tmp271_ = _tmp270_;
													_tmp272_ = g_strcmp0 (_tmp271_, "1") == 0;
													_g_free0 (_tmp271_);
													if (_tmp272_) {
														ValaParameter* _tmp273_ = NULL;
														gboolean _tmp274_ = FALSE;
														gboolean _tmp275_ = FALSE;
														_tmp273_ = p;
														vala_parameter_set_direction (_tmp273_, VALA_PARAMETER_DIRECTION_REF);
														_tmp275_ = array_requested;
														if (!_tmp275_) {
															ValaDataType* _tmp276_ = NULL;
															_tmp276_ = param_type;
															_tmp274_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp276_, VALA_TYPE_ARRAY_TYPE);
														} else {
															_tmp274_ = FALSE;
														}
														if (_tmp274_) {
															ValaArrayType* array_type = NULL;
															ValaDataType* _tmp277_ = NULL;
															ValaArrayType* _tmp278_ = NULL;
															ValaArrayType* _tmp279_ = NULL;
															ValaDataType* _tmp280_ = NULL;
															ValaDataType* _tmp281_ = NULL;
															ValaDataType* _tmp282_ = NULL;
															ValaParameter* _tmp283_ = NULL;
															ValaDataType* _tmp284_ = NULL;
															_tmp277_ = param_type;
															_tmp278_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp277_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
															array_type = _tmp278_;
															_tmp279_ = array_type;
															_tmp280_ = vala_array_type_get_element_type (_tmp279_);
															_tmp281_ = _tmp280_;
															_tmp282_ = _vala_code_node_ref0 (_tmp281_);
															_vala_code_node_unref0 (param_type);
															param_type = _tmp282_;
															_tmp283_ = p;
															_tmp284_ = param_type;
															vala_variable_set_variable_type ((ValaVariable*) _tmp283_, _tmp284_);
															_vala_code_node_unref0 (array_type);
														}
													}
												} else {
													gchar** _tmp285_ = NULL;
													gint _tmp285__length1 = 0;
													const gchar* _tmp286_ = NULL;
													_tmp285_ = nv;
													_tmp285__length1 = nv_length1;
													_tmp286_ = _tmp285_[0];
													if (g_strcmp0 (_tmp286_, "takes_ownership") == 0) {
														gchar** _tmp287_ = NULL;
														gint _tmp287__length1 = 0;
														const gchar* _tmp288_ = NULL;
														gchar* _tmp289_ = NULL;
														gchar* _tmp290_ = NULL;
														gboolean _tmp291_ = FALSE;
														_tmp287_ = nv;
														_tmp287__length1 = nv_length1;
														_tmp288_ = _tmp287_[1];
														_tmp289_ = vala_gidl_parser_eval (self, _tmp288_);
														_tmp290_ = _tmp289_;
														_tmp291_ = g_strcmp0 (_tmp290_, "1") == 0;
														_g_free0 (_tmp290_);
														if (_tmp291_) {
															ValaDataType* _tmp292_ = NULL;
															_tmp292_ = param_type;
															vala_data_type_set_value_owned (_tmp292_, TRUE);
														}
													} else {
														gchar** _tmp293_ = NULL;
														gint _tmp293__length1 = 0;
														const gchar* _tmp294_ = NULL;
														_tmp293_ = nv;
														_tmp293__length1 = nv_length1;
														_tmp294_ = _tmp293_[0];
														if (g_strcmp0 (_tmp294_, "nullable") == 0) {
															gchar** _tmp295_ = NULL;
															gint _tmp295__length1 = 0;
															const gchar* _tmp296_ = NULL;
															gchar* _tmp297_ = NULL;
															gchar* _tmp298_ = NULL;
															gboolean _tmp299_ = FALSE;
															_tmp295_ = nv;
															_tmp295__length1 = nv_length1;
															_tmp296_ = _tmp295_[1];
															_tmp297_ = vala_gidl_parser_eval (self, _tmp296_);
															_tmp298_ = _tmp297_;
															_tmp299_ = g_strcmp0 (_tmp298_, "1") == 0;
															_g_free0 (_tmp298_);
															if (_tmp299_) {
																ValaDataType* _tmp300_ = NULL;
																_tmp300_ = param_type;
																vala_data_type_set_nullable (_tmp300_, TRUE);
															}
														} else {
															gchar** _tmp301_ = NULL;
															gint _tmp301__length1 = 0;
															const gchar* _tmp302_ = NULL;
															_tmp301_ = nv;
															_tmp301__length1 = nv_length1;
															_tmp302_ = _tmp301_[0];
															if (g_strcmp0 (_tmp302_, "type_arguments") == 0) {
																ValaDataType* _tmp303_ = NULL;
																gchar** _tmp304_ = NULL;
																gint _tmp304__length1 = 0;
																const gchar* _tmp305_ = NULL;
																gchar* _tmp306_ = NULL;
																gchar* _tmp307_ = NULL;
																_tmp303_ = param_type;
																_tmp304_ = nv;
																_tmp304__length1 = nv_length1;
																_tmp305_ = _tmp304_[1];
																_tmp306_ = vala_gidl_parser_eval (self, _tmp305_);
																_tmp307_ = _tmp306_;
																vala_gidl_parser_parse_type_arguments_from_string (self, _tmp303_, _tmp307_, NULL);
																_g_free0 (_tmp307_);
															} else {
																gchar** _tmp308_ = NULL;
																gint _tmp308__length1 = 0;
																const gchar* _tmp309_ = NULL;
																_tmp308_ = nv;
																_tmp308__length1 = nv_length1;
																_tmp309_ = _tmp308_[0];
																if (g_strcmp0 (_tmp309_, "no_array_length") == 0) {
																	gchar** _tmp310_ = NULL;
																	gint _tmp310__length1 = 0;
																	const gchar* _tmp311_ = NULL;
																	gchar* _tmp312_ = NULL;
																	gchar* _tmp313_ = NULL;
																	gboolean _tmp314_ = FALSE;
																	_tmp310_ = nv;
																	_tmp310__length1 = nv_length1;
																	_tmp311_ = _tmp310_[1];
																	_tmp312_ = vala_gidl_parser_eval (self, _tmp311_);
																	_tmp313_ = _tmp312_;
																	_tmp314_ = g_strcmp0 (_tmp313_, "1") == 0;
																	_g_free0 (_tmp313_);
																	if (_tmp314_) {
																		ValaParameter* _tmp315_ = NULL;
																		_tmp315_ = p;
																		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp315_, "CCode", "array_length", FALSE, NULL);
																	}
																} else {
																	gchar** _tmp316_ = NULL;
																	gint _tmp316__length1 = 0;
																	const gchar* _tmp317_ = NULL;
																	_tmp316_ = nv;
																	_tmp316__length1 = nv_length1;
																	_tmp317_ = _tmp316_[0];
																	if (g_strcmp0 (_tmp317_, "array_length_type") == 0) {
																		ValaParameter* _tmp318_ = NULL;
																		gchar** _tmp319_ = NULL;
																		gint _tmp319__length1 = 0;
																		const gchar* _tmp320_ = NULL;
																		gchar* _tmp321_ = NULL;
																		gchar* _tmp322_ = NULL;
																		_tmp318_ = p;
																		_tmp319_ = nv;
																		_tmp319__length1 = nv_length1;
																		_tmp320_ = _tmp319_[1];
																		_tmp321_ = vala_gidl_parser_eval (self, _tmp320_);
																		_tmp322_ = _tmp321_;
																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp318_, "CCode", "array_length_type", _tmp322_, NULL);
																		_g_free0 (_tmp322_);
																	} else {
																		gchar** _tmp323_ = NULL;
																		gint _tmp323__length1 = 0;
																		const gchar* _tmp324_ = NULL;
																		_tmp323_ = nv;
																		_tmp323__length1 = nv_length1;
																		_tmp324_ = _tmp323_[0];
																		if (g_strcmp0 (_tmp324_, "array_null_terminated") == 0) {
																			gchar** _tmp325_ = NULL;
																			gint _tmp325__length1 = 0;
																			const gchar* _tmp326_ = NULL;
																			gchar* _tmp327_ = NULL;
																			gchar* _tmp328_ = NULL;
																			gboolean _tmp329_ = FALSE;
																			_tmp325_ = nv;
																			_tmp325__length1 = nv_length1;
																			_tmp326_ = _tmp325_[1];
																			_tmp327_ = vala_gidl_parser_eval (self, _tmp326_);
																			_tmp328_ = _tmp327_;
																			_tmp329_ = g_strcmp0 (_tmp328_, "1") == 0;
																			_g_free0 (_tmp328_);
																			if (_tmp329_) {
																				ValaParameter* _tmp330_ = NULL;
																				ValaParameter* _tmp331_ = NULL;
																				_tmp330_ = p;
																				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp330_, "CCode", "array_length", FALSE, NULL);
																				_tmp331_ = p;
																				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp331_, "CCode", "array_null_terminated", TRUE, NULL);
																			}
																		} else {
																			gchar** _tmp332_ = NULL;
																			gint _tmp332__length1 = 0;
																			const gchar* _tmp333_ = NULL;
																			_tmp332_ = nv;
																			_tmp332__length1 = nv_length1;
																			_tmp333_ = _tmp332_[0];
																			if (g_strcmp0 (_tmp333_, "type_name") == 0) {
																				ValaParameter* _tmp334_ = NULL;
																				gchar** _tmp335_ = NULL;
																				gint _tmp335__length1 = 0;
																				const gchar* _tmp336_ = NULL;
																				gchar* _tmp337_ = NULL;
																				gchar* _tmp338_ = NULL;
																				ValaDataType* _tmp339_ = NULL;
																				ValaDataType* _tmp340_ = NULL;
																				_tmp334_ = p;
																				_tmp335_ = nv;
																				_tmp335__length1 = nv_length1;
																				_tmp336_ = _tmp335_[1];
																				_tmp337_ = vala_gidl_parser_eval (self, _tmp336_);
																				_tmp338_ = _tmp337_;
																				_tmp339_ = vala_gidl_parser_parse_type_from_string (self, _tmp338_, FALSE, NULL);
																				_vala_code_node_unref0 (param_type);
																				param_type = _tmp339_;
																				_tmp340_ = param_type;
																				vala_variable_set_variable_type ((ValaVariable*) _tmp334_, _tmp340_);
																				_g_free0 (_tmp338_);
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
								}
							}
						}
					}
					_tmp342_ = show_param;
					if (_tmp342_) {
						_tmp341_ = TRUE;
					} else {
						gboolean _tmp343_ = FALSE;
						_tmp343_ = hide_param;
						_tmp341_ = !_tmp343_;
					}
					if (_tmp341_) {
						ValaDelegate* _tmp344_ = NULL;
						ValaParameter* _tmp345_ = NULL;
						_tmp344_ = cb;
						_tmp345_ = p;
						vala_delegate_add_parameter (_tmp344_, _tmp345_);
					}
					_vala_code_node_unref0 (p);
					_vala_code_node_unref0 (param_type);
					_g_free0 (param_name);
				}
				_tmp346_ = remaining_params;
				remaining_params = _tmp346_ - 1;
			}
		}
	}
	_tmp348_ = suppress_throws;
	if (_tmp348_ == FALSE) {
		const gchar* _tmp349_ = NULL;
		_tmp349_ = error_types;
		_tmp347_ = _tmp349_ != NULL;
	} else {
		_tmp347_ = FALSE;
	}
	if (_tmp347_) {
		gchar** type_args = NULL;
		const gchar* _tmp350_ = NULL;
		gchar* _tmp351_ = NULL;
		gchar* _tmp352_ = NULL;
		gchar** _tmp353_ = NULL;
		gchar** _tmp354_ = NULL;
		gchar** _tmp355_ = NULL;
		gint _tmp355__length1 = 0;
		gint type_args_length1 = 0;
		gint _type_args_size_ = 0;
		gchar** _tmp356_ = NULL;
		gint _tmp356__length1 = 0;
		_tmp350_ = error_types;
		_tmp351_ = vala_gidl_parser_eval (self, _tmp350_);
		_tmp352_ = _tmp351_;
		_tmp354_ = _tmp353_ = g_strsplit (_tmp352_, ",", 0);
		_tmp355_ = _tmp354_;
		_tmp355__length1 = _vala_array_length (_tmp353_);
		_g_free0 (_tmp352_);
		type_args = _tmp355_;
		type_args_length1 = _tmp355__length1;
		_type_args_size_ = type_args_length1;
		_tmp356_ = type_args;
		_tmp356__length1 = type_args_length1;
		{
			gchar** type_arg_collection = NULL;
			gint type_arg_collection_length1 = 0;
			gint _type_arg_collection_size_ = 0;
			gint type_arg_it = 0;
			type_arg_collection = _tmp356_;
			type_arg_collection_length1 = _tmp356__length1;
			for (type_arg_it = 0; type_arg_it < _tmp356__length1; type_arg_it = type_arg_it + 1) {
				gchar* _tmp357_ = NULL;
				gchar* type_arg = NULL;
				_tmp357_ = g_strdup (type_arg_collection[type_arg_it]);
				type_arg = _tmp357_;
				{
					ValaDelegate* _tmp358_ = NULL;
					const gchar* _tmp359_ = NULL;
					ValaDataType* _tmp360_ = NULL;
					ValaDataType* _tmp361_ = NULL;
					_tmp358_ = cb;
					_tmp359_ = type_arg;
					_tmp360_ = vala_gidl_parser_parse_type_from_string (self, _tmp359_, TRUE, NULL);
					_tmp361_ = _tmp360_;
					vala_code_node_add_error_type ((ValaCodeNode*) _tmp358_, _tmp361_);
					_vala_code_node_unref0 (_tmp361_);
					_g_free0 (type_arg);
				}
			}
		}
		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
	}
	result = cb;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (error_types);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gboolean vala_gidl_parser_is_reference_type (ValaGIdlParser* self, const gchar* cname) {
	gboolean result = FALSE;
	gchar** st_attributes = NULL;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_ = NULL;
	gint st_attributes_length1 = 0;
	gint _st_attributes_size_ = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cname != NULL, FALSE);
	_tmp0_ = cname;
	_tmp2_ = vala_gidl_parser_get_attributes (self, _tmp0_, &_tmp1_);
	st_attributes = _tmp2_;
	st_attributes_length1 = _tmp1_;
	_st_attributes_size_ = st_attributes_length1;
	_tmp3_ = st_attributes;
	_tmp3__length1 = st_attributes_length1;
	if (_tmp3_ != NULL) {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = st_attributes;
		_tmp4__length1 = st_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp4_;
			attr_collection_length1 = _tmp4__length1;
			for (attr_it = 0; attr_it < _tmp4__length1; attr_it = attr_it + 1) {
				gchar* _tmp5_ = NULL;
				gchar* attr = NULL;
				_tmp5_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp5_;
				{
					gchar** nv = NULL;
					const gchar* _tmp6_ = NULL;
					gchar** _tmp7_ = NULL;
					gchar** _tmp8_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gboolean _tmp9_ = FALSE;
					gchar** _tmp10_ = NULL;
					gint _tmp10__length1 = 0;
					const gchar* _tmp11_ = NULL;
					_tmp6_ = attr;
					_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "=", 2);
					nv = _tmp8_;
					nv_length1 = _vala_array_length (_tmp7_);
					_nv_size_ = nv_length1;
					_tmp10_ = nv;
					_tmp10__length1 = nv_length1;
					_tmp11_ = _tmp10_[0];
					if (g_strcmp0 (_tmp11_, "is_value_type") == 0) {
						gchar** _tmp12_ = NULL;
						gint _tmp12__length1 = 0;
						const gchar* _tmp13_ = NULL;
						gchar* _tmp14_ = NULL;
						gchar* _tmp15_ = NULL;
						_tmp12_ = nv;
						_tmp12__length1 = nv_length1;
						_tmp13_ = _tmp12_[1];
						_tmp14_ = vala_gidl_parser_eval (self, _tmp13_);
						_tmp15_ = _tmp14_;
						_tmp9_ = g_strcmp0 (_tmp15_, "1") == 0;
						_g_free0 (_tmp15_);
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						result = FALSE;
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	result = TRUE;
	st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void vala_gidl_parser_parse_struct (ValaGIdlParser* self, GIdlNodeStruct* st_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node = NULL;
	GIdlNodeStruct* _tmp0_ = NULL;
	GIdlNodeStruct* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* name = NULL;
	GIdlNode* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	ValaSymbol* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GIdlNode* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (st_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = st_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = st_node;
	_tmp2_ = _tmp1_->deprecated;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = container;
	_tmp6_ = vala_gidl_parser_fix_type_name (self, _tmp4_, _tmp5_);
	name = _tmp6_;
	_tmp7_ = node;
	_tmp8_ = _tmp7_->name;
	_tmp9_ = vala_gidl_parser_is_reference_type (self, _tmp8_);
	if (!_tmp9_) {
		ValaStruct* st = NULL;
		ValaSymbol* _tmp10_ = NULL;
		ValaScope* _tmp11_ = NULL;
		ValaScope* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		ValaSymbol* _tmp14_ = NULL;
		ValaStruct* _tmp15_ = NULL;
		ValaStruct* _tmp16_ = NULL;
		ValaStruct* _tmp143_ = NULL;
		ValaTypeSymbol* _tmp144_ = NULL;
		GIdlNodeStruct* _tmp145_ = NULL;
		GList* _tmp146_ = NULL;
		_tmp10_ = container;
		_tmp11_ = vala_symbol_get_scope (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = name;
		_tmp14_ = vala_scope_lookup (_tmp12_, _tmp13_);
		_tmp15_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp14_) : NULL;
		if (_tmp15_ == NULL) {
			_vala_code_node_unref0 (_tmp14_);
		}
		st = _tmp15_;
		_tmp16_ = st;
		if (_tmp16_ == NULL) {
			const gchar* _tmp17_ = NULL;
			ValaSourceReference* _tmp18_ = NULL;
			ValaStruct* _tmp19_ = NULL;
			ValaStruct* _tmp20_ = NULL;
			gchar** st_attributes = NULL;
			GIdlNode* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gchar** _tmp24_ = NULL;
			gint st_attributes_length1 = 0;
			gint _st_attributes_size_ = 0;
			gchar** _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			ValaSymbol* _tmp139_ = NULL;
			ValaStruct* _tmp140_ = NULL;
			ValaSourceFile* _tmp141_ = NULL;
			ValaStruct* _tmp142_ = NULL;
			_tmp17_ = name;
			_tmp18_ = self->priv->current_source_reference;
			_tmp19_ = vala_struct_new (_tmp17_, _tmp18_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp19_;
			_tmp20_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp20_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp21_ = node;
			_tmp22_ = _tmp21_->name;
			_tmp24_ = vala_gidl_parser_get_attributes (self, _tmp22_, &_tmp23_);
			st_attributes = _tmp24_;
			st_attributes_length1 = _tmp23_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp25_ = st_attributes;
			_tmp25__length1 = st_attributes_length1;
			if (_tmp25_ != NULL) {
				gchar** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				_tmp26_ = st_attributes;
				_tmp26__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp26_;
					attr_collection_length1 = _tmp26__length1;
					for (attr_it = 0; attr_it < _tmp26__length1; attr_it = attr_it + 1) {
						gchar* _tmp27_ = NULL;
						gchar* attr = NULL;
						_tmp27_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp27_;
						{
							gchar** nv = NULL;
							const gchar* _tmp28_ = NULL;
							gchar** _tmp29_ = NULL;
							gchar** _tmp30_ = NULL;
							gint nv_length1 = 0;
							gint _nv_size_ = 0;
							gchar** _tmp31_ = NULL;
							gint _tmp31__length1 = 0;
							const gchar* _tmp32_ = NULL;
							_tmp28_ = attr;
							_tmp30_ = _tmp29_ = g_strsplit (_tmp28_, "=", 2);
							nv = _tmp30_;
							nv_length1 = _vala_array_length (_tmp29_);
							_nv_size_ = nv_length1;
							_tmp31_ = nv;
							_tmp31__length1 = nv_length1;
							_tmp32_ = _tmp31_[0];
							if (g_strcmp0 (_tmp32_, "cheader_filename") == 0) {
								ValaStruct* _tmp33_ = NULL;
								gchar** _tmp34_ = NULL;
								gint _tmp34__length1 = 0;
								const gchar* _tmp35_ = NULL;
								gchar* _tmp36_ = NULL;
								gchar* _tmp37_ = NULL;
								_tmp33_ = st;
								_tmp34_ = nv;
								_tmp34__length1 = nv_length1;
								_tmp35_ = _tmp34_[1];
								_tmp36_ = vala_gidl_parser_eval (self, _tmp35_);
								_tmp37_ = _tmp36_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp33_, "CCode", "cheader_filename", _tmp37_, NULL);
								_g_free0 (_tmp37_);
							} else {
								gchar** _tmp38_ = NULL;
								gint _tmp38__length1 = 0;
								const gchar* _tmp39_ = NULL;
								_tmp38_ = nv;
								_tmp38__length1 = nv_length1;
								_tmp39_ = _tmp38_[0];
								if (g_strcmp0 (_tmp39_, "hidden") == 0) {
									gchar** _tmp40_ = NULL;
									gint _tmp40__length1 = 0;
									const gchar* _tmp41_ = NULL;
									gchar* _tmp42_ = NULL;
									gchar* _tmp43_ = NULL;
									gboolean _tmp44_ = FALSE;
									_tmp40_ = nv;
									_tmp40__length1 = nv_length1;
									_tmp41_ = _tmp40_[1];
									_tmp42_ = vala_gidl_parser_eval (self, _tmp41_);
									_tmp43_ = _tmp42_;
									_tmp44_ = g_strcmp0 (_tmp43_, "1") == 0;
									_g_free0 (_tmp43_);
									if (_tmp44_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (st);
										_g_free0 (name);
										return;
									}
								} else {
									gchar** _tmp45_ = NULL;
									gint _tmp45__length1 = 0;
									const gchar* _tmp46_ = NULL;
									_tmp45_ = nv;
									_tmp45__length1 = nv_length1;
									_tmp46_ = _tmp45_[0];
									if (g_strcmp0 (_tmp46_, "base_type") == 0) {
										ValaStruct* _tmp47_ = NULL;
										gchar** _tmp48_ = NULL;
										gint _tmp48__length1 = 0;
										const gchar* _tmp49_ = NULL;
										gchar* _tmp50_ = NULL;
										gchar* _tmp51_ = NULL;
										ValaDataType* _tmp52_ = NULL;
										ValaDataType* _tmp53_ = NULL;
										_tmp47_ = st;
										_tmp48_ = nv;
										_tmp48__length1 = nv_length1;
										_tmp49_ = _tmp48_[1];
										_tmp50_ = vala_gidl_parser_eval (self, _tmp49_);
										_tmp51_ = _tmp50_;
										_tmp52_ = vala_gidl_parser_parse_type_string (self, _tmp51_);
										_tmp53_ = _tmp52_;
										vala_struct_set_base_type (_tmp47_, _tmp53_);
										_vala_code_node_unref0 (_tmp53_);
										_g_free0 (_tmp51_);
									} else {
										gchar** _tmp54_ = NULL;
										gint _tmp54__length1 = 0;
										const gchar* _tmp55_ = NULL;
										_tmp54_ = nv;
										_tmp54__length1 = nv_length1;
										_tmp55_ = _tmp54_[0];
										if (g_strcmp0 (_tmp55_, "rank") == 0) {
											ValaStruct* _tmp56_ = NULL;
											gchar** _tmp57_ = NULL;
											gint _tmp57__length1 = 0;
											const gchar* _tmp58_ = NULL;
											gchar* _tmp59_ = NULL;
											gchar* _tmp60_ = NULL;
											gint _tmp61_ = 0;
											_tmp56_ = st;
											_tmp57_ = nv;
											_tmp57__length1 = nv_length1;
											_tmp58_ = _tmp57_[1];
											_tmp59_ = vala_gidl_parser_eval (self, _tmp58_);
											_tmp60_ = _tmp59_;
											_tmp61_ = atoi (_tmp60_);
											vala_struct_set_rank (_tmp56_, _tmp61_);
											_g_free0 (_tmp60_);
										} else {
											gchar** _tmp62_ = NULL;
											gint _tmp62__length1 = 0;
											const gchar* _tmp63_ = NULL;
											_tmp62_ = nv;
											_tmp62__length1 = nv_length1;
											_tmp63_ = _tmp62_[0];
											if (g_strcmp0 (_tmp63_, "simple_type") == 0) {
												gchar** _tmp64_ = NULL;
												gint _tmp64__length1 = 0;
												const gchar* _tmp65_ = NULL;
												gchar* _tmp66_ = NULL;
												gchar* _tmp67_ = NULL;
												gboolean _tmp68_ = FALSE;
												_tmp64_ = nv;
												_tmp64__length1 = nv_length1;
												_tmp65_ = _tmp64_[1];
												_tmp66_ = vala_gidl_parser_eval (self, _tmp65_);
												_tmp67_ = _tmp66_;
												_tmp68_ = g_strcmp0 (_tmp67_, "1") == 0;
												_g_free0 (_tmp67_);
												if (_tmp68_) {
													ValaStruct* _tmp69_ = NULL;
													_tmp69_ = st;
													vala_struct_set_simple_type (_tmp69_, TRUE);
												}
											} else {
												gchar** _tmp70_ = NULL;
												gint _tmp70__length1 = 0;
												const gchar* _tmp71_ = NULL;
												_tmp70_ = nv;
												_tmp70__length1 = nv_length1;
												_tmp71_ = _tmp70_[0];
												if (g_strcmp0 (_tmp71_, "immutable") == 0) {
													gchar** _tmp72_ = NULL;
													gint _tmp72__length1 = 0;
													const gchar* _tmp73_ = NULL;
													gchar* _tmp74_ = NULL;
													gchar* _tmp75_ = NULL;
													gboolean _tmp76_ = FALSE;
													_tmp72_ = nv;
													_tmp72__length1 = nv_length1;
													_tmp73_ = _tmp72_[1];
													_tmp74_ = vala_gidl_parser_eval (self, _tmp73_);
													_tmp75_ = _tmp74_;
													_tmp76_ = g_strcmp0 (_tmp75_, "1") == 0;
													_g_free0 (_tmp75_);
													if (_tmp76_) {
														ValaStruct* _tmp77_ = NULL;
														_tmp77_ = st;
														vala_code_node_set_attribute ((ValaCodeNode*) _tmp77_, "Immutable", TRUE, NULL);
													}
												} else {
													gchar** _tmp78_ = NULL;
													gint _tmp78__length1 = 0;
													const gchar* _tmp79_ = NULL;
													_tmp78_ = nv;
													_tmp78__length1 = nv_length1;
													_tmp79_ = _tmp78_[0];
													if (g_strcmp0 (_tmp79_, "has_type_id") == 0) {
														gchar** _tmp80_ = NULL;
														gint _tmp80__length1 = 0;
														const gchar* _tmp81_ = NULL;
														gchar* _tmp82_ = NULL;
														gchar* _tmp83_ = NULL;
														gboolean _tmp84_ = FALSE;
														_tmp80_ = nv;
														_tmp80__length1 = nv_length1;
														_tmp81_ = _tmp80_[1];
														_tmp82_ = vala_gidl_parser_eval (self, _tmp81_);
														_tmp83_ = _tmp82_;
														_tmp84_ = g_strcmp0 (_tmp83_, "0") == 0;
														_g_free0 (_tmp83_);
														if (_tmp84_) {
															ValaStruct* _tmp85_ = NULL;
															_tmp85_ = st;
															vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp85_, "CCode", "has_type_id", FALSE, NULL);
														}
													} else {
														gchar** _tmp86_ = NULL;
														gint _tmp86__length1 = 0;
														const gchar* _tmp87_ = NULL;
														_tmp86_ = nv;
														_tmp86__length1 = nv_length1;
														_tmp87_ = _tmp86_[0];
														if (g_strcmp0 (_tmp87_, "type_id") == 0) {
															ValaStruct* _tmp88_ = NULL;
															gchar** _tmp89_ = NULL;
															gint _tmp89__length1 = 0;
															const gchar* _tmp90_ = NULL;
															gchar* _tmp91_ = NULL;
															gchar* _tmp92_ = NULL;
															_tmp88_ = st;
															_tmp89_ = nv;
															_tmp89__length1 = nv_length1;
															_tmp90_ = _tmp89_[1];
															_tmp91_ = vala_gidl_parser_eval (self, _tmp90_);
															_tmp92_ = _tmp91_;
															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp88_, "CCode", "type_id", _tmp92_, NULL);
															_g_free0 (_tmp92_);
														} else {
															gchar** _tmp93_ = NULL;
															gint _tmp93__length1 = 0;
															const gchar* _tmp94_ = NULL;
															_tmp93_ = nv;
															_tmp93__length1 = nv_length1;
															_tmp94_ = _tmp93_[0];
															if (g_strcmp0 (_tmp94_, "has_copy_function") == 0) {
																gchar** _tmp95_ = NULL;
																gint _tmp95__length1 = 0;
																const gchar* _tmp96_ = NULL;
																gchar* _tmp97_ = NULL;
																gchar* _tmp98_ = NULL;
																gboolean _tmp99_ = FALSE;
																_tmp95_ = nv;
																_tmp95__length1 = nv_length1;
																_tmp96_ = _tmp95_[1];
																_tmp97_ = vala_gidl_parser_eval (self, _tmp96_);
																_tmp98_ = _tmp97_;
																_tmp99_ = g_strcmp0 (_tmp98_, "0") == 0;
																_g_free0 (_tmp98_);
																if (_tmp99_) {
																	ValaStruct* _tmp100_ = NULL;
																	_tmp100_ = st;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp100_, "CCode", "has_copy_function", FALSE, NULL);
																}
															} else {
																gchar** _tmp101_ = NULL;
																gint _tmp101__length1 = 0;
																const gchar* _tmp102_ = NULL;
																_tmp101_ = nv;
																_tmp101__length1 = nv_length1;
																_tmp102_ = _tmp101_[0];
																if (g_strcmp0 (_tmp102_, "deprecated") == 0) {
																	gchar** _tmp103_ = NULL;
																	gint _tmp103__length1 = 0;
																	const gchar* _tmp104_ = NULL;
																	gchar* _tmp105_ = NULL;
																	gchar* _tmp106_ = NULL;
																	gboolean _tmp107_ = FALSE;
																	_tmp103_ = nv;
																	_tmp103__length1 = nv_length1;
																	_tmp104_ = _tmp103_[1];
																	_tmp105_ = vala_gidl_parser_eval (self, _tmp104_);
																	_tmp106_ = _tmp105_;
																	_tmp107_ = g_strcmp0 (_tmp106_, "1") == 0;
																	_g_free0 (_tmp106_);
																	if (_tmp107_) {
																		ValaStruct* _tmp108_ = NULL;
																		_tmp108_ = st;
																		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp108_, "Version", "deprecated", TRUE, NULL);
																	}
																} else {
																	gchar** _tmp109_ = NULL;
																	gint _tmp109__length1 = 0;
																	const gchar* _tmp110_ = NULL;
																	_tmp109_ = nv;
																	_tmp109__length1 = nv_length1;
																	_tmp110_ = _tmp109_[0];
																	if (g_strcmp0 (_tmp110_, "replacement") == 0) {
																		ValaStruct* _tmp111_ = NULL;
																		gchar** _tmp112_ = NULL;
																		gint _tmp112__length1 = 0;
																		const gchar* _tmp113_ = NULL;
																		gchar* _tmp114_ = NULL;
																		gchar* _tmp115_ = NULL;
																		_tmp111_ = st;
																		_tmp112_ = nv;
																		_tmp112__length1 = nv_length1;
																		_tmp113_ = _tmp112_[1];
																		_tmp114_ = vala_gidl_parser_eval (self, _tmp113_);
																		_tmp115_ = _tmp114_;
																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp111_, "Version", "replacement", _tmp115_, NULL);
																		_g_free0 (_tmp115_);
																	} else {
																		gchar** _tmp116_ = NULL;
																		gint _tmp116__length1 = 0;
																		const gchar* _tmp117_ = NULL;
																		_tmp116_ = nv;
																		_tmp116__length1 = nv_length1;
																		_tmp117_ = _tmp116_[0];
																		if (g_strcmp0 (_tmp117_, "deprecated_since") == 0) {
																			ValaStruct* _tmp118_ = NULL;
																			gchar** _tmp119_ = NULL;
																			gint _tmp119__length1 = 0;
																			const gchar* _tmp120_ = NULL;
																			gchar* _tmp121_ = NULL;
																			gchar* _tmp122_ = NULL;
																			_tmp118_ = st;
																			_tmp119_ = nv;
																			_tmp119__length1 = nv_length1;
																			_tmp120_ = _tmp119_[1];
																			_tmp121_ = vala_gidl_parser_eval (self, _tmp120_);
																			_tmp122_ = _tmp121_;
																			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp118_, "Version", "deprecated_since", _tmp122_, NULL);
																			_g_free0 (_tmp122_);
																		} else {
																			gchar** _tmp123_ = NULL;
																			gint _tmp123__length1 = 0;
																			const gchar* _tmp124_ = NULL;
																			_tmp123_ = nv;
																			_tmp123__length1 = nv_length1;
																			_tmp124_ = _tmp123_[0];
																			if (g_strcmp0 (_tmp124_, "has_destroy_function") == 0) {
																				gchar** _tmp125_ = NULL;
																				gint _tmp125__length1 = 0;
																				const gchar* _tmp126_ = NULL;
																				gchar* _tmp127_ = NULL;
																				gchar* _tmp128_ = NULL;
																				gboolean _tmp129_ = FALSE;
																				_tmp125_ = nv;
																				_tmp125__length1 = nv_length1;
																				_tmp126_ = _tmp125_[1];
																				_tmp127_ = vala_gidl_parser_eval (self, _tmp126_);
																				_tmp128_ = _tmp127_;
																				_tmp129_ = g_strcmp0 (_tmp128_, "0") == 0;
																				_g_free0 (_tmp128_);
																				if (_tmp129_) {
																					ValaStruct* _tmp130_ = NULL;
																					_tmp130_ = st;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp130_, "CCode", "has_destroy_function", FALSE, NULL);
																				}
																			} else {
																				gchar** _tmp131_ = NULL;
																				gint _tmp131__length1 = 0;
																				const gchar* _tmp132_ = NULL;
																				_tmp131_ = nv;
																				_tmp131__length1 = nv_length1;
																				_tmp132_ = _tmp131_[0];
																				if (g_strcmp0 (_tmp132_, "experimental") == 0) {
																					gchar** _tmp133_ = NULL;
																					gint _tmp133__length1 = 0;
																					const gchar* _tmp134_ = NULL;
																					gchar* _tmp135_ = NULL;
																					gchar* _tmp136_ = NULL;
																					gboolean _tmp137_ = FALSE;
																					_tmp133_ = nv;
																					_tmp133__length1 = nv_length1;
																					_tmp134_ = _tmp133_[1];
																					_tmp135_ = vala_gidl_parser_eval (self, _tmp134_);
																					_tmp136_ = _tmp135_;
																					_tmp137_ = g_strcmp0 (_tmp136_, "1") == 0;
																					_g_free0 (_tmp136_);
																					if (_tmp137_) {
																						ValaStruct* _tmp138_ = NULL;
																						_tmp138_ = st;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp138_, "Version", "experimental", TRUE, NULL);
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp139_ = container;
			_tmp140_ = st;
			vala_gidl_parser_add_symbol_to_container (self, _tmp139_, (ValaSymbol*) _tmp140_);
			_tmp141_ = self->priv->current_source_file;
			_tmp142_ = st;
			vala_source_file_add_node (_tmp141_, (ValaCodeNode*) _tmp142_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp143_ = st;
		_tmp144_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp143_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp144_;
		_tmp145_ = st_node;
		_tmp146_ = _tmp145_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp146_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp147_ = NULL;
					GIdlNodeTypeId _tmp148_ = 0;
					_tmp147_ = member;
					_tmp148_ = _tmp147_->type;
					if (_tmp148_ == G_IDL_NODE_FUNCTION) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp149_ = NULL;
						ValaMethod* _tmp150_ = NULL;
						ValaMethod* _tmp151_ = NULL;
						_tmp149_ = member;
						_tmp150_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp149_, FALSE);
						m = _tmp150_;
						_tmp151_ = m;
						if (_tmp151_ != NULL) {
							ValaStruct* _tmp152_ = NULL;
							ValaMethod* _tmp153_ = NULL;
							_tmp152_ = st;
							_tmp153_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp152_, _tmp153_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp154_ = NULL;
						GIdlNodeTypeId _tmp155_ = 0;
						_tmp154_ = member;
						_tmp155_ = _tmp154_->type;
						if (_tmp155_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp156_ = NULL;
							ValaField* _tmp157_ = NULL;
							ValaField* _tmp158_ = NULL;
							_tmp156_ = member;
							_tmp157_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp156_);
							f = _tmp157_;
							_tmp158_ = f;
							if (_tmp158_ != NULL) {
								ValaStruct* _tmp159_ = NULL;
								ValaField* _tmp160_ = NULL;
								_tmp159_ = st;
								_tmp160_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp159_, _tmp160_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void = FALSE;
		gchar* ref_function = NULL;
		gchar* unref_function = NULL;
		gchar* copy_function = NULL;
		gchar* free_function = NULL;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp161_ = NULL;
		ValaScope* _tmp162_ = NULL;
		ValaScope* _tmp163_ = NULL;
		const gchar* _tmp164_ = NULL;
		ValaSymbol* _tmp165_ = NULL;
		ValaClass* _tmp166_ = NULL;
		ValaClass* _tmp167_ = NULL;
		ValaClass* _tmp325_ = NULL;
		ValaTypeSymbol* _tmp326_ = NULL;
		GIdlNodeStruct* _tmp327_ = NULL;
		GList* _tmp328_ = NULL;
		const gchar* _tmp379_ = NULL;
		const gchar* _tmp388_ = NULL;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp161_ = container;
		_tmp162_ = vala_symbol_get_scope (_tmp161_);
		_tmp163_ = _tmp162_;
		_tmp164_ = name;
		_tmp165_ = vala_scope_lookup (_tmp163_, _tmp164_);
		_tmp166_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp165_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp165_) : NULL;
		if (_tmp166_ == NULL) {
			_vala_code_node_unref0 (_tmp165_);
		}
		cl = _tmp166_;
		_tmp167_ = cl;
		if (_tmp167_ == NULL) {
			gchar* base_class = NULL;
			gboolean is_fundamental = FALSE;
			const gchar* _tmp168_ = NULL;
			ValaSourceReference* _tmp169_ = NULL;
			ValaClass* _tmp170_ = NULL;
			ValaClass* _tmp171_ = NULL;
			gchar** cl_attributes = NULL;
			GIdlNode* _tmp172_ = NULL;
			const gchar* _tmp173_ = NULL;
			gint _tmp174_ = 0;
			gchar** _tmp175_ = NULL;
			gint cl_attributes_length1 = 0;
			gint _cl_attributes_size_ = 0;
			gchar** _tmp176_ = NULL;
			gint _tmp176__length1 = 0;
			ValaSymbol* _tmp312_ = NULL;
			ValaClass* _tmp313_ = NULL;
			ValaSourceFile* _tmp314_ = NULL;
			ValaClass* _tmp315_ = NULL;
			const gchar* _tmp316_ = NULL;
			gboolean _tmp321_ = FALSE;
			const gchar* _tmp322_ = NULL;
			base_class = NULL;
			is_fundamental = FALSE;
			_tmp168_ = name;
			_tmp169_ = self->priv->current_source_reference;
			_tmp170_ = vala_class_new (_tmp168_, _tmp169_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp170_;
			_tmp171_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp171_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp172_ = node;
			_tmp173_ = _tmp172_->name;
			_tmp175_ = vala_gidl_parser_get_attributes (self, _tmp173_, &_tmp174_);
			cl_attributes = _tmp175_;
			cl_attributes_length1 = _tmp174_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp176_ = cl_attributes;
			_tmp176__length1 = cl_attributes_length1;
			if (_tmp176_ != NULL) {
				gchar** _tmp177_ = NULL;
				gint _tmp177__length1 = 0;
				_tmp177_ = cl_attributes;
				_tmp177__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp177_;
					attr_collection_length1 = _tmp177__length1;
					for (attr_it = 0; attr_it < _tmp177__length1; attr_it = attr_it + 1) {
						gchar* _tmp178_ = NULL;
						gchar* attr = NULL;
						_tmp178_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp178_;
						{
							gchar** nv = NULL;
							const gchar* _tmp179_ = NULL;
							gchar** _tmp180_ = NULL;
							gchar** _tmp181_ = NULL;
							gint nv_length1 = 0;
							gint _nv_size_ = 0;
							gchar** _tmp182_ = NULL;
							gint _tmp182__length1 = 0;
							const gchar* _tmp183_ = NULL;
							_tmp179_ = attr;
							_tmp181_ = _tmp180_ = g_strsplit (_tmp179_, "=", 2);
							nv = _tmp181_;
							nv_length1 = _vala_array_length (_tmp180_);
							_nv_size_ = nv_length1;
							_tmp182_ = nv;
							_tmp182__length1 = nv_length1;
							_tmp183_ = _tmp182_[0];
							if (g_strcmp0 (_tmp183_, "cheader_filename") == 0) {
								ValaClass* _tmp184_ = NULL;
								gchar** _tmp185_ = NULL;
								gint _tmp185__length1 = 0;
								const gchar* _tmp186_ = NULL;
								gchar* _tmp187_ = NULL;
								gchar* _tmp188_ = NULL;
								_tmp184_ = cl;
								_tmp185_ = nv;
								_tmp185__length1 = nv_length1;
								_tmp186_ = _tmp185_[1];
								_tmp187_ = vala_gidl_parser_eval (self, _tmp186_);
								_tmp188_ = _tmp187_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp184_, "CCode", "cheader_filename", _tmp188_, NULL);
								_g_free0 (_tmp188_);
							} else {
								gchar** _tmp189_ = NULL;
								gint _tmp189__length1 = 0;
								const gchar* _tmp190_ = NULL;
								_tmp189_ = nv;
								_tmp189__length1 = nv_length1;
								_tmp190_ = _tmp189_[0];
								if (g_strcmp0 (_tmp190_, "base_class") == 0) {
									gchar** _tmp191_ = NULL;
									gint _tmp191__length1 = 0;
									const gchar* _tmp192_ = NULL;
									gchar* _tmp193_ = NULL;
									_tmp191_ = nv;
									_tmp191__length1 = nv_length1;
									_tmp192_ = _tmp191_[1];
									_tmp193_ = vala_gidl_parser_eval (self, _tmp192_);
									_g_free0 (base_class);
									base_class = _tmp193_;
								} else {
									gchar** _tmp194_ = NULL;
									gint _tmp194__length1 = 0;
									const gchar* _tmp195_ = NULL;
									_tmp194_ = nv;
									_tmp194__length1 = nv_length1;
									_tmp195_ = _tmp194_[0];
									if (g_strcmp0 (_tmp195_, "hidden") == 0) {
										gchar** _tmp196_ = NULL;
										gint _tmp196__length1 = 0;
										const gchar* _tmp197_ = NULL;
										gchar* _tmp198_ = NULL;
										gchar* _tmp199_ = NULL;
										gboolean _tmp200_ = FALSE;
										_tmp196_ = nv;
										_tmp196__length1 = nv_length1;
										_tmp197_ = _tmp196_[1];
										_tmp198_ = vala_gidl_parser_eval (self, _tmp197_);
										_tmp199_ = _tmp198_;
										_tmp200_ = g_strcmp0 (_tmp199_, "1") == 0;
										_g_free0 (_tmp199_);
										if (_tmp200_) {
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (base_class);
											_vala_code_node_unref0 (cl);
											_g_free0 (free_function);
											_g_free0 (copy_function);
											_g_free0 (unref_function);
											_g_free0 (ref_function);
											_g_free0 (name);
											return;
										}
									} else {
										gchar** _tmp201_ = NULL;
										gint _tmp201__length1 = 0;
										const gchar* _tmp202_ = NULL;
										_tmp201_ = nv;
										_tmp201__length1 = nv_length1;
										_tmp202_ = _tmp201_[0];
										if (g_strcmp0 (_tmp202_, "is_immutable") == 0) {
											gchar** _tmp203_ = NULL;
											gint _tmp203__length1 = 0;
											const gchar* _tmp204_ = NULL;
											gchar* _tmp205_ = NULL;
											gchar* _tmp206_ = NULL;
											gboolean _tmp207_ = FALSE;
											_tmp203_ = nv;
											_tmp203__length1 = nv_length1;
											_tmp204_ = _tmp203_[1];
											_tmp205_ = vala_gidl_parser_eval (self, _tmp204_);
											_tmp206_ = _tmp205_;
											_tmp207_ = g_strcmp0 (_tmp206_, "1") == 0;
											_g_free0 (_tmp206_);
											if (_tmp207_) {
												ValaClass* _tmp208_ = NULL;
												_tmp208_ = cl;
												vala_class_set_is_immutable (_tmp208_, TRUE);
											}
										} else {
											gchar** _tmp209_ = NULL;
											gint _tmp209__length1 = 0;
											const gchar* _tmp210_ = NULL;
											_tmp209_ = nv;
											_tmp209__length1 = nv_length1;
											_tmp210_ = _tmp209_[0];
											if (g_strcmp0 (_tmp210_, "const_cname") == 0) {
												ValaClass* _tmp211_ = NULL;
												gchar** _tmp212_ = NULL;
												gint _tmp212__length1 = 0;
												const gchar* _tmp213_ = NULL;
												gchar* _tmp214_ = NULL;
												gchar* _tmp215_ = NULL;
												_tmp211_ = cl;
												_tmp212_ = nv;
												_tmp212__length1 = nv_length1;
												_tmp213_ = _tmp212_[1];
												_tmp214_ = vala_gidl_parser_eval (self, _tmp213_);
												_tmp215_ = _tmp214_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp211_, "CCode", "const_cname", _tmp215_, NULL);
												_g_free0 (_tmp215_);
											} else {
												gchar** _tmp216_ = NULL;
												gint _tmp216__length1 = 0;
												const gchar* _tmp217_ = NULL;
												_tmp216_ = nv;
												_tmp216__length1 = nv_length1;
												_tmp217_ = _tmp216_[0];
												if (g_strcmp0 (_tmp217_, "is_fundamental") == 0) {
													gchar** _tmp218_ = NULL;
													gint _tmp218__length1 = 0;
													const gchar* _tmp219_ = NULL;
													gchar* _tmp220_ = NULL;
													gchar* _tmp221_ = NULL;
													gboolean _tmp222_ = FALSE;
													_tmp218_ = nv;
													_tmp218__length1 = nv_length1;
													_tmp219_ = _tmp218_[1];
													_tmp220_ = vala_gidl_parser_eval (self, _tmp219_);
													_tmp221_ = _tmp220_;
													_tmp222_ = g_strcmp0 (_tmp221_, "1") == 0;
													_g_free0 (_tmp221_);
													if (_tmp222_) {
														is_fundamental = TRUE;
													}
												} else {
													gboolean _tmp223_ = FALSE;
													gchar** _tmp224_ = NULL;
													gint _tmp224__length1 = 0;
													const gchar* _tmp225_ = NULL;
													_tmp224_ = nv;
													_tmp224__length1 = nv_length1;
													_tmp225_ = _tmp224_[0];
													if (g_strcmp0 (_tmp225_, "abstract") == 0) {
														const gchar* _tmp226_ = NULL;
														_tmp226_ = base_class;
														_tmp223_ = _tmp226_ != NULL;
													} else {
														_tmp223_ = FALSE;
													}
													if (_tmp223_) {
														gchar** _tmp227_ = NULL;
														gint _tmp227__length1 = 0;
														const gchar* _tmp228_ = NULL;
														gchar* _tmp229_ = NULL;
														gchar* _tmp230_ = NULL;
														gboolean _tmp231_ = FALSE;
														_tmp227_ = nv;
														_tmp227__length1 = nv_length1;
														_tmp228_ = _tmp227_[1];
														_tmp229_ = vala_gidl_parser_eval (self, _tmp228_);
														_tmp230_ = _tmp229_;
														_tmp231_ = g_strcmp0 (_tmp230_, "1") == 0;
														_g_free0 (_tmp230_);
														if (_tmp231_) {
															ValaClass* _tmp232_ = NULL;
															_tmp232_ = cl;
															vala_class_set_is_abstract (_tmp232_, TRUE);
														}
													} else {
														gchar** _tmp233_ = NULL;
														gint _tmp233__length1 = 0;
														const gchar* _tmp234_ = NULL;
														_tmp233_ = nv;
														_tmp233__length1 = nv_length1;
														_tmp234_ = _tmp233_[0];
														if (g_strcmp0 (_tmp234_, "free_function") == 0) {
															gchar** _tmp235_ = NULL;
															gint _tmp235__length1 = 0;
															const gchar* _tmp236_ = NULL;
															gchar* _tmp237_ = NULL;
															_tmp235_ = nv;
															_tmp235__length1 = nv_length1;
															_tmp236_ = _tmp235_[1];
															_tmp237_ = vala_gidl_parser_eval (self, _tmp236_);
															_g_free0 (free_function);
															free_function = _tmp237_;
														} else {
															gchar** _tmp238_ = NULL;
															gint _tmp238__length1 = 0;
															const gchar* _tmp239_ = NULL;
															_tmp238_ = nv;
															_tmp238__length1 = nv_length1;
															_tmp239_ = _tmp238_[0];
															if (g_strcmp0 (_tmp239_, "ref_function") == 0) {
																gchar** _tmp240_ = NULL;
																gint _tmp240__length1 = 0;
																const gchar* _tmp241_ = NULL;
																gchar* _tmp242_ = NULL;
																_tmp240_ = nv;
																_tmp240__length1 = nv_length1;
																_tmp241_ = _tmp240_[1];
																_tmp242_ = vala_gidl_parser_eval (self, _tmp241_);
																_g_free0 (ref_function);
																ref_function = _tmp242_;
															} else {
																gchar** _tmp243_ = NULL;
																gint _tmp243__length1 = 0;
																const gchar* _tmp244_ = NULL;
																_tmp243_ = nv;
																_tmp243__length1 = nv_length1;
																_tmp244_ = _tmp243_[0];
																if (g_strcmp0 (_tmp244_, "unref_function") == 0) {
																	gchar** _tmp245_ = NULL;
																	gint _tmp245__length1 = 0;
																	const gchar* _tmp246_ = NULL;
																	gchar* _tmp247_ = NULL;
																	_tmp245_ = nv;
																	_tmp245__length1 = nv_length1;
																	_tmp246_ = _tmp245_[1];
																	_tmp247_ = vala_gidl_parser_eval (self, _tmp246_);
																	_g_free0 (unref_function);
																	unref_function = _tmp247_;
																} else {
																	gchar** _tmp248_ = NULL;
																	gint _tmp248__length1 = 0;
																	const gchar* _tmp249_ = NULL;
																	_tmp248_ = nv;
																	_tmp248__length1 = nv_length1;
																	_tmp249_ = _tmp248_[0];
																	if (g_strcmp0 (_tmp249_, "copy_function") == 0) {
																		gchar** _tmp250_ = NULL;
																		gint _tmp250__length1 = 0;
																		const gchar* _tmp251_ = NULL;
																		gchar* _tmp252_ = NULL;
																		_tmp250_ = nv;
																		_tmp250__length1 = nv_length1;
																		_tmp251_ = _tmp250_[1];
																		_tmp252_ = vala_gidl_parser_eval (self, _tmp251_);
																		_g_free0 (copy_function);
																		copy_function = _tmp252_;
																	} else {
																		gchar** _tmp253_ = NULL;
																		gint _tmp253__length1 = 0;
																		const gchar* _tmp254_ = NULL;
																		_tmp253_ = nv;
																		_tmp253__length1 = nv_length1;
																		_tmp254_ = _tmp253_[0];
																		if (g_strcmp0 (_tmp254_, "ref_function_void") == 0) {
																			gchar** _tmp255_ = NULL;
																			gint _tmp255__length1 = 0;
																			const gchar* _tmp256_ = NULL;
																			gchar* _tmp257_ = NULL;
																			gchar* _tmp258_ = NULL;
																			gboolean _tmp259_ = FALSE;
																			_tmp255_ = nv;
																			_tmp255__length1 = nv_length1;
																			_tmp256_ = _tmp255_[1];
																			_tmp257_ = vala_gidl_parser_eval (self, _tmp256_);
																			_tmp258_ = _tmp257_;
																			_tmp259_ = g_strcmp0 (_tmp258_, "1") == 0;
																			_g_free0 (_tmp258_);
																			if (_tmp259_) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			gchar** _tmp260_ = NULL;
																			gint _tmp260__length1 = 0;
																			const gchar* _tmp261_ = NULL;
																			_tmp260_ = nv;
																			_tmp260__length1 = nv_length1;
																			_tmp261_ = _tmp260_[0];
																			if (g_strcmp0 (_tmp261_, "deprecated") == 0) {
																				gchar** _tmp262_ = NULL;
																				gint _tmp262__length1 = 0;
																				const gchar* _tmp263_ = NULL;
																				gchar* _tmp264_ = NULL;
																				gchar* _tmp265_ = NULL;
																				gboolean _tmp266_ = FALSE;
																				_tmp262_ = nv;
																				_tmp262__length1 = nv_length1;
																				_tmp263_ = _tmp262_[1];
																				_tmp264_ = vala_gidl_parser_eval (self, _tmp263_);
																				_tmp265_ = _tmp264_;
																				_tmp266_ = g_strcmp0 (_tmp265_, "1") == 0;
																				_g_free0 (_tmp265_);
																				if (_tmp266_) {
																					ValaClass* _tmp267_ = NULL;
																					_tmp267_ = cl;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp267_, "Version", "deprecated", TRUE, NULL);
																				}
																			} else {
																				gchar** _tmp268_ = NULL;
																				gint _tmp268__length1 = 0;
																				const gchar* _tmp269_ = NULL;
																				_tmp268_ = nv;
																				_tmp268__length1 = nv_length1;
																				_tmp269_ = _tmp268_[0];
																				if (g_strcmp0 (_tmp269_, "replacement") == 0) {
																					ValaClass* _tmp270_ = NULL;
																					gchar** _tmp271_ = NULL;
																					gint _tmp271__length1 = 0;
																					const gchar* _tmp272_ = NULL;
																					gchar* _tmp273_ = NULL;
																					gchar* _tmp274_ = NULL;
																					_tmp270_ = cl;
																					_tmp271_ = nv;
																					_tmp271__length1 = nv_length1;
																					_tmp272_ = _tmp271_[1];
																					_tmp273_ = vala_gidl_parser_eval (self, _tmp272_);
																					_tmp274_ = _tmp273_;
																					vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp270_, "Version", "replacement", _tmp274_, NULL);
																					_g_free0 (_tmp274_);
																				} else {
																					gchar** _tmp275_ = NULL;
																					gint _tmp275__length1 = 0;
																					const gchar* _tmp276_ = NULL;
																					_tmp275_ = nv;
																					_tmp275__length1 = nv_length1;
																					_tmp276_ = _tmp275_[0];
																					if (g_strcmp0 (_tmp276_, "deprecated_since") == 0) {
																						ValaClass* _tmp277_ = NULL;
																						gchar** _tmp278_ = NULL;
																						gint _tmp278__length1 = 0;
																						const gchar* _tmp279_ = NULL;
																						gchar* _tmp280_ = NULL;
																						gchar* _tmp281_ = NULL;
																						_tmp277_ = cl;
																						_tmp278_ = nv;
																						_tmp278__length1 = nv_length1;
																						_tmp279_ = _tmp278_[1];
																						_tmp280_ = vala_gidl_parser_eval (self, _tmp279_);
																						_tmp281_ = _tmp280_;
																						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp277_, "Version", "deprecated_since", _tmp281_, NULL);
																						_g_free0 (_tmp281_);
																					} else {
																						gchar** _tmp282_ = NULL;
																						gint _tmp282__length1 = 0;
																						const gchar* _tmp283_ = NULL;
																						_tmp282_ = nv;
																						_tmp282__length1 = nv_length1;
																						_tmp283_ = _tmp282_[0];
																						if (g_strcmp0 (_tmp283_, "type_parameters") == 0) {
																							gchar** _tmp284_ = NULL;
																							gint _tmp284__length1 = 0;
																							const gchar* _tmp285_ = NULL;
																							gchar* _tmp286_ = NULL;
																							gchar* _tmp287_ = NULL;
																							gchar** _tmp288_ = NULL;
																							gchar** _tmp289_ = NULL;
																							gchar** _tmp290_ = NULL;
																							gint _tmp290__length1 = 0;
																							_tmp284_ = nv;
																							_tmp284__length1 = nv_length1;
																							_tmp285_ = _tmp284_[1];
																							_tmp286_ = vala_gidl_parser_eval (self, _tmp285_);
																							_tmp287_ = _tmp286_;
																							_tmp289_ = _tmp288_ = g_strsplit (_tmp287_, ",", 0);
																							_tmp290_ = _tmp289_;
																							_tmp290__length1 = _vala_array_length (_tmp288_);
																							_g_free0 (_tmp287_);
																							{
																								gchar** type_param_name_collection = NULL;
																								gint type_param_name_collection_length1 = 0;
																								gint _type_param_name_collection_size_ = 0;
																								gint type_param_name_it = 0;
																								type_param_name_collection = _tmp290_;
																								type_param_name_collection_length1 = _tmp290__length1;
																								for (type_param_name_it = 0; type_param_name_it < _tmp290__length1; type_param_name_it = type_param_name_it + 1) {
																									gchar* _tmp291_ = NULL;
																									gchar* type_param_name = NULL;
																									_tmp291_ = g_strdup (type_param_name_collection[type_param_name_it]);
																									type_param_name = _tmp291_;
																									{
																										ValaClass* _tmp292_ = NULL;
																										const gchar* _tmp293_ = NULL;
																										ValaSourceReference* _tmp294_ = NULL;
																										ValaTypeParameter* _tmp295_ = NULL;
																										ValaTypeParameter* _tmp296_ = NULL;
																										_tmp292_ = cl;
																										_tmp293_ = type_param_name;
																										_tmp294_ = self->priv->current_source_reference;
																										_tmp295_ = vala_typeparameter_new (_tmp293_, _tmp294_);
																										_tmp296_ = _tmp295_;
																										vala_object_type_symbol_add_type_parameter ((ValaObjectTypeSymbol*) _tmp292_, _tmp296_);
																										_vala_code_node_unref0 (_tmp296_);
																										_g_free0 (type_param_name);
																									}
																								}
																								type_param_name_collection = (_vala_array_free (type_param_name_collection, type_param_name_collection_length1, (GDestroyNotify) g_free), NULL);
																							}
																						} else {
																							gchar** _tmp297_ = NULL;
																							gint _tmp297__length1 = 0;
																							const gchar* _tmp298_ = NULL;
																							_tmp297_ = nv;
																							_tmp297__length1 = nv_length1;
																							_tmp298_ = _tmp297_[0];
																							if (g_strcmp0 (_tmp298_, "experimental") == 0) {
																								gchar** _tmp299_ = NULL;
																								gint _tmp299__length1 = 0;
																								const gchar* _tmp300_ = NULL;
																								gchar* _tmp301_ = NULL;
																								gchar* _tmp302_ = NULL;
																								gboolean _tmp303_ = FALSE;
																								_tmp299_ = nv;
																								_tmp299__length1 = nv_length1;
																								_tmp300_ = _tmp299_[1];
																								_tmp301_ = vala_gidl_parser_eval (self, _tmp300_);
																								_tmp302_ = _tmp301_;
																								_tmp303_ = g_strcmp0 (_tmp302_, "1") == 0;
																								_g_free0 (_tmp302_);
																								if (_tmp303_) {
																									ValaClass* _tmp304_ = NULL;
																									_tmp304_ = cl;
																									vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp304_, "Version", "experimental", TRUE, NULL);
																								}
																							} else {
																								gchar** _tmp305_ = NULL;
																								gint _tmp305__length1 = 0;
																								const gchar* _tmp306_ = NULL;
																								_tmp305_ = nv;
																								_tmp305__length1 = nv_length1;
																								_tmp306_ = _tmp305_[0];
																								if (g_strcmp0 (_tmp306_, "delegate_target_cname") == 0) {
																									ValaClass* _tmp307_ = NULL;
																									gchar** _tmp308_ = NULL;
																									gint _tmp308__length1 = 0;
																									const gchar* _tmp309_ = NULL;
																									gchar* _tmp310_ = NULL;
																									gchar* _tmp311_ = NULL;
																									_tmp307_ = cl;
																									_tmp308_ = nv;
																									_tmp308__length1 = nv_length1;
																									_tmp309_ = _tmp308_[1];
																									_tmp310_ = vala_gidl_parser_eval (self, _tmp309_);
																									_tmp311_ = _tmp310_;
																									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp307_, "CCode", "delegate_target_cname", _tmp311_, NULL);
																									_g_free0 (_tmp311_);
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp312_ = container;
			_tmp313_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, _tmp312_, (ValaSymbol*) _tmp313_);
			_tmp314_ = self->priv->current_source_file;
			_tmp315_ = cl;
			vala_source_file_add_node (_tmp314_, (ValaCodeNode*) _tmp315_);
			_tmp316_ = base_class;
			if (_tmp316_ != NULL) {
				ValaDataType* parent = NULL;
				const gchar* _tmp317_ = NULL;
				ValaDataType* _tmp318_ = NULL;
				ValaClass* _tmp319_ = NULL;
				ValaDataType* _tmp320_ = NULL;
				_tmp317_ = base_class;
				_tmp318_ = vala_gidl_parser_parse_type_string (self, _tmp317_);
				parent = _tmp318_;
				_tmp319_ = cl;
				_tmp320_ = parent;
				vala_class_add_base_type (_tmp319_, _tmp320_);
				_vala_code_node_unref0 (parent);
			}
			_tmp322_ = base_class;
			if (_tmp322_ == NULL) {
				gboolean _tmp323_ = FALSE;
				_tmp323_ = is_fundamental;
				_tmp321_ = !_tmp323_;
			} else {
				_tmp321_ = FALSE;
			}
			if (_tmp321_) {
				ValaClass* _tmp324_ = NULL;
				_tmp324_ = cl;
				vala_class_set_is_compact (_tmp324_, TRUE);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp325_ = cl;
		_tmp326_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp325_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp326_;
		_tmp327_ = st_node;
		_tmp328_ = _tmp327_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp328_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp329_ = NULL;
					GIdlNodeTypeId _tmp330_ = 0;
					_tmp329_ = member;
					_tmp330_ = _tmp329_->type;
					if (_tmp330_ == G_IDL_NODE_FUNCTION) {
						gboolean _tmp331_ = FALSE;
						const gchar* _tmp332_ = NULL;
						_tmp332_ = ref_function;
						if (_tmp332_ == NULL) {
							GIdlNode* _tmp333_ = NULL;
							const gchar* _tmp334_ = NULL;
							_tmp333_ = member;
							_tmp334_ = _tmp333_->name;
							_tmp331_ = g_strcmp0 (_tmp334_, "ref") == 0;
						} else {
							_tmp331_ = FALSE;
						}
						if (_tmp331_) {
							GIdlNode* _tmp335_ = NULL;
							const gchar* _tmp336_ = NULL;
							gchar* _tmp337_ = NULL;
							GIdlNode* _tmp338_ = NULL;
							GIdlNodeParam* _tmp339_ = NULL;
							GIdlNodeType* _tmp340_ = NULL;
							ValaDataType* _tmp341_ = NULL;
							ValaDataType* _tmp342_ = NULL;
							_tmp335_ = member;
							_tmp336_ = ((GIdlNodeFunction*) _tmp335_)->symbol;
							_tmp337_ = g_strdup (_tmp336_);
							_g_free0 (ref_function);
							ref_function = _tmp337_;
							_tmp338_ = member;
							_tmp339_ = ((GIdlNodeFunction*) _tmp338_)->result;
							_tmp340_ = _tmp339_->type;
							_tmp341_ = vala_gidl_parser_parse_type (self, _tmp340_, NULL);
							_tmp342_ = _tmp341_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp342_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp342_);
						} else {
							gboolean _tmp343_ = FALSE;
							const gchar* _tmp344_ = NULL;
							_tmp344_ = unref_function;
							if (_tmp344_ == NULL) {
								GIdlNode* _tmp345_ = NULL;
								const gchar* _tmp346_ = NULL;
								_tmp345_ = member;
								_tmp346_ = _tmp345_->name;
								_tmp343_ = g_strcmp0 (_tmp346_, "unref") == 0;
							} else {
								_tmp343_ = FALSE;
							}
							if (_tmp343_) {
								GIdlNode* _tmp347_ = NULL;
								const gchar* _tmp348_ = NULL;
								gchar* _tmp349_ = NULL;
								_tmp347_ = member;
								_tmp348_ = ((GIdlNodeFunction*) _tmp347_)->symbol;
								_tmp349_ = g_strdup (_tmp348_);
								_g_free0 (unref_function);
								unref_function = _tmp349_;
							} else {
								gboolean _tmp350_ = FALSE;
								const gchar* _tmp351_ = NULL;
								_tmp351_ = free_function;
								if (_tmp351_ == NULL) {
									gboolean _tmp352_ = FALSE;
									GIdlNode* _tmp353_ = NULL;
									const gchar* _tmp354_ = NULL;
									_tmp353_ = member;
									_tmp354_ = _tmp353_->name;
									if (g_strcmp0 (_tmp354_, "free") == 0) {
										_tmp352_ = TRUE;
									} else {
										GIdlNode* _tmp355_ = NULL;
										const gchar* _tmp356_ = NULL;
										_tmp355_ = member;
										_tmp356_ = _tmp355_->name;
										_tmp352_ = g_strcmp0 (_tmp356_, "destroy") == 0;
									}
									_tmp350_ = _tmp352_;
								} else {
									_tmp350_ = FALSE;
								}
								if (_tmp350_) {
									GIdlNode* _tmp357_ = NULL;
									const gchar* _tmp358_ = NULL;
									gchar* _tmp359_ = NULL;
									_tmp357_ = member;
									_tmp358_ = ((GIdlNodeFunction*) _tmp357_)->symbol;
									_tmp359_ = g_strdup (_tmp358_);
									_g_free0 (free_function);
									free_function = _tmp359_;
								} else {
									gboolean _tmp360_ = FALSE;
									const gchar* _tmp361_ = NULL;
									ValaMethod* m = NULL;
									GIdlNode* _tmp367_ = NULL;
									ValaMethod* _tmp368_ = NULL;
									ValaMethod* _tmp369_ = NULL;
									_tmp361_ = copy_function;
									if (_tmp361_ == NULL) {
										GIdlNode* _tmp362_ = NULL;
										const gchar* _tmp363_ = NULL;
										_tmp362_ = member;
										_tmp363_ = _tmp362_->name;
										_tmp360_ = g_strcmp0 (_tmp363_, "copy") == 0;
									} else {
										_tmp360_ = FALSE;
									}
									if (_tmp360_) {
										GIdlNode* _tmp364_ = NULL;
										const gchar* _tmp365_ = NULL;
										gchar* _tmp366_ = NULL;
										_tmp364_ = member;
										_tmp365_ = ((GIdlNodeFunction*) _tmp364_)->symbol;
										_tmp366_ = g_strdup (_tmp365_);
										_g_free0 (copy_function);
										copy_function = _tmp366_;
									}
									_tmp367_ = member;
									_tmp368_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp367_, FALSE);
									m = _tmp368_;
									_tmp369_ = m;
									if (_tmp369_ != NULL) {
										ValaClass* _tmp370_ = NULL;
										ValaMethod* _tmp371_ = NULL;
										_tmp370_ = cl;
										_tmp371_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp370_, _tmp371_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp372_ = NULL;
						GIdlNodeTypeId _tmp373_ = 0;
						_tmp372_ = member;
						_tmp373_ = _tmp372_->type;
						if (_tmp373_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp374_ = NULL;
							ValaField* _tmp375_ = NULL;
							ValaField* _tmp376_ = NULL;
							_tmp374_ = member;
							_tmp375_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp374_);
							f = _tmp375_;
							_tmp376_ = f;
							if (_tmp376_ != NULL) {
								ValaClass* _tmp377_ = NULL;
								ValaField* _tmp378_ = NULL;
								_tmp377_ = cl;
								_tmp378_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp377_, _tmp378_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp379_ = ref_function;
		if (_tmp379_ != NULL) {
			ValaClass* _tmp380_ = NULL;
			const gchar* _tmp381_ = NULL;
			gboolean _tmp382_ = FALSE;
			_tmp380_ = cl;
			_tmp381_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp380_, "CCode", "ref_function", _tmp381_, NULL);
			_tmp382_ = ref_function_void;
			if (_tmp382_) {
				ValaClass* _tmp383_ = NULL;
				gboolean _tmp384_ = FALSE;
				_tmp383_ = cl;
				_tmp384_ = ref_function_void;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp383_, "CCode", "ref_function_void", _tmp384_, NULL);
			}
		} else {
			const gchar* _tmp385_ = NULL;
			_tmp385_ = copy_function;
			if (_tmp385_ != NULL) {
				ValaClass* _tmp386_ = NULL;
				const gchar* _tmp387_ = NULL;
				_tmp386_ = cl;
				_tmp387_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp386_, "CCode", "copy_function", _tmp387_, NULL);
			}
		}
		_tmp388_ = unref_function;
		if (_tmp388_ != NULL) {
			ValaClass* _tmp389_ = NULL;
			const gchar* _tmp390_ = NULL;
			_tmp389_ = cl;
			_tmp390_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp389_, "CCode", "unref_function", _tmp390_, NULL);
		} else {
			gboolean _tmp391_ = FALSE;
			const gchar* _tmp392_ = NULL;
			_tmp392_ = free_function;
			if (_tmp392_ != NULL) {
				const gchar* _tmp393_ = NULL;
				ValaClass* _tmp394_ = NULL;
				gchar* _tmp395_ = NULL;
				gchar* _tmp396_ = NULL;
				gchar* _tmp397_ = NULL;
				gchar* _tmp398_ = NULL;
				_tmp393_ = free_function;
				_tmp394_ = cl;
				_tmp395_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp394_);
				_tmp396_ = _tmp395_;
				_tmp397_ = g_strdup_printf ("%sfree", _tmp396_);
				_tmp398_ = _tmp397_;
				_tmp391_ = g_strcmp0 (_tmp393_, _tmp398_) != 0;
				_g_free0 (_tmp398_);
				_g_free0 (_tmp396_);
			} else {
				_tmp391_ = FALSE;
			}
			if (_tmp391_) {
				ValaClass* _tmp399_ = NULL;
				const gchar* _tmp400_ = NULL;
				_tmp399_ = cl;
				_tmp400_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp399_, "CCode", "free_function", _tmp400_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_union (ValaGIdlParser* self, GIdlNodeUnion* un_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node = NULL;
	GIdlNodeUnion* _tmp0_ = NULL;
	GIdlNodeUnion* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* name = NULL;
	GIdlNode* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	ValaSymbol* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GIdlNode* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (un_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = un_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = un_node;
	_tmp2_ = _tmp1_->deprecated;
	if (_tmp2_) {
		return;
	}
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = container;
	_tmp6_ = vala_gidl_parser_fix_type_name (self, _tmp4_, _tmp5_);
	name = _tmp6_;
	_tmp7_ = node;
	_tmp8_ = _tmp7_->name;
	_tmp9_ = vala_gidl_parser_is_reference_type (self, _tmp8_);
	if (!_tmp9_) {
		ValaStruct* st = NULL;
		ValaSymbol* _tmp10_ = NULL;
		ValaScope* _tmp11_ = NULL;
		ValaScope* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		ValaSymbol* _tmp14_ = NULL;
		ValaStruct* _tmp15_ = NULL;
		ValaStruct* _tmp16_ = NULL;
		ValaStruct* _tmp79_ = NULL;
		ValaTypeSymbol* _tmp80_ = NULL;
		GIdlNodeUnion* _tmp81_ = NULL;
		GList* _tmp82_ = NULL;
		_tmp10_ = container;
		_tmp11_ = vala_symbol_get_scope (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = name;
		_tmp14_ = vala_scope_lookup (_tmp12_, _tmp13_);
		_tmp15_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp14_) : NULL;
		if (_tmp15_ == NULL) {
			_vala_code_node_unref0 (_tmp14_);
		}
		st = _tmp15_;
		_tmp16_ = st;
		if (_tmp16_ == NULL) {
			const gchar* _tmp17_ = NULL;
			ValaSourceReference* _tmp18_ = NULL;
			ValaStruct* _tmp19_ = NULL;
			ValaStruct* _tmp20_ = NULL;
			gchar** st_attributes = NULL;
			GIdlNode* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gchar** _tmp24_ = NULL;
			gint st_attributes_length1 = 0;
			gint _st_attributes_size_ = 0;
			gchar** _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			ValaSymbol* _tmp75_ = NULL;
			ValaStruct* _tmp76_ = NULL;
			ValaSourceFile* _tmp77_ = NULL;
			ValaStruct* _tmp78_ = NULL;
			_tmp17_ = name;
			_tmp18_ = self->priv->current_source_reference;
			_tmp19_ = vala_struct_new (_tmp17_, _tmp18_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp19_;
			_tmp20_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp20_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp21_ = node;
			_tmp22_ = _tmp21_->name;
			_tmp24_ = vala_gidl_parser_get_attributes (self, _tmp22_, &_tmp23_);
			st_attributes = _tmp24_;
			st_attributes_length1 = _tmp23_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp25_ = st_attributes;
			_tmp25__length1 = st_attributes_length1;
			if (_tmp25_ != NULL) {
				gchar** _tmp26_ = NULL;
				gint _tmp26__length1 = 0;
				_tmp26_ = st_attributes;
				_tmp26__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp26_;
					attr_collection_length1 = _tmp26__length1;
					for (attr_it = 0; attr_it < _tmp26__length1; attr_it = attr_it + 1) {
						gchar* _tmp27_ = NULL;
						gchar* attr = NULL;
						_tmp27_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp27_;
						{
							gchar** nv = NULL;
							const gchar* _tmp28_ = NULL;
							gchar** _tmp29_ = NULL;
							gchar** _tmp30_ = NULL;
							gint nv_length1 = 0;
							gint _nv_size_ = 0;
							gchar** _tmp31_ = NULL;
							gint _tmp31__length1 = 0;
							const gchar* _tmp32_ = NULL;
							_tmp28_ = attr;
							_tmp30_ = _tmp29_ = g_strsplit (_tmp28_, "=", 2);
							nv = _tmp30_;
							nv_length1 = _vala_array_length (_tmp29_);
							_nv_size_ = nv_length1;
							_tmp31_ = nv;
							_tmp31__length1 = nv_length1;
							_tmp32_ = _tmp31_[0];
							if (g_strcmp0 (_tmp32_, "cheader_filename") == 0) {
								ValaStruct* _tmp33_ = NULL;
								gchar** _tmp34_ = NULL;
								gint _tmp34__length1 = 0;
								const gchar* _tmp35_ = NULL;
								gchar* _tmp36_ = NULL;
								gchar* _tmp37_ = NULL;
								_tmp33_ = st;
								_tmp34_ = nv;
								_tmp34__length1 = nv_length1;
								_tmp35_ = _tmp34_[1];
								_tmp36_ = vala_gidl_parser_eval (self, _tmp35_);
								_tmp37_ = _tmp36_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp33_, "CCode", "cheader_filename", _tmp37_, NULL);
								_g_free0 (_tmp37_);
							} else {
								gchar** _tmp38_ = NULL;
								gint _tmp38__length1 = 0;
								const gchar* _tmp39_ = NULL;
								_tmp38_ = nv;
								_tmp38__length1 = nv_length1;
								_tmp39_ = _tmp38_[0];
								if (g_strcmp0 (_tmp39_, "deprecated") == 0) {
									gchar** _tmp40_ = NULL;
									gint _tmp40__length1 = 0;
									const gchar* _tmp41_ = NULL;
									gchar* _tmp42_ = NULL;
									gchar* _tmp43_ = NULL;
									gboolean _tmp44_ = FALSE;
									_tmp40_ = nv;
									_tmp40__length1 = nv_length1;
									_tmp41_ = _tmp40_[1];
									_tmp42_ = vala_gidl_parser_eval (self, _tmp41_);
									_tmp43_ = _tmp42_;
									_tmp44_ = g_strcmp0 (_tmp43_, "1") == 0;
									_g_free0 (_tmp43_);
									if (_tmp44_) {
										ValaStruct* _tmp45_ = NULL;
										_tmp45_ = st;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp45_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp46_ = NULL;
									gint _tmp46__length1 = 0;
									const gchar* _tmp47_ = NULL;
									_tmp46_ = nv;
									_tmp46__length1 = nv_length1;
									_tmp47_ = _tmp46_[0];
									if (g_strcmp0 (_tmp47_, "replacement") == 0) {
										ValaStruct* _tmp48_ = NULL;
										gchar** _tmp49_ = NULL;
										gint _tmp49__length1 = 0;
										const gchar* _tmp50_ = NULL;
										gchar* _tmp51_ = NULL;
										gchar* _tmp52_ = NULL;
										_tmp48_ = st;
										_tmp49_ = nv;
										_tmp49__length1 = nv_length1;
										_tmp50_ = _tmp49_[1];
										_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
										_tmp52_ = _tmp51_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp48_, "Version", "replacement", _tmp52_, NULL);
										_g_free0 (_tmp52_);
									} else {
										gchar** _tmp53_ = NULL;
										gint _tmp53__length1 = 0;
										const gchar* _tmp54_ = NULL;
										_tmp53_ = nv;
										_tmp53__length1 = nv_length1;
										_tmp54_ = _tmp53_[0];
										if (g_strcmp0 (_tmp54_, "deprecated_since") == 0) {
											ValaStruct* _tmp55_ = NULL;
											gchar** _tmp56_ = NULL;
											gint _tmp56__length1 = 0;
											const gchar* _tmp57_ = NULL;
											gchar* _tmp58_ = NULL;
											gchar* _tmp59_ = NULL;
											_tmp55_ = st;
											_tmp56_ = nv;
											_tmp56__length1 = nv_length1;
											_tmp57_ = _tmp56_[1];
											_tmp58_ = vala_gidl_parser_eval (self, _tmp57_);
											_tmp59_ = _tmp58_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp55_, "Version", "deprecated_since", _tmp59_, NULL);
											_g_free0 (_tmp59_);
										} else {
											gchar** _tmp60_ = NULL;
											gint _tmp60__length1 = 0;
											const gchar* _tmp61_ = NULL;
											_tmp60_ = nv;
											_tmp60__length1 = nv_length1;
											_tmp61_ = _tmp60_[0];
											if (g_strcmp0 (_tmp61_, "hidden") == 0) {
												gchar** _tmp62_ = NULL;
												gint _tmp62__length1 = 0;
												const gchar* _tmp63_ = NULL;
												gchar* _tmp64_ = NULL;
												gchar* _tmp65_ = NULL;
												gboolean _tmp66_ = FALSE;
												_tmp62_ = nv;
												_tmp62__length1 = nv_length1;
												_tmp63_ = _tmp62_[1];
												_tmp64_ = vala_gidl_parser_eval (self, _tmp63_);
												_tmp65_ = _tmp64_;
												_tmp66_ = g_strcmp0 (_tmp65_, "1") == 0;
												_g_free0 (_tmp65_);
												if (_tmp66_) {
													nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
													_g_free0 (attr);
													st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
													_vala_code_node_unref0 (st);
													_g_free0 (name);
													return;
												}
											} else {
												gchar** _tmp67_ = NULL;
												gint _tmp67__length1 = 0;
												const gchar* _tmp68_ = NULL;
												_tmp67_ = nv;
												_tmp67__length1 = nv_length1;
												_tmp68_ = _tmp67_[0];
												if (g_strcmp0 (_tmp68_, "experimental") == 0) {
													gchar** _tmp69_ = NULL;
													gint _tmp69__length1 = 0;
													const gchar* _tmp70_ = NULL;
													gchar* _tmp71_ = NULL;
													gchar* _tmp72_ = NULL;
													gboolean _tmp73_ = FALSE;
													_tmp69_ = nv;
													_tmp69__length1 = nv_length1;
													_tmp70_ = _tmp69_[1];
													_tmp71_ = vala_gidl_parser_eval (self, _tmp70_);
													_tmp72_ = _tmp71_;
													_tmp73_ = g_strcmp0 (_tmp72_, "1") == 0;
													_g_free0 (_tmp72_);
													if (_tmp73_) {
														ValaStruct* _tmp74_ = NULL;
														_tmp74_ = st;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp74_, "Version", "experimental", TRUE, NULL);
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp75_ = container;
			_tmp76_ = st;
			vala_gidl_parser_add_symbol_to_container (self, _tmp75_, (ValaSymbol*) _tmp76_);
			_tmp77_ = self->priv->current_source_file;
			_tmp78_ = st;
			vala_source_file_add_node (_tmp77_, (ValaCodeNode*) _tmp78_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp79_ = st;
		_tmp80_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp79_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp80_;
		_tmp81_ = un_node;
		_tmp82_ = _tmp81_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp82_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp83_ = NULL;
					GIdlNodeTypeId _tmp84_ = 0;
					_tmp83_ = member;
					_tmp84_ = _tmp83_->type;
					if (_tmp84_ == G_IDL_NODE_FUNCTION) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp85_ = NULL;
						ValaMethod* _tmp86_ = NULL;
						ValaMethod* _tmp87_ = NULL;
						_tmp85_ = member;
						_tmp86_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp85_, FALSE);
						m = _tmp86_;
						_tmp87_ = m;
						if (_tmp87_ != NULL) {
							ValaStruct* _tmp88_ = NULL;
							ValaMethod* _tmp89_ = NULL;
							_tmp88_ = st;
							_tmp89_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp88_, _tmp89_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp90_ = NULL;
						GIdlNodeTypeId _tmp91_ = 0;
						_tmp90_ = member;
						_tmp91_ = _tmp90_->type;
						if (_tmp91_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp92_ = NULL;
							ValaField* _tmp93_ = NULL;
							ValaField* _tmp94_ = NULL;
							_tmp92_ = member;
							_tmp93_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp92_);
							f = _tmp93_;
							_tmp94_ = f;
							if (_tmp94_ != NULL) {
								ValaStruct* _tmp95_ = NULL;
								ValaField* _tmp96_ = NULL;
								_tmp95_ = st;
								_tmp96_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp95_, _tmp96_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp97_ = NULL;
		ValaScope* _tmp98_ = NULL;
		ValaScope* _tmp99_ = NULL;
		const gchar* _tmp100_ = NULL;
		ValaSymbol* _tmp101_ = NULL;
		ValaClass* _tmp102_ = NULL;
		ValaClass* _tmp103_ = NULL;
		ValaClass* _tmp137_ = NULL;
		ValaTypeSymbol* _tmp138_ = NULL;
		gboolean ref_function_void = FALSE;
		gchar* ref_function = NULL;
		gchar* unref_function = NULL;
		gchar* copy_function = NULL;
		gchar* free_function = NULL;
		GIdlNodeUnion* _tmp139_ = NULL;
		GList* _tmp140_ = NULL;
		const gchar* _tmp183_ = NULL;
		const gchar* _tmp192_ = NULL;
		_tmp97_ = container;
		_tmp98_ = vala_symbol_get_scope (_tmp97_);
		_tmp99_ = _tmp98_;
		_tmp100_ = name;
		_tmp101_ = vala_scope_lookup (_tmp99_, _tmp100_);
		_tmp102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp101_) : NULL;
		if (_tmp102_ == NULL) {
			_vala_code_node_unref0 (_tmp101_);
		}
		cl = _tmp102_;
		_tmp103_ = cl;
		if (_tmp103_ == NULL) {
			const gchar* _tmp104_ = NULL;
			ValaSourceReference* _tmp105_ = NULL;
			ValaClass* _tmp106_ = NULL;
			ValaClass* _tmp107_ = NULL;
			ValaClass* _tmp108_ = NULL;
			gchar** cl_attributes = NULL;
			GIdlNode* _tmp109_ = NULL;
			const gchar* _tmp110_ = NULL;
			gint _tmp111_ = 0;
			gchar** _tmp112_ = NULL;
			gint cl_attributes_length1 = 0;
			gint _cl_attributes_size_ = 0;
			gchar** _tmp113_ = NULL;
			gint _tmp113__length1 = 0;
			ValaSymbol* _tmp133_ = NULL;
			ValaClass* _tmp134_ = NULL;
			ValaSourceFile* _tmp135_ = NULL;
			ValaClass* _tmp136_ = NULL;
			_tmp104_ = name;
			_tmp105_ = self->priv->current_source_reference;
			_tmp106_ = vala_class_new (_tmp104_, _tmp105_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp106_;
			_tmp107_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp107_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp108_ = cl;
			vala_class_set_is_compact (_tmp108_, TRUE);
			_tmp109_ = node;
			_tmp110_ = _tmp109_->name;
			_tmp112_ = vala_gidl_parser_get_attributes (self, _tmp110_, &_tmp111_);
			cl_attributes = _tmp112_;
			cl_attributes_length1 = _tmp111_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp113_ = cl_attributes;
			_tmp113__length1 = cl_attributes_length1;
			if (_tmp113_ != NULL) {
				gchar** _tmp114_ = NULL;
				gint _tmp114__length1 = 0;
				_tmp114_ = cl_attributes;
				_tmp114__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp114_;
					attr_collection_length1 = _tmp114__length1;
					for (attr_it = 0; attr_it < _tmp114__length1; attr_it = attr_it + 1) {
						gchar* _tmp115_ = NULL;
						gchar* attr = NULL;
						_tmp115_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp115_;
						{
							gchar** nv = NULL;
							const gchar* _tmp116_ = NULL;
							gchar** _tmp117_ = NULL;
							gchar** _tmp118_ = NULL;
							gint nv_length1 = 0;
							gint _nv_size_ = 0;
							gchar** _tmp119_ = NULL;
							gint _tmp119__length1 = 0;
							const gchar* _tmp120_ = NULL;
							_tmp116_ = attr;
							_tmp118_ = _tmp117_ = g_strsplit (_tmp116_, "=", 2);
							nv = _tmp118_;
							nv_length1 = _vala_array_length (_tmp117_);
							_nv_size_ = nv_length1;
							_tmp119_ = nv;
							_tmp119__length1 = nv_length1;
							_tmp120_ = _tmp119_[0];
							if (g_strcmp0 (_tmp120_, "cheader_filename") == 0) {
								ValaClass* _tmp121_ = NULL;
								gchar** _tmp122_ = NULL;
								gint _tmp122__length1 = 0;
								const gchar* _tmp123_ = NULL;
								gchar* _tmp124_ = NULL;
								gchar* _tmp125_ = NULL;
								_tmp121_ = cl;
								_tmp122_ = nv;
								_tmp122__length1 = nv_length1;
								_tmp123_ = _tmp122_[1];
								_tmp124_ = vala_gidl_parser_eval (self, _tmp123_);
								_tmp125_ = _tmp124_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp121_, "CCode", "cheader_filename", _tmp125_, NULL);
								_g_free0 (_tmp125_);
							} else {
								gchar** _tmp126_ = NULL;
								gint _tmp126__length1 = 0;
								const gchar* _tmp127_ = NULL;
								_tmp126_ = nv;
								_tmp126__length1 = nv_length1;
								_tmp127_ = _tmp126_[0];
								if (g_strcmp0 (_tmp127_, "hidden") == 0) {
									gchar** _tmp128_ = NULL;
									gint _tmp128__length1 = 0;
									const gchar* _tmp129_ = NULL;
									gchar* _tmp130_ = NULL;
									gchar* _tmp131_ = NULL;
									gboolean _tmp132_ = FALSE;
									_tmp128_ = nv;
									_tmp128__length1 = nv_length1;
									_tmp129_ = _tmp128_[1];
									_tmp130_ = vala_gidl_parser_eval (self, _tmp129_);
									_tmp131_ = _tmp130_;
									_tmp132_ = g_strcmp0 (_tmp131_, "1") == 0;
									_g_free0 (_tmp131_);
									if (_tmp132_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (name);
										return;
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp133_ = container;
			_tmp134_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, _tmp133_, (ValaSymbol*) _tmp134_);
			_tmp135_ = self->priv->current_source_file;
			_tmp136_ = cl;
			vala_source_file_add_node (_tmp135_, (ValaCodeNode*) _tmp136_);
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp137_ = cl;
		_tmp138_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp137_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp138_;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp139_ = un_node;
		_tmp140_ = _tmp139_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp140_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp141_ = NULL;
					GIdlNodeTypeId _tmp142_ = 0;
					_tmp141_ = member;
					_tmp142_ = _tmp141_->type;
					if (_tmp142_ == G_IDL_NODE_FUNCTION) {
						GIdlNode* _tmp143_ = NULL;
						const gchar* _tmp144_ = NULL;
						_tmp143_ = member;
						_tmp144_ = _tmp143_->name;
						if (g_strcmp0 (_tmp144_, "ref") == 0) {
							GIdlNode* _tmp145_ = NULL;
							const gchar* _tmp146_ = NULL;
							gchar* _tmp147_ = NULL;
							GIdlNode* _tmp148_ = NULL;
							GIdlNodeParam* _tmp149_ = NULL;
							GIdlNodeType* _tmp150_ = NULL;
							ValaDataType* _tmp151_ = NULL;
							ValaDataType* _tmp152_ = NULL;
							_tmp145_ = member;
							_tmp146_ = ((GIdlNodeFunction*) _tmp145_)->symbol;
							_tmp147_ = g_strdup (_tmp146_);
							_g_free0 (ref_function);
							ref_function = _tmp147_;
							_tmp148_ = member;
							_tmp149_ = ((GIdlNodeFunction*) _tmp148_)->result;
							_tmp150_ = _tmp149_->type;
							_tmp151_ = vala_gidl_parser_parse_type (self, _tmp150_, NULL);
							_tmp152_ = _tmp151_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp152_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp152_);
						} else {
							GIdlNode* _tmp153_ = NULL;
							const gchar* _tmp154_ = NULL;
							_tmp153_ = member;
							_tmp154_ = _tmp153_->name;
							if (g_strcmp0 (_tmp154_, "unref") == 0) {
								GIdlNode* _tmp155_ = NULL;
								const gchar* _tmp156_ = NULL;
								gchar* _tmp157_ = NULL;
								_tmp155_ = member;
								_tmp156_ = ((GIdlNodeFunction*) _tmp155_)->symbol;
								_tmp157_ = g_strdup (_tmp156_);
								_g_free0 (unref_function);
								unref_function = _tmp157_;
							} else {
								gboolean _tmp158_ = FALSE;
								GIdlNode* _tmp159_ = NULL;
								const gchar* _tmp160_ = NULL;
								_tmp159_ = member;
								_tmp160_ = _tmp159_->name;
								if (g_strcmp0 (_tmp160_, "free") == 0) {
									_tmp158_ = TRUE;
								} else {
									GIdlNode* _tmp161_ = NULL;
									const gchar* _tmp162_ = NULL;
									_tmp161_ = member;
									_tmp162_ = _tmp161_->name;
									_tmp158_ = g_strcmp0 (_tmp162_, "destroy") == 0;
								}
								if (_tmp158_) {
									GIdlNode* _tmp163_ = NULL;
									const gchar* _tmp164_ = NULL;
									gchar* _tmp165_ = NULL;
									_tmp163_ = member;
									_tmp164_ = ((GIdlNodeFunction*) _tmp163_)->symbol;
									_tmp165_ = g_strdup (_tmp164_);
									_g_free0 (free_function);
									free_function = _tmp165_;
								} else {
									GIdlNode* _tmp166_ = NULL;
									const gchar* _tmp167_ = NULL;
									ValaMethod* m = NULL;
									GIdlNode* _tmp171_ = NULL;
									ValaMethod* _tmp172_ = NULL;
									ValaMethod* _tmp173_ = NULL;
									_tmp166_ = member;
									_tmp167_ = _tmp166_->name;
									if (g_strcmp0 (_tmp167_, "copy") == 0) {
										GIdlNode* _tmp168_ = NULL;
										const gchar* _tmp169_ = NULL;
										gchar* _tmp170_ = NULL;
										_tmp168_ = member;
										_tmp169_ = ((GIdlNodeFunction*) _tmp168_)->symbol;
										_tmp170_ = g_strdup (_tmp169_);
										_g_free0 (copy_function);
										copy_function = _tmp170_;
									}
									_tmp171_ = member;
									_tmp172_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp171_, FALSE);
									m = _tmp172_;
									_tmp173_ = m;
									if (_tmp173_ != NULL) {
										ValaClass* _tmp174_ = NULL;
										ValaMethod* _tmp175_ = NULL;
										_tmp174_ = cl;
										_tmp175_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp174_, _tmp175_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp176_ = NULL;
						GIdlNodeTypeId _tmp177_ = 0;
						_tmp176_ = member;
						_tmp177_ = _tmp176_->type;
						if (_tmp177_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp178_ = NULL;
							ValaField* _tmp179_ = NULL;
							ValaField* _tmp180_ = NULL;
							_tmp178_ = member;
							_tmp179_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp178_);
							f = _tmp179_;
							_tmp180_ = f;
							if (_tmp180_ != NULL) {
								ValaClass* _tmp181_ = NULL;
								ValaField* _tmp182_ = NULL;
								_tmp181_ = cl;
								_tmp182_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp181_, _tmp182_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp183_ = ref_function;
		if (_tmp183_ != NULL) {
			ValaClass* _tmp184_ = NULL;
			const gchar* _tmp185_ = NULL;
			gboolean _tmp186_ = FALSE;
			_tmp184_ = cl;
			_tmp185_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp184_, "CCode", "ref_function", _tmp185_, NULL);
			_tmp186_ = ref_function_void;
			if (_tmp186_) {
				ValaClass* _tmp187_ = NULL;
				gboolean _tmp188_ = FALSE;
				_tmp187_ = cl;
				_tmp188_ = ref_function_void;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp187_, "CCode", "ref_function_void", _tmp188_, NULL);
			}
		} else {
			const gchar* _tmp189_ = NULL;
			_tmp189_ = copy_function;
			if (_tmp189_ != NULL) {
				ValaClass* _tmp190_ = NULL;
				const gchar* _tmp191_ = NULL;
				_tmp190_ = cl;
				_tmp191_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp190_, "CCode", "copy_function", _tmp191_, NULL);
			}
		}
		_tmp192_ = unref_function;
		if (_tmp192_ != NULL) {
			ValaClass* _tmp193_ = NULL;
			const gchar* _tmp194_ = NULL;
			_tmp193_ = cl;
			_tmp194_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp193_, "CCode", "unref_function", _tmp194_, NULL);
		} else {
			gboolean _tmp195_ = FALSE;
			const gchar* _tmp196_ = NULL;
			_tmp196_ = free_function;
			if (_tmp196_ != NULL) {
				const gchar* _tmp197_ = NULL;
				ValaClass* _tmp198_ = NULL;
				gchar* _tmp199_ = NULL;
				gchar* _tmp200_ = NULL;
				gchar* _tmp201_ = NULL;
				gchar* _tmp202_ = NULL;
				_tmp197_ = free_function;
				_tmp198_ = cl;
				_tmp199_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp198_);
				_tmp200_ = _tmp199_;
				_tmp201_ = g_strdup_printf ("%sfree", _tmp200_);
				_tmp202_ = _tmp201_;
				_tmp195_ = g_strcmp0 (_tmp197_, _tmp202_) != 0;
				_g_free0 (_tmp202_);
				_g_free0 (_tmp200_);
			} else {
				_tmp195_ = FALSE;
			}
			if (_tmp195_) {
				ValaClass* _tmp203_ = NULL;
				const gchar* _tmp204_ = NULL;
				_tmp203_ = cl;
				_tmp204_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp203_, "CCode", "free_function", _tmp204_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
		_vala_code_node_unref0 (cl);
	}
	_g_free0 (name);
}


static void vala_gidl_parser_parse_boxed (ValaGIdlParser* self, GIdlNodeBoxed* boxed_node, ValaSymbol* container, GIdlModule* module) {
	GIdlNode* node = NULL;
	GIdlNodeBoxed* _tmp0_ = NULL;
	gchar* name = NULL;
	GIdlNode* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	ValaSymbol* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar** node_attributes = NULL;
	GIdlNode* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gchar** _tmp8_ = NULL;
	gint node_attributes_length1 = 0;
	gint _node_attributes_size_ = 0;
	gchar** _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	GIdlNode* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (boxed_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = boxed_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = node;
	_tmp2_ = _tmp1_->name;
	_tmp3_ = container;
	_tmp4_ = vala_gidl_parser_fix_type_name (self, _tmp2_, _tmp3_);
	name = _tmp4_;
	_tmp5_ = node;
	_tmp6_ = _tmp5_->name;
	_tmp8_ = vala_gidl_parser_get_attributes (self, _tmp6_, &_tmp7_);
	node_attributes = _tmp8_;
	node_attributes_length1 = _tmp7_;
	_node_attributes_size_ = node_attributes_length1;
	_tmp9_ = node_attributes;
	_tmp9__length1 = node_attributes_length1;
	if (_tmp9_ != NULL) {
		gchar** _tmp10_ = NULL;
		gint _tmp10__length1 = 0;
		_tmp10_ = node_attributes;
		_tmp10__length1 = node_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp10_;
			attr_collection_length1 = _tmp10__length1;
			for (attr_it = 0; attr_it < _tmp10__length1; attr_it = attr_it + 1) {
				gchar* _tmp11_ = NULL;
				gchar* attr = NULL;
				_tmp11_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp11_;
				{
					gchar** nv = NULL;
					const gchar* _tmp12_ = NULL;
					gchar** _tmp13_ = NULL;
					gchar** _tmp14_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					const gchar* _tmp16_ = NULL;
					_tmp12_ = attr;
					_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, "=", 2);
					nv = _tmp14_;
					nv_length1 = _vala_array_length (_tmp13_);
					_nv_size_ = nv_length1;
					_tmp15_ = nv;
					_tmp15__length1 = nv_length1;
					_tmp16_ = _tmp15_[0];
					if (g_strcmp0 (_tmp16_, "hidden") == 0) {
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
						node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (name);
						return;
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp17_ = node;
	_tmp18_ = _tmp17_->name;
	_tmp19_ = vala_gidl_parser_is_reference_type (self, _tmp18_);
	if (!_tmp19_) {
		ValaStruct* st = NULL;
		ValaSymbol* _tmp20_ = NULL;
		ValaScope* _tmp21_ = NULL;
		ValaScope* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		ValaSymbol* _tmp24_ = NULL;
		ValaStruct* _tmp25_ = NULL;
		ValaStruct* _tmp26_ = NULL;
		ValaStruct* _tmp106_ = NULL;
		ValaTypeSymbol* _tmp107_ = NULL;
		GIdlNodeBoxed* _tmp108_ = NULL;
		GList* _tmp109_ = NULL;
		_tmp20_ = container;
		_tmp21_ = vala_symbol_get_scope (_tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = name;
		_tmp24_ = vala_scope_lookup (_tmp22_, _tmp23_);
		_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp24_) : NULL;
		if (_tmp25_ == NULL) {
			_vala_code_node_unref0 (_tmp24_);
		}
		st = _tmp25_;
		_tmp26_ = st;
		if (_tmp26_ == NULL) {
			const gchar* _tmp27_ = NULL;
			ValaSourceReference* _tmp28_ = NULL;
			ValaStruct* _tmp29_ = NULL;
			ValaStruct* _tmp30_ = NULL;
			gchar** st_attributes = NULL;
			GIdlNode* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gchar** _tmp34_ = NULL;
			gint st_attributes_length1 = 0;
			gint _st_attributes_size_ = 0;
			gchar** _tmp35_ = NULL;
			gint _tmp35__length1 = 0;
			ValaSymbol* _tmp102_ = NULL;
			ValaStruct* _tmp103_ = NULL;
			ValaSourceFile* _tmp104_ = NULL;
			ValaStruct* _tmp105_ = NULL;
			_tmp27_ = name;
			_tmp28_ = self->priv->current_source_reference;
			_tmp29_ = vala_struct_new (_tmp27_, _tmp28_, NULL);
			_vala_code_node_unref0 (st);
			st = _tmp29_;
			_tmp30_ = st;
			vala_symbol_set_access ((ValaSymbol*) _tmp30_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp31_ = node;
			_tmp32_ = _tmp31_->name;
			_tmp34_ = vala_gidl_parser_get_attributes (self, _tmp32_, &_tmp33_);
			st_attributes = _tmp34_;
			st_attributes_length1 = _tmp33_;
			_st_attributes_size_ = st_attributes_length1;
			_tmp35_ = st_attributes;
			_tmp35__length1 = st_attributes_length1;
			if (_tmp35_ != NULL) {
				gchar** _tmp36_ = NULL;
				gint _tmp36__length1 = 0;
				_tmp36_ = st_attributes;
				_tmp36__length1 = st_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp36_;
					attr_collection_length1 = _tmp36__length1;
					for (attr_it = 0; attr_it < _tmp36__length1; attr_it = attr_it + 1) {
						gchar* _tmp37_ = NULL;
						gchar* attr = NULL;
						_tmp37_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp37_;
						{
							gchar** nv = NULL;
							const gchar* _tmp38_ = NULL;
							gchar** _tmp39_ = NULL;
							gchar** _tmp40_ = NULL;
							gint nv_length1 = 0;
							gint _nv_size_ = 0;
							gchar** _tmp41_ = NULL;
							gint _tmp41__length1 = 0;
							const gchar* _tmp42_ = NULL;
							_tmp38_ = attr;
							_tmp40_ = _tmp39_ = g_strsplit (_tmp38_, "=", 2);
							nv = _tmp40_;
							nv_length1 = _vala_array_length (_tmp39_);
							_nv_size_ = nv_length1;
							_tmp41_ = nv;
							_tmp41__length1 = nv_length1;
							_tmp42_ = _tmp41_[0];
							if (g_strcmp0 (_tmp42_, "cheader_filename") == 0) {
								ValaStruct* _tmp43_ = NULL;
								gchar** _tmp44_ = NULL;
								gint _tmp44__length1 = 0;
								const gchar* _tmp45_ = NULL;
								gchar* _tmp46_ = NULL;
								gchar* _tmp47_ = NULL;
								_tmp43_ = st;
								_tmp44_ = nv;
								_tmp44__length1 = nv_length1;
								_tmp45_ = _tmp44_[1];
								_tmp46_ = vala_gidl_parser_eval (self, _tmp45_);
								_tmp47_ = _tmp46_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp43_, "CCode", "cheader_filename", _tmp47_, NULL);
								_g_free0 (_tmp47_);
							} else {
								gchar** _tmp48_ = NULL;
								gint _tmp48__length1 = 0;
								const gchar* _tmp49_ = NULL;
								_tmp48_ = nv;
								_tmp48__length1 = nv_length1;
								_tmp49_ = _tmp48_[0];
								if (g_strcmp0 (_tmp49_, "deprecated") == 0) {
									gchar** _tmp50_ = NULL;
									gint _tmp50__length1 = 0;
									const gchar* _tmp51_ = NULL;
									gchar* _tmp52_ = NULL;
									gchar* _tmp53_ = NULL;
									gboolean _tmp54_ = FALSE;
									_tmp50_ = nv;
									_tmp50__length1 = nv_length1;
									_tmp51_ = _tmp50_[1];
									_tmp52_ = vala_gidl_parser_eval (self, _tmp51_);
									_tmp53_ = _tmp52_;
									_tmp54_ = g_strcmp0 (_tmp53_, "1") == 0;
									_g_free0 (_tmp53_);
									if (_tmp54_) {
										ValaStruct* _tmp55_ = NULL;
										_tmp55_ = st;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp55_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp56_ = NULL;
									gint _tmp56__length1 = 0;
									const gchar* _tmp57_ = NULL;
									_tmp56_ = nv;
									_tmp56__length1 = nv_length1;
									_tmp57_ = _tmp56_[0];
									if (g_strcmp0 (_tmp57_, "replacement") == 0) {
										ValaStruct* _tmp58_ = NULL;
										gchar** _tmp59_ = NULL;
										gint _tmp59__length1 = 0;
										const gchar* _tmp60_ = NULL;
										gchar* _tmp61_ = NULL;
										gchar* _tmp62_ = NULL;
										_tmp58_ = st;
										_tmp59_ = nv;
										_tmp59__length1 = nv_length1;
										_tmp60_ = _tmp59_[1];
										_tmp61_ = vala_gidl_parser_eval (self, _tmp60_);
										_tmp62_ = _tmp61_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp58_, "Version", "replacement", _tmp62_, NULL);
										_g_free0 (_tmp62_);
									} else {
										gchar** _tmp63_ = NULL;
										gint _tmp63__length1 = 0;
										const gchar* _tmp64_ = NULL;
										_tmp63_ = nv;
										_tmp63__length1 = nv_length1;
										_tmp64_ = _tmp63_[0];
										if (g_strcmp0 (_tmp64_, "deprecated_since") == 0) {
											ValaStruct* _tmp65_ = NULL;
											gchar** _tmp66_ = NULL;
											gint _tmp66__length1 = 0;
											const gchar* _tmp67_ = NULL;
											gchar* _tmp68_ = NULL;
											gchar* _tmp69_ = NULL;
											_tmp65_ = st;
											_tmp66_ = nv;
											_tmp66__length1 = nv_length1;
											_tmp67_ = _tmp66_[1];
											_tmp68_ = vala_gidl_parser_eval (self, _tmp67_);
											_tmp69_ = _tmp68_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp65_, "Version", "deprecated_since", _tmp69_, NULL);
											_g_free0 (_tmp69_);
										} else {
											gchar** _tmp70_ = NULL;
											gint _tmp70__length1 = 0;
											const gchar* _tmp71_ = NULL;
											_tmp70_ = nv;
											_tmp70__length1 = nv_length1;
											_tmp71_ = _tmp70_[0];
											if (g_strcmp0 (_tmp71_, "immutable") == 0) {
												gchar** _tmp72_ = NULL;
												gint _tmp72__length1 = 0;
												const gchar* _tmp73_ = NULL;
												gchar* _tmp74_ = NULL;
												gchar* _tmp75_ = NULL;
												gboolean _tmp76_ = FALSE;
												_tmp72_ = nv;
												_tmp72__length1 = nv_length1;
												_tmp73_ = _tmp72_[1];
												_tmp74_ = vala_gidl_parser_eval (self, _tmp73_);
												_tmp75_ = _tmp74_;
												_tmp76_ = g_strcmp0 (_tmp75_, "1") == 0;
												_g_free0 (_tmp75_);
												if (_tmp76_) {
													ValaStruct* _tmp77_ = NULL;
													_tmp77_ = st;
													vala_code_node_set_attribute ((ValaCodeNode*) _tmp77_, "Immutable", TRUE, NULL);
												}
											} else {
												gchar** _tmp78_ = NULL;
												gint _tmp78__length1 = 0;
												const gchar* _tmp79_ = NULL;
												_tmp78_ = nv;
												_tmp78__length1 = nv_length1;
												_tmp79_ = _tmp78_[0];
												if (g_strcmp0 (_tmp79_, "has_copy_function") == 0) {
													gchar** _tmp80_ = NULL;
													gint _tmp80__length1 = 0;
													const gchar* _tmp81_ = NULL;
													gchar* _tmp82_ = NULL;
													gchar* _tmp83_ = NULL;
													gboolean _tmp84_ = FALSE;
													_tmp80_ = nv;
													_tmp80__length1 = nv_length1;
													_tmp81_ = _tmp80_[1];
													_tmp82_ = vala_gidl_parser_eval (self, _tmp81_);
													_tmp83_ = _tmp82_;
													_tmp84_ = g_strcmp0 (_tmp83_, "0") == 0;
													_g_free0 (_tmp83_);
													if (_tmp84_) {
														ValaStruct* _tmp85_ = NULL;
														_tmp85_ = st;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp85_, "CCode", "has_copy_function", FALSE, NULL);
													}
												} else {
													gchar** _tmp86_ = NULL;
													gint _tmp86__length1 = 0;
													const gchar* _tmp87_ = NULL;
													_tmp86_ = nv;
													_tmp86__length1 = nv_length1;
													_tmp87_ = _tmp86_[0];
													if (g_strcmp0 (_tmp87_, "has_destroy_function") == 0) {
														gchar** _tmp88_ = NULL;
														gint _tmp88__length1 = 0;
														const gchar* _tmp89_ = NULL;
														gchar* _tmp90_ = NULL;
														gchar* _tmp91_ = NULL;
														gboolean _tmp92_ = FALSE;
														_tmp88_ = nv;
														_tmp88__length1 = nv_length1;
														_tmp89_ = _tmp88_[1];
														_tmp90_ = vala_gidl_parser_eval (self, _tmp89_);
														_tmp91_ = _tmp90_;
														_tmp92_ = g_strcmp0 (_tmp91_, "0") == 0;
														_g_free0 (_tmp91_);
														if (_tmp92_) {
															ValaStruct* _tmp93_ = NULL;
															_tmp93_ = st;
															vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp93_, "CCode", "has_destroy_function", FALSE, NULL);
														}
													} else {
														gchar** _tmp94_ = NULL;
														gint _tmp94__length1 = 0;
														const gchar* _tmp95_ = NULL;
														_tmp94_ = nv;
														_tmp94__length1 = nv_length1;
														_tmp95_ = _tmp94_[0];
														if (g_strcmp0 (_tmp95_, "experimental") == 0) {
															gchar** _tmp96_ = NULL;
															gint _tmp96__length1 = 0;
															const gchar* _tmp97_ = NULL;
															gchar* _tmp98_ = NULL;
															gchar* _tmp99_ = NULL;
															gboolean _tmp100_ = FALSE;
															_tmp96_ = nv;
															_tmp96__length1 = nv_length1;
															_tmp97_ = _tmp96_[1];
															_tmp98_ = vala_gidl_parser_eval (self, _tmp97_);
															_tmp99_ = _tmp98_;
															_tmp100_ = g_strcmp0 (_tmp99_, "1") == 0;
															_g_free0 (_tmp99_);
															if (_tmp100_) {
																ValaStruct* _tmp101_ = NULL;
																_tmp101_ = st;
																vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp101_, "Version", "experimental", TRUE, NULL);
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp102_ = container;
			_tmp103_ = st;
			vala_gidl_parser_add_symbol_to_container (self, _tmp102_, (ValaSymbol*) _tmp103_);
			_tmp104_ = self->priv->current_source_file;
			_tmp105_ = st;
			vala_source_file_add_node (_tmp104_, (ValaCodeNode*) _tmp105_);
			st_attributes = (_vala_array_free (st_attributes, st_attributes_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp106_ = st;
		_tmp107_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp106_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp107_;
		_tmp108_ = boxed_node;
		_tmp109_ = _tmp108_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp109_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp110_ = NULL;
					GIdlNodeTypeId _tmp111_ = 0;
					_tmp110_ = member;
					_tmp111_ = _tmp110_->type;
					if (_tmp111_ == G_IDL_NODE_FUNCTION) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp112_ = NULL;
						ValaMethod* _tmp113_ = NULL;
						ValaMethod* _tmp114_ = NULL;
						_tmp112_ = member;
						_tmp113_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp112_, FALSE);
						m = _tmp113_;
						_tmp114_ = m;
						if (_tmp114_ != NULL) {
							ValaStruct* _tmp115_ = NULL;
							ValaMethod* _tmp116_ = NULL;
							_tmp115_ = st;
							_tmp116_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp115_, _tmp116_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp117_ = NULL;
						GIdlNodeTypeId _tmp118_ = 0;
						_tmp117_ = member;
						_tmp118_ = _tmp117_->type;
						if (_tmp118_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp119_ = NULL;
							ValaField* _tmp120_ = NULL;
							ValaField* _tmp121_ = NULL;
							_tmp119_ = member;
							_tmp120_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp119_);
							f = _tmp120_;
							_tmp121_ = f;
							if (_tmp121_ != NULL) {
								ValaStruct* _tmp122_ = NULL;
								ValaField* _tmp123_ = NULL;
								_tmp122_ = st;
								_tmp123_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp122_, _tmp123_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (st);
	} else {
		gboolean ref_function_void = FALSE;
		gchar* ref_function = NULL;
		gchar* unref_function = NULL;
		gchar* copy_function = NULL;
		gchar* free_function = NULL;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp124_ = NULL;
		ValaScope* _tmp125_ = NULL;
		ValaScope* _tmp126_ = NULL;
		const gchar* _tmp127_ = NULL;
		ValaSymbol* _tmp128_ = NULL;
		ValaClass* _tmp129_ = NULL;
		ValaClass* _tmp130_ = NULL;
		ValaClass* _tmp246_ = NULL;
		ValaTypeSymbol* _tmp247_ = NULL;
		GIdlNodeBoxed* _tmp248_ = NULL;
		GList* _tmp249_ = NULL;
		const gchar* _tmp292_ = NULL;
		const gchar* _tmp301_ = NULL;
		ref_function_void = FALSE;
		ref_function = NULL;
		unref_function = NULL;
		copy_function = NULL;
		free_function = NULL;
		_tmp124_ = container;
		_tmp125_ = vala_symbol_get_scope (_tmp124_);
		_tmp126_ = _tmp125_;
		_tmp127_ = name;
		_tmp128_ = vala_scope_lookup (_tmp126_, _tmp127_);
		_tmp129_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp128_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp128_) : NULL;
		if (_tmp129_ == NULL) {
			_vala_code_node_unref0 (_tmp128_);
		}
		cl = _tmp129_;
		_tmp130_ = cl;
		if (_tmp130_ == NULL) {
			gchar* base_class = NULL;
			const gchar* _tmp131_ = NULL;
			ValaSourceReference* _tmp132_ = NULL;
			ValaClass* _tmp133_ = NULL;
			ValaClass* _tmp134_ = NULL;
			ValaClass* _tmp135_ = NULL;
			GIdlNodeBoxed* _tmp136_ = NULL;
			const gchar* _tmp137_ = NULL;
			gchar** cl_attributes = NULL;
			GIdlNode* _tmp143_ = NULL;
			const gchar* _tmp144_ = NULL;
			gint _tmp145_ = 0;
			gchar** _tmp146_ = NULL;
			gint cl_attributes_length1 = 0;
			gint _cl_attributes_size_ = 0;
			gchar** _tmp147_ = NULL;
			gint _tmp147__length1 = 0;
			ValaSymbol* _tmp237_ = NULL;
			ValaClass* _tmp238_ = NULL;
			ValaSourceFile* _tmp239_ = NULL;
			ValaClass* _tmp240_ = NULL;
			const gchar* _tmp241_ = NULL;
			base_class = NULL;
			_tmp131_ = name;
			_tmp132_ = self->priv->current_source_reference;
			_tmp133_ = vala_class_new (_tmp131_, _tmp132_, NULL);
			_vala_code_node_unref0 (cl);
			cl = _tmp133_;
			_tmp134_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp134_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp135_ = cl;
			vala_class_set_is_compact (_tmp135_, TRUE);
			_tmp136_ = boxed_node;
			_tmp137_ = _tmp136_->gtype_init;
			if (_tmp137_ != NULL) {
				ValaClass* _tmp138_ = NULL;
				GIdlNodeBoxed* _tmp139_ = NULL;
				const gchar* _tmp140_ = NULL;
				gchar* _tmp141_ = NULL;
				gchar* _tmp142_ = NULL;
				_tmp138_ = cl;
				_tmp139_ = boxed_node;
				_tmp140_ = _tmp139_->gtype_init;
				_tmp141_ = g_strdup_printf ("%s ()", _tmp140_);
				_tmp142_ = _tmp141_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp138_, "CCode", "type_id", _tmp142_, NULL);
				_g_free0 (_tmp142_);
			}
			_tmp143_ = node;
			_tmp144_ = _tmp143_->name;
			_tmp146_ = vala_gidl_parser_get_attributes (self, _tmp144_, &_tmp145_);
			cl_attributes = _tmp146_;
			cl_attributes_length1 = _tmp145_;
			_cl_attributes_size_ = cl_attributes_length1;
			_tmp147_ = cl_attributes;
			_tmp147__length1 = cl_attributes_length1;
			if (_tmp147_ != NULL) {
				gchar** _tmp148_ = NULL;
				gint _tmp148__length1 = 0;
				_tmp148_ = cl_attributes;
				_tmp148__length1 = cl_attributes_length1;
				{
					gchar** attr_collection = NULL;
					gint attr_collection_length1 = 0;
					gint _attr_collection_size_ = 0;
					gint attr_it = 0;
					attr_collection = _tmp148_;
					attr_collection_length1 = _tmp148__length1;
					for (attr_it = 0; attr_it < _tmp148__length1; attr_it = attr_it + 1) {
						gchar* _tmp149_ = NULL;
						gchar* attr = NULL;
						_tmp149_ = g_strdup (attr_collection[attr_it]);
						attr = _tmp149_;
						{
							gchar** nv = NULL;
							const gchar* _tmp150_ = NULL;
							gchar** _tmp151_ = NULL;
							gchar** _tmp152_ = NULL;
							gint nv_length1 = 0;
							gint _nv_size_ = 0;
							gchar** _tmp153_ = NULL;
							gint _tmp153__length1 = 0;
							const gchar* _tmp154_ = NULL;
							_tmp150_ = attr;
							_tmp152_ = _tmp151_ = g_strsplit (_tmp150_, "=", 2);
							nv = _tmp152_;
							nv_length1 = _vala_array_length (_tmp151_);
							_nv_size_ = nv_length1;
							_tmp153_ = nv;
							_tmp153__length1 = nv_length1;
							_tmp154_ = _tmp153_[0];
							if (g_strcmp0 (_tmp154_, "cheader_filename") == 0) {
								ValaClass* _tmp155_ = NULL;
								gchar** _tmp156_ = NULL;
								gint _tmp156__length1 = 0;
								const gchar* _tmp157_ = NULL;
								gchar* _tmp158_ = NULL;
								gchar* _tmp159_ = NULL;
								_tmp155_ = cl;
								_tmp156_ = nv;
								_tmp156__length1 = nv_length1;
								_tmp157_ = _tmp156_[1];
								_tmp158_ = vala_gidl_parser_eval (self, _tmp157_);
								_tmp159_ = _tmp158_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp155_, "CCode", "cheader_filename", _tmp159_, NULL);
								_g_free0 (_tmp159_);
							} else {
								gchar** _tmp160_ = NULL;
								gint _tmp160__length1 = 0;
								const gchar* _tmp161_ = NULL;
								_tmp160_ = nv;
								_tmp160__length1 = nv_length1;
								_tmp161_ = _tmp160_[0];
								if (g_strcmp0 (_tmp161_, "base_class") == 0) {
									gchar** _tmp162_ = NULL;
									gint _tmp162__length1 = 0;
									const gchar* _tmp163_ = NULL;
									gchar* _tmp164_ = NULL;
									_tmp162_ = nv;
									_tmp162__length1 = nv_length1;
									_tmp163_ = _tmp162_[1];
									_tmp164_ = vala_gidl_parser_eval (self, _tmp163_);
									_g_free0 (base_class);
									base_class = _tmp164_;
								} else {
									gchar** _tmp165_ = NULL;
									gint _tmp165__length1 = 0;
									const gchar* _tmp166_ = NULL;
									_tmp165_ = nv;
									_tmp165__length1 = nv_length1;
									_tmp166_ = _tmp165_[0];
									if (g_strcmp0 (_tmp166_, "is_immutable") == 0) {
										gchar** _tmp167_ = NULL;
										gint _tmp167__length1 = 0;
										const gchar* _tmp168_ = NULL;
										gchar* _tmp169_ = NULL;
										gchar* _tmp170_ = NULL;
										gboolean _tmp171_ = FALSE;
										_tmp167_ = nv;
										_tmp167__length1 = nv_length1;
										_tmp168_ = _tmp167_[1];
										_tmp169_ = vala_gidl_parser_eval (self, _tmp168_);
										_tmp170_ = _tmp169_;
										_tmp171_ = g_strcmp0 (_tmp170_, "1") == 0;
										_g_free0 (_tmp170_);
										if (_tmp171_) {
											ValaClass* _tmp172_ = NULL;
											_tmp172_ = cl;
											vala_class_set_is_immutable (_tmp172_, TRUE);
										}
									} else {
										gchar** _tmp173_ = NULL;
										gint _tmp173__length1 = 0;
										const gchar* _tmp174_ = NULL;
										_tmp173_ = nv;
										_tmp173__length1 = nv_length1;
										_tmp174_ = _tmp173_[0];
										if (g_strcmp0 (_tmp174_, "deprecated") == 0) {
											gchar** _tmp175_ = NULL;
											gint _tmp175__length1 = 0;
											const gchar* _tmp176_ = NULL;
											gchar* _tmp177_ = NULL;
											gchar* _tmp178_ = NULL;
											gboolean _tmp179_ = FALSE;
											_tmp175_ = nv;
											_tmp175__length1 = nv_length1;
											_tmp176_ = _tmp175_[1];
											_tmp177_ = vala_gidl_parser_eval (self, _tmp176_);
											_tmp178_ = _tmp177_;
											_tmp179_ = g_strcmp0 (_tmp178_, "1") == 0;
											_g_free0 (_tmp178_);
											if (_tmp179_) {
												ValaClass* _tmp180_ = NULL;
												_tmp180_ = cl;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp180_, "Version", "deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp181_ = NULL;
											gint _tmp181__length1 = 0;
											const gchar* _tmp182_ = NULL;
											_tmp181_ = nv;
											_tmp181__length1 = nv_length1;
											_tmp182_ = _tmp181_[0];
											if (g_strcmp0 (_tmp182_, "replacement") == 0) {
												ValaClass* _tmp183_ = NULL;
												gchar** _tmp184_ = NULL;
												gint _tmp184__length1 = 0;
												const gchar* _tmp185_ = NULL;
												gchar* _tmp186_ = NULL;
												gchar* _tmp187_ = NULL;
												_tmp183_ = cl;
												_tmp184_ = nv;
												_tmp184__length1 = nv_length1;
												_tmp185_ = _tmp184_[1];
												_tmp186_ = vala_gidl_parser_eval (self, _tmp185_);
												_tmp187_ = _tmp186_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp183_, "Version", "replacement", _tmp187_, NULL);
												_g_free0 (_tmp187_);
											} else {
												gchar** _tmp188_ = NULL;
												gint _tmp188__length1 = 0;
												const gchar* _tmp189_ = NULL;
												_tmp188_ = nv;
												_tmp188__length1 = nv_length1;
												_tmp189_ = _tmp188_[0];
												if (g_strcmp0 (_tmp189_, "deprecated_since") == 0) {
													ValaClass* _tmp190_ = NULL;
													gchar** _tmp191_ = NULL;
													gint _tmp191__length1 = 0;
													const gchar* _tmp192_ = NULL;
													gchar* _tmp193_ = NULL;
													gchar* _tmp194_ = NULL;
													_tmp190_ = cl;
													_tmp191_ = nv;
													_tmp191__length1 = nv_length1;
													_tmp192_ = _tmp191_[1];
													_tmp193_ = vala_gidl_parser_eval (self, _tmp192_);
													_tmp194_ = _tmp193_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp190_, "Version", "deprecated_since", _tmp194_, NULL);
													_g_free0 (_tmp194_);
												} else {
													gchar** _tmp195_ = NULL;
													gint _tmp195__length1 = 0;
													const gchar* _tmp196_ = NULL;
													_tmp195_ = nv;
													_tmp195__length1 = nv_length1;
													_tmp196_ = _tmp195_[0];
													if (g_strcmp0 (_tmp196_, "const_cname") == 0) {
														ValaClass* _tmp197_ = NULL;
														gchar** _tmp198_ = NULL;
														gint _tmp198__length1 = 0;
														const gchar* _tmp199_ = NULL;
														gchar* _tmp200_ = NULL;
														gchar* _tmp201_ = NULL;
														_tmp197_ = cl;
														_tmp198_ = nv;
														_tmp198__length1 = nv_length1;
														_tmp199_ = _tmp198_[1];
														_tmp200_ = vala_gidl_parser_eval (self, _tmp199_);
														_tmp201_ = _tmp200_;
														vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp197_, "CCode", "const_cname", _tmp201_, NULL);
														_g_free0 (_tmp201_);
													} else {
														gchar** _tmp202_ = NULL;
														gint _tmp202__length1 = 0;
														const gchar* _tmp203_ = NULL;
														_tmp202_ = nv;
														_tmp202__length1 = nv_length1;
														_tmp203_ = _tmp202_[0];
														if (g_strcmp0 (_tmp203_, "free_function") == 0) {
															gchar** _tmp204_ = NULL;
															gint _tmp204__length1 = 0;
															const gchar* _tmp205_ = NULL;
															gchar* _tmp206_ = NULL;
															_tmp204_ = nv;
															_tmp204__length1 = nv_length1;
															_tmp205_ = _tmp204_[1];
															_tmp206_ = vala_gidl_parser_eval (self, _tmp205_);
															_g_free0 (free_function);
															free_function = _tmp206_;
														} else {
															gchar** _tmp207_ = NULL;
															gint _tmp207__length1 = 0;
															const gchar* _tmp208_ = NULL;
															_tmp207_ = nv;
															_tmp207__length1 = nv_length1;
															_tmp208_ = _tmp207_[0];
															if (g_strcmp0 (_tmp208_, "ref_function") == 0) {
																gchar** _tmp209_ = NULL;
																gint _tmp209__length1 = 0;
																const gchar* _tmp210_ = NULL;
																gchar* _tmp211_ = NULL;
																_tmp209_ = nv;
																_tmp209__length1 = nv_length1;
																_tmp210_ = _tmp209_[1];
																_tmp211_ = vala_gidl_parser_eval (self, _tmp210_);
																_g_free0 (ref_function);
																ref_function = _tmp211_;
															} else {
																gchar** _tmp212_ = NULL;
																gint _tmp212__length1 = 0;
																const gchar* _tmp213_ = NULL;
																_tmp212_ = nv;
																_tmp212__length1 = nv_length1;
																_tmp213_ = _tmp212_[0];
																if (g_strcmp0 (_tmp213_, "unref_function") == 0) {
																	gchar** _tmp214_ = NULL;
																	gint _tmp214__length1 = 0;
																	const gchar* _tmp215_ = NULL;
																	gchar* _tmp216_ = NULL;
																	_tmp214_ = nv;
																	_tmp214__length1 = nv_length1;
																	_tmp215_ = _tmp214_[1];
																	_tmp216_ = vala_gidl_parser_eval (self, _tmp215_);
																	_g_free0 (unref_function);
																	unref_function = _tmp216_;
																} else {
																	gchar** _tmp217_ = NULL;
																	gint _tmp217__length1 = 0;
																	const gchar* _tmp218_ = NULL;
																	_tmp217_ = nv;
																	_tmp217__length1 = nv_length1;
																	_tmp218_ = _tmp217_[0];
																	if (g_strcmp0 (_tmp218_, "copy_function") == 0) {
																		gchar** _tmp219_ = NULL;
																		gint _tmp219__length1 = 0;
																		const gchar* _tmp220_ = NULL;
																		gchar* _tmp221_ = NULL;
																		_tmp219_ = nv;
																		_tmp219__length1 = nv_length1;
																		_tmp220_ = _tmp219_[1];
																		_tmp221_ = vala_gidl_parser_eval (self, _tmp220_);
																		_g_free0 (copy_function);
																		copy_function = _tmp221_;
																	} else {
																		gchar** _tmp222_ = NULL;
																		gint _tmp222__length1 = 0;
																		const gchar* _tmp223_ = NULL;
																		_tmp222_ = nv;
																		_tmp222__length1 = nv_length1;
																		_tmp223_ = _tmp222_[0];
																		if (g_strcmp0 (_tmp223_, "ref_function_void") == 0) {
																			gchar** _tmp224_ = NULL;
																			gint _tmp224__length1 = 0;
																			const gchar* _tmp225_ = NULL;
																			gchar* _tmp226_ = NULL;
																			gchar* _tmp227_ = NULL;
																			gboolean _tmp228_ = FALSE;
																			_tmp224_ = nv;
																			_tmp224__length1 = nv_length1;
																			_tmp225_ = _tmp224_[1];
																			_tmp226_ = vala_gidl_parser_eval (self, _tmp225_);
																			_tmp227_ = _tmp226_;
																			_tmp228_ = g_strcmp0 (_tmp227_, "1") == 0;
																			_g_free0 (_tmp227_);
																			if (_tmp228_) {
																				ref_function_void = TRUE;
																			}
																		} else {
																			gchar** _tmp229_ = NULL;
																			gint _tmp229__length1 = 0;
																			const gchar* _tmp230_ = NULL;
																			_tmp229_ = nv;
																			_tmp229__length1 = nv_length1;
																			_tmp230_ = _tmp229_[0];
																			if (g_strcmp0 (_tmp230_, "experimental") == 0) {
																				gchar** _tmp231_ = NULL;
																				gint _tmp231__length1 = 0;
																				const gchar* _tmp232_ = NULL;
																				gchar* _tmp233_ = NULL;
																				gchar* _tmp234_ = NULL;
																				gboolean _tmp235_ = FALSE;
																				_tmp231_ = nv;
																				_tmp231__length1 = nv_length1;
																				_tmp232_ = _tmp231_[1];
																				_tmp233_ = vala_gidl_parser_eval (self, _tmp232_);
																				_tmp234_ = _tmp233_;
																				_tmp235_ = g_strcmp0 (_tmp234_, "1") == 0;
																				_g_free0 (_tmp234_);
																				if (_tmp235_) {
																					ValaClass* _tmp236_ = NULL;
																					_tmp236_ = cl;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp236_, "Version", "experimental", TRUE, NULL);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
						}
					}
				}
			}
			_tmp237_ = container;
			_tmp238_ = cl;
			vala_gidl_parser_add_symbol_to_container (self, _tmp237_, (ValaSymbol*) _tmp238_);
			_tmp239_ = self->priv->current_source_file;
			_tmp240_ = cl;
			vala_source_file_add_node (_tmp239_, (ValaCodeNode*) _tmp240_);
			_tmp241_ = base_class;
			if (_tmp241_ != NULL) {
				ValaDataType* parent = NULL;
				const gchar* _tmp242_ = NULL;
				ValaDataType* _tmp243_ = NULL;
				ValaClass* _tmp244_ = NULL;
				ValaDataType* _tmp245_ = NULL;
				_tmp242_ = base_class;
				_tmp243_ = vala_gidl_parser_parse_type_string (self, _tmp242_);
				parent = _tmp243_;
				_tmp244_ = cl;
				_tmp245_ = parent;
				vala_class_add_base_type (_tmp244_, _tmp245_);
				_vala_code_node_unref0 (parent);
			}
			cl_attributes = (_vala_array_free (cl_attributes, cl_attributes_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (base_class);
		}
		_tmp246_ = cl;
		_tmp247_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp246_);
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = _tmp247_;
		_tmp248_ = boxed_node;
		_tmp249_ = _tmp248_->members;
		{
			GList* member_collection = NULL;
			GList* member_it = NULL;
			member_collection = _tmp249_;
			for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
				GIdlNode* member = NULL;
				member = (GIdlNode*) member_it->data;
				{
					GIdlNode* _tmp250_ = NULL;
					GIdlNodeTypeId _tmp251_ = 0;
					_tmp250_ = member;
					_tmp251_ = _tmp250_->type;
					if (_tmp251_ == G_IDL_NODE_FUNCTION) {
						GIdlNode* _tmp252_ = NULL;
						const gchar* _tmp253_ = NULL;
						_tmp252_ = member;
						_tmp253_ = _tmp252_->name;
						if (g_strcmp0 (_tmp253_, "ref") == 0) {
							GIdlNode* _tmp254_ = NULL;
							const gchar* _tmp255_ = NULL;
							gchar* _tmp256_ = NULL;
							GIdlNode* _tmp257_ = NULL;
							GIdlNodeParam* _tmp258_ = NULL;
							GIdlNodeType* _tmp259_ = NULL;
							ValaDataType* _tmp260_ = NULL;
							ValaDataType* _tmp261_ = NULL;
							_tmp254_ = member;
							_tmp255_ = ((GIdlNodeFunction*) _tmp254_)->symbol;
							_tmp256_ = g_strdup (_tmp255_);
							_g_free0 (ref_function);
							ref_function = _tmp256_;
							_tmp257_ = member;
							_tmp258_ = ((GIdlNodeFunction*) _tmp257_)->result;
							_tmp259_ = _tmp258_->type;
							_tmp260_ = vala_gidl_parser_parse_type (self, _tmp259_, NULL);
							_tmp261_ = _tmp260_;
							ref_function_void = G_TYPE_CHECK_INSTANCE_TYPE (_tmp261_, VALA_TYPE_VOID_TYPE);
							_vala_code_node_unref0 (_tmp261_);
						} else {
							GIdlNode* _tmp262_ = NULL;
							const gchar* _tmp263_ = NULL;
							_tmp262_ = member;
							_tmp263_ = _tmp262_->name;
							if (g_strcmp0 (_tmp263_, "unref") == 0) {
								GIdlNode* _tmp264_ = NULL;
								const gchar* _tmp265_ = NULL;
								gchar* _tmp266_ = NULL;
								_tmp264_ = member;
								_tmp265_ = ((GIdlNodeFunction*) _tmp264_)->symbol;
								_tmp266_ = g_strdup (_tmp265_);
								_g_free0 (unref_function);
								unref_function = _tmp266_;
							} else {
								gboolean _tmp267_ = FALSE;
								GIdlNode* _tmp268_ = NULL;
								const gchar* _tmp269_ = NULL;
								_tmp268_ = member;
								_tmp269_ = _tmp268_->name;
								if (g_strcmp0 (_tmp269_, "free") == 0) {
									_tmp267_ = TRUE;
								} else {
									GIdlNode* _tmp270_ = NULL;
									const gchar* _tmp271_ = NULL;
									_tmp270_ = member;
									_tmp271_ = _tmp270_->name;
									_tmp267_ = g_strcmp0 (_tmp271_, "destroy") == 0;
								}
								if (_tmp267_) {
									GIdlNode* _tmp272_ = NULL;
									const gchar* _tmp273_ = NULL;
									gchar* _tmp274_ = NULL;
									_tmp272_ = member;
									_tmp273_ = ((GIdlNodeFunction*) _tmp272_)->symbol;
									_tmp274_ = g_strdup (_tmp273_);
									_g_free0 (free_function);
									free_function = _tmp274_;
								} else {
									GIdlNode* _tmp275_ = NULL;
									const gchar* _tmp276_ = NULL;
									ValaMethod* m = NULL;
									GIdlNode* _tmp280_ = NULL;
									ValaMethod* _tmp281_ = NULL;
									ValaMethod* _tmp282_ = NULL;
									_tmp275_ = member;
									_tmp276_ = _tmp275_->name;
									if (g_strcmp0 (_tmp276_, "copy") == 0) {
										GIdlNode* _tmp277_ = NULL;
										const gchar* _tmp278_ = NULL;
										gchar* _tmp279_ = NULL;
										_tmp277_ = member;
										_tmp278_ = ((GIdlNodeFunction*) _tmp277_)->symbol;
										_tmp279_ = g_strdup (_tmp278_);
										_g_free0 (copy_function);
										copy_function = _tmp279_;
									}
									_tmp280_ = member;
									_tmp281_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp280_, FALSE);
									m = _tmp281_;
									_tmp282_ = m;
									if (_tmp282_ != NULL) {
										ValaClass* _tmp283_ = NULL;
										ValaMethod* _tmp284_ = NULL;
										_tmp283_ = cl;
										_tmp284_ = m;
										vala_symbol_add_method ((ValaSymbol*) _tmp283_, _tmp284_);
									}
									_vala_code_node_unref0 (m);
								}
							}
						}
					} else {
						GIdlNode* _tmp285_ = NULL;
						GIdlNodeTypeId _tmp286_ = 0;
						_tmp285_ = member;
						_tmp286_ = _tmp285_->type;
						if (_tmp286_ == G_IDL_NODE_FIELD) {
							ValaField* f = NULL;
							GIdlNode* _tmp287_ = NULL;
							ValaField* _tmp288_ = NULL;
							ValaField* _tmp289_ = NULL;
							_tmp287_ = member;
							_tmp288_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp287_);
							f = _tmp288_;
							_tmp289_ = f;
							if (_tmp289_ != NULL) {
								ValaClass* _tmp290_ = NULL;
								ValaField* _tmp291_ = NULL;
								_tmp290_ = cl;
								_tmp291_ = f;
								vala_symbol_add_field ((ValaSymbol*) _tmp290_, _tmp291_);
							}
							_vala_code_node_unref0 (f);
						}
					}
				}
			}
		}
		_tmp292_ = ref_function;
		if (_tmp292_ != NULL) {
			ValaClass* _tmp293_ = NULL;
			const gchar* _tmp294_ = NULL;
			gboolean _tmp295_ = FALSE;
			_tmp293_ = cl;
			_tmp294_ = ref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp293_, "CCode", "ref_function", _tmp294_, NULL);
			_tmp295_ = ref_function_void;
			if (_tmp295_) {
				ValaClass* _tmp296_ = NULL;
				gboolean _tmp297_ = FALSE;
				_tmp296_ = cl;
				_tmp297_ = ref_function_void;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp296_, "CCode", "ref_function_void", _tmp297_, NULL);
			}
		} else {
			const gchar* _tmp298_ = NULL;
			_tmp298_ = copy_function;
			if (_tmp298_ != NULL) {
				ValaClass* _tmp299_ = NULL;
				const gchar* _tmp300_ = NULL;
				_tmp299_ = cl;
				_tmp300_ = copy_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp299_, "CCode", "copy_function", _tmp300_, NULL);
			}
		}
		_tmp301_ = unref_function;
		if (_tmp301_ != NULL) {
			ValaClass* _tmp302_ = NULL;
			const gchar* _tmp303_ = NULL;
			_tmp302_ = cl;
			_tmp303_ = unref_function;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp302_, "CCode", "unref_function", _tmp303_, NULL);
		} else {
			gboolean _tmp304_ = FALSE;
			const gchar* _tmp305_ = NULL;
			_tmp305_ = free_function;
			if (_tmp305_ != NULL) {
				const gchar* _tmp306_ = NULL;
				ValaClass* _tmp307_ = NULL;
				gchar* _tmp308_ = NULL;
				gchar* _tmp309_ = NULL;
				gchar* _tmp310_ = NULL;
				gchar* _tmp311_ = NULL;
				_tmp306_ = free_function;
				_tmp307_ = cl;
				_tmp308_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp307_);
				_tmp309_ = _tmp308_;
				_tmp310_ = g_strdup_printf ("%sfree", _tmp309_);
				_tmp311_ = _tmp310_;
				_tmp304_ = g_strcmp0 (_tmp306_, _tmp311_) != 0;
				_g_free0 (_tmp311_);
				_g_free0 (_tmp309_);
			} else {
				_tmp304_ = FALSE;
			}
			if (_tmp304_) {
				ValaClass* _tmp312_ = NULL;
				const gchar* _tmp313_ = NULL;
				_tmp312_ = cl;
				_tmp313_ = free_function;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp312_, "CCode", "free_function", _tmp313_, NULL);
			}
		}
		_vala_code_node_unref0 (self->priv->current_data_type);
		self->priv->current_data_type = NULL;
		_vala_code_node_unref0 (cl);
		_g_free0 (free_function);
		_g_free0 (copy_function);
		_g_free0 (unref_function);
		_g_free0 (ref_function);
	}
	node_attributes = (_vala_array_free (node_attributes, node_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (name);
}


static gunichar string_get_char (const gchar* self, glong index) {
	gunichar result = 0U;
	glong _tmp0_ = 0L;
	gunichar _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = index;
	_tmp1_ = g_utf8_get_char (((gchar*) self) + _tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_gidl_parser_parse_enum (ValaGIdlParser* self, GIdlNodeEnum* en_node, ValaSymbol* container, GIdlModule* module, gboolean is_flags) {
	GIdlNode* node = NULL;
	GIdlNodeEnum* _tmp0_ = NULL;
	gchar* name = NULL;
	GIdlNode* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	ValaSymbol* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean existing = FALSE;
	ValaEnum* en = NULL;
	ValaSymbol* _tmp5_ = NULL;
	ValaScope* _tmp6_ = NULL;
	ValaScope* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	ValaSymbol* _tmp9_ = NULL;
	ValaEnum* _tmp10_ = NULL;
	ValaEnum* _tmp11_ = NULL;
	gboolean _tmp28_ = FALSE;
	GIdlNodeEnum* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	gchar* common_prefix = NULL;
	GIdlNodeEnum* _tmp34_ = NULL;
	GList* _tmp35_ = NULL;
	gboolean is_errordomain = FALSE;
	gchar* cheader_filename = NULL;
	gchar** en_attributes = NULL;
	GIdlNode* _tmp105_ = NULL;
	const gchar* _tmp106_ = NULL;
	gint _tmp107_ = 0;
	gchar** _tmp108_ = NULL;
	gint en_attributes_length1 = 0;
	gint _en_attributes_size_ = 0;
	gchar** _tmp109_ = NULL;
	gint _tmp109__length1 = 0;
	ValaEnum* _tmp203_ = NULL;
	const gchar* _tmp204_ = NULL;
	GIdlNodeEnum* _tmp205_ = NULL;
	GList* _tmp206_ = NULL;
	gboolean _tmp258_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (en_node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = en_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = node;
	_tmp2_ = _tmp1_->name;
	_tmp3_ = container;
	_tmp4_ = vala_gidl_parser_fix_type_name (self, _tmp2_, _tmp3_);
	name = _tmp4_;
	existing = TRUE;
	_tmp5_ = container;
	_tmp6_ = vala_symbol_get_scope (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = name;
	_tmp9_ = vala_scope_lookup (_tmp7_, _tmp8_);
	_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_ENUM) ? ((ValaEnum*) _tmp9_) : NULL;
	if (_tmp10_ == NULL) {
		_vala_code_node_unref0 (_tmp9_);
	}
	en = _tmp10_;
	_tmp11_ = en;
	if (_tmp11_ == NULL) {
		const gchar* _tmp12_ = NULL;
		ValaSourceReference* _tmp13_ = NULL;
		ValaEnum* _tmp14_ = NULL;
		ValaEnum* _tmp15_ = NULL;
		_tmp12_ = name;
		_tmp13_ = self->priv->current_source_reference;
		_tmp14_ = vala_enum_new (_tmp12_, _tmp13_, NULL);
		_vala_code_node_unref0 (en);
		en = _tmp14_;
		_tmp15_ = en;
		vala_symbol_set_access ((ValaSymbol*) _tmp15_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		existing = FALSE;
	} else {
		ValaEnumValue* dummy = NULL;
		ValaEnum* _tmp16_ = NULL;
		ValaScope* _tmp17_ = NULL;
		ValaScope* _tmp18_ = NULL;
		ValaSymbol* _tmp19_ = NULL;
		ValaEnumValue* _tmp20_ = NULL;
		_tmp16_ = en;
		_tmp17_ = vala_symbol_get_scope ((ValaSymbol*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_scope_lookup (_tmp18_, "__DUMMY__");
		dummy = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_ENUM_VALUE, ValaEnumValue);
		_tmp20_ = dummy;
		if (_tmp20_ != NULL) {
			ValaEnum* _tmp21_ = NULL;
			ValaList* _tmp22_ = NULL;
			ValaList* _tmp23_ = NULL;
			ValaEnumValue* _tmp24_ = NULL;
			ValaEnum* _tmp25_ = NULL;
			ValaScope* _tmp26_ = NULL;
			ValaScope* _tmp27_ = NULL;
			_tmp21_ = en;
			_tmp22_ = vala_enum_get_values (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = dummy;
			vala_collection_remove ((ValaCollection*) _tmp23_, _tmp24_);
			_vala_iterable_unref0 (_tmp23_);
			_tmp25_ = en;
			_tmp26_ = vala_symbol_get_scope ((ValaSymbol*) _tmp25_);
			_tmp27_ = _tmp26_;
			vala_scope_remove (_tmp27_, "__DUMMY__");
		}
		_vala_code_node_unref0 (dummy);
	}
	_tmp29_ = en_node;
	_tmp30_ = _tmp29_->gtype_name;
	if (_tmp30_ == NULL) {
		_tmp28_ = TRUE;
	} else {
		GIdlNodeEnum* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		_tmp31_ = en_node;
		_tmp32_ = _tmp31_->gtype_name;
		_tmp28_ = g_strcmp0 (_tmp32_, "") == 0;
	}
	if (_tmp28_) {
		ValaEnum* _tmp33_ = NULL;
		_tmp33_ = en;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp33_, "CCode", "has_type_id", FALSE, NULL);
	}
	common_prefix = NULL;
	_tmp34_ = en_node;
	_tmp35_ = _tmp34_->values;
	{
		GList* value_collection = NULL;
		GList* value_it = NULL;
		value_collection = _tmp35_;
		for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
			GIdlNode* value = NULL;
			value = (GIdlNode*) value_it->data;
			{
				gchar** val_attributes = NULL;
				GIdlNode* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gchar** _tmp39_ = NULL;
				gint val_attributes_length1 = 0;
				gint _val_attributes_size_ = 0;
				gboolean is_hidden = FALSE;
				gchar** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gboolean _tmp53_ = FALSE;
				const gchar* _tmp54_ = NULL;
				_tmp36_ = value;
				_tmp37_ = _tmp36_->name;
				_tmp39_ = vala_gidl_parser_get_attributes (self, _tmp37_, &_tmp38_);
				val_attributes = _tmp39_;
				val_attributes_length1 = _tmp38_;
				_val_attributes_size_ = val_attributes_length1;
				is_hidden = FALSE;
				_tmp40_ = val_attributes;
				_tmp40__length1 = val_attributes_length1;
				if (_tmp40_ != NULL) {
					gchar** _tmp41_ = NULL;
					gint _tmp41__length1 = 0;
					_tmp41_ = val_attributes;
					_tmp41__length1 = val_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp41_;
						attr_collection_length1 = _tmp41__length1;
						for (attr_it = 0; attr_it < _tmp41__length1; attr_it = attr_it + 1) {
							gchar* _tmp42_ = NULL;
							gchar* attr = NULL;
							_tmp42_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp42_;
							{
								gchar** nv = NULL;
								const gchar* _tmp43_ = NULL;
								gchar** _tmp44_ = NULL;
								gchar** _tmp45_ = NULL;
								gint nv_length1 = 0;
								gint _nv_size_ = 0;
								gboolean _tmp46_ = FALSE;
								gchar** _tmp47_ = NULL;
								gint _tmp47__length1 = 0;
								const gchar* _tmp48_ = NULL;
								_tmp43_ = attr;
								_tmp45_ = _tmp44_ = g_strsplit (_tmp43_, "=", 2);
								nv = _tmp45_;
								nv_length1 = _vala_array_length (_tmp44_);
								_nv_size_ = nv_length1;
								_tmp47_ = nv;
								_tmp47__length1 = nv_length1;
								_tmp48_ = _tmp47_[0];
								if (g_strcmp0 (_tmp48_, "hidden") == 0) {
									gchar** _tmp49_ = NULL;
									gint _tmp49__length1 = 0;
									const gchar* _tmp50_ = NULL;
									gchar* _tmp51_ = NULL;
									gchar* _tmp52_ = NULL;
									_tmp49_ = nv;
									_tmp49__length1 = nv_length1;
									_tmp50_ = _tmp49_[1];
									_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
									_tmp52_ = _tmp51_;
									_tmp46_ = g_strcmp0 (_tmp52_, "1") == 0;
									_g_free0 (_tmp52_);
								} else {
									_tmp46_ = FALSE;
								}
								if (_tmp46_) {
									is_hidden = TRUE;
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp53_ = is_hidden;
				if (_tmp53_) {
					val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
					continue;
				}
				_tmp54_ = common_prefix;
				if (_tmp54_ == NULL) {
					GIdlNode* _tmp55_ = NULL;
					const gchar* _tmp56_ = NULL;
					gchar* _tmp57_ = NULL;
					_tmp55_ = value;
					_tmp56_ = _tmp55_->name;
					_tmp57_ = g_strdup (_tmp56_);
					_g_free0 (common_prefix);
					common_prefix = _tmp57_;
					while (TRUE) {
						gboolean _tmp58_ = FALSE;
						const gchar* _tmp59_ = NULL;
						gint _tmp60_ = 0;
						gint _tmp61_ = 0;
						const gchar* _tmp64_ = NULL;
						const gchar* _tmp65_ = NULL;
						gint _tmp66_ = 0;
						gint _tmp67_ = 0;
						gchar* _tmp68_ = NULL;
						_tmp59_ = common_prefix;
						_tmp60_ = strlen (_tmp59_);
						_tmp61_ = _tmp60_;
						if (_tmp61_ > 0) {
							const gchar* _tmp62_ = NULL;
							gboolean _tmp63_ = FALSE;
							_tmp62_ = common_prefix;
							_tmp63_ = g_str_has_suffix (_tmp62_, "_");
							_tmp58_ = !_tmp63_;
						} else {
							_tmp58_ = FALSE;
						}
						if (!_tmp58_) {
							break;
						}
						_tmp64_ = common_prefix;
						_tmp65_ = common_prefix;
						_tmp66_ = strlen (_tmp65_);
						_tmp67_ = _tmp66_;
						_tmp68_ = string_substring (_tmp64_, (glong) 0, (glong) (_tmp67_ - 1));
						_g_free0 (common_prefix);
						common_prefix = _tmp68_;
					}
				} else {
					while (TRUE) {
						GIdlNode* _tmp69_ = NULL;
						const gchar* _tmp70_ = NULL;
						const gchar* _tmp71_ = NULL;
						gboolean _tmp72_ = FALSE;
						const gchar* _tmp73_ = NULL;
						const gchar* _tmp74_ = NULL;
						gint _tmp75_ = 0;
						gint _tmp76_ = 0;
						gchar* _tmp77_ = NULL;
						_tmp69_ = value;
						_tmp70_ = _tmp69_->name;
						_tmp71_ = common_prefix;
						_tmp72_ = g_str_has_prefix (_tmp70_, _tmp71_);
						if (!(!_tmp72_)) {
							break;
						}
						_tmp73_ = common_prefix;
						_tmp74_ = common_prefix;
						_tmp75_ = strlen (_tmp74_);
						_tmp76_ = _tmp75_;
						_tmp77_ = string_substring (_tmp73_, (glong) 0, (glong) (_tmp76_ - 1));
						_g_free0 (common_prefix);
						common_prefix = _tmp77_;
					}
				}
				while (TRUE) {
					gboolean _tmp78_ = FALSE;
					const gchar* _tmp79_ = NULL;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					const gchar* _tmp100_ = NULL;
					const gchar* _tmp101_ = NULL;
					gint _tmp102_ = 0;
					gint _tmp103_ = 0;
					gchar* _tmp104_ = NULL;
					_tmp79_ = common_prefix;
					_tmp80_ = strlen (_tmp79_);
					_tmp81_ = _tmp80_;
					if (_tmp81_ > 0) {
						gboolean _tmp82_ = FALSE;
						const gchar* _tmp83_ = NULL;
						gboolean _tmp84_ = FALSE;
						_tmp83_ = common_prefix;
						_tmp84_ = g_str_has_suffix (_tmp83_, "_");
						if (!_tmp84_) {
							_tmp82_ = TRUE;
						} else {
							gboolean _tmp85_ = FALSE;
							GIdlNode* _tmp86_ = NULL;
							const gchar* _tmp87_ = NULL;
							const gchar* _tmp88_ = NULL;
							gint _tmp89_ = 0;
							gint _tmp90_ = 0;
							gunichar _tmp91_ = 0U;
							gboolean _tmp92_ = FALSE;
							_tmp86_ = value;
							_tmp87_ = _tmp86_->name;
							_tmp88_ = common_prefix;
							_tmp89_ = strlen (_tmp88_);
							_tmp90_ = _tmp89_;
							_tmp91_ = string_get_char (_tmp87_, (glong) _tmp90_);
							_tmp92_ = g_unichar_isdigit (_tmp91_);
							if (_tmp92_) {
								GIdlNode* _tmp93_ = NULL;
								const gchar* _tmp94_ = NULL;
								gint _tmp95_ = 0;
								gint _tmp96_ = 0;
								const gchar* _tmp97_ = NULL;
								gint _tmp98_ = 0;
								gint _tmp99_ = 0;
								_tmp93_ = value;
								_tmp94_ = _tmp93_->name;
								_tmp95_ = strlen (_tmp94_);
								_tmp96_ = _tmp95_;
								_tmp97_ = common_prefix;
								_tmp98_ = strlen (_tmp97_);
								_tmp99_ = _tmp98_;
								_tmp85_ = (_tmp96_ - _tmp99_) <= 1;
							} else {
								_tmp85_ = FALSE;
							}
							_tmp82_ = _tmp85_;
						}
						_tmp78_ = _tmp82_;
					} else {
						_tmp78_ = FALSE;
					}
					if (!_tmp78_) {
						break;
					}
					_tmp100_ = common_prefix;
					_tmp101_ = common_prefix;
					_tmp102_ = strlen (_tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = string_substring (_tmp100_, (glong) 0, (glong) (_tmp103_ - 1));
					_g_free0 (common_prefix);
					common_prefix = _tmp104_;
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	is_errordomain = FALSE;
	cheader_filename = NULL;
	_tmp105_ = node;
	_tmp106_ = _tmp105_->name;
	_tmp108_ = vala_gidl_parser_get_attributes (self, _tmp106_, &_tmp107_);
	en_attributes = _tmp108_;
	en_attributes_length1 = _tmp107_;
	_en_attributes_size_ = en_attributes_length1;
	_tmp109_ = en_attributes;
	_tmp109__length1 = en_attributes_length1;
	if (_tmp109_ != NULL) {
		gchar** _tmp110_ = NULL;
		gint _tmp110__length1 = 0;
		_tmp110_ = en_attributes;
		_tmp110__length1 = en_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp110_;
			attr_collection_length1 = _tmp110__length1;
			for (attr_it = 0; attr_it < _tmp110__length1; attr_it = attr_it + 1) {
				gchar* _tmp111_ = NULL;
				gchar* attr = NULL;
				_tmp111_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp111_;
				{
					gchar** nv = NULL;
					const gchar* _tmp112_ = NULL;
					gchar** _tmp113_ = NULL;
					gchar** _tmp114_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gchar** _tmp115_ = NULL;
					gint _tmp115__length1 = 0;
					const gchar* _tmp116_ = NULL;
					_tmp112_ = attr;
					_tmp114_ = _tmp113_ = g_strsplit (_tmp112_, "=", 2);
					nv = _tmp114_;
					nv_length1 = _vala_array_length (_tmp113_);
					_nv_size_ = nv_length1;
					_tmp115_ = nv;
					_tmp115__length1 = nv_length1;
					_tmp116_ = _tmp115_[0];
					if (g_strcmp0 (_tmp116_, "common_prefix") == 0) {
						gchar** _tmp117_ = NULL;
						gint _tmp117__length1 = 0;
						const gchar* _tmp118_ = NULL;
						gchar* _tmp119_ = NULL;
						_tmp117_ = nv;
						_tmp117__length1 = nv_length1;
						_tmp118_ = _tmp117_[1];
						_tmp119_ = vala_gidl_parser_eval (self, _tmp118_);
						_g_free0 (common_prefix);
						common_prefix = _tmp119_;
					} else {
						gchar** _tmp120_ = NULL;
						gint _tmp120__length1 = 0;
						const gchar* _tmp121_ = NULL;
						_tmp120_ = nv;
						_tmp120__length1 = nv_length1;
						_tmp121_ = _tmp120_[0];
						if (g_strcmp0 (_tmp121_, "cheader_filename") == 0) {
							gchar** _tmp122_ = NULL;
							gint _tmp122__length1 = 0;
							const gchar* _tmp123_ = NULL;
							gchar* _tmp124_ = NULL;
							ValaEnum* _tmp125_ = NULL;
							const gchar* _tmp126_ = NULL;
							_tmp122_ = nv;
							_tmp122__length1 = nv_length1;
							_tmp123_ = _tmp122_[1];
							_tmp124_ = vala_gidl_parser_eval (self, _tmp123_);
							_g_free0 (cheader_filename);
							cheader_filename = _tmp124_;
							_tmp125_ = en;
							_tmp126_ = cheader_filename;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp125_, "CCode", "cheader_filename", _tmp126_, NULL);
						} else {
							gchar** _tmp127_ = NULL;
							gint _tmp127__length1 = 0;
							const gchar* _tmp128_ = NULL;
							_tmp127_ = nv;
							_tmp127__length1 = nv_length1;
							_tmp128_ = _tmp127_[0];
							if (g_strcmp0 (_tmp128_, "hidden") == 0) {
								gchar** _tmp129_ = NULL;
								gint _tmp129__length1 = 0;
								const gchar* _tmp130_ = NULL;
								gchar* _tmp131_ = NULL;
								gchar* _tmp132_ = NULL;
								gboolean _tmp133_ = FALSE;
								_tmp129_ = nv;
								_tmp129__length1 = nv_length1;
								_tmp130_ = _tmp129_[1];
								_tmp131_ = vala_gidl_parser_eval (self, _tmp130_);
								_tmp132_ = _tmp131_;
								_tmp133_ = g_strcmp0 (_tmp132_, "1") == 0;
								_g_free0 (_tmp132_);
								if (_tmp133_) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (cheader_filename);
									_g_free0 (common_prefix);
									_vala_code_node_unref0 (en);
									_g_free0 (name);
									return;
								}
							} else {
								gchar** _tmp134_ = NULL;
								gint _tmp134__length1 = 0;
								const gchar* _tmp135_ = NULL;
								_tmp134_ = nv;
								_tmp134__length1 = nv_length1;
								_tmp135_ = _tmp134_[0];
								if (g_strcmp0 (_tmp135_, "deprecated") == 0) {
									gchar** _tmp136_ = NULL;
									gint _tmp136__length1 = 0;
									const gchar* _tmp137_ = NULL;
									gchar* _tmp138_ = NULL;
									gchar* _tmp139_ = NULL;
									gboolean _tmp140_ = FALSE;
									_tmp136_ = nv;
									_tmp136__length1 = nv_length1;
									_tmp137_ = _tmp136_[1];
									_tmp138_ = vala_gidl_parser_eval (self, _tmp137_);
									_tmp139_ = _tmp138_;
									_tmp140_ = g_strcmp0 (_tmp139_, "1") == 0;
									_g_free0 (_tmp139_);
									if (_tmp140_) {
										ValaEnum* _tmp141_ = NULL;
										_tmp141_ = en;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp141_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp142_ = NULL;
									gint _tmp142__length1 = 0;
									const gchar* _tmp143_ = NULL;
									_tmp142_ = nv;
									_tmp142__length1 = nv_length1;
									_tmp143_ = _tmp142_[0];
									if (g_strcmp0 (_tmp143_, "default_value") == 0) {
										ValaEnum* _tmp144_ = NULL;
										gchar** _tmp145_ = NULL;
										gint _tmp145__length1 = 0;
										const gchar* _tmp146_ = NULL;
										gchar* _tmp147_ = NULL;
										gchar* _tmp148_ = NULL;
										_tmp144_ = en;
										_tmp145_ = nv;
										_tmp145__length1 = nv_length1;
										_tmp146_ = _tmp145_[1];
										_tmp147_ = vala_gidl_parser_eval (self, _tmp146_);
										_tmp148_ = _tmp147_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp144_, "CCode", "default_value", _tmp148_, NULL);
										_g_free0 (_tmp148_);
									} else {
										gchar** _tmp149_ = NULL;
										gint _tmp149__length1 = 0;
										const gchar* _tmp150_ = NULL;
										_tmp149_ = nv;
										_tmp149__length1 = nv_length1;
										_tmp150_ = _tmp149_[0];
										if (g_strcmp0 (_tmp150_, "replacement") == 0) {
											ValaEnum* _tmp151_ = NULL;
											gchar** _tmp152_ = NULL;
											gint _tmp152__length1 = 0;
											const gchar* _tmp153_ = NULL;
											gchar* _tmp154_ = NULL;
											gchar* _tmp155_ = NULL;
											_tmp151_ = en;
											_tmp152_ = nv;
											_tmp152__length1 = nv_length1;
											_tmp153_ = _tmp152_[1];
											_tmp154_ = vala_gidl_parser_eval (self, _tmp153_);
											_tmp155_ = _tmp154_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp151_, "Version", "replacement", _tmp155_, NULL);
											_g_free0 (_tmp155_);
										} else {
											gchar** _tmp156_ = NULL;
											gint _tmp156__length1 = 0;
											const gchar* _tmp157_ = NULL;
											_tmp156_ = nv;
											_tmp156__length1 = nv_length1;
											_tmp157_ = _tmp156_[0];
											if (g_strcmp0 (_tmp157_, "deprecated_since") == 0) {
												ValaEnum* _tmp158_ = NULL;
												gchar** _tmp159_ = NULL;
												gint _tmp159__length1 = 0;
												const gchar* _tmp160_ = NULL;
												gchar* _tmp161_ = NULL;
												gchar* _tmp162_ = NULL;
												_tmp158_ = en;
												_tmp159_ = nv;
												_tmp159__length1 = nv_length1;
												_tmp160_ = _tmp159_[1];
												_tmp161_ = vala_gidl_parser_eval (self, _tmp160_);
												_tmp162_ = _tmp161_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp158_, "Version", "deprecated_since", _tmp162_, NULL);
												_g_free0 (_tmp162_);
											} else {
												gchar** _tmp163_ = NULL;
												gint _tmp163__length1 = 0;
												const gchar* _tmp164_ = NULL;
												_tmp163_ = nv;
												_tmp163__length1 = nv_length1;
												_tmp164_ = _tmp163_[0];
												if (g_strcmp0 (_tmp164_, "rename_to") == 0) {
													ValaEnum* _tmp165_ = NULL;
													gchar** _tmp166_ = NULL;
													gint _tmp166__length1 = 0;
													const gchar* _tmp167_ = NULL;
													gchar* _tmp168_ = NULL;
													gchar* _tmp169_ = NULL;
													_tmp165_ = en;
													_tmp166_ = nv;
													_tmp166__length1 = nv_length1;
													_tmp167_ = _tmp166_[1];
													_tmp168_ = vala_gidl_parser_eval (self, _tmp167_);
													_tmp169_ = _tmp168_;
													vala_symbol_set_name ((ValaSymbol*) _tmp165_, _tmp169_);
													_g_free0 (_tmp169_);
												} else {
													gchar** _tmp170_ = NULL;
													gint _tmp170__length1 = 0;
													const gchar* _tmp171_ = NULL;
													_tmp170_ = nv;
													_tmp170__length1 = nv_length1;
													_tmp171_ = _tmp170_[0];
													if (g_strcmp0 (_tmp171_, "errordomain") == 0) {
														gchar** _tmp172_ = NULL;
														gint _tmp172__length1 = 0;
														const gchar* _tmp173_ = NULL;
														gchar* _tmp174_ = NULL;
														gchar* _tmp175_ = NULL;
														gboolean _tmp176_ = FALSE;
														_tmp172_ = nv;
														_tmp172__length1 = nv_length1;
														_tmp173_ = _tmp172_[1];
														_tmp174_ = vala_gidl_parser_eval (self, _tmp173_);
														_tmp175_ = _tmp174_;
														_tmp176_ = g_strcmp0 (_tmp175_, "1") == 0;
														_g_free0 (_tmp175_);
														if (_tmp176_) {
															is_errordomain = TRUE;
														}
													} else {
														gchar** _tmp177_ = NULL;
														gint _tmp177__length1 = 0;
														const gchar* _tmp178_ = NULL;
														_tmp177_ = nv;
														_tmp177__length1 = nv_length1;
														_tmp178_ = _tmp177_[0];
														if (g_strcmp0 (_tmp178_, "to_string") == 0) {
															ValaUnresolvedType* return_type = NULL;
															ValaUnresolvedType* _tmp179_ = NULL;
															ValaUnresolvedType* _tmp180_ = NULL;
															ValaUnresolvedSymbol* _tmp181_ = NULL;
															ValaUnresolvedSymbol* _tmp182_ = NULL;
															ValaUnresolvedType* _tmp183_ = NULL;
															ValaMethod* m = NULL;
															ValaUnresolvedType* _tmp184_ = NULL;
															ValaSourceReference* _tmp185_ = NULL;
															ValaMethod* _tmp186_ = NULL;
															ValaMethod* _tmp187_ = NULL;
															ValaMethod* _tmp188_ = NULL;
															gchar** _tmp189_ = NULL;
															gint _tmp189__length1 = 0;
															const gchar* _tmp190_ = NULL;
															gchar* _tmp191_ = NULL;
															gchar* _tmp192_ = NULL;
															ValaEnum* _tmp193_ = NULL;
															ValaMethod* _tmp194_ = NULL;
															_tmp179_ = vala_unresolved_type_new ();
															return_type = _tmp179_;
															_tmp180_ = return_type;
															_tmp181_ = vala_unresolved_symbol_new (NULL, "string", NULL);
															_tmp182_ = _tmp181_;
															vala_unresolved_type_set_unresolved_symbol (_tmp180_, _tmp182_);
															_vala_code_node_unref0 (_tmp182_);
															_tmp183_ = return_type;
															vala_data_type_set_value_owned ((ValaDataType*) _tmp183_, FALSE);
															_tmp184_ = return_type;
															_tmp185_ = self->priv->current_source_reference;
															_tmp186_ = vala_method_new ("to_string", (ValaDataType*) _tmp184_, _tmp185_, NULL);
															m = _tmp186_;
															_tmp187_ = m;
															vala_symbol_set_access ((ValaSymbol*) _tmp187_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
															_tmp188_ = m;
															_tmp189_ = nv;
															_tmp189__length1 = nv_length1;
															_tmp190_ = _tmp189_[1];
															_tmp191_ = vala_gidl_parser_eval (self, _tmp190_);
															_tmp192_ = _tmp191_;
															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp188_, "CCode", "cname", _tmp192_, NULL);
															_g_free0 (_tmp192_);
															_tmp193_ = en;
															_tmp194_ = m;
															vala_symbol_add_method ((ValaSymbol*) _tmp193_, _tmp194_);
															_vala_code_node_unref0 (m);
															_vala_code_node_unref0 (return_type);
														} else {
															gchar** _tmp195_ = NULL;
															gint _tmp195__length1 = 0;
															const gchar* _tmp196_ = NULL;
															_tmp195_ = nv;
															_tmp195__length1 = nv_length1;
															_tmp196_ = _tmp195_[0];
															if (g_strcmp0 (_tmp196_, "experimental") == 0) {
																gchar** _tmp197_ = NULL;
																gint _tmp197__length1 = 0;
																const gchar* _tmp198_ = NULL;
																gchar* _tmp199_ = NULL;
																gchar* _tmp200_ = NULL;
																gboolean _tmp201_ = FALSE;
																_tmp197_ = nv;
																_tmp197__length1 = nv_length1;
																_tmp198_ = _tmp197_[1];
																_tmp199_ = vala_gidl_parser_eval (self, _tmp198_);
																_tmp200_ = _tmp199_;
																_tmp201_ = g_strcmp0 (_tmp200_, "1") == 0;
																_g_free0 (_tmp200_);
																if (_tmp201_) {
																	ValaEnum* _tmp202_ = NULL;
																	_tmp202_ = en;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp202_, "Version", "experimental", TRUE, NULL);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp203_ = en;
	_tmp204_ = common_prefix;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp203_, "CCode", "cprefix", _tmp204_, NULL);
	_tmp205_ = en_node;
	_tmp206_ = _tmp205_->values;
	{
		GList* value2_collection = NULL;
		GList* value2_it = NULL;
		value2_collection = _tmp206_;
		for (value2_it = value2_collection; value2_it != NULL; value2_it = value2_it->next) {
			GIdlNode* value2 = NULL;
			value2 = (GIdlNode*) value2_it->data;
			{
				ValaEnumValue* ev = NULL;
				GIdlNode* _tmp207_ = NULL;
				const gchar* _tmp208_ = NULL;
				const gchar* _tmp209_ = NULL;
				gint _tmp210_ = 0;
				gint _tmp211_ = 0;
				gchar* _tmp212_ = NULL;
				gchar* _tmp213_ = NULL;
				ValaEnumValue* _tmp214_ = NULL;
				ValaEnumValue* _tmp215_ = NULL;
				gchar** val_attributes = NULL;
				GIdlNode* _tmp216_ = NULL;
				const gchar* _tmp217_ = NULL;
				gint _tmp218_ = 0;
				gchar** _tmp219_ = NULL;
				gint val_attributes_length1 = 0;
				gint _val_attributes_size_ = 0;
				gboolean is_hidden = FALSE;
				gchar** _tmp220_ = NULL;
				gint _tmp220__length1 = 0;
				gboolean _tmp255_ = FALSE;
				_tmp207_ = value2;
				_tmp208_ = _tmp207_->name;
				_tmp209_ = common_prefix;
				_tmp210_ = strlen (_tmp209_);
				_tmp211_ = _tmp210_;
				_tmp212_ = string_substring (_tmp208_, (glong) _tmp211_, (glong) -1);
				_tmp213_ = _tmp212_;
				_tmp214_ = vala_enum_value_new (_tmp213_, NULL, NULL, NULL);
				_tmp215_ = _tmp214_;
				_g_free0 (_tmp213_);
				ev = _tmp215_;
				_tmp216_ = value2;
				_tmp217_ = _tmp216_->name;
				_tmp219_ = vala_gidl_parser_get_attributes (self, _tmp217_, &_tmp218_);
				val_attributes = _tmp219_;
				val_attributes_length1 = _tmp218_;
				_val_attributes_size_ = val_attributes_length1;
				is_hidden = FALSE;
				_tmp220_ = val_attributes;
				_tmp220__length1 = val_attributes_length1;
				if (_tmp220_ != NULL) {
					gchar** _tmp221_ = NULL;
					gint _tmp221__length1 = 0;
					_tmp221_ = val_attributes;
					_tmp221__length1 = val_attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp221_;
						attr_collection_length1 = _tmp221__length1;
						for (attr_it = 0; attr_it < _tmp221__length1; attr_it = attr_it + 1) {
							gchar* _tmp222_ = NULL;
							gchar* attr = NULL;
							_tmp222_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp222_;
							{
								gchar** nv = NULL;
								const gchar* _tmp223_ = NULL;
								gchar** _tmp224_ = NULL;
								gchar** _tmp225_ = NULL;
								gint nv_length1 = 0;
								gint _nv_size_ = 0;
								gboolean _tmp226_ = FALSE;
								gchar** _tmp227_ = NULL;
								gint _tmp227__length1 = 0;
								const gchar* _tmp228_ = NULL;
								_tmp223_ = attr;
								_tmp225_ = _tmp224_ = g_strsplit (_tmp223_, "=", 2);
								nv = _tmp225_;
								nv_length1 = _vala_array_length (_tmp224_);
								_nv_size_ = nv_length1;
								_tmp227_ = nv;
								_tmp227__length1 = nv_length1;
								_tmp228_ = _tmp227_[0];
								if (g_strcmp0 (_tmp228_, "hidden") == 0) {
									gchar** _tmp229_ = NULL;
									gint _tmp229__length1 = 0;
									const gchar* _tmp230_ = NULL;
									gchar* _tmp231_ = NULL;
									gchar* _tmp232_ = NULL;
									_tmp229_ = nv;
									_tmp229__length1 = nv_length1;
									_tmp230_ = _tmp229_[1];
									_tmp231_ = vala_gidl_parser_eval (self, _tmp230_);
									_tmp232_ = _tmp231_;
									_tmp226_ = g_strcmp0 (_tmp232_, "1") == 0;
									_g_free0 (_tmp232_);
								} else {
									_tmp226_ = FALSE;
								}
								if (_tmp226_) {
									is_hidden = TRUE;
								} else {
									gchar** _tmp233_ = NULL;
									gint _tmp233__length1 = 0;
									const gchar* _tmp234_ = NULL;
									_tmp233_ = nv;
									_tmp233__length1 = nv_length1;
									_tmp234_ = _tmp233_[0];
									if (g_strcmp0 (_tmp234_, "deprecated") == 0) {
										gchar** _tmp235_ = NULL;
										gint _tmp235__length1 = 0;
										const gchar* _tmp236_ = NULL;
										gchar* _tmp237_ = NULL;
										gchar* _tmp238_ = NULL;
										gboolean _tmp239_ = FALSE;
										_tmp235_ = nv;
										_tmp235__length1 = nv_length1;
										_tmp236_ = _tmp235_[1];
										_tmp237_ = vala_gidl_parser_eval (self, _tmp236_);
										_tmp238_ = _tmp237_;
										_tmp239_ = g_strcmp0 (_tmp238_, "1") == 0;
										_g_free0 (_tmp238_);
										if (_tmp239_) {
											ValaEnumValue* _tmp240_ = NULL;
											_tmp240_ = ev;
											vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp240_, "Version", "deprecated", TRUE, NULL);
										}
									} else {
										gchar** _tmp241_ = NULL;
										gint _tmp241__length1 = 0;
										const gchar* _tmp242_ = NULL;
										_tmp241_ = nv;
										_tmp241__length1 = nv_length1;
										_tmp242_ = _tmp241_[0];
										if (g_strcmp0 (_tmp242_, "replacement") == 0) {
											ValaEnumValue* _tmp243_ = NULL;
											gchar** _tmp244_ = NULL;
											gint _tmp244__length1 = 0;
											const gchar* _tmp245_ = NULL;
											gchar* _tmp246_ = NULL;
											gchar* _tmp247_ = NULL;
											_tmp243_ = ev;
											_tmp244_ = nv;
											_tmp244__length1 = nv_length1;
											_tmp245_ = _tmp244_[1];
											_tmp246_ = vala_gidl_parser_eval (self, _tmp245_);
											_tmp247_ = _tmp246_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp243_, "Version", "replacement", _tmp247_, NULL);
											_g_free0 (_tmp247_);
										} else {
											gchar** _tmp248_ = NULL;
											gint _tmp248__length1 = 0;
											const gchar* _tmp249_ = NULL;
											_tmp248_ = nv;
											_tmp248__length1 = nv_length1;
											_tmp249_ = _tmp248_[0];
											if (g_strcmp0 (_tmp249_, "deprecated_since") == 0) {
												ValaEnumValue* _tmp250_ = NULL;
												gchar** _tmp251_ = NULL;
												gint _tmp251__length1 = 0;
												const gchar* _tmp252_ = NULL;
												gchar* _tmp253_ = NULL;
												gchar* _tmp254_ = NULL;
												_tmp250_ = ev;
												_tmp251_ = nv;
												_tmp251__length1 = nv_length1;
												_tmp252_ = _tmp251_[1];
												_tmp253_ = vala_gidl_parser_eval (self, _tmp252_);
												_tmp254_ = _tmp253_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp250_, "Version", "deprecated_since", _tmp254_, NULL);
												_g_free0 (_tmp254_);
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp255_ = is_hidden;
				if (!_tmp255_) {
					ValaEnum* _tmp256_ = NULL;
					ValaEnumValue* _tmp257_ = NULL;
					_tmp256_ = en;
					_tmp257_ = ev;
					vala_enum_add_value (_tmp256_, _tmp257_);
				}
				val_attributes = (_vala_array_free (val_attributes, val_attributes_length1, (GDestroyNotify) g_free), NULL);
				_vala_code_node_unref0 (ev);
			}
		}
	}
	_tmp258_ = is_errordomain;
	if (_tmp258_) {
		ValaErrorDomain* ed = NULL;
		ValaEnum* _tmp259_ = NULL;
		const gchar* _tmp260_ = NULL;
		const gchar* _tmp261_ = NULL;
		ValaSourceReference* _tmp262_ = NULL;
		ValaErrorDomain* _tmp263_ = NULL;
		ValaErrorDomain* _tmp264_ = NULL;
		ValaErrorDomain* _tmp265_ = NULL;
		const gchar* _tmp266_ = NULL;
		const gchar* _tmp267_ = NULL;
		ValaSourceFile* _tmp287_ = NULL;
		ValaErrorDomain* _tmp288_ = NULL;
		gboolean _tmp289_ = FALSE;
		_tmp259_ = en;
		_tmp260_ = vala_symbol_get_name ((ValaSymbol*) _tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = self->priv->current_source_reference;
		_tmp263_ = vala_error_domain_new (_tmp261_, _tmp262_, NULL);
		ed = _tmp263_;
		_tmp264_ = ed;
		vala_symbol_set_access ((ValaSymbol*) _tmp264_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp265_ = ed;
		_tmp266_ = common_prefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp265_, "CCode", "cprefix", _tmp266_, NULL);
		_tmp267_ = cheader_filename;
		if (_tmp267_ != NULL) {
			ValaErrorDomain* _tmp268_ = NULL;
			const gchar* _tmp269_ = NULL;
			_tmp268_ = ed;
			_tmp269_ = cheader_filename;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp268_, "CCode", "cheader_filename", _tmp269_, NULL);
		}
		{
			ValaList* _ev_list = NULL;
			ValaEnum* _tmp270_ = NULL;
			ValaList* _tmp271_ = NULL;
			gint _ev_size = 0;
			ValaList* _tmp272_ = NULL;
			gint _tmp273_ = 0;
			gint _tmp274_ = 0;
			gint _ev_index = 0;
			_tmp270_ = en;
			_tmp271_ = vala_enum_get_values (_tmp270_);
			_ev_list = _tmp271_;
			_tmp272_ = _ev_list;
			_tmp273_ = vala_collection_get_size ((ValaCollection*) _tmp272_);
			_tmp274_ = _tmp273_;
			_ev_size = _tmp274_;
			_ev_index = -1;
			while (TRUE) {
				gint _tmp275_ = 0;
				gint _tmp276_ = 0;
				gint _tmp277_ = 0;
				ValaEnumValue* ev = NULL;
				ValaList* _tmp278_ = NULL;
				gint _tmp279_ = 0;
				gpointer _tmp280_ = NULL;
				ValaErrorDomain* _tmp281_ = NULL;
				ValaEnumValue* _tmp282_ = NULL;
				const gchar* _tmp283_ = NULL;
				const gchar* _tmp284_ = NULL;
				ValaErrorCode* _tmp285_ = NULL;
				ValaErrorCode* _tmp286_ = NULL;
				_tmp275_ = _ev_index;
				_ev_index = _tmp275_ + 1;
				_tmp276_ = _ev_index;
				_tmp277_ = _ev_size;
				if (!(_tmp276_ < _tmp277_)) {
					break;
				}
				_tmp278_ = _ev_list;
				_tmp279_ = _ev_index;
				_tmp280_ = vala_list_get (_tmp278_, _tmp279_);
				ev = (ValaEnumValue*) _tmp280_;
				_tmp281_ = ed;
				_tmp282_ = ev;
				_tmp283_ = vala_symbol_get_name ((ValaSymbol*) _tmp282_);
				_tmp284_ = _tmp283_;
				_tmp285_ = vala_error_code_new (_tmp284_, NULL, NULL);
				_tmp286_ = _tmp285_;
				vala_error_domain_add_code (_tmp281_, _tmp286_);
				_vala_code_node_unref0 (_tmp286_);
				_vala_code_node_unref0 (ev);
			}
			_vala_iterable_unref0 (_ev_list);
		}
		_tmp287_ = self->priv->current_source_file;
		_tmp288_ = ed;
		vala_source_file_add_node (_tmp287_, (ValaCodeNode*) _tmp288_);
		_tmp289_ = existing;
		if (!_tmp289_) {
			ValaSymbol* _tmp290_ = NULL;
			ValaErrorDomain* _tmp291_ = NULL;
			_tmp290_ = container;
			_tmp291_ = ed;
			vala_gidl_parser_add_symbol_to_container (self, _tmp290_, (ValaSymbol*) _tmp291_);
		}
		_vala_code_node_unref0 (ed);
	} else {
		ValaEnum* _tmp292_ = NULL;
		gboolean _tmp293_ = FALSE;
		ValaSourceFile* _tmp294_ = NULL;
		ValaEnum* _tmp295_ = NULL;
		gboolean _tmp296_ = FALSE;
		_tmp292_ = en;
		_tmp293_ = is_flags;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp292_, "Flags", _tmp293_, NULL);
		_tmp294_ = self->priv->current_source_file;
		_tmp295_ = en;
		vala_source_file_add_node (_tmp294_, (ValaCodeNode*) _tmp295_);
		_tmp296_ = existing;
		if (!_tmp296_) {
			ValaSymbol* _tmp297_ = NULL;
			ValaEnum* _tmp298_ = NULL;
			_tmp297_ = container;
			_tmp298_ = en;
			vala_gidl_parser_add_symbol_to_container (self, _tmp297_, (ValaSymbol*) _tmp298_);
		}
	}
	en_attributes = (_vala_array_free (en_attributes, en_attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cheader_filename);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (en);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_object (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module) {
	gchar* name = NULL;
	GIdlNodeInterface* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* base_class = NULL;
	ValaClass* cl = NULL;
	ValaSymbol* _tmp4_ = NULL;
	ValaScope* _tmp5_ = NULL;
	ValaScope* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	ValaSymbol* _tmp8_ = NULL;
	ValaClass* _tmp9_ = NULL;
	ValaClass* _tmp10_ = NULL;
	const gchar* _tmp136_ = NULL;
	GIdlNodeInterface* _tmp159_ = NULL;
	GList* _tmp160_ = NULL;
	ValaClass* _tmp183_ = NULL;
	ValaTypeSymbol* _tmp184_ = NULL;
	GHashFunc _tmp185_ = NULL;
	GEqualFunc _tmp186_ = NULL;
	ValaHashSet* _tmp187_ = NULL;
	ValaHashMap* current_type_func_map = NULL;
	GHashFunc _tmp188_ = NULL;
	GEqualFunc _tmp189_ = NULL;
	GEqualFunc _tmp190_ = NULL;
	ValaHashMap* _tmp191_ = NULL;
	ValaHashMap* current_type_vfunc_map = NULL;
	GHashFunc _tmp192_ = NULL;
	GEqualFunc _tmp193_ = NULL;
	GEqualFunc _tmp194_ = NULL;
	ValaHashMap* _tmp195_ = NULL;
	GIdlNodeInterface* _tmp196_ = NULL;
	GList* _tmp197_ = NULL;
	GIdlNodeInterface* _tmp209_ = NULL;
	GList* _tmp210_ = NULL;
	GIdlNodeInterface* _tmp247_ = NULL;
	GList* _tmp248_ = NULL;
	ValaClass* _tmp314_ = NULL;
	ValaClass* _tmp315_ = NULL;
	ValaCreationMethod* _tmp316_ = NULL;
	ValaCreationMethod* _tmp317_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = node;
	_tmp1_ = ((GIdlNode*) _tmp0_)->name;
	_tmp2_ = container;
	_tmp3_ = vala_gidl_parser_fix_type_name (self, _tmp1_, _tmp2_);
	name = _tmp3_;
	base_class = NULL;
	_tmp4_ = container;
	_tmp5_ = vala_symbol_get_scope (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = name;
	_tmp8_ = vala_scope_lookup (_tmp6_, _tmp7_);
	_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp8_) : NULL;
	if (_tmp9_ == NULL) {
		_vala_code_node_unref0 (_tmp8_);
	}
	cl = _tmp9_;
	_tmp10_ = cl;
	if (_tmp10_ == NULL) {
		const gchar* _tmp11_ = NULL;
		ValaSourceReference* _tmp12_ = NULL;
		ValaClass* _tmp13_ = NULL;
		ValaClass* _tmp14_ = NULL;
		gchar** attributes = NULL;
		GIdlNodeInterface* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gchar** _tmp18_ = NULL;
		gint attributes_length1 = 0;
		gint _attributes_size_ = 0;
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		ValaSymbol* _tmp132_ = NULL;
		ValaClass* _tmp133_ = NULL;
		ValaSourceFile* _tmp134_ = NULL;
		ValaClass* _tmp135_ = NULL;
		_tmp11_ = name;
		_tmp12_ = self->priv->current_source_reference;
		_tmp13_ = vala_class_new (_tmp11_, _tmp12_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp13_;
		_tmp14_ = cl;
		vala_symbol_set_access ((ValaSymbol*) _tmp14_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp15_ = node;
		_tmp16_ = _tmp15_->gtype_name;
		_tmp18_ = vala_gidl_parser_get_attributes (self, _tmp16_, &_tmp17_);
		attributes = _tmp18_;
		attributes_length1 = _tmp17_;
		_attributes_size_ = attributes_length1;
		_tmp19_ = attributes;
		_tmp19__length1 = attributes_length1;
		if (_tmp19_ != NULL) {
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			_tmp20_ = attributes;
			_tmp20__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp20_;
				attr_collection_length1 = _tmp20__length1;
				for (attr_it = 0; attr_it < _tmp20__length1; attr_it = attr_it + 1) {
					gchar* _tmp21_ = NULL;
					gchar* attr = NULL;
					_tmp21_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp21_;
					{
						gchar** nv = NULL;
						const gchar* _tmp22_ = NULL;
						gchar** _tmp23_ = NULL;
						gchar** _tmp24_ = NULL;
						gint nv_length1 = 0;
						gint _nv_size_ = 0;
						gchar** _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						const gchar* _tmp26_ = NULL;
						_tmp22_ = attr;
						_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, "=", 2);
						nv = _tmp24_;
						nv_length1 = _vala_array_length (_tmp23_);
						_nv_size_ = nv_length1;
						_tmp25_ = nv;
						_tmp25__length1 = nv_length1;
						_tmp26_ = _tmp25_[0];
						if (g_strcmp0 (_tmp26_, "cheader_filename") == 0) {
							ValaClass* _tmp27_ = NULL;
							gchar** _tmp28_ = NULL;
							gint _tmp28__length1 = 0;
							const gchar* _tmp29_ = NULL;
							gchar* _tmp30_ = NULL;
							gchar* _tmp31_ = NULL;
							_tmp27_ = cl;
							_tmp28_ = nv;
							_tmp28__length1 = nv_length1;
							_tmp29_ = _tmp28_[1];
							_tmp30_ = vala_gidl_parser_eval (self, _tmp29_);
							_tmp31_ = _tmp30_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp27_, "CCode", "cheader_filename", _tmp31_, NULL);
							_g_free0 (_tmp31_);
						} else {
							gchar** _tmp32_ = NULL;
							gint _tmp32__length1 = 0;
							const gchar* _tmp33_ = NULL;
							_tmp32_ = nv;
							_tmp32__length1 = nv_length1;
							_tmp33_ = _tmp32_[0];
							if (g_strcmp0 (_tmp33_, "base_class") == 0) {
								gchar** _tmp34_ = NULL;
								gint _tmp34__length1 = 0;
								const gchar* _tmp35_ = NULL;
								gchar* _tmp36_ = NULL;
								_tmp34_ = nv;
								_tmp34__length1 = nv_length1;
								_tmp35_ = _tmp34_[1];
								_tmp36_ = vala_gidl_parser_eval (self, _tmp35_);
								_g_free0 (base_class);
								base_class = _tmp36_;
							} else {
								gchar** _tmp37_ = NULL;
								gint _tmp37__length1 = 0;
								const gchar* _tmp38_ = NULL;
								_tmp37_ = nv;
								_tmp37__length1 = nv_length1;
								_tmp38_ = _tmp37_[0];
								if (g_strcmp0 (_tmp38_, "hidden") == 0) {
									gchar** _tmp39_ = NULL;
									gint _tmp39__length1 = 0;
									const gchar* _tmp40_ = NULL;
									gchar* _tmp41_ = NULL;
									gchar* _tmp42_ = NULL;
									gboolean _tmp43_ = FALSE;
									_tmp39_ = nv;
									_tmp39__length1 = nv_length1;
									_tmp40_ = _tmp39_[1];
									_tmp41_ = vala_gidl_parser_eval (self, _tmp40_);
									_tmp42_ = _tmp41_;
									_tmp43_ = g_strcmp0 (_tmp42_, "1") == 0;
									_g_free0 (_tmp42_);
									if (_tmp43_) {
										nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
										_g_free0 (attr);
										attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
										_vala_code_node_unref0 (cl);
										_g_free0 (base_class);
										_g_free0 (name);
										return;
									}
								} else {
									gchar** _tmp44_ = NULL;
									gint _tmp44__length1 = 0;
									const gchar* _tmp45_ = NULL;
									_tmp44_ = nv;
									_tmp44__length1 = nv_length1;
									_tmp45_ = _tmp44_[0];
									if (g_strcmp0 (_tmp45_, "type_check_function") == 0) {
										ValaClass* _tmp46_ = NULL;
										gchar** _tmp47_ = NULL;
										gint _tmp47__length1 = 0;
										const gchar* _tmp48_ = NULL;
										gchar* _tmp49_ = NULL;
										gchar* _tmp50_ = NULL;
										_tmp46_ = cl;
										_tmp47_ = nv;
										_tmp47__length1 = nv_length1;
										_tmp48_ = _tmp47_[1];
										_tmp49_ = vala_gidl_parser_eval (self, _tmp48_);
										_tmp50_ = _tmp49_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp46_, "CCode", "type_check_function", _tmp50_, NULL);
										_g_free0 (_tmp50_);
									} else {
										gchar** _tmp51_ = NULL;
										gint _tmp51__length1 = 0;
										const gchar* _tmp52_ = NULL;
										_tmp51_ = nv;
										_tmp51__length1 = nv_length1;
										_tmp52_ = _tmp51_[0];
										if (g_strcmp0 (_tmp52_, "deprecated") == 0) {
											gchar** _tmp53_ = NULL;
											gint _tmp53__length1 = 0;
											const gchar* _tmp54_ = NULL;
											gchar* _tmp55_ = NULL;
											gchar* _tmp56_ = NULL;
											gboolean _tmp57_ = FALSE;
											_tmp53_ = nv;
											_tmp53__length1 = nv_length1;
											_tmp54_ = _tmp53_[1];
											_tmp55_ = vala_gidl_parser_eval (self, _tmp54_);
											_tmp56_ = _tmp55_;
											_tmp57_ = g_strcmp0 (_tmp56_, "1") == 0;
											_g_free0 (_tmp56_);
											if (_tmp57_) {
												ValaClass* _tmp58_ = NULL;
												_tmp58_ = cl;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp58_, "Version", "deprecated", TRUE, NULL);
											}
										} else {
											gchar** _tmp59_ = NULL;
											gint _tmp59__length1 = 0;
											const gchar* _tmp60_ = NULL;
											_tmp59_ = nv;
											_tmp59__length1 = nv_length1;
											_tmp60_ = _tmp59_[0];
											if (g_strcmp0 (_tmp60_, "replacement") == 0) {
												ValaClass* _tmp61_ = NULL;
												gchar** _tmp62_ = NULL;
												gint _tmp62__length1 = 0;
												const gchar* _tmp63_ = NULL;
												gchar* _tmp64_ = NULL;
												gchar* _tmp65_ = NULL;
												_tmp61_ = cl;
												_tmp62_ = nv;
												_tmp62__length1 = nv_length1;
												_tmp63_ = _tmp62_[1];
												_tmp64_ = vala_gidl_parser_eval (self, _tmp63_);
												_tmp65_ = _tmp64_;
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp61_, "Version", "replacement", _tmp65_, NULL);
												_g_free0 (_tmp65_);
											} else {
												gchar** _tmp66_ = NULL;
												gint _tmp66__length1 = 0;
												const gchar* _tmp67_ = NULL;
												_tmp66_ = nv;
												_tmp66__length1 = nv_length1;
												_tmp67_ = _tmp66_[0];
												if (g_strcmp0 (_tmp67_, "deprecated_since") == 0) {
													ValaClass* _tmp68_ = NULL;
													gchar** _tmp69_ = NULL;
													gint _tmp69__length1 = 0;
													const gchar* _tmp70_ = NULL;
													gchar* _tmp71_ = NULL;
													gchar* _tmp72_ = NULL;
													_tmp68_ = cl;
													_tmp69_ = nv;
													_tmp69__length1 = nv_length1;
													_tmp70_ = _tmp69_[1];
													_tmp71_ = vala_gidl_parser_eval (self, _tmp70_);
													_tmp72_ = _tmp71_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp68_, "Version", "deprecated_since", _tmp72_, NULL);
													_g_free0 (_tmp72_);
												} else {
													gchar** _tmp73_ = NULL;
													gint _tmp73__length1 = 0;
													const gchar* _tmp74_ = NULL;
													_tmp73_ = nv;
													_tmp73__length1 = nv_length1;
													_tmp74_ = _tmp73_[0];
													if (g_strcmp0 (_tmp74_, "type_id") == 0) {
														ValaClass* _tmp75_ = NULL;
														gchar** _tmp76_ = NULL;
														gint _tmp76__length1 = 0;
														const gchar* _tmp77_ = NULL;
														gchar* _tmp78_ = NULL;
														gchar* _tmp79_ = NULL;
														_tmp75_ = cl;
														_tmp76_ = nv;
														_tmp76__length1 = nv_length1;
														_tmp77_ = _tmp76_[1];
														_tmp78_ = vala_gidl_parser_eval (self, _tmp77_);
														_tmp79_ = _tmp78_;
														vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp75_, "CCode", "type_id", _tmp79_, NULL);
														_g_free0 (_tmp79_);
													} else {
														gchar** _tmp80_ = NULL;
														gint _tmp80__length1 = 0;
														const gchar* _tmp81_ = NULL;
														_tmp80_ = nv;
														_tmp80__length1 = nv_length1;
														_tmp81_ = _tmp80_[0];
														if (g_strcmp0 (_tmp81_, "abstract") == 0) {
															gchar** _tmp82_ = NULL;
															gint _tmp82__length1 = 0;
															const gchar* _tmp83_ = NULL;
															gchar* _tmp84_ = NULL;
															gchar* _tmp85_ = NULL;
															gboolean _tmp86_ = FALSE;
															_tmp82_ = nv;
															_tmp82__length1 = nv_length1;
															_tmp83_ = _tmp82_[1];
															_tmp84_ = vala_gidl_parser_eval (self, _tmp83_);
															_tmp85_ = _tmp84_;
															_tmp86_ = g_strcmp0 (_tmp85_, "1") == 0;
															_g_free0 (_tmp85_);
															if (_tmp86_) {
																ValaClass* _tmp87_ = NULL;
																_tmp87_ = cl;
																vala_class_set_is_abstract (_tmp87_, TRUE);
															}
														} else {
															gchar** _tmp88_ = NULL;
															gint _tmp88__length1 = 0;
															const gchar* _tmp89_ = NULL;
															_tmp88_ = nv;
															_tmp88__length1 = nv_length1;
															_tmp89_ = _tmp88_[0];
															if (g_strcmp0 (_tmp89_, "experimental") == 0) {
																gchar** _tmp90_ = NULL;
																gint _tmp90__length1 = 0;
																const gchar* _tmp91_ = NULL;
																gchar* _tmp92_ = NULL;
																gchar* _tmp93_ = NULL;
																gboolean _tmp94_ = FALSE;
																_tmp90_ = nv;
																_tmp90__length1 = nv_length1;
																_tmp91_ = _tmp90_[1];
																_tmp92_ = vala_gidl_parser_eval (self, _tmp91_);
																_tmp93_ = _tmp92_;
																_tmp94_ = g_strcmp0 (_tmp93_, "1") == 0;
																_g_free0 (_tmp93_);
																if (_tmp94_) {
																	ValaClass* _tmp95_ = NULL;
																	_tmp95_ = cl;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp95_, "Version", "experimental", TRUE, NULL);
																}
															} else {
																gchar** _tmp96_ = NULL;
																gint _tmp96__length1 = 0;
																const gchar* _tmp97_ = NULL;
																_tmp96_ = nv;
																_tmp96__length1 = nv_length1;
																_tmp97_ = _tmp96_[0];
																if (g_strcmp0 (_tmp97_, "compact") == 0) {
																	gchar** _tmp98_ = NULL;
																	gint _tmp98__length1 = 0;
																	const gchar* _tmp99_ = NULL;
																	gchar* _tmp100_ = NULL;
																	gchar* _tmp101_ = NULL;
																	gboolean _tmp102_ = FALSE;
																	_tmp98_ = nv;
																	_tmp98__length1 = nv_length1;
																	_tmp99_ = _tmp98_[1];
																	_tmp100_ = vala_gidl_parser_eval (self, _tmp99_);
																	_tmp101_ = _tmp100_;
																	_tmp102_ = g_strcmp0 (_tmp101_, "1") == 0;
																	_g_free0 (_tmp101_);
																	if (_tmp102_) {
																		ValaClass* _tmp103_ = NULL;
																		_tmp103_ = cl;
																		vala_class_set_is_compact (_tmp103_, TRUE);
																	}
																} else {
																	gchar** _tmp104_ = NULL;
																	gint _tmp104__length1 = 0;
																	const gchar* _tmp105_ = NULL;
																	_tmp104_ = nv;
																	_tmp104__length1 = nv_length1;
																	_tmp105_ = _tmp104_[0];
																	if (g_strcmp0 (_tmp105_, "ref_function") == 0) {
																		ValaClass* _tmp106_ = NULL;
																		gchar** _tmp107_ = NULL;
																		gint _tmp107__length1 = 0;
																		const gchar* _tmp108_ = NULL;
																		gchar* _tmp109_ = NULL;
																		gchar* _tmp110_ = NULL;
																		_tmp106_ = cl;
																		_tmp107_ = nv;
																		_tmp107__length1 = nv_length1;
																		_tmp108_ = _tmp107_[1];
																		_tmp109_ = vala_gidl_parser_eval (self, _tmp108_);
																		_tmp110_ = _tmp109_;
																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp106_, "CCode", "ref_function", _tmp110_, NULL);
																		_g_free0 (_tmp110_);
																	} else {
																		gchar** _tmp111_ = NULL;
																		gint _tmp111__length1 = 0;
																		const gchar* _tmp112_ = NULL;
																		_tmp111_ = nv;
																		_tmp111__length1 = nv_length1;
																		_tmp112_ = _tmp111_[0];
																		if (g_strcmp0 (_tmp112_, "unref_function") == 0) {
																			ValaClass* _tmp113_ = NULL;
																			gchar** _tmp114_ = NULL;
																			gint _tmp114__length1 = 0;
																			const gchar* _tmp115_ = NULL;
																			gchar* _tmp116_ = NULL;
																			gchar* _tmp117_ = NULL;
																			_tmp113_ = cl;
																			_tmp114_ = nv;
																			_tmp114__length1 = nv_length1;
																			_tmp115_ = _tmp114_[1];
																			_tmp116_ = vala_gidl_parser_eval (self, _tmp115_);
																			_tmp117_ = _tmp116_;
																			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp113_, "CCode", "unref_function", _tmp117_, NULL);
																			_g_free0 (_tmp117_);
																		} else {
																			gchar** _tmp118_ = NULL;
																			gint _tmp118__length1 = 0;
																			const gchar* _tmp119_ = NULL;
																			_tmp118_ = nv;
																			_tmp118__length1 = nv_length1;
																			_tmp119_ = _tmp118_[0];
																			if (g_strcmp0 (_tmp119_, "copy_function") == 0) {
																				ValaClass* _tmp120_ = NULL;
																				gchar** _tmp121_ = NULL;
																				gint _tmp121__length1 = 0;
																				const gchar* _tmp122_ = NULL;
																				gchar* _tmp123_ = NULL;
																				gchar* _tmp124_ = NULL;
																				_tmp120_ = cl;
																				_tmp121_ = nv;
																				_tmp121__length1 = nv_length1;
																				_tmp122_ = _tmp121_[1];
																				_tmp123_ = vala_gidl_parser_eval (self, _tmp122_);
																				_tmp124_ = _tmp123_;
																				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp120_, "CCode", "copy_function", _tmp124_, NULL);
																				_g_free0 (_tmp124_);
																			} else {
																				gchar** _tmp125_ = NULL;
																				gint _tmp125__length1 = 0;
																				const gchar* _tmp126_ = NULL;
																				_tmp125_ = nv;
																				_tmp125__length1 = nv_length1;
																				_tmp126_ = _tmp125_[0];
																				if (g_strcmp0 (_tmp126_, "free_function") == 0) {
																					ValaClass* _tmp127_ = NULL;
																					gchar** _tmp128_ = NULL;
																					gint _tmp128__length1 = 0;
																					const gchar* _tmp129_ = NULL;
																					gchar* _tmp130_ = NULL;
																					gchar* _tmp131_ = NULL;
																					_tmp127_ = cl;
																					_tmp128_ = nv;
																					_tmp128__length1 = nv_length1;
																					_tmp129_ = _tmp128_[1];
																					_tmp130_ = vala_gidl_parser_eval (self, _tmp129_);
																					_tmp131_ = _tmp130_;
																					vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp127_, "CCode", "free_function", _tmp131_, NULL);
																					_g_free0 (_tmp131_);
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		_tmp132_ = container;
		_tmp133_ = cl;
		vala_gidl_parser_add_symbol_to_container (self, _tmp132_, (ValaSymbol*) _tmp133_);
		_tmp134_ = self->priv->current_source_file;
		_tmp135_ = cl;
		vala_source_file_add_node (_tmp134_, (ValaCodeNode*) _tmp135_);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp136_ = base_class;
	if (_tmp136_ != NULL) {
		ValaDataType* parent = NULL;
		const gchar* _tmp137_ = NULL;
		ValaDataType* _tmp138_ = NULL;
		ValaClass* _tmp139_ = NULL;
		ValaDataType* _tmp140_ = NULL;
		_tmp137_ = base_class;
		_tmp138_ = vala_gidl_parser_parse_type_string (self, _tmp137_);
		parent = _tmp138_;
		_tmp139_ = cl;
		_tmp140_ = parent;
		vala_class_add_base_type (_tmp139_, _tmp140_);
		_vala_code_node_unref0 (parent);
	} else {
		GIdlNodeInterface* _tmp141_ = NULL;
		const gchar* _tmp142_ = NULL;
		_tmp141_ = node;
		_tmp142_ = _tmp141_->parent;
		if (_tmp142_ != NULL) {
			ValaClass* _tmp143_ = NULL;
			gboolean _tmp144_ = FALSE;
			gboolean _tmp145_ = FALSE;
			_tmp143_ = cl;
			_tmp144_ = vala_class_get_is_compact (_tmp143_);
			_tmp145_ = _tmp144_;
			if (!_tmp145_) {
				ValaDataType* parent = NULL;
				GIdlNodeInterface* _tmp146_ = NULL;
				const gchar* _tmp147_ = NULL;
				ValaDataType* _tmp148_ = NULL;
				ValaClass* _tmp149_ = NULL;
				ValaDataType* _tmp150_ = NULL;
				_tmp146_ = node;
				_tmp147_ = _tmp146_->parent;
				_tmp148_ = vala_gidl_parser_parse_type_string (self, _tmp147_);
				parent = _tmp148_;
				_tmp149_ = cl;
				_tmp150_ = parent;
				vala_class_add_base_type (_tmp149_, _tmp150_);
				_vala_code_node_unref0 (parent);
			}
		} else {
			ValaUnresolvedSymbol* gobject_symbol = NULL;
			ValaUnresolvedSymbol* _tmp151_ = NULL;
			ValaUnresolvedSymbol* _tmp152_ = NULL;
			ValaUnresolvedSymbol* _tmp153_ = NULL;
			ValaUnresolvedSymbol* _tmp154_ = NULL;
			ValaClass* _tmp155_ = NULL;
			ValaUnresolvedSymbol* _tmp156_ = NULL;
			ValaUnresolvedType* _tmp157_ = NULL;
			ValaUnresolvedType* _tmp158_ = NULL;
			_tmp151_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
			_tmp152_ = _tmp151_;
			_tmp153_ = vala_unresolved_symbol_new (_tmp152_, "Object", NULL);
			_tmp154_ = _tmp153_;
			_vala_code_node_unref0 (_tmp152_);
			gobject_symbol = _tmp154_;
			_tmp155_ = cl;
			_tmp156_ = gobject_symbol;
			_tmp157_ = vala_unresolved_type_new_from_symbol (_tmp156_, NULL);
			_tmp158_ = _tmp157_;
			vala_class_add_base_type (_tmp155_, (ValaDataType*) _tmp158_);
			_vala_code_node_unref0 (_tmp158_);
			_vala_code_node_unref0 (gobject_symbol);
		}
	}
	_tmp159_ = node;
	_tmp160_ = _tmp159_->interfaces;
	{
		GList* iface_name_collection = NULL;
		GList* iface_name_it = NULL;
		iface_name_collection = _tmp160_;
		for (iface_name_it = iface_name_collection; iface_name_it != NULL; iface_name_it = iface_name_it->next) {
			gchar* _tmp161_ = NULL;
			gchar* iface_name = NULL;
			_tmp161_ = g_strdup ((const gchar*) iface_name_it->data);
			iface_name = _tmp161_;
			{
				gboolean skip_iface = FALSE;
				gchar** attributes = NULL;
				const gchar* _tmp162_ = NULL;
				gint _tmp163_ = 0;
				gchar** _tmp164_ = NULL;
				gint attributes_length1 = 0;
				gint _attributes_size_ = 0;
				gchar** _tmp165_ = NULL;
				gint _tmp165__length1 = 0;
				gboolean _tmp178_ = FALSE;
				ValaDataType* iface = NULL;
				const gchar* _tmp179_ = NULL;
				ValaDataType* _tmp180_ = NULL;
				ValaClass* _tmp181_ = NULL;
				ValaDataType* _tmp182_ = NULL;
				skip_iface = FALSE;
				_tmp162_ = iface_name;
				_tmp164_ = vala_gidl_parser_get_attributes (self, _tmp162_, &_tmp163_);
				attributes = _tmp164_;
				attributes_length1 = _tmp163_;
				_attributes_size_ = attributes_length1;
				_tmp165_ = attributes;
				_tmp165__length1 = attributes_length1;
				if (_tmp165_ != NULL) {
					gchar** _tmp166_ = NULL;
					gint _tmp166__length1 = 0;
					_tmp166_ = attributes;
					_tmp166__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp166_;
						attr_collection_length1 = _tmp166__length1;
						for (attr_it = 0; attr_it < _tmp166__length1; attr_it = attr_it + 1) {
							gchar* _tmp167_ = NULL;
							gchar* attr = NULL;
							_tmp167_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp167_;
							{
								gchar** nv = NULL;
								const gchar* _tmp168_ = NULL;
								gchar** _tmp169_ = NULL;
								gchar** _tmp170_ = NULL;
								gint nv_length1 = 0;
								gint _nv_size_ = 0;
								gchar** _tmp171_ = NULL;
								gint _tmp171__length1 = 0;
								const gchar* _tmp172_ = NULL;
								_tmp168_ = attr;
								_tmp170_ = _tmp169_ = g_strsplit (_tmp168_, "=", 2);
								nv = _tmp170_;
								nv_length1 = _vala_array_length (_tmp169_);
								_nv_size_ = nv_length1;
								_tmp171_ = nv;
								_tmp171__length1 = nv_length1;
								_tmp172_ = _tmp171_[0];
								if (g_strcmp0 (_tmp172_, "hidden") == 0) {
									gchar** _tmp173_ = NULL;
									gint _tmp173__length1 = 0;
									const gchar* _tmp174_ = NULL;
									gchar* _tmp175_ = NULL;
									gchar* _tmp176_ = NULL;
									gboolean _tmp177_ = FALSE;
									_tmp173_ = nv;
									_tmp173__length1 = nv_length1;
									_tmp174_ = _tmp173_[1];
									_tmp175_ = vala_gidl_parser_eval (self, _tmp174_);
									_tmp176_ = _tmp175_;
									_tmp177_ = g_strcmp0 (_tmp176_, "1") == 0;
									_g_free0 (_tmp176_);
									if (_tmp177_) {
										skip_iface = TRUE;
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp178_ = skip_iface;
				if (_tmp178_) {
					attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (iface_name);
					continue;
				}
				_tmp179_ = iface_name;
				_tmp180_ = vala_gidl_parser_parse_type_string (self, _tmp179_);
				iface = _tmp180_;
				_tmp181_ = cl;
				_tmp182_ = iface;
				vala_class_add_base_type (_tmp181_, _tmp182_);
				_vala_code_node_unref0 (iface);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (iface_name);
			}
		}
	}
	_tmp183_ = cl;
	_tmp184_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp183_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp184_;
	_tmp185_ = g_str_hash;
	_tmp186_ = g_str_equal;
	_tmp187_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp185_, _tmp186_);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = (ValaSet*) _tmp187_;
	_tmp188_ = g_str_hash;
	_tmp189_ = g_str_equal;
	_tmp190_ = g_direct_equal;
	_tmp191_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_POINTER, NULL, NULL, _tmp188_, _tmp189_, _tmp190_);
	current_type_func_map = _tmp191_;
	_tmp192_ = g_str_hash;
	_tmp193_ = g_str_equal;
	_tmp194_ = g_direct_equal;
	_tmp195_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp192_, _tmp193_, _tmp194_);
	current_type_vfunc_map = _tmp195_;
	_tmp196_ = node;
	_tmp197_ = _tmp196_->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp197_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp198_ = NULL;
				GIdlNodeTypeId _tmp199_ = 0;
				GIdlNode* _tmp204_ = NULL;
				GIdlNodeTypeId _tmp205_ = 0;
				_tmp198_ = member;
				_tmp199_ = _tmp198_->type;
				if (_tmp199_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp200_ = NULL;
					GIdlNode* _tmp201_ = NULL;
					const gchar* _tmp202_ = NULL;
					GIdlNode* _tmp203_ = NULL;
					_tmp200_ = current_type_func_map;
					_tmp201_ = member;
					_tmp202_ = _tmp201_->name;
					_tmp203_ = member;
					vala_map_set ((ValaMap*) _tmp200_, _tmp202_, (GIdlNodeFunction*) _tmp203_);
				}
				_tmp204_ = member;
				_tmp205_ = _tmp204_->type;
				if (_tmp205_ == G_IDL_NODE_VFUNC) {
					ValaHashMap* _tmp206_ = NULL;
					GIdlNode* _tmp207_ = NULL;
					const gchar* _tmp208_ = NULL;
					_tmp206_ = current_type_vfunc_map;
					_tmp207_ = member;
					_tmp208_ = _tmp207_->name;
					vala_map_set ((ValaMap*) _tmp206_, _tmp208_, "1");
				}
			}
		}
	}
	_tmp209_ = node;
	_tmp210_ = _tmp209_->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp210_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp211_ = NULL;
				GIdlNodeTypeId _tmp212_ = 0;
				_tmp211_ = member;
				_tmp212_ = _tmp211_->type;
				if (_tmp212_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp213_ = NULL;
					GIdlNode* _tmp214_ = NULL;
					const gchar* _tmp215_ = NULL;
					gboolean _tmp216_ = FALSE;
					_tmp213_ = current_type_vfunc_map;
					_tmp214_ = member;
					_tmp215_ = _tmp214_->name;
					_tmp216_ = vala_map_contains ((ValaMap*) _tmp213_, _tmp215_);
					if (!_tmp216_) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp217_ = NULL;
						ValaMethod* _tmp218_ = NULL;
						ValaMethod* _tmp219_ = NULL;
						_tmp217_ = member;
						_tmp218_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp217_, FALSE);
						m = _tmp218_;
						_tmp219_ = m;
						if (_tmp219_ != NULL) {
							ValaClass* _tmp220_ = NULL;
							ValaMethod* _tmp221_ = NULL;
							_tmp220_ = cl;
							_tmp221_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp220_, _tmp221_);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					GIdlNode* _tmp222_ = NULL;
					GIdlNodeTypeId _tmp223_ = 0;
					_tmp222_ = member;
					_tmp223_ = _tmp222_->type;
					if (_tmp223_ == G_IDL_NODE_VFUNC) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp224_ = NULL;
						ValaHashMap* _tmp225_ = NULL;
						GIdlNode* _tmp226_ = NULL;
						const gchar* _tmp227_ = NULL;
						gpointer _tmp228_ = NULL;
						ValaMethod* _tmp229_ = NULL;
						ValaMethod* _tmp230_ = NULL;
						_tmp224_ = member;
						_tmp225_ = current_type_func_map;
						_tmp226_ = member;
						_tmp227_ = _tmp226_->name;
						_tmp228_ = vala_map_get ((ValaMap*) _tmp225_, _tmp227_);
						_tmp229_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) _tmp224_, (GIdlNodeFunction*) _tmp228_, FALSE);
						m = _tmp229_;
						_tmp230_ = m;
						if (_tmp230_ != NULL) {
							ValaClass* _tmp231_ = NULL;
							ValaMethod* _tmp232_ = NULL;
							_tmp231_ = cl;
							_tmp232_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp231_, _tmp232_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp233_ = NULL;
						GIdlNodeTypeId _tmp234_ = 0;
						_tmp233_ = member;
						_tmp234_ = _tmp233_->type;
						if (_tmp234_ == G_IDL_NODE_PROPERTY) {
							ValaProperty* prop = NULL;
							GIdlNode* _tmp235_ = NULL;
							ValaProperty* _tmp236_ = NULL;
							ValaProperty* _tmp237_ = NULL;
							_tmp235_ = member;
							_tmp236_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) _tmp235_);
							prop = _tmp236_;
							_tmp237_ = prop;
							if (_tmp237_ != NULL) {
								ValaClass* _tmp238_ = NULL;
								ValaProperty* _tmp239_ = NULL;
								_tmp238_ = cl;
								_tmp239_ = prop;
								vala_symbol_add_property ((ValaSymbol*) _tmp238_, _tmp239_);
							}
							_vala_code_node_unref0 (prop);
						} else {
							GIdlNode* _tmp240_ = NULL;
							GIdlNodeTypeId _tmp241_ = 0;
							_tmp240_ = member;
							_tmp241_ = _tmp240_->type;
							if (_tmp241_ == G_IDL_NODE_SIGNAL) {
								ValaSignal* sig = NULL;
								GIdlNode* _tmp242_ = NULL;
								ValaSignal* _tmp243_ = NULL;
								ValaSignal* _tmp244_ = NULL;
								_tmp242_ = member;
								_tmp243_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) _tmp242_);
								sig = _tmp243_;
								_tmp244_ = sig;
								if (_tmp244_ != NULL) {
									ValaClass* _tmp245_ = NULL;
									ValaSignal* _tmp246_ = NULL;
									_tmp245_ = cl;
									_tmp246_ = sig;
									vala_symbol_add_signal ((ValaSymbol*) _tmp245_, _tmp246_);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	_tmp247_ = node;
	_tmp248_ = _tmp247_->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp248_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp249_ = NULL;
				GIdlNodeTypeId _tmp250_ = 0;
				_tmp249_ = member;
				_tmp250_ = _tmp249_->type;
				if (_tmp250_ == G_IDL_NODE_FIELD) {
					ValaSet* _tmp251_ = NULL;
					GIdlNode* _tmp252_ = NULL;
					const gchar* _tmp253_ = NULL;
					gboolean _tmp254_ = FALSE;
					_tmp251_ = self->priv->current_type_symbol_set;
					_tmp252_ = member;
					_tmp253_ = _tmp252_->name;
					_tmp254_ = vala_collection_contains ((ValaCollection*) _tmp251_, _tmp253_);
					if (!_tmp254_) {
						ValaField* f = NULL;
						GIdlNode* _tmp255_ = NULL;
						ValaField* _tmp256_ = NULL;
						ValaField* _tmp257_ = NULL;
						_tmp255_ = member;
						_tmp256_ = vala_gidl_parser_parse_field (self, (GIdlNodeField*) _tmp255_);
						f = _tmp256_;
						_tmp257_ = f;
						if (_tmp257_ != NULL) {
							ValaClass* _tmp258_ = NULL;
							ValaField* _tmp259_ = NULL;
							_tmp258_ = cl;
							_tmp259_ = f;
							vala_symbol_add_field ((ValaSymbol*) _tmp258_, _tmp259_);
						}
						_vala_code_node_unref0 (f);
					}
				}
			}
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaClass* _tmp260_ = NULL;
		ValaList* _tmp261_ = NULL;
		gint _prop_size = 0;
		ValaList* _tmp262_ = NULL;
		gint _tmp263_ = 0;
		gint _tmp264_ = 0;
		gint _prop_index = 0;
		_tmp260_ = cl;
		_tmp261_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp260_);
		_prop_list = _tmp261_;
		_tmp262_ = _prop_list;
		_tmp263_ = vala_collection_get_size ((ValaCollection*) _tmp262_);
		_tmp264_ = _tmp263_;
		_prop_size = _tmp264_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp265_ = 0;
			gint _tmp266_ = 0;
			gint _tmp267_ = 0;
			ValaProperty* prop = NULL;
			ValaList* _tmp268_ = NULL;
			gint _tmp269_ = 0;
			gpointer _tmp270_ = NULL;
			gchar* getter = NULL;
			ValaProperty* _tmp271_ = NULL;
			const gchar* _tmp272_ = NULL;
			const gchar* _tmp273_ = NULL;
			gchar* _tmp274_ = NULL;
			gboolean _tmp275_ = FALSE;
			ValaProperty* _tmp276_ = NULL;
			ValaPropertyAccessor* _tmp277_ = NULL;
			ValaPropertyAccessor* _tmp278_ = NULL;
			gchar* setter = NULL;
			ValaProperty* _tmp283_ = NULL;
			const gchar* _tmp284_ = NULL;
			const gchar* _tmp285_ = NULL;
			gchar* _tmp286_ = NULL;
			gboolean _tmp287_ = FALSE;
			gboolean _tmp288_ = FALSE;
			ValaProperty* _tmp289_ = NULL;
			ValaPropertyAccessor* _tmp290_ = NULL;
			ValaPropertyAccessor* _tmp291_ = NULL;
			gboolean _tmp301_ = FALSE;
			ValaProperty* _tmp302_ = NULL;
			ValaAttribute* _tmp303_ = NULL;
			ValaAttribute* _tmp304_ = NULL;
			gboolean _tmp305_ = FALSE;
			_tmp265_ = _prop_index;
			_prop_index = _tmp265_ + 1;
			_tmp266_ = _prop_index;
			_tmp267_ = _prop_size;
			if (!(_tmp266_ < _tmp267_)) {
				break;
			}
			_tmp268_ = _prop_list;
			_tmp269_ = _prop_index;
			_tmp270_ = vala_list_get (_tmp268_, _tmp269_);
			prop = (ValaProperty*) _tmp270_;
			_tmp271_ = prop;
			_tmp272_ = vala_symbol_get_name ((ValaSymbol*) _tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = g_strdup_printf ("get_%s", _tmp273_);
			getter = _tmp274_;
			_tmp276_ = prop;
			_tmp277_ = vala_property_get_get_accessor (_tmp276_);
			_tmp278_ = _tmp277_;
			if (_tmp278_ != NULL) {
				ValaSet* _tmp279_ = NULL;
				const gchar* _tmp280_ = NULL;
				gboolean _tmp281_ = FALSE;
				_tmp279_ = self->priv->current_type_symbol_set;
				_tmp280_ = getter;
				_tmp281_ = vala_collection_contains ((ValaCollection*) _tmp279_, _tmp280_);
				_tmp275_ = !_tmp281_;
			} else {
				_tmp275_ = FALSE;
			}
			if (_tmp275_) {
				ValaProperty* _tmp282_ = NULL;
				_tmp282_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp282_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp283_ = prop;
			_tmp284_ = vala_symbol_get_name ((ValaSymbol*) _tmp283_);
			_tmp285_ = _tmp284_;
			_tmp286_ = g_strdup_printf ("set_%s", _tmp285_);
			setter = _tmp286_;
			_tmp289_ = prop;
			_tmp290_ = vala_property_get_set_accessor (_tmp289_);
			_tmp291_ = _tmp290_;
			if (_tmp291_ != NULL) {
				ValaProperty* _tmp292_ = NULL;
				ValaPropertyAccessor* _tmp293_ = NULL;
				ValaPropertyAccessor* _tmp294_ = NULL;
				gboolean _tmp295_ = FALSE;
				gboolean _tmp296_ = FALSE;
				_tmp292_ = prop;
				_tmp293_ = vala_property_get_set_accessor (_tmp292_);
				_tmp294_ = _tmp293_;
				_tmp295_ = vala_property_accessor_get_writable (_tmp294_);
				_tmp296_ = _tmp295_;
				_tmp288_ = _tmp296_;
			} else {
				_tmp288_ = FALSE;
			}
			if (_tmp288_) {
				ValaSet* _tmp297_ = NULL;
				const gchar* _tmp298_ = NULL;
				gboolean _tmp299_ = FALSE;
				_tmp297_ = self->priv->current_type_symbol_set;
				_tmp298_ = setter;
				_tmp299_ = vala_collection_contains ((ValaCollection*) _tmp297_, _tmp298_);
				_tmp287_ = !_tmp299_;
			} else {
				_tmp287_ = FALSE;
			}
			if (_tmp287_) {
				ValaProperty* _tmp300_ = NULL;
				_tmp300_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp300_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp302_ = prop;
			_tmp303_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp302_, "NoAccessorMethod");
			_tmp304_ = _tmp303_;
			_tmp305_ = _tmp304_ != NULL;
			_vala_code_node_unref0 (_tmp304_);
			if (_tmp305_) {
				ValaProperty* _tmp306_ = NULL;
				ValaPropertyAccessor* _tmp307_ = NULL;
				ValaPropertyAccessor* _tmp308_ = NULL;
				_tmp306_ = prop;
				_tmp307_ = vala_property_get_get_accessor (_tmp306_);
				_tmp308_ = _tmp307_;
				_tmp301_ = _tmp308_ != NULL;
			} else {
				_tmp301_ = FALSE;
			}
			if (_tmp301_) {
				ValaProperty* _tmp309_ = NULL;
				ValaPropertyAccessor* _tmp310_ = NULL;
				ValaPropertyAccessor* _tmp311_ = NULL;
				ValaDataType* _tmp312_ = NULL;
				ValaDataType* _tmp313_ = NULL;
				_tmp309_ = prop;
				_tmp310_ = vala_property_get_get_accessor (_tmp309_);
				_tmp311_ = _tmp310_;
				_tmp312_ = vala_property_accessor_get_value_type (_tmp311_);
				_tmp313_ = _tmp312_;
				vala_data_type_set_value_owned (_tmp313_, TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp314_ = cl;
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) _tmp314_);
	_tmp315_ = cl;
	_tmp316_ = vala_class_get_default_construction_method (_tmp315_);
	_tmp317_ = _tmp316_;
	if (_tmp317_ == NULL) {
		ValaCreationMethod* cm = NULL;
		ValaClass* _tmp318_ = NULL;
		ValaSourceReference* _tmp319_ = NULL;
		ValaSourceReference* _tmp320_ = NULL;
		ValaCreationMethod* _tmp321_ = NULL;
		ValaCreationMethod* _tmp322_ = NULL;
		ValaCreationMethod* _tmp323_ = NULL;
		ValaClass* _tmp324_ = NULL;
		ValaCreationMethod* _tmp325_ = NULL;
		_tmp318_ = cl;
		_tmp319_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp318_);
		_tmp320_ = _tmp319_;
		_tmp321_ = vala_creation_method_new (NULL, NULL, _tmp320_, NULL);
		cm = _tmp321_;
		_tmp322_ = cm;
		vala_method_set_has_construct_function ((ValaMethod*) _tmp322_, FALSE);
		_tmp323_ = cm;
		vala_symbol_set_access ((ValaSymbol*) _tmp323_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
		_tmp324_ = cl;
		_tmp325_ = cm;
		vala_symbol_add_method ((ValaSymbol*) _tmp324_, (ValaMethod*) _tmp325_);
		_vala_code_node_unref0 (cm);
	}
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = NULL;
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = NULL;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (cl);
	_g_free0 (base_class);
	_g_free0 (name);
}


static void vala_gidl_parser_parse_interface (ValaGIdlParser* self, GIdlNodeInterface* node, ValaSymbol* container, GIdlModule* module) {
	gchar* name = NULL;
	GIdlNodeInterface* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	ValaSymbol* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	ValaInterface* iface = NULL;
	ValaSymbol* _tmp4_ = NULL;
	ValaScope* _tmp5_ = NULL;
	ValaScope* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	ValaSymbol* _tmp8_ = NULL;
	ValaInterface* _tmp9_ = NULL;
	ValaInterface* _tmp10_ = NULL;
	ValaInterface* _tmp64_ = NULL;
	ValaTypeSymbol* _tmp65_ = NULL;
	GHashFunc _tmp66_ = NULL;
	GEqualFunc _tmp67_ = NULL;
	ValaHashSet* _tmp68_ = NULL;
	ValaHashMap* current_type_func_map = NULL;
	GHashFunc _tmp69_ = NULL;
	GEqualFunc _tmp70_ = NULL;
	GEqualFunc _tmp71_ = NULL;
	ValaHashMap* _tmp72_ = NULL;
	ValaHashMap* current_type_vfunc_map = NULL;
	GHashFunc _tmp73_ = NULL;
	GEqualFunc _tmp74_ = NULL;
	GEqualFunc _tmp75_ = NULL;
	ValaHashMap* _tmp76_ = NULL;
	GIdlNodeInterface* _tmp77_ = NULL;
	GList* _tmp78_ = NULL;
	GIdlNodeInterface* _tmp90_ = NULL;
	GList* _tmp91_ = NULL;
	ValaInterface* _tmp183_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (module != NULL);
	_tmp0_ = node;
	_tmp1_ = _tmp0_->gtype_name;
	_tmp2_ = container;
	_tmp3_ = vala_gidl_parser_fix_type_name (self, _tmp1_, _tmp2_);
	name = _tmp3_;
	_tmp4_ = container;
	_tmp5_ = vala_symbol_get_scope (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = name;
	_tmp8_ = vala_scope_lookup (_tmp6_, _tmp7_);
	_tmp9_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_INTERFACE) ? ((ValaInterface*) _tmp8_) : NULL;
	if (_tmp9_ == NULL) {
		_vala_code_node_unref0 (_tmp8_);
	}
	iface = _tmp9_;
	_tmp10_ = iface;
	if (_tmp10_ == NULL) {
		const gchar* _tmp11_ = NULL;
		ValaSourceReference* _tmp12_ = NULL;
		ValaInterface* _tmp13_ = NULL;
		ValaInterface* _tmp14_ = NULL;
		gchar** attributes = NULL;
		GIdlNodeInterface* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gchar** _tmp18_ = NULL;
		gint attributes_length1 = 0;
		gint _attributes_size_ = 0;
		gchar** _tmp19_ = NULL;
		gint _tmp19__length1 = 0;
		GIdlNodeInterface* _tmp53_ = NULL;
		GList* _tmp54_ = NULL;
		ValaSymbol* _tmp60_ = NULL;
		ValaInterface* _tmp61_ = NULL;
		ValaSourceFile* _tmp62_ = NULL;
		ValaInterface* _tmp63_ = NULL;
		_tmp11_ = name;
		_tmp12_ = self->priv->current_source_reference;
		_tmp13_ = vala_interface_new (_tmp11_, _tmp12_, NULL);
		_vala_code_node_unref0 (iface);
		iface = _tmp13_;
		_tmp14_ = iface;
		vala_symbol_set_access ((ValaSymbol*) _tmp14_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp15_ = node;
		_tmp16_ = _tmp15_->gtype_name;
		_tmp18_ = vala_gidl_parser_get_attributes (self, _tmp16_, &_tmp17_);
		attributes = _tmp18_;
		attributes_length1 = _tmp17_;
		_attributes_size_ = attributes_length1;
		_tmp19_ = attributes;
		_tmp19__length1 = attributes_length1;
		if (_tmp19_ != NULL) {
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			_tmp20_ = attributes;
			_tmp20__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp20_;
				attr_collection_length1 = _tmp20__length1;
				for (attr_it = 0; attr_it < _tmp20__length1; attr_it = attr_it + 1) {
					gchar* _tmp21_ = NULL;
					gchar* attr = NULL;
					_tmp21_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp21_;
					{
						gchar** nv = NULL;
						const gchar* _tmp22_ = NULL;
						gchar** _tmp23_ = NULL;
						gchar** _tmp24_ = NULL;
						gint nv_length1 = 0;
						gint _nv_size_ = 0;
						gchar** _tmp25_ = NULL;
						gint _tmp25__length1 = 0;
						const gchar* _tmp26_ = NULL;
						_tmp22_ = attr;
						_tmp24_ = _tmp23_ = g_strsplit (_tmp22_, "=", 2);
						nv = _tmp24_;
						nv_length1 = _vala_array_length (_tmp23_);
						_nv_size_ = nv_length1;
						_tmp25_ = nv;
						_tmp25__length1 = nv_length1;
						_tmp26_ = _tmp25_[0];
						if (g_strcmp0 (_tmp26_, "cheader_filename") == 0) {
							ValaInterface* _tmp27_ = NULL;
							gchar** _tmp28_ = NULL;
							gint _tmp28__length1 = 0;
							const gchar* _tmp29_ = NULL;
							gchar* _tmp30_ = NULL;
							gchar* _tmp31_ = NULL;
							_tmp27_ = iface;
							_tmp28_ = nv;
							_tmp28__length1 = nv_length1;
							_tmp29_ = _tmp28_[1];
							_tmp30_ = vala_gidl_parser_eval (self, _tmp29_);
							_tmp31_ = _tmp30_;
							vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp27_, "CCode", "cheader_filename", _tmp31_, NULL);
							_g_free0 (_tmp31_);
						} else {
							gchar** _tmp32_ = NULL;
							gint _tmp32__length1 = 0;
							const gchar* _tmp33_ = NULL;
							_tmp32_ = nv;
							_tmp32__length1 = nv_length1;
							_tmp33_ = _tmp32_[0];
							if (g_strcmp0 (_tmp33_, "hidden") == 0) {
								gchar** _tmp34_ = NULL;
								gint _tmp34__length1 = 0;
								const gchar* _tmp35_ = NULL;
								gchar* _tmp36_ = NULL;
								gchar* _tmp37_ = NULL;
								gboolean _tmp38_ = FALSE;
								_tmp34_ = nv;
								_tmp34__length1 = nv_length1;
								_tmp35_ = _tmp34_[1];
								_tmp36_ = vala_gidl_parser_eval (self, _tmp35_);
								_tmp37_ = _tmp36_;
								_tmp38_ = g_strcmp0 (_tmp37_, "1") == 0;
								_g_free0 (_tmp37_);
								if (_tmp38_) {
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (iface);
									_g_free0 (name);
									return;
								}
							} else {
								gchar** _tmp39_ = NULL;
								gint _tmp39__length1 = 0;
								const gchar* _tmp40_ = NULL;
								_tmp39_ = nv;
								_tmp39__length1 = nv_length1;
								_tmp40_ = _tmp39_[0];
								if (g_strcmp0 (_tmp40_, "type_cname") == 0) {
									ValaInterface* _tmp41_ = NULL;
									gchar** _tmp42_ = NULL;
									gint _tmp42__length1 = 0;
									const gchar* _tmp43_ = NULL;
									gchar* _tmp44_ = NULL;
									gchar* _tmp45_ = NULL;
									_tmp41_ = iface;
									_tmp42_ = nv;
									_tmp42__length1 = nv_length1;
									_tmp43_ = _tmp42_[1];
									_tmp44_ = vala_gidl_parser_eval (self, _tmp43_);
									_tmp45_ = _tmp44_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp41_, "CCode", "type_cname", _tmp45_, NULL);
									_g_free0 (_tmp45_);
								} else {
									gchar** _tmp46_ = NULL;
									gint _tmp46__length1 = 0;
									const gchar* _tmp47_ = NULL;
									_tmp46_ = nv;
									_tmp46__length1 = nv_length1;
									_tmp47_ = _tmp46_[0];
									if (g_strcmp0 (_tmp47_, "lower_case_csuffix") == 0) {
										ValaInterface* _tmp48_ = NULL;
										gchar** _tmp49_ = NULL;
										gint _tmp49__length1 = 0;
										const gchar* _tmp50_ = NULL;
										gchar* _tmp51_ = NULL;
										gchar* _tmp52_ = NULL;
										_tmp48_ = iface;
										_tmp49_ = nv;
										_tmp49__length1 = nv_length1;
										_tmp50_ = _tmp49_[1];
										_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
										_tmp52_ = _tmp51_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp48_, "CCode", "lower_case_csuffix", _tmp52_, NULL);
										_g_free0 (_tmp52_);
									}
								}
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		_tmp53_ = node;
		_tmp54_ = _tmp53_->prerequisites;
		{
			GList* prereq_name_collection = NULL;
			GList* prereq_name_it = NULL;
			prereq_name_collection = _tmp54_;
			for (prereq_name_it = prereq_name_collection; prereq_name_it != NULL; prereq_name_it = prereq_name_it->next) {
				gchar* _tmp55_ = NULL;
				gchar* prereq_name = NULL;
				_tmp55_ = g_strdup ((const gchar*) prereq_name_it->data);
				prereq_name = _tmp55_;
				{
					ValaDataType* prereq = NULL;
					const gchar* _tmp56_ = NULL;
					ValaDataType* _tmp57_ = NULL;
					ValaInterface* _tmp58_ = NULL;
					ValaDataType* _tmp59_ = NULL;
					_tmp56_ = prereq_name;
					_tmp57_ = vala_gidl_parser_parse_type_string (self, _tmp56_);
					prereq = _tmp57_;
					_tmp58_ = iface;
					_tmp59_ = prereq;
					vala_interface_add_prerequisite (_tmp58_, _tmp59_);
					_vala_code_node_unref0 (prereq);
					_g_free0 (prereq_name);
				}
			}
		}
		_tmp60_ = container;
		_tmp61_ = iface;
		vala_gidl_parser_add_symbol_to_container (self, _tmp60_, (ValaSymbol*) _tmp61_);
		_tmp62_ = self->priv->current_source_file;
		_tmp63_ = iface;
		vala_source_file_add_node (_tmp62_, (ValaCodeNode*) _tmp63_);
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp64_ = iface;
	_tmp65_ = _vala_code_node_ref0 ((ValaTypeSymbol*) _tmp64_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = _tmp65_;
	_tmp66_ = g_str_hash;
	_tmp67_ = g_str_equal;
	_tmp68_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp66_, _tmp67_);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	self->priv->current_type_symbol_set = (ValaSet*) _tmp68_;
	_tmp69_ = g_str_hash;
	_tmp70_ = g_str_equal;
	_tmp71_ = g_direct_equal;
	_tmp72_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_POINTER, NULL, NULL, _tmp69_, _tmp70_, _tmp71_);
	current_type_func_map = _tmp72_;
	_tmp73_ = g_str_hash;
	_tmp74_ = g_str_equal;
	_tmp75_ = g_direct_equal;
	_tmp76_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp73_, _tmp74_, _tmp75_);
	current_type_vfunc_map = _tmp76_;
	_tmp77_ = node;
	_tmp78_ = _tmp77_->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp78_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp79_ = NULL;
				GIdlNodeTypeId _tmp80_ = 0;
				GIdlNode* _tmp85_ = NULL;
				GIdlNodeTypeId _tmp86_ = 0;
				_tmp79_ = member;
				_tmp80_ = _tmp79_->type;
				if (_tmp80_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp81_ = NULL;
					GIdlNode* _tmp82_ = NULL;
					const gchar* _tmp83_ = NULL;
					GIdlNode* _tmp84_ = NULL;
					_tmp81_ = current_type_func_map;
					_tmp82_ = member;
					_tmp83_ = _tmp82_->name;
					_tmp84_ = member;
					vala_map_set ((ValaMap*) _tmp81_, _tmp83_, (GIdlNodeFunction*) _tmp84_);
				}
				_tmp85_ = member;
				_tmp86_ = _tmp85_->type;
				if (_tmp86_ == G_IDL_NODE_VFUNC) {
					ValaHashMap* _tmp87_ = NULL;
					GIdlNode* _tmp88_ = NULL;
					const gchar* _tmp89_ = NULL;
					_tmp87_ = current_type_vfunc_map;
					_tmp88_ = member;
					_tmp89_ = _tmp88_->name;
					vala_map_set ((ValaMap*) _tmp87_, _tmp89_, "1");
				}
			}
		}
	}
	_tmp90_ = node;
	_tmp91_ = _tmp90_->members;
	{
		GList* member_collection = NULL;
		GList* member_it = NULL;
		member_collection = _tmp91_;
		for (member_it = member_collection; member_it != NULL; member_it = member_it->next) {
			GIdlNode* member = NULL;
			member = (GIdlNode*) member_it->data;
			{
				GIdlNode* _tmp92_ = NULL;
				GIdlNodeTypeId _tmp93_ = 0;
				_tmp92_ = member;
				_tmp93_ = _tmp92_->type;
				if (_tmp93_ == G_IDL_NODE_FUNCTION) {
					ValaHashMap* _tmp94_ = NULL;
					GIdlNode* _tmp95_ = NULL;
					const gchar* _tmp96_ = NULL;
					gboolean _tmp97_ = FALSE;
					_tmp94_ = current_type_vfunc_map;
					_tmp95_ = member;
					_tmp96_ = _tmp95_->name;
					_tmp97_ = vala_map_contains ((ValaMap*) _tmp94_, _tmp96_);
					if (!_tmp97_) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp98_ = NULL;
						ValaMethod* _tmp99_ = NULL;
						ValaMethod* _tmp100_ = NULL;
						_tmp98_ = member;
						_tmp99_ = vala_gidl_parser_parse_function (self, (GIdlNodeFunction*) _tmp98_, TRUE);
						m = _tmp99_;
						_tmp100_ = m;
						if (_tmp100_ != NULL) {
							ValaInterface* _tmp101_ = NULL;
							ValaMethod* _tmp102_ = NULL;
							_tmp101_ = iface;
							_tmp102_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp101_, _tmp102_);
						}
						_vala_code_node_unref0 (m);
					}
				} else {
					GIdlNode* _tmp103_ = NULL;
					GIdlNodeTypeId _tmp104_ = 0;
					_tmp103_ = member;
					_tmp104_ = _tmp103_->type;
					if (_tmp104_ == G_IDL_NODE_VFUNC) {
						ValaMethod* m = NULL;
						GIdlNode* _tmp105_ = NULL;
						ValaHashMap* _tmp106_ = NULL;
						GIdlNode* _tmp107_ = NULL;
						const gchar* _tmp108_ = NULL;
						gpointer _tmp109_ = NULL;
						ValaMethod* _tmp110_ = NULL;
						ValaMethod* _tmp111_ = NULL;
						_tmp105_ = member;
						_tmp106_ = current_type_func_map;
						_tmp107_ = member;
						_tmp108_ = _tmp107_->name;
						_tmp109_ = vala_map_get ((ValaMap*) _tmp106_, _tmp108_);
						_tmp110_ = vala_gidl_parser_parse_virtual (self, (GIdlNodeVFunc*) _tmp105_, (GIdlNodeFunction*) _tmp109_, TRUE);
						m = _tmp110_;
						_tmp111_ = m;
						if (_tmp111_ != NULL) {
							ValaInterface* _tmp112_ = NULL;
							ValaMethod* _tmp113_ = NULL;
							_tmp112_ = iface;
							_tmp113_ = m;
							vala_symbol_add_method ((ValaSymbol*) _tmp112_, _tmp113_);
						}
						_vala_code_node_unref0 (m);
					} else {
						GIdlNode* _tmp114_ = NULL;
						GIdlNodeTypeId _tmp115_ = 0;
						_tmp114_ = member;
						_tmp115_ = _tmp114_->type;
						if (_tmp115_ == G_IDL_NODE_PROPERTY) {
							ValaProperty* prop = NULL;
							GIdlNode* _tmp116_ = NULL;
							ValaProperty* _tmp117_ = NULL;
							ValaProperty* _tmp118_ = NULL;
							_tmp116_ = member;
							_tmp117_ = vala_gidl_parser_parse_property (self, (GIdlNodeProperty*) _tmp116_);
							prop = _tmp117_;
							_tmp118_ = prop;
							if (_tmp118_ != NULL) {
								ValaInterface* _tmp119_ = NULL;
								ValaProperty* _tmp120_ = NULL;
								_tmp119_ = iface;
								_tmp120_ = prop;
								vala_symbol_add_property ((ValaSymbol*) _tmp119_, _tmp120_);
							}
							_vala_code_node_unref0 (prop);
						} else {
							GIdlNode* _tmp121_ = NULL;
							GIdlNodeTypeId _tmp122_ = 0;
							_tmp121_ = member;
							_tmp122_ = _tmp121_->type;
							if (_tmp122_ == G_IDL_NODE_SIGNAL) {
								ValaSignal* sig = NULL;
								GIdlNode* _tmp123_ = NULL;
								ValaSignal* _tmp124_ = NULL;
								ValaSignal* _tmp125_ = NULL;
								_tmp123_ = member;
								_tmp124_ = vala_gidl_parser_parse_signal (self, (GIdlNodeSignal*) _tmp123_);
								sig = _tmp124_;
								_tmp125_ = sig;
								if (_tmp125_ != NULL) {
									ValaInterface* _tmp126_ = NULL;
									ValaSignal* _tmp127_ = NULL;
									ValaSignal* _tmp128_ = NULL;
									_tmp126_ = iface;
									_tmp127_ = sig;
									vala_symbol_add_signal ((ValaSymbol*) _tmp126_, _tmp127_);
									_tmp128_ = sig;
									vala_signal_set_is_virtual (_tmp128_, FALSE);
								}
								_vala_code_node_unref0 (sig);
							}
						}
					}
				}
			}
		}
	}
	{
		ValaList* _prop_list = NULL;
		ValaInterface* _tmp129_ = NULL;
		ValaList* _tmp130_ = NULL;
		gint _prop_size = 0;
		ValaList* _tmp131_ = NULL;
		gint _tmp132_ = 0;
		gint _tmp133_ = 0;
		gint _prop_index = 0;
		_tmp129_ = iface;
		_tmp130_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp129_);
		_prop_list = _tmp130_;
		_tmp131_ = _prop_list;
		_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
		_tmp133_ = _tmp132_;
		_prop_size = _tmp133_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp134_ = 0;
			gint _tmp135_ = 0;
			gint _tmp136_ = 0;
			ValaProperty* prop = NULL;
			ValaList* _tmp137_ = NULL;
			gint _tmp138_ = 0;
			gpointer _tmp139_ = NULL;
			gchar* getter = NULL;
			ValaProperty* _tmp140_ = NULL;
			const gchar* _tmp141_ = NULL;
			const gchar* _tmp142_ = NULL;
			gchar* _tmp143_ = NULL;
			gboolean _tmp144_ = FALSE;
			ValaProperty* _tmp145_ = NULL;
			ValaPropertyAccessor* _tmp146_ = NULL;
			ValaPropertyAccessor* _tmp147_ = NULL;
			gchar* setter = NULL;
			ValaProperty* _tmp152_ = NULL;
			const gchar* _tmp153_ = NULL;
			const gchar* _tmp154_ = NULL;
			gchar* _tmp155_ = NULL;
			gboolean _tmp156_ = FALSE;
			gboolean _tmp157_ = FALSE;
			ValaProperty* _tmp158_ = NULL;
			ValaPropertyAccessor* _tmp159_ = NULL;
			ValaPropertyAccessor* _tmp160_ = NULL;
			gboolean _tmp170_ = FALSE;
			ValaProperty* _tmp171_ = NULL;
			ValaAttribute* _tmp172_ = NULL;
			ValaAttribute* _tmp173_ = NULL;
			gboolean _tmp174_ = FALSE;
			_tmp134_ = _prop_index;
			_prop_index = _tmp134_ + 1;
			_tmp135_ = _prop_index;
			_tmp136_ = _prop_size;
			if (!(_tmp135_ < _tmp136_)) {
				break;
			}
			_tmp137_ = _prop_list;
			_tmp138_ = _prop_index;
			_tmp139_ = vala_list_get (_tmp137_, _tmp138_);
			prop = (ValaProperty*) _tmp139_;
			_tmp140_ = prop;
			_tmp141_ = vala_symbol_get_name ((ValaSymbol*) _tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = g_strdup_printf ("get_%s", _tmp142_);
			getter = _tmp143_;
			_tmp145_ = prop;
			_tmp146_ = vala_property_get_get_accessor (_tmp145_);
			_tmp147_ = _tmp146_;
			if (_tmp147_ != NULL) {
				ValaSet* _tmp148_ = NULL;
				const gchar* _tmp149_ = NULL;
				gboolean _tmp150_ = FALSE;
				_tmp148_ = self->priv->current_type_symbol_set;
				_tmp149_ = getter;
				_tmp150_ = vala_collection_contains ((ValaCollection*) _tmp148_, _tmp149_);
				_tmp144_ = !_tmp150_;
			} else {
				_tmp144_ = FALSE;
			}
			if (_tmp144_) {
				ValaProperty* _tmp151_ = NULL;
				_tmp151_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp151_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp152_ = prop;
			_tmp153_ = vala_symbol_get_name ((ValaSymbol*) _tmp152_);
			_tmp154_ = _tmp153_;
			_tmp155_ = g_strdup_printf ("set_%s", _tmp154_);
			setter = _tmp155_;
			_tmp158_ = prop;
			_tmp159_ = vala_property_get_set_accessor (_tmp158_);
			_tmp160_ = _tmp159_;
			if (_tmp160_ != NULL) {
				ValaProperty* _tmp161_ = NULL;
				ValaPropertyAccessor* _tmp162_ = NULL;
				ValaPropertyAccessor* _tmp163_ = NULL;
				gboolean _tmp164_ = FALSE;
				gboolean _tmp165_ = FALSE;
				_tmp161_ = prop;
				_tmp162_ = vala_property_get_set_accessor (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_property_accessor_get_writable (_tmp163_);
				_tmp165_ = _tmp164_;
				_tmp157_ = _tmp165_;
			} else {
				_tmp157_ = FALSE;
			}
			if (_tmp157_) {
				ValaSet* _tmp166_ = NULL;
				const gchar* _tmp167_ = NULL;
				gboolean _tmp168_ = FALSE;
				_tmp166_ = self->priv->current_type_symbol_set;
				_tmp167_ = setter;
				_tmp168_ = vala_collection_contains ((ValaCollection*) _tmp166_, _tmp167_);
				_tmp156_ = !_tmp168_;
			} else {
				_tmp156_ = FALSE;
			}
			if (_tmp156_) {
				ValaProperty* _tmp169_ = NULL;
				_tmp169_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp169_, "NoAccessorMethod", TRUE, NULL);
			}
			_tmp171_ = prop;
			_tmp172_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp171_, "NoAccessorMethod");
			_tmp173_ = _tmp172_;
			_tmp174_ = _tmp173_ != NULL;
			_vala_code_node_unref0 (_tmp173_);
			if (_tmp174_) {
				ValaProperty* _tmp175_ = NULL;
				ValaPropertyAccessor* _tmp176_ = NULL;
				ValaPropertyAccessor* _tmp177_ = NULL;
				_tmp175_ = prop;
				_tmp176_ = vala_property_get_get_accessor (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp170_ = _tmp177_ != NULL;
			} else {
				_tmp170_ = FALSE;
			}
			if (_tmp170_) {
				ValaProperty* _tmp178_ = NULL;
				ValaPropertyAccessor* _tmp179_ = NULL;
				ValaPropertyAccessor* _tmp180_ = NULL;
				ValaDataType* _tmp181_ = NULL;
				ValaDataType* _tmp182_ = NULL;
				_tmp178_ = prop;
				_tmp179_ = vala_property_get_get_accessor (_tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_property_accessor_get_value_type (_tmp180_);
				_tmp182_ = _tmp181_;
				vala_data_type_set_value_owned (_tmp182_, TRUE);
			}
			_g_free0 (setter);
			_g_free0 (getter);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp183_ = iface;
	vala_gidl_parser_handle_async_methods (self, (ValaObjectTypeSymbol*) _tmp183_);
	_vala_code_node_unref0 (self->priv->current_data_type);
	self->priv->current_data_type = NULL;
	_vala_map_unref0 (current_type_vfunc_map);
	_vala_map_unref0 (current_type_func_map);
	_vala_code_node_unref0 (iface);
	_g_free0 (name);
}


static void vala_gidl_parser_handle_async_methods (ValaGIdlParser* self, ValaObjectTypeSymbol* type_symbol) {
	ValaSet* finish_methods = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	ValaHashSet* _tmp2_ = NULL;
	ValaList* methods = NULL;
	ValaObjectTypeSymbol* _tmp3_ = NULL;
	ValaList* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type_symbol != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_hash_set_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_, _tmp1_);
	finish_methods = (ValaSet*) _tmp2_;
	_tmp3_ = type_symbol;
	_tmp4_ = vala_object_type_symbol_get_methods (_tmp3_);
	methods = _tmp4_;
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp5_ = NULL;
		ValaList* _tmp6_ = NULL;
		gint _m_size = 0;
		ValaList* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _m_index = 0;
		_tmp5_ = methods;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_m_list = _tmp6_;
		_tmp7_ = _m_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_m_size = _tmp9_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			ValaMethod* m = NULL;
			ValaList* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			gpointer _tmp15_ = NULL;
			ValaMethod* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			gboolean _tmp18_ = FALSE;
			_tmp10_ = _m_index;
			_m_index = _tmp10_ + 1;
			_tmp11_ = _m_index;
			_tmp12_ = _m_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _m_list;
			_tmp14_ = _m_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			m = (ValaMethod*) _tmp15_;
			_tmp16_ = m;
			_tmp17_ = vala_method_get_coroutine (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_) {
				gchar* finish_method_base = NULL;
				ValaMethod* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				ValaMethod* finish_method = NULL;
				ValaObjectTypeSymbol* _tmp38_ = NULL;
				ValaScope* _tmp39_ = NULL;
				ValaScope* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				gchar* _tmp42_ = NULL;
				gchar* _tmp43_ = NULL;
				ValaSymbol* _tmp44_ = NULL;
				ValaMethod* _tmp45_ = NULL;
				ValaMethod* _tmp46_ = NULL;
				ValaMethod* _tmp47_ = NULL;
				ValaMethod* _tmp68_ = NULL;
				_tmp19_ = m;
				_tmp20_ = vala_symbol_get_name ((ValaSymbol*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_str_has_suffix (_tmp21_, "_async");
				if (_tmp22_) {
					ValaMethod* _tmp23_ = NULL;
					const gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					ValaMethod* _tmp26_ = NULL;
					const gchar* _tmp27_ = NULL;
					const gchar* _tmp28_ = NULL;
					gint _tmp29_ = 0;
					gint _tmp30_ = 0;
					gint _tmp31_ = 0;
					gint _tmp32_ = 0;
					gchar* _tmp33_ = NULL;
					_tmp23_ = m;
					_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = m;
					_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = strlen (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = strlen ("_async");
					_tmp32_ = _tmp31_;
					_tmp33_ = string_substring (_tmp25_, (glong) 0, (glong) (_tmp30_ - _tmp32_));
					_g_free0 (finish_method_base);
					finish_method_base = _tmp33_;
				} else {
					ValaMethod* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					gchar* _tmp37_ = NULL;
					_tmp34_ = m;
					_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strdup (_tmp36_);
					_g_free0 (finish_method_base);
					finish_method_base = _tmp37_;
				}
				_tmp38_ = type_symbol;
				_tmp39_ = vala_symbol_get_scope ((ValaSymbol*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = finish_method_base;
				_tmp42_ = g_strconcat (_tmp41_, "_finish", NULL);
				_tmp43_ = _tmp42_;
				_tmp44_ = vala_scope_lookup (_tmp40_, _tmp43_);
				_tmp45_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp44_) : NULL;
				if (_tmp45_ == NULL) {
					_vala_code_node_unref0 (_tmp44_);
				}
				_tmp46_ = _tmp45_;
				_g_free0 (_tmp43_);
				finish_method = _tmp46_;
				_tmp47_ = finish_method;
				if (_tmp47_ == NULL) {
					gchar* method_cname = NULL;
					ValaMethod* _tmp48_ = NULL;
					gchar* _tmp49_ = NULL;
					_tmp48_ = m;
					_tmp49_ = vala_gidl_parser_get_finish_cname (self, _tmp48_);
					method_cname = _tmp49_;
					{
						ValaList* _method_list = NULL;
						ValaObjectTypeSymbol* _tmp50_ = NULL;
						ValaList* _tmp51_ = NULL;
						gint _method_size = 0;
						ValaList* _tmp52_ = NULL;
						gint _tmp53_ = 0;
						gint _tmp54_ = 0;
						gint _method_index = 0;
						_tmp50_ = type_symbol;
						_tmp51_ = vala_object_type_symbol_get_methods (_tmp50_);
						_method_list = _tmp51_;
						_tmp52_ = _method_list;
						_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
						_tmp54_ = _tmp53_;
						_method_size = _tmp54_;
						_method_index = -1;
						while (TRUE) {
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							gint _tmp57_ = 0;
							ValaMethod* method = NULL;
							ValaList* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							gpointer _tmp60_ = NULL;
							ValaMethod* _tmp61_ = NULL;
							gchar* _tmp62_ = NULL;
							gchar* _tmp63_ = NULL;
							const gchar* _tmp64_ = NULL;
							gboolean _tmp65_ = FALSE;
							_tmp55_ = _method_index;
							_method_index = _tmp55_ + 1;
							_tmp56_ = _method_index;
							_tmp57_ = _method_size;
							if (!(_tmp56_ < _tmp57_)) {
								break;
							}
							_tmp58_ = _method_list;
							_tmp59_ = _method_index;
							_tmp60_ = vala_list_get (_tmp58_, _tmp59_);
							method = (ValaMethod*) _tmp60_;
							_tmp61_ = method;
							_tmp62_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp61_, NULL);
							_tmp63_ = _tmp62_;
							_tmp64_ = method_cname;
							_tmp65_ = g_strcmp0 (_tmp63_, _tmp64_) == 0;
							_g_free0 (_tmp63_);
							if (_tmp65_) {
								ValaMethod* _tmp66_ = NULL;
								ValaMethod* _tmp67_ = NULL;
								_tmp66_ = method;
								_tmp67_ = _vala_code_node_ref0 (_tmp66_);
								_vala_code_node_unref0 (finish_method);
								finish_method = _tmp67_;
								_vala_code_node_unref0 (method);
								break;
							}
							_vala_code_node_unref0 (method);
						}
						_vala_iterable_unref0 (_method_list);
					}
					_g_free0 (method_cname);
				}
				_tmp68_ = finish_method;
				if (_tmp68_ != NULL) {
					ValaMethod* _tmp69_ = NULL;
					ValaMethod* _tmp70_ = NULL;
					ValaDataType* _tmp71_ = NULL;
					ValaDataType* _tmp72_ = NULL;
					ValaDataType* _tmp73_ = NULL;
					ValaDataType* _tmp74_ = NULL;
					ValaAttribute* a = NULL;
					ValaMethod* _tmp75_ = NULL;
					ValaAttribute* _tmp76_ = NULL;
					gboolean _tmp77_ = FALSE;
					ValaAttribute* _tmp78_ = NULL;
					gboolean _tmp84_ = FALSE;
					ValaAttribute* _tmp85_ = NULL;
					ValaSet* _tmp139_ = NULL;
					ValaMethod* _tmp140_ = NULL;
					_tmp69_ = m;
					_tmp70_ = finish_method;
					_tmp71_ = vala_method_get_return_type (_tmp70_);
					_tmp72_ = _tmp71_;
					_tmp73_ = vala_data_type_copy (_tmp72_);
					_tmp74_ = _tmp73_;
					vala_method_set_return_type (_tmp69_, _tmp74_);
					_vala_code_node_unref0 (_tmp74_);
					_tmp75_ = finish_method;
					_tmp76_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp75_, "CCode");
					a = _tmp76_;
					_tmp78_ = a;
					if (_tmp78_ != NULL) {
						ValaAttribute* _tmp79_ = NULL;
						gboolean _tmp80_ = FALSE;
						_tmp79_ = a;
						_tmp80_ = vala_attribute_has_argument (_tmp79_, "array_length");
						_tmp77_ = _tmp80_;
					} else {
						_tmp77_ = FALSE;
					}
					if (_tmp77_) {
						ValaMethod* _tmp81_ = NULL;
						ValaAttribute* _tmp82_ = NULL;
						gboolean _tmp83_ = FALSE;
						_tmp81_ = m;
						_tmp82_ = a;
						_tmp83_ = vala_attribute_get_bool (_tmp82_, "array_length", FALSE);
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp81_, "CCode", "array_length", _tmp83_, NULL);
					}
					_tmp85_ = a;
					if (_tmp85_ != NULL) {
						ValaAttribute* _tmp86_ = NULL;
						gboolean _tmp87_ = FALSE;
						_tmp86_ = a;
						_tmp87_ = vala_attribute_has_argument (_tmp86_, "array_null_terminated");
						_tmp84_ = _tmp87_;
					} else {
						_tmp84_ = FALSE;
					}
					if (_tmp84_) {
						ValaMethod* _tmp88_ = NULL;
						ValaAttribute* _tmp89_ = NULL;
						gboolean _tmp90_ = FALSE;
						_tmp88_ = m;
						_tmp89_ = a;
						_tmp90_ = vala_attribute_get_bool (_tmp89_, "array_null_terminated", FALSE);
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp88_, "CCode", "array_null_terminated", _tmp90_, NULL);
					}
					{
						ValaList* _param_list = NULL;
						ValaMethod* _tmp91_ = NULL;
						ValaList* _tmp92_ = NULL;
						gint _param_size = 0;
						ValaList* _tmp93_ = NULL;
						gint _tmp94_ = 0;
						gint _tmp95_ = 0;
						gint _param_index = 0;
						_tmp91_ = finish_method;
						_tmp92_ = vala_method_get_parameters (_tmp91_);
						_param_list = _tmp92_;
						_tmp93_ = _param_list;
						_tmp94_ = vala_collection_get_size ((ValaCollection*) _tmp93_);
						_tmp95_ = _tmp94_;
						_param_size = _tmp95_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp96_ = 0;
							gint _tmp97_ = 0;
							gint _tmp98_ = 0;
							ValaParameter* param = NULL;
							ValaList* _tmp99_ = NULL;
							gint _tmp100_ = 0;
							gpointer _tmp101_ = NULL;
							ValaParameter* _tmp102_ = NULL;
							ValaParameterDirection _tmp103_ = 0;
							ValaParameterDirection _tmp104_ = 0;
							_tmp96_ = _param_index;
							_param_index = _tmp96_ + 1;
							_tmp97_ = _param_index;
							_tmp98_ = _param_size;
							if (!(_tmp97_ < _tmp98_)) {
								break;
							}
							_tmp99_ = _param_list;
							_tmp100_ = _param_index;
							_tmp101_ = vala_list_get (_tmp99_, _tmp100_);
							param = (ValaParameter*) _tmp101_;
							_tmp102_ = param;
							_tmp103_ = vala_parameter_get_direction (_tmp102_);
							_tmp104_ = _tmp103_;
							if (_tmp104_ == VALA_PARAMETER_DIRECTION_OUT) {
								ValaParameter* async_param = NULL;
								ValaParameter* _tmp105_ = NULL;
								ValaParameter* _tmp106_ = NULL;
								ValaMethod* _tmp107_ = NULL;
								ValaScope* _tmp108_ = NULL;
								ValaScope* _tmp109_ = NULL;
								ValaParameter* _tmp110_ = NULL;
								const gchar* _tmp111_ = NULL;
								const gchar* _tmp112_ = NULL;
								ValaSymbol* _tmp113_ = NULL;
								ValaSymbol* _tmp114_ = NULL;
								gboolean _tmp115_ = FALSE;
								ValaMethod* _tmp122_ = NULL;
								ValaParameter* _tmp123_ = NULL;
								_tmp105_ = param;
								_tmp106_ = vala_parameter_copy (_tmp105_);
								async_param = _tmp106_;
								_tmp107_ = m;
								_tmp108_ = vala_symbol_get_scope ((ValaSymbol*) _tmp107_);
								_tmp109_ = _tmp108_;
								_tmp110_ = param;
								_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
								_tmp112_ = _tmp111_;
								_tmp113_ = vala_scope_lookup (_tmp109_, _tmp112_);
								_tmp114_ = _tmp113_;
								_tmp115_ = _tmp114_ != NULL;
								_vala_code_node_unref0 (_tmp114_);
								if (_tmp115_) {
									ValaParameter* _tmp116_ = NULL;
									ValaParameter* _tmp117_ = NULL;
									const gchar* _tmp118_ = NULL;
									const gchar* _tmp119_ = NULL;
									gchar* _tmp120_ = NULL;
									gchar* _tmp121_ = NULL;
									_tmp116_ = async_param;
									_tmp117_ = async_param;
									_tmp118_ = vala_symbol_get_name ((ValaSymbol*) _tmp117_);
									_tmp119_ = _tmp118_;
									_tmp120_ = g_strconcat (_tmp119_, "_out", NULL);
									_tmp121_ = _tmp120_;
									vala_symbol_set_name ((ValaSymbol*) _tmp117_, _tmp121_);
									_g_free0 (_tmp121_);
								}
								_tmp122_ = m;
								_tmp123_ = async_param;
								vala_method_add_parameter (_tmp122_, _tmp123_);
								_vala_code_node_unref0 (async_param);
							}
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
					{
						ValaList* _error_type_list = NULL;
						ValaMethod* _tmp124_ = NULL;
						ValaList* _tmp125_ = NULL;
						gint _error_type_size = 0;
						ValaList* _tmp126_ = NULL;
						gint _tmp127_ = 0;
						gint _tmp128_ = 0;
						gint _error_type_index = 0;
						_tmp124_ = finish_method;
						_tmp125_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp124_);
						_error_type_list = _tmp125_;
						_tmp126_ = _error_type_list;
						_tmp127_ = vala_collection_get_size ((ValaCollection*) _tmp126_);
						_tmp128_ = _tmp127_;
						_error_type_size = _tmp128_;
						_error_type_index = -1;
						while (TRUE) {
							gint _tmp129_ = 0;
							gint _tmp130_ = 0;
							gint _tmp131_ = 0;
							ValaDataType* error_type = NULL;
							ValaList* _tmp132_ = NULL;
							gint _tmp133_ = 0;
							gpointer _tmp134_ = NULL;
							ValaMethod* _tmp135_ = NULL;
							ValaDataType* _tmp136_ = NULL;
							ValaDataType* _tmp137_ = NULL;
							ValaDataType* _tmp138_ = NULL;
							_tmp129_ = _error_type_index;
							_error_type_index = _tmp129_ + 1;
							_tmp130_ = _error_type_index;
							_tmp131_ = _error_type_size;
							if (!(_tmp130_ < _tmp131_)) {
								break;
							}
							_tmp132_ = _error_type_list;
							_tmp133_ = _error_type_index;
							_tmp134_ = vala_list_get (_tmp132_, _tmp133_);
							error_type = (ValaDataType*) _tmp134_;
							_tmp135_ = m;
							_tmp136_ = error_type;
							_tmp137_ = vala_data_type_copy (_tmp136_);
							_tmp138_ = _tmp137_;
							vala_code_node_add_error_type ((ValaCodeNode*) _tmp135_, _tmp138_);
							_vala_code_node_unref0 (_tmp138_);
							_vala_code_node_unref0 (error_type);
						}
						_vala_iterable_unref0 (_error_type_list);
					}
					_tmp139_ = finish_methods;
					_tmp140_ = finish_method;
					vala_collection_add ((ValaCollection*) _tmp139_, _tmp140_);
					_vala_code_node_unref0 (a);
				}
				_vala_code_node_unref0 (finish_method);
				_g_free0 (finish_method_base);
			}
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaIterator* _m_it = NULL;
		ValaSet* _tmp141_ = NULL;
		ValaIterator* _tmp142_ = NULL;
		_tmp141_ = finish_methods;
		_tmp142_ = vala_iterable_iterator ((ValaIterable*) _tmp141_);
		_m_it = _tmp142_;
		while (TRUE) {
			ValaIterator* _tmp143_ = NULL;
			gboolean _tmp144_ = FALSE;
			ValaMethod* m = NULL;
			ValaIterator* _tmp145_ = NULL;
			gpointer _tmp146_ = NULL;
			ValaObjectTypeSymbol* _tmp147_ = NULL;
			ValaScope* _tmp148_ = NULL;
			ValaScope* _tmp149_ = NULL;
			ValaMethod* _tmp150_ = NULL;
			const gchar* _tmp151_ = NULL;
			const gchar* _tmp152_ = NULL;
			ValaList* _tmp153_ = NULL;
			ValaMethod* _tmp154_ = NULL;
			_tmp143_ = _m_it;
			_tmp144_ = vala_iterator_next (_tmp143_);
			if (!_tmp144_) {
				break;
			}
			_tmp145_ = _m_it;
			_tmp146_ = vala_iterator_get (_tmp145_);
			m = (ValaMethod*) _tmp146_;
			_tmp147_ = type_symbol;
			_tmp148_ = vala_symbol_get_scope ((ValaSymbol*) _tmp147_);
			_tmp149_ = _tmp148_;
			_tmp150_ = m;
			_tmp151_ = vala_symbol_get_name ((ValaSymbol*) _tmp150_);
			_tmp152_ = _tmp151_;
			vala_scope_remove (_tmp149_, _tmp152_);
			_tmp153_ = methods;
			_tmp154_ = m;
			vala_collection_remove ((ValaCollection*) _tmp153_, _tmp154_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterator_unref0 (_m_it);
	}
	_vala_iterable_unref0 (methods);
	_vala_iterable_unref0 (finish_methods);
}


static ValaDataType* vala_gidl_parser_parse_type (ValaGIdlParser* self, GIdlNodeType* type_node, ValaParameterDirection* direction) {
	ValaParameterDirection _vala_direction = 0;
	ValaDataType* result = NULL;
	ValaUnresolvedType* type = NULL;
	ValaUnresolvedType* _tmp0_ = NULL;
	GIdlNodeType* _tmp1_ = NULL;
	TypeTag _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_node != NULL, NULL);
	_vala_direction = VALA_PARAMETER_DIRECTION_IN;
	_tmp0_ = vala_unresolved_type_new ();
	type = _tmp0_;
	_tmp1_ = type_node;
	_tmp2_ = _tmp1_->tag;
	if (_tmp2_ == TYPE_TAG_VOID) {
		GIdlNodeType* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = type_node;
		_tmp4_ = _tmp3_->is_pointer;
		if (_tmp4_) {
			ValaVoidType* _tmp5_ = NULL;
			ValaVoidType* _tmp6_ = NULL;
			ValaPointerType* _tmp7_ = NULL;
			ValaDataType* _tmp8_ = NULL;
			_tmp5_ = vala_void_type_new (NULL);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_pointer_type_new ((ValaDataType*) _tmp6_, NULL);
			_tmp8_ = (ValaDataType*) _tmp7_;
			_vala_code_node_unref0 (_tmp6_);
			result = _tmp8_;
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _vala_direction;
			}
			return result;
		} else {
			ValaVoidType* _tmp9_ = NULL;
			_tmp9_ = vala_void_type_new (NULL);
			result = (ValaDataType*) _tmp9_;
			_vala_code_node_unref0 (type);
			if (direction) {
				*direction = _vala_direction;
			}
			return result;
		}
	} else {
		GIdlNodeType* _tmp10_ = NULL;
		TypeTag _tmp11_ = 0;
		_tmp10_ = type_node;
		_tmp11_ = _tmp10_->tag;
		if (_tmp11_ == TYPE_TAG_BOOLEAN) {
			ValaUnresolvedType* _tmp12_ = NULL;
			ValaUnresolvedSymbol* _tmp13_ = NULL;
			ValaUnresolvedSymbol* _tmp14_ = NULL;
			_tmp12_ = type;
			_tmp13_ = vala_unresolved_symbol_new (NULL, "bool", NULL);
			_tmp14_ = _tmp13_;
			vala_unresolved_type_set_unresolved_symbol (_tmp12_, _tmp14_);
			_vala_code_node_unref0 (_tmp14_);
		} else {
			GIdlNodeType* _tmp15_ = NULL;
			TypeTag _tmp16_ = 0;
			_tmp15_ = type_node;
			_tmp16_ = _tmp15_->tag;
			if (_tmp16_ == TYPE_TAG_INT8) {
				ValaUnresolvedType* _tmp17_ = NULL;
				ValaUnresolvedSymbol* _tmp18_ = NULL;
				ValaUnresolvedSymbol* _tmp19_ = NULL;
				_tmp17_ = type;
				_tmp18_ = vala_unresolved_symbol_new (NULL, "char", NULL);
				_tmp19_ = _tmp18_;
				vala_unresolved_type_set_unresolved_symbol (_tmp17_, _tmp19_);
				_vala_code_node_unref0 (_tmp19_);
			} else {
				GIdlNodeType* _tmp20_ = NULL;
				TypeTag _tmp21_ = 0;
				_tmp20_ = type_node;
				_tmp21_ = _tmp20_->tag;
				if (_tmp21_ == TYPE_TAG_UINT8) {
					ValaUnresolvedType* _tmp22_ = NULL;
					ValaUnresolvedSymbol* _tmp23_ = NULL;
					ValaUnresolvedSymbol* _tmp24_ = NULL;
					_tmp22_ = type;
					_tmp23_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
					_tmp24_ = _tmp23_;
					vala_unresolved_type_set_unresolved_symbol (_tmp22_, _tmp24_);
					_vala_code_node_unref0 (_tmp24_);
				} else {
					GIdlNodeType* _tmp25_ = NULL;
					TypeTag _tmp26_ = 0;
					_tmp25_ = type_node;
					_tmp26_ = _tmp25_->tag;
					if (_tmp26_ == TYPE_TAG_INT16) {
						ValaUnresolvedType* _tmp27_ = NULL;
						ValaUnresolvedSymbol* _tmp28_ = NULL;
						ValaUnresolvedSymbol* _tmp29_ = NULL;
						_tmp27_ = type;
						_tmp28_ = vala_unresolved_symbol_new (NULL, "int16", NULL);
						_tmp29_ = _tmp28_;
						vala_unresolved_type_set_unresolved_symbol (_tmp27_, _tmp29_);
						_vala_code_node_unref0 (_tmp29_);
					} else {
						GIdlNodeType* _tmp30_ = NULL;
						TypeTag _tmp31_ = 0;
						_tmp30_ = type_node;
						_tmp31_ = _tmp30_->tag;
						if (_tmp31_ == TYPE_TAG_UINT16) {
							ValaUnresolvedType* _tmp32_ = NULL;
							ValaUnresolvedSymbol* _tmp33_ = NULL;
							ValaUnresolvedSymbol* _tmp34_ = NULL;
							_tmp32_ = type;
							_tmp33_ = vala_unresolved_symbol_new (NULL, "uint16", NULL);
							_tmp34_ = _tmp33_;
							vala_unresolved_type_set_unresolved_symbol (_tmp32_, _tmp34_);
							_vala_code_node_unref0 (_tmp34_);
						} else {
							GIdlNodeType* _tmp35_ = NULL;
							TypeTag _tmp36_ = 0;
							_tmp35_ = type_node;
							_tmp36_ = _tmp35_->tag;
							if (_tmp36_ == TYPE_TAG_INT32) {
								ValaUnresolvedType* _tmp37_ = NULL;
								ValaUnresolvedSymbol* _tmp38_ = NULL;
								ValaUnresolvedSymbol* _tmp39_ = NULL;
								_tmp37_ = type;
								_tmp38_ = vala_unresolved_symbol_new (NULL, "int32", NULL);
								_tmp39_ = _tmp38_;
								vala_unresolved_type_set_unresolved_symbol (_tmp37_, _tmp39_);
								_vala_code_node_unref0 (_tmp39_);
							} else {
								GIdlNodeType* _tmp40_ = NULL;
								TypeTag _tmp41_ = 0;
								_tmp40_ = type_node;
								_tmp41_ = _tmp40_->tag;
								if (_tmp41_ == TYPE_TAG_UINT32) {
									ValaUnresolvedType* _tmp42_ = NULL;
									ValaUnresolvedSymbol* _tmp43_ = NULL;
									ValaUnresolvedSymbol* _tmp44_ = NULL;
									_tmp42_ = type;
									_tmp43_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
									_tmp44_ = _tmp43_;
									vala_unresolved_type_set_unresolved_symbol (_tmp42_, _tmp44_);
									_vala_code_node_unref0 (_tmp44_);
								} else {
									GIdlNodeType* _tmp45_ = NULL;
									TypeTag _tmp46_ = 0;
									_tmp45_ = type_node;
									_tmp46_ = _tmp45_->tag;
									if (_tmp46_ == TYPE_TAG_INT64) {
										ValaUnresolvedType* _tmp47_ = NULL;
										ValaUnresolvedSymbol* _tmp48_ = NULL;
										ValaUnresolvedSymbol* _tmp49_ = NULL;
										_tmp47_ = type;
										_tmp48_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
										_tmp49_ = _tmp48_;
										vala_unresolved_type_set_unresolved_symbol (_tmp47_, _tmp49_);
										_vala_code_node_unref0 (_tmp49_);
									} else {
										GIdlNodeType* _tmp50_ = NULL;
										TypeTag _tmp51_ = 0;
										_tmp50_ = type_node;
										_tmp51_ = _tmp50_->tag;
										if (_tmp51_ == TYPE_TAG_UINT64) {
											ValaUnresolvedType* _tmp52_ = NULL;
											ValaUnresolvedSymbol* _tmp53_ = NULL;
											ValaUnresolvedSymbol* _tmp54_ = NULL;
											_tmp52_ = type;
											_tmp53_ = vala_unresolved_symbol_new (NULL, "uint64", NULL);
											_tmp54_ = _tmp53_;
											vala_unresolved_type_set_unresolved_symbol (_tmp52_, _tmp54_);
											_vala_code_node_unref0 (_tmp54_);
										} else {
											GIdlNodeType* _tmp55_ = NULL;
											TypeTag _tmp56_ = 0;
											_tmp55_ = type_node;
											_tmp56_ = _tmp55_->tag;
											if (_tmp56_ == TYPE_TAG_INT) {
												ValaUnresolvedType* _tmp57_ = NULL;
												ValaUnresolvedSymbol* _tmp58_ = NULL;
												ValaUnresolvedSymbol* _tmp59_ = NULL;
												_tmp57_ = type;
												_tmp58_ = vala_unresolved_symbol_new (NULL, "int", NULL);
												_tmp59_ = _tmp58_;
												vala_unresolved_type_set_unresolved_symbol (_tmp57_, _tmp59_);
												_vala_code_node_unref0 (_tmp59_);
											} else {
												GIdlNodeType* _tmp60_ = NULL;
												TypeTag _tmp61_ = 0;
												_tmp60_ = type_node;
												_tmp61_ = _tmp60_->tag;
												if (_tmp61_ == TYPE_TAG_UINT) {
													ValaUnresolvedType* _tmp62_ = NULL;
													ValaUnresolvedSymbol* _tmp63_ = NULL;
													ValaUnresolvedSymbol* _tmp64_ = NULL;
													_tmp62_ = type;
													_tmp63_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
													_tmp64_ = _tmp63_;
													vala_unresolved_type_set_unresolved_symbol (_tmp62_, _tmp64_);
													_vala_code_node_unref0 (_tmp64_);
												} else {
													GIdlNodeType* _tmp65_ = NULL;
													TypeTag _tmp66_ = 0;
													_tmp65_ = type_node;
													_tmp66_ = _tmp65_->tag;
													if (_tmp66_ == TYPE_TAG_LONG) {
														ValaUnresolvedType* _tmp67_ = NULL;
														ValaUnresolvedSymbol* _tmp68_ = NULL;
														ValaUnresolvedSymbol* _tmp69_ = NULL;
														_tmp67_ = type;
														_tmp68_ = vala_unresolved_symbol_new (NULL, "long", NULL);
														_tmp69_ = _tmp68_;
														vala_unresolved_type_set_unresolved_symbol (_tmp67_, _tmp69_);
														_vala_code_node_unref0 (_tmp69_);
													} else {
														GIdlNodeType* _tmp70_ = NULL;
														TypeTag _tmp71_ = 0;
														_tmp70_ = type_node;
														_tmp71_ = _tmp70_->tag;
														if (_tmp71_ == TYPE_TAG_ULONG) {
															ValaUnresolvedType* _tmp72_ = NULL;
															ValaUnresolvedSymbol* _tmp73_ = NULL;
															ValaUnresolvedSymbol* _tmp74_ = NULL;
															_tmp72_ = type;
															_tmp73_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
															_tmp74_ = _tmp73_;
															vala_unresolved_type_set_unresolved_symbol (_tmp72_, _tmp74_);
															_vala_code_node_unref0 (_tmp74_);
														} else {
															GIdlNodeType* _tmp75_ = NULL;
															TypeTag _tmp76_ = 0;
															_tmp75_ = type_node;
															_tmp76_ = _tmp75_->tag;
															if (_tmp76_ == TYPE_TAG_SSIZE) {
																ValaUnresolvedType* _tmp77_ = NULL;
																ValaUnresolvedSymbol* _tmp78_ = NULL;
																ValaUnresolvedSymbol* _tmp79_ = NULL;
																_tmp77_ = type;
																_tmp78_ = vala_unresolved_symbol_new (NULL, "ssize_t", NULL);
																_tmp79_ = _tmp78_;
																vala_unresolved_type_set_unresolved_symbol (_tmp77_, _tmp79_);
																_vala_code_node_unref0 (_tmp79_);
															} else {
																GIdlNodeType* _tmp80_ = NULL;
																TypeTag _tmp81_ = 0;
																_tmp80_ = type_node;
																_tmp81_ = _tmp80_->tag;
																if (_tmp81_ == TYPE_TAG_SIZE) {
																	ValaUnresolvedType* _tmp82_ = NULL;
																	ValaUnresolvedSymbol* _tmp83_ = NULL;
																	ValaUnresolvedSymbol* _tmp84_ = NULL;
																	_tmp82_ = type;
																	_tmp83_ = vala_unresolved_symbol_new (NULL, "size_t", NULL);
																	_tmp84_ = _tmp83_;
																	vala_unresolved_type_set_unresolved_symbol (_tmp82_, _tmp84_);
																	_vala_code_node_unref0 (_tmp84_);
																} else {
																	GIdlNodeType* _tmp85_ = NULL;
																	TypeTag _tmp86_ = 0;
																	_tmp85_ = type_node;
																	_tmp86_ = _tmp85_->tag;
																	if (_tmp86_ == TYPE_TAG_FLOAT) {
																		ValaUnresolvedType* _tmp87_ = NULL;
																		ValaUnresolvedSymbol* _tmp88_ = NULL;
																		ValaUnresolvedSymbol* _tmp89_ = NULL;
																		_tmp87_ = type;
																		_tmp88_ = vala_unresolved_symbol_new (NULL, "float", NULL);
																		_tmp89_ = _tmp88_;
																		vala_unresolved_type_set_unresolved_symbol (_tmp87_, _tmp89_);
																		_vala_code_node_unref0 (_tmp89_);
																	} else {
																		GIdlNodeType* _tmp90_ = NULL;
																		TypeTag _tmp91_ = 0;
																		_tmp90_ = type_node;
																		_tmp91_ = _tmp90_->tag;
																		if (_tmp91_ == TYPE_TAG_DOUBLE) {
																			ValaUnresolvedType* _tmp92_ = NULL;
																			ValaUnresolvedSymbol* _tmp93_ = NULL;
																			ValaUnresolvedSymbol* _tmp94_ = NULL;
																			_tmp92_ = type;
																			_tmp93_ = vala_unresolved_symbol_new (NULL, "double", NULL);
																			_tmp94_ = _tmp93_;
																			vala_unresolved_type_set_unresolved_symbol (_tmp92_, _tmp94_);
																			_vala_code_node_unref0 (_tmp94_);
																		} else {
																			GIdlNodeType* _tmp95_ = NULL;
																			TypeTag _tmp96_ = 0;
																			_tmp95_ = type_node;
																			_tmp96_ = _tmp95_->tag;
																			if (_tmp96_ == TYPE_TAG_UTF8) {
																				ValaUnresolvedType* _tmp97_ = NULL;
																				ValaUnresolvedSymbol* _tmp98_ = NULL;
																				ValaUnresolvedSymbol* _tmp99_ = NULL;
																				_tmp97_ = type;
																				_tmp98_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																				_tmp99_ = _tmp98_;
																				vala_unresolved_type_set_unresolved_symbol (_tmp97_, _tmp99_);
																				_vala_code_node_unref0 (_tmp99_);
																			} else {
																				GIdlNodeType* _tmp100_ = NULL;
																				TypeTag _tmp101_ = 0;
																				_tmp100_ = type_node;
																				_tmp101_ = _tmp100_->tag;
																				if (_tmp101_ == TYPE_TAG_FILENAME) {
																					ValaUnresolvedType* _tmp102_ = NULL;
																					ValaUnresolvedSymbol* _tmp103_ = NULL;
																					ValaUnresolvedSymbol* _tmp104_ = NULL;
																					_tmp102_ = type;
																					_tmp103_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																					_tmp104_ = _tmp103_;
																					vala_unresolved_type_set_unresolved_symbol (_tmp102_, _tmp104_);
																					_vala_code_node_unref0 (_tmp104_);
																				} else {
																					GIdlNodeType* _tmp105_ = NULL;
																					TypeTag _tmp106_ = 0;
																					_tmp105_ = type_node;
																					_tmp106_ = _tmp105_->tag;
																					if (_tmp106_ == TYPE_TAG_ARRAY) {
																						ValaDataType* element_type = NULL;
																						GIdlNodeType* _tmp107_ = NULL;
																						GIdlNodeType* _tmp108_ = NULL;
																						ValaDataType* _tmp109_ = NULL;
																						ValaDataType* _tmp110_ = NULL;
																						ValaUnresolvedType* _tmp111_ = NULL;
																						ValaUnresolvedType* _tmp112_ = NULL;
																						ValaDataType* _tmp113_ = NULL;
																						ValaDataType* _tmp114_ = NULL;
																						ValaDataType* _tmp115_ = NULL;
																						ValaSourceReference* _tmp116_ = NULL;
																						ValaSourceReference* _tmp117_ = NULL;
																						ValaArrayType* _tmp118_ = NULL;
																						_tmp107_ = type_node;
																						_tmp108_ = _tmp107_->parameter_type1;
																						_tmp109_ = vala_gidl_parser_parse_type (self, _tmp108_, NULL);
																						element_type = _tmp109_;
																						_tmp110_ = element_type;
																						_tmp111_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp110_, VALA_TYPE_UNRESOLVED_TYPE) ? ((ValaUnresolvedType*) _tmp110_) : NULL);
																						_vala_code_node_unref0 (type);
																						type = _tmp111_;
																						_tmp112_ = type;
																						if (_tmp112_ == NULL) {
																							result = element_type;
																							_vala_code_node_unref0 (type);
																							if (direction) {
																								*direction = _vala_direction;
																							}
																							return result;
																						}
																						_tmp113_ = element_type;
																						vala_data_type_set_value_owned (_tmp113_, TRUE);
																						_tmp114_ = element_type;
																						_tmp115_ = element_type;
																						_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp115_);
																						_tmp117_ = _tmp116_;
																						_tmp118_ = vala_array_type_new (_tmp114_, 1, _tmp117_);
																						result = (ValaDataType*) _tmp118_;
																						_vala_code_node_unref0 (element_type);
																						_vala_code_node_unref0 (type);
																						if (direction) {
																							*direction = _vala_direction;
																						}
																						return result;
																					} else {
																						GIdlNodeType* _tmp119_ = NULL;
																						TypeTag _tmp120_ = 0;
																						_tmp119_ = type_node;
																						_tmp120_ = _tmp119_->tag;
																						if (_tmp120_ == TYPE_TAG_LIST) {
																							ValaUnresolvedType* _tmp121_ = NULL;
																							ValaUnresolvedSymbol* _tmp122_ = NULL;
																							ValaUnresolvedSymbol* _tmp123_ = NULL;
																							ValaUnresolvedSymbol* _tmp124_ = NULL;
																							ValaUnresolvedSymbol* _tmp125_ = NULL;
																							_tmp121_ = type;
																							_tmp122_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																							_tmp123_ = _tmp122_;
																							_tmp124_ = vala_unresolved_symbol_new (_tmp123_, "List", NULL);
																							_tmp125_ = _tmp124_;
																							vala_unresolved_type_set_unresolved_symbol (_tmp121_, _tmp125_);
																							_vala_code_node_unref0 (_tmp125_);
																							_vala_code_node_unref0 (_tmp123_);
																						} else {
																							GIdlNodeType* _tmp126_ = NULL;
																							TypeTag _tmp127_ = 0;
																							_tmp126_ = type_node;
																							_tmp127_ = _tmp126_->tag;
																							if (_tmp127_ == TYPE_TAG_SLIST) {
																								ValaUnresolvedType* _tmp128_ = NULL;
																								ValaUnresolvedSymbol* _tmp129_ = NULL;
																								ValaUnresolvedSymbol* _tmp130_ = NULL;
																								ValaUnresolvedSymbol* _tmp131_ = NULL;
																								ValaUnresolvedSymbol* _tmp132_ = NULL;
																								_tmp128_ = type;
																								_tmp129_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																								_tmp130_ = _tmp129_;
																								_tmp131_ = vala_unresolved_symbol_new (_tmp130_, "SList", NULL);
																								_tmp132_ = _tmp131_;
																								vala_unresolved_type_set_unresolved_symbol (_tmp128_, _tmp132_);
																								_vala_code_node_unref0 (_tmp132_);
																								_vala_code_node_unref0 (_tmp130_);
																							} else {
																								GIdlNodeType* _tmp133_ = NULL;
																								TypeTag _tmp134_ = 0;
																								_tmp133_ = type_node;
																								_tmp134_ = _tmp133_->tag;
																								if (_tmp134_ == TYPE_TAG_HASH) {
																									ValaUnresolvedType* _tmp135_ = NULL;
																									ValaUnresolvedSymbol* _tmp136_ = NULL;
																									ValaUnresolvedSymbol* _tmp137_ = NULL;
																									ValaUnresolvedSymbol* _tmp138_ = NULL;
																									ValaUnresolvedSymbol* _tmp139_ = NULL;
																									_tmp135_ = type;
																									_tmp136_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																									_tmp137_ = _tmp136_;
																									_tmp138_ = vala_unresolved_symbol_new (_tmp137_, "HashTable", NULL);
																									_tmp139_ = _tmp138_;
																									vala_unresolved_type_set_unresolved_symbol (_tmp135_, _tmp139_);
																									_vala_code_node_unref0 (_tmp139_);
																									_vala_code_node_unref0 (_tmp137_);
																								} else {
																									GIdlNodeType* _tmp140_ = NULL;
																									TypeTag _tmp141_ = 0;
																									_tmp140_ = type_node;
																									_tmp141_ = _tmp140_->tag;
																									if (_tmp141_ == TYPE_TAG_ERROR) {
																										ValaUnresolvedType* _tmp142_ = NULL;
																										ValaUnresolvedSymbol* _tmp143_ = NULL;
																										ValaUnresolvedSymbol* _tmp144_ = NULL;
																										ValaUnresolvedSymbol* _tmp145_ = NULL;
																										ValaUnresolvedSymbol* _tmp146_ = NULL;
																										_tmp142_ = type;
																										_tmp143_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																										_tmp144_ = _tmp143_;
																										_tmp145_ = vala_unresolved_symbol_new (_tmp144_, "Error", NULL);
																										_tmp146_ = _tmp145_;
																										vala_unresolved_type_set_unresolved_symbol (_tmp142_, _tmp146_);
																										_vala_code_node_unref0 (_tmp146_);
																										_vala_code_node_unref0 (_tmp144_);
																									} else {
																										gboolean _tmp147_ = FALSE;
																										gboolean _tmp148_ = FALSE;
																										GIdlNodeType* _tmp149_ = NULL;
																										const gchar* _tmp150_ = NULL;
																										gboolean _tmp151_ = FALSE;
																										_tmp149_ = type_node;
																										_tmp150_ = _tmp149_->unparsed;
																										_tmp151_ = g_str_has_prefix (_tmp150_, "cairo_device_t");
																										if (_tmp151_) {
																											_tmp148_ = TRUE;
																										} else {
																											GIdlNodeType* _tmp152_ = NULL;
																											const gchar* _tmp153_ = NULL;
																											gboolean _tmp154_ = FALSE;
																											_tmp152_ = type_node;
																											_tmp153_ = _tmp152_->unparsed;
																											_tmp154_ = g_str_has_prefix (_tmp153_, "cairo_pattern_t");
																											_tmp148_ = _tmp154_;
																										}
																										if (_tmp148_) {
																											_tmp147_ = TRUE;
																										} else {
																											GIdlNodeType* _tmp155_ = NULL;
																											const gchar* _tmp156_ = NULL;
																											gboolean _tmp157_ = FALSE;
																											_tmp155_ = type_node;
																											_tmp156_ = _tmp155_->unparsed;
																											_tmp157_ = g_str_has_prefix (_tmp156_, "cairo_surface_t");
																											_tmp147_ = _tmp157_;
																										}
																										if (_tmp147_) {
																											GIdlNodeType* _tmp158_ = NULL;
																											const gchar* _tmp159_ = NULL;
																											gboolean _tmp160_ = FALSE;
																											GIdlNodeType* _tmp182_ = NULL;
																											const gchar* _tmp183_ = NULL;
																											gboolean _tmp184_ = FALSE;
																											_tmp158_ = type_node;
																											_tmp159_ = _tmp158_->unparsed;
																											_tmp160_ = g_str_has_prefix (_tmp159_, "cairo_device_t");
																											if (_tmp160_) {
																												ValaUnresolvedType* _tmp161_ = NULL;
																												ValaUnresolvedSymbol* _tmp162_ = NULL;
																												ValaUnresolvedSymbol* _tmp163_ = NULL;
																												ValaUnresolvedSymbol* _tmp164_ = NULL;
																												ValaUnresolvedSymbol* _tmp165_ = NULL;
																												_tmp161_ = type;
																												_tmp162_ = vala_unresolved_symbol_new (NULL, "Cairo", NULL);
																												_tmp163_ = _tmp162_;
																												_tmp164_ = vala_unresolved_symbol_new (_tmp163_, "Device", NULL);
																												_tmp165_ = _tmp164_;
																												vala_unresolved_type_set_unresolved_symbol (_tmp161_, _tmp165_);
																												_vala_code_node_unref0 (_tmp165_);
																												_vala_code_node_unref0 (_tmp163_);
																											} else {
																												GIdlNodeType* _tmp166_ = NULL;
																												const gchar* _tmp167_ = NULL;
																												gboolean _tmp168_ = FALSE;
																												_tmp166_ = type_node;
																												_tmp167_ = _tmp166_->unparsed;
																												_tmp168_ = g_str_has_prefix (_tmp167_, "cairo_pattern_t");
																												if (_tmp168_) {
																													ValaUnresolvedType* _tmp169_ = NULL;
																													ValaUnresolvedSymbol* _tmp170_ = NULL;
																													ValaUnresolvedSymbol* _tmp171_ = NULL;
																													ValaUnresolvedSymbol* _tmp172_ = NULL;
																													ValaUnresolvedSymbol* _tmp173_ = NULL;
																													_tmp169_ = type;
																													_tmp170_ = vala_unresolved_symbol_new (NULL, "Cairo", NULL);
																													_tmp171_ = _tmp170_;
																													_tmp172_ = vala_unresolved_symbol_new (_tmp171_, "Pattern", NULL);
																													_tmp173_ = _tmp172_;
																													vala_unresolved_type_set_unresolved_symbol (_tmp169_, _tmp173_);
																													_vala_code_node_unref0 (_tmp173_);
																													_vala_code_node_unref0 (_tmp171_);
																												} else {
																													GIdlNodeType* _tmp174_ = NULL;
																													const gchar* _tmp175_ = NULL;
																													gboolean _tmp176_ = FALSE;
																													_tmp174_ = type_node;
																													_tmp175_ = _tmp174_->unparsed;
																													_tmp176_ = g_str_has_prefix (_tmp175_, "cairo_surface_t");
																													if (_tmp176_) {
																														ValaUnresolvedType* _tmp177_ = NULL;
																														ValaUnresolvedSymbol* _tmp178_ = NULL;
																														ValaUnresolvedSymbol* _tmp179_ = NULL;
																														ValaUnresolvedSymbol* _tmp180_ = NULL;
																														ValaUnresolvedSymbol* _tmp181_ = NULL;
																														_tmp177_ = type;
																														_tmp178_ = vala_unresolved_symbol_new (NULL, "Cairo", NULL);
																														_tmp179_ = _tmp178_;
																														_tmp180_ = vala_unresolved_symbol_new (_tmp179_, "Surface", NULL);
																														_tmp181_ = _tmp180_;
																														vala_unresolved_type_set_unresolved_symbol (_tmp177_, _tmp181_);
																														_vala_code_node_unref0 (_tmp181_);
																														_vala_code_node_unref0 (_tmp179_);
																													}
																												}
																											}
																											_tmp182_ = type_node;
																											_tmp183_ = _tmp182_->unparsed;
																											_tmp184_ = g_str_has_suffix (_tmp183_, "**");
																											if (_tmp184_) {
																												_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																											}
																										} else {
																											GIdlNodeType* _tmp185_ = NULL;
																											gboolean _tmp186_ = FALSE;
																											_tmp185_ = type_node;
																											_tmp186_ = _tmp185_->is_interface;
																											if (_tmp186_) {
																												gchar* n = NULL;
																												GIdlNodeType* _tmp187_ = NULL;
																												const gchar* _tmp188_ = NULL;
																												gchar* _tmp189_ = NULL;
																												const gchar* _tmp190_ = NULL;
																												const gchar* _tmp191_ = NULL;
																												gboolean _tmp192_ = FALSE;
																												gboolean _tmp197_ = FALSE;
																												GIdlNodeType* _tmp198_ = NULL;
																												gboolean _tmp199_ = FALSE;
																												_tmp187_ = type_node;
																												_tmp188_ = _tmp187_->interface;
																												_tmp189_ = g_strdup (_tmp188_);
																												n = _tmp189_;
																												_tmp190_ = n;
																												if (g_strcmp0 (_tmp190_, "") == 0) {
																													result = NULL;
																													_g_free0 (n);
																													_vala_code_node_unref0 (type);
																													if (direction) {
																														*direction = _vala_direction;
																													}
																													return result;
																												}
																												_tmp191_ = n;
																												_tmp192_ = g_str_has_prefix (_tmp191_, "const-");
																												if (_tmp192_) {
																													const gchar* _tmp193_ = NULL;
																													gint _tmp194_ = 0;
																													gint _tmp195_ = 0;
																													gchar* _tmp196_ = NULL;
																													_tmp193_ = n;
																													_tmp194_ = strlen ("const-");
																													_tmp195_ = _tmp194_;
																													_tmp196_ = string_substring (_tmp193_, (glong) _tmp195_, (glong) -1);
																													_g_free0 (n);
																													n = _tmp196_;
																												}
																												_tmp198_ = type_node;
																												_tmp199_ = _tmp198_->is_pointer;
																												if (_tmp199_) {
																													gboolean _tmp200_ = FALSE;
																													const gchar* _tmp201_ = NULL;
																													_tmp201_ = n;
																													if (g_strcmp0 (_tmp201_, "gchar") == 0) {
																														_tmp200_ = TRUE;
																													} else {
																														const gchar* _tmp202_ = NULL;
																														_tmp202_ = n;
																														_tmp200_ = g_strcmp0 (_tmp202_, "char") == 0;
																													}
																													_tmp197_ = _tmp200_;
																												} else {
																													_tmp197_ = FALSE;
																												}
																												if (_tmp197_) {
																													ValaUnresolvedType* _tmp203_ = NULL;
																													ValaUnresolvedSymbol* _tmp204_ = NULL;
																													ValaUnresolvedSymbol* _tmp205_ = NULL;
																													GIdlNodeType* _tmp206_ = NULL;
																													const gchar* _tmp207_ = NULL;
																													gboolean _tmp208_ = FALSE;
																													_tmp203_ = type;
																													_tmp204_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																													_tmp205_ = _tmp204_;
																													vala_unresolved_type_set_unresolved_symbol (_tmp203_, _tmp205_);
																													_vala_code_node_unref0 (_tmp205_);
																													_tmp206_ = type_node;
																													_tmp207_ = _tmp206_->unparsed;
																													_tmp208_ = g_str_has_suffix (_tmp207_, "**");
																													if (_tmp208_) {
																														_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																													}
																												} else {
																													const gchar* _tmp209_ = NULL;
																													_tmp209_ = n;
																													if (g_strcmp0 (_tmp209_, "gunichar") == 0) {
																														ValaUnresolvedType* _tmp210_ = NULL;
																														ValaUnresolvedSymbol* _tmp211_ = NULL;
																														ValaUnresolvedSymbol* _tmp212_ = NULL;
																														_tmp210_ = type;
																														_tmp211_ = vala_unresolved_symbol_new (NULL, "unichar", NULL);
																														_tmp212_ = _tmp211_;
																														vala_unresolved_type_set_unresolved_symbol (_tmp210_, _tmp212_);
																														_vala_code_node_unref0 (_tmp212_);
																													} else {
																														const gchar* _tmp213_ = NULL;
																														_tmp213_ = n;
																														if (g_strcmp0 (_tmp213_, "gchar") == 0) {
																															ValaUnresolvedType* _tmp214_ = NULL;
																															ValaUnresolvedSymbol* _tmp215_ = NULL;
																															ValaUnresolvedSymbol* _tmp216_ = NULL;
																															_tmp214_ = type;
																															_tmp215_ = vala_unresolved_symbol_new (NULL, "char", NULL);
																															_tmp216_ = _tmp215_;
																															vala_unresolved_type_set_unresolved_symbol (_tmp214_, _tmp216_);
																															_vala_code_node_unref0 (_tmp216_);
																														} else {
																															gboolean _tmp217_ = FALSE;
																															const gchar* _tmp218_ = NULL;
																															_tmp218_ = n;
																															if (g_strcmp0 (_tmp218_, "guchar") == 0) {
																																_tmp217_ = TRUE;
																															} else {
																																const gchar* _tmp219_ = NULL;
																																_tmp219_ = n;
																																_tmp217_ = g_strcmp0 (_tmp219_, "guint8") == 0;
																															}
																															if (_tmp217_) {
																																ValaUnresolvedType* _tmp220_ = NULL;
																																ValaUnresolvedSymbol* _tmp221_ = NULL;
																																ValaUnresolvedSymbol* _tmp222_ = NULL;
																																GIdlNodeType* _tmp223_ = NULL;
																																gboolean _tmp224_ = FALSE;
																																_tmp220_ = type;
																																_tmp221_ = vala_unresolved_symbol_new (NULL, "uchar", NULL);
																																_tmp222_ = _tmp221_;
																																vala_unresolved_type_set_unresolved_symbol (_tmp220_, _tmp222_);
																																_vala_code_node_unref0 (_tmp222_);
																																_tmp223_ = type_node;
																																_tmp224_ = _tmp223_->is_pointer;
																																if (_tmp224_) {
																																	ValaUnresolvedType* _tmp225_ = NULL;
																																	ValaUnresolvedType* _tmp226_ = NULL;
																																	ValaUnresolvedType* _tmp227_ = NULL;
																																	ValaSourceReference* _tmp228_ = NULL;
																																	ValaSourceReference* _tmp229_ = NULL;
																																	ValaArrayType* _tmp230_ = NULL;
																																	_tmp225_ = type;
																																	vala_data_type_set_value_owned ((ValaDataType*) _tmp225_, TRUE);
																																	_tmp226_ = type;
																																	_tmp227_ = type;
																																	_tmp228_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp227_);
																																	_tmp229_ = _tmp228_;
																																	_tmp230_ = vala_array_type_new ((ValaDataType*) _tmp226_, 1, _tmp229_);
																																	result = (ValaDataType*) _tmp230_;
																																	_g_free0 (n);
																																	_vala_code_node_unref0 (type);
																																	if (direction) {
																																		*direction = _vala_direction;
																																	}
																																	return result;
																																}
																															} else {
																																const gchar* _tmp231_ = NULL;
																																_tmp231_ = n;
																																if (g_strcmp0 (_tmp231_, "gushort") == 0) {
																																	ValaUnresolvedType* _tmp232_ = NULL;
																																	ValaUnresolvedSymbol* _tmp233_ = NULL;
																																	ValaUnresolvedSymbol* _tmp234_ = NULL;
																																	_tmp232_ = type;
																																	_tmp233_ = vala_unresolved_symbol_new (NULL, "ushort", NULL);
																																	_tmp234_ = _tmp233_;
																																	vala_unresolved_type_set_unresolved_symbol (_tmp232_, _tmp234_);
																																	_vala_code_node_unref0 (_tmp234_);
																																} else {
																																	const gchar* _tmp235_ = NULL;
																																	_tmp235_ = n;
																																	if (g_strcmp0 (_tmp235_, "gshort") == 0) {
																																		ValaUnresolvedType* _tmp236_ = NULL;
																																		ValaUnresolvedSymbol* _tmp237_ = NULL;
																																		ValaUnresolvedSymbol* _tmp238_ = NULL;
																																		_tmp236_ = type;
																																		_tmp237_ = vala_unresolved_symbol_new (NULL, "short", NULL);
																																		_tmp238_ = _tmp237_;
																																		vala_unresolved_type_set_unresolved_symbol (_tmp236_, _tmp238_);
																																		_vala_code_node_unref0 (_tmp238_);
																																	} else {
																																		gboolean _tmp239_ = FALSE;
																																		const gchar* _tmp240_ = NULL;
																																		_tmp240_ = n;
																																		if (g_strcmp0 (_tmp240_, "gconstpointer") == 0) {
																																			_tmp239_ = TRUE;
																																		} else {
																																			const gchar* _tmp241_ = NULL;
																																			_tmp241_ = n;
																																			_tmp239_ = g_strcmp0 (_tmp241_, "void") == 0;
																																		}
																																		if (_tmp239_) {
																																			ValaVoidType* _tmp242_ = NULL;
																																			ValaVoidType* _tmp243_ = NULL;
																																			ValaPointerType* _tmp244_ = NULL;
																																			ValaDataType* _tmp245_ = NULL;
																																			_tmp242_ = vala_void_type_new (NULL);
																																			_tmp243_ = _tmp242_;
																																			_tmp244_ = vala_pointer_type_new ((ValaDataType*) _tmp243_, NULL);
																																			_tmp245_ = (ValaDataType*) _tmp244_;
																																			_vala_code_node_unref0 (_tmp243_);
																																			result = _tmp245_;
																																			_g_free0 (n);
																																			_vala_code_node_unref0 (type);
																																			if (direction) {
																																				*direction = _vala_direction;
																																			}
																																			return result;
																																		} else {
																																			gboolean _tmp246_ = FALSE;
																																			const gchar* _tmp247_ = NULL;
																																			_tmp247_ = n;
																																			if (g_strcmp0 (_tmp247_, "goffset") == 0) {
																																				_tmp246_ = TRUE;
																																			} else {
																																				const gchar* _tmp248_ = NULL;
																																				_tmp248_ = n;
																																				_tmp246_ = g_strcmp0 (_tmp248_, "off_t") == 0;
																																			}
																																			if (_tmp246_) {
																																				ValaUnresolvedType* _tmp249_ = NULL;
																																				ValaUnresolvedSymbol* _tmp250_ = NULL;
																																				ValaUnresolvedSymbol* _tmp251_ = NULL;
																																				_tmp249_ = type;
																																				_tmp250_ = vala_unresolved_symbol_new (NULL, "int64", NULL);
																																				_tmp251_ = _tmp250_;
																																				vala_unresolved_type_set_unresolved_symbol (_tmp249_, _tmp251_);
																																				_vala_code_node_unref0 (_tmp251_);
																																			} else {
																																				const gchar* _tmp252_ = NULL;
																																				_tmp252_ = n;
																																				if (g_strcmp0 (_tmp252_, "value_array") == 0) {
																																					ValaUnresolvedType* _tmp253_ = NULL;
																																					ValaUnresolvedSymbol* _tmp254_ = NULL;
																																					ValaUnresolvedSymbol* _tmp255_ = NULL;
																																					ValaUnresolvedSymbol* _tmp256_ = NULL;
																																					ValaUnresolvedSymbol* _tmp257_ = NULL;
																																					_tmp253_ = type;
																																					_tmp254_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																					_tmp255_ = _tmp254_;
																																					_tmp256_ = vala_unresolved_symbol_new (_tmp255_, "ValueArray", NULL);
																																					_tmp257_ = _tmp256_;
																																					vala_unresolved_type_set_unresolved_symbol (_tmp253_, _tmp257_);
																																					_vala_code_node_unref0 (_tmp257_);
																																					_vala_code_node_unref0 (_tmp255_);
																																				} else {
																																					const gchar* _tmp258_ = NULL;
																																					_tmp258_ = n;
																																					if (g_strcmp0 (_tmp258_, "time_t") == 0) {
																																						ValaUnresolvedType* _tmp259_ = NULL;
																																						ValaUnresolvedSymbol* _tmp260_ = NULL;
																																						ValaUnresolvedSymbol* _tmp261_ = NULL;
																																						_tmp259_ = type;
																																						_tmp260_ = vala_unresolved_symbol_new (NULL, "ulong", NULL);
																																						_tmp261_ = _tmp260_;
																																						vala_unresolved_type_set_unresolved_symbol (_tmp259_, _tmp261_);
																																						_vala_code_node_unref0 (_tmp261_);
																																					} else {
																																						const gchar* _tmp262_ = NULL;
																																						_tmp262_ = n;
																																						if (g_strcmp0 (_tmp262_, "socklen_t") == 0) {
																																							ValaUnresolvedType* _tmp263_ = NULL;
																																							ValaUnresolvedSymbol* _tmp264_ = NULL;
																																							ValaUnresolvedSymbol* _tmp265_ = NULL;
																																							_tmp263_ = type;
																																							_tmp264_ = vala_unresolved_symbol_new (NULL, "uint32", NULL);
																																							_tmp265_ = _tmp264_;
																																							vala_unresolved_type_set_unresolved_symbol (_tmp263_, _tmp265_);
																																							_vala_code_node_unref0 (_tmp265_);
																																						} else {
																																							const gchar* _tmp266_ = NULL;
																																							_tmp266_ = n;
																																							if (g_strcmp0 (_tmp266_, "mode_t") == 0) {
																																								ValaUnresolvedType* _tmp267_ = NULL;
																																								ValaUnresolvedSymbol* _tmp268_ = NULL;
																																								ValaUnresolvedSymbol* _tmp269_ = NULL;
																																								_tmp267_ = type;
																																								_tmp268_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																								_tmp269_ = _tmp268_;
																																								vala_unresolved_type_set_unresolved_symbol (_tmp267_, _tmp269_);
																																								_vala_code_node_unref0 (_tmp269_);
																																							} else {
																																								gboolean _tmp270_ = FALSE;
																																								const gchar* _tmp271_ = NULL;
																																								_tmp271_ = n;
																																								if (g_strcmp0 (_tmp271_, "gint") == 0) {
																																									_tmp270_ = TRUE;
																																								} else {
																																									const gchar* _tmp272_ = NULL;
																																									_tmp272_ = n;
																																									_tmp270_ = g_strcmp0 (_tmp272_, "pid_t") == 0;
																																								}
																																								if (_tmp270_) {
																																									ValaUnresolvedType* _tmp273_ = NULL;
																																									ValaUnresolvedSymbol* _tmp274_ = NULL;
																																									ValaUnresolvedSymbol* _tmp275_ = NULL;
																																									_tmp273_ = type;
																																									_tmp274_ = vala_unresolved_symbol_new (NULL, "int", NULL);
																																									_tmp275_ = _tmp274_;
																																									vala_unresolved_type_set_unresolved_symbol (_tmp273_, _tmp275_);
																																									_vala_code_node_unref0 (_tmp275_);
																																								} else {
																																									gboolean _tmp276_ = FALSE;
																																									const gchar* _tmp277_ = NULL;
																																									_tmp277_ = n;
																																									if (g_strcmp0 (_tmp277_, "unsigned") == 0) {
																																										_tmp276_ = TRUE;
																																									} else {
																																										const gchar* _tmp278_ = NULL;
																																										_tmp278_ = n;
																																										_tmp276_ = g_strcmp0 (_tmp278_, "unsigned-int") == 0;
																																									}
																																									if (_tmp276_) {
																																										ValaUnresolvedType* _tmp279_ = NULL;
																																										ValaUnresolvedSymbol* _tmp280_ = NULL;
																																										ValaUnresolvedSymbol* _tmp281_ = NULL;
																																										_tmp279_ = type;
																																										_tmp280_ = vala_unresolved_symbol_new (NULL, "uint", NULL);
																																										_tmp281_ = _tmp280_;
																																										vala_unresolved_type_set_unresolved_symbol (_tmp279_, _tmp281_);
																																										_vala_code_node_unref0 (_tmp281_);
																																									} else {
																																										const gchar* _tmp282_ = NULL;
																																										_tmp282_ = n;
																																										if (g_strcmp0 (_tmp282_, "FILE") == 0) {
																																											ValaUnresolvedType* _tmp283_ = NULL;
																																											ValaUnresolvedSymbol* _tmp284_ = NULL;
																																											ValaUnresolvedSymbol* _tmp285_ = NULL;
																																											ValaUnresolvedSymbol* _tmp286_ = NULL;
																																											ValaUnresolvedSymbol* _tmp287_ = NULL;
																																											_tmp283_ = type;
																																											_tmp284_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																											_tmp285_ = _tmp284_;
																																											_tmp286_ = vala_unresolved_symbol_new (_tmp285_, "FileStream", NULL);
																																											_tmp287_ = _tmp286_;
																																											vala_unresolved_type_set_unresolved_symbol (_tmp283_, _tmp287_);
																																											_vala_code_node_unref0 (_tmp287_);
																																											_vala_code_node_unref0 (_tmp285_);
																																										} else {
																																											const gchar* _tmp288_ = NULL;
																																											_tmp288_ = n;
																																											if (g_strcmp0 (_tmp288_, "struct") == 0) {
																																												ValaVoidType* _tmp289_ = NULL;
																																												ValaVoidType* _tmp290_ = NULL;
																																												ValaPointerType* _tmp291_ = NULL;
																																												ValaDataType* _tmp292_ = NULL;
																																												_tmp289_ = vala_void_type_new (NULL);
																																												_tmp290_ = _tmp289_;
																																												_tmp291_ = vala_pointer_type_new ((ValaDataType*) _tmp290_, NULL);
																																												_tmp292_ = (ValaDataType*) _tmp291_;
																																												_vala_code_node_unref0 (_tmp290_);
																																												result = _tmp292_;
																																												_g_free0 (n);
																																												_vala_code_node_unref0 (type);
																																												if (direction) {
																																													*direction = _vala_direction;
																																												}
																																												return result;
																																											} else {
																																												const gchar* _tmp293_ = NULL;
																																												_tmp293_ = n;
																																												if (g_strcmp0 (_tmp293_, "iconv_t") == 0) {
																																													ValaVoidType* _tmp294_ = NULL;
																																													ValaVoidType* _tmp295_ = NULL;
																																													ValaPointerType* _tmp296_ = NULL;
																																													ValaDataType* _tmp297_ = NULL;
																																													_tmp294_ = vala_void_type_new (NULL);
																																													_tmp295_ = _tmp294_;
																																													_tmp296_ = vala_pointer_type_new ((ValaDataType*) _tmp295_, NULL);
																																													_tmp297_ = (ValaDataType*) _tmp296_;
																																													_vala_code_node_unref0 (_tmp295_);
																																													result = _tmp297_;
																																													_g_free0 (n);
																																													_vala_code_node_unref0 (type);
																																													if (direction) {
																																														*direction = _vala_direction;
																																													}
																																													return result;
																																												} else {
																																													const gchar* _tmp298_ = NULL;
																																													_tmp298_ = n;
																																													if (g_strcmp0 (_tmp298_, "GType") == 0) {
																																														ValaUnresolvedType* _tmp299_ = NULL;
																																														ValaUnresolvedSymbol* _tmp300_ = NULL;
																																														ValaUnresolvedSymbol* _tmp301_ = NULL;
																																														ValaUnresolvedSymbol* _tmp302_ = NULL;
																																														ValaUnresolvedSymbol* _tmp303_ = NULL;
																																														GIdlNodeType* _tmp304_ = NULL;
																																														gboolean _tmp305_ = FALSE;
																																														_tmp299_ = type;
																																														_tmp300_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
																																														_tmp301_ = _tmp300_;
																																														_tmp302_ = vala_unresolved_symbol_new (_tmp301_, "Type", NULL);
																																														_tmp303_ = _tmp302_;
																																														vala_unresolved_type_set_unresolved_symbol (_tmp299_, _tmp303_);
																																														_vala_code_node_unref0 (_tmp303_);
																																														_vala_code_node_unref0 (_tmp301_);
																																														_tmp304_ = type_node;
																																														_tmp305_ = _tmp304_->is_pointer;
																																														if (_tmp305_) {
																																															ValaUnresolvedType* _tmp306_ = NULL;
																																															ValaUnresolvedType* _tmp307_ = NULL;
																																															ValaUnresolvedType* _tmp308_ = NULL;
																																															ValaSourceReference* _tmp309_ = NULL;
																																															ValaSourceReference* _tmp310_ = NULL;
																																															ValaArrayType* _tmp311_ = NULL;
																																															_tmp306_ = type;
																																															vala_data_type_set_value_owned ((ValaDataType*) _tmp306_, TRUE);
																																															_tmp307_ = type;
																																															_tmp308_ = type;
																																															_tmp309_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp308_);
																																															_tmp310_ = _tmp309_;
																																															_tmp311_ = vala_array_type_new ((ValaDataType*) _tmp307_, 1, _tmp310_);
																																															result = (ValaDataType*) _tmp311_;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															if (direction) {
																																																*direction = _vala_direction;
																																															}
																																															return result;
																																														}
																																													} else {
																																														const gchar* _tmp312_ = NULL;
																																														_tmp312_ = n;
																																														if (g_strcmp0 (_tmp312_, "GStrv") == 0) {
																																															ValaUnresolvedType* _tmp313_ = NULL;
																																															ValaUnresolvedSymbol* _tmp314_ = NULL;
																																															ValaUnresolvedSymbol* _tmp315_ = NULL;
																																															ValaUnresolvedType* _tmp316_ = NULL;
																																															ValaUnresolvedType* _tmp317_ = NULL;
																																															ValaUnresolvedType* _tmp318_ = NULL;
																																															ValaSourceReference* _tmp319_ = NULL;
																																															ValaSourceReference* _tmp320_ = NULL;
																																															ValaArrayType* _tmp321_ = NULL;
																																															_tmp313_ = type;
																																															_tmp314_ = vala_unresolved_symbol_new (NULL, "string", NULL);
																																															_tmp315_ = _tmp314_;
																																															vala_unresolved_type_set_unresolved_symbol (_tmp313_, _tmp315_);
																																															_vala_code_node_unref0 (_tmp315_);
																																															_tmp316_ = type;
																																															vala_data_type_set_value_owned ((ValaDataType*) _tmp316_, TRUE);
																																															_tmp317_ = type;
																																															_tmp318_ = type;
																																															_tmp319_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp318_);
																																															_tmp320_ = _tmp319_;
																																															_tmp321_ = vala_array_type_new ((ValaDataType*) _tmp317_, 1, _tmp320_);
																																															result = (ValaDataType*) _tmp321_;
																																															_g_free0 (n);
																																															_vala_code_node_unref0 (type);
																																															if (direction) {
																																																*direction = _vala_direction;
																																															}
																																															return result;
																																														} else {
																																															ValaDataType* named_type = NULL;
																																															const gchar* _tmp322_ = NULL;
																																															ValaDataType* _tmp323_ = NULL;
																																															ValaDataType* _tmp324_ = NULL;
																																															ValaUnresolvedType* _tmp325_ = NULL;
																																															ValaUnresolvedType* _tmp326_ = NULL;
																																															const gchar* _tmp327_ = NULL;
																																															gboolean _tmp328_ = FALSE;
																																															_tmp322_ = n;
																																															_tmp323_ = vala_gidl_parser_parse_type_string (self, _tmp322_);
																																															named_type = _tmp323_;
																																															_tmp324_ = named_type;
																																															_tmp325_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp324_, VALA_TYPE_UNRESOLVED_TYPE) ? ((ValaUnresolvedType*) _tmp324_) : NULL);
																																															_vala_code_node_unref0 (type);
																																															type = _tmp325_;
																																															_tmp326_ = type;
																																															if (_tmp326_ == NULL) {
																																																result = named_type;
																																																_g_free0 (n);
																																																_vala_code_node_unref0 (type);
																																																if (direction) {
																																																	*direction = _vala_direction;
																																																}
																																																return result;
																																															}
																																															_tmp327_ = n;
																																															_tmp328_ = vala_gidl_parser_is_simple_type (self, _tmp327_);
																																															if (_tmp328_) {
																																																GIdlNodeType* _tmp329_ = NULL;
																																																gboolean _tmp330_ = FALSE;
																																																_tmp329_ = type_node;
																																																_tmp330_ = _tmp329_->is_pointer;
																																																if (_tmp330_) {
																																																	_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																																																}
																																															} else {
																																																GIdlNodeType* _tmp331_ = NULL;
																																																const gchar* _tmp332_ = NULL;
																																																gboolean _tmp333_ = FALSE;
																																																_tmp331_ = type_node;
																																																_tmp332_ = _tmp331_->unparsed;
																																																_tmp333_ = g_str_has_suffix (_tmp332_, "**");
																																																if (_tmp333_) {
																																																	_vala_direction = VALA_PARAMETER_DIRECTION_OUT;
																																																}
																																															}
																																															_vala_code_node_unref0 (named_type);
																																														}
																																													}
																																												}
																																											}
																																										}
																																									}
																																								}
																																							}
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																												_g_free0 (n);
																											} else {
																												FILE* _tmp334_ = NULL;
																												GIdlNodeType* _tmp335_ = NULL;
																												TypeTag _tmp336_ = 0;
																												_tmp334_ = stdout;
																												_tmp335_ = type_node;
																												_tmp336_ = _tmp335_->tag;
																												fprintf (_tmp334_, "%d\n", (gint) _tmp336_);
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = (ValaDataType*) type;
	if (direction) {
		*direction = _vala_direction;
	}
	return result;
}


static gboolean vala_gidl_parser_is_simple_type (ValaGIdlParser* self, const gchar* type_name) {
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	ValaTypeSymbol* _tmp3_ = NULL;
	ValaStruct* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	ValaStruct* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type_name != NULL, FALSE);
	_tmp0_ = self->priv->cname_type_map;
	_tmp1_ = type_name;
	_tmp2_ = vala_map_get (_tmp0_, _tmp1_);
	_tmp3_ = (ValaTypeSymbol*) _tmp2_;
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp3_) : NULL;
	if (_tmp4_ == NULL) {
		_vala_code_node_unref0 (_tmp3_);
	}
	st = _tmp4_;
	_tmp6_ = st;
	if (_tmp6_ != NULL) {
		ValaStruct* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = st;
		_tmp8_ = vala_struct_is_simple_type (_tmp7_);
		_tmp5_ = _tmp8_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	result = FALSE;
	_vala_code_node_unref0 (st);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_type_string (ValaGIdlParser* self, const gchar* n) {
	ValaDataType* result = NULL;
	const gchar* _tmp0_ = NULL;
	ValaUnresolvedType* type = NULL;
	ValaUnresolvedType* _tmp5_ = NULL;
	ValaTypeSymbol* dt = NULL;
	ValaMap* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gpointer _tmp8_ = NULL;
	ValaTypeSymbol* _tmp9_ = NULL;
	gchar** type_attributes = NULL;
	const gchar* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gchar** _tmp30_ = NULL;
	gint type_attributes_length1 = 0;
	gint _type_attributes_size_ = 0;
	gchar* ns_name = NULL;
	gchar** _tmp31_ = NULL;
	gint _tmp31__length1 = 0;
	ValaUnresolvedType* _tmp74_ = NULL;
	ValaUnresolvedSymbol* _tmp75_ = NULL;
	ValaUnresolvedSymbol* _tmp76_ = NULL;
	const gchar* _tmp93_ = NULL;
	ValaNamespace* _tmp94_ = NULL;
	const gchar* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	gboolean _tmp97_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (n != NULL, NULL);
	_tmp0_ = n;
	if (g_strcmp0 (_tmp0_, "va_list") == 0) {
		ValaVoidType* _tmp1_ = NULL;
		ValaVoidType* _tmp2_ = NULL;
		ValaPointerType* _tmp3_ = NULL;
		ValaDataType* _tmp4_ = NULL;
		_tmp1_ = vala_void_type_new (NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_pointer_type_new ((ValaDataType*) _tmp2_, NULL);
		_tmp4_ = (ValaDataType*) _tmp3_;
		_vala_code_node_unref0 (_tmp2_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = vala_unresolved_type_new ();
	type = _tmp5_;
	_tmp6_ = self->priv->cname_type_map;
	_tmp7_ = n;
	_tmp8_ = vala_map_get (_tmp6_, _tmp7_);
	dt = (ValaTypeSymbol*) _tmp8_;
	_tmp9_ = dt;
	if (_tmp9_ != NULL) {
		ValaUnresolvedSymbol* parent_symbol = NULL;
		ValaTypeSymbol* _tmp10_ = NULL;
		ValaSymbol* _tmp11_ = NULL;
		ValaSymbol* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		ValaUnresolvedType* _tmp21_ = NULL;
		ValaUnresolvedSymbol* _tmp22_ = NULL;
		ValaTypeSymbol* _tmp23_ = NULL;
		const gchar* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		ValaUnresolvedSymbol* _tmp26_ = NULL;
		ValaUnresolvedSymbol* _tmp27_ = NULL;
		parent_symbol = NULL;
		_tmp10_ = dt;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_symbol_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ != NULL) {
			ValaTypeSymbol* _tmp15_ = NULL;
			ValaSymbol* _tmp16_ = NULL;
			ValaSymbol* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			ValaUnresolvedSymbol* _tmp20_ = NULL;
			_tmp15_ = dt;
			_tmp16_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_symbol_get_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_unresolved_symbol_new (NULL, _tmp19_, NULL);
			_vala_code_node_unref0 (parent_symbol);
			parent_symbol = _tmp20_;
		}
		_tmp21_ = type;
		_tmp22_ = parent_symbol;
		_tmp23_ = dt;
		_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_unresolved_symbol_new (_tmp22_, _tmp25_, NULL);
		_tmp27_ = _tmp26_;
		vala_unresolved_type_set_unresolved_symbol (_tmp21_, _tmp27_);
		_vala_code_node_unref0 (_tmp27_);
		result = (ValaDataType*) type;
		_vala_code_node_unref0 (parent_symbol);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp28_ = n;
	_tmp30_ = vala_gidl_parser_get_attributes (self, _tmp28_, &_tmp29_);
	type_attributes = _tmp30_;
	type_attributes_length1 = _tmp29_;
	_type_attributes_size_ = type_attributes_length1;
	ns_name = NULL;
	_tmp31_ = type_attributes;
	_tmp31__length1 = type_attributes_length1;
	if (NULL != _tmp31_) {
		gchar** _tmp32_ = NULL;
		gint _tmp32__length1 = 0;
		_tmp32_ = type_attributes;
		_tmp32__length1 = type_attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp32_;
			attr_collection_length1 = _tmp32__length1;
			for (attr_it = 0; attr_it < _tmp32__length1; attr_it = attr_it + 1) {
				gchar* _tmp33_ = NULL;
				gchar* attr = NULL;
				_tmp33_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp33_;
				{
					gchar** nv = NULL;
					const gchar* _tmp34_ = NULL;
					gchar** _tmp35_ = NULL;
					gchar** _tmp36_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gchar** _tmp37_ = NULL;
					gint _tmp37__length1 = 0;
					const gchar* _tmp38_ = NULL;
					_tmp34_ = attr;
					_tmp36_ = _tmp35_ = g_strsplit (_tmp34_, "=", 2);
					nv = _tmp36_;
					nv_length1 = _vala_array_length (_tmp35_);
					_nv_size_ = nv_length1;
					_tmp37_ = nv;
					_tmp37__length1 = nv_length1;
					_tmp38_ = _tmp37_[0];
					if (g_strcmp0 (_tmp38_, "cprefix") == 0) {
						ValaUnresolvedType* _tmp39_ = NULL;
						const gchar* _tmp40_ = NULL;
						gchar** _tmp41_ = NULL;
						gint _tmp41__length1 = 0;
						const gchar* _tmp42_ = NULL;
						gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						gint _tmp46_ = 0;
						gchar* _tmp47_ = NULL;
						gchar* _tmp48_ = NULL;
						ValaUnresolvedSymbol* _tmp49_ = NULL;
						ValaUnresolvedSymbol* _tmp50_ = NULL;
						_tmp39_ = type;
						_tmp40_ = n;
						_tmp41_ = nv;
						_tmp41__length1 = nv_length1;
						_tmp42_ = _tmp41_[1];
						_tmp43_ = vala_gidl_parser_eval (self, _tmp42_);
						_tmp44_ = _tmp43_;
						_tmp45_ = strlen (_tmp44_);
						_tmp46_ = _tmp45_;
						_tmp47_ = string_substring (_tmp40_, (glong) _tmp46_, (glong) -1);
						_tmp48_ = _tmp47_;
						_tmp49_ = vala_unresolved_symbol_new (NULL, _tmp48_, NULL);
						_tmp50_ = _tmp49_;
						vala_unresolved_type_set_unresolved_symbol (_tmp39_, _tmp50_);
						_vala_code_node_unref0 (_tmp50_);
						_g_free0 (_tmp48_);
						_g_free0 (_tmp44_);
					} else {
						gchar** _tmp51_ = NULL;
						gint _tmp51__length1 = 0;
						const gchar* _tmp52_ = NULL;
						_tmp51_ = nv;
						_tmp51__length1 = nv_length1;
						_tmp52_ = _tmp51_[0];
						if (g_strcmp0 (_tmp52_, "name") == 0) {
							ValaUnresolvedType* _tmp53_ = NULL;
							gchar** _tmp54_ = NULL;
							gint _tmp54__length1 = 0;
							const gchar* _tmp55_ = NULL;
							gchar* _tmp56_ = NULL;
							gchar* _tmp57_ = NULL;
							ValaUnresolvedSymbol* _tmp58_ = NULL;
							ValaUnresolvedSymbol* _tmp59_ = NULL;
							_tmp53_ = type;
							_tmp54_ = nv;
							_tmp54__length1 = nv_length1;
							_tmp55_ = _tmp54_[1];
							_tmp56_ = vala_gidl_parser_eval (self, _tmp55_);
							_tmp57_ = _tmp56_;
							_tmp58_ = vala_unresolved_symbol_new (NULL, _tmp57_, NULL);
							_tmp59_ = _tmp58_;
							vala_unresolved_type_set_unresolved_symbol (_tmp53_, _tmp59_);
							_vala_code_node_unref0 (_tmp59_);
							_g_free0 (_tmp57_);
						} else {
							gchar** _tmp60_ = NULL;
							gint _tmp60__length1 = 0;
							const gchar* _tmp61_ = NULL;
							_tmp60_ = nv;
							_tmp60__length1 = nv_length1;
							_tmp61_ = _tmp60_[0];
							if (g_strcmp0 (_tmp61_, "namespace") == 0) {
								gchar** _tmp62_ = NULL;
								gint _tmp62__length1 = 0;
								const gchar* _tmp63_ = NULL;
								gchar* _tmp64_ = NULL;
								_tmp62_ = nv;
								_tmp62__length1 = nv_length1;
								_tmp63_ = _tmp62_[1];
								_tmp64_ = vala_gidl_parser_eval (self, _tmp63_);
								_g_free0 (ns_name);
								ns_name = _tmp64_;
							} else {
								gchar** _tmp65_ = NULL;
								gint _tmp65__length1 = 0;
								const gchar* _tmp66_ = NULL;
								_tmp65_ = nv;
								_tmp65__length1 = nv_length1;
								_tmp66_ = _tmp65_[0];
								if (g_strcmp0 (_tmp66_, "rename_to") == 0) {
									ValaUnresolvedType* _tmp67_ = NULL;
									gchar** _tmp68_ = NULL;
									gint _tmp68__length1 = 0;
									const gchar* _tmp69_ = NULL;
									gchar* _tmp70_ = NULL;
									gchar* _tmp71_ = NULL;
									ValaUnresolvedSymbol* _tmp72_ = NULL;
									ValaUnresolvedSymbol* _tmp73_ = NULL;
									_tmp67_ = type;
									_tmp68_ = nv;
									_tmp68__length1 = nv_length1;
									_tmp69_ = _tmp68_[1];
									_tmp70_ = vala_gidl_parser_eval (self, _tmp69_);
									_tmp71_ = _tmp70_;
									_tmp72_ = vala_unresolved_symbol_new (NULL, _tmp71_, NULL);
									_tmp73_ = _tmp72_;
									vala_unresolved_type_set_unresolved_symbol (_tmp67_, _tmp73_);
									_vala_code_node_unref0 (_tmp73_);
									_g_free0 (_tmp71_);
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp74_ = type;
	_tmp75_ = vala_unresolved_type_get_unresolved_symbol (_tmp74_);
	_tmp76_ = _tmp75_;
	if (_tmp76_ != NULL) {
		ValaUnresolvedType* _tmp77_ = NULL;
		ValaUnresolvedSymbol* _tmp78_ = NULL;
		ValaUnresolvedSymbol* _tmp79_ = NULL;
		const gchar* _tmp80_ = NULL;
		const gchar* _tmp81_ = NULL;
		const gchar* _tmp86_ = NULL;
		_tmp77_ = type;
		_tmp78_ = vala_unresolved_type_get_unresolved_symbol (_tmp77_);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_symbol_get_name ((ValaSymbol*) _tmp79_);
		_tmp81_ = _tmp80_;
		if (g_strcmp0 (_tmp81_, "pointer") == 0) {
			ValaVoidType* _tmp82_ = NULL;
			ValaVoidType* _tmp83_ = NULL;
			ValaPointerType* _tmp84_ = NULL;
			ValaDataType* _tmp85_ = NULL;
			_tmp82_ = vala_void_type_new (NULL);
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_pointer_type_new ((ValaDataType*) _tmp83_, NULL);
			_tmp85_ = (ValaDataType*) _tmp84_;
			_vala_code_node_unref0 (_tmp83_);
			result = _tmp85_;
			_g_free0 (ns_name);
			type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
			_vala_code_node_unref0 (dt);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp86_ = ns_name;
		if (_tmp86_ != NULL) {
			ValaUnresolvedType* _tmp87_ = NULL;
			ValaUnresolvedSymbol* _tmp88_ = NULL;
			ValaUnresolvedSymbol* _tmp89_ = NULL;
			const gchar* _tmp90_ = NULL;
			ValaUnresolvedSymbol* _tmp91_ = NULL;
			ValaUnresolvedSymbol* _tmp92_ = NULL;
			_tmp87_ = type;
			_tmp88_ = vala_unresolved_type_get_unresolved_symbol (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = ns_name;
			_tmp91_ = vala_unresolved_symbol_new (NULL, _tmp90_, NULL);
			_tmp92_ = _tmp91_;
			vala_unresolved_symbol_set_inner (_tmp89_, _tmp92_);
			_vala_code_node_unref0 (_tmp92_);
		}
		result = (ValaDataType*) type;
		_g_free0 (ns_name);
		type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
		_vala_code_node_unref0 (dt);
		return result;
	}
	_tmp93_ = n;
	_tmp94_ = self->priv->current_namespace;
	_tmp95_ = vala_symbol_get_name ((ValaSymbol*) _tmp94_);
	_tmp96_ = _tmp95_;
	_tmp97_ = g_str_has_prefix (_tmp93_, _tmp96_);
	if (_tmp97_) {
		ValaUnresolvedType* _tmp98_ = NULL;
		ValaNamespace* _tmp99_ = NULL;
		const gchar* _tmp100_ = NULL;
		const gchar* _tmp101_ = NULL;
		ValaUnresolvedSymbol* _tmp102_ = NULL;
		ValaUnresolvedSymbol* _tmp103_ = NULL;
		const gchar* _tmp104_ = NULL;
		ValaNamespace* _tmp105_ = NULL;
		const gchar* _tmp106_ = NULL;
		const gchar* _tmp107_ = NULL;
		gint _tmp108_ = 0;
		gint _tmp109_ = 0;
		gchar* _tmp110_ = NULL;
		gchar* _tmp111_ = NULL;
		ValaUnresolvedSymbol* _tmp112_ = NULL;
		ValaUnresolvedSymbol* _tmp113_ = NULL;
		_tmp98_ = type;
		_tmp99_ = self->priv->current_namespace;
		_tmp100_ = vala_symbol_get_name ((ValaSymbol*) _tmp99_);
		_tmp101_ = _tmp100_;
		_tmp102_ = vala_unresolved_symbol_new (NULL, _tmp101_, NULL);
		_tmp103_ = _tmp102_;
		_tmp104_ = n;
		_tmp105_ = self->priv->current_namespace;
		_tmp106_ = vala_symbol_get_name ((ValaSymbol*) _tmp105_);
		_tmp107_ = _tmp106_;
		_tmp108_ = strlen (_tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = string_substring (_tmp104_, (glong) _tmp109_, (glong) -1);
		_tmp111_ = _tmp110_;
		_tmp112_ = vala_unresolved_symbol_new (_tmp103_, _tmp111_, NULL);
		_tmp113_ = _tmp112_;
		vala_unresolved_type_set_unresolved_symbol (_tmp98_, _tmp113_);
		_vala_code_node_unref0 (_tmp113_);
		_g_free0 (_tmp111_);
		_vala_code_node_unref0 (_tmp103_);
	} else {
		gboolean _tmp114_ = FALSE;
		gboolean _tmp115_ = FALSE;
		ValaNamespace* _tmp116_ = NULL;
		ValaSymbol* _tmp117_ = NULL;
		ValaSymbol* _tmp118_ = NULL;
		_tmp116_ = self->priv->current_namespace;
		_tmp117_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp116_);
		_tmp118_ = _tmp117_;
		if (_tmp118_ != NULL) {
			ValaNamespace* _tmp119_ = NULL;
			ValaSymbol* _tmp120_ = NULL;
			ValaSymbol* _tmp121_ = NULL;
			const gchar* _tmp122_ = NULL;
			const gchar* _tmp123_ = NULL;
			_tmp119_ = self->priv->current_namespace;
			_tmp120_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp119_);
			_tmp121_ = _tmp120_;
			_tmp122_ = vala_symbol_get_name (_tmp121_);
			_tmp123_ = _tmp122_;
			_tmp115_ = _tmp123_ != NULL;
		} else {
			_tmp115_ = FALSE;
		}
		if (_tmp115_) {
			const gchar* _tmp124_ = NULL;
			ValaNamespace* _tmp125_ = NULL;
			ValaSymbol* _tmp126_ = NULL;
			ValaSymbol* _tmp127_ = NULL;
			const gchar* _tmp128_ = NULL;
			const gchar* _tmp129_ = NULL;
			gboolean _tmp130_ = FALSE;
			_tmp124_ = n;
			_tmp125_ = self->priv->current_namespace;
			_tmp126_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_symbol_get_name (_tmp127_);
			_tmp129_ = _tmp128_;
			_tmp130_ = g_str_has_prefix (_tmp124_, _tmp129_);
			_tmp114_ = _tmp130_;
		} else {
			_tmp114_ = FALSE;
		}
		if (_tmp114_) {
			ValaUnresolvedType* _tmp131_ = NULL;
			ValaNamespace* _tmp132_ = NULL;
			ValaSymbol* _tmp133_ = NULL;
			ValaSymbol* _tmp134_ = NULL;
			const gchar* _tmp135_ = NULL;
			const gchar* _tmp136_ = NULL;
			ValaUnresolvedSymbol* _tmp137_ = NULL;
			ValaUnresolvedSymbol* _tmp138_ = NULL;
			const gchar* _tmp139_ = NULL;
			ValaNamespace* _tmp140_ = NULL;
			ValaSymbol* _tmp141_ = NULL;
			ValaSymbol* _tmp142_ = NULL;
			const gchar* _tmp143_ = NULL;
			const gchar* _tmp144_ = NULL;
			gint _tmp145_ = 0;
			gint _tmp146_ = 0;
			gchar* _tmp147_ = NULL;
			gchar* _tmp148_ = NULL;
			ValaUnresolvedSymbol* _tmp149_ = NULL;
			ValaUnresolvedSymbol* _tmp150_ = NULL;
			_tmp131_ = type;
			_tmp132_ = self->priv->current_namespace;
			_tmp133_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = vala_symbol_get_name (_tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_unresolved_symbol_new (NULL, _tmp136_, NULL);
			_tmp138_ = _tmp137_;
			_tmp139_ = n;
			_tmp140_ = self->priv->current_namespace;
			_tmp141_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_symbol_get_name (_tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = strlen (_tmp144_);
			_tmp146_ = _tmp145_;
			_tmp147_ = string_substring (_tmp139_, (glong) _tmp146_, (glong) -1);
			_tmp148_ = _tmp147_;
			_tmp149_ = vala_unresolved_symbol_new (_tmp138_, _tmp148_, NULL);
			_tmp150_ = _tmp149_;
			vala_unresolved_type_set_unresolved_symbol (_tmp131_, _tmp150_);
			_vala_code_node_unref0 (_tmp150_);
			_g_free0 (_tmp148_);
			_vala_code_node_unref0 (_tmp138_);
		} else {
			const gchar* _tmp151_ = NULL;
			gboolean _tmp152_ = FALSE;
			_tmp151_ = n;
			_tmp152_ = g_str_has_prefix (_tmp151_, "G");
			if (_tmp152_) {
				ValaUnresolvedType* _tmp153_ = NULL;
				ValaUnresolvedSymbol* _tmp154_ = NULL;
				ValaUnresolvedSymbol* _tmp155_ = NULL;
				const gchar* _tmp156_ = NULL;
				gchar* _tmp157_ = NULL;
				gchar* _tmp158_ = NULL;
				ValaUnresolvedSymbol* _tmp159_ = NULL;
				ValaUnresolvedSymbol* _tmp160_ = NULL;
				_tmp153_ = type;
				_tmp154_ = vala_unresolved_symbol_new (NULL, "GLib", NULL);
				_tmp155_ = _tmp154_;
				_tmp156_ = n;
				_tmp157_ = string_substring (_tmp156_, (glong) 1, (glong) -1);
				_tmp158_ = _tmp157_;
				_tmp159_ = vala_unresolved_symbol_new (_tmp155_, _tmp158_, NULL);
				_tmp160_ = _tmp159_;
				vala_unresolved_type_set_unresolved_symbol (_tmp153_, _tmp160_);
				_vala_code_node_unref0 (_tmp160_);
				_g_free0 (_tmp158_);
				_vala_code_node_unref0 (_tmp155_);
			} else {
				gchar** name_parts = NULL;
				const gchar* _tmp161_ = NULL;
				gchar** _tmp162_ = NULL;
				gchar** _tmp163_ = NULL;
				gint name_parts_length1 = 0;
				gint _name_parts_size_ = 0;
				gchar** _tmp164_ = NULL;
				gint _tmp164__length1 = 0;
				const gchar* _tmp165_ = NULL;
				_tmp161_ = n;
				_tmp163_ = _tmp162_ = g_strsplit (_tmp161_, ".", 2);
				name_parts = _tmp163_;
				name_parts_length1 = _vala_array_length (_tmp162_);
				_name_parts_size_ = name_parts_length1;
				_tmp164_ = name_parts;
				_tmp164__length1 = name_parts_length1;
				_tmp165_ = _tmp164_[1];
				if (_tmp165_ == NULL) {
					ValaUnresolvedType* _tmp166_ = NULL;
					gchar** _tmp167_ = NULL;
					gint _tmp167__length1 = 0;
					const gchar* _tmp168_ = NULL;
					ValaUnresolvedSymbol* _tmp169_ = NULL;
					ValaUnresolvedSymbol* _tmp170_ = NULL;
					_tmp166_ = type;
					_tmp167_ = name_parts;
					_tmp167__length1 = name_parts_length1;
					_tmp168_ = _tmp167_[0];
					_tmp169_ = vala_unresolved_symbol_new (NULL, _tmp168_, NULL);
					_tmp170_ = _tmp169_;
					vala_unresolved_type_set_unresolved_symbol (_tmp166_, _tmp170_);
					_vala_code_node_unref0 (_tmp170_);
				} else {
					ValaUnresolvedType* _tmp171_ = NULL;
					gchar** _tmp172_ = NULL;
					gint _tmp172__length1 = 0;
					const gchar* _tmp173_ = NULL;
					ValaUnresolvedSymbol* _tmp174_ = NULL;
					ValaUnresolvedSymbol* _tmp175_ = NULL;
					gchar** _tmp176_ = NULL;
					gint _tmp176__length1 = 0;
					const gchar* _tmp177_ = NULL;
					ValaUnresolvedSymbol* _tmp178_ = NULL;
					ValaUnresolvedSymbol* _tmp179_ = NULL;
					_tmp171_ = type;
					_tmp172_ = name_parts;
					_tmp172__length1 = name_parts_length1;
					_tmp173_ = _tmp172_[0];
					_tmp174_ = vala_unresolved_symbol_new (NULL, _tmp173_, NULL);
					_tmp175_ = _tmp174_;
					_tmp176_ = name_parts;
					_tmp176__length1 = name_parts_length1;
					_tmp177_ = _tmp176_[1];
					_tmp178_ = vala_unresolved_symbol_new (_tmp175_, _tmp177_, NULL);
					_tmp179_ = _tmp178_;
					vala_unresolved_type_set_unresolved_symbol (_tmp171_, _tmp179_);
					_vala_code_node_unref0 (_tmp179_);
					_vala_code_node_unref0 (_tmp175_);
				}
				name_parts = (_vala_array_free (name_parts, name_parts_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	result = (ValaDataType*) type;
	_g_free0 (ns_name);
	type_attributes = (_vala_array_free (type_attributes, type_attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (dt);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_param (ValaGIdlParser* self, GIdlNodeParam* param, ValaParameterDirection* direction) {
	ValaParameterDirection _vala_direction = 0;
	ValaDataType* result = NULL;
	ValaDataType* type = NULL;
	GIdlNodeParam* _tmp0_ = NULL;
	GIdlNodeType* _tmp1_ = NULL;
	ValaParameterDirection _tmp2_ = 0;
	ValaDataType* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (param != NULL, NULL);
	_tmp0_ = param;
	_tmp1_ = _tmp0_->type;
	_tmp3_ = vala_gidl_parser_parse_type (self, _tmp1_, &_tmp2_);
	_vala_direction = _tmp2_;
	type = _tmp3_;
	result = type;
	if (direction) {
		*direction = _vala_direction;
	}
	return result;
}


static ValaUnresolvedSymbol* vala_gidl_parser_parse_symbol_from_string (ValaGIdlParser* self, const gchar* symbol_string, ValaSourceReference* source_reference) {
	ValaUnresolvedSymbol* result = NULL;
	ValaUnresolvedSymbol* sym = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	ValaUnresolvedSymbol* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp0_ = symbol_string;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ".", 0);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp2_;
		s_collection_length1 = _vala_array_length (_tmp1_);
		for (s_it = 0; s_it < _vala_array_length (_tmp1_); s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				ValaSourceReference* _tmp5_ = NULL;
				ValaUnresolvedSymbol* _tmp6_ = NULL;
				_tmp3_ = sym;
				_tmp4_ = s;
				_tmp5_ = source_reference;
				_tmp6_ = vala_unresolved_symbol_new (_tmp3_, _tmp4_, _tmp5_);
				_vala_code_node_unref0 (sym);
				sym = _tmp6_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp7_ = sym;
	if (_tmp7_ == NULL) {
		ValaSourceReference* _tmp8_ = NULL;
		_tmp8_ = source_reference;
		vala_report_error (_tmp8_, "a symbol must be specified");
	}
	result = sym;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean vala_gidl_parser_parse_type_arguments_from_string (ValaGIdlParser* self, ValaDataType* parent_type, const gchar* type_arguments, ValaSourceReference* source_reference) {
	gboolean result = FALSE;
	gint type_arguments_length = 0;
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GString* current = NULL;
	gint _tmp3_ = 0;
	GString* _tmp4_ = NULL;
	gint depth = 0;
	ValaDataType* dt = NULL;
	GString* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	ValaSourceReference* _tmp55_ = NULL;
	ValaDataType* _tmp56_ = NULL;
	ValaDataType* _tmp57_ = NULL;
	ValaDataType* _tmp58_ = NULL;
	ValaDataType* _tmp59_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = type_arguments;
	_tmp1_ = strlen (_tmp0_);
	_tmp2_ = _tmp1_;
	type_arguments_length = (gint) _tmp2_;
	_tmp3_ = type_arguments_length;
	_tmp4_ = g_string_sized_new ((gsize) _tmp3_);
	current = _tmp4_;
	depth = 0;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gboolean _tmp9_ = FALSE;
				const gchar* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gchar _tmp12_ = '\0';
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = c;
					c = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = c;
				_tmp8_ = type_arguments_length;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp10_ = type_arguments;
				_tmp11_ = c;
				_tmp12_ = string_get (_tmp10_, (glong) _tmp11_);
				if (_tmp12_ == '<') {
					_tmp9_ = TRUE;
				} else {
					const gchar* _tmp13_ = NULL;
					gint _tmp14_ = 0;
					gchar _tmp15_ = '\0';
					_tmp13_ = type_arguments;
					_tmp14_ = c;
					_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
					_tmp9_ = _tmp15_ == '[';
				}
				if (_tmp9_) {
					gint _tmp16_ = 0;
					GString* _tmp17_ = NULL;
					const gchar* _tmp18_ = NULL;
					gint _tmp19_ = 0;
					gchar _tmp20_ = '\0';
					_tmp16_ = depth;
					depth = _tmp16_ + 1;
					_tmp17_ = current;
					_tmp18_ = type_arguments;
					_tmp19_ = c;
					_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
					g_string_append_unichar (_tmp17_, (gunichar) _tmp20_);
				} else {
					gboolean _tmp21_ = FALSE;
					const gchar* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					gchar _tmp24_ = '\0';
					_tmp22_ = type_arguments;
					_tmp23_ = c;
					_tmp24_ = string_get (_tmp22_, (glong) _tmp23_);
					if (_tmp24_ == '>') {
						_tmp21_ = TRUE;
					} else {
						const gchar* _tmp25_ = NULL;
						gint _tmp26_ = 0;
						gchar _tmp27_ = '\0';
						_tmp25_ = type_arguments;
						_tmp26_ = c;
						_tmp27_ = string_get (_tmp25_, (glong) _tmp26_);
						_tmp21_ = _tmp27_ == ']';
					}
					if (_tmp21_) {
						gint _tmp28_ = 0;
						GString* _tmp29_ = NULL;
						const gchar* _tmp30_ = NULL;
						gint _tmp31_ = 0;
						gchar _tmp32_ = '\0';
						_tmp28_ = depth;
						depth = _tmp28_ - 1;
						_tmp29_ = current;
						_tmp30_ = type_arguments;
						_tmp31_ = c;
						_tmp32_ = string_get (_tmp30_, (glong) _tmp31_);
						g_string_append_unichar (_tmp29_, (gunichar) _tmp32_);
					} else {
						const gchar* _tmp33_ = NULL;
						gint _tmp34_ = 0;
						gchar _tmp35_ = '\0';
						_tmp33_ = type_arguments;
						_tmp34_ = c;
						_tmp35_ = string_get (_tmp33_, (glong) _tmp34_);
						if (_tmp35_ == ',') {
							gint _tmp36_ = 0;
							_tmp36_ = depth;
							if (_tmp36_ == 0) {
								ValaDataType* dt = NULL;
								GString* _tmp37_ = NULL;
								const gchar* _tmp38_ = NULL;
								ValaSourceReference* _tmp39_ = NULL;
								ValaDataType* _tmp40_ = NULL;
								ValaDataType* _tmp41_ = NULL;
								ValaDataType* _tmp42_ = NULL;
								ValaDataType* _tmp43_ = NULL;
								GString* _tmp44_ = NULL;
								_tmp37_ = current;
								_tmp38_ = _tmp37_->str;
								_tmp39_ = source_reference;
								_tmp40_ = vala_gidl_parser_parse_type_from_string (self, _tmp38_, TRUE, _tmp39_);
								dt = _tmp40_;
								_tmp41_ = dt;
								if (_tmp41_ == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								_tmp42_ = parent_type;
								_tmp43_ = dt;
								vala_data_type_add_type_argument (_tmp42_, _tmp43_);
								_tmp44_ = current;
								g_string_truncate (_tmp44_, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								GString* _tmp45_ = NULL;
								const gchar* _tmp46_ = NULL;
								gint _tmp47_ = 0;
								gchar _tmp48_ = '\0';
								_tmp45_ = current;
								_tmp46_ = type_arguments;
								_tmp47_ = c;
								_tmp48_ = string_get (_tmp46_, (glong) _tmp47_);
								g_string_append_unichar (_tmp45_, (gunichar) _tmp48_);
							}
						} else {
							GString* _tmp49_ = NULL;
							const gchar* _tmp50_ = NULL;
							gint _tmp51_ = 0;
							gchar _tmp52_ = '\0';
							_tmp49_ = current;
							_tmp50_ = type_arguments;
							_tmp51_ = c;
							_tmp52_ = string_get (_tmp50_, (glong) _tmp51_);
							g_string_append_unichar (_tmp49_, (gunichar) _tmp52_);
						}
					}
				}
			}
		}
	}
	_tmp53_ = current;
	_tmp54_ = _tmp53_->str;
	_tmp55_ = source_reference;
	_tmp56_ = vala_gidl_parser_parse_type_from_string (self, _tmp54_, TRUE, _tmp55_);
	dt = _tmp56_;
	_tmp57_ = dt;
	if (_tmp57_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	_tmp58_ = parent_type;
	_tmp59_ = dt;
	vala_data_type_add_type_argument (_tmp58_, _tmp59_);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}


static ValaDataType* vala_gidl_parser_parse_type_from_string (ValaGIdlParser* self, const gchar* type_string, gboolean owned_by_default, ValaSourceReference* source_reference) {
	ValaDataType* result = NULL;
	GRegex* _tmp0_ = NULL;
	GMatchInfo* match = NULL;
	GRegex* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GMatchInfo* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	ValaDataType* type = NULL;
	gchar* ownership_data = NULL;
	GMatchInfo* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* type_name = NULL;
	GMatchInfo* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* type_arguments_data = NULL;
	GMatchInfo* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* pointers_data = NULL;
	GMatchInfo* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* array_data = NULL;
	GMatchInfo* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* array_dimension_data = NULL;
	GMatchInfo* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* nullable_data = NULL;
	GMatchInfo* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	const gchar* _tmp25_ = NULL;
	gboolean nullable = FALSE;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_ = NULL;
	gboolean value_owned = FALSE;
	gboolean _tmp47_ = FALSE;
	const gchar* _tmp48_ = NULL;
	ValaUnresolvedSymbol* sym = NULL;
	const gchar* _tmp50_ = NULL;
	ValaSourceReference* _tmp51_ = NULL;
	ValaUnresolvedSymbol* _tmp52_ = NULL;
	ValaUnresolvedSymbol* _tmp53_ = NULL;
	ValaUnresolvedSymbol* _tmp54_ = NULL;
	ValaSourceReference* _tmp55_ = NULL;
	ValaUnresolvedType* _tmp56_ = NULL;
	gboolean _tmp57_ = FALSE;
	const gchar* _tmp58_ = NULL;
	const gchar* _tmp66_ = NULL;
	gboolean _tmp75_ = FALSE;
	const gchar* _tmp76_ = NULL;
	ValaDataType* _tmp87_ = NULL;
	gboolean _tmp88_ = FALSE;
	ValaDataType* _tmp89_ = NULL;
	gboolean _tmp90_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	_tmp0_ = vala_gidl_parser_type_from_string_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_ = NULL;
			GRegex* _tmp3_ = NULL;
			_tmp2_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[(," \
"*)?\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch2_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_gidl_parser_type_from_string_regex);
			vala_gidl_parser_type_from_string_regex = _tmp3_;
			_g_regex_unref0 (_tmp1_);
		}
		goto __finally2;
		__catch2_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = e->message;
			g_error ("valagidlparser.vala:2131: Unable to compile regex: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp5_ = vala_gidl_parser_type_from_string_regex;
	_tmp6_ = type_string;
	_tmp8_ = g_regex_match (_tmp5_, _tmp6_, 0, &_tmp7_);
	_g_match_info_unref0 (match);
	match = _tmp7_;
	if (!_tmp8_) {
		ValaSourceReference* _tmp9_ = NULL;
		_tmp9_ = source_reference;
		vala_report_error (_tmp9_, "unable to parse type");
		result = NULL;
		_g_match_info_unref0 (match);
		return result;
	}
	type = NULL;
	_tmp10_ = match;
	_tmp11_ = g_match_info_fetch (_tmp10_, 1);
	ownership_data = _tmp11_;
	_tmp12_ = match;
	_tmp13_ = g_match_info_fetch (_tmp12_, 2);
	type_name = _tmp13_;
	_tmp14_ = match;
	_tmp15_ = g_match_info_fetch (_tmp14_, 3);
	type_arguments_data = _tmp15_;
	_tmp16_ = match;
	_tmp17_ = g_match_info_fetch (_tmp16_, 4);
	pointers_data = _tmp17_;
	_tmp18_ = match;
	_tmp19_ = g_match_info_fetch (_tmp18_, 5);
	array_data = _tmp19_;
	_tmp20_ = match;
	_tmp21_ = g_match_info_fetch (_tmp20_, 6);
	array_dimension_data = _tmp21_;
	_tmp22_ = match;
	_tmp23_ = g_match_info_fetch (_tmp22_, 7);
	nullable_data = _tmp23_;
	_tmp25_ = nullable_data;
	if (_tmp25_ != NULL) {
		const gchar* _tmp26_ = NULL;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		_tmp26_ = nullable_data;
		_tmp27_ = strlen (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp24_ = _tmp28_ > 0;
	} else {
		_tmp24_ = FALSE;
	}
	nullable = _tmp24_;
	_tmp30_ = ownership_data;
	if (_tmp30_ == NULL) {
		const gchar* _tmp31_ = NULL;
		_tmp31_ = type_name;
		_tmp29_ = g_strcmp0 (_tmp31_, "void") == 0;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		gboolean _tmp32_ = FALSE;
		const gchar* _tmp33_ = NULL;
		_tmp33_ = array_data;
		if (_tmp33_ == NULL) {
			gboolean _tmp34_ = FALSE;
			_tmp34_ = nullable;
			_tmp32_ = !_tmp34_;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaSourceReference* _tmp35_ = NULL;
			ValaVoidType* _tmp36_ = NULL;
			const gchar* _tmp37_ = NULL;
			_tmp35_ = source_reference;
			_tmp36_ = vala_void_type_new (_tmp35_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp36_;
			_tmp37_ = pointers_data;
			if (_tmp37_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp38_ = FALSE;
						_tmp38_ = TRUE;
						while (TRUE) {
							gint _tmp40_ = 0;
							const gchar* _tmp41_ = NULL;
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							ValaDataType* _tmp44_ = NULL;
							ValaPointerType* _tmp45_ = NULL;
							if (!_tmp38_) {
								gint _tmp39_ = 0;
								_tmp39_ = i;
								i = _tmp39_ + 1;
							}
							_tmp38_ = FALSE;
							_tmp40_ = i;
							_tmp41_ = pointers_data;
							_tmp42_ = strlen (_tmp41_);
							_tmp43_ = _tmp42_;
							if (!(_tmp40_ < _tmp43_)) {
								break;
							}
							_tmp44_ = type;
							_tmp45_ = vala_pointer_type_new (_tmp44_, NULL);
							_vala_code_node_unref0 (type);
							type = (ValaDataType*) _tmp45_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_unref0 (match);
			return result;
		} else {
			ValaSourceReference* _tmp46_ = NULL;
			_tmp46_ = source_reference;
			vala_report_error (_tmp46_, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	_tmp47_ = owned_by_default;
	value_owned = _tmp47_;
	_tmp48_ = ownership_data;
	if (g_strcmp0 (_tmp48_, "owned") == 0) {
		value_owned = TRUE;
	} else {
		const gchar* _tmp49_ = NULL;
		_tmp49_ = ownership_data;
		if (g_strcmp0 (_tmp49_, "unowned") == 0) {
			value_owned = FALSE;
		}
	}
	_tmp50_ = type_name;
	_tmp51_ = source_reference;
	_tmp52_ = vala_gidl_parser_parse_symbol_from_string (self, _tmp50_, _tmp51_);
	sym = _tmp52_;
	_tmp53_ = sym;
	if (_tmp53_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_dimension_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_unref0 (match);
		return result;
	}
	_tmp54_ = sym;
	_tmp55_ = source_reference;
	_tmp56_ = vala_unresolved_type_new_from_symbol (_tmp54_, _tmp55_);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp56_;
	_tmp58_ = type_arguments_data;
	if (_tmp58_ != NULL) {
		const gchar* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		gint _tmp61_ = 0;
		_tmp59_ = type_arguments_data;
		_tmp60_ = strlen (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp57_ = _tmp61_ > 0;
	} else {
		_tmp57_ = FALSE;
	}
	if (_tmp57_) {
		ValaDataType* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		ValaSourceReference* _tmp64_ = NULL;
		gboolean _tmp65_ = FALSE;
		_tmp62_ = type;
		_tmp63_ = type_arguments_data;
		_tmp64_ = source_reference;
		_tmp65_ = vala_gidl_parser_parse_type_arguments_from_string (self, _tmp62_, _tmp63_, _tmp64_);
		if (!_tmp65_) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_dimension_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	_tmp66_ = pointers_data;
	if (_tmp66_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp67_ = FALSE;
				_tmp67_ = TRUE;
				while (TRUE) {
					gint _tmp69_ = 0;
					const gchar* _tmp70_ = NULL;
					gint _tmp71_ = 0;
					gint _tmp72_ = 0;
					ValaDataType* _tmp73_ = NULL;
					ValaPointerType* _tmp74_ = NULL;
					if (!_tmp67_) {
						gint _tmp68_ = 0;
						_tmp68_ = i;
						i = _tmp68_ + 1;
					}
					_tmp67_ = FALSE;
					_tmp69_ = i;
					_tmp70_ = pointers_data;
					_tmp71_ = strlen (_tmp70_);
					_tmp72_ = _tmp71_;
					if (!(_tmp69_ < _tmp72_)) {
						break;
					}
					_tmp73_ = type;
					_tmp74_ = vala_pointer_type_new (_tmp73_, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp74_;
				}
			}
		}
	}
	_tmp76_ = array_data;
	if (_tmp76_ != NULL) {
		const gchar* _tmp77_ = NULL;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		_tmp77_ = array_data;
		_tmp78_ = strlen (_tmp77_);
		_tmp79_ = _tmp78_;
		_tmp75_ = _tmp79_ > 0;
	} else {
		_tmp75_ = FALSE;
	}
	if (_tmp75_) {
		ValaDataType* _tmp80_ = NULL;
		ValaDataType* _tmp81_ = NULL;
		const gchar* _tmp82_ = NULL;
		gint _tmp83_ = 0;
		gint _tmp84_ = 0;
		ValaSourceReference* _tmp85_ = NULL;
		ValaArrayType* _tmp86_ = NULL;
		_tmp80_ = type;
		vala_data_type_set_value_owned (_tmp80_, TRUE);
		_tmp81_ = type;
		_tmp82_ = array_dimension_data;
		_tmp83_ = strlen (_tmp82_);
		_tmp84_ = _tmp83_;
		_tmp85_ = source_reference;
		_tmp86_ = vala_array_type_new (_tmp81_, _tmp84_ + 1, _tmp85_);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp86_;
	}
	_tmp87_ = type;
	_tmp88_ = nullable;
	vala_data_type_set_nullable (_tmp87_, _tmp88_);
	_tmp89_ = type;
	_tmp90_ = value_owned;
	vala_data_type_set_value_owned (_tmp89_, _tmp90_);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_dimension_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_unref0 (match);
	return result;
}


static gboolean int64_try_parse (const gchar* str, gint64* _result_) {
	gint64 _vala_result = 0LL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtoll (_tmp0_, &_tmp1_, (guint) 0);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static gboolean double_try_parse (const gchar* str, gdouble* _result_) {
	gdouble _vala_result = 0.0;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gdouble _tmp2_ = 0.0;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp0_ = str;
	_tmp2_ = g_ascii_strtod (_tmp0_, &_tmp1_);
	endptr = _tmp1_;
	_vala_result = _tmp2_;
	_tmp3_ = endptr;
	_tmp4_ = str;
	_tmp5_ = str;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp3_ == (((gchar*) _tmp4_) + _tmp7_)) {
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	} else {
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
}


static ValaMethod* vala_gidl_parser_create_method (ValaGIdlParser* self, const gchar* name, const gchar* symbol, GIdlNodeParam* res, GList* parameters, gboolean is_constructor, gboolean is_interface) {
	ValaMethod* result = NULL;
	ValaDataType* return_type = NULL;
	GIdlNodeParam* _tmp0_ = NULL;
	ValaMethod* m = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	ValaMethod* _tmp49_ = NULL;
	ValaSet* _tmp50_ = NULL;
	ValaTypeSymbol* _tmp53_ = NULL;
	gboolean add_ellipsis = FALSE;
	gboolean suppress_throws = FALSE;
	gchar* error_types = NULL;
	ValaSymbol* container = NULL;
	gchar** attributes = NULL;
	const gchar* _tmp76_ = NULL;
	gint _tmp77_ = 0;
	gchar** _tmp78_ = NULL;
	gint attributes_length1 = 0;
	gint _attributes_size_ = 0;
	gchar** _tmp79_ = NULL;
	gint _tmp79__length1 = 0;
	gboolean first = FALSE;
	ValaParameter* last_param = NULL;
	ValaDataType* last_param_type = NULL;
	GList* _tmp373_ = NULL;
	gboolean _tmp792_ = FALSE;
	gboolean _tmp793_ = FALSE;
	gboolean _tmp807_ = FALSE;
	gboolean _tmp809_ = FALSE;
	ValaParameter* _tmp810_ = NULL;
	ValaSymbol* _tmp820_ = NULL;
	const gchar* _tmp826_ = NULL;
	ValaMethod* _tmp827_ = NULL;
	ValaSymbol* _tmp828_ = NULL;
	gchar* _tmp829_ = NULL;
	gchar* _tmp830_ = NULL;
	gboolean _tmp831_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (symbol != NULL, NULL);
	return_type = NULL;
	_tmp0_ = res;
	if (_tmp0_ != NULL) {
		GIdlNodeParam* _tmp1_ = NULL;
		ValaDataType* _tmp2_ = NULL;
		_tmp1_ = res;
		_tmp2_ = vala_gidl_parser_parse_param (self, _tmp1_, NULL);
		_vala_code_node_unref0 (return_type);
		return_type = _tmp2_;
	}
	_tmp4_ = is_interface;
	if (!_tmp4_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp6_ = is_constructor;
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			const gchar* _tmp7_ = NULL;
			gboolean _tmp8_ = FALSE;
			_tmp7_ = name;
			_tmp8_ = g_str_has_prefix (_tmp7_, "new");
			_tmp5_ = _tmp8_;
		}
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		const gchar* _tmp9_ = NULL;
		ValaSourceReference* _tmp10_ = NULL;
		ValaCreationMethod* _tmp11_ = NULL;
		ValaMethod* _tmp12_ = NULL;
		ValaMethod* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		gboolean _tmp29_ = FALSE;
		ValaTypeSymbol* _tmp30_ = NULL;
		_tmp9_ = name;
		_tmp10_ = self->priv->current_source_reference;
		_tmp11_ = vala_creation_method_new (NULL, _tmp9_, _tmp10_, NULL);
		_vala_code_node_unref0 (m);
		m = (ValaMethod*) _tmp11_;
		_tmp12_ = m;
		vala_method_set_has_construct_function (_tmp12_, FALSE);
		_tmp13_ = m;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
		_tmp15_ = _tmp14_;
		if (g_strcmp0 (_tmp15_, "new") == 0) {
			ValaMethod* _tmp16_ = NULL;
			_tmp16_ = m;
			vala_symbol_set_name ((ValaSymbol*) _tmp16_, NULL);
		} else {
			ValaMethod* _tmp17_ = NULL;
			const gchar* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			_tmp17_ = m;
			_tmp18_ = vala_symbol_get_name ((ValaSymbol*) _tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_str_has_prefix (_tmp19_, "new_");
			if (_tmp20_) {
				ValaMethod* _tmp21_ = NULL;
				ValaMethod* _tmp22_ = NULL;
				const gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gint _tmp25_ = 0;
				gint _tmp26_ = 0;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_ = NULL;
				_tmp21_ = m;
				_tmp22_ = m;
				_tmp23_ = vala_symbol_get_name ((ValaSymbol*) _tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = strlen ("new_");
				_tmp26_ = _tmp25_;
				_tmp27_ = string_substring (_tmp24_, (glong) _tmp26_, (glong) -1);
				_tmp28_ = _tmp27_;
				vala_symbol_set_name ((ValaSymbol*) _tmp21_, _tmp28_);
				_g_free0 (_tmp28_);
			}
		}
		_tmp30_ = self->priv->current_data_type;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp30_, VALA_TYPE_CLASS)) {
			GIdlNodeParam* _tmp31_ = NULL;
			_tmp31_ = res;
			_tmp29_ = _tmp31_ != NULL;
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			ValaTypeSymbol* _tmp32_ = NULL;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_ = NULL;
			GIdlNodeParam* _tmp37_ = NULL;
			GIdlNodeType* _tmp38_ = NULL;
			const gchar* _tmp39_ = NULL;
			gboolean _tmp40_ = FALSE;
			_tmp32_ = self->priv->current_data_type;
			_tmp33_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp32_, NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strdup_printf ("%s*", _tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = res;
			_tmp38_ = _tmp37_->type;
			_tmp39_ = _tmp38_->unparsed;
			_tmp40_ = g_strcmp0 (_tmp36_, _tmp39_) != 0;
			_g_free0 (_tmp36_);
			_g_free0 (_tmp34_);
			if (_tmp40_) {
				ValaMethod* _tmp41_ = NULL;
				GIdlNodeParam* _tmp42_ = NULL;
				GIdlNodeType* _tmp43_ = NULL;
				const gchar* _tmp44_ = NULL;
				_tmp41_ = m;
				_tmp42_ = res;
				_tmp43_ = _tmp42_->type;
				_tmp44_ = _tmp43_->unparsed;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp41_, "CCode", "type", _tmp44_, NULL);
			}
		}
	} else {
		const gchar* _tmp45_ = NULL;
		ValaDataType* _tmp46_ = NULL;
		ValaSourceReference* _tmp47_ = NULL;
		ValaMethod* _tmp48_ = NULL;
		_tmp45_ = name;
		_tmp46_ = return_type;
		_tmp47_ = self->priv->current_source_reference;
		_tmp48_ = vala_method_new (_tmp45_, _tmp46_, _tmp47_, NULL);
		_vala_code_node_unref0 (m);
		m = _tmp48_;
	}
	_tmp49_ = m;
	vala_symbol_set_access ((ValaSymbol*) _tmp49_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp50_ = self->priv->current_type_symbol_set;
	if (_tmp50_ != NULL) {
		ValaSet* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		_tmp51_ = self->priv->current_type_symbol_set;
		_tmp52_ = name;
		vala_collection_add ((ValaCollection*) _tmp51_, _tmp52_);
	}
	_tmp53_ = self->priv->current_data_type;
	if (_tmp53_ != NULL) {
		gchar** sig_attributes = NULL;
		ValaTypeSymbol* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		const gchar* _tmp57_ = NULL;
		gchar* _tmp58_ = NULL;
		gchar* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		gchar** _tmp61_ = NULL;
		gchar** _tmp62_ = NULL;
		gint _tmp62__length1 = 0;
		gint sig_attributes_length1 = 0;
		gint _sig_attributes_size_ = 0;
		gchar** _tmp63_ = NULL;
		gint _tmp63__length1 = 0;
		_tmp54_ = self->priv->current_data_type;
		_tmp55_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp54_, NULL);
		_tmp56_ = _tmp55_;
		_tmp57_ = name;
		_tmp58_ = g_strdup_printf ("%s::%s", _tmp56_, _tmp57_);
		_tmp59_ = _tmp58_;
		_tmp61_ = vala_gidl_parser_get_attributes (self, _tmp59_, &_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp62__length1 = _tmp60_;
		_g_free0 (_tmp59_);
		_g_free0 (_tmp56_);
		sig_attributes = _tmp62_;
		sig_attributes_length1 = _tmp62__length1;
		_sig_attributes_size_ = sig_attributes_length1;
		_tmp63_ = sig_attributes;
		_tmp63__length1 = sig_attributes_length1;
		if (_tmp63_ != NULL) {
			gchar** _tmp64_ = NULL;
			gint _tmp64__length1 = 0;
			_tmp64_ = sig_attributes;
			_tmp64__length1 = sig_attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp64_;
				attr_collection_length1 = _tmp64__length1;
				for (attr_it = 0; attr_it < _tmp64__length1; attr_it = attr_it + 1) {
					gchar* _tmp65_ = NULL;
					gchar* attr = NULL;
					_tmp65_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp65_;
					{
						gchar** nv = NULL;
						const gchar* _tmp66_ = NULL;
						gchar** _tmp67_ = NULL;
						gchar** _tmp68_ = NULL;
						gint nv_length1 = 0;
						gint _nv_size_ = 0;
						gboolean _tmp69_ = FALSE;
						gchar** _tmp70_ = NULL;
						gint _tmp70__length1 = 0;
						const gchar* _tmp71_ = NULL;
						_tmp66_ = attr;
						_tmp68_ = _tmp67_ = g_strsplit (_tmp66_, "=", 2);
						nv = _tmp68_;
						nv_length1 = _vala_array_length (_tmp67_);
						_nv_size_ = nv_length1;
						_tmp70_ = nv;
						_tmp70__length1 = nv_length1;
						_tmp71_ = _tmp70_[0];
						if (g_strcmp0 (_tmp71_, "has_emitter") == 0) {
							gchar** _tmp72_ = NULL;
							gint _tmp72__length1 = 0;
							const gchar* _tmp73_ = NULL;
							gchar* _tmp74_ = NULL;
							gchar* _tmp75_ = NULL;
							_tmp72_ = nv;
							_tmp72__length1 = nv_length1;
							_tmp73_ = _tmp72_[1];
							_tmp74_ = vala_gidl_parser_eval (self, _tmp73_);
							_tmp75_ = _tmp74_;
							_tmp69_ = g_strcmp0 (_tmp75_, "1") == 0;
							_g_free0 (_tmp75_);
						} else {
							_tmp69_ = FALSE;
						}
						if (_tmp69_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (m);
							_vala_code_node_unref0 (return_type);
							return result;
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		sig_attributes = (_vala_array_free (sig_attributes, sig_attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	add_ellipsis = FALSE;
	suppress_throws = FALSE;
	error_types = NULL;
	container = NULL;
	_tmp76_ = symbol;
	_tmp78_ = vala_gidl_parser_get_attributes (self, _tmp76_, &_tmp77_);
	attributes = _tmp78_;
	attributes_length1 = _tmp77_;
	_attributes_size_ = attributes_length1;
	_tmp79_ = attributes;
	_tmp79__length1 = attributes_length1;
	if (_tmp79_ != NULL) {
		gchar** _tmp80_ = NULL;
		gint _tmp80__length1 = 0;
		_tmp80_ = attributes;
		_tmp80__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp80_;
			attr_collection_length1 = _tmp80__length1;
			for (attr_it = 0; attr_it < _tmp80__length1; attr_it = attr_it + 1) {
				gchar* _tmp81_ = NULL;
				gchar* attr = NULL;
				_tmp81_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp81_;
				{
					gchar** nv = NULL;
					const gchar* _tmp82_ = NULL;
					gchar** _tmp83_ = NULL;
					gchar** _tmp84_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gchar** _tmp85_ = NULL;
					gint _tmp85__length1 = 0;
					const gchar* _tmp86_ = NULL;
					_tmp82_ = attr;
					_tmp84_ = _tmp83_ = g_strsplit (_tmp82_, "=", 2);
					nv = _tmp84_;
					nv_length1 = _vala_array_length (_tmp83_);
					_nv_size_ = nv_length1;
					_tmp85_ = nv;
					_tmp85__length1 = nv_length1;
					_tmp86_ = _tmp85_[0];
					if (g_strcmp0 (_tmp86_, "name") == 0) {
						ValaMethod* _tmp87_ = NULL;
						gchar** _tmp88_ = NULL;
						gint _tmp88__length1 = 0;
						const gchar* _tmp89_ = NULL;
						gchar* _tmp90_ = NULL;
						gchar* _tmp91_ = NULL;
						_tmp87_ = m;
						_tmp88_ = nv;
						_tmp88__length1 = nv_length1;
						_tmp89_ = _tmp88_[1];
						_tmp90_ = vala_gidl_parser_eval (self, _tmp89_);
						_tmp91_ = _tmp90_;
						vala_symbol_set_name ((ValaSymbol*) _tmp87_, _tmp91_);
						_g_free0 (_tmp91_);
					} else {
						gchar** _tmp92_ = NULL;
						gint _tmp92__length1 = 0;
						const gchar* _tmp93_ = NULL;
						_tmp92_ = nv;
						_tmp92__length1 = nv_length1;
						_tmp93_ = _tmp92_[0];
						if (g_strcmp0 (_tmp93_, "hidden") == 0) {
							gchar** _tmp94_ = NULL;
							gint _tmp94__length1 = 0;
							const gchar* _tmp95_ = NULL;
							gchar* _tmp96_ = NULL;
							gchar* _tmp97_ = NULL;
							gboolean _tmp98_ = FALSE;
							_tmp94_ = nv;
							_tmp94__length1 = nv_length1;
							_tmp95_ = _tmp94_[1];
							_tmp96_ = vala_gidl_parser_eval (self, _tmp95_);
							_tmp97_ = _tmp96_;
							_tmp98_ = g_strcmp0 (_tmp97_, "1") == 0;
							_g_free0 (_tmp97_);
							if (_tmp98_) {
								result = NULL;
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
								attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
								_vala_code_node_unref0 (container);
								_g_free0 (error_types);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (return_type);
								return result;
							}
						} else {
							gchar** _tmp99_ = NULL;
							gint _tmp99__length1 = 0;
							const gchar* _tmp100_ = NULL;
							_tmp99_ = nv;
							_tmp99__length1 = nv_length1;
							_tmp100_ = _tmp99_[0];
							if (g_strcmp0 (_tmp100_, "ellipsis") == 0) {
								gchar** _tmp101_ = NULL;
								gint _tmp101__length1 = 0;
								const gchar* _tmp102_ = NULL;
								gchar* _tmp103_ = NULL;
								gchar* _tmp104_ = NULL;
								gboolean _tmp105_ = FALSE;
								_tmp101_ = nv;
								_tmp101__length1 = nv_length1;
								_tmp102_ = _tmp101_[1];
								_tmp103_ = vala_gidl_parser_eval (self, _tmp102_);
								_tmp104_ = _tmp103_;
								_tmp105_ = g_strcmp0 (_tmp104_, "1") == 0;
								_g_free0 (_tmp104_);
								if (_tmp105_) {
									add_ellipsis = TRUE;
								}
							} else {
								gchar** _tmp106_ = NULL;
								gint _tmp106__length1 = 0;
								const gchar* _tmp107_ = NULL;
								_tmp106_ = nv;
								_tmp106__length1 = nv_length1;
								_tmp107_ = _tmp106_[0];
								if (g_strcmp0 (_tmp107_, "printf_format") == 0) {
									gchar** _tmp108_ = NULL;
									gint _tmp108__length1 = 0;
									const gchar* _tmp109_ = NULL;
									gchar* _tmp110_ = NULL;
									gchar* _tmp111_ = NULL;
									gboolean _tmp112_ = FALSE;
									_tmp108_ = nv;
									_tmp108__length1 = nv_length1;
									_tmp109_ = _tmp108_[1];
									_tmp110_ = vala_gidl_parser_eval (self, _tmp109_);
									_tmp111_ = _tmp110_;
									_tmp112_ = g_strcmp0 (_tmp111_, "1") == 0;
									_g_free0 (_tmp111_);
									if (_tmp112_) {
										ValaMethod* _tmp113_ = NULL;
										_tmp113_ = m;
										vala_code_node_set_attribute ((ValaCodeNode*) _tmp113_, "PrintfFormat", TRUE, NULL);
									}
								} else {
									gchar** _tmp114_ = NULL;
									gint _tmp114__length1 = 0;
									const gchar* _tmp115_ = NULL;
									_tmp114_ = nv;
									_tmp114__length1 = nv_length1;
									_tmp115_ = _tmp114_[0];
									if (g_strcmp0 (_tmp115_, "transfer_ownership") == 0) {
										gchar** _tmp116_ = NULL;
										gint _tmp116__length1 = 0;
										const gchar* _tmp117_ = NULL;
										gchar* _tmp118_ = NULL;
										gchar* _tmp119_ = NULL;
										gboolean _tmp120_ = FALSE;
										_tmp116_ = nv;
										_tmp116__length1 = nv_length1;
										_tmp117_ = _tmp116_[1];
										_tmp118_ = vala_gidl_parser_eval (self, _tmp117_);
										_tmp119_ = _tmp118_;
										_tmp120_ = g_strcmp0 (_tmp119_, "1") == 0;
										_g_free0 (_tmp119_);
										if (_tmp120_) {
											ValaDataType* _tmp121_ = NULL;
											_tmp121_ = return_type;
											vala_data_type_set_value_owned (_tmp121_, TRUE);
										}
									} else {
										gchar** _tmp122_ = NULL;
										gint _tmp122__length1 = 0;
										const gchar* _tmp123_ = NULL;
										_tmp122_ = nv;
										_tmp122__length1 = nv_length1;
										_tmp123_ = _tmp122_[0];
										if (g_strcmp0 (_tmp123_, "transfer_container") == 0) {
											gchar** _tmp124_ = NULL;
											gint _tmp124__length1 = 0;
											const gchar* _tmp125_ = NULL;
											gchar* _tmp126_ = NULL;
											gchar* _tmp127_ = NULL;
											gboolean _tmp128_ = FALSE;
											_tmp124_ = nv;
											_tmp124__length1 = nv_length1;
											_tmp125_ = _tmp124_[1];
											_tmp126_ = vala_gidl_parser_eval (self, _tmp125_);
											_tmp127_ = _tmp126_;
											_tmp128_ = g_strcmp0 (_tmp127_, "1") == 0;
											_g_free0 (_tmp127_);
											if (_tmp128_) {
												ValaDataType* _tmp129_ = NULL;
												ValaDataType* _tmp130_ = NULL;
												_tmp129_ = return_type;
												vala_data_type_set_value_owned (_tmp129_, TRUE);
												_tmp130_ = return_type;
												if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp130_, VALA_TYPE_ARRAY_TYPE)) {
													ValaDataType* _tmp131_ = NULL;
													ValaDataType* _tmp132_ = NULL;
													ValaDataType* _tmp133_ = NULL;
													_tmp131_ = return_type;
													_tmp132_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp131_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
													_tmp133_ = _tmp132_;
													vala_data_type_set_value_owned (_tmp133_, FALSE);
												}
											}
										} else {
											gchar** _tmp134_ = NULL;
											gint _tmp134__length1 = 0;
											const gchar* _tmp135_ = NULL;
											_tmp134_ = nv;
											_tmp134__length1 = nv_length1;
											_tmp135_ = _tmp134_[0];
											if (g_strcmp0 (_tmp135_, "destroys_instance") == 0) {
												gchar** _tmp136_ = NULL;
												gint _tmp136__length1 = 0;
												const gchar* _tmp137_ = NULL;
												gchar* _tmp138_ = NULL;
												gchar* _tmp139_ = NULL;
												gboolean _tmp140_ = FALSE;
												_tmp136_ = nv;
												_tmp136__length1 = nv_length1;
												_tmp137_ = _tmp136_[1];
												_tmp138_ = vala_gidl_parser_eval (self, _tmp137_);
												_tmp139_ = _tmp138_;
												_tmp140_ = g_strcmp0 (_tmp139_, "1") == 0;
												_g_free0 (_tmp139_);
												if (_tmp140_) {
													ValaMethod* _tmp141_ = NULL;
													ValaMethod* _tmp142_ = NULL;
													ValaSourceReference* _tmp143_ = NULL;
													ValaSourceReference* _tmp144_ = NULL;
													_tmp141_ = m;
													_tmp142_ = m;
													_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp142_);
													_tmp144_ = _tmp143_;
													vala_code_node_set_attribute ((ValaCodeNode*) _tmp141_, "DestroysInstance", TRUE, _tmp144_);
												}
											} else {
												gchar** _tmp145_ = NULL;
												gint _tmp145__length1 = 0;
												const gchar* _tmp146_ = NULL;
												_tmp145_ = nv;
												_tmp145__length1 = nv_length1;
												_tmp146_ = _tmp145_[0];
												if (g_strcmp0 (_tmp146_, "returns_floating_reference") == 0) {
													gchar** _tmp147_ = NULL;
													gint _tmp147__length1 = 0;
													const gchar* _tmp148_ = NULL;
													gchar* _tmp149_ = NULL;
													gchar* _tmp150_ = NULL;
													gboolean _tmp151_ = FALSE;
													_tmp147_ = nv;
													_tmp147__length1 = nv_length1;
													_tmp148_ = _tmp147_[1];
													_tmp149_ = vala_gidl_parser_eval (self, _tmp148_);
													_tmp150_ = _tmp149_;
													_tmp151_ = g_strcmp0 (_tmp150_, "1") == 0;
													_g_free0 (_tmp150_);
													if (_tmp151_) {
														ValaMethod* _tmp152_ = NULL;
														ValaMethod* _tmp153_ = NULL;
														ValaDataType* _tmp154_ = NULL;
														ValaDataType* _tmp155_ = NULL;
														_tmp152_ = m;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp152_, "CCode", "returns_floating_reference", TRUE, NULL);
														_tmp153_ = m;
														_tmp154_ = vala_method_get_return_type (_tmp153_);
														_tmp155_ = _tmp154_;
														vala_data_type_set_value_owned (_tmp155_, TRUE);
													}
												} else {
													gchar** _tmp156_ = NULL;
													gint _tmp156__length1 = 0;
													const gchar* _tmp157_ = NULL;
													_tmp156_ = nv;
													_tmp156__length1 = nv_length1;
													_tmp157_ = _tmp156_[0];
													if (g_strcmp0 (_tmp157_, "nullable") == 0) {
														gboolean _tmp158_ = FALSE;
														gchar** _tmp159_ = NULL;
														gint _tmp159__length1 = 0;
														const gchar* _tmp160_ = NULL;
														gchar* _tmp161_ = NULL;
														gchar* _tmp162_ = NULL;
														gboolean _tmp163_ = FALSE;
														_tmp159_ = nv;
														_tmp159__length1 = nv_length1;
														_tmp160_ = _tmp159_[1];
														_tmp161_ = vala_gidl_parser_eval (self, _tmp160_);
														_tmp162_ = _tmp161_;
														_tmp163_ = g_strcmp0 (_tmp162_, "1") == 0;
														_g_free0 (_tmp162_);
														if (_tmp163_) {
															ValaDataType* _tmp164_ = NULL;
															_tmp164_ = return_type;
															_tmp158_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp164_, VALA_TYPE_VOID_TYPE);
														} else {
															_tmp158_ = FALSE;
														}
														if (_tmp158_) {
															ValaDataType* _tmp165_ = NULL;
															_tmp165_ = return_type;
															vala_data_type_set_nullable (_tmp165_, TRUE);
														}
													} else {
														gchar** _tmp166_ = NULL;
														gint _tmp166__length1 = 0;
														const gchar* _tmp167_ = NULL;
														_tmp166_ = nv;
														_tmp166__length1 = nv_length1;
														_tmp167_ = _tmp166_[0];
														if (g_strcmp0 (_tmp167_, "sentinel") == 0) {
															ValaMethod* _tmp168_ = NULL;
															gchar** _tmp169_ = NULL;
															gint _tmp169__length1 = 0;
															const gchar* _tmp170_ = NULL;
															gchar* _tmp171_ = NULL;
															gchar* _tmp172_ = NULL;
															_tmp168_ = m;
															_tmp169_ = nv;
															_tmp169__length1 = nv_length1;
															_tmp170_ = _tmp169_[1];
															_tmp171_ = vala_gidl_parser_eval (self, _tmp170_);
															_tmp172_ = _tmp171_;
															vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp168_, "CCode", "sentinel", _tmp172_, NULL);
															_g_free0 (_tmp172_);
														} else {
															gchar** _tmp173_ = NULL;
															gint _tmp173__length1 = 0;
															const gchar* _tmp174_ = NULL;
															_tmp173_ = nv;
															_tmp173__length1 = nv_length1;
															_tmp174_ = _tmp173_[0];
															if (g_strcmp0 (_tmp174_, "is_array") == 0) {
																gchar** _tmp175_ = NULL;
																gint _tmp175__length1 = 0;
																const gchar* _tmp176_ = NULL;
																gchar* _tmp177_ = NULL;
																gchar* _tmp178_ = NULL;
																gboolean _tmp179_ = FALSE;
																_tmp175_ = nv;
																_tmp175__length1 = nv_length1;
																_tmp176_ = _tmp175_[1];
																_tmp177_ = vala_gidl_parser_eval (self, _tmp176_);
																_tmp178_ = _tmp177_;
																_tmp179_ = g_strcmp0 (_tmp178_, "1") == 0;
																_g_free0 (_tmp178_);
																if (_tmp179_) {
																	ValaDataType* _tmp180_ = NULL;
																	ValaDataType* _tmp181_ = NULL;
																	ValaDataType* _tmp182_ = NULL;
																	ValaSourceReference* _tmp183_ = NULL;
																	ValaSourceReference* _tmp184_ = NULL;
																	ValaArrayType* _tmp185_ = NULL;
																	ValaMethod* _tmp186_ = NULL;
																	ValaDataType* _tmp187_ = NULL;
																	_tmp180_ = return_type;
																	vala_data_type_set_value_owned (_tmp180_, TRUE);
																	_tmp181_ = return_type;
																	_tmp182_ = return_type;
																	_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp182_);
																	_tmp184_ = _tmp183_;
																	_tmp185_ = vala_array_type_new (_tmp181_, 1, _tmp184_);
																	_vala_code_node_unref0 (return_type);
																	return_type = (ValaDataType*) _tmp185_;
																	_tmp186_ = m;
																	_tmp187_ = return_type;
																	vala_method_set_return_type (_tmp186_, _tmp187_);
																}
															} else {
																gchar** _tmp188_ = NULL;
																gint _tmp188__length1 = 0;
																const gchar* _tmp189_ = NULL;
																_tmp188_ = nv;
																_tmp188__length1 = nv_length1;
																_tmp189_ = _tmp188_[0];
																if (g_strcmp0 (_tmp189_, "is_pointer") == 0) {
																	gchar** _tmp190_ = NULL;
																	gint _tmp190__length1 = 0;
																	const gchar* _tmp191_ = NULL;
																	gchar* _tmp192_ = NULL;
																	gchar* _tmp193_ = NULL;
																	gboolean _tmp194_ = FALSE;
																	_tmp190_ = nv;
																	_tmp190__length1 = nv_length1;
																	_tmp191_ = _tmp190_[1];
																	_tmp192_ = vala_gidl_parser_eval (self, _tmp191_);
																	_tmp193_ = _tmp192_;
																	_tmp194_ = g_strcmp0 (_tmp193_, "1") == 0;
																	_g_free0 (_tmp193_);
																	if (_tmp194_) {
																		ValaDataType* _tmp195_ = NULL;
																		ValaDataType* _tmp196_ = NULL;
																		ValaSourceReference* _tmp197_ = NULL;
																		ValaSourceReference* _tmp198_ = NULL;
																		ValaPointerType* _tmp199_ = NULL;
																		ValaMethod* _tmp200_ = NULL;
																		ValaDataType* _tmp201_ = NULL;
																		_tmp195_ = return_type;
																		_tmp196_ = return_type;
																		_tmp197_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp196_);
																		_tmp198_ = _tmp197_;
																		_tmp199_ = vala_pointer_type_new (_tmp195_, _tmp198_);
																		_vala_code_node_unref0 (return_type);
																		return_type = (ValaDataType*) _tmp199_;
																		_tmp200_ = m;
																		_tmp201_ = return_type;
																		vala_method_set_return_type (_tmp200_, _tmp201_);
																	}
																} else {
																	gchar** _tmp202_ = NULL;
																	gint _tmp202__length1 = 0;
																	const gchar* _tmp203_ = NULL;
																	_tmp202_ = nv;
																	_tmp202__length1 = nv_length1;
																	_tmp203_ = _tmp202_[0];
																	if (g_strcmp0 (_tmp203_, "throws") == 0) {
																		gchar** _tmp204_ = NULL;
																		gint _tmp204__length1 = 0;
																		const gchar* _tmp205_ = NULL;
																		gchar* _tmp206_ = NULL;
																		gchar* _tmp207_ = NULL;
																		gboolean _tmp208_ = FALSE;
																		_tmp204_ = nv;
																		_tmp204__length1 = nv_length1;
																		_tmp205_ = _tmp204_[1];
																		_tmp206_ = vala_gidl_parser_eval (self, _tmp205_);
																		_tmp207_ = _tmp206_;
																		_tmp208_ = g_strcmp0 (_tmp207_, "0") == 0;
																		_g_free0 (_tmp207_);
																		if (_tmp208_) {
																			suppress_throws = TRUE;
																		}
																	} else {
																		gchar** _tmp209_ = NULL;
																		gint _tmp209__length1 = 0;
																		const gchar* _tmp210_ = NULL;
																		_tmp209_ = nv;
																		_tmp209__length1 = nv_length1;
																		_tmp210_ = _tmp209_[0];
																		if (g_strcmp0 (_tmp210_, "error_types") == 0) {
																			gchar** _tmp211_ = NULL;
																			gint _tmp211__length1 = 0;
																			const gchar* _tmp212_ = NULL;
																			gchar* _tmp213_ = NULL;
																			_tmp211_ = nv;
																			_tmp211__length1 = nv_length1;
																			_tmp212_ = _tmp211_[1];
																			_tmp213_ = vala_gidl_parser_eval (self, _tmp212_);
																			_g_free0 (error_types);
																			error_types = _tmp213_;
																		} else {
																			gchar** _tmp214_ = NULL;
																			gint _tmp214__length1 = 0;
																			const gchar* _tmp215_ = NULL;
																			_tmp214_ = nv;
																			_tmp214__length1 = nv_length1;
																			_tmp215_ = _tmp214_[0];
																			if (g_strcmp0 (_tmp215_, "no_array_length") == 0) {
																				gchar** _tmp216_ = NULL;
																				gint _tmp216__length1 = 0;
																				const gchar* _tmp217_ = NULL;
																				gchar* _tmp218_ = NULL;
																				gchar* _tmp219_ = NULL;
																				gboolean _tmp220_ = FALSE;
																				_tmp216_ = nv;
																				_tmp216__length1 = nv_length1;
																				_tmp217_ = _tmp216_[1];
																				_tmp218_ = vala_gidl_parser_eval (self, _tmp217_);
																				_tmp219_ = _tmp218_;
																				_tmp220_ = g_strcmp0 (_tmp219_, "1") == 0;
																				_g_free0 (_tmp219_);
																				if (_tmp220_) {
																					ValaMethod* _tmp221_ = NULL;
																					_tmp221_ = m;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp221_, "CCode", "array_length", FALSE, NULL);
																				}
																			} else {
																				gchar** _tmp222_ = NULL;
																				gint _tmp222__length1 = 0;
																				const gchar* _tmp223_ = NULL;
																				_tmp222_ = nv;
																				_tmp222__length1 = nv_length1;
																				_tmp223_ = _tmp222_[0];
																				if (g_strcmp0 (_tmp223_, "array_null_terminated") == 0) {
																					gchar** _tmp224_ = NULL;
																					gint _tmp224__length1 = 0;
																					const gchar* _tmp225_ = NULL;
																					gchar* _tmp226_ = NULL;
																					gchar* _tmp227_ = NULL;
																					gboolean _tmp228_ = FALSE;
																					_tmp224_ = nv;
																					_tmp224__length1 = nv_length1;
																					_tmp225_ = _tmp224_[1];
																					_tmp226_ = vala_gidl_parser_eval (self, _tmp225_);
																					_tmp227_ = _tmp226_;
																					_tmp228_ = g_strcmp0 (_tmp227_, "1") == 0;
																					_g_free0 (_tmp227_);
																					if (_tmp228_) {
																						ValaMethod* _tmp229_ = NULL;
																						ValaMethod* _tmp230_ = NULL;
																						_tmp229_ = m;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp229_, "CCode", "array_length", FALSE, NULL);
																						_tmp230_ = m;
																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp230_, "CCode", "array_null_terminated", TRUE, NULL);
																					}
																				} else {
																					gchar** _tmp231_ = NULL;
																					gint _tmp231__length1 = 0;
																					const gchar* _tmp232_ = NULL;
																					_tmp231_ = nv;
																					_tmp231__length1 = nv_length1;
																					_tmp232_ = _tmp231_[0];
																					if (g_strcmp0 (_tmp232_, "array_length_type") == 0) {
																						ValaMethod* _tmp233_ = NULL;
																						gchar** _tmp234_ = NULL;
																						gint _tmp234__length1 = 0;
																						const gchar* _tmp235_ = NULL;
																						gchar* _tmp236_ = NULL;
																						gchar* _tmp237_ = NULL;
																						_tmp233_ = m;
																						_tmp234_ = nv;
																						_tmp234__length1 = nv_length1;
																						_tmp235_ = _tmp234_[1];
																						_tmp236_ = vala_gidl_parser_eval (self, _tmp235_);
																						_tmp237_ = _tmp236_;
																						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp233_, "CCode", "array_length_type", _tmp237_, NULL);
																						_g_free0 (_tmp237_);
																					} else {
																						gchar** _tmp238_ = NULL;
																						gint _tmp238__length1 = 0;
																						const gchar* _tmp239_ = NULL;
																						_tmp238_ = nv;
																						_tmp238__length1 = nv_length1;
																						_tmp239_ = _tmp238_[0];
																						if (g_strcmp0 (_tmp239_, "type_name") == 0) {
																							ValaMethod* _tmp240_ = NULL;
																							gchar** _tmp241_ = NULL;
																							gint _tmp241__length1 = 0;
																							const gchar* _tmp242_ = NULL;
																							gchar* _tmp243_ = NULL;
																							gchar* _tmp244_ = NULL;
																							ValaDataType* _tmp245_ = NULL;
																							gboolean _tmp246_ = FALSE;
																							gboolean _tmp247_ = FALSE;
																							ValaDataType* _tmp248_ = NULL;
																							ValaDataType* _tmp249_ = NULL;
																							_tmp240_ = m;
																							_tmp241_ = nv;
																							_tmp241__length1 = nv_length1;
																							_tmp242_ = _tmp241_[1];
																							_tmp243_ = vala_gidl_parser_eval (self, _tmp242_);
																							_tmp244_ = _tmp243_;
																							_tmp245_ = return_type;
																							_tmp246_ = vala_data_type_get_value_owned (_tmp245_);
																							_tmp247_ = _tmp246_;
																							_tmp248_ = vala_gidl_parser_parse_type_from_string (self, _tmp244_, _tmp247_, NULL);
																							_vala_code_node_unref0 (return_type);
																							return_type = _tmp248_;
																							_tmp249_ = return_type;
																							vala_method_set_return_type (_tmp240_, _tmp249_);
																							_g_free0 (_tmp244_);
																						} else {
																							gchar** _tmp250_ = NULL;
																							gint _tmp250__length1 = 0;
																							const gchar* _tmp251_ = NULL;
																							_tmp250_ = nv;
																							_tmp250__length1 = nv_length1;
																							_tmp251_ = _tmp250_[0];
																							if (g_strcmp0 (_tmp251_, "ctype") == 0) {
																								ValaMethod* _tmp252_ = NULL;
																								gchar** _tmp253_ = NULL;
																								gint _tmp253__length1 = 0;
																								const gchar* _tmp254_ = NULL;
																								gchar* _tmp255_ = NULL;
																								gchar* _tmp256_ = NULL;
																								_tmp252_ = m;
																								_tmp253_ = nv;
																								_tmp253__length1 = nv_length1;
																								_tmp254_ = _tmp253_[1];
																								_tmp255_ = vala_gidl_parser_eval (self, _tmp254_);
																								_tmp256_ = _tmp255_;
																								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp252_, "CCode", "type", _tmp256_, NULL);
																								_g_free0 (_tmp256_);
																							} else {
																								gchar** _tmp257_ = NULL;
																								gint _tmp257__length1 = 0;
																								const gchar* _tmp258_ = NULL;
																								_tmp257_ = nv;
																								_tmp257__length1 = nv_length1;
																								_tmp258_ = _tmp257_[0];
																								if (g_strcmp0 (_tmp258_, "type_arguments") == 0) {
																									ValaDataType* _tmp259_ = NULL;
																									gchar** _tmp260_ = NULL;
																									gint _tmp260__length1 = 0;
																									const gchar* _tmp261_ = NULL;
																									gchar* _tmp262_ = NULL;
																									gchar* _tmp263_ = NULL;
																									_tmp259_ = return_type;
																									_tmp260_ = nv;
																									_tmp260__length1 = nv_length1;
																									_tmp261_ = _tmp260_[1];
																									_tmp262_ = vala_gidl_parser_eval (self, _tmp261_);
																									_tmp263_ = _tmp262_;
																									vala_gidl_parser_parse_type_arguments_from_string (self, _tmp259_, _tmp263_, NULL);
																									_g_free0 (_tmp263_);
																								} else {
																									gchar** _tmp264_ = NULL;
																									gint _tmp264__length1 = 0;
																									const gchar* _tmp265_ = NULL;
																									_tmp264_ = nv;
																									_tmp264__length1 = nv_length1;
																									_tmp265_ = _tmp264_[0];
																									if (g_strcmp0 (_tmp265_, "deprecated") == 0) {
																										gchar** _tmp266_ = NULL;
																										gint _tmp266__length1 = 0;
																										const gchar* _tmp267_ = NULL;
																										gchar* _tmp268_ = NULL;
																										gchar* _tmp269_ = NULL;
																										gboolean _tmp270_ = FALSE;
																										_tmp266_ = nv;
																										_tmp266__length1 = nv_length1;
																										_tmp267_ = _tmp266_[1];
																										_tmp268_ = vala_gidl_parser_eval (self, _tmp267_);
																										_tmp269_ = _tmp268_;
																										_tmp270_ = g_strcmp0 (_tmp269_, "1") == 0;
																										_g_free0 (_tmp269_);
																										if (_tmp270_) {
																											ValaMethod* _tmp271_ = NULL;
																											_tmp271_ = m;
																											vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp271_, "Version", "deprecated", TRUE, NULL);
																										}
																									} else {
																										gchar** _tmp272_ = NULL;
																										gint _tmp272__length1 = 0;
																										const gchar* _tmp273_ = NULL;
																										_tmp272_ = nv;
																										_tmp272__length1 = nv_length1;
																										_tmp273_ = _tmp272_[0];
																										if (g_strcmp0 (_tmp273_, "replacement") == 0) {
																											ValaMethod* _tmp274_ = NULL;
																											gchar** _tmp275_ = NULL;
																											gint _tmp275__length1 = 0;
																											const gchar* _tmp276_ = NULL;
																											gchar* _tmp277_ = NULL;
																											gchar* _tmp278_ = NULL;
																											_tmp274_ = m;
																											_tmp275_ = nv;
																											_tmp275__length1 = nv_length1;
																											_tmp276_ = _tmp275_[1];
																											_tmp277_ = vala_gidl_parser_eval (self, _tmp276_);
																											_tmp278_ = _tmp277_;
																											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp274_, "Version", "replacement", _tmp278_, NULL);
																											_g_free0 (_tmp278_);
																										} else {
																											gchar** _tmp279_ = NULL;
																											gint _tmp279__length1 = 0;
																											const gchar* _tmp280_ = NULL;
																											_tmp279_ = nv;
																											_tmp279__length1 = nv_length1;
																											_tmp280_ = _tmp279_[0];
																											if (g_strcmp0 (_tmp280_, "deprecated_since") == 0) {
																												ValaMethod* _tmp281_ = NULL;
																												gchar** _tmp282_ = NULL;
																												gint _tmp282__length1 = 0;
																												const gchar* _tmp283_ = NULL;
																												gchar* _tmp284_ = NULL;
																												gchar* _tmp285_ = NULL;
																												_tmp281_ = m;
																												_tmp282_ = nv;
																												_tmp282__length1 = nv_length1;
																												_tmp283_ = _tmp282_[1];
																												_tmp284_ = vala_gidl_parser_eval (self, _tmp283_);
																												_tmp285_ = _tmp284_;
																												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp281_, "Version", "deprecated_since", _tmp285_, NULL);
																												_g_free0 (_tmp285_);
																											} else {
																												gchar** _tmp286_ = NULL;
																												gint _tmp286__length1 = 0;
																												const gchar* _tmp287_ = NULL;
																												_tmp286_ = nv;
																												_tmp286__length1 = nv_length1;
																												_tmp287_ = _tmp286_[0];
																												if (g_strcmp0 (_tmp287_, "cheader_filename") == 0) {
																													ValaMethod* _tmp288_ = NULL;
																													gchar** _tmp289_ = NULL;
																													gint _tmp289__length1 = 0;
																													const gchar* _tmp290_ = NULL;
																													gchar* _tmp291_ = NULL;
																													gchar* _tmp292_ = NULL;
																													_tmp288_ = m;
																													_tmp289_ = nv;
																													_tmp289__length1 = nv_length1;
																													_tmp290_ = _tmp289_[1];
																													_tmp291_ = vala_gidl_parser_eval (self, _tmp290_);
																													_tmp292_ = _tmp291_;
																													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp288_, "CCode", "cheader_filename", _tmp292_, NULL);
																													_g_free0 (_tmp292_);
																												} else {
																													gchar** _tmp293_ = NULL;
																													gint _tmp293__length1 = 0;
																													const gchar* _tmp294_ = NULL;
																													_tmp293_ = nv;
																													_tmp293__length1 = nv_length1;
																													_tmp294_ = _tmp293_[0];
																													if (g_strcmp0 (_tmp294_, "abstract") == 0) {
																														gchar** _tmp295_ = NULL;
																														gint _tmp295__length1 = 0;
																														const gchar* _tmp296_ = NULL;
																														gchar* _tmp297_ = NULL;
																														gchar* _tmp298_ = NULL;
																														gboolean _tmp299_ = FALSE;
																														_tmp295_ = nv;
																														_tmp295__length1 = nv_length1;
																														_tmp296_ = _tmp295_[1];
																														_tmp297_ = vala_gidl_parser_eval (self, _tmp296_);
																														_tmp298_ = _tmp297_;
																														_tmp299_ = g_strcmp0 (_tmp298_, "1") == 0;
																														_g_free0 (_tmp298_);
																														if (_tmp299_) {
																															ValaMethod* _tmp300_ = NULL;
																															_tmp300_ = m;
																															vala_method_set_is_abstract (_tmp300_, TRUE);
																														}
																													} else {
																														gchar** _tmp301_ = NULL;
																														gint _tmp301__length1 = 0;
																														const gchar* _tmp302_ = NULL;
																														_tmp301_ = nv;
																														_tmp301__length1 = nv_length1;
																														_tmp302_ = _tmp301_[0];
																														if (g_strcmp0 (_tmp302_, "virtual") == 0) {
																															gchar** _tmp303_ = NULL;
																															gint _tmp303__length1 = 0;
																															const gchar* _tmp304_ = NULL;
																															gchar* _tmp305_ = NULL;
																															gchar* _tmp306_ = NULL;
																															gboolean _tmp307_ = FALSE;
																															_tmp303_ = nv;
																															_tmp303__length1 = nv_length1;
																															_tmp304_ = _tmp303_[1];
																															_tmp305_ = vala_gidl_parser_eval (self, _tmp304_);
																															_tmp306_ = _tmp305_;
																															_tmp307_ = g_strcmp0 (_tmp306_, "1") == 0;
																															_g_free0 (_tmp306_);
																															if (_tmp307_) {
																																ValaMethod* _tmp308_ = NULL;
																																_tmp308_ = m;
																																vala_method_set_is_virtual (_tmp308_, TRUE);
																															}
																														} else {
																															gchar** _tmp309_ = NULL;
																															gint _tmp309__length1 = 0;
																															const gchar* _tmp310_ = NULL;
																															_tmp309_ = nv;
																															_tmp309__length1 = nv_length1;
																															_tmp310_ = _tmp309_[0];
																															if (g_strcmp0 (_tmp310_, "vfunc_name") == 0) {
																																ValaMethod* _tmp311_ = NULL;
																																gchar** _tmp312_ = NULL;
																																gint _tmp312__length1 = 0;
																																const gchar* _tmp313_ = NULL;
																																gchar* _tmp314_ = NULL;
																																gchar* _tmp315_ = NULL;
																																_tmp311_ = m;
																																_tmp312_ = nv;
																																_tmp312__length1 = nv_length1;
																																_tmp313_ = _tmp312_[1];
																																_tmp314_ = vala_gidl_parser_eval (self, _tmp313_);
																																_tmp315_ = _tmp314_;
																																vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp311_, "CCode", "vfunc_name", _tmp315_, NULL);
																																_g_free0 (_tmp315_);
																															} else {
																																gchar** _tmp316_ = NULL;
																																gint _tmp316__length1 = 0;
																																const gchar* _tmp317_ = NULL;
																																_tmp316_ = nv;
																																_tmp316__length1 = nv_length1;
																																_tmp317_ = _tmp316_[0];
																																if (g_strcmp0 (_tmp317_, "finish_vfunc_name") == 0) {
																																	ValaMethod* _tmp318_ = NULL;
																																	gchar** _tmp319_ = NULL;
																																	gint _tmp319__length1 = 0;
																																	const gchar* _tmp320_ = NULL;
																																	gchar* _tmp321_ = NULL;
																																	gchar* _tmp322_ = NULL;
																																	_tmp318_ = m;
																																	_tmp319_ = nv;
																																	_tmp319__length1 = nv_length1;
																																	_tmp320_ = _tmp319_[1];
																																	_tmp321_ = vala_gidl_parser_eval (self, _tmp320_);
																																	_tmp322_ = _tmp321_;
																																	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp318_, "CCode", "finish_vfunc_name", _tmp322_, NULL);
																																	_g_free0 (_tmp322_);
																																} else {
																																	gchar** _tmp323_ = NULL;
																																	gint _tmp323__length1 = 0;
																																	const gchar* _tmp324_ = NULL;
																																	_tmp323_ = nv;
																																	_tmp323__length1 = nv_length1;
																																	_tmp324_ = _tmp323_[0];
																																	if (g_strcmp0 (_tmp324_, "finish_name") == 0) {
																																		ValaMethod* _tmp325_ = NULL;
																																		gchar** _tmp326_ = NULL;
																																		gint _tmp326__length1 = 0;
																																		const gchar* _tmp327_ = NULL;
																																		gchar* _tmp328_ = NULL;
																																		gchar* _tmp329_ = NULL;
																																		_tmp325_ = m;
																																		_tmp326_ = nv;
																																		_tmp326__length1 = nv_length1;
																																		_tmp327_ = _tmp326_[1];
																																		_tmp328_ = vala_gidl_parser_eval (self, _tmp327_);
																																		_tmp329_ = _tmp328_;
																																		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp325_, "CCode", "finish_name", _tmp329_, NULL);
																																		_g_free0 (_tmp329_);
																																	} else {
																																		gchar** _tmp330_ = NULL;
																																		gint _tmp330__length1 = 0;
																																		const gchar* _tmp331_ = NULL;
																																		_tmp330_ = nv;
																																		_tmp330__length1 = nv_length1;
																																		_tmp331_ = _tmp330_[0];
																																		if (g_strcmp0 (_tmp331_, "async") == 0) {
																																			gchar** _tmp332_ = NULL;
																																			gint _tmp332__length1 = 0;
																																			const gchar* _tmp333_ = NULL;
																																			gchar* _tmp334_ = NULL;
																																			gchar* _tmp335_ = NULL;
																																			gboolean _tmp336_ = FALSE;
																																			_tmp332_ = nv;
																																			_tmp332__length1 = nv_length1;
																																			_tmp333_ = _tmp332_[1];
																																			_tmp334_ = vala_gidl_parser_eval (self, _tmp333_);
																																			_tmp335_ = _tmp334_;
																																			_tmp336_ = g_strcmp0 (_tmp335_, "1") == 0;
																																			_g_free0 (_tmp335_);
																																			if (_tmp336_) {
																																				ValaMethod* _tmp337_ = NULL;
																																				_tmp337_ = m;
																																				vala_method_set_coroutine (_tmp337_, TRUE);
																																			}
																																		} else {
																																			gchar** _tmp338_ = NULL;
																																			gint _tmp338__length1 = 0;
																																			const gchar* _tmp339_ = NULL;
																																			_tmp338_ = nv;
																																			_tmp338__length1 = nv_length1;
																																			_tmp339_ = _tmp338_[0];
																																			if (g_strcmp0 (_tmp339_, "parent") == 0) {
																																				gchar** _tmp340_ = NULL;
																																				gint _tmp340__length1 = 0;
																																				const gchar* _tmp341_ = NULL;
																																				gchar* _tmp342_ = NULL;
																																				gchar* _tmp343_ = NULL;
																																				ValaSymbol* _tmp344_ = NULL;
																																				gchar* prefix = NULL;
																																				ValaSymbol* _tmp345_ = NULL;
																																				gchar* _tmp346_ = NULL;
																																				const gchar* _tmp347_ = NULL;
																																				const gchar* _tmp348_ = NULL;
																																				gboolean _tmp349_ = FALSE;
																																				_tmp340_ = nv;
																																				_tmp340__length1 = nv_length1;
																																				_tmp341_ = _tmp340_[1];
																																				_tmp342_ = vala_gidl_parser_eval (self, _tmp341_);
																																				_tmp343_ = _tmp342_;
																																				_tmp344_ = vala_gidl_parser_get_container_from_name (self, _tmp343_);
																																				_vala_code_node_unref0 (container);
																																				container = _tmp344_;
																																				_g_free0 (_tmp343_);
																																				_tmp345_ = container;
																																				_tmp346_ = vala_gidl_parser_get_lower_case_cprefix (self, _tmp345_);
																																				prefix = _tmp346_;
																																				_tmp347_ = symbol;
																																				_tmp348_ = prefix;
																																				_tmp349_ = g_str_has_prefix (_tmp347_, _tmp348_);
																																				if (_tmp349_) {
																																					ValaMethod* _tmp350_ = NULL;
																																					const gchar* _tmp351_ = NULL;
																																					const gchar* _tmp352_ = NULL;
																																					gint _tmp353_ = 0;
																																					gint _tmp354_ = 0;
																																					gchar* _tmp355_ = NULL;
																																					gchar* _tmp356_ = NULL;
																																					_tmp350_ = m;
																																					_tmp351_ = symbol;
																																					_tmp352_ = prefix;
																																					_tmp353_ = strlen (_tmp352_);
																																					_tmp354_ = _tmp353_;
																																					_tmp355_ = string_substring (_tmp351_, (glong) _tmp354_, (glong) -1);
																																					_tmp356_ = _tmp355_;
																																					vala_symbol_set_name ((ValaSymbol*) _tmp350_, _tmp356_);
																																					_g_free0 (_tmp356_);
																																				}
																																				_g_free0 (prefix);
																																			} else {
																																				gchar** _tmp357_ = NULL;
																																				gint _tmp357__length1 = 0;
																																				const gchar* _tmp358_ = NULL;
																																				_tmp357_ = nv;
																																				_tmp357__length1 = nv_length1;
																																				_tmp358_ = _tmp357_[0];
																																				if (g_strcmp0 (_tmp358_, "experimental") == 0) {
																																					gchar** _tmp359_ = NULL;
																																					gint _tmp359__length1 = 0;
																																					const gchar* _tmp360_ = NULL;
																																					gchar* _tmp361_ = NULL;
																																					gchar* _tmp362_ = NULL;
																																					gboolean _tmp363_ = FALSE;
																																					_tmp359_ = nv;
																																					_tmp359__length1 = nv_length1;
																																					_tmp360_ = _tmp359_[1];
																																					_tmp361_ = vala_gidl_parser_eval (self, _tmp360_);
																																					_tmp362_ = _tmp361_;
																																					_tmp363_ = g_strcmp0 (_tmp362_, "1") == 0;
																																					_g_free0 (_tmp362_);
																																					if (_tmp363_) {
																																						ValaMethod* _tmp364_ = NULL;
																																						_tmp364_ = m;
																																						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp364_, "Version", "experimental", TRUE, NULL);
																																					}
																																				} else {
																																					gchar** _tmp365_ = NULL;
																																					gint _tmp365__length1 = 0;
																																					const gchar* _tmp366_ = NULL;
																																					_tmp365_ = nv;
																																					_tmp365__length1 = nv_length1;
																																					_tmp366_ = _tmp365_[0];
																																					if (g_strcmp0 (_tmp366_, "simple_generics") == 0) {
																																						gchar** _tmp367_ = NULL;
																																						gint _tmp367__length1 = 0;
																																						const gchar* _tmp368_ = NULL;
																																						gchar* _tmp369_ = NULL;
																																						gchar* _tmp370_ = NULL;
																																						gboolean _tmp371_ = FALSE;
																																						_tmp367_ = nv;
																																						_tmp367__length1 = nv_length1;
																																						_tmp368_ = _tmp367_[1];
																																						_tmp369_ = vala_gidl_parser_eval (self, _tmp368_);
																																						_tmp370_ = _tmp369_;
																																						_tmp371_ = g_strcmp0 (_tmp370_, "1") == 0;
																																						_g_free0 (_tmp370_);
																																						if (_tmp371_) {
																																							ValaMethod* _tmp372_ = NULL;
																																							_tmp372_ = m;
																																							vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp372_, "CCode", "simple_generics", TRUE, NULL);
																																						}
																																					}
																																				}
																																			}
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	first = TRUE;
	last_param = NULL;
	last_param_type = NULL;
	_tmp373_ = parameters;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp373_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				GIdlNode* param_node = NULL;
				GIdlNodeParam* _tmp374_ = NULL;
				gboolean _tmp375_ = FALSE;
				gboolean _tmp435_ = FALSE;
				GIdlNodeParam* _tmp436_ = NULL;
				GIdlNodeType* _tmp437_ = NULL;
				const gchar* _tmp438_ = NULL;
				gboolean _tmp446_ = FALSE;
				gboolean _tmp447_ = FALSE;
				gchar* param_name = NULL;
				GIdlNode* _tmp456_ = NULL;
				const gchar* _tmp457_ = NULL;
				gchar* _tmp458_ = NULL;
				const gchar* _tmp459_ = NULL;
				ValaParameterDirection direction = 0;
				ValaDataType* param_type = NULL;
				GIdlNodeParam* _tmp463_ = NULL;
				ValaParameterDirection _tmp464_ = 0;
				ValaDataType* _tmp465_ = NULL;
				ValaParameter* p = NULL;
				const gchar* _tmp466_ = NULL;
				ValaDataType* _tmp467_ = NULL;
				ValaParameter* _tmp468_ = NULL;
				ValaParameter* _tmp469_ = NULL;
				ValaParameterDirection _tmp470_ = 0;
				gboolean hide_param = FALSE;
				gboolean show_param = FALSE;
				gboolean set_array_length_pos = FALSE;
				gdouble array_length_pos = 0.0;
				gboolean set_delegate_target_pos = FALSE;
				gdouble delegate_target_pos = 0.0;
				gboolean array_requested = FALSE;
				gboolean out_requested = FALSE;
				const gchar* _tmp471_ = NULL;
				GIdlNode* _tmp472_ = NULL;
				const gchar* _tmp473_ = NULL;
				gchar* _tmp474_ = NULL;
				gchar* _tmp475_ = NULL;
				gint _tmp476_ = 0;
				gchar** _tmp477_ = NULL;
				gchar** _tmp478_ = NULL;
				gint _tmp478__length1 = 0;
				gboolean _tmp752_ = FALSE;
				ValaParameter* _tmp753_ = NULL;
				gboolean _tmp777_ = FALSE;
				gboolean _tmp778_ = FALSE;
				ValaParameter* _tmp788_ = NULL;
				ValaParameter* _tmp789_ = NULL;
				ValaDataType* _tmp790_ = NULL;
				ValaDataType* _tmp791_ = NULL;
				_tmp374_ = param;
				param_node = (GIdlNode*) _tmp374_;
				_tmp375_ = first;
				if (_tmp375_) {
					gboolean _tmp376_ = FALSE;
					gboolean _tmp377_ = FALSE;
					gboolean _tmp378_ = FALSE;
					ValaMethod* _tmp379_ = NULL;
					first = FALSE;
					_tmp379_ = m;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp379_, VALA_TYPE_CREATION_METHOD)) {
						ValaTypeSymbol* _tmp380_ = NULL;
						_tmp380_ = self->priv->current_data_type;
						_tmp378_ = _tmp380_ != NULL;
					} else {
						_tmp378_ = FALSE;
					}
					if (_tmp378_) {
						GIdlNodeParam* _tmp381_ = NULL;
						GIdlNodeType* _tmp382_ = NULL;
						gboolean _tmp383_ = FALSE;
						_tmp381_ = param;
						_tmp382_ = _tmp381_->type;
						_tmp383_ = _tmp382_->is_interface;
						_tmp377_ = _tmp383_;
					} else {
						_tmp377_ = FALSE;
					}
					if (_tmp377_) {
						gboolean _tmp384_ = FALSE;
						GIdlNode* _tmp385_ = NULL;
						const gchar* _tmp386_ = NULL;
						_tmp385_ = param_node;
						_tmp386_ = _tmp385_->name;
						if (g_strcmp0 (_tmp386_, "self") == 0) {
							_tmp384_ = TRUE;
						} else {
							GIdlNodeParam* _tmp387_ = NULL;
							GIdlNodeType* _tmp388_ = NULL;
							const gchar* _tmp389_ = NULL;
							ValaTypeSymbol* _tmp390_ = NULL;
							gchar* _tmp391_ = NULL;
							gchar* _tmp392_ = NULL;
							gboolean _tmp393_ = FALSE;
							_tmp387_ = param;
							_tmp388_ = _tmp387_->type;
							_tmp389_ = _tmp388_->interface;
							_tmp390_ = self->priv->current_data_type;
							_tmp391_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp390_, NULL);
							_tmp392_ = _tmp391_;
							_tmp393_ = g_str_has_suffix (_tmp389_, _tmp392_);
							_tmp384_ = _tmp393_;
							_g_free0 (_tmp392_);
						}
						_tmp376_ = _tmp384_;
					} else {
						_tmp376_ = FALSE;
					}
					if (_tmp376_) {
						continue;
					} else {
						gboolean _tmp394_ = FALSE;
						gboolean _tmp395_ = FALSE;
						gboolean _tmp396_ = FALSE;
						ValaMethod* _tmp397_ = NULL;
						_tmp397_ = m;
						if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp397_, VALA_TYPE_CREATION_METHOD)) {
							ValaTypeSymbol* _tmp398_ = NULL;
							_tmp398_ = self->priv->current_data_type;
							_tmp396_ = _tmp398_ != NULL;
						} else {
							_tmp396_ = FALSE;
						}
						if (_tmp396_) {
							GIdlNodeParam* _tmp399_ = NULL;
							GIdlNodeType* _tmp400_ = NULL;
							gboolean _tmp401_ = FALSE;
							_tmp399_ = param;
							_tmp400_ = _tmp399_->type;
							_tmp401_ = _tmp400_->is_interface;
							_tmp395_ = _tmp401_;
						} else {
							_tmp395_ = FALSE;
						}
						if (_tmp395_) {
							gboolean _tmp402_ = FALSE;
							GIdlNode* _tmp403_ = NULL;
							const gchar* _tmp404_ = NULL;
							_tmp403_ = param_node;
							_tmp404_ = _tmp403_->name;
							if (g_strcmp0 (_tmp404_, "klass") == 0) {
								_tmp402_ = TRUE;
							} else {
								GIdlNodeParam* _tmp405_ = NULL;
								GIdlNodeType* _tmp406_ = NULL;
								const gchar* _tmp407_ = NULL;
								ValaTypeSymbol* _tmp408_ = NULL;
								gchar* _tmp409_ = NULL;
								gchar* _tmp410_ = NULL;
								gchar* _tmp411_ = NULL;
								gchar* _tmp412_ = NULL;
								gboolean _tmp413_ = FALSE;
								_tmp405_ = param;
								_tmp406_ = _tmp405_->type;
								_tmp407_ = _tmp406_->interface;
								_tmp408_ = self->priv->current_data_type;
								_tmp409_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp408_, NULL);
								_tmp410_ = _tmp409_;
								_tmp411_ = g_strdup_printf ("%sClass", _tmp410_);
								_tmp412_ = _tmp411_;
								_tmp413_ = g_str_has_suffix (_tmp407_, _tmp412_);
								_tmp402_ = _tmp413_;
								_g_free0 (_tmp412_);
								_g_free0 (_tmp410_);
							}
							_tmp394_ = _tmp402_;
						} else {
							_tmp394_ = FALSE;
						}
						if (_tmp394_) {
							ValaMethod* _tmp414_ = NULL;
							ValaMethod* _tmp415_ = NULL;
							const gchar* _tmp416_ = NULL;
							const gchar* _tmp417_ = NULL;
							gboolean _tmp418_ = FALSE;
							_tmp414_ = m;
							vala_method_set_binding (_tmp414_, VALA_MEMBER_BINDING_CLASS);
							_tmp415_ = m;
							_tmp416_ = vala_symbol_get_name ((ValaSymbol*) _tmp415_);
							_tmp417_ = _tmp416_;
							_tmp418_ = g_str_has_prefix (_tmp417_, "class_");
							if (_tmp418_) {
								ValaMethod* _tmp419_ = NULL;
								ValaMethod* _tmp420_ = NULL;
								const gchar* _tmp421_ = NULL;
								const gchar* _tmp422_ = NULL;
								gint _tmp423_ = 0;
								gint _tmp424_ = 0;
								ValaMethod* _tmp425_ = NULL;
								const gchar* _tmp426_ = NULL;
								const gchar* _tmp427_ = NULL;
								gint _tmp428_ = 0;
								gint _tmp429_ = 0;
								gint _tmp430_ = 0;
								gint _tmp431_ = 0;
								gchar* _tmp432_ = NULL;
								gchar* _tmp433_ = NULL;
								_tmp419_ = m;
								_tmp420_ = m;
								_tmp421_ = vala_symbol_get_name ((ValaSymbol*) _tmp420_);
								_tmp422_ = _tmp421_;
								_tmp423_ = strlen ("class_");
								_tmp424_ = _tmp423_;
								_tmp425_ = m;
								_tmp426_ = vala_symbol_get_name ((ValaSymbol*) _tmp425_);
								_tmp427_ = _tmp426_;
								_tmp428_ = strlen (_tmp427_);
								_tmp429_ = _tmp428_;
								_tmp430_ = strlen ("class_");
								_tmp431_ = _tmp430_;
								_tmp432_ = string_substring (_tmp422_, (glong) _tmp424_, (glong) (_tmp429_ - _tmp431_));
								_tmp433_ = _tmp432_;
								vala_symbol_set_name ((ValaSymbol*) _tmp419_, _tmp433_);
								_g_free0 (_tmp433_);
							}
							continue;
						} else {
							ValaMethod* _tmp434_ = NULL;
							_tmp434_ = m;
							vala_method_set_binding (_tmp434_, VALA_MEMBER_BINDING_STATIC);
						}
					}
				}
				_tmp436_ = param;
				_tmp437_ = _tmp436_->type;
				_tmp438_ = _tmp437_->interface;
				if (g_strcmp0 (_tmp438_, "GAsyncReadyCallback") == 0) {
					gboolean _tmp439_ = FALSE;
					const gchar* _tmp440_ = NULL;
					gboolean _tmp441_ = FALSE;
					_tmp440_ = symbol;
					_tmp441_ = g_str_has_suffix (_tmp440_, "_async");
					if (_tmp441_) {
						_tmp439_ = TRUE;
					} else {
						ValaMethod* _tmp442_ = NULL;
						gboolean _tmp443_ = FALSE;
						gboolean _tmp444_ = FALSE;
						_tmp442_ = m;
						_tmp443_ = vala_method_get_coroutine (_tmp442_);
						_tmp444_ = _tmp443_;
						_tmp439_ = _tmp444_;
					}
					_tmp435_ = _tmp439_;
				} else {
					_tmp435_ = FALSE;
				}
				if (_tmp435_) {
					ValaMethod* _tmp445_ = NULL;
					_tmp445_ = m;
					vala_method_set_coroutine (_tmp445_, TRUE);
					continue;
				}
				_tmp447_ = suppress_throws;
				if (_tmp447_ == FALSE) {
					GIdlNodeParam* _tmp448_ = NULL;
					gboolean _tmp449_ = FALSE;
					_tmp448_ = param;
					_tmp449_ = vala_gidl_parser_param_is_exception (self, _tmp448_);
					_tmp446_ = _tmp449_;
				} else {
					_tmp446_ = FALSE;
				}
				if (_tmp446_) {
					const gchar* _tmp450_ = NULL;
					_tmp450_ = error_types;
					if (_tmp450_ == NULL) {
						ValaMethod* _tmp451_ = NULL;
						GIdlNodeParam* _tmp452_ = NULL;
						GIdlNodeType* _tmp453_ = NULL;
						ValaDataType* _tmp454_ = NULL;
						ValaDataType* _tmp455_ = NULL;
						_tmp451_ = m;
						_tmp452_ = param;
						_tmp453_ = _tmp452_->type;
						_tmp454_ = vala_gidl_parser_parse_type (self, _tmp453_, NULL);
						_tmp455_ = _tmp454_;
						vala_code_node_add_error_type ((ValaCodeNode*) _tmp451_, _tmp455_);
						_vala_code_node_unref0 (_tmp455_);
					}
					continue;
				}
				_tmp456_ = param_node;
				_tmp457_ = _tmp456_->name;
				_tmp458_ = g_strdup (_tmp457_);
				param_name = _tmp458_;
				_tmp459_ = param_name;
				if (g_strcmp0 (_tmp459_, "result") == 0) {
					gchar* _tmp460_ = NULL;
					_tmp460_ = g_strdup ("_result");
					_g_free0 (param_name);
					param_name = _tmp460_;
				} else {
					const gchar* _tmp461_ = NULL;
					_tmp461_ = param_name;
					if (g_strcmp0 (_tmp461_, "string") == 0) {
						gchar* _tmp462_ = NULL;
						_tmp462_ = g_strdup ("str");
						_g_free0 (param_name);
						param_name = _tmp462_;
					}
				}
				_tmp463_ = param;
				_tmp465_ = vala_gidl_parser_parse_param (self, _tmp463_, &_tmp464_);
				direction = _tmp464_;
				param_type = _tmp465_;
				_tmp466_ = param_name;
				_tmp467_ = param_type;
				_tmp468_ = vala_parameter_new (_tmp466_, _tmp467_, NULL);
				p = _tmp468_;
				_tmp469_ = p;
				_tmp470_ = direction;
				vala_parameter_set_direction (_tmp469_, _tmp470_);
				hide_param = FALSE;
				show_param = FALSE;
				set_array_length_pos = FALSE;
				array_length_pos = (gdouble) 0;
				set_delegate_target_pos = FALSE;
				delegate_target_pos = (gdouble) 0;
				array_requested = FALSE;
				out_requested = FALSE;
				_tmp471_ = symbol;
				_tmp472_ = param_node;
				_tmp473_ = _tmp472_->name;
				_tmp474_ = g_strdup_printf ("%s.%s", _tmp471_, _tmp473_);
				_tmp475_ = _tmp474_;
				_tmp477_ = vala_gidl_parser_get_attributes (self, _tmp475_, &_tmp476_);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes = _tmp477_;
				attributes_length1 = _tmp476_;
				_attributes_size_ = attributes_length1;
				_g_free0 (_tmp475_);
				_tmp478_ = attributes;
				_tmp478__length1 = attributes_length1;
				if (_tmp478_ != NULL) {
					gchar** _tmp479_ = NULL;
					gint _tmp479__length1 = 0;
					_tmp479_ = attributes;
					_tmp479__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp479_;
						attr_collection_length1 = _tmp479__length1;
						for (attr_it = 0; attr_it < _tmp479__length1; attr_it = attr_it + 1) {
							gchar* _tmp480_ = NULL;
							gchar* attr = NULL;
							_tmp480_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp480_;
							{
								gchar** nv = NULL;
								const gchar* _tmp481_ = NULL;
								gchar** _tmp482_ = NULL;
								gchar** _tmp483_ = NULL;
								gint nv_length1 = 0;
								gint _nv_size_ = 0;
								gchar** _tmp484_ = NULL;
								gint _tmp484__length1 = 0;
								const gchar* _tmp485_ = NULL;
								_tmp481_ = attr;
								_tmp483_ = _tmp482_ = g_strsplit (_tmp481_, "=", 2);
								nv = _tmp483_;
								nv_length1 = _vala_array_length (_tmp482_);
								_nv_size_ = nv_length1;
								_tmp484_ = nv;
								_tmp484__length1 = nv_length1;
								_tmp485_ = _tmp484_[0];
								if (g_strcmp0 (_tmp485_, "is_array") == 0) {
									gchar** _tmp486_ = NULL;
									gint _tmp486__length1 = 0;
									const gchar* _tmp487_ = NULL;
									gchar* _tmp488_ = NULL;
									gchar* _tmp489_ = NULL;
									gboolean _tmp490_ = FALSE;
									_tmp486_ = nv;
									_tmp486__length1 = nv_length1;
									_tmp487_ = _tmp486_[1];
									_tmp488_ = vala_gidl_parser_eval (self, _tmp487_);
									_tmp489_ = _tmp488_;
									_tmp490_ = g_strcmp0 (_tmp489_, "1") == 0;
									_g_free0 (_tmp489_);
									if (_tmp490_) {
										ValaDataType* _tmp491_ = NULL;
										ValaDataType* _tmp492_ = NULL;
										ValaDataType* _tmp493_ = NULL;
										ValaSourceReference* _tmp494_ = NULL;
										ValaSourceReference* _tmp495_ = NULL;
										ValaArrayType* _tmp496_ = NULL;
										ValaParameter* _tmp497_ = NULL;
										ValaDataType* _tmp498_ = NULL;
										gboolean _tmp499_ = FALSE;
										_tmp491_ = param_type;
										vala_data_type_set_value_owned (_tmp491_, TRUE);
										_tmp492_ = param_type;
										_tmp493_ = param_type;
										_tmp494_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp493_);
										_tmp495_ = _tmp494_;
										_tmp496_ = vala_array_type_new (_tmp492_, 1, _tmp495_);
										_vala_code_node_unref0 (param_type);
										param_type = (ValaDataType*) _tmp496_;
										_tmp497_ = p;
										_tmp498_ = param_type;
										vala_variable_set_variable_type ((ValaVariable*) _tmp497_, _tmp498_);
										_tmp499_ = out_requested;
										if (!_tmp499_) {
											ValaParameter* _tmp500_ = NULL;
											_tmp500_ = p;
											vala_parameter_set_direction (_tmp500_, VALA_PARAMETER_DIRECTION_IN);
										}
										array_requested = TRUE;
									}
								} else {
									gchar** _tmp501_ = NULL;
									gint _tmp501__length1 = 0;
									const gchar* _tmp502_ = NULL;
									_tmp501_ = nv;
									_tmp501__length1 = nv_length1;
									_tmp502_ = _tmp501_[0];
									if (g_strcmp0 (_tmp502_, "is_pointer") == 0) {
										gchar** _tmp503_ = NULL;
										gint _tmp503__length1 = 0;
										const gchar* _tmp504_ = NULL;
										gchar* _tmp505_ = NULL;
										gchar* _tmp506_ = NULL;
										gboolean _tmp507_ = FALSE;
										_tmp503_ = nv;
										_tmp503__length1 = nv_length1;
										_tmp504_ = _tmp503_[1];
										_tmp505_ = vala_gidl_parser_eval (self, _tmp504_);
										_tmp506_ = _tmp505_;
										_tmp507_ = g_strcmp0 (_tmp506_, "1") == 0;
										_g_free0 (_tmp506_);
										if (_tmp507_) {
											ValaDataType* _tmp508_ = NULL;
											ValaDataType* _tmp509_ = NULL;
											ValaSourceReference* _tmp510_ = NULL;
											ValaSourceReference* _tmp511_ = NULL;
											ValaPointerType* _tmp512_ = NULL;
											ValaParameter* _tmp513_ = NULL;
											ValaDataType* _tmp514_ = NULL;
											gboolean _tmp515_ = FALSE;
											_tmp508_ = param_type;
											_tmp509_ = return_type;
											_tmp510_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp509_);
											_tmp511_ = _tmp510_;
											_tmp512_ = vala_pointer_type_new (_tmp508_, _tmp511_);
											_vala_code_node_unref0 (param_type);
											param_type = (ValaDataType*) _tmp512_;
											_tmp513_ = p;
											_tmp514_ = param_type;
											vala_variable_set_variable_type ((ValaVariable*) _tmp513_, _tmp514_);
											_tmp515_ = out_requested;
											if (!_tmp515_) {
												ValaParameter* _tmp516_ = NULL;
												_tmp516_ = p;
												vala_parameter_set_direction (_tmp516_, VALA_PARAMETER_DIRECTION_IN);
											}
										}
									} else {
										gchar** _tmp517_ = NULL;
										gint _tmp517__length1 = 0;
										const gchar* _tmp518_ = NULL;
										_tmp517_ = nv;
										_tmp517__length1 = nv_length1;
										_tmp518_ = _tmp517_[0];
										if (g_strcmp0 (_tmp518_, "is_out") == 0) {
											gchar** _tmp519_ = NULL;
											gint _tmp519__length1 = 0;
											const gchar* _tmp520_ = NULL;
											gchar* _tmp521_ = NULL;
											gchar* _tmp522_ = NULL;
											gboolean _tmp523_ = FALSE;
											_tmp519_ = nv;
											_tmp519__length1 = nv_length1;
											_tmp520_ = _tmp519_[1];
											_tmp521_ = vala_gidl_parser_eval (self, _tmp520_);
											_tmp522_ = _tmp521_;
											_tmp523_ = g_strcmp0 (_tmp522_, "1") == 0;
											_g_free0 (_tmp522_);
											if (_tmp523_) {
												ValaParameter* _tmp524_ = NULL;
												gboolean _tmp525_ = FALSE;
												gboolean _tmp526_ = FALSE;
												_tmp524_ = p;
												vala_parameter_set_direction (_tmp524_, VALA_PARAMETER_DIRECTION_OUT);
												out_requested = TRUE;
												_tmp526_ = array_requested;
												if (!_tmp526_) {
													ValaDataType* _tmp527_ = NULL;
													_tmp527_ = param_type;
													_tmp525_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp527_, VALA_TYPE_ARRAY_TYPE);
												} else {
													_tmp525_ = FALSE;
												}
												if (_tmp525_) {
													ValaArrayType* array_type = NULL;
													ValaDataType* _tmp528_ = NULL;
													ValaArrayType* _tmp529_ = NULL;
													ValaArrayType* _tmp530_ = NULL;
													ValaDataType* _tmp531_ = NULL;
													ValaDataType* _tmp532_ = NULL;
													ValaDataType* _tmp533_ = NULL;
													ValaParameter* _tmp534_ = NULL;
													ValaDataType* _tmp535_ = NULL;
													_tmp528_ = param_type;
													_tmp529_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp528_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
													array_type = _tmp529_;
													_tmp530_ = array_type;
													_tmp531_ = vala_array_type_get_element_type (_tmp530_);
													_tmp532_ = _tmp531_;
													_tmp533_ = _vala_code_node_ref0 (_tmp532_);
													_vala_code_node_unref0 (param_type);
													param_type = _tmp533_;
													_tmp534_ = p;
													_tmp535_ = param_type;
													vala_variable_set_variable_type ((ValaVariable*) _tmp534_, _tmp535_);
													_vala_code_node_unref0 (array_type);
												}
											}
										} else {
											gchar** _tmp536_ = NULL;
											gint _tmp536__length1 = 0;
											const gchar* _tmp537_ = NULL;
											_tmp536_ = nv;
											_tmp536__length1 = nv_length1;
											_tmp537_ = _tmp536_[0];
											if (g_strcmp0 (_tmp537_, "is_ref") == 0) {
												gchar** _tmp538_ = NULL;
												gint _tmp538__length1 = 0;
												const gchar* _tmp539_ = NULL;
												gchar* _tmp540_ = NULL;
												gchar* _tmp541_ = NULL;
												gboolean _tmp542_ = FALSE;
												_tmp538_ = nv;
												_tmp538__length1 = nv_length1;
												_tmp539_ = _tmp538_[1];
												_tmp540_ = vala_gidl_parser_eval (self, _tmp539_);
												_tmp541_ = _tmp540_;
												_tmp542_ = g_strcmp0 (_tmp541_, "1") == 0;
												_g_free0 (_tmp541_);
												if (_tmp542_) {
													ValaParameter* _tmp543_ = NULL;
													gboolean _tmp544_ = FALSE;
													gboolean _tmp545_ = FALSE;
													_tmp543_ = p;
													vala_parameter_set_direction (_tmp543_, VALA_PARAMETER_DIRECTION_REF);
													_tmp545_ = array_requested;
													if (!_tmp545_) {
														ValaDataType* _tmp546_ = NULL;
														_tmp546_ = param_type;
														_tmp544_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp546_, VALA_TYPE_ARRAY_TYPE);
													} else {
														_tmp544_ = FALSE;
													}
													if (_tmp544_) {
														ValaArrayType* array_type = NULL;
														ValaDataType* _tmp547_ = NULL;
														ValaArrayType* _tmp548_ = NULL;
														ValaArrayType* _tmp549_ = NULL;
														ValaDataType* _tmp550_ = NULL;
														ValaDataType* _tmp551_ = NULL;
														ValaDataType* _tmp552_ = NULL;
														ValaParameter* _tmp553_ = NULL;
														ValaDataType* _tmp554_ = NULL;
														_tmp547_ = param_type;
														_tmp548_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp547_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
														array_type = _tmp548_;
														_tmp549_ = array_type;
														_tmp550_ = vala_array_type_get_element_type (_tmp549_);
														_tmp551_ = _tmp550_;
														_tmp552_ = _vala_code_node_ref0 (_tmp551_);
														_vala_code_node_unref0 (param_type);
														param_type = _tmp552_;
														_tmp553_ = p;
														_tmp554_ = param_type;
														vala_variable_set_variable_type ((ValaVariable*) _tmp553_, _tmp554_);
														_vala_code_node_unref0 (array_type);
													}
												}
											} else {
												gchar** _tmp555_ = NULL;
												gint _tmp555__length1 = 0;
												const gchar* _tmp556_ = NULL;
												_tmp555_ = nv;
												_tmp555__length1 = nv_length1;
												_tmp556_ = _tmp555_[0];
												if (g_strcmp0 (_tmp556_, "nullable") == 0) {
													gboolean _tmp557_ = FALSE;
													gchar** _tmp558_ = NULL;
													gint _tmp558__length1 = 0;
													const gchar* _tmp559_ = NULL;
													gchar* _tmp560_ = NULL;
													gchar* _tmp561_ = NULL;
													gboolean _tmp562_ = FALSE;
													_tmp558_ = nv;
													_tmp558__length1 = nv_length1;
													_tmp559_ = _tmp558_[1];
													_tmp560_ = vala_gidl_parser_eval (self, _tmp559_);
													_tmp561_ = _tmp560_;
													_tmp562_ = g_strcmp0 (_tmp561_, "1") == 0;
													_g_free0 (_tmp561_);
													if (_tmp562_) {
														ValaDataType* _tmp563_ = NULL;
														_tmp563_ = param_type;
														_tmp557_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp563_, VALA_TYPE_VOID_TYPE);
													} else {
														_tmp557_ = FALSE;
													}
													if (_tmp557_) {
														ValaDataType* _tmp564_ = NULL;
														_tmp564_ = param_type;
														vala_data_type_set_nullable (_tmp564_, TRUE);
													}
												} else {
													gchar** _tmp565_ = NULL;
													gint _tmp565__length1 = 0;
													const gchar* _tmp566_ = NULL;
													_tmp565_ = nv;
													_tmp565__length1 = nv_length1;
													_tmp566_ = _tmp565_[0];
													if (g_strcmp0 (_tmp566_, "transfer_ownership") == 0) {
														gchar** _tmp567_ = NULL;
														gint _tmp567__length1 = 0;
														const gchar* _tmp568_ = NULL;
														gchar* _tmp569_ = NULL;
														gchar* _tmp570_ = NULL;
														gboolean _tmp571_ = FALSE;
														_tmp567_ = nv;
														_tmp567__length1 = nv_length1;
														_tmp568_ = _tmp567_[1];
														_tmp569_ = vala_gidl_parser_eval (self, _tmp568_);
														_tmp570_ = _tmp569_;
														_tmp571_ = g_strcmp0 (_tmp570_, "1") == 0;
														_g_free0 (_tmp570_);
														if (_tmp571_) {
															ValaDataType* _tmp572_ = NULL;
															_tmp572_ = param_type;
															vala_data_type_set_value_owned (_tmp572_, TRUE);
														}
													} else {
														gchar** _tmp573_ = NULL;
														gint _tmp573__length1 = 0;
														const gchar* _tmp574_ = NULL;
														_tmp573_ = nv;
														_tmp573__length1 = nv_length1;
														_tmp574_ = _tmp573_[0];
														if (g_strcmp0 (_tmp574_, "takes_ownership") == 0) {
															gchar** _tmp575_ = NULL;
															gint _tmp575__length1 = 0;
															const gchar* _tmp576_ = NULL;
															gchar* _tmp577_ = NULL;
															gchar* _tmp578_ = NULL;
															gboolean _tmp579_ = FALSE;
															_tmp575_ = nv;
															_tmp575__length1 = nv_length1;
															_tmp576_ = _tmp575_[1];
															_tmp577_ = vala_gidl_parser_eval (self, _tmp576_);
															_tmp578_ = _tmp577_;
															_tmp579_ = g_strcmp0 (_tmp578_, "1") == 0;
															_g_free0 (_tmp578_);
															if (_tmp579_) {
																ValaDataType* _tmp580_ = NULL;
																_tmp580_ = param_type;
																vala_data_type_set_value_owned (_tmp580_, TRUE);
															}
														} else {
															gchar** _tmp581_ = NULL;
															gint _tmp581__length1 = 0;
															const gchar* _tmp582_ = NULL;
															_tmp581_ = nv;
															_tmp581__length1 = nv_length1;
															_tmp582_ = _tmp581_[0];
															if (g_strcmp0 (_tmp582_, "value_owned") == 0) {
																gchar** _tmp583_ = NULL;
																gint _tmp583__length1 = 0;
																const gchar* _tmp584_ = NULL;
																gchar* _tmp585_ = NULL;
																gchar* _tmp586_ = NULL;
																gboolean _tmp587_ = FALSE;
																_tmp583_ = nv;
																_tmp583__length1 = nv_length1;
																_tmp584_ = _tmp583_[1];
																_tmp585_ = vala_gidl_parser_eval (self, _tmp584_);
																_tmp586_ = _tmp585_;
																_tmp587_ = g_strcmp0 (_tmp586_, "0") == 0;
																_g_free0 (_tmp586_);
																if (_tmp587_) {
																	ValaDataType* _tmp588_ = NULL;
																	_tmp588_ = param_type;
																	vala_data_type_set_value_owned (_tmp588_, FALSE);
																} else {
																	gchar** _tmp589_ = NULL;
																	gint _tmp589__length1 = 0;
																	const gchar* _tmp590_ = NULL;
																	gchar* _tmp591_ = NULL;
																	gchar* _tmp592_ = NULL;
																	gboolean _tmp593_ = FALSE;
																	_tmp589_ = nv;
																	_tmp589__length1 = nv_length1;
																	_tmp590_ = _tmp589_[1];
																	_tmp591_ = vala_gidl_parser_eval (self, _tmp590_);
																	_tmp592_ = _tmp591_;
																	_tmp593_ = g_strcmp0 (_tmp592_, "1") == 0;
																	_g_free0 (_tmp592_);
																	if (_tmp593_) {
																		ValaDataType* _tmp594_ = NULL;
																		_tmp594_ = param_type;
																		vala_data_type_set_value_owned (_tmp594_, TRUE);
																	}
																}
															} else {
																gchar** _tmp595_ = NULL;
																gint _tmp595__length1 = 0;
																const gchar* _tmp596_ = NULL;
																_tmp595_ = nv;
																_tmp595__length1 = nv_length1;
																_tmp596_ = _tmp595_[0];
																if (g_strcmp0 (_tmp596_, "hidden") == 0) {
																	gchar** _tmp597_ = NULL;
																	gint _tmp597__length1 = 0;
																	const gchar* _tmp598_ = NULL;
																	gchar* _tmp599_ = NULL;
																	gchar* _tmp600_ = NULL;
																	gboolean _tmp601_ = FALSE;
																	_tmp597_ = nv;
																	_tmp597__length1 = nv_length1;
																	_tmp598_ = _tmp597_[1];
																	_tmp599_ = vala_gidl_parser_eval (self, _tmp598_);
																	_tmp600_ = _tmp599_;
																	_tmp601_ = g_strcmp0 (_tmp600_, "1") == 0;
																	_g_free0 (_tmp600_);
																	if (_tmp601_) {
																		hide_param = TRUE;
																	} else {
																		gchar** _tmp602_ = NULL;
																		gint _tmp602__length1 = 0;
																		const gchar* _tmp603_ = NULL;
																		gchar* _tmp604_ = NULL;
																		gchar* _tmp605_ = NULL;
																		gboolean _tmp606_ = FALSE;
																		_tmp602_ = nv;
																		_tmp602__length1 = nv_length1;
																		_tmp603_ = _tmp602_[1];
																		_tmp604_ = vala_gidl_parser_eval (self, _tmp603_);
																		_tmp605_ = _tmp604_;
																		_tmp606_ = g_strcmp0 (_tmp605_, "0") == 0;
																		_g_free0 (_tmp605_);
																		if (_tmp606_) {
																			show_param = TRUE;
																		}
																	}
																} else {
																	gchar** _tmp607_ = NULL;
																	gint _tmp607__length1 = 0;
																	const gchar* _tmp608_ = NULL;
																	_tmp607_ = nv;
																	_tmp607__length1 = nv_length1;
																	_tmp608_ = _tmp607_[0];
																	if (g_strcmp0 (_tmp608_, "no_array_length") == 0) {
																		gchar** _tmp609_ = NULL;
																		gint _tmp609__length1 = 0;
																		const gchar* _tmp610_ = NULL;
																		gchar* _tmp611_ = NULL;
																		gchar* _tmp612_ = NULL;
																		gboolean _tmp613_ = FALSE;
																		_tmp609_ = nv;
																		_tmp609__length1 = nv_length1;
																		_tmp610_ = _tmp609_[1];
																		_tmp611_ = vala_gidl_parser_eval (self, _tmp610_);
																		_tmp612_ = _tmp611_;
																		_tmp613_ = g_strcmp0 (_tmp612_, "1") == 0;
																		_g_free0 (_tmp612_);
																		if (_tmp613_) {
																			ValaParameter* _tmp614_ = NULL;
																			_tmp614_ = p;
																			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp614_, "CCode", "array_length", FALSE, NULL);
																		}
																	} else {
																		gchar** _tmp615_ = NULL;
																		gint _tmp615__length1 = 0;
																		const gchar* _tmp616_ = NULL;
																		_tmp615_ = nv;
																		_tmp615__length1 = nv_length1;
																		_tmp616_ = _tmp615_[0];
																		if (g_strcmp0 (_tmp616_, "array_length_type") == 0) {
																			ValaParameter* _tmp617_ = NULL;
																			gchar** _tmp618_ = NULL;
																			gint _tmp618__length1 = 0;
																			const gchar* _tmp619_ = NULL;
																			gchar* _tmp620_ = NULL;
																			gchar* _tmp621_ = NULL;
																			_tmp617_ = p;
																			_tmp618_ = nv;
																			_tmp618__length1 = nv_length1;
																			_tmp619_ = _tmp618_[1];
																			_tmp620_ = vala_gidl_parser_eval (self, _tmp619_);
																			_tmp621_ = _tmp620_;
																			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp617_, "CCode", "array_length_type", _tmp621_, NULL);
																			_g_free0 (_tmp621_);
																		} else {
																			gchar** _tmp622_ = NULL;
																			gint _tmp622__length1 = 0;
																			const gchar* _tmp623_ = NULL;
																			_tmp622_ = nv;
																			_tmp622__length1 = nv_length1;
																			_tmp623_ = _tmp622_[0];
																			if (g_strcmp0 (_tmp623_, "array_null_terminated") == 0) {
																				gchar** _tmp624_ = NULL;
																				gint _tmp624__length1 = 0;
																				const gchar* _tmp625_ = NULL;
																				gchar* _tmp626_ = NULL;
																				gchar* _tmp627_ = NULL;
																				gboolean _tmp628_ = FALSE;
																				_tmp624_ = nv;
																				_tmp624__length1 = nv_length1;
																				_tmp625_ = _tmp624_[1];
																				_tmp626_ = vala_gidl_parser_eval (self, _tmp625_);
																				_tmp627_ = _tmp626_;
																				_tmp628_ = g_strcmp0 (_tmp627_, "1") == 0;
																				_g_free0 (_tmp627_);
																				if (_tmp628_) {
																					ValaParameter* _tmp629_ = NULL;
																					ValaParameter* _tmp630_ = NULL;
																					_tmp629_ = p;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp629_, "CCode", "array_length", FALSE, NULL);
																					_tmp630_ = p;
																					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp630_, "CCode", "array_null_terminated", TRUE, NULL);
																				}
																			} else {
																				gchar** _tmp631_ = NULL;
																				gint _tmp631__length1 = 0;
																				const gchar* _tmp632_ = NULL;
																				_tmp631_ = nv;
																				_tmp631__length1 = nv_length1;
																				_tmp632_ = _tmp631_[0];
																				if (g_strcmp0 (_tmp632_, "array_length_pos") == 0) {
																					gchar** _tmp633_ = NULL;
																					gint _tmp633__length1 = 0;
																					const gchar* _tmp634_ = NULL;
																					gchar* _tmp635_ = NULL;
																					gchar* _tmp636_ = NULL;
																					gdouble _tmp637_ = 0.0;
																					set_array_length_pos = TRUE;
																					_tmp633_ = nv;
																					_tmp633__length1 = nv_length1;
																					_tmp634_ = _tmp633_[1];
																					_tmp635_ = vala_gidl_parser_eval (self, _tmp634_);
																					_tmp636_ = _tmp635_;
																					_tmp637_ = double_parse (_tmp636_);
																					array_length_pos = _tmp637_;
																					_g_free0 (_tmp636_);
																				} else {
																					gchar** _tmp638_ = NULL;
																					gint _tmp638__length1 = 0;
																					const gchar* _tmp639_ = NULL;
																					_tmp638_ = nv;
																					_tmp638__length1 = nv_length1;
																					_tmp639_ = _tmp638_[0];
																					if (g_strcmp0 (_tmp639_, "delegate_target_pos") == 0) {
																						gchar** _tmp640_ = NULL;
																						gint _tmp640__length1 = 0;
																						const gchar* _tmp641_ = NULL;
																						gchar* _tmp642_ = NULL;
																						gchar* _tmp643_ = NULL;
																						gdouble _tmp644_ = 0.0;
																						set_delegate_target_pos = TRUE;
																						_tmp640_ = nv;
																						_tmp640__length1 = nv_length1;
																						_tmp641_ = _tmp640_[1];
																						_tmp642_ = vala_gidl_parser_eval (self, _tmp641_);
																						_tmp643_ = _tmp642_;
																						_tmp644_ = double_parse (_tmp643_);
																						delegate_target_pos = _tmp644_;
																						_g_free0 (_tmp643_);
																					} else {
																						gchar** _tmp645_ = NULL;
																						gint _tmp645__length1 = 0;
																						const gchar* _tmp646_ = NULL;
																						_tmp645_ = nv;
																						_tmp645__length1 = nv_length1;
																						_tmp646_ = _tmp645_[0];
																						if (g_strcmp0 (_tmp646_, "type_name") == 0) {
																							ValaParameter* _tmp647_ = NULL;
																							gchar** _tmp648_ = NULL;
																							gint _tmp648__length1 = 0;
																							const gchar* _tmp649_ = NULL;
																							gchar* _tmp650_ = NULL;
																							gchar* _tmp651_ = NULL;
																							ValaDataType* _tmp652_ = NULL;
																							ValaDataType* _tmp653_ = NULL;
																							_tmp647_ = p;
																							_tmp648_ = nv;
																							_tmp648__length1 = nv_length1;
																							_tmp649_ = _tmp648_[1];
																							_tmp650_ = vala_gidl_parser_eval (self, _tmp649_);
																							_tmp651_ = _tmp650_;
																							_tmp652_ = vala_gidl_parser_parse_type_from_string (self, _tmp651_, FALSE, NULL);
																							_vala_code_node_unref0 (param_type);
																							param_type = _tmp652_;
																							_tmp653_ = param_type;
																							vala_variable_set_variable_type ((ValaVariable*) _tmp647_, _tmp653_);
																							_g_free0 (_tmp651_);
																						} else {
																							gchar** _tmp654_ = NULL;
																							gint _tmp654__length1 = 0;
																							const gchar* _tmp655_ = NULL;
																							_tmp654_ = nv;
																							_tmp654__length1 = nv_length1;
																							_tmp655_ = _tmp654_[0];
																							if (g_strcmp0 (_tmp655_, "ctype") == 0) {
																								ValaParameter* _tmp656_ = NULL;
																								gchar** _tmp657_ = NULL;
																								gint _tmp657__length1 = 0;
																								const gchar* _tmp658_ = NULL;
																								gchar* _tmp659_ = NULL;
																								gchar* _tmp660_ = NULL;
																								_tmp656_ = p;
																								_tmp657_ = nv;
																								_tmp657__length1 = nv_length1;
																								_tmp658_ = _tmp657_[1];
																								_tmp659_ = vala_gidl_parser_eval (self, _tmp658_);
																								_tmp660_ = _tmp659_;
																								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp656_, "CCode", "type", _tmp660_, NULL);
																								_g_free0 (_tmp660_);
																							} else {
																								gchar** _tmp661_ = NULL;
																								gint _tmp661__length1 = 0;
																								const gchar* _tmp662_ = NULL;
																								_tmp661_ = nv;
																								_tmp661__length1 = nv_length1;
																								_tmp662_ = _tmp661_[0];
																								if (g_strcmp0 (_tmp662_, "scope") == 0) {
																									ValaParameter* _tmp663_ = NULL;
																									gchar** _tmp664_ = NULL;
																									gint _tmp664__length1 = 0;
																									const gchar* _tmp665_ = NULL;
																									gchar* _tmp666_ = NULL;
																									gchar* _tmp667_ = NULL;
																									_tmp663_ = p;
																									_tmp664_ = nv;
																									_tmp664__length1 = nv_length1;
																									_tmp665_ = _tmp664_[1];
																									_tmp666_ = vala_gidl_parser_eval (self, _tmp665_);
																									_tmp667_ = _tmp666_;
																									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp663_, "CCode", "scope", _tmp667_, NULL);
																									_g_free0 (_tmp667_);
																								} else {
																									gchar** _tmp668_ = NULL;
																									gint _tmp668__length1 = 0;
																									const gchar* _tmp669_ = NULL;
																									_tmp668_ = nv;
																									_tmp668__length1 = nv_length1;
																									_tmp669_ = _tmp668_[0];
																									if (g_strcmp0 (_tmp669_, "type_arguments") == 0) {
																										ValaDataType* _tmp670_ = NULL;
																										gchar** _tmp671_ = NULL;
																										gint _tmp671__length1 = 0;
																										const gchar* _tmp672_ = NULL;
																										gchar* _tmp673_ = NULL;
																										gchar* _tmp674_ = NULL;
																										_tmp670_ = param_type;
																										_tmp671_ = nv;
																										_tmp671__length1 = nv_length1;
																										_tmp672_ = _tmp671_[1];
																										_tmp673_ = vala_gidl_parser_eval (self, _tmp672_);
																										_tmp674_ = _tmp673_;
																										vala_gidl_parser_parse_type_arguments_from_string (self, _tmp670_, _tmp674_, NULL);
																										_g_free0 (_tmp674_);
																									} else {
																										gchar** _tmp675_ = NULL;
																										gint _tmp675__length1 = 0;
																										const gchar* _tmp676_ = NULL;
																										_tmp675_ = nv;
																										_tmp675__length1 = nv_length1;
																										_tmp676_ = _tmp675_[0];
																										if (g_strcmp0 (_tmp676_, "default_value") == 0) {
																											gchar* val = NULL;
																											gchar** _tmp677_ = NULL;
																											gint _tmp677__length1 = 0;
																											const gchar* _tmp678_ = NULL;
																											gchar* _tmp679_ = NULL;
																											const gchar* _tmp680_ = NULL;
																											_tmp677_ = nv;
																											_tmp677__length1 = nv_length1;
																											_tmp678_ = _tmp677_[1];
																											_tmp679_ = vala_gidl_parser_eval (self, _tmp678_);
																											val = _tmp679_;
																											_tmp680_ = val;
																											if (g_strcmp0 (_tmp680_, "null") == 0) {
																												ValaParameter* _tmp681_ = NULL;
																												ValaDataType* _tmp682_ = NULL;
																												ValaSourceReference* _tmp683_ = NULL;
																												ValaSourceReference* _tmp684_ = NULL;
																												ValaNullLiteral* _tmp685_ = NULL;
																												ValaNullLiteral* _tmp686_ = NULL;
																												_tmp681_ = p;
																												_tmp682_ = param_type;
																												_tmp683_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp682_);
																												_tmp684_ = _tmp683_;
																												_tmp685_ = vala_null_literal_new (_tmp684_);
																												_tmp686_ = _tmp685_;
																												vala_variable_set_initializer ((ValaVariable*) _tmp681_, (ValaExpression*) _tmp686_);
																												_vala_code_node_unref0 (_tmp686_);
																											} else {
																												const gchar* _tmp687_ = NULL;
																												_tmp687_ = val;
																												if (g_strcmp0 (_tmp687_, "true") == 0) {
																													ValaParameter* _tmp688_ = NULL;
																													ValaDataType* _tmp689_ = NULL;
																													ValaSourceReference* _tmp690_ = NULL;
																													ValaSourceReference* _tmp691_ = NULL;
																													ValaBooleanLiteral* _tmp692_ = NULL;
																													ValaBooleanLiteral* _tmp693_ = NULL;
																													_tmp688_ = p;
																													_tmp689_ = param_type;
																													_tmp690_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp689_);
																													_tmp691_ = _tmp690_;
																													_tmp692_ = vala_boolean_literal_new (TRUE, _tmp691_);
																													_tmp693_ = _tmp692_;
																													vala_variable_set_initializer ((ValaVariable*) _tmp688_, (ValaExpression*) _tmp693_);
																													_vala_code_node_unref0 (_tmp693_);
																												} else {
																													const gchar* _tmp694_ = NULL;
																													_tmp694_ = val;
																													if (g_strcmp0 (_tmp694_, "false") == 0) {
																														ValaParameter* _tmp695_ = NULL;
																														ValaDataType* _tmp696_ = NULL;
																														ValaSourceReference* _tmp697_ = NULL;
																														ValaSourceReference* _tmp698_ = NULL;
																														ValaBooleanLiteral* _tmp699_ = NULL;
																														ValaBooleanLiteral* _tmp700_ = NULL;
																														_tmp695_ = p;
																														_tmp696_ = param_type;
																														_tmp697_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp696_);
																														_tmp698_ = _tmp697_;
																														_tmp699_ = vala_boolean_literal_new (FALSE, _tmp698_);
																														_tmp700_ = _tmp699_;
																														vala_variable_set_initializer ((ValaVariable*) _tmp695_, (ValaExpression*) _tmp700_);
																														_vala_code_node_unref0 (_tmp700_);
																													} else {
																														const gchar* _tmp701_ = NULL;
																														_tmp701_ = val;
																														if (g_strcmp0 (_tmp701_, "") == 0) {
																															ValaParameter* _tmp702_ = NULL;
																															ValaDataType* _tmp703_ = NULL;
																															ValaSourceReference* _tmp704_ = NULL;
																															ValaSourceReference* _tmp705_ = NULL;
																															ValaStringLiteral* _tmp706_ = NULL;
																															ValaStringLiteral* _tmp707_ = NULL;
																															_tmp702_ = p;
																															_tmp703_ = param_type;
																															_tmp704_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp703_);
																															_tmp705_ = _tmp704_;
																															_tmp706_ = vala_string_literal_new ("\"\"", _tmp705_);
																															_tmp707_ = _tmp706_;
																															vala_variable_set_initializer ((ValaVariable*) _tmp702_, (ValaExpression*) _tmp707_);
																															_vala_code_node_unref0 (_tmp707_);
																														} else {
																															const gchar* _tmp708_ = NULL;
																															gboolean _tmp709_ = FALSE;
																															_tmp708_ = val;
																															_tmp709_ = int64_try_parse (_tmp708_, NULL);
																															if (_tmp709_) {
																																ValaParameter* _tmp710_ = NULL;
																																const gchar* _tmp711_ = NULL;
																																ValaDataType* _tmp712_ = NULL;
																																ValaSourceReference* _tmp713_ = NULL;
																																ValaSourceReference* _tmp714_ = NULL;
																																ValaIntegerLiteral* _tmp715_ = NULL;
																																ValaIntegerLiteral* _tmp716_ = NULL;
																																_tmp710_ = p;
																																_tmp711_ = val;
																																_tmp712_ = param_type;
																																_tmp713_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp712_);
																																_tmp714_ = _tmp713_;
																																_tmp715_ = vala_integer_literal_new (_tmp711_, _tmp714_);
																																_tmp716_ = _tmp715_;
																																vala_variable_set_initializer ((ValaVariable*) _tmp710_, (ValaExpression*) _tmp716_);
																																_vala_code_node_unref0 (_tmp716_);
																															} else {
																																const gchar* _tmp717_ = NULL;
																																gboolean _tmp718_ = FALSE;
																																_tmp717_ = val;
																																_tmp718_ = double_try_parse (_tmp717_, NULL);
																																if (_tmp718_) {
																																	ValaParameter* _tmp719_ = NULL;
																																	const gchar* _tmp720_ = NULL;
																																	ValaDataType* _tmp721_ = NULL;
																																	ValaSourceReference* _tmp722_ = NULL;
																																	ValaSourceReference* _tmp723_ = NULL;
																																	ValaRealLiteral* _tmp724_ = NULL;
																																	ValaRealLiteral* _tmp725_ = NULL;
																																	_tmp719_ = p;
																																	_tmp720_ = val;
																																	_tmp721_ = param_type;
																																	_tmp722_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp721_);
																																	_tmp723_ = _tmp722_;
																																	_tmp724_ = vala_real_literal_new (_tmp720_, _tmp723_);
																																	_tmp725_ = _tmp724_;
																																	vala_variable_set_initializer ((ValaVariable*) _tmp719_, (ValaExpression*) _tmp725_);
																																	_vala_code_node_unref0 (_tmp725_);
																																} else {
																																	gboolean _tmp726_ = FALSE;
																																	const gchar* _tmp727_ = NULL;
																																	gboolean _tmp728_ = FALSE;
																																	_tmp727_ = val;
																																	_tmp728_ = g_str_has_prefix (_tmp727_, "\"");
																																	if (_tmp728_) {
																																		const gchar* _tmp729_ = NULL;
																																		gboolean _tmp730_ = FALSE;
																																		_tmp729_ = val;
																																		_tmp730_ = g_str_has_suffix (_tmp729_, "\"");
																																		_tmp726_ = _tmp730_;
																																	} else {
																																		_tmp726_ = FALSE;
																																	}
																																	if (_tmp726_) {
																																		ValaParameter* _tmp731_ = NULL;
																																		const gchar* _tmp732_ = NULL;
																																		ValaDataType* _tmp733_ = NULL;
																																		ValaSourceReference* _tmp734_ = NULL;
																																		ValaSourceReference* _tmp735_ = NULL;
																																		ValaStringLiteral* _tmp736_ = NULL;
																																		ValaStringLiteral* _tmp737_ = NULL;
																																		_tmp731_ = p;
																																		_tmp732_ = val;
																																		_tmp733_ = param_type;
																																		_tmp734_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp733_);
																																		_tmp735_ = _tmp734_;
																																		_tmp736_ = vala_string_literal_new (_tmp732_, _tmp735_);
																																		_tmp737_ = _tmp736_;
																																		vala_variable_set_initializer ((ValaVariable*) _tmp731_, (ValaExpression*) _tmp737_);
																																		_vala_code_node_unref0 (_tmp737_);
																																	} else {
																																		const gchar* _tmp738_ = NULL;
																																		gchar** _tmp739_ = NULL;
																																		gchar** _tmp740_ = NULL;
																																		_tmp738_ = val;
																																		_tmp740_ = _tmp739_ = g_strsplit (_tmp738_, ".", 0);
																																		{
																																			gchar** member_collection = NULL;
																																			gint member_collection_length1 = 0;
																																			gint _member_collection_size_ = 0;
																																			gint member_it = 0;
																																			member_collection = _tmp740_;
																																			member_collection_length1 = _vala_array_length (_tmp739_);
																																			for (member_it = 0; member_it < _vala_array_length (_tmp739_); member_it = member_it + 1) {
																																				gchar* _tmp741_ = NULL;
																																				gchar* member = NULL;
																																				_tmp741_ = g_strdup (member_collection[member_it]);
																																				member = _tmp741_;
																																				{
																																					ValaParameter* _tmp742_ = NULL;
																																					ValaParameter* _tmp743_ = NULL;
																																					ValaExpression* _tmp744_ = NULL;
																																					ValaExpression* _tmp745_ = NULL;
																																					const gchar* _tmp746_ = NULL;
																																					ValaDataType* _tmp747_ = NULL;
																																					ValaSourceReference* _tmp748_ = NULL;
																																					ValaSourceReference* _tmp749_ = NULL;
																																					ValaMemberAccess* _tmp750_ = NULL;
																																					ValaMemberAccess* _tmp751_ = NULL;
																																					_tmp742_ = p;
																																					_tmp743_ = p;
																																					_tmp744_ = vala_variable_get_initializer ((ValaVariable*) _tmp743_);
																																					_tmp745_ = _tmp744_;
																																					_tmp746_ = member;
																																					_tmp747_ = param_type;
																																					_tmp748_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp747_);
																																					_tmp749_ = _tmp748_;
																																					_tmp750_ = vala_member_access_new (_tmp745_, _tmp746_, _tmp749_);
																																					_tmp751_ = _tmp750_;
																																					vala_variable_set_initializer ((ValaVariable*) _tmp742_, (ValaExpression*) _tmp751_);
																																					_vala_code_node_unref0 (_tmp751_);
																																					_g_free0 (member);
																																				}
																																			}
																																			member_collection = (_vala_array_free (member_collection, member_collection_length1, (GDestroyNotify) g_free), NULL);
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																											_g_free0 (val);
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
				}
				_tmp753_ = last_param;
				if (_tmp753_ != NULL) {
					ValaParameter* _tmp754_ = NULL;
					const gchar* _tmp755_ = NULL;
					const gchar* _tmp756_ = NULL;
					ValaParameter* _tmp757_ = NULL;
					const gchar* _tmp758_ = NULL;
					const gchar* _tmp759_ = NULL;
					gchar* _tmp760_ = NULL;
					gchar* _tmp761_ = NULL;
					_tmp754_ = p;
					_tmp755_ = vala_symbol_get_name ((ValaSymbol*) _tmp754_);
					_tmp756_ = _tmp755_;
					_tmp757_ = last_param;
					_tmp758_ = vala_symbol_get_name ((ValaSymbol*) _tmp757_);
					_tmp759_ = _tmp758_;
					_tmp760_ = g_strconcat ("n_", _tmp759_, NULL);
					_tmp761_ = _tmp760_;
					_tmp752_ = g_strcmp0 (_tmp756_, _tmp761_) == 0;
					_g_free0 (_tmp761_);
				} else {
					_tmp752_ = FALSE;
				}
				if (_tmp752_) {
					ValaDataType* _tmp762_ = NULL;
					_tmp762_ = last_param_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp762_, VALA_TYPE_ARRAY_TYPE)) {
						ValaDataType* _tmp763_ = NULL;
						ValaDataType* _tmp764_ = NULL;
						ValaDataType* _tmp765_ = NULL;
						ValaSourceReference* _tmp766_ = NULL;
						ValaSourceReference* _tmp767_ = NULL;
						ValaArrayType* _tmp768_ = NULL;
						ValaParameter* _tmp769_ = NULL;
						ValaDataType* _tmp770_ = NULL;
						ValaParameter* _tmp771_ = NULL;
						_tmp763_ = last_param_type;
						vala_data_type_set_value_owned (_tmp763_, TRUE);
						_tmp764_ = last_param_type;
						_tmp765_ = last_param_type;
						_tmp766_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp765_);
						_tmp767_ = _tmp766_;
						_tmp768_ = vala_array_type_new (_tmp764_, 1, _tmp767_);
						_vala_code_node_unref0 (last_param_type);
						last_param_type = (ValaDataType*) _tmp768_;
						_tmp769_ = last_param;
						_tmp770_ = last_param_type;
						vala_variable_set_variable_type ((ValaVariable*) _tmp769_, _tmp770_);
						_tmp771_ = last_param;
						vala_parameter_set_direction (_tmp771_, VALA_PARAMETER_DIRECTION_IN);
					}
					hide_param = TRUE;
				} else {
					gboolean _tmp772_ = FALSE;
					ValaParameter* _tmp773_ = NULL;
					_tmp773_ = last_param;
					if (_tmp773_ != NULL) {
						ValaParameter* _tmp774_ = NULL;
						const gchar* _tmp775_ = NULL;
						const gchar* _tmp776_ = NULL;
						_tmp774_ = p;
						_tmp775_ = vala_symbol_get_name ((ValaSymbol*) _tmp774_);
						_tmp776_ = _tmp775_;
						_tmp772_ = g_strcmp0 (_tmp776_, "user_data") == 0;
					} else {
						_tmp772_ = FALSE;
					}
					if (_tmp772_) {
						hide_param = TRUE;
					}
				}
				_tmp778_ = show_param;
				if (_tmp778_) {
					_tmp777_ = TRUE;
				} else {
					gboolean _tmp779_ = FALSE;
					_tmp779_ = hide_param;
					_tmp777_ = !_tmp779_;
				}
				if (_tmp777_) {
					ValaMethod* _tmp780_ = NULL;
					ValaParameter* _tmp781_ = NULL;
					gboolean _tmp782_ = FALSE;
					gboolean _tmp785_ = FALSE;
					_tmp780_ = m;
					_tmp781_ = p;
					vala_method_add_parameter (_tmp780_, _tmp781_);
					_tmp782_ = set_array_length_pos;
					if (_tmp782_) {
						ValaParameter* _tmp783_ = NULL;
						gdouble _tmp784_ = 0.0;
						_tmp783_ = p;
						_tmp784_ = array_length_pos;
						vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp783_, "CCode", "array_length_pos", _tmp784_, NULL);
					}
					_tmp785_ = set_delegate_target_pos;
					if (_tmp785_) {
						ValaParameter* _tmp786_ = NULL;
						gdouble _tmp787_ = 0.0;
						_tmp786_ = p;
						_tmp787_ = delegate_target_pos;
						vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp786_, "CCode", "delegate_target_pos", _tmp787_, NULL);
					}
				}
				_tmp788_ = p;
				_tmp789_ = _vala_code_node_ref0 (_tmp788_);
				_vala_code_node_unref0 (last_param);
				last_param = _tmp789_;
				_tmp790_ = param_type;
				_tmp791_ = _vala_code_node_ref0 (_tmp790_);
				_vala_code_node_unref0 (last_param_type);
				last_param_type = _tmp791_;
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
				_g_free0 (param_name);
			}
		}
	}
	_tmp793_ = suppress_throws;
	if (_tmp793_ == FALSE) {
		const gchar* _tmp794_ = NULL;
		_tmp794_ = error_types;
		_tmp792_ = _tmp794_ != NULL;
	} else {
		_tmp792_ = FALSE;
	}
	if (_tmp792_) {
		gchar** type_args = NULL;
		const gchar* _tmp795_ = NULL;
		gchar* _tmp796_ = NULL;
		gchar* _tmp797_ = NULL;
		gchar** _tmp798_ = NULL;
		gchar** _tmp799_ = NULL;
		gchar** _tmp800_ = NULL;
		gint _tmp800__length1 = 0;
		gint type_args_length1 = 0;
		gint _type_args_size_ = 0;
		gchar** _tmp801_ = NULL;
		gint _tmp801__length1 = 0;
		_tmp795_ = error_types;
		_tmp796_ = vala_gidl_parser_eval (self, _tmp795_);
		_tmp797_ = _tmp796_;
		_tmp799_ = _tmp798_ = g_strsplit (_tmp797_, ",", 0);
		_tmp800_ = _tmp799_;
		_tmp800__length1 = _vala_array_length (_tmp798_);
		_g_free0 (_tmp797_);
		type_args = _tmp800_;
		type_args_length1 = _tmp800__length1;
		_type_args_size_ = type_args_length1;
		_tmp801_ = type_args;
		_tmp801__length1 = type_args_length1;
		{
			gchar** type_arg_collection = NULL;
			gint type_arg_collection_length1 = 0;
			gint _type_arg_collection_size_ = 0;
			gint type_arg_it = 0;
			type_arg_collection = _tmp801_;
			type_arg_collection_length1 = _tmp801__length1;
			for (type_arg_it = 0; type_arg_it < _tmp801__length1; type_arg_it = type_arg_it + 1) {
				gchar* _tmp802_ = NULL;
				gchar* type_arg = NULL;
				_tmp802_ = g_strdup (type_arg_collection[type_arg_it]);
				type_arg = _tmp802_;
				{
					ValaMethod* _tmp803_ = NULL;
					const gchar* _tmp804_ = NULL;
					ValaDataType* _tmp805_ = NULL;
					ValaDataType* _tmp806_ = NULL;
					_tmp803_ = m;
					_tmp804_ = type_arg;
					_tmp805_ = vala_gidl_parser_parse_type_from_string (self, _tmp804_, TRUE, NULL);
					_tmp806_ = _tmp805_;
					vala_code_node_add_error_type ((ValaCodeNode*) _tmp803_, _tmp806_);
					_vala_code_node_unref0 (_tmp806_);
					_g_free0 (type_arg);
				}
			}
		}
		type_args = (_vala_array_free (type_args, type_args_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp807_ = first;
	if (_tmp807_) {
		ValaMethod* _tmp808_ = NULL;
		_tmp808_ = m;
		vala_method_set_binding (_tmp808_, VALA_MEMBER_BINDING_STATIC);
	}
	_tmp810_ = last_param;
	if (_tmp810_ != NULL) {
		ValaParameter* _tmp811_ = NULL;
		const gchar* _tmp812_ = NULL;
		const gchar* _tmp813_ = NULL;
		gboolean _tmp814_ = FALSE;
		_tmp811_ = last_param;
		_tmp812_ = vala_symbol_get_name ((ValaSymbol*) _tmp811_);
		_tmp813_ = _tmp812_;
		_tmp814_ = g_str_has_prefix (_tmp813_, "first_");
		_tmp809_ = _tmp814_;
	} else {
		_tmp809_ = FALSE;
	}
	if (_tmp809_) {
		ValaParameter* _tmp815_ = NULL;
		_tmp815_ = last_param;
		vala_parameter_set_ellipsis (_tmp815_, TRUE);
	} else {
		gboolean _tmp816_ = FALSE;
		_tmp816_ = add_ellipsis;
		if (_tmp816_) {
			ValaMethod* _tmp817_ = NULL;
			ValaParameter* _tmp818_ = NULL;
			ValaParameter* _tmp819_ = NULL;
			_tmp817_ = m;
			_tmp818_ = vala_parameter_new_with_ellipsis (NULL);
			_tmp819_ = _tmp818_;
			vala_method_add_parameter (_tmp817_, _tmp819_);
			_vala_code_node_unref0 (_tmp819_);
		}
	}
	_tmp820_ = container;
	if (_tmp820_ == NULL) {
		ValaTypeSymbol* _tmp821_ = NULL;
		ValaSymbol* _tmp822_ = NULL;
		ValaSymbol* _tmp823_ = NULL;
		_tmp821_ = self->priv->current_data_type;
		_tmp822_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp821_);
		_vala_code_node_unref0 (container);
		container = _tmp822_;
		_tmp823_ = container;
		if (_tmp823_ == NULL) {
			ValaNamespace* _tmp824_ = NULL;
			ValaSymbol* _tmp825_ = NULL;
			_tmp824_ = self->priv->current_namespace;
			_tmp825_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp824_);
			_vala_code_node_unref0 (container);
			container = _tmp825_;
		}
	}
	_tmp826_ = symbol;
	_tmp827_ = m;
	_tmp828_ = container;
	_tmp829_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp827_, _tmp828_);
	_tmp830_ = _tmp829_;
	_tmp831_ = g_strcmp0 (_tmp826_, _tmp830_) != 0;
	_g_free0 (_tmp830_);
	if (_tmp831_) {
		ValaMethod* _tmp832_ = NULL;
		const gchar* _tmp833_ = NULL;
		_tmp832_ = m;
		_tmp833_ = symbol;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp832_, "CCode", "cname", _tmp833_, NULL);
	}
	result = m;
	_vala_code_node_unref0 (last_param_type);
	_vala_code_node_unref0 (last_param);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (container);
	_g_free0 (error_types);
	_vala_code_node_unref0 (return_type);
	return result;
}


static gchar* string_chomp (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strchomp (_tmp1_);
	result = _result_;
	return result;
}


static gboolean vala_gidl_parser_param_is_exception (ValaGIdlParser* self, GIdlNodeParam* param) {
	gboolean result = FALSE;
	GIdlNodeParam* _tmp0_ = NULL;
	GIdlNodeType* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gchar* s = NULL;
	GIdlNodeParam* _tmp3_ = NULL;
	GIdlNodeType* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (param != NULL, FALSE);
	_tmp0_ = param;
	_tmp1_ = _tmp0_->type;
	_tmp2_ = _tmp1_->is_error;
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = param;
	_tmp4_ = _tmp3_->type;
	_tmp5_ = _tmp4_->unparsed;
	_tmp6_ = string_chomp (_tmp5_);
	s = _tmp6_;
	_tmp7_ = s;
	_tmp8_ = g_str_has_suffix (_tmp7_, "**");
	if (_tmp8_) {
		result = TRUE;
		_g_free0 (s);
		return result;
	}
	result = FALSE;
	_g_free0 (s);
	return result;
}


static ValaMethod* vala_gidl_parser_parse_function (ValaGIdlParser* self, GIdlNodeFunction* f, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNode* node = NULL;
	GIdlNodeFunction* _tmp0_ = NULL;
	GIdlNodeFunction* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GIdlNode* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GIdlNodeFunction* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GIdlNodeFunction* _tmp7_ = NULL;
	GIdlNodeParam* _tmp8_ = NULL;
	GIdlNodeFunction* _tmp9_ = NULL;
	GList* _tmp10_ = NULL;
	GIdlNodeFunction* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaMethod* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	_tmp0_ = f;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = f;
	_tmp2_ = _tmp1_->deprecated;
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	_tmp3_ = node;
	_tmp4_ = _tmp3_->name;
	_tmp5_ = f;
	_tmp6_ = _tmp5_->symbol;
	_tmp7_ = f;
	_tmp8_ = _tmp7_->result;
	_tmp9_ = f;
	_tmp10_ = _tmp9_->parameters;
	_tmp11_ = f;
	_tmp12_ = _tmp11_->is_constructor;
	_tmp13_ = is_interface;
	_tmp14_ = vala_gidl_parser_create_method (self, _tmp4_, _tmp6_, _tmp8_, _tmp10_, _tmp12_, _tmp13_);
	result = _tmp14_;
	return result;
}


static ValaMethod* vala_gidl_parser_parse_virtual (ValaGIdlParser* self, GIdlNodeVFunc* v, GIdlNodeFunction* func, gboolean is_interface) {
	ValaMethod* result = NULL;
	GIdlNode* node = NULL;
	GIdlNodeVFunc* _tmp0_ = NULL;
	gchar* symbol = NULL;
	ValaTypeSymbol* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GIdlNode* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GIdlNodeFunction* _tmp8_ = NULL;
	GList* _tmp12_ = NULL;
	GIdlNodeFunction* _tmp13_ = NULL;
	ValaMethod* m = NULL;
	GIdlNode* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	GIdlNodeVFunc* _tmp21_ = NULL;
	GIdlNodeParam* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	ValaMethod* _tmp24_ = NULL;
	ValaMethod* _tmp25_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (v != NULL, NULL);
	_tmp0_ = v;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = self->priv->current_data_type;
	_tmp2_ = vala_gidl_parser_get_lower_case_cprefix (self, (ValaSymbol*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = node;
	_tmp5_ = _tmp4_->name;
	_tmp6_ = g_strdup_printf ("%s%s", _tmp3_, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp3_);
	symbol = _tmp7_;
	_tmp8_ = func;
	if (_tmp8_ != NULL) {
		GIdlNodeFunction* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp9_ = func;
		_tmp10_ = _tmp9_->symbol;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (symbol);
		symbol = _tmp11_;
	}
	_tmp13_ = func;
	if (_tmp13_ != NULL) {
		GIdlNodeFunction* _tmp14_ = NULL;
		GList* _tmp15_ = NULL;
		_tmp14_ = func;
		_tmp15_ = _tmp14_->parameters;
		_tmp12_ = _tmp15_;
	} else {
		GIdlNodeVFunc* _tmp16_ = NULL;
		GList* _tmp17_ = NULL;
		_tmp16_ = v;
		_tmp17_ = _tmp16_->parameters;
		_tmp12_ = _tmp17_;
	}
	_tmp18_ = node;
	_tmp19_ = _tmp18_->name;
	_tmp20_ = symbol;
	_tmp21_ = v;
	_tmp22_ = _tmp21_->result;
	_tmp23_ = is_interface;
	_tmp24_ = vala_gidl_parser_create_method (self, _tmp19_, _tmp20_, _tmp22_, _tmp12_, FALSE, _tmp23_);
	m = _tmp24_;
	_tmp25_ = m;
	if (_tmp25_ != NULL) {
		ValaMethod* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
		ValaMethod* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		ValaMethod* _tmp32_ = NULL;
		gboolean _tmp33_ = FALSE;
		ValaMethod* _tmp34_ = NULL;
		gboolean _tmp35_ = FALSE;
		gboolean _tmp36_ = FALSE;
		ValaMethod* _tmp38_ = NULL;
		gchar** attributes = NULL;
		const gchar* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		gchar** _tmp41_ = NULL;
		gint attributes_length1 = 0;
		gint _attributes_size_ = 0;
		gchar** _tmp42_ = NULL;
		gint _tmp42__length1 = 0;
		GIdlNodeFunction* _tmp59_ = NULL;
		_tmp26_ = m;
		vala_method_set_binding (_tmp26_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp28_ = m;
		_tmp29_ = vala_method_get_is_abstract (_tmp28_);
		_tmp30_ = _tmp29_;
		if (_tmp30_) {
			_tmp27_ = TRUE;
		} else {
			gboolean _tmp31_ = FALSE;
			_tmp31_ = is_interface;
			_tmp27_ = _tmp31_;
		}
		_tmp32_ = m;
		vala_method_set_is_virtual (_tmp32_, !_tmp27_);
		_tmp34_ = m;
		_tmp35_ = vala_method_get_is_abstract (_tmp34_);
		_tmp36_ = _tmp35_;
		if (_tmp36_) {
			_tmp33_ = TRUE;
		} else {
			gboolean _tmp37_ = FALSE;
			_tmp37_ = is_interface;
			_tmp33_ = _tmp37_;
		}
		_tmp38_ = m;
		vala_method_set_is_abstract (_tmp38_, _tmp33_);
		_tmp39_ = symbol;
		_tmp41_ = vala_gidl_parser_get_attributes (self, _tmp39_, &_tmp40_);
		attributes = _tmp41_;
		attributes_length1 = _tmp40_;
		_attributes_size_ = attributes_length1;
		_tmp42_ = attributes;
		_tmp42__length1 = attributes_length1;
		if (_tmp42_ != NULL) {
			gchar** _tmp43_ = NULL;
			gint _tmp43__length1 = 0;
			_tmp43_ = attributes;
			_tmp43__length1 = attributes_length1;
			{
				gchar** attr_collection = NULL;
				gint attr_collection_length1 = 0;
				gint _attr_collection_size_ = 0;
				gint attr_it = 0;
				attr_collection = _tmp43_;
				attr_collection_length1 = _tmp43__length1;
				for (attr_it = 0; attr_it < _tmp43__length1; attr_it = attr_it + 1) {
					gchar* _tmp44_ = NULL;
					gchar* attr = NULL;
					_tmp44_ = g_strdup (attr_collection[attr_it]);
					attr = _tmp44_;
					{
						gchar** nv = NULL;
						const gchar* _tmp45_ = NULL;
						gchar** _tmp46_ = NULL;
						gchar** _tmp47_ = NULL;
						gint nv_length1 = 0;
						gint _nv_size_ = 0;
						gchar** _tmp48_ = NULL;
						gint _tmp48__length1 = 0;
						const gchar* _tmp49_ = NULL;
						_tmp45_ = attr;
						_tmp47_ = _tmp46_ = g_strsplit (_tmp45_, "=", 2);
						nv = _tmp47_;
						nv_length1 = _vala_array_length (_tmp46_);
						_nv_size_ = nv_length1;
						_tmp48_ = nv;
						_tmp48__length1 = nv_length1;
						_tmp49_ = _tmp48_[0];
						if (g_strcmp0 (_tmp49_, "virtual") == 0) {
							gchar** _tmp50_ = NULL;
							gint _tmp50__length1 = 0;
							const gchar* _tmp51_ = NULL;
							gchar* _tmp52_ = NULL;
							gchar* _tmp53_ = NULL;
							gboolean _tmp54_ = FALSE;
							_tmp50_ = nv;
							_tmp50__length1 = nv_length1;
							_tmp51_ = _tmp50_[1];
							_tmp52_ = vala_gidl_parser_eval (self, _tmp51_);
							_tmp53_ = _tmp52_;
							_tmp54_ = g_strcmp0 (_tmp53_, "0") == 0;
							_g_free0 (_tmp53_);
							if (_tmp54_) {
								ValaMethod* _tmp55_ = NULL;
								ValaMethod* _tmp56_ = NULL;
								_tmp55_ = m;
								vala_method_set_is_virtual (_tmp55_, FALSE);
								_tmp56_ = m;
								vala_method_set_is_abstract (_tmp56_, FALSE);
							} else {
								ValaMethod* _tmp57_ = NULL;
								ValaMethod* _tmp58_ = NULL;
								_tmp57_ = m;
								vala_method_set_is_virtual (_tmp57_, TRUE);
								_tmp58_ = m;
								vala_method_set_is_abstract (_tmp58_, FALSE);
							}
						}
						nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (attr);
					}
				}
			}
		}
		_tmp59_ = func;
		if (_tmp59_ == NULL) {
			ValaMethod* _tmp60_ = NULL;
			_tmp60_ = m;
			vala_code_node_set_attribute ((ValaCodeNode*) _tmp60_, "NoWrapper", TRUE, NULL);
		}
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	}
	result = m;
	_g_free0 (symbol);
	return result;
}


static gchar* vala_gidl_parser_fix_prop_name (ValaGIdlParser* self, const gchar* name) {
	gchar* result = NULL;
	GString* str = NULL;
	GString* _tmp0_ = NULL;
	gchar* i = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GString* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_string_new ("");
	str = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = g_strdup (_tmp1_);
	i = _tmp2_;
	while (TRUE) {
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gunichar c = 0U;
		const gchar* _tmp6_ = NULL;
		gunichar _tmp7_ = 0U;
		gunichar _tmp8_ = 0U;
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		_tmp3_ = i;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!(_tmp5_ > 0)) {
			break;
		}
		_tmp6_ = i;
		_tmp7_ = string_get_char (_tmp6_, (glong) 0);
		c = _tmp7_;
		_tmp8_ = c;
		if (_tmp8_ == ((gunichar) '-')) {
			GString* _tmp9_ = NULL;
			_tmp9_ = str;
			g_string_append_c (_tmp9_, '_');
		} else {
			GString* _tmp10_ = NULL;
			gunichar _tmp11_ = 0U;
			_tmp10_ = str;
			_tmp11_ = c;
			g_string_append_unichar (_tmp10_, _tmp11_);
		}
		_tmp12_ = i;
		_tmp13_ = g_utf8_next_char (_tmp12_);
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (i);
		i = _tmp14_;
	}
	_tmp15_ = str;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_free0 (i);
	_g_string_free0 (str);
	return result;
}


static ValaProperty* vala_gidl_parser_parse_property (ValaGIdlParser* self, GIdlNodeProperty* prop_node) {
	ValaProperty* result = NULL;
	GIdlNode* node = NULL;
	GIdlNodeProperty* _tmp0_ = NULL;
	GIdlNodeProperty* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GIdlNodeProperty* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	ValaProperty* prop = NULL;
	GIdlNode* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GIdlNodeProperty* _tmp14_ = NULL;
	GIdlNodeType* _tmp15_ = NULL;
	ValaDataType* _tmp16_ = NULL;
	ValaDataType* _tmp17_ = NULL;
	ValaSourceReference* _tmp18_ = NULL;
	ValaProperty* _tmp19_ = NULL;
	ValaProperty* _tmp20_ = NULL;
	ValaProperty* _tmp21_ = NULL;
	ValaProperty* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	GIdlNodeProperty* _tmp24_ = NULL;
	GIdlNodeType* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	GIdlNodeProperty* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	GIdlNodeProperty* _tmp42_ = NULL;
	gboolean _tmp43_ = FALSE;
	gchar** attributes = NULL;
	ValaTypeSymbol* _tmp65_ = NULL;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	GIdlNode* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	gchar* _tmp70_ = NULL;
	gchar* _tmp71_ = NULL;
	gint _tmp72_ = 0;
	gchar** _tmp73_ = NULL;
	gchar** _tmp74_ = NULL;
	gint _tmp74__length1 = 0;
	gint attributes_length1 = 0;
	gint _attributes_size_ = 0;
	gchar** _tmp75_ = NULL;
	gint _tmp75__length1 = 0;
	ValaSet* _tmp178_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	_tmp0_ = prop_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = prop_node;
	_tmp2_ = _tmp1_->deprecated;
	if (_tmp2_) {
		result = NULL;
		return result;
	}
	_tmp4_ = prop_node;
	_tmp5_ = _tmp4_->readable;
	if (!_tmp5_) {
		GIdlNodeProperty* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = prop_node;
		_tmp7_ = _tmp6_->writable;
		_tmp3_ = !_tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GIdlNodeProperty* _tmp8_ = NULL;
		GIdlNodeProperty* _tmp9_ = NULL;
		_tmp8_ = prop_node;
		_tmp8_->readable = TRUE;
		_tmp9_ = prop_node;
		_tmp9_->writable = TRUE;
	}
	_tmp10_ = node;
	_tmp11_ = _tmp10_->name;
	_tmp12_ = vala_gidl_parser_fix_prop_name (self, _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = prop_node;
	_tmp15_ = _tmp14_->type;
	_tmp16_ = vala_gidl_parser_parse_type (self, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	_tmp18_ = self->priv->current_source_reference;
	_tmp19_ = vala_property_new (_tmp13_, _tmp17_, NULL, NULL, _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_vala_code_node_unref0 (_tmp17_);
	_g_free0 (_tmp13_);
	prop = _tmp20_;
	_tmp21_ = prop;
	vala_symbol_set_access ((ValaSymbol*) _tmp21_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp22_ = prop;
	vala_property_set_interface_only (_tmp22_, TRUE);
	_tmp24_ = prop_node;
	_tmp25_ = _tmp24_->type;
	_tmp26_ = _tmp25_->is_interface;
	if (_tmp26_) {
		GIdlNodeProperty* _tmp27_ = NULL;
		GIdlNodeType* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		_tmp27_ = prop_node;
		_tmp28_ = _tmp27_->type;
		_tmp29_ = _tmp28_->interface;
		_tmp23_ = g_strcmp0 (_tmp29_, "GStrv") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaProperty* _tmp30_ = NULL;
		ValaProperty* _tmp31_ = NULL;
		_tmp30_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp30_, "CCode", "array_length", FALSE, NULL);
		_tmp31_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp31_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp32_ = prop_node;
	_tmp33_ = _tmp32_->readable;
	if (_tmp33_) {
		ValaProperty* _tmp34_ = NULL;
		ValaProperty* _tmp35_ = NULL;
		ValaDataType* _tmp36_ = NULL;
		ValaDataType* _tmp37_ = NULL;
		ValaDataType* _tmp38_ = NULL;
		ValaDataType* _tmp39_ = NULL;
		ValaPropertyAccessor* _tmp40_ = NULL;
		ValaPropertyAccessor* _tmp41_ = NULL;
		_tmp34_ = prop;
		_tmp35_ = prop;
		_tmp36_ = vala_property_get_property_type (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_data_type_copy (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp39_, NULL, NULL, NULL);
		_tmp41_ = _tmp40_;
		vala_property_set_get_accessor (_tmp34_, _tmp41_);
		_vala_code_node_unref0 (_tmp41_);
		_vala_code_node_unref0 (_tmp39_);
	}
	_tmp42_ = prop_node;
	_tmp43_ = _tmp42_->writable;
	if (_tmp43_) {
		ValaProperty* _tmp44_ = NULL;
		ValaProperty* _tmp45_ = NULL;
		ValaDataType* _tmp46_ = NULL;
		ValaDataType* _tmp47_ = NULL;
		ValaDataType* _tmp48_ = NULL;
		ValaDataType* _tmp49_ = NULL;
		ValaPropertyAccessor* _tmp50_ = NULL;
		ValaPropertyAccessor* _tmp51_ = NULL;
		GIdlNodeProperty* _tmp52_ = NULL;
		gboolean _tmp53_ = FALSE;
		_tmp44_ = prop;
		_tmp45_ = prop;
		_tmp46_ = vala_property_get_property_type (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_data_type_copy (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_property_accessor_new (FALSE, FALSE, FALSE, _tmp49_, NULL, NULL, NULL);
		_tmp51_ = _tmp50_;
		vala_property_set_set_accessor (_tmp44_, _tmp51_);
		_vala_code_node_unref0 (_tmp51_);
		_vala_code_node_unref0 (_tmp49_);
		_tmp52_ = prop_node;
		_tmp53_ = _tmp52_->construct_only;
		if (_tmp53_) {
			ValaProperty* _tmp54_ = NULL;
			ValaPropertyAccessor* _tmp55_ = NULL;
			ValaPropertyAccessor* _tmp56_ = NULL;
			_tmp54_ = prop;
			_tmp55_ = vala_property_get_set_accessor (_tmp54_);
			_tmp56_ = _tmp55_;
			vala_property_accessor_set_construction (_tmp56_, TRUE);
		} else {
			ValaProperty* _tmp57_ = NULL;
			ValaPropertyAccessor* _tmp58_ = NULL;
			ValaPropertyAccessor* _tmp59_ = NULL;
			ValaProperty* _tmp60_ = NULL;
			ValaPropertyAccessor* _tmp61_ = NULL;
			ValaPropertyAccessor* _tmp62_ = NULL;
			GIdlNodeProperty* _tmp63_ = NULL;
			gboolean _tmp64_ = FALSE;
			_tmp57_ = prop;
			_tmp58_ = vala_property_get_set_accessor (_tmp57_);
			_tmp59_ = _tmp58_;
			vala_property_accessor_set_writable (_tmp59_, TRUE);
			_tmp60_ = prop;
			_tmp61_ = vala_property_get_set_accessor (_tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = prop_node;
			_tmp64_ = _tmp63_->construct;
			vala_property_accessor_set_construction (_tmp62_, _tmp64_);
		}
	}
	_tmp65_ = self->priv->current_data_type;
	_tmp66_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp65_, NULL);
	_tmp67_ = _tmp66_;
	_tmp68_ = node;
	_tmp69_ = _tmp68_->name;
	_tmp70_ = g_strdup_printf ("%s:%s", _tmp67_, _tmp69_);
	_tmp71_ = _tmp70_;
	_tmp73_ = vala_gidl_parser_get_attributes (self, _tmp71_, &_tmp72_);
	_tmp74_ = _tmp73_;
	_tmp74__length1 = _tmp72_;
	_g_free0 (_tmp71_);
	_g_free0 (_tmp67_);
	attributes = _tmp74_;
	attributes_length1 = _tmp74__length1;
	_attributes_size_ = attributes_length1;
	_tmp75_ = attributes;
	_tmp75__length1 = attributes_length1;
	if (_tmp75_ != NULL) {
		gchar** _tmp76_ = NULL;
		gint _tmp76__length1 = 0;
		_tmp76_ = attributes;
		_tmp76__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp76_;
			attr_collection_length1 = _tmp76__length1;
			for (attr_it = 0; attr_it < _tmp76__length1; attr_it = attr_it + 1) {
				gchar* _tmp77_ = NULL;
				gchar* attr = NULL;
				_tmp77_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp77_;
				{
					gchar** nv = NULL;
					const gchar* _tmp78_ = NULL;
					gchar** _tmp79_ = NULL;
					gchar** _tmp80_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gchar** _tmp81_ = NULL;
					gint _tmp81__length1 = 0;
					const gchar* _tmp82_ = NULL;
					_tmp78_ = attr;
					_tmp80_ = _tmp79_ = g_strsplit (_tmp78_, "=", 2);
					nv = _tmp80_;
					nv_length1 = _vala_array_length (_tmp79_);
					_nv_size_ = nv_length1;
					_tmp81_ = nv;
					_tmp81__length1 = nv_length1;
					_tmp82_ = _tmp81_[0];
					if (g_strcmp0 (_tmp82_, "hidden") == 0) {
						gchar** _tmp83_ = NULL;
						gint _tmp83__length1 = 0;
						const gchar* _tmp84_ = NULL;
						gchar* _tmp85_ = NULL;
						gchar* _tmp86_ = NULL;
						gboolean _tmp87_ = FALSE;
						_tmp83_ = nv;
						_tmp83__length1 = nv_length1;
						_tmp84_ = _tmp83_[1];
						_tmp85_ = vala_gidl_parser_eval (self, _tmp84_);
						_tmp86_ = _tmp85_;
						_tmp87_ = g_strcmp0 (_tmp86_, "1") == 0;
						_g_free0 (_tmp86_);
						if (_tmp87_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_vala_code_node_unref0 (prop);
							return result;
						}
					} else {
						gchar** _tmp88_ = NULL;
						gint _tmp88__length1 = 0;
						const gchar* _tmp89_ = NULL;
						_tmp88_ = nv;
						_tmp88__length1 = nv_length1;
						_tmp89_ = _tmp88_[0];
						if (g_strcmp0 (_tmp89_, "type_arguments") == 0) {
							ValaProperty* _tmp90_ = NULL;
							ValaDataType* _tmp91_ = NULL;
							ValaDataType* _tmp92_ = NULL;
							gchar** _tmp93_ = NULL;
							gint _tmp93__length1 = 0;
							const gchar* _tmp94_ = NULL;
							gchar* _tmp95_ = NULL;
							gchar* _tmp96_ = NULL;
							_tmp90_ = prop;
							_tmp91_ = vala_property_get_property_type (_tmp90_);
							_tmp92_ = _tmp91_;
							_tmp93_ = nv;
							_tmp93__length1 = nv_length1;
							_tmp94_ = _tmp93_[1];
							_tmp95_ = vala_gidl_parser_eval (self, _tmp94_);
							_tmp96_ = _tmp95_;
							vala_gidl_parser_parse_type_arguments_from_string (self, _tmp92_, _tmp96_, NULL);
							_g_free0 (_tmp96_);
						} else {
							gchar** _tmp97_ = NULL;
							gint _tmp97__length1 = 0;
							const gchar* _tmp98_ = NULL;
							_tmp97_ = nv;
							_tmp97__length1 = nv_length1;
							_tmp98_ = _tmp97_[0];
							if (g_strcmp0 (_tmp98_, "deprecated") == 0) {
								gchar** _tmp99_ = NULL;
								gint _tmp99__length1 = 0;
								const gchar* _tmp100_ = NULL;
								gchar* _tmp101_ = NULL;
								gchar* _tmp102_ = NULL;
								gboolean _tmp103_ = FALSE;
								_tmp99_ = nv;
								_tmp99__length1 = nv_length1;
								_tmp100_ = _tmp99_[1];
								_tmp101_ = vala_gidl_parser_eval (self, _tmp100_);
								_tmp102_ = _tmp101_;
								_tmp103_ = g_strcmp0 (_tmp102_, "1") == 0;
								_g_free0 (_tmp102_);
								if (_tmp103_) {
									ValaProperty* _tmp104_ = NULL;
									_tmp104_ = prop;
									vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp104_, "Version", "deprecated", TRUE, NULL);
								}
							} else {
								gchar** _tmp105_ = NULL;
								gint _tmp105__length1 = 0;
								const gchar* _tmp106_ = NULL;
								_tmp105_ = nv;
								_tmp105__length1 = nv_length1;
								_tmp106_ = _tmp105_[0];
								if (g_strcmp0 (_tmp106_, "replacement") == 0) {
									ValaProperty* _tmp107_ = NULL;
									gchar** _tmp108_ = NULL;
									gint _tmp108__length1 = 0;
									const gchar* _tmp109_ = NULL;
									gchar* _tmp110_ = NULL;
									gchar* _tmp111_ = NULL;
									_tmp107_ = prop;
									_tmp108_ = nv;
									_tmp108__length1 = nv_length1;
									_tmp109_ = _tmp108_[1];
									_tmp110_ = vala_gidl_parser_eval (self, _tmp109_);
									_tmp111_ = _tmp110_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp107_, "Version", "replacement", _tmp111_, NULL);
									_g_free0 (_tmp111_);
								} else {
									gchar** _tmp112_ = NULL;
									gint _tmp112__length1 = 0;
									const gchar* _tmp113_ = NULL;
									_tmp112_ = nv;
									_tmp112__length1 = nv_length1;
									_tmp113_ = _tmp112_[0];
									if (g_strcmp0 (_tmp113_, "deprecated_since") == 0) {
										ValaProperty* _tmp114_ = NULL;
										gchar** _tmp115_ = NULL;
										gint _tmp115__length1 = 0;
										const gchar* _tmp116_ = NULL;
										gchar* _tmp117_ = NULL;
										gchar* _tmp118_ = NULL;
										_tmp114_ = prop;
										_tmp115_ = nv;
										_tmp115__length1 = nv_length1;
										_tmp116_ = _tmp115_[1];
										_tmp117_ = vala_gidl_parser_eval (self, _tmp116_);
										_tmp118_ = _tmp117_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp114_, "Version", "deprecated_since", _tmp118_, NULL);
										_g_free0 (_tmp118_);
									} else {
										gchar** _tmp119_ = NULL;
										gint _tmp119__length1 = 0;
										const gchar* _tmp120_ = NULL;
										_tmp119_ = nv;
										_tmp119__length1 = nv_length1;
										_tmp120_ = _tmp119_[0];
										if (g_strcmp0 (_tmp120_, "accessor_method") == 0) {
											gchar** _tmp121_ = NULL;
											gint _tmp121__length1 = 0;
											const gchar* _tmp122_ = NULL;
											gchar* _tmp123_ = NULL;
											gchar* _tmp124_ = NULL;
											gboolean _tmp125_ = FALSE;
											_tmp121_ = nv;
											_tmp121__length1 = nv_length1;
											_tmp122_ = _tmp121_[1];
											_tmp123_ = vala_gidl_parser_eval (self, _tmp122_);
											_tmp124_ = _tmp123_;
											_tmp125_ = g_strcmp0 (_tmp124_, "0") == 0;
											_g_free0 (_tmp124_);
											if (_tmp125_) {
												ValaProperty* _tmp126_ = NULL;
												_tmp126_ = prop;
												vala_code_node_set_attribute ((ValaCodeNode*) _tmp126_, "NoAccessorMethod", TRUE, NULL);
											}
										} else {
											gchar** _tmp127_ = NULL;
											gint _tmp127__length1 = 0;
											const gchar* _tmp128_ = NULL;
											_tmp127_ = nv;
											_tmp127__length1 = nv_length1;
											_tmp128_ = _tmp127_[0];
											if (g_strcmp0 (_tmp128_, "owned_get") == 0) {
												gchar** _tmp129_ = NULL;
												gint _tmp129__length1 = 0;
												const gchar* _tmp130_ = NULL;
												gchar* _tmp131_ = NULL;
												gchar* _tmp132_ = NULL;
												gboolean _tmp133_ = FALSE;
												_tmp129_ = nv;
												_tmp129__length1 = nv_length1;
												_tmp130_ = _tmp129_[1];
												_tmp131_ = vala_gidl_parser_eval (self, _tmp130_);
												_tmp132_ = _tmp131_;
												_tmp133_ = g_strcmp0 (_tmp132_, "1") == 0;
												_g_free0 (_tmp132_);
												if (_tmp133_) {
													ValaProperty* _tmp134_ = NULL;
													ValaPropertyAccessor* _tmp135_ = NULL;
													ValaPropertyAccessor* _tmp136_ = NULL;
													ValaDataType* _tmp137_ = NULL;
													ValaDataType* _tmp138_ = NULL;
													_tmp134_ = prop;
													_tmp135_ = vala_property_get_get_accessor (_tmp134_);
													_tmp136_ = _tmp135_;
													_tmp137_ = vala_property_accessor_get_value_type (_tmp136_);
													_tmp138_ = _tmp137_;
													vala_data_type_set_value_owned (_tmp138_, TRUE);
												}
											} else {
												gchar** _tmp139_ = NULL;
												gint _tmp139__length1 = 0;
												const gchar* _tmp140_ = NULL;
												_tmp139_ = nv;
												_tmp139__length1 = nv_length1;
												_tmp140_ = _tmp139_[0];
												if (g_strcmp0 (_tmp140_, "type_name") == 0) {
													ValaProperty* _tmp141_ = NULL;
													gchar** _tmp142_ = NULL;
													gint _tmp142__length1 = 0;
													const gchar* _tmp143_ = NULL;
													gchar* _tmp144_ = NULL;
													gchar* _tmp145_ = NULL;
													ValaDataType* _tmp146_ = NULL;
													ValaDataType* _tmp147_ = NULL;
													_tmp141_ = prop;
													_tmp142_ = nv;
													_tmp142__length1 = nv_length1;
													_tmp143_ = _tmp142_[1];
													_tmp144_ = vala_gidl_parser_eval (self, _tmp143_);
													_tmp145_ = _tmp144_;
													_tmp146_ = vala_gidl_parser_parse_type_from_string (self, _tmp145_, FALSE, NULL);
													_tmp147_ = _tmp146_;
													vala_property_set_property_type (_tmp141_, _tmp147_);
													_vala_code_node_unref0 (_tmp147_);
													_g_free0 (_tmp145_);
												} else {
													gchar** _tmp148_ = NULL;
													gint _tmp148__length1 = 0;
													const gchar* _tmp149_ = NULL;
													_tmp148_ = nv;
													_tmp148__length1 = nv_length1;
													_tmp149_ = _tmp148_[0];
													if (g_strcmp0 (_tmp149_, "experimental") == 0) {
														gchar** _tmp150_ = NULL;
														gint _tmp150__length1 = 0;
														const gchar* _tmp151_ = NULL;
														gchar* _tmp152_ = NULL;
														gchar* _tmp153_ = NULL;
														gboolean _tmp154_ = FALSE;
														_tmp150_ = nv;
														_tmp150__length1 = nv_length1;
														_tmp151_ = _tmp150_[1];
														_tmp152_ = vala_gidl_parser_eval (self, _tmp151_);
														_tmp153_ = _tmp152_;
														_tmp154_ = g_strcmp0 (_tmp153_, "1") == 0;
														_g_free0 (_tmp153_);
														if (_tmp154_) {
															ValaProperty* _tmp155_ = NULL;
															_tmp155_ = prop;
															vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp155_, "Version", "experimental", TRUE, NULL);
														}
													} else {
														gchar** _tmp156_ = NULL;
														gint _tmp156__length1 = 0;
														const gchar* _tmp157_ = NULL;
														_tmp156_ = nv;
														_tmp156__length1 = nv_length1;
														_tmp157_ = _tmp156_[0];
														if (g_strcmp0 (_tmp157_, "nullable") == 0) {
															gboolean _tmp158_ = FALSE;
															gchar** _tmp159_ = NULL;
															gint _tmp159__length1 = 0;
															const gchar* _tmp160_ = NULL;
															gchar* _tmp161_ = NULL;
															gchar* _tmp162_ = NULL;
															gboolean _tmp163_ = FALSE;
															_tmp159_ = nv;
															_tmp159__length1 = nv_length1;
															_tmp160_ = _tmp159_[1];
															_tmp161_ = vala_gidl_parser_eval (self, _tmp160_);
															_tmp162_ = _tmp161_;
															_tmp163_ = g_strcmp0 (_tmp162_, "1") == 0;
															_g_free0 (_tmp162_);
															if (_tmp163_) {
																ValaProperty* _tmp164_ = NULL;
																ValaDataType* _tmp165_ = NULL;
																ValaDataType* _tmp166_ = NULL;
																_tmp164_ = prop;
																_tmp165_ = vala_property_get_property_type (_tmp164_);
																_tmp166_ = _tmp165_;
																_tmp158_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp166_, VALA_TYPE_VOID_TYPE);
															} else {
																_tmp158_ = FALSE;
															}
															if (_tmp158_) {
																ValaProperty* _tmp167_ = NULL;
																ValaDataType* _tmp168_ = NULL;
																ValaDataType* _tmp169_ = NULL;
																_tmp167_ = prop;
																_tmp168_ = vala_property_get_property_type (_tmp167_);
																_tmp169_ = _tmp168_;
																vala_data_type_set_nullable (_tmp169_, TRUE);
															}
														} else {
															gchar** _tmp170_ = NULL;
															gint _tmp170__length1 = 0;
															const gchar* _tmp171_ = NULL;
															_tmp170_ = nv;
															_tmp170__length1 = nv_length1;
															_tmp171_ = _tmp170_[0];
															if (g_strcmp0 (_tmp171_, "abstract") == 0) {
																gchar** _tmp172_ = NULL;
																gint _tmp172__length1 = 0;
																const gchar* _tmp173_ = NULL;
																gchar* _tmp174_ = NULL;
																gchar* _tmp175_ = NULL;
																gboolean _tmp176_ = FALSE;
																_tmp172_ = nv;
																_tmp172__length1 = nv_length1;
																_tmp173_ = _tmp172_[1];
																_tmp174_ = vala_gidl_parser_eval (self, _tmp173_);
																_tmp175_ = _tmp174_;
																_tmp176_ = g_strcmp0 (_tmp175_, "1") == 0;
																_g_free0 (_tmp175_);
																if (_tmp176_) {
																	ValaProperty* _tmp177_ = NULL;
																	_tmp177_ = prop;
																	vala_property_set_is_abstract (_tmp177_, TRUE);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp178_ = self->priv->current_type_symbol_set;
	if (_tmp178_ != NULL) {
		ValaSet* _tmp179_ = NULL;
		ValaProperty* _tmp180_ = NULL;
		const gchar* _tmp181_ = NULL;
		const gchar* _tmp182_ = NULL;
		_tmp179_ = self->priv->current_type_symbol_set;
		_tmp180_ = prop;
		_tmp181_ = vala_symbol_get_name ((ValaSymbol*) _tmp180_);
		_tmp182_ = _tmp181_;
		vala_collection_add ((ValaCollection*) _tmp179_, _tmp182_);
	}
	result = prop;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static ValaConstant* vala_gidl_parser_parse_constant (ValaGIdlParser* self, GIdlNodeConstant* const_node) {
	ValaConstant* result = NULL;
	GIdlNode* node = NULL;
	GIdlNodeConstant* _tmp0_ = NULL;
	ValaDataType* type = NULL;
	GIdlNodeConstant* _tmp1_ = NULL;
	GIdlNodeType* _tmp2_ = NULL;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_ = NULL;
	ValaConstant* c = NULL;
	GIdlNode* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	ValaDataType* _tmp7_ = NULL;
	ValaSourceReference* _tmp8_ = NULL;
	ValaConstant* _tmp9_ = NULL;
	ValaConstant* _tmp10_ = NULL;
	gchar** attributes = NULL;
	GIdlNode* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gchar** _tmp14_ = NULL;
	gint attributes_length1 = 0;
	gint _attributes_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	ValaConstant* _tmp65_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (const_node != NULL, NULL);
	_tmp0_ = const_node;
	node = (GIdlNode*) _tmp0_;
	_tmp1_ = const_node;
	_tmp2_ = _tmp1_->type;
	_tmp3_ = vala_gidl_parser_parse_type (self, _tmp2_, NULL);
	type = _tmp3_;
	_tmp4_ = type;
	if (_tmp4_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp5_ = node;
	_tmp6_ = _tmp5_->name;
	_tmp7_ = type;
	_tmp8_ = self->priv->current_source_reference;
	_tmp9_ = vala_constant_new (_tmp6_, _tmp7_, NULL, _tmp8_, NULL);
	c = _tmp9_;
	_tmp10_ = c;
	vala_symbol_set_external ((ValaSymbol*) _tmp10_, TRUE);
	_tmp11_ = node;
	_tmp12_ = _tmp11_->name;
	_tmp14_ = vala_gidl_parser_get_attributes (self, _tmp12_, &_tmp13_);
	attributes = _tmp14_;
	attributes_length1 = _tmp13_;
	_attributes_size_ = attributes_length1;
	_tmp15_ = attributes;
	_tmp15__length1 = attributes_length1;
	if (_tmp15_ != NULL) {
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		_tmp16_ = attributes;
		_tmp16__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp16_;
			attr_collection_length1 = _tmp16__length1;
			for (attr_it = 0; attr_it < _tmp16__length1; attr_it = attr_it + 1) {
				gchar* _tmp17_ = NULL;
				gchar* attr = NULL;
				_tmp17_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp17_;
				{
					gchar** nv = NULL;
					const gchar* _tmp18_ = NULL;
					gchar** _tmp19_ = NULL;
					gchar** _tmp20_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					_tmp18_ = attr;
					_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "=", 2);
					nv = _tmp20_;
					nv_length1 = _vala_array_length (_tmp19_);
					_nv_size_ = nv_length1;
					_tmp21_ = nv;
					_tmp21__length1 = nv_length1;
					_tmp22_ = _tmp21_[0];
					if (g_strcmp0 (_tmp22_, "cheader_filename") == 0) {
						ValaConstant* _tmp23_ = NULL;
						gchar** _tmp24_ = NULL;
						gint _tmp24__length1 = 0;
						const gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gchar* _tmp27_ = NULL;
						_tmp23_ = c;
						_tmp24_ = nv;
						_tmp24__length1 = nv_length1;
						_tmp25_ = _tmp24_[1];
						_tmp26_ = vala_gidl_parser_eval (self, _tmp25_);
						_tmp27_ = _tmp26_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp23_, "CCode", "cheader_filename", _tmp27_, NULL);
						_g_free0 (_tmp27_);
					} else {
						gchar** _tmp28_ = NULL;
						gint _tmp28__length1 = 0;
						const gchar* _tmp29_ = NULL;
						_tmp28_ = nv;
						_tmp28__length1 = nv_length1;
						_tmp29_ = _tmp28_[0];
						if (g_strcmp0 (_tmp29_, "deprecated") == 0) {
							gchar** _tmp30_ = NULL;
							gint _tmp30__length1 = 0;
							const gchar* _tmp31_ = NULL;
							gchar* _tmp32_ = NULL;
							gchar* _tmp33_ = NULL;
							gboolean _tmp34_ = FALSE;
							_tmp30_ = nv;
							_tmp30__length1 = nv_length1;
							_tmp31_ = _tmp30_[1];
							_tmp32_ = vala_gidl_parser_eval (self, _tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = g_strcmp0 (_tmp33_, "1") == 0;
							_g_free0 (_tmp33_);
							if (_tmp34_) {
								ValaConstant* _tmp35_ = NULL;
								_tmp35_ = c;
								vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp35_, "Version", "deprecated", TRUE, NULL);
							}
						} else {
							gchar** _tmp36_ = NULL;
							gint _tmp36__length1 = 0;
							const gchar* _tmp37_ = NULL;
							_tmp36_ = nv;
							_tmp36__length1 = nv_length1;
							_tmp37_ = _tmp36_[0];
							if (g_strcmp0 (_tmp37_, "replacement") == 0) {
								ValaConstant* _tmp38_ = NULL;
								gchar** _tmp39_ = NULL;
								gint _tmp39__length1 = 0;
								const gchar* _tmp40_ = NULL;
								gchar* _tmp41_ = NULL;
								gchar* _tmp42_ = NULL;
								_tmp38_ = c;
								_tmp39_ = nv;
								_tmp39__length1 = nv_length1;
								_tmp40_ = _tmp39_[1];
								_tmp41_ = vala_gidl_parser_eval (self, _tmp40_);
								_tmp42_ = _tmp41_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp38_, "Version", "replacement", _tmp42_, NULL);
								_g_free0 (_tmp42_);
							} else {
								gchar** _tmp43_ = NULL;
								gint _tmp43__length1 = 0;
								const gchar* _tmp44_ = NULL;
								_tmp43_ = nv;
								_tmp43__length1 = nv_length1;
								_tmp44_ = _tmp43_[0];
								if (g_strcmp0 (_tmp44_, "deprecated_since") == 0) {
									ValaConstant* _tmp45_ = NULL;
									gchar** _tmp46_ = NULL;
									gint _tmp46__length1 = 0;
									const gchar* _tmp47_ = NULL;
									gchar* _tmp48_ = NULL;
									gchar* _tmp49_ = NULL;
									_tmp45_ = c;
									_tmp46_ = nv;
									_tmp46__length1 = nv_length1;
									_tmp47_ = _tmp46_[1];
									_tmp48_ = vala_gidl_parser_eval (self, _tmp47_);
									_tmp49_ = _tmp48_;
									vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp45_, "Version", "deprecated_since", _tmp49_, NULL);
									_g_free0 (_tmp49_);
								} else {
									gchar** _tmp50_ = NULL;
									gint _tmp50__length1 = 0;
									const gchar* _tmp51_ = NULL;
									_tmp50_ = nv;
									_tmp50__length1 = nv_length1;
									_tmp51_ = _tmp50_[0];
									if (g_strcmp0 (_tmp51_, "hidden") == 0) {
										gchar** _tmp52_ = NULL;
										gint _tmp52__length1 = 0;
										const gchar* _tmp53_ = NULL;
										gchar* _tmp54_ = NULL;
										gchar* _tmp55_ = NULL;
										gboolean _tmp56_ = FALSE;
										_tmp52_ = nv;
										_tmp52__length1 = nv_length1;
										_tmp53_ = _tmp52_[1];
										_tmp54_ = vala_gidl_parser_eval (self, _tmp53_);
										_tmp55_ = _tmp54_;
										_tmp56_ = g_strcmp0 (_tmp55_, "1") == 0;
										_g_free0 (_tmp55_);
										if (_tmp56_) {
											result = NULL;
											nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
											_g_free0 (attr);
											attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
											_vala_code_node_unref0 (c);
											_vala_code_node_unref0 (type);
											return result;
										}
									} else {
										gchar** _tmp57_ = NULL;
										gint _tmp57__length1 = 0;
										const gchar* _tmp58_ = NULL;
										_tmp57_ = nv;
										_tmp57__length1 = nv_length1;
										_tmp58_ = _tmp57_[0];
										if (g_strcmp0 (_tmp58_, "experimental") == 0) {
											gchar** _tmp59_ = NULL;
											gint _tmp59__length1 = 0;
											const gchar* _tmp60_ = NULL;
											gchar* _tmp61_ = NULL;
											gchar* _tmp62_ = NULL;
											gboolean _tmp63_ = FALSE;
											_tmp59_ = nv;
											_tmp59__length1 = nv_length1;
											_tmp60_ = _tmp59_[1];
											_tmp61_ = vala_gidl_parser_eval (self, _tmp60_);
											_tmp62_ = _tmp61_;
											_tmp63_ = g_strcmp0 (_tmp62_, "1") == 0;
											_g_free0 (_tmp62_);
											if (_tmp63_) {
												ValaConstant* _tmp64_ = NULL;
												_tmp64_ = c;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp64_, "Version", "experimental", TRUE, NULL);
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp65_ = c;
	vala_symbol_set_access ((ValaSymbol*) _tmp65_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	result = c;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_vala_code_node_unref0 (type);
	return result;
}


static ValaField* vala_gidl_parser_parse_field (ValaGIdlParser* self, GIdlNodeField* field_node) {
	ValaField* result = NULL;
	GIdlNode* node = NULL;
	GIdlNodeField* _tmp0_ = NULL;
	gboolean unhidden = FALSE;
	ValaDataType* type = NULL;
	GIdlNodeField* _tmp1_ = NULL;
	GIdlNodeType* _tmp2_ = NULL;
	ValaDataType* _tmp3_ = NULL;
	ValaDataType* _tmp4_ = NULL;
	gchar* cheader_filename = NULL;
	gchar* ctype = NULL;
	gchar* array_length_cname = NULL;
	gchar* array_length_type = NULL;
	gboolean array_null_terminated = FALSE;
	gboolean deprecated = FALSE;
	gchar* deprecated_since = NULL;
	gchar* replacement = NULL;
	gboolean experimental = FALSE;
	gboolean no_delegate_target = FALSE;
	gchar** attributes = NULL;
	ValaTypeSymbol* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GIdlNode* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gint attributes_length1 = 0;
	gint _attributes_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gboolean _tmp135_ = FALSE;
	GIdlNode* _tmp136_ = NULL;
	const gchar* _tmp137_ = NULL;
	gboolean _tmp138_ = FALSE;
	ValaSet* _tmp140_ = NULL;
	gchar* field_name = NULL;
	GIdlNode* _tmp144_ = NULL;
	const gchar* _tmp145_ = NULL;
	gchar* _tmp146_ = NULL;
	const gchar* _tmp147_ = NULL;
	ValaField* field = NULL;
	const gchar* _tmp149_ = NULL;
	ValaDataType* _tmp150_ = NULL;
	ValaSourceReference* _tmp151_ = NULL;
	ValaField* _tmp152_ = NULL;
	ValaField* _tmp153_ = NULL;
	const gchar* _tmp154_ = NULL;
	GIdlNode* _tmp155_ = NULL;
	const gchar* _tmp156_ = NULL;
	gboolean _tmp160_ = FALSE;
	gboolean _tmp168_ = FALSE;
	const gchar* _tmp170_ = NULL;
	const gchar* _tmp173_ = NULL;
	gboolean _tmp176_ = FALSE;
	gboolean _tmp178_ = FALSE;
	const gchar* _tmp179_ = NULL;
	gboolean _tmp191_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (field_node != NULL, NULL);
	_tmp0_ = field_node;
	node = (GIdlNode*) _tmp0_;
	unhidden = FALSE;
	_tmp1_ = field_node;
	_tmp2_ = _tmp1_->type;
	_tmp3_ = vala_gidl_parser_parse_type (self, _tmp2_, NULL);
	type = _tmp3_;
	_tmp4_ = type;
	if (_tmp4_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (type);
		return result;
	}
	cheader_filename = NULL;
	ctype = NULL;
	array_length_cname = NULL;
	array_length_type = NULL;
	array_null_terminated = FALSE;
	deprecated = FALSE;
	deprecated_since = NULL;
	replacement = NULL;
	experimental = FALSE;
	no_delegate_target = FALSE;
	_tmp5_ = self->priv->current_data_type;
	_tmp6_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = node;
	_tmp9_ = _tmp8_->name;
	_tmp10_ = g_strdup_printf ("%s.%s", _tmp7_, _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp13_ = vala_gidl_parser_get_attributes (self, _tmp11_, &_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp14__length1 = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp7_);
	attributes = _tmp14_;
	attributes_length1 = _tmp14__length1;
	_attributes_size_ = attributes_length1;
	_tmp15_ = attributes;
	_tmp15__length1 = attributes_length1;
	if (_tmp15_ != NULL) {
		gchar** _tmp16_ = NULL;
		gint _tmp16__length1 = 0;
		_tmp16_ = attributes;
		_tmp16__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp16_;
			attr_collection_length1 = _tmp16__length1;
			for (attr_it = 0; attr_it < _tmp16__length1; attr_it = attr_it + 1) {
				gchar* _tmp17_ = NULL;
				gchar* attr = NULL;
				_tmp17_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp17_;
				{
					gchar** nv = NULL;
					const gchar* _tmp18_ = NULL;
					gchar** _tmp19_ = NULL;
					gchar** _tmp20_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gchar** _tmp21_ = NULL;
					gint _tmp21__length1 = 0;
					const gchar* _tmp22_ = NULL;
					_tmp18_ = attr;
					_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "=", 2);
					nv = _tmp20_;
					nv_length1 = _vala_array_length (_tmp19_);
					_nv_size_ = nv_length1;
					_tmp21_ = nv;
					_tmp21__length1 = nv_length1;
					_tmp22_ = _tmp21_[0];
					if (g_strcmp0 (_tmp22_, "hidden") == 0) {
						gchar** _tmp23_ = NULL;
						gint _tmp23__length1 = 0;
						const gchar* _tmp24_ = NULL;
						gchar* _tmp25_ = NULL;
						gchar* _tmp26_ = NULL;
						gboolean _tmp27_ = FALSE;
						_tmp23_ = nv;
						_tmp23__length1 = nv_length1;
						_tmp24_ = _tmp23_[1];
						_tmp25_ = vala_gidl_parser_eval (self, _tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = g_strcmp0 (_tmp26_, "1") == 0;
						_g_free0 (_tmp26_);
						if (_tmp27_) {
							result = NULL;
							nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (attr);
							attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (replacement);
							_g_free0 (deprecated_since);
							_g_free0 (array_length_type);
							_g_free0 (array_length_cname);
							_g_free0 (ctype);
							_g_free0 (cheader_filename);
							_vala_code_node_unref0 (type);
							return result;
						} else {
							unhidden = TRUE;
						}
					} else {
						gchar** _tmp28_ = NULL;
						gint _tmp28__length1 = 0;
						const gchar* _tmp29_ = NULL;
						_tmp28_ = nv;
						_tmp28__length1 = nv_length1;
						_tmp29_ = _tmp28_[0];
						if (g_strcmp0 (_tmp29_, "is_array") == 0) {
							gchar** _tmp30_ = NULL;
							gint _tmp30__length1 = 0;
							const gchar* _tmp31_ = NULL;
							gchar* _tmp32_ = NULL;
							gchar* _tmp33_ = NULL;
							gboolean _tmp34_ = FALSE;
							_tmp30_ = nv;
							_tmp30__length1 = nv_length1;
							_tmp31_ = _tmp30_[1];
							_tmp32_ = vala_gidl_parser_eval (self, _tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = g_strcmp0 (_tmp33_, "1") == 0;
							_g_free0 (_tmp33_);
							if (_tmp34_) {
								ValaDataType* _tmp35_ = NULL;
								ValaDataType* _tmp36_ = NULL;
								ValaDataType* _tmp37_ = NULL;
								ValaSourceReference* _tmp38_ = NULL;
								ValaSourceReference* _tmp39_ = NULL;
								ValaArrayType* _tmp40_ = NULL;
								_tmp35_ = type;
								vala_data_type_set_value_owned (_tmp35_, TRUE);
								_tmp36_ = type;
								_tmp37_ = type;
								_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp37_);
								_tmp39_ = _tmp38_;
								_tmp40_ = vala_array_type_new (_tmp36_, 1, _tmp39_);
								_vala_code_node_unref0 (type);
								type = (ValaDataType*) _tmp40_;
							}
						} else {
							gchar** _tmp41_ = NULL;
							gint _tmp41__length1 = 0;
							const gchar* _tmp42_ = NULL;
							_tmp41_ = nv;
							_tmp41__length1 = nv_length1;
							_tmp42_ = _tmp41_[0];
							if (g_strcmp0 (_tmp42_, "weak") == 0) {
								gchar** _tmp43_ = NULL;
								gint _tmp43__length1 = 0;
								const gchar* _tmp44_ = NULL;
								gchar* _tmp45_ = NULL;
								gchar* _tmp46_ = NULL;
								gboolean _tmp47_ = FALSE;
								_tmp43_ = nv;
								_tmp43__length1 = nv_length1;
								_tmp44_ = _tmp43_[1];
								_tmp45_ = vala_gidl_parser_eval (self, _tmp44_);
								_tmp46_ = _tmp45_;
								_tmp47_ = g_strcmp0 (_tmp46_, "0") == 0;
								_g_free0 (_tmp46_);
								if (_tmp47_) {
									ValaDataType* _tmp48_ = NULL;
									_tmp48_ = type;
									vala_data_type_set_value_owned (_tmp48_, TRUE);
								}
							} else {
								gchar** _tmp49_ = NULL;
								gint _tmp49__length1 = 0;
								const gchar* _tmp50_ = NULL;
								_tmp49_ = nv;
								_tmp49__length1 = nv_length1;
								_tmp50_ = _tmp49_[0];
								if (g_strcmp0 (_tmp50_, "value_owned") == 0) {
									gchar** _tmp51_ = NULL;
									gint _tmp51__length1 = 0;
									const gchar* _tmp52_ = NULL;
									gchar* _tmp53_ = NULL;
									gchar* _tmp54_ = NULL;
									gboolean _tmp55_ = FALSE;
									_tmp51_ = nv;
									_tmp51__length1 = nv_length1;
									_tmp52_ = _tmp51_[1];
									_tmp53_ = vala_gidl_parser_eval (self, _tmp52_);
									_tmp54_ = _tmp53_;
									_tmp55_ = g_strcmp0 (_tmp54_, "0") == 0;
									_g_free0 (_tmp54_);
									if (_tmp55_) {
										ValaDataType* _tmp56_ = NULL;
										_tmp56_ = type;
										vala_data_type_set_value_owned (_tmp56_, FALSE);
									} else {
										gchar** _tmp57_ = NULL;
										gint _tmp57__length1 = 0;
										const gchar* _tmp58_ = NULL;
										gchar* _tmp59_ = NULL;
										gchar* _tmp60_ = NULL;
										gboolean _tmp61_ = FALSE;
										_tmp57_ = nv;
										_tmp57__length1 = nv_length1;
										_tmp58_ = _tmp57_[1];
										_tmp59_ = vala_gidl_parser_eval (self, _tmp58_);
										_tmp60_ = _tmp59_;
										_tmp61_ = g_strcmp0 (_tmp60_, "1") == 0;
										_g_free0 (_tmp60_);
										if (_tmp61_) {
											ValaDataType* _tmp62_ = NULL;
											_tmp62_ = type;
											vala_data_type_set_value_owned (_tmp62_, TRUE);
										}
									}
								} else {
									gchar** _tmp63_ = NULL;
									gint _tmp63__length1 = 0;
									const gchar* _tmp64_ = NULL;
									_tmp63_ = nv;
									_tmp63__length1 = nv_length1;
									_tmp64_ = _tmp63_[0];
									if (g_strcmp0 (_tmp64_, "type_name") == 0) {
										gchar** _tmp65_ = NULL;
										gint _tmp65__length1 = 0;
										const gchar* _tmp66_ = NULL;
										gchar* _tmp67_ = NULL;
										gchar* _tmp68_ = NULL;
										ValaDataType* _tmp69_ = NULL;
										_tmp65_ = nv;
										_tmp65__length1 = nv_length1;
										_tmp66_ = _tmp65_[1];
										_tmp67_ = vala_gidl_parser_eval (self, _tmp66_);
										_tmp68_ = _tmp67_;
										_tmp69_ = vala_gidl_parser_parse_type_from_string (self, _tmp68_, TRUE, NULL);
										_vala_code_node_unref0 (type);
										type = _tmp69_;
										_g_free0 (_tmp68_);
									} else {
										gchar** _tmp70_ = NULL;
										gint _tmp70__length1 = 0;
										const gchar* _tmp71_ = NULL;
										_tmp70_ = nv;
										_tmp70__length1 = nv_length1;
										_tmp71_ = _tmp70_[0];
										if (g_strcmp0 (_tmp71_, "type_arguments") == 0) {
											ValaDataType* _tmp72_ = NULL;
											gchar** _tmp73_ = NULL;
											gint _tmp73__length1 = 0;
											const gchar* _tmp74_ = NULL;
											gchar* _tmp75_ = NULL;
											gchar* _tmp76_ = NULL;
											_tmp72_ = type;
											_tmp73_ = nv;
											_tmp73__length1 = nv_length1;
											_tmp74_ = _tmp73_[1];
											_tmp75_ = vala_gidl_parser_eval (self, _tmp74_);
											_tmp76_ = _tmp75_;
											vala_gidl_parser_parse_type_arguments_from_string (self, _tmp72_, _tmp76_, NULL);
											_g_free0 (_tmp76_);
										} else {
											gchar** _tmp77_ = NULL;
											gint _tmp77__length1 = 0;
											const gchar* _tmp78_ = NULL;
											_tmp77_ = nv;
											_tmp77__length1 = nv_length1;
											_tmp78_ = _tmp77_[0];
											if (g_strcmp0 (_tmp78_, "deprecated") == 0) {
												gchar** _tmp79_ = NULL;
												gint _tmp79__length1 = 0;
												const gchar* _tmp80_ = NULL;
												gchar* _tmp81_ = NULL;
												gchar* _tmp82_ = NULL;
												gboolean _tmp83_ = FALSE;
												_tmp79_ = nv;
												_tmp79__length1 = nv_length1;
												_tmp80_ = _tmp79_[1];
												_tmp81_ = vala_gidl_parser_eval (self, _tmp80_);
												_tmp82_ = _tmp81_;
												_tmp83_ = g_strcmp0 (_tmp82_, "1") == 0;
												_g_free0 (_tmp82_);
												if (_tmp83_) {
													deprecated = TRUE;
												}
											} else {
												gchar** _tmp84_ = NULL;
												gint _tmp84__length1 = 0;
												const gchar* _tmp85_ = NULL;
												_tmp84_ = nv;
												_tmp84__length1 = nv_length1;
												_tmp85_ = _tmp84_[0];
												if (g_strcmp0 (_tmp85_, "replacement") == 0) {
													gchar** _tmp86_ = NULL;
													gint _tmp86__length1 = 0;
													const gchar* _tmp87_ = NULL;
													gchar* _tmp88_ = NULL;
													_tmp86_ = nv;
													_tmp86__length1 = nv_length1;
													_tmp87_ = _tmp86_[1];
													_tmp88_ = vala_gidl_parser_eval (self, _tmp87_);
													_g_free0 (replacement);
													replacement = _tmp88_;
												} else {
													gchar** _tmp89_ = NULL;
													gint _tmp89__length1 = 0;
													const gchar* _tmp90_ = NULL;
													_tmp89_ = nv;
													_tmp89__length1 = nv_length1;
													_tmp90_ = _tmp89_[0];
													if (g_strcmp0 (_tmp90_, "deprecated_since") == 0) {
														gchar** _tmp91_ = NULL;
														gint _tmp91__length1 = 0;
														const gchar* _tmp92_ = NULL;
														gchar* _tmp93_ = NULL;
														_tmp91_ = nv;
														_tmp91__length1 = nv_length1;
														_tmp92_ = _tmp91_[1];
														_tmp93_ = vala_gidl_parser_eval (self, _tmp92_);
														_g_free0 (deprecated_since);
														deprecated_since = _tmp93_;
													} else {
														gchar** _tmp94_ = NULL;
														gint _tmp94__length1 = 0;
														const gchar* _tmp95_ = NULL;
														_tmp94_ = nv;
														_tmp94__length1 = nv_length1;
														_tmp95_ = _tmp94_[0];
														if (g_strcmp0 (_tmp95_, "cheader_filename") == 0) {
															gchar** _tmp96_ = NULL;
															gint _tmp96__length1 = 0;
															const gchar* _tmp97_ = NULL;
															gchar* _tmp98_ = NULL;
															_tmp96_ = nv;
															_tmp96__length1 = nv_length1;
															_tmp97_ = _tmp96_[1];
															_tmp98_ = vala_gidl_parser_eval (self, _tmp97_);
															_g_free0 (cheader_filename);
															cheader_filename = _tmp98_;
														} else {
															gchar** _tmp99_ = NULL;
															gint _tmp99__length1 = 0;
															const gchar* _tmp100_ = NULL;
															_tmp99_ = nv;
															_tmp99__length1 = nv_length1;
															_tmp100_ = _tmp99_[0];
															if (g_strcmp0 (_tmp100_, "ctype") == 0) {
																gchar** _tmp101_ = NULL;
																gint _tmp101__length1 = 0;
																const gchar* _tmp102_ = NULL;
																gchar* _tmp103_ = NULL;
																_tmp101_ = nv;
																_tmp101__length1 = nv_length1;
																_tmp102_ = _tmp101_[1];
																_tmp103_ = vala_gidl_parser_eval (self, _tmp102_);
																_g_free0 (ctype);
																ctype = _tmp103_;
															} else {
																gchar** _tmp104_ = NULL;
																gint _tmp104__length1 = 0;
																const gchar* _tmp105_ = NULL;
																_tmp104_ = nv;
																_tmp104__length1 = nv_length1;
																_tmp105_ = _tmp104_[0];
																if (g_strcmp0 (_tmp105_, "array_null_terminated") == 0) {
																	gchar** _tmp106_ = NULL;
																	gint _tmp106__length1 = 0;
																	const gchar* _tmp107_ = NULL;
																	gchar* _tmp108_ = NULL;
																	gchar* _tmp109_ = NULL;
																	gboolean _tmp110_ = FALSE;
																	_tmp106_ = nv;
																	_tmp106__length1 = nv_length1;
																	_tmp107_ = _tmp106_[1];
																	_tmp108_ = vala_gidl_parser_eval (self, _tmp107_);
																	_tmp109_ = _tmp108_;
																	_tmp110_ = g_strcmp0 (_tmp109_, "1") == 0;
																	_g_free0 (_tmp109_);
																	if (_tmp110_) {
																		array_null_terminated = TRUE;
																	}
																} else {
																	gchar** _tmp111_ = NULL;
																	gint _tmp111__length1 = 0;
																	const gchar* _tmp112_ = NULL;
																	_tmp111_ = nv;
																	_tmp111__length1 = nv_length1;
																	_tmp112_ = _tmp111_[0];
																	if (g_strcmp0 (_tmp112_, "array_length_cname") == 0) {
																		gchar** _tmp113_ = NULL;
																		gint _tmp113__length1 = 0;
																		const gchar* _tmp114_ = NULL;
																		gchar* _tmp115_ = NULL;
																		_tmp113_ = nv;
																		_tmp113__length1 = nv_length1;
																		_tmp114_ = _tmp113_[1];
																		_tmp115_ = vala_gidl_parser_eval (self, _tmp114_);
																		_g_free0 (array_length_cname);
																		array_length_cname = _tmp115_;
																	} else {
																		gchar** _tmp116_ = NULL;
																		gint _tmp116__length1 = 0;
																		const gchar* _tmp117_ = NULL;
																		_tmp116_ = nv;
																		_tmp116__length1 = nv_length1;
																		_tmp117_ = _tmp116_[0];
																		if (g_strcmp0 (_tmp117_, "array_length_type") == 0) {
																			gchar** _tmp118_ = NULL;
																			gint _tmp118__length1 = 0;
																			const gchar* _tmp119_ = NULL;
																			gchar* _tmp120_ = NULL;
																			_tmp118_ = nv;
																			_tmp118__length1 = nv_length1;
																			_tmp119_ = _tmp118_[1];
																			_tmp120_ = vala_gidl_parser_eval (self, _tmp119_);
																			_g_free0 (array_length_type);
																			array_length_type = _tmp120_;
																		} else {
																			gchar** _tmp121_ = NULL;
																			gint _tmp121__length1 = 0;
																			const gchar* _tmp122_ = NULL;
																			_tmp121_ = nv;
																			_tmp121__length1 = nv_length1;
																			_tmp122_ = _tmp121_[0];
																			if (g_strcmp0 (_tmp122_, "no_delegate_target") == 0) {
																				gchar** _tmp123_ = NULL;
																				gint _tmp123__length1 = 0;
																				const gchar* _tmp124_ = NULL;
																				gchar* _tmp125_ = NULL;
																				gchar* _tmp126_ = NULL;
																				gboolean _tmp127_ = FALSE;
																				_tmp123_ = nv;
																				_tmp123__length1 = nv_length1;
																				_tmp124_ = _tmp123_[1];
																				_tmp125_ = vala_gidl_parser_eval (self, _tmp124_);
																				_tmp126_ = _tmp125_;
																				_tmp127_ = g_strcmp0 (_tmp126_, "1") == 0;
																				_g_free0 (_tmp126_);
																				if (_tmp127_) {
																					no_delegate_target = TRUE;
																				}
																			} else {
																				gchar** _tmp128_ = NULL;
																				gint _tmp128__length1 = 0;
																				const gchar* _tmp129_ = NULL;
																				_tmp128_ = nv;
																				_tmp128__length1 = nv_length1;
																				_tmp129_ = _tmp128_[0];
																				if (g_strcmp0 (_tmp129_, "experimental") == 0) {
																					gchar** _tmp130_ = NULL;
																					gint _tmp130__length1 = 0;
																					const gchar* _tmp131_ = NULL;
																					gchar* _tmp132_ = NULL;
																					gchar* _tmp133_ = NULL;
																					gboolean _tmp134_ = FALSE;
																					_tmp130_ = nv;
																					_tmp130__length1 = nv_length1;
																					_tmp131_ = _tmp130_[1];
																					_tmp132_ = vala_gidl_parser_eval (self, _tmp131_);
																					_tmp133_ = _tmp132_;
																					_tmp134_ = g_strcmp0 (_tmp133_, "1") == 0;
																					_g_free0 (_tmp133_);
																					if (_tmp134_) {
																						experimental = TRUE;
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
	}
	_tmp136_ = node;
	_tmp137_ = _tmp136_->name;
	_tmp138_ = g_str_has_prefix (_tmp137_, "_");
	if (_tmp138_) {
		gboolean _tmp139_ = FALSE;
		_tmp139_ = unhidden;
		_tmp135_ = !_tmp139_;
	} else {
		_tmp135_ = FALSE;
	}
	if (_tmp135_) {
		result = NULL;
		attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (replacement);
		_g_free0 (deprecated_since);
		_g_free0 (array_length_type);
		_g_free0 (array_length_cname);
		_g_free0 (ctype);
		_g_free0 (cheader_filename);
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp140_ = self->priv->current_type_symbol_set;
	if (_tmp140_ != NULL) {
		ValaSet* _tmp141_ = NULL;
		GIdlNode* _tmp142_ = NULL;
		const gchar* _tmp143_ = NULL;
		_tmp141_ = self->priv->current_type_symbol_set;
		_tmp142_ = node;
		_tmp143_ = _tmp142_->name;
		vala_collection_add ((ValaCollection*) _tmp141_, _tmp143_);
	}
	_tmp144_ = node;
	_tmp145_ = _tmp144_->name;
	_tmp146_ = g_strdup (_tmp145_);
	field_name = _tmp146_;
	_tmp147_ = field_name;
	if (g_strcmp0 (_tmp147_, "string") == 0) {
		gchar* _tmp148_ = NULL;
		_tmp148_ = g_strdup ("str");
		_g_free0 (field_name);
		field_name = _tmp148_;
	}
	_tmp149_ = field_name;
	_tmp150_ = type;
	_tmp151_ = self->priv->current_source_reference;
	_tmp152_ = vala_field_new (_tmp149_, _tmp150_, NULL, _tmp151_, NULL);
	field = _tmp152_;
	_tmp153_ = field;
	vala_symbol_set_access ((ValaSymbol*) _tmp153_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp154_ = field_name;
	_tmp155_ = node;
	_tmp156_ = _tmp155_->name;
	if (g_strcmp0 (_tmp154_, _tmp156_) != 0) {
		ValaField* _tmp157_ = NULL;
		GIdlNode* _tmp158_ = NULL;
		const gchar* _tmp159_ = NULL;
		_tmp157_ = field;
		_tmp158_ = node;
		_tmp159_ = _tmp158_->name;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp157_, "CCode", "cname", _tmp159_, NULL);
	}
	_tmp160_ = deprecated;
	if (_tmp160_) {
		ValaField* _tmp161_ = NULL;
		const gchar* _tmp162_ = NULL;
		const gchar* _tmp165_ = NULL;
		_tmp161_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp161_, "Version", "deprecated", TRUE, NULL);
		_tmp162_ = deprecated_since;
		if (_tmp162_ != NULL) {
			ValaField* _tmp163_ = NULL;
			const gchar* _tmp164_ = NULL;
			_tmp163_ = field;
			_tmp164_ = deprecated_since;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp163_, "Version", "deprecated_since", _tmp164_, NULL);
		}
		_tmp165_ = replacement;
		if (_tmp165_ != NULL) {
			ValaField* _tmp166_ = NULL;
			const gchar* _tmp167_ = NULL;
			_tmp166_ = field;
			_tmp167_ = replacement;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp166_, "Version", "replacement", _tmp167_, NULL);
		}
	}
	_tmp168_ = experimental;
	if (_tmp168_) {
		ValaField* _tmp169_ = NULL;
		_tmp169_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp169_, "Version", "experimental", TRUE, NULL);
	}
	_tmp170_ = ctype;
	if (_tmp170_ != NULL) {
		ValaField* _tmp171_ = NULL;
		const gchar* _tmp172_ = NULL;
		_tmp171_ = field;
		_tmp172_ = ctype;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp171_, "CCode", "type", _tmp172_, NULL);
	}
	_tmp173_ = cheader_filename;
	if (_tmp173_ != NULL) {
		ValaField* _tmp174_ = NULL;
		const gchar* _tmp175_ = NULL;
		_tmp174_ = field;
		_tmp175_ = cheader_filename;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp174_, "CCode", "cheader_filename", _tmp175_, NULL);
	}
	_tmp176_ = array_null_terminated;
	if (_tmp176_) {
		ValaField* _tmp177_ = NULL;
		_tmp177_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp177_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp179_ = array_length_cname;
	if (_tmp179_ != NULL) {
		_tmp178_ = TRUE;
	} else {
		const gchar* _tmp180_ = NULL;
		_tmp180_ = array_length_type;
		_tmp178_ = _tmp180_ != NULL;
	}
	if (_tmp178_) {
		const gchar* _tmp181_ = NULL;
		const gchar* _tmp184_ = NULL;
		_tmp181_ = array_length_cname;
		if (_tmp181_ != NULL) {
			ValaField* _tmp182_ = NULL;
			const gchar* _tmp183_ = NULL;
			_tmp182_ = field;
			_tmp183_ = array_length_cname;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp182_, "CCode", "array_length_cname", _tmp183_, NULL);
		}
		_tmp184_ = array_length_type;
		if (_tmp184_ != NULL) {
			ValaField* _tmp185_ = NULL;
			const gchar* _tmp186_ = NULL;
			_tmp185_ = field;
			_tmp186_ = array_length_type;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp185_, "CCode", "array_length_type", _tmp186_, NULL);
		}
	} else {
		ValaField* _tmp187_ = NULL;
		ValaDataType* _tmp188_ = NULL;
		ValaDataType* _tmp189_ = NULL;
		_tmp187_ = field;
		_tmp188_ = vala_variable_get_variable_type ((ValaVariable*) _tmp187_);
		_tmp189_ = _tmp188_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, VALA_TYPE_ARRAY_TYPE)) {
			ValaField* _tmp190_ = NULL;
			_tmp190_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp190_, "CCode", "array_length", FALSE, NULL);
		}
	}
	_tmp191_ = no_delegate_target;
	if (_tmp191_) {
		ValaField* _tmp192_ = NULL;
		_tmp192_ = field;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp192_, "CCode", "delegate_target", FALSE, NULL);
	}
	result = field;
	_g_free0 (field_name);
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (replacement);
	_g_free0 (deprecated_since);
	_g_free0 (array_length_type);
	_g_free0 (array_length_cname);
	_g_free0 (ctype);
	_g_free0 (cheader_filename);
	_vala_code_node_unref0 (type);
	return result;
}


static gint string_index_of_nth_char (const gchar* self, glong c) {
	gint result = 0;
	glong _tmp0_ = 0L;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = c;
	_tmp1_ = g_utf8_offset_to_pointer (self, _tmp0_);
	result = (gint) (_tmp1_ - ((gchar*) self));
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_slist_free__g_free0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_free0_, NULL);
	g_slist_free (self);
}


static gchar** vala_gidl_parser_get_attributes (ValaGIdlParser* self, const gchar* codenode, int* result_length1) {
	gchar** result = NULL;
	gchar* attributes = NULL;
	ValaMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp35_ = NULL;
	GSList* attr_list = NULL;
	GString* attr = NULL;
	const gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	GString* _tmp40_ = NULL;
	gint attributes_len = 0;
	const gchar* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	const gchar* remaining = NULL;
	const gchar* _tmp44_ = NULL;
	gboolean quoted = FALSE;
	gboolean escaped = FALSE;
	GString* _tmp71_ = NULL;
	gssize _tmp72_ = 0L;
	gchar** attrs = NULL;
	GSList* _tmp76_ = NULL;
	guint _tmp77_ = 0U;
	gchar** _tmp78_ = NULL;
	gint attrs_length1 = 0;
	gint _attrs_size_ = 0;
	GSList* attr_i = NULL;
	GSList* _tmp79_ = NULL;
	gchar** _tmp93_ = NULL;
	gint _tmp93__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (codenode != NULL, NULL);
	_tmp0_ = self->priv->codenode_attributes_map;
	_tmp1_ = codenode;
	_tmp2_ = vala_map_get (_tmp0_, _tmp1_);
	attributes = (gchar*) _tmp2_;
	_tmp3_ = attributes;
	if (_tmp3_ == NULL) {
		gboolean dot_required = FALSE;
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gboolean colon_required = FALSE;
		const gchar* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		ValaSet* pattern_specs = NULL;
		ValaMap* _tmp8_ = NULL;
		ValaSet* _tmp9_ = NULL;
		_tmp4_ = codenode;
		_tmp5_ = string_index_of_char (_tmp4_, (gunichar) '.', 0);
		dot_required = -1 != _tmp5_;
		_tmp6_ = codenode;
		_tmp7_ = string_index_of_char (_tmp6_, (gunichar) ':', 0);
		colon_required = -1 != _tmp7_;
		_tmp8_ = self->priv->codenode_attributes_patterns;
		_tmp9_ = vala_map_get_keys (_tmp8_);
		pattern_specs = _tmp9_;
		{
			ValaIterator* _pattern_it = NULL;
			ValaSet* _tmp10_ = NULL;
			ValaIterator* _tmp11_ = NULL;
			_tmp10_ = pattern_specs;
			_tmp11_ = vala_iterable_iterator ((ValaIterable*) _tmp10_);
			_pattern_it = _tmp11_;
			while (TRUE) {
				ValaIterator* _tmp12_ = NULL;
				gboolean _tmp13_ = FALSE;
				GPatternSpec* pattern = NULL;
				ValaIterator* _tmp14_ = NULL;
				gpointer _tmp15_ = NULL;
				gchar* pspec = NULL;
				ValaMap* _tmp16_ = NULL;
				GPatternSpec* _tmp17_ = NULL;
				gpointer _tmp18_ = NULL;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				GPatternSpec* _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gboolean _tmp30_ = FALSE;
				_tmp12_ = _pattern_it;
				_tmp13_ = vala_iterator_next (_tmp12_);
				if (!_tmp13_) {
					break;
				}
				_tmp14_ = _pattern_it;
				_tmp15_ = vala_iterator_get (_tmp14_);
				pattern = _tmp15_;
				_tmp16_ = self->priv->codenode_attributes_patterns;
				_tmp17_ = pattern;
				_tmp18_ = vala_map_get (_tmp16_, _tmp17_);
				pspec = (gchar*) _tmp18_;
				_tmp21_ = dot_required;
				if (_tmp21_) {
					const gchar* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					_tmp22_ = pspec;
					_tmp23_ = string_index_of_char (_tmp22_, (gunichar) '.', 0);
					_tmp20_ = -1 == _tmp23_;
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					_tmp19_ = TRUE;
				} else {
					gboolean _tmp24_ = FALSE;
					gboolean _tmp25_ = FALSE;
					_tmp25_ = colon_required;
					if (_tmp25_) {
						const gchar* _tmp26_ = NULL;
						gint _tmp27_ = 0;
						_tmp26_ = pspec;
						_tmp27_ = string_index_of_char (_tmp26_, (gunichar) ':', 0);
						_tmp24_ = -1 == _tmp27_;
					} else {
						_tmp24_ = FALSE;
					}
					_tmp19_ = _tmp24_;
				}
				if (_tmp19_) {
					_g_free0 (pspec);
					continue;
				}
				_tmp28_ = pattern;
				_tmp29_ = codenode;
				_tmp30_ = g_pattern_match_string (_tmp28_, _tmp29_);
				if (_tmp30_) {
					const gchar* _tmp31_ = NULL;
					gint _tmp32_ = 0;
					gchar** _tmp33_ = NULL;
					gchar** _tmp34_ = NULL;
					gint _tmp34__length1 = 0;
					_tmp31_ = pspec;
					_tmp33_ = vala_gidl_parser_get_attributes (self, _tmp31_, &_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp34__length1 = _tmp32_;
					if (result_length1) {
						*result_length1 = _tmp34__length1;
					}
					result = _tmp34_;
					_g_free0 (pspec);
					_vala_iterator_unref0 (_pattern_it);
					_vala_iterable_unref0 (pattern_specs);
					_g_free0 (attributes);
					return result;
				}
				_g_free0 (pspec);
			}
			_vala_iterator_unref0 (_pattern_it);
		}
		_vala_iterable_unref0 (pattern_specs);
	}
	_tmp35_ = attributes;
	if (_tmp35_ == NULL) {
		gchar** _tmp36_ = NULL;
		gint _tmp36__length1 = 0;
		_tmp36_ = NULL;
		_tmp36__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp36__length1;
		}
		result = _tmp36_;
		_g_free0 (attributes);
		return result;
	}
	attr_list = NULL;
	_tmp37_ = attributes;
	_tmp38_ = strlen (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_string_sized_new ((gsize) _tmp39_);
	attr = _tmp40_;
	_tmp41_ = attributes;
	_tmp42_ = strlen (_tmp41_);
	_tmp43_ = _tmp42_;
	attributes_len = _tmp43_;
	_tmp44_ = attributes;
	remaining = _tmp44_;
	quoted = FALSE;
	escaped = FALSE;
	{
		gint b = 0;
		b = 0;
		{
			gboolean _tmp45_ = FALSE;
			_tmp45_ = TRUE;
			while (TRUE) {
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gunichar c = 0U;
				const gchar* _tmp49_ = NULL;
				gunichar _tmp50_ = 0U;
				gboolean _tmp51_ = FALSE;
				const gchar* _tmp68_ = NULL;
				const gchar* _tmp69_ = NULL;
				gint _tmp70_ = 0;
				if (!_tmp45_) {
					gint _tmp46_ = 0;
					_tmp46_ = b;
					b = _tmp46_ + 1;
				}
				_tmp45_ = FALSE;
				_tmp47_ = b;
				_tmp48_ = attributes_len;
				if (!(_tmp47_ < _tmp48_)) {
					break;
				}
				_tmp49_ = remaining;
				_tmp50_ = string_get_char (_tmp49_, (glong) 0);
				c = _tmp50_;
				_tmp51_ = escaped;
				if (_tmp51_) {
					GString* _tmp52_ = NULL;
					gunichar _tmp53_ = 0U;
					escaped = FALSE;
					_tmp52_ = attr;
					_tmp53_ = c;
					g_string_append_unichar (_tmp52_, _tmp53_);
				} else {
					gunichar _tmp54_ = 0U;
					_tmp54_ = c;
					if (_tmp54_ == ((gunichar) '"')) {
						GString* _tmp55_ = NULL;
						gunichar _tmp56_ = 0U;
						gboolean _tmp57_ = FALSE;
						_tmp55_ = attr;
						_tmp56_ = c;
						g_string_append_unichar (_tmp55_, _tmp56_);
						_tmp57_ = quoted;
						quoted = !_tmp57_;
					} else {
						gunichar _tmp58_ = 0U;
						_tmp58_ = c;
						if (_tmp58_ == ((gunichar) '\\')) {
							escaped = TRUE;
						} else {
							gboolean _tmp59_ = FALSE;
							gboolean _tmp60_ = FALSE;
							_tmp60_ = quoted;
							if (!_tmp60_) {
								gunichar _tmp61_ = 0U;
								_tmp61_ = c;
								_tmp59_ = _tmp61_ == ((gunichar) ' ');
							} else {
								_tmp59_ = FALSE;
							}
							if (_tmp59_) {
								GString* _tmp62_ = NULL;
								const gchar* _tmp63_ = NULL;
								gchar* _tmp64_ = NULL;
								GString* _tmp65_ = NULL;
								_tmp62_ = attr;
								_tmp63_ = _tmp62_->str;
								_tmp64_ = g_strdup (_tmp63_);
								attr_list = g_slist_prepend (attr_list, _tmp64_);
								_tmp65_ = attr;
								g_string_truncate (_tmp65_, (gsize) 0);
							} else {
								GString* _tmp66_ = NULL;
								gunichar _tmp67_ = 0U;
								_tmp66_ = attr;
								_tmp67_ = c;
								g_string_append_unichar (_tmp66_, _tmp67_);
							}
						}
					}
				}
				_tmp68_ = remaining;
				_tmp69_ = remaining;
				_tmp70_ = string_index_of_nth_char (_tmp69_, (glong) 1);
				remaining = (const gchar*) (((gchar*) _tmp68_) + _tmp70_);
			}
		}
	}
	_tmp71_ = attr;
	_tmp72_ = _tmp71_->len;
	if (_tmp72_ > ((gssize) 0)) {
		GString* _tmp73_ = NULL;
		const gchar* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		_tmp73_ = attr;
		_tmp74_ = _tmp73_->str;
		_tmp75_ = g_strdup (_tmp74_);
		attr_list = g_slist_prepend (attr_list, _tmp75_);
	}
	_tmp76_ = attr_list;
	_tmp77_ = g_slist_length (_tmp76_);
	_tmp78_ = g_new0 (gchar*, _tmp77_ + 1);
	attrs = _tmp78_;
	attrs_length1 = _tmp77_;
	_attrs_size_ = attrs_length1;
	_tmp79_ = attr_list;
	attr_i = _tmp79_;
	{
		gint a = 0;
		a = 0;
		{
			gboolean _tmp80_ = FALSE;
			_tmp80_ = TRUE;
			while (TRUE) {
				gint _tmp84_ = 0;
				gchar** _tmp85_ = NULL;
				gint _tmp85__length1 = 0;
				gchar** _tmp86_ = NULL;
				gint _tmp86__length1 = 0;
				gchar** _tmp87_ = NULL;
				gint _tmp87__length1 = 0;
				gint _tmp88_ = 0;
				GSList* _tmp89_ = NULL;
				gconstpointer _tmp90_ = NULL;
				gchar* _tmp91_ = NULL;
				gchar* _tmp92_ = NULL;
				if (!_tmp80_) {
					gint _tmp81_ = 0;
					GSList* _tmp82_ = NULL;
					GSList* _tmp83_ = NULL;
					_tmp81_ = a;
					a = _tmp81_ + 1;
					_tmp82_ = attr_i;
					_tmp83_ = _tmp82_->next;
					attr_i = _tmp83_;
				}
				_tmp80_ = FALSE;
				_tmp84_ = a;
				_tmp85_ = attrs;
				_tmp85__length1 = attrs_length1;
				if (!(_tmp84_ < _tmp85__length1)) {
					break;
				}
				_tmp86_ = attrs;
				_tmp86__length1 = attrs_length1;
				_tmp87_ = attrs;
				_tmp87__length1 = attrs_length1;
				_tmp88_ = a;
				_tmp89_ = attr_i;
				_tmp90_ = _tmp89_->data;
				_tmp91_ = g_strdup ((const gchar*) _tmp90_);
				_g_free0 (_tmp86_[(_tmp87__length1 - 1) - _tmp88_]);
				_tmp86_[(_tmp87__length1 - 1) - _tmp88_] = _tmp91_;
				_tmp92_ = _tmp86_[(_tmp87__length1 - 1) - _tmp88_];
			}
		}
	}
	_tmp93_ = attrs;
	_tmp93__length1 = attrs_length1;
	if (result_length1) {
		*result_length1 = _tmp93__length1;
	}
	result = _tmp93_;
	_g_string_free0 (attr);
	__g_slist_free__g_free0_0 (attr_list);
	_g_free0 (attributes);
	return result;
}


static gchar* vala_gidl_parser_eval (ValaGIdlParser* self, const gchar* s) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (s != NULL, NULL);
	_tmp3_ = s;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ >= 2) {
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = s;
		_tmp7_ = g_str_has_prefix (_tmp6_, "\"");
		_tmp2_ = _tmp7_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = s;
		_tmp9_ = g_str_has_suffix (_tmp8_, "\"");
		_tmp1_ = _tmp9_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp10_ = NULL;
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gchar* _tmp14_ = NULL;
		_tmp10_ = s;
		_tmp11_ = s;
		_tmp12_ = strlen (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_substring (_tmp10_, (glong) 1, (glong) (_tmp13_ - 2));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp14_;
	} else {
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		_tmp15_ = s;
		_tmp16_ = g_strdup (_tmp15_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp16_;
	}
	result = _tmp0_;
	return result;
}


static ValaSignal* vala_gidl_parser_parse_signal (ValaGIdlParser* self, GIdlNodeSignal* sig_node) {
	ValaSignal* result = NULL;
	GIdlNode* node = NULL;
	GIdlNodeSignal* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GIdlNodeSignal* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	ValaSignal* sig = NULL;
	GIdlNode* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	GIdlNodeSignal* _tmp10_ = NULL;
	GIdlNodeParam* _tmp11_ = NULL;
	ValaDataType* _tmp12_ = NULL;
	ValaDataType* _tmp13_ = NULL;
	ValaSourceReference* _tmp14_ = NULL;
	ValaSignal* _tmp15_ = NULL;
	ValaSignal* _tmp16_ = NULL;
	ValaSignal* _tmp17_ = NULL;
	gchar** attributes = NULL;
	ValaTypeSymbol* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	ValaSignal* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gint _tmp26_ = 0;
	gchar** _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	gint attributes_length1 = 0;
	gint _attributes_size_ = 0;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	ValaSignal* _tmp133_ = NULL;
	gboolean first = FALSE;
	GIdlNodeSignal* _tmp134_ = NULL;
	GList* _tmp135_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig_node != NULL, NULL);
	_tmp0_ = sig_node;
	node = (GIdlNode*) _tmp0_;
	_tmp2_ = sig_node;
	_tmp3_ = _tmp2_->deprecated;
	if (_tmp3_) {
		_tmp1_ = TRUE;
	} else {
		GIdlNodeSignal* _tmp4_ = NULL;
		GIdlNodeParam* _tmp5_ = NULL;
		_tmp4_ = sig_node;
		_tmp5_ = _tmp4_->result;
		_tmp1_ = _tmp5_ == NULL;
	}
	if (_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp6_ = node;
	_tmp7_ = _tmp6_->name;
	_tmp8_ = vala_gidl_parser_fix_prop_name (self, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = sig_node;
	_tmp11_ = _tmp10_->result;
	_tmp12_ = vala_gidl_parser_parse_param (self, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->current_source_reference;
	_tmp15_ = vala_signal_new (_tmp9_, _tmp13_, _tmp14_, NULL);
	_tmp16_ = _tmp15_;
	_vala_code_node_unref0 (_tmp13_);
	_g_free0 (_tmp9_);
	sig = _tmp16_;
	_tmp17_ = sig;
	vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp18_ = self->priv->current_data_type;
	_tmp19_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	_tmp21_ = sig;
	_tmp22_ = vala_symbol_get_name ((ValaSymbol*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup_printf ("%s::%s", _tmp20_, _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp27_ = vala_gidl_parser_get_attributes (self, _tmp25_, &_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp28__length1 = _tmp26_;
	_g_free0 (_tmp25_);
	_g_free0 (_tmp20_);
	attributes = _tmp28_;
	attributes_length1 = _tmp28__length1;
	_attributes_size_ = attributes_length1;
	_tmp29_ = attributes;
	_tmp29__length1 = attributes_length1;
	if (_tmp29_ != NULL) {
		gchar* ns_name = NULL;
		gchar** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		const gchar* _tmp124_ = NULL;
		ns_name = NULL;
		_tmp30_ = attributes;
		_tmp30__length1 = attributes_length1;
		{
			gchar** attr_collection = NULL;
			gint attr_collection_length1 = 0;
			gint _attr_collection_size_ = 0;
			gint attr_it = 0;
			attr_collection = _tmp30_;
			attr_collection_length1 = _tmp30__length1;
			for (attr_it = 0; attr_it < _tmp30__length1; attr_it = attr_it + 1) {
				gchar* _tmp31_ = NULL;
				gchar* attr = NULL;
				_tmp31_ = g_strdup (attr_collection[attr_it]);
				attr = _tmp31_;
				{
					gchar** nv = NULL;
					const gchar* _tmp32_ = NULL;
					gchar** _tmp33_ = NULL;
					gchar** _tmp34_ = NULL;
					gint nv_length1 = 0;
					gint _nv_size_ = 0;
					gchar** _tmp35_ = NULL;
					gint _tmp35__length1 = 0;
					const gchar* _tmp36_ = NULL;
					_tmp32_ = attr;
					_tmp34_ = _tmp33_ = g_strsplit (_tmp32_, "=", 2);
					nv = _tmp34_;
					nv_length1 = _vala_array_length (_tmp33_);
					_nv_size_ = nv_length1;
					_tmp35_ = nv;
					_tmp35__length1 = nv_length1;
					_tmp36_ = _tmp35_[0];
					if (g_strcmp0 (_tmp36_, "name") == 0) {
						ValaSignal* _tmp37_ = NULL;
						ValaSignal* _tmp38_ = NULL;
						const gchar* _tmp39_ = NULL;
						const gchar* _tmp40_ = NULL;
						ValaSignal* _tmp41_ = NULL;
						gchar** _tmp42_ = NULL;
						gint _tmp42__length1 = 0;
						const gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
						gchar* _tmp45_ = NULL;
						_tmp37_ = sig;
						_tmp38_ = sig;
						_tmp39_ = vala_symbol_get_name ((ValaSymbol*) _tmp38_);
						_tmp40_ = _tmp39_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp37_, "CCode", "cname", _tmp40_, NULL);
						_tmp41_ = sig;
						_tmp42_ = nv;
						_tmp42__length1 = nv_length1;
						_tmp43_ = _tmp42_[1];
						_tmp44_ = vala_gidl_parser_eval (self, _tmp43_);
						_tmp45_ = _tmp44_;
						vala_symbol_set_name ((ValaSymbol*) _tmp41_, _tmp45_);
						_g_free0 (_tmp45_);
					} else {
						gboolean _tmp46_ = FALSE;
						gchar** _tmp47_ = NULL;
						gint _tmp47__length1 = 0;
						const gchar* _tmp48_ = NULL;
						_tmp47_ = nv;
						_tmp47__length1 = nv_length1;
						_tmp48_ = _tmp47_[0];
						if (g_strcmp0 (_tmp48_, "has_emitter") == 0) {
							gchar** _tmp49_ = NULL;
							gint _tmp49__length1 = 0;
							const gchar* _tmp50_ = NULL;
							gchar* _tmp51_ = NULL;
							gchar* _tmp52_ = NULL;
							_tmp49_ = nv;
							_tmp49__length1 = nv_length1;
							_tmp50_ = _tmp49_[1];
							_tmp51_ = vala_gidl_parser_eval (self, _tmp50_);
							_tmp52_ = _tmp51_;
							_tmp46_ = g_strcmp0 (_tmp52_, "1") == 0;
							_g_free0 (_tmp52_);
						} else {
							_tmp46_ = FALSE;
						}
						if (_tmp46_) {
							ValaSignal* _tmp53_ = NULL;
							_tmp53_ = sig;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp53_, "HasEmitter", TRUE, NULL);
						} else {
							gchar** _tmp54_ = NULL;
							gint _tmp54__length1 = 0;
							const gchar* _tmp55_ = NULL;
							_tmp54_ = nv;
							_tmp54__length1 = nv_length1;
							_tmp55_ = _tmp54_[0];
							if (g_strcmp0 (_tmp55_, "hidden") == 0) {
								gchar** _tmp56_ = NULL;
								gint _tmp56__length1 = 0;
								const gchar* _tmp57_ = NULL;
								gchar* _tmp58_ = NULL;
								gchar* _tmp59_ = NULL;
								gboolean _tmp60_ = FALSE;
								_tmp56_ = nv;
								_tmp56__length1 = nv_length1;
								_tmp57_ = _tmp56_[1];
								_tmp58_ = vala_gidl_parser_eval (self, _tmp57_);
								_tmp59_ = _tmp58_;
								_tmp60_ = g_strcmp0 (_tmp59_, "1") == 0;
								_g_free0 (_tmp59_);
								if (_tmp60_) {
									result = NULL;
									nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
									_g_free0 (attr);
									_g_free0 (ns_name);
									attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
									_vala_code_node_unref0 (sig);
									return result;
								}
							} else {
								gchar** _tmp61_ = NULL;
								gint _tmp61__length1 = 0;
								const gchar* _tmp62_ = NULL;
								_tmp61_ = nv;
								_tmp61__length1 = nv_length1;
								_tmp62_ = _tmp61_[0];
								if (g_strcmp0 (_tmp62_, "deprecated") == 0) {
									gchar** _tmp63_ = NULL;
									gint _tmp63__length1 = 0;
									const gchar* _tmp64_ = NULL;
									gchar* _tmp65_ = NULL;
									gchar* _tmp66_ = NULL;
									gboolean _tmp67_ = FALSE;
									_tmp63_ = nv;
									_tmp63__length1 = nv_length1;
									_tmp64_ = _tmp63_[1];
									_tmp65_ = vala_gidl_parser_eval (self, _tmp64_);
									_tmp66_ = _tmp65_;
									_tmp67_ = g_strcmp0 (_tmp66_, "1") == 0;
									_g_free0 (_tmp66_);
									if (_tmp67_) {
										ValaSignal* _tmp68_ = NULL;
										_tmp68_ = sig;
										vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp68_, "Version", "deprecated", TRUE, NULL);
									}
								} else {
									gchar** _tmp69_ = NULL;
									gint _tmp69__length1 = 0;
									const gchar* _tmp70_ = NULL;
									_tmp69_ = nv;
									_tmp69__length1 = nv_length1;
									_tmp70_ = _tmp69_[0];
									if (g_strcmp0 (_tmp70_, "replacement") == 0) {
										ValaSignal* _tmp71_ = NULL;
										gchar** _tmp72_ = NULL;
										gint _tmp72__length1 = 0;
										const gchar* _tmp73_ = NULL;
										gchar* _tmp74_ = NULL;
										gchar* _tmp75_ = NULL;
										_tmp71_ = sig;
										_tmp72_ = nv;
										_tmp72__length1 = nv_length1;
										_tmp73_ = _tmp72_[1];
										_tmp74_ = vala_gidl_parser_eval (self, _tmp73_);
										_tmp75_ = _tmp74_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp71_, "Version", "replacement", _tmp75_, NULL);
										_g_free0 (_tmp75_);
									} else {
										gchar** _tmp76_ = NULL;
										gint _tmp76__length1 = 0;
										const gchar* _tmp77_ = NULL;
										_tmp76_ = nv;
										_tmp76__length1 = nv_length1;
										_tmp77_ = _tmp76_[0];
										if (g_strcmp0 (_tmp77_, "deprecated_since") == 0) {
											ValaSignal* _tmp78_ = NULL;
											gchar** _tmp79_ = NULL;
											gint _tmp79__length1 = 0;
											const gchar* _tmp80_ = NULL;
											gchar* _tmp81_ = NULL;
											gchar* _tmp82_ = NULL;
											_tmp78_ = sig;
											_tmp79_ = nv;
											_tmp79__length1 = nv_length1;
											_tmp80_ = _tmp79_[1];
											_tmp81_ = vala_gidl_parser_eval (self, _tmp80_);
											_tmp82_ = _tmp81_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp78_, "Version", "deprecated_since", _tmp82_, NULL);
											_g_free0 (_tmp82_);
										} else {
											gchar** _tmp83_ = NULL;
											gint _tmp83__length1 = 0;
											const gchar* _tmp84_ = NULL;
											_tmp83_ = nv;
											_tmp83__length1 = nv_length1;
											_tmp84_ = _tmp83_[0];
											if (g_strcmp0 (_tmp84_, "transfer_ownership") == 0) {
												gchar** _tmp85_ = NULL;
												gint _tmp85__length1 = 0;
												const gchar* _tmp86_ = NULL;
												gchar* _tmp87_ = NULL;
												gchar* _tmp88_ = NULL;
												gboolean _tmp89_ = FALSE;
												_tmp85_ = nv;
												_tmp85__length1 = nv_length1;
												_tmp86_ = _tmp85_[1];
												_tmp87_ = vala_gidl_parser_eval (self, _tmp86_);
												_tmp88_ = _tmp87_;
												_tmp89_ = g_strcmp0 (_tmp88_, "1") == 0;
												_g_free0 (_tmp88_);
												if (_tmp89_) {
													ValaSignal* _tmp90_ = NULL;
													ValaDataType* _tmp91_ = NULL;
													ValaDataType* _tmp92_ = NULL;
													_tmp90_ = sig;
													_tmp91_ = vala_signal_get_return_type (_tmp90_);
													_tmp92_ = _tmp91_;
													vala_data_type_set_value_owned (_tmp92_, TRUE);
												}
											} else {
												gchar** _tmp93_ = NULL;
												gint _tmp93__length1 = 0;
												const gchar* _tmp94_ = NULL;
												_tmp93_ = nv;
												_tmp93__length1 = nv_length1;
												_tmp94_ = _tmp93_[0];
												if (g_strcmp0 (_tmp94_, "namespace_name") == 0) {
													gchar** _tmp95_ = NULL;
													gint _tmp95__length1 = 0;
													const gchar* _tmp96_ = NULL;
													gchar* _tmp97_ = NULL;
													_tmp95_ = nv;
													_tmp95__length1 = nv_length1;
													_tmp96_ = _tmp95_[1];
													_tmp97_ = vala_gidl_parser_eval (self, _tmp96_);
													_g_free0 (ns_name);
													ns_name = _tmp97_;
												} else {
													gchar** _tmp98_ = NULL;
													gint _tmp98__length1 = 0;
													const gchar* _tmp99_ = NULL;
													_tmp98_ = nv;
													_tmp98__length1 = nv_length1;
													_tmp99_ = _tmp98_[0];
													if (g_strcmp0 (_tmp99_, "type_name") == 0) {
														ValaSignal* _tmp100_ = NULL;
														gchar** _tmp101_ = NULL;
														gint _tmp101__length1 = 0;
														const gchar* _tmp102_ = NULL;
														gchar* _tmp103_ = NULL;
														gchar* _tmp104_ = NULL;
														ValaDataType* _tmp105_ = NULL;
														ValaDataType* _tmp106_ = NULL;
														_tmp100_ = sig;
														_tmp101_ = nv;
														_tmp101__length1 = nv_length1;
														_tmp102_ = _tmp101_[1];
														_tmp103_ = vala_gidl_parser_eval (self, _tmp102_);
														_tmp104_ = _tmp103_;
														_tmp105_ = vala_gidl_parser_parse_type_from_string (self, _tmp104_, FALSE, NULL);
														_tmp106_ = _tmp105_;
														vala_signal_set_return_type (_tmp100_, _tmp106_);
														_vala_code_node_unref0 (_tmp106_);
														_g_free0 (_tmp104_);
													} else {
														gchar** _tmp107_ = NULL;
														gint _tmp107__length1 = 0;
														const gchar* _tmp108_ = NULL;
														_tmp107_ = nv;
														_tmp107__length1 = nv_length1;
														_tmp108_ = _tmp107_[0];
														if (g_strcmp0 (_tmp108_, "type_arguments") == 0) {
															ValaSignal* _tmp109_ = NULL;
															ValaDataType* _tmp110_ = NULL;
															ValaDataType* _tmp111_ = NULL;
															gchar** _tmp112_ = NULL;
															gint _tmp112__length1 = 0;
															const gchar* _tmp113_ = NULL;
															gchar* _tmp114_ = NULL;
															gchar* _tmp115_ = NULL;
															_tmp109_ = sig;
															_tmp110_ = vala_signal_get_return_type (_tmp109_);
															_tmp111_ = _tmp110_;
															_tmp112_ = nv;
															_tmp112__length1 = nv_length1;
															_tmp113_ = _tmp112_[1];
															_tmp114_ = vala_gidl_parser_eval (self, _tmp113_);
															_tmp115_ = _tmp114_;
															vala_gidl_parser_parse_type_arguments_from_string (self, _tmp111_, _tmp115_, NULL);
															_g_free0 (_tmp115_);
														} else {
															gchar** _tmp116_ = NULL;
															gint _tmp116__length1 = 0;
															const gchar* _tmp117_ = NULL;
															_tmp116_ = nv;
															_tmp116__length1 = nv_length1;
															_tmp117_ = _tmp116_[0];
															if (g_strcmp0 (_tmp117_, "experimental") == 0) {
																gchar** _tmp118_ = NULL;
																gint _tmp118__length1 = 0;
																const gchar* _tmp119_ = NULL;
																gchar* _tmp120_ = NULL;
																gchar* _tmp121_ = NULL;
																gboolean _tmp122_ = FALSE;
																_tmp118_ = nv;
																_tmp118__length1 = nv_length1;
																_tmp119_ = _tmp118_[1];
																_tmp120_ = vala_gidl_parser_eval (self, _tmp119_);
																_tmp121_ = _tmp120_;
																_tmp122_ = g_strcmp0 (_tmp121_, "1") == 0;
																_g_free0 (_tmp121_);
																if (_tmp122_) {
																	ValaSignal* _tmp123_ = NULL;
																	_tmp123_ = sig;
																	vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp123_, "Version", "experimental", TRUE, NULL);
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (attr);
				}
			}
		}
		_tmp124_ = ns_name;
		if (_tmp124_ != NULL) {
			ValaSignal* _tmp125_ = NULL;
			ValaDataType* _tmp126_ = NULL;
			ValaDataType* _tmp127_ = NULL;
			ValaUnresolvedSymbol* _tmp128_ = NULL;
			ValaUnresolvedSymbol* _tmp129_ = NULL;
			const gchar* _tmp130_ = NULL;
			ValaUnresolvedSymbol* _tmp131_ = NULL;
			ValaUnresolvedSymbol* _tmp132_ = NULL;
			_tmp125_ = sig;
			_tmp126_ = vala_signal_get_return_type (_tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp127_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
			_tmp129_ = _tmp128_;
			_tmp130_ = ns_name;
			_tmp131_ = vala_unresolved_symbol_new (NULL, _tmp130_, NULL);
			_tmp132_ = _tmp131_;
			vala_unresolved_symbol_set_inner (_tmp129_, _tmp132_);
			_vala_code_node_unref0 (_tmp132_);
		}
		_g_free0 (ns_name);
	}
	_tmp133_ = sig;
	vala_signal_set_is_virtual (_tmp133_, TRUE);
	first = TRUE;
	_tmp134_ = sig_node;
	_tmp135_ = _tmp134_->parameters;
	{
		GList* param_collection = NULL;
		GList* param_it = NULL;
		param_collection = _tmp135_;
		for (param_it = param_collection; param_it != NULL; param_it = param_it->next) {
			GIdlNodeParam* param = NULL;
			param = (GIdlNodeParam*) param_it->data;
			{
				gboolean _tmp136_ = FALSE;
				GIdlNode* param_node = NULL;
				GIdlNodeParam* _tmp137_ = NULL;
				ValaParameterDirection direction = 0;
				ValaDataType* param_type = NULL;
				GIdlNodeParam* _tmp138_ = NULL;
				ValaParameterDirection _tmp139_ = 0;
				ValaDataType* _tmp140_ = NULL;
				ValaParameter* p = NULL;
				GIdlNode* _tmp141_ = NULL;
				const gchar* _tmp142_ = NULL;
				ValaDataType* _tmp143_ = NULL;
				ValaParameter* _tmp144_ = NULL;
				ValaParameter* _tmp145_ = NULL;
				ValaParameterDirection _tmp146_ = 0;
				gboolean hide_param = FALSE;
				gboolean show_param = FALSE;
				ValaTypeSymbol* _tmp147_ = NULL;
				gchar* _tmp148_ = NULL;
				gchar* _tmp149_ = NULL;
				ValaSignal* _tmp150_ = NULL;
				const gchar* _tmp151_ = NULL;
				const gchar* _tmp152_ = NULL;
				GIdlNode* _tmp153_ = NULL;
				const gchar* _tmp154_ = NULL;
				gchar* _tmp155_ = NULL;
				gchar* _tmp156_ = NULL;
				gint _tmp157_ = 0;
				gchar** _tmp158_ = NULL;
				gchar** _tmp159_ = NULL;
				gint _tmp159__length1 = 0;
				gboolean _tmp279_ = FALSE;
				gboolean _tmp280_ = FALSE;
				_tmp136_ = first;
				if (_tmp136_) {
					first = FALSE;
					continue;
				}
				_tmp137_ = param;
				param_node = (GIdlNode*) _tmp137_;
				_tmp138_ = param;
				_tmp140_ = vala_gidl_parser_parse_param (self, _tmp138_, &_tmp139_);
				direction = _tmp139_;
				param_type = _tmp140_;
				_tmp141_ = param_node;
				_tmp142_ = _tmp141_->name;
				_tmp143_ = param_type;
				_tmp144_ = vala_parameter_new (_tmp142_, _tmp143_, NULL);
				p = _tmp144_;
				_tmp145_ = p;
				_tmp146_ = direction;
				vala_parameter_set_direction (_tmp145_, _tmp146_);
				hide_param = FALSE;
				show_param = FALSE;
				_tmp147_ = self->priv->current_data_type;
				_tmp148_ = vala_gidl_parser_get_cname (self, (ValaSymbol*) _tmp147_, NULL);
				_tmp149_ = _tmp148_;
				_tmp150_ = sig;
				_tmp151_ = vala_symbol_get_name ((ValaSymbol*) _tmp150_);
				_tmp152_ = _tmp151_;
				_tmp153_ = param_node;
				_tmp154_ = _tmp153_->name;
				_tmp155_ = g_strdup_printf ("%s::%s.%s", _tmp149_, _tmp152_, _tmp154_);
				_tmp156_ = _tmp155_;
				_tmp158_ = vala_gidl_parser_get_attributes (self, _tmp156_, &_tmp157_);
				attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
				attributes = _tmp158_;
				attributes_length1 = _tmp157_;
				_attributes_size_ = attributes_length1;
				_g_free0 (_tmp156_);
				_g_free0 (_tmp149_);
				_tmp159_ = attributes;
				_tmp159__length1 = attributes_length1;
				if (_tmp159_ != NULL) {
					gchar* ns_name = NULL;
					gchar** _tmp160_ = NULL;
					gint _tmp160__length1 = 0;
					const gchar* _tmp272_ = NULL;
					ns_name = NULL;
					_tmp160_ = attributes;
					_tmp160__length1 = attributes_length1;
					{
						gchar** attr_collection = NULL;
						gint attr_collection_length1 = 0;
						gint _attr_collection_size_ = 0;
						gint attr_it = 0;
						attr_collection = _tmp160_;
						attr_collection_length1 = _tmp160__length1;
						for (attr_it = 0; attr_it < _tmp160__length1; attr_it = attr_it + 1) {
							gchar* _tmp161_ = NULL;
							gchar* attr = NULL;
							_tmp161_ = g_strdup (attr_collection[attr_it]);
							attr = _tmp161_;
							{
								gchar** nv = NULL;
								const gchar* _tmp162_ = NULL;
								gchar** _tmp163_ = NULL;
								gchar** _tmp164_ = NULL;
								gint nv_length1 = 0;
								gint _nv_size_ = 0;
								gchar** _tmp165_ = NULL;
								gint _tmp165__length1 = 0;
								const gchar* _tmp166_ = NULL;
								_tmp162_ = attr;
								_tmp164_ = _tmp163_ = g_strsplit (_tmp162_, "=", 2);
								nv = _tmp164_;
								nv_length1 = _vala_array_length (_tmp163_);
								_nv_size_ = nv_length1;
								_tmp165_ = nv;
								_tmp165__length1 = nv_length1;
								_tmp166_ = _tmp165_[0];
								if (g_strcmp0 (_tmp166_, "hidden") == 0) {
									gchar** _tmp167_ = NULL;
									gint _tmp167__length1 = 0;
									const gchar* _tmp168_ = NULL;
									gchar* _tmp169_ = NULL;
									gchar* _tmp170_ = NULL;
									gboolean _tmp171_ = FALSE;
									_tmp167_ = nv;
									_tmp167__length1 = nv_length1;
									_tmp168_ = _tmp167_[1];
									_tmp169_ = vala_gidl_parser_eval (self, _tmp168_);
									_tmp170_ = _tmp169_;
									_tmp171_ = g_strcmp0 (_tmp170_, "1") == 0;
									_g_free0 (_tmp170_);
									if (_tmp171_) {
										hide_param = TRUE;
									} else {
										gchar** _tmp172_ = NULL;
										gint _tmp172__length1 = 0;
										const gchar* _tmp173_ = NULL;
										gchar* _tmp174_ = NULL;
										gchar* _tmp175_ = NULL;
										gboolean _tmp176_ = FALSE;
										_tmp172_ = nv;
										_tmp172__length1 = nv_length1;
										_tmp173_ = _tmp172_[1];
										_tmp174_ = vala_gidl_parser_eval (self, _tmp173_);
										_tmp175_ = _tmp174_;
										_tmp176_ = g_strcmp0 (_tmp175_, "0") == 0;
										_g_free0 (_tmp175_);
										if (_tmp176_) {
											show_param = TRUE;
										}
									}
								} else {
									gchar** _tmp177_ = NULL;
									gint _tmp177__length1 = 0;
									const gchar* _tmp178_ = NULL;
									_tmp177_ = nv;
									_tmp177__length1 = nv_length1;
									_tmp178_ = _tmp177_[0];
									if (g_strcmp0 (_tmp178_, "is_array") == 0) {
										gchar** _tmp179_ = NULL;
										gint _tmp179__length1 = 0;
										const gchar* _tmp180_ = NULL;
										gchar* _tmp181_ = NULL;
										gchar* _tmp182_ = NULL;
										gboolean _tmp183_ = FALSE;
										_tmp179_ = nv;
										_tmp179__length1 = nv_length1;
										_tmp180_ = _tmp179_[1];
										_tmp181_ = vala_gidl_parser_eval (self, _tmp180_);
										_tmp182_ = _tmp181_;
										_tmp183_ = g_strcmp0 (_tmp182_, "1") == 0;
										_g_free0 (_tmp182_);
										if (_tmp183_) {
											ValaDataType* _tmp184_ = NULL;
											ValaDataType* _tmp185_ = NULL;
											ValaDataType* _tmp186_ = NULL;
											ValaSourceReference* _tmp187_ = NULL;
											ValaSourceReference* _tmp188_ = NULL;
											ValaArrayType* _tmp189_ = NULL;
											ValaParameter* _tmp190_ = NULL;
											ValaDataType* _tmp191_ = NULL;
											ValaParameter* _tmp192_ = NULL;
											_tmp184_ = param_type;
											vala_data_type_set_value_owned (_tmp184_, TRUE);
											_tmp185_ = param_type;
											_tmp186_ = param_type;
											_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp186_);
											_tmp188_ = _tmp187_;
											_tmp189_ = vala_array_type_new (_tmp185_, 1, _tmp188_);
											_vala_code_node_unref0 (param_type);
											param_type = (ValaDataType*) _tmp189_;
											_tmp190_ = p;
											_tmp191_ = param_type;
											vala_variable_set_variable_type ((ValaVariable*) _tmp190_, _tmp191_);
											_tmp192_ = p;
											vala_parameter_set_direction (_tmp192_, VALA_PARAMETER_DIRECTION_IN);
										}
									} else {
										gchar** _tmp193_ = NULL;
										gint _tmp193__length1 = 0;
										const gchar* _tmp194_ = NULL;
										_tmp193_ = nv;
										_tmp193__length1 = nv_length1;
										_tmp194_ = _tmp193_[0];
										if (g_strcmp0 (_tmp194_, "no_array_length") == 0) {
											gchar** _tmp195_ = NULL;
											gint _tmp195__length1 = 0;
											const gchar* _tmp196_ = NULL;
											gchar* _tmp197_ = NULL;
											gchar* _tmp198_ = NULL;
											gboolean _tmp199_ = FALSE;
											_tmp195_ = nv;
											_tmp195__length1 = nv_length1;
											_tmp196_ = _tmp195_[1];
											_tmp197_ = vala_gidl_parser_eval (self, _tmp196_);
											_tmp198_ = _tmp197_;
											_tmp199_ = g_strcmp0 (_tmp198_, "1") == 0;
											_g_free0 (_tmp198_);
											if (_tmp199_) {
												ValaParameter* _tmp200_ = NULL;
												_tmp200_ = p;
												vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp200_, "CCode", "array_length", FALSE, NULL);
											}
										} else {
											gchar** _tmp201_ = NULL;
											gint _tmp201__length1 = 0;
											const gchar* _tmp202_ = NULL;
											_tmp201_ = nv;
											_tmp201__length1 = nv_length1;
											_tmp202_ = _tmp201_[0];
											if (g_strcmp0 (_tmp202_, "array_length_type") == 0) {
												ValaParameter* _tmp203_ = NULL;
												gchar** _tmp204_ = NULL;
												gint _tmp204__length1 = 0;
												const gchar* _tmp205_ = NULL;
												_tmp203_ = p;
												_tmp204_ = nv;
												_tmp204__length1 = nv_length1;
												_tmp205_ = _tmp204_[1];
												vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp203_, "CCode", "array_length_type", _tmp205_, NULL);
											} else {
												gchar** _tmp206_ = NULL;
												gint _tmp206__length1 = 0;
												const gchar* _tmp207_ = NULL;
												_tmp206_ = nv;
												_tmp206__length1 = nv_length1;
												_tmp207_ = _tmp206_[0];
												if (g_strcmp0 (_tmp207_, "array_null_terminated") == 0) {
													gchar** _tmp208_ = NULL;
													gint _tmp208__length1 = 0;
													const gchar* _tmp209_ = NULL;
													gchar* _tmp210_ = NULL;
													gchar* _tmp211_ = NULL;
													gboolean _tmp212_ = FALSE;
													_tmp208_ = nv;
													_tmp208__length1 = nv_length1;
													_tmp209_ = _tmp208_[1];
													_tmp210_ = vala_gidl_parser_eval (self, _tmp209_);
													_tmp211_ = _tmp210_;
													_tmp212_ = g_strcmp0 (_tmp211_, "1") == 0;
													_g_free0 (_tmp211_);
													if (_tmp212_) {
														ValaParameter* _tmp213_ = NULL;
														ValaParameter* _tmp214_ = NULL;
														_tmp213_ = p;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp213_, "CCode", "array_length", FALSE, NULL);
														_tmp214_ = p;
														vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp214_, "CCode", "array_null_terminated", TRUE, NULL);
													}
												} else {
													gchar** _tmp215_ = NULL;
													gint _tmp215__length1 = 0;
													const gchar* _tmp216_ = NULL;
													_tmp215_ = nv;
													_tmp215__length1 = nv_length1;
													_tmp216_ = _tmp215_[0];
													if (g_strcmp0 (_tmp216_, "is_out") == 0) {
														gchar** _tmp217_ = NULL;
														gint _tmp217__length1 = 0;
														const gchar* _tmp218_ = NULL;
														gchar* _tmp219_ = NULL;
														gchar* _tmp220_ = NULL;
														gboolean _tmp221_ = FALSE;
														_tmp217_ = nv;
														_tmp217__length1 = nv_length1;
														_tmp218_ = _tmp217_[1];
														_tmp219_ = vala_gidl_parser_eval (self, _tmp218_);
														_tmp220_ = _tmp219_;
														_tmp221_ = g_strcmp0 (_tmp220_, "1") == 0;
														_g_free0 (_tmp220_);
														if (_tmp221_) {
															ValaParameter* _tmp222_ = NULL;
															_tmp222_ = p;
															vala_parameter_set_direction (_tmp222_, VALA_PARAMETER_DIRECTION_OUT);
														}
													} else {
														gchar** _tmp223_ = NULL;
														gint _tmp223__length1 = 0;
														const gchar* _tmp224_ = NULL;
														_tmp223_ = nv;
														_tmp223__length1 = nv_length1;
														_tmp224_ = _tmp223_[0];
														if (g_strcmp0 (_tmp224_, "is_ref") == 0) {
															gchar** _tmp225_ = NULL;
															gint _tmp225__length1 = 0;
															const gchar* _tmp226_ = NULL;
															gchar* _tmp227_ = NULL;
															gchar* _tmp228_ = NULL;
															gboolean _tmp229_ = FALSE;
															_tmp225_ = nv;
															_tmp225__length1 = nv_length1;
															_tmp226_ = _tmp225_[1];
															_tmp227_ = vala_gidl_parser_eval (self, _tmp226_);
															_tmp228_ = _tmp227_;
															_tmp229_ = g_strcmp0 (_tmp228_, "1") == 0;
															_g_free0 (_tmp228_);
															if (_tmp229_) {
																ValaParameter* _tmp230_ = NULL;
																_tmp230_ = p;
																vala_parameter_set_direction (_tmp230_, VALA_PARAMETER_DIRECTION_REF);
															}
														} else {
															gchar** _tmp231_ = NULL;
															gint _tmp231__length1 = 0;
															const gchar* _tmp232_ = NULL;
															_tmp231_ = nv;
															_tmp231__length1 = nv_length1;
															_tmp232_ = _tmp231_[0];
															if (g_strcmp0 (_tmp232_, "nullable") == 0) {
																gboolean _tmp233_ = FALSE;
																gchar** _tmp234_ = NULL;
																gint _tmp234__length1 = 0;
																const gchar* _tmp235_ = NULL;
																gchar* _tmp236_ = NULL;
																gchar* _tmp237_ = NULL;
																gboolean _tmp238_ = FALSE;
																_tmp234_ = nv;
																_tmp234__length1 = nv_length1;
																_tmp235_ = _tmp234_[1];
																_tmp236_ = vala_gidl_parser_eval (self, _tmp235_);
																_tmp237_ = _tmp236_;
																_tmp238_ = g_strcmp0 (_tmp237_, "1") == 0;
																_g_free0 (_tmp237_);
																if (_tmp238_) {
																	ValaDataType* _tmp239_ = NULL;
																	_tmp239_ = param_type;
																	_tmp233_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp239_, VALA_TYPE_VOID_TYPE);
																} else {
																	_tmp233_ = FALSE;
																}
																if (_tmp233_) {
																	ValaDataType* _tmp240_ = NULL;
																	_tmp240_ = param_type;
																	vala_data_type_set_nullable (_tmp240_, TRUE);
																}
															} else {
																gchar** _tmp241_ = NULL;
																gint _tmp241__length1 = 0;
																const gchar* _tmp242_ = NULL;
																_tmp241_ = nv;
																_tmp241__length1 = nv_length1;
																_tmp242_ = _tmp241_[0];
																if (g_strcmp0 (_tmp242_, "transfer_ownership") == 0) {
																	gchar** _tmp243_ = NULL;
																	gint _tmp243__length1 = 0;
																	const gchar* _tmp244_ = NULL;
																	gchar* _tmp245_ = NULL;
																	gchar* _tmp246_ = NULL;
																	gboolean _tmp247_ = FALSE;
																	_tmp243_ = nv;
																	_tmp243__length1 = nv_length1;
																	_tmp244_ = _tmp243_[1];
																	_tmp245_ = vala_gidl_parser_eval (self, _tmp244_);
																	_tmp246_ = _tmp245_;
																	_tmp247_ = g_strcmp0 (_tmp246_, "1") == 0;
																	_g_free0 (_tmp246_);
																	if (_tmp247_) {
																		ValaDataType* _tmp248_ = NULL;
																		_tmp248_ = param_type;
																		vala_data_type_set_value_owned (_tmp248_, TRUE);
																	}
																} else {
																	gchar** _tmp249_ = NULL;
																	gint _tmp249__length1 = 0;
																	const gchar* _tmp250_ = NULL;
																	_tmp249_ = nv;
																	_tmp249__length1 = nv_length1;
																	_tmp250_ = _tmp249_[0];
																	if (g_strcmp0 (_tmp250_, "type_name") == 0) {
																		ValaParameter* _tmp251_ = NULL;
																		gchar** _tmp252_ = NULL;
																		gint _tmp252__length1 = 0;
																		const gchar* _tmp253_ = NULL;
																		gchar* _tmp254_ = NULL;
																		gchar* _tmp255_ = NULL;
																		ValaDataType* _tmp256_ = NULL;
																		ValaDataType* _tmp257_ = NULL;
																		_tmp251_ = p;
																		_tmp252_ = nv;
																		_tmp252__length1 = nv_length1;
																		_tmp253_ = _tmp252_[1];
																		_tmp254_ = vala_gidl_parser_eval (self, _tmp253_);
																		_tmp255_ = _tmp254_;
																		_tmp256_ = vala_gidl_parser_parse_type_from_string (self, _tmp255_, FALSE, NULL);
																		_vala_code_node_unref0 (param_type);
																		param_type = _tmp256_;
																		_tmp257_ = param_type;
																		vala_variable_set_variable_type ((ValaVariable*) _tmp251_, _tmp257_);
																		_g_free0 (_tmp255_);
																	} else {
																		gchar** _tmp258_ = NULL;
																		gint _tmp258__length1 = 0;
																		const gchar* _tmp259_ = NULL;
																		_tmp258_ = nv;
																		_tmp258__length1 = nv_length1;
																		_tmp259_ = _tmp258_[0];
																		if (g_strcmp0 (_tmp259_, "type_arguments") == 0) {
																			ValaParameter* _tmp260_ = NULL;
																			ValaDataType* _tmp261_ = NULL;
																			ValaDataType* _tmp262_ = NULL;
																			gchar** _tmp263_ = NULL;
																			gint _tmp263__length1 = 0;
																			const gchar* _tmp264_ = NULL;
																			gchar* _tmp265_ = NULL;
																			gchar* _tmp266_ = NULL;
																			_tmp260_ = p;
																			_tmp261_ = vala_variable_get_variable_type ((ValaVariable*) _tmp260_);
																			_tmp262_ = _tmp261_;
																			_tmp263_ = nv;
																			_tmp263__length1 = nv_length1;
																			_tmp264_ = _tmp263_[1];
																			_tmp265_ = vala_gidl_parser_eval (self, _tmp264_);
																			_tmp266_ = _tmp265_;
																			vala_gidl_parser_parse_type_arguments_from_string (self, _tmp262_, _tmp266_, NULL);
																			_g_free0 (_tmp266_);
																		} else {
																			gchar** _tmp267_ = NULL;
																			gint _tmp267__length1 = 0;
																			const gchar* _tmp268_ = NULL;
																			_tmp267_ = nv;
																			_tmp267__length1 = nv_length1;
																			_tmp268_ = _tmp267_[0];
																			if (g_strcmp0 (_tmp268_, "namespace_name") == 0) {
																				gchar** _tmp269_ = NULL;
																				gint _tmp269__length1 = 0;
																				const gchar* _tmp270_ = NULL;
																				gchar* _tmp271_ = NULL;
																				_tmp269_ = nv;
																				_tmp269__length1 = nv_length1;
																				_tmp270_ = _tmp269_[1];
																				_tmp271_ = vala_gidl_parser_eval (self, _tmp270_);
																				_g_free0 (ns_name);
																				ns_name = _tmp271_;
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
								nv = (_vala_array_free (nv, nv_length1, (GDestroyNotify) g_free), NULL);
								_g_free0 (attr);
							}
						}
					}
					_tmp272_ = ns_name;
					if (_tmp272_ != NULL) {
						ValaDataType* _tmp273_ = NULL;
						ValaUnresolvedSymbol* _tmp274_ = NULL;
						ValaUnresolvedSymbol* _tmp275_ = NULL;
						const gchar* _tmp276_ = NULL;
						ValaUnresolvedSymbol* _tmp277_ = NULL;
						ValaUnresolvedSymbol* _tmp278_ = NULL;
						_tmp273_ = param_type;
						_tmp274_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp273_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
						_tmp275_ = _tmp274_;
						_tmp276_ = ns_name;
						_tmp277_ = vala_unresolved_symbol_new (NULL, _tmp276_, NULL);
						_tmp278_ = _tmp277_;
						vala_unresolved_symbol_set_inner (_tmp275_, _tmp278_);
						_vala_code_node_unref0 (_tmp278_);
					}
					_g_free0 (ns_name);
				}
				_tmp280_ = show_param;
				if (_tmp280_) {
					_tmp279_ = TRUE;
				} else {
					gboolean _tmp281_ = FALSE;
					_tmp281_ = hide_param;
					_tmp279_ = !_tmp281_;
				}
				if (_tmp279_) {
					ValaSignal* _tmp282_ = NULL;
					ValaParameter* _tmp283_ = NULL;
					_tmp282_ = sig;
					_tmp283_ = p;
					vala_signal_add_parameter (_tmp282_, _tmp283_);
				}
				_vala_code_node_unref0 (p);
				_vala_code_node_unref0 (param_type);
			}
		}
	}
	result = sig;
	attributes = (_vala_array_free (attributes, attributes_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


ValaGIdlParser* vala_gidl_parser_construct (GType object_type) {
	ValaGIdlParser* self = NULL;
	self = (ValaGIdlParser*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGIdlParser* vala_gidl_parser_new (void) {
	return vala_gidl_parser_construct (VALA_TYPE_GIDL_PARSER);
}


static void vala_gidl_parser_class_init (ValaGIdlParserClass * klass) {
	vala_gidl_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gidl_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGIdlParserPrivate));
	((ValaCodeVisitorClass *) klass)->visit_namespace = (void (*)(ValaCodeVisitor*, ValaNamespace*)) vala_gidl_parser_real_visit_namespace;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*)(ValaCodeVisitor*, ValaClass*)) vala_gidl_parser_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*)(ValaCodeVisitor*, ValaStruct*)) vala_gidl_parser_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*)(ValaCodeVisitor*, ValaInterface*)) vala_gidl_parser_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*)(ValaCodeVisitor*, ValaEnum*)) vala_gidl_parser_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*)(ValaCodeVisitor*, ValaErrorDomain*)) vala_gidl_parser_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_delegate = (void (*)(ValaCodeVisitor*, ValaDelegate*)) vala_gidl_parser_real_visit_delegate;
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*)(ValaCodeVisitor*, ValaSourceFile*)) vala_gidl_parser_real_visit_source_file;
}


static void vala_gidl_parser_instance_init (ValaGIdlParser * self) {
	self->priv = VALA_GIDL_PARSER_GET_PRIVATE (self);
}


static void vala_gidl_parser_finalize (ValaCodeVisitor* obj) {
	ValaGIdlParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIDL_PARSER, ValaGIdlParser);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_source_reference_unref0 (self->priv->current_source_reference);
	_vala_code_node_unref0 (self->priv->current_namespace);
	_vala_code_node_unref0 (self->priv->current_data_type);
	_vala_map_unref0 (self->priv->codenode_attributes_map);
	_vala_map_unref0 (self->priv->codenode_attributes_patterns);
	_vala_iterable_unref0 (self->priv->current_type_symbol_set);
	_vala_map_unref0 (self->priv->cname_type_map);
	VALA_CODE_VISITOR_CLASS (vala_gidl_parser_parent_class)->finalize (obj);
}


/**
 * Code visitor parsing all GIDL files.
 */
GType vala_gidl_parser_get_type (void) {
	static volatile gsize vala_gidl_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gidl_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGIdlParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gidl_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGIdlParser), 0, (GInstanceInitFunc) vala_gidl_parser_instance_init, NULL };
		GType vala_gidl_parser_type_id;
		vala_gidl_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGIdlParser", &g_define_type_info, 0);
		g_once_init_leave (&vala_gidl_parser_type_id__volatile, vala_gidl_parser_type_id);
	}
	return vala_gidl_parser_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



