/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	ValaList* base_types;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* properties;
	ValaList* signals;
	ValaList* classes;
	ValaList* structs;
	ValaList* enums;
	ValaList* delegates;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _static_destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _destructor;
};


static gpointer vala_class_parent_class = NULL;

#define VALA_CLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS, ValaClassPrivate))
static void vala_class_real_add_constant (ValaSymbol* base, ValaConstant* c);
static void vala_class_real_add_field (ValaSymbol* base, ValaField* f);
static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value);
static void vala_class_real_add_method (ValaSymbol* base, ValaMethod* m);
static ValaList* vala_class_real_get_methods (ValaObjectTypeSymbol* base);
static void vala_class_real_add_property (ValaSymbol* base, ValaProperty* prop);
static ValaList* vala_class_real_get_properties (ValaObjectTypeSymbol* base);
static void vala_class_real_add_signal (ValaSymbol* base, ValaSignal* sig);
static ValaList* vala_class_real_get_signals (ValaObjectTypeSymbol* base);
static void vala_class_real_add_class (ValaSymbol* base, ValaClass* cl);
static void vala_class_real_add_struct (ValaSymbol* base, ValaStruct* st);
static void vala_class_real_add_enum (ValaSymbol* base, ValaEnum* en);
static void vala_class_real_add_delegate (ValaSymbol* base, ValaDelegate* d);
static void vala_class_real_add_constructor (ValaSymbol* base, ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base, ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, ValaList* list);
static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t);
static gboolean vala_class_real_check (ValaCodeNode* base, ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_class_finalize (ValaCodeNode * obj);


/**
 * Returns a copy of the list of classes.
 *
 * @return list of classes
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_class_get_classes (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->classes;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of structs.
 *
 * @return list of structs
 */
ValaList* vala_class_get_structs (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->structs;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of enums.
 *
 * @return list of enums
 */
ValaList* vala_class_get_enums (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->enums;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of delegates.
 *
 * @return list of delegates
 */
ValaList* vala_class_get_delegates (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass* vala_class_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaClass* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


ValaClass* vala_class_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}


/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void vala_class_add_base_type (ValaClass* self, ValaDataType* type) {
	ValaList* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = type;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
ValaList* vala_class_get_base_types (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified constant as a member to this class.
 *
 * @param c a constant
 */
static void vala_class_real_add_constant (ValaSymbol* base, ValaConstant* c) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaConstant* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaConstant* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaConstant* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = c;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = c;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = c;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void vala_class_real_add_field (ValaSymbol* base, ValaField* f) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaField* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaField* _tmp3_;
	ValaSymbolAccessibility _tmp4_;
	ValaSymbolAccessibility _tmp5_;
	ValaScope* _tmp16_;
	ValaScope* _tmp17_;
	ValaField* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	ValaField* _tmp21_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = f;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp3_ = f;
	_tmp4_ = vala_symbol_get_access ((ValaSymbol*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaField* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp6_ = f;
		_tmp7_ = vala_field_get_binding (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp9_ = FALSE;
		ValaField* _tmp10_;
		ValaSymbolAccessibility _tmp11_;
		ValaSymbolAccessibility _tmp12_;
		_tmp10_ = f;
		_tmp11_ = vala_symbol_get_access ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaField* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp13_ = f;
			_tmp14_ = vala_field_get_binding (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
	_tmp16_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = f;
	_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = f;
	vala_scope_add (_tmp17_, _tmp20_, (ValaSymbol*) _tmp21_);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
ValaList* vala_class_get_fields (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList* vala_class_get_constants (ValaClass* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_class_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMethod* _tmp1_;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp32_ = FALSE;
	ValaMethod* _tmp33_;
	ValaDataType* _tmp34_;
	ValaDataType* _tmp35_;
	ValaMethod* _tmp65_;
	ValaList* _tmp93_;
	ValaMethod* _tmp94_;
	ValaMethod* _tmp95_;
	ValaDataType* _tmp96_;
	ValaDataType* _tmp97_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = m;
	_tmp2_ = vala_method_get_binding (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		ValaMethod* _tmp4_;
		_tmp4_ = m;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_CREATION_METHOD);
	}
	if (_tmp0_) {
		ValaMethod* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaMethod* _tmp16_;
		ValaObjectType* _tmp17_;
		ValaObjectType* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		ValaMethod* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		ValaMethod* _tmp24_;
		ValaParameter* _tmp25_;
		ValaParameter* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		ValaMethod* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		_tmp5_ = m;
		_tmp6_ = vala_method_get_this_parameter (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaMethod* _tmp8_;
			ValaScope* _tmp9_;
			ValaScope* _tmp10_;
			ValaMethod* _tmp11_;
			ValaParameter* _tmp12_;
			ValaParameter* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp8_ = m;
			_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = m;
			_tmp12_ = vala_method_get_this_parameter (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			vala_scope_remove (_tmp10_, _tmp15_);
		}
		_tmp16_ = m;
		_tmp17_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_parameter_new ("this", (ValaDataType*) _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		vala_method_set_this_parameter (_tmp16_, _tmp20_);
		_vala_code_node_unref0 (_tmp20_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp21_ = m;
		_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = m;
		_tmp25_ = vala_method_get_this_parameter (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = m;
		_tmp30_ = vala_method_get_this_parameter (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_scope_add (_tmp23_, _tmp28_, (ValaSymbol*) _tmp31_);
	}
	_tmp33_ = m;
	_tmp34_ = vala_callable_get_return_type ((ValaCallable*) _tmp33_);
	_tmp35_ = _tmp34_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_VOID_TYPE)) {
		ValaMethod* _tmp36_;
		ValaList* _tmp37_;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		_tmp36_ = m;
		_tmp37_ = vala_method_get_postconditions (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_tmp32_ = _tmp40_ > 0;
		_vala_iterable_unref0 (_tmp38_);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		ValaMethod* _tmp41_;
		ValaLocalVariable* _tmp42_;
		ValaLocalVariable* _tmp43_;
		ValaMethod* _tmp52_;
		ValaMethod* _tmp53_;
		ValaDataType* _tmp54_;
		ValaDataType* _tmp55_;
		ValaDataType* _tmp56_;
		ValaDataType* _tmp57_;
		ValaSourceReference* _tmp58_;
		ValaSourceReference* _tmp59_;
		ValaLocalVariable* _tmp60_;
		ValaLocalVariable* _tmp61_;
		ValaMethod* _tmp62_;
		ValaLocalVariable* _tmp63_;
		ValaLocalVariable* _tmp64_;
		_tmp41_ = m;
		_tmp42_ = vala_subroutine_get_result_var ((ValaSubroutine*) _tmp41_);
		_tmp43_ = _tmp42_;
		if (_tmp43_ != NULL) {
			ValaMethod* _tmp44_;
			ValaScope* _tmp45_;
			ValaScope* _tmp46_;
			ValaMethod* _tmp47_;
			ValaLocalVariable* _tmp48_;
			ValaLocalVariable* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			_tmp44_ = m;
			_tmp45_ = vala_symbol_get_scope ((ValaSymbol*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = m;
			_tmp48_ = vala_subroutine_get_result_var ((ValaSubroutine*) _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_symbol_get_name ((ValaSymbol*) _tmp49_);
			_tmp51_ = _tmp50_;
			vala_scope_remove (_tmp46_, _tmp51_);
		}
		_tmp52_ = m;
		_tmp53_ = m;
		_tmp54_ = vala_callable_get_return_type ((ValaCallable*) _tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = vala_data_type_copy (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_local_variable_new (_tmp57_, "result", NULL, _tmp59_);
		_tmp61_ = _tmp60_;
		vala_subroutine_set_result_var ((ValaSubroutine*) _tmp52_, _tmp61_);
		_vala_code_node_unref0 (_tmp61_);
		_vala_code_node_unref0 (_tmp57_);
		_tmp62_ = m;
		_tmp63_ = vala_subroutine_get_result_var ((ValaSubroutine*) _tmp62_);
		_tmp64_ = _tmp63_;
		vala_local_variable_set_is_result (_tmp64_, TRUE);
	}
	_tmp65_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp66_;
		const gchar* _tmp67_;
		const gchar* _tmp68_;
		ValaCreationMethod* cm = NULL;
		ValaMethod* _tmp71_;
		ValaCreationMethod* _tmp72_;
		gboolean _tmp73_ = FALSE;
		ValaCreationMethod* _tmp74_;
		const gchar* _tmp75_;
		const gchar* _tmp76_;
		_tmp66_ = m;
		_tmp67_ = vala_symbol_get_name ((ValaSymbol*) _tmp66_);
		_tmp68_ = _tmp67_;
		if (_tmp68_ == NULL) {
			ValaMethod* _tmp69_;
			ValaMethod* _tmp70_;
			_tmp69_ = m;
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			_tmp70_ = m;
			vala_symbol_set_name ((ValaSymbol*) _tmp70_, ".new");
		}
		_tmp71_ = m;
		_tmp72_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp72_;
		_tmp74_ = cm;
		_tmp75_ = vala_creation_method_get_class_name (_tmp74_);
		_tmp76_ = _tmp75_;
		if (_tmp76_ != NULL) {
			ValaCreationMethod* _tmp77_;
			const gchar* _tmp78_;
			const gchar* _tmp79_;
			const gchar* _tmp80_;
			const gchar* _tmp81_;
			_tmp77_ = cm;
			_tmp78_ = vala_creation_method_get_class_name (_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp81_ = _tmp80_;
			_tmp73_ = g_strcmp0 (_tmp79_, _tmp81_) != 0;
		} else {
			_tmp73_ = FALSE;
		}
		if (_tmp73_) {
			ValaMethod* _tmp82_;
			ValaSourceReference* _tmp83_;
			ValaSourceReference* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			ValaCreationMethod* _tmp87_;
			const gchar* _tmp88_;
			const gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			ValaMethod* _tmp92_;
			_tmp82_ = m;
			_tmp83_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp86_ = _tmp85_;
			_tmp87_ = cm;
			_tmp88_ = vala_creation_method_get_class_name (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp86_, _tmp89_);
			_tmp91_ = _tmp90_;
			vala_report_error (_tmp84_, _tmp91_);
			_g_free0 (_tmp91_);
			_g_free0 (_tmp86_);
			_tmp92_ = m;
			vala_code_node_set_error ((ValaCodeNode*) _tmp92_, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp93_ = self->priv->methods;
	_tmp94_ = m;
	vala_collection_add ((ValaCollection*) _tmp93_, _tmp94_);
	_tmp95_ = m;
	_tmp96_ = vala_method_get_base_interface_type (_tmp95_);
	_tmp97_ = _tmp96_;
	if (_tmp97_ == NULL) {
		ValaScope* _tmp98_;
		ValaScope* _tmp99_;
		ValaMethod* _tmp100_;
		const gchar* _tmp101_;
		const gchar* _tmp102_;
		ValaMethod* _tmp103_;
		_tmp98_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = m;
		_tmp101_ = vala_symbol_get_name ((ValaSymbol*) _tmp100_);
		_tmp102_ = _tmp101_;
		_tmp103_ = m;
		vala_scope_add (_tmp99_, _tmp102_, (ValaSymbol*) _tmp103_);
	} else {
		ValaScope* _tmp104_;
		ValaScope* _tmp105_;
		ValaMethod* _tmp106_;
		_tmp104_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp105_ = _tmp104_;
		_tmp106_ = m;
		vala_scope_add (_tmp105_, NULL, (ValaSymbol*) _tmp106_);
	}
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
static ValaList* vala_class_real_get_methods (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaClass*) base;
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void vala_class_real_add_property (ValaSymbol* base, ValaProperty* prop) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaProperty* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaProperty* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaProperty* _tmp7_;
	ValaProperty* _tmp8_;
	ValaObjectType* _tmp9_;
	ValaObjectType* _tmp10_;
	ValaParameter* _tmp11_;
	ValaParameter* _tmp12_;
	ValaProperty* _tmp13_;
	ValaScope* _tmp14_;
	ValaScope* _tmp15_;
	ValaProperty* _tmp16_;
	ValaParameter* _tmp17_;
	ValaParameter* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	ValaProperty* _tmp21_;
	ValaParameter* _tmp22_;
	ValaParameter* _tmp23_;
	ValaProperty* _tmp24_;
	ValaField* _tmp25_;
	ValaField* _tmp26_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->properties;
	_tmp1_ = prop;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = prop;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = prop;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
	_tmp8_ = prop;
	_tmp9_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_parameter_new ("this", (ValaDataType*) _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	vala_property_set_this_parameter (_tmp8_, _tmp12_);
	_vala_code_node_unref0 (_tmp12_);
	_vala_code_node_unref0 (_tmp10_);
	_tmp13_ = prop;
	_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = prop;
	_tmp17_ = vala_property_get_this_parameter (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = prop;
	_tmp22_ = vala_property_get_this_parameter (_tmp21_);
	_tmp23_ = _tmp22_;
	vala_scope_add (_tmp15_, _tmp20_, (ValaSymbol*) _tmp23_);
	_tmp24_ = prop;
	_tmp25_ = vala_property_get_field (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaProperty* _tmp27_;
		ValaField* _tmp28_;
		ValaField* _tmp29_;
		_tmp27_ = prop;
		_tmp28_ = vala_property_get_field (_tmp27_);
		_tmp29_ = _tmp28_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp29_);
	}
}


/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
static ValaList* vala_class_real_get_properties (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaClass*) base;
	_tmp0_ = self->priv->properties;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified signal as a member to this class.
 *
 * @param sig a signal
 */
static void vala_class_real_add_signal (ValaSymbol* base, ValaSignal* sig) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaSignal* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaSignal* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaSignal* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = self->priv->signals;
	_tmp1_ = sig;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = sig;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sig;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Returns a copy of the list of signals.
 *
 * @return list of signals
 */
static ValaList* vala_class_real_get_signals (ValaObjectTypeSymbol* base) {
	ValaClass * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaClass*) base;
	_tmp0_ = self->priv->signals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified class as an inner class.
 *
 * @param cl a class
 */
static void vala_class_real_add_class (ValaSymbol* base, ValaClass* cl) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaClass* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaClass* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaClass* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (cl != NULL);
	_tmp0_ = self->priv->classes;
	_tmp1_ = cl;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = cl;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = cl;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified struct as an inner struct.
 *
 * @param st a struct
 */
static void vala_class_real_add_struct (ValaSymbol* base, ValaStruct* st) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaStruct* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaStruct* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaStruct* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (st != NULL);
	_tmp0_ = self->priv->structs;
	_tmp1_ = st;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = st;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = st;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified enum as an inner enum.
 *
 * @param en an enum
 */
static void vala_class_real_add_enum (ValaSymbol* base, ValaEnum* en) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaEnum* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaEnum* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaEnum* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (en != NULL);
	_tmp0_ = self->priv->enums;
	_tmp1_ = en;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = en;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = en;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified delegate as an inner delegate.
 *
 * @param d a delegate
 */
static void vala_class_real_add_delegate (ValaSymbol* base, ValaDelegate* d) {
	ValaClass * self;
	ValaList* _tmp0_;
	ValaDelegate* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaDelegate* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaDelegate* _tmp7_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = self->priv->delegates;
	_tmp1_ = d;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = d;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = d;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


static void vala_class_real_add_constructor (ValaSymbol* base, ValaConstructor* c) {
	ValaClass * self;
	ValaConstructor* _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = c;
	_tmp1_ = vala_constructor_get_binding (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaConstructor* _tmp3_;
		ValaConstructor* _tmp7_;
		_tmp3_ = self->priv->_constructor;
		if (_tmp3_ != NULL) {
			ValaConstructor* _tmp4_;
			ValaSourceReference* _tmp5_;
			ValaSourceReference* _tmp6_;
			_tmp4_ = c;
			_tmp5_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp4_);
			_tmp6_ = _tmp5_;
			vala_report_error (_tmp6_, "class already contains a constructor");
		}
		_tmp7_ = c;
		vala_class_set_constructor (self, _tmp7_);
	} else {
		ValaConstructor* _tmp8_;
		ValaMemberBinding _tmp9_;
		ValaMemberBinding _tmp10_;
		_tmp8_ = c;
		_tmp9_ = vala_constructor_get_binding (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == VALA_MEMBER_BINDING_CLASS) {
			ValaConstructor* _tmp11_;
			ValaConstructor* _tmp15_;
			_tmp11_ = self->priv->_class_constructor;
			if (_tmp11_ != NULL) {
				ValaConstructor* _tmp12_;
				ValaSourceReference* _tmp13_;
				ValaSourceReference* _tmp14_;
				_tmp12_ = c;
				_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp12_);
				_tmp14_ = _tmp13_;
				vala_report_error (_tmp14_, "class already contains a class constructor");
			}
			_tmp15_ = c;
			vala_class_set_class_constructor (self, _tmp15_);
		} else {
			ValaConstructor* _tmp16_;
			ValaConstructor* _tmp20_;
			_tmp16_ = self->priv->_static_constructor;
			if (_tmp16_ != NULL) {
				ValaConstructor* _tmp17_;
				ValaSourceReference* _tmp18_;
				ValaSourceReference* _tmp19_;
				_tmp17_ = c;
				_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp17_);
				_tmp19_ = _tmp18_;
				vala_report_error (_tmp19_, "class already contains a static constructor");
			}
			_tmp20_ = c;
			vala_class_set_static_constructor (self, _tmp20_);
		}
	}
}


static void vala_class_real_add_destructor (ValaSymbol* base, ValaDestructor* d) {
	ValaClass * self;
	ValaDestructor* _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = d;
	_tmp1_ = vala_destructor_get_binding (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaDestructor* _tmp3_;
		ValaDestructor* _tmp4_;
		ValaDestructor* _tmp8_;
		_tmp3_ = vala_class_get_destructor (self);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaDestructor* _tmp5_;
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			_tmp5_ = d;
			_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp5_);
			_tmp7_ = _tmp6_;
			vala_report_error (_tmp7_, "class already contains a destructor");
		}
		_tmp8_ = d;
		vala_class_set_destructor (self, _tmp8_);
	} else {
		ValaDestructor* _tmp9_;
		ValaMemberBinding _tmp10_;
		ValaMemberBinding _tmp11_;
		_tmp9_ = d;
		_tmp10_ = vala_destructor_get_binding (_tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == VALA_MEMBER_BINDING_CLASS) {
			ValaDestructor* _tmp12_;
			ValaDestructor* _tmp16_;
			_tmp12_ = self->priv->_class_destructor;
			if (_tmp12_ != NULL) {
				ValaDestructor* _tmp13_;
				ValaSourceReference* _tmp14_;
				ValaSourceReference* _tmp15_;
				_tmp13_ = d;
				_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp15_, "class already contains a class destructor");
			}
			_tmp16_ = d;
			vala_class_set_class_destructor (self, _tmp16_);
		} else {
			ValaDestructor* _tmp17_;
			ValaDestructor* _tmp21_;
			_tmp17_ = self->priv->_static_destructor;
			if (_tmp17_ != NULL) {
				ValaDestructor* _tmp18_;
				ValaSourceReference* _tmp19_;
				ValaSourceReference* _tmp20_;
				_tmp18_ = d;
				_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp18_);
				_tmp20_ = _tmp19_;
				vala_report_error (_tmp20_, "class already contains a static destructor");
			}
			_tmp21_ = d;
			vala_class_set_static_destructor (self, _tmp21_);
		}
	}
}


static void vala_class_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_class (_tmp0_, self);
}


static void vala_class_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaClass * self;
	ValaConstructor* _tmp103_;
	ValaConstructor* _tmp106_;
	ValaConstructor* _tmp109_;
	ValaDestructor* _tmp112_;
	ValaDestructor* _tmp113_;
	ValaDestructor* _tmp117_;
	ValaDestructor* _tmp120_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			ValaCodeVisitor* _tmp12_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			_tmp12_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, _tmp12_);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp13_;
		gint _p_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _p_index = 0;
		_tmp13_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp13_;
		_tmp14_ = _p_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_p_size = _tmp16_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaTypeParameter* _tmp23_;
			ValaCodeVisitor* _tmp24_;
			_tmp17_ = _p_index;
			_p_index = _tmp17_ + 1;
			_tmp18_ = _p_index;
			_tmp19_ = _p_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _p_list;
			_tmp21_ = _p_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			p = (ValaTypeParameter*) _tmp22_;
			_tmp23_ = p;
			_tmp24_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, _tmp24_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp25_;
		ValaList* _tmp26_;
		gint _en_size = 0;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _en_index = 0;
		_tmp25_ = self->priv->enums;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_en_list = _tmp26_;
		_tmp27_ = _en_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_en_size = _tmp29_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			ValaEnum* en = NULL;
			ValaList* _tmp33_;
			gint _tmp34_;
			gpointer _tmp35_;
			ValaEnum* _tmp36_;
			ValaCodeVisitor* _tmp37_;
			_tmp30_ = _en_index;
			_en_index = _tmp30_ + 1;
			_tmp31_ = _en_index;
			_tmp32_ = _en_size;
			if (!(_tmp31_ < _tmp32_)) {
				break;
			}
			_tmp33_ = _en_list;
			_tmp34_ = _en_index;
			_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
			en = (ValaEnum*) _tmp35_;
			_tmp36_ = en;
			_tmp37_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp36_, _tmp37_);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp38_;
		ValaList* _tmp39_;
		gint _f_size = 0;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _f_index = 0;
		_tmp38_ = self->priv->fields;
		_tmp39_ = _vala_iterable_ref0 (_tmp38_);
		_f_list = _tmp39_;
		_tmp40_ = _f_list;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_f_size = _tmp42_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			ValaField* f = NULL;
			ValaList* _tmp46_;
			gint _tmp47_;
			gpointer _tmp48_;
			ValaField* _tmp49_;
			ValaCodeVisitor* _tmp50_;
			_tmp43_ = _f_index;
			_f_index = _tmp43_ + 1;
			_tmp44_ = _f_index;
			_tmp45_ = _f_size;
			if (!(_tmp44_ < _tmp45_)) {
				break;
			}
			_tmp46_ = _f_list;
			_tmp47_ = _f_index;
			_tmp48_ = vala_list_get (_tmp46_, _tmp47_);
			f = (ValaField*) _tmp48_;
			_tmp49_ = f;
			_tmp50_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp49_, _tmp50_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp51_;
		ValaList* _tmp52_;
		gint _c_size = 0;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _c_index = 0;
		_tmp51_ = self->priv->constants;
		_tmp52_ = _vala_iterable_ref0 (_tmp51_);
		_c_list = _tmp52_;
		_tmp53_ = _c_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_c_size = _tmp55_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			ValaConstant* c = NULL;
			ValaList* _tmp59_;
			gint _tmp60_;
			gpointer _tmp61_;
			ValaConstant* _tmp62_;
			ValaCodeVisitor* _tmp63_;
			_tmp56_ = _c_index;
			_c_index = _tmp56_ + 1;
			_tmp57_ = _c_index;
			_tmp58_ = _c_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _c_list;
			_tmp60_ = _c_index;
			_tmp61_ = vala_list_get (_tmp59_, _tmp60_);
			c = (ValaConstant*) _tmp61_;
			_tmp62_ = c;
			_tmp63_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp62_, _tmp63_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp64_;
		ValaList* _tmp65_;
		gint _m_size = 0;
		ValaList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint _m_index = 0;
		_tmp64_ = self->priv->methods;
		_tmp65_ = _vala_iterable_ref0 (_tmp64_);
		_m_list = _tmp65_;
		_tmp66_ = _m_list;
		_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		_m_size = _tmp68_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			ValaMethod* m = NULL;
			ValaList* _tmp72_;
			gint _tmp73_;
			gpointer _tmp74_;
			ValaMethod* _tmp75_;
			ValaCodeVisitor* _tmp76_;
			_tmp69_ = _m_index;
			_m_index = _tmp69_ + 1;
			_tmp70_ = _m_index;
			_tmp71_ = _m_size;
			if (!(_tmp70_ < _tmp71_)) {
				break;
			}
			_tmp72_ = _m_list;
			_tmp73_ = _m_index;
			_tmp74_ = vala_list_get (_tmp72_, _tmp73_);
			m = (ValaMethod*) _tmp74_;
			_tmp75_ = m;
			_tmp76_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp75_, _tmp76_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp77_;
		ValaList* _tmp78_;
		gint _prop_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _prop_index = 0;
		_tmp77_ = self->priv->properties;
		_tmp78_ = _vala_iterable_ref0 (_tmp77_);
		_prop_list = _tmp78_;
		_tmp79_ = _prop_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_prop_size = _tmp81_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			ValaProperty* prop = NULL;
			ValaList* _tmp85_;
			gint _tmp86_;
			gpointer _tmp87_;
			ValaProperty* _tmp88_;
			ValaCodeVisitor* _tmp89_;
			_tmp82_ = _prop_index;
			_prop_index = _tmp82_ + 1;
			_tmp83_ = _prop_index;
			_tmp84_ = _prop_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _prop_list;
			_tmp86_ = _prop_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			prop = (ValaProperty*) _tmp87_;
			_tmp88_ = prop;
			_tmp89_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, _tmp89_);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp90_;
		ValaList* _tmp91_;
		gint _sig_size = 0;
		ValaList* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gint _sig_index = 0;
		_tmp90_ = self->priv->signals;
		_tmp91_ = _vala_iterable_ref0 (_tmp90_);
		_sig_list = _tmp91_;
		_tmp92_ = _sig_list;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
		_tmp94_ = _tmp93_;
		_sig_size = _tmp94_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp95_;
			gint _tmp96_;
			gint _tmp97_;
			ValaSignal* sig = NULL;
			ValaList* _tmp98_;
			gint _tmp99_;
			gpointer _tmp100_;
			ValaSignal* _tmp101_;
			ValaCodeVisitor* _tmp102_;
			_tmp95_ = _sig_index;
			_sig_index = _tmp95_ + 1;
			_tmp96_ = _sig_index;
			_tmp97_ = _sig_size;
			if (!(_tmp96_ < _tmp97_)) {
				break;
			}
			_tmp98_ = _sig_list;
			_tmp99_ = _sig_index;
			_tmp100_ = vala_list_get (_tmp98_, _tmp99_);
			sig = (ValaSignal*) _tmp100_;
			_tmp101_ = sig;
			_tmp102_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp101_, _tmp102_);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp103_ = self->priv->_constructor;
	if (_tmp103_ != NULL) {
		ValaConstructor* _tmp104_;
		ValaCodeVisitor* _tmp105_;
		_tmp104_ = self->priv->_constructor;
		_tmp105_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp104_, _tmp105_);
	}
	_tmp106_ = self->priv->_class_constructor;
	if (_tmp106_ != NULL) {
		ValaConstructor* _tmp107_;
		ValaCodeVisitor* _tmp108_;
		_tmp107_ = self->priv->_class_constructor;
		_tmp108_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp107_, _tmp108_);
	}
	_tmp109_ = self->priv->_static_constructor;
	if (_tmp109_ != NULL) {
		ValaConstructor* _tmp110_;
		ValaCodeVisitor* _tmp111_;
		_tmp110_ = self->priv->_static_constructor;
		_tmp111_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp110_, _tmp111_);
	}
	_tmp112_ = vala_class_get_destructor (self);
	_tmp113_ = _tmp112_;
	if (_tmp113_ != NULL) {
		ValaDestructor* _tmp114_;
		ValaDestructor* _tmp115_;
		ValaCodeVisitor* _tmp116_;
		_tmp114_ = vala_class_get_destructor (self);
		_tmp115_ = _tmp114_;
		_tmp116_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp115_, _tmp116_);
	}
	_tmp117_ = self->priv->_static_destructor;
	if (_tmp117_ != NULL) {
		ValaDestructor* _tmp118_;
		ValaCodeVisitor* _tmp119_;
		_tmp118_ = self->priv->_static_destructor;
		_tmp119_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp118_, _tmp119_);
	}
	_tmp120_ = self->priv->_class_destructor;
	if (_tmp120_ != NULL) {
		ValaDestructor* _tmp121_;
		ValaCodeVisitor* _tmp122_;
		_tmp121_ = self->priv->_class_destructor;
		_tmp122_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp121_, _tmp122_);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp123_;
		ValaList* _tmp124_;
		gint _cl_size = 0;
		ValaList* _tmp125_;
		gint _tmp126_;
		gint _tmp127_;
		gint _cl_index = 0;
		_tmp123_ = self->priv->classes;
		_tmp124_ = _vala_iterable_ref0 (_tmp123_);
		_cl_list = _tmp124_;
		_tmp125_ = _cl_list;
		_tmp126_ = vala_collection_get_size ((ValaCollection*) _tmp125_);
		_tmp127_ = _tmp126_;
		_cl_size = _tmp127_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			ValaClass* cl = NULL;
			ValaList* _tmp131_;
			gint _tmp132_;
			gpointer _tmp133_;
			ValaClass* _tmp134_;
			ValaCodeVisitor* _tmp135_;
			_tmp128_ = _cl_index;
			_cl_index = _tmp128_ + 1;
			_tmp129_ = _cl_index;
			_tmp130_ = _cl_size;
			if (!(_tmp129_ < _tmp130_)) {
				break;
			}
			_tmp131_ = _cl_list;
			_tmp132_ = _cl_index;
			_tmp133_ = vala_list_get (_tmp131_, _tmp132_);
			cl = (ValaClass*) _tmp133_;
			_tmp134_ = cl;
			_tmp135_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp134_, _tmp135_);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp136_;
		ValaList* _tmp137_;
		gint _st_size = 0;
		ValaList* _tmp138_;
		gint _tmp139_;
		gint _tmp140_;
		gint _st_index = 0;
		_tmp136_ = self->priv->structs;
		_tmp137_ = _vala_iterable_ref0 (_tmp136_);
		_st_list = _tmp137_;
		_tmp138_ = _st_list;
		_tmp139_ = vala_collection_get_size ((ValaCollection*) _tmp138_);
		_tmp140_ = _tmp139_;
		_st_size = _tmp140_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp141_;
			gint _tmp142_;
			gint _tmp143_;
			ValaStruct* st = NULL;
			ValaList* _tmp144_;
			gint _tmp145_;
			gpointer _tmp146_;
			ValaStruct* _tmp147_;
			ValaCodeVisitor* _tmp148_;
			_tmp141_ = _st_index;
			_st_index = _tmp141_ + 1;
			_tmp142_ = _st_index;
			_tmp143_ = _st_size;
			if (!(_tmp142_ < _tmp143_)) {
				break;
			}
			_tmp144_ = _st_list;
			_tmp145_ = _st_index;
			_tmp146_ = vala_list_get (_tmp144_, _tmp145_);
			st = (ValaStruct*) _tmp146_;
			_tmp147_ = st;
			_tmp148_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp147_, _tmp148_);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp149_;
		ValaList* _tmp150_;
		gint _d_size = 0;
		ValaList* _tmp151_;
		gint _tmp152_;
		gint _tmp153_;
		gint _d_index = 0;
		_tmp149_ = self->priv->delegates;
		_tmp150_ = _vala_iterable_ref0 (_tmp149_);
		_d_list = _tmp150_;
		_tmp151_ = _d_list;
		_tmp152_ = vala_collection_get_size ((ValaCollection*) _tmp151_);
		_tmp153_ = _tmp152_;
		_d_size = _tmp153_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp154_;
			gint _tmp155_;
			gint _tmp156_;
			ValaDelegate* d = NULL;
			ValaList* _tmp157_;
			gint _tmp158_;
			gpointer _tmp159_;
			ValaDelegate* _tmp160_;
			ValaCodeVisitor* _tmp161_;
			_tmp154_ = _d_index;
			_d_index = _tmp154_ + 1;
			_tmp155_ = _d_index;
			_tmp156_ = _d_size;
			if (!(_tmp155_ < _tmp156_)) {
				break;
			}
			_tmp157_ = _d_list;
			_tmp158_ = _d_index;
			_tmp159_ = vala_list_get (_tmp157_, _tmp158_);
			d = (ValaDelegate*) _tmp159_;
			_tmp160_ = d;
			_tmp161_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp160_, _tmp161_);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base) {
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


gboolean vala_class_is_fundamental (ValaClass* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaClass * self;
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = t;
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == _tmp0_) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _base_type_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _base_type_index = 0;
		_tmp1_ = self->priv->base_types;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_base_type_list = _tmp2_;
		_tmp3_ = _base_type_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_base_type_size = _tmp5_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			gboolean _tmp12_ = FALSE;
			ValaDataType* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			_tmp6_ = _base_type_index;
			_base_type_index = _tmp6_ + 1;
			_tmp7_ = _base_type_index;
			_tmp8_ = _base_type_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _base_type_list;
			_tmp10_ = _base_type_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			base_type = (ValaDataType*) _tmp11_;
			_tmp13_ = base_type;
			_tmp14_ = vala_data_type_get_data_type (_tmp13_);
			_tmp15_ = _tmp14_;
			if (_tmp15_ != NULL) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				gboolean _tmp20_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = t;
				_tmp20_ = vala_typesymbol_is_subtype_of (_tmp18_, _tmp19_);
				_tmp12_ = _tmp20_;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static void vala_class_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				ValaDataType* _tmp10_;
				gboolean _tmp11_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->base_types;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->base_types;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = old_type;
				_tmp11_ = _tmp9_ == _tmp10_;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp11_) {
					ValaList* _tmp12_;
					gint _tmp13_;
					ValaDataType* _tmp14_;
					ValaDataType* _tmp15_;
					_tmp12_ = self->priv->base_types;
					_tmp13_ = i;
					_tmp14_ = new_type;
					vala_list_set (_tmp12_, _tmp13_, _tmp14_);
					_tmp15_ = new_type;
					vala_code_node_set_parent_node ((ValaCodeNode*) _tmp15_, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static void vala_class_get_all_prerequisites (ValaClass* self, ValaInterface* iface, ValaList* list) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaInterface* _tmp0_;
		ValaList* _tmp1_;
		gint _prereq_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prereq_index = 0;
		_tmp0_ = iface;
		_tmp1_ = vala_interface_get_prerequisites (_tmp0_);
		_prereq_list = _tmp1_;
		_tmp2_ = _prereq_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prereq_size = _tmp4_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			ValaList* _tmp16_;
			ValaTypeSymbol* _tmp17_;
			ValaTypeSymbol* _tmp18_;
			_tmp5_ = _prereq_index;
			_prereq_index = _tmp5_ + 1;
			_tmp6_ = _prereq_index;
			_tmp7_ = _prereq_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _prereq_list;
			_tmp9_ = _prereq_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			prereq = (ValaDataType*) _tmp10_;
			_tmp11_ = prereq;
			_tmp12_ = vala_data_type_get_data_type (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = _vala_code_node_ref0 (_tmp13_);
			type = _tmp14_;
			_tmp15_ = type;
			if (_tmp15_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp16_ = list;
			_tmp17_ = type;
			vala_collection_add ((ValaCollection*) _tmp16_, _tmp17_);
			_tmp18_ = type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_INTERFACE)) {
				ValaTypeSymbol* _tmp19_;
				ValaList* _tmp20_;
				_tmp19_ = type;
				_tmp20_ = list;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_INTERFACE, ValaInterface), _tmp20_);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}


static gboolean vala_class_class_is_a (ValaClass* self, ValaClass* cl, ValaTypeSymbol* t) {
	gboolean result = FALSE;
	ValaClass* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = cl;
	_tmp1_ = t;
	if (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == _tmp1_) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaClass* _tmp2_;
		ValaList* _tmp3_;
		gint _base_type_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _base_type_index = 0;
		_tmp2_ = cl;
		_tmp3_ = vala_class_get_base_types (_tmp2_);
		_base_type_list = _tmp3_;
		_tmp4_ = _base_type_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_base_type_size = _tmp6_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaDataType* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			_tmp7_ = _base_type_index;
			_base_type_index = _tmp7_ + 1;
			_tmp8_ = _base_type_index;
			_tmp9_ = _base_type_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _base_type_list;
			_tmp11_ = _base_type_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			base_type = (ValaDataType*) _tmp12_;
			_tmp13_ = base_type;
			_tmp14_ = vala_data_type_get_data_type (_tmp13_);
			_tmp15_ = _tmp14_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_CLASS)) {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				gboolean _tmp20_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = t;
				_tmp20_ = vala_class_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_CLASS, ValaClass), _tmp19_);
				if (_tmp20_) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				_tmp21_ = base_type;
				_tmp22_ = vala_data_type_get_data_type (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = t;
				if (_tmp23_ == _tmp24_) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_class_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaClass * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaCodeContext* _tmp25_;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaConstructor* _tmp205_;
	ValaConstructor* _tmp208_;
	ValaConstructor* _tmp211_;
	ValaDestructor* _tmp214_;
	ValaDestructor* _tmp215_;
	ValaDestructor* _tmp219_;
	ValaDestructor* _tmp222_;
	gboolean _tmp264_;
	gboolean _tmp265_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp314_;
	ValaArrayList* _tmp315_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp333_;
	ValaArrayList* _tmp334_;
	ValaList* _tmp352_;
	gint _tmp353_;
	gint _tmp354_;
	ValaSourceFileType _tmp382_;
	ValaSourceFileType _tmp383_;
	ValaCodeContext* _tmp610_;
	ValaSemanticAnalyzer* _tmp611_;
	ValaSemanticAnalyzer* _tmp612_;
	ValaSourceFile* _tmp613_;
	ValaCodeContext* _tmp614_;
	ValaSemanticAnalyzer* _tmp615_;
	ValaSemanticAnalyzer* _tmp616_;
	ValaSymbol* _tmp617_;
	gboolean _tmp618_;
	gboolean _tmp619_;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_;
		ValaSemanticAnalyzer* _tmp19_;
		ValaSemanticAnalyzer* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceFile* _tmp23_;
		ValaSourceFile* _tmp24_;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp28_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _base_type_reference_index = 0;
		_tmp28_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp28_;
		_tmp29_ = _base_type_reference_list;
		_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_base_type_reference_size = _tmp31_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp35_;
			gint _tmp36_;
			gpointer _tmp37_;
			ValaDataType* _tmp38_;
			ValaCodeContext* _tmp39_;
			gboolean _tmp40_;
			ValaDataType* _tmp41_;
			ValaCodeContext* _tmp51_;
			ValaSemanticAnalyzer* _tmp52_;
			ValaSemanticAnalyzer* _tmp53_;
			ValaDataType* _tmp54_;
			gboolean _tmp55_;
			gint n_type_args = 0;
			ValaDataType* _tmp65_;
			ValaList* _tmp66_;
			ValaList* _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint n_type_params = 0;
			ValaDataType* _tmp71_;
			ValaTypeSymbol* _tmp72_;
			ValaTypeSymbol* _tmp73_;
			ValaList* _tmp74_;
			ValaList* _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			_tmp32_ = _base_type_reference_index;
			_base_type_reference_index = _tmp32_ + 1;
			_tmp33_ = _base_type_reference_index;
			_tmp34_ = _base_type_reference_size;
			if (!(_tmp33_ < _tmp34_)) {
				break;
			}
			_tmp35_ = _base_type_reference_list;
			_tmp36_ = _base_type_reference_index;
			_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
			base_type_reference = (ValaDataType*) _tmp37_;
			_tmp38_ = base_type_reference;
			_tmp39_ = context;
			_tmp40_ = vala_code_node_check ((ValaCodeNode*) _tmp38_, _tmp39_);
			if (!_tmp40_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp41_ = base_type_reference;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp41_, VALA_TYPE_OBJECT_TYPE)) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				ValaDataType* _tmp44_;
				gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = base_type_reference;
				_tmp45_ = vala_code_node_to_string ((ValaCodeNode*) _tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp48_ = _tmp47_;
				_tmp49_ = g_strdup_printf ("base type `%s` of class `%s` is not an object type", _tmp46_, _tmp48_);
				_tmp50_ = _tmp49_;
				vala_report_error (_tmp43_, _tmp50_);
				_g_free0 (_tmp50_);
				_g_free0 (_tmp48_);
				_g_free0 (_tmp46_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp51_ = context;
			_tmp52_ = vala_code_context_get_analyzer (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = base_type_reference;
			_tmp55_ = vala_semantic_analyzer_is_type_accessible (_tmp53_, (ValaSymbol*) self, _tmp54_);
			if (!_tmp55_) {
				ValaSourceReference* _tmp56_;
				ValaSourceReference* _tmp57_;
				ValaDataType* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp57_ = _tmp56_;
				_tmp58_ = base_type_reference;
				_tmp59_ = vala_code_node_to_string ((ValaCodeNode*) _tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				_tmp63_ = g_strdup_printf ("base type `%s` is less accessible than class `%s`", _tmp60_, _tmp62_);
				_tmp64_ = _tmp63_;
				vala_report_error (_tmp57_, _tmp64_);
				_g_free0 (_tmp64_);
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp65_ = base_type_reference;
			_tmp66_ = vala_data_type_get_type_arguments (_tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_collection_get_size ((ValaCollection*) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = _tmp69_;
			_vala_iterable_unref0 (_tmp67_);
			n_type_args = _tmp70_;
			_tmp71_ = base_type_reference;
			_tmp72_ = vala_data_type_get_data_type (_tmp71_);
			_tmp73_ = _tmp72_;
			_tmp74_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = _tmp77_;
			_vala_iterable_unref0 (_tmp75_);
			n_type_params = _tmp78_;
			_tmp79_ = n_type_args;
			_tmp80_ = n_type_params;
			if (_tmp79_ < _tmp80_) {
				ValaDataType* _tmp81_;
				ValaSourceReference* _tmp82_;
				ValaSourceReference* _tmp83_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp81_ = base_type_reference;
				_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp81_);
				_tmp83_ = _tmp82_;
				vala_report_error (_tmp83_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				gint _tmp84_;
				gint _tmp85_;
				_tmp84_ = n_type_args;
				_tmp85_ = n_type_params;
				if (_tmp84_ > _tmp85_) {
					ValaDataType* _tmp86_;
					ValaSourceReference* _tmp87_;
					ValaSourceReference* _tmp88_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp86_ = base_type_reference;
					_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp86_);
					_tmp88_ = _tmp87_;
					vala_report_error (_tmp88_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp89_;
		ValaList* _tmp90_;
		gint _type_size = 0;
		ValaList* _tmp91_;
		gint _tmp92_;
		gint _tmp93_;
		gint _type_index = 0;
		_tmp89_ = self->priv->base_types;
		_tmp90_ = _vala_iterable_ref0 (_tmp89_);
		_type_list = _tmp90_;
		_tmp91_ = _type_list;
		_tmp92_ = vala_collection_get_size ((ValaCollection*) _tmp91_);
		_tmp93_ = _tmp92_;
		_type_size = _tmp93_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp94_;
			gint _tmp95_;
			gint _tmp96_;
			ValaDataType* type = NULL;
			ValaList* _tmp97_;
			gint _tmp98_;
			gpointer _tmp99_;
			ValaDataType* _tmp100_;
			ValaCodeContext* _tmp101_;
			_tmp94_ = _type_index;
			_type_index = _tmp94_ + 1;
			_tmp95_ = _type_index;
			_tmp96_ = _type_size;
			if (!(_tmp95_ < _tmp96_)) {
				break;
			}
			_tmp97_ = _type_list;
			_tmp98_ = _type_index;
			_tmp99_ = vala_list_get (_tmp97_, _tmp98_);
			type = (ValaDataType*) _tmp99_;
			_tmp100_ = type;
			_tmp101_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp100_, _tmp101_);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp102_;
		gint _p_size = 0;
		ValaList* _tmp103_;
		gint _tmp104_;
		gint _tmp105_;
		gint _p_index = 0;
		_tmp102_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp102_;
		_tmp103_ = _p_list;
		_tmp104_ = vala_collection_get_size ((ValaCollection*) _tmp103_);
		_tmp105_ = _tmp104_;
		_p_size = _tmp105_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp106_;
			gint _tmp107_;
			gint _tmp108_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp109_;
			gint _tmp110_;
			gpointer _tmp111_;
			ValaTypeParameter* _tmp112_;
			ValaCodeContext* _tmp113_;
			_tmp106_ = _p_index;
			_p_index = _tmp106_ + 1;
			_tmp107_ = _p_index;
			_tmp108_ = _p_size;
			if (!(_tmp107_ < _tmp108_)) {
				break;
			}
			_tmp109_ = _p_list;
			_tmp110_ = _p_index;
			_tmp111_ = vala_list_get (_tmp109_, _tmp110_);
			p = (ValaTypeParameter*) _tmp111_;
			_tmp112_ = p;
			_tmp113_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp112_, _tmp113_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp114_;
		ValaList* _tmp115_;
		gint _en_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _en_index = 0;
		_tmp114_ = self->priv->enums;
		_tmp115_ = _vala_iterable_ref0 (_tmp114_);
		_en_list = _tmp115_;
		_tmp116_ = _en_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_en_size = _tmp118_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			ValaEnum* en = NULL;
			ValaList* _tmp122_;
			gint _tmp123_;
			gpointer _tmp124_;
			ValaEnum* _tmp125_;
			ValaCodeContext* _tmp126_;
			_tmp119_ = _en_index;
			_en_index = _tmp119_ + 1;
			_tmp120_ = _en_index;
			_tmp121_ = _en_size;
			if (!(_tmp120_ < _tmp121_)) {
				break;
			}
			_tmp122_ = _en_list;
			_tmp123_ = _en_index;
			_tmp124_ = vala_list_get (_tmp122_, _tmp123_);
			en = (ValaEnum*) _tmp124_;
			_tmp125_ = en;
			_tmp126_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp125_, _tmp126_);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp127_;
		ValaList* _tmp128_;
		gint _f_size = 0;
		ValaList* _tmp129_;
		gint _tmp130_;
		gint _tmp131_;
		gint _f_index = 0;
		_tmp127_ = self->priv->fields;
		_tmp128_ = _vala_iterable_ref0 (_tmp127_);
		_f_list = _tmp128_;
		_tmp129_ = _f_list;
		_tmp130_ = vala_collection_get_size ((ValaCollection*) _tmp129_);
		_tmp131_ = _tmp130_;
		_f_size = _tmp131_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp132_;
			gint _tmp133_;
			gint _tmp134_;
			ValaField* f = NULL;
			ValaList* _tmp135_;
			gint _tmp136_;
			gpointer _tmp137_;
			ValaField* _tmp138_;
			ValaCodeContext* _tmp139_;
			_tmp132_ = _f_index;
			_f_index = _tmp132_ + 1;
			_tmp133_ = _f_index;
			_tmp134_ = _f_size;
			if (!(_tmp133_ < _tmp134_)) {
				break;
			}
			_tmp135_ = _f_list;
			_tmp136_ = _f_index;
			_tmp137_ = vala_list_get (_tmp135_, _tmp136_);
			f = (ValaField*) _tmp137_;
			_tmp138_ = f;
			_tmp139_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp138_, _tmp139_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp140_;
		ValaList* _tmp141_;
		gint _c_size = 0;
		ValaList* _tmp142_;
		gint _tmp143_;
		gint _tmp144_;
		gint _c_index = 0;
		_tmp140_ = self->priv->constants;
		_tmp141_ = _vala_iterable_ref0 (_tmp140_);
		_c_list = _tmp141_;
		_tmp142_ = _c_list;
		_tmp143_ = vala_collection_get_size ((ValaCollection*) _tmp142_);
		_tmp144_ = _tmp143_;
		_c_size = _tmp144_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp145_;
			gint _tmp146_;
			gint _tmp147_;
			ValaConstant* c = NULL;
			ValaList* _tmp148_;
			gint _tmp149_;
			gpointer _tmp150_;
			ValaConstant* _tmp151_;
			ValaCodeContext* _tmp152_;
			_tmp145_ = _c_index;
			_c_index = _tmp145_ + 1;
			_tmp146_ = _c_index;
			_tmp147_ = _c_size;
			if (!(_tmp146_ < _tmp147_)) {
				break;
			}
			_tmp148_ = _c_list;
			_tmp149_ = _c_index;
			_tmp150_ = vala_list_get (_tmp148_, _tmp149_);
			c = (ValaConstant*) _tmp150_;
			_tmp151_ = c;
			_tmp152_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp151_, _tmp152_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp153_;
		ValaList* _tmp154_;
		gint _m_size = 0;
		ValaList* _tmp155_;
		gint _tmp156_;
		gint _tmp157_;
		gint _m_index = 0;
		_tmp153_ = self->priv->methods;
		_tmp154_ = _vala_iterable_ref0 (_tmp153_);
		_m_list = _tmp154_;
		_tmp155_ = _m_list;
		_tmp156_ = vala_collection_get_size ((ValaCollection*) _tmp155_);
		_tmp157_ = _tmp156_;
		_m_size = _tmp157_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp158_;
			gint _tmp159_;
			gint _tmp160_;
			ValaMethod* m = NULL;
			ValaList* _tmp161_;
			gint _tmp162_;
			gpointer _tmp163_;
			ValaMethod* _tmp164_;
			ValaCodeContext* _tmp165_;
			_tmp158_ = _m_index;
			_m_index = _tmp158_ + 1;
			_tmp159_ = _m_index;
			_tmp160_ = _m_size;
			if (!(_tmp159_ < _tmp160_)) {
				break;
			}
			_tmp161_ = _m_list;
			_tmp162_ = _m_index;
			_tmp163_ = vala_list_get (_tmp161_, _tmp162_);
			m = (ValaMethod*) _tmp163_;
			_tmp164_ = m;
			_tmp165_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp164_, _tmp165_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp166_;
		ValaList* _tmp167_;
		gint _prop_size = 0;
		ValaList* _tmp168_;
		gint _tmp169_;
		gint _tmp170_;
		gint _prop_index = 0;
		_tmp166_ = self->priv->properties;
		_tmp167_ = _vala_iterable_ref0 (_tmp166_);
		_prop_list = _tmp167_;
		_tmp168_ = _prop_list;
		_tmp169_ = vala_collection_get_size ((ValaCollection*) _tmp168_);
		_tmp170_ = _tmp169_;
		_prop_size = _tmp170_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp171_;
			gint _tmp172_;
			gint _tmp173_;
			ValaProperty* prop = NULL;
			ValaList* _tmp174_;
			gint _tmp175_;
			gpointer _tmp176_;
			gboolean _tmp177_ = FALSE;
			ValaProperty* _tmp178_;
			ValaAttribute* _tmp179_;
			ValaAttribute* _tmp180_;
			gboolean _tmp181_;
			ValaProperty* _tmp190_;
			ValaCodeContext* _tmp191_;
			_tmp171_ = _prop_index;
			_prop_index = _tmp171_ + 1;
			_tmp172_ = _prop_index;
			_tmp173_ = _prop_size;
			if (!(_tmp172_ < _tmp173_)) {
				break;
			}
			_tmp174_ = _prop_list;
			_tmp175_ = _prop_index;
			_tmp176_ = vala_list_get (_tmp174_, _tmp175_);
			prop = (ValaProperty*) _tmp176_;
			_tmp178_ = prop;
			_tmp179_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp178_, "NoAccessorMethod");
			_tmp180_ = _tmp179_;
			_tmp181_ = _tmp180_ != NULL;
			_vala_code_node_unref0 (_tmp180_);
			if (_tmp181_) {
				ValaCodeContext* _tmp182_;
				ValaSemanticAnalyzer* _tmp183_;
				ValaSemanticAnalyzer* _tmp184_;
				ValaClass* _tmp185_;
				gboolean _tmp186_;
				_tmp182_ = context;
				_tmp183_ = vala_code_context_get_analyzer (_tmp182_);
				_tmp184_ = _tmp183_;
				_tmp185_ = _tmp184_->object_type;
				_tmp186_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp185_);
				_tmp177_ = !_tmp186_;
			} else {
				_tmp177_ = FALSE;
			}
			if (_tmp177_) {
				ValaProperty* _tmp187_;
				ValaSourceReference* _tmp188_;
				ValaSourceReference* _tmp189_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp187_ = prop;
				_tmp188_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp187_);
				_tmp189_ = _tmp188_;
				vala_report_error (_tmp189_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp190_ = prop;
			_tmp191_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp190_, _tmp191_);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp192_;
		ValaList* _tmp193_;
		gint _sig_size = 0;
		ValaList* _tmp194_;
		gint _tmp195_;
		gint _tmp196_;
		gint _sig_index = 0;
		_tmp192_ = self->priv->signals;
		_tmp193_ = _vala_iterable_ref0 (_tmp192_);
		_sig_list = _tmp193_;
		_tmp194_ = _sig_list;
		_tmp195_ = vala_collection_get_size ((ValaCollection*) _tmp194_);
		_tmp196_ = _tmp195_;
		_sig_size = _tmp196_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp197_;
			gint _tmp198_;
			gint _tmp199_;
			ValaSignal* sig = NULL;
			ValaList* _tmp200_;
			gint _tmp201_;
			gpointer _tmp202_;
			ValaSignal* _tmp203_;
			ValaCodeContext* _tmp204_;
			_tmp197_ = _sig_index;
			_sig_index = _tmp197_ + 1;
			_tmp198_ = _sig_index;
			_tmp199_ = _sig_size;
			if (!(_tmp198_ < _tmp199_)) {
				break;
			}
			_tmp200_ = _sig_list;
			_tmp201_ = _sig_index;
			_tmp202_ = vala_list_get (_tmp200_, _tmp201_);
			sig = (ValaSignal*) _tmp202_;
			_tmp203_ = sig;
			_tmp204_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp203_, _tmp204_);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp205_ = self->priv->_constructor;
	if (_tmp205_ != NULL) {
		ValaConstructor* _tmp206_;
		ValaCodeContext* _tmp207_;
		_tmp206_ = self->priv->_constructor;
		_tmp207_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp206_, _tmp207_);
	}
	_tmp208_ = self->priv->_class_constructor;
	if (_tmp208_ != NULL) {
		ValaConstructor* _tmp209_;
		ValaCodeContext* _tmp210_;
		_tmp209_ = self->priv->_class_constructor;
		_tmp210_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp209_, _tmp210_);
	}
	_tmp211_ = self->priv->_static_constructor;
	if (_tmp211_ != NULL) {
		ValaConstructor* _tmp212_;
		ValaCodeContext* _tmp213_;
		_tmp212_ = self->priv->_static_constructor;
		_tmp213_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp212_, _tmp213_);
	}
	_tmp214_ = vala_class_get_destructor (self);
	_tmp215_ = _tmp214_;
	if (_tmp215_ != NULL) {
		ValaDestructor* _tmp216_;
		ValaDestructor* _tmp217_;
		ValaCodeContext* _tmp218_;
		_tmp216_ = vala_class_get_destructor (self);
		_tmp217_ = _tmp216_;
		_tmp218_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp217_, _tmp218_);
	}
	_tmp219_ = self->priv->_static_destructor;
	if (_tmp219_ != NULL) {
		ValaDestructor* _tmp220_;
		ValaCodeContext* _tmp221_;
		_tmp220_ = self->priv->_static_destructor;
		_tmp221_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp220_, _tmp221_);
	}
	_tmp222_ = self->priv->_class_destructor;
	if (_tmp222_ != NULL) {
		ValaDestructor* _tmp223_;
		ValaCodeContext* _tmp224_;
		_tmp223_ = self->priv->_class_destructor;
		_tmp224_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp223_, _tmp224_);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp225_;
		ValaList* _tmp226_;
		gint _cl_size = 0;
		ValaList* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		gint _cl_index = 0;
		_tmp225_ = self->priv->classes;
		_tmp226_ = _vala_iterable_ref0 (_tmp225_);
		_cl_list = _tmp226_;
		_tmp227_ = _cl_list;
		_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
		_tmp229_ = _tmp228_;
		_cl_size = _tmp229_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp230_;
			gint _tmp231_;
			gint _tmp232_;
			ValaClass* cl = NULL;
			ValaList* _tmp233_;
			gint _tmp234_;
			gpointer _tmp235_;
			ValaClass* _tmp236_;
			ValaCodeContext* _tmp237_;
			_tmp230_ = _cl_index;
			_cl_index = _tmp230_ + 1;
			_tmp231_ = _cl_index;
			_tmp232_ = _cl_size;
			if (!(_tmp231_ < _tmp232_)) {
				break;
			}
			_tmp233_ = _cl_list;
			_tmp234_ = _cl_index;
			_tmp235_ = vala_list_get (_tmp233_, _tmp234_);
			cl = (ValaClass*) _tmp235_;
			_tmp236_ = cl;
			_tmp237_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp236_, _tmp237_);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp238_;
		ValaList* _tmp239_;
		gint _st_size = 0;
		ValaList* _tmp240_;
		gint _tmp241_;
		gint _tmp242_;
		gint _st_index = 0;
		_tmp238_ = self->priv->structs;
		_tmp239_ = _vala_iterable_ref0 (_tmp238_);
		_st_list = _tmp239_;
		_tmp240_ = _st_list;
		_tmp241_ = vala_collection_get_size ((ValaCollection*) _tmp240_);
		_tmp242_ = _tmp241_;
		_st_size = _tmp242_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp243_;
			gint _tmp244_;
			gint _tmp245_;
			ValaStruct* st = NULL;
			ValaList* _tmp246_;
			gint _tmp247_;
			gpointer _tmp248_;
			ValaStruct* _tmp249_;
			ValaCodeContext* _tmp250_;
			_tmp243_ = _st_index;
			_st_index = _tmp243_ + 1;
			_tmp244_ = _st_index;
			_tmp245_ = _st_size;
			if (!(_tmp244_ < _tmp245_)) {
				break;
			}
			_tmp246_ = _st_list;
			_tmp247_ = _st_index;
			_tmp248_ = vala_list_get (_tmp246_, _tmp247_);
			st = (ValaStruct*) _tmp248_;
			_tmp249_ = st;
			_tmp250_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp249_, _tmp250_);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp251_;
		ValaList* _tmp252_;
		gint _d_size = 0;
		ValaList* _tmp253_;
		gint _tmp254_;
		gint _tmp255_;
		gint _d_index = 0;
		_tmp251_ = self->priv->delegates;
		_tmp252_ = _vala_iterable_ref0 (_tmp251_);
		_d_list = _tmp252_;
		_tmp253_ = _d_list;
		_tmp254_ = vala_collection_get_size ((ValaCollection*) _tmp253_);
		_tmp255_ = _tmp254_;
		_d_size = _tmp255_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp256_;
			gint _tmp257_;
			gint _tmp258_;
			ValaDelegate* d = NULL;
			ValaList* _tmp259_;
			gint _tmp260_;
			gpointer _tmp261_;
			ValaDelegate* _tmp262_;
			ValaCodeContext* _tmp263_;
			_tmp256_ = _d_index;
			_d_index = _tmp256_ + 1;
			_tmp257_ = _d_index;
			_tmp258_ = _d_size;
			if (!(_tmp257_ < _tmp258_)) {
				break;
			}
			_tmp259_ = _d_list;
			_tmp260_ = _d_index;
			_tmp261_ = vala_list_get (_tmp259_, _tmp260_);
			d = (ValaDelegate*) _tmp261_;
			_tmp262_ = d;
			_tmp263_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp262_, _tmp263_);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp264_ = vala_class_get_is_compact (self);
	_tmp265_ = _tmp264_;
	if (_tmp265_) {
		gboolean _tmp285_ = FALSE;
		gboolean _tmp286_ = FALSE;
		gboolean _tmp287_ = FALSE;
		gboolean _tmp288_;
		gboolean _tmp289_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp266_;
			gint _base_type_size = 0;
			ValaList* _tmp267_;
			gint _tmp268_;
			gint _tmp269_;
			gint _base_type_index = 0;
			_tmp266_ = vala_class_get_base_types (self);
			_base_type_list = _tmp266_;
			_tmp267_ = _base_type_list;
			_tmp268_ = vala_collection_get_size ((ValaCollection*) _tmp267_);
			_tmp269_ = _tmp268_;
			_base_type_size = _tmp269_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp270_;
				gint _tmp271_;
				gint _tmp272_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp273_;
				gint _tmp274_;
				gpointer _tmp275_;
				ValaDataType* _tmp276_;
				ValaTypeSymbol* _tmp277_;
				ValaTypeSymbol* _tmp278_;
				_tmp270_ = _base_type_index;
				_base_type_index = _tmp270_ + 1;
				_tmp271_ = _base_type_index;
				_tmp272_ = _base_type_size;
				if (!(_tmp271_ < _tmp272_)) {
					break;
				}
				_tmp273_ = _base_type_list;
				_tmp274_ = _base_type_index;
				_tmp275_ = vala_list_get (_tmp273_, _tmp274_);
				base_type = (ValaDataType*) _tmp275_;
				_tmp276_ = base_type;
				_tmp277_ = vala_data_type_get_data_type (_tmp276_);
				_tmp278_ = _tmp277_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp278_, VALA_TYPE_INTERFACE)) {
					ValaSourceReference* _tmp279_;
					ValaSourceReference* _tmp280_;
					gchar* _tmp281_;
					gchar* _tmp282_;
					gchar* _tmp283_;
					gchar* _tmp284_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp279_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp282_ = _tmp281_;
					_tmp283_ = g_strdup_printf ("compact classes `%s` may not implement interfaces", _tmp282_);
					_tmp284_ = _tmp283_;
					vala_report_error (_tmp280_, _tmp284_);
					_g_free0 (_tmp284_);
					_g_free0 (_tmp282_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp288_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp289_ = _tmp288_;
		if (!_tmp289_) {
			gboolean _tmp290_;
			gboolean _tmp291_;
			_tmp290_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp291_ = _tmp290_;
			_tmp287_ = !_tmp291_;
		} else {
			_tmp287_ = FALSE;
		}
		if (_tmp287_) {
			ValaClass* _tmp292_;
			_tmp292_ = self->priv->_base_class;
			_tmp286_ = _tmp292_ != NULL;
		} else {
			_tmp286_ = FALSE;
		}
		if (_tmp286_) {
			ValaClass* _tmp293_;
			ValaCodeContext* _tmp294_;
			ValaSemanticAnalyzer* _tmp295_;
			ValaSemanticAnalyzer* _tmp296_;
			ValaClass* _tmp297_;
			_tmp293_ = self->priv->_base_class;
			_tmp294_ = context;
			_tmp295_ = vala_code_context_get_analyzer (_tmp294_);
			_tmp296_ = _tmp295_;
			_tmp297_ = _tmp296_->gsource_type;
			_tmp285_ = _tmp293_ != _tmp297_;
		} else {
			_tmp285_ = FALSE;
		}
		if (_tmp285_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp298_;
				ValaList* _tmp299_;
				gint _f_size = 0;
				ValaList* _tmp300_;
				gint _tmp301_;
				gint _tmp302_;
				gint _f_index = 0;
				_tmp298_ = self->priv->fields;
				_tmp299_ = _vala_iterable_ref0 (_tmp298_);
				_f_list = _tmp299_;
				_tmp300_ = _f_list;
				_tmp301_ = vala_collection_get_size ((ValaCollection*) _tmp300_);
				_tmp302_ = _tmp301_;
				_f_size = _tmp302_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp303_;
					gint _tmp304_;
					gint _tmp305_;
					ValaField* f = NULL;
					ValaList* _tmp306_;
					gint _tmp307_;
					gpointer _tmp308_;
					ValaField* _tmp309_;
					ValaMemberBinding _tmp310_;
					ValaMemberBinding _tmp311_;
					_tmp303_ = _f_index;
					_f_index = _tmp303_ + 1;
					_tmp304_ = _f_index;
					_tmp305_ = _f_size;
					if (!(_tmp304_ < _tmp305_)) {
						break;
					}
					_tmp306_ = _f_list;
					_tmp307_ = _f_index;
					_tmp308_ = vala_list_get (_tmp306_, _tmp307_);
					f = (ValaField*) _tmp308_;
					_tmp309_ = f;
					_tmp310_ = vala_field_get_binding (_tmp309_);
					_tmp311_ = _tmp310_;
					if (_tmp311_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp312_;
						ValaSourceReference* _tmp313_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp312_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp313_ = _tmp312_;
						vala_report_error (_tmp313_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp314_ = g_direct_equal;
	_tmp315_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp314_);
	prerequisites = (ValaList*) _tmp315_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp316_;
		gint _base_type_size = 0;
		ValaList* _tmp317_;
		gint _tmp318_;
		gint _tmp319_;
		gint _base_type_index = 0;
		_tmp316_ = vala_class_get_base_types (self);
		_base_type_list = _tmp316_;
		_tmp317_ = _base_type_list;
		_tmp318_ = vala_collection_get_size ((ValaCollection*) _tmp317_);
		_tmp319_ = _tmp318_;
		_base_type_size = _tmp319_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp320_;
			gint _tmp321_;
			gint _tmp322_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp323_;
			gint _tmp324_;
			gpointer _tmp325_;
			ValaDataType* _tmp326_;
			ValaTypeSymbol* _tmp327_;
			ValaTypeSymbol* _tmp328_;
			_tmp320_ = _base_type_index;
			_base_type_index = _tmp320_ + 1;
			_tmp321_ = _base_type_index;
			_tmp322_ = _base_type_size;
			if (!(_tmp321_ < _tmp322_)) {
				break;
			}
			_tmp323_ = _base_type_list;
			_tmp324_ = _base_type_index;
			_tmp325_ = vala_list_get (_tmp323_, _tmp324_);
			base_type = (ValaDataType*) _tmp325_;
			_tmp326_ = base_type;
			_tmp327_ = vala_data_type_get_data_type (_tmp326_);
			_tmp328_ = _tmp327_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp328_, VALA_TYPE_INTERFACE)) {
				ValaDataType* _tmp329_;
				ValaTypeSymbol* _tmp330_;
				ValaTypeSymbol* _tmp331_;
				ValaList* _tmp332_;
				_tmp329_ = base_type;
				_tmp330_ = vala_data_type_get_data_type (_tmp329_);
				_tmp331_ = _tmp330_;
				_tmp332_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp331_, VALA_TYPE_INTERFACE, ValaInterface), _tmp332_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp333_ = g_direct_equal;
	_tmp334_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp333_);
	missing_prereqs = (ValaList*) _tmp334_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp335_;
		ValaList* _tmp336_;
		gint _prereq_size = 0;
		ValaList* _tmp337_;
		gint _tmp338_;
		gint _tmp339_;
		gint _prereq_index = 0;
		_tmp335_ = prerequisites;
		_tmp336_ = _vala_iterable_ref0 (_tmp335_);
		_prereq_list = _tmp336_;
		_tmp337_ = _prereq_list;
		_tmp338_ = vala_collection_get_size ((ValaCollection*) _tmp337_);
		_tmp339_ = _tmp338_;
		_prereq_size = _tmp339_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp340_;
			gint _tmp341_;
			gint _tmp342_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp343_;
			gint _tmp344_;
			gpointer _tmp345_;
			ValaTypeSymbol* _tmp346_;
			gboolean _tmp347_;
			_tmp340_ = _prereq_index;
			_prereq_index = _tmp340_ + 1;
			_tmp341_ = _prereq_index;
			_tmp342_ = _prereq_size;
			if (!(_tmp341_ < _tmp342_)) {
				break;
			}
			_tmp343_ = _prereq_list;
			_tmp344_ = _prereq_index;
			_tmp345_ = vala_list_get (_tmp343_, _tmp344_);
			prereq = (ValaTypeSymbol*) _tmp345_;
			_tmp346_ = prereq;
			_tmp347_ = vala_class_class_is_a (self, self, _tmp346_);
			if (!_tmp347_) {
				ValaList* _tmp348_;
				ValaTypeSymbol* _tmp349_;
				gchar* _tmp350_;
				gchar* _tmp351_;
				_tmp348_ = missing_prereqs;
				_tmp349_ = prereq;
				_tmp350_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp349_);
				_tmp351_ = _tmp350_;
				vala_list_insert (_tmp348_, 0, _tmp351_);
				_g_free0 (_tmp351_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp352_ = missing_prereqs;
	_tmp353_ = vala_collection_get_size ((ValaCollection*) _tmp352_);
	_tmp354_ = _tmp353_;
	if (_tmp354_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp355_;
		gchar* _tmp356_;
		gchar* _tmp357_;
		gchar* _tmp358_;
		gboolean first = FALSE;
		const gchar* _tmp377_;
		gchar* _tmp378_;
		ValaSourceReference* _tmp379_;
		ValaSourceReference* _tmp380_;
		const gchar* _tmp381_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp355_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp356_ = _tmp355_;
		_tmp357_ = g_strdup_printf ("%s: some prerequisites (", _tmp356_);
		_tmp358_ = _tmp357_;
		_g_free0 (_tmp356_);
		error_string = _tmp358_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp359_;
			ValaList* _tmp360_;
			gint _s_size = 0;
			ValaList* _tmp361_;
			gint _tmp362_;
			gint _tmp363_;
			gint _s_index = 0;
			_tmp359_ = missing_prereqs;
			_tmp360_ = _vala_iterable_ref0 (_tmp359_);
			_s_list = _tmp360_;
			_tmp361_ = _s_list;
			_tmp362_ = vala_collection_get_size ((ValaCollection*) _tmp361_);
			_tmp363_ = _tmp362_;
			_s_size = _tmp363_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp364_;
				gint _tmp365_;
				gint _tmp366_;
				gchar* s = NULL;
				ValaList* _tmp367_;
				gint _tmp368_;
				gpointer _tmp369_;
				gboolean _tmp370_;
				_tmp364_ = _s_index;
				_s_index = _tmp364_ + 1;
				_tmp365_ = _s_index;
				_tmp366_ = _s_size;
				if (!(_tmp365_ < _tmp366_)) {
					break;
				}
				_tmp367_ = _s_list;
				_tmp368_ = _s_index;
				_tmp369_ = vala_list_get (_tmp367_, _tmp368_);
				s = (gchar*) _tmp369_;
				_tmp370_ = first;
				if (_tmp370_) {
					const gchar* _tmp371_;
					const gchar* _tmp372_;
					gchar* _tmp373_;
					_tmp371_ = error_string;
					_tmp372_ = s;
					_tmp373_ = g_strdup_printf ("%s`%s'", _tmp371_, _tmp372_);
					_g_free0 (error_string);
					error_string = _tmp373_;
					first = FALSE;
				} else {
					const gchar* _tmp374_;
					const gchar* _tmp375_;
					gchar* _tmp376_;
					_tmp374_ = error_string;
					_tmp375_ = s;
					_tmp376_ = g_strdup_printf ("%s, `%s'", _tmp374_, _tmp375_);
					_g_free0 (error_string);
					error_string = _tmp376_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp377_ = error_string;
		_tmp378_ = g_strconcat (_tmp377_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp378_;
		_tmp379_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp380_ = _tmp379_;
		_tmp381_ = error_string;
		vala_report_error (_tmp380_, _tmp381_);
		_g_free0 (error_string);
	}
	_tmp382_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp383_ = _tmp382_;
	if (_tmp383_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp534_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp384_;
			gint _base_type_size = 0;
			ValaList* _tmp385_;
			gint _tmp386_;
			gint _tmp387_;
			gint _base_type_index = 0;
			_tmp384_ = vala_class_get_base_types (self);
			_base_type_list = _tmp384_;
			_tmp385_ = _base_type_list;
			_tmp386_ = vala_collection_get_size ((ValaCollection*) _tmp385_);
			_tmp387_ = _tmp386_;
			_base_type_size = _tmp387_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp388_;
				gint _tmp389_;
				gint _tmp390_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp391_;
				gint _tmp392_;
				gpointer _tmp393_;
				ValaDataType* _tmp394_;
				ValaTypeSymbol* _tmp395_;
				ValaTypeSymbol* _tmp396_;
				_tmp388_ = _base_type_index;
				_base_type_index = _tmp388_ + 1;
				_tmp389_ = _base_type_index;
				_tmp390_ = _base_type_size;
				if (!(_tmp389_ < _tmp390_)) {
					break;
				}
				_tmp391_ = _base_type_list;
				_tmp392_ = _base_type_index;
				_tmp393_ = vala_list_get (_tmp391_, _tmp392_);
				base_type = (ValaDataType*) _tmp393_;
				_tmp394_ = base_type;
				_tmp395_ = vala_data_type_get_data_type (_tmp394_);
				_tmp396_ = _tmp395_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp396_, VALA_TYPE_INTERFACE)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp397_;
					ValaTypeSymbol* _tmp398_;
					ValaTypeSymbol* _tmp399_;
					ValaInterface* _tmp400_;
					gboolean _tmp401_ = FALSE;
					ValaClass* _tmp402_;
					_tmp397_ = base_type;
					_tmp398_ = vala_data_type_get_data_type (_tmp397_);
					_tmp399_ = _tmp398_;
					_tmp400_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp399_, VALA_TYPE_INTERFACE, ValaInterface));
					iface = _tmp400_;
					_tmp402_ = self->priv->_base_class;
					if (_tmp402_ != NULL) {
						ValaClass* _tmp403_;
						ValaInterface* _tmp404_;
						gboolean _tmp405_;
						_tmp403_ = self->priv->_base_class;
						_tmp404_ = iface;
						_tmp405_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp403_, (ValaTypeSymbol*) _tmp404_);
						_tmp401_ = _tmp405_;
					} else {
						_tmp401_ = FALSE;
					}
					if (_tmp401_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp406_;
						ValaList* _tmp407_;
						gint _m_size = 0;
						ValaList* _tmp408_;
						gint _tmp409_;
						gint _tmp410_;
						gint _m_index = 0;
						_tmp406_ = iface;
						_tmp407_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp406_);
						_m_list = _tmp407_;
						_tmp408_ = _m_list;
						_tmp409_ = vala_collection_get_size ((ValaCollection*) _tmp408_);
						_tmp410_ = _tmp409_;
						_m_size = _tmp410_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp411_;
							gint _tmp412_;
							gint _tmp413_;
							ValaMethod* m = NULL;
							ValaList* _tmp414_;
							gint _tmp415_;
							gpointer _tmp416_;
							ValaMethod* _tmp417_;
							gboolean _tmp418_;
							gboolean _tmp419_;
							_tmp411_ = _m_index;
							_m_index = _tmp411_ + 1;
							_tmp412_ = _m_index;
							_tmp413_ = _m_size;
							if (!(_tmp412_ < _tmp413_)) {
								break;
							}
							_tmp414_ = _m_list;
							_tmp415_ = _m_index;
							_tmp416_ = vala_list_get (_tmp414_, _tmp415_);
							m = (ValaMethod*) _tmp416_;
							_tmp417_ = m;
							_tmp418_ = vala_method_get_is_abstract (_tmp417_);
							_tmp419_ = _tmp418_;
							if (_tmp419_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								ValaClass* _tmp420_;
								gboolean _tmp459_;
								implemented = FALSE;
								_tmp420_ = _vala_code_node_ref0 (self);
								base_class = _tmp420_;
								while (TRUE) {
									ValaClass* _tmp421_;
									ValaClass* _tmp456_;
									ValaClass* _tmp457_;
									ValaClass* _tmp458_;
									_tmp421_ = base_class;
									if (!(_tmp421_ != NULL)) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp422_;
										ValaList* _tmp423_;
										gint _impl_size = 0;
										ValaList* _tmp424_;
										gint _tmp425_;
										gint _tmp426_;
										gint _impl_index = 0;
										_tmp422_ = base_class;
										_tmp423_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp422_);
										_impl_list = _tmp423_;
										_tmp424_ = _impl_list;
										_tmp425_ = vala_collection_get_size ((ValaCollection*) _tmp424_);
										_tmp426_ = _tmp425_;
										_impl_size = _tmp426_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp427_;
											gint _tmp428_;
											gint _tmp429_;
											ValaMethod* impl = NULL;
											ValaList* _tmp430_;
											gint _tmp431_;
											gpointer _tmp432_;
											gboolean _tmp433_ = FALSE;
											ValaMethod* _tmp434_;
											const gchar* _tmp435_;
											const gchar* _tmp436_;
											ValaMethod* _tmp437_;
											const gchar* _tmp438_;
											const gchar* _tmp439_;
											_tmp427_ = _impl_index;
											_impl_index = _tmp427_ + 1;
											_tmp428_ = _impl_index;
											_tmp429_ = _impl_size;
											if (!(_tmp428_ < _tmp429_)) {
												break;
											}
											_tmp430_ = _impl_list;
											_tmp431_ = _impl_index;
											_tmp432_ = vala_list_get (_tmp430_, _tmp431_);
											impl = (ValaMethod*) _tmp432_;
											_tmp434_ = impl;
											_tmp435_ = vala_symbol_get_name ((ValaSymbol*) _tmp434_);
											_tmp436_ = _tmp435_;
											_tmp437_ = m;
											_tmp438_ = vala_symbol_get_name ((ValaSymbol*) _tmp437_);
											_tmp439_ = _tmp438_;
											if (g_strcmp0 (_tmp436_, _tmp439_) == 0) {
												gboolean _tmp440_ = FALSE;
												ValaMethod* _tmp441_;
												ValaDataType* _tmp442_;
												ValaDataType* _tmp443_;
												_tmp441_ = impl;
												_tmp442_ = vala_method_get_base_interface_type (_tmp441_);
												_tmp443_ = _tmp442_;
												if (_tmp443_ == NULL) {
													_tmp440_ = TRUE;
												} else {
													ValaMethod* _tmp444_;
													ValaDataType* _tmp445_;
													ValaDataType* _tmp446_;
													ValaTypeSymbol* _tmp447_;
													ValaTypeSymbol* _tmp448_;
													ValaInterface* _tmp449_;
													_tmp444_ = impl;
													_tmp445_ = vala_method_get_base_interface_type (_tmp444_);
													_tmp446_ = _tmp445_;
													_tmp447_ = vala_data_type_get_data_type (_tmp446_);
													_tmp448_ = _tmp447_;
													_tmp449_ = iface;
													_tmp440_ = _tmp448_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp449_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
												}
												_tmp433_ = _tmp440_;
											} else {
												_tmp433_ = FALSE;
											}
											if (_tmp433_) {
												ValaMethod* _tmp450_;
												ValaVersionAttribute* _tmp451_;
												ValaVersionAttribute* _tmp452_;
												ValaSourceReference* _tmp453_;
												ValaSourceReference* _tmp454_;
												ValaMethod* _tmp455_;
												_tmp450_ = impl;
												_tmp451_ = vala_symbol_get_version ((ValaSymbol*) _tmp450_);
												_tmp452_ = _tmp451_;
												_tmp453_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp454_ = _tmp453_;
												vala_version_attribute_check (_tmp452_, _tmp454_);
												_tmp455_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp455_, TRUE);
												implemented = TRUE;
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp456_ = base_class;
									_tmp457_ = _tmp456_->priv->_base_class;
									_tmp458_ = _vala_code_node_ref0 (_tmp457_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp458_;
								}
								_tmp459_ = implemented;
								if (!_tmp459_) {
									ValaSourceReference* _tmp460_;
									ValaSourceReference* _tmp461_;
									gchar* _tmp462_;
									gchar* _tmp463_;
									ValaMethod* _tmp464_;
									gchar* _tmp465_;
									gchar* _tmp466_;
									gchar* _tmp467_;
									gchar* _tmp468_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp460_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp461_ = _tmp460_;
									_tmp462_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp463_ = _tmp462_;
									_tmp464_ = m;
									_tmp465_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp464_);
									_tmp466_ = _tmp465_;
									_tmp467_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp463_, _tmp466_);
									_tmp468_ = _tmp467_;
									vala_report_error (_tmp461_, _tmp468_);
									_g_free0 (_tmp468_);
									_g_free0 (_tmp466_);
									_g_free0 (_tmp463_);
								}
								_vala_code_node_unref0 (base_class);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp469_;
						ValaList* _tmp470_;
						gint _prop_size = 0;
						ValaList* _tmp471_;
						gint _tmp472_;
						gint _tmp473_;
						gint _prop_index = 0;
						_tmp469_ = iface;
						_tmp470_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp469_);
						_prop_list = _tmp470_;
						_tmp471_ = _prop_list;
						_tmp472_ = vala_collection_get_size ((ValaCollection*) _tmp471_);
						_tmp473_ = _tmp472_;
						_prop_size = _tmp473_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp474_;
							gint _tmp475_;
							gint _tmp476_;
							ValaProperty* prop = NULL;
							ValaList* _tmp477_;
							gint _tmp478_;
							gpointer _tmp479_;
							ValaProperty* _tmp480_;
							gboolean _tmp481_;
							gboolean _tmp482_;
							_tmp474_ = _prop_index;
							_prop_index = _tmp474_ + 1;
							_tmp475_ = _prop_index;
							_tmp476_ = _prop_size;
							if (!(_tmp475_ < _tmp476_)) {
								break;
							}
							_tmp477_ = _prop_list;
							_tmp478_ = _prop_index;
							_tmp479_ = vala_list_get (_tmp477_, _tmp478_);
							prop = (ValaProperty*) _tmp479_;
							_tmp480_ = prop;
							_tmp481_ = vala_property_get_is_abstract (_tmp480_);
							_tmp482_ = _tmp481_;
							if (_tmp482_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaClass* _tmp483_;
								ValaSymbol* _tmp497_;
								sym = NULL;
								_tmp483_ = _vala_code_node_ref0 (self);
								base_class = _tmp483_;
								while (TRUE) {
									gboolean _tmp484_ = FALSE;
									ValaClass* _tmp485_;
									ValaClass* _tmp487_;
									ValaScope* _tmp488_;
									ValaScope* _tmp489_;
									ValaProperty* _tmp490_;
									const gchar* _tmp491_;
									const gchar* _tmp492_;
									ValaSymbol* _tmp493_;
									ValaClass* _tmp494_;
									ValaClass* _tmp495_;
									ValaClass* _tmp496_;
									_tmp485_ = base_class;
									if (_tmp485_ != NULL) {
										ValaSymbol* _tmp486_;
										_tmp486_ = sym;
										_tmp484_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp486_, VALA_TYPE_PROPERTY);
									} else {
										_tmp484_ = FALSE;
									}
									if (!_tmp484_) {
										break;
									}
									_tmp487_ = base_class;
									_tmp488_ = vala_symbol_get_scope ((ValaSymbol*) _tmp487_);
									_tmp489_ = _tmp488_;
									_tmp490_ = prop;
									_tmp491_ = vala_symbol_get_name ((ValaSymbol*) _tmp490_);
									_tmp492_ = _tmp491_;
									_tmp493_ = vala_scope_lookup (_tmp489_, _tmp492_);
									_vala_code_node_unref0 (sym);
									sym = _tmp493_;
									_tmp494_ = base_class;
									_tmp495_ = _tmp494_->priv->_base_class;
									_tmp496_ = _vala_code_node_ref0 (_tmp495_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp496_;
								}
								_tmp497_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp497_, VALA_TYPE_PROPERTY)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp498_;
									ValaProperty* _tmp499_;
									gchar* invalid_match = NULL;
									gboolean _tmp500_ = FALSE;
									ValaProperty* _tmp501_;
									gboolean _tmp502_;
									gboolean _tmp503_;
									ValaSymbol* _tmp519_;
									ValaVersionAttribute* _tmp520_;
									ValaVersionAttribute* _tmp521_;
									ValaSourceReference* _tmp522_;
									ValaSourceReference* _tmp523_;
									ValaSymbol* _tmp524_;
									_tmp498_ = sym;
									_tmp499_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp498_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp499_;
									invalid_match = NULL;
									_tmp501_ = base_prop;
									_tmp502_ = vala_symbol_get_hides ((ValaSymbol*) _tmp501_);
									_tmp503_ = _tmp502_;
									if (!_tmp503_) {
										ValaProperty* _tmp504_;
										ValaProperty* _tmp505_;
										gchar* _tmp506_ = NULL;
										gboolean _tmp507_;
										_tmp504_ = base_prop;
										_tmp505_ = prop;
										_tmp507_ = vala_property_compatible (_tmp504_, _tmp505_, &_tmp506_);
										_g_free0 (invalid_match);
										invalid_match = _tmp506_;
										_tmp500_ = !_tmp507_;
									} else {
										_tmp500_ = FALSE;
									}
									if (_tmp500_) {
										ValaSourceReference* _tmp508_;
										ValaSourceReference* _tmp509_;
										ValaProperty* _tmp510_;
										gchar* _tmp511_;
										gchar* _tmp512_;
										ValaProperty* _tmp513_;
										gchar* _tmp514_;
										gchar* _tmp515_;
										const gchar* _tmp516_;
										gchar* _tmp517_;
										gchar* _tmp518_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp508_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp509_ = _tmp508_;
										_tmp510_ = prop;
										_tmp511_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp510_);
										_tmp512_ = _tmp511_;
										_tmp513_ = base_prop;
										_tmp514_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp513_);
										_tmp515_ = _tmp514_;
										_tmp516_ = invalid_match;
										_tmp517_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp512_, _tmp515_, _tmp516_);
										_tmp518_ = _tmp517_;
										vala_report_error (_tmp509_, _tmp518_);
										_g_free0 (_tmp518_);
										_g_free0 (_tmp515_);
										_g_free0 (_tmp512_);
									}
									_tmp519_ = sym;
									_tmp520_ = vala_symbol_get_version (_tmp519_);
									_tmp521_ = _tmp520_;
									_tmp522_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp523_ = _tmp522_;
									vala_version_attribute_check (_tmp521_, _tmp523_);
									_tmp524_ = sym;
									vala_symbol_set_used (_tmp524_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp525_;
									ValaSourceReference* _tmp526_;
									gchar* _tmp527_;
									gchar* _tmp528_;
									ValaProperty* _tmp529_;
									gchar* _tmp530_;
									gchar* _tmp531_;
									gchar* _tmp532_;
									gchar* _tmp533_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp525_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp526_ = _tmp525_;
									_tmp527_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp528_ = _tmp527_;
									_tmp529_ = prop;
									_tmp530_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp529_);
									_tmp531_ = _tmp530_;
									_tmp532_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp528_, _tmp531_);
									_tmp533_ = _tmp532_;
									vala_report_error (_tmp526_, _tmp533_);
									_g_free0 (_tmp533_);
									_g_free0 (_tmp531_);
									_g_free0 (_tmp528_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp534_ = self->priv->_is_abstract;
		if (!_tmp534_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp535_;
			ValaClass* _tmp536_;
			_tmp535_ = self->priv->_base_class;
			_tmp536_ = _vala_code_node_ref0 (_tmp535_);
			base_class = _tmp536_;
			while (TRUE) {
				gboolean _tmp537_ = FALSE;
				ValaClass* _tmp538_;
				ValaClass* _tmp607_;
				ValaClass* _tmp608_;
				ValaClass* _tmp609_;
				_tmp538_ = base_class;
				if (_tmp538_ != NULL) {
					ValaClass* _tmp539_;
					gboolean _tmp540_;
					_tmp539_ = base_class;
					_tmp540_ = _tmp539_->priv->_is_abstract;
					_tmp537_ = _tmp540_;
				} else {
					_tmp537_ = FALSE;
				}
				if (!_tmp537_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp541_;
					ValaList* _tmp542_;
					gint _base_method_size = 0;
					ValaList* _tmp543_;
					gint _tmp544_;
					gint _tmp545_;
					gint _base_method_index = 0;
					_tmp541_ = base_class;
					_tmp542_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp541_);
					_base_method_list = _tmp542_;
					_tmp543_ = _base_method_list;
					_tmp544_ = vala_collection_get_size ((ValaCollection*) _tmp543_);
					_tmp545_ = _tmp544_;
					_base_method_size = _tmp545_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp546_;
						gint _tmp547_;
						gint _tmp548_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp549_;
						gint _tmp550_;
						gpointer _tmp551_;
						ValaMethod* _tmp552_;
						gboolean _tmp553_;
						gboolean _tmp554_;
						_tmp546_ = _base_method_index;
						_base_method_index = _tmp546_ + 1;
						_tmp547_ = _base_method_index;
						_tmp548_ = _base_method_size;
						if (!(_tmp547_ < _tmp548_)) {
							break;
						}
						_tmp549_ = _base_method_list;
						_tmp550_ = _base_method_index;
						_tmp551_ = vala_list_get (_tmp549_, _tmp550_);
						base_method = (ValaMethod*) _tmp551_;
						_tmp552_ = base_method;
						_tmp553_ = vala_method_get_is_abstract (_tmp552_);
						_tmp554_ = _tmp553_;
						if (_tmp554_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp555_;
							const gchar* _tmp556_;
							const gchar* _tmp557_;
							ValaSymbol* _tmp558_;
							ValaMethod* _tmp559_;
							gboolean _tmp560_ = FALSE;
							ValaMethod* _tmp561_;
							_tmp555_ = base_method;
							_tmp556_ = vala_symbol_get_name ((ValaSymbol*) _tmp555_);
							_tmp557_ = _tmp556_;
							_tmp558_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp557_);
							_tmp559_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp558_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp558_) : NULL;
							if (_tmp559_ == NULL) {
								_vala_code_node_unref0 (_tmp558_);
							}
							override_method = _tmp559_;
							_tmp561_ = override_method;
							if (_tmp561_ == NULL) {
								_tmp560_ = TRUE;
							} else {
								ValaMethod* _tmp562_;
								gboolean _tmp563_;
								gboolean _tmp564_;
								_tmp562_ = override_method;
								_tmp563_ = vala_method_get_overrides (_tmp562_);
								_tmp564_ = _tmp563_;
								_tmp560_ = !_tmp564_;
							}
							if (_tmp560_) {
								ValaSourceReference* _tmp565_;
								ValaSourceReference* _tmp566_;
								gchar* _tmp567_;
								gchar* _tmp568_;
								ValaMethod* _tmp569_;
								gchar* _tmp570_;
								gchar* _tmp571_;
								gchar* _tmp572_;
								gchar* _tmp573_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp565_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp566_ = _tmp565_;
								_tmp567_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp568_ = _tmp567_;
								_tmp569_ = base_method;
								_tmp570_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp569_);
								_tmp571_ = _tmp570_;
								_tmp572_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp568_, _tmp571_);
								_tmp573_ = _tmp572_;
								vala_report_error (_tmp566_, _tmp573_);
								_g_free0 (_tmp573_);
								_g_free0 (_tmp571_);
								_g_free0 (_tmp568_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp574_;
					ValaList* _tmp575_;
					gint _base_property_size = 0;
					ValaList* _tmp576_;
					gint _tmp577_;
					gint _tmp578_;
					gint _base_property_index = 0;
					_tmp574_ = base_class;
					_tmp575_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp574_);
					_base_property_list = _tmp575_;
					_tmp576_ = _base_property_list;
					_tmp577_ = vala_collection_get_size ((ValaCollection*) _tmp576_);
					_tmp578_ = _tmp577_;
					_base_property_size = _tmp578_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp579_;
						gint _tmp580_;
						gint _tmp581_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp582_;
						gint _tmp583_;
						gpointer _tmp584_;
						ValaProperty* _tmp585_;
						gboolean _tmp586_;
						gboolean _tmp587_;
						_tmp579_ = _base_property_index;
						_base_property_index = _tmp579_ + 1;
						_tmp580_ = _base_property_index;
						_tmp581_ = _base_property_size;
						if (!(_tmp580_ < _tmp581_)) {
							break;
						}
						_tmp582_ = _base_property_list;
						_tmp583_ = _base_property_index;
						_tmp584_ = vala_list_get (_tmp582_, _tmp583_);
						base_property = (ValaProperty*) _tmp584_;
						_tmp585_ = base_property;
						_tmp586_ = vala_property_get_is_abstract (_tmp585_);
						_tmp587_ = _tmp586_;
						if (_tmp587_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp588_;
							const gchar* _tmp589_;
							const gchar* _tmp590_;
							ValaSymbol* _tmp591_;
							ValaProperty* _tmp592_;
							gboolean _tmp593_ = FALSE;
							ValaProperty* _tmp594_;
							_tmp588_ = base_property;
							_tmp589_ = vala_symbol_get_name ((ValaSymbol*) _tmp588_);
							_tmp590_ = _tmp589_;
							_tmp591_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp590_);
							_tmp592_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp591_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp591_) : NULL;
							if (_tmp592_ == NULL) {
								_vala_code_node_unref0 (_tmp591_);
							}
							override_property = _tmp592_;
							_tmp594_ = override_property;
							if (_tmp594_ == NULL) {
								_tmp593_ = TRUE;
							} else {
								ValaProperty* _tmp595_;
								gboolean _tmp596_;
								gboolean _tmp597_;
								_tmp595_ = override_property;
								_tmp596_ = vala_property_get_overrides (_tmp595_);
								_tmp597_ = _tmp596_;
								_tmp593_ = !_tmp597_;
							}
							if (_tmp593_) {
								ValaSourceReference* _tmp598_;
								ValaSourceReference* _tmp599_;
								gchar* _tmp600_;
								gchar* _tmp601_;
								ValaProperty* _tmp602_;
								gchar* _tmp603_;
								gchar* _tmp604_;
								gchar* _tmp605_;
								gchar* _tmp606_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp598_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp599_ = _tmp598_;
								_tmp600_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp601_ = _tmp600_;
								_tmp602_ = base_property;
								_tmp603_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp602_);
								_tmp604_ = _tmp603_;
								_tmp605_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp601_, _tmp604_);
								_tmp606_ = _tmp605_;
								vala_report_error (_tmp599_, _tmp606_);
								_g_free0 (_tmp606_);
								_g_free0 (_tmp604_);
								_g_free0 (_tmp601_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp607_ = base_class;
				_tmp608_ = _tmp607_->priv->_base_class;
				_tmp609_ = _vala_code_node_ref0 (_tmp608_);
				_vala_code_node_unref0 (base_class);
				base_class = _tmp609_;
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	_tmp610_ = context;
	_tmp611_ = vala_code_context_get_analyzer (_tmp610_);
	_tmp612_ = _tmp611_;
	_tmp613_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp612_, _tmp613_);
	_tmp614_ = context;
	_tmp615_ = vala_code_context_get_analyzer (_tmp614_);
	_tmp616_ = _tmp615_;
	_tmp617_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp616_, _tmp617_);
	_tmp618_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp619_ = _tmp618_;
	result = !_tmp619_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaClass* vala_class_get_base_class (ValaClass* self) {
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}


void vala_class_set_base_class (ValaClass* self, ValaClass* value) {
	ValaClass* _tmp0_;
	ValaClass* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp1_;
}


gboolean vala_class_get_is_abstract (ValaClass* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void vala_class_set_is_abstract (ValaClass* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_abstract = _tmp0_;
}


static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


gboolean vala_class_get_is_compact (ValaClass* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	gboolean* _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_compact (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			ValaAttribute* _tmp7_;
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_ != NULL;
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
		}
	}
	_tmp10_ = self->priv->_is_compact;
	if (_tmp10_ == NULL) {
		ValaAttribute* _tmp11_;
		ValaAttribute* _tmp12_;
		gboolean _tmp13_;
		gboolean* _tmp14_;
		_tmp11_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_ != NULL;
		_tmp14_ = __bool_dup0 (&_tmp13_);
		_g_free0 (self->priv->_is_compact);
		self->priv->_is_compact = _tmp14_;
		_vala_code_node_unref0 (_tmp12_);
	}
	_tmp15_ = self->priv->_is_compact;
	result = *_tmp15_;
	return result;
}


void vala_class_set_is_compact (ValaClass* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp1_;
	_tmp2_ = value;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", _tmp2_, NULL);
}


gboolean vala_class_get_is_immutable (ValaClass* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	gboolean* _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_immutable (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			ValaAttribute* _tmp7_;
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_ != NULL;
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
		}
	}
	_tmp10_ = self->priv->_is_immutable;
	if (_tmp10_ == NULL) {
		ValaAttribute* _tmp11_;
		ValaAttribute* _tmp12_;
		gboolean _tmp13_;
		gboolean* _tmp14_;
		_tmp11_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_ != NULL;
		_tmp14_ = __bool_dup0 (&_tmp13_);
		_g_free0 (self->priv->_is_immutable);
		self->priv->_is_immutable = _tmp14_;
		_vala_code_node_unref0 (_tmp12_);
	}
	_tmp15_ = self->priv->_is_immutable;
	result = *_tmp15_;
	return result;
}


void vala_class_set_is_immutable (ValaClass* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp1_;
	_tmp2_ = value;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", _tmp2_, NULL);
}


gboolean vala_class_get_has_private_fields (ValaClass* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_private_fields;
	result = _tmp0_;
	return result;
}


void vala_class_set_has_private_fields (ValaClass* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_has_private_fields = _tmp0_;
}


gboolean vala_class_get_has_class_private_fields (ValaClass* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_class_private_fields;
	result = _tmp0_;
	return result;
}


static void vala_class_set_has_class_private_fields (ValaClass* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_has_class_private_fields = _tmp0_;
}


ValaCreationMethod* vala_class_get_default_construction_method (ValaClass* self) {
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}


void vala_class_set_default_construction_method (ValaClass* self, ValaCreationMethod* value) {
	ValaCreationMethod* _tmp0_;
	ValaCreationMethod* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp1_;
}


ValaConstructor* vala_class_get_constructor (ValaClass* self) {
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp1_;
}


ValaConstructor* vala_class_get_class_constructor (ValaClass* self) {
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_class_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp1_;
}


ValaConstructor* vala_class_get_static_constructor (ValaClass* self) {
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_static_constructor (ValaClass* self, ValaConstructor* value) {
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp1_;
}


ValaDestructor* vala_class_get_destructor (ValaClass* self) {
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	ValaDestructor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp1_;
	_tmp2_ = self->priv->_destructor;
	if (_tmp2_ != NULL) {
		ValaDestructor* _tmp3_;
		ValaParameter* _tmp4_;
		ValaParameter* _tmp5_;
		ValaDestructor* _tmp14_;
		ValaObjectType* _tmp15_;
		ValaObjectType* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		ValaDestructor* _tmp19_;
		ValaScope* _tmp20_;
		ValaScope* _tmp21_;
		ValaDestructor* _tmp22_;
		ValaParameter* _tmp23_;
		ValaParameter* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		ValaDestructor* _tmp27_;
		ValaParameter* _tmp28_;
		ValaParameter* _tmp29_;
		_tmp3_ = self->priv->_destructor;
		_tmp4_ = vala_destructor_get_this_parameter (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			ValaDestructor* _tmp6_;
			ValaScope* _tmp7_;
			ValaScope* _tmp8_;
			ValaDestructor* _tmp9_;
			ValaParameter* _tmp10_;
			ValaParameter* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp6_ = self->priv->_destructor;
			_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->priv->_destructor;
			_tmp10_ = vala_destructor_get_this_parameter (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			vala_scope_remove (_tmp8_, _tmp13_);
		}
		_tmp14_ = self->priv->_destructor;
		_tmp15_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_parameter_new ("this", (ValaDataType*) _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		vala_destructor_set_this_parameter (_tmp14_, _tmp18_);
		_vala_code_node_unref0 (_tmp18_);
		_vala_code_node_unref0 (_tmp16_);
		_tmp19_ = self->priv->_destructor;
		_tmp20_ = vala_symbol_get_scope ((ValaSymbol*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = self->priv->_destructor;
		_tmp23_ = vala_destructor_get_this_parameter (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->_destructor;
		_tmp28_ = vala_destructor_get_this_parameter (_tmp27_);
		_tmp29_ = _tmp28_;
		vala_scope_add (_tmp21_, _tmp26_, (ValaSymbol*) _tmp29_);
	}
}


ValaDestructor* vala_class_get_static_destructor (ValaClass* self) {
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_static_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp1_;
}


ValaDestructor* vala_class_get_class_destructor (ValaClass* self) {
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}


void vala_class_set_class_destructor (ValaClass* self, ValaDestructor* value) {
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp1_;
}


gboolean vala_class_get_is_error_base (ValaClass* self) {
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


static void vala_class_class_init (ValaClassClass * klass) {
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassPrivate));
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol *, ValaConstant*)) vala_class_real_add_constant;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol *, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol *, ValaMethod*)) vala_class_real_add_method;
	((ValaObjectTypeSymbolClass *) klass)->get_methods = (ValaList* (*) (ValaObjectTypeSymbol *)) vala_class_real_get_methods;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol *, ValaProperty*)) vala_class_real_add_property;
	((ValaObjectTypeSymbolClass *) klass)->get_properties = (ValaList* (*) (ValaObjectTypeSymbol *)) vala_class_real_get_properties;
	((ValaSymbolClass *) klass)->add_signal = (void (*) (ValaSymbol *, ValaSignal*)) vala_class_real_add_signal;
	((ValaObjectTypeSymbolClass *) klass)->get_signals = (ValaList* (*) (ValaObjectTypeSymbol *)) vala_class_real_get_signals;
	((ValaSymbolClass *) klass)->add_class = (void (*) (ValaSymbol *, ValaClass*)) vala_class_real_add_class;
	((ValaSymbolClass *) klass)->add_struct = (void (*) (ValaSymbol *, ValaStruct*)) vala_class_real_add_struct;
	((ValaSymbolClass *) klass)->add_enum = (void (*) (ValaSymbol *, ValaEnum*)) vala_class_real_add_enum;
	((ValaSymbolClass *) klass)->add_delegate = (void (*) (ValaSymbol *, ValaDelegate*)) vala_class_real_add_delegate;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol *, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol *, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol *)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol *, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_class_real_check;
}


static void vala_class_instance_init (ValaClass * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	GEqualFunc _tmp10_;
	ValaArrayList* _tmp11_;
	GEqualFunc _tmp12_;
	ValaArrayList* _tmp13_;
	GEqualFunc _tmp14_;
	ValaArrayList* _tmp15_;
	GEqualFunc _tmp16_;
	ValaArrayList* _tmp17_;
	GEqualFunc _tmp18_;
	ValaArrayList* _tmp19_;
	self->priv = VALA_CLASS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->constants = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->fields = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	self->priv->methods = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->properties = (ValaList*) _tmp9_;
	_tmp10_ = g_direct_equal;
	_tmp11_ = vala_array_list_new (VALA_TYPE_SIGNAL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp10_);
	self->priv->signals = (ValaList*) _tmp11_;
	_tmp12_ = g_direct_equal;
	_tmp13_ = vala_array_list_new (VALA_TYPE_CLASS, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp12_);
	self->priv->classes = (ValaList*) _tmp13_;
	_tmp14_ = g_direct_equal;
	_tmp15_ = vala_array_list_new (VALA_TYPE_STRUCT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp14_);
	self->priv->structs = (ValaList*) _tmp15_;
	_tmp16_ = g_direct_equal;
	_tmp17_ = vala_array_list_new (VALA_TYPE_ENUM, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp16_);
	self->priv->enums = (ValaList*) _tmp17_;
	_tmp18_ = g_direct_equal;
	_tmp19_ = vala_array_list_new (VALA_TYPE_DELEGATE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp18_);
	self->priv->delegates = (ValaList*) _tmp19_;
}


static void vala_class_finalize (ValaCodeNode * obj) {
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_iterable_unref0 (self->priv->signals);
	_vala_iterable_unref0 (self->priv->classes);
	_vala_iterable_unref0 (self->priv->structs);
	_vala_iterable_unref0 (self->priv->enums);
	_vala_iterable_unref0 (self->priv->delegates);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType vala_class_get_type (void) {
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}



