/* valafield.c generated by valac, the Vala compiler
 * generated from valafield.vala, do not modify */

/* valafield.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaFieldPrivate {
	ValaMemberBinding _binding;
	gboolean _is_volatile;
	gboolean lock_used;
};


static gpointer vala_field_parent_class = NULL;
static ValaLockableIface * vala_field_vala_lockable_parent_iface = NULL;

#define VALA_FIELD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FIELD, ValaFieldPrivate))
static void vala_field_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_field_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_field_real_get_lock_used (ValaLockable* base);
static void vala_field_real_set_lock_used (ValaLockable* base, gboolean used);
static void vala_field_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static void vala_field_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_field_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_field_finalize (ValaCodeNode * obj);


/**
 * Creates a new field.
 *
 * @param name              field name
 * @param variable_type     field type
 * @param initializer       initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created field
 */
ValaField* vala_field_construct (GType object_type, const gchar* name, ValaDataType* variable_type, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaField* self = NULL;
	ValaDataType* _tmp0_;
	const gchar* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaComment* _tmp4_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (variable_type != NULL, NULL);
	_tmp0_ = variable_type;
	_tmp1_ = name;
	_tmp2_ = initializer;
	_tmp3_ = source_reference;
	_tmp4_ = comment;
	self = (ValaField*) vala_variable_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_);
	return self;
}


ValaField* vala_field_new (const gchar* name, ValaDataType* variable_type, ValaExpression* initializer, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_field_construct (VALA_TYPE_FIELD, name, variable_type, initializer, source_reference, comment);
}


static void vala_field_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaField * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_field (_tmp0_, self);
}


static void vala_field_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	self = (ValaField*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaCodeVisitor* _tmp7_;
		_tmp5_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, _tmp7_);
	}
}


static gboolean vala_field_real_get_lock_used (ValaLockable* base) {
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaField*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void vala_field_real_set_lock_used (ValaLockable* base, gboolean used) {
	ValaField * self;
	gboolean _tmp0_;
	self = (ValaField*) base;
	_tmp0_ = used;
	self->priv->lock_used = _tmp0_;
}


static void vala_field_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaField * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaField*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_variable_set_initializer ((ValaVariable*) self, _tmp3_);
	}
}


static void vala_field_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaField * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaField*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp3_);
	}
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean vala_field_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaField * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaCodeContext* _tmp25_;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaDataType* _tmp32_;
	ValaDataType* _tmp33_;
	ValaCodeContext* _tmp34_;
	ValaCodeContext* _tmp35_;
	ValaSemanticAnalyzer* _tmp36_;
	ValaSemanticAnalyzer* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean _tmp40_;
	ValaExpression* _tmp51_;
	ValaExpression* _tmp52_;
	gboolean _tmp149_ = FALSE;
	ValaMemberBinding _tmp150_;
	gboolean field_in_header = FALSE;
	gboolean _tmp155_;
	ValaSymbol* _tmp156_;
	ValaSymbol* _tmp157_;
	gboolean _tmp167_ = FALSE;
	gboolean _tmp168_ = FALSE;
	gboolean _tmp169_;
	gboolean _tmp170_;
	ValaCodeContext* _tmp185_;
	ValaSemanticAnalyzer* _tmp186_;
	ValaSemanticAnalyzer* _tmp187_;
	ValaSourceFile* _tmp188_;
	ValaCodeContext* _tmp189_;
	ValaSemanticAnalyzer* _tmp190_;
	ValaSemanticAnalyzer* _tmp191_;
	ValaSymbol* _tmp192_;
	gboolean _tmp193_;
	gboolean _tmp194_;
	self = (ValaField*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_;
		ValaSemanticAnalyzer* _tmp19_;
		ValaSemanticAnalyzer* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceFile* _tmp23_;
		ValaSourceFile* _tmp24_;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, (ValaSymbol*) self);
	_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp29_ = _tmp28_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp29_, VALA_TYPE_VOID_TYPE)) {
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp31_ = _tmp30_;
		vala_report_error (_tmp31_, "'void' not supported as field type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp32_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp33_, _tmp34_);
	_tmp35_ = context;
	_tmp36_ = vala_code_context_get_analyzer (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_semantic_analyzer_is_type_accessible (_tmp37_, (ValaSymbol*) self, _tmp39_);
	if (!_tmp40_) {
		ValaSourceReference* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaDataType* _tmp43_;
		ValaDataType* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_code_node_to_string ((ValaCodeNode*) _tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strdup_printf ("field type `%s` is less accessible than field `%s`", _tmp46_, _tmp48_);
		_tmp50_ = _tmp49_;
		vala_report_error (_tmp42_, _tmp50_);
		_g_free0 (_tmp50_);
		_g_free0 (_tmp48_);
		_g_free0 (_tmp46_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp51_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp52_ = _tmp51_;
	if (_tmp52_ != NULL) {
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaDataType* _tmp55_;
		ValaDataType* _tmp56_;
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaCodeContext* _tmp59_;
		gboolean _tmp60_;
		ValaExpression* _tmp61_;
		ValaExpression* _tmp62_;
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		ValaExpression* _tmp67_;
		ValaExpression* _tmp68_;
		ValaDataType* _tmp69_;
		ValaDataType* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		gboolean _tmp73_;
		ValaExpression* _tmp88_;
		ValaExpression* _tmp89_;
		ValaDataType* _tmp90_;
		ValaDataType* _tmp91_;
		gboolean _tmp92_;
		gboolean _tmp102_ = FALSE;
		ValaSymbol* _tmp103_;
		ValaSymbol* _tmp104_;
		gboolean _tmp110_ = FALSE;
		gboolean _tmp111_ = FALSE;
		ValaSymbol* _tmp112_;
		ValaSymbol* _tmp113_;
		gboolean _tmp130_ = FALSE;
		gboolean _tmp131_ = FALSE;
		gboolean _tmp132_ = FALSE;
		ValaMemberBinding _tmp133_;
		gboolean _tmp145_;
		gboolean _tmp146_;
		_tmp53_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp56_ = _tmp55_;
		vala_expression_set_target_type (_tmp54_, _tmp56_);
		_tmp57_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp58_ = _tmp57_;
		_tmp59_ = context;
		_tmp60_ = vala_code_node_check ((ValaCodeNode*) _tmp58_, _tmp59_);
		if (!_tmp60_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp61_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_expression_get_value_type (_tmp62_);
		_tmp64_ = _tmp63_;
		if (_tmp64_ == NULL) {
			ValaSourceReference* _tmp65_;
			ValaSourceReference* _tmp66_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp66_ = _tmp65_;
			vala_report_error (_tmp66_, "expression type not allowed as initializer");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp67_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp68_ = _tmp67_;
		_tmp69_ = vala_expression_get_value_type (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_data_type_compatible (_tmp70_, _tmp72_);
		if (!_tmp73_) {
			ValaSourceReference* _tmp74_;
			ValaSourceReference* _tmp75_;
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			ValaDataType* _tmp78_;
			ValaDataType* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			ValaDataType* _tmp82_;
			ValaDataType* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp75_ = _tmp74_;
			_tmp76_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp77_ = _tmp76_;
			_tmp78_ = vala_expression_get_value_type (_tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = vala_code_node_to_string ((ValaCodeNode*) _tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp83_ = _tmp82_;
			_tmp84_ = vala_code_node_to_string ((ValaCodeNode*) _tmp83_);
			_tmp85_ = _tmp84_;
			_tmp86_ = g_strdup_printf ("Cannot convert from `%s' to `%s'", _tmp81_, _tmp85_);
			_tmp87_ = _tmp86_;
			vala_report_error (_tmp75_, _tmp87_);
			_g_free0 (_tmp87_);
			_g_free0 (_tmp85_);
			_g_free0 (_tmp81_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp88_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp89_ = _tmp88_;
		_tmp90_ = vala_expression_get_value_type (_tmp89_);
		_tmp91_ = _tmp90_;
		_tmp92_ = vala_data_type_is_disposable (_tmp91_);
		if (_tmp92_) {
			gboolean _tmp93_ = FALSE;
			ValaDataType* _tmp94_;
			ValaDataType* _tmp95_;
			_tmp94_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp95_ = _tmp94_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp95_, VALA_TYPE_POINTER_TYPE)) {
				ValaDataType* _tmp96_;
				ValaDataType* _tmp97_;
				gboolean _tmp98_;
				gboolean _tmp99_;
				_tmp96_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_data_type_get_value_owned (_tmp97_);
				_tmp99_ = _tmp98_;
				_tmp93_ = !_tmp99_;
			} else {
				_tmp93_ = FALSE;
			}
			if (_tmp93_) {
				ValaSourceReference* _tmp100_;
				ValaSourceReference* _tmp101_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp100_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp101_ = _tmp100_;
				vala_report_error (_tmp101_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp103_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp104_ = _tmp103_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp104_, VALA_TYPE_NAMESPACE)) {
			ValaExpression* _tmp105_;
			ValaExpression* _tmp106_;
			gboolean _tmp107_;
			_tmp105_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp106_ = _tmp105_;
			_tmp107_ = vala_expression_is_constant (_tmp106_);
			_tmp102_ = !_tmp107_;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaSourceReference* _tmp108_;
			ValaSourceReference* _tmp109_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp109_ = _tmp108_;
			vala_report_error (_tmp109_, "Non-constant field initializers not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp112_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp113_ = _tmp112_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp113_, VALA_TYPE_NAMESPACE)) {
			ValaExpression* _tmp114_;
			ValaExpression* _tmp115_;
			gboolean _tmp116_;
			_tmp114_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp115_ = _tmp114_;
			_tmp116_ = vala_expression_is_constant (_tmp115_);
			_tmp111_ = _tmp116_;
		} else {
			_tmp111_ = FALSE;
		}
		if (_tmp111_) {
			ValaExpression* _tmp117_;
			ValaExpression* _tmp118_;
			gboolean _tmp119_;
			_tmp117_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp118_ = _tmp117_;
			_tmp119_ = vala_expression_is_non_null (_tmp118_);
			_tmp110_ = _tmp119_;
		} else {
			_tmp110_ = FALSE;
		}
		if (_tmp110_) {
			gboolean _tmp120_ = FALSE;
			ValaDataType* _tmp121_;
			ValaDataType* _tmp122_;
			gboolean _tmp123_;
			_tmp121_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp122_ = _tmp121_;
			_tmp123_ = vala_data_type_is_disposable (_tmp122_);
			if (_tmp123_) {
				ValaDataType* _tmp124_;
				ValaDataType* _tmp125_;
				gboolean _tmp126_;
				gboolean _tmp127_;
				_tmp124_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp125_ = _tmp124_;
				_tmp126_ = vala_data_type_get_value_owned (_tmp125_);
				_tmp127_ = _tmp126_;
				_tmp120_ = _tmp127_;
			} else {
				_tmp120_ = FALSE;
			}
			if (_tmp120_) {
				ValaSourceReference* _tmp128_;
				ValaSourceReference* _tmp129_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp129_ = _tmp128_;
				vala_report_error (_tmp129_, "Owned namespace fields can only be initialized in a function or method");
				result = FALSE;
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
		_tmp133_ = self->priv->_binding;
		if (_tmp133_ == VALA_MEMBER_BINDING_STATIC) {
			ValaSymbol* _tmp134_;
			ValaSymbol* _tmp135_;
			_tmp134_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp135_ = _tmp134_;
			_tmp132_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp135_, VALA_TYPE_CLASS);
		} else {
			_tmp132_ = FALSE;
		}
		if (_tmp132_) {
			ValaSymbol* _tmp136_;
			ValaSymbol* _tmp137_;
			gboolean _tmp138_;
			gboolean _tmp139_;
			_tmp136_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp137_ = _tmp136_;
			_tmp138_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp137_, VALA_TYPE_CLASS, ValaClass));
			_tmp139_ = _tmp138_;
			_tmp131_ = _tmp139_;
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			ValaExpression* _tmp140_;
			ValaExpression* _tmp141_;
			gboolean _tmp142_;
			_tmp140_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_expression_is_constant (_tmp141_);
			_tmp130_ = !_tmp142_;
		} else {
			_tmp130_ = FALSE;
		}
		if (_tmp130_) {
			ValaSourceReference* _tmp143_;
			ValaSourceReference* _tmp144_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp144_ = _tmp143_;
			vala_report_error (_tmp144_, "Static fields in compact classes cannot have non-constant initializers");
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		_tmp145_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp146_ = _tmp145_;
		if (_tmp146_) {
			ValaSourceReference* _tmp147_;
			ValaSourceReference* _tmp148_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp148_ = _tmp147_;
			vala_report_error (_tmp148_, "External fields cannot use initializers");
		}
	}
	_tmp150_ = self->priv->_binding;
	if (_tmp150_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaSymbol* _tmp151_;
		ValaSymbol* _tmp152_;
		_tmp151_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp152_ = _tmp151_;
		_tmp149_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp152_, VALA_TYPE_INTERFACE);
	} else {
		_tmp149_ = FALSE;
	}
	if (_tmp149_) {
		ValaSourceReference* _tmp153_;
		ValaSourceReference* _tmp154_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp154_ = _tmp153_;
		vala_report_error (_tmp154_, "Interfaces may not have instance fields");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp155_ = vala_symbol_is_internal_symbol ((ValaSymbol*) self);
	field_in_header = !_tmp155_;
	_tmp156_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp157_ = _tmp156_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp157_, VALA_TYPE_CLASS)) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp158_;
		ValaSymbol* _tmp159_;
		ValaClass* _tmp160_;
		gboolean _tmp161_ = FALSE;
		ValaClass* _tmp162_;
		gboolean _tmp163_;
		gboolean _tmp164_;
		_tmp158_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp159_ = _tmp158_;
		_tmp160_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp159_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp160_;
		_tmp162_ = cl;
		_tmp163_ = vala_class_get_is_compact (_tmp162_);
		_tmp164_ = _tmp163_;
		if (_tmp164_) {
			ValaClass* _tmp165_;
			gboolean _tmp166_;
			_tmp165_ = cl;
			_tmp166_ = vala_symbol_is_internal_symbol ((ValaSymbol*) _tmp165_);
			_tmp161_ = !_tmp166_;
		} else {
			_tmp161_ = FALSE;
		}
		if (_tmp161_) {
			field_in_header = TRUE;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp169_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp170_ = _tmp169_;
	if (!_tmp170_) {
		gboolean _tmp171_;
		gboolean _tmp172_;
		_tmp171_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp172_ = _tmp171_;
		_tmp168_ = !_tmp172_;
	} else {
		_tmp168_ = FALSE;
	}
	if (_tmp168_) {
		ValaSymbol* _tmp173_;
		ValaSymbol* _tmp174_;
		_tmp173_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp174_ = _tmp173_;
		_tmp167_ = _tmp174_ != NULL;
		_vala_code_node_unref0 (_tmp174_);
	} else {
		_tmp167_ = FALSE;
	}
	if (_tmp167_) {
		ValaSourceReference* _tmp175_;
		ValaSourceReference* _tmp176_;
		gchar* _tmp177_;
		gchar* _tmp178_;
		ValaSymbol* _tmp179_;
		ValaSymbol* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		gchar* _tmp184_;
		_tmp175_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp176_ = _tmp175_;
		_tmp177_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp178_ = _tmp177_;
		_tmp179_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp180_ = _tmp179_;
		_tmp181_ = vala_symbol_get_full_name (_tmp180_);
		_tmp182_ = _tmp181_;
		_tmp183_ = g_strdup_printf ("%s hides inherited field `%s'. Use the `new' keyword if hiding was int" \
"entional", _tmp178_, _tmp182_);
		_tmp184_ = _tmp183_;
		vala_report_warning (_tmp176_, _tmp184_);
		_g_free0 (_tmp184_);
		_g_free0 (_tmp182_);
		_vala_code_node_unref0 (_tmp180_);
		_g_free0 (_tmp178_);
	}
	_tmp185_ = context;
	_tmp186_ = vala_code_context_get_analyzer (_tmp185_);
	_tmp187_ = _tmp186_;
	_tmp188_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp187_, _tmp188_);
	_tmp189_ = context;
	_tmp190_ = vala_code_context_get_analyzer (_tmp189_);
	_tmp191_ = _tmp190_;
	_tmp192_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp191_, _tmp192_);
	_tmp193_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp194_ = _tmp193_;
	result = !_tmp194_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaMemberBinding vala_field_get_binding (ValaField* self) {
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void vala_field_set_binding (ValaField* self, ValaMemberBinding value) {
	ValaMemberBinding _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_binding = _tmp0_;
}


gboolean vala_field_get_is_volatile (ValaField* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_volatile;
	result = _tmp0_;
	return result;
}


void vala_field_set_is_volatile (ValaField* self, gboolean value) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_volatile = _tmp0_;
}


static void vala_field_class_init (ValaFieldClass * klass) {
	vala_field_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_field_finalize;
	g_type_class_add_private (klass, sizeof (ValaFieldPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_field_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_field_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_field_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_field_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_field_real_check;
}


static void vala_field_vala_lockable_interface_init (ValaLockableIface * iface) {
	vala_field_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*) (ValaLockable *)) vala_field_real_get_lock_used;
	iface->set_lock_used = (void (*) (ValaLockable *, gboolean)) vala_field_real_set_lock_used;
}


static void vala_field_instance_init (ValaField * self) {
	self->priv = VALA_FIELD_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	self->priv->lock_used = FALSE;
}


static void vala_field_finalize (ValaCodeNode * obj) {
	ValaField * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FIELD, ValaField);
	VALA_CODE_NODE_CLASS (vala_field_parent_class)->finalize (obj);
}


/**
 * Represents a type or namespace field.
 */
GType vala_field_get_type (void) {
	static volatile gsize vala_field_type_id__volatile = 0;
	if (g_once_init_enter (&vala_field_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFieldClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_field_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaField), 0, (GInstanceInitFunc) vala_field_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_field_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_field_type_id;
		vala_field_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaField", &g_define_type_info, 0);
		g_type_add_interface_static (vala_field_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_field_type_id__volatile, vala_field_type_id);
	}
	return vala_field_type_id__volatile;
}



