/* valaifstatement.c generated by valac, the Vala compiler
 * generated from valaifstatement.vala, do not modify */

/* valaifstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaIfStatementPrivate {
	ValaExpression* _condition;
	ValaBlock* _true_statement;
	ValaBlock* _false_statement;
};


static gpointer vala_if_statement_parent_class = NULL;
static ValaStatementIface * vala_if_statement_vala_statement_parent_iface = NULL;

#define VALA_IF_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_IF_STATEMENT, ValaIfStatementPrivate))
static void vala_if_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_if_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_if_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_if_statement_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_if_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_if_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new if statement.
 *
 * @param cond       a boolean condition
 * @param true_stmt  statement to be evaluated if condition is true
 * @param false_stmt statement to be evaluated if condition is false
 * @return           newly created if statement
 */
ValaIfStatement* vala_if_statement_construct (GType object_type, ValaExpression* cond, ValaBlock* true_stmt, ValaBlock* false_stmt, ValaSourceReference* source) {
	ValaIfStatement* self = NULL;
	ValaExpression* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	ValaSourceReference* _tmp3_;
	g_return_val_if_fail (cond != NULL, NULL);
	g_return_val_if_fail (true_stmt != NULL, NULL);
	self = (ValaIfStatement*) vala_code_node_construct (object_type);
	_tmp0_ = cond;
	vala_if_statement_set_condition (self, _tmp0_);
	_tmp1_ = true_stmt;
	vala_if_statement_set_true_statement (self, _tmp1_);
	_tmp2_ = false_stmt;
	vala_if_statement_set_false_statement (self, _tmp2_);
	_tmp3_ = source;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp3_);
	return self;
}


ValaIfStatement* vala_if_statement_new (ValaExpression* cond, ValaBlock* true_stmt, ValaBlock* false_stmt, ValaSourceReference* source) {
	return vala_if_statement_construct (VALA_TYPE_IF_STATEMENT, cond, true_stmt, false_stmt, source);
}


static void vala_if_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaIfStatement * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaIfStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_if_statement (_tmp0_, self);
}


static void vala_if_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaIfStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaCodeVisitor* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaBlock* _tmp6_;
	ValaBlock* _tmp7_;
	ValaCodeVisitor* _tmp8_;
	ValaBlock* _tmp9_;
	ValaBlock* _tmp10_;
	self = (ValaIfStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_if_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = visitor;
	_tmp4_ = vala_if_statement_get_condition (self);
	_tmp5_ = _tmp4_;
	vala_code_visitor_visit_end_full_expression (_tmp3_, _tmp5_);
	_tmp6_ = vala_if_statement_get_true_statement (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp7_, _tmp8_);
	_tmp9_ = vala_if_statement_get_false_statement (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaBlock* _tmp11_;
		ValaBlock* _tmp12_;
		ValaCodeVisitor* _tmp13_;
		_tmp11_ = vala_if_statement_get_false_statement (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp12_, _tmp13_);
	}
}


static void vala_if_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaIfStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaIfStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_if_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_if_statement_set_condition (self, _tmp3_);
	}
}


static gboolean vala_if_statement_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaIfStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCodeContext* _tmp6_;
	ValaSemanticAnalyzer* _tmp7_;
	ValaSemanticAnalyzer* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaCodeContext* _tmp14_;
	ValaBlock* _tmp15_;
	ValaBlock* _tmp16_;
	ValaCodeContext* _tmp17_;
	ValaBlock* _tmp18_;
	ValaBlock* _tmp19_;
	ValaExpression* _tmp23_;
	ValaExpression* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gboolean _tmp27_ = FALSE;
	ValaExpression* _tmp28_;
	ValaExpression* _tmp29_;
	ValaDataType* _tmp30_;
	ValaDataType* _tmp31_;
	ValaExpression* _tmp45_;
	ValaExpression* _tmp46_;
	ValaList* _tmp47_;
	ValaList* _tmp48_;
	ValaBlock* _tmp49_;
	ValaBlock* _tmp50_;
	ValaList* _tmp51_;
	ValaList* _tmp52_;
	ValaBlock* _tmp53_;
	ValaBlock* _tmp54_;
	gboolean _tmp59_;
	gboolean _tmp60_;
	self = (ValaIfStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_if_statement_get_condition (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	_tmp7_ = vala_code_context_get_analyzer (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_->bool_type;
	_tmp10_ = vala_data_type_copy (_tmp9_);
	_tmp11_ = _tmp10_;
	vala_expression_set_target_type (_tmp5_, _tmp11_);
	_vala_code_node_unref0 (_tmp11_);
	_tmp12_ = vala_if_statement_get_condition (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp13_, _tmp14_);
	_tmp15_ = vala_if_statement_get_true_statement (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = context;
	vala_code_node_check ((ValaCodeNode*) _tmp16_, _tmp17_);
	_tmp18_ = vala_if_statement_get_false_statement (self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaBlock* _tmp20_;
		ValaBlock* _tmp21_;
		ValaCodeContext* _tmp22_;
		_tmp20_ = vala_if_statement_get_false_statement (self);
		_tmp21_ = _tmp20_;
		_tmp22_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp21_, _tmp22_);
	}
	_tmp23_ = vala_if_statement_get_condition (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_code_node_get_error ((ValaCodeNode*) _tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp28_ = vala_if_statement_get_condition (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_expression_get_value_type (_tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_ == NULL) {
		_tmp27_ = TRUE;
	} else {
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		ValaCodeContext* _tmp36_;
		ValaSemanticAnalyzer* _tmp37_;
		ValaSemanticAnalyzer* _tmp38_;
		ValaDataType* _tmp39_;
		gboolean _tmp40_;
		_tmp32_ = vala_if_statement_get_condition (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_expression_get_value_type (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = context;
		_tmp37_ = vala_code_context_get_analyzer (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = _tmp38_->bool_type;
		_tmp40_ = vala_data_type_compatible (_tmp35_, _tmp39_);
		_tmp27_ = !_tmp40_;
	}
	if (_tmp27_) {
		ValaExpression* _tmp41_;
		ValaExpression* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaSourceReference* _tmp44_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp41_ = vala_if_statement_get_condition (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp42_);
		_tmp44_ = _tmp43_;
		vala_report_error (_tmp44_, "Condition must be boolean");
		result = FALSE;
		return result;
	}
	_tmp45_ = vala_if_statement_get_condition (self);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp46_);
	_tmp48_ = _tmp47_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp48_);
	_vala_iterable_unref0 (_tmp48_);
	_tmp49_ = vala_if_statement_get_true_statement (self);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp50_);
	_tmp52_ = _tmp51_;
	vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp52_);
	_vala_iterable_unref0 (_tmp52_);
	_tmp53_ = vala_if_statement_get_false_statement (self);
	_tmp54_ = _tmp53_;
	if (_tmp54_ != NULL) {
		ValaBlock* _tmp55_;
		ValaBlock* _tmp56_;
		ValaList* _tmp57_;
		ValaList* _tmp58_;
		_tmp55_ = vala_if_statement_get_false_statement (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp56_);
		_tmp58_ = _tmp57_;
		vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp58_);
		_vala_iterable_unref0 (_tmp58_);
	}
	_tmp59_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp60_ = _tmp59_;
	result = !_tmp60_;
	return result;
}


static void vala_if_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaIfStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeGenerator* _tmp2_;
	ValaCodeGenerator* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCodeGenerator* _tmp6_;
	self = (ValaIfStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_if_statement_get_condition (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = codegen;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = codegen;
	_tmp4_ = vala_if_statement_get_condition (self);
	_tmp5_ = _tmp4_;
	vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) _tmp3_, _tmp5_);
	_tmp6_ = codegen;
	vala_code_visitor_visit_if_statement ((ValaCodeVisitor*) _tmp6_, self);
}


ValaExpression* vala_if_statement_get_condition (ValaIfStatement* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_condition;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_if_statement_set_condition (ValaIfStatement* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_condition);
	self->priv->_condition = _tmp1_;
	_tmp2_ = self->priv->_condition;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaBlock* vala_if_statement_get_true_statement (ValaIfStatement* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_true_statement;
	result = _tmp0_;
	return result;
}


void vala_if_statement_set_true_statement (ValaIfStatement* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_true_statement);
	self->priv->_true_statement = _tmp1_;
	_tmp2_ = self->priv->_true_statement;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


ValaBlock* vala_if_statement_get_false_statement (ValaIfStatement* self) {
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_false_statement;
	result = _tmp0_;
	return result;
}


void vala_if_statement_set_false_statement (ValaIfStatement* self, ValaBlock* value) {
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBlock* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_false_statement);
	self->priv->_false_statement = _tmp1_;
	_tmp2_ = self->priv->_false_statement;
	if (_tmp2_ != NULL) {
		ValaBlock* _tmp3_;
		_tmp3_ = self->priv->_false_statement;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp3_, (ValaCodeNode*) self);
	}
}


static void vala_if_statement_class_init (ValaIfStatementClass * klass) {
	vala_if_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_if_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaIfStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_if_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_if_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_if_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_if_statement_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_if_statement_real_emit;
}


static void vala_if_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_if_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_if_statement_instance_init (ValaIfStatement * self) {
	self->priv = VALA_IF_STATEMENT_GET_PRIVATE (self);
}


static void vala_if_statement_finalize (ValaCodeNode * obj) {
	ValaIfStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_IF_STATEMENT, ValaIfStatement);
	_vala_code_node_unref0 (self->priv->_condition);
	_vala_code_node_unref0 (self->priv->_true_statement);
	_vala_code_node_unref0 (self->priv->_false_statement);
	VALA_CODE_NODE_CLASS (vala_if_statement_parent_class)->finalize (obj);
}


/**
 * Represents an if selection statement in the source code.
 */
GType vala_if_statement_get_type (void) {
	static volatile gsize vala_if_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_if_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaIfStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_if_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaIfStatement), 0, (GInstanceInitFunc) vala_if_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_if_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_if_statement_type_id;
		vala_if_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaIfStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_if_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_if_statement_type_id__volatile, vala_if_statement_type_id);
	}
	return vala_if_statement_type_id__volatile;
}



