/* valastruct.c generated by valac, the Vala compiler
 * generated from valastruct.vala, do not modify */

/* valastruct.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaStructPrivate {
	ValaList* type_parameters;
	ValaList* constants;
	ValaList* fields;
	ValaList* methods;
	ValaList* properties;
	ValaDataType* _base_type;
	gboolean* boolean_type;
	gboolean* integer_type;
	gboolean* floating_type;
	gboolean* decimal_floating_type;
	gboolean* simple_type;
	gint* rank;
	gint* _width;
	gboolean* _signed;
	gboolean* _is_immutable;
	ValaMethod* _default_construction_method;
};


static gpointer vala_struct_parent_class = NULL;

#define VALA_STRUCT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_STRUCT, ValaStructPrivate))
static void vala_struct_real_add_constant (ValaSymbol* base, ValaConstant* c);
static void vala_struct_real_add_field (ValaSymbol* base, ValaField* f);
static void vala_struct_real_add_method (ValaSymbol* base, ValaMethod* m);
static void vala_struct_real_add_property (ValaSymbol* base, ValaProperty* prop);
static void vala_struct_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_struct_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean* _bool_dup (gboolean* self);
static gint* _int_dup (gint* self);
static gint vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base, const gchar* name);
static void vala_struct_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_struct_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t);
static gboolean vala_struct_is_recursive_value_type (ValaStruct* self, ValaDataType* type);
static gboolean vala_struct_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_struct_finalize (ValaCodeNode * obj);


/**
 * Creates a new struct.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @return                 newly created struct
 */
ValaStruct* vala_struct_construct (GType object_type, const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	ValaStruct* self = NULL;
	const gchar* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaComment* _tmp2_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = name;
	_tmp1_ = source_reference;
	_tmp2_ = comment;
	self = (ValaStruct*) vala_typesymbol_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


ValaStruct* vala_struct_new (const gchar* name, ValaSourceReference* source_reference, ValaComment* comment) {
	return vala_struct_construct (VALA_TYPE_STRUCT, name, source_reference, comment);
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void vala_struct_add_type_parameter (ValaStruct* self, ValaTypeParameter* p) {
	ValaList* _tmp0_;
	ValaTypeParameter* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaTypeParameter* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaTypeParameter* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = p;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = p;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = p;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_struct_get_type_parameters (ValaStruct* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified constant as a member to this struct.
 *
 * @param c a constant
 */
static void vala_struct_real_add_constant (ValaSymbol* base, ValaConstant* c) {
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaConstant* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaConstant* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaConstant* _tmp7_;
	self = (ValaStruct*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = c;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = c;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = c;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
}


/**
 * Adds the specified field as a member to this struct.
 *
 * @param f a field
 */
static void vala_struct_real_add_field (ValaSymbol* base, ValaField* f) {
	ValaStruct * self;
	ValaField* _tmp0_;
	ValaList* _tmp1_;
	ValaField* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	ValaField* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	ValaField* _tmp8_;
	self = (ValaStruct*) base;
	g_return_if_fail (f != NULL);
	_tmp0_ = f;
	vala_symbol_set_access ((ValaSymbol*) _tmp0_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp1_ = self->priv->fields;
	_tmp2_ = f;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
	_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = f;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = f;
	vala_scope_add (_tmp4_, _tmp7_, (ValaSymbol*) _tmp8_);
}


/**
 * Returns a copy of the list of fields.
 *
 * @return list of fields
 */
ValaList* vala_struct_get_fields (ValaStruct* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->fields;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a copy of the list of constants.
 *
 * @return list of constants
 */
ValaList* vala_struct_get_constants (ValaStruct* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->constants;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this struct.
 *
 * @param m a method
 */
static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


static void vala_struct_real_add_method (ValaSymbol* base, ValaMethod* m) {
	ValaStruct * self;
	ValaMethod* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaMethod* _tmp2_;
	ValaMemberBinding _tmp3_;
	ValaMemberBinding _tmp4_;
	gboolean _tmp22_ = FALSE;
	ValaMethod* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaMethod* _tmp44_;
	ValaList* _tmp72_;
	ValaMethod* _tmp73_;
	ValaScope* _tmp74_;
	ValaScope* _tmp75_;
	ValaMethod* _tmp76_;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	ValaMethod* _tmp79_;
	self = (ValaStruct*) base;
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp2_ = m;
	_tmp3_ = vala_method_get_binding (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp1_ = TRUE;
	} else {
		ValaMethod* _tmp5_;
		_tmp5_ = m;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_CREATION_METHOD);
	}
	if (_tmp1_) {
		ValaMethod* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		ValaParameter* _tmp9_;
		ValaParameter* _tmp10_;
		ValaMethod* _tmp11_;
		ValaScope* _tmp12_;
		ValaScope* _tmp13_;
		ValaMethod* _tmp14_;
		ValaParameter* _tmp15_;
		ValaParameter* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		ValaMethod* _tmp19_;
		ValaParameter* _tmp20_;
		ValaParameter* _tmp21_;
		_tmp6_ = m;
		_tmp7_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaTypeSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_parameter_new ("this", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		vala_method_set_this_parameter (_tmp6_, _tmp10_);
		_vala_code_node_unref0 (_tmp10_);
		_vala_code_node_unref0 (_tmp8_);
		_tmp11_ = m;
		_tmp12_ = vala_symbol_get_scope ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = m;
		_tmp15_ = vala_method_get_this_parameter (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_name ((ValaSymbol*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = m;
		_tmp20_ = vala_method_get_this_parameter (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_scope_add (_tmp13_, _tmp18_, (ValaSymbol*) _tmp21_);
	}
	_tmp23_ = m;
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) _tmp23_);
	_tmp25_ = _tmp24_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_VOID_TYPE)) {
		ValaMethod* _tmp26_;
		ValaList* _tmp27_;
		ValaList* _tmp28_;
		gint _tmp29_;
		gint _tmp30_;
		_tmp26_ = m;
		_tmp27_ = vala_method_get_postconditions (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp22_ = _tmp30_ > 0;
		_vala_iterable_unref0 (_tmp28_);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		ValaMethod* _tmp31_;
		ValaMethod* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		ValaDataType* _tmp36_;
		ValaSourceReference* _tmp37_;
		ValaSourceReference* _tmp38_;
		ValaLocalVariable* _tmp39_;
		ValaLocalVariable* _tmp40_;
		ValaMethod* _tmp41_;
		ValaLocalVariable* _tmp42_;
		ValaLocalVariable* _tmp43_;
		_tmp31_ = m;
		_tmp32_ = m;
		_tmp33_ = vala_callable_get_return_type ((ValaCallable*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_data_type_copy (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_local_variable_new (_tmp36_, "result", NULL, _tmp38_);
		_tmp40_ = _tmp39_;
		vala_subroutine_set_result_var ((ValaSubroutine*) _tmp31_, _tmp40_);
		_vala_code_node_unref0 (_tmp40_);
		_vala_code_node_unref0 (_tmp36_);
		_tmp41_ = m;
		_tmp42_ = vala_subroutine_get_result_var ((ValaSubroutine*) _tmp41_);
		_tmp43_ = _tmp42_;
		vala_local_variable_set_is_result (_tmp43_, TRUE);
	}
	_tmp44_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		ValaCreationMethod* cm = NULL;
		ValaMethod* _tmp50_;
		ValaCreationMethod* _tmp51_;
		gboolean _tmp52_ = FALSE;
		ValaCreationMethod* _tmp53_;
		const gchar* _tmp54_;
		const gchar* _tmp55_;
		_tmp45_ = m;
		_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
		_tmp47_ = _tmp46_;
		if (_tmp47_ == NULL) {
			ValaMethod* _tmp48_;
			ValaMethod* _tmp49_;
			_tmp48_ = m;
			vala_struct_set_default_construction_method (self, _tmp48_);
			_tmp49_ = m;
			vala_symbol_set_name ((ValaSymbol*) _tmp49_, ".new");
		}
		_tmp50_ = m;
		_tmp51_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp51_;
		_tmp53_ = cm;
		_tmp54_ = vala_creation_method_get_class_name (_tmp53_);
		_tmp55_ = _tmp54_;
		if (_tmp55_ != NULL) {
			ValaCreationMethod* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			const gchar* _tmp60_;
			_tmp56_ = cm;
			_tmp57_ = vala_creation_method_get_class_name (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp60_ = _tmp59_;
			_tmp52_ = g_strcmp0 (_tmp58_, _tmp60_) != 0;
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			ValaMethod* _tmp61_;
			ValaSourceReference* _tmp62_;
			ValaSourceReference* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			ValaCreationMethod* _tmp66_;
			const gchar* _tmp67_;
			const gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			ValaMethod* _tmp71_;
			_tmp61_ = m;
			_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp65_ = _tmp64_;
			_tmp66_ = cm;
			_tmp67_ = vala_creation_method_get_class_name (_tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp65_, _tmp68_);
			_tmp70_ = _tmp69_;
			vala_report_error (_tmp63_, _tmp70_);
			_g_free0 (_tmp70_);
			_g_free0 (_tmp65_);
			_tmp71_ = m;
			vala_code_node_set_error ((ValaCodeNode*) _tmp71_, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp72_ = self->priv->methods;
	_tmp73_ = m;
	vala_collection_add ((ValaCollection*) _tmp72_, _tmp73_);
	_tmp74_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp75_ = _tmp74_;
	_tmp76_ = m;
	_tmp77_ = vala_symbol_get_name ((ValaSymbol*) _tmp76_);
	_tmp78_ = _tmp77_;
	_tmp79_ = m;
	vala_scope_add (_tmp75_, _tmp78_, (ValaSymbol*) _tmp79_);
}


/**
 * Returns a copy of the list of methods.
 *
 * @return list of methods
 */
ValaList* vala_struct_get_methods (ValaStruct* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->methods;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified property as a member to this struct.
 *
 * @param prop a property
 */
static void vala_struct_real_add_property (ValaSymbol* base, ValaProperty* prop) {
	ValaStruct * self;
	ValaList* _tmp0_;
	ValaProperty* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaProperty* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValaProperty* _tmp7_;
	ValaProperty* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaParameter* _tmp11_;
	ValaParameter* _tmp12_;
	ValaProperty* _tmp13_;
	ValaScope* _tmp14_;
	ValaScope* _tmp15_;
	ValaProperty* _tmp16_;
	ValaParameter* _tmp17_;
	ValaParameter* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	ValaProperty* _tmp21_;
	ValaParameter* _tmp22_;
	ValaParameter* _tmp23_;
	ValaProperty* _tmp24_;
	ValaField* _tmp25_;
	ValaField* _tmp26_;
	self = (ValaStruct*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->properties;
	_tmp1_ = prop;
	vala_collection_add ((ValaCollection*) _tmp0_, _tmp1_);
	_tmp2_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = prop;
	_tmp5_ = vala_symbol_get_name ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = prop;
	vala_scope_add (_tmp3_, _tmp6_, (ValaSymbol*) _tmp7_);
	_tmp8_ = prop;
	_tmp9_ = vala_semantic_analyzer_get_data_type_for_symbol ((ValaTypeSymbol*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_parameter_new ("this", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	vala_property_set_this_parameter (_tmp8_, _tmp12_);
	_vala_code_node_unref0 (_tmp12_);
	_vala_code_node_unref0 (_tmp10_);
	_tmp13_ = prop;
	_tmp14_ = vala_symbol_get_scope ((ValaSymbol*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = prop;
	_tmp17_ = vala_property_get_this_parameter (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = prop;
	_tmp22_ = vala_property_get_this_parameter (_tmp21_);
	_tmp23_ = _tmp22_;
	vala_scope_add (_tmp15_, _tmp20_, (ValaSymbol*) _tmp23_);
	_tmp24_ = prop;
	_tmp25_ = vala_property_get_field (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != NULL) {
		ValaProperty* _tmp27_;
		ValaField* _tmp28_;
		ValaField* _tmp29_;
		_tmp27_ = prop;
		_tmp28_ = vala_property_get_field (_tmp27_);
		_tmp29_ = _tmp28_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp29_);
	}
}


/**
 * Returns a copy of the list of properties.
 *
 * @return list of properties
 */
ValaList* vala_struct_get_properties (ValaStruct* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->properties;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_struct_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaStruct * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_struct (_tmp0_, self);
}


static void vala_struct_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaStruct*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaCodeVisitor* _tmp4_;
		_tmp2_ = vala_struct_get_base_type (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = visitor;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, _tmp4_);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _p_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _p_index = 0;
		_tmp5_ = self->priv->type_parameters;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_p_list = _tmp6_;
		_tmp7_ = _p_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_p_size = _tmp9_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			ValaTypeParameter* _tmp16_;
			ValaCodeVisitor* _tmp17_;
			_tmp10_ = _p_index;
			_p_index = _tmp10_ + 1;
			_tmp11_ = _p_index;
			_tmp12_ = _p_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _p_list;
			_tmp14_ = _p_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			p = (ValaTypeParameter*) _tmp15_;
			_tmp16_ = p;
			_tmp17_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp16_, _tmp17_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _f_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _f_index = 0;
		_tmp18_ = self->priv->fields;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_f_list = _tmp19_;
		_tmp20_ = _f_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_f_size = _tmp22_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			ValaField* f = NULL;
			ValaList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_;
			ValaField* _tmp29_;
			ValaCodeVisitor* _tmp30_;
			_tmp23_ = _f_index;
			_f_index = _tmp23_ + 1;
			_tmp24_ = _f_index;
			_tmp25_ = _f_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _f_list;
			_tmp27_ = _f_index;
			_tmp28_ = vala_list_get (_tmp26_, _tmp27_);
			f = (ValaField*) _tmp28_;
			_tmp29_ = f;
			_tmp30_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp29_, _tmp30_);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp31_;
		ValaList* _tmp32_;
		gint _c_size = 0;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _c_index = 0;
		_tmp31_ = self->priv->constants;
		_tmp32_ = _vala_iterable_ref0 (_tmp31_);
		_c_list = _tmp32_;
		_tmp33_ = _c_list;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_c_size = _tmp35_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			ValaConstant* c = NULL;
			ValaList* _tmp39_;
			gint _tmp40_;
			gpointer _tmp41_;
			ValaConstant* _tmp42_;
			ValaCodeVisitor* _tmp43_;
			_tmp36_ = _c_index;
			_c_index = _tmp36_ + 1;
			_tmp37_ = _c_index;
			_tmp38_ = _c_size;
			if (!(_tmp37_ < _tmp38_)) {
				break;
			}
			_tmp39_ = _c_list;
			_tmp40_ = _c_index;
			_tmp41_ = vala_list_get (_tmp39_, _tmp40_);
			c = (ValaConstant*) _tmp41_;
			_tmp42_ = c;
			_tmp43_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp42_, _tmp43_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp44_;
		ValaList* _tmp45_;
		gint _m_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _m_index = 0;
		_tmp44_ = self->priv->methods;
		_tmp45_ = _vala_iterable_ref0 (_tmp44_);
		_m_list = _tmp45_;
		_tmp46_ = _m_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_m_size = _tmp48_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaMethod* m = NULL;
			ValaList* _tmp52_;
			gint _tmp53_;
			gpointer _tmp54_;
			ValaMethod* _tmp55_;
			ValaCodeVisitor* _tmp56_;
			_tmp49_ = _m_index;
			_m_index = _tmp49_ + 1;
			_tmp50_ = _m_index;
			_tmp51_ = _m_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _m_list;
			_tmp53_ = _m_index;
			_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
			m = (ValaMethod*) _tmp54_;
			_tmp55_ = m;
			_tmp56_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp55_, _tmp56_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp57_;
		ValaList* _tmp58_;
		gint _prop_size = 0;
		ValaList* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint _prop_index = 0;
		_tmp57_ = self->priv->properties;
		_tmp58_ = _vala_iterable_ref0 (_tmp57_);
		_prop_list = _tmp58_;
		_tmp59_ = _prop_list;
		_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
		_tmp61_ = _tmp60_;
		_prop_size = _tmp61_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp62_;
			gint _tmp63_;
			gint _tmp64_;
			ValaProperty* prop = NULL;
			ValaList* _tmp65_;
			gint _tmp66_;
			gpointer _tmp67_;
			ValaProperty* _tmp68_;
			ValaCodeVisitor* _tmp69_;
			_tmp62_ = _prop_index;
			_prop_index = _tmp62_ + 1;
			_tmp63_ = _prop_index;
			_tmp64_ = _prop_size;
			if (!(_tmp63_ < _tmp64_)) {
				break;
			}
			_tmp65_ = _prop_list;
			_tmp66_ = _prop_index;
			_tmp67_ = vala_list_get (_tmp65_, _tmp66_);
			prop = (ValaProperty*) _tmp67_;
			_tmp68_ = prop;
			_tmp69_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp68_, _tmp69_);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
}


/**
 * Returns whether this is a boolean type.
 *
 * @return true if this is a boolean type, false otherwise
 */
static gboolean* _bool_dup (gboolean* self) {
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer __bool_dup0 (gpointer self) {
	return self ? _bool_dup (self) : NULL;
}


gboolean vala_struct_is_boolean_type (ValaStruct* self) {
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp7_;
	gboolean* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = st;
		_tmp6_ = vala_struct_is_boolean_type (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp7_ = self->priv->boolean_type;
	if (_tmp7_ == NULL) {
		ValaAttribute* _tmp8_;
		ValaAttribute* _tmp9_;
		gboolean _tmp10_;
		gboolean* _tmp11_;
		_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "BooleanType");
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_ != NULL;
		_tmp11_ = __bool_dup0 (&_tmp10_);
		_g_free0 (self->priv->boolean_type);
		self->priv->boolean_type = _tmp11_;
		_vala_code_node_unref0 (_tmp9_);
	}
	_tmp12_ = self->priv->boolean_type;
	result = *_tmp12_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Returns whether this is an integer type.
 *
 * @return true if this is an integer type, false otherwise
 */
gboolean vala_struct_is_integer_type (ValaStruct* self) {
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp7_;
	gboolean* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = st;
		_tmp6_ = vala_struct_is_integer_type (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp7_ = self->priv->integer_type;
	if (_tmp7_ == NULL) {
		ValaAttribute* _tmp8_;
		ValaAttribute* _tmp9_;
		gboolean _tmp10_;
		gboolean* _tmp11_;
		_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "IntegerType");
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_ != NULL;
		_tmp11_ = __bool_dup0 (&_tmp10_);
		_g_free0 (self->priv->integer_type);
		self->priv->integer_type = _tmp11_;
		_vala_code_node_unref0 (_tmp9_);
	}
	_tmp12_ = self->priv->integer_type;
	result = *_tmp12_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Returns whether this is a floating point type.
 *
 * @return true if this is a floating point type, false otherwise
 */
gboolean vala_struct_is_floating_type (ValaStruct* self) {
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp7_;
	gboolean* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = st;
		_tmp6_ = vala_struct_is_floating_type (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp7_ = self->priv->floating_type;
	if (_tmp7_ == NULL) {
		ValaAttribute* _tmp8_;
		ValaAttribute* _tmp9_;
		gboolean _tmp10_;
		gboolean* _tmp11_;
		_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "FloatingType");
		_tmp9_ = _tmp8_;
		_tmp10_ = _tmp9_ != NULL;
		_tmp11_ = __bool_dup0 (&_tmp10_);
		_g_free0 (self->priv->floating_type);
		self->priv->floating_type = _tmp11_;
		_vala_code_node_unref0 (_tmp9_);
	}
	_tmp12_ = self->priv->floating_type;
	result = *_tmp12_;
	_vala_code_node_unref0 (st);
	return result;
}


gboolean vala_struct_is_decimal_floating_type (ValaStruct* self) {
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp7_;
	gboolean* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = st;
		_tmp6_ = vala_struct_is_decimal_floating_type (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp7_ = self->priv->decimal_floating_type;
	if (_tmp7_ == NULL) {
		gboolean _tmp8_;
		gboolean* _tmp9_;
		_tmp8_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "FloatingType", "decimal", FALSE);
		_tmp9_ = __bool_dup0 (&_tmp8_);
		_g_free0 (self->priv->decimal_floating_type);
		self->priv->decimal_floating_type = _tmp9_;
	}
	_tmp10_ = self->priv->decimal_floating_type;
	result = *_tmp10_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Returns the rank of this integer or floating point type.
 *
 * @return the rank if this is an integer or floating point type
 */
static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


gint vala_struct_get_rank (ValaStruct* self) {
	gint result = 0;
	gint* _tmp0_;
	gint* _tmp16_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->rank;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_;
		_tmp2_ = vala_struct_is_integer_type (self);
		if (_tmp2_) {
			gboolean _tmp3_;
			_tmp3_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "IntegerType", "rank");
			_tmp1_ = _tmp3_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gint _tmp4_;
			gint* _tmp5_;
			_tmp4_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "IntegerType", "rank", 0);
			_tmp5_ = __int_dup0 (&_tmp4_);
			_g_free0 (self->priv->rank);
			self->priv->rank = _tmp5_;
		} else {
			gboolean _tmp6_;
			_tmp6_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) self, "FloatingType", "rank");
			if (_tmp6_) {
				gint _tmp7_;
				gint* _tmp8_;
				_tmp7_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "FloatingType", "rank", 0);
				_tmp8_ = __int_dup0 (&_tmp7_);
				_g_free0 (self->priv->rank);
				self->priv->rank = _tmp8_;
			} else {
				ValaStruct* st = NULL;
				ValaStruct* _tmp9_;
				ValaStruct* _tmp10_;
				ValaStruct* _tmp11_;
				ValaStruct* _tmp12_;
				_tmp9_ = vala_struct_get_base_struct (self);
				_tmp10_ = _tmp9_;
				_tmp11_ = _vala_code_node_ref0 (_tmp10_);
				st = _tmp11_;
				_tmp12_ = st;
				if (_tmp12_ != NULL) {
					ValaStruct* _tmp13_;
					gint _tmp14_;
					gint* _tmp15_;
					_tmp13_ = st;
					_tmp14_ = vala_struct_get_rank (_tmp13_);
					_tmp15_ = __int_dup0 (&_tmp14_);
					_g_free0 (self->priv->rank);
					self->priv->rank = _tmp15_;
				}
				_vala_code_node_unref0 (st);
			}
		}
	}
	_tmp16_ = self->priv->rank;
	result = *_tmp16_;
	return result;
}


/**
 * Sets the rank of this integer or floating point type.
 */
void vala_struct_set_rank (ValaStruct* self, gint rank) {
	gint _tmp0_;
	gint* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = rank;
	_tmp1_ = __int_dup0 (&_tmp0_);
	_g_free0 (self->priv->rank);
	self->priv->rank = _tmp1_;
	_tmp2_ = vala_struct_is_integer_type (self);
	if (_tmp2_) {
		gint _tmp3_;
		_tmp3_ = rank;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "IntegerType", "rank", _tmp3_, NULL);
	} else {
		gint _tmp4_;
		_tmp4_ = rank;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "FloatingType", "rank", _tmp4_, NULL);
	}
}


static gint vala_struct_real_get_type_parameter_index (ValaTypeSymbol* base, const gchar* name) {
	ValaStruct * self;
	gint result = 0;
	gint i = 0;
	self = (ValaStruct*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _p_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaTypeParameter* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			_tmp5_ = _p_index;
			_p_index = _tmp5_ + 1;
			_tmp6_ = _p_index;
			_tmp7_ = _p_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _p_list;
			_tmp9_ = _p_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			p = (ValaTypeParameter*) _tmp10_;
			_tmp11_ = p;
			_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = name;
			if (g_strcmp0 (_tmp13_, _tmp14_) == 0) {
				result = i;
				_vala_code_node_unref0 (p);
				_vala_iterable_unref0 (_p_list);
				return result;
			}
			_tmp15_ = i;
			i = _tmp15_ + 1;
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	result = -1;
	return result;
}


/**
 * Returns whether this struct is a simple type, i.e. whether
 * instances are passed by value.
 */
gboolean vala_struct_is_simple_type (ValaStruct* self) {
	gboolean result = FALSE;
	ValaStruct* st = NULL;
	ValaStruct* _tmp0_;
	ValaStruct* _tmp1_;
	ValaStruct* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaStruct* _tmp4_;
	gboolean* _tmp7_;
	gboolean* _tmp21_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_struct_get_base_struct (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	st = _tmp2_;
	_tmp4_ = st;
	if (_tmp4_ != NULL) {
		ValaStruct* _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = st;
		_tmp6_ = vala_struct_is_simple_type (_tmp5_);
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_code_node_unref0 (st);
		return result;
	}
	_tmp7_ = self->priv->simple_type;
	if (_tmp7_ == NULL) {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaAttribute* _tmp11_;
		ValaAttribute* _tmp12_;
		gboolean _tmp13_;
		gboolean* _tmp20_;
		_tmp11_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "SimpleType");
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_ != NULL;
		_vala_code_node_unref0 (_tmp12_);
		if (_tmp13_) {
			_tmp10_ = TRUE;
		} else {
			ValaAttribute* _tmp14_;
			ValaAttribute* _tmp15_;
			_tmp14_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "BooleanType");
			_tmp15_ = _tmp14_;
			_tmp10_ = _tmp15_ != NULL;
			_vala_code_node_unref0 (_tmp15_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaAttribute* _tmp16_;
			ValaAttribute* _tmp17_;
			_tmp16_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "IntegerType");
			_tmp17_ = _tmp16_;
			_tmp9_ = _tmp17_ != NULL;
			_vala_code_node_unref0 (_tmp17_);
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			ValaAttribute* _tmp18_;
			ValaAttribute* _tmp19_;
			_tmp18_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "FloatingType");
			_tmp19_ = _tmp18_;
			_tmp8_ = _tmp19_ != NULL;
			_vala_code_node_unref0 (_tmp19_);
		}
		_tmp20_ = __bool_dup0 (&_tmp8_);
		_g_free0 (self->priv->simple_type);
		self->priv->simple_type = _tmp20_;
	}
	_tmp21_ = self->priv->simple_type;
	result = *_tmp21_;
	_vala_code_node_unref0 (st);
	return result;
}


/**
 * Marks this struct as simple type, i.e. instances will be passed by
 * value.
 */
void vala_struct_set_simple_type (ValaStruct* self, gboolean simple_type) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = simple_type;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->simple_type);
	self->priv->simple_type = _tmp1_;
	_tmp2_ = simple_type;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "SimpleType", _tmp2_, NULL);
}


static void vala_struct_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaStruct * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaStruct*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_struct_get_base_type (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_type;
	if (_tmp1_ == _tmp2_) {
		ValaDataType* _tmp3_;
		_tmp3_ = new_type;
		vala_struct_set_base_type (self, _tmp3_);
	}
}


static gboolean vala_struct_real_is_subtype_of (ValaTypeSymbol* base, ValaTypeSymbol* t) {
	ValaStruct * self;
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	self = (ValaStruct*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	_tmp0_ = t;
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == _tmp0_) {
		result = TRUE;
		return result;
	}
	_tmp1_ = vala_struct_get_base_type (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		_tmp4_ = vala_struct_get_base_type (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_get_data_type (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaDataType* _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			gboolean _tmp13_;
			_tmp8_ = vala_struct_get_base_type (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_data_type_get_data_type (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = t;
			_tmp13_ = vala_typesymbol_is_subtype_of (_tmp11_, _tmp12_);
			_tmp3_ = _tmp13_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		}
	}
	result = FALSE;
	return result;
}


gboolean vala_struct_is_disposable (ValaStruct* self) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "CCode", "destroy_function", NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _f_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _f_index = 0;
		_tmp3_ = self->priv->fields;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_f_list = _tmp4_;
		_tmp5_ = _f_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_f_size = _tmp7_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			ValaField* f = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			gboolean _tmp14_ = FALSE;
			ValaField* _tmp15_;
			ValaMemberBinding _tmp16_;
			ValaMemberBinding _tmp17_;
			_tmp8_ = _f_index;
			_f_index = _tmp8_ + 1;
			_tmp9_ = _f_index;
			_tmp10_ = _f_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _f_list;
			_tmp12_ = _f_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			f = (ValaField*) _tmp13_;
			_tmp15_ = f;
			_tmp16_ = vala_field_get_binding (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp18_;
				ValaDataType* _tmp19_;
				ValaDataType* _tmp20_;
				gboolean _tmp21_;
				_tmp18_ = f;
				_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) _tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = vala_data_type_is_disposable (_tmp20_);
				_tmp14_ = _tmp21_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				return result;
			}
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	result = FALSE;
	return result;
}


static gboolean vala_struct_is_recursive_value_type (ValaStruct* self, ValaDataType* type) {
	gboolean result = FALSE;
	ValaStructValueType* struct_type = NULL;
	ValaDataType* _tmp0_;
	ValaStructValueType* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaStructValueType* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = type;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, VALA_TYPE_STRUCT_VALUE_TYPE) ? ((ValaStructValueType*) _tmp0_) : NULL);
	struct_type = _tmp1_;
	_tmp3_ = struct_type;
	if (_tmp3_ != NULL) {
		ValaStructValueType* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = struct_type;
		_tmp5_ = vala_data_type_get_nullable ((ValaDataType*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = !_tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaStruct* st = NULL;
		ValaStructValueType* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		ValaTypeSymbol* _tmp9_;
		ValaStruct* _tmp10_;
		ValaStruct* _tmp11_;
		_tmp7_ = struct_type;
		_tmp8_ = vala_value_type_get_type_symbol ((ValaValueType*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_STRUCT, ValaStruct));
		st = _tmp10_;
		_tmp11_ = st;
		if (_tmp11_ == self) {
			result = TRUE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (struct_type);
			return result;
		}
		{
			ValaList* _f_list = NULL;
			ValaStruct* _tmp12_;
			ValaList* _tmp13_;
			ValaList* _tmp14_;
			gint _f_size = 0;
			ValaList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _f_index = 0;
			_tmp12_ = st;
			_tmp13_ = _tmp12_->priv->fields;
			_tmp14_ = _vala_iterable_ref0 (_tmp13_);
			_f_list = _tmp14_;
			_tmp15_ = _f_list;
			_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_f_size = _tmp17_;
			_f_index = -1;
			while (TRUE) {
				gint _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				ValaField* f = NULL;
				ValaList* _tmp21_;
				gint _tmp22_;
				gpointer _tmp23_;
				gboolean _tmp24_ = FALSE;
				ValaField* _tmp25_;
				ValaMemberBinding _tmp26_;
				ValaMemberBinding _tmp27_;
				_tmp18_ = _f_index;
				_f_index = _tmp18_ + 1;
				_tmp19_ = _f_index;
				_tmp20_ = _f_size;
				if (!(_tmp19_ < _tmp20_)) {
					break;
				}
				_tmp21_ = _f_list;
				_tmp22_ = _f_index;
				_tmp23_ = vala_list_get (_tmp21_, _tmp22_);
				f = (ValaField*) _tmp23_;
				_tmp25_ = f;
				_tmp26_ = vala_field_get_binding (_tmp25_);
				_tmp27_ = _tmp26_;
				if (_tmp27_ == VALA_MEMBER_BINDING_INSTANCE) {
					ValaField* _tmp28_;
					ValaDataType* _tmp29_;
					ValaDataType* _tmp30_;
					gboolean _tmp31_;
					_tmp28_ = f;
					_tmp29_ = vala_variable_get_variable_type ((ValaVariable*) _tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = vala_struct_is_recursive_value_type (self, _tmp30_);
					_tmp24_ = _tmp31_;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					result = TRUE;
					_vala_code_node_unref0 (f);
					_vala_iterable_unref0 (_f_list);
					_vala_code_node_unref0 (st);
					_vala_code_node_unref0 (struct_type);
					return result;
				}
				_vala_code_node_unref0 (f);
			}
			_vala_iterable_unref0 (_f_list);
		}
		_vala_code_node_unref0 (st);
	}
	result = FALSE;
	_vala_code_node_unref0 (struct_type);
	return result;
}


static gpointer _vala_source_file_ref0 (gpointer self) {
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean vala_struct_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaStruct * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaCodeContext* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSymbol* old_symbol = NULL;
	ValaCodeContext* _tmp10_;
	ValaSemanticAnalyzer* _tmp11_;
	ValaSemanticAnalyzer* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSourceReference* _tmp16_;
	ValaSourceReference* _tmp17_;
	ValaCodeContext* _tmp25_;
	ValaSemanticAnalyzer* _tmp26_;
	ValaSemanticAnalyzer* _tmp27_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	gboolean _tmp131_ = FALSE;
	gboolean _tmp132_;
	gboolean _tmp133_;
	ValaCodeContext* _tmp173_;
	ValaSemanticAnalyzer* _tmp174_;
	ValaSemanticAnalyzer* _tmp175_;
	ValaSourceFile* _tmp176_;
	ValaCodeContext* _tmp177_;
	ValaSemanticAnalyzer* _tmp178_;
	ValaSemanticAnalyzer* _tmp179_;
	ValaSymbol* _tmp180_;
	gboolean _tmp181_;
	gboolean _tmp182_;
	self = (ValaStruct*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = context;
	_tmp5_ = vala_code_context_get_analyzer (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_source_file (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_source_file_ref0 (_tmp8_);
	old_source_file = _tmp9_;
	_tmp10_ = context;
	_tmp11_ = vala_code_context_get_analyzer (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_semantic_analyzer_get_current_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _vala_code_node_ref0 (_tmp14_);
	old_symbol = _tmp15_;
	_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaCodeContext* _tmp18_;
		ValaSemanticAnalyzer* _tmp19_;
		ValaSemanticAnalyzer* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaSourceFile* _tmp23_;
		ValaSourceFile* _tmp24_;
		_tmp18_ = context;
		_tmp19_ = vala_code_context_get_analyzer (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = vala_source_reference_get_file (_tmp22_);
		_tmp24_ = _tmp23_;
		vala_semantic_analyzer_set_current_source_file (_tmp20_, _tmp24_);
	}
	_tmp25_ = context;
	_tmp26_ = vala_code_context_get_analyzer (_tmp25_);
	_tmp27_ = _tmp26_;
	vala_semantic_analyzer_set_current_symbol (_tmp27_, (ValaSymbol*) self);
	_tmp28_ = vala_struct_get_base_type (self);
	_tmp29_ = _tmp28_;
	if (_tmp29_ != NULL) {
		ValaDataType* _tmp30_;
		ValaDataType* _tmp31_;
		ValaCodeContext* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		_tmp30_ = vala_struct_get_base_type (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = context;
		vala_code_node_check ((ValaCodeNode*) _tmp31_, _tmp32_);
		_tmp33_ = vala_struct_get_base_type (self);
		_tmp34_ = _tmp33_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALA_TYPE_VALUE_TYPE)) {
			ValaSourceReference* _tmp35_;
			ValaSourceReference* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_struct_get_base_type (self);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_code_node_to_string ((ValaCodeNode*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strdup_printf ("The base type `%s` of struct `%s` is not a struct", _tmp40_, _tmp42_);
			_tmp44_ = _tmp43_;
			vala_report_error (_tmp36_, _tmp44_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp40_);
			result = FALSE;
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp45_;
		ValaList* _tmp46_;
		gint _p_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _p_index = 0;
		_tmp45_ = self->priv->type_parameters;
		_tmp46_ = _vala_iterable_ref0 (_tmp45_);
		_p_list = _tmp46_;
		_tmp47_ = _p_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_p_size = _tmp49_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp53_;
			gint _tmp54_;
			gpointer _tmp55_;
			ValaTypeParameter* _tmp56_;
			ValaCodeContext* _tmp57_;
			_tmp50_ = _p_index;
			_p_index = _tmp50_ + 1;
			_tmp51_ = _p_index;
			_tmp52_ = _p_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _p_list;
			_tmp54_ = _p_index;
			_tmp55_ = vala_list_get (_tmp53_, _tmp54_);
			p = (ValaTypeParameter*) _tmp55_;
			_tmp56_ = p;
			_tmp57_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp56_, _tmp57_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp58_;
		ValaList* _tmp59_;
		gint _f_size = 0;
		ValaList* _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		gint _f_index = 0;
		_tmp58_ = self->priv->fields;
		_tmp59_ = _vala_iterable_ref0 (_tmp58_);
		_f_list = _tmp59_;
		_tmp60_ = _f_list;
		_tmp61_ = vala_collection_get_size ((ValaCollection*) _tmp60_);
		_tmp62_ = _tmp61_;
		_f_size = _tmp62_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			ValaField* f = NULL;
			ValaList* _tmp66_;
			gint _tmp67_;
			gpointer _tmp68_;
			ValaField* _tmp69_;
			ValaCodeContext* _tmp70_;
			gboolean _tmp71_ = FALSE;
			ValaField* _tmp72_;
			ValaMemberBinding _tmp73_;
			ValaMemberBinding _tmp74_;
			gboolean _tmp82_ = FALSE;
			ValaField* _tmp83_;
			ValaMemberBinding _tmp84_;
			ValaMemberBinding _tmp85_;
			_tmp63_ = _f_index;
			_f_index = _tmp63_ + 1;
			_tmp64_ = _f_index;
			_tmp65_ = _f_size;
			if (!(_tmp64_ < _tmp65_)) {
				break;
			}
			_tmp66_ = _f_list;
			_tmp67_ = _f_index;
			_tmp68_ = vala_list_get (_tmp66_, _tmp67_);
			f = (ValaField*) _tmp68_;
			_tmp69_ = f;
			_tmp70_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp69_, _tmp70_);
			_tmp72_ = f;
			_tmp73_ = vala_field_get_binding (_tmp72_);
			_tmp74_ = _tmp73_;
			if (_tmp74_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp75_;
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				gboolean _tmp78_;
				_tmp75_ = f;
				_tmp76_ = vala_variable_get_variable_type ((ValaVariable*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_struct_is_recursive_value_type (self, _tmp77_);
				_tmp71_ = _tmp78_;
			} else {
				_tmp71_ = FALSE;
			}
			if (_tmp71_) {
				ValaField* _tmp79_;
				ValaSourceReference* _tmp80_;
				ValaSourceReference* _tmp81_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp79_ = f;
				_tmp80_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp79_);
				_tmp81_ = _tmp80_;
				vala_report_error (_tmp81_, "Recursive value types are not allowed");
				result = FALSE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp83_ = f;
			_tmp84_ = vala_field_get_binding (_tmp83_);
			_tmp85_ = _tmp84_;
			if (_tmp85_ == VALA_MEMBER_BINDING_INSTANCE) {
				ValaField* _tmp86_;
				ValaExpression* _tmp87_;
				ValaExpression* _tmp88_;
				_tmp86_ = f;
				_tmp87_ = vala_variable_get_initializer ((ValaVariable*) _tmp86_);
				_tmp88_ = _tmp87_;
				_tmp82_ = _tmp88_ != NULL;
			} else {
				_tmp82_ = FALSE;
			}
			if (_tmp82_) {
				ValaField* _tmp89_;
				ValaSourceReference* _tmp90_;
				ValaSourceReference* _tmp91_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp89_ = f;
				_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp89_);
				_tmp91_ = _tmp90_;
				vala_report_error (_tmp91_, "Instance field initializers not supported");
				result = FALSE;
				_vala_code_node_unref0 (f);
				_vala_iterable_unref0 (_f_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp92_;
		ValaList* _tmp93_;
		gint _c_size = 0;
		ValaList* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		gint _c_index = 0;
		_tmp92_ = self->priv->constants;
		_tmp93_ = _vala_iterable_ref0 (_tmp92_);
		_c_list = _tmp93_;
		_tmp94_ = _c_list;
		_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
		_tmp96_ = _tmp95_;
		_c_size = _tmp96_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp97_;
			gint _tmp98_;
			gint _tmp99_;
			ValaConstant* c = NULL;
			ValaList* _tmp100_;
			gint _tmp101_;
			gpointer _tmp102_;
			ValaConstant* _tmp103_;
			ValaCodeContext* _tmp104_;
			_tmp97_ = _c_index;
			_c_index = _tmp97_ + 1;
			_tmp98_ = _c_index;
			_tmp99_ = _c_size;
			if (!(_tmp98_ < _tmp99_)) {
				break;
			}
			_tmp100_ = _c_list;
			_tmp101_ = _c_index;
			_tmp102_ = vala_list_get (_tmp100_, _tmp101_);
			c = (ValaConstant*) _tmp102_;
			_tmp103_ = c;
			_tmp104_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp103_, _tmp104_);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp105_;
		ValaList* _tmp106_;
		gint _m_size = 0;
		ValaList* _tmp107_;
		gint _tmp108_;
		gint _tmp109_;
		gint _m_index = 0;
		_tmp105_ = self->priv->methods;
		_tmp106_ = _vala_iterable_ref0 (_tmp105_);
		_m_list = _tmp106_;
		_tmp107_ = _m_list;
		_tmp108_ = vala_collection_get_size ((ValaCollection*) _tmp107_);
		_tmp109_ = _tmp108_;
		_m_size = _tmp109_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			ValaMethod* m = NULL;
			ValaList* _tmp113_;
			gint _tmp114_;
			gpointer _tmp115_;
			ValaMethod* _tmp116_;
			ValaCodeContext* _tmp117_;
			_tmp110_ = _m_index;
			_m_index = _tmp110_ + 1;
			_tmp111_ = _m_index;
			_tmp112_ = _m_size;
			if (!(_tmp111_ < _tmp112_)) {
				break;
			}
			_tmp113_ = _m_list;
			_tmp114_ = _m_index;
			_tmp115_ = vala_list_get (_tmp113_, _tmp114_);
			m = (ValaMethod*) _tmp115_;
			_tmp116_ = m;
			_tmp117_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp116_, _tmp117_);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp118_;
		ValaList* _tmp119_;
		gint _prop_size = 0;
		ValaList* _tmp120_;
		gint _tmp121_;
		gint _tmp122_;
		gint _prop_index = 0;
		_tmp118_ = self->priv->properties;
		_tmp119_ = _vala_iterable_ref0 (_tmp118_);
		_prop_list = _tmp119_;
		_tmp120_ = _prop_list;
		_tmp121_ = vala_collection_get_size ((ValaCollection*) _tmp120_);
		_tmp122_ = _tmp121_;
		_prop_size = _tmp122_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp123_;
			gint _tmp124_;
			gint _tmp125_;
			ValaProperty* prop = NULL;
			ValaList* _tmp126_;
			gint _tmp127_;
			gpointer _tmp128_;
			ValaProperty* _tmp129_;
			ValaCodeContext* _tmp130_;
			_tmp123_ = _prop_index;
			_prop_index = _tmp123_ + 1;
			_tmp124_ = _prop_index;
			_tmp125_ = _prop_size;
			if (!(_tmp124_ < _tmp125_)) {
				break;
			}
			_tmp126_ = _prop_list;
			_tmp127_ = _prop_index;
			_tmp128_ = vala_list_get (_tmp126_, _tmp127_);
			prop = (ValaProperty*) _tmp128_;
			_tmp129_ = prop;
			_tmp130_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp129_, _tmp130_);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	_tmp132_ = vala_symbol_get_external ((ValaSymbol*) self);
	_tmp133_ = _tmp132_;
	if (!_tmp133_) {
		gboolean _tmp134_;
		gboolean _tmp135_;
		_tmp134_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp135_ = _tmp134_;
		_tmp131_ = !_tmp135_;
	} else {
		_tmp131_ = FALSE;
	}
	if (_tmp131_) {
		gboolean _tmp136_ = FALSE;
		gboolean _tmp137_ = FALSE;
		gboolean _tmp138_ = FALSE;
		gboolean _tmp139_ = FALSE;
		ValaDataType* _tmp140_;
		ValaDataType* _tmp141_;
		_tmp140_ = vala_struct_get_base_type (self);
		_tmp141_ = _tmp140_;
		if (_tmp141_ == NULL) {
			ValaList* _tmp142_;
			ValaList* _tmp143_;
			gint _tmp144_;
			gint _tmp145_;
			_tmp142_ = vala_struct_get_fields (self);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
			_tmp145_ = _tmp144_;
			_tmp139_ = _tmp145_ == 0;
			_vala_iterable_unref0 (_tmp143_);
		} else {
			_tmp139_ = FALSE;
		}
		if (_tmp139_) {
			gboolean _tmp146_;
			_tmp146_ = vala_struct_is_boolean_type (self);
			_tmp138_ = !_tmp146_;
		} else {
			_tmp138_ = FALSE;
		}
		if (_tmp138_) {
			gboolean _tmp147_;
			_tmp147_ = vala_struct_is_integer_type (self);
			_tmp137_ = !_tmp147_;
		} else {
			_tmp137_ = FALSE;
		}
		if (_tmp137_) {
			gboolean _tmp148_;
			_tmp148_ = vala_struct_is_floating_type (self);
			_tmp136_ = !_tmp148_;
		} else {
			_tmp136_ = FALSE;
		}
		if (_tmp136_) {
			ValaSourceReference* _tmp149_;
			ValaSourceReference* _tmp150_;
			const gchar* _tmp151_;
			const gchar* _tmp152_;
			gchar* _tmp153_;
			gchar* _tmp154_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp150_ = _tmp149_;
			_tmp151_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp152_ = _tmp151_;
			_tmp153_ = g_strdup_printf ("structs cannot be empty: %s", _tmp152_);
			_tmp154_ = _tmp153_;
			vala_report_error (_tmp150_, _tmp154_);
			_g_free0 (_tmp154_);
		} else {
			ValaDataType* _tmp155_;
			ValaDataType* _tmp156_;
			_tmp155_ = vala_struct_get_base_type (self);
			_tmp156_ = _tmp155_;
			if (_tmp156_ != NULL) {
				{
					ValaList* _f_list = NULL;
					ValaList* _tmp157_;
					ValaList* _tmp158_;
					gint _f_size = 0;
					ValaList* _tmp159_;
					gint _tmp160_;
					gint _tmp161_;
					gint _f_index = 0;
					_tmp157_ = self->priv->fields;
					_tmp158_ = _vala_iterable_ref0 (_tmp157_);
					_f_list = _tmp158_;
					_tmp159_ = _f_list;
					_tmp160_ = vala_collection_get_size ((ValaCollection*) _tmp159_);
					_tmp161_ = _tmp160_;
					_f_size = _tmp161_;
					_f_index = -1;
					while (TRUE) {
						gint _tmp162_;
						gint _tmp163_;
						gint _tmp164_;
						ValaField* f = NULL;
						ValaList* _tmp165_;
						gint _tmp166_;
						gpointer _tmp167_;
						ValaField* _tmp168_;
						ValaMemberBinding _tmp169_;
						ValaMemberBinding _tmp170_;
						_tmp162_ = _f_index;
						_f_index = _tmp162_ + 1;
						_tmp163_ = _f_index;
						_tmp164_ = _f_size;
						if (!(_tmp163_ < _tmp164_)) {
							break;
						}
						_tmp165_ = _f_list;
						_tmp166_ = _f_index;
						_tmp167_ = vala_list_get (_tmp165_, _tmp166_);
						f = (ValaField*) _tmp167_;
						_tmp168_ = f;
						_tmp169_ = vala_field_get_binding (_tmp168_);
						_tmp170_ = _tmp169_;
						if (_tmp170_ == VALA_MEMBER_BINDING_INSTANCE) {
							ValaSourceReference* _tmp171_;
							ValaSourceReference* _tmp172_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp172_ = _tmp171_;
							vala_report_error (_tmp172_, "derived structs may not have instance fields");
							_vala_code_node_unref0 (f);
							break;
						}
						_vala_code_node_unref0 (f);
					}
					_vala_iterable_unref0 (_f_list);
				}
			}
		}
	}
	_tmp173_ = context;
	_tmp174_ = vala_code_context_get_analyzer (_tmp173_);
	_tmp175_ = _tmp174_;
	_tmp176_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp175_, _tmp176_);
	_tmp177_ = context;
	_tmp178_ = vala_code_context_get_analyzer (_tmp177_);
	_tmp179_ = _tmp178_;
	_tmp180_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp179_, _tmp180_);
	_tmp181_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp182_ = _tmp181_;
	result = !_tmp182_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaDataType* vala_struct_get_base_type (ValaStruct* self) {
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	result = _tmp0_;
	return result;
}


void vala_struct_set_base_type (ValaStruct* self, ValaDataType* value) {
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp0_, (ValaCodeNode*) self);
	_tmp1_ = value;
	_tmp2_ = _vala_code_node_ref0 (_tmp1_);
	_vala_code_node_unref0 (self->priv->_base_type);
	self->priv->_base_type = _tmp2_;
}


ValaStruct* vala_struct_get_base_struct (ValaStruct* self) {
	ValaStruct* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	if (_tmp0_ != NULL) {
		ValaDataType* _tmp1_;
		ValaTypeSymbol* _tmp2_;
		ValaTypeSymbol* _tmp3_;
		_tmp1_ = self->priv->_base_type;
		_tmp2_ = vala_data_type_get_data_type (_tmp1_);
		_tmp3_ = _tmp2_;
		result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp3_) : NULL;
		return result;
	}
	result = NULL;
	return result;
}


ValaMethod* vala_struct_get_default_construction_method (ValaStruct* self) {
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}


void vala_struct_set_default_construction_method (ValaStruct* self, ValaMethod* value) {
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp1_;
}


gboolean vala_struct_get_is_immutable (ValaStruct* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaAttribute* _tmp1_;
		ValaAttribute* _tmp2_;
		gboolean _tmp3_;
		gboolean* _tmp4_;
		_tmp1_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_ != NULL;
		_tmp4_ = __bool_dup0 (&_tmp3_);
		_g_free0 (self->priv->_is_immutable);
		self->priv->_is_immutable = _tmp4_;
		_vala_code_node_unref0 (_tmp2_);
	}
	_tmp5_ = self->priv->_is_immutable;
	result = *_tmp5_;
	return result;
}


void vala_struct_set_is_immutable (ValaStruct* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp1_;
	_tmp2_ = value;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", _tmp2_, NULL);
}


gint vala_struct_get_width (ValaStruct* self) {
	gint result;
	gint* _tmp0_;
	gint* _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_width;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		_tmp1_ = vala_struct_is_integer_type (self);
		if (_tmp1_) {
			gint _tmp2_;
			gint* _tmp3_;
			_tmp2_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "IntegerType", "width", 32);
			_tmp3_ = __int_dup0 (&_tmp2_);
			_g_free0 (self->priv->_width);
			self->priv->_width = _tmp3_;
		} else {
			gint _tmp4_;
			gint* _tmp5_;
			_tmp4_ = vala_code_node_get_attribute_integer ((ValaCodeNode*) self, "FloatingType", "width", 32);
			_tmp5_ = __int_dup0 (&_tmp4_);
			_g_free0 (self->priv->_width);
			self->priv->_width = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_width;
	result = *_tmp6_;
	return result;
}


void vala_struct_set_width (ValaStruct* self, gint value) {
	gint _tmp0_;
	gint* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __int_dup0 (&_tmp0_);
	_g_free0 (self->priv->_width);
	self->priv->_width = _tmp1_;
	_tmp2_ = vala_struct_is_integer_type (self);
	if (_tmp2_) {
		gint _tmp3_;
		_tmp3_ = value;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "IntegerType", "width", _tmp3_, NULL);
	} else {
		gint _tmp4_;
		_tmp4_ = value;
		vala_code_node_set_attribute_integer ((ValaCodeNode*) self, "FloatingType", "width", _tmp4_, NULL);
	}
}


gboolean vala_struct_get_signed (ValaStruct* self) {
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_signed;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "IntegerType", "signed", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_signed);
		self->priv->_signed = _tmp2_;
	}
	_tmp3_ = self->priv->_signed;
	result = *_tmp3_;
	return result;
}


void vala_struct_set_signed (ValaStruct* self, gboolean value) {
	gboolean _tmp0_;
	gboolean* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = __bool_dup0 (&_tmp0_);
	_g_free0 (self->priv->_signed);
	self->priv->_signed = _tmp1_;
	_tmp2_ = value;
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "IntegerType", "signed", _tmp2_, NULL);
}


static void vala_struct_class_init (ValaStructClass * klass) {
	vala_struct_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_struct_finalize;
	g_type_class_add_private (klass, sizeof (ValaStructPrivate));
	((ValaSymbolClass *) klass)->add_constant = (void (*) (ValaSymbol *, ValaConstant*)) vala_struct_real_add_constant;
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol *, ValaField*)) vala_struct_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol *, ValaMethod*)) vala_struct_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol *, ValaProperty*)) vala_struct_real_add_property;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_struct_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_struct_real_accept_children;
	((ValaTypeSymbolClass *) klass)->get_type_parameter_index = (gint (*) (ValaTypeSymbol *, const gchar*)) vala_struct_real_get_type_parameter_index;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_struct_real_replace_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol *, ValaTypeSymbol*)) vala_struct_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_struct_real_check;
}


static void vala_struct_instance_init (ValaStruct * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	GEqualFunc _tmp8_;
	ValaArrayList* _tmp9_;
	self->priv = VALA_STRUCT_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_CONSTANT, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->constants = (ValaList*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_TYPE_FIELD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
	self->priv->fields = (ValaList*) _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_TYPE_METHOD, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp6_);
	self->priv->methods = (ValaList*) _tmp7_;
	_tmp8_ = g_direct_equal;
	_tmp9_ = vala_array_list_new (VALA_TYPE_PROPERTY, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp8_);
	self->priv->properties = (ValaList*) _tmp9_;
	self->priv->_base_type = NULL;
}


static void vala_struct_finalize (ValaCodeNode * obj) {
	ValaStruct * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_STRUCT, ValaStruct);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->constants);
	_vala_iterable_unref0 (self->priv->fields);
	_vala_iterable_unref0 (self->priv->methods);
	_vala_iterable_unref0 (self->priv->properties);
	_vala_code_node_unref0 (self->priv->_base_type);
	_g_free0 (self->priv->boolean_type);
	_g_free0 (self->priv->integer_type);
	_g_free0 (self->priv->floating_type);
	_g_free0 (self->priv->decimal_floating_type);
	_g_free0 (self->priv->simple_type);
	_g_free0 (self->priv->rank);
	_g_free0 (self->priv->_width);
	_g_free0 (self->priv->_signed);
	_g_free0 (self->priv->_is_immutable);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	VALA_CODE_NODE_CLASS (vala_struct_parent_class)->finalize (obj);
}


/**
 * Represents a struct declaration in the source code.
 */
GType vala_struct_get_type (void) {
	static volatile gsize vala_struct_type_id__volatile = 0;
	if (g_once_init_enter (&vala_struct_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaStructClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_struct_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaStruct), 0, (GInstanceInitFunc) vala_struct_instance_init, NULL };
		GType vala_struct_type_id;
		vala_struct_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaStruct", &g_define_type_info, 0);
		g_once_init_leave (&vala_struct_type_id__volatile, vala_struct_type_id);
	}
	return vala_struct_type_id__volatile;
}



