/* valaswitchstatement.c generated by valac, the Vala compiler
 * generated from valaswitchstatement.vala, do not modify */

/* valaswitchstatement.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaSwitchStatementPrivate {
	ValaExpression* _expression;
	ValaList* sections;
};


static gpointer vala_switch_statement_parent_class = NULL;
static ValaStatementIface * vala_switch_statement_vala_statement_parent_iface = NULL;

#define VALA_SWITCH_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatementPrivate))
static void vala_switch_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_switch_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_switch_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_switch_statement_real_check (ValaCodeNode* base, ValaCodeContext* context);
static void vala_switch_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen);
static void vala_switch_statement_finalize (ValaCodeNode * obj);


/**
 * Creates a new switch statement.
 *
 * @param expression       switch expression
 * @param source_reference reference to source code
 * @return                 newly created switch statement
 */
ValaSwitchStatement* vala_switch_statement_construct (GType object_type, ValaExpression* expression, ValaSourceReference* source_reference) {
	ValaSwitchStatement* self = NULL;
	ValaSourceReference* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (ValaSwitchStatement*) vala_code_node_construct (object_type);
	_tmp0_ = source_reference;
	vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp0_);
	_tmp1_ = expression;
	vala_switch_statement_set_expression (self, _tmp1_);
	return self;
}


ValaSwitchStatement* vala_switch_statement_new (ValaExpression* expression, ValaSourceReference* source_reference) {
	return vala_switch_statement_construct (VALA_TYPE_SWITCH_STATEMENT, expression, source_reference);
}


/**
 * Appends the specified section to the list of switch sections.
 *
 * @param section a switch section
 */
void vala_switch_statement_add_section (ValaSwitchStatement* self, ValaSwitchSection* section) {
	ValaSwitchSection* _tmp0_;
	ValaList* _tmp1_;
	ValaSwitchSection* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (section != NULL);
	_tmp0_ = section;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp0_, (ValaCodeNode*) self);
	_tmp1_ = self->priv->sections;
	_tmp2_ = section;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp2_);
}


/**
 * Returns a copy of the list of switch sections.
 *
 * @return section list
 */
static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList* vala_switch_statement_get_sections (ValaSwitchStatement* self) {
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->sections;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void vala_switch_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSwitchStatement * self;
	ValaCodeVisitor* _tmp0_;
	self = (ValaSwitchStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = visitor;
	vala_code_visitor_visit_switch_statement (_tmp0_, self);
}


static void vala_switch_statement_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaSwitchStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeVisitor* _tmp2_;
	ValaCodeVisitor* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	self = (ValaSwitchStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_switch_statement_get_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = visitor;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = visitor;
	_tmp4_ = vala_switch_statement_get_expression (self);
	_tmp5_ = _tmp4_;
	vala_code_visitor_visit_end_full_expression (_tmp3_, _tmp5_);
	{
		ValaList* _section_list = NULL;
		ValaList* _tmp6_;
		ValaList* _tmp7_;
		gint _section_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _section_index = 0;
		_tmp6_ = self->priv->sections;
		_tmp7_ = _vala_iterable_ref0 (_tmp6_);
		_section_list = _tmp7_;
		_tmp8_ = _section_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_section_size = _tmp10_;
		_section_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			ValaSwitchSection* section = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			ValaSwitchSection* _tmp17_;
			ValaCodeVisitor* _tmp18_;
			_tmp11_ = _section_index;
			_section_index = _tmp11_ + 1;
			_tmp12_ = _section_index;
			_tmp13_ = _section_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _section_list;
			_tmp15_ = _section_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			section = (ValaSwitchSection*) _tmp16_;
			_tmp17_ = section;
			_tmp18_ = visitor;
			vala_code_node_accept ((ValaCodeNode*) _tmp17_, _tmp18_);
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
}


static void vala_switch_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaSwitchStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaSwitchStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_switch_statement_get_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_node;
	if (_tmp1_ == _tmp2_) {
		ValaExpression* _tmp3_;
		_tmp3_ = new_node;
		vala_switch_statement_set_expression (self, _tmp3_);
	}
}


static gboolean vala_switch_statement_real_check (ValaCodeNode* base, ValaCodeContext* context) {
	ValaSwitchStatement * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCodeContext* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_ = FALSE;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	ValaDataType* _tmp40_;
	ValaDataType* _tmp41_;
	ValaDataType* _tmp42_;
	ValaDataType* _tmp43_;
	ValaExpression* _tmp44_;
	ValaExpression* _tmp45_;
	ValaDataType* _tmp46_;
	ValaDataType* _tmp47_;
	ValaHashSet* labelset = NULL;
	GHashFunc _tmp48_;
	GEqualFunc _tmp49_;
	ValaHashSet* _tmp50_;
	gboolean _tmp113_;
	gboolean _tmp114_;
	self = (ValaSwitchStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_switch_statement_get_expression (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = context;
	_tmp7_ = vala_code_node_check ((ValaCodeNode*) _tmp5_, _tmp6_);
	if (!_tmp7_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp9_ = vala_switch_statement_get_expression (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		_tmp15_ = vala_switch_statement_get_expression (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_expression_get_value_type (_tmp16_);
		_tmp18_ = _tmp17_;
		if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_INTEGER_TYPE)) {
			ValaExpression* _tmp19_;
			ValaExpression* _tmp20_;
			ValaDataType* _tmp21_;
			ValaDataType* _tmp22_;
			_tmp19_ = vala_switch_statement_get_expression (self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_expression_get_value_type (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp14_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaExpression* _tmp23_;
			ValaExpression* _tmp24_;
			ValaDataType* _tmp25_;
			ValaDataType* _tmp26_;
			ValaCodeContext* _tmp27_;
			ValaSemanticAnalyzer* _tmp28_;
			ValaSemanticAnalyzer* _tmp29_;
			ValaDataType* _tmp30_;
			gboolean _tmp31_;
			_tmp23_ = vala_switch_statement_get_expression (self);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_expression_get_value_type (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = context;
			_tmp28_ = vala_code_context_get_analyzer (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = _tmp29_->string_type;
			_tmp31_ = vala_data_type_compatible (_tmp26_, _tmp30_);
			_tmp13_ = !_tmp31_;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp8_ = _tmp13_;
	}
	if (_tmp8_) {
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaSourceReference* _tmp35_;
		_tmp32_ = vala_switch_statement_get_expression (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp33_);
		_tmp35_ = _tmp34_;
		vala_report_error (_tmp35_, "Integer or string expression expected");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp36_ = vala_switch_statement_get_expression (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_switch_statement_get_expression (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_expression_get_value_type (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = vala_data_type_copy (_tmp41_);
	_tmp43_ = _tmp42_;
	vala_expression_set_target_type (_tmp37_, _tmp43_);
	_vala_code_node_unref0 (_tmp43_);
	_tmp44_ = vala_switch_statement_get_expression (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_expression_get_target_type (_tmp45_);
	_tmp47_ = _tmp46_;
	vala_data_type_set_nullable (_tmp47_, FALSE);
	_tmp48_ = g_str_hash;
	_tmp49_ = g_str_equal;
	_tmp50_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp48_, _tmp49_);
	labelset = _tmp50_;
	{
		ValaList* _section_list = NULL;
		ValaList* _tmp51_;
		ValaList* _tmp52_;
		gint _section_size = 0;
		ValaList* _tmp53_;
		gint _tmp54_;
		gint _tmp55_;
		gint _section_index = 0;
		_tmp51_ = self->priv->sections;
		_tmp52_ = _vala_iterable_ref0 (_tmp51_);
		_section_list = _tmp52_;
		_tmp53_ = _section_list;
		_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
		_tmp55_ = _tmp54_;
		_section_size = _tmp55_;
		_section_index = -1;
		while (TRUE) {
			gint _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			ValaSwitchSection* section = NULL;
			ValaList* _tmp59_;
			gint _tmp60_;
			gpointer _tmp61_;
			ValaSwitchSection* _tmp62_;
			ValaCodeContext* _tmp63_;
			ValaSwitchSection* _tmp110_;
			ValaList* _tmp111_;
			ValaList* _tmp112_;
			_tmp56_ = _section_index;
			_section_index = _tmp56_ + 1;
			_tmp57_ = _section_index;
			_tmp58_ = _section_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _section_list;
			_tmp60_ = _section_index;
			_tmp61_ = vala_list_get (_tmp59_, _tmp60_);
			section = (ValaSwitchSection*) _tmp61_;
			_tmp62_ = section;
			_tmp63_ = context;
			vala_code_node_check ((ValaCodeNode*) _tmp62_, _tmp63_);
			{
				ValaList* _label_list = NULL;
				ValaSwitchSection* _tmp64_;
				ValaList* _tmp65_;
				gint _label_size = 0;
				ValaList* _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				gint _label_index = 0;
				_tmp64_ = section;
				_tmp65_ = vala_switch_section_get_labels (_tmp64_);
				_label_list = _tmp65_;
				_tmp66_ = _label_list;
				_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
				_tmp68_ = _tmp67_;
				_label_size = _tmp68_;
				_label_index = -1;
				while (TRUE) {
					gint _tmp69_;
					gint _tmp70_;
					gint _tmp71_;
					ValaSwitchLabel* label = NULL;
					ValaList* _tmp72_;
					gint _tmp73_;
					gpointer _tmp74_;
					ValaSwitchLabel* _tmp75_;
					ValaExpression* _tmp76_;
					ValaExpression* _tmp77_;
					_tmp69_ = _label_index;
					_label_index = _tmp69_ + 1;
					_tmp70_ = _label_index;
					_tmp71_ = _label_size;
					if (!(_tmp70_ < _tmp71_)) {
						break;
					}
					_tmp72_ = _label_list;
					_tmp73_ = _label_index;
					_tmp74_ = vala_list_get (_tmp72_, _tmp73_);
					label = (ValaSwitchLabel*) _tmp74_;
					_tmp75_ = label;
					_tmp76_ = vala_switch_label_get_expression (_tmp75_);
					_tmp77_ = _tmp76_;
					if (_tmp77_ != NULL) {
						gchar* value = NULL;
						ValaSwitchLabel* _tmp78_;
						ValaExpression* _tmp79_;
						ValaExpression* _tmp80_;
						gboolean _tmp100_ = FALSE;
						const gchar* _tmp101_;
						value = NULL;
						_tmp78_ = label;
						_tmp79_ = vala_switch_label_get_expression (_tmp78_);
						_tmp80_ = _tmp79_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp80_, VALA_TYPE_STRING_LITERAL)) {
							ValaSwitchLabel* _tmp81_;
							ValaExpression* _tmp82_;
							ValaExpression* _tmp83_;
							gchar* _tmp84_;
							_tmp81_ = label;
							_tmp82_ = vala_switch_label_get_expression (_tmp81_);
							_tmp83_ = _tmp82_;
							_tmp84_ = vala_string_literal_eval (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_STRING_LITERAL, ValaStringLiteral));
							_g_free0 (value);
							value = _tmp84_;
						} else {
							ValaSwitchLabel* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							_tmp85_ = label;
							_tmp86_ = vala_switch_label_get_expression (_tmp85_);
							_tmp87_ = _tmp86_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_LITERAL)) {
								ValaSwitchLabel* _tmp88_;
								ValaExpression* _tmp89_;
								ValaExpression* _tmp90_;
								gchar* _tmp91_;
								_tmp88_ = label;
								_tmp89_ = vala_switch_label_get_expression (_tmp88_);
								_tmp90_ = _tmp89_;
								_tmp91_ = vala_code_node_to_string ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_LITERAL, ValaLiteral));
								_g_free0 (value);
								value = _tmp91_;
							} else {
								ValaSwitchLabel* _tmp92_;
								ValaExpression* _tmp93_;
								ValaExpression* _tmp94_;
								gboolean _tmp95_;
								_tmp92_ = label;
								_tmp93_ = vala_switch_label_get_expression (_tmp92_);
								_tmp94_ = _tmp93_;
								_tmp95_ = vala_expression_is_constant (_tmp94_);
								if (_tmp95_) {
									ValaSwitchLabel* _tmp96_;
									ValaExpression* _tmp97_;
									ValaExpression* _tmp98_;
									gchar* _tmp99_;
									_tmp96_ = label;
									_tmp97_ = vala_switch_label_get_expression (_tmp96_);
									_tmp98_ = _tmp97_;
									_tmp99_ = vala_code_node_to_string ((ValaCodeNode*) _tmp98_);
									_g_free0 (value);
									value = _tmp99_;
								}
							}
						}
						_tmp101_ = value;
						if (_tmp101_ != NULL) {
							ValaHashSet* _tmp102_;
							const gchar* _tmp103_;
							gboolean _tmp104_;
							_tmp102_ = labelset;
							_tmp103_ = value;
							_tmp104_ = vala_collection_add ((ValaCollection*) _tmp102_, _tmp103_);
							_tmp100_ = !_tmp104_;
						} else {
							_tmp100_ = FALSE;
						}
						if (_tmp100_) {
							ValaSwitchLabel* _tmp105_;
							ValaExpression* _tmp106_;
							ValaExpression* _tmp107_;
							ValaSourceReference* _tmp108_;
							ValaSourceReference* _tmp109_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp105_ = label;
							_tmp106_ = vala_switch_label_get_expression (_tmp105_);
							_tmp107_ = _tmp106_;
							_tmp108_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp107_);
							_tmp109_ = _tmp108_;
							vala_report_error (_tmp109_, "Switch statement already contains this label");
						}
						_g_free0 (value);
					}
					_vala_code_node_unref0 (label);
				}
				_vala_iterable_unref0 (_label_list);
			}
			_tmp110_ = section;
			_tmp111_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp110_);
			_tmp112_ = _tmp111_;
			vala_code_node_add_error_types ((ValaCodeNode*) self, _tmp112_);
			_vala_iterable_unref0 (_tmp112_);
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
	_tmp113_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp114_ = _tmp113_;
	result = !_tmp114_;
	_vala_iterable_unref0 (labelset);
	return result;
}


static void vala_switch_statement_real_emit (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaSwitchStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCodeGenerator* _tmp2_;
	ValaCodeGenerator* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCodeGenerator* _tmp6_;
	self = (ValaSwitchStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_switch_statement_get_expression (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = codegen;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, _tmp2_);
	_tmp3_ = codegen;
	_tmp4_ = vala_switch_statement_get_expression (self);
	_tmp5_ = _tmp4_;
	vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) _tmp3_, _tmp5_);
	_tmp6_ = codegen;
	vala_code_visitor_visit_switch_statement ((ValaCodeVisitor*) _tmp6_, self);
}


ValaExpression* vala_switch_statement_get_expression (ValaSwitchStatement* self) {
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression;
	result = _tmp0_;
	return result;
}


static gpointer _vala_code_node_ref0 (gpointer self) {
	return self ? vala_code_node_ref (self) : NULL;
}


void vala_switch_statement_set_expression (ValaSwitchStatement* self, ValaExpression* value) {
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _vala_code_node_ref0 (_tmp0_);
	_vala_code_node_unref0 (self->priv->_expression);
	self->priv->_expression = _tmp1_;
	_tmp2_ = self->priv->_expression;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
}


static void vala_switch_statement_class_init (ValaSwitchStatementClass * klass) {
	vala_switch_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_switch_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaSwitchStatementPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_switch_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_switch_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_switch_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_switch_statement_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode *, ValaCodeGenerator*)) vala_switch_statement_real_emit;
}


static void vala_switch_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_switch_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_switch_statement_instance_init (ValaSwitchStatement * self) {
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_SWITCH_STATEMENT_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_SWITCH_SECTION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->sections = (ValaList*) _tmp1_;
}


static void vala_switch_statement_finalize (ValaCodeNode * obj) {
	ValaSwitchStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_SWITCH_STATEMENT, ValaSwitchStatement);
	_vala_code_node_unref0 (self->priv->_expression);
	_vala_iterable_unref0 (self->priv->sections);
	VALA_CODE_NODE_CLASS (vala_switch_statement_parent_class)->finalize (obj);
}


/**
 * Represents a switch selection statement in the source code.
 */
GType vala_switch_statement_get_type (void) {
	static volatile gsize vala_switch_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_switch_statement_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaSwitchStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_switch_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaSwitchStatement), 0, (GInstanceInitFunc) vala_switch_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_switch_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_switch_statement_type_id;
		vala_switch_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaSwitchStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_switch_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
		g_once_init_leave (&vala_switch_statement_type_id__volatile, vala_switch_statement_type_id);
	}
	return vala_switch_statement_type_id__volatile;
}



