# CiviCRM 5.24.0

Released April 1, 2020

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Menubar - Add "find menu item" search feature
  ([16597](https://github.com/civicrm/civicrm-core/pull/16597))**

  Adds a new "Find menu item" search under the "Home" (Civi logo) menu which
  allows user to locate menu items by typing a few letters.

- **Allow advanced search for contributions without a soft credit related
  ([dev/core#1386](https://lab.civicrm.org/dev/core/issues/1386):
  [15834](https://github.com/civicrm/civicrm-core/pull/15834) and
  [16622](https://github.com/civicrm/civicrm-core/pull/16622))**

  Improves the Advanced Search UI "Contributions" section "Contributions or Soft
  Credits?" field  field by adding a fifth option "Contributions without a soft
  credit" and updating the labels for the other options.

- **Allow payment processors to indicate whether they require an email address
  ([dev/core#1584](https://lab.civicrm.org/dev/core/issues/1584):
  [16503](https://github.com/civicrm/civicrm-core/pull/16503))**

  Adds a function to indicate whether a payment processor requires an email
  address which can be used to determine whether drupal webform should require
  an email address.

- **Show full description under select2 options
  ([dev/core#1587](https://lab.civicrm.org/dev/core/issues/1587):
  [16507](https://github.com/civicrm/civicrm-core/pull/16507) and
  [16510](https://github.com/civicrm/civicrm-core/pull/16510))**

  Improves the usability of Select-2 drop downs by displaying the
  full description in a tool tip when hovering over an option.

- **Migrate installers to "setup" API (Work Towards
  [dev/core#1615](https://lab.civicrm.org/dev/core/issues/1615):
  [16618](https://github.com/civicrm/civicrm-core/pull/16618))**

  Migrates `civicrm-setup` from its own git repo to `civicrm-core.git:setup/`.

- **APIv4-based smart groups
  ([16876](https://github.com/civicrm/civicrm-core/pull/16876),
  [16666](https://github.com/civicrm/civicrm-core/pull/16666) and
  [16834](https://github.com/civicrm/civicrm-core/pull/16834))**

  Allows smart groups to be created with APIv4 params in addition to via search
  form values. Adds a user interface to save smart groups from the APIv4
  explorer.

- **Style & layout clean up
  ([16680](https://github.com/civicrm/civicrm-core/pull/16680))**

  Improves the Contribution Invoice template by cleaning it up, improving
  the layout and making the CiviCRM logo comply with the display "empowered by
  CiviCRM" setting.

- **Relationship report - add sort order for end date
  ([16512](https://github.com/civicrm/civicrm-core/pull/16512))**

  Improves the Relationship report by making end date available as a field to
  sort by.

- **add column for report
  ([16523](https://github.com/civicrm/civicrm-core/pull/16523))**

  Adds "is active?" as an option for the "Columns" tab for the Relationship
  report.

- **Make php 7.3 the recommended php version
  ([16459](https://github.com/civicrm/civicrm-core/pull/16459))**

  Makes the recommended php version 7.3.

- **Increase php min recommended version
  ([16668](https://github.com/civicrm/civicrm-core/pull/16668))**

  Makes the minimum recommended php version 7.2 (it was 7.1).

- **Add pseudoconstant for priceset
  ([16665](https://github.com/civicrm/civicrm-core/pull/16665) and
  [16648](https://github.com/civicrm/civicrm-core/pull/16648))**

  Adds a pseudo constant for price set so that the API accepts `price_set_id` by
  name or id.

- **[Feature] Add in new hook alterUFFields to allow extensions to modify which
  fields can be added to a profile
  ([16655](https://github.com/civicrm/civicrm-core/pull/16655))**

  Adds a new hook `hook_civicrm_alterUFFields` which allows extensions to modify
  fields in a profile.

- **Enable the "sequentialcreditnotes" extension on new installations
  ([16598](https://github.com/civicrm/civicrm-core/pull/16598))**

  Ensures the new core extension `sequenttialcreditnotes` is added on upgrade
  AND install.

- **Move  settings definition on contribution settings form to metadata.
  ([16513](https://github.com/civicrm/civicrm-core/pull/16513))**

  Moves from hard coded settings on contribution settings forms to setting a
  spec for adding settings to a contribution form making it possible for
  extension developers to modify the settings using a hook (like the
  `sequentialcreditnotes` extension).

- **Making the poor performance associated with the `creditnote_id` field opt in
  rather than opt out (Work Towards
  [dev/financial#84](https://lab.civicrm.org/dev/financial/issues/84):
  [16531](https://github.com/civicrm/civicrm-core/pull/16531) and
  [16664](https://github.com/civicrm/civicrm-core/pull/16664))**

  Refactors code in preparation of make the credit note field opt in.
  Additionally, makes it possible to hide extensions by tagging them
  "mgmt:hidden" and hides the `sequentialcreditnotes` extension.

- **Upgrade Net_SMTP Package and remove now unneeded patches and move to using
  composer patches rather than patching in a script file
  ([16498](https://github.com/civicrm/civicrm-core/pull/16498))**

  Updates the `Net_SMTP` package to the latest version of the library and
  standardizes patches.

- **info.xml - Allow extensions to define a list of tags
  ([16551](https://github.com/civicrm/civicrm-core/pull/16551))**

  Makes it so that extension developers can register tags in the info.xml file.

- **Speed boost for civicrm/ajax/checkemail
  ([15824](https://github.com/civicrm/civicrm-core/pull/15824))**

  Performance improvement for `civicrm/ajax/checkemail` which is used when
  adding a cc email address to an email message among other places.

- **Improve activity query performance in Constituent Detail Report
  ([13078](https://github.com/civicrm/civicrm-core/pull/13078))**

  Improves performance of the "Constituent Detail Report" template.

- **Added conditional check so that it can be altered by hook
  ([16499](https://github.com/civicrm/civicrm-core/pull/16499))**

  Added a conditional check for printing blocks so that they can be easily
  altered by hooks.

- **Enable jQuery validate on register/contribution forms
  ([16494](https://github.com/civicrm/civicrm-core/pull/16494))**

  Makes jQuery validate available by default on frontend contribution /
  registration forms.

### CiviCase

- **Add ts() for a sentence 'Add to case as role'
  ([16630](https://github.com/civicrm/civicrm-core/pull/16630))**

  Improves translation by making the string 'Add to case as role'
  translatable.

- **Add CiviCase option for showing case activities in normal views
  ([16360](https://github.com/civicrm/civicrm-core/pull/16360))**

  Provides a setting controlling whether activities that belong to cases are
  visible outside of cases.

### CiviContribute

- **Proposal: Add in payment_processor-{payment processor type} class attribute
  to Radio HTML
  ([dev/financial#105](https://lab.civicrm.org/dev/financial/issues/105):
  [15940](https://github.com/civicrm/civicrm-core/pull/15940))**

  Adds a css class to each radio button for payment processor options so that
  they can be styled distinctly.

- **Payment edit link cannot be modified
  ([dev/financial#117](https://lab.civicrm.org/dev/financial/issues/117):
  [16504](https://github.com/civicrm/civicrm-core/pull/16504))**

  Makes it so the edit payment link on view of a Contribution can be modified by
  `hook_civicrm_links`.

- **Proposal - move source & received date to near the top on ContributionView
  form ([dev/financial#118](https://lab.civicrm.org/dev/financial/issues/118):
  [16565](https://github.com/civicrm/civicrm-core/pull/16565))**

  Improves the UI of Contributions in view mode by moving the source and date
  fields closer to the top.

### CiviMail

- **Pass template_type through to alterMailing hook
  ([16529](https://github.com/civicrm/civicrm-core/pull/16529))**

  Improves `hook_civicrm_alterMailing` by passing the `template_type`
  (traditional or mosaico).

### Drupal Integration

- **Use `civicrm-setup` to handle installation
  ([dev/drupal#4](https://lab.civicrm.org/dev/drupal/issues/4):
  [16628](https://github.com/civicrm/civicrm-core/pull/16628))**

  Improves the installation process for drupal 8 by making it so `civicrm-setup`
  reports the pending action.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Export Problems from Advanced Search - Searchable Numeric Fields Throw SQL
  Error & Not all Rows Exported
  ([CRM-607](https://issues.civicrm.org/jira/browse/CRM-607):
  [16627](https://github.com/civicrm/civicrm-core/pull/16627))**

  Fixes a syntax error for smart groups that reference custom fields that have
  been removed.

- **Do not CC or BCC (Event) Contribution invoice
  ([dev/core#1436](https://lab.civicrm.org/dev/core/issues/1436):
  [16005](https://github.com/civicrm/civicrm-core/pull/16005))**

  Ensures Contribution Invoices are not sent to the CC and BCC email address(s)
  configured for Event Confirmation purposes.

- **Group search form template does not add Datatables CSS classes (DT_RowClass)
  ([dev/core#1547](https://lab.civicrm.org/dev/core/issues/1547):
  [16359](https://github.com/civicrm/civicrm-core/pull/16359) and
  [16743](https://github.com/civicrm/civicrm-core/pull/16743))**

  Ensures child groups are nested on the Manage Groups form.

- **Multisite domain group fails on 5.20.0 (Work Towards
  [dev/core#1450](https://lab.civicrm.org/dev/core/issues/1450):
  [16095](https://github.com/civicrm/civicrm-core/pull/16095))**

  Improves performance of the multi site domain group to keep it from crashing
  on sites with large domain groups.

- **scheduled reminder: select participant role permissions require admin &
  don't match rest of scheduled reminder permissions
  ([dev/core#1568](https://lab.civicrm.org/dev/core/issues/1568):
  [16455](https://github.com/civicrm/civicrm-core/pull/16455))**

  Ensures that non-administrator users setting scheduled reminders can limit by
  participant role.

- **Custom Group Types not filterable
  ([dev/core#1577](https://lab.civicrm.org/dev/core/issues/1577):
  [16475](https://github.com/civicrm/civicrm-core/pull/16475))**

  Ensures that the "Custom Group Type" filter works on the "Manage Groups" form.

- **E_WARNING on New/Edit Tag screen
  ([dev/core#1593](https://lab.civicrm.org/dev/core/issues/1593) and
  [dev/core#1536](https://lab.civicrm.org/dev/core/issues/1536):
  [16554](https://github.com/civicrm/civicrm-core/pull/16554))**

  Fixes count E_WARNING on the Tag screen.

- **Extension unit tests broken in master
  ([dev/core#1594](https://lab.civicrm.org/dev/core/issues/1594):
  [16544](https://github.com/civicrm/civicrm-core/pull/16544))**

  Ensures extension unit tests run.

- **Undefined offset 0 in system check for custom fields after upgrade to 5.23
  ([dev/core#1636](https://lab.civicrm.org/dev/core/issues/1636):
  [16707](https://github.com/civicrm/civicrm-core/pull/16707))**

  Fixes an E_NOTICE "Undefined index 0 line 109 in
  CRM/Utils/Check/Component/Schema.php" when logging in to a site with smart
  groups that don't have `form_values[0]` (most likely made thru the API).

- **Fix SettingTrait YesNo translation
  ([16685](https://github.com/civicrm/civicrm-core/pull/16685))**

  Ensures "Yes/no" radio admin settings are correctly translated.

- **TokenProcessor - fix greetings tokens
  ([16624](https://github.com/civicrm/civicrm-core/pull/16624))**

  Ensure greetings tokens get populated as expected.

- **Contact Type Values with Cap in order to be well translated with ts()
  ([16638](https://github.com/civicrm/civicrm-core/pull/16638))**

  Ensures Contact Types get translated in the task menu.

- **CommunicationPreferences 'loclize' -> 'localize'
  ([16633](https://github.com/civicrm/civicrm-core/pull/16633))**

  Ensures the "Communication Preferences" field options get localized.

- **Convert civicrm_note.modified_date to timestamp
  ([16338](https://github.com/civicrm/civicrm-core/pull/16338))**

  Ensures the `civicrm_note.modified_date` field stores the date and time before
  this change this field only stored the date.

- **Fix two more php-finding regexes
  ([16606](https://github.com/civicrm/civicrm-core/pull/16606))**

  Ensures the APIv4 explorer loads regardless regardless of the enclosing path.

- **Settings Fix setting readonly attribute
  ([16451](https://github.com/civicrm/civicrm-core/pull/16451))**

  Ensures that when a setting is defined via "civicrm.settings.php" it is set to
  read only in the ui.

- **Fix issues with retrieving supportsTestMode/supportsLiveMode for payment
  processors ([15330](https://github.com/civicrm/civicrm-core/pull/15330))**

  Improves performance and ensures that one cannot select a live payment
  processor on the back end payment form in test mode.

- **State/province not copied on shared address
  ([dev/core#1605](https://lab.civicrm.org/dev/core/issues/1605):
  [16649](https://github.com/civicrm/civicrm-core/pull/16649))**

- **Activity Summary civireport gives fatal error when grouping activity date by
  quarter ([dev/core#1619](https://lab.civicrm.org/dev/core/issues/1619):
  [16643](https://github.com/civicrm/civicrm-core/pull/16643))**

- **Fix parameter format for upgrade call to install/enable
  sequentialcreditnotes
  ([16686](https://github.com/civicrm/civicrm-core/pull/16686))**

- **Activity Report: filtering by "is null" or "is not null" is ignored
  ([dev/core#1627](https://lab.civicrm.org/dev/core/issues/1627):
  [16672](https://github.com/civicrm/civicrm-core/pull/16672))**

- **Fix backoffice participant partial payments to be stdised & not miscalculate
  net_amount ([16442](https://github.com/civicrm/civicrm-core/pull/16442))**

- **Throwing API_Exception if file fails to copy when creating attachment
  ([16465](https://github.com/civicrm/civicrm-core/pull/16465))**

- **Do not enable core payment processor types that we believe likely don't work
  on new installs
  ([16362](https://github.com/civicrm/civicrm-core/pull/16362))**

- **Resolve notices if first donation amount and date columns were disabled
  ([16491](https://github.com/civicrm/civicrm-core/pull/16491))**

- **Allow any casting done in Type::validate to bubble up to
  Request::retrieveValue
  ([16525](https://github.com/civicrm/civicrm-core/pull/16525))**

- **Fix a PHP notice for users with limited permissions when loading a contact's
  summary ([16515](https://github.com/civicrm/civicrm-core/pull/16515))**

- **Do not fatally fail on angular pages if an extension is missing
  ([16533](https://github.com/civicrm/civicrm-core/pull/16533))**

- **fix contribution summary report's statistics when grouping and having
  ([16467](https://github.com/civicrm/civicrm-core/pull/16467))**

- **Fix smart group custom field check to cope with api error
  ([16750](https://github.com/civicrm/civicrm-core/pull/16750))**

- **Inline editing not working on admin option value-like screens
  ([dev/core#1651](https://lab.civicrm.org/dev/core/issues/1651):
  [16779](https://github.com/civicrm/civicrm-core/pull/16779) and
  [16791](https://github.com/civicrm/civicrm-core/pull/16791))**

- **Fix fatal error on loading extension page when an extension has been deleted
  ([16752](https://github.com/civicrm/civicrm-core/pull/16752))**

- **Can't install 5.23 in another language
  ([dev/translation#40](https://lab.civicrm.org/dev/translation/issues/40):
  [16842](https://github.com/civicrm/civicrm-core/pull/16842))**

- **Don't cache the full path of extensions so they don't break with dynamic
  paths
  ([dev/cloud-native#21](https://lab.civicrm.org/dev/cloud-native/issues/21):
  [15410](https://github.com/civicrm/civicrm-core/pull/15410))**

- **Monetary Amount Display setting not respected for price set totals
  ([dev/core#1019](https://lab.civicrm.org/dev/core/issues/1019):
  [16487](https://github.com/civicrm/civicrm-core/pull/16487))**

- **mailing label primary address selection ignored if global option
  searchPrimaryDetailsOnly disabled
  ([dev/core#1158](https://lab.civicrm.org/dev/core/issues/1158):
  [14928](https://github.com/civicrm/civicrm-core/pull/14928) and
  [16640](https://github.com/civicrm/civicrm-core/pull/16640))**

- **APIv4 - Correctly return null values from DAO save actions
  ([16645](https://github.com/civicrm/civicrm-core/pull/16645))**

- **Api4 - Display sql errors in explorer
  ([16641](https://github.com/civicrm/civicrm-core/pull/16641))**

- **"DB Error: unknown error" when merging if duplicate contact has null
  created_date ([dev/core#1589](https://lab.civicrm.org/dev/core/issues/1589):
  [16543](https://github.com/civicrm/civicrm-core/pull/16543))**

- **Exporting contacts via membership dashboard click through selects all
  contacts in database
  ([dev/user-interface#14](https://lab.civicrm.org/dev/user-interface/issues/14):
  [16763](https://github.com/civicrm/civicrm-core/pull/16763) and
  [16933](https://github.com/civicrm/civicrm-core/pull/16933))**

  Fixes a bug where the links from the membership dashboard 'appear to work' but
  then don't work in export.

### CiviCampaign

- **Secondarily order campaign dashboard by id
  ([15316](https://github.com/civicrm/civicrm-core/pull/15316))**

  Improves the "Campaign Dashboard" by organizing Campaigns by Start Date and
  then Id so that if campaigns are rapidly added they show up in the correct
  order.

### CiviCase

- **Case Activities Report includes core activities *always*
  ([dev/core#1366](https://lab.civicrm.org/dev/core/issues/1366):
  [16669](https://github.com/civicrm/civicrm-core/pull/16669),
  [16660](https://github.com/civicrm/civicrm-core/pull/16660) and
  [15998](https://github.com/civicrm/civicrm-core/pull/15998))**

  Improves printing/generating the Case Activity Audit by skipping a screen
  that does not work and cleaning up the code.

- **Incorrect boolean comparisons in ang/crmCaseType/list.html for is_active and
  is_reserved ([dev/core#1451](https://lab.civicrm.org/dev/core/issues/1451):
  [16035](https://github.com/civicrm/civicrm-core/pull/16035))**

  Ensures the correct drop down actions are displayed on the case type listing
  screen.

- **My Case dashlet doesn't sort by name but contact_id instead
  ([dev/core#1623](https://lab.civicrm.org/dev/core/issues/1623):
  [16647](https://github.com/civicrm/civicrm-core/pull/16647))**

  Ensures the case dashlet sorts by contact sort name.

- **Remove hardcoded settings from form and use SettingForm.tpl for Case
  settings ([16600](https://github.com/civicrm/civicrm-core/pull/16600))**

- **Adding a timeline to a case doesn't get the last activity in the timeline
  right ([dev/core#1675](https://lab.civicrm.org/dev/core/issues/1675):
  [16926](https://github.com/civicrm/civicrm-core/pull/16926))**

### CiviContribute

- **when importing contributions, can't match contact on phone number
  ([dev/core#1438](https://lab.civicrm.org/dev/core/issues/1438):
  [16009](https://github.com/civicrm/civicrm-core/pull/16009))**

  Ensures when importing contributions, phone number is listed as a field to
  match on and that matching via phone number works as expected.

- **Invoice does not assign/display the contact's country
  ([dev/financial#109](https://lab.civicrm.org/dev/financial/issues/109):
  [15964](https://github.com/civicrm/civicrm-core/pull/15964))**

- **CRM_Utils_Money::equals should round to monetary values then compare, not do
  a difference comparison.
  ([dev/financial#104](https://lab.civicrm.org/dev/financial/issues/104):
  [15856](https://github.com/civicrm/civicrm-core/pull/15856))**

- **Count refunds when calculating amount due for an invoice
  ([16506](https://github.com/civicrm/civicrm-core/pull/16506))**

### CiviMail

- **Unsubscribe broken on multilingual sites -- may cause mass unsubscribes to
  all groups ([dev/core#1622](https://lab.civicrm.org/dev/core/issues/1622):
  [16634](https://github.com/civicrm/civicrm-core/pull/16634))**

### CiviMember

- **Deleting memberships does not delete its related line item.
  ([dev/membership#17](https://lab.civicrm.org/dev/membership/issues/17):
  [15859](https://github.com/civicrm/civicrm-core/pull/15859))**

- **Related / Inherited Memberships: Custom fields not filled with data
  ([dev/core#1365](https://lab.civicrm.org/dev/core/issues/1365):
  [15884](https://github.com/civicrm/civicrm-core/pull/15884))**

### Backdrop Integration

- **bin/*, extern/* - Fix leak of "$config" in global namespace backdrop
  ([16702](https://github.com/civicrm/civicrm-core/pull/16702))**

  This removes the `$config` variable from some pre CMS boot locations to avoid
  issues with backdrop compatability.

### Drupal Integration

- **Multi-select custom data shows values not labels in drupal user record
  ([CRM-984](https://issues.civicrm.org/jira/browse/CRM-984):
  [549](https://github.com/civicrm/civicrm-drupal/pull/549))**

  Ensures that the "Add CiviCRM Tag to Contact" action lists Tags as options
  instead of Groups.

- **Check email when creating a user in drupal 8
  ([15390](https://github.com/civicrm/civicrm-core/pull/15390))**

  Ensures when creating a new Drupal8 user via a CiviCRM profile, the email
  address entered is validated as a unique user email.

- **`E2E_Cache_*Test` raises dependency-hell in D8
  ([dev/core#1562](https://lab.civicrm.org/dev/core/issues/1562):
  [16522](https://github.com/civicrm/civicrm-core/pull/16522))**

### Joomla Integration

- **CiviCRM upgrade to 5.23.0 breaks payment processor
  ([dev/financial#120](https://lab.civicrm.org/dev/financial/issues/120):
  [16761](https://github.com/civicrm/civicrm-core/pull/16761))**

  Fixes loading of several javascript and css assets on front end pages (such as
  the contribution page) in Joomla.

- **CiviCRM menu disappears and upgrade to 5.23.x fails if Joomla is in a folder
  below the website.
  ([dev/joomla#26](https://lab.civicrm.org/dev/joomla/issues/26):
  [16887](https://github.com/civicrm/civicrm-core/pull/16887))**

### WordPress Integration

- **5.23 breaks WP admin menu links
  ([dev/core#1637](https://lab.civicrm.org/dev/core/issues/1637):
  [16721](https://github.com/civicrm/civicrm-core/pull/16721),
  [16735](https://github.com/civicrm/civicrm-core/pull/16735))**

- **Fix display of administrator permissions in WordPress Multisite
  ([dev/core#1628](https://lab.civicrm.org/dev/core/issues/1628):
  [16675](https://github.com/civicrm/civicrm-core/pull/16675))**

  Ensures that users with the role "Network
  Administrator" can limit the permissions for users with the role "Site
  Administrator" for WordPress with Multisite.

- **Fix synchronisation of Users to Contacts in WordPress Multisite
  ([dev/core#1629](https://lab.civicrm.org/dev/core/issues/1629):
  [16676](https://github.com/civicrm/civicrm-core/pull/16676))**

  For WordPress Multisite's ensures that only users of a particular sub site are
  synced to CiviCRM for that sub site.

## <a name="misc"></a>Miscellany

- **Update CKEditor 4.14
  ([16841](https://github.com/civicrm/civicrm-core/pull/16841))**

- **Remove fatal  from  form
  ([16500](https://github.com/civicrm/civicrm-core/pull/16500))**

- **Add deprecation notices on PartialAmount params
  ([16505](https://github.com/civicrm/civicrm-core/pull/16505))**

- **fix headers ([16492](https://github.com/civicrm/civicrm-core/pull/16492))**

- **API Kernel - cleanup deprecated fn & unused param
  ([16511](https://github.com/civicrm/civicrm-core/pull/16511))**

- **Common.js - remove duplicate function
  ([16508](https://github.com/civicrm/civicrm-core/pull/16508))**

- **Fix calls to Request::retrieve
  ([16526](https://github.com/civicrm/civicrm-core/pull/16526))**

- **APIv4 - merge ActionUtil with Request::create
  ([16516](https://github.com/civicrm/civicrm-core/pull/16516))**

- **Fix year typo.
  ([16486](https://github.com/civicrm/civicrm-core/pull/16486))**

- **Remove reference to mysql 5.0 & 5.1
  ([16539](https://github.com/civicrm/civicrm-core/pull/16539))**

- **Change "Added By" to "Added by"
  ([16527](https://github.com/civicrm/civicrm-core/pull/16527))**

- **Remove old defines for flexmailer that haven't been required since CiviCRM
  5.x ([16528](https://github.com/civicrm/civicrm-core/pull/16528))**

- **Make savedSearch bao sane
  ([16575](https://github.com/civicrm/civicrm-core/pull/16575))**

- **Add deprecation notice
  ([16585](https://github.com/civicrm/civicrm-core/pull/16585))**

- **Move determination of year & month to formatCreditCardDetails
  ([16562](https://github.com/civicrm/civicrm-core/pull/16562))**

- **Add description to params for api3 Payment.get
  ([16602](https://github.com/civicrm/civicrm-core/pull/16602))**

- **Move sequentialcreditnotes under `ext/` folder
  ([16616](https://github.com/civicrm/civicrm-core/pull/16616))**

- **Removed Invalid Parameter from function doc
  ([16631](https://github.com/civicrm/civicrm-core/pull/16631))**

- **civicrm.settings.php.template - Simplify examples of `$civicrm_setting`
  ([16636](https://github.com/civicrm/civicrm-core/pull/16636))**

- **Remove unused columns from civicrm_saved_search
  ([16637](https://github.com/civicrm/civicrm-core/pull/16637))**

- **News dashboard - Code cleanup to update js & css
  ([16632](https://github.com/civicrm/civicrm-core/pull/16632))**

- **Fix mistake in comment
  ([16657](https://github.com/civicrm/civicrm-core/pull/16657))**

- **Remove helper function now that contribution settings is not weirdly stored
  ([16566](https://github.com/civicrm/civicrm-core/pull/16566))**

- **added sudo constant for sms api type
  ([16679](https://github.com/civicrm/civicrm-core/pull/16679))**

- **Add setEntityId() to entityForm
  ([16020](https://github.com/civicrm/civicrm-core/pull/16020))**

- **Remove deprecated function CRM_Contact_BAO_GroupContactCache::remove
  ([16682](https://github.com/civicrm/civicrm-core/pull/16682))**

- **Ancient switch statement that provides hardcoded translation doesn't do
  anything anymore
  ([dev/translation#37](https://lab.civicrm.org/dev/translation/issues/37):
  [16619](https://github.com/civicrm/civicrm-core/pull/16619))**

- **Cleanup copyValues DAO function
  ([16589](https://github.com/civicrm/civicrm-core/pull/16589))**

- **Remove unused code
  ([16493](https://github.com/civicrm/civicrm-core/pull/16493))**

- **remove unnecessary file
  ([16502](https://github.com/civicrm/civicrm-core/pull/16502))**

- **[REF] Fix static call to non-static function.
  ([16552](https://github.com/civicrm/civicrm-core/pull/16552))**

- **[REF] Change function signature to support moving this off the form layer
  ([16677](https://github.com/civicrm/civicrm-core/pull/16677))**

- **[REF] Remove FPDI library from packages as it is deployed by composer
  ([287](https://github.com/civicrm/civicrm-packages/pull/287))**

- **[REF] Use relative path for finding the advmultiseletct javascript
  ([286](https://github.com/civicrm/civicrm-packages/pull/286))**

- **[REF] Remove patch from dompdf cleanup script that is no longer needed
  ([16490](https://github.com/civicrm/civicrm-core/pull/16490))**

- **(REF) Move CIVICRM_MAIL_LOG logic from patch-files to wrapper-class
  ([16497](https://github.com/civicrm/civicrm-core/pull/16497))**

- **[REF] Remove never used property
  ([16540](https://github.com/civicrm/civicrm-core/pull/16540))**

- **([REF] Fix handling of owner url parameter from Membership Dashboard
  [16937](https://github.com/civicrm/civicrm-core/pull/16937))**

- **REF Refactor ActivityTokens to use a trait that can be shared with other
  entities ([16468](https://github.com/civicrm/civicrm-core/pull/16468))**

- **[REF] Extract function to getTransactionInfo
  ([16545](https://github.com/civicrm/civicrm-core/pull/16545))**

- **[REF] Update civicrm_generated following merge of #16362
  ([16605](https://github.com/civicrm/civicrm-core/pull/16605))**

- **[REF] Extract self-service eligibility code into its own function
  ([16615](https://github.com/civicrm/civicrm-core/pull/16615))**

- **[REF] Only call getACLs when contact_id is present, remove handling
  ([16667](https://github.com/civicrm/civicrm-core/pull/16667))**

- **[REF] Deprecate _html2pdf_tcpdf function in favour of _html2pdf_dompdf
  ([16662](https://github.com/civicrm/civicrm-core/pull/16662))**

- **[REF] simple function extraction
  ([16642](https://github.com/civicrm/civicrm-core/pull/16642))**

- **[REF] Removed unused function
  ([16663](https://github.com/civicrm/civicrm-core/pull/16663))**

- **[REF] Refactor adding payment processor radio section onto register and
  contribution main forms
  ([16595](https://github.com/civicrm/civicrm-core/pull/16595))**

- **[REF] Add in pre and post hooks to UFField Entity
  ([16653](https://github.com/civicrm/civicrm-core/pull/16653))**

- **[NFC] Use insert ignore for inserts into civicrm_extension to stop warnings
  on duplicate entry for sequential credit notes extension
  ([16644](https://github.com/civicrm/civicrm-core/pull/16644))**

- **[NFC] dev/core#1466 Update Documentation URLS to be the correct links in the
  security component check
  ([dev/core#1466](https://lab.civicrm.org/dev/core/issues/1466):
  [16085](https://github.com/civicrm/civicrm-core/pull/16085))**

- **[NFC] Convert Custom Field BAO file to use short array syntax
  ([16613](https://github.com/civicrm/civicrm-core/pull/16613))**

- **[NFC] dev/core#1621 Extend unit tests to ensure that entity financial
  account is correctly deleted when financial type is deleted
  ([dev/core#1621](https://lab.civicrm.org/dev/core/issues/1621):
  [16639](https://github.com/civicrm/civicrm-core/pull/16639))**

- **[NFC] Minor code cleanup
  ([16563](https://github.com/civicrm/civicrm-core/pull/16563))**

- **[NFC] Preliminary cleanup
  ([16557](https://github.com/civicrm/civicrm-core/pull/16557))**

- **(NFC) Fix typo - no hyphen in 'override'
  ([16571](https://github.com/civicrm/civicrm-core/pull/16571))**

- **(NFC) Remove `$Id$` from header
  ([16582](https://github.com/civicrm/civicrm-core/pull/16582))**

- **[NFC] Test cleanup.
  ([16581](https://github.com/civicrm/civicrm-core/pull/16581))**

- **[NFC] Add missing letter "h" in upgrade script for task description
  ([16687](https://github.com/civicrm/civicrm-core/pull/16687))**

- **[TEST] Unit test environment no longer working on windows after latest
  CodeGen updates
  ([dev/core#1572](https://lab.civicrm.org/dev/core/issues/1572):
  [16477](https://github.com/civicrm/civicrm-core/pull/16477))**

- **[TEST] CRM_Event_BAO_AdditionalPaymentTest::testAddPartialPayment should
  have status transition checks fixed & enabled
  ([dev/financial#102](https://lab.civicrm.org/dev/financial/issues/102):
  [16564](https://github.com/civicrm/civicrm-core/pull/16564))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

a-n The Artists Information Company - William Mortada; AGH Strategies - Alice
Frumin, Andrew Hunt; Agileware - Agileware Team, Francis Whittle; Alexy
Mikhailichenko; breheret; Calibrate - Wouter Hechtermans; CEPR - Josh Brown;
Chris Burgess; Christian Wach; Circle Interactive - Pradeep Nayak; CiviCoop -
Klaas Eikelboom; CiviCRM - Coleman Watts, Tim Otten; CiviDesk - Yashodha Chaku;
Coop SymbioTIC - Mathieu Lutfy; Dave D; Electronic Frontier Foundation - Mark
Burdett; Francesc Bassas i Bullich; Freeform Solutions - Herb van den Dool;
Fuzion - Jitendra Purohit; Greenpeace Central and Eastern Europe - Patrick
Figel; GMCVO Databases - Jade Gaunt; iXiam - Luciano Spiegel; Jens Schuppe; JMA
Consulting - Monish Deb, Seamus Lee; Kartik Kathuria; Lighthouse Design and
Consulting - Brian Shaughnessy; Makoa - Usha F. Matisson; Megaphone Technology
Consulting - Jon Goldberg; MJW Consulting - Matthew Wire; Progressive Technology
Project - Jamie McClelland; Richard van Oosterhout; Roomify, LLC - Adrian
Rollett; Squiffle Consulting - Aidan Saunders; Tadpole Collective - Kevin
Cristiano; Wikimedia Foundation - Eileen McNaughton, Elliott Eggleston, Maggie
Epps

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

a-n The Artists Information Company - William Mortada; Agileware - Justin
Freeman; Andrew Cormick-Dockery; Artful Robot - Rich Lott; Betty Dolfing;
British Humanist Association - Andrew West; CiviCoop - Jaap Jansma, Matthijs
Keijser;  CiviDesk - Sunil Pawar; Joinery - Allen Shaw; MJCO - Mikey O'Toole;
Simon John Parker; Third Sector Design - Michael McAndrew;

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andrew Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
