# RUN: %fish %s
# REQUIRES: command -v sphinx-build

mkdir -p man/man1

echo >man/man1/dirname.1 '
.SH NAME
dirname \- strip last component from file name
.SH DESCRIPTION
.PP
Output each NAME with its last non\-slash component and trailing slashes
.TP
\fB\-z\fR, \fB\-\-zero\fR
end each output line with NUL, not newline
'

MANPATH=$PWD/man fish_update_completions
# CHECK: Parsing man pages and writing completions to {{.*}}/generated_completions/
# CHECK: {{.*}}  1 / 1 : dirname.1{{.*}}

cd $__fish_cache_dir
find . -type f
# CHECK: ./generated_completions/dirname.fish

cat ./generated_completions/dirname.fish
# CHECK: # dirname
# CHECK: # Autogenerated from man page {{.*}}/man/man1/dirname.1
# CHECK: complete -c dirname -s z -l zero -d 'end each output line with NUL, not newline'
