---
title: Akatab - Design and Type Sample
fontversion: 3.000
---

Akatab (“writing”) is designed to reflect a handwriting style and even the “writing in sand” effect. 

Six weights for this typeface family are included:

- Akatab Regular
- Akatab Medium
- Akatab SemiBold
- Akatab Bold
- Akatab ExtraBold
- Akatab Black

The full range of weights is accessed in different ways depending on the application. See [Using Axis-Based Font Families](https://software.sil.org/fonts/axis-based-fonts/) for details.

## Tifinagh:

<p> This section demonstrates all of the Tifinagh Unicode characters in the font, including those in a right-to-left design. Alternate glyphs that are available through features are demonstrated in the [Features](features.md) document. </p>

### Unicode characters

#### Regular:

<p><span class='akatab-R normal'> ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

<p style="text-align:right"><span class='akatab-R normal'> &#x202E; ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

#### Medium:

<p><span class='akatab-M normal'> ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

<p style="text-align:right"><span class='akatab-R normal'> &#x202E; ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

#### SemiBold:

<p><span class='akatab-SB normal'> ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

<p style="text-align:right"><span class='akatab-B normal'> &#x202E; ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

#### Bold:

<p><span class='akatab-B normal'> ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

<p style="text-align:right"><span class='akatab-B normal'> &#x202E; ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

#### ExtraBold:

<p><span class='akatab-EB normal'> ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

<p style="text-align:right"><span class='akatab-B normal'> &#x202E; ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

#### Black:

<p><span class='akatab-BL normal'> ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

<p style="text-align:right"><span class='akatab-B normal'> &#x202E; ⴰ ⴱ ⴳ ⴴ ⴶ ⴷ ⴸ ⴹ ⴼ ⴾ ⵀ ⵂ ⵆ ⵈ ⵉ ⵋ ⵌ ⵍ ⵎ ⵏ ⵐ ⵑ ⵓ ⵔ ⵗ ⵘ ⵙ ⵛ ⵜ ⵟ ⵢ ⵣ ⵤ ⵧ ⵰ &#x25cc;&#x2D7F; </span></p>

### Biconsonant ligatures

#### Regular:

<p><span class='akatab-R normal'> ⴱ⵿ⵜ ⴴ⵿ⵜ ⴶ⵿ⵜ ⴼ⵿ⵜ ⵀ⵿ⵜ ⵉ⵿ⵜ ⵋ⵿ⵜ ⵌ⵿ⵜ ⵍ⵿ⴾ ⵍ⵿ⵜ ⵎ⵿ⵀ ⵎ⵿ⵙ ⵎ⵿ⵜ ⵏ⵿ⴴ ⵏ⵿ⴶ ⵏ⵿ⴷ ⵏ⵿ⴸ ⵏ⵿ⴹ ⵏ⵿ⴼ ⵏ⵿ⴼ⵿ⵜ ⵏ⵿ⴾ ⵏ⵿ⵌ ⵏ⵿ⵗ ⵏ⵿ⵙ ⵏ⵿ⵛ ⵏ⵿ⵜ ⵏ⵿ⵤ ⵓ⵿ⵜ ⵔ⵿ⴾ ⵔ⵿ⵏ ⵔ⵿ⵜ ⵙ⵿ⴾ ⵙ⵿ⵏ ⵙ⵿ⵜ ⵛ⵿ⴾ ⵛ⵿ⵏ ⵛ⵿ⵜ ⵣ⵿ⵜ </span></p>

<p style="text-align:right"><span class='akatab-R normal'> &#x202E; ⴱ⵿ⵜ ⴴ⵿ⵜ ⴶ⵿ⵜ ⴼ⵿ⵜ ⵀ⵿ⵜ ⵉ⵿ⵜ ⵋ⵿ⵜ ⵌ⵿ⵜ ⵍ⵿ⴾ ⵍ⵿ⵜ ⵎ⵿ⵀ ⵎ⵿ⵙ ⵎ⵿ⵜ ⵏ⵿ⴴ ⵏ⵿ⴶ ⵏ⵿ⴷ ⵏ⵿ⴸ ⵏ⵿ⴹ ⵏ⵿ⴼ ⵏ⵿ⴾ ⵏ⵿ⵌ ⵏ⵿ⵗ ⵏ⵿ⵙ ⵏ⵿ⵛ ⵏ⵿ⵜ ⵏ⵿ⵤ ⵓ⵿ⵜ ⵔ⵿ⴾ ⵔ⵿ⵏ ⵔ⵿ⵜ ⵙ⵿ⴾ ⵙ⵿ⵏ ⵙ⵿ⵜ ⵛ⵿ⴾ ⵛ⵿ⵏ ⵛ⵿ⵜ ⵣ⵿ⵜ </span></p>

#### Bold:

<p><span class='akatab-B normal'> ⴱ⵿ⵜ ⴴ⵿ⵜ ⴶ⵿ⵜ ⴼ⵿ⵜ ⵀ⵿ⵜ ⵉ⵿ⵜ ⵋ⵿ⵜ ⵌ⵿ⵜ ⵍ⵿ⴾ ⵍ⵿ⵜ ⵎ⵿ⵀ ⵎ⵿ⵙ ⵎ⵿ⵜ ⵏ⵿ⴴ ⵏ⵿ⴶ ⵏ⵿ⴷ ⵏ⵿ⴸ ⵏ⵿ⴹ ⵏ⵿ⴼ ⵏ⵿ⴼ⵿ⵜ ⵏ⵿ⴾ ⵏ⵿ⵌ ⵏ⵿ⵗ ⵏ⵿ⵙ ⵏ⵿ⵛ ⵏ⵿ⵜ ⵏ⵿ⵤ ⵓ⵿ⵜ ⵔ⵿ⴾ ⵔ⵿ⵏ ⵔ⵿ⵜ ⵙ⵿ⴾ ⵙ⵿ⵏ ⵙ⵿ⵜ ⵛ⵿ⴾ ⵛ⵿ⵏ ⵛ⵿ⵜ ⵣ⵿ⵜ </span></p>

<p style="text-align:right"><span class='akatab-B normal'> &#x202E; ⴱ⵿ⵜ ⴴ⵿ⵜ ⴶ⵿ⵜ ⴼ⵿ⵜ ⵀ⵿ⵜ ⵉ⵿ⵜ ⵋ⵿ⵜ ⵌ⵿ⵜ ⵍ⵿ⴾ ⵍ⵿ⵜ ⵎ⵿ⵀ ⵎ⵿ⵙ ⵎ⵿ⵜ ⵏ⵿ⴴ ⵏ⵿ⴶ ⵏ⵿ⴷ ⵏ⵿ⴸ ⵏ⵿ⴹ ⵏ⵿ⴼ ⵏ⵿ⴾ ⵏ⵿ⵌ ⵏ⵿ⵗ ⵏ⵿ⵙ ⵏ⵿ⵛ ⵏ⵿ⵜ ⵏ⵿ⵤ ⵓ⵿ⵜ ⵔ⵿ⴾ ⵔ⵿ⵏ ⵔ⵿ⵜ ⵙ⵿ⴾ ⵙ⵿ⵏ ⵙ⵿ⵜ ⵛ⵿ⴾ ⵛ⵿ⵏ ⵛ⵿ⵜ ⵣ⵿ⵜ </span></p>

### Raised characters
<p><span class="akatab-R normal"> ⵏⵏⵏ ⵏⵍⵏ ⵍⵍⵍ ⵍⵏⵍ </span></p>

## Private Use Area (PUA) characters

### Tifinagh superscripts
<p style="font-size:13px; ">These superscript characters correspond to U+E300 – U+E304 respectively and are shown between Tifinagh characters for clarity. They are used as aids in literacy.</p>  
<p><span class="akatab-R normal"> ⵏⵏ  ⵏⵏ  ⵏⵏ  ⵏⵏ  ⵏⵏ </span></p>

## Special use ligatures and diacritic marks
<p style="font-size:13px; ">These ligatures and diacritic marks are used as aids in literacy and linguistic research.</p>  

### SIL vowels (Niger)
<p style="font-size:13px; ">Type the Tifinagh character followed by the appropriate combining circumflex (U+0302), breve (U+0306) or dot below (U+0323).</p>
<p><span class="akatab-R normal"> ⴰ̂ ⴰ̆ ⵓ̂ ⵢ̂ ⵢ̣ ⵧ̂ </span></p>

### Diacritics
<p style="font-size:13px; ">Type any Tifinagh consonant followed by either a combining acute (U+0301), tilde (U+0303) or ring above (U+030A).</p> 
<p><span class="akatab-R normal"> ⵗ́ ⴾ́ ⵈ́ ⵆ́ ⵂ́ ⴱ́ ⵀ́ ⵔ́ ⵙ́ ⴷ́ ⴸ́ ⴹ́ ⵎ́ ⵟ́ ⴼ́ ⵢ́ ⵉ́ ⴴ́ ⴶ́ ⵑ́ ⵏ́ ⵍ́ ⵐ́ ⵛ́ ⵜ́ ⵓ́ ⵌ́ ⵣ́ ⵋ́ </span></p> 
<p><span class="akatab-R normal"> ⵗ̃ ⴾ̃ ⵈ̃ ⵆ̃ ⵂ̃ ⴱ̃ ⵀ̃ ⵔ̃ ⵙ̃ ⴷ̃ ⴸ̃ ⴹ̃ ⵎ̃ ⵟ̃ ⴼ̃ ⵢ̃ ⵉ̃ ⴴ̃ ⴶ̃ ⵑ̃ ⵏ̃ ⵍ̃ ⵐ̃ ⵛ̃ ⵜ̃ ⵓ̃ ⵌ̃ ⵣ̃ ⵋ̃ </span></p> 
<p><span class="akatab-R normal"> ⵗ̇ ⴾ̇ ⵈ̇ ⵆ̇ ⵂ̇ ⴱ̇ ⵀ̇ ⵔ̇ ⵙ̇ ⴷ̇ ⴸ̇ ⴹ̇ ⵎ̇ ⵟ̇ ⴼ̇ ⵢ̇ ⵉ̇ ⴴ̇ ⴶ̇ ⵑ̇ ⵏ̇ ⵍ̇ ⵐ̇ ⵛ̇ ⵜ̇ ⵓ̇ ⵌ̇ ⵣ̇ ⵋ̇ </span></p>


## Latin, punctuation and other specials:

<p> This section demonstrates all of the Latin, punctuation and other special *visible* characters in the font. It is organized by Unicode block. *Note: Inclusion of basic Latin repertoire is provided as a convenience but is not intended for extensive Latin script use.* </p>

### Basic Latin:

Regular: <span class='akatab-R normal'>! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~</span>

**Bold:** <span class='akatab-B normal'>! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < = > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~</span>

### Latin-1 Supplement:

Regular: <span class='akatab-R normal'> &#x00A0; ¡ ¢ £ ¤ ¥ ¦ § ¨ © ª « ¬ ­ ® ¯ ° ± ² ³ ´ µ ¶ · ¸ ¹ º » ¼ ½ ¾ ¿ À Á Â Ã Ä Å Æ Ç È É Ê Ë Ì Í Î Ï Ñ Ò Ó Ô Õ Ö × Ø Ù Ú Û Ü Ý Þ ß à á â ã ä å æ ç è é ê ë ì í î ï ñ ò ó ô õ ö ÷ ø ù ú û ü ý þ ÿ</span>

**Bold:** <span class='akatab-B normal'> &#x00A0; ¡ ¢ £ ¤ ¥ ¦ § ¨ © ª « ¬ ­ ® ¯ ° ± ² ³ ´ µ ¶ · ¸ ¹ º » ¼ ½ ¾ ¿ À Á Â Ã Ä Å Æ Ç È É Ê Ë Ì Í Î Ï Ñ Ò Ó Ô Õ Ö × Ø Ù Ú Û Ü Ý Þ ß à á â ã ä å æ ç è é ê ë ì í î ï ñ ò ó ô õ ö ÷ ø ù ú û ü ý þ ÿ</span>

### Latin Extended-A:

Regular: <span class='akatab-R normal'> Ă ă Ĕ ĕ Ĭ ĭ ı Ŋ ŋ Ŏ ŏ Œ œ Š š Ŭ ŭ Ÿ Ž ž </span>

**Bold:** <span class='akatab-B normal'> Ă ă Ĕ ĕ Ĭ ĭ ı Ŋ ŋ Ŏ ŏ Œ œ Š š Ŭ ŭ Ÿ Ž ž </span>

### Latin Extended-B:

Regular:<span class='akatab-R normal'> Ǝ ƒ Ɣ ǝ ȷ </span>

**Bold:** <span class='akatab-B normal'> Ǝ ƒ Ɣ ǝ ȷ </span>

### IPA Extensions:

Regular:<span class='akatab-R normal'> ə ɣ </span>

**Bold:** <span class='akatab-B normal'> ə ɣ </span>

### Spacing Modifier Letters:

Regular: <span class='akatab-R normal'> ˆ ˇ ː ˘ ˙ ˚ ˛ ˜ ˝</span>

**Bold:** <span class='akatab-B normal'> ˆ ˇ ː ˘ ˙ ˚ ˛ ˜ ˝</span>

### Combining Diacritical Marks:

Regular: <span class='akatab-R normal'> &#x25cc;&#x0300; &#x25cc;&#x0301; &#x25cc;&#x0302; &#x25cc;&#x0303; &#x25cc;&#x0304; &#x25cc;&#x0305; &#x25cc;&#x0306; &#x25cc;&#x0307; &#x25cc;&#x0308; &#x25cc;&#x030A; &#x25cc;&#x030B; &#x25cc;&#x030C; &#x25cc;&#x0323; &#x25cc;&#x0327; &#x25cc;&#x0328; </span>

**Bold:** <span class='akatab-B normal'> &#x25cc;&#x0300; &#x25cc;&#x0301; &#x25cc;&#x0302; &#x25cc;&#x0303; &#x25cc;&#x0304; &#x25cc;&#x0305; &#x25cc;&#x0306; &#x25cc;&#x0307; &#x25cc;&#x0308; &#x25cc;&#x030A; &#x25cc;&#x030B; &#x25cc;&#x030C; &#x25cc;&#x0323; &#x25cc;&#x0327; &#x25cc;&#x0328; </span>

### Greek and Coptic:

Regular: <span class='akatab-R normal'>&#x03C0;</span>

**Bold:** <span class='akatab-B normal'>&#x03C0;</span>

### Latin Extended Additional:

Regular: <span class='akatab-R normal'> Ḅ ḅ Ḍ ḍ Ḥ ḥ Ḳ ḳ Ḷ ḷ Ṃ ṃ Ṇ ṇ Ṛ ṛ Ṣ ṣ Ṭ ṭ Ẉ ẉ Ẓ ẓ Ỵ ỵ </span>

**Bold:** <span class='akatab-B normal'> Ḅ ḅ Ḍ ḍ Ḥ ḥ Ḳ ḳ Ḷ ḷ Ṃ ṃ Ṇ ṇ Ṛ ṛ Ṣ ṣ Ṭ ṭ Ẉ ẉ Ẓ ẓ Ỵ ỵ </span>

### General Punctuation, Supplemental Punctuation, Superscripts and Subscripts:

Regular: <span class='akatab-R normal'>&#x2010; &#x2011; &#x2012; &#x2013; &#x2014; &#x2015; &#x2018; &#x2019; &#x201A; &#x201C; &#x201D; &#x201E; &#x201F; &#x2020; &#x2021; &#x2022; &#x2026; &#x2030; &#x2039; &#x203A; &#x2044; &#x2074; </span>

**Bold:** <span class='akatab-B normal'>&#x2010; &#x2011; &#x2012; &#x2013; &#x2014; &#x2015; &#x2018; &#x2019; &#x201A; &#x201C; &#x201D; &#x201E; &#x2020; &#x2021; &#x2022; &#x2026; &#x2027; &#x2030; &#x2039; &#x203A; &#x2044; &#x2074; </span>

### Currency Symbols:

Regular: <span class='akatab-R normal'>&#x20AC;</span>

**Bold:** <span class='akatab-B normal'>&#x20AC;</span>

### Letterlike Symbols, Mathematical Operators, Control Pictures, Geometric Shapes, Miscellaneous Mathematical Symbols-B: 

Regular: <span class='akatab-R normal'> ™ Ω ∂ ∆ ∏ ∑ − ∕ ∙ √ ∞ ∫ ≈ ≠ ≤ ≥ ␣ ◊ ◌ </span>

**Bold:** <span class='akatab-B normal'> ™ Ω ∂ ∏ ∑ − ∕ ∙ √ ∞ ∫ ≈ ≠ ≤ ≥ ␣ ◊ ◌ </span>


<p> For a complete list of Unicode characters included in Akatab, see [Character Set Support](charset.md). </p>

SIL International is the creator of the Akatab fonts, and is the owner of all proprietary rights therein.

*Akatab* is a trademark of SIL International.
