//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmediaservices

// AudioAnalyzerPresetClassification provides polymorphic access to related types.
// Call the interface's GetAudioAnalyzerPreset() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioAnalyzerPreset, *VideoAnalyzerPreset
type AudioAnalyzerPresetClassification interface {
	PresetClassification
	// GetAudioAnalyzerPreset returns the AudioAnalyzerPreset content of the underlying type.
	GetAudioAnalyzerPreset() *AudioAnalyzerPreset
}

// AudioClassification provides polymorphic access to related types.
// Call the interface's GetAudio() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AacAudio, *Audio, *DDAudio
type AudioClassification interface {
	CodecClassification
	// GetAudio returns the Audio content of the underlying type.
	GetAudio() *Audio
}

// AudioTrackDescriptorClassification provides polymorphic access to related types.
// Call the interface's GetAudioTrackDescriptor() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioTrackDescriptor, *SelectAudioTrackByAttribute, *SelectAudioTrackByID
type AudioTrackDescriptorClassification interface {
	TrackDescriptorClassification
	// GetAudioTrackDescriptor returns the AudioTrackDescriptor content of the underlying type.
	GetAudioTrackDescriptor() *AudioTrackDescriptor
}

// ClipTimeClassification provides polymorphic access to related types.
// Call the interface's GetClipTime() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AbsoluteClipTime, *ClipTime, *UTCClipTime
type ClipTimeClassification interface {
	// GetClipTime returns the ClipTime content of the underlying type.
	GetClipTime() *ClipTime
}

// CodecClassification provides polymorphic access to related types.
// Call the interface's GetCodec() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AacAudio, *Audio, *Codec, *CopyAudio, *CopyVideo, *DDAudio, *H264Video, *H265Video, *Image, *JpgImage, *PNGImage, *Video
type CodecClassification interface {
	// GetCodec returns the Codec content of the underlying type.
	GetCodec() *Codec
}

// ContentKeyPolicyConfigurationClassification provides polymorphic access to related types.
// Call the interface's GetContentKeyPolicyConfiguration() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ContentKeyPolicyClearKeyConfiguration, *ContentKeyPolicyConfiguration, *ContentKeyPolicyFairPlayConfiguration, *ContentKeyPolicyPlayReadyConfiguration,
// - *ContentKeyPolicyUnknownConfiguration, *ContentKeyPolicyWidevineConfiguration
type ContentKeyPolicyConfigurationClassification interface {
	// GetContentKeyPolicyConfiguration returns the ContentKeyPolicyConfiguration content of the underlying type.
	GetContentKeyPolicyConfiguration() *ContentKeyPolicyConfiguration
}

// ContentKeyPolicyPlayReadyContentKeyLocationClassification provides polymorphic access to related types.
// Call the interface's GetContentKeyPolicyPlayReadyContentKeyLocation() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ContentKeyPolicyPlayReadyContentEncryptionKeyFromHeader, *ContentKeyPolicyPlayReadyContentEncryptionKeyFromKeyIdentifier,
// - *ContentKeyPolicyPlayReadyContentKeyLocation
type ContentKeyPolicyPlayReadyContentKeyLocationClassification interface {
	// GetContentKeyPolicyPlayReadyContentKeyLocation returns the ContentKeyPolicyPlayReadyContentKeyLocation content of the underlying type.
	GetContentKeyPolicyPlayReadyContentKeyLocation() *ContentKeyPolicyPlayReadyContentKeyLocation
}

// ContentKeyPolicyRestrictionClassification provides polymorphic access to related types.
// Call the interface's GetContentKeyPolicyRestriction() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ContentKeyPolicyOpenRestriction, *ContentKeyPolicyRestriction, *ContentKeyPolicyTokenRestriction, *ContentKeyPolicyUnknownRestriction
type ContentKeyPolicyRestrictionClassification interface {
	// GetContentKeyPolicyRestriction returns the ContentKeyPolicyRestriction content of the underlying type.
	GetContentKeyPolicyRestriction() *ContentKeyPolicyRestriction
}

// ContentKeyPolicyRestrictionTokenKeyClassification provides polymorphic access to related types.
// Call the interface's GetContentKeyPolicyRestrictionTokenKey() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ContentKeyPolicyRestrictionTokenKey, *ContentKeyPolicyRsaTokenKey, *ContentKeyPolicySymmetricTokenKey, *ContentKeyPolicyX509CertificateTokenKey
type ContentKeyPolicyRestrictionTokenKeyClassification interface {
	// GetContentKeyPolicyRestrictionTokenKey returns the ContentKeyPolicyRestrictionTokenKey content of the underlying type.
	GetContentKeyPolicyRestrictionTokenKey() *ContentKeyPolicyRestrictionTokenKey
}

// FormatClassification provides polymorphic access to related types.
// Call the interface's GetFormat() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Format, *ImageFormat, *JpgFormat, *Mp4Format, *MultiBitrateFormat, *PNGFormat, *TransportStreamFormat
type FormatClassification interface {
	// GetFormat returns the Format content of the underlying type.
	GetFormat() *Format
}

// ImageClassification provides polymorphic access to related types.
// Call the interface's GetImage() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Image, *JpgImage, *PNGImage
type ImageClassification interface {
	VideoClassification
	// GetImage returns the Image content of the underlying type.
	GetImage() *Image
}

// ImageFormatClassification provides polymorphic access to related types.
// Call the interface's GetImageFormat() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ImageFormat, *JpgFormat, *PNGFormat
type ImageFormatClassification interface {
	FormatClassification
	// GetImageFormat returns the ImageFormat content of the underlying type.
	GetImageFormat() *ImageFormat
}

// InputDefinitionClassification provides polymorphic access to related types.
// Call the interface's GetInputDefinition() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *FromAllInputFile, *FromEachInputFile, *InputDefinition, *InputFile
type InputDefinitionClassification interface {
	// GetInputDefinition returns the InputDefinition content of the underlying type.
	GetInputDefinition() *InputDefinition
}

// JobInputClassification provides polymorphic access to related types.
// Call the interface's GetJobInput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *JobInput, *JobInputAsset, *JobInputClip, *JobInputHTTP, *JobInputSequence, *JobInputs
type JobInputClassification interface {
	// GetJobInput returns the JobInput content of the underlying type.
	GetJobInput() *JobInput
}

// JobInputClipClassification provides polymorphic access to related types.
// Call the interface's GetJobInputClip() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *JobInputAsset, *JobInputClip, *JobInputHTTP
type JobInputClipClassification interface {
	JobInputClassification
	// GetJobInputClip returns the JobInputClip content of the underlying type.
	GetJobInputClip() *JobInputClip
}

// JobOutputClassification provides polymorphic access to related types.
// Call the interface's GetJobOutput() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *JobOutput, *JobOutputAsset
type JobOutputClassification interface {
	// GetJobOutput returns the JobOutput content of the underlying type.
	GetJobOutput() *JobOutput
}

// MultiBitrateFormatClassification provides polymorphic access to related types.
// Call the interface's GetMultiBitrateFormat() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *Mp4Format, *MultiBitrateFormat, *TransportStreamFormat
type MultiBitrateFormatClassification interface {
	FormatClassification
	// GetMultiBitrateFormat returns the MultiBitrateFormat content of the underlying type.
	GetMultiBitrateFormat() *MultiBitrateFormat
}

// OverlayClassification provides polymorphic access to related types.
// Call the interface's GetOverlay() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioOverlay, *Overlay, *VideoOverlay
type OverlayClassification interface {
	// GetOverlay returns the Overlay content of the underlying type.
	GetOverlay() *Overlay
}

// PresetClassification provides polymorphic access to related types.
// Call the interface's GetPreset() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioAnalyzerPreset, *BuiltInStandardEncoderPreset, *FaceDetectorPreset, *Preset, *StandardEncoderPreset, *VideoAnalyzerPreset
type PresetClassification interface {
	// GetPreset returns the Preset content of the underlying type.
	GetPreset() *Preset
}

// TrackBaseClassification provides polymorphic access to related types.
// Call the interface's GetTrackBase() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioTrack, *TextTrack, *TrackBase, *VideoTrack
type TrackBaseClassification interface {
	// GetTrackBase returns the TrackBase content of the underlying type.
	GetTrackBase() *TrackBase
}

// TrackDescriptorClassification provides polymorphic access to related types.
// Call the interface's GetTrackDescriptor() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *AudioTrackDescriptor, *SelectAudioTrackByAttribute, *SelectAudioTrackByID, *SelectVideoTrackByAttribute, *SelectVideoTrackByID,
// - *TrackDescriptor, *VideoTrackDescriptor
type TrackDescriptorClassification interface {
	// GetTrackDescriptor returns the TrackDescriptor content of the underlying type.
	GetTrackDescriptor() *TrackDescriptor
}

// VideoClassification provides polymorphic access to related types.
// Call the interface's GetVideo() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *H264Video, *H265Video, *Image, *JpgImage, *PNGImage, *Video
type VideoClassification interface {
	CodecClassification
	// GetVideo returns the Video content of the underlying type.
	GetVideo() *Video
}

// VideoTrackDescriptorClassification provides polymorphic access to related types.
// Call the interface's GetVideoTrackDescriptor() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *SelectVideoTrackByAttribute, *SelectVideoTrackByID, *VideoTrackDescriptor
type VideoTrackDescriptorClassification interface {
	TrackDescriptorClassification
	// GetVideoTrackDescriptor returns the VideoTrackDescriptor content of the underlying type.
	GetVideoTrackDescriptor() *VideoTrackDescriptor
}
