//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/networkcloud/armnetworkcloud"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// BareMetalMachinesServer is a fake server for instances of the armnetworkcloud.BareMetalMachinesClient type.
type BareMetalMachinesServer struct {
	// BeginCordon is the fake for method BareMetalMachinesClient.BeginCordon
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginCordon func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, options *armnetworkcloud.BareMetalMachinesClientBeginCordonOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientCordonResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method BareMetalMachinesClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, bareMetalMachineParameters armnetworkcloud.BareMetalMachine, options *armnetworkcloud.BareMetalMachinesClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method BareMetalMachinesClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, options *armnetworkcloud.BareMetalMachinesClientBeginDeleteOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method BareMetalMachinesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, options *armnetworkcloud.BareMetalMachinesClientGetOptions) (resp azfake.Responder[armnetworkcloud.BareMetalMachinesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method BareMetalMachinesClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armnetworkcloud.BareMetalMachinesClientListByResourceGroupOptions) (resp azfake.PagerResponder[armnetworkcloud.BareMetalMachinesClientListByResourceGroupResponse])

	// NewListBySubscriptionPager is the fake for method BareMetalMachinesClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armnetworkcloud.BareMetalMachinesClientListBySubscriptionOptions) (resp azfake.PagerResponder[armnetworkcloud.BareMetalMachinesClientListBySubscriptionResponse])

	// BeginPowerOff is the fake for method BareMetalMachinesClient.BeginPowerOff
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginPowerOff func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, options *armnetworkcloud.BareMetalMachinesClientBeginPowerOffOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientPowerOffResponse], errResp azfake.ErrorResponder)

	// BeginReimage is the fake for method BareMetalMachinesClient.BeginReimage
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginReimage func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, options *armnetworkcloud.BareMetalMachinesClientBeginReimageOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientReimageResponse], errResp azfake.ErrorResponder)

	// BeginReplace is the fake for method BareMetalMachinesClient.BeginReplace
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginReplace func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, options *armnetworkcloud.BareMetalMachinesClientBeginReplaceOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientReplaceResponse], errResp azfake.ErrorResponder)

	// BeginRestart is the fake for method BareMetalMachinesClient.BeginRestart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginRestart func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, options *armnetworkcloud.BareMetalMachinesClientBeginRestartOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRestartResponse], errResp azfake.ErrorResponder)

	// BeginRunCommand is the fake for method BareMetalMachinesClient.BeginRunCommand
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginRunCommand func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, bareMetalMachineRunCommandParameters armnetworkcloud.BareMetalMachineRunCommandParameters, options *armnetworkcloud.BareMetalMachinesClientBeginRunCommandOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRunCommandResponse], errResp azfake.ErrorResponder)

	// BeginRunDataExtracts is the fake for method BareMetalMachinesClient.BeginRunDataExtracts
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginRunDataExtracts func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, bareMetalMachineRunDataExtractsParameters armnetworkcloud.BareMetalMachineRunDataExtractsParameters, options *armnetworkcloud.BareMetalMachinesClientBeginRunDataExtractsOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRunDataExtractsResponse], errResp azfake.ErrorResponder)

	// BeginRunReadCommands is the fake for method BareMetalMachinesClient.BeginRunReadCommands
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginRunReadCommands func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, bareMetalMachineRunReadCommandsParameters armnetworkcloud.BareMetalMachineRunReadCommandsParameters, options *armnetworkcloud.BareMetalMachinesClientBeginRunReadCommandsOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRunReadCommandsResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method BareMetalMachinesClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginStart func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, options *armnetworkcloud.BareMetalMachinesClientBeginStartOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientStartResponse], errResp azfake.ErrorResponder)

	// BeginUncordon is the fake for method BareMetalMachinesClient.BeginUncordon
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginUncordon func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, options *armnetworkcloud.BareMetalMachinesClientBeginUncordonOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientUncordonResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method BareMetalMachinesClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, bareMetalMachineName string, bareMetalMachineUpdateParameters armnetworkcloud.BareMetalMachinePatchParameters, options *armnetworkcloud.BareMetalMachinesClientBeginUpdateOptions) (resp azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewBareMetalMachinesServerTransport creates a new instance of BareMetalMachinesServerTransport with the provided implementation.
// The returned BareMetalMachinesServerTransport instance is connected to an instance of armnetworkcloud.BareMetalMachinesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBareMetalMachinesServerTransport(srv *BareMetalMachinesServer) *BareMetalMachinesServerTransport {
	return &BareMetalMachinesServerTransport{
		srv:                         srv,
		beginCordon:                 newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientCordonResponse]](),
		beginCreateOrUpdate:         newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientCreateOrUpdateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientDeleteResponse]](),
		newListByResourceGroupPager: newTracker[azfake.PagerResponder[armnetworkcloud.BareMetalMachinesClientListByResourceGroupResponse]](),
		newListBySubscriptionPager:  newTracker[azfake.PagerResponder[armnetworkcloud.BareMetalMachinesClientListBySubscriptionResponse]](),
		beginPowerOff:               newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientPowerOffResponse]](),
		beginReimage:                newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientReimageResponse]](),
		beginReplace:                newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientReplaceResponse]](),
		beginRestart:                newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRestartResponse]](),
		beginRunCommand:             newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRunCommandResponse]](),
		beginRunDataExtracts:        newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRunDataExtractsResponse]](),
		beginRunReadCommands:        newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRunReadCommandsResponse]](),
		beginStart:                  newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientStartResponse]](),
		beginUncordon:               newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientUncordonResponse]](),
		beginUpdate:                 newTracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientUpdateResponse]](),
	}
}

// BareMetalMachinesServerTransport connects instances of armnetworkcloud.BareMetalMachinesClient to instances of BareMetalMachinesServer.
// Don't use this type directly, use NewBareMetalMachinesServerTransport instead.
type BareMetalMachinesServerTransport struct {
	srv                         *BareMetalMachinesServer
	beginCordon                 *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientCordonResponse]]
	beginCreateOrUpdate         *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientCreateOrUpdateResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientDeleteResponse]]
	newListByResourceGroupPager *tracker[azfake.PagerResponder[armnetworkcloud.BareMetalMachinesClientListByResourceGroupResponse]]
	newListBySubscriptionPager  *tracker[azfake.PagerResponder[armnetworkcloud.BareMetalMachinesClientListBySubscriptionResponse]]
	beginPowerOff               *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientPowerOffResponse]]
	beginReimage                *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientReimageResponse]]
	beginReplace                *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientReplaceResponse]]
	beginRestart                *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRestartResponse]]
	beginRunCommand             *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRunCommandResponse]]
	beginRunDataExtracts        *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRunDataExtractsResponse]]
	beginRunReadCommands        *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientRunReadCommandsResponse]]
	beginStart                  *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientStartResponse]]
	beginUncordon               *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientUncordonResponse]]
	beginUpdate                 *tracker[azfake.PollerResponder[armnetworkcloud.BareMetalMachinesClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for BareMetalMachinesServerTransport.
func (b *BareMetalMachinesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "BareMetalMachinesClient.BeginCordon":
		resp, err = b.dispatchBeginCordon(req)
	case "BareMetalMachinesClient.BeginCreateOrUpdate":
		resp, err = b.dispatchBeginCreateOrUpdate(req)
	case "BareMetalMachinesClient.BeginDelete":
		resp, err = b.dispatchBeginDelete(req)
	case "BareMetalMachinesClient.Get":
		resp, err = b.dispatchGet(req)
	case "BareMetalMachinesClient.NewListByResourceGroupPager":
		resp, err = b.dispatchNewListByResourceGroupPager(req)
	case "BareMetalMachinesClient.NewListBySubscriptionPager":
		resp, err = b.dispatchNewListBySubscriptionPager(req)
	case "BareMetalMachinesClient.BeginPowerOff":
		resp, err = b.dispatchBeginPowerOff(req)
	case "BareMetalMachinesClient.BeginReimage":
		resp, err = b.dispatchBeginReimage(req)
	case "BareMetalMachinesClient.BeginReplace":
		resp, err = b.dispatchBeginReplace(req)
	case "BareMetalMachinesClient.BeginRestart":
		resp, err = b.dispatchBeginRestart(req)
	case "BareMetalMachinesClient.BeginRunCommand":
		resp, err = b.dispatchBeginRunCommand(req)
	case "BareMetalMachinesClient.BeginRunDataExtracts":
		resp, err = b.dispatchBeginRunDataExtracts(req)
	case "BareMetalMachinesClient.BeginRunReadCommands":
		resp, err = b.dispatchBeginRunReadCommands(req)
	case "BareMetalMachinesClient.BeginStart":
		resp, err = b.dispatchBeginStart(req)
	case "BareMetalMachinesClient.BeginUncordon":
		resp, err = b.dispatchBeginUncordon(req)
	case "BareMetalMachinesClient.BeginUpdate":
		resp, err = b.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginCordon(req *http.Request) (*http.Response, error) {
	if b.srv.BeginCordon == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCordon not implemented")}
	}
	beginCordon := b.beginCordon.get(req)
	if beginCordon == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cordon`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkcloud.BareMetalMachineCordonParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		var options *armnetworkcloud.BareMetalMachinesClientBeginCordonOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armnetworkcloud.BareMetalMachinesClientBeginCordonOptions{
				BareMetalMachineCordonParameters: &body,
			}
		}
		respr, errRespr := b.srv.BeginCordon(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCordon = &respr
		b.beginCordon.add(req, beginCordon)
	}

	resp, err := server.PollerResponderNext(beginCordon, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginCordon.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCordon) {
		b.beginCordon.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if b.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := b.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkcloud.BareMetalMachine](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		b.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		b.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		b.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if b.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := b.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginDelete(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		b.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		b.beginDelete.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if b.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.Get(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BareMetalMachine, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := b.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := b.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		b.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armnetworkcloud.BareMetalMachinesClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		b.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := b.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := b.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		b.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armnetworkcloud.BareMetalMachinesClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		b.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginPowerOff(req *http.Request) (*http.Response, error) {
	if b.srv.BeginPowerOff == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginPowerOff not implemented")}
	}
	beginPowerOff := b.beginPowerOff.get(req)
	if beginPowerOff == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/powerOff`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkcloud.BareMetalMachinePowerOffParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		var options *armnetworkcloud.BareMetalMachinesClientBeginPowerOffOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armnetworkcloud.BareMetalMachinesClientBeginPowerOffOptions{
				BareMetalMachinePowerOffParameters: &body,
			}
		}
		respr, errRespr := b.srv.BeginPowerOff(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginPowerOff = &respr
		b.beginPowerOff.add(req, beginPowerOff)
	}

	resp, err := server.PollerResponderNext(beginPowerOff, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginPowerOff.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginPowerOff) {
		b.beginPowerOff.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginReimage(req *http.Request) (*http.Response, error) {
	if b.srv.BeginReimage == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReimage not implemented")}
	}
	beginReimage := b.beginReimage.get(req)
	if beginReimage == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/reimage`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginReimage(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReimage = &respr
		b.beginReimage.add(req, beginReimage)
	}

	resp, err := server.PollerResponderNext(beginReimage, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginReimage.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReimage) {
		b.beginReimage.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginReplace(req *http.Request) (*http.Response, error) {
	if b.srv.BeginReplace == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginReplace not implemented")}
	}
	beginReplace := b.beginReplace.get(req)
	if beginReplace == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/replace`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkcloud.BareMetalMachineReplaceParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		var options *armnetworkcloud.BareMetalMachinesClientBeginReplaceOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armnetworkcloud.BareMetalMachinesClientBeginReplaceOptions{
				BareMetalMachineReplaceParameters: &body,
			}
		}
		respr, errRespr := b.srv.BeginReplace(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginReplace = &respr
		b.beginReplace.add(req, beginReplace)
	}

	resp, err := server.PollerResponderNext(beginReplace, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginReplace.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginReplace) {
		b.beginReplace.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginRestart(req *http.Request) (*http.Response, error) {
	if b.srv.BeginRestart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestart not implemented")}
	}
	beginRestart := b.beginRestart.get(req)
	if beginRestart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restart`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginRestart(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestart = &respr
		b.beginRestart.add(req, beginRestart)
	}

	resp, err := server.PollerResponderNext(beginRestart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginRestart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestart) {
		b.beginRestart.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginRunCommand(req *http.Request) (*http.Response, error) {
	if b.srv.BeginRunCommand == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRunCommand not implemented")}
	}
	beginRunCommand := b.beginRunCommand.get(req)
	if beginRunCommand == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runCommand`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkcloud.BareMetalMachineRunCommandParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginRunCommand(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRunCommand = &respr
		b.beginRunCommand.add(req, beginRunCommand)
	}

	resp, err := server.PollerResponderNext(beginRunCommand, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginRunCommand.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRunCommand) {
		b.beginRunCommand.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginRunDataExtracts(req *http.Request) (*http.Response, error) {
	if b.srv.BeginRunDataExtracts == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRunDataExtracts not implemented")}
	}
	beginRunDataExtracts := b.beginRunDataExtracts.get(req)
	if beginRunDataExtracts == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runDataExtracts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkcloud.BareMetalMachineRunDataExtractsParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginRunDataExtracts(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRunDataExtracts = &respr
		b.beginRunDataExtracts.add(req, beginRunDataExtracts)
	}

	resp, err := server.PollerResponderNext(beginRunDataExtracts, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginRunDataExtracts.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRunDataExtracts) {
		b.beginRunDataExtracts.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginRunReadCommands(req *http.Request) (*http.Response, error) {
	if b.srv.BeginRunReadCommands == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRunReadCommands not implemented")}
	}
	beginRunReadCommands := b.beginRunReadCommands.get(req)
	if beginRunReadCommands == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/runReadCommands`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkcloud.BareMetalMachineRunReadCommandsParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginRunReadCommands(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRunReadCommands = &respr
		b.beginRunReadCommands.add(req, beginRunReadCommands)
	}

	resp, err := server.PollerResponderNext(beginRunReadCommands, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginRunReadCommands.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRunReadCommands) {
		b.beginRunReadCommands.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if b.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := b.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginStart(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		b.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		b.beginStart.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginUncordon(req *http.Request) (*http.Response, error) {
	if b.srv.BeginUncordon == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUncordon not implemented")}
	}
	beginUncordon := b.beginUncordon.get(req)
	if beginUncordon == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/uncordon`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginUncordon(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUncordon = &respr
		b.beginUncordon.add(req, beginUncordon)
	}

	resp, err := server.PollerResponderNext(beginUncordon, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		b.beginUncordon.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUncordon) {
		b.beginUncordon.remove(req)
	}

	return resp, nil
}

func (b *BareMetalMachinesServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if b.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := b.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.NetworkCloud/bareMetalMachines/(?P<bareMetalMachineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armnetworkcloud.BareMetalMachinePatchParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		bareMetalMachineNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("bareMetalMachineName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := b.srv.BeginUpdate(req.Context(), resourceGroupNameParam, bareMetalMachineNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		b.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		b.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		b.beginUpdate.remove(req)
	}

	return resp, nil
}
